<?php

namespace Qcloud\Cos\Tests;

use Qcloud\Cos\Client;

class TestHelper {

    public static function nuke($bucket) {
        try {
            $cosClient = new Client(['region' => getenv('COS_REGION'),
                        'credentials'=> [
                        'appId' => getenv('COS_APPID'),
                        'secretId'    => getenv('COS_KEY'),
                        'secretKey' => getenv('COS_SECRET')]]);
            $result = $cosClient->listObjects(['Bucket' => $bucket]);
            if (isset($result['Contents'])) {
                foreach ($result['Contents'] as $content) {
                    $cosClient->deleteObject(['Bucket' => $bucket, 'Key' => $content['Key']]);
                }
            }

            while(True){
                $result = $cosClient->ListMultipartUploads(
                    ['Bucket' => $bucket]);
                if (count($result['Uploads']) == 0){
                    break;
                }
                foreach ($result['Uploads'] as $upload) {
                    try {
                        $rt = $cosClient->AbortMultipartUpload(
                            ['Bucket' => $bucket,
                                'Key' => $upload['Key'],
                                'UploadId' => $upload['UploadId']]);
                    } catch (\Exception $e) {
                        print_r($e);
                    }
                }
            }        
            $cosClient->deleteBucket(['Bucket' => $bucket]);
        } catch (\Exception $e) {
            // echo "$e\n";
        }
    }
}
