<?php
/* @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @link        http://www.dzzoffice.com
 * @author      zyx(zyx@dzz.cc)
 */
if (!defined('IN_DZZ')) {
    exit('Access Denied');
}
$uid = $_G['uid'];
if (isset($_GET['requestfile']) && $_GET['requestfile']) {
    $positions = [];
    $explorer_setting = get_resources_some_setting();
    $orgs = $groups = $groupinfo = [];
    if ($explorer_setting['orgonperm']) {
        $orgs = C::t('organization')->fetch_all_orggroup($uid);//机构群组
    }

    if ($explorer_setting['grouponperm']) {
        $groupinfo = C::t('organization')->fetch_group_by_uid($uid, true);//个人群组
    }

    if ($explorer_setting['useronperm']) {
        $homefid = C::t('folder')->fetch_fid_by_flag('home');
        $positions[] = ['pname' => '我的网盘', 'pfid' => $homefid];
    }
    if ($orgs['org']) {
        $groups = array_merge($orgs['org'], $groupinfo);
    }
    
    foreach ($groups as $v) {
        if ($v['type'] == 1) {
            $positions[] = ['pname' => $v['orgname'], 'pfid' => $v['fid'], 'type' => '群组'];
        } else {
            $positions[] = ['pname' => $v['orgname'], 'pfid' => $v['fid'], 'type' => '机构'];
        }

    }
    exit(json_encode($positions));
} elseif ($_GET['do'] == 'getuser') {
    $term = trim($_GET['q']);
    $page = empty($_GET['page']) ? 1 : intval($_GET['page']);
    $perpage = 30;
    $start = ($page - 1) * $perpage;
    $uids = [];
    $param_user = ['user', 'user_status'];
    $sql_user = "where u.status<1 ";

    if ($term) {
        $sql_user .= " and u.username LIKE %s";
        $param_user[] = '%' . $term . '%';
    }
    $data = [];

    if ($count = DB::result_first("select COUNT(DISTINCT u.uid) from %t u  LEFT JOIN %t s on u.uid=s.uid   $sql_user", $param_user)) {
        foreach (DB::fetch_all("select DISTINCT u.uid,u.username  from %t u LEFT JOIN %t s on u.uid=s.uid  $sql_user order by s.lastactivity DESC limit $start,$perpage", $param_user) as $value) {
            $data[] = ['id' => $value['uid'],
                'text' => $value['username']
            ];
        }
    }
    exit(json_encode(['total_count' => $count + ($extra ? 1 : 0), 'items' => $data]));

}

