<?php
if (!defined('IN_DZZ')) {
    exit('Access Denied');
}
global $_G;
Hook::listen('check_login');//检查是否登录，未登录跳转到登录界面
$uid = $_G['uid'];
if (!C::t('folder')->check_home_by_uid($uid)) {
    C::t('folder')->fetch_home_by_uid($uid);
}
$id = isset($_GET['id']) ? $_GET['id'] : '';
$operation = $_GET['operation'] ?: '';
$range = isset($_GET['range']) ? trim($_GET['range']) : '';//指定范围
$data = [];
if ($operation == 'get_children') {
    if ($id == 'group') {
        $groupinfo = C::t('organization')->fetch_group_by_uid($uid, true);
        foreach ($groupinfo as $v) {
            $children = (C::t('resources')->fetch_folder_num_by_pfid($v['fid']) > 0) ? true : false;
            $arr = [
                'id' => 'g_' . $v['orgid'],
                'type' => 'group',
                'children' => $children,
                'li_attr' => ['hashs' => 'group&gid=' . $v['orgid']]
            ];
            if (intval($v['aid']) == 0) {
                $arr['text'] = avatar_group($v['orgid'], [$v['orgid'] => ['aid' => $v['aid'], 'orgname' => $v['orgname']]]) . $v['orgname'];
                $arr['icon'] = false;
            } else {
                $arr['text'] = $v['orgname'];
                $arr['icon'] = 'index.php?mod=io&op=thumbnail&width=24&height=24&path=' . dzzencode('attach::' . $v['aid']);
            }

            $data[] = $arr;
        }
        exit(json_encode($data));
    } elseif (preg_match('/g_\d+/', $id)) {
        $gid = intval(str_replace('g_', '', $id));
        $groupinfo = C::t('organization')->fetch($gid);
        if ($groupinfo && ($groupinfo['diron'] == 1 || C::t('organization_admin')->chk_memberperm($gid, $uid))) {
            foreach (C::t('folder')->fetch_folder_by_pfid($groupinfo['fid'], ['fname', 'fid']) as $val) {
                $children = (C::t('resources')->fetch_folder_num_by_pfid($val['fid']) > 0) ? true : false;
                $data[] = [
                    'id' => 'f_' . $val['fid'],
                    'text' => $val['fname'],
                    'type' => 'folder',
                    'children' => $children,
                    'li_attr' => [
                        'hashs' => 'group&do=file&gid=' . $groupinfo['orgid'] . '&fid=' . $val['fid']]
                ];
            }
        }
        exit(json_encode($data));
    } elseif (preg_match('/gid_\d+/', $id)) {
        $gid = intval(str_replace('gid_', '', $id));
        $orginfo = C::t('organization')->fetch($gid);
        if ($orginfo && ($orginfo['diron'] == 1 || C::t('organization_admin')->chk_memberperm($gid, $uid))) {
            foreach (C::t('folder')->fetch_folder_by_pfid($orginfo['fid'], ['fname', 'fid']) as $val) {
                $children = (C::t('resources')->fetch_folder_num_by_pfid($val['fid']) > 0) ? true : false;
                $arr = [
                    'id' => 'f_' . $val['fid'],
                    'text' => $val['fname'],
                    'type' => 'folder',
                    'children' => $children,
                    'li_attr' => [
                        'href' => DZZSCRIPT . '?mod=' . MOD_NAME . '&op=group',
                        'hashs' => 'group&do=file&gid=' . $orginfo['orgid'] . '&fid=' . $val['fid']
                    ]
                ];
                $data[] = $arr;
            }
        }

        $groupinfo = C::t('organization')->fetch_org_by_uidorgid($uid, $gid);

        if ($groupinfo) {
            foreach ($groupinfo as $val) {
                if (count(C::t('organization')->fetch_org_by_uidorgid($uid, $val['orgid'])) > 0 || C::t('resources')->fetch_folder_num_by_pfid($val['fid']) > 0) {
                    $children = true;
                } else {
                    $children = false;
                }
                $arr = [
                    'id' => 'gid_' . $val['orgid'],
                    'type' => 'department',
                    'children' => $children,
                    'li_attr' => ['hashs' => 'group&gid=' . $val['orgid'], 'args' => 'gid_' . $val['orgid']]
                ];
                if (intval($val['aid']) == 0) {
                    $arr['text'] = avatar_group($val['orgid'], [$val['orgid'] => ['aid' => $val['aid'], 'orgname' => $val['orgname']]]) . $val['orgname'];
                    $arr['icon'] = false;
                } else {
                    $arr['text'] = $val['orgname'];
                    $arr['icon'] = 'index.php?mod=io&op=thumbnail&width=24&height=24&path=' . dzzencode('attach::' . $val['aid']);
                }
                $data[] = $arr;
            }
        }
        exit(json_encode($data));
    } elseif (preg_match('/f_\d+/', $id)) {
        $fid = intval(str_replace('f_', '', $id));
        foreach (C::t('folder')->fetch_folder_by_pfid($fid, ['fname', 'fid', 'gid']) as $val) {
            $children = (C::t('resources')->fetch_folder_num_by_pfid($val['fid']) > 0) ? true : false;
            $data[] = [
                'id' => 'f_' . $val['fid'],
                'text' => $val['fname'],
                'type' => 'folder',
                'children' => $children,
                'li_attr' => [
                    'href' => DZZSCRIPT . '?mod=' . MOD_NAME . '&op=group',
                    'hashs' => 'group&do=file&gid=' . $val['gid'] . '&fid=' . $val['fid']]
            ];
        }
        exit(json_encode($data));
    } elseif (preg_match('/u_\d+/', $id)) {
        $fid = intval(str_replace('u_', '', $id));
        foreach (C::t('folder')->fetch_folder_by_pfid($fid, ['fname', 'fid']) as $v) {
            $children = (C::t('resources')->fetch_folder_num_by_pfid($v['fid']) > 0) ? true : false;
            $data[] = [
                'id' => 'u_' . $v['fid'],
                'text' => $v['fname'],
                'type' => 'folder',
                'children' => $children,
                'li_attr' => [
                    'hashs' => 'home&do=file&fid=' . $v['fid']
                ]
            ];
        }
        exit(json_encode($data));
    } else {
        $explorer_setting = get_resources_some_setting();
        $selrangearr = [];
        if ($range) {
            $selrangearr = explode(',', $range);
        }
        $rangeval = (count($selrangearr) > 0) ? true : false;
        if ($explorer_setting['useronperm'] && (!$rangeval || ($rangeval && in_array('home', $selrangearr)))) {
            $folders = C::t('folder')->fetch_home_by_uid();
            $fid = $folders['fid'];
            $children = (C::t('resources')->fetch_folder_num_by_pfid($fid) > 0) ? true : false;
            $data[] = [
                'id' => 'u_' . $fid,
                'text' => lang('explorer_user_root_dirname'),
                'type' => 'home',
                'children' => $children,
                'li_attr' => ['hashs' => "home&fid=$fid", 'flag' => 'home']
            ];
        }
        if ($explorer_setting['orgonperm'] && (!$rangeval || ($rangeval && in_array('org', $selrangearr)))) {
            $orgs = C::t('organization')->fetch_all_orggroup($uid);
            foreach ($orgs['org'] as $v) {
                if (count(C::t('organization')->fetch_org_by_uidorgid($uid, $v['orgid'])) > 0 || C::t('resources')->fetch_folder_num_by_pfid($v['fid']) > 0) {
                    $children = true;
                } else {
                    $children = false;
                }
                if (!empty($v)) {
                    $arr = [
                        'id' => 'gid_' . $v['orgid'],
                        'type' => ($v['pfid'] > 0 ? 'department' : 'organization'),
                        'children' => $children,
                        'li_attr' => ['hashs' => 'group&gid=' . $v['orgid'], 'args' => 'gid_' . $v['orgid']]
                    ];
                    if (intval($v['aid']) == 0) {
                        $arr['text'] = avatar_group($v['orgid'], [$v['orgid'] => ['aid' => $v['aid'], 'orgname' => $v['orgname']]]) . $v['orgname'];
                        $arr['icon'] = false;
                    } else {
                        $arr['text'] = $v['orgname'];
                        $arr['icon'] = 'index.php?mod=io&op=thumbnail&width=24&height=24&path=' . dzzencode('attach::' . $v['aid']);
                    }
                    $data[] = $arr;
                }
            }
        }
        if ($explorer_setting['grouponperm'] && (!$rangeval || ($rangeval && in_array('group', $selrangearr)))) {
            $groups = C::t('organization')->fetch_group_by_uid($uid, true);
            $children = (count($groups) > 0) ? true : false;
            $data[] = [
                'id' => 'group',
                'text' => '群组',
                'type' => 'group',
                'children' => $children,
                'li_attr' => ['hashs' => '']
            ];
        }
    }
    exit(json_encode($data));
} elseif ($operation == 'getParentsArr') {//获取
    $fid = intval($_GET['fid']);
    $gid = intval($_GET['gid']);
    $ret = [];
    if ($fid) {
        $subfix = '';
        $org = [];
        foreach (C::t('folder')->fetch_all_parent_by_fid($fid) as $value) {
            if (empty($subfix)) {
                if ($value['gid']) {//是部门或者群组
                    $org = C::t('organization')->fetch($value['gid']);
                    if ($org['type'] == 0) {
                        $subfix = 'gid_';
                    } elseif ($org['type'] == 1) {
                        $subfix = 'g_';
                    }
                } else {
                    $subfix = 'u_';
                }
            }
            if ($value['gid'] < 1) {
                $arr[] = 'u_' . $value['fid'];
            } elseif ($value['flag'] == 'organization') {
                $arr[] = $subfix . $value['gid'];
            } else {
                $arr[] = 'f_' . $value['fid'];
            }
        }
        if ($subfix == 'g_') {//群组的话，需要增加顶级"群组"
            $arr[] = 'group';
        }
        $arr = array_reverse($arr);
    } elseif ($gid) {
        $subfix = '';
        foreach (C::t('organization')->fetch_parent_by_orgid($gid) as $orgid) {
            if (empty($subfix)) {
                $org = C::t('organization')->fetch($orgid);
                if ($org['type'] == 0) {
                    $subfix = 'gid_';
                } elseif ($org['type'] == 1) {
                    $subfix = 'g_';
                }
            }
            $arr[] = $subfix . $orgid;

        }
        if ($subfix == 'g_') array_unshift($arr, 'group');
    }
    $arr = array_unique($arr);
    exit(json_encode($arr));
}

