/* SPDX-License-Identifier: GPL-2.0 WITH Linux-syscall-note */
/*
 *
 * (C) COPYRIGHT 2018-2022 ARM Limited. All rights reserved.
 *
 * This program is free software and is provided to you under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation, and any use by you of this program is subject to the terms
 * of such GNU license.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can access it online at
 * http://www.gnu.org/licenses/gpl-2.0.html.
 *
 */

/*
 * This header was originally autogenerated, but it is now ok (and
 * expected) to have to add to it.
 */

#ifndef _KBASE_CSF_REGISTERS_H_
#define _KBASE_CSF_REGISTERS_H_

/*
 * Begin register sets
 */

/* DOORBELLS base address */
#define DOORBELLS_BASE 0x0080000
#define DOORBELLS_REG(r) (DOORBELLS_BASE + (r))

/* CS_KERNEL_INPUT_BLOCK base address */
#define CS_KERNEL_INPUT_BLOCK_BASE 0x0000
#define CS_KERNEL_INPUT_BLOCK_REG(r) (CS_KERNEL_INPUT_BLOCK_BASE + (r))

/* CS_KERNEL_OUTPUT_BLOCK base address */
#define CS_KERNEL_OUTPUT_BLOCK_BASE 0x0000
#define CS_KERNEL_OUTPUT_BLOCK_REG(r) (CS_KERNEL_OUTPUT_BLOCK_BASE + (r))

/* CS_USER_INPUT_BLOCK base address */
#define CS_USER_INPUT_BLOCK_BASE 0x0000
#define CS_USER_INPUT_BLOCK_REG(r) (CS_USER_INPUT_BLOCK_BASE + (r))

/* CS_USER_OUTPUT_BLOCK base address */
#define CS_USER_OUTPUT_BLOCK_BASE 0x0000
#define CS_USER_OUTPUT_BLOCK_REG(r) (CS_USER_OUTPUT_BLOCK_BASE + (r))

/* CSG_INPUT_BLOCK base address */
#define CSG_INPUT_BLOCK_BASE 0x0000
#define CSG_INPUT_BLOCK_REG(r) (CSG_INPUT_BLOCK_BASE + (r))

/* CSG_OUTPUT_BLOCK base address */
#define CSG_OUTPUT_BLOCK_BASE 0x0000
#define CSG_OUTPUT_BLOCK_REG(r) (CSG_OUTPUT_BLOCK_BASE + (r))

/* GLB_CONTROL_BLOCK base address */
#define GLB_CONTROL_BLOCK_BASE 0x04000000
#define GLB_CONTROL_BLOCK_REG(r) (GLB_CONTROL_BLOCK_BASE + (r))

/* GLB_INPUT_BLOCK base address */
#define GLB_INPUT_BLOCK_BASE 0x0000
#define GLB_INPUT_BLOCK_REG(r) (GLB_INPUT_BLOCK_BASE + (r))

/* GLB_OUTPUT_BLOCK base address */
#define GLB_OUTPUT_BLOCK_BASE 0x0000
#define GLB_OUTPUT_BLOCK_REG(r) (GLB_OUTPUT_BLOCK_BASE + (r))

/* USER base address */
#define USER_BASE 0x0010000
#define USER_REG(r) (USER_BASE + (r))

/* End register sets */

/*
 * Begin register offsets
 */

/* DOORBELLS register offsets */
#define DOORBELL_0 0x0000 /* () Doorbell 0 register */
#define DOORBELL(n) (DOORBELL_0 + (n)*65536)
#define DOORBELL_REG(n, r) (DOORBELL(n) + DOORBELL_BLOCK_REG(r))
#define DOORBELL_COUNT 1024

/* DOORBELL_BLOCK register offsets */
#define DB_BLK_DOORBELL 0x0000 /* (WO) Doorbell request */

/* CS_KERNEL_INPUT_BLOCK register offsets */
#define CS_REQ 0x0000 /* () CS request flags */
#define CS_CONFIG 0x0004 /* () CS configuration */
#define CS_ACK_IRQ_MASK 0x000C /* () Command steam interrupt mask */
#define CS_BASE_LO 0x0010 /* () Base pointer for the ring buffer, low word */
#define CS_BASE_HI 0x0014 /* () Base pointer for the ring buffer, high word */
#define CS_SIZE 0x0018 /* () Size of the ring buffer */
#define CS_TILER_HEAP_START_LO 0x0020 /* () Pointer to heap start, low word */
#define CS_TILER_HEAP_START_HI 0x0024 /* () Pointer to heap start, high word */
#define CS_TILER_HEAP_END_LO 0x0028 /* () Tiler heap descriptor address, low word */
#define CS_TILER_HEAP_END_HI 0x002C /* () Tiler heap descriptor address, high word */
#define CS_USER_INPUT_LO 0x0030 /* () CS user mode input page address, low word */
#define CS_USER_INPUT_HI 0x0034 /* () CS user mode input page address, high word */
#define CS_USER_OUTPUT_LO 0x0038 /* () CS user mode input page address, low word */
#define CS_USER_OUTPUT_HI 0x003C /* () CS user mode input page address, high word */
#define CS_INSTR_CONFIG 0x0040 /* () Instrumentation buffer configuration */
#define CS_INSTR_BUFFER_SIZE 0x0044 /* () Instrumentation buffer size */
#define CS_INSTR_BUFFER_BASE_LO 0x0048 /* () Instrumentation buffer base pointer, low word */
#define CS_INSTR_BUFFER_BASE_HI 0x004C /* () Instrumentation buffer base pointer, high word */
#define CS_INSTR_BUFFER_OFFSET_POINTER_LO 0x0050 /* () Instrumentation buffer pointer to insert offset, low word */
#define CS_INSTR_BUFFER_OFFSET_POINTER_HI 0x0054 /* () Instrumentation buffer pointer to insert offset, high word */

/* CS_KERNEL_OUTPUT_BLOCK register offsets */
#define CS_ACK 0x0000 /* () CS acknowledge flags */
#define CS_STATUS_CMD_PTR_LO 0x0040 /* () Program pointer current value, low word */
#define CS_STATUS_CMD_PTR_HI 0x0044 /* () Program pointer current value, high word */
#define CS_STATUS_WAIT 0x0048 /* () Wait condition status register */
#define CS_STATUS_REQ_RESOURCE 0x004C /* () Indicates the resources requested by the CS */
#define CS_STATUS_WAIT_SYNC_POINTER_LO 0x0050 /* () Sync object pointer, low word */
#define CS_STATUS_WAIT_SYNC_POINTER_HI 0x0054 /* () Sync object pointer, high word */
#define CS_STATUS_WAIT_SYNC_VALUE 0x0058 /* () Sync object test value */
#define CS_STATUS_SCOREBOARDS 0x005C /* () Scoreboard status */
#define CS_STATUS_BLOCKED_REASON 0x0060 /* () Blocked reason */
#define CS_FAULT 0x0080 /* () Recoverable fault information */
#define CS_FATAL 0x0084 /* () Unrecoverable fault information */
#define CS_FAULT_INFO_LO 0x0088 /* () Additional information about a recoverable fault, low word */
#define CS_FAULT_INFO_HI 0x008C /* () Additional information about a recoverable fault, high word */
#define CS_FATAL_INFO_LO 0x0090 /* () Additional information about a non-recoverable fault, low word */
#define CS_FATAL_INFO_HI 0x0094 /* () Additional information about a non-recoverable fault, high word */
#define CS_HEAP_VT_START 0x00C0 /* () Number of vertex/tiling operations started */
#define CS_HEAP_VT_END 0x00C4 /* () Number of vertex/tiling operations completed */
#define CS_HEAP_FRAG_END 0x00CC /* () Number of fragment completed */
#define CS_HEAP_ADDRESS_LO 0x00D0 /* () Heap address, low word */
#define CS_HEAP_ADDRESS_HI 0x00D4 /* () Heap address, high word */

/* CS_USER_INPUT_BLOCK register offsets */
#define CS_INSERT_LO 0x0000 /* () Current insert offset for ring buffer, low word */
#define CS_INSERT_HI 0x0004 /* () Current insert offset for ring buffer, high word */
#define CS_EXTRACT_INIT_LO 0x0008 /* () Initial extract offset for ring buffer, low word */
#define CS_EXTRACT_INIT_HI 0x000C /* () Initial extract offset for ring buffer, high word */

/* CS_USER_OUTPUT_BLOCK register offsets */
#define CS_EXTRACT_LO 0x0000 /* () Current extract offset for ring buffer, low word */
#define CS_EXTRACT_HI 0x0004 /* () Current extract offset for ring buffer, high word */
#define CS_ACTIVE 0x0008 /* () Initial extract offset when the CS is started */

/* CSG_INPUT_BLOCK register offsets */
#define CSG_REQ 0x0000 /* () CSG request */
#define CSG_ACK_IRQ_MASK 0x0004 /* () Global acknowledge interrupt mask */
#define CSG_DB_REQ 0x0008 /* () Global doorbell request */
#define CSG_IRQ_ACK 0x000C /* () CS IRQ acknowledge */
#define CSG_ALLOW_COMPUTE_LO 0x0020 /* () Allowed compute endpoints, low word */
#define CSG_ALLOW_COMPUTE_HI 0x0024 /* () Allowed compute endpoints, high word */
#define CSG_ALLOW_FRAGMENT_LO 0x0028 /* () Allowed fragment endpoints, low word */
#define CSG_ALLOW_FRAGMENT_HI 0x002C /* () Allowed fragment endpoints, high word */
#define CSG_ALLOW_OTHER 0x0030 /* () Allowed other endpoints */
#define CSG_EP_REQ 0x0034 /* () Maximum number of endpoints allowed */
#define CSG_SUSPEND_BUF_LO 0x0040 /* () Normal mode suspend buffer, low word */
#define CSG_SUSPEND_BUF_HI 0x0044 /* () Normal mode suspend buffer, high word */
#define CSG_PROTM_SUSPEND_BUF_LO 0x0048 /* () Protected mode suspend buffer, low word */
#define CSG_PROTM_SUSPEND_BUF_HI 0x004C /* () Protected mode suspend buffer, high word */
#define CSG_CONFIG 0x0050 /* () CSG configuration options */
#define CSG_ITER_TRACE_CONFIG 0x0054 /* () CSG trace configuration */
#define CSG_DVS_BUF_LO 0x0060 /* () Normal mode deferred vertex shading work buffer, low word */
#define CSG_DVS_BUF_HI 0x0064 /* () Normal mode deferred vertex shading work buffer, high word */

/* CSG_OUTPUT_BLOCK register offsets */
#define CSG_ACK 0x0000 /* () CSG acknowledge flags */
#define CSG_DB_ACK 0x0008 /* () CS kernel doorbell acknowledge flags */
#define CSG_IRQ_REQ 0x000C /* () CS interrupt request flags */
#define CSG_STATUS_EP_CURRENT 0x0010 /* () Endpoint allocation status register */
#define CSG_STATUS_EP_REQ 0x0014 /* () Endpoint request status register */
#define CSG_RESOURCE_DEP 0x001C /* () Current resource dependencies */

/* GLB_CONTROL_BLOCK register offsets */
#define GLB_VERSION 0x0000 /* () Global interface version */
#define GLB_FEATURES 0x0004 /* () Global interface features */
#define GLB_INPUT_VA 0x0008 /* () Address of GLB_INPUT_BLOCK */
#define GLB_OUTPUT_VA 0x000C /* () Address of GLB_OUTPUT_BLOCK */
#define GLB_GROUP_NUM 0x0010 /* () Number of CSG interfaces */
#define GLB_GROUP_STRIDE 0x0014 /* () Stride between CSG interfaces */
#define GLB_PRFCNT_SIZE 0x0018 /* () Size of CSF performance counters */
#define GLB_INSTR_FEATURES                                                     \
	0x001C /* () TRACE_POINT instrumentation. (csf >= 1.1.0) */
#define GROUP_CONTROL_0 0x1000 /* () CSG control and capabilities */
#define GROUP_CONTROL(n) (GROUP_CONTROL_0 + (n)*256)
#define GROUP_CONTROL_REG(n, r) (GROUP_CONTROL(n) + GROUP_CONTROL_BLOCK_REG(r))
#define GROUP_CONTROL_COUNT 16

/* STREAM_CONTROL_BLOCK register offsets */
#define STREAM_FEATURES 0x0000 /* () CSI features */
#define STREAM_INPUT_VA 0x0004 /* () Address of CS_KERNEL_INPUT_BLOCK */
#define STREAM_OUTPUT_VA 0x0008 /* () Address of CS_KERNEL_OUTPUT_BLOCK */

/* GROUP_CONTROL_BLOCK register offsets */
#define GROUP_FEATURES 0x0000 /* () CSG interface features */
#define GROUP_INPUT_VA 0x0004 /* () Address of CSG_INPUT_BLOCK */
#define GROUP_OUTPUT_VA 0x0008 /* () Address of CSG_OUTPUT_BLOCK */
#define GROUP_SUSPEND_SIZE 0x000C /* () Size of CSG suspend buffer */
#define GROUP_PROTM_SUSPEND_SIZE 0x0010 /* () Size of CSG protected-mode suspend buffer */
#define GROUP_STREAM_NUM 0x0014 /* () Number of CS interfaces */
#define GROUP_STREAM_STRIDE 0x0018 /* () Stride between CS interfaces  */
#define STREAM_CONTROL_0 0x0040 /* () CS control and capabilities */
#define STREAM_CONTROL(n) (STREAM_CONTROL_0 + (n)*12)
#define STREAM_CONTROL_REG(n, r) (STREAM_CONTROL(n) + STREAM_CONTROL_BLOCK_REG(r))
#define STREAM_CONTROL_COUNT 16

/* GLB_INPUT_BLOCK register offsets */
#define GLB_REQ 0x0000 /* () Global request */
#define GLB_ACK_IRQ_MASK 0x0004 /* () Global acknowledge interrupt mask */
#define GLB_DB_REQ 0x0008 /* () Global doorbell request */
#define GLB_PROGRESS_TIMER 0x0010 /* () Global progress timeout */
#define GLB_PWROFF_TIMER 0x0014 /* () Global shader core power off timer */
#define GLB_ALLOC_EN_LO 0x0018 /* () Global shader core allocation enable mask, low word */
#define GLB_ALLOC_EN_HI 0x001C /* () Global shader core allocation enable mask, high word */

#define GLB_PRFCNT_JASID 0x0024 /* () Performance counter address space */
#define GLB_PRFCNT_BASE_LO 0x0028 /* () Performance counter buffer address, low word */
#define GLB_PRFCNT_BASE_HI 0x002C /* () Performance counter buffer address, high word */
#define GLB_PRFCNT_EXTRACT 0x0030 /* () Performance counter buffer extract index */
#define GLB_PRFCNT_CONFIG 0x0040 /* () Performance counter configuration */
#define GLB_PRFCNT_CSG_SELECT 0x0044 /* () CSG performance counting enable */
#define GLB_PRFCNT_FW_EN 0x0048 /* () Performance counter enable for firmware */
#define GLB_PRFCNT_CSG_EN 0x004C /* () Performance counter enable for CSG */
#define GLB_PRFCNT_CSF_EN 0x0050 /* () Performance counter enable for CSF */
#define GLB_PRFCNT_SHADER_EN 0x0054 /* () Performance counter enable for shader cores */
#define GLB_PRFCNT_TILER_EN 0x0058 /* () Performance counter enable for tiler */
#define GLB_PRFCNT_MMU_L2_EN 0x005C /* () Performance counter enable for MMU/L2 cache */

#define GLB_DEBUG_FWUTF_DESTROY 0x0FE0 /* () Test fixture destroy function address */
#define GLB_DEBUG_FWUTF_TEST 0x0FE4 /* () Test index */
#define GLB_DEBUG_FWUTF_FIXTURE 0x0FE8 /* () Test fixture index */
#define GLB_DEBUG_FWUTF_CREATE 0x0FEC /* () Test fixture create function address */
#define GLB_DEBUG_ACK_IRQ_MASK 0x0FF8 /* () Global debug acknowledge interrupt mask */
#define GLB_DEBUG_REQ 0x0FFC /* () Global debug request */

/* GLB_OUTPUT_BLOCK register offsets */
#define GLB_ACK 0x0000 /* () Global acknowledge */
#define GLB_DB_ACK 0x0008 /* () Global doorbell acknowledge */
#define GLB_HALT_STATUS 0x0010 /* () Global halt status */
#define GLB_PRFCNT_STATUS 0x0014 /* () Performance counter status */
#define GLB_PRFCNT_INSERT 0x0018 /* () Performance counter buffer insert index */
#define GLB_DEBUG_FWUTF_RESULT 0x0FE0 /* () Firmware debug test result */
#define GLB_DEBUG_ACK 0x0FFC /* () Global debug acknowledge */

/* USER register offsets */
#define LATEST_FLUSH 0x0000 /* () Flush ID of latest clean-and-invalidate operation */

/* End register offsets */

/* CS_KERNEL_INPUT_BLOCK register set definitions */
/* GLB_VERSION register */
#define GLB_VERSION_PATCH_SHIFT (0)
#define GLB_VERSION_PATCH_MASK ((0xFFFF) << GLB_VERSION_PATCH_SHIFT)
#define GLB_VERSION_PATCH_GET(reg_val) (((reg_val)&GLB_VERSION_PATCH_MASK) >> GLB_VERSION_PATCH_SHIFT)
#define GLB_VERSION_PATCH_SET(reg_val, value) \
	(((reg_val) & ~GLB_VERSION_PATCH_MASK) | (((value) << GLB_VERSION_PATCH_SHIFT) & GLB_VERSION_PATCH_MASK))
#define GLB_VERSION_MINOR_SHIFT (16)
#define GLB_VERSION_MINOR_MASK ((0xFF) << GLB_VERSION_MINOR_SHIFT)
#define GLB_VERSION_MINOR_GET(reg_val) (((reg_val)&GLB_VERSION_MINOR_MASK) >> GLB_VERSION_MINOR_SHIFT)
#define GLB_VERSION_MINOR_SET(reg_val, value) \
	(((reg_val) & ~GLB_VERSION_MINOR_MASK) | (((value) << GLB_VERSION_MINOR_SHIFT) & GLB_VERSION_MINOR_MASK))
#define GLB_VERSION_MAJOR_SHIFT (24)
#define GLB_VERSION_MAJOR_MASK ((0xFF) << GLB_VERSION_MAJOR_SHIFT)
#define GLB_VERSION_MAJOR_GET(reg_val) (((reg_val)&GLB_VERSION_MAJOR_MASK) >> GLB_VERSION_MAJOR_SHIFT)
#define GLB_VERSION_MAJOR_SET(reg_val, value) \
	(((reg_val) & ~GLB_VERSION_MAJOR_MASK) | (((value) << GLB_VERSION_MAJOR_SHIFT) & GLB_VERSION_MAJOR_MASK))

/* CS_REQ register */
#define CS_REQ_STATE_SHIFT 0
#define CS_REQ_STATE_MASK (0x7 << CS_REQ_STATE_SHIFT)
#define CS_REQ_STATE_GET(reg_val) (((reg_val)&CS_REQ_STATE_MASK) >> CS_REQ_STATE_SHIFT)
#define CS_REQ_STATE_SET(reg_val, value) \
	(((reg_val) & ~CS_REQ_STATE_MASK) | (((value) << CS_REQ_STATE_SHIFT) & CS_REQ_STATE_MASK))
/* CS_REQ_STATE values */
#define CS_REQ_STATE_STOP 0x0
#define CS_REQ_STATE_START 0x1
/* End of CS_REQ_STATE values */
#define CS_REQ_EXTRACT_EVENT_SHIFT 4
#define CS_REQ_EXTRACT_EVENT_MASK (0x1 << CS_REQ_EXTRACT_EVENT_SHIFT)
#define CS_REQ_EXTRACT_EVENT_GET(reg_val) (((reg_val)&CS_REQ_EXTRACT_EVENT_MASK) >> CS_REQ_EXTRACT_EVENT_SHIFT)
#define CS_REQ_EXTRACT_EVENT_SET(reg_val, value) \
	(((reg_val) & ~CS_REQ_EXTRACT_EVENT_MASK) | (((value) << CS_REQ_EXTRACT_EVENT_SHIFT) & CS_REQ_EXTRACT_EVENT_MASK))

#define CS_REQ_IDLE_SYNC_WAIT_SHIFT 8
#define CS_REQ_IDLE_SYNC_WAIT_MASK (0x1 << CS_REQ_IDLE_SYNC_WAIT_SHIFT)
#define CS_REQ_IDLE_SYNC_WAIT_GET(reg_val) (((reg_val)&CS_REQ_IDLE_SYNC_WAIT_MASK) >> CS_REQ_IDLE_SYNC_WAIT_SHIFT)
#define CS_REQ_IDLE_SYNC_WAIT_SET(reg_val, value) \
	(((reg_val) & ~CS_REQ_IDLE_SYNC_WAIT_MASK) |  \
	 (((value) << CS_REQ_IDLE_SYNC_WAIT_SHIFT) & CS_REQ_IDLE_SYNC_WAIT_MASK))
#define CS_REQ_IDLE_PROTM_PEND_SHIFT 9
#define CS_REQ_IDLE_PROTM_PEND_MASK (0x1 << CS_REQ_IDLE_PROTM_PEND_SHIFT)
#define CS_REQ_IDLE_PROTM_PEND_GET(reg_val) (((reg_val)&CS_REQ_IDLE_PROTM_PEND_MASK) >> CS_REQ_IDLE_PROTM_PEND_SHIFT)
#define CS_REQ_IDLE_PROTM_PEND_SET(reg_val, value) \
	(((reg_val) & ~CS_REQ_IDLE_PROTM_PEND_MASK) |  \
	 (((value) << CS_REQ_IDLE_PROTM_PEND_SHIFT) & CS_REQ_IDLE_PROTM_PEND_MASK))
#define CS_REQ_IDLE_EMPTY_SHIFT 10
#define CS_REQ_IDLE_EMPTY_MASK (0x1 << CS_REQ_IDLE_EMPTY_SHIFT)
#define CS_REQ_IDLE_EMPTY_GET(reg_val) (((reg_val)&CS_REQ_IDLE_EMPTY_MASK) >> CS_REQ_IDLE_EMPTY_SHIFT)
#define CS_REQ_IDLE_EMPTY_SET(reg_val, value) \
	(((reg_val) & ~CS_REQ_IDLE_EMPTY_MASK) | (((value) << CS_REQ_IDLE_EMPTY_SHIFT) & CS_REQ_IDLE_EMPTY_MASK))
#define CS_REQ_IDLE_RESOURCE_REQ_SHIFT 11
#define CS_REQ_IDLE_RESOURCE_REQ_MASK (0x1 << CS_REQ_IDLE_RESOURCE_REQ_SHIFT)
#define CS_REQ_IDLE_RESOURCE_REQ_GET(reg_val) \
	(((reg_val)&CS_REQ_IDLE_RESOURCE_REQ_MASK) >> CS_REQ_IDLE_RESOURCE_REQ_SHIFT)
#define CS_REQ_IDLE_RESOURCE_REQ_SET(reg_val, value) \
	(((reg_val) & ~CS_REQ_IDLE_RESOURCE_REQ_MASK) |  \
	 (((value) << CS_REQ_IDLE_RESOURCE_REQ_SHIFT) & CS_REQ_IDLE_RESOURCE_REQ_MASK))
#define CS_REQ_TILER_OOM_SHIFT 26
#define CS_REQ_TILER_OOM_MASK (0x1 << CS_REQ_TILER_OOM_SHIFT)
#define CS_REQ_TILER_OOM_GET(reg_val) (((reg_val)&CS_REQ_TILER_OOM_MASK) >> CS_REQ_TILER_OOM_SHIFT)
#define CS_REQ_TILER_OOM_SET(reg_val, value) \
	(((reg_val) & ~CS_REQ_TILER_OOM_MASK) | (((value) << CS_REQ_TILER_OOM_SHIFT) & CS_REQ_TILER_OOM_MASK))
#define CS_REQ_PROTM_PEND_SHIFT 27
#define CS_REQ_PROTM_PEND_MASK (0x1 << CS_REQ_PROTM_PEND_SHIFT)
#define CS_REQ_PROTM_PEND_GET(reg_val) (((reg_val)&CS_REQ_PROTM_PEND_MASK) >> CS_REQ_PROTM_PEND_SHIFT)
#define CS_REQ_PROTM_PEND_SET(reg_val, value) \
	(((reg_val) & ~CS_REQ_PROTM_PEND_MASK) | (((value) << CS_REQ_PROTM_PEND_SHIFT) & CS_REQ_PROTM_PEND_MASK))
#define CS_REQ_FATAL_SHIFT 30
#define CS_REQ_FATAL_MASK (0x1 << CS_REQ_FATAL_SHIFT)
#define CS_REQ_FATAL_GET(reg_val) (((reg_val)&CS_REQ_FATAL_MASK) >> CS_REQ_FATAL_SHIFT)
#define CS_REQ_FATAL_SET(reg_val, value) \
	(((reg_val) & ~CS_REQ_FATAL_MASK) | (((value) << CS_REQ_FATAL_SHIFT) & CS_REQ_FATAL_MASK))
#define CS_REQ_FAULT_SHIFT 31
#define CS_REQ_FAULT_MASK (0x1 << CS_REQ_FAULT_SHIFT)
#define CS_REQ_FAULT_GET(reg_val) (((reg_val)&CS_REQ_FAULT_MASK) >> CS_REQ_FAULT_SHIFT)
#define CS_REQ_FAULT_SET(reg_val, value) \
	(((reg_val) & ~CS_REQ_FAULT_MASK) | (((value) << CS_REQ_FAULT_SHIFT) & CS_REQ_FAULT_MASK))

/* CS_CONFIG register */
#define CS_CONFIG_PRIORITY_SHIFT 0
#define CS_CONFIG_PRIORITY_MASK (0xF << CS_CONFIG_PRIORITY_SHIFT)
#define CS_CONFIG_PRIORITY_GET(reg_val) (((reg_val)&CS_CONFIG_PRIORITY_MASK) >> CS_CONFIG_PRIORITY_SHIFT)
#define CS_CONFIG_PRIORITY_SET(reg_val, value) \
	(((reg_val) & ~CS_CONFIG_PRIORITY_MASK) | (((value) << CS_CONFIG_PRIORITY_SHIFT) & CS_CONFIG_PRIORITY_MASK))
#define CS_CONFIG_USER_DOORBELL_SHIFT 8
#define CS_CONFIG_USER_DOORBELL_MASK (0xFF << CS_CONFIG_USER_DOORBELL_SHIFT)
#define CS_CONFIG_USER_DOORBELL_GET(reg_val) (((reg_val)&CS_CONFIG_USER_DOORBELL_MASK) >> CS_CONFIG_USER_DOORBELL_SHIFT)
#define CS_CONFIG_USER_DOORBELL_SET(reg_val, value) \
	(((reg_val) & ~CS_CONFIG_USER_DOORBELL_MASK) |  \
	 (((value) << CS_CONFIG_USER_DOORBELL_SHIFT) & CS_CONFIG_USER_DOORBELL_MASK))

/* CS_ACK_IRQ_MASK register */
#define CS_ACK_IRQ_MASK_STATE_SHIFT 0
#define CS_ACK_IRQ_MASK_STATE_MASK (0x7 << CS_ACK_IRQ_MASK_STATE_SHIFT)
#define CS_ACK_IRQ_MASK_STATE_GET(reg_val) (((reg_val)&CS_ACK_IRQ_MASK_STATE_MASK) >> CS_ACK_IRQ_MASK_STATE_SHIFT)
#define CS_ACK_IRQ_MASK_STATE_SET(reg_val, value) \
	(((reg_val) & ~CS_ACK_IRQ_MASK_STATE_MASK) |  \
	 (((value) << CS_ACK_IRQ_MASK_STATE_SHIFT) & CS_ACK_IRQ_MASK_STATE_MASK))
/* CS_ACK_IRQ_MASK_STATE values */
#define CS_ACK_IRQ_MASK_STATE_DISABLED 0x0
#define CS_ACK_IRQ_MASK_STATE_ENABLED 0x7
/* End of CS_ACK_IRQ_MASK_STATE values */
#define CS_ACK_IRQ_MASK_EXTRACT_EVENT_SHIFT 4
#define CS_ACK_IRQ_MASK_EXTRACT_EVENT_MASK (0x1 << CS_ACK_IRQ_MASK_EXTRACT_EVENT_SHIFT)
#define CS_ACK_IRQ_MASK_EXTRACT_EVENT_GET(reg_val) \
	(((reg_val)&CS_ACK_IRQ_MASK_EXTRACT_EVENT_MASK) >> CS_ACK_IRQ_MASK_EXTRACT_EVENT_SHIFT)
#define CS_ACK_IRQ_MASK_EXTRACT_EVENT_SET(reg_val, value) \
	(((reg_val) & ~CS_ACK_IRQ_MASK_EXTRACT_EVENT_MASK) |  \
	 (((value) << CS_ACK_IRQ_MASK_EXTRACT_EVENT_SHIFT) & CS_ACK_IRQ_MASK_EXTRACT_EVENT_MASK))
#define CS_ACK_IRQ_MASK_TILER_OOM_SHIFT 26
#define CS_ACK_IRQ_MASK_TILER_OOM_MASK (0x1 << CS_ACK_IRQ_MASK_TILER_OOM_SHIFT)
#define CS_ACK_IRQ_MASK_TILER_OOM_GET(reg_val) \
	(((reg_val)&CS_ACK_IRQ_MASK_TILER_OOM_MASK) >> CS_ACK_IRQ_MASK_TILER_OOM_SHIFT)
#define CS_ACK_IRQ_MASK_TILER_OOM_SET(reg_val, value) \
	(((reg_val) & ~CS_ACK_IRQ_MASK_TILER_OOM_MASK) |  \
	 (((value) << CS_ACK_IRQ_MASK_TILER_OOM_SHIFT) & CS_ACK_IRQ_MASK_TILER_OOM_MASK))
#define CS_ACK_IRQ_MASK_PROTM_PEND_SHIFT 27
#define CS_ACK_IRQ_MASK_PROTM_PEND_MASK (0x1 << CS_ACK_IRQ_MASK_PROTM_PEND_SHIFT)
#define CS_ACK_IRQ_MASK_PROTM_PEND_GET(reg_val) \
	(((reg_val)&CS_ACK_IRQ_MASK_PROTM_PEND_MASK) >> CS_ACK_IRQ_MASK_PROTM_PEND_SHIFT)
#define CS_ACK_IRQ_MASK_PROTM_PEND_SET(reg_val, value) \
	(((reg_val) & ~CS_ACK_IRQ_MASK_PROTM_PEND_MASK) |  \
	 (((value) << CS_ACK_IRQ_MASK_PROTM_PEND_SHIFT) & CS_ACK_IRQ_MASK_PROTM_PEND_MASK))
#define CS_ACK_IRQ_MASK_FATAL_SHIFT 30
#define CS_ACK_IRQ_MASK_FATAL_MASK (0x1 << CS_ACK_IRQ_MASK_FATAL_SHIFT)
#define CS_ACK_IRQ_MASK_FATAL_GET(reg_val) (((reg_val)&CS_ACK_IRQ_MASK_FATAL_MASK) >> CS_ACK_IRQ_MASK_FATAL_SHIFT)
#define CS_ACK_IRQ_MASK_FATAL_SET(reg_val, value) \
	(((reg_val) & ~CS_ACK_IRQ_MASK_FATAL_MASK) |  \
	 (((value) << CS_ACK_IRQ_MASK_FATAL_SHIFT) & CS_ACK_IRQ_MASK_FATAL_MASK))
#define CS_ACK_IRQ_MASK_FAULT_SHIFT 31
#define CS_ACK_IRQ_MASK_FAULT_MASK (0x1 << CS_ACK_IRQ_MASK_FAULT_SHIFT)
#define CS_ACK_IRQ_MASK_FAULT_GET(reg_val) (((reg_val)&CS_ACK_IRQ_MASK_FAULT_MASK) >> CS_ACK_IRQ_MASK_FAULT_SHIFT)
#define CS_ACK_IRQ_MASK_FAULT_SET(reg_val, value) \
	(((reg_val) & ~CS_ACK_IRQ_MASK_FAULT_MASK) |  \
	 (((value) << CS_ACK_IRQ_MASK_FAULT_SHIFT) & CS_ACK_IRQ_MASK_FAULT_MASK))

/* CS_BASE register */
#define CS_BASE_POINTER_SHIFT 0
#define CS_BASE_POINTER_MASK (GPU_ULL(0xFFFFFFFFFFFFFFFF) << CS_BASE_POINTER_SHIFT)
#define CS_BASE_POINTER_GET(reg_val) (((reg_val)&CS_BASE_POINTER_MASK) >> CS_BASE_POINTER_SHIFT)
#define CS_BASE_POINTER_SET(reg_val, value) \
	(((reg_val) & ~CS_BASE_POINTER_MASK) | (((value) << CS_BASE_POINTER_SHIFT) & CS_BASE_POINTER_MASK))

/* CS_SIZE register */
#define CS_SIZE_SIZE_SHIFT 0
#define CS_SIZE_SIZE_MASK (0xFFFFFFFF << CS_SIZE_SIZE_SHIFT)
#define CS_SIZE_SIZE_GET(reg_val) (((reg_val)&CS_SIZE_SIZE_MASK) >> CS_SIZE_SIZE_SHIFT)
#define CS_SIZE_SIZE_SET(reg_val, value) \
	(((reg_val) & ~CS_SIZE_SIZE_MASK) | (((value) << CS_SIZE_SIZE_SHIFT) & CS_SIZE_SIZE_MASK))

/* CS_TILER_HEAP_START register */
#define CS_TILER_HEAP_START_POINTER_SHIFT 0
#define CS_TILER_HEAP_START_POINTER_MASK                                                           \
	(GPU_ULL(0xFFFFFFFFFFFFFFFF) << CS_TILER_HEAP_START_POINTER_SHIFT)
#define CS_TILER_HEAP_START_POINTER_GET(reg_val) \
	(((reg_val)&CS_TILER_HEAP_START_POINTER_MASK) >> CS_TILER_HEAP_START_POINTER_SHIFT)
#define CS_TILER_HEAP_START_POINTER_SET(reg_val, value) \
	(((reg_val) & ~CS_TILER_HEAP_START_POINTER_MASK) |  \
	 (((value) << CS_TILER_HEAP_START_POINTER_SHIFT) & CS_TILER_HEAP_START_POINTER_MASK))
/* HeapChunkPointer nested in CS_TILER_HEAP_START_POINTER */
/* End of HeapChunkPointer nested in CS_TILER_HEAP_START_POINTER */

/* CS_TILER_HEAP_END register */
#define CS_TILER_HEAP_END_POINTER_SHIFT 0
#define CS_TILER_HEAP_END_POINTER_MASK                                                             \
	(GPU_ULL(0xFFFFFFFFFFFFFFFF) << CS_TILER_HEAP_END_POINTER_SHIFT)
#define CS_TILER_HEAP_END_POINTER_GET(reg_val) \
	(((reg_val)&CS_TILER_HEAP_END_POINTER_MASK) >> CS_TILER_HEAP_END_POINTER_SHIFT)
#define CS_TILER_HEAP_END_POINTER_SET(reg_val, value) \
	(((reg_val) & ~CS_TILER_HEAP_END_POINTER_MASK) |  \
	 (((value) << CS_TILER_HEAP_END_POINTER_SHIFT) & CS_TILER_HEAP_END_POINTER_MASK))
/* HeapChunkPointer nested in CS_TILER_HEAP_END_POINTER */
/* End of HeapChunkPointer nested in CS_TILER_HEAP_END_POINTER */

/* CS_USER_INPUT register */
#define CS_USER_INPUT_POINTER_SHIFT 0
#define CS_USER_INPUT_POINTER_MASK (GPU_ULL(0xFFFFFFFFFFFFFFFF) << CS_USER_INPUT_POINTER_SHIFT)
#define CS_USER_INPUT_POINTER_GET(reg_val) (((reg_val)&CS_USER_INPUT_POINTER_MASK) >> CS_USER_INPUT_POINTER_SHIFT)
#define CS_USER_INPUT_POINTER_SET(reg_val, value) \
	(((reg_val) & ~CS_USER_INPUT_POINTER_MASK) |  \
	 (((value) << CS_USER_INPUT_POINTER_SHIFT) & CS_USER_INPUT_POINTER_MASK))

/* CS_USER_OUTPUT register */
#define CS_USER_OUTPUT_POINTER_SHIFT 0
#define CS_USER_OUTPUT_POINTER_MASK (GPU_ULL(0xFFFFFFFFFFFFFFFF) << CS_USER_OUTPUT_POINTER_SHIFT)
#define CS_USER_OUTPUT_POINTER_GET(reg_val) (((reg_val)&CS_USER_OUTPUT_POINTER_MASK) >> CS_USER_OUTPUT_POINTER_SHIFT)
#define CS_USER_OUTPUT_POINTER_SET(reg_val, value) \
	(((reg_val) & ~CS_USER_OUTPUT_POINTER_MASK) |  \
	 (((value) << CS_USER_OUTPUT_POINTER_SHIFT) & CS_USER_OUTPUT_POINTER_MASK))

/* CS_INSTR_CONFIG register */
#define CS_INSTR_CONFIG_JASID_SHIFT (0)
#define CS_INSTR_CONFIG_JASID_MASK ((u32)0xF << CS_INSTR_CONFIG_JASID_SHIFT)
#define CS_INSTR_CONFIG_JASID_GET(reg_val) (((reg_val)&CS_INSTR_CONFIG_JASID_MASK) >> CS_INSTR_CONFIG_JASID_SHIFT)
#define CS_INSTR_CONFIG_JASID_SET(reg_val, value) \
	(((reg_val) & ~CS_INSTR_CONFIG_JASID_MASK) |  \
	 (((value) << CS_INSTR_CONFIG_JASID_SHIFT) & CS_INSTR_CONFIG_JASID_MASK))
#define CS_INSTR_CONFIG_EVENT_SIZE_SHIFT (4)
#define CS_INSTR_CONFIG_EVENT_SIZE_MASK ((u32)0xF << CS_INSTR_CONFIG_EVENT_SIZE_SHIFT)
#define CS_INSTR_CONFIG_EVENT_SIZE_GET(reg_val) \
	(((reg_val)&CS_INSTR_CONFIG_EVENT_SIZE_MASK) >> CS_INSTR_CONFIG_EVENT_SIZE_SHIFT)
#define CS_INSTR_CONFIG_EVENT_SIZE_SET(reg_val, value) \
	(((reg_val) & ~CS_INSTR_CONFIG_EVENT_SIZE_MASK) |  \
	 (((value) << CS_INSTR_CONFIG_EVENT_SIZE_SHIFT) & CS_INSTR_CONFIG_EVENT_SIZE_MASK))
#define CS_INSTR_CONFIG_EVENT_STATE_SHIFT (16)
#define CS_INSTR_CONFIG_EVENT_STATE_MASK ((u32)0xFF << CS_INSTR_CONFIG_EVENT_STATE_SHIFT)
#define CS_INSTR_CONFIG_EVENT_STATE_GET(reg_val) \
	(((reg_val)&CS_INSTR_CONFIG_EVENT_STATE_MASK) >> CS_INSTR_CONFIG_EVENT_STATE_SHIFT)
#define CS_INSTR_CONFIG_EVENT_STATE_SET(reg_val, value) \
	(((reg_val) & ~CS_INSTR_CONFIG_EVENT_STATE_MASK) |  \
	 (((value) << CS_INSTR_CONFIG_EVENT_STATE_SHIFT) & CS_INSTR_CONFIG_EVENT_STATE_MASK))

/* CS_INSTR_BUFFER_SIZE register */
#define CS_INSTR_BUFFER_SIZE_SIZE_SHIFT (0)
#define CS_INSTR_BUFFER_SIZE_SIZE_MASK ((u32)0xFFFFFFFF << CS_INSTR_BUFFER_SIZE_SIZE_SHIFT)
#define CS_INSTR_BUFFER_SIZE_SIZE_GET(reg_val) \
	(((reg_val)&CS_INSTR_BUFFER_SIZE_SIZE_MASK) >> CS_INSTR_BUFFER_SIZE_SIZE_SHIFT)
#define CS_INSTR_BUFFER_SIZE_SIZE_SET(reg_val, value) \
	(((reg_val) & ~CS_INSTR_BUFFER_SIZE_SIZE_MASK) |  \
	 (((value) << CS_INSTR_BUFFER_SIZE_SIZE_SHIFT) & CS_INSTR_BUFFER_SIZE_SIZE_MASK))

/* CS_INSTR_BUFFER_BASE register */
#define CS_INSTR_BUFFER_BASE_POINTER_SHIFT (0)
#define CS_INSTR_BUFFER_BASE_POINTER_MASK                                                          \
	(GPU_ULL(0xFFFFFFFFFFFFFFFF) << CS_INSTR_BUFFER_BASE_POINTER_SHIFT)
#define CS_INSTR_BUFFER_BASE_POINTER_GET(reg_val) \
	(((reg_val)&CS_INSTR_BUFFER_BASE_POINTER_MASK) >> CS_INSTR_BUFFER_BASE_POINTER_SHIFT)
#define CS_INSTR_BUFFER_BASE_POINTER_SET(reg_val, value) \
	(((reg_val) & ~CS_INSTR_BUFFER_BASE_POINTER_MASK) |  \
	 (((value) << CS_INSTR_BUFFER_BASE_POINTER_SHIFT) & CS_INSTR_BUFFER_BASE_POINTER_MASK))

/* CS_INSTR_BUFFER_OFFSET_POINTER register */
#define CS_INSTR_BUFFER_OFFSET_POINTER_POINTER_SHIFT (0)
#define CS_INSTR_BUFFER_OFFSET_POINTER_POINTER_MASK                                                \
	((GPU_ULL(0xFFFFFFFFFFFFFFFF)) << CS_INSTR_BUFFER_OFFSET_POINTER_POINTER_SHIFT)
#define CS_INSTR_BUFFER_OFFSET_POINTER_POINTER_GET(reg_val) \
	(((reg_val)&CS_INSTR_BUFFER_OFFSET_POINTER_POINTER_MASK) >> CS_INSTR_BUFFER_OFFSET_POINTER_POINTER_SHIFT)
#define CS_INSTR_BUFFER_OFFSET_POINTER_POINTER_SET(reg_val, value) \
	(((reg_val) & ~CS_INSTR_BUFFER_OFFSET_POINTER_POINTER_MASK) |  \
	 (((value) << CS_INSTR_BUFFER_OFFSET_POINTER_POINTER_SHIFT) & CS_INSTR_BUFFER_OFFSET_POINTER_POINTER_MASK))

/* End of CS_KERNEL_INPUT_BLOCK register set definitions */

/* CS_KERNEL_OUTPUT_BLOCK register set definitions */

/* CS_ACK register */
#define CS_ACK_STATE_SHIFT 0
#define CS_ACK_STATE_MASK (0x7 << CS_ACK_STATE_SHIFT)
#define CS_ACK_STATE_GET(reg_val) (((reg_val)&CS_ACK_STATE_MASK) >> CS_ACK_STATE_SHIFT)
#define CS_ACK_STATE_SET(reg_val, value) \
	(((reg_val) & ~CS_ACK_STATE_MASK) | (((value) << CS_ACK_STATE_SHIFT) & CS_ACK_STATE_MASK))
/* CS_ACK_STATE values */
#define CS_ACK_STATE_STOP 0x0
#define CS_ACK_STATE_START 0x1
/* End of CS_ACK_STATE values */
#define CS_ACK_EXTRACT_EVENT_SHIFT 4
#define CS_ACK_EXTRACT_EVENT_MASK (0x1 << CS_ACK_EXTRACT_EVENT_SHIFT)
#define CS_ACK_EXTRACT_EVENT_GET(reg_val) (((reg_val)&CS_ACK_EXTRACT_EVENT_MASK) >> CS_ACK_EXTRACT_EVENT_SHIFT)
#define CS_ACK_EXTRACT_EVENT_SET(reg_val, value) \
	(((reg_val) & ~CS_ACK_EXTRACT_EVENT_MASK) | (((value) << CS_ACK_EXTRACT_EVENT_SHIFT) & CS_ACK_EXTRACT_EVENT_MASK))
#define CS_ACK_TILER_OOM_SHIFT 26
#define CS_ACK_TILER_OOM_MASK (0x1 << CS_ACK_TILER_OOM_SHIFT)
#define CS_ACK_TILER_OOM_GET(reg_val) (((reg_val)&CS_ACK_TILER_OOM_MASK) >> CS_ACK_TILER_OOM_SHIFT)
#define CS_ACK_TILER_OOM_SET(reg_val, value) \
	(((reg_val) & ~CS_ACK_TILER_OOM_MASK) | (((value) << CS_ACK_TILER_OOM_SHIFT) & CS_ACK_TILER_OOM_MASK))
#define CS_ACK_PROTM_PEND_SHIFT 27
#define CS_ACK_PROTM_PEND_MASK (0x1 << CS_ACK_PROTM_PEND_SHIFT)
#define CS_ACK_PROTM_PEND_GET(reg_val) (((reg_val)&CS_ACK_PROTM_PEND_MASK) >> CS_ACK_PROTM_PEND_SHIFT)
#define CS_ACK_PROTM_PEND_SET(reg_val, value) \
	(((reg_val) & ~CS_ACK_PROTM_PEND_MASK) | (((value) << CS_ACK_PROTM_PEND_SHIFT) & CS_ACK_PROTM_PEND_MASK))
#define CS_ACK_FATAL_SHIFT 30
#define CS_ACK_FATAL_MASK (0x1 << CS_ACK_FATAL_SHIFT)
#define CS_ACK_FATAL_GET(reg_val) (((reg_val)&CS_ACK_FATAL_MASK) >> CS_ACK_FATAL_SHIFT)
#define CS_ACK_FATAL_SET(reg_val, value) \
	(((reg_val) & ~CS_ACK_FATAL_MASK) | (((value) << CS_ACK_FATAL_SHIFT) & CS_ACK_FATAL_MASK))
#define CS_ACK_FAULT_SHIFT 31
#define CS_ACK_FAULT_MASK (0x1 << CS_ACK_FAULT_SHIFT)
#define CS_ACK_FAULT_GET(reg_val) (((reg_val)&CS_ACK_FAULT_MASK) >> CS_ACK_FAULT_SHIFT)
#define CS_ACK_FAULT_SET(reg_val, value) \
	(((reg_val) & ~CS_ACK_FAULT_MASK) | (((value) << CS_ACK_FAULT_SHIFT) & CS_ACK_FAULT_MASK))

/* CS_STATUS_CMD_PTR register */
#define CS_STATUS_CMD_PTR_POINTER_SHIFT 0
#define CS_STATUS_CMD_PTR_POINTER_MASK                                                             \
	(GPU_ULL(0xFFFFFFFFFFFFFFFF) << CS_STATUS_CMD_PTR_POINTER_SHIFT)
#define CS_STATUS_CMD_PTR_POINTER_GET(reg_val) \
	(((reg_val)&CS_STATUS_CMD_PTR_POINTER_MASK) >> CS_STATUS_CMD_PTR_POINTER_SHIFT)
#define CS_STATUS_CMD_PTR_POINTER_SET(reg_val, value) \
	(((reg_val) & ~CS_STATUS_CMD_PTR_POINTER_MASK) |  \
	 (((value) << CS_STATUS_CMD_PTR_POINTER_SHIFT) & CS_STATUS_CMD_PTR_POINTER_MASK))

/* CS_STATUS_WAIT register */
#define CS_STATUS_WAIT_SB_MASK_SHIFT 0
#define CS_STATUS_WAIT_SB_MASK_MASK (0xFFFF << CS_STATUS_WAIT_SB_MASK_SHIFT)
#define CS_STATUS_WAIT_SB_MASK_GET(reg_val) (((reg_val)&CS_STATUS_WAIT_SB_MASK_MASK) >> CS_STATUS_WAIT_SB_MASK_SHIFT)
#define CS_STATUS_WAIT_SB_MASK_SET(reg_val, value) \
	(((reg_val) & ~CS_STATUS_WAIT_SB_MASK_MASK) |  \
	 (((value) << CS_STATUS_WAIT_SB_MASK_SHIFT) & CS_STATUS_WAIT_SB_MASK_MASK))
#define CS_STATUS_WAIT_SB_SOURCE_SHIFT 16
#define CS_STATUS_WAIT_SB_SOURCE_MASK (0xF << CS_STATUS_WAIT_SB_SOURCE_SHIFT)
#define CS_STATUS_WAIT_SB_SOURCE_GET(reg_val)                                                      \
	(((reg_val)&CS_STATUS_WAIT_SB_SOURCE_MASK) >> CS_STATUS_WAIT_SB_SOURCE_SHIFT)
#define CS_STATUS_WAIT_SB_SOURCE_SET(reg_val, value)                                               \
	(((reg_val) & ~CS_STATUS_WAIT_SB_SOURCE_MASK) |                                            \
	 (((value) << CS_STATUS_WAIT_SB_SOURCE_SHIFT) & CS_STATUS_WAIT_SB_SOURCE_MASK))
#define CS_STATUS_WAIT_SYNC_WAIT_CONDITION_SHIFT 24
#define CS_STATUS_WAIT_SYNC_WAIT_CONDITION_MASK (0xF << CS_STATUS_WAIT_SYNC_WAIT_CONDITION_SHIFT)
#define CS_STATUS_WAIT_SYNC_WAIT_CONDITION_GET(reg_val) \
	(((reg_val)&CS_STATUS_WAIT_SYNC_WAIT_CONDITION_MASK) >> CS_STATUS_WAIT_SYNC_WAIT_CONDITION_SHIFT)
#define CS_STATUS_WAIT_SYNC_WAIT_CONDITION_SET(reg_val, value) \
	(((reg_val) & ~CS_STATUS_WAIT_SYNC_WAIT_CONDITION_MASK) |  \
	 (((value) << CS_STATUS_WAIT_SYNC_WAIT_CONDITION_SHIFT) & CS_STATUS_WAIT_SYNC_WAIT_CONDITION_MASK))
/* CS_STATUS_WAIT_SYNC_WAIT_CONDITION values */
#define CS_STATUS_WAIT_SYNC_WAIT_CONDITION_LE 0x0
#define CS_STATUS_WAIT_SYNC_WAIT_CONDITION_GT 0x1
#define CS_STATUS_WAIT_SYNC_WAIT_CONDITION_GE 0x5
/* End of CS_STATUS_WAIT_SYNC_WAIT_CONDITION values */
#define CS_STATUS_WAIT_PROGRESS_WAIT_SHIFT 28
#define CS_STATUS_WAIT_PROGRESS_WAIT_MASK (0x1 << CS_STATUS_WAIT_PROGRESS_WAIT_SHIFT)
#define CS_STATUS_WAIT_PROGRESS_WAIT_GET(reg_val) \
	(((reg_val)&CS_STATUS_WAIT_PROGRESS_WAIT_MASK) >> CS_STATUS_WAIT_PROGRESS_WAIT_SHIFT)
#define CS_STATUS_WAIT_PROGRESS_WAIT_SET(reg_val, value) \
	(((reg_val) & ~CS_STATUS_WAIT_PROGRESS_WAIT_MASK) |  \
	 (((value) << CS_STATUS_WAIT_PROGRESS_WAIT_SHIFT) & CS_STATUS_WAIT_PROGRESS_WAIT_MASK))
#define CS_STATUS_WAIT_PROTM_PEND_SHIFT 29
#define CS_STATUS_WAIT_PROTM_PEND_MASK (0x1 << CS_STATUS_WAIT_PROTM_PEND_SHIFT)
#define CS_STATUS_WAIT_PROTM_PEND_GET(reg_val) \
	(((reg_val)&CS_STATUS_WAIT_PROTM_PEND_MASK) >> CS_STATUS_WAIT_PROTM_PEND_SHIFT)
#define CS_STATUS_WAIT_PROTM_PEND_SET(reg_val, value) \
	(((reg_val) & ~CS_STATUS_WAIT_PROTM_PEND_MASK) |  \
	 (((value) << CS_STATUS_WAIT_PROTM_PEND_SHIFT) & CS_STATUS_WAIT_PROTM_PEND_MASK))
#define CS_STATUS_WAIT_SYNC_WAIT_SHIFT 31
#define CS_STATUS_WAIT_SYNC_WAIT_MASK (0x1 << CS_STATUS_WAIT_SYNC_WAIT_SHIFT)
#define CS_STATUS_WAIT_SYNC_WAIT_GET(reg_val) \
	(((reg_val)&CS_STATUS_WAIT_SYNC_WAIT_MASK) >> CS_STATUS_WAIT_SYNC_WAIT_SHIFT)
#define CS_STATUS_WAIT_SYNC_WAIT_SET(reg_val, value) \
	(((reg_val) & ~CS_STATUS_WAIT_SYNC_WAIT_MASK) |  \
	 (((value) << CS_STATUS_WAIT_SYNC_WAIT_SHIFT) & CS_STATUS_WAIT_SYNC_WAIT_MASK))

/* CS_STATUS_REQ_RESOURCE register */
#define CS_STATUS_REQ_RESOURCE_COMPUTE_RESOURCES_SHIFT 0
#define CS_STATUS_REQ_RESOURCE_COMPUTE_RESOURCES_MASK (0x1 << CS_STATUS_REQ_RESOURCE_COMPUTE_RESOURCES_SHIFT)
#define CS_STATUS_REQ_RESOURCE_COMPUTE_RESOURCES_GET(reg_val) \
	(((reg_val)&CS_STATUS_REQ_RESOURCE_COMPUTE_RESOURCES_MASK) >> CS_STATUS_REQ_RESOURCE_COMPUTE_RESOURCES_SHIFT)
#define CS_STATUS_REQ_RESOURCE_COMPUTE_RESOURCES_SET(reg_val, value) \
	(((reg_val) & ~CS_STATUS_REQ_RESOURCE_COMPUTE_RESOURCES_MASK) |  \
	 (((value) << CS_STATUS_REQ_RESOURCE_COMPUTE_RESOURCES_SHIFT) & CS_STATUS_REQ_RESOURCE_COMPUTE_RESOURCES_MASK))
#define CS_STATUS_REQ_RESOURCE_FRAGMENT_RESOURCES_SHIFT 1
#define CS_STATUS_REQ_RESOURCE_FRAGMENT_RESOURCES_MASK (0x1 << CS_STATUS_REQ_RESOURCE_FRAGMENT_RESOURCES_SHIFT)
#define CS_STATUS_REQ_RESOURCE_FRAGMENT_RESOURCES_GET(reg_val) \
	(((reg_val)&CS_STATUS_REQ_RESOURCE_FRAGMENT_RESOURCES_MASK) >> CS_STATUS_REQ_RESOURCE_FRAGMENT_RESOURCES_SHIFT)
#define CS_STATUS_REQ_RESOURCE_FRAGMENT_RESOURCES_SET(reg_val, value) \
	(((reg_val) & ~CS_STATUS_REQ_RESOURCE_FRAGMENT_RESOURCES_MASK) |  \
	 (((value) << CS_STATUS_REQ_RESOURCE_FRAGMENT_RESOURCES_SHIFT) & CS_STATUS_REQ_RESOURCE_FRAGMENT_RESOURCES_MASK))
#define CS_STATUS_REQ_RESOURCE_TILER_RESOURCES_SHIFT 2
#define CS_STATUS_REQ_RESOURCE_TILER_RESOURCES_MASK (0x1 << CS_STATUS_REQ_RESOURCE_TILER_RESOURCES_SHIFT)
#define CS_STATUS_REQ_RESOURCE_TILER_RESOURCES_GET(reg_val) \
	(((reg_val)&CS_STATUS_REQ_RESOURCE_TILER_RESOURCES_MASK) >> CS_STATUS_REQ_RESOURCE_TILER_RESOURCES_SHIFT)
#define CS_STATUS_REQ_RESOURCE_TILER_RESOURCES_SET(reg_val, value) \
	(((reg_val) & ~CS_STATUS_REQ_RESOURCE_TILER_RESOURCES_MASK) |  \
	 (((value) << CS_STATUS_REQ_RESOURCE_TILER_RESOURCES_SHIFT) & CS_STATUS_REQ_RESOURCE_TILER_RESOURCES_MASK))
#define CS_STATUS_REQ_RESOURCE_IDVS_RESOURCES_SHIFT 3
#define CS_STATUS_REQ_RESOURCE_IDVS_RESOURCES_MASK (0x1 << CS_STATUS_REQ_RESOURCE_IDVS_RESOURCES_SHIFT)
#define CS_STATUS_REQ_RESOURCE_IDVS_RESOURCES_GET(reg_val) \
	(((reg_val)&CS_STATUS_REQ_RESOURCE_IDVS_RESOURCES_MASK) >> CS_STATUS_REQ_RESOURCE_IDVS_RESOURCES_SHIFT)
#define CS_STATUS_REQ_RESOURCE_IDVS_RESOURCES_SET(reg_val, value) \
	(((reg_val) & ~CS_STATUS_REQ_RESOURCE_IDVS_RESOURCES_MASK) |  \
	 (((value) << CS_STATUS_REQ_RESOURCE_IDVS_RESOURCES_SHIFT) & CS_STATUS_REQ_RESOURCE_IDVS_RESOURCES_MASK))

/* CS_STATUS_WAIT_SYNC_POINTER register */
#define CS_STATUS_WAIT_SYNC_POINTER_POINTER_SHIFT 0
#define CS_STATUS_WAIT_SYNC_POINTER_POINTER_MASK                                                   \
	(GPU_ULL(0xFFFFFFFFFFFFFFFF) << CS_STATUS_WAIT_SYNC_POINTER_POINTER_SHIFT)
#define CS_STATUS_WAIT_SYNC_POINTER_POINTER_GET(reg_val) \
	(((reg_val)&CS_STATUS_WAIT_SYNC_POINTER_POINTER_MASK) >> CS_STATUS_WAIT_SYNC_POINTER_POINTER_SHIFT)
#define CS_STATUS_WAIT_SYNC_POINTER_POINTER_SET(reg_val, value) \
	(((reg_val) & ~CS_STATUS_WAIT_SYNC_POINTER_POINTER_MASK) |  \
	 (((value) << CS_STATUS_WAIT_SYNC_POINTER_POINTER_SHIFT) & CS_STATUS_WAIT_SYNC_POINTER_POINTER_MASK))

/* CS_STATUS_WAIT_SYNC_VALUE register */
#define CS_STATUS_WAIT_SYNC_VALUE_VALUE_SHIFT 0
#define CS_STATUS_WAIT_SYNC_VALUE_VALUE_MASK (0xFFFFFFFF << CS_STATUS_WAIT_SYNC_VALUE_VALUE_SHIFT)
#define CS_STATUS_WAIT_SYNC_VALUE_VALUE_GET(reg_val) \
	(((reg_val)&CS_STATUS_WAIT_SYNC_VALUE_VALUE_MASK) >> CS_STATUS_WAIT_SYNC_VALUE_VALUE_SHIFT)
#define CS_STATUS_WAIT_SYNC_VALUE_VALUE_SET(reg_val, value) \
	(((reg_val) & ~CS_STATUS_WAIT_SYNC_VALUE_VALUE_MASK) |  \
	 (((value) << CS_STATUS_WAIT_SYNC_VALUE_VALUE_SHIFT) & CS_STATUS_WAIT_SYNC_VALUE_VALUE_MASK))

/* CS_STATUS_SCOREBOARDS register */
#define CS_STATUS_SCOREBOARDS_NONZERO_SHIFT (0)
#define CS_STATUS_SCOREBOARDS_NONZERO_MASK                                     \
	((0xFFFF) << CS_STATUS_SCOREBOARDS_NONZERO_SHIFT)
#define CS_STATUS_SCOREBOARDS_NONZERO_GET(reg_val)                             \
	(((reg_val)&CS_STATUS_SCOREBOARDS_NONZERO_MASK) >>                     \
	 CS_STATUS_SCOREBOARDS_NONZERO_SHIFT)
#define CS_STATUS_SCOREBOARDS_NONZERO_SET(reg_val, value)                      \
	(((reg_val) & ~CS_STATUS_SCOREBOARDS_NONZERO_MASK) |                   \
	 (((value) << CS_STATUS_SCOREBOARDS_NONZERO_SHIFT) &                   \
	  CS_STATUS_SCOREBOARDS_NONZERO_MASK))

/* CS_STATUS_BLOCKED_REASON register */
#define CS_STATUS_BLOCKED_REASON_REASON_SHIFT (0)
#define CS_STATUS_BLOCKED_REASON_REASON_MASK                                   \
	((0xF) << CS_STATUS_BLOCKED_REASON_REASON_SHIFT)
#define CS_STATUS_BLOCKED_REASON_REASON_GET(reg_val)                           \
	(((reg_val)&CS_STATUS_BLOCKED_REASON_REASON_MASK) >>                   \
	 CS_STATUS_BLOCKED_REASON_REASON_SHIFT)
#define CS_STATUS_BLOCKED_REASON_REASON_SET(reg_val, value)                    \
	(((reg_val) & ~CS_STATUS_BLOCKED_REASON_REASON_MASK) |                 \
	 (((value) << CS_STATUS_BLOCKED_REASON_REASON_SHIFT) &                 \
	  CS_STATUS_BLOCKED_REASON_REASON_MASK))
/* CS_STATUS_BLOCKED_REASON_reason values */
#define CS_STATUS_BLOCKED_REASON_REASON_UNBLOCKED 0x0
#define CS_STATUS_BLOCKED_REASON_REASON_WAIT 0x1
#define CS_STATUS_BLOCKED_REASON_REASON_PROGRESS_WAIT 0x2
#define CS_STATUS_BLOCKED_REASON_REASON_SYNC_WAIT 0x3
#define CS_STATUS_BLOCKED_REASON_REASON_DEFERRED 0x4
#define CS_STATUS_BLOCKED_REASON_REASON_RESOURCE 0x5
#define CS_STATUS_BLOCKED_REASON_REASON_FLUSH 0x6
/* End of CS_STATUS_BLOCKED_REASON_reason values */

/* CS_FAULT register */
#define CS_FAULT_EXCEPTION_TYPE_SHIFT 0
#define CS_FAULT_EXCEPTION_TYPE_MASK (0xFF << CS_FAULT_EXCEPTION_TYPE_SHIFT)
#define CS_FAULT_EXCEPTION_TYPE_GET(reg_val) (((reg_val)&CS_FAULT_EXCEPTION_TYPE_MASK) >> CS_FAULT_EXCEPTION_TYPE_SHIFT)
#define CS_FAULT_EXCEPTION_TYPE_SET(reg_val, value) \
	(((reg_val) & ~CS_FAULT_EXCEPTION_TYPE_MASK) |  \
	 (((value) << CS_FAULT_EXCEPTION_TYPE_SHIFT) & CS_FAULT_EXCEPTION_TYPE_MASK))
/* CS_FAULT_EXCEPTION_TYPE values */
#define CS_FAULT_EXCEPTION_TYPE_KABOOM 0x05
#define CS_FAULT_EXCEPTION_TYPE_CS_RESOURCE_TERMINATED 0x0F
#define CS_FAULT_EXCEPTION_TYPE_CS_BUS_FAULT 0x48
#define CS_FAULT_EXCEPTION_TYPE_CS_INHERIT_FAULT 0x4B
#define CS_FAULT_EXCEPTION_TYPE_INSTR_INVALID_PC 0x50
#define CS_FAULT_EXCEPTION_TYPE_INSTR_INVALID_ENC 0x51
#define CS_FAULT_EXCEPTION_TYPE_INSTR_BARRIER_FAULT 0x55
#define CS_FAULT_EXCEPTION_TYPE_DATA_INVALID_FAULT 0x58
#define CS_FAULT_EXCEPTION_TYPE_TILE_RANGE_FAULT 0x59
#define CS_FAULT_EXCEPTION_TYPE_ADDR_RANGE_FAULT 0x5A
#define CS_FAULT_EXCEPTION_TYPE_IMPRECISE_FAULT 0x5B
#define CS_FAULT_EXCEPTION_TYPE_RESOURCE_EVICTION_TIMEOUT 0x69
/* End of CS_FAULT_EXCEPTION_TYPE values */
#define CS_FAULT_EXCEPTION_DATA_SHIFT 8
#define CS_FAULT_EXCEPTION_DATA_MASK (0xFFFFFF << CS_FAULT_EXCEPTION_DATA_SHIFT)
#define CS_FAULT_EXCEPTION_DATA_GET(reg_val) (((reg_val)&CS_FAULT_EXCEPTION_DATA_MASK) >> CS_FAULT_EXCEPTION_DATA_SHIFT)
#define CS_FAULT_EXCEPTION_DATA_SET(reg_val, value) \
	(((reg_val) & ~CS_FAULT_EXCEPTION_DATA_MASK) |  \
	 (((value) << CS_FAULT_EXCEPTION_DATA_SHIFT) & CS_FAULT_EXCEPTION_DATA_MASK))

/* CS_FATAL register */
#define CS_FATAL_EXCEPTION_TYPE_SHIFT 0
#define CS_FATAL_EXCEPTION_TYPE_MASK (0xFF << CS_FATAL_EXCEPTION_TYPE_SHIFT)
#define CS_FATAL_EXCEPTION_TYPE_GET(reg_val) (((reg_val)&CS_FATAL_EXCEPTION_TYPE_MASK) >> CS_FATAL_EXCEPTION_TYPE_SHIFT)
#define CS_FATAL_EXCEPTION_TYPE_SET(reg_val, value) \
	(((reg_val) & ~CS_FATAL_EXCEPTION_TYPE_MASK) |  \
	 (((value) << CS_FATAL_EXCEPTION_TYPE_SHIFT) & CS_FATAL_EXCEPTION_TYPE_MASK))
/* CS_FATAL_EXCEPTION_TYPE values */
#define CS_FATAL_EXCEPTION_TYPE_CS_CONFIG_FAULT 0x40
#define CS_FATAL_EXCEPTION_TYPE_CS_UNRECOVERABLE 0x41
#define CS_FATAL_EXCEPTION_TYPE_CS_ENDPOINT_FAULT 0x44
#define CS_FATAL_EXCEPTION_TYPE_CS_BUS_FAULT 0x48
#define CS_FATAL_EXCEPTION_TYPE_CS_INVALID_INSTRUCTION 0x49
#define CS_FATAL_EXCEPTION_TYPE_CS_CALL_STACK_OVERFLOW 0x4A
#define CS_FATAL_EXCEPTION_TYPE_FIRMWARE_INTERNAL_ERROR 0x68
/* End of CS_FATAL_EXCEPTION_TYPE values */
#define CS_FATAL_EXCEPTION_DATA_SHIFT 8
#define CS_FATAL_EXCEPTION_DATA_MASK (0xFFFFFF << CS_FATAL_EXCEPTION_DATA_SHIFT)
#define CS_FATAL_EXCEPTION_DATA_GET(reg_val) (((reg_val)&CS_FATAL_EXCEPTION_DATA_MASK) >> CS_FATAL_EXCEPTION_DATA_SHIFT)
#define CS_FATAL_EXCEPTION_DATA_SET(reg_val, value) \
	(((reg_val) & ~CS_FATAL_EXCEPTION_DATA_MASK) |  \
	 (((value) << CS_FATAL_EXCEPTION_DATA_SHIFT) & CS_FATAL_EXCEPTION_DATA_MASK))

/* CS_FAULT_INFO register */
#define CS_FAULT_INFO_EXCEPTION_DATA_SHIFT 0
#define CS_FAULT_INFO_EXCEPTION_DATA_MASK                                                          \
	(GPU_ULL(0xFFFFFFFFFFFFFFFF) << CS_FAULT_INFO_EXCEPTION_DATA_SHIFT)
#define CS_FAULT_INFO_EXCEPTION_DATA_GET(reg_val) \
	(((reg_val)&CS_FAULT_INFO_EXCEPTION_DATA_MASK) >> CS_FAULT_INFO_EXCEPTION_DATA_SHIFT)
#define CS_FAULT_INFO_EXCEPTION_DATA_SET(reg_val, value) \
	(((reg_val) & ~CS_FAULT_INFO_EXCEPTION_DATA_MASK) |  \
	 (((value) << CS_FAULT_INFO_EXCEPTION_DATA_SHIFT) & CS_FAULT_INFO_EXCEPTION_DATA_MASK))

/* CS_FATAL_INFO register */
#define CS_FATAL_INFO_EXCEPTION_DATA_SHIFT 0
#define CS_FATAL_INFO_EXCEPTION_DATA_MASK                                                          \
	(GPU_ULL(0xFFFFFFFFFFFFFFFF) << CS_FATAL_INFO_EXCEPTION_DATA_SHIFT)
#define CS_FATAL_INFO_EXCEPTION_DATA_GET(reg_val) \
	(((reg_val)&CS_FATAL_INFO_EXCEPTION_DATA_MASK) >> CS_FATAL_INFO_EXCEPTION_DATA_SHIFT)
#define CS_FATAL_INFO_EXCEPTION_DATA_SET(reg_val, value) \
	(((reg_val) & ~CS_FATAL_INFO_EXCEPTION_DATA_MASK) |  \
	 (((value) << CS_FATAL_INFO_EXCEPTION_DATA_SHIFT) & CS_FATAL_INFO_EXCEPTION_DATA_MASK))

/* CS_HEAP_VT_START register */
#define CS_HEAP_VT_START_VALUE_SHIFT 0
#define CS_HEAP_VT_START_VALUE_MASK (0xFFFFFFFF << CS_HEAP_VT_START_VALUE_SHIFT)
#define CS_HEAP_VT_START_VALUE_GET(reg_val) (((reg_val)&CS_HEAP_VT_START_VALUE_MASK) >> CS_HEAP_VT_START_VALUE_SHIFT)
#define CS_HEAP_VT_START_VALUE_SET(reg_val, value) \
	(((reg_val) & ~CS_HEAP_VT_START_VALUE_MASK) |  \
	 (((value) << CS_HEAP_VT_START_VALUE_SHIFT) & CS_HEAP_VT_START_VALUE_MASK))

/* CS_HEAP_VT_END register */
#define CS_HEAP_VT_END_VALUE_SHIFT 0
#define CS_HEAP_VT_END_VALUE_MASK (0xFFFFFFFF << CS_HEAP_VT_END_VALUE_SHIFT)
#define CS_HEAP_VT_END_VALUE_GET(reg_val) (((reg_val)&CS_HEAP_VT_END_VALUE_MASK) >> CS_HEAP_VT_END_VALUE_SHIFT)
#define CS_HEAP_VT_END_VALUE_SET(reg_val, value) \
	(((reg_val) & ~CS_HEAP_VT_END_VALUE_MASK) | (((value) << CS_HEAP_VT_END_VALUE_SHIFT) & CS_HEAP_VT_END_VALUE_MASK))

/* CS_HEAP_FRAG_END register */
#define CS_HEAP_FRAG_END_VALUE_SHIFT 0
#define CS_HEAP_FRAG_END_VALUE_MASK (0xFFFFFFFF << CS_HEAP_FRAG_END_VALUE_SHIFT)
#define CS_HEAP_FRAG_END_VALUE_GET(reg_val) (((reg_val)&CS_HEAP_FRAG_END_VALUE_MASK) >> CS_HEAP_FRAG_END_VALUE_SHIFT)
#define CS_HEAP_FRAG_END_VALUE_SET(reg_val, value) \
	(((reg_val) & ~CS_HEAP_FRAG_END_VALUE_MASK) |  \
	 (((value) << CS_HEAP_FRAG_END_VALUE_SHIFT) & CS_HEAP_FRAG_END_VALUE_MASK))

/* CS_HEAP_ADDRESS register */
#define CS_HEAP_ADDRESS_POINTER_SHIFT 0
#define CS_HEAP_ADDRESS_POINTER_MASK (GPU_ULL(0xFFFFFFFFFFFFFFFF) << CS_HEAP_ADDRESS_POINTER_SHIFT)
#define CS_HEAP_ADDRESS_POINTER_GET(reg_val) (((reg_val)&CS_HEAP_ADDRESS_POINTER_MASK) >> CS_HEAP_ADDRESS_POINTER_SHIFT)
#define CS_HEAP_ADDRESS_POINTER_SET(reg_val, value) \
	(((reg_val) & ~CS_HEAP_ADDRESS_POINTER_MASK) |  \
	 (((value) << CS_HEAP_ADDRESS_POINTER_SHIFT) & CS_HEAP_ADDRESS_POINTER_MASK))
/* End of CS_KERNEL_OUTPUT_BLOCK register set definitions */

/* CS_USER_INPUT_BLOCK register set definitions */

/* CS_INSERT register */
#define CS_INSERT_VALUE_SHIFT 0
#define CS_INSERT_VALUE_MASK (GPU_ULL(0xFFFFFFFFFFFFFFFF) << CS_INSERT_VALUE_SHIFT)
#define CS_INSERT_VALUE_GET(reg_val) (((reg_val)&CS_INSERT_VALUE_MASK) >> CS_INSERT_VALUE_SHIFT)
#define CS_INSERT_VALUE_SET(reg_val, value) \
	(((reg_val) & ~CS_INSERT_VALUE_MASK) | (((value) << CS_INSERT_VALUE_SHIFT) & CS_INSERT_VALUE_MASK))

/* CS_EXTRACT_INIT register */
#define CS_EXTRACT_INIT_VALUE_SHIFT 0
#define CS_EXTRACT_INIT_VALUE_MASK (GPU_ULL(0xFFFFFFFFFFFFFFFF) << CS_EXTRACT_INIT_VALUE_SHIFT)
#define CS_EXTRACT_INIT_VALUE_GET(reg_val) (((reg_val)&CS_EXTRACT_INIT_VALUE_MASK) >> CS_EXTRACT_INIT_VALUE_SHIFT)
#define CS_EXTRACT_INIT_VALUE_SET(reg_val, value) \
	(((reg_val) & ~CS_EXTRACT_INIT_VALUE_MASK) |  \
	 (((value) << CS_EXTRACT_INIT_VALUE_SHIFT) & CS_EXTRACT_INIT_VALUE_MASK))
/* End of CS_USER_INPUT_BLOCK register set definitions */

/* CS_USER_OUTPUT_BLOCK register set definitions */

/* CS_EXTRACT register */
#define CS_EXTRACT_VALUE_SHIFT 0
#define CS_EXTRACT_VALUE_MASK (GPU_ULL(0xFFFFFFFFFFFFFFFF) << CS_EXTRACT_VALUE_SHIFT)
#define CS_EXTRACT_VALUE_GET(reg_val) (((reg_val)&CS_EXTRACT_VALUE_MASK) >> CS_EXTRACT_VALUE_SHIFT)
#define CS_EXTRACT_VALUE_SET(reg_val, value) \
	(((reg_val) & ~CS_EXTRACT_VALUE_MASK) | (((value) << CS_EXTRACT_VALUE_SHIFT) & CS_EXTRACT_VALUE_MASK))

/* CS_ACTIVE register */
#define CS_ACTIVE_HW_ACTIVE_SHIFT 0
#define CS_ACTIVE_HW_ACTIVE_MASK (0x1 << CS_ACTIVE_HW_ACTIVE_SHIFT)
#define CS_ACTIVE_HW_ACTIVE_GET(reg_val) (((reg_val)&CS_ACTIVE_HW_ACTIVE_MASK) >> CS_ACTIVE_HW_ACTIVE_SHIFT)
#define CS_ACTIVE_HW_ACTIVE_SET(reg_val, value) \
	(((reg_val) & ~CS_ACTIVE_HW_ACTIVE_MASK) | (((value) << CS_ACTIVE_HW_ACTIVE_SHIFT) & CS_ACTIVE_HW_ACTIVE_MASK))
/* End of CS_USER_OUTPUT_BLOCK register set definitions */

/* CSG_INPUT_BLOCK register set definitions */

/* CSG_REQ register */
#define CSG_REQ_STATE_SHIFT 0
#define CSG_REQ_STATE_MASK (0x7 << CSG_REQ_STATE_SHIFT)
#define CSG_REQ_STATE_GET(reg_val) (((reg_val)&CSG_REQ_STATE_MASK) >> CSG_REQ_STATE_SHIFT)
#define CSG_REQ_STATE_SET(reg_val, value) \
	(((reg_val) & ~CSG_REQ_STATE_MASK) | (((value) << CSG_REQ_STATE_SHIFT) & CSG_REQ_STATE_MASK))
/* CSG_REQ_STATE values */
#define CSG_REQ_STATE_TERMINATE 0x0
#define CSG_REQ_STATE_START 0x1
#define CSG_REQ_STATE_SUSPEND 0x2
#define CSG_REQ_STATE_RESUME 0x3
/* End of CSG_REQ_STATE values */
#define CSG_REQ_EP_CFG_SHIFT 4
#define CSG_REQ_EP_CFG_MASK (0x1 << CSG_REQ_EP_CFG_SHIFT)
#define CSG_REQ_EP_CFG_GET(reg_val) (((reg_val)&CSG_REQ_EP_CFG_MASK) >> CSG_REQ_EP_CFG_SHIFT)
#define CSG_REQ_EP_CFG_SET(reg_val, value) \
	(((reg_val) & ~CSG_REQ_EP_CFG_MASK) | (((value) << CSG_REQ_EP_CFG_SHIFT) & CSG_REQ_EP_CFG_MASK))
#define CSG_REQ_STATUS_UPDATE_SHIFT 5
#define CSG_REQ_STATUS_UPDATE_MASK (0x1 << CSG_REQ_STATUS_UPDATE_SHIFT)
#define CSG_REQ_STATUS_UPDATE_GET(reg_val) (((reg_val)&CSG_REQ_STATUS_UPDATE_MASK) >> CSG_REQ_STATUS_UPDATE_SHIFT)
#define CSG_REQ_STATUS_UPDATE_SET(reg_val, value) \
	(((reg_val) & ~CSG_REQ_STATUS_UPDATE_MASK) |  \
	 (((value) << CSG_REQ_STATUS_UPDATE_SHIFT) & CSG_REQ_STATUS_UPDATE_MASK))
#define CSG_REQ_SYNC_UPDATE_SHIFT 28
#define CSG_REQ_SYNC_UPDATE_MASK (0x1 << CSG_REQ_SYNC_UPDATE_SHIFT)
#define CSG_REQ_SYNC_UPDATE_GET(reg_val) (((reg_val)&CSG_REQ_SYNC_UPDATE_MASK) >> CSG_REQ_SYNC_UPDATE_SHIFT)
#define CSG_REQ_SYNC_UPDATE_SET(reg_val, value) \
	(((reg_val) & ~CSG_REQ_SYNC_UPDATE_MASK) | (((value) << CSG_REQ_SYNC_UPDATE_SHIFT) & CSG_REQ_SYNC_UPDATE_MASK))
#define CSG_REQ_IDLE_SHIFT 29
#define CSG_REQ_IDLE_MASK (0x1 << CSG_REQ_IDLE_SHIFT)
#define CSG_REQ_IDLE_GET(reg_val) (((reg_val)&CSG_REQ_IDLE_MASK) >> CSG_REQ_IDLE_SHIFT)
#define CSG_REQ_IDLE_SET(reg_val, value) \
	(((reg_val) & ~CSG_REQ_IDLE_MASK) | (((value) << CSG_REQ_IDLE_SHIFT) & CSG_REQ_IDLE_MASK))
#define CSG_REQ_PROGRESS_TIMER_EVENT_SHIFT 31
#define CSG_REQ_PROGRESS_TIMER_EVENT_MASK (0x1 << CSG_REQ_PROGRESS_TIMER_EVENT_SHIFT)
#define CSG_REQ_PROGRESS_TIMER_EVENT_GET(reg_val) \
	(((reg_val)&CSG_REQ_PROGRESS_TIMER_EVENT_MASK) >> CSG_REQ_PROGRESS_TIMER_EVENT_SHIFT)
#define CSG_REQ_PROGRESS_TIMER_EVENT_SET(reg_val, value) \
	(((reg_val) & ~CSG_REQ_PROGRESS_TIMER_EVENT_MASK) |  \
	 (((value) << CSG_REQ_PROGRESS_TIMER_EVENT_SHIFT) & CSG_REQ_PROGRESS_TIMER_EVENT_MASK))

/* CSG_ACK_IRQ_MASK register */
#define CSG_ACK_IRQ_MASK_STATE_SHIFT 0
#define CSG_ACK_IRQ_MASK_STATE_MASK (0x7 << CSG_ACK_IRQ_MASK_STATE_SHIFT)
#define CSG_ACK_IRQ_MASK_STATE_GET(reg_val) (((reg_val)&CSG_ACK_IRQ_MASK_STATE_MASK) >> CSG_ACK_IRQ_MASK_STATE_SHIFT)
#define CSG_ACK_IRQ_MASK_STATE_SET(reg_val, value) \
	(((reg_val) & ~CSG_ACK_IRQ_MASK_STATE_MASK) |  \
	 (((value) << CSG_ACK_IRQ_MASK_STATE_SHIFT) & CSG_ACK_IRQ_MASK_STATE_MASK))
/* CSG_ACK_IRQ_MASK_STATE values */
#define CSG_ACK_IRQ_MASK_STATE_DISABLED 0x0
#define CSG_ACK_IRQ_MASK_STATE_ENABLED 0x7
/* End of CSG_ACK_IRQ_MASK_STATE values */
#define CSG_ACK_IRQ_MASK_EP_CFG_SHIFT 4
#define CSG_ACK_IRQ_MASK_EP_CFG_MASK (0x1 << CSG_ACK_IRQ_MASK_EP_CFG_SHIFT)
#define CSG_ACK_IRQ_MASK_EP_CFG_GET(reg_val) (((reg_val)&CSG_ACK_IRQ_MASK_EP_CFG_MASK) >> CSG_ACK_IRQ_MASK_EP_CFG_SHIFT)
#define CSG_ACK_IRQ_MASK_EP_CFG_SET(reg_val, value) \
	(((reg_val) & ~CSG_ACK_IRQ_MASK_EP_CFG_MASK) |  \
	 (((value) << CSG_ACK_IRQ_MASK_EP_CFG_SHIFT) & CSG_ACK_IRQ_MASK_EP_CFG_MASK))
#define CSG_ACK_IRQ_MASK_STATUS_UPDATE_SHIFT 5
#define CSG_ACK_IRQ_MASK_STATUS_UPDATE_MASK (0x1 << CSG_ACK_IRQ_MASK_STATUS_UPDATE_SHIFT)
#define CSG_ACK_IRQ_MASK_STATUS_UPDATE_GET(reg_val) \
	(((reg_val)&CSG_ACK_IRQ_MASK_STATUS_UPDATE_MASK) >> CSG_ACK_IRQ_MASK_STATUS_UPDATE_SHIFT)
#define CSG_ACK_IRQ_MASK_STATUS_UPDATE_SET(reg_val, value) \
	(((reg_val) & ~CSG_ACK_IRQ_MASK_STATUS_UPDATE_MASK) |  \
	 (((value) << CSG_ACK_IRQ_MASK_STATUS_UPDATE_SHIFT) & CSG_ACK_IRQ_MASK_STATUS_UPDATE_MASK))
#define CSG_ACK_IRQ_MASK_SYNC_UPDATE_SHIFT 28
#define CSG_ACK_IRQ_MASK_SYNC_UPDATE_MASK (0x1 << CSG_ACK_IRQ_MASK_SYNC_UPDATE_SHIFT)
#define CSG_ACK_IRQ_MASK_SYNC_UPDATE_GET(reg_val) \
	(((reg_val)&CSG_ACK_IRQ_MASK_SYNC_UPDATE_MASK) >> CSG_ACK_IRQ_MASK_SYNC_UPDATE_SHIFT)
#define CSG_ACK_IRQ_MASK_SYNC_UPDATE_SET(reg_val, value) \
	(((reg_val) & ~CSG_ACK_IRQ_MASK_SYNC_UPDATE_MASK) |  \
	 (((value) << CSG_ACK_IRQ_MASK_SYNC_UPDATE_SHIFT) & CSG_ACK_IRQ_MASK_SYNC_UPDATE_MASK))
#define CSG_ACK_IRQ_MASK_IDLE_SHIFT 29
#define CSG_ACK_IRQ_MASK_IDLE_MASK (0x1 << CSG_ACK_IRQ_MASK_IDLE_SHIFT)
#define CSG_ACK_IRQ_MASK_IDLE_GET(reg_val) (((reg_val)&CSG_ACK_IRQ_MASK_IDLE_MASK) >> CSG_ACK_IRQ_MASK_IDLE_SHIFT)
#define CSG_ACK_IRQ_MASK_IDLE_SET(reg_val, value) \
	(((reg_val) & ~CSG_ACK_IRQ_MASK_IDLE_MASK) |  \
	 (((value) << CSG_ACK_IRQ_MASK_IDLE_SHIFT) & CSG_ACK_IRQ_MASK_IDLE_MASK))
#define CSG_ACK_IRQ_MASK_DOORBELL_SHIFT 30
#define CSG_ACK_IRQ_MASK_DOORBELL_MASK (0x1 << CSG_ACK_IRQ_MASK_DOORBELL_SHIFT)
#define CSG_ACK_IRQ_MASK_DOORBELL_GET(reg_val) \
	(((reg_val)&CSG_ACK_IRQ_MASK_DOORBELL_MASK) >> CSG_ACK_IRQ_MASK_DOORBELL_SHIFT)
#define CSG_ACK_IRQ_MASK_DOORBELL_SET(reg_val, value) \
	(((reg_val) & ~CSG_ACK_IRQ_MASK_DOORBELL_MASK) |  \
	 (((value) << CSG_ACK_IRQ_MASK_DOORBELL_SHIFT) & CSG_ACK_IRQ_MASK_DOORBELL_MASK))
#define CSG_ACK_IRQ_MASK_PROGRESS_TIMER_EVENT_SHIFT 31
#define CSG_ACK_IRQ_MASK_PROGRESS_TIMER_EVENT_MASK (0x1 << CSG_ACK_IRQ_MASK_PROGRESS_TIMER_EVENT_SHIFT)
#define CSG_ACK_IRQ_MASK_PROGRESS_TIMER_EVENT_GET(reg_val) \
	(((reg_val)&CSG_ACK_IRQ_MASK_PROGRESS_TIMER_EVENT_MASK) >> CSG_ACK_IRQ_MASK_PROGRESS_TIMER_EVENT_SHIFT)
#define CSG_ACK_IRQ_MASK_PROGRESS_TIMER_EVENT_SET(reg_val, value) \
	(((reg_val) & ~CSG_ACK_IRQ_MASK_PROGRESS_TIMER_EVENT_MASK) |  \
	 (((value) << CSG_ACK_IRQ_MASK_PROGRESS_TIMER_EVENT_SHIFT) & CSG_ACK_IRQ_MASK_PROGRESS_TIMER_EVENT_MASK))

/* CSG_EP_REQ register */
#define CSG_EP_REQ_COMPUTE_EP_SHIFT 0
#define CSG_EP_REQ_COMPUTE_EP_MASK (0xFF << CSG_EP_REQ_COMPUTE_EP_SHIFT)
#define CSG_EP_REQ_COMPUTE_EP_GET(reg_val) (((reg_val)&CSG_EP_REQ_COMPUTE_EP_MASK) >> CSG_EP_REQ_COMPUTE_EP_SHIFT)
#define CSG_EP_REQ_COMPUTE_EP_SET(reg_val, value) \
	(((reg_val) & ~CSG_EP_REQ_COMPUTE_EP_MASK) |  \
	 (((value) << CSG_EP_REQ_COMPUTE_EP_SHIFT) & CSG_EP_REQ_COMPUTE_EP_MASK))
#define CSG_EP_REQ_FRAGMENT_EP_SHIFT 8
#define CSG_EP_REQ_FRAGMENT_EP_MASK (0xFF << CSG_EP_REQ_FRAGMENT_EP_SHIFT)
#define CSG_EP_REQ_FRAGMENT_EP_GET(reg_val) (((reg_val)&CSG_EP_REQ_FRAGMENT_EP_MASK) >> CSG_EP_REQ_FRAGMENT_EP_SHIFT)
#define CSG_EP_REQ_FRAGMENT_EP_SET(reg_val, value) \
	(((reg_val) & ~CSG_EP_REQ_FRAGMENT_EP_MASK) |  \
	 (((value) << CSG_EP_REQ_FRAGMENT_EP_SHIFT) & CSG_EP_REQ_FRAGMENT_EP_MASK))
#define CSG_EP_REQ_TILER_EP_SHIFT 16
#define CSG_EP_REQ_TILER_EP_MASK (0xF << CSG_EP_REQ_TILER_EP_SHIFT)
#define CSG_EP_REQ_TILER_EP_GET(reg_val) (((reg_val)&CSG_EP_REQ_TILER_EP_MASK) >> CSG_EP_REQ_TILER_EP_SHIFT)
#define CSG_EP_REQ_TILER_EP_SET(reg_val, value) \
	(((reg_val) & ~CSG_EP_REQ_TILER_EP_MASK) | (((value) << CSG_EP_REQ_TILER_EP_SHIFT) & CSG_EP_REQ_TILER_EP_MASK))
#define CSG_EP_REQ_EXCLUSIVE_COMPUTE_SHIFT 20
#define CSG_EP_REQ_EXCLUSIVE_COMPUTE_MASK (0x1 << CSG_EP_REQ_EXCLUSIVE_COMPUTE_SHIFT)
#define CSG_EP_REQ_EXCLUSIVE_COMPUTE_GET(reg_val) \
	(((reg_val)&CSG_EP_REQ_EXCLUSIVE_COMPUTE_MASK) >> CSG_EP_REQ_EXCLUSIVE_COMPUTE_SHIFT)
#define CSG_EP_REQ_EXCLUSIVE_COMPUTE_SET(reg_val, value) \
	(((reg_val) & ~CSG_EP_REQ_EXCLUSIVE_COMPUTE_MASK) |  \
	 (((value) << CSG_EP_REQ_EXCLUSIVE_COMPUTE_SHIFT) & CSG_EP_REQ_EXCLUSIVE_COMPUTE_MASK))
#define CSG_EP_REQ_EXCLUSIVE_FRAGMENT_SHIFT 21
#define CSG_EP_REQ_EXCLUSIVE_FRAGMENT_MASK (0x1 << CSG_EP_REQ_EXCLUSIVE_FRAGMENT_SHIFT)
#define CSG_EP_REQ_EXCLUSIVE_FRAGMENT_GET(reg_val) \
	(((reg_val)&CSG_EP_REQ_EXCLUSIVE_FRAGMENT_MASK) >> CSG_EP_REQ_EXCLUSIVE_FRAGMENT_SHIFT)
#define CSG_EP_REQ_EXCLUSIVE_FRAGMENT_SET(reg_val, value) \
	(((reg_val) & ~CSG_EP_REQ_EXCLUSIVE_FRAGMENT_MASK) |  \
	 (((value) << CSG_EP_REQ_EXCLUSIVE_FRAGMENT_SHIFT) & CSG_EP_REQ_EXCLUSIVE_FRAGMENT_MASK))
#define CSG_EP_REQ_PRIORITY_SHIFT 28
#define CSG_EP_REQ_PRIORITY_MASK (0xF << CSG_EP_REQ_PRIORITY_SHIFT)
#define CSG_EP_REQ_PRIORITY_GET(reg_val) (((reg_val)&CSG_EP_REQ_PRIORITY_MASK) >> CSG_EP_REQ_PRIORITY_SHIFT)
#define CSG_EP_REQ_PRIORITY_SET(reg_val, value) \
	(((reg_val) & ~CSG_EP_REQ_PRIORITY_MASK) | (((value) << CSG_EP_REQ_PRIORITY_SHIFT) & CSG_EP_REQ_PRIORITY_MASK))

/* CSG_SUSPEND_BUF register */
#define CSG_SUSPEND_BUF_POINTER_SHIFT 0
#define CSG_SUSPEND_BUF_POINTER_MASK (GPU_ULL(0xFFFFFFFFFFFFFFFF) << CSG_SUSPEND_BUF_POINTER_SHIFT)
#define CSG_SUSPEND_BUF_POINTER_GET(reg_val) (((reg_val)&CSG_SUSPEND_BUF_POINTER_MASK) >> CSG_SUSPEND_BUF_POINTER_SHIFT)
#define CSG_SUSPEND_BUF_POINTER_SET(reg_val, value) \
	(((reg_val) & ~CSG_SUSPEND_BUF_POINTER_MASK) |  \
	 (((value) << CSG_SUSPEND_BUF_POINTER_SHIFT) & CSG_SUSPEND_BUF_POINTER_MASK))

/* CSG_PROTM_SUSPEND_BUF register */
#define CSG_PROTM_SUSPEND_BUF_POINTER_SHIFT 0
#define CSG_PROTM_SUSPEND_BUF_POINTER_MASK                                                         \
	(GPU_ULL(0xFFFFFFFFFFFFFFFF) << CSG_PROTM_SUSPEND_BUF_POINTER_SHIFT)
#define CSG_PROTM_SUSPEND_BUF_POINTER_GET(reg_val) \
	(((reg_val)&CSG_PROTM_SUSPEND_BUF_POINTER_MASK) >> CSG_PROTM_SUSPEND_BUF_POINTER_SHIFT)
#define CSG_PROTM_SUSPEND_BUF_POINTER_SET(reg_val, value) \
	(((reg_val) & ~CSG_PROTM_SUSPEND_BUF_POINTER_MASK) |  \
	 (((value) << CSG_PROTM_SUSPEND_BUF_POINTER_SHIFT) & CSG_PROTM_SUSPEND_BUF_POINTER_MASK))

/* CSG_DVS_BUF_BUFFER register */
#define CSG_DVS_BUF_BUFFER_SIZE_SHIFT GPU_U(0)
#define CSG_DVS_BUF_BUFFER_SIZE_MASK (GPU_U(0xFFF) << CSG_DVS_BUF_BUFFER_SIZE_SHIFT)
#define CSG_DVS_BUF_BUFFER_SIZE_GET(reg_val) (((reg_val)&CSG_DVS_BUF_BUFFER_SIZE_MASK) >> CSG_DVS_BUF_BUFFER_SIZE_SHIFT)
#define CSG_DVS_BUF_BUFFER_SIZE_SET(reg_val, value) \
	(((reg_val) & ~CSG_DVS_BUF_BUFFER_SIZE_MASK) |  \
	 (((value) << CSG_DVS_BUF_BUFFER_SIZE_SHIFT) & CSG_DVS_BUF_BUFFER_SIZE_MASK))
#define CSG_DVS_BUF_BUFFER_POINTER_SHIFT GPU_U(12)
#define CSG_DVS_BUF_BUFFER_POINTER_MASK                                                            \
	(GPU_ULL(0xFFFFFFFFFFFFF) << CSG_DVS_BUF_BUFFER_POINTER_SHIFT)
#define CSG_DVS_BUF_BUFFER_POINTER_GET(reg_val) \
	(((reg_val)&CSG_DVS_BUF_BUFFER_POINTER_MASK) >> CSG_DVS_BUF_BUFFER_POINTER_SHIFT)
#define CSG_DVS_BUF_BUFFER_POINTER_SET(reg_val, value) \
	(((reg_val) & ~CSG_DVS_BUF_BUFFER_POINTER_MASK) |  \
	 (((value) << CSG_DVS_BUF_BUFFER_POINTER_SHIFT) & CSG_DVS_BUF_BUFFER_POINTER_MASK))

/* End of CSG_INPUT_BLOCK register set definitions */

/* CSG_OUTPUT_BLOCK register set definitions */

/* CSG_ACK register */
#define CSG_ACK_STATE_SHIFT 0
#define CSG_ACK_STATE_MASK (0x7 << CSG_ACK_STATE_SHIFT)
#define CSG_ACK_STATE_GET(reg_val) (((reg_val)&CSG_ACK_STATE_MASK) >> CSG_ACK_STATE_SHIFT)
#define CSG_ACK_STATE_SET(reg_val, value) \
	(((reg_val) & ~CSG_ACK_STATE_MASK) | (((value) << CSG_ACK_STATE_SHIFT) & CSG_ACK_STATE_MASK))
/* CSG_ACK_STATE values */
#define CSG_ACK_STATE_TERMINATE 0x0
#define CSG_ACK_STATE_START 0x1
#define CSG_ACK_STATE_SUSPEND 0x2
#define CSG_ACK_STATE_RESUME 0x3
/* End of CSG_ACK_STATE values */
#define CSG_ACK_EP_CFG_SHIFT 4
#define CSG_ACK_EP_CFG_MASK (0x1 << CSG_ACK_EP_CFG_SHIFT)
#define CSG_ACK_EP_CFG_GET(reg_val) (((reg_val)&CSG_ACK_EP_CFG_MASK) >> CSG_ACK_EP_CFG_SHIFT)
#define CSG_ACK_EP_CFG_SET(reg_val, value) \
	(((reg_val) & ~CSG_ACK_EP_CFG_MASK) | (((value) << CSG_ACK_EP_CFG_SHIFT) & CSG_ACK_EP_CFG_MASK))
#define CSG_ACK_STATUS_UPDATE_SHIFT 5
#define CSG_ACK_STATUS_UPDATE_MASK (0x1 << CSG_ACK_STATUS_UPDATE_SHIFT)
#define CSG_ACK_STATUS_UPDATE_GET(reg_val) (((reg_val)&CSG_ACK_STATUS_UPDATE_MASK) >> CSG_ACK_STATUS_UPDATE_SHIFT)
#define CSG_ACK_STATUS_UPDATE_SET(reg_val, value) \
	(((reg_val) & ~CSG_ACK_STATUS_UPDATE_MASK) |  \
	 (((value) << CSG_ACK_STATUS_UPDATE_SHIFT) & CSG_ACK_STATUS_UPDATE_MASK))
#define CSG_ACK_SYNC_UPDATE_SHIFT 28
#define CSG_ACK_SYNC_UPDATE_MASK (0x1 << CSG_ACK_SYNC_UPDATE_SHIFT)
#define CSG_ACK_SYNC_UPDATE_GET(reg_val) (((reg_val)&CSG_ACK_SYNC_UPDATE_MASK) >> CSG_ACK_SYNC_UPDATE_SHIFT)
#define CSG_ACK_SYNC_UPDATE_SET(reg_val, value) \
	(((reg_val) & ~CSG_ACK_SYNC_UPDATE_MASK) | (((value) << CSG_ACK_SYNC_UPDATE_SHIFT) & CSG_ACK_SYNC_UPDATE_MASK))
#define CSG_ACK_IDLE_SHIFT 29
#define CSG_ACK_IDLE_MASK (0x1 << CSG_ACK_IDLE_SHIFT)
#define CSG_ACK_IDLE_GET(reg_val) (((reg_val)&CSG_ACK_IDLE_MASK) >> CSG_ACK_IDLE_SHIFT)
#define CSG_ACK_IDLE_SET(reg_val, value) \
	(((reg_val) & ~CSG_ACK_IDLE_MASK) | (((value) << CSG_ACK_IDLE_SHIFT) & CSG_ACK_IDLE_MASK))
#define CSG_ACK_DOORBELL_SHIFT 30
#define CSG_ACK_DOORBELL_MASK (0x1 << CSG_ACK_DOORBELL_SHIFT)
#define CSG_ACK_DOORBELL_GET(reg_val) (((reg_val)&CSG_ACK_DOORBELL_MASK) >> CSG_ACK_DOORBELL_SHIFT)
#define CSG_ACK_DOORBELL_SET(reg_val, value) \
	(((reg_val) & ~CSG_ACK_DOORBELL_MASK) | (((value) << CSG_ACK_DOORBELL_SHIFT) & CSG_ACK_DOORBELL_MASK))
#define CSG_ACK_PROGRESS_TIMER_EVENT_SHIFT 31
#define CSG_ACK_PROGRESS_TIMER_EVENT_MASK (0x1 << CSG_ACK_PROGRESS_TIMER_EVENT_SHIFT)
#define CSG_ACK_PROGRESS_TIMER_EVENT_GET(reg_val) \
	(((reg_val)&CSG_ACK_PROGRESS_TIMER_EVENT_MASK) >> CSG_ACK_PROGRESS_TIMER_EVENT_SHIFT)
#define CSG_ACK_PROGRESS_TIMER_EVENT_SET(reg_val, value) \
	(((reg_val) & ~CSG_ACK_PROGRESS_TIMER_EVENT_MASK) |  \
	 (((value) << CSG_ACK_PROGRESS_TIMER_EVENT_SHIFT) & CSG_ACK_PROGRESS_TIMER_EVENT_MASK))

/* CSG_STATUS_EP_CURRENT register */
#define CSG_STATUS_EP_CURRENT_COMPUTE_EP_SHIFT 0
#define CSG_STATUS_EP_CURRENT_COMPUTE_EP_MASK (0xFF << CSG_STATUS_EP_CURRENT_COMPUTE_EP_SHIFT)
#define CSG_STATUS_EP_CURRENT_COMPUTE_EP_GET(reg_val) \
	(((reg_val)&CSG_STATUS_EP_CURRENT_COMPUTE_EP_MASK) >> CSG_STATUS_EP_CURRENT_COMPUTE_EP_SHIFT)
#define CSG_STATUS_EP_CURRENT_COMPUTE_EP_SET(reg_val, value) \
	(((reg_val) & ~CSG_STATUS_EP_CURRENT_COMPUTE_EP_MASK) |  \
	 (((value) << CSG_STATUS_EP_CURRENT_COMPUTE_EP_SHIFT) & CSG_STATUS_EP_CURRENT_COMPUTE_EP_MASK))
#define CSG_STATUS_EP_CURRENT_FRAGMENT_EP_SHIFT 8
#define CSG_STATUS_EP_CURRENT_FRAGMENT_EP_MASK (0xFF << CSG_STATUS_EP_CURRENT_FRAGMENT_EP_SHIFT)
#define CSG_STATUS_EP_CURRENT_FRAGMENT_EP_GET(reg_val) \
	(((reg_val)&CSG_STATUS_EP_CURRENT_FRAGMENT_EP_MASK) >> CSG_STATUS_EP_CURRENT_FRAGMENT_EP_SHIFT)
#define CSG_STATUS_EP_CURRENT_FRAGMENT_EP_SET(reg_val, value) \
	(((reg_val) & ~CSG_STATUS_EP_CURRENT_FRAGMENT_EP_MASK) |  \
	 (((value) << CSG_STATUS_EP_CURRENT_FRAGMENT_EP_SHIFT) & CSG_STATUS_EP_CURRENT_FRAGMENT_EP_MASK))
#define CSG_STATUS_EP_CURRENT_TILER_EP_SHIFT 16
#define CSG_STATUS_EP_CURRENT_TILER_EP_MASK (0xF << CSG_STATUS_EP_CURRENT_TILER_EP_SHIFT)
#define CSG_STATUS_EP_CURRENT_TILER_EP_GET(reg_val) \
	(((reg_val)&CSG_STATUS_EP_CURRENT_TILER_EP_MASK) >> CSG_STATUS_EP_CURRENT_TILER_EP_SHIFT)
#define CSG_STATUS_EP_CURRENT_TILER_EP_SET(reg_val, value) \
	(((reg_val) & ~CSG_STATUS_EP_CURRENT_TILER_EP_MASK) |  \
	 (((value) << CSG_STATUS_EP_CURRENT_TILER_EP_SHIFT) & CSG_STATUS_EP_CURRENT_TILER_EP_MASK))

/* CSG_STATUS_EP_REQ register */
#define CSG_STATUS_EP_REQ_COMPUTE_EP_SHIFT 0
#define CSG_STATUS_EP_REQ_COMPUTE_EP_MASK (0xFF << CSG_STATUS_EP_REQ_COMPUTE_EP_SHIFT)
#define CSG_STATUS_EP_REQ_COMPUTE_EP_GET(reg_val) \
	(((reg_val)&CSG_STATUS_EP_REQ_COMPUTE_EP_MASK) >> CSG_STATUS_EP_REQ_COMPUTE_EP_SHIFT)
#define CSG_STATUS_EP_REQ_COMPUTE_EP_SET(reg_val, value) \
	(((reg_val) & ~CSG_STATUS_EP_REQ_COMPUTE_EP_MASK) |  \
	 (((value) << CSG_STATUS_EP_REQ_COMPUTE_EP_SHIFT) & CSG_STATUS_EP_REQ_COMPUTE_EP_MASK))
#define CSG_STATUS_EP_REQ_FRAGMENT_EP_SHIFT 8
#define CSG_STATUS_EP_REQ_FRAGMENT_EP_MASK (0xFF << CSG_STATUS_EP_REQ_FRAGMENT_EP_SHIFT)
#define CSG_STATUS_EP_REQ_FRAGMENT_EP_GET(reg_val) \
	(((reg_val)&CSG_STATUS_EP_REQ_FRAGMENT_EP_MASK) >> CSG_STATUS_EP_REQ_FRAGMENT_EP_SHIFT)
#define CSG_STATUS_EP_REQ_FRAGMENT_EP_SET(reg_val, value) \
	(((reg_val) & ~CSG_STATUS_EP_REQ_FRAGMENT_EP_MASK) |  \
	 (((value) << CSG_STATUS_EP_REQ_FRAGMENT_EP_SHIFT) & CSG_STATUS_EP_REQ_FRAGMENT_EP_MASK))
#define CSG_STATUS_EP_REQ_TILER_EP_SHIFT 16
#define CSG_STATUS_EP_REQ_TILER_EP_MASK (0xF << CSG_STATUS_EP_REQ_TILER_EP_SHIFT)
#define CSG_STATUS_EP_REQ_TILER_EP_GET(reg_val) \
	(((reg_val)&CSG_STATUS_EP_REQ_TILER_EP_MASK) >> CSG_STATUS_EP_REQ_TILER_EP_SHIFT)
#define CSG_STATUS_EP_REQ_TILER_EP_SET(reg_val, value) \
	(((reg_val) & ~CSG_STATUS_EP_REQ_TILER_EP_MASK) |  \
	 (((value) << CSG_STATUS_EP_REQ_TILER_EP_SHIFT) & CSG_STATUS_EP_REQ_TILER_EP_MASK))
#define CSG_STATUS_EP_REQ_EXCLUSIVE_COMPUTE_SHIFT 20
#define CSG_STATUS_EP_REQ_EXCLUSIVE_COMPUTE_MASK (0x1 << CSG_STATUS_EP_REQ_EXCLUSIVE_COMPUTE_SHIFT)
#define CSG_STATUS_EP_REQ_EXCLUSIVE_COMPUTE_GET(reg_val) \
	(((reg_val)&CSG_STATUS_EP_REQ_EXCLUSIVE_COMPUTE_MASK) >> CSG_STATUS_EP_REQ_EXCLUSIVE_COMPUTE_SHIFT)
#define CSG_STATUS_EP_REQ_EXCLUSIVE_COMPUTE_SET(reg_val, value) \
	(((reg_val) & ~CSG_STATUS_EP_REQ_EXCLUSIVE_COMPUTE_MASK) |  \
	 (((value) << CSG_STATUS_EP_REQ_EXCLUSIVE_COMPUTE_SHIFT) & CSG_STATUS_EP_REQ_EXCLUSIVE_COMPUTE_MASK))
#define CSG_STATUS_EP_REQ_EXCLUSIVE_FRAGMENT_SHIFT 21
#define CSG_STATUS_EP_REQ_EXCLUSIVE_FRAGMENT_MASK (0x1 << CSG_STATUS_EP_REQ_EXCLUSIVE_FRAGMENT_SHIFT)
#define CSG_STATUS_EP_REQ_EXCLUSIVE_FRAGMENT_GET(reg_val) \
	(((reg_val)&CSG_STATUS_EP_REQ_EXCLUSIVE_FRAGMENT_MASK) >> CSG_STATUS_EP_REQ_EXCLUSIVE_FRAGMENT_SHIFT)
#define CSG_STATUS_EP_REQ_EXCLUSIVE_FRAGMENT_SET(reg_val, value) \
	(((reg_val) & ~CSG_STATUS_EP_REQ_EXCLUSIVE_FRAGMENT_MASK) |  \
	 (((value) << CSG_STATUS_EP_REQ_EXCLUSIVE_FRAGMENT_SHIFT) & CSG_STATUS_EP_REQ_EXCLUSIVE_FRAGMENT_MASK))

/* End of CSG_OUTPUT_BLOCK register set definitions */

/* STREAM_CONTROL_BLOCK register set definitions */

/* STREAM_FEATURES register */
#define STREAM_FEATURES_WORK_REGISTERS_SHIFT 0
#define STREAM_FEATURES_WORK_REGISTERS_MASK (0xFF << STREAM_FEATURES_WORK_REGISTERS_SHIFT)
#define STREAM_FEATURES_WORK_REGISTERS_GET(reg_val) \
	(((reg_val)&STREAM_FEATURES_WORK_REGISTERS_MASK) >> STREAM_FEATURES_WORK_REGISTERS_SHIFT)
#define STREAM_FEATURES_WORK_REGISTERS_SET(reg_val, value) \
	(((reg_val) & ~STREAM_FEATURES_WORK_REGISTERS_MASK) |  \
	 (((value) << STREAM_FEATURES_WORK_REGISTERS_SHIFT) & STREAM_FEATURES_WORK_REGISTERS_MASK))
#define STREAM_FEATURES_SCOREBOARDS_SHIFT 8
#define STREAM_FEATURES_SCOREBOARDS_MASK (0xFF << STREAM_FEATURES_SCOREBOARDS_SHIFT)
#define STREAM_FEATURES_SCOREBOARDS_GET(reg_val) \
	(((reg_val)&STREAM_FEATURES_SCOREBOARDS_MASK) >> STREAM_FEATURES_SCOREBOARDS_SHIFT)
#define STREAM_FEATURES_SCOREBOARDS_SET(reg_val, value) \
	(((reg_val) & ~STREAM_FEATURES_SCOREBOARDS_MASK) |  \
	 (((value) << STREAM_FEATURES_SCOREBOARDS_SHIFT) & STREAM_FEATURES_SCOREBOARDS_MASK))
#define STREAM_FEATURES_COMPUTE_SHIFT 16
#define STREAM_FEATURES_COMPUTE_MASK (0x1 << STREAM_FEATURES_COMPUTE_SHIFT)
#define STREAM_FEATURES_COMPUTE_GET(reg_val) (((reg_val)&STREAM_FEATURES_COMPUTE_MASK) >> STREAM_FEATURES_COMPUTE_SHIFT)
#define STREAM_FEATURES_COMPUTE_SET(reg_val, value) \
	(((reg_val) & ~STREAM_FEATURES_COMPUTE_MASK) |  \
	 (((value) << STREAM_FEATURES_COMPUTE_SHIFT) & STREAM_FEATURES_COMPUTE_MASK))
#define STREAM_FEATURES_FRAGMENT_SHIFT 17
#define STREAM_FEATURES_FRAGMENT_MASK (0x1 << STREAM_FEATURES_FRAGMENT_SHIFT)
#define STREAM_FEATURES_FRAGMENT_GET(reg_val) \
	(((reg_val)&STREAM_FEATURES_FRAGMENT_MASK) >> STREAM_FEATURES_FRAGMENT_SHIFT)
#define STREAM_FEATURES_FRAGMENT_SET(reg_val, value) \
	(((reg_val) & ~STREAM_FEATURES_FRAGMENT_MASK) |  \
	 (((value) << STREAM_FEATURES_FRAGMENT_SHIFT) & STREAM_FEATURES_FRAGMENT_MASK))
#define STREAM_FEATURES_TILER_SHIFT 18
#define STREAM_FEATURES_TILER_MASK (0x1 << STREAM_FEATURES_TILER_SHIFT)
#define STREAM_FEATURES_TILER_GET(reg_val) (((reg_val)&STREAM_FEATURES_TILER_MASK) >> STREAM_FEATURES_TILER_SHIFT)
#define STREAM_FEATURES_TILER_SET(reg_val, value) \
	(((reg_val) & ~STREAM_FEATURES_TILER_MASK) |  \
	 (((value) << STREAM_FEATURES_TILER_SHIFT) & STREAM_FEATURES_TILER_MASK))

/* STREAM_INPUT_VA register */
#define STREAM_INPUT_VA_VALUE_SHIFT 0
#define STREAM_INPUT_VA_VALUE_MASK (0xFFFFFFFF << STREAM_INPUT_VA_VALUE_SHIFT)
#define STREAM_INPUT_VA_VALUE_GET(reg_val) (((reg_val)&STREAM_INPUT_VA_VALUE_MASK) >> STREAM_INPUT_VA_VALUE_SHIFT)
#define STREAM_INPUT_VA_VALUE_SET(reg_val, value) \
	(((reg_val) & ~STREAM_INPUT_VA_VALUE_MASK) |  \
	 (((value) << STREAM_INPUT_VA_VALUE_SHIFT) & STREAM_INPUT_VA_VALUE_MASK))

/* STREAM_OUTPUT_VA register */
#define STREAM_OUTPUT_VA_VALUE_SHIFT 0
#define STREAM_OUTPUT_VA_VALUE_MASK (0xFFFFFFFF << STREAM_OUTPUT_VA_VALUE_SHIFT)
#define STREAM_OUTPUT_VA_VALUE_GET(reg_val) (((reg_val)&STREAM_OUTPUT_VA_VALUE_MASK) >> STREAM_OUTPUT_VA_VALUE_SHIFT)
#define STREAM_OUTPUT_VA_VALUE_SET(reg_val, value) \
	(((reg_val) & ~STREAM_OUTPUT_VA_VALUE_MASK) |  \
	 (((value) << STREAM_OUTPUT_VA_VALUE_SHIFT) & STREAM_OUTPUT_VA_VALUE_MASK))
/* End of STREAM_CONTROL_BLOCK register set definitions */

/* GLB_INPUT_BLOCK register set definitions */

/* GLB_REQ register */
#define GLB_REQ_HALT_SHIFT 0
#define GLB_REQ_HALT_MASK (0x1 << GLB_REQ_HALT_SHIFT)
#define GLB_REQ_HALT_GET(reg_val) (((reg_val)&GLB_REQ_HALT_MASK) >> GLB_REQ_HALT_SHIFT)
#define GLB_REQ_HALT_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_HALT_MASK) | (((value) << GLB_REQ_HALT_SHIFT) & GLB_REQ_HALT_MASK))
#define GLB_REQ_CFG_PROGRESS_TIMER_SHIFT 1
#define GLB_REQ_CFG_PROGRESS_TIMER_MASK (0x1 << GLB_REQ_CFG_PROGRESS_TIMER_SHIFT)
#define GLB_REQ_CFG_PROGRESS_TIMER_GET(reg_val) \
	(((reg_val)&GLB_REQ_CFG_PROGRESS_TIMER_MASK) >> GLB_REQ_CFG_PROGRESS_TIMER_SHIFT)
#define GLB_REQ_CFG_PROGRESS_TIMER_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_CFG_PROGRESS_TIMER_MASK) |  \
	 (((value) << GLB_REQ_CFG_PROGRESS_TIMER_SHIFT) & GLB_REQ_CFG_PROGRESS_TIMER_MASK))
#define GLB_REQ_CFG_ALLOC_EN_SHIFT 2
#define GLB_REQ_CFG_ALLOC_EN_MASK (0x1 << GLB_REQ_CFG_ALLOC_EN_SHIFT)
#define GLB_REQ_CFG_ALLOC_EN_GET(reg_val) (((reg_val)&GLB_REQ_CFG_ALLOC_EN_MASK) >> GLB_REQ_CFG_ALLOC_EN_SHIFT)
#define GLB_REQ_CFG_ALLOC_EN_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_CFG_ALLOC_EN_MASK) | (((value) << GLB_REQ_CFG_ALLOC_EN_SHIFT) & GLB_REQ_CFG_ALLOC_EN_MASK))
#define GLB_REQ_CFG_PWROFF_TIMER_SHIFT 3
#define GLB_REQ_CFG_PWROFF_TIMER_MASK (0x1 << GLB_REQ_CFG_PWROFF_TIMER_SHIFT)
#define GLB_REQ_CFG_PWROFF_TIMER_GET(reg_val) \
	(((reg_val)&GLB_REQ_CFG_PWROFF_TIMER_MASK) >> GLB_REQ_CFG_PWROFF_TIMER_SHIFT)
#define GLB_REQ_CFG_PWROFF_TIMER_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_CFG_PWROFF_TIMER_MASK) |  \
	 (((value) << GLB_REQ_CFG_PWROFF_TIMER_SHIFT) & GLB_REQ_CFG_PWROFF_TIMER_MASK))
#define GLB_REQ_PROTM_ENTER_SHIFT 4
#define GLB_REQ_PROTM_ENTER_MASK (0x1 << GLB_REQ_PROTM_ENTER_SHIFT)
#define GLB_REQ_PROTM_ENTER_GET(reg_val) (((reg_val)&GLB_REQ_PROTM_ENTER_MASK) >> GLB_REQ_PROTM_ENTER_SHIFT)
#define GLB_REQ_PROTM_ENTER_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_PROTM_ENTER_MASK) | (((value) << GLB_REQ_PROTM_ENTER_SHIFT) & GLB_REQ_PROTM_ENTER_MASK))
#define GLB_REQ_PRFCNT_ENABLE_SHIFT 5
#define GLB_REQ_PRFCNT_ENABLE_MASK (0x1 << GLB_REQ_PRFCNT_ENABLE_SHIFT)
#define GLB_REQ_PRFCNT_ENABLE_GET(reg_val) (((reg_val)&GLB_REQ_PRFCNT_ENABLE_MASK) >> GLB_REQ_PRFCNT_ENABLE_SHIFT)
#define GLB_REQ_PRFCNT_ENABLE_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_PRFCNT_ENABLE_MASK) |  \
	 (((value) << GLB_REQ_PRFCNT_ENABLE_SHIFT) & GLB_REQ_PRFCNT_ENABLE_MASK))
#define GLB_REQ_PRFCNT_SAMPLE_SHIFT 6
#define GLB_REQ_PRFCNT_SAMPLE_MASK (0x1 << GLB_REQ_PRFCNT_SAMPLE_SHIFT)
#define GLB_REQ_PRFCNT_SAMPLE_GET(reg_val) (((reg_val)&GLB_REQ_PRFCNT_SAMPLE_MASK) >> GLB_REQ_PRFCNT_SAMPLE_SHIFT)
#define GLB_REQ_PRFCNT_SAMPLE_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_PRFCNT_SAMPLE_MASK) |  \
	 (((value) << GLB_REQ_PRFCNT_SAMPLE_SHIFT) & GLB_REQ_PRFCNT_SAMPLE_MASK))
#define GLB_REQ_COUNTER_ENABLE_SHIFT 7
#define GLB_REQ_COUNTER_ENABLE_MASK (0x1 << GLB_REQ_COUNTER_ENABLE_SHIFT)
#define GLB_REQ_COUNTER_ENABLE_GET(reg_val) (((reg_val)&GLB_REQ_COUNTER_ENABLE_MASK) >> GLB_REQ_COUNTER_ENABLE_SHIFT)
#define GLB_REQ_COUNTER_ENABLE_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_COUNTER_ENABLE_MASK) |  \
	 (((value) << GLB_REQ_COUNTER_ENABLE_SHIFT) & GLB_REQ_COUNTER_ENABLE_MASK))
#define GLB_REQ_PING_SHIFT 8
#define GLB_REQ_PING_MASK (0x1 << GLB_REQ_PING_SHIFT)
#define GLB_REQ_PING_GET(reg_val) (((reg_val)&GLB_REQ_PING_MASK) >> GLB_REQ_PING_SHIFT)
#define GLB_REQ_PING_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_PING_MASK) | (((value) << GLB_REQ_PING_SHIFT) & GLB_REQ_PING_MASK))
#define GLB_REQ_FIRMWARE_CONFIG_UPDATE_SHIFT 9
#define GLB_REQ_FIRMWARE_CONFIG_UPDATE_MASK                                    \
	(0x1 << GLB_REQ_FIRMWARE_CONFIG_UPDATE_SHIFT)
#define GLB_REQ_FIRMWARE_CONFIG_UPDATE_GET(reg_val)                            \
	(((reg_val)&GLB_REQ_FIRMWARE_CONFIG_UPDATE_MASK) >>                    \
	 GLB_REQ_FIRMWARE_CONFIG_UPDATE_SHIFT)
#define GLB_REQ_FIRMWARE_CONFIG_UPDATE_SET(reg_val, value)                     \
	(((reg_val) & ~GLB_REQ_FIRMWARE_CONFIG_UPDATE_MASK) |                  \
	 (((value) << GLB_REQ_FIRMWARE_CONFIG_UPDATE_SHIFT) &                  \
	  GLB_REQ_FIRMWARE_CONFIG_UPDATE_MASK))
#define GLB_REQ_SLEEP_SHIFT 12
#define GLB_REQ_SLEEP_MASK (0x1 << GLB_REQ_SLEEP_SHIFT)
#define GLB_REQ_SLEEP_GET(reg_val) \
	(((reg_val) & GLB_REQ_SLEEP_MASK) >> GLB_REQ_SLEEP_SHIFT)
#define GLB_REQ_SLEEP_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_SLEEP_MASK) | \
	 (((value) << GLB_REQ_SLEEP_SHIFT) & GLB_REQ_SLEEP_MASK))
#define GLB_REQ_INACTIVE_COMPUTE_SHIFT 20
#define GLB_REQ_INACTIVE_COMPUTE_MASK (0x1 << GLB_REQ_INACTIVE_COMPUTE_SHIFT)
#define GLB_REQ_INACTIVE_COMPUTE_GET(reg_val) \
	(((reg_val)&GLB_REQ_INACTIVE_COMPUTE_MASK) >> GLB_REQ_INACTIVE_COMPUTE_SHIFT)
#define GLB_REQ_INACTIVE_COMPUTE_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_INACTIVE_COMPUTE_MASK) |  \
	 (((value) << GLB_REQ_INACTIVE_COMPUTE_SHIFT) & GLB_REQ_INACTIVE_COMPUTE_MASK))
#define GLB_REQ_INACTIVE_FRAGMENT_SHIFT 21
#define GLB_REQ_INACTIVE_FRAGMENT_MASK (0x1 << GLB_REQ_INACTIVE_FRAGMENT_SHIFT)
#define GLB_REQ_INACTIVE_FRAGMENT_GET(reg_val) \
	(((reg_val)&GLB_REQ_INACTIVE_FRAGMENT_MASK) >> GLB_REQ_INACTIVE_FRAGMENT_SHIFT)
#define GLB_REQ_INACTIVE_FRAGMENT_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_INACTIVE_FRAGMENT_MASK) |  \
	 (((value) << GLB_REQ_INACTIVE_FRAGMENT_SHIFT) & GLB_REQ_INACTIVE_FRAGMENT_MASK))
#define GLB_REQ_INACTIVE_TILER_SHIFT 22
#define GLB_REQ_INACTIVE_TILER_MASK (0x1 << GLB_REQ_INACTIVE_TILER_SHIFT)
#define GLB_REQ_INACTIVE_TILER_GET(reg_val) (((reg_val)&GLB_REQ_INACTIVE_TILER_MASK) >> GLB_REQ_INACTIVE_TILER_SHIFT)
#define GLB_REQ_INACTIVE_TILER_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_INACTIVE_TILER_MASK) |  \
	 (((value) << GLB_REQ_INACTIVE_TILER_SHIFT) & GLB_REQ_INACTIVE_TILER_MASK))
#define GLB_REQ_PROTM_EXIT_SHIFT 23
#define GLB_REQ_PROTM_EXIT_MASK (0x1 << GLB_REQ_PROTM_EXIT_SHIFT)
#define GLB_REQ_PROTM_EXIT_GET(reg_val) (((reg_val)&GLB_REQ_PROTM_EXIT_MASK) >> GLB_REQ_PROTM_EXIT_SHIFT)
#define GLB_REQ_PROTM_EXIT_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_PROTM_EXIT_MASK) | (((value) << GLB_REQ_PROTM_EXIT_SHIFT) & GLB_REQ_PROTM_EXIT_MASK))
#define GLB_REQ_PRFCNT_THRESHOLD_SHIFT 24
#define GLB_REQ_PRFCNT_THRESHOLD_MASK (0x1 << GLB_REQ_PRFCNT_THRESHOLD_SHIFT)
#define GLB_REQ_PRFCNT_THRESHOLD_GET(reg_val) \
	(((reg_val)&GLB_REQ_PRFCNT_THRESHOLD_MASK) >> \
	 GLB_REQ_PRFCNT_THRESHOLD_SHIFT)
#define GLB_REQ_PRFCNT_THRESHOLD_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_PRFCNT_THRESHOLD_MASK) | \
	 (((value) << GLB_REQ_PRFCNT_THRESHOLD_SHIFT) & \
	  GLB_REQ_PRFCNT_THRESHOLD_MASK))
#define GLB_REQ_PRFCNT_OVERFLOW_SHIFT 25
#define GLB_REQ_PRFCNT_OVERFLOW_MASK (0x1 << GLB_REQ_PRFCNT_OVERFLOW_SHIFT)
#define GLB_REQ_PRFCNT_OVERFLOW_GET(reg_val) \
	(((reg_val)&GLB_REQ_PRFCNT_OVERFLOW_MASK) >> \
	 GLB_REQ_PRFCNT_OVERFLOW_SHIFT)
#define GLB_REQ_PRFCNT_OVERFLOW_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_PRFCNT_OVERFLOW_MASK) | \
	 (((value) << GLB_REQ_PRFCNT_OVERFLOW_SHIFT) & \
	  GLB_REQ_PRFCNT_OVERFLOW_MASK))
#define GLB_REQ_DEBUG_CSF_REQ_SHIFT 30
#define GLB_REQ_DEBUG_CSF_REQ_MASK (0x1 << GLB_REQ_DEBUG_CSF_REQ_SHIFT)
#define GLB_REQ_DEBUG_CSF_REQ_GET(reg_val) (((reg_val)&GLB_REQ_DEBUG_CSF_REQ_MASK) >> GLB_REQ_DEBUG_CSF_REQ_SHIFT)
#define GLB_REQ_DEBUG_CSF_REQ_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_DEBUG_CSF_REQ_MASK) |  \
	 (((value) << GLB_REQ_DEBUG_CSF_REQ_SHIFT) & GLB_REQ_DEBUG_CSF_REQ_MASK))
#define GLB_REQ_DEBUG_HOST_REQ_SHIFT 31
#define GLB_REQ_DEBUG_HOST_REQ_MASK (0x1 << GLB_REQ_DEBUG_HOST_REQ_SHIFT)
#define GLB_REQ_DEBUG_HOST_REQ_GET(reg_val) (((reg_val)&GLB_REQ_DEBUG_HOST_REQ_MASK) >> GLB_REQ_DEBUG_HOST_REQ_SHIFT)
#define GLB_REQ_DEBUG_HOST_REQ_SET(reg_val, value) \
	(((reg_val) & ~GLB_REQ_DEBUG_HOST_REQ_MASK) |  \
	 (((value) << GLB_REQ_DEBUG_HOST_REQ_SHIFT) & GLB_REQ_DEBUG_HOST_REQ_MASK))

/* GLB_ACK_IRQ_MASK register */
#define GLB_ACK_IRQ_MASK_HALT_SHIFT 0
#define GLB_ACK_IRQ_MASK_HALT_MASK (0x1 << GLB_ACK_IRQ_MASK_HALT_SHIFT)
#define GLB_ACK_IRQ_MASK_HALT_GET(reg_val) (((reg_val)&GLB_ACK_IRQ_MASK_HALT_MASK) >> GLB_ACK_IRQ_MASK_HALT_SHIFT)
#define GLB_ACK_IRQ_MASK_HALT_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_HALT_MASK) |  \
	 (((value) << GLB_ACK_IRQ_MASK_HALT_SHIFT) & GLB_ACK_IRQ_MASK_HALT_MASK))
#define GLB_ACK_IRQ_MASK_CFG_PROGRESS_TIMER_SHIFT 1
#define GLB_ACK_IRQ_MASK_CFG_PROGRESS_TIMER_MASK (0x1 << GLB_ACK_IRQ_MASK_CFG_PROGRESS_TIMER_SHIFT)
#define GLB_ACK_IRQ_MASK_CFG_PROGRESS_TIMER_GET(reg_val) \
	(((reg_val)&GLB_ACK_IRQ_MASK_CFG_PROGRESS_TIMER_MASK) >> GLB_ACK_IRQ_MASK_CFG_PROGRESS_TIMER_SHIFT)
#define GLB_ACK_IRQ_MASK_CFG_PROGRESS_TIMER_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_CFG_PROGRESS_TIMER_MASK) |  \
	 (((value) << GLB_ACK_IRQ_MASK_CFG_PROGRESS_TIMER_SHIFT) & GLB_ACK_IRQ_MASK_CFG_PROGRESS_TIMER_MASK))
#define GLB_ACK_IRQ_MASK_CFG_ALLOC_EN_SHIFT 2
#define GLB_ACK_IRQ_MASK_CFG_ALLOC_EN_MASK (0x1 << GLB_ACK_IRQ_MASK_CFG_ALLOC_EN_SHIFT)
#define GLB_ACK_IRQ_MASK_CFG_ALLOC_EN_GET(reg_val) \
	(((reg_val)&GLB_ACK_IRQ_MASK_CFG_ALLOC_EN_MASK) >> GLB_ACK_IRQ_MASK_CFG_ALLOC_EN_SHIFT)
#define GLB_ACK_IRQ_MASK_CFG_ALLOC_EN_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_CFG_ALLOC_EN_MASK) |  \
	 (((value) << GLB_ACK_IRQ_MASK_CFG_ALLOC_EN_SHIFT) & GLB_ACK_IRQ_MASK_CFG_ALLOC_EN_MASK))
#define GLB_ACK_IRQ_MASK_CFG_PWROFF_TIMER_SHIFT 3
#define GLB_ACK_IRQ_MASK_CFG_PWROFF_TIMER_MASK (0x1 << GLB_ACK_IRQ_MASK_CFG_PWROFF_TIMER_SHIFT)
#define GLB_ACK_IRQ_MASK_CFG_PWROFF_TIMER_GET(reg_val) \
	(((reg_val)&GLB_ACK_IRQ_MASK_CFG_PWROFF_TIMER_MASK) >> GLB_ACK_IRQ_MASK_CFG_PWROFF_TIMER_SHIFT)
#define GLB_ACK_IRQ_MASK_CFG_PWROFF_TIMER_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_CFG_PWROFF_TIMER_MASK) |  \
	 (((value) << GLB_ACK_IRQ_MASK_CFG_PWROFF_TIMER_SHIFT) & GLB_ACK_IRQ_MASK_CFG_PWROFF_TIMER_MASK))
#define GLB_ACK_IRQ_MASK_PROTM_ENTER_SHIFT 4
#define GLB_ACK_IRQ_MASK_PROTM_ENTER_MASK (0x1 << GLB_ACK_IRQ_MASK_PROTM_ENTER_SHIFT)
#define GLB_ACK_IRQ_MASK_PROTM_ENTER_GET(reg_val) \
	(((reg_val)&GLB_ACK_IRQ_MASK_PROTM_ENTER_MASK) >> GLB_ACK_IRQ_MASK_PROTM_ENTER_SHIFT)
#define GLB_ACK_IRQ_MASK_PROTM_ENTER_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_PROTM_ENTER_MASK) |  \
	 (((value) << GLB_ACK_IRQ_MASK_PROTM_ENTER_SHIFT) & GLB_ACK_IRQ_MASK_PROTM_ENTER_MASK))
#define GLB_ACK_IRQ_MASK_PRFCNT_ENABLE_SHIFT 5
#define GLB_ACK_IRQ_MASK_PRFCNT_ENABLE_MASK (0x1 << GLB_ACK_IRQ_MASK_PRFCNT_ENABLE_SHIFT)
#define GLB_ACK_IRQ_MASK_PRFCNT_ENABLE_GET(reg_val) \
	(((reg_val)&GLB_ACK_IRQ_MASK_PRFCNT_ENABLE_MASK) >> GLB_ACK_IRQ_MASK_PRFCNT_ENABLE_SHIFT)
#define GLB_ACK_IRQ_MASK_PRFCNT_ENABLE_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_PRFCNT_ENABLE_MASK) |  \
	 (((value) << GLB_ACK_IRQ_MASK_PRFCNT_ENABLE_SHIFT) & GLB_ACK_IRQ_MASK_PRFCNT_ENABLE_MASK))
#define GLB_ACK_IRQ_MASK_PRFCNT_SAMPLE_SHIFT 6
#define GLB_ACK_IRQ_MASK_PRFCNT_SAMPLE_MASK (0x1 << GLB_ACK_IRQ_MASK_PRFCNT_SAMPLE_SHIFT)
#define GLB_ACK_IRQ_MASK_PRFCNT_SAMPLE_GET(reg_val) \
	(((reg_val)&GLB_ACK_IRQ_MASK_PRFCNT_SAMPLE_MASK) >> GLB_ACK_IRQ_MASK_PRFCNT_SAMPLE_SHIFT)
#define GLB_ACK_IRQ_MASK_PRFCNT_SAMPLE_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_PRFCNT_SAMPLE_MASK) |  \
	 (((value) << GLB_ACK_IRQ_MASK_PRFCNT_SAMPLE_SHIFT) & GLB_ACK_IRQ_MASK_PRFCNT_SAMPLE_MASK))
#define GLB_ACK_IRQ_MASK_COUNTER_ENABLE_SHIFT 7
#define GLB_ACK_IRQ_MASK_COUNTER_ENABLE_MASK (0x1 << GLB_ACK_IRQ_MASK_COUNTER_ENABLE_SHIFT)
#define GLB_ACK_IRQ_MASK_COUNTER_ENABLE_GET(reg_val) \
	(((reg_val)&GLB_ACK_IRQ_MASK_COUNTER_ENABLE_MASK) >> GLB_ACK_IRQ_MASK_COUNTER_ENABLE_SHIFT)
#define GLB_ACK_IRQ_MASK_COUNTER_ENABLE_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_COUNTER_ENABLE_MASK) |  \
	 (((value) << GLB_ACK_IRQ_MASK_COUNTER_ENABLE_SHIFT) & GLB_ACK_IRQ_MASK_COUNTER_ENABLE_MASK))
#define GLB_ACK_IRQ_MASK_PING_SHIFT 8
#define GLB_ACK_IRQ_MASK_PING_MASK (0x1 << GLB_ACK_IRQ_MASK_PING_SHIFT)
#define GLB_ACK_IRQ_MASK_PING_GET(reg_val) (((reg_val)&GLB_ACK_IRQ_MASK_PING_MASK) >> GLB_ACK_IRQ_MASK_PING_SHIFT)
#define GLB_ACK_IRQ_MASK_PING_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_PING_MASK) |  \
	 (((value) << GLB_ACK_IRQ_MASK_PING_SHIFT) & GLB_ACK_IRQ_MASK_PING_MASK))
#define GLB_ACK_IRQ_MASK_FIRMWARE_CONFIG_UPDATE_SHIFT 9
#define GLB_ACK_IRQ_MASK_FIRMWARE_CONFIG_UPDATE_MASK                           \
	(0x1 << GLB_ACK_IRQ_MASK_FIRMWARE_CONFIG_UPDATE_SHIFT)
#define GLB_ACK_IRQ_MASK_FIRMWARE_CONFIG_UPDATE_GET(reg_val)                   \
	(((reg_val)&GLB_ACK_IRQ_MASK_FIRMWARE_CONFIG_UPDATE_MASK) >>           \
	 GLB_ACK_IRQ_MASK_FIRMWARE_CONFIG_UPDATE_SHIFT)
#define GLB_ACK_IRQ_MASK_FIRMWARE_CONFIG_UPDATE_SET(reg_val, value)            \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_FIRMWARE_CONFIG_UPDATE_MASK) |         \
	 (((value) << GLB_ACK_IRQ_MASK_FIRMWARE_CONFIG_UPDATE_SHIFT) &         \
	  GLB_ACK_IRQ_MASK_FIRMWARE_CONFIG_UPDATE_MASK))
#define GLB_ACK_IRQ_MASK_INACTIVE_COMPUTE_SHIFT 20
#define GLB_ACK_IRQ_MASK_INACTIVE_COMPUTE_MASK (0x1 << GLB_ACK_IRQ_MASK_INACTIVE_COMPUTE_SHIFT)
#define GLB_ACK_IRQ_MASK_INACTIVE_COMPUTE_GET(reg_val) \
	(((reg_val)&GLB_ACK_IRQ_MASK_INACTIVE_COMPUTE_MASK) >> GLB_ACK_IRQ_MASK_INACTIVE_COMPUTE_SHIFT)
#define GLB_ACK_IRQ_MASK_INACTIVE_COMPUTE_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_INACTIVE_COMPUTE_MASK) |  \
	 (((value) << GLB_ACK_IRQ_MASK_INACTIVE_COMPUTE_SHIFT) & GLB_ACK_IRQ_MASK_INACTIVE_COMPUTE_MASK))
#define GLB_ACK_IRQ_MASK_INACTIVE_FRAGMENT_SHIFT 21
#define GLB_ACK_IRQ_MASK_INACTIVE_FRAGMENT_MASK (0x1 << GLB_ACK_IRQ_MASK_INACTIVE_FRAGMENT_SHIFT)
#define GLB_ACK_IRQ_MASK_INACTIVE_FRAGMENT_GET(reg_val) \
	(((reg_val)&GLB_ACK_IRQ_MASK_INACTIVE_FRAGMENT_MASK) >> GLB_ACK_IRQ_MASK_INACTIVE_FRAGMENT_SHIFT)
#define GLB_ACK_IRQ_MASK_INACTIVE_FRAGMENT_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_INACTIVE_FRAGMENT_MASK) |  \
	 (((value) << GLB_ACK_IRQ_MASK_INACTIVE_FRAGMENT_SHIFT) & GLB_ACK_IRQ_MASK_INACTIVE_FRAGMENT_MASK))
#define GLB_ACK_IRQ_MASK_INACTIVE_TILER_SHIFT 22
#define GLB_ACK_IRQ_MASK_INACTIVE_TILER_MASK (0x1 << GLB_ACK_IRQ_MASK_INACTIVE_TILER_SHIFT)
#define GLB_ACK_IRQ_MASK_INACTIVE_TILER_GET(reg_val) \
	(((reg_val)&GLB_ACK_IRQ_MASK_INACTIVE_TILER_MASK) >> GLB_ACK_IRQ_MASK_INACTIVE_TILER_SHIFT)
#define GLB_ACK_IRQ_MASK_INACTIVE_TILER_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_INACTIVE_TILER_MASK) |  \
	 (((value) << GLB_ACK_IRQ_MASK_INACTIVE_TILER_SHIFT) & GLB_ACK_IRQ_MASK_INACTIVE_TILER_MASK))
#define GLB_ACK_IRQ_MASK_PROTM_EXIT_SHIFT 23
#define GLB_ACK_IRQ_MASK_PROTM_EXIT_MASK (0x1 << GLB_ACK_IRQ_MASK_PROTM_EXIT_SHIFT)
#define GLB_ACK_IRQ_MASK_PROTM_EXIT_GET(reg_val) \
	(((reg_val)&GLB_ACK_IRQ_MASK_PROTM_EXIT_MASK) >> GLB_ACK_IRQ_MASK_PROTM_EXIT_SHIFT)
#define GLB_ACK_IRQ_MASK_PROTM_EXIT_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_PROTM_EXIT_MASK) |  \
	 (((value) << GLB_ACK_IRQ_MASK_PROTM_EXIT_SHIFT) & GLB_ACK_IRQ_MASK_PROTM_EXIT_MASK))
#define GLB_ACK_IRQ_MASK_PRFCNT_THRESHOLD_SHIFT 24
#define GLB_ACK_IRQ_MASK_PRFCNT_THRESHOLD_MASK \
	(0x1 << GLB_ACK_IRQ_MASK_PRFCNT_THRESHOLD_SHIFT)
#define GLB_ACK_IRQ_MASK_PRFCNT_THRESHOLD_GET(reg_val) \
	(((reg_val)&GLB_ACK_IRQ_MASK_PRFCNT_THRESHOLD_MASK) >> \
	 GLB_ACK_IRQ_MASK_PRFCNT_THRESHOLD_SHIFT)
#define GLB_ACK_IRQ_MASK_PRFCNT_THRESHOLD_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_PRFCNT_THRESHOLD_MASK) | \
	 (((value) << GLB_ACK_IRQ_MASK_PRFCNT_THRESHOLD_SHIFT) & \
	  GLB_ACK_IRQ_MASK_PRFCNT_THRESHOLD_MASK))
#define GLB_ACK_IRQ_MASK_PRFCNT_OVERFLOW_SHIFT 25
#define GLB_ACK_IRQ_MASK_PRFCNT_OVERFLOW_MASK \
	(0x1 << GLB_ACK_IRQ_MASK_PRFCNT_OVERFLOW_SHIFT)
#define GLB_ACK_IRQ_MASK_PRFCNT_OVERFLOW_GET(reg_val) \
	(((reg_val)&GLB_ACK_IRQ_MASK_PRFCNT_OVERFLOW_MASK) >> \
	 GLB_ACK_IRQ_MASK_PRFCNT_OVERFLOW_SHIFT)
#define GLB_ACK_IRQ_MASK_PRFCNT_OVERFLOW_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_PRFCNT_OVERFLOW_MASK) | \
	 (((value) << GLB_ACK_IRQ_MASK_PRFCNT_OVERFLOW_SHIFT) & \
	  GLB_ACK_IRQ_MASK_PRFCNT_OVERFLOW_MASK))
#define GLB_ACK_IRQ_MASK_DEBUG_CSF_REQ_SHIFT 30
#define GLB_ACK_IRQ_MASK_DEBUG_CSF_REQ_MASK (0x1 << GLB_ACK_IRQ_MASK_DEBUG_CSF_REQ_SHIFT)
#define GLB_ACK_IRQ_MASK_DEBUG_CSF_REQ_GET(reg_val) \
	(((reg_val)&GLB_ACK_IRQ_MASK_DEBUG_CSF_REQ_MASK) >> GLB_ACK_IRQ_MASK_DEBUG_CSF_REQ_SHIFT)
#define GLB_ACK_IRQ_MASK_DEBUG_CSF_REQ_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_DEBUG_CSF_REQ_MASK) |  \
	 (((value) << GLB_ACK_IRQ_MASK_DEBUG_CSF_REQ_SHIFT) & GLB_ACK_IRQ_MASK_DEBUG_CSF_REQ_MASK))
#define GLB_ACK_IRQ_MASK_DEBUG_HOST_REQ_SHIFT 31
#define GLB_ACK_IRQ_MASK_DEBUG_HOST_REQ_MASK (0x1 << GLB_ACK_IRQ_MASK_DEBUG_HOST_REQ_SHIFT)
#define GLB_ACK_IRQ_MASK_DEBUG_HOST_REQ_GET(reg_val) \
	(((reg_val)&GLB_ACK_IRQ_MASK_DEBUG_HOST_REQ_MASK) >> GLB_ACK_IRQ_MASK_DEBUG_HOST_REQ_SHIFT)
#define GLB_ACK_IRQ_MASK_DEBUG_HOST_REQ_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_IRQ_MASK_DEBUG_HOST_REQ_MASK) |  \
	 (((value) << GLB_ACK_IRQ_MASK_DEBUG_HOST_REQ_SHIFT) & GLB_ACK_IRQ_MASK_DEBUG_HOST_REQ_MASK))

/* GLB_PROGRESS_TIMER register */
#define GLB_PROGRESS_TIMER_TIMEOUT_SHIFT 0
#define GLB_PROGRESS_TIMER_TIMEOUT_MASK (0xFFFFFFFF << GLB_PROGRESS_TIMER_TIMEOUT_SHIFT)
#define GLB_PROGRESS_TIMER_TIMEOUT_GET(reg_val) \
	(((reg_val)&GLB_PROGRESS_TIMER_TIMEOUT_MASK) >> GLB_PROGRESS_TIMER_TIMEOUT_SHIFT)
#define GLB_PROGRESS_TIMER_TIMEOUT_SET(reg_val, value) \
	(((reg_val) & ~GLB_PROGRESS_TIMER_TIMEOUT_MASK) |  \
	 (((value) << GLB_PROGRESS_TIMER_TIMEOUT_SHIFT) & GLB_PROGRESS_TIMER_TIMEOUT_MASK))

/* GLB_PWROFF_TIMER register */
#define GLB_PWROFF_TIMER_TIMEOUT_SHIFT 0
#define GLB_PWROFF_TIMER_TIMEOUT_MASK (0x7FFFFFFF << GLB_PWROFF_TIMER_TIMEOUT_SHIFT)
#define GLB_PWROFF_TIMER_TIMEOUT_GET(reg_val) \
	(((reg_val)&GLB_PWROFF_TIMER_TIMEOUT_MASK) >> GLB_PWROFF_TIMER_TIMEOUT_SHIFT)
#define GLB_PWROFF_TIMER_TIMEOUT_SET(reg_val, value) \
	(((reg_val) & ~GLB_PWROFF_TIMER_TIMEOUT_MASK) |  \
	 (((value) << GLB_PWROFF_TIMER_TIMEOUT_SHIFT) & GLB_PWROFF_TIMER_TIMEOUT_MASK))
#define GLB_PWROFF_TIMER_TIMER_SOURCE_SHIFT 31
#define GLB_PWROFF_TIMER_TIMER_SOURCE_MASK (0x1 << GLB_PWROFF_TIMER_TIMER_SOURCE_SHIFT)
#define GLB_PWROFF_TIMER_TIMER_SOURCE_GET(reg_val) \
	(((reg_val)&GLB_PWROFF_TIMER_TIMER_SOURCE_MASK) >> GLB_PWROFF_TIMER_TIMER_SOURCE_SHIFT)
#define GLB_PWROFF_TIMER_TIMER_SOURCE_SET(reg_val, value) \
	(((reg_val) & ~GLB_PWROFF_TIMER_TIMER_SOURCE_MASK) |  \
	 (((value) << GLB_PWROFF_TIMER_TIMER_SOURCE_SHIFT) & GLB_PWROFF_TIMER_TIMER_SOURCE_MASK))
/* GLB_PWROFF_TIMER_TIMER_SOURCE values */
#define GLB_PWROFF_TIMER_TIMER_SOURCE_SYSTEM_TIMESTAMP 0x0
#define GLB_PWROFF_TIMER_TIMER_SOURCE_GPU_COUNTER 0x1
/* End of GLB_PWROFF_TIMER_TIMER_SOURCE values */

/* GLB_ALLOC_EN register */
#define GLB_ALLOC_EN_MASK_SHIFT 0
#define GLB_ALLOC_EN_MASK_MASK (GPU_ULL(0xFFFFFFFFFFFFFFFF) << GLB_ALLOC_EN_MASK_SHIFT)
#define GLB_ALLOC_EN_MASK_GET(reg_val) (((reg_val)&GLB_ALLOC_EN_MASK_MASK) >> GLB_ALLOC_EN_MASK_SHIFT)
#define GLB_ALLOC_EN_MASK_SET(reg_val, value) \
	(((reg_val) & ~GLB_ALLOC_EN_MASK_MASK) | (((value) << GLB_ALLOC_EN_MASK_SHIFT) & GLB_ALLOC_EN_MASK_MASK))

/* GLB_OUTPUT_BLOCK register set definitions */

/* GLB_ACK register */
#define GLB_ACK_CFG_PROGRESS_TIMER_SHIFT 1
#define GLB_ACK_CFG_PROGRESS_TIMER_MASK (0x1 << GLB_ACK_CFG_PROGRESS_TIMER_SHIFT)
#define GLB_ACK_CFG_PROGRESS_TIMER_GET(reg_val) \
	(((reg_val)&GLB_ACK_CFG_PROGRESS_TIMER_MASK) >> GLB_ACK_CFG_PROGRESS_TIMER_SHIFT)
#define GLB_ACK_CFG_PROGRESS_TIMER_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_CFG_PROGRESS_TIMER_MASK) |  \
	 (((value) << GLB_ACK_CFG_PROGRESS_TIMER_SHIFT) & GLB_ACK_CFG_PROGRESS_TIMER_MASK))
#define GLB_ACK_CFG_ALLOC_EN_SHIFT 2
#define GLB_ACK_CFG_ALLOC_EN_MASK (0x1 << GLB_ACK_CFG_ALLOC_EN_SHIFT)
#define GLB_ACK_CFG_ALLOC_EN_GET(reg_val) (((reg_val)&GLB_ACK_CFG_ALLOC_EN_MASK) >> GLB_ACK_CFG_ALLOC_EN_SHIFT)
#define GLB_ACK_CFG_ALLOC_EN_SET(reg_val, value) \
	(((reg_val) & ~GLB_ACK_CFG_ALLOC_EN_MASK) | (((value) << GLB_ACK_CFG_ALLOC_EN_SHIFT) & GLB_ACK_CFG_ALLOC_EN_MASK))
/* End of GLB_OUTPUT_BLOCK register set definitions */

/* The following register and fields are for headers before 10.x.7/11.x.4 */
#define GLB_REQ_IDLE_ENABLE_SHIFT (10)
#define GLB_REQ_REQ_IDLE_ENABLE (1 << GLB_REQ_IDLE_ENABLE_SHIFT)
#define GLB_REQ_REQ_IDLE_DISABLE (0 << GLB_REQ_IDLE_ENABLE_SHIFT)
#define GLB_REQ_IDLE_ENABLE_MASK (0x1 << GLB_REQ_IDLE_ENABLE_SHIFT)
#define GLB_REQ_IDLE_DISABLE_MASK (0x1 << GLB_REQ_IDLE_ENABLE_SHIFT)
#define GLB_REQ_IDLE_EVENT_SHIFT (26)
#define GLB_REQ_IDLE_EVENT_MASK (0x1 << GLB_REQ_IDLE_EVENT_SHIFT)
#define GLB_ACK_IDLE_ENABLE_SHIFT (10)
#define GLB_ACK_ACK_IDLE_ENABLE (1 << GLB_ACK_IDLE_ENABLE_SHIFT)
#define GLB_ACK_ACK_IDLE_DISABLE (0 << GLB_ACK_IDLE_ENABLE_SHIFT)
#define GLB_ACK_IDLE_ENABLE_MASK (0x1 << GLB_ACK_IDLE_ENABLE_SHIFT)
#define GLB_ACK_IDLE_EVENT_SHIFT (26)
#define GLB_ACK_IDLE_EVENT_MASK (0x1 << GLB_REQ_IDLE_EVENT_SHIFT)

#define GLB_ACK_IRQ_MASK_IDLE_EVENT_SHIFT (26)
#define GLB_ACK_IRQ_MASK_IDLE_EVENT_MASK (0x1 << GLB_ACK_IRQ_MASK_IDLE_EVENT_SHIFT)

#define GLB_ACK_IRQ_MASK_IDLE_ENABLE_SHIFT GPU_U(10)
#define GLB_ACK_IRQ_MASK_IDLE_ENABLE_MASK (GPU_U(0x1) << GLB_ACK_IRQ_MASK_IDLE_ENABLE_SHIFT)

#define GLB_IDLE_TIMER (0x0080)
/* GLB_IDLE_TIMER register */
#define GLB_IDLE_TIMER_TIMEOUT_SHIFT (0)
#define GLB_IDLE_TIMER_TIMEOUT_MASK ((0x7FFFFFFF) << GLB_IDLE_TIMER_TIMEOUT_SHIFT)
#define GLB_IDLE_TIMER_TIMEOUT_GET(reg_val) (((reg_val)&GLB_IDLE_TIMER_TIMEOUT_MASK) >> GLB_IDLE_TIMER_TIMEOUT_SHIFT)
#define GLB_IDLE_TIMER_TIMEOUT_SET(reg_val, value) \
	(((reg_val) & ~GLB_IDLE_TIMER_TIMEOUT_MASK) |  \
	 (((value) << GLB_IDLE_TIMER_TIMEOUT_SHIFT) & GLB_IDLE_TIMER_TIMEOUT_MASK))
#define GLB_IDLE_TIMER_TIMER_SOURCE_SHIFT (31)
#define GLB_IDLE_TIMER_TIMER_SOURCE_MASK ((0x1) << GLB_IDLE_TIMER_TIMER_SOURCE_SHIFT)
#define GLB_IDLE_TIMER_TIMER_SOURCE_GET(reg_val) \
	(((reg_val)&GLB_IDLE_TIMER_TIMER_SOURCE_MASK) >> GLB_IDLE_TIMER_TIMER_SOURCE_SHIFT)
#define GLB_IDLE_TIMER_TIMER_SOURCE_SET(reg_val, value) \
	(((reg_val) & ~GLB_IDLE_TIMER_TIMER_SOURCE_MASK) |  \
	 (((value) << GLB_IDLE_TIMER_TIMER_SOURCE_SHIFT) & GLB_IDLE_TIMER_TIMER_SOURCE_MASK))
/* GLB_IDLE_TIMER_TIMER_SOURCE values */
#define GLB_IDLE_TIMER_TIMER_SOURCE_SYSTEM_TIMESTAMP 0x0
#define GLB_IDLE_TIMER_TIMER_SOURCE_GPU_COUNTER 0x1
/* End of GLB_IDLE_TIMER_TIMER_SOURCE values */

/* GLB_INSTR_FEATURES register */
#define GLB_INSTR_FEATURES_OFFSET_UPDATE_RATE_SHIFT (0)
#define GLB_INSTR_FEATURES_OFFSET_UPDATE_RATE_MASK ((u32)0xF << GLB_INSTR_FEATURES_OFFSET_UPDATE_RATE_SHIFT)
#define GLB_INSTR_FEATURES_OFFSET_UPDATE_RATE_GET(reg_val) \
	(((reg_val)&GLB_INSTR_FEATURES_OFFSET_UPDATE_RATE_MASK) >> GLB_INSTR_FEATURES_OFFSET_UPDATE_RATE_SHIFT)
#define GLB_INSTR_FEATURES_OFFSET_UPDATE_RATE_SET(reg_val, value) \
	(((reg_val) & ~GLB_INSTR_FEATURES_OFFSET_UPDATE_RATE_MASK) |  \
	 (((value) << GLB_INSTR_FEATURES_OFFSET_UPDATE_RATE_SHIFT) & GLB_INSTR_FEATURES_OFFSET_UPDATE_RATE_MASK))
#define GLB_INSTR_FEATURES_EVENT_SIZE_MAX_SHIFT (4)
#define GLB_INSTR_FEATURES_EVENT_SIZE_MAX_MASK ((u32)0xF << GLB_INSTR_FEATURES_EVENT_SIZE_MAX_SHIFT)
#define GLB_INSTR_FEATURES_EVENT_SIZE_MAX_GET(reg_val) \
	(((reg_val)&GLB_INSTR_FEATURES_EVENT_SIZE_MAX_MASK) >> GLB_INSTR_FEATURES_EVENT_SIZE_MAX_SHIFT)
#define GLB_INSTR_FEATURES_EVENT_SIZE_MAX_SET(reg_val, value) \
	(((reg_val) & ~GLB_INSTR_FEATURES_EVENT_SIZE_MAX_MASK) |  \
	 (((value) << GLB_INSTR_FEATURES_EVENT_SIZE_MAX_SHIFT) & GLB_INSTR_FEATURES_EVENT_SIZE_MAX_MASK))

#define CSG_STATUS_STATE (0x0018) /* CSG state status register */
/* CSG_STATUS_STATE register */
#define CSG_STATUS_STATE_IDLE_SHIFT (0)
#define CSG_STATUS_STATE_IDLE_MASK ((0x1) << CSG_STATUS_STATE_IDLE_SHIFT)
#define CSG_STATUS_STATE_IDLE_GET(reg_val) \
	(((reg_val)&CSG_STATUS_STATE_IDLE_MASK) >> CSG_STATUS_STATE_IDLE_SHIFT)
#define CSG_STATUS_STATE_IDLE_SET(reg_val, value) \
	(((reg_val) & ~CSG_STATUS_STATE_IDLE_MASK) |  \
	(((value) << CSG_STATUS_STATE_IDLE_SHIFT) & CSG_STATUS_STATE_IDLE_MASK))

/* GLB_FEATURES_ITER_TRACE_SUPPORTED register */
#define GLB_FEATURES_ITER_TRACE_SUPPORTED_SHIFT GPU_U(4)
#define GLB_FEATURES_ITER_TRACE_SUPPORTED_MASK                                 \
	(GPU_U(0x1) << GLB_FEATURES_ITER_TRACE_SUPPORTED_SHIFT)
#define GLB_FEATURES_ITER_TRACE_SUPPORTED_GET(reg_val)                         \
	(((reg_val)&GLB_FEATURES_ITER_TRACE_SUPPORTED_MASK) >>                 \
	 GLB_FEATURES_ITER_TRACE_SUPPORTED_SHIFT)
#define GLB_FEATURES_ITER_TRACE_SUPPORTED_SET(reg_val, value)                  \
	(((reg_val) & ~GLB_FEATURES_ITER_TRACE_SUPPORTED_MASK) |               \
	 (((value) << GLB_FEATURES_ITER_TRACE_SUPPORTED_SHIFT) &               \
	  GLB_FEATURES_ITER_TRACE_SUPPORTED_MASK))

/* GLB_REQ_ITER_TRACE_ENABLE register */
#define GLB_REQ_ITER_TRACE_ENABLE_SHIFT GPU_U(11)
#define GLB_REQ_ITER_TRACE_ENABLE_MASK                                         \
	(GPU_U(0x1) << GLB_REQ_ITER_TRACE_ENABLE_SHIFT)
#define GLB_REQ_ITER_TRACE_ENABLE_GET(reg_val)                                 \
	(((reg_val)&GLB_REQ_ITER_TRACE_ENABLE_MASK) >>                         \
	 GLB_REQ_ITER_TRACE_ENABLE_SHIFT)
#define GLB_REQ_ITER_TRACE_ENABLE_SET(reg_val, value)                          \
	(((reg_val) & ~GLB_REQ_ITER_TRACE_ENABLE_MASK) |                       \
	 (((value) << GLB_REQ_ITER_TRACE_ENABLE_SHIFT) &                       \
	  GLB_REQ_ITER_TRACE_ENABLE_MASK))

/* GLB_PRFCNT_CONFIG register */
#define GLB_PRFCNT_CONFIG_SIZE_SHIFT (0)
#define GLB_PRFCNT_CONFIG_SIZE_MASK (0xFF << GLB_PRFCNT_CONFIG_SIZE_SHIFT)
#define GLB_PRFCNT_CONFIG_SIZE_GET(reg_val)                                                        \
	(((reg_val)&GLB_PRFCNT_CONFIG_SIZE_MASK) >> GLB_PRFCNT_CONFIG_SIZE_SHIFT)
#define GLB_PRFCNT_CONFIG_SIZE_SET(reg_val, value)                                                 \
	(((reg_val) & ~GLB_PRFCNT_CONFIG_SIZE_MASK) |                                              \
	 (((value) << GLB_PRFCNT_CONFIG_SIZE_SHIFT) & GLB_PRFCNT_CONFIG_SIZE_MASK))
#define GLB_PRFCNT_CONFIG_SET_SELECT_SHIFT GPU_U(8)
#define GLB_PRFCNT_CONFIG_SET_SELECT_MASK (GPU_U(0x3) << GLB_PRFCNT_CONFIG_SET_SELECT_SHIFT)
#define GLB_PRFCNT_CONFIG_SET_SELECT_GET(reg_val)                                                  \
	(((reg_val)&GLB_PRFCNT_CONFIG_SET_SELECT_MASK) >> GLB_PRFCNT_CONFIG_SET_SELECT_SHIFT)
#define GLB_PRFCNT_CONFIG_SET_SELECT_SET(reg_val, value)                                           \
	(((reg_val) & ~GLB_PRFCNT_CONFIG_SET_SELECT_MASK) |                                        \
	 (((value) << GLB_PRFCNT_CONFIG_SET_SELECT_SHIFT) & GLB_PRFCNT_CONFIG_SET_SELECT_MASK))

/* GLB_PRFCNT_SIZE register */
#define GLB_PRFCNT_SIZE_HARDWARE_SIZE_SET_MOD(value) ((value) >> 8)
#define GLB_PRFCNT_SIZE_HARDWARE_SIZE_GET_MOD(value) ((value) << 8)
#define GLB_PRFCNT_SIZE_HARDWARE_SIZE_SHIFT GPU_U(0)
#define GLB_PRFCNT_SIZE_HARDWARE_SIZE_MASK (GPU_U(0xFFFF) << GLB_PRFCNT_SIZE_HARDWARE_SIZE_SHIFT)
#define GLB_PRFCNT_SIZE_HARDWARE_SIZE_GET(reg_val)                                                 \
	(GLB_PRFCNT_SIZE_HARDWARE_SIZE_GET_MOD(((reg_val)&GLB_PRFCNT_SIZE_HARDWARE_SIZE_MASK) >>   \
					       GLB_PRFCNT_SIZE_HARDWARE_SIZE_SHIFT))
#define GLB_PRFCNT_SIZE_HARDWARE_SIZE_SET(reg_val, value)                                          \
	(((reg_val) & ~GLB_PRFCNT_SIZE_HARDWARE_SIZE_MASK) |                                       \
	 ((GLB_PRFCNT_SIZE_HARDWARE_SIZE_SET_MOD(value) << GLB_PRFCNT_SIZE_HARDWARE_SIZE_SHIFT) &  \
	  GLB_PRFCNT_SIZE_HARDWARE_SIZE_MASK))
#define GLB_PRFCNT_SIZE_FIRMWARE_SIZE_SET_MOD(value) ((value) >> 8)
#define GLB_PRFCNT_SIZE_FIRMWARE_SIZE_GET_MOD(value) ((value) << 8)
#define GLB_PRFCNT_SIZE_FIRMWARE_SIZE_SHIFT GPU_U(16)
#define GLB_PRFCNT_SIZE_FIRMWARE_SIZE_MASK (GPU_U(0xFFFF) << GLB_PRFCNT_SIZE_FIRMWARE_SIZE_SHIFT)
#define GLB_PRFCNT_SIZE_FIRMWARE_SIZE_GET(reg_val)                                                 \
	(GLB_PRFCNT_SIZE_FIRMWARE_SIZE_GET_MOD(((reg_val)&GLB_PRFCNT_SIZE_FIRMWARE_SIZE_MASK) >>   \
					       GLB_PRFCNT_SIZE_FIRMWARE_SIZE_SHIFT))
#define GLB_PRFCNT_SIZE_FIRMWARE_SIZE_SET(reg_val, value)                                          \
	(((reg_val) & ~GLB_PRFCNT_SIZE_FIRMWARE_SIZE_MASK) |                                       \
	 ((GLB_PRFCNT_SIZE_FIRMWARE_SIZE_SET_MOD(value) << GLB_PRFCNT_SIZE_FIRMWARE_SIZE_SHIFT) &  \
	  GLB_PRFCNT_SIZE_FIRMWARE_SIZE_MASK))

#endif /* _KBASE_CSF_REGISTERS_H_ */
