/*
 * drivers/input/touchscreen/gslX680.c
 *
 * Copyright (c) 2012 Shanghai Basewin
 *	Guan Yuwei<guanyuwei@basewin.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 */

#ifndef	_GSLX680_FIREFLY_H_
#define	_GSLX680_FIREFLY_H_

#define SCREEN_MAX_X	768
#define SCREEN_MAX_Y	1024

#define GSLX680_COMPATIBLE
#define	GSL_NOID_VERSION
#ifdef	GSL_NOID_VERSION
struct gsl_touch_info {
	int x[10];
	int y[10];
	int id[10];
	int finger_num;
};

unsigned int gsl_mask_tiaoping(void);
unsigned int gsl_version_id(void);
void gsl_alg_id_main(struct gsl_touch_info *cinfo);
void gsl_DataInit(int *ret);

unsigned int gsl_config_data_id_3680B[] = {
	0x72d266,
	0x200,
	0, 0,
	0,
	0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,

	0x10c, 0x5, 0x14000f, 0x14000f, 0x4000300, 0, 0x5100, 0x8e00,
	0, 0x320014, 0, 0, 0, 0, 0, 0,
	0x8, 0x4000, 0x1000, 0x10100005, 0x10000000, 0, 0, 0,
	0x1b6db688, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0x40, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,

	0, /*key_map*/
	0x3200384, 0x64, 0x503e8, /*0*/
	0, 0, 0, /*1*/
	0, 0, 0, /*2*/
	0, 0, 0, /*3*/
	0, 0, 0, /*4*/
	0, 0, 0, /*5*/
	0, 0, 0, /*6*/
	0, 0, 0, /*7*/

	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,

	0x221,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0x2010100, 0x6050403, 0xa090807, 0xf0d0c0b, 0x13121110,
	0x18171615, 0x1d1c1b19, 0x21201f1e, 0x26252423, 0x2b2a2928,
	0x302f2e2d, 0x35333231, 0x39383736, 0x3d3c3b3a, 0x3f3f3f3e,
	0, 0x1010000, 0x5040302, 0xa090706, 0xf0e0c0b, 0x15131211,
	0x1a191716, 0x201e1d1b, 0x26242321, 0x2b2a2827, 0x312f2e2d,
	0x36343332, 0x3b3a3837, 0x3e3e3d3c, 0x3f3f3f3f, 0x3f3f3f3f,

	0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c, 0x13121110,
	0x17161514, 0x1b1a1918, 0x1f1e1d1c, 0x23222120, 0x27262524,
	0x2b2a2928, 0x2f2e2d2c, 0x33323130, 0x37363534, 0x3b3a3938,
	0x3f3e3d3c, 0x3020100, 0x7060504, 0xb0a0908, 0xf0e0d0c,
	0x13121110, 0x17161514, 0x1b1a1918, 0x1f1e1d1c, 0x23222120,
	0x27262524, 0x2b2a2928, 0x2f2e2d2c, 0x33323130, 0x37363534,
	0x3b3a3938, 0x3f3e3d3c, 0x3020100, 0x7060504, 0xb0a0908,
	0xf0e0d0c, 0x13121110, 0x17161514, 0x1b1a1918, 0x1f1e1d1c,
	0x23222120, 0x27262524, 0x2b2a2928, 0x2f2e2d2c, 0x33323130,
	0x37363534, 0x3b3a3938, 0x3f3e3d3c, 0x3020100, 0x7060504,
	0xb0a0908, 0xf0e0d0c, 0x13121110, 0x17161514, 0x1b1a1918,
	0x1f1e1d1c, 0x23222120, 0x27262524, 0x2b2a2928, 0x2f2e2d2c,
	0x33323130, 0x37363534, 0x3b3a3938, 0x3f3e3d3c,

	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,

	0x3,
	0x101, 0, 0x100, 0,
	0x20, 0x10, 0x8, 0x4,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,

	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0,
};
#endif
struct fw_data {
	u32 offset:8;
	u32:0;
	u32 val;
};

static const struct fw_data GSL3680B_FW[] = {
{0xf0, 0x3},
{0x00, 0x781a6cee},
{0x04, 0x00000000},
{0x08, 0x00000000},
{0x0c, 0x00000000},
{0x10, 0x00000000},
{0x14, 0x00000000},
{0x18, 0x00000000},
{0x1c, 0x00000000},
{0x20, 0x00000000},
{0x24, 0x00005100},
{0x28, 0x00008e00},
{0x2c, 0x00000000},
{0x30, 0x00000000},
{0x34, 0x00000000},
{0x38, 0x00000000},
{0x3c, 0x00000000},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00000000},
{0x50, 0x00000000},
{0x54, 0x00000000},
{0x58, 0x00000000},
{0x5c, 0x00000000},
{0x60, 0x00000000},
{0x64, 0x1a0ac00a},
{0x68, 0x00000002},
{0x6c, 0x0000000f},
{0x70, 0x00000000},
{0x74, 0xffffffff},
{0x78, 0xffffffec},
{0x7c, 0x00000000},
{0xf0, 0x4},
{0x00, 0x00000000},
{0x04, 0x00000000},
{0x08, 0x00000000},
{0x0c, 0x00000000},
{0x10, 0x0000ff06},
{0x14, 0x00000000},
{0x18, 0x00000000},
{0x1c, 0x00000000},
{0x20, 0x00000000},
{0x24, 0x00000000},
{0x28, 0x00000000},
{0x2c, 0x00000000},
{0x30, 0x00001000},
{0x34, 0x00000000},
{0x38, 0x0000000a},
{0x3c, 0x00000258},
{0x40, 0x00000000},
{0x44, 0x04020a00},
{0x48, 0x0014012c},
{0x4c, 0x9a080007},
{0x50, 0x00000000},
{0x54, 0x00010203},
{0x58, 0x04050607},
{0x5c, 0x08090a0b},
{0x60, 0x0c0d0e0f},
{0x64, 0x10111213},
{0x68, 0x14151617},
{0x6c, 0x18191a1b},
{0x70, 0x1c1d1e1f},
{0x74, 0x0014000a},
{0x78, 0x80808080},
{0x7c, 0xcba981f4},
{0xf0, 0x5},
{0x00, 0x00000000},
{0x04, 0x00000005},
{0x08, 0x000000b4},
{0x0c, 0x66666666},
{0x10, 0x0000000a},
{0x14, 0x00000000},
{0x18, 0x00000fff},
{0x1c, 0x10100005},
{0x20, 0x10000000},
{0x24, 0x00000000},
{0x28, 0x00000000},
{0x2c, 0x00000400},
{0x30, 0x80808080},
{0x34, 0x80808080},
{0x38, 0x80808080},
{0x3c, 0x80808080},
{0x40, 0x80808080},
{0x44, 0x80808080},
{0x48, 0x80808080},
{0x4c, 0x80808000},
{0x50, 0xffffffff},
{0x54, 0x00010203},
{0x58, 0x04050607},
{0x5c, 0x08090a0b},
{0x60, 0x0c0d0e0f},
{0x64, 0x10111213},
{0x68, 0x14151617},
{0x6c, 0x18191a1b},
{0x70, 0x1c1d1e1f},
{0x74, 0x00000221},
{0x78, 0x0000000f},
{0x7c, 0x00000014},
{0xf0, 0x6},
{0x00, 0x0000000f},
{0x04, 0x00000000},
{0x08, 0x00000014},
{0x0c, 0x04030402},
{0x10, 0x00000032},
{0x14, 0x1414140a},
{0x18, 0x00000000},
{0x1c, 0x00000001},
{0x20, 0x00002904},
{0x24, 0x00000400},
{0x28, 0x00000300},
{0x2c, 0xf8010011},
{0x30, 0xf8010011},
{0x34, 0x00000003},
{0x38, 0x00000003},
{0x3c, 0x00000fff},
{0x40, 0x80000000},
{0x44, 0x00180018},
{0x48, 0x00000fff},
{0x4c, 0x04040402},
{0x50, 0x00070006},
{0x54, 0x00000000},
{0x58, 0x00004000},
{0x5c, 0x1b6db688},
{0x60, 0x20100804},
{0x64, 0x00000000},
{0x68, 0x00000000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000190},
{0x78, 0x000a003c},
{0x7c, 0x00000000},
{0xf0, 0x7},
{0x00, 0x010b000a},
{0x04, 0x030d020c},
{0x08, 0x050f040e},
{0x0c, 0x07110610},
{0x10, 0x09130812},
{0x14, 0x0b170a16},
{0x18, 0x00000000},
{0x1c, 0x000a0078},
{0x20, 0x00001081},
{0x24, 0xff080010},
{0x28, 0xff080120},
{0x2c, 0xff080140},
{0x30, 0xff080160},
{0x34, 0x000000f0},
{0x38, 0x000000d5},
{0x3c, 0x000000a6},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x0000010c},
{0x4c, 0x000f0003},
{0x50, 0x00000d00},
{0x54, 0x00000003},
{0x58, 0x00000000},
{0x5c, 0x000d0001},
{0x60, 0x000e000e},
{0x64, 0x00000000},
{0x68, 0x00000000},
{0x6c, 0x00080002},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00023456},
{0x7c, 0x00789a1b},
{0xf0, 0x8},
{0x00, 0x020f222f},
{0x04, 0x224f226f},
{0x08, 0x228f22af},
{0x0c, 0x22cf22ef},
{0x10, 0x230f232f},
{0x14, 0x234f236f},
{0x18, 0x238f23af},
{0x1c, 0x53cf03ef},
{0x20, 0x01f001f1},
{0x24, 0x01f201f3},
{0x28, 0x01f401f5},
{0x2c, 0x01f601f7},
{0x30, 0x01f801f9},
{0x34, 0x01fa01fb},
{0x38, 0x01fc01fd},
{0x3c, 0x01fe01ff},
{0x40, 0x01030507},
{0x44, 0x090b0d0f},
{0x48, 0x11130000},
{0x4c, 0x02040608},
{0x50, 0x0a0c0e10},
{0x54, 0x12140000},
{0x58, 0x00060005},
{0x5c, 0x00000008},
{0x60, 0x000001f4},
{0x64, 0x04030201},
{0x68, 0x08080804},
{0x6c, 0x00000100},
{0x70, 0x000000cd},
{0x74, 0x0000006a},
{0x78, 0x00000000},
{0x7c, 0x00000014},
{0xf0, 0x9},
{0x00, 0xff080094},
{0x04, 0x00070011},
{0x08, 0xff080090},
{0x0c, 0x00040000},
{0x10, 0xff080068},
{0x14, 0x00030000},
{0x18, 0xff080064},
{0x1c, 0x01002582},
{0x20, 0xff080060},
{0x24, 0x00000000},
{0x28, 0xff08004c},
{0x2c, 0x00197fff},
{0x30, 0xfffffff0},
{0x34, 0x00000000},
{0x38, 0xfffffff0},
{0x3c, 0x00000000},
{0x40, 0xfffffff0},
{0x44, 0x00000000},
{0x48, 0xfffffff0},
{0x4c, 0x00000000},
{0x50, 0xfffffff0},
{0x54, 0x00000000},
{0x58, 0xfffffff0},
{0x5c, 0x00000000},
{0x60, 0xfffffff0},
{0x64, 0x00000000},
{0x68, 0xfffffff0},
{0x6c, 0x00000000},
{0x70, 0xfffffff0},
{0x74, 0x00000000},
{0x78, 0xfffffff0},
{0x7c, 0x00000000},
{0xf0, 0x0},
{0x00, 0x01000000},
{0x04, 0x01000000},
{0x08, 0x01000000},
{0x0c, 0x233fc0c0},
{0x10, 0xa2146004},
{0x14, 0xa4102000},
{0x18, 0xe4244000},
{0x1c, 0x233fc0c0},
{0x20, 0xa2146010},
{0x24, 0x2500003f},
{0x28, 0xa414a3ff},
{0x2c, 0xe4244000},
{0x30, 0x01000000},
{0x34, 0x821020e0},
{0x38, 0x81880001},
{0x3c, 0x01000000},
{0x40, 0x01000000},
{0x44, 0x01000000},
{0x48, 0x270010c0},
{0x4c, 0xa614e00f},
{0x50, 0xe6a00040},
{0x54, 0x01000000},
{0x58, 0xa410200f},
{0x5c, 0xe4a00040},
{0x60, 0x01000000},
{0x64, 0xa0100000},
{0x68, 0xa2100000},
{0x6c, 0xa4100000},
{0x70, 0xa6100000},
{0x74, 0xa8100000},
{0x78, 0xaa100000},
{0x7c, 0xac100000},
{0xf0, 0x1},
{0x00, 0xae100000},
{0x04, 0x90100000},
{0x08, 0x92100000},
{0x0c, 0x94100000},
{0x10, 0x96100000},
{0x14, 0x98100000},
{0x18, 0x9a100000},
{0x1c, 0x9c100000},
{0x20, 0x9e100000},
{0x24, 0x84100000},
{0x28, 0x86100000},
{0x2c, 0x88100000},
{0x30, 0x8a100000},
{0x34, 0x8c100000},
{0x38, 0x8e100000},
{0x3c, 0x01000000},
{0x40, 0x01000000},
{0x44, 0x01000000},
{0x48, 0x82100000},
{0x4c, 0x81900001},
{0x50, 0x82100000},
{0x54, 0x81980001},
{0x58, 0x81800000},
{0x5c, 0x01000000},
{0x60, 0x01000000},
{0x64, 0x01000000},
{0x68, 0xbc102cf8},
{0x6c, 0x9c102c78},
{0x70, 0x01000000},
{0x74, 0x01000000},
{0x78, 0x01000000},
{0x7c, 0x01000000},
{0xf0, 0x2},
{0x00, 0x270010c0},
{0x04, 0xa614e00f},
{0x08, 0xe6a00040},
{0x0c, 0x01000000},
{0x10, 0x4000045c},
{0x14, 0x01000000},
{0x18, 0x01000000},
{0x1c, 0x10bfffff},
{0x20, 0x01000000},
{0x24, 0x03169684},
{0x28, 0x82106042},
{0x2c, 0x0329694d},
{0x30, 0x82106292},
{0x34, 0x00000000},
{0x38, 0x00000000},
{0x3c, 0x00000000},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00000000},
{0x50, 0x00000000},
{0x54, 0x00000000},
{0x58, 0x00000000},
{0x5c, 0x00000000},
{0x60, 0x00000000},
{0x64, 0x00000000},
{0x68, 0x00000000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x00000000},
{0xf0, 0x1a},
{0x00, 0x82102001},
{0x04, 0x81904000},
{0x08, 0x01000000},
{0x0c, 0x01000000},
{0x10, 0x01000000},
{0x14, 0x81c3e008},
{0x18, 0x01000000},
{0x1c, 0x03000008},
{0x20, 0x82106342},
{0x24, 0xa3804000},
{0x28, 0x03000004},
{0x2c, 0x82106000},
{0x30, 0x81984000},
{0x34, 0x01000000},
{0x38, 0x01000000},
{0x3c, 0x01000000},
{0x40, 0x81c3e008},
{0x44, 0x01000000},
{0x48, 0x01000000},
{0x4c, 0x01000000},
{0x50, 0x01000000},
{0x54, 0xa7800000},
{0x58, 0x01000000},
{0x5c, 0x01000000},
{0x60, 0x01000000},
{0x64, 0x81c3e008},
{0x68, 0x01000000},
{0x6c, 0x82020008},
{0x70, 0x82004008},
{0x74, 0x9b326002},
{0x78, 0x82004001},
{0x7c, 0x8200400d},
{0xf0, 0x1b},
{0x00, 0x83286002},
{0x04, 0x920a6003},
{0x08, 0x932a6003},
{0x0c, 0xd00065b0},
{0x10, 0x91320009},
{0x14, 0x81c3e008},
{0x18, 0x900a20ff},
{0x1c, 0x9a020008},
{0x20, 0x9a034008},
{0x24, 0x97326002},
{0x28, 0x9a03400d},
{0x2c, 0x9a03400b},
{0x30, 0x920a6003},
{0x34, 0x9b2b6002},
{0x38, 0x932a6003},
{0x3c, 0x821020ff},
{0x40, 0xd80365b0},
{0x44, 0x83284009},
{0x48, 0x822b0001},
{0x4c, 0x952a8009},
{0x50, 0x8210400a},
{0x54, 0xc22365b0},
{0x58, 0x912a2002},
{0x5c, 0xda0223a4},
{0x60, 0x972ae002},
{0x64, 0x81c3e008},
{0x68, 0xc223400b},
{0x6c, 0x9a102005},
{0x70, 0x8210200b},
{0x74, 0x9a234008},
{0x78, 0x82204008},
{0x7c, 0x9b2b6002},
{0xf0, 0x1c},
{0x00, 0x80a22005},
{0x04, 0x14800007},
{0x08, 0x99286002},
{0x0c, 0x033fc200},
{0x10, 0x8210600c},
{0x14, 0xc2004000},
{0x18, 0x10800006},
{0x1c, 0x8330400d},
{0x20, 0x033fc200},
{0x24, 0x82106008},
{0x28, 0xc2004000},
{0x2c, 0x8330400c},
{0x30, 0x81c3e008},
{0x34, 0x9008600f},
{0x38, 0x9de3bf98},
{0x3c, 0xc200247c},
{0x40, 0x83306001},
{0x44, 0x80a60001},
{0x48, 0x1a800006},
{0x4c, 0x90100018},
{0x50, 0x7fffffe7},
{0x54, 0x01000000},
{0x58, 0x10800006},
{0x5c, 0xb0020008},
{0x60, 0x7fffffe3},
{0x64, 0x90260001},
{0x68, 0x90020008},
{0x6c, 0xb0022001},
{0x70, 0x81c7e008},
{0x74, 0x81e80000},
{0x78, 0x9de3bf98},
{0x7c, 0xa8102000},
{0xf0, 0x1d},
{0x00, 0xc20023d4},
{0x04, 0x80a50001},
{0x08, 0x1a800057},
{0x0c, 0xe2002348},
{0x10, 0xa4102000},
{0x14, 0xc200247c},
{0x18, 0x80a48001},
{0x1c, 0x3a80004e},
{0x20, 0xa8052001},
{0x24, 0x7fffffe5},
{0x28, 0x90100012},
{0x2c, 0x92100008},
{0x30, 0x7fffffaf},
{0x34, 0x90100014},
{0x38, 0x80a62000},
{0x3c, 0x12800004},
{0x40, 0xa0100008},
{0x44, 0x10800016},
{0x48, 0xa0102000},
{0x4c, 0x80a62009},
{0x50, 0x18800011},
{0x54, 0x80a62007},
{0x58, 0x4000024d},
{0x5c, 0x01000000},
{0x60, 0x94100008},
{0x64, 0x90100014},
{0x68, 0x40000254},
{0x6c, 0x921ca001},
{0x70, 0x80a20011},
{0x74, 0x04800007},
{0x78, 0xa6100008},
{0x7c, 0x9a102008},
{0xf0, 0x1e},
{0x00, 0x9a234018},
{0x04, 0x82102001},
{0x08, 0x8328400d},
{0x0c, 0xa02c0001},
{0x10, 0x80a62007},
{0x14, 0x18800008},
{0x18, 0x80a62008},
{0x1c, 0x9a102007},
{0x20, 0x9a234018},
{0x24, 0x82102001},
{0x28, 0x8328400d},
{0x2c, 0x10800022},
{0x30, 0xa0140001},
{0x34, 0x1280000a},
{0x38, 0x821e2009},
{0x3c, 0x80a420fe},
{0x40, 0x24800002},
{0x44, 0xa0042001},
{0x48, 0x0300001c},
{0x4c, 0x9b2ca002},
{0x50, 0x82106200},
{0x54, 0x10800018},
{0x58, 0xe6234001},
{0x5c, 0x80a00001},
{0x60, 0x9a603fff},
{0x64, 0x80a420fe},
{0x68, 0x04800003},
{0x6c, 0x82102001},
{0x70, 0x82102000},
{0x74, 0x808b4001},
{0x78, 0x0280000f},
{0x7c, 0x0300001c},
{0xf0, 0x1f},
{0x00, 0x9b2ca002},
{0x04, 0x82106200},
{0x08, 0xc2034001},
{0x0c, 0x80a04011},
{0x10, 0x18800003},
{0x14, 0x9a204011},
{0x18, 0x9a244001},
{0x1c, 0x80a4c011},
{0x20, 0x14800003},
{0x24, 0x8224c011},
{0x28, 0x82244013},
{0x2c, 0x80a34001},
{0x30, 0xa0642000},
{0x34, 0x7fffffa1},
{0x38, 0x90100012},
{0x3c, 0x92100008},
{0x40, 0x90100014},
{0x44, 0x7fffff76},
{0x48, 0x94100010},
{0x4c, 0x10bfffb2},
{0x50, 0xa404a001},
{0x54, 0xc20023d4},
{0x58, 0x80a50001},
{0x5c, 0x0abfffae},
{0x60, 0xa4102000},
{0x64, 0x81c7e008},
{0x68, 0x81e80000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x00000000},
{0xf0, 0x20},
{0x00, 0x83580000},
{0x04, 0x82086ff0},
{0x08, 0x83306004},
{0x0c, 0x80a06005},
{0x10, 0x02800024},
{0x14, 0x01000000},
{0x18, 0x80a06006},
{0x1c, 0x02800039},
{0x20, 0x01000000},
{0x24, 0x80a06015},
{0x28, 0x02800051},
{0x2c, 0x01000000},
{0x30, 0x80a0602a},
{0x34, 0x02800085},
{0x38, 0x01000000},
{0x3c, 0x073fc180},
{0x40, 0x8610e03c},
{0x44, 0x05169680},
{0x48, 0x84004002},
{0x4c, 0xc420c000},
{0x50, 0x073fc000},
{0x54, 0x8610e020},
{0x58, 0x84102001},
{0x5c, 0xc420c000},
{0x60, 0x0500000c},
{0x64, 0x01000000},
{0x68, 0x01000000},
{0x6c, 0x8480bfff},
{0x70, 0x12bffffe},
{0x74, 0x01000000},
{0x78, 0x01000000},
{0x7c, 0x073fc000},
{0xf0, 0x21},
{0x00, 0x8610e020},
{0x04, 0x84102000},
{0x08, 0xc420c000},
{0x0c, 0x01000000},
{0x10, 0x01000000},
{0x14, 0x81c44000},
{0x18, 0x81cc8000},
{0x1c, 0x01000000},
{0x20, 0xa7500000},
{0x24, 0xa92ce002},
{0x28, 0xa734e001},
{0x2c, 0xa614c014},
{0x30, 0xa60ce007},
{0x34, 0x81900000},
{0x38, 0x01000000},
{0x3c, 0x01000000},
{0x40, 0x81e00000},
{0x44, 0xe03ba000},
{0x48, 0xe43ba008},
{0x4c, 0xe83ba010},
{0x50, 0xec3ba018},
{0x54, 0xf03ba020},
{0x58, 0xf43ba028},
{0x5c, 0xf83ba030},
{0x60, 0xfc3ba038},
{0x64, 0x81e80000},
{0x68, 0x8194c000},
{0x6c, 0x01000000},
{0x70, 0x01000000},
{0x74, 0x81c44000},
{0x78, 0x81cc8000},
{0x7c, 0x01000000},
{0xf0, 0x22},
{0x00, 0xa7500000},
{0x04, 0xa934e002},
{0x08, 0xa72ce001},
{0x0c, 0xa614c014},
{0x10, 0xa60ce007},
{0x14, 0x81900000},
{0x18, 0x01000000},
{0x1c, 0x01000000},
{0x20, 0x81e80000},
{0x24, 0x81e80000},
{0x28, 0xe01ba000},
{0x2c, 0xe41ba008},
{0x30, 0xe81ba010},
{0x34, 0xec1ba018},
{0x38, 0xf01ba020},
{0x3c, 0xf41ba028},
{0x40, 0xf81ba030},
{0x44, 0xfc1ba038},
{0x48, 0x81e00000},
{0x4c, 0x81e00000},
{0x50, 0x8194c000},
{0x54, 0x01000000},
{0x58, 0x01000000},
{0x5c, 0x81c44000},
{0x60, 0x81cc8000},
{0x64, 0x01000000},
{0x68, 0x01000000},
{0x6c, 0x82102010},
{0x70, 0x273fc0c0},
{0x74, 0xa614e010},
{0x78, 0xc224c000},
{0x7c, 0x01000000},
{0xf0, 0x23},
{0x00, 0x033fc0c0},
{0x04, 0x82106004},
{0x08, 0xa6102000},
{0x0c, 0xe6204000},
{0x10, 0x01000000},
{0x14, 0x01000000},
{0x18, 0x01000000},
{0x1c, 0xa6102020},
{0x20, 0x83480000},
{0x24, 0x82104013},
{0x28, 0x81884000},
{0x2c, 0x01000000},
{0x30, 0x40000f82},
{0x34, 0x01000000},
{0x38, 0x01000000},
{0x3c, 0x01000000},
{0x40, 0xa7500000},
{0x44, 0xa934e002},
{0x48, 0xa72ce001},
{0x4c, 0xa614c014},
{0x50, 0xa60ce007},
{0x54, 0x81900000},
{0x58, 0x01000000},
{0x5c, 0x81e80000},
{0x60, 0xe01ba000},
{0x64, 0xe41ba008},
{0x68, 0xe81ba010},
{0x6c, 0xec1ba018},
{0x70, 0xf01ba020},
{0x74, 0xf41ba028},
{0x78, 0xf81ba030},
{0x7c, 0xfc1ba038},
{0xf0, 0x24},
{0x00, 0x81e00000},
{0x04, 0x8194c000},
{0x08, 0x01000000},
{0x0c, 0xa6102020},
{0x10, 0x83480000},
{0x14, 0x82284013},
{0x18, 0x81884000},
{0x1c, 0x01000000},
{0x20, 0x033fc0c0},
{0x24, 0x82106004},
{0x28, 0xa6103fff},
{0x2c, 0xe6204000},
{0x30, 0x01000000},
{0x34, 0x01000000},
{0x38, 0x01000000},
{0x3c, 0x81c44000},
{0x40, 0x81cc8000},
{0x44, 0x01000000},
{0x48, 0x81c48000},
{0x4c, 0x81cca004},
{0x50, 0x01000000},
{0x54, 0x01000000},
{0x58, 0x01000000},
{0x5c, 0x01000000},
{0x60, 0x01000000},
{0x64, 0x01000000},
{0x68, 0x01000000},
{0x6c, 0x01000000},
{0x70, 0x01000000},
{0x74, 0x01000000},
{0x78, 0x01000000},
{0x7c, 0x01000000},
{0xf0, 0x25},
{0x00, 0x9de3bf98},
{0x04, 0x7ffffea6},
{0x08, 0x01000000},
{0x0c, 0x7ffffe9d},
{0x10, 0x01000000},
{0x14, 0x40000089},
{0x18, 0x01000000},
{0x1c, 0x7ffffeab},
{0x20, 0x01000000},
{0x24, 0x30bffffe},
{0x28, 0x80a22000},
{0x2c, 0x02800006},
{0x30, 0x01000000},
{0x34, 0x01000000},
{0x38, 0x90823fff},
{0x3c, 0x12bffffe},
{0x40, 0x01000000},
{0x44, 0x81c3e008},
{0x48, 0x01000000},
{0x4c, 0x033fc200},
{0x50, 0x961060a0},
{0x54, 0x98102000},
{0x58, 0x832b2002},
{0x5c, 0x9a03000c},
{0x60, 0xda136400},
{0x64, 0x98032001},
{0x68, 0x80a3201f},
{0x6c, 0x04bffffb},
{0x70, 0xda20400b},
{0x74, 0x81c3e008},
{0x78, 0x01000000},
{0x7c, 0x98102000},
{0xf0, 0x26},
{0x00, 0x9610201e},
{0x04, 0x80a22000},
{0x08, 0x12800003},
{0x0c, 0x8210000c},
{0x10, 0x8222c00c},
{0x14, 0x83286002},
{0x18, 0xda006480},
{0x1c, 0x80a37ff0},
{0x20, 0x02800006},
{0x24, 0x98032002},
{0x28, 0xc2006484},
{0x2c, 0x80a3201f},
{0x30, 0x04bffff5},
{0x34, 0xc2234000},
{0x38, 0x81c3e008},
{0x3c, 0x01000000},
{0x40, 0x193fc180},
{0x44, 0x03202020},
{0x48, 0x9a132038},
{0x4c, 0x82106080},
{0x50, 0xc2234000},
{0x54, 0x03296956},
{0x58, 0x9410625a},
{0x5c, 0xc0230000},
{0x60, 0x031696a9},
{0x64, 0x821061a5},
{0x68, 0xd200254c},
{0x6c, 0x98102500},
{0x70, 0xda00250c},
{0x74, 0x80a3400a},
{0x78, 0x02800005},
{0x7c, 0x96033a50},
{0xf0, 0x27},
{0x00, 0x80a34001},
{0x04, 0x32800009},
{0x08, 0xc0230000},
{0x0c, 0x80a2e05f},
{0x10, 0x28800007},
{0x14, 0x98032004},
{0x18, 0x80a3250c},
{0x1c, 0x22800004},
{0x20, 0x98032004},
{0x24, 0xc0230000},
{0x28, 0x98032004},
{0x2c, 0x80a3273f},
{0x30, 0x28bffff1},
{0x34, 0xda00250c},
{0x38, 0x80a22000},
{0x3c, 0x16800014},
{0x40, 0x98102740},
{0x44, 0x1b296956},
{0x48, 0xc200250c},
{0x4c, 0x9a13625a},
{0x50, 0x80a0400d},
{0x54, 0x033fc180},
{0x58, 0x8210603c},
{0x5c, 0x12800004},
{0x60, 0xc0204000},
{0x64, 0x10800007},
{0x68, 0xc0202748},
{0x6c, 0xc0230000},
{0x70, 0x98032004},
{0x74, 0x80a327bf},
{0x78, 0x28bffffe},
{0x7c, 0xc0230000},
{0xf0, 0x28},
{0x00, 0x80a22000},
{0x04, 0x06800007},
{0x08, 0x033fc200},
{0x0c, 0x0300003f},
{0x10, 0x82106380},
{0x14, 0x820a4001},
{0x18, 0xc220254c},
{0x1c, 0x033fc200},
{0x20, 0x82106030},
{0x24, 0xd6004000},
{0x28, 0x03296956},
{0x2c, 0x8210625a},
{0x30, 0xd800250c},
{0x34, 0xda00254c},
{0x38, 0x80a30001},
{0x3c, 0x9a136010},
{0x40, 0x82102010},
{0x44, 0xc2202574},
{0x48, 0xda20254c},
{0x4c, 0x12800018},
{0x50, 0xd620257c},
{0x54, 0x82102015},
{0x58, 0xc2202500},
{0x5c, 0x94102000},
{0x60, 0x92102000},
{0x64, 0x832aa002},
{0x68, 0xd00063a4},
{0x6c, 0x96102000},
{0x70, 0x980265b0},
{0x74, 0x9b2ae002},
{0x78, 0xc2030000},
{0x7c, 0x9602e001},
{0xf0, 0x29},
{0x00, 0xc222000d},
{0x04, 0x80a2e005},
{0x08, 0x08bffffb},
{0x0c, 0x98032004},
{0x10, 0x9402a001},
{0x14, 0x80a2a003},
{0x18, 0x08bffff3},
{0x1c, 0x92026018},
{0x20, 0x03000004},
{0x24, 0x81c062cc},
{0x28, 0x01000000},
{0x2c, 0x01000000},
{0x30, 0x81c3e008},
{0x34, 0x01000000},
{0x38, 0x9de3bf98},
{0x3c, 0x2f200040},
{0x40, 0x2d3fc200},
{0x44, 0x8215e101},
{0x48, 0xc2258000},
{0x4c, 0x40000c36},
{0x50, 0x90102000},
{0x54, 0x213fc140},
{0x58, 0xda00247c},
{0x5c, 0x98142040},
{0x60, 0xea030000},
{0x64, 0xc20022f8},
{0x68, 0x9b336001},
{0x6c, 0x825b4001},
{0x70, 0xaa0d7c00},
{0x74, 0xaa154001},
{0x78, 0xea230000},
{0x7c, 0x82142004},
{0xf0, 0x2a},
{0x00, 0xea004000},
{0x04, 0xaa0d7ff0},
{0x08, 0xaa15400d},
{0x0c, 0xea204000},
{0x10, 0x8215a080},
{0x14, 0xea004000},
{0x18, 0xaa0d7ff0},
{0x1c, 0xaa15400d},
{0x20, 0xea204000},
{0x24, 0xc2002298},
{0x28, 0x9a15a070},
{0x2c, 0xc2234000},
{0x30, 0x033fc000},
{0x34, 0xda002338},
{0x38, 0x82106030},
{0x3c, 0xda204000},
{0x40, 0x0300003f},
{0x44, 0x9e142058},
{0x48, 0x821063ff},
{0x4c, 0x19000016},
{0x50, 0xc223c000},
{0x54, 0x98132200},
{0x58, 0x96142088},
{0x5c, 0xd822c000},
{0x60, 0x9414208c},
{0x64, 0x23000018},
{0x68, 0xe2228000},
{0x6c, 0xc20023f8},
{0x70, 0x9215a00c},
{0x74, 0xc2224000},
{0x78, 0xc20023fc},
{0x7c, 0x9015a008},
{0xf0, 0x2b},
{0x00, 0xc2220000},
{0x04, 0xa414205c},
{0x08, 0xc0248000},
{0x0c, 0xa6142080},
{0x10, 0xd824c000},
{0x14, 0xa8142084},
{0x18, 0x7fffff4d},
{0x1c, 0xe2250000},
{0x20, 0x9a15a07c},
{0x24, 0xea034000},
{0x28, 0x033ff000},
{0x2c, 0xd0002374},
{0x30, 0xaa2d4001},
{0x34, 0xea234000},
{0x38, 0x033fc1c0},
{0x3c, 0xda002340},
{0x40, 0x82106064},
{0x44, 0xda204000},
{0x48, 0x0300007f},
{0x4c, 0x96142010},
{0x50, 0x821063ff},
{0x54, 0x94142030},
{0x58, 0x1907ffc0},
{0x5c, 0xc222c000},
{0x60, 0xa0142014},
{0x64, 0xd8228000},
{0x68, 0x80a22000},
{0x6c, 0x0280000f},
{0x70, 0xd8240000},
{0x74, 0x932a2010},
{0x78, 0x82022001},
{0x7c, 0x9b2a2004},
{0xf0, 0x2c},
{0x00, 0x83286010},
{0x04, 0x9a02400d},
{0x08, 0x9815a084},
{0x0c, 0xda230000},
{0x10, 0x82004008},
{0x14, 0x9615a088},
{0x18, 0x82006002},
{0x1c, 0x9415a08c},
{0x20, 0xd222c000},
{0x24, 0xc2228000},
{0x28, 0x9a15a030},
{0x2c, 0xc2002344},
{0x30, 0xc2234000},
{0x34, 0x7fffff43},
{0x38, 0x90103fff},
{0x3c, 0x7fffff30},
{0x40, 0x90102001},
{0x44, 0x033fc0c0},
{0x48, 0x9a103fff},
{0x4c, 0x82106004},
{0x50, 0xda204000},
{0x54, 0xee258000},
{0x58, 0x81c7e008},
{0x5c, 0x81e80000},
{0x60, 0x03169696},
{0x64, 0xd8002180},
{0x68, 0x8210625a},
{0x6c, 0x80a30001},
{0x70, 0x96102000},
{0x74, 0x12800007},
{0x78, 0x9a102000},
{0x7c, 0x033fc180},
{0xf0, 0x2d},
{0x00, 0x82106030},
{0x04, 0xd8204000},
{0x08, 0x1080001c},
{0x0c, 0x90102001},
{0x10, 0xc2034000},
{0x14, 0x9a036004},
{0x18, 0x80a364ff},
{0x1c, 0x08bffffd},
{0x20, 0x9602c001},
{0x24, 0x03000014},
{0x28, 0x82106308},
{0x2c, 0x82087f80},
{0x30, 0x9a102d00},
{0x34, 0x80a34001},
{0x38, 0x3a800009},
{0x3c, 0x03169696},
{0x40, 0x98100001},
{0x44, 0xc2034000},
{0x48, 0x9a036004},
{0x4c, 0x80a3400c},
{0x50, 0x0abffffd},
{0x54, 0x9602c001},
{0x58, 0x03169696},
{0x5c, 0x8210625a},
{0x60, 0x821ac001},
{0x64, 0x80a00001},
{0x68, 0x033fc180},
{0x6c, 0x82106030},
{0x70, 0xd6204000},
{0x74, 0x90603fff},
{0x78, 0x81c3e008},
{0x7c, 0x01000000},
{0xf0, 0x2e},
{0x00, 0x9de3be98},
{0x04, 0xb2067fff},
{0x08, 0x96100018},
{0x0c, 0xf227befc},
{0x10, 0xc027bef8},
{0x14, 0x98102000},
{0x18, 0xb007bff8},
{0x1c, 0xd4063f00},
{0x20, 0xda063f04},
{0x24, 0xb810000a},
{0x28, 0x98033fff},
{0x2c, 0xb0063ff8},
{0x30, 0x80a2800d},
{0x34, 0x16800031},
{0x38, 0xb610000d},
{0x3c, 0xbb2aa002},
{0x40, 0x832b6002},
{0x44, 0xb207400b},
{0x48, 0xb400400b},
{0x4c, 0xde02c01d},
{0x50, 0x80a7001b},
{0x54, 0x1680001c},
{0x58, 0x01000000},
{0x5c, 0xc2068000},
{0x60, 0x80a0400f},
{0x64, 0x04800005},
{0x68, 0x80a7001b},
{0x6c, 0xb606ffff},
{0x70, 0x10bffff8},
{0x74, 0xb406bffc},
{0x78, 0x16800013},
{0x7c, 0x80a7001b},
{0xf0, 0x2f},
{0x00, 0xc2068000},
{0x04, 0xc2264000},
{0x08, 0xb8072001},
{0x0c, 0x80a7001b},
{0x10, 0x1680000d},
{0x14, 0xb2066004},
{0x18, 0xc2064000},
{0x1c, 0x80a0400f},
{0x20, 0x26bffffb},
{0x24, 0xb8072001},
{0x28, 0x80a7001b},
{0x2c, 0x16800006},
{0x30, 0x01000000},
{0x34, 0xc2268000},
{0x38, 0xb606ffff},
{0x3c, 0xb406bffc},
{0x40, 0x80a7001b},
{0x44, 0x12bfffe4},
{0x48, 0x80a7001b},
{0x4c, 0xb0062008},
{0x50, 0x82073fff},
{0x54, 0xc2263f04},
{0x58, 0xd4263f00},
{0x5c, 0x832f2002},
{0x60, 0xb0062008},
{0x64, 0xde22c001},
{0x68, 0xba072001},
{0x6c, 0xfa263f00},
{0x70, 0xda263f04},
{0x74, 0x98032002},
{0x78, 0x80a33fff},
{0x7c, 0x34bfffc9},
{0xf0, 0x30},
{0x00, 0xd4063f00},
{0x04, 0x81c7e008},
{0x08, 0x81e80000},
{0x0c, 0x033fc140},
{0x10, 0x82106048},
{0x14, 0xda004000},
{0x18, 0x03000040},
{0x1c, 0x808b4001},
{0x20, 0x03000016},
{0x24, 0x12800003},
{0x28, 0x90106200},
{0x2c, 0x11000018},
{0x30, 0x81c3e008},
{0x34, 0x01000000},
{0x38, 0x9de3bf18},
{0x3c, 0xa12e2002},
{0x40, 0xda1423da},
{0x44, 0xd61423d8},
{0x48, 0xc200247c},
{0x4c, 0xb022c00d},
{0x50, 0x825b4001},
{0x54, 0x92862001},
{0x58, 0x0280000c},
{0x5c, 0x9a004019},
{0x60, 0xb0100009},
{0x64, 0x9807bf78},
{0x68, 0x8203400d},
{0x6c, 0xc2168001},
{0x70, 0xc2230000},
{0x74, 0xc200247c},
{0x78, 0x9a034001},
{0x7c, 0xb0863fff},
{0xf0, 0x31},
{0x00, 0x12bffffa},
{0x04, 0x98032004},
{0x08, 0x7fffff9e},
{0x0c, 0x9007bf78},
{0x10, 0xda1423ea},
{0x14, 0xd61423e8},
{0x18, 0x80a3400b},
{0x1c, 0x92102000},
{0x20, 0x1880000b},
{0x24, 0xb010000d},
{0x28, 0x832b6002},
{0x2c, 0x8200401e},
{0x30, 0x98007f78},
{0x34, 0xc2030000},
{0x38, 0xb0062001},
{0x3c, 0x92024001},
{0x40, 0x80a6000b},
{0x44, 0x08bffffc},
{0x48, 0x98032004},
{0x4c, 0xb022c00d},
{0x50, 0xb0062001},
{0x54, 0x81800000},
{0x58, 0x01000000},
{0x5c, 0x01000000},
{0x60, 0x01000000},
{0x64, 0xb0724018},
{0x68, 0x81c7e008},
{0x6c, 0x81e80000},
{0x70, 0x9de3bf98},
{0x74, 0xda002310},
{0x78, 0x80a36000},
{0x7c, 0x02800055},
{0xf0, 0x32},
{0x00, 0xb0102000},
{0x04, 0xc200254c},
{0x08, 0x80886100},
{0x0c, 0x22800003},
{0x10, 0xc2002594},
{0x14, 0x3080004f},
{0x18, 0x82006001},
{0x1c, 0x80a0400d},
{0x20, 0xc2202594},
{0x24, 0x0a80004b},
{0x28, 0xb0102000},
{0x2c, 0xa2102000},
{0x30, 0xc20023d4},
{0x34, 0x80a44001},
{0x38, 0xc0202594},
{0x3c, 0xa0102000},
{0x40, 0x1a800026},
{0x44, 0xa52c2002},
{0x48, 0xc204a364},
{0x4c, 0x80a06000},
{0x50, 0x0280001e},
{0x54, 0xb0102000},
{0x58, 0xc20022fc},
{0x5c, 0x80a60001},
{0x60, 0x1a80001a},
{0x64, 0x90100010},
{0x68, 0xc200254c},
{0x6c, 0x80886020},
{0x70, 0xc20e2380},
{0x74, 0x1500001b},
{0x78, 0x12800006},
{0x7c, 0x920860ff},
{0xf0, 0x33},
{0x00, 0x15000019},
{0x04, 0x920860ff},
{0x08, 0x9412a200},
{0x0c, 0x90100010},
{0x10, 0x7fffffaa},
{0x14, 0xb0062001},
{0x18, 0xc204a364},
{0x1c, 0xda002348},
{0x20, 0x98020001},
{0x24, 0x82034001},
{0x28, 0x80a20001},
{0x2c, 0x38bfffeb},
{0x30, 0xa2046001},
{0x34, 0x80a3000d},
{0x38, 0x3abfffe9},
{0x3c, 0xc20022fc},
{0x40, 0x10bfffe6},
{0x44, 0xa2046001},
{0x48, 0xa0042001},
{0x4c, 0xc20023d4},
{0x50, 0x10bfffdc},
{0x54, 0x80a40001},
{0x58, 0xd800258c},
{0x5c, 0x80a0000c},
{0x60, 0x9a603fff},
{0x64, 0x80a00011},
{0x68, 0x82603fff},
{0x6c, 0x808b4001},
{0x70, 0x0280000a},
{0x74, 0x80a46000},
{0x78, 0xda00254c},
{0x7c, 0x83336005},
{0xf0, 0x34},
{0x00, 0x82086001},
{0x04, 0x82186001},
{0x08, 0x83286005},
{0x0c, 0x9a0b7fdf},
{0x10, 0x9a134001},
{0x14, 0xda20254c},
{0x18, 0x12800004},
{0x1c, 0x82032001},
{0x20, 0x10800003},
{0x24, 0xc020258c},
{0x28, 0xc220258c},
{0x2c, 0xc200258c},
{0x30, 0x80a06002},
{0x34, 0x08800007},
{0x38, 0xb0102000},
{0x3c, 0xc200254c},
{0x40, 0x1b000040},
{0x44, 0x8210400d},
{0x48, 0xc220254c},
{0x4c, 0xb0102001},
{0x50, 0x81c7e008},
{0x54, 0x81e80000},
{0x58, 0x9de3bf58},
{0x5c, 0xc200254c},
{0x60, 0x8330600b},
{0x64, 0x82086001},
{0x68, 0x80a00001},
{0x6c, 0x9a603fff},
{0x70, 0x8207bfb8},
{0x74, 0xb610200f},
{0x78, 0xc0204000},
{0x7c, 0xb686ffff},
{0xf0, 0x35},
{0x00, 0x1cbffffe},
{0x04, 0x82006004},
{0x08, 0xb0102001},
{0x0c, 0xc2002300},
{0x10, 0x80a60001},
{0x14, 0x38800044},
{0x18, 0xfa002500},
{0x1c, 0x9610201a},
{0x20, 0xb4102001},
{0x24, 0xc2002308},
{0x28, 0x80a68001},
{0x2c, 0x18800038},
{0x30, 0x0300001c},
{0x34, 0xbb2ae002},
{0x38, 0x82106200},
{0x3c, 0xba074001},
{0x40, 0xb2076004},
{0x44, 0x8203400d},
{0x48, 0xfa506210},
{0x4c, 0x80a76000},
{0x50, 0x2280002b},
{0x54, 0xb406a001},
{0x58, 0xc2064000},
{0x5c, 0x80a0401d},
{0x60, 0x36800027},
{0x64, 0xb406a001},
{0x68, 0xbb2e2010},
{0x6c, 0x832ea018},
{0x70, 0x8200401d},
{0x74, 0x9e006001},
{0x78, 0xb6102000},
{0x7c, 0x98102001},
{0xf0, 0x36},
{0x00, 0xba07bfb8},
{0x04, 0xb92ee002},
{0x08, 0xc20f2700},
{0x0c, 0x80a68001},
{0x10, 0x12800011},
{0x14, 0xb606e001},
{0x18, 0xc20f2701},
{0x1c, 0x80a60001},
{0x20, 0x3280000e},
{0x24, 0xc2172700},
{0x28, 0xd8274000},
{0x2c, 0x0300003f},
{0x30, 0xfa172702},
{0x34, 0x821063ff},
{0x38, 0x80a74001},
{0x3c, 0x22800010},
{0x40, 0xb406a001},
{0x44, 0xc2072700},
{0x48, 0x82006001},
{0x4c, 0x1080000b},
{0x50, 0xc2272700},
{0x54, 0xc2172700},
{0x58, 0x80a06000},
{0x5c, 0x12800005},
{0x60, 0x80a6e00f},
{0x64, 0xd8274000},
{0x68, 0x10800004},
{0x6c, 0xde272700},
{0x70, 0x08bfffe5},
{0x74, 0xba076004},
{0x78, 0xb406a001},
{0x7c, 0xc2002308},
{0xf0, 0x37},
{0x00, 0x80a68001},
{0x04, 0x08bfffd0},
{0x08, 0xb2066004},
{0x0c, 0xb0062001},
{0x10, 0xc2002300},
{0x14, 0x80a60001},
{0x18, 0x08bfffc2},
{0x1c, 0x9602e01a},
{0x20, 0xfa002500},
{0x24, 0xc20021f4},
{0x28, 0x80a74001},
{0x2c, 0x1880001d},
{0x30, 0xb0102000},
{0x34, 0xb4102000},
{0x38, 0xb6102000},
{0x3c, 0xb807bff8},
{0x40, 0xbb2ee002},
{0x44, 0x8207401c},
{0x48, 0xc2007fc0},
{0x4c, 0x80a06000},
{0x50, 0x32800004},
{0x54, 0xfa176702},
{0x58, 0x10800005},
{0x5c, 0xc0276700},
{0x60, 0xc20b63cc},
{0x64, 0x80a74001},
{0x68, 0xb466bfff},
{0x6c, 0xb606e001},
{0x70, 0x80a6e00f},
{0x74, 0x08bffff4},
{0x78, 0xbb2ee002},
{0x7c, 0xc20b63ce},
{0xf0, 0x38},
{0x00, 0x80a68001},
{0x04, 0x08800007},
{0x08, 0xb0102000},
{0x0c, 0xc200254c},
{0x10, 0x3b000200},
{0x14, 0x8210401d},
{0x18, 0xc220254c},
{0x1c, 0xb0102001},
{0x20, 0x81c7e008},
{0x24, 0x81e80000},
{0x28, 0x9de3bf98},
{0x2c, 0xf4002200},
{0x30, 0x80a6a000},
{0x34, 0x12800007},
{0x38, 0x9e102001},
{0x3c, 0xc200254c},
{0x40, 0x82087ffb},
{0x44, 0xc220254c},
{0x48, 0x10800043},
{0x4c, 0xc0202588},
{0x50, 0x80a3c01a},
{0x54, 0x1880001c},
{0x58, 0xc0202504},
{0x5c, 0x0300001c},
{0x60, 0x82106200},
{0x64, 0xb0006068},
{0x68, 0xda002308},
{0x6c, 0xb6102001},
{0x70, 0x80a6c00d},
{0x74, 0x38800011},
{0x78, 0x9e03e001},
{0x7c, 0xf2002238},
{0xf0, 0x39},
{0x00, 0xba062004},
{0x04, 0xc2074000},
{0x08, 0xb606e001},
{0x0c, 0xba076004},
{0x10, 0x80a04019},
{0x14, 0x04800005},
{0x18, 0xb8204019},
{0x1c, 0xc2002504},
{0x20, 0x8200401c},
{0x24, 0xc2202504},
{0x28, 0x80a6c00d},
{0x2c, 0x28bffff7},
{0x30, 0xc2074000},
{0x34, 0x9e03e001},
{0x38, 0x80a3c01a},
{0x3c, 0x08bfffec},
{0x40, 0xb0062068},
{0x44, 0xf800254c},
{0x48, 0x808f2008},
{0x4c, 0x12800008},
{0x50, 0xfa002504},
{0x54, 0xc200223c},
{0x58, 0x80a74001},
{0x5c, 0x34800009},
{0x60, 0xc2002588},
{0x64, 0x10800009},
{0x68, 0xc0202588},
{0x6c, 0xc200223c},
{0x70, 0x80a74001},
{0x74, 0x34800005},
{0x78, 0xc0202588},
{0x7c, 0xc2002588},
{0xf0, 0x3a},
{0x00, 0x82006001},
{0x04, 0xc2202588},
{0x08, 0xfa002588},
{0x0c, 0xc2002290},
{0x10, 0x80a74001},
{0x14, 0x2880000b},
{0x18, 0xfa00254c},
{0x1c, 0x83372003},
{0x20, 0x82086001},
{0x24, 0x82186001},
{0x28, 0x83286002},
{0x2c, 0xba0f3ffb},
{0x30, 0xba174001},
{0x34, 0xfa20254c},
{0x38, 0xc0202588},
{0x3c, 0xfa00254c},
{0x40, 0xbb376002},
{0x44, 0x033fc180},
{0x48, 0xba0f6001},
{0x4c, 0x8210602c},
{0x50, 0xfa204000},
{0x54, 0x81c7e008},
{0x58, 0x81e80000},
{0x5c, 0x9de3bf98},
{0x60, 0xfa5023c6},
{0x64, 0x80a76000},
{0x68, 0x0280003d},
{0x6c, 0x9e102001},
{0x70, 0xc20022fc},
{0x74, 0x80a3c001},
{0x78, 0x18800039},
{0x7c, 0x1700001c},
{0xf0, 0x3b},
{0x00, 0x8212e200},
{0x04, 0x9810001d},
{0x08, 0x9a006004},
{0x0c, 0xb6102001},
{0x10, 0xf20022f8},
{0x14, 0x80a6c019},
{0x18, 0xb4102000},
{0x1c, 0x1880002b},
{0x20, 0x82102000},
{0x24, 0xf05023c4},
{0x28, 0xba036068},
{0x2c, 0xf8074000},
{0x30, 0xb606e001},
{0x34, 0x80a70018},
{0x38, 0x06800004},
{0x3c, 0xba076068},
{0x40, 0xb406801c},
{0x44, 0x82006001},
{0x48, 0x80a6c019},
{0x4c, 0x28bffff9},
{0x50, 0xf8074000},
{0x54, 0x80a06000},
{0x58, 0x2280001d},
{0x5c, 0x9e03e001},
{0x60, 0x953ea01f},
{0x64, 0x8182a000},
{0x68, 0x01000000},
{0x6c, 0x01000000},
{0x70, 0x01000000},
{0x74, 0x827e8001},
{0x78, 0x8258400c},
{0x7c, 0xbb38601f},
{0xf0, 0x3c},
{0x00, 0xbb376016},
{0x04, 0x8200401d},
{0x08, 0xb6102001},
{0x0c, 0xfa0022f8},
{0x10, 0x80a6c01d},
{0x14, 0x1880000d},
{0x18, 0xb538600a},
{0x1c, 0x832be002},
{0x20, 0xba006068},
{0x24, 0xb812e200},
{0x28, 0xc207401c},
{0x2c, 0x8220401a},
{0x30, 0xc227401c},
{0x34, 0xb606e001},
{0x38, 0xc20022f8},
{0x3c, 0x80a6c001},
{0x40, 0x08bffffa},
{0x44, 0xba076068},
{0x48, 0x9e03e001},
{0x4c, 0xc20022fc},
{0x50, 0x80a3c001},
{0x54, 0x08bfffce},
{0x58, 0x9a036004},
{0x5c, 0x81c7e008},
{0x60, 0x81e80000},
{0x64, 0x9de3bf18},
{0x68, 0xe2502458},
{0x6c, 0x80a46000},
{0x70, 0x02800058},
{0x74, 0x01000000},
{0x78, 0xc20022f8},
{0x7c, 0x80a44001},
{0xf0, 0x3d},
{0x00, 0x1a800054},
{0x04, 0xa0102001},
{0x08, 0xc20022fc},
{0x0c, 0x80a40001},
{0x10, 0x18800050},
{0x14, 0xe450245a},
{0x18, 0x96102001},
{0x1c, 0xc20022f8},
{0x20, 0x80a2c001},
{0x24, 0x1880000f},
{0x28, 0x0300001c},
{0x2c, 0x9b2c2002},
{0x30, 0x82106200},
{0x34, 0x9a034001},
{0x38, 0x9a036068},
{0x3c, 0x9807bf78},
{0x40, 0xc2034000},
{0x44, 0xc2230000},
{0x48, 0x9602e001},
{0x4c, 0xc20022f8},
{0x50, 0x80a2c001},
{0x54, 0x9a036068},
{0x58, 0x08bffffa},
{0x5c, 0x98032004},
{0x60, 0x9007bf78},
{0x64, 0x7ffffe07},
{0x68, 0xd20022f8},
{0x6c, 0x96100012},
{0x70, 0x80a48011},
{0x74, 0x1480000b},
{0x78, 0x94102000},
{0x7c, 0x832ca002},
{0xf0, 0x3e},
{0x00, 0x8200401e},
{0x04, 0x9a007f78},
{0x08, 0xc2034000},
{0x0c, 0x9602e001},
{0x10, 0x94028001},
{0x14, 0x80a2c011},
{0x18, 0x04bffffc},
{0x1c, 0x9a036004},
{0x20, 0x82244012},
{0x24, 0x82006001},
{0x28, 0x9b3aa01f},
{0x2c, 0x81836000},
{0x30, 0x01000000},
{0x34, 0x01000000},
{0x38, 0x01000000},
{0x3c, 0x947a8001},
{0x40, 0xc25021ac},
{0x44, 0x80a28001},
{0x48, 0x26800002},
{0x4c, 0x94100001},
{0x50, 0x96102001},
{0x54, 0xc20022f8},
{0x58, 0x80a2c001},
{0x5c, 0x18800018},
{0x60, 0x9b2c2002},
{0x64, 0x0300001c},
{0x68, 0x92106200},
{0x6c, 0x98036068},
{0x70, 0xc2030009},
{0x74, 0x9a20400a},
{0x78, 0xda230009},
{0x7c, 0xc20023c8},
{0xf0, 0x3f},
{0x00, 0x83306012},
{0x04, 0x80886001},
{0x08, 0x02800009},
{0x0c, 0x9602e001},
{0x10, 0xc20c22af},
{0x14, 0x825b4001},
{0x18, 0x9b38601f},
{0x1c, 0x9b336019},
{0x20, 0x8200400d},
{0x24, 0x83386007},
{0x28, 0xc2230009},
{0x2c, 0xc20022f8},
{0x30, 0x80a2c001},
{0x34, 0x08bfffef},
{0x38, 0x98032068},
{0x3c, 0xa0042001},
{0x40, 0xc20022fc},
{0x44, 0x80a40001},
{0x48, 0x08bfffb5},
{0x4c, 0x96102001},
{0x50, 0x81c7e008},
{0x54, 0x81e80000},
{0x58, 0x9de3bf38},
{0x5c, 0x1b00003f},
{0x60, 0xc2002350},
{0x64, 0x9a1363ff},
{0x68, 0xba08400d},
{0x6c, 0xa4102001},
{0x70, 0xda002300},
{0x74, 0x80a4800d},
{0x78, 0x18800058},
{0x7c, 0xa3306010},
{0xf0, 0x40},
{0x00, 0xae10201a},
{0x04, 0xac10201a},
{0x08, 0xaa102000},
{0x0c, 0xa8102000},
{0x10, 0xa6102000},
{0x14, 0x80a46000},
{0x18, 0x0280002c},
{0x1c, 0xa0102000},
{0x20, 0x0300001c},
{0x24, 0x96106200},
{0x28, 0x92102000},
{0x2c, 0x9807bf98},
{0x30, 0x8204c009},
{0x34, 0xda086440},
{0x38, 0x8205800d},
{0x3c, 0x80a36000},
{0x40, 0x02800008},
{0x44, 0x83286002},
{0x48, 0xc200400b},
{0x4c, 0xc2230000},
{0x50, 0x92026001},
{0x54, 0x80a2600b},
{0x58, 0x04bffff6},
{0x5c, 0x98032004},
{0x60, 0x7ffffda8},
{0x64, 0x9007bf98},
{0x68, 0x80a74011},
{0x6c, 0x1480000b},
{0x70, 0x9210001d},
{0x74, 0x832f6002},
{0x78, 0x8200401e},
{0x7c, 0x9a007f98},
{0xf0, 0x41},
{0x00, 0xc2034000},
{0x04, 0x92026001},
{0x08, 0xa0040001},
{0x0c, 0x80a24011},
{0x10, 0x04bffffc},
{0x14, 0x9a036004},
{0x18, 0x8224401d},
{0x1c, 0x82006001},
{0x20, 0x9b3c201f},
{0x24, 0x81836000},
{0x28, 0x01000000},
{0x2c, 0x01000000},
{0x30, 0x01000000},
{0x34, 0xa07c0001},
{0x38, 0xc25021ae},
{0x3c, 0x80a40001},
{0x40, 0x26800002},
{0x44, 0xa0100001},
{0x48, 0x92102000},
{0x4c, 0x1100001c},
{0x50, 0x82050009},
{0x54, 0xda086440},
{0x58, 0x8205c00d},
{0x5c, 0x92026001},
{0x60, 0x94122200},
{0x64, 0x80a36000},
{0x68, 0x02800011},
{0x6c, 0x97286002},
{0x70, 0xc20023c8},
{0x74, 0x83306011},
{0x78, 0xda02c00a},
{0x7c, 0x80886001},
{0xf0, 0x42},
{0x00, 0x02800008},
{0x04, 0x98234010},
{0x08, 0xda0ca2af},
{0x0c, 0x9a5b000d},
{0x10, 0x833b601f},
{0x14, 0x83306019},
{0x18, 0x9a034001},
{0x1c, 0x993b6007},
{0x20, 0x80a2600b},
{0x24, 0x04bfffeb},
{0x28, 0xd822c00a},
{0x2c, 0xaa056001},
{0x30, 0xa604e00c},
{0x34, 0x80a56001},
{0x38, 0x04bfffb7},
{0x3c, 0xa805200c},
{0x40, 0xa404a001},
{0x44, 0xc2002300},
{0x48, 0x80a48001},
{0x4c, 0xac05a01a},
{0x50, 0x08bfffae},
{0x54, 0xae05e01a},
{0x58, 0xc2082247},
{0x5c, 0x80a06000},
{0x60, 0x02800037},
{0x64, 0x01000000},
{0x68, 0xc20022f8},
{0x6c, 0x80a48001},
{0x70, 0x18800033},
{0x74, 0xa05ca068},
{0x78, 0xa2100010},
{0x7c, 0x92102001},
{0xf0, 0x43},
{0x00, 0xc20022fc},
{0x04, 0x80a24001},
{0x08, 0x1880000e},
{0x0c, 0x0300001c},
{0x10, 0x82106200},
{0x14, 0x82044001},
{0x18, 0x9a006004},
{0x1c, 0x9807bf98},
{0x20, 0xc2034000},
{0x24, 0xc2230000},
{0x28, 0x92026001},
{0x2c, 0xc20022fc},
{0x30, 0x80a24001},
{0x34, 0x9a036004},
{0x38, 0x08bffffa},
{0x3c, 0x98032004},
{0x40, 0x9007bf98},
{0x44, 0x7ffffd4f},
{0x48, 0xd20022fc},
{0x4c, 0xc2082247},
{0x50, 0x83286002},
{0x54, 0x8200401e},
{0x58, 0xd8007f98},
{0x5c, 0x80a32000},
{0x60, 0x26800012},
{0x64, 0xa404a001},
{0x68, 0x92102001},
{0x6c, 0xc20022fc},
{0x70, 0x80a24001},
{0x74, 0x1880000c},
{0x78, 0x0300001c},
{0x7c, 0x96106200},
{0xf0, 0x44},
{0x00, 0x9a042004},
{0x04, 0xc203400b},
{0x08, 0x8220400c},
{0x0c, 0xc223400b},
{0x10, 0x92026001},
{0x14, 0xc20022fc},
{0x18, 0x80a24001},
{0x1c, 0x08bffffa},
{0x20, 0x9a036004},
{0x24, 0xa404a001},
{0x28, 0xc20022f8},
{0x2c, 0x80a48001},
{0x30, 0xa2046068},
{0x34, 0x08bfffd2},
{0x38, 0xa0042068},
{0x3c, 0x81c7e008},
{0x40, 0x81e80000},
{0x44, 0x1b000800},
{0x48, 0x9a136040},
{0x4c, 0xc20023c8},
{0x50, 0x8208400d},
{0x54, 0x80a0400d},
{0x58, 0x1280001f},
{0x5c, 0x90102002},
{0x60, 0xc2002300},
{0x64, 0xda002308},
{0x68, 0x82006001},
{0x6c, 0x83306001},
{0x70, 0x80a2000d},
{0x74, 0x9a006001},
{0x78, 0x18800017},
{0x7c, 0x98007fff},
{0xf0, 0x45},
{0x00, 0x825b6068},
{0x04, 0x1b00001c},
{0x08, 0x985b2068},
{0x0c, 0x92136200},
{0x10, 0x94006008},
{0x14, 0x98032008},
{0x18, 0x9a136268},
{0x1c, 0xd603000d},
{0x20, 0xc2030009},
{0x24, 0xc223000d},
{0x28, 0xd6230009},
{0x2c, 0xc2028009},
{0x30, 0xd602800d},
{0x34, 0xc222800d},
{0x38, 0xd6228009},
{0x3c, 0x90022002},
{0x40, 0xc2002308},
{0x44, 0x80a20001},
{0x48, 0x98032008},
{0x4c, 0x08bffff4},
{0x50, 0x9402a008},
{0x54, 0x81c3e008},
{0x58, 0x01000000},
{0x5c, 0x9de3bf98},
{0x60, 0xd0002214},
{0x64, 0x80a22000},
{0x68, 0x02800072},
{0x6c, 0x96102001},
{0x70, 0xc20022f8},
{0x74, 0x80a2c001},
{0x78, 0x1880006e},
{0x7c, 0x9810201a},
{0xf0, 0x46},
{0x00, 0xb6102001},
{0x04, 0xfa0022fc},
{0x08, 0x80a6c01d},
{0x0c, 0x38800065},
{0x10, 0x9602e001},
{0x14, 0x1500001c},
{0x18, 0xa212a204},
{0x1c, 0x8203001b},
{0x20, 0xb9286002},
{0x24, 0x8212a200},
{0x28, 0xf4070001},
{0x2c, 0x80a68008},
{0x30, 0x24800057},
{0x34, 0xb606e001},
{0x38, 0x8212a1fc},
{0x3c, 0xc2070001},
{0x40, 0x80a68001},
{0x44, 0x26800052},
{0x48, 0xb606e001},
{0x4c, 0xc2070011},
{0x50, 0x80a68001},
{0x54, 0x2480004e},
{0x58, 0xb606e001},
{0x5c, 0xc20023c8},
{0x60, 0x80886040},
{0x64, 0x0280000a},
{0x68, 0x9206e001},
{0x6c, 0x83376001},
{0x70, 0x80a6c001},
{0x74, 0x28800007},
{0x78, 0x9a102000},
{0x7c, 0x8227401b},
{0xf0, 0x47},
{0x00, 0xb6006001},
{0x04, 0x10800003},
{0x08, 0x9a102001},
{0x0c, 0x9a102000},
{0x10, 0xfa00221c},
{0x14, 0xc2002220},
{0x18, 0xba5f401b},
{0x1c, 0xba074001},
{0x20, 0xba5e801d},
{0x24, 0x833f601f},
{0x28, 0x83306016},
{0x2c, 0xba074001},
{0x30, 0xc2002224},
{0x34, 0x8258401b},
{0x38, 0xbb3f600a},
{0x3c, 0xba074001},
{0x40, 0xc2002240},
{0x44, 0x9e074001},
{0x48, 0xc2002218},
{0x4c, 0xb806c001},
{0x50, 0x2100001c},
{0x54, 0xc20023c8},
{0x58, 0x80886040},
{0x5c, 0x0280000e},
{0x60, 0xb0142200},
{0x64, 0xfa0022fc},
{0x68, 0x82076001},
{0x6c, 0x83306001},
{0x70, 0x80a70001},
{0x74, 0x18800024},
{0x78, 0xbb376001},
{0x7c, 0x80a36000},
{0xf0, 0x48},
{0x00, 0x32800006},
{0x04, 0xc20022fc},
{0x08, 0x80a7001d},
{0x0c, 0x1880001f},
{0x10, 0xb6100009},
{0x14, 0xc20022fc},
{0x18, 0xba20401c},
{0x1c, 0x80a70001},
{0x20, 0x18800019},
{0x24, 0xba076001},
{0x28, 0x80a36000},
{0x2c, 0x22800002},
{0x30, 0xba10001c},
{0x34, 0x8203001d},
{0x38, 0xb7286002},
{0x3c, 0xc206c018},
{0x40, 0xb220400f},
{0x44, 0xf226c018},
{0x48, 0xfa002228},
{0x4c, 0x8227001d},
{0x50, 0x80a7001d},
{0x54, 0xb45bc001},
{0x58, 0x04bfffdf},
{0x5c, 0xb8072001},
{0x60, 0xc200222c},
{0x64, 0x825e8001},
{0x68, 0xbb38601f},
{0x6c, 0xbb376018},
{0x70, 0x8200401d},
{0x74, 0x83386008},
{0x78, 0x82264001},
{0x7c, 0x10bfffd6},
{0xf0, 0x49},
{0x00, 0xc226c018},
{0x04, 0xb6100009},
{0x08, 0xb606e001},
{0x0c, 0xfa0022fc},
{0x10, 0x80a6c01d},
{0x14, 0x08bfffa3},
{0x18, 0x8203001b},
{0x1c, 0x9602e001},
{0x20, 0xc20022f8},
{0x24, 0x80a2c001},
{0x28, 0x08bfff96},
{0x2c, 0x9803201a},
{0x30, 0x81c7e008},
{0x34, 0x81e80000},
{0x38, 0x9de3bf98},
{0x3c, 0xd6002214},
{0x40, 0x80a2e000},
{0x44, 0x02800060},
{0x48, 0x9a102001},
{0x4c, 0xc20022fc},
{0x50, 0x80a34001},
{0x54, 0x1880005c},
{0x58, 0x1100001c},
{0x5c, 0xb0102001},
{0x60, 0xf60022f8},
{0x64, 0x80a6001b},
{0x68, 0x18800052},
{0x6c, 0x832b6002},
{0x70, 0xb2006068},
{0x74, 0x1500001c},
{0x78, 0x92122268},
{0x7c, 0xb412a200},
{0xf0, 0x4a},
{0x00, 0xf806401a},
{0x04, 0x80a7000b},
{0x08, 0x24800046},
{0x0c, 0xb0062001},
{0x10, 0x8212a198},
{0x14, 0xc2064001},
{0x18, 0x80a70001},
{0x1c, 0x26800041},
{0x20, 0xb0062001},
{0x24, 0xc2064009},
{0x28, 0x80a70001},
{0x2c, 0x2480003d},
{0x30, 0xb0062001},
{0x34, 0xfa00221c},
{0x38, 0xc2002220},
{0x3c, 0xba5f4018},
{0x40, 0xba074001},
{0x44, 0xba5f001d},
{0x48, 0x833f601f},
{0x4c, 0x83306016},
{0x50, 0xba074001},
{0x54, 0xc2002224},
{0x58, 0x82584018},
{0x5c, 0xbb3f600a},
{0x60, 0xba074001},
{0x64, 0xc2002218},
{0x68, 0xb8060001},
{0x6c, 0xc2002240},
{0x70, 0x80a7001b},
{0x74, 0x18800028},
{0x78, 0x98074001},
{0x7c, 0x825f201a},
{0xf0, 0x4b},
{0x00, 0x8200400d},
{0x04, 0x9e10001a},
{0x08, 0xb5286002},
{0x0c, 0xc206800f},
{0x10, 0x8220400c},
{0x14, 0xc226800f},
{0x18, 0xfa002228},
{0x1c, 0x80a7001d},
{0x20, 0x24800019},
{0x24, 0xb8072001},
{0x28, 0xc20023c8},
{0x2c, 0x80886080},
{0x30, 0x02800008},
{0x34, 0xb6076001},
{0x38, 0x80a7001b},
{0x3c, 0x32800006},
{0x40, 0x8210001c},
{0x44, 0xc20022f8},
{0x48, 0x10800003},
{0x4c, 0x82006001},
{0x50, 0x8210001c},
{0x54, 0xba20401d},
{0x58, 0xc200222c},
{0x5c, 0xba5b001d},
{0x60, 0xba5f4001},
{0x64, 0x833f601f},
{0x68, 0x83306018},
{0x6c, 0xba074001},
{0x70, 0xc206800f},
{0x74, 0xbb3f6008},
{0x78, 0x8220401d},
{0x7c, 0xc226800f},
{0xf0, 0x4c},
{0x00, 0xb8072001},
{0x04, 0xc20022f8},
{0x08, 0x80a70001},
{0x0c, 0x08bfffe0},
{0x10, 0xb406a068},
{0x14, 0xb0062001},
{0x18, 0xb2066068},
{0x1c, 0xb0062001},
{0x20, 0xf60022f8},
{0x24, 0x80a6001b},
{0x28, 0x08bfffb5},
{0x2c, 0xb2066068},
{0x30, 0x9a036001},
{0x34, 0xc20022fc},
{0x38, 0x80a34001},
{0x3c, 0x08bfffa9},
{0x40, 0xb0102001},
{0x44, 0x81c7e008},
{0x48, 0x81e80000},
{0x4c, 0x9de3bf98},
{0x50, 0xc20023d0},
{0x54, 0x80a06000},
{0x58, 0x02800050},
{0x5c, 0xb2102001},
{0x60, 0xc2002300},
{0x64, 0x80a64001},
{0x68, 0x18800025},
{0x6c, 0x0300001c},
{0x70, 0x98106200},
{0x74, 0x9e106208},
{0x78, 0x9a106204},
{0x7c, 0xb01061fc},
{0xf0, 0x4d},
{0x00, 0xb410201a},
{0x04, 0xb6102068},
{0x08, 0xc24823d2},
{0x0c, 0xfa06c00d},
{0x10, 0xba5f4001},
{0x14, 0x833f601f},
{0x18, 0x83306019},
{0x1c, 0xba074001},
{0x20, 0xc206c00f},
{0x24, 0xbb3f6007},
{0x28, 0x8220401d},
{0x2c, 0xc226c00f},
{0x30, 0xf8002308},
{0x34, 0xb806801c},
{0x38, 0xb92f2002},
{0x3c, 0xc24823d3},
{0x40, 0xfa07000c},
{0x44, 0xba5f4001},
{0x48, 0x833f601f},
{0x4c, 0x83306019},
{0x50, 0xba074001},
{0x54, 0xc2070018},
{0x58, 0xbb3f6007},
{0x5c, 0x8220401d},
{0x60, 0xc2270018},
{0x64, 0xb2066001},
{0x68, 0xc2002300},
{0x6c, 0x80a64001},
{0x70, 0xb606e068},
{0x74, 0x08bfffe5},
{0x78, 0xb406a01a},
{0x7c, 0xb6102001},
{0xf0, 0x4e},
{0x00, 0xc2002308},
{0x04, 0x80a6c001},
{0x08, 0x18800024},
{0x0c, 0x0300001c},
{0x10, 0x9e106200},
{0x14, 0xb21062d0},
{0x18, 0xb0106268},
{0x1c, 0xb4106198},
{0x20, 0xb92ee002},
{0x24, 0xc24823d0},
{0x28, 0xfa070018},
{0x2c, 0xba5f4001},
{0x30, 0x833f601f},
{0x34, 0x83306019},
{0x38, 0xba074001},
{0x3c, 0xc2070019},
{0x40, 0xbb3f6007},
{0x44, 0x8220401d},
{0x48, 0xc2270019},
{0x4c, 0xf8002300},
{0x50, 0xb85f201a},
{0x54, 0xb807001b},
{0x58, 0xb92f2002},
{0x5c, 0xc24823d1},
{0x60, 0xfa07000f},
{0x64, 0xba5f4001},
{0x68, 0x833f601f},
{0x6c, 0x83306019},
{0x70, 0xba074001},
{0x74, 0xc207001a},
{0x78, 0xbb3f6007},
{0x7c, 0x8220401d},
{0xf0, 0x4f},
{0x00, 0xc227001a},
{0x04, 0xb606e001},
{0x08, 0xc2002308},
{0x0c, 0x80a6c001},
{0x10, 0x08bfffe5},
{0x14, 0xb92ee002},
{0x18, 0x81c7e008},
{0x1c, 0x81e80000},
{0x20, 0x9de3bf70},
{0x24, 0x92102001},
{0x28, 0xd0002300},
{0x2c, 0x80a24008},
{0x30, 0x1880001a},
{0x34, 0x9e102000},
{0x38, 0x0300001c},
{0x3c, 0x82106200},
{0x40, 0x82006068},
{0x44, 0xd6002308},
{0x48, 0x94102001},
{0x4c, 0x80a2800b},
{0x50, 0x3880000f},
{0x54, 0x92026001},
{0x58, 0x9a006004},
{0x5c, 0xd8034000},
{0x60, 0x80a3000f},
{0x64, 0x04800005},
{0x68, 0x9a036004},
{0x6c, 0x9e10000c},
{0x70, 0xa0100009},
{0x74, 0xa410000a},
{0x78, 0x9402a001},
{0x7c, 0x80a2800b},
{0xf0, 0x50},
{0x00, 0x28bffff8},
{0x04, 0xd8034000},
{0x08, 0x92026001},
{0x0c, 0x80a24008},
{0x10, 0x08bfffee},
{0x14, 0x82006068},
{0x18, 0xa2042001},
{0x1c, 0x92043fff},
{0x20, 0x80a24011},
{0x24, 0x1480002c},
{0x28, 0x9e102000},
{0x2c, 0x0300001c},
{0x30, 0xa6106200},
{0x34, 0xa004a001},
{0x38, 0x905a601a},
{0x3c, 0x9404bfff},
{0x40, 0x80a28010},
{0x44, 0x14800020},
{0x48, 0x8202000a},
{0x4c, 0x9b2be002},
{0x50, 0x83286002},
{0x54, 0x9a03401e},
{0x58, 0x96004013},
{0x5c, 0x9a037fd0},
{0x60, 0x833aa01f},
{0x64, 0x8220400a},
{0x68, 0x80a26000},
{0x6c, 0x0480000f},
{0x70, 0x9930601f},
{0x74, 0xc2002300},
{0x78, 0x80a04009},
{0x7c, 0x82603fff},
{0xf0, 0x51},
{0x00, 0x8088400c},
{0x04, 0x2280000a},
{0x08, 0xc0234000},
{0x0c, 0xc2002308},
{0x10, 0x80a28001},
{0x14, 0x38800006},
{0x18, 0xc0234000},
{0x1c, 0xc202c000},
{0x20, 0x10800003},
{0x24, 0xc2234000},
{0x28, 0xc0234000},
{0x2c, 0x9402a001},
{0x30, 0x9e03e001},
{0x34, 0x9a036004},
{0x38, 0x80a28010},
{0x3c, 0x04bfffe9},
{0x40, 0x9602e004},
{0x44, 0x92026001},
{0x48, 0x80a24011},
{0x4c, 0x04bfffdc},
{0x50, 0x9002201a},
{0x54, 0x92102009},
{0x58, 0x7ffffb8a},
{0x5c, 0x9007bfd0},
{0x60, 0xc207bfec},
{0x64, 0xd807bfe8},
{0x68, 0x98030001},
{0x6c, 0xc207bff0},
{0x70, 0x98030001},
{0x74, 0xda082347},
{0x78, 0x9a036001},
{0x7c, 0xc200256c},
{0xf0, 0x52},
{0x00, 0x8258400d},
{0x04, 0xd608257f},
{0x08, 0x9602e001},
{0x0c, 0x9b33201f},
{0x10, 0x9803000d},
{0x14, 0x81800000},
{0x18, 0x01000000},
{0x1c, 0x01000000},
{0x20, 0x01000000},
{0x24, 0x8270400b},
{0x28, 0xc220256c},
{0x2c, 0x993b2001},
{0x30, 0x94102000},
{0x34, 0x92102c18},
{0x38, 0x972aa002},
{0x3c, 0xc212e3b4},
{0x40, 0x825b0001},
{0x44, 0x9b38601f},
{0x48, 0x9b336018},
{0x4c, 0x8200400d},
{0x50, 0xda12e3b6},
{0x54, 0x83386008},
{0x58, 0x8200400d},
{0x5c, 0xda00256c},
{0x60, 0x8258400d},
{0x64, 0x83306007},
{0x68, 0x9402a001},
{0x6c, 0x80a06c18},
{0x70, 0x04800003},
{0x74, 0xc222e520},
{0x78, 0xd222e520},
{0x7c, 0x80a2a003},
{0xf0, 0x53},
{0x00, 0x04bfffef},
{0x04, 0x972aa002},
{0x08, 0xc20023c0},
{0x0c, 0x80a06000},
{0x10, 0x02800007},
{0x14, 0x82103001},
{0x18, 0xc2002200},
{0x1c, 0x80a06000},
{0x20, 0x22800005},
{0x24, 0xc200259c},
{0x28, 0x82103001},
{0x2c, 0xc220252c},
{0x30, 0xc200259c},
{0x34, 0x80a06000},
{0x38, 0x02800005},
{0x3c, 0xc2002288},
{0x40, 0x9b306001},
{0x44, 0x83306002},
{0x48, 0x8200400d},
{0x4c, 0xc220251c},
{0x50, 0x81c7e008},
{0x54, 0x81e80000},
{0x58, 0x9de3bf98},
{0x5c, 0x825e601a},
{0x60, 0x82004018},
{0x64, 0x3b00001c},
{0x68, 0x83286002},
{0x6c, 0xba176200},
{0x70, 0x9a066001},
{0x74, 0xde00401d},
{0x78, 0xb2067fff},
{0x7c, 0xc2002478},
{0xf0, 0x54},
{0x00, 0x9823c001},
{0x04, 0x80a6400d},
{0x08, 0xb4062001},
{0x0c, 0x14800028},
{0x10, 0x96102000},
{0x14, 0x9410001d},
{0x18, 0xb85e601a},
{0x1c, 0xb006bffe},
{0x20, 0x833e601f},
{0x24, 0xba070018},
{0x28, 0x82204019},
{0x2c, 0xbb2f6002},
{0x30, 0xb730601f},
{0x34, 0xba07400a},
{0x38, 0x80a62000},
{0x3c, 0x24800015},
{0x40, 0xb0062001},
{0x44, 0xc2002308},
{0x48, 0x80a04018},
{0x4c, 0x82603fff},
{0x50, 0x8088401b},
{0x54, 0x2280000f},
{0x58, 0xb0062001},
{0x5c, 0xc2002300},
{0x60, 0x80a64001},
{0x64, 0x3880000b},
{0x68, 0xb0062001},
{0x6c, 0xc2074000},
{0x70, 0x80a0400f},
{0x74, 0x04800004},
{0x78, 0x80a0400c},
{0x7c, 0x1080000d},
{0xf0, 0x55},
{0x00, 0xb0102000},
{0x04, 0x24800002},
{0x08, 0x96102001},
{0x0c, 0xb0062001},
{0x10, 0x80a6001a},
{0x14, 0x04bfffe9},
{0x18, 0xba076004},
{0x1c, 0xb2066001},
{0x20, 0x80a6400d},
{0x24, 0x04bfffde},
{0x28, 0xb807201a},
{0x2c, 0xb010000b},
{0x30, 0x81c7e008},
{0x34, 0x81e80000},
{0x38, 0x9de3bf58},
{0x3c, 0xc208224d},
{0x40, 0x80a06000},
{0x44, 0x02800067},
{0x48, 0x96102000},
{0x4c, 0x90067ffe},
{0x50, 0xac066002},
{0x54, 0x80a20016},
{0x58, 0x14800040},
{0x5c, 0x9e102000},
{0x60, 0xa6062002},
{0x64, 0xa05a201a},
{0x68, 0x92063ffe},
{0x6c, 0x80a24013},
{0x70, 0x14800036},
{0x74, 0x9b3a201f},
{0x78, 0x98064019},
{0x7c, 0x98230008},
{0xf0, 0x56},
{0x00, 0x972be002},
{0x04, 0x94040009},
{0x08, 0x0300001c},
{0x0c, 0x9a234008},
{0x10, 0xae106200},
{0x14, 0x9602c01e},
{0x18, 0x952aa002},
{0x1c, 0xa85b201a},
{0x20, 0xab33601f},
{0x24, 0x9602ffb8},
{0x28, 0x94028017},
{0x2c, 0xa4063fff},
{0x30, 0xa2062001},
{0x34, 0x98067fff},
{0x38, 0x82060018},
{0x3c, 0x82204009},
{0x40, 0x82050001},
{0x44, 0x80a24012},
{0x48, 0x0680000b},
{0x4c, 0x9b286002},
{0x50, 0x80a24011},
{0x54, 0x14800009},
{0x58, 0x80a26000},
{0x5c, 0x80a2000c},
{0x60, 0x06800005},
{0x64, 0x82066001},
{0x68, 0x80a20001},
{0x6c, 0x24800014},
{0x70, 0x92026001},
{0x74, 0x80a26000},
{0x78, 0x2480000d},
{0x7c, 0xc2034017},
{0xf0, 0x57},
{0x00, 0xc2002308},
{0x04, 0x80a04009},
{0x08, 0x82603fff},
{0x0c, 0x80884015},
{0x10, 0x22800007},
{0x14, 0xc2034017},
{0x18, 0xc2002300},
{0x1c, 0x80a20001},
{0x20, 0x38800003},
{0x24, 0xc2034017},
{0x28, 0xc2028000},
{0x2c, 0xc222c000},
{0x30, 0x9e03e001},
{0x34, 0x9602e004},
{0x38, 0x92026001},
{0x3c, 0x80a24013},
{0x40, 0x04bfffde},
{0x44, 0x9402a004},
{0x48, 0x90022001},
{0x4c, 0x80a20016},
{0x50, 0x04bfffc6},
{0x54, 0xa004201a},
{0x58, 0x9007bfb8},
{0x5c, 0x7ffffac9},
{0x60, 0x92102010},
{0x64, 0xda08224f},
{0x68, 0xb00b60ff},
{0x6c, 0xd608224d},
{0x70, 0x80a6000b},
{0x74, 0x1480000b},
{0x78, 0x9e102000},
{0x7c, 0x832e2002},
{0xf0, 0x58},
{0x00, 0x8200401e},
{0x04, 0x98007fb8},
{0x08, 0xc2030000},
{0x0c, 0xb0062001},
{0x10, 0x9e03c001},
{0x14, 0x80a6000b},
{0x18, 0x04bffffc},
{0x1c, 0x98032004},
{0x20, 0x9a0b60ff},
{0x24, 0xc208224d},
{0x28, 0x8220400d},
{0x2c, 0xda08224c},
{0x30, 0x82006001},
{0x34, 0x9a5bc00d},
{0x38, 0x993b601f},
{0x3c, 0x81832000},
{0x40, 0x01000000},
{0x44, 0x01000000},
{0x48, 0x01000000},
{0x4c, 0x9a7b4001},
{0x50, 0x833b601f},
{0x54, 0x83306019},
{0x58, 0x9a034001},
{0x5c, 0x973b6007},
{0x60, 0x81c7e008},
{0x64, 0x91e8000b},
{0x68, 0x9de3bf88},
{0x6c, 0xa410001b},
{0x70, 0xa610001a},
{0x74, 0x94062001},
{0x78, 0x96066001},
{0x7c, 0xa207bff8},
{0xf0, 0x59},
{0x00, 0x8207bfe8},
{0x04, 0xb6102003},
{0x08, 0xc0204000},
{0x0c, 0xb686ffff},
{0x10, 0x1cbffffe},
{0x14, 0x82006004},
{0x18, 0xb2067fff},
{0x1c, 0x80a6400b},
{0x20, 0x14800030},
{0x24, 0x82064019},
{0x28, 0xba02c00b},
{0x2c, 0xba07400b},
{0x30, 0x82004019},
{0x34, 0x8220401d},
{0x38, 0x3b00001c},
{0x3c, 0xa0176200},
{0x40, 0x9820400a},
{0x44, 0x9a5e601a},
{0x48, 0xb602bffe},
{0x4c, 0x8203401b},
{0x50, 0x83286002},
{0x54, 0xba06c00c},
{0x58, 0xb0004010},
{0x5c, 0xb4076008},
{0x60, 0x90102001},
{0x64, 0x932a001a},
{0x68, 0x9e102000},
{0x6c, 0xb92be002},
{0x70, 0xfa072520},
{0x74, 0xba5f4012},
{0x78, 0x833f601f},
{0x7c, 0x83306018},
{0xf0, 0x5a},
{0x00, 0xba074001},
{0x04, 0xc2060000},
{0x08, 0x82204013},
{0x0c, 0xbb3f6008},
{0x10, 0x9e03e001},
{0x14, 0x80a0401d},
{0x18, 0x04800005},
{0x1c, 0xb8070011},
{0x20, 0xc2073ff0},
{0x24, 0x82104009},
{0x28, 0xc2273ff0},
{0x2c, 0x80a3e003},
{0x30, 0x08bffff0},
{0x34, 0xb92be002},
{0x38, 0xb606e001},
{0x3c, 0xb406a001},
{0x40, 0x80a6c00a},
{0x44, 0x04bfffe8},
{0x48, 0xb0062004},
{0x4c, 0xb2066001},
{0x50, 0x9a03601a},
{0x54, 0x80a6400b},
{0x58, 0x04bfffdc},
{0x5c, 0x98032003},
{0x60, 0xc207bfe8},
{0x64, 0x80886010},
{0x68, 0x0280000a},
{0x6c, 0xfa07bfec},
{0x70, 0xc207bff4},
{0x74, 0x80886082},
{0x78, 0x02800007},
{0x7c, 0x808f6010},
{0xf0, 0x5b},
{0x00, 0x80886028},
{0x04, 0x1280001f},
{0x08, 0xb0102003},
{0x0c, 0xfa07bfec},
{0x10, 0x808f6010},
{0x14, 0x02800012},
{0x18, 0xc207bff0},
{0x1c, 0x808f6082},
{0x20, 0x02800007},
{0x24, 0x808f6028},
{0x28, 0xc207bff4},
{0x2c, 0x80886028},
{0x30, 0x32800014},
{0x34, 0xb0102002},
{0x38, 0x808f6028},
{0x3c, 0x02800008},
{0x40, 0xc207bff0},
{0x44, 0xc207bff4},
{0x48, 0x80886082},
{0x4c, 0x02800004},
{0x50, 0xc207bff0},
{0x54, 0x1080000b},
{0x58, 0xb0102002},
{0x5c, 0x80886010},
{0x60, 0x02800008},
{0x64, 0xb0102000},
{0x68, 0x80886082},
{0x6c, 0x02800005},
{0x70, 0x80886028},
{0x74, 0x12800003},
{0x78, 0xb0102001},
{0x7c, 0xb0102000},
{0xf0, 0x5c},
{0x00, 0x81c7e008},
{0x04, 0x81e80000},
{0x08, 0xc2002308},
{0x0c, 0x80a20001},
{0x10, 0x2880000e},
{0x14, 0xc200237c},
{0x18, 0xc2002304},
{0x1c, 0x80a06000},
{0x20, 0x02800007},
{0x24, 0x9a022001},
{0x28, 0xc2002300},
{0x2c, 0x80a24001},
{0x30, 0x08800029},
{0x34, 0x82102000},
{0x38, 0x9a022001},
{0x3c, 0x825a601a},
{0x40, 0x10800008},
{0x44, 0x8200400d},
{0x48, 0x80a06000},
{0x4c, 0x12800022},
{0x50, 0x82102000},
{0x54, 0x9a026001},
{0x58, 0x825b601a},
{0x5c, 0x82004008},
{0x60, 0x1b00001c},
{0x64, 0x83286002},
{0x68, 0x9a136200},
{0x6c, 0xda00400d},
{0x70, 0xc200251c},
{0x74, 0x80a34001},
{0x78, 0x04800017},
{0x7c, 0x82102000},
{0xf0, 0x5d},
{0x00, 0xc20021cc},
{0x04, 0x80a06000},
{0x08, 0x9810000d},
{0x0c, 0x02800012},
{0x10, 0x8210000d},
{0x14, 0x10800004},
{0x18, 0x832a2010},
{0x1c, 0x1080000e},
{0x20, 0x8210000c},
{0x24, 0x90004009},
{0x28, 0x9a102007},
{0x2c, 0x832b6002},
{0x30, 0xc20061b0},
{0x34, 0x80a06000},
{0x38, 0x02800006},
{0x3c, 0x80a04008},
{0x40, 0x02bffff7},
{0x44, 0x9a837fff},
{0x48, 0x1cbffffa},
{0x4c, 0x832b6002},
{0x50, 0x82102000},
{0x54, 0x81c3e008},
{0x58, 0x90100001},
{0x5c, 0x9de3bf98},
{0x60, 0xc200254c},
{0x64, 0x82087fbf},
{0x68, 0xc220254c},
{0x6c, 0xc020259c},
{0x70, 0xc0202514},
{0x74, 0xba102000},
{0x78, 0xa2102000},
{0x7c, 0x832c6002},
{0xf0, 0x5e},
{0x00, 0xa2046001},
{0x04, 0x80a46009},
{0x08, 0x04bffffd},
{0x0c, 0xc0206610},
{0x10, 0xc2002568},
{0x14, 0x80a06000},
{0x18, 0x02800004},
{0x1c, 0xa4102001},
{0x20, 0x82007fff},
{0x24, 0xc2202568},
{0x28, 0xc20022f8},
{0x2c, 0x80a48001},
{0x30, 0x18800073},
{0x34, 0xae10201a},
{0x38, 0xa2102001},
{0x3c, 0xc20022fc},
{0x40, 0x80a44001},
{0x44, 0x18800069},
{0x48, 0x03000044},
{0x4c, 0xa6048001},
{0x50, 0x832de002},
{0x54, 0xaa006004},
{0x58, 0xa8100013},
{0x5c, 0x2d000040},
{0x60, 0xc2002308},
{0x64, 0x80a44001},
{0x68, 0x38800037},
{0x6c, 0xc2002568},
{0x70, 0xc2002300},
{0x74, 0x80a48001},
{0x78, 0x38800033},
{0x7c, 0xc2002568},
{0xf0, 0x5f},
{0x00, 0x0300001c},
{0x04, 0x82106200},
{0x08, 0xda054001},
{0x0c, 0xc2002474},
{0x10, 0x80a34001},
{0x14, 0x0680004d},
{0x18, 0x1b000040},
{0x1c, 0x90100011},
{0x20, 0x7ffffe8e},
{0x24, 0x92100012},
{0x28, 0x80a22000},
{0x2c, 0x02800047},
{0x30, 0x1b000040},
{0x34, 0x92100012},
{0x38, 0x7ffffec0},
{0x3c, 0x90100011},
{0x40, 0xa0100008},
{0x44, 0x90100011},
{0x48, 0x92100012},
{0x4c, 0x94100010},
{0x50, 0x7fffff26},
{0x54, 0xd6002470},
{0x58, 0x80a22000},
{0x5c, 0x0280003b},
{0x60, 0x1b000040},
{0x64, 0x94100010},
{0x68, 0x90100011},
{0x6c, 0x92100012},
{0x70, 0x7fffff1e},
{0x74, 0x96102100},
{0x78, 0x80a22000},
{0x7c, 0x0280000a},
{0xf0, 0x60},
{0x00, 0xd8002514},
{0x04, 0xc200254c},
{0x08, 0x82106040},
{0x0c, 0xc220254c},
{0x10, 0xc2002280},
{0x14, 0xc2202568},
{0x18, 0x9b2b2002},
{0x1c, 0x10800006},
{0x20, 0x82058012},
{0x24, 0x1b000010},
{0x28, 0x82058012},
{0x2c, 0x8200400d},
{0x30, 0x9b2b2002},
{0x34, 0xc2236610},
{0x38, 0x82032001},
{0x3c, 0x1080001f},
{0x40, 0xc2202514},
{0x44, 0x80a06000},
{0x48, 0x12800020},
{0x4c, 0x1b000040},
{0x50, 0x90100011},
{0x54, 0x7fffff6d},
{0x58, 0x92100012},
{0x5c, 0x80a22000},
{0x60, 0x0280001a},
{0x64, 0x1b000040},
{0x68, 0xda00259c},
{0x6c, 0x80a36000},
{0x70, 0x2280000c},
{0x74, 0xc2002514},
{0x78, 0xc20023c8},
{0x7c, 0x80886100},
{0xf0, 0x61},
{0x00, 0x22800008},
{0x04, 0xc2002514},
{0x08, 0x80a2001d},
{0x0c, 0x2480000f},
{0x10, 0x1b000040},
{0x14, 0x832b6002},
{0x18, 0x10800007},
{0x1c, 0xe820660c},
{0x20, 0x9b286002},
{0x24, 0xe6236610},
{0x28, 0x82006001},
{0x2c, 0xc220259c},
{0x30, 0xc2202514},
{0x34, 0xba100008},
{0x38, 0xc2002514},
{0x3c, 0x80a06009},
{0x40, 0x1880000f},
{0x44, 0x1b000040},
{0x48, 0xa2046001},
{0x4c, 0xc20022fc},
{0x50, 0xa604c00d},
{0x54, 0x80a44001},
{0x58, 0xaa056004},
{0x5c, 0xac05800d},
{0x60, 0x08bfffa0},
{0x64, 0xa805000d},
{0x68, 0xa404a001},
{0x6c, 0xc20022f8},
{0x70, 0x80a48001},
{0x74, 0x08bfff91},
{0x78, 0xae05e01a},
{0x7c, 0x81c7e008},
{0xf0, 0x62},
{0x00, 0x81e80000},
{0x04, 0x80a22000},
{0x08, 0x2280001c},
{0x0c, 0xc2002558},
{0x10, 0xd4002208},
{0x14, 0x80a2a000},
{0x18, 0x0280002e},
{0x1c, 0x01000000},
{0x20, 0xc2002514},
{0x24, 0x80a06000},
{0x28, 0x12800007},
{0x2c, 0xc2002558},
{0x30, 0x80a06000},
{0x34, 0x02800027},
{0x38, 0x82007fff},
{0x3c, 0x10800025},
{0x40, 0xc2202558},
{0x44, 0x80a06000},
{0x48, 0x32800022},
{0x4c, 0xd4202558},
{0x50, 0x17200040},
{0x54, 0x1b3fc200},
{0x58, 0x8212e001},
{0x5c, 0xc2234000},
{0x60, 0xc2002298},
{0x64, 0x98136070},
{0x68, 0xc2230000},
{0x6c, 0xd6234000},
{0x70, 0x10800018},
{0x74, 0xd4202558},
{0x78, 0x80a06000},
{0x7c, 0x32800007},
{0xf0, 0x63},
{0x00, 0xc2002514},
{0x04, 0xc2002208},
{0x08, 0x80a06000},
{0x0c, 0x1280000e},
{0x10, 0x033fc200},
{0x14, 0xc2002514},
{0x18, 0x80a06001},
{0x1c, 0x08800006},
{0x20, 0xd800233c},
{0x24, 0x82007fff},
{0x28, 0xda002204},
{0x2c, 0x8258400d},
{0x30, 0x98030001},
{0x34, 0x033fc200},
{0x38, 0x82106070},
{0x3c, 0x10800005},
{0x40, 0xd8204000},
{0x44, 0xda002234},
{0x48, 0x82106070},
{0x4c, 0xda204000},
{0x50, 0x81c3e008},
{0x54, 0x01000000},
{0x58, 0x82220009},
{0x5c, 0x9a58400a},
{0x60, 0x833b601f},
{0x64, 0x80a20009},
{0x68, 0x83306019},
{0x6c, 0x04800004},
{0x70, 0x90102000},
{0x74, 0x82034001},
{0x78, 0x91386007},
{0x7c, 0x81c3e008},
{0xf0, 0x64},
{0x00, 0x01000000},
{0x04, 0x9de3bf98},
{0x08, 0xc2002308},
{0x0c, 0x82006001},
{0x10, 0xf80022fc},
{0x14, 0x80a70001},
{0x18, 0x2a800019},
{0x1c, 0xc2002300},
{0x20, 0x3100001c},
{0x24, 0xb6102001},
{0x28, 0xc20022f8},
{0x2c, 0x80a6c001},
{0x30, 0x1880000c},
{0x34, 0x832f2002},
{0x38, 0xba006068},
{0x3c, 0xb2162204},
{0x40, 0xb4162200},
{0x44, 0xc207401a},
{0x48, 0xc2274019},
{0x4c, 0xb606e001},
{0x50, 0xc20022f8},
{0x54, 0x80a6c001},
{0x58, 0x08bffffb},
{0x5c, 0xba076068},
{0x60, 0xc2002308},
{0x64, 0xb8073fff},
{0x68, 0x82006001},
{0x6c, 0x80a70001},
{0x70, 0x1abfffee},
{0x74, 0xb6102001},
{0x78, 0xc2002300},
{0x7c, 0x82006001},
{0xf0, 0x65},
{0x00, 0xf60022f8},
{0x04, 0x80a6c001},
{0x08, 0x0a800018},
{0x0c, 0x1f00001c},
{0x10, 0xb45ee068},
{0x14, 0xb8102001},
{0x18, 0xc2002308},
{0x1c, 0x80a70001},
{0x20, 0x3880000d},
{0x24, 0xc2002300},
{0x28, 0xb013e268},
{0x2c, 0xb213e200},
{0x30, 0xba06a004},
{0x34, 0xc2074019},
{0x38, 0xc2274018},
{0x3c, 0xb8072001},
{0x40, 0xc2002308},
{0x44, 0x80a70001},
{0x48, 0x08bffffb},
{0x4c, 0xba076004},
{0x50, 0xc2002300},
{0x54, 0xb606ffff},
{0x58, 0x82006001},
{0x5c, 0x80a6c001},
{0x60, 0x1abfffed},
{0x64, 0xb406bf98},
{0x68, 0x81c7e008},
{0x6c, 0x81e80000},
{0x70, 0x9de3bf98},
{0x74, 0xc20022f8},
{0x78, 0x80a07fff},
{0x7c, 0x0280001d},
{0xf0, 0x66},
{0x00, 0xaa102001},
{0x04, 0xa810201a},
{0x08, 0xa6102068},
{0x0c, 0x2300001c},
{0x10, 0x82146208},
{0x14, 0xa4146204},
{0x18, 0xd204c001},
{0x1c, 0xd408228c},
{0x20, 0x7fffffae},
{0x24, 0xd004c012},
{0x28, 0x82146200},
{0x2c, 0xd024c001},
{0x30, 0xe0002308},
{0x34, 0xa0050010},
{0x38, 0xa12c2002},
{0x3c, 0xa21461fc},
{0x40, 0xd0040001},
{0x44, 0xd2040011},
{0x48, 0x7fffffa4},
{0x4c, 0xd408228d},
{0x50, 0xd0240012},
{0x54, 0xc20022f8},
{0x58, 0xaa056001},
{0x5c, 0x82006001},
{0x60, 0x80a54001},
{0x64, 0xa604e068},
{0x68, 0x08bfffe9},
{0x6c, 0xa805201a},
{0x70, 0xa6102001},
{0x74, 0xc2002308},
{0x78, 0x80a4c001},
{0x7c, 0x18800017},
{0xf0, 0x67},
{0x00, 0x2300001c},
{0x04, 0xa12ce002},
{0x08, 0x821462d0},
{0x0c, 0xa4146268},
{0x10, 0xd2040001},
{0x14, 0xd408228e},
{0x18, 0x7fffff90},
{0x1c, 0xd0040012},
{0x20, 0x82146200},
{0x24, 0xd0240001},
{0x28, 0xe0002300},
{0x2c, 0xa05c201a},
{0x30, 0xa0040013},
{0x34, 0xa12c2002},
{0x38, 0xa2146198},
{0x3c, 0xd0040001},
{0x40, 0xd2040011},
{0x44, 0x7fffff85},
{0x48, 0xd408228f},
{0x4c, 0xd0240012},
{0x50, 0x10bfffe9},
{0x54, 0xa604e001},
{0x58, 0x1700001c},
{0x5c, 0x9012e204},
{0x60, 0x9212e268},
{0x64, 0xda024000},
{0x68, 0xc2020000},
{0x6c, 0x8200400d},
{0x70, 0x9412e200},
{0x74, 0x83386001},
{0x78, 0xc2228000},
{0x7c, 0xd8002308},
{0xf0, 0x68},
{0x00, 0x992b2002},
{0x04, 0x9612e26c},
{0x08, 0xda03000b},
{0x0c, 0xc203000a},
{0x10, 0x8200400d},
{0x14, 0x83386001},
{0x18, 0xc2230008},
{0x1c, 0xda002300},
{0x20, 0x9a5b6068},
{0x24, 0xd803400a},
{0x28, 0xc203400b},
{0x2c, 0x8200400c},
{0x30, 0x83386001},
{0x34, 0xc2234009},
{0x38, 0xc2002300},
{0x3c, 0xda002308},
{0x40, 0x8258601a},
{0x44, 0x8200400d},
{0x48, 0x83286002},
{0x4c, 0xda004009},
{0x50, 0xd8004008},
{0x54, 0x9a03400c},
{0x58, 0x9b3b6001},
{0x5c, 0xda20400b},
{0x60, 0x81c7e008},
{0x64, 0x81e80000},
{0x68, 0x9de3bf98},
{0x6c, 0xfa0023c8},
{0x70, 0x83376015},
{0x74, 0x80886001},
{0x78, 0x02800048},
{0x7c, 0x808f6010},
{0xf0, 0x69},
{0x00, 0x92102000},
{0x04, 0x94102000},
{0x08, 0x98102001},
{0x0c, 0x12800004},
{0x10, 0xa010201a},
{0x14, 0x98102000},
{0x18, 0xa0102001},
{0x1c, 0x821b2003},
{0x20, 0x901b2001},
{0x24, 0x83286002},
{0x28, 0xbb2a2002},
{0x2c, 0xc2060001},
{0x30, 0xfa06001d},
{0x34, 0x8220401d},
{0x38, 0x80a06003},
{0x3c, 0x14800037},
{0x40, 0x821b2002},
{0x44, 0xfa062004},
{0x48, 0xf8060000},
{0x4c, 0xda06200c},
{0x50, 0xba5f601a},
{0x54, 0xba07401c},
{0x58, 0xb45b601a},
{0x5c, 0xde062008},
{0x60, 0x83286002},
{0x64, 0xb406800f},
{0x68, 0x3900001c},
{0x6c, 0xb8172200},
{0x70, 0xb52ea002},
{0x74, 0xf6060001},
{0x78, 0xb32b2002},
{0x7c, 0xbb2f6002},
{0xf0, 0x6a},
{0x00, 0xc2060019},
{0x04, 0x9606801c},
{0x08, 0xb6a6c001},
{0x0c, 0x0c80000d},
{0x10, 0xb407401c},
{0x14, 0xb32c2002},
{0x18, 0xb606e001},
{0x1c, 0xb8102000},
{0x20, 0x8222c01c},
{0x24, 0xfa004000},
{0x28, 0xc207001a},
{0x2c, 0x92024001},
{0x30, 0x9402801d},
{0x34, 0xb686ffff},
{0x38, 0x12bffffa},
{0x3c, 0xb8070019},
{0x40, 0x80a2400a},
{0x44, 0x06800009},
{0x48, 0x80a32000},
{0x4c, 0xbb2a2002},
{0x50, 0xc206001d},
{0x54, 0x80a06000},
{0x58, 0x04800010},
{0x5c, 0x82007fff},
{0x60, 0x1080000e},
{0x64, 0xc226001d},
{0x68, 0x22800008},
{0x6c, 0xc2002300},
{0x70, 0xc2002308},
{0x74, 0x80a3c001},
{0x78, 0x18800008},
{0x7c, 0x8203e001},
{0xf0, 0x6b},
{0x00, 0x10800006},
{0x04, 0xc2262008},
{0x08, 0x80a34001},
{0x0c, 0x18800003},
{0x10, 0x82036001},
{0x14, 0xc226200c},
{0x18, 0x81c7e008},
{0x1c, 0x81e80000},
{0x20, 0x9de3bf98},
{0x24, 0xb12e2002},
{0x28, 0xf8062610},
{0x2c, 0x9a0f2fff},
{0x30, 0xb1372010},
{0x34, 0xb00e2fff},
{0x38, 0xba5b601a},
{0x3c, 0xba074018},
{0x40, 0x0300001c},
{0x44, 0x82106200},
{0x48, 0xbb2f6002},
{0x4c, 0xfa074001},
{0x50, 0xc20821e4},
{0x54, 0xba5f4001},
{0x58, 0x833f601f},
{0x5c, 0x83306019},
{0x60, 0xba074001},
{0x64, 0xbb3f6007},
{0x68, 0xb937200c},
{0x6c, 0xc20821e5},
{0x70, 0x90100019},
{0x74, 0x9610001a},
{0x78, 0xa6074001},
{0x7c, 0x808f2001},
{0xf0, 0x6c},
{0x00, 0xb006001a},
{0x04, 0x0280000c},
{0x08, 0x9a034019},
{0x0c, 0xc20023c8},
{0x10, 0x80886200},
{0x14, 0x32800002},
{0x18, 0xb006001a},
{0x1c, 0xc200237c},
{0x20, 0x80a06000},
{0x24, 0x22800056},
{0x28, 0x9a036001},
{0x2c, 0x10800054},
{0x30, 0xb0062001},
{0x34, 0xc20023c8},
{0x38, 0x83306014},
{0x3c, 0x82086001},
{0x40, 0x80a00001},
{0x44, 0xa0603fff},
{0x48, 0x9a034008},
{0x4c, 0x8333601f},
{0x50, 0x80940001},
{0x54, 0x1280004a},
{0x58, 0xb006000b},
{0x5c, 0x80a62000},
{0x60, 0x06800048},
{0x64, 0x80a2e000},
{0x68, 0xc2002300},
{0x6c, 0x82006001},
{0x70, 0x80a34001},
{0x74, 0x18800043},
{0x78, 0x80a2e000},
{0x7c, 0xc2002308},
{0xf0, 0x6d},
{0x00, 0x82006001},
{0x04, 0x80a60001},
{0x08, 0x1880003d},
{0x0c, 0xa2102000},
{0x10, 0x2500001c},
{0x14, 0x98103fff},
{0x18, 0xa814a200},
{0x1c, 0x9414a200},
{0x20, 0x80a2e000},
{0x24, 0x9e100018},
{0x28, 0x12800004},
{0x2c, 0xb203400c},
{0x30, 0x9e06000c},
{0x34, 0xb210000d},
{0x38, 0x82264008},
{0x3c, 0xba23c00b},
{0x40, 0x8258601a},
{0x44, 0x8200401d},
{0x48, 0x83286002},
{0x4c, 0xfa00400a},
{0x50, 0xc20821e6},
{0x54, 0xba5f4001},
{0x58, 0x833f601f},
{0x5c, 0x83306019},
{0x60, 0x925e601a},
{0x64, 0xba074001},
{0x68, 0xbb3f6007},
{0x6c, 0xb45e6068},
{0x70, 0xb602400f},
{0x74, 0xf80821e7},
{0x78, 0x8203c00c},
{0x7c, 0xb807401c},
{0xf0, 0x6e},
{0x00, 0x83286002},
{0x04, 0xb72ee002},
{0x08, 0xb406800a},
{0x0c, 0xb206400c},
{0x10, 0xfa06c00a},
{0x14, 0xb4068001},
{0x18, 0xb25e6068},
{0x1c, 0x80a7401c},
{0x20, 0x14800017},
{0x24, 0x832be002},
{0x28, 0x80a2e000},
{0x2c, 0x22800005},
{0x30, 0x8202400f},
{0x34, 0xb406400a},
{0x38, 0xb4068001},
{0x3c, 0x8202400f},
{0x40, 0xb7286002},
{0x44, 0xc2068000},
{0x48, 0x80a0401c},
{0x4c, 0x1480000c},
{0x50, 0x98032001},
{0x54, 0xc206c014},
{0x58, 0x80a04013},
{0x5c, 0x36800002},
{0x60, 0xa2102001},
{0x64, 0x80a32001},
{0x68, 0x04bfffce},
{0x6c, 0x9414a200},
{0x70, 0x80a46000},
{0x74, 0x32bfffb6},
{0x78, 0x9a034008},
{0x7c, 0x80a2e000},
{0xf0, 0x6f},
{0x00, 0x12800003},
{0x04, 0xb026000b},
{0x08, 0xb0234008},
{0x0c, 0x81c7e008},
{0x10, 0x81e80000},
{0x14, 0x9de3bf80},
{0x18, 0x03003fc0},
{0x1c, 0x82106001},
{0x20, 0xc227bff4},
{0x24, 0xc227bff0},
{0x28, 0xae102000},
{0x2c, 0xc2002514},
{0x30, 0x80a5c001},
{0x34, 0xa8102000},
{0x38, 0x1a80007a},
{0x3c, 0xa2102000},
{0x40, 0x8207bff8},
{0x44, 0x9a044001},
{0x48, 0xa12c6002},
{0x4c, 0xa0040001},
{0x50, 0xd44b7ff9},
{0x54, 0x90100014},
{0x58, 0x7fffff72},
{0x5c, 0xd24b7ff8},
{0x60, 0xa2046001},
{0x64, 0x80a46003},
{0x68, 0x04bffff6},
{0x6c, 0xd0243fe8},
{0x70, 0x7fffff1e},
{0x74, 0x9007bfe0},
{0x78, 0xd207bfe4},
{0x7c, 0xea07bfec},
{0xf0, 0x70},
{0x00, 0x80a24015},
{0x04, 0xa0102000},
{0x08, 0xa2102000},
{0x0c, 0x14800020},
{0x10, 0xa4102000},
{0x14, 0x0300001c},
{0x18, 0xba106200},
{0x1c, 0xe607bfe8},
{0x20, 0xec07bfe0},
{0x24, 0x905a601a},
{0x28, 0x80a58013},
{0x2c, 0x14800014},
{0x30, 0x96100016},
{0x34, 0x82020016},
{0x38, 0x83286002},
{0x3c, 0x9400401d},
{0x40, 0x98026001},
{0x44, 0xda028000},
{0x48, 0x8202e001},
{0x4c, 0x96100001},
{0x50, 0x9e5b4001},
{0x54, 0x9402a004},
{0x58, 0x80a36000},
{0x5c, 0x04800005},
{0x60, 0x825b400c},
{0x64, 0xa2044001},
{0x68, 0xa404800f},
{0x6c, 0xa004000d},
{0x70, 0x80a2c013},
{0x74, 0x24bffff5},
{0x78, 0xda028000},
{0x7c, 0x92026001},
{0xf0, 0x71},
{0x00, 0x80a24015},
{0x04, 0x04bfffe9},
{0x08, 0x9002201a},
{0x0c, 0x80a42000},
{0x10, 0x94052001},
{0x14, 0x12800004},
{0x18, 0x912d2002},
{0x1c, 0x1080003d},
{0x20, 0xc0222610},
{0x24, 0x832c6006},
{0x28, 0x992ca006},
{0x2c, 0x9338601f},
{0x30, 0x81826000},
{0x34, 0x01000000},
{0x38, 0x01000000},
{0x3c, 0x01000000},
{0x40, 0x96784010},
{0x44, 0xda022610},
{0x48, 0x833b201f},
{0x4c, 0x81806000},
{0x50, 0x01000000},
{0x54, 0x01000000},
{0x58, 0x01000000},
{0x5c, 0x987b0010},
{0x60, 0x9b33600c},
{0x64, 0x808b6001},
{0x68, 0xa202ffa0},
{0x6c, 0x02800007},
{0x70, 0xa4033fa0},
{0x74, 0xc200237c},
{0x78, 0x80a06000},
{0x7c, 0x22800003},
{0xf0, 0x72},
{0x00, 0xa202ff60},
{0x04, 0xa4033f60},
{0x08, 0x80a46000},
{0x0c, 0x24800002},
{0x10, 0xa2102001},
{0x14, 0x80a4a000},
{0x18, 0x24800002},
{0x1c, 0xa4102001},
{0x20, 0xc20021e0},
{0x24, 0x80a06000},
{0x28, 0x2280000f},
{0x2c, 0xa0102000},
{0x30, 0x81800000},
{0x34, 0x01000000},
{0x38, 0x01000000},
{0x3c, 0x01000000},
{0x40, 0xa0f40001},
{0x44, 0x32800004},
{0x48, 0x80a4200f},
{0x4c, 0x10800006},
{0x50, 0xa0102001},
{0x54, 0x34800004},
{0x58, 0xa010200f},
{0x5c, 0x10800003},
{0x60, 0x832c6010},
{0x64, 0x832c6010},
{0x68, 0x82004012},
{0x6c, 0x9b2c201c},
{0x70, 0x9a034001},
{0x74, 0xd8022610},
{0x78, 0x03000004},
{0x7c, 0x980b0001},
{0xf0, 0x73},
{0x00, 0x832de002},
{0x04, 0x9803000d},
{0x08, 0xd8206610},
{0x0c, 0xae05e001},
{0x10, 0xc2002514},
{0x14, 0xa810000a},
{0x18, 0x10bfff88},
{0x1c, 0x80a28001},
{0x20, 0xee202514},
{0x24, 0x81c7e008},
{0x28, 0x81e80000},
{0x2c, 0xd4020000},
{0x30, 0x03000019},
{0x34, 0x9802800a},
{0x38, 0x82106200},
{0x3c, 0xda130001},
{0x40, 0x0300001b},
{0x44, 0xc2130001},
{0x48, 0x96a0400d},
{0x4c, 0x02800016},
{0x50, 0x03000019},
{0x54, 0x80a2e000},
{0x58, 0x04800009},
{0x5c, 0x82102001},
{0x60, 0xda022004},
{0x64, 0x8328400d},
{0x68, 0x80a2c001},
{0x6c, 0x3480000d},
{0x70, 0x973ac00d},
{0x74, 0x1080000b},
{0x78, 0x96102001},
{0x7c, 0x1680000a},
{0xf0, 0x74},
{0x00, 0x03000019},
{0x04, 0xda022008},
{0x08, 0x82103fff},
{0x0c, 0x8328400d},
{0x10, 0x80a2c001},
{0x14, 0x36800003},
{0x18, 0x96103fff},
{0x1c, 0x973ac00d},
{0x20, 0x03000019},
{0x24, 0x92106200},
{0x28, 0x8202800a},
{0x2c, 0xc2104009},
{0x30, 0x9602c001},
{0x34, 0x808aa001},
{0x38, 0x0280000f},
{0x3c, 0x9b3aa01f},
{0x40, 0x9b33601f},
{0x44, 0x9a02800d},
{0x48, 0x9b3b6001},
{0x4c, 0x9b2b6002},
{0x50, 0xd8034009},
{0x54, 0x033fffc0},
{0x58, 0x980b0001},
{0x5c, 0x0300003f},
{0x60, 0x821063ff},
{0x64, 0x820ac001},
{0x68, 0x98030001},
{0x6c, 0x1080000d},
{0x70, 0xd8234009},
{0x74, 0x9b33601f},
{0x78, 0x9a02800d},
{0x7c, 0x9b3b6001},
{0xf0, 0x75},
{0x00, 0x9b2b6002},
{0x04, 0x0300003f},
{0x08, 0xd8034009},
{0x0c, 0x821063ff},
{0x10, 0x980b0001},
{0x14, 0x832ae010},
{0x18, 0x8200400c},
{0x1c, 0xc2234009},
{0x20, 0xc2020000},
{0x24, 0xda00247c},
{0x28, 0x8200400d},
{0x2c, 0x81c3e008},
{0x30, 0xc2220000},
{0x34, 0x9de3bf88},
{0x38, 0xc2002200},
{0x3c, 0x80a06000},
{0x40, 0x3280000f},
{0x44, 0xc20021f8},
{0x48, 0xda00254c},
{0x4c, 0x808b6040},
{0x50, 0x2280000d},
{0x54, 0xc208254e},
{0x58, 0xc20023c8},
{0x5c, 0x80886400},
{0x60, 0x22800007},
{0x64, 0xc20021f8},
{0x68, 0x8333600c},
{0x6c, 0x80886001},
{0x70, 0x22800005},
{0x74, 0xc208254e},
{0x78, 0xc20021f8},
{0x7c, 0x10800032},
{0xf0, 0x76},
{0x00, 0xc2202538},
{0x04, 0x80a06000},
{0x08, 0x12800003},
{0x0c, 0xa0102000},
{0x10, 0xa0102002},
{0x14, 0xa0142001},
{0x18, 0xc2002564},
{0x1c, 0x80a40001},
{0x20, 0x32800007},
{0x24, 0xc20021f8},
{0x28, 0xc20c2314},
{0x2c, 0x80a06000},
{0x30, 0x32800006},
{0x34, 0xc2002538},
{0x38, 0xc20021f8},
{0x3c, 0xc2202538},
{0x40, 0x10800021},
{0x44, 0xe0202564},
{0x48, 0x82006001},
{0x4c, 0xc2202538},
{0x50, 0xda0c2314},
{0x54, 0x80a0400d},
{0x58, 0x0680001b},
{0x5c, 0x01000000},
{0x60, 0xc0202538},
{0x64, 0xc20c234c},
{0x68, 0xc227bfec},
{0x6c, 0xc20c230c},
{0x70, 0xc227bff0},
{0x74, 0xa0102001},
{0x78, 0xc2002308},
{0x7c, 0x80a40001},
{0xf0, 0x77},
{0x00, 0x18800011},
{0x04, 0x01000000},
{0x08, 0xc20c237f},
{0x0c, 0xc227bfe8},
{0x10, 0xa2102001},
{0x14, 0xc2002300},
{0x18, 0x80a44001},
{0x1c, 0x38800006},
{0x20, 0xa0042001},
{0x24, 0x7fffff82},
{0x28, 0x9007bfe8},
{0x2c, 0x10bffffa},
{0x30, 0xa2046001},
{0x34, 0xc2002308},
{0x38, 0x80a40001},
{0x3c, 0x28bffff4},
{0x40, 0xc20c237f},
{0x44, 0x81c7e008},
{0x48, 0x81e80000},
{0x4c, 0x9de3bf88},
{0x50, 0xd8082246},
{0x54, 0x80a32000},
{0x58, 0x22800041},
{0x5c, 0xc020255c},
{0x60, 0xda00254c},
{0x64, 0x808b6001},
{0x68, 0x12800007},
{0x6c, 0x820b7ffe},
{0x70, 0xc2002568},
{0x74, 0x80a06000},
{0x78, 0x22800007},
{0x7c, 0xc200259c},
{0xf0, 0x78},
{0x00, 0x820b7ffe},
{0x04, 0xc220254c},
{0x08, 0xc027bfec},
{0x0c, 0x1080000e},
{0x10, 0xc027bff0},
{0x14, 0x80a06000},
{0x18, 0x32800031},
{0x1c, 0xc020255c},
{0x20, 0xc200255c},
{0x24, 0x82006001},
{0x28, 0x80a0400c},
{0x2c, 0x0a80002c},
{0x30, 0xc220255c},
{0x34, 0xc2082244},
{0x38, 0xc227bfec},
{0x3c, 0xc2082245},
{0x40, 0xc227bff0},
{0x44, 0xc2002308},
{0x48, 0xa0006001},
{0x4c, 0xc20022fc},
{0x50, 0x80a40001},
{0x54, 0x1880000c},
{0x58, 0xa2102001},
{0x5c, 0xc20c237f},
{0x60, 0xc227bfe8},
{0x64, 0xc20022f8},
{0x68, 0x80a44001},
{0x6c, 0x38bffff8},
{0x70, 0xa0042001},
{0x74, 0x7fffff4e},
{0x78, 0x9007bfe8},
{0x7c, 0x10bffffa},
{0xf0, 0x79},
{0x00, 0xa2046001},
{0x04, 0xa0102001},
{0x08, 0xc2002308},
{0x0c, 0x80a40001},
{0x10, 0x38800013},
{0x14, 0xc020255c},
{0x18, 0xd80c237f},
{0x1c, 0xd827bfe8},
{0x20, 0xc200247c},
{0x24, 0xda002300},
{0x28, 0x8258400d},
{0x2c, 0x98030001},
{0x30, 0xd827bfe8},
{0x34, 0xc2002300},
{0x38, 0xa2006001},
{0x3c, 0xc20022f8},
{0x40, 0x80a44001},
{0x44, 0x38bffff1},
{0x48, 0xa0042001},
{0x4c, 0x7fffff38},
{0x50, 0x9007bfe8},
{0x54, 0x10bffffa},
{0x58, 0xa2046001},
{0x5c, 0x81c7e008},
{0x60, 0x81e80000},
{0x64, 0x9de3bf98},
{0x68, 0xc2002744},
{0x6c, 0x98100018},
{0x70, 0x80a0600f},
{0x74, 0x14800003},
{0x78, 0x9e10200f},
{0x7c, 0x9e100001},
{0xf0, 0x7a},
{0x00, 0x1b000015},
{0x04, 0x0300003f},
{0x08, 0x941063ff},
{0x0c, 0xb203e001},
{0x10, 0xb0102000},
{0x14, 0x9610000d},
{0x18, 0xb72e2002},
{0x1c, 0x8203401b},
{0x20, 0xfa106002},
{0x24, 0xb803001b},
{0x28, 0xf4172002},
{0x2c, 0xc213401b},
{0x30, 0xf813001b},
{0x34, 0x8258400f},
{0x38, 0xba5f400f},
{0x3c, 0x8200401c},
{0x40, 0xba07401a},
{0x44, 0x81800000},
{0x48, 0x01000000},
{0x4c, 0x01000000},
{0x50, 0x01000000},
{0x54, 0x82704019},
{0x58, 0x81800000},
{0x5c, 0x01000000},
{0x60, 0x01000000},
{0x64, 0x01000000},
{0x68, 0xba774019},
{0x6c, 0x83286010},
{0x70, 0xba0f400a},
{0x74, 0x8200401d},
{0x78, 0xb0062001},
{0x7c, 0x80a6217f},
{0xf0, 0x7b},
{0x00, 0x04bfffe6},
{0x04, 0xc226c00b},
{0x08, 0xf2202744},
{0x0c, 0x81c7e008},
{0x10, 0x81e80000},
{0x14, 0xd6020000},
{0x18, 0xd8024000},
{0x1c, 0x9132e010},
{0x20, 0x95332010},
{0x24, 0x900a2fff},
{0x28, 0x940aafff},
{0x2c, 0x03000007},
{0x30, 0x9a22000a},
{0x34, 0x821063ff},
{0x38, 0x940b0001},
{0x3c, 0x900ac001},
{0x40, 0x9022000a},
{0x44, 0x9a5b400d},
{0x48, 0x905a0008},
{0x4c, 0x81c3e008},
{0x50, 0x90034008},
{0x54, 0x9de3bf98},
{0x58, 0xc2002200},
{0x5c, 0x80a06000},
{0x60, 0x12800062},
{0x64, 0x033fc200},
{0x68, 0x82106030},
{0x6c, 0xda004000},
{0x70, 0xc2002344},
{0x74, 0x80a34001},
{0x78, 0x1280005c},
{0x7c, 0x01000000},
{0xf0, 0x7c},
{0x00, 0xc208254d},
{0x04, 0x80a06000},
{0x08, 0x12800058},
{0x0c, 0x01000000},
{0x10, 0xc208254e},
{0x14, 0x80a06000},
{0x18, 0x02800054},
{0x1c, 0x01000000},
{0x20, 0xc2002334},
{0x24, 0x825860fa},
{0x28, 0x820060fa},
{0x2c, 0xda002500},
{0x30, 0x80a34001},
{0x34, 0x0a80004d},
{0x38, 0x01000000},
{0x3c, 0xd6002748},
{0x40, 0x80a2e000},
{0x44, 0x1480001d},
{0x48, 0x8202ffff},
{0x4c, 0xc2002514},
{0x50, 0x80a06001},
{0x54, 0x32800045},
{0x58, 0xc0202748},
{0x5c, 0xc2002610},
{0x60, 0x80a06000},
{0x64, 0x32800004},
{0x68, 0xc200254c},
{0x6c, 0x1080003f},
{0x70, 0xc0202748},
{0x74, 0x80886040},
{0x78, 0x32800006},
{0x7c, 0xd800239c},
{0xf0, 0x7d},
{0x00, 0x80a2e000},
{0x04, 0x0680000d},
{0x08, 0x8202e001},
{0x0c, 0xd800239c},
{0x10, 0x0300003f},
{0x14, 0x9b332010},
{0x18, 0x821063ff},
{0x1c, 0x980b0001},
{0x20, 0x9a38000d},
{0x24, 0x9a23400c},
{0x28, 0x80a2c00d},
{0x2c, 0x06800005},
{0x30, 0x03296956},
{0x34, 0x8202ffff},
{0x38, 0x1080002c},
{0x3c, 0xc2202748},
{0x40, 0x9a10625a},
{0x44, 0xc200250c},
{0x48, 0x80a0400d},
{0x4c, 0x02800004},
{0x50, 0xb0102000},
{0x54, 0xda20250c},
{0x58, 0xc0202744},
{0x5c, 0x832e2002},
{0x60, 0x9200674c},
{0x64, 0xc200674c},
{0x68, 0x90102610},
{0x6c, 0x80a06000},
{0x70, 0x0280000d},
{0x74, 0xb0062001},
{0x78, 0x7fffffa7},
{0x7c, 0x01000000},
{0xf0, 0x7e},
{0x00, 0xc2002300},
{0x04, 0xda002308},
{0x08, 0x82584001},
{0x0c, 0x9a5b400d},
{0x10, 0x8200400d},
{0x14, 0x83286006},
{0x18, 0x80a20001},
{0x1c, 0x0a800013},
{0x20, 0x01000000},
{0x24, 0x80a6200f},
{0x28, 0x08bfffee},
{0x2c, 0x832e2002},
{0x30, 0x030041eb},
{0x34, 0xc2202748},
{0x38, 0xb010200f},
{0x3c, 0x9b2e2002},
{0x40, 0xc2036748},
{0x44, 0xb0863fff},
{0x48, 0x12bffffd},
{0x4c, 0xc223674c},
{0x50, 0xc2002610},
{0x54, 0x31000019},
{0x58, 0xc220274c},
{0x5c, 0xb0162200},
{0x60, 0x7fffff61},
{0x64, 0x81e80000},
{0x68, 0x01000000},
{0x6c, 0x81c7e008},
{0x70, 0x81e80000},
{0x74, 0x9de3bf98},
{0x78, 0xa4102000},
{0x7c, 0xe6002514},
{0xf0, 0x7f},
{0x00, 0x80a48013},
{0x04, 0x1a800010},
{0x08, 0xa0102000},
{0x0c, 0xa2102610},
{0x10, 0x92100011},
{0x14, 0x7fffff80},
{0x18, 0x90100018},
{0x1c, 0x82102001},
{0x20, 0x83284010},
{0x24, 0xa2046004},
{0x28, 0x80a20019},
{0x2c, 0x1a800003},
{0x30, 0xa0042001},
{0x34, 0xa4148001},
{0x38, 0x80a40013},
{0x3c, 0x0abffff6},
{0x40, 0x92100011},
{0x44, 0x81c7e008},
{0x48, 0x91e80012},
{0x4c, 0x9de3bf98},
{0x50, 0x0300001c},
{0x54, 0x98100018},
{0x58, 0xba106200},
{0x5c, 0xb4102000},
{0x60, 0x832ea002},
{0x64, 0xb406a001},
{0x68, 0x80a6a373},
{0x6c, 0x08bffffd},
{0x70, 0xc020401d},
{0x74, 0xb4102001},
{0x78, 0xc20022fc},
{0x7c, 0x80a68001},
{0xf0, 0x80},
{0x00, 0x1880001f},
{0x04, 0x0300001c},
{0x08, 0x82106200},
{0x0c, 0x9a006004},
{0x10, 0xc20022f8},
{0x14, 0xb2102001},
{0x18, 0x80a64001},
{0x1c, 0x3100001b},
{0x20, 0xb610000c},
{0x24, 0x18800011},
{0x28, 0xc20ea37f},
{0x2c, 0x9e004001},
{0x30, 0xb8036068},
{0x34, 0xfa16c00f},
{0x38, 0xc216000f},
{0x3c, 0x8220401d},
{0x40, 0xc2270000},
{0x44, 0xfa00247c},
{0x48, 0xba07401d},
{0x4c, 0xb2066001},
{0x50, 0xc20022f8},
{0x54, 0xb606c01d},
{0x58, 0x80a64001},
{0x5c, 0xb006001d},
{0x60, 0x08bffff5},
{0x64, 0xb8072068},
{0x68, 0xb406a001},
{0x6c, 0xc20022fc},
{0x70, 0x80a68001},
{0x74, 0x08bfffe7},
{0x78, 0x9a036004},
{0x7c, 0x81c7e008},
{0xf0, 0x81},
{0x00, 0x81e80000},
{0x04, 0x9de3bf98},
{0x08, 0xc200254c},
{0x0c, 0x80886200},
{0x10, 0x0280000a},
{0x14, 0xc0202598},
{0x18, 0x7fffffcd},
{0x1c, 0x11000015},
{0x20, 0x10800007},
{0x24, 0xee0023a0},
{0x28, 0x03000080},
{0x2c, 0x82134001},
{0x30, 0x10800099},
{0x34, 0xc220254c},
{0x38, 0xee0022ac},
{0x3c, 0xaa102000},
{0x40, 0xa12d6003},
{0x44, 0xc2042660},
{0x48, 0x80a06000},
{0x4c, 0x2280008f},
{0x50, 0xaa056001},
{0x54, 0x80a56000},
{0x58, 0x32800008},
{0x5c, 0xda002500},
{0x60, 0xc200259c},
{0x64, 0x80a06000},
{0x68, 0x1280001d},
{0x6c, 0x2d200000},
{0x70, 0x10800012},
{0x74, 0xac102000},
{0x78, 0xc20022d0},
{0x7c, 0x80a34001},
{0xf0, 0x82},
{0x00, 0x38800007},
{0x04, 0xc0242664},
{0x08, 0xc2002200},
{0x0c, 0x80a06000},
{0x10, 0x02800005},
{0x14, 0x90042660},
{0x18, 0xc0242664},
{0x1c, 0x1080007a},
{0x20, 0xc0242660},
{0x24, 0x7fffff94},
{0x28, 0x92100017},
{0x2c, 0xac922000},
{0x30, 0x3280000c},
{0x34, 0xc2142666},
{0x38, 0xc2142664},
{0x3c, 0x80a06000},
{0x40, 0x2280006d},
{0x44, 0xc0242664},
{0x48, 0xc2042664},
{0x4c, 0x1b3fffc0},
{0x50, 0x8200400d},
{0x54, 0x10800069},
{0x58, 0xc2242664},
{0x5c, 0xc2142666},
{0x60, 0x80a06000},
{0x64, 0x0280000a},
{0x68, 0x80a56000},
{0x6c, 0xc2042664},
{0x70, 0x82007fff},
{0x74, 0xc2242664},
{0x78, 0xc2142666},
{0x7c, 0x80a06000},
{0xf0, 0x83},
{0x00, 0x3280005f},
{0x04, 0xc2002598},
{0x08, 0x80a56000},
{0x0c, 0x32800006},
{0x10, 0xda00254c},
{0x14, 0xc200254c},
{0x18, 0x82106001},
{0x1c, 0x10800057},
{0x20, 0xc220254c},
{0x24, 0x808b6200},
{0x28, 0x02bfffc0},
{0x2c, 0x03296956},
{0x30, 0xda00250c},
{0x34, 0x8210625a},
{0x38, 0x80a34001},
{0x3c, 0x02800006},
{0x40, 0x031696a9},
{0x44, 0x821061a5},
{0x48, 0x80a34001},
{0x4c, 0x3280004c},
{0x50, 0xc2002598},
{0x54, 0xc2042660},
{0x58, 0x9b306016},
{0x5c, 0x82086fff},
{0x60, 0xa3386006},
{0x64, 0xa60b603f},
{0x68, 0xa8046001},
{0x6c, 0xa404e001},
{0x70, 0x90100014},
{0x74, 0x92100012},
{0x78, 0x94102000},
{0x7c, 0x7ffffa9b},
{0xf0, 0x84},
{0x00, 0xd600246c},
{0x04, 0x80a22000},
{0x08, 0x3280003b},
{0x0c, 0xc0242664},
{0x10, 0x80a46001},
{0x14, 0x0480000b},
{0x18, 0x90046002},
{0x1c, 0x90100011},
{0x20, 0x92100012},
{0x24, 0x94102000},
{0x28, 0x7ffffa90},
{0x2c, 0xd600246c},
{0x30, 0x80a22000},
{0x34, 0x32800030},
{0x38, 0xc0242664},
{0x3c, 0x90046002},
{0x40, 0xc2002308},
{0x44, 0x80a20001},
{0x48, 0x1a80000a},
{0x4c, 0x80a4e001},
{0x50, 0x92100012},
{0x54, 0x94102000},
{0x58, 0x7ffffa84},
{0x5c, 0xd600246c},
{0x60, 0x80a22000},
{0x64, 0x32800024},
{0x68, 0xc0242664},
{0x6c, 0x80a4e001},
{0x70, 0x0480000b},
{0x74, 0x9204e002},
{0x78, 0x90100014},
{0x7c, 0x92100013},
{0xf0, 0x85},
{0x00, 0x94102000},
{0x04, 0x7ffffa79},
{0x08, 0xd600246c},
{0x0c, 0x80a22000},
{0x10, 0x32800019},
{0x14, 0xc0242664},
{0x18, 0x9204e002},
{0x1c, 0xc2002300},
{0x20, 0x80a24001},
{0x24, 0x3a80000a},
{0x28, 0xc2002570},
{0x2c, 0x90100014},
{0x30, 0x94102000},
{0x34, 0x7ffffa6d},
{0x38, 0xd600246c},
{0x3c, 0x80a22000},
{0x40, 0x3280000d},
{0x44, 0xc0242664},
{0x48, 0xc2002570},
{0x4c, 0x82006001},
{0x50, 0x80a06004},
{0x54, 0x08800009},
{0x58, 0xc2202570},
{0x5c, 0xc200254c},
{0x60, 0x1b000080},
{0x64, 0x8210400d},
{0x68, 0xc220254c},
{0x6c, 0x1080000a},
{0x70, 0xc0202570},
{0x74, 0xc0242660},
{0x78, 0xc2002598},
{0x7c, 0x82104016},
{0xf0, 0x86},
{0x00, 0xc2202598},
{0x04, 0xaa056001},
{0x08, 0x80a56013},
{0x0c, 0x04bfff6e},
{0x10, 0xa12d6003},
{0x14, 0xc2002598},
{0x18, 0x80a06000},
{0x1c, 0x22800002},
{0x20, 0xc0202570},
{0x24, 0xc200259c},
{0x28, 0x80a06000},
{0x2c, 0x2280000b},
{0x30, 0xda002500},
{0x34, 0xc2002660},
{0x38, 0x80a06000},
{0x3c, 0x32800007},
{0x40, 0xda002500},
{0x44, 0x03000004},
{0x48, 0xc2202660},
{0x4c, 0xc2002248},
{0x50, 0xc2202664},
{0x54, 0xda002500},
{0x58, 0xc20022d0},
{0x5c, 0x80a34001},
{0x60, 0x1880002c},
{0x64, 0x01000000},
{0x68, 0xc2002200},
{0x6c, 0x80a06000},
{0x70, 0x12800028},
{0x74, 0xaa102000},
{0x78, 0xc2002514},
{0x7c, 0x80a54001},
{0xf0, 0x87},
{0x00, 0x1a800024},
{0x04, 0x94102001},
{0x08, 0x972d6002},
{0x0c, 0xc202e610},
{0x10, 0x8330600c},
{0x14, 0x80886001},
{0x18, 0x3280001a},
{0x1c, 0xaa056001},
{0x20, 0x9b2a8015},
{0x24, 0xc2002598},
{0x28, 0x8088400d},
{0x2c, 0x32800015},
{0x30, 0xaa056001},
{0x34, 0x98102001},
{0x38, 0x9b2b2003},
{0x3c, 0xc2036660},
{0x40, 0x80a06000},
{0x44, 0x1280000b},
{0x48, 0x98032001},
{0x4c, 0xc202e610},
{0x50, 0xc2236660},
{0x54, 0xc200254c},
{0x58, 0x80886200},
{0x5c, 0x22800003},
{0x60, 0xc2002378},
{0x64, 0xc200239c},
{0x68, 0x10800005},
{0x6c, 0xc2236664},
{0x70, 0x80a32013},
{0x74, 0x04bffff2},
{0x78, 0x9b2b2003},
{0x7c, 0xaa056001},
{0xf0, 0x88},
{0x00, 0xc2002514},
{0x04, 0x80a54001},
{0x08, 0x0abfffe1},
{0x0c, 0x972d6002},
{0x10, 0x81c7e008},
{0x14, 0x81e80000},
{0x18, 0x98102000},
{0x1c, 0xc2002514},
{0x20, 0x80a30001},
{0x24, 0x1a80000b},
{0x28, 0x033fc180},
{0x2c, 0x96106004},
{0x30, 0x832b2002},
{0x34, 0xda006610},
{0x38, 0xda20400b},
{0x3c, 0x98032001},
{0x40, 0xc2002514},
{0x44, 0x80a30001},
{0x48, 0x0abffffb},
{0x4c, 0x832b2002},
{0x50, 0xda00254c},
{0x54, 0x808b6080},
{0x58, 0x32800008},
{0x5c, 0xc208254e},
{0x60, 0xc2002514},
{0x64, 0x9a136080},
{0x68, 0x82106100},
{0x6c, 0xda20254c},
{0x70, 0xc2202514},
{0x74, 0xc208254e},
{0x78, 0x80a06000},
{0x7c, 0x1280000a},
{0xf0, 0x89},
{0x00, 0xc20023c8},
{0x04, 0x83306016},
{0x08, 0x80886001},
{0x0c, 0x22800006},
{0x10, 0xc20023c8},
{0x14, 0xc2002514},
{0x18, 0x82106200},
{0x1c, 0xc2202514},
{0x20, 0xc20023c8},
{0x24, 0x83306013},
{0x28, 0x80886001},
{0x2c, 0x02800012},
{0x30, 0xda002514},
{0x34, 0xc2002200},
{0x38, 0x80a06000},
{0x3c, 0x0280000e},
{0x40, 0x01000000},
{0x44, 0x033fc000},
{0x48, 0x8210605c},
{0x4c, 0xc2004000},
{0x50, 0x83286010},
{0x54, 0x9a134001},
{0x58, 0xc200254c},
{0x5c, 0x80886004},
{0x60, 0x02800004},
{0x64, 0xda202514},
{0x68, 0x82136800},
{0x6c, 0xc2202514},
{0x70, 0xda002514},
{0x74, 0x80a36000},
{0x78, 0x2280000a},
{0x7c, 0xda002514},
{0xf0, 0x8a},
{0x00, 0xc20021e0},
{0x04, 0x80a06000},
{0x08, 0x22800006},
{0x0c, 0xda002514},
{0x10, 0x03000004},
{0x14, 0x82134001},
{0x18, 0xc2202514},
{0x1c, 0xda002514},
{0x20, 0x033fc180},
{0x24, 0x81c3e008},
{0x28, 0xda204000},
{0x2c, 0xc2002200},
{0x30, 0x80a06000},
{0x34, 0x1280001a},
{0x38, 0x01000000},
{0x3c, 0xda002500},
{0x40, 0xc20021f0},
{0x44, 0x80a34001},
{0x48, 0x18800015},
{0x4c, 0x01000000},
{0x50, 0xd800254c},
{0x54, 0x808b2400},
{0x58, 0x12800011},
{0x5c, 0x01000000},
{0x60, 0xda002514},
{0x64, 0xc20021e8},
{0x68, 0x80a34001},
{0x6c, 0x2a80000c},
{0x70, 0xc02025a0},
{0x74, 0x03000100},
{0x78, 0xda0025a0},
{0x7c, 0x96130001},
{0xf0, 0x8b},
{0x00, 0x9810000d},
{0x04, 0x9a036001},
{0x08, 0xc20021ec},
{0x0c, 0x80a30001},
{0x10, 0x08800003},
{0x14, 0xda2025a0},
{0x18, 0xd620254c},
{0x1c, 0x81c3e008},
{0x20, 0x01000000},
{0x24, 0x9de3bf98},
{0x28, 0x833e201f},
{0x2c, 0xd0002320},
{0x30, 0x82204018},
{0x34, 0x80a22000},
{0x38, 0x02800016},
{0x3c, 0x9b30601f},
{0x40, 0x033fc000},
{0x44, 0xa0106020},
{0x48, 0xc200231c},
{0x4c, 0x80a00001},
{0x50, 0x82402000},
{0x54, 0x8088400d},
{0x58, 0xda002318},
{0x5c, 0x821e000d},
{0x60, 0x02800009},
{0x64, 0xb0086001},
{0x68, 0x80a0000d},
{0x6c, 0x82603fff},
{0x70, 0x7ffff32e},
{0x74, 0xc2240000},
{0x78, 0xc2002318},
{0x7c, 0x10800005},
{0xf0, 0x8c},
{0x00, 0xc2240000},
{0x04, 0x033fc000},
{0x08, 0x82106020},
{0x0c, 0xf0204000},
{0x10, 0x81c7e008},
{0x14, 0x81e80000},
{0x18, 0x9de3bf98},
{0x1c, 0xc2002514},
{0x20, 0x80a06000},
{0x24, 0x1280000a},
{0x28, 0x90102001},
{0x2c, 0xc200254c},
{0x30, 0x9b306003},
{0x34, 0x83306002},
{0x38, 0x82086001},
{0x3c, 0x9a0b6001},
{0x40, 0x80a0400d},
{0x44, 0x22800005},
{0x48, 0xc2002560},
{0x4c, 0x82102005},
{0x50, 0x10800007},
{0x54, 0xc2202560},
{0x58, 0x9a007fff},
{0x5c, 0x80a06000},
{0x60, 0x02800005},
{0x64, 0x90102002},
{0x68, 0xda202560},
{0x6c, 0x7fffffce},
{0x70, 0x01000000},
{0x74, 0xc200254c},
{0x78, 0x9a004001},
{0x7c, 0x9a0b6008},
{0xf0, 0x8d},
{0x00, 0x82087ff7},
{0x04, 0x8210400d},
{0x08, 0xc220254c},
{0x0c, 0x81c7e008},
{0x10, 0x81e80000},
{0x14, 0x01000000},
{0x18, 0x27001040},
{0x1c, 0xa614e00f},
{0x20, 0xe6a00040},
{0x24, 0x01000000},
{0x28, 0x81c3e008},
{0x2c, 0x01000000},
{0x30, 0x9de3bf98},
{0x34, 0xc2002508},
{0x38, 0x80a06000},
{0x3c, 0x0280000f},
{0x40, 0x1b3fc180},
{0x44, 0x82102001},
{0x48, 0x9a13603c},
{0x4c, 0xc2234000},
{0x50, 0xc2002508},
{0x54, 0x820860ff},
{0x58, 0x80a04018},
{0x5c, 0x12800005},
{0x60, 0x033fc180},
{0x64, 0x7fffffec},
{0x68, 0x01000000},
{0x6c, 0x30bffff9},
{0x70, 0x8210603c},
{0x74, 0xc0204000},
{0x78, 0x81c7e008},
{0x7c, 0x81e80000},
{0xf0, 0x8e},
{0x00, 0x9de3bf98},
{0x04, 0x7fffffeb},
{0x08, 0x901020a5},
{0x0c, 0x7ffff6ce},
{0x10, 0x01000000},
{0x14, 0x7ffff545},
{0x18, 0x01000000},
{0x1c, 0xc20023c8},
{0x20, 0x83306012},
{0x24, 0x80886001},
{0x28, 0x02800007},
{0x2c, 0x01000000},
{0x30, 0x7ffff62a},
{0x34, 0x01000000},
{0x38, 0x7ffff5cb},
{0x3c, 0x01000000},
{0x40, 0x30800005},
{0x44, 0x7ffff5c8},
{0x48, 0x01000000},
{0x4c, 0x7ffff623},
{0x50, 0x01000000},
{0x54, 0x7ffff582},
{0x58, 0x01000000},
{0x5c, 0xc20023c8},
{0x60, 0x80886010},
{0x64, 0x02800005},
{0x68, 0x01000000},
{0x6c, 0x7ffff6dc},
{0x70, 0x01000000},
{0x74, 0x30800003},
{0x78, 0x7ffff750},
{0x7c, 0x01000000},
{0xf0, 0x8f},
{0x00, 0x7ffff7b3},
{0x04, 0xb01020aa},
{0x08, 0x7ffff806},
{0x0c, 0x01000000},
{0x10, 0x7ffffa9d},
{0x14, 0x01000000},
{0x18, 0x7ffff9d1},
{0x1c, 0x01000000},
{0x20, 0x7ffffad4},
{0x24, 0x01000000},
{0x28, 0x7ffffa57},
{0x2c, 0x90102001},
{0x30, 0x7ffffcc1},
{0x34, 0x01000000},
{0x38, 0x7ffffd05},
{0x3c, 0x01000000},
{0x40, 0x7ffffbf5},
{0x44, 0x01000000},
{0x48, 0x7ffffd83},
{0x4c, 0x01000000},
{0x50, 0x7fffffb8},
{0x54, 0x9010205a},
{0x58, 0x7ffffe2b},
{0x5c, 0x01000000},
{0x60, 0x7fffff53},
{0x64, 0x01000000},
{0x68, 0x7fffff0c},
{0x6c, 0x01000000},
{0x70, 0x7fffff8a},
{0x74, 0x01000000},
{0x78, 0x7fffffae},
{0x7c, 0x81e80000},
{0xf0, 0x90},
{0x00, 0x01000000},
{0x04, 0x9de3bf98},
{0x08, 0xa4102000},
{0x0c, 0xc20023d4},
{0x10, 0x80a48001},
{0x14, 0xa2102000},
{0x18, 0x1a800016},
{0x1c, 0xa0102000},
{0x20, 0xc200247c},
{0x24, 0x80a40001},
{0x28, 0x3a80000f},
{0x2c, 0xa2046001},
{0x30, 0x7ffff182},
{0x34, 0x90100010},
{0x38, 0x92100008},
{0x3c, 0x7ffff14c},
{0x40, 0x90100011},
{0x44, 0x0300003f},
{0x48, 0xda002274},
{0x4c, 0x821063ff},
{0x50, 0x9a0b4001},
{0x54, 0x80a2000d},
{0x58, 0xa4400012},
{0x5c, 0x10bffff1},
{0x60, 0xa0042001},
{0x64, 0xc20023d4},
{0x68, 0x10bfffec},
{0x6c, 0x80a44001},
{0x70, 0xc2102274},
{0x74, 0x80a48001},
{0x78, 0x08800005},
{0x7c, 0x033fc180},
{0xf0, 0x91},
{0x00, 0x1b004000},
{0x04, 0x8210603c},
{0x08, 0xda204000},
{0x0c, 0x81c7e008},
{0x10, 0x81e80000},
{0x14, 0x9de3bf98},
{0x18, 0xf600227c},
{0x1c, 0x80a6e000},
{0x20, 0x02800033},
{0x24, 0x01000000},
{0x28, 0xc2002594},
{0x2c, 0x80a06001},
{0x30, 0x1280002f},
{0x34, 0xb0102000},
{0x38, 0xfa0022f8},
{0x3c, 0xc200247c},
{0x40, 0xb45f4001},
{0x44, 0x3b000007},
{0x48, 0xba1763ff},
{0x4c, 0x8336e00d},
{0x50, 0x9e08401d},
{0x54, 0x80a6001a},
{0x58, 0xb2102000},
{0x5c, 0x9a0ec01d},
{0x60, 0x1a800014},
{0x64, 0xb8102000},
{0x68, 0x03000019},
{0x6c, 0x96106200},
{0x70, 0x1900001b},
{0x74, 0xba07001c},
{0x78, 0xc217400c},
{0x7c, 0x80a3c001},
{0xf0, 0x92},
{0x00, 0xb2400019},
{0x04, 0xc217400b},
{0x08, 0x80a0400d},
{0x0c, 0x0a800005},
{0x10, 0xb8072001},
{0x14, 0x80a0400f},
{0x18, 0x08800004},
{0x1c, 0x80a7001a},
{0x20, 0xb0062001},
{0x24, 0x80a7001a},
{0x28, 0x0abffff4},
{0x2c, 0xba07001c},
{0x30, 0xb936e01a},
{0x34, 0x80a6401c},
{0x38, 0x14800003},
{0x3c, 0xba102001},
{0x40, 0xba102000},
{0x44, 0x80a6001c},
{0x48, 0x14800003},
{0x4c, 0x82102001},
{0x50, 0x82102000},
{0x54, 0x80974001},
{0x58, 0x02800005},
{0x5c, 0x033fc180},
{0x60, 0x3b008000},
{0x64, 0x8210603c},
{0x68, 0xfa204000},
{0x6c, 0x81c7e008},
{0x70, 0x81e80000},
{0x74, 0xda00247c},
{0x78, 0xc20022f8},
{0x7c, 0x8258400d},
{0xf0, 0x93},
{0x00, 0x83306001},
{0x04, 0x9a102000},
{0x08, 0x80a34001},
{0x0c, 0x1a80002b},
{0x10, 0x0300003f},
{0x14, 0x901063ff},
{0x18, 0x1500001b},
{0x1c, 0xd8002544},
{0x20, 0x80a32008},
{0x24, 0x92036001},
{0x28, 0x0880000d},
{0x2c, 0x972b6002},
{0x30, 0xda02c00a},
{0x34, 0x83336010},
{0x38, 0x82004001},
{0x3c, 0x9a0b4008},
{0x40, 0x81800000},
{0x44, 0x01000000},
{0x48, 0x01000000},
{0x4c, 0x01000000},
{0x50, 0x8270400c},
{0x54, 0x1080000a},
{0x58, 0x9a03400d},
{0x5c, 0xda02c00a},
{0x60, 0x83336010},
{0x64, 0x81800000},
{0x68, 0x01000000},
{0x6c, 0x01000000},
{0x70, 0x01000000},
{0x74, 0x8270400c},
{0x78, 0x9a0b4008},
{0x7c, 0x81800000},
{0xf0, 0x94},
{0x00, 0x01000000},
{0x04, 0x01000000},
{0x08, 0x01000000},
{0x0c, 0x9a73400c},
{0x10, 0x83286010},
{0x14, 0x8200400d},
{0x18, 0xc222c00a},
{0x1c, 0xda00247c},
{0x20, 0xc20022f8},
{0x24, 0x8258400d},
{0x28, 0x83306001},
{0x2c, 0x80a24001},
{0x30, 0x0abfffdb},
{0x34, 0x9a100009},
{0x38, 0x81c3e008},
{0x3c, 0x01000000},
{0x40, 0x9de3bf98},
{0x44, 0xc2002544},
{0x48, 0x82006001},
{0x4c, 0xc2202544},
{0x50, 0x9e100018},
{0x54, 0x031fffdf},
{0x58, 0xb01063ff},
{0x5c, 0xba102000},
{0x60, 0x3500001b},
{0x64, 0xb72f6002},
{0x68, 0xc2002544},
{0x6c, 0x80a06009},
{0x70, 0xb2076001},
{0x74, 0x12800007},
{0x78, 0xb810001b},
{0x7c, 0xc206c01a},
{0xf0, 0x95},
{0x00, 0x83306001},
{0x04, 0x82084018},
{0x08, 0xc226c01a},
{0x0c, 0xc2002544},
{0x10, 0x80a06008},
{0x14, 0x08800006},
{0x18, 0xc207001a},
{0x1c, 0xfa03c01c},
{0x20, 0xbb376001},
{0x24, 0x10800003},
{0x28, 0xba0f4018},
{0x2c, 0xfa03c01c},
{0x30, 0x8200401d},
{0x34, 0xc227001a},
{0x38, 0x80a6617f},
{0x3c, 0x08bfffea},
{0x40, 0xba100019},
{0x44, 0x81c7e008},
{0x48, 0x81e80000},
{0x4c, 0x9a102000},
{0x50, 0x832b6002},
{0x54, 0x9a036001},
{0x58, 0x80a3617f},
{0x5c, 0x08bffffd},
{0x60, 0xc0220001},
{0x64, 0x81c3e008},
{0x68, 0x01000000},
{0x6c, 0xc200247c},
{0x70, 0xda0022f8},
{0x74, 0x8258400d},
{0x78, 0x97306001},
{0x7c, 0x98102000},
{0xf0, 0x96},
{0x00, 0x80a3000b},
{0x04, 0x1680000e},
{0x08, 0x03000019},
{0x0c, 0x90106200},
{0x10, 0x0307ffc7},
{0x14, 0x921063ff},
{0x18, 0x1500001b},
{0x1c, 0x9b2b2002},
{0x20, 0xc203400a},
{0x24, 0x83306003},
{0x28, 0x82084009},
{0x2c, 0x98032001},
{0x30, 0x80a3000b},
{0x34, 0x06bffffa},
{0x38, 0xc2234008},
{0x3c, 0x0300001c},
{0x40, 0x9a106200},
{0x44, 0x98102000},
{0x48, 0x832b2002},
{0x4c, 0x98032001},
{0x50, 0x80a322ff},
{0x54, 0x04bffffd},
{0x58, 0xc020400d},
{0x5c, 0x81c3e008},
{0x60, 0x01000000},
{0x64, 0x9de3bf98},
{0x68, 0xc200253c},
{0x6c, 0x80a06000},
{0x70, 0x12800048},
{0x74, 0xb0102000},
{0x78, 0xd6002460},
{0x7c, 0x82102080},
{0xf0, 0x97},
{0x00, 0x80a2e000},
{0x04, 0x02800043},
{0x08, 0xc220256c},
{0x0c, 0x10800005},
{0x10, 0xb0102001},
{0x14, 0xc220256c},
{0x18, 0x1080003e},
{0x1c, 0xf00e2468},
{0x20, 0xd80022fc},
{0x24, 0x80a6000c},
{0x28, 0x1880002d},
{0x2c, 0x9a102000},
{0x30, 0xd40022f8},
{0x34, 0x3300001c},
{0x38, 0xb6102001},
{0x3c, 0x80a6c00a},
{0x40, 0x18800020},
{0x44, 0xb4102000},
{0x48, 0x832e2002},
{0x4c, 0xb8006068},
{0x50, 0xa0166200},
{0x54, 0x90166198},
{0x58, 0x92166268},
{0x5c, 0xde0022f8},
{0x60, 0xfa070010},
{0x64, 0x80a7400b},
{0x68, 0x26800013},
{0x6c, 0xb606e001},
{0x70, 0x80a6e001},
{0x74, 0x22800007},
{0x78, 0xc20022f8},
{0x7c, 0xc2070008},
{0xf0, 0x98},
{0x00, 0x80a74001},
{0x04, 0x2480000c},
{0x08, 0xb606e001},
{0x0c, 0xc20022f8},
{0x10, 0x80a6c001},
{0x14, 0x22800007},
{0x18, 0xb406a001},
{0x1c, 0xc2070009},
{0x20, 0x80a74001},
{0x24, 0x26800004},
{0x28, 0xb606e001},
{0x2c, 0xb406a001},
{0x30, 0xb606e001},
{0x34, 0x80a6c00f},
{0x38, 0x08bfffea},
{0x3c, 0xb8072068},
{0x40, 0x80a6800d},
{0x44, 0x34800002},
{0x48, 0x9a10001a},
{0x4c, 0xb0062001},
{0x50, 0x80a6000c},
{0x54, 0x28bfffda},
{0x58, 0xb6102001},
{0x5c, 0xb0102000},
{0x60, 0xc20e2464},
{0x64, 0x80a06000},
{0x68, 0x22800006},
{0x6c, 0xb0062001},
{0x70, 0x80a34001},
{0x74, 0x34bfffc8},
{0x78, 0xc20e2278},
{0x7c, 0xb0062001},
{0xf0, 0x99},
{0x00, 0x80a62003},
{0x04, 0x24bffff8},
{0x08, 0xc20e2464},
{0x0c, 0xb0102000},
{0x10, 0x81c7e008},
{0x14, 0x81e80000},
{0x18, 0xda00247c},
{0x1c, 0xc20022f8},
{0x20, 0x8258400d},
{0x24, 0x83306001},
{0x28, 0x9a102000},
{0x2c, 0x80a34001},
{0x30, 0x1a800017},
{0x34, 0x031fffdf},
{0x38, 0x921063ff},
{0x3c, 0x1700001b},
{0x40, 0xd8002544},
{0x44, 0x94036001},
{0x48, 0x80a32008},
{0x4c, 0x08800006},
{0x50, 0x9b2b6002},
{0x54, 0xc203400b},
{0x58, 0x83306001},
{0x5c, 0x10800003},
{0x60, 0x82084009},
{0x64, 0xc203400b},
{0x68, 0x8258400c},
{0x6c, 0xc223400b},
{0x70, 0xda00247c},
{0x74, 0xc20022f8},
{0x78, 0x8258400d},
{0x7c, 0x83306001},
{0xf0, 0x9a},
{0x00, 0x80a28001},
{0x04, 0x0abfffef},
{0x08, 0x9a10000a},
{0x0c, 0x81c3e008},
{0x10, 0x01000000},
{0x14, 0x9de3bf98},
{0x18, 0xd600254c},
{0x1c, 0x808ae010},
{0x20, 0x2280000f},
{0x24, 0xc2002574},
{0x28, 0x033fc200},
{0x2c, 0xda002334},
{0x30, 0xd8002298},
{0x34, 0x82106070},
{0x38, 0xd8204000},
{0x3c, 0x960affef},
{0x40, 0x9a036001},
{0x44, 0xd620254c},
{0x48, 0xda202574},
{0x4c, 0xc0202544},
{0x50, 0x7fffff5f},
{0x54, 0x1100001b},
{0x58, 0xc2002574},
{0x5c, 0x80a06000},
{0x60, 0x22800011},
{0x64, 0xc2002578},
{0x68, 0x82007fff},
{0x6c, 0x7ffff2a8},
{0x70, 0xc2202574},
{0x74, 0x7fffff33},
{0x78, 0x01000000},
{0x7c, 0xc2002574},
{0xf0, 0x9b},
{0x00, 0x80a06000},
{0x04, 0x32800008},
{0x08, 0xc2002578},
{0x0c, 0x7ffffefa},
{0x10, 0x01000000},
{0x14, 0x11000019},
{0x18, 0x7ffffc8d},
{0x1c, 0x90122200},
{0x20, 0xc2002578},
{0x24, 0x80a06000},
{0x28, 0x1280001a},
{0x2c, 0x01000000},
{0x30, 0xc2002574},
{0x34, 0x80a06000},
{0x38, 0x12800016},
{0x3c, 0x01000000},
{0x40, 0x7fffff69},
{0x44, 0x01000000},
{0x48, 0x80a22000},
{0x4c, 0x02800007},
{0x50, 0xd020253c},
{0x54, 0x7fffffb1},
{0x58, 0x01000000},
{0x5c, 0xc200253c},
{0x60, 0x1080000c},
{0x64, 0xc2202574},
{0x68, 0xc2002334},
{0x6c, 0x82006001},
{0x70, 0xda00254c},
{0x74, 0xc2202574},
{0x78, 0x9a136010},
{0x7c, 0x82102001},
{0xf0, 0x9c},
{0x00, 0xda20254c},
{0x04, 0xc2202578},
{0x08, 0x7ffff8bf},
{0x0c, 0x91e82000},
{0x10, 0x01000000},
{0x14, 0x81c7e008},
{0x18, 0x81e80000},
{0x1c, 0x9de3bf98},
{0x20, 0xd800254c},
{0x24, 0x808b2010},
{0x28, 0x0280002c},
{0x2c, 0x033fc200},
{0x30, 0x82106030},
{0x34, 0xda004000},
{0x38, 0xc200257c},
{0x3c, 0x80a34001},
{0x40, 0x02800004},
{0x44, 0x03000800},
{0x48, 0x82130001},
{0x4c, 0xc220254c},
{0x50, 0xc2002344},
{0x54, 0x80a34001},
{0x58, 0x3280000d},
{0x5c, 0xc208254d},
{0x60, 0xc2002200},
{0x64, 0x80a06000},
{0x68, 0x32800009},
{0x6c, 0xc208254d},
{0x70, 0x7ffffe89},
{0x74, 0x01000000},
{0x78, 0x7ffff29e},
{0x7c, 0x01000000},
{0xf0, 0x9d},
{0x00, 0x7ffff2f6},
{0x04, 0x01000000},
{0x08, 0xc208254d},
{0x0c, 0x80a06000},
{0x10, 0x02800012},
{0x14, 0x033fc180},
{0x18, 0xc0204000},
{0x1c, 0xb0102002},
{0x20, 0x11000099},
{0x24, 0x7ffff101},
{0x28, 0x9012233c},
{0x2c, 0x7ffffdbe},
{0x30, 0x90102002},
{0x34, 0xb0863fff},
{0x38, 0x1cbffffb},
{0x3c, 0x11000099},
{0x40, 0xc210254c},
{0x44, 0x80886001},
{0x48, 0x32800002},
{0x4c, 0xc020250c},
{0x50, 0x7ffff11c},
{0x54, 0x91e82015},
{0x58, 0x01000000},
{0x5c, 0x81c7e008},
{0x60, 0x81e80000},
{0x64, 0x9de3bf98},
{0x68, 0x96100018},
{0x6c, 0x98100019},
{0x70, 0x9a10001a},
{0x74, 0x9e10001b},
{0x78, 0xb0102000},
{0x7c, 0xb4102000},
{0xf0, 0x9e},
{0x00, 0xb2102000},
{0x04, 0xb72e2002},
{0x08, 0xf816c00b},
{0x0c, 0xc216c00c},
{0x10, 0x80a70001},
{0x14, 0x0a80000a},
{0x18, 0xfa16c00d},
{0x1c, 0x80a0401d},
{0x20, 0x1a80000f},
{0x24, 0x80a66000},
{0x28, 0x80a7001d},
{0x2c, 0x1a80000b},
{0x30, 0x8210001d},
{0x34, 0x10800009},
{0x38, 0x8210001c},
{0x3c, 0x80a0401d},
{0x40, 0x08800007},
{0x44, 0x80a66000},
{0x48, 0x80a7001d},
{0x4c, 0x08800003},
{0x50, 0x8210001d},
{0x54, 0x8210001c},
{0x58, 0x80a66000},
{0x5c, 0x22800002},
{0x60, 0x83286010},
{0x64, 0xb2066001},
{0x68, 0xb4068001},
{0x6c, 0x80a66001},
{0x70, 0x04bfffe6},
{0x74, 0xb606e002},
{0x78, 0x832e2002},
{0x7c, 0xb0062001},
{0xf0, 0x9f},
{0x00, 0x80a6217f},
{0x04, 0x04bfffde},
{0x08, 0xf423c001},
{0x0c, 0x81c7e008},
{0x10, 0x81e80000},
{0x14, 0x98102000},
{0x18, 0x9b2b2002},
{0x1c, 0x98032001},
{0x20, 0xc202000d},
{0x24, 0x80a3217f},
{0x28, 0x04bffffc},
{0x2c, 0xc222400d},
{0x30, 0x81c3e008},
{0x34, 0x01000000},
{0x38, 0x9de3bf98},
{0x3c, 0x7ffffdb6},
{0x40, 0x01000000},
{0x44, 0x0300003f},
{0x48, 0x98106300},
{0x4c, 0xc2002508},
{0x50, 0x8088400c},
{0x54, 0x02800009},
{0x58, 0x033fc040},
{0x5c, 0xda002508},
{0x60, 0xc200254c},
{0x64, 0x9a0b400c},
{0x68, 0x8210400d},
{0x6c, 0xc220254c},
{0x70, 0xc0202508},
{0x74, 0x033fc040},
{0x78, 0xe4002500},
{0x7c, 0x8210600c},
{0xf0, 0xa0},
{0x00, 0x80a4a029},
{0x04, 0x08800008},
{0x08, 0xc0204000},
{0x0c, 0x7fffff42},
{0x10, 0x01000000},
{0x14, 0x7fffff82},
{0x18, 0x01000000},
{0x1c, 0x10800085},
{0x20, 0xc2002500},
{0x24, 0x80a4a000},
{0x28, 0x12800013},
{0x2c, 0x80a4a014},
{0x30, 0x7ffff0c4},
{0x34, 0x90102000},
{0x38, 0x033fc200},
{0x3c, 0xda002330},
{0x40, 0x82106074},
{0x44, 0xda204000},
{0x48, 0x7ffff0ad},
{0x4c, 0x90102001},
{0x50, 0x7ffff184},
{0x54, 0x01000000},
{0x58, 0x80a22000},
{0x5c, 0x32800075},
{0x60, 0xc2002500},
{0x64, 0x7ffffd50},
{0x68, 0x90102001},
{0x6c, 0x10800071},
{0x70, 0xc2002500},
{0x74, 0x1880000c},
{0x78, 0x80a4a015},
{0x7c, 0x808ca001},
{0xf0, 0xa1},
{0x00, 0x3280006c},
{0x04, 0xc2002500},
{0x08, 0x9004bffe},
{0x0c, 0x7fffef7b},
{0x10, 0x91322001},
{0x14, 0x7ffff08e},
{0x18, 0x01000000},
{0x1c, 0x10800065},
{0x20, 0xc2002500},
{0x24, 0x18800017},
{0x28, 0x80a4a016},
{0x2c, 0x7ffffdd6},
{0x30, 0x01000000},
{0x34, 0x7ffff16b},
{0x38, 0x01000000},
{0x3c, 0x80a22000},
{0x40, 0x32800005},
{0x44, 0x033fc180},
{0x48, 0x7ffffd37},
{0x4c, 0x90102001},
{0x50, 0x033fc180},
{0x54, 0xda0025b0},
{0x58, 0x82106038},
{0x5c, 0xda204000},
{0x60, 0x033fc200},
{0x64, 0xda00232c},
{0x68, 0x82106074},
{0x6c, 0xda204000},
{0x70, 0x7ffff083},
{0x74, 0x90102000},
{0x78, 0x1080004e},
{0x7c, 0xc2002500},
{0xf0, 0xa2},
{0x00, 0x18800006},
{0x04, 0x80a4a018},
{0x08, 0x7ffffe71},
{0x0c, 0x1100001b},
{0x10, 0x10800048},
{0x14, 0xc2002500},
{0x18, 0x18800012},
{0x1c, 0x80a4a028},
{0x20, 0x033fc140},
{0x24, 0x82106048},
{0x28, 0xda004000},
{0x2c, 0x03000040},
{0x30, 0x11000018},
{0x34, 0x808b4001},
{0x38, 0x02800006},
{0x3c, 0x1300001e},
{0x40, 0x11000016},
{0x44, 0x1300001c},
{0x48, 0x90122200},
{0x4c, 0x92126200},
{0x50, 0x7fffff91},
{0x54, 0x01000000},
{0x58, 0x10800036},
{0x5c, 0xc2002500},
{0x60, 0x38800034},
{0x64, 0xc2002500},
{0x68, 0x033fc140},
{0x6c, 0x82106048},
{0x70, 0xda004000},
{0x74, 0x03000040},
{0x78, 0x808b4001},
{0x7c, 0x0280000e},
{0xf0, 0xa3},
{0x00, 0x1500001e},
{0x04, 0x2100001c},
{0x08, 0x92142200},
{0x0c, 0x23000016},
{0x10, 0x96100009},
{0x14, 0x90146200},
{0x18, 0x7fffff53},
{0x1c, 0x1500001e},
{0x20, 0x7ffffe28},
{0x24, 0x90142200},
{0x28, 0x90146200},
{0x2c, 0x1080000b},
{0x30, 0x92142200},
{0x34, 0x1300001c},
{0x38, 0x92126200},
{0x3c, 0x11000018},
{0x40, 0x7fffff49},
{0x44, 0x9610000a},
{0x48, 0x7ffffe1e},
{0x4c, 0x1100001e},
{0x50, 0x11000018},
{0x54, 0x1300001e},
{0x58, 0x7fffff6f},
{0x5c, 0x01000000},
{0x60, 0x80a4a028},
{0x64, 0x32800013},
{0x68, 0xc2002500},
{0x6c, 0x7ffffe40},
{0x70, 0x01000000},
{0x74, 0xc200250c},
{0x78, 0x80a06000},
{0x7c, 0x3280000a},
{0xf0, 0xa4},
{0x00, 0xc200254c},
{0x04, 0x031696a9},
{0x08, 0x821061a5},
{0x0c, 0x11000019},
{0x10, 0xc220250c},
{0x14, 0x90122200},
{0x18, 0x7fffff5f},
{0x1c, 0x13000015},
{0x20, 0xc200254c},
{0x24, 0x82106012},
{0x28, 0xc220254c},
{0x2c, 0xc2002500},
{0x30, 0x80a48001},
{0x34, 0x3280000c},
{0x38, 0xc0202578},
{0x3c, 0x031fffff},
{0x40, 0x821063f0},
{0x44, 0x80a48001},
{0x48, 0x38800003},
{0x4c, 0x25040000},
{0x50, 0xa404a001},
{0x54, 0x033fc180},
{0x58, 0x82106034},
{0x5c, 0xe4204000},
{0x60, 0xe4202500},
{0x64, 0xc2002578},
{0x68, 0x80a06000},
{0x6c, 0x02800005},
{0x70, 0x01000000},
{0x74, 0x7ffffd23},
{0x78, 0x01000000},
{0x7c, 0xc0202578},
{0xf0, 0xa5},
{0x00, 0x81c7e008},
{0x04, 0x81e80000},
{0x08, 0x81c3e008},
{0x0c, 0x01000000},
{0x10, 0x00000000},
{0x14, 0x00000000},
{0x18, 0x00000000},
{0x1c, 0x00000000},
{0x20, 0x00000000},
{0x24, 0x00000000},
{0x28, 0x00000000},
{0x2c, 0x00000000},
{0x30, 0x00000000},
{0x34, 0x00000000},
{0x38, 0x00000000},
{0x3c, 0x00000000},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00000000},
{0x50, 0x00000000},
{0x54, 0x00000000},
{0x58, 0x00000000},
{0x5c, 0x00000000},
{0x60, 0x00000000},
{0x64, 0x00000000},
{0x68, 0x00000000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x00000000},
{0xf0, 0xa6},
{0x00, 0x00003692},
{0x04, 0xa5010402},
{0x08, 0xa5000000},
{0x0c, 0x00000000},
{0x10, 0x4c494348},
{0x14, 0x49444449},
{0x18, 0x43415352},
{0x1c, 0x4341534c},
{0x20, 0x43415345},
{0x24, 0x534f5254},
{0x28, 0x4b455953},
{0x2c, 0x4e454152},
{0x30, 0x4156474e},
{0x34, 0x47525752},
{0x38, 0x52464d41},
{0x3c, 0x52534e55},
{0x40, 0x5244524f},
{0x44, 0x45534443},
{0x48, 0x52454f4e},
{0x4c, 0x53554352},
{0x50, 0x50524553},
{0x54, 0x00000000},
{0x58, 0x4f637420},
{0x5c, 0x32312032},
{0x60, 0x30313300},
{0x64, 0x00000000},
{0x68, 0x31363a32},
{0x6c, 0x383a3238},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x00000000},
};

#endif
