// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (c) 2022 Rockchip Electronics Co. Ltd.
 *
 * it66353 HDMI 3 in 1 out driver.
 *
 * Author: Kenneth.Hung@ite.com.tw
 *	   Wangqiang Guo <kay.guo@rock-chips.com>
 * Version: IT66353_SAMPLE_1.08
 *
 */
#include <linux/module.h>
#include "config.h"
#include "platform.h"
#include "debug.h"
#include "it66353_drv.h"
#include "it66353_EQ.h"
#include "it66353.h"

/*
 * TX_PN_SWAP
 * 1: Enable TX side TMDS P/N swap
 * 0: Disable TX side TMDS P/N swap
 */
#define TX_PN_SWAP 0
#ifndef TX_PN_SWAP

	#pragma message("TX_PN_SWAP is defined to 0")
	#pragma message("IT6635 EVB should be TX_PN_SWAP==1")
	#error ("Please define TX_PN_SWAP by your PCB layout.")

#else

	#if TX_PN_SWAP
		#ifdef _SHOW_PRAGMA_MSG
		#pragma message("TX_PN_SWAP is pre-defined to 1")
		#endif
	#else
		#ifdef _SHOW_PRAGMA_MSG
		#pragma message("TX_PN_SWAP is pre-defined to 0")
		#endif
	#endif

#endif

/*
 * DEFAULT_RS_IDX
 * :The default EQ when power on.
 */
#define DEFAULT_RS_IDX 4

/*
 * DEFAULT_PORT
 * :The default active port when power on.
 */
#define DEFAULT_PORT   0

// constant definition
#define HPD_TOGGLE_TIMEOUT_400MS (27)
#define HPD_TOGGLE_TIMEOUT_1SEC (100)
#define HPD_TOGGLE_TIMEOUT_2SEC (20|(0x80))
#define HPD_TOGGLE_TIMEOUT_3SEC (30|(0x80))



IT6635_RX_OPTIONS it66353_s_RxOpts = {
	0xC3,	// u8 tag1;
	0,		// u8 EnRxDDCBypass;
	0,		// u8 EnRxPWR5VBypass;
	0,		// u8 EnRxHPDBypass;
	1,		// u8 TryFixedEQFirst;
	1,		// u8 EnableAutoEQ;
	1,		// u8 NonActivePortReplyHPD;
	0,		// u8 DisableEdidRam;
	{DEFAULT_RS_IDX, DEFAULT_RS_IDX, DEFAULT_RS_IDX}, // u8 DefaultEQ[3];
	1,		// u8 FixIncorrectHdmiEnc;
	0,		// u8 HPDOutputInverse;
	HPD_TOGGLE_TIMEOUT_2SEC,	// u8 HPDTogglePeriod;
	1,		// u8 TxOEAlignment;
	(u8)sizeof(IT6635_RX_OPTIONS),	// u8 str_size;
};

IT6635_TX_OPTIONS it66353_s_TxOpts = {
	0x3C,		// u8 tag1;
	TX_PN_SWAP,	// u8 EnTxPNSwap;
	TX_PN_SWAP,	// u8 EnTxChSwap;
	0,		// u8 EnTxVCLKInv;
	0,		// u8 EnTxOutD1t;
	1,		// u8 CopyEDIDFromSink;
	1,		// u8 ParsePhysicalAddr;
	1,		// u8 TurnOffTx5VWhenSwitchPort;
	(u8)sizeof(IT6635_TX_OPTIONS),	// u8 str_size;
};

IT6635_DEV_OPTION it66353_s_DevOpts = {
	0x5A,		// u8 tag1;
	SWAddr,		// u8 SwAddr;
	RXAddr,		// u8 RxAddr;
	CECAddr,	// u8 CecAddr;
	RXEDIDAddr,	// u8 EdidAddr;
	// u8 EnCEC;
	0,		// u8 ForceRxOn;
	1,		// u8 RxAutoPowerDown;
	1,		// u8 DoTxPowerDown;
	0,		// u8 TxPowerDownWhileWaitingClock;
	(u8)sizeof(IT6635_DEV_OPTION),	// u8 str_size;

};

u8 it66353_s_default_edid_port0[] = {
	0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
	0x26, 0x85, 0x35, 0x66, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x19, 0x01, 0x03, 0x80, 0x80, 0x48, 0x78,
	0x0A, 0xDA, 0xFF, 0xA3, 0x58, 0x4A, 0xA2, 0x29,
	0x17, 0x49, 0x4B, 0x20, 0x08, 0x00, 0x31, 0x40,
	0x61, 0x40, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0xE8,
	0x00, 0x30, 0xF2, 0x70, 0x5A, 0x80, 0xB0, 0x58,
	0x8A, 0x00, 0xBA, 0x88, 0x21, 0x00, 0x00, 0x1E,
	0x02, 0x3A, 0x80, 0x18, 0x71, 0x38, 0x2D, 0x40,
	0x58, 0x2C, 0x45, 0x00, 0xBA, 0x88, 0x21, 0x00,
	0x00, 0x1E, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x50,
	0x61, 0x6E, 0x61, 0x73, 0x6F, 0x6E, 0x69, 0x63,
	0x2D, 0x54, 0x56, 0x0A, 0x00, 0x00, 0x00, 0xFD,
	0x00, 0x17, 0x3D, 0x0F, 0x88, 0x3C, 0x00, 0x0A,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0xF0,

	0x02, 0x03, 0x43, 0xF0, 0x57, 0x10, 0x1F, 0x05,
	0x14, 0x20, 0x21, 0x22, 0x04, 0x13, 0x03, 0x12,
	0x07, 0x16, 0x5D, 0x5E, 0x5F, 0x62, 0x63, 0x64,
	0x61, 0x60, 0x66, 0x65, 0x23, 0x09, 0x07, 0x01,
	0x6E, 0x03, 0x0C, 0x00, 0x10, 0x00, 0x38, 0x3C,
	0x2F, 0x00, 0x80, 0x01, 0x02, 0x03, 0x04, 0x67,
	0xD8, 0x5D, 0xC4, 0x01, 0x78, 0x80, 0x03, 0xE2,
	0x00, 0x4B, 0xE3, 0x05, 0x1F, 0x01, 0xE4, 0x0F,
	0x00, 0x00, 0x78, 0x56, 0x5E, 0x00, 0xA0, 0xA0,
	0xA0, 0x29, 0x50, 0x30, 0x20, 0x35, 0x00, 0xBA,
	0x88, 0x21, 0x00, 0x00, 0x1A, 0x66, 0x21, 0x56,
	0xAA, 0x51, 0x00, 0x1E, 0x30, 0x46, 0x8F, 0x33,
	0x00, 0xBA, 0x88, 0x21, 0x00, 0x00, 0x1E, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06,
};

void it66353_options_init(void)
{
	it66353_gdev.opts.rx_opt[0] = &it66353_s_RxOpts;
	it66353_gdev.opts.rx_opt[1] = &it66353_s_RxOpts;
	it66353_gdev.opts.rx_opt[2] = &it66353_s_RxOpts;
	it66353_gdev.opts.rx_opt[3] = &it66353_s_RxOpts;
	it66353_gdev.opts.active_rx_opt = it66353_gdev.opts.rx_opt[DEFAULT_PORT];
	it66353_gdev.opts.tx_opt = &it66353_s_TxOpts;
	it66353_gdev.opts.dev_opt = &it66353_s_DevOpts;
	it66353_gdev.vars.Rx_active_port = DEFAULT_PORT;

	it66353_vars_init();
}

MODULE_LICENSE("GPL v2");
