/* SPDX-License-Identifier: GPL-2.0 */
/********************************************************************************
 *
 *  Copyright (C) 2017 	NEXTCHIP Inc. All rights reserved.
 *  Module		: video_eq_table.c
 *  Description	:
 *  Author		:
 *  Date         :
 *  Version		: Version 1.0
 *
 ********************************************************************************
 *  History      :
 *
 *
 ********************************************************************************/
#ifndef _CABLE_B_VIDEO_EQ_TABLE_H_
#define _CABLE_B_VIDEO_EQ_TABLE_H_

#include "new_video_eq.h"

_video_equalizer_value_table_s_test equalizer_value_fmtdef_cableB[ NC_EQ_SETTING_FMT_MAX ] =
{
	[ AHD20_1080P_30P_SINGLE_ENDED ] = /* o */
	{
		.name         = "AHD20_1080P_30P_SINGLE_ENDED",
		.video_fmt    = AHD20_1080P_30P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x62,  0x22,  0x22,  0x22,  0x22,  0x22 },
			.eq_band_sel = {  0x77,  0x77,  0x77,  0x77,  0x57,  0x57 },
			.eq_gain_sel = {  0x78,  0x7b,  0x7f,  0x7f,  0x7f,  0x7f },
			.deq_a_on 	 = {  0x00,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.deq_a_sel   = {  0x00,  0x91,  0x87,  0x89,  0x93,  0x94 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC,  0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78,  0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17,  0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1,  0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3,  0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A,  0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2,  0xB2 },
		},
		/* color */
		{
			.contrast  		= {  0x86,  0x82,  0x82,  0x7e,  0x7c,  0x77 },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x0f,  0x0f },
			.c_filter  		= {  0x82,  0x82,  0x82,  0x82,  0xa2,  0xb2 },
			.hue 	  		= {  0x00,  0x00,  0x00,  0xfe,  0xfe,  0xfe },
			.u_gain   		= {  0x00,  0x00,  0x04,  0x10,  0x10,  0x18 },
			.v_gain   		= {  0x00,  0x00,  0xf0,  0x0e,  0x0e,  0x14 },
			.u_offset 		= {  0xfe,  0xfe,  0xfe,  0xfe,  0xfe,  0xfe },
			.v_offset 		= {  0xfb,  0xfb,  0xfb,  0xfb,  0xfb,  0xfb },
			.black_level    = {  0x80,  0x81,  0x81,  0x83,  0x83,  0x87 },
			.acc_ref		= {  0x57,  0x57,  0x57,  0x57,  0x57,  0x57 },
			.cti_delay      = {  0x80,  0x80,  0x80,  0x80,  0x80,  0x80 },
			.sub_saturation = {  0xa8,  0xa8,  0xa8,  0xa8,  0x90,  0x90 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a,  0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.burst_dec_c 	= {  0x30,  0x30,  0x30,  0x30,  0x30,  0x30 },
			.c_option       = {  0x80,  0x80,  0x90,  0x90,  0x90,  0xa0 },
			.y_filter_b     = {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e,  0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x86,  0x84,  0x80,  0x80,  0x80,  0x80 },
			.h_delay_b = {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.h_delay_c = {  0x03,  0x03,  0x03,  0x03,  0x03,  0x03 },
			.y_delay   = {  0x05,  0x03,  0x03,  0x03,  0x03,  0x03 },
		},
		/* clock */
		{
			.clk_adc = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.clk_dec = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler2 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler3 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler4 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler9 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.comb_mode 		= {  0x01,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72,  0x72 },
			.mem_path 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc,  0xdc },
			.format_set1 	= {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.format_set2 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.vblk_end 		= {  0x21,  0x21,  0x21,  0x21,  0x21,  0x21 },
		},
	},

	[ AHD20_1080P_25P_SINGLE_ENDED ] =
	{
		.name         = "AHD20_1080P_25P_SINGLE_ENDED",
		.video_fmt    = AHD20_1080P_25P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x62,  0x22,  0x22,  0x22,  0x22,  0x22 },
			.eq_band_sel = {  0x77,  0x77,  0x77,  0x77,  0x57,  0x57 },
			.eq_gain_sel = {  0x78,  0x7b,  0x7f,  0x7f,  0x7f,  0x7f },
			.deq_a_on 	 = {  0x00,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.deq_a_sel   = {  0x00,  0x91,  0x87,  0x89,  0x93,  0x94 },
			.deq_b_sel 	 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC,  0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78,  0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17,  0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1,  0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3,  0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A,  0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2,  0xB2 },
		},
		/* color */
		{
			.contrast  		= {  0x86,  0x82,  0x82,  0x7e,  0x7c,  0x77 },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x0f,  0x0f },
			.c_filter  		= {  0x82,  0x82,  0x82,  0x82,  0xa2,  0xb2 },
			.hue     		= {  0x00,  0x00,  0x00,  0xfe,  0xfe,  0xfe },
			.u_gain  		= {  0x00,  0x00,  0x04,  0x10,  0x10,  0x18 },
			.v_gain   		= {  0x00,  0x00,  0xf0,  0x0e,  0x0e,  0x14 },
			.u_offset 		= {  0xfe,  0xfe,  0xfe,  0xfe,  0xfe,  0xfe },
			.v_offset 		= {  0xfb,  0xfb,  0xfb,  0xfb,  0xfb,  0xfb },
			.black_level 	= {  0x80,  0x81,  0x81,  0x83,  0x83,  0x87 },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57,  0x57 },
			.cti_delay      = {  0x80,  0x80,  0x80,  0x80,  0x80,  0x80 },
			.sub_saturation = {  0xa8,  0xa8,  0xa8,  0xa8,  0x90,  0x90 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a,  0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.burst_dec_c 	= {  0x30,  0x30,  0x30,  0x30,  0x30,  0x30 },
			.c_option 	    = {  0x80,  0x80,  0x90,  0x90,  0x90,  0xa0 },
			.y_filter_b     = {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e,  0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x86,  0x84,  0x80,  0x80,  0x80,  0x80 },
			.h_delay_b = {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.h_delay_c = {  0x03,  0x03,  0x03,  0x03,  0x03,  0x03 },
			.y_delay   = {  0x05,  0x03,  0x03,  0x03,  0x03,  0x03 },
		},
		/* clock */
		{
			.clk_adc = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.clk_dec = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler2 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler3 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler4 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler9 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.pn_auto  		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.comb_mode 		= {  0x01,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72,  0x72 },
			.mem_path 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc,  0xdc },
			.format_set1 	= {  0x03,  0x03,  0x03,  0x03,  0x03,  0x03 },
			.format_set2 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.vblk_end 		= {  0x21,  0x21,  0x21,  0x21,  0x21,  0x21 },
		},
	},

	[ AHD20_720P_25P_EX_Btype_SINGLE_ENDED ] =
	{
		.name         = "AHD20_720P_25P_EX_Btype_SINGLE_ENDED",
		.video_fmt    = AHD20_720P_25P_EX_Btype,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x62,  0x62,  0x22,  0x22,  0x22,  0x22 },
			.eq_band_sel = {  0x77,  0x77,  0x77,  0x77,  0x67,  0x57 },
			.eq_gain_sel = {  0x78,  0x78,  0x7a,  0x7f,  0x7f,  0x7f },
			.deq_a_on 	 = {  0x00,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.deq_a_sel 	 = {  0x00,  0x86,  0x87,  0x93,  0x8e,  0x8e },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC,  0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78,  0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17,  0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1,  0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3,  0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A,  0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2,  0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x88,  0x88,  0x78,  0x88,  0x88,  0x7e },
			.h_peaking 		= {  0x3f,  0x3f,  0x3f,  0x3f,  0x3f,  0x3f },
			.c_filter 		= {  0x82,  0x82,  0x82,  0x82,  0x92,  0x92 },
			.hue 			= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.u_gain			= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.v_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.u_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.black_level	= {  0x84,  0x84,  0x84,  0x84,  0x84,  0x86 },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57,  0x57 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80,  0x80 },
			.sub_saturation = {  0xa8,  0xab,  0xb0,  0xb0,  0xa4,  0xa0 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a,  0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.burst_dec_c	= {  0x30,  0x30,  0x30,  0x30,  0x30,  0x30 },
			.c_option 		= {  0x80,  0x80,  0x80,  0x80,  0x90,  0x90 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e,  0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x60,  0x60,  0x5e,  0x5b,  0x59,  0x59 },
			.h_delay_b = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_delay_c = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.y_delay   = {  0x05,  0x05,  0x05,  0x05,  0x05,  0x05 },
		},
		/* clock */
		{
			.clk_adc = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.clk_dec = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler2 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler3 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler4		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler9 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.comb_mode 		= {  0x01,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72,  0x72 },
			.mem_path 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc,  0xdc },
			.format_set1 	= {  0x0d,  0x0d,  0x0d,  0x0d,  0x0d,  0x0d },
			.format_set2 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.vblk_end 		= {  0x21,  0x21,  0x21,  0x21,  0x21,  0x21 },
		},
	},

	[ AHD20_720P_30P_EX_Btype_SINGLE_ENDED ] =
	{
		.name         = "AHD20_720P_30P_EX_Btype_SINGLE_ENDED",
		.video_fmt    = AHD20_720P_30P_EX_Btype,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass 	 = {  0x62,  0x62,  0x22,  0x22,  0x22,  0x22 },
			.eq_band_sel = {  0x77,  0x77,  0x77,  0x77,  0x67,  0x57 },
			.eq_gain_sel = {  0x78,  0x78,  0x7a,  0x7f,  0x7f,  0x7f },
			.deq_a_on    = {  0x00,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.deq_a_sel 	 = {  0x00,  0x86,  0x87,  0x93,  0x8e,  0x8e },
			.deq_b_sel 	 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC,  0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78,  0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17,  0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1,  0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3,  0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A,  0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2,  0xB2 },

		},
		/* color */
		{
			.contrast 		= {  0x88,  0x88,  0x78,  0x88,  0x88,  0x7e },
			.h_peaking 		= {  0x3f,  0x3f,  0x3f,  0x3f,  0x3f,  0x3f },
			.c_filter 		= {  0x82,  0x82,  0x82,  0x82,  0x92,  0x92 },
			.hue 			= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.u_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.v_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.u_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.black_level 	= {  0x84,  0x84,  0x84,  0x84,  0x84,  0x86 },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57,  0x57 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80,  0x80 },
			.sub_saturation = {  0xa8,  0xab,  0xb0,  0xb0,  0xa4,  0xa0 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a,  0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.burst_dec_c 	= {  0x30,  0x30,  0x30,  0x30,  0x30,  0x30 },
			.c_option 		= {  0x80,  0x80,  0x80,  0x80,  0x90,  0x90 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e,  0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x60,  0x60,  0x5e,  0x5b,  0x59,  0x59 },
			.h_delay_b = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_delay_c = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.y_delay   = {  0x05,  0x05,  0x05,  0x05,  0x05,  0x05 },
		},
		/* clock */
		{
			.clk_adc = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.clk_dec = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler2 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler3 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler4		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler9 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.comb_mode 		= {  0x01,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72,  0x72 },
			.mem_path 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc,  0xdc },
			.format_set1 	= {  0x0c,  0x0c,  0x0c,  0x0c,  0x0c,  0x0c },
			.format_set2 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.vblk_end 		= {  0x21,  0x21,  0x21,  0x21,  0x21,  0x21 },
		},
	},

	[ AHD20_720P_25P_SINGLE_ENDED ] =
	{
		.name         = "AHD20_720P_25P_SINGLE_ENDED",
		.video_fmt    = AHD20_720P_25P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass 	 = {  0x62,  0x62,  0x22,  0x22,  0x22,  0x22 },
			.eq_band_sel = {  0x77,  0x77,  0x77,  0x77,  0x67,  0x57 },
			.eq_gain_sel = {  0x78,  0x78,  0x7a,  0x7f,  0x7f,  0x7f },
			.deq_a_on 	 = {  0x00,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.deq_a_sel   = {  0x00,  0x86,  0x87,  0x93,  0x8e,  0x8e },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC,  0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78,  0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17,  0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1,  0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3,  0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A,  0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2,  0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x88,  0x88,  0x78,  0x88,  0x88,  0x7e },
			.h_peaking 		= {  0x3f,  0x3f,  0x3f,  0x3f,  0x3f,  0x3f },
			.c_filter 		= {  0x82,  0x82,  0x82,  0x82,  0x92,  0x92 },
			.hue 			= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.u_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.v_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.u_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.black_level 	= {  0x84,  0x84,  0x84,  0x84,  0x84,  0x86 },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57,  0x57 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80,  0x80 },
			.sub_saturation = {  0xa8,  0xab,  0xb0,  0xb0,  0xa4,  0xa0 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a,  0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.burst_dec_c	= {  0x30,  0x30,  0x30,  0x30,  0x30,  0x30 },
			.c_option 		= {  0x80,  0x80,  0x80,  0x80,  0x90,  0x90 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e,  0x1e },

		},
		/* timing_a */
		{
			.h_delay_a = {  0x60,  0x60,  0x5e,  0x5b,  0x59,  0x59 },
			.h_delay_b = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_delay_c = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.y_delay   = {  0x05,  0x05,  0x05,  0x05,  0x05,    0x05 },
		},
		/* clock */
		{
			.clk_adc = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.clk_dec = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler2 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler3 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler4 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler9 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.comb_mode 		= {  0x01,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72,  0x72 },
			.mem_path 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc,  0xdc },
			.format_set1 	= {  0x0d,  0x0d,  0x0d,  0x0d,  0x0d,  0x0d },
			.format_set2 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.vblk_end 		= {  0x21,  0x21,  0x21,  0x21,  0x21,  0x21 },
		},
	},

	[ AHD20_720P_30P_SINGLE_ENDED ] =
	{
		.name         = "AHD20_720P_30P_SINGLE_ENDED",
		.video_fmt    = AHD20_720P_30P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass 	 = {  0x62,  0x62,  0x22,  0x22,  0x22,  0x22 },
			.eq_band_sel = {  0x77,  0x77,  0x77,  0x77,  0x67,  0x57 },
			.eq_gain_sel = {  0x78,  0x78,  0x7a,  0x7f,  0x7f,  0x7f },
			.deq_a_on 	 = {  0x00,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.deq_a_sel 	 = {  0x00,  0x86,  0x87,  0x93,  0x8e,  0x8e },
			.deq_b_sel 	 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC,  0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78,  0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17,  0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1,  0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3,  0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A,  0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2,  0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x88,  0x88,  0x78,  0x88,  0x88,  0x7e },
			.h_peaking 		= {  0x3f,  0x3f,  0x3f,  0x3f,  0x3f,  0x3f },
			.c_filter 		= {  0x82,  0x82,  0x82,  0x82,  0x92,  0x92 },
			.hue 			= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.u_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.v_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.u_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.black_level 	= {  0x84,  0x84,  0x84,  0x84,  0x84,  0x86 },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57,  0x57 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80,  0x80 },
			.sub_saturation = {  0xa8,  0xab,  0xb0,  0xb0,  0xa4,  0xa0 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a,  0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.burst_dec_c 	= {  0x30,  0x30,  0x30,  0x30,  0x30,  0x30 },
			.c_option 		= {  0x80,  0x80,  0x80,  0x80,  0x90,  0x90 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e,  0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x60,  0x60,  0x5e,  0x5b,  0x59,  0x59 },
			.h_delay_b = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_delay_c = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.y_delay   = {  0x05,  0x05,  0x05,  0x05,  0x05,    0x05 },
		},
		/* clock */
		{
			.clk_adc = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.clk_dec = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler2 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler3 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler4 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler9 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.comb_mode 		= {  0x01,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72,  0x72 },
			.mem_path 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc,  0xdc },
			.format_set1 	= {  0x0c,  0x0c,  0x0c,  0x0c,  0x0c,  0x0c },
			.format_set2 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.vblk_end 		= {  0x21,  0x21,  0x21,  0x21,  0x21,  0x21 },
		},
	},

	[ CVI_FHD_25P_SINGLE_ENDED ] =
	{
		.name         = "CVI_FHD_25P_SINGLE_ENDED",
		.video_fmt    = CVI_FHD_25P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x62,  0x22,  0x22,  0x22,  0x22,  0x22 },
			.eq_band_sel = {  0x07,  0x77,  0x77,  0x77,  0x67,  0x47 },
			.eq_gain_sel = {  0x78,  0x7f,  0x6f,  0x7f,  0x7f,  0x7f },
			.deq_a_on    = {  0x00,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.deq_a_sel   = {  0x00,  0x92,  0x93,  0x94,  0x95,  0x93 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC,  0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78,  0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17,  0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1,  0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3,  0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A,  0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2,  0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x98,  0x98,  0x98,  0x98,  0x98,  0x98 },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.c_filter 		= {  0x92,  0x92,  0x92,  0x92,  0xb2,  0xb2 },
			.hue 			= {  0x03,  0x03,  0x04,  0x04,  0x04,  0x04 },
			.u_gain 		= {  0x0c,  0x0c,  0x0c,  0x0c,  0x0c,  0x0c },
			.v_gain 		= {  0x1a,  0x1a,  0x1a,  0x1a,  0x1a,  0x1a },
			.u_offset 		= {  0xfa,  0xfa,  0xfa,  0xfa,  0xfa,  0xfa },
			.v_offset 		= {  0xfa,  0xfa,  0xfa,  0xfa,  0xfa,  0xfa },
			.black_level 	= {  0x86,  0x7a,  0x88,  0x84,  0x84,  0x84 },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x47,  0x37 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80,  0x80 },
			.sub_saturation = {  0xa8,  0xa0,  0xa0,  0x90,  0x90,  0x90 },
			.burst_dec_a    = {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a,  0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.burst_dec_c 	= {  0x30,  0x30,  0x30,  0x30,  0x30,  0x30 },
			.c_option 		= {  0xc0,  0xc0,  0xc0,  0xc0,  0xc0,  0xc0 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e,  0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x80,  0x80,  0x80,  0x80,  0x80,  0x80 },
			.h_delay_b = {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.h_delay_c = {  0x06,  0x06,  0x06,  0x06,  0x06,  0x06 },
			.y_delay   = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
		},
		/* clock */
		{
			.clk_adc = {  0x05,  0x05,  0x05,  0x05,  0x05,  0x05 },
			.clk_dec = {  0x44,  0x44,  0x44,  0x44,  0x44,  0x44 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x01,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.h_scaler2 		= {  0x49,  0x49,  0x49,  0x49,  0x49,  0x49 },
			.h_scaler3 		= {  0x4f,  0x4f,  0x4f,  0x4f,  0x4f,  0x4f },
			.h_scaler4 		= {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler9 		= {  0x80,  0x80,  0x80,  0x80,  0x80,  0x80 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05,  0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72,  0x72 },
			.mem_path 		= {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc,  0xdc },
			.format_set1 	= {  0x03,  0x03,  0x03,  0x03,  0x03,  0x03 },
			.format_set2 	= {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.vblk_end 		= {  0x80,  0x80,  0x80,  0x80,  0x80,  0x80 },
		},
	},

	[ CVI_FHD_30P_SINGLE_ENDED ] =
	{
		.name         = "CVI_FHD_30P_SINGLE_ENDED",
		.video_fmt    = CVI_FHD_30P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x62,  0x22,  0x22,  0x22,  0x22,  0x22 },
			.eq_band_sel = {  0x07,  0x77,  0x77,  0x77,  0x67,  0x47 },
			.eq_gain_sel = {  0x78,  0x7f,  0x6f,  0x7f,  0x7f,  0x7f },
			.deq_a_on    = {  0x00,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.deq_a_sel   = {  0x00,  0x92,  0x93,  0x94,  0x95,  0x93 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC,  0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78,  0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17,  0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1,  0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3,  0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A,  0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2,  0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x98,  0x98,  0x98,  0x98,  0x98,  0x98 },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.c_filter 		= {  0x92,  0x92,  0x92,  0x92,  0xb2,  0xb2 },
			.hue 			= {  0x03,  0x03,  0x04,  0x04,  0x04,  0x04 },
			.u_gain 		= {  0x0c,  0x0c,  0x0c,  0x0c,  0x0c,  0x0c },
			.v_gain 		= {  0x1a,  0x1a,  0x1a,  0x1a,  0x1a,  0x1a },
			.u_offset 		= {  0xfa,  0xfa,  0xfa,  0xfa,  0xfa,  0xfa },
			.v_offset 		= {  0xfa,  0xfa,  0xfa,  0xfa,  0xfa,  0xfa },
			.black_level 	= {  0x86,  0x7a,  0x88,  0x84,  0x84,  0x84 },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x47,  0x37 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80,  0x80 },
			.sub_saturation = {  0xa8,  0xa0,  0xa0,  0x90,  0x90,  0x90 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a,  0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.burst_dec_c 	= {  0x30,  0x30,  0x30,  0x30,  0x30,  0x30 },
			.c_option 		= {  0xc0,  0xc0,  0xc0,  0xc0,  0xc0,  0xc0 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e,  0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x80,  0x80,  0x80,  0x80,  0x80,  0x80 },
			.h_delay_b = {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.h_delay_c = {  0x06,  0x06,  0x06,  0x06,  0x06,  0x06 },
			.y_delay   = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
		},
		/* clock */
		{
			.clk_adc = {  0x05,  0x05,  0x05,  0x05,  0x05,  0x05 },
			.clk_dec = {  0x44,  0x44,  0x44,  0x44,  0x44,  0x44 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x01,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.h_scaler2 		= {  0x39,  0x39,  0x39,  0x39,  0x39,  0x39 },
			.h_scaler3 		= {  0x50,  0x50,  0x50,  0x50,  0x50,  0x50 },
			.h_scaler4 		= {  0x01,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler9 		= {  0x80,  0x80,  0x80,  0x80,  0x80,  0x80 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05,  0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72,  0x72 },
			.mem_path 		= {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc,  0xdc },
			.format_set1 	= {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.format_set2 	= {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.vblk_end 		= {  0x80,  0x80,  0x80,  0x80,  0x80,  0x80 },
		},
	},

	[ CVI_HD_25P_SINGLE_ENDED ] =
	{
		.name         = "CVI_HD_25P_SINGLE_ENDED",
		.video_fmt    = CVI_HD_25P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x22,  0x22,  0x22,  0x22,  0x22,  0x22 },
			.eq_band_sel = {  0x77,  0x67,  0x57,  0x57,  0x57,  0x47 },
			.eq_gain_sel = {  0x78,  0x78,  0x78,  0x7f,  0x7f,  0x7f },
			.deq_a_on    = {  0x00,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.deq_a_sel   = {  0x00,  0x91,  0x92,  0x93,  0x93,  0x93 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC,  0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78,  0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17,  0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1,  0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3,  0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A,  0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2,  0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x88,  0x8c,  0x8a,  0x87,  0x85,  0x84 },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.c_filter 		= {  0x82,  0x92,  0x92,  0x92,  0xa2,  0xa2 },
			.hue 			= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.u_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.v_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.u_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.black_level 	= {  0x84,  0x86,  0x84,  0x84,  0x86,  0x88 },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57,  0x57 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80,  0x80 },
			.sub_saturation = {  0xa8,  0xaa,  0xaa,  0xac,  0xa8,  0xa6 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a,  0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.burst_dec_c 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.c_option 		= {  0x80,  0x80,  0x80,  0x80,  0xa0,  0xa0 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e,  0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x60,  0x60,  0x5e,  0x5b,  0x59,  0x59 },
			.h_delay_b = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_delay_c = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.y_delay   = {  0x05,  0x05,  0x05,  0x05,  0x05,  0x05 },
		},
		/* clock */
		{
			.clk_adc = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.clk_dec = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x01,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.h_scaler2 		= {  0x29,  0x29,  0x29,  0x29,  0x29,  0x29 },
			.h_scaler3 		= {  0xc0,  0xc0,  0xc0,  0xc0,  0xc0,  0xc0 },
			.h_scaler4 		= {  0xc1,  0xc1,  0xc1,  0xc1,  0xc1,  0xc1 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler9 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05,  0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72,  0x72 },
			.mem_path 		= {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc,  0xdc },
			.format_set1 	= {  0x07,  0x07,  0x07,  0x07,  0x07,  0x07 },
			.format_set2 	= {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.vblk_end 		= {  0x21,  0x21,  0x21,  0x21,  0x21,  0x21 },
		},
	},

	[ CVI_HD_30P_SINGLE_ENDED ] =
	{
		.name         = "CVI_HD_30P_SINGLE_ENDED",
		.video_fmt    = CVI_HD_30P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass = {  0x22,  0x22,  0x22,  0x22,  0x22,  0x22 },
			.eq_band_sel = {  0x77,  0x67,  0x57,  0x57,  0x57,  0x47 },
			.eq_gain_sel = {  0x78,  0x78,  0x78,  0x7f,  0x7f,  0x7f },
			.deq_a_on = {  0x00,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.deq_a_sel = {  0x00,  0x91,  0x92,  0x93,  0x93,  0x93 },
			.deq_b_sel = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC,  0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78,  0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17,  0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1,  0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3,  0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A,  0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2,  0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x88,  0x8c,  0x8a,  0x87,  0x85,  0x84 },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.c_filter		= {  0x82,  0x92,  0x92,  0x92,  0xa2,  0xa2 },
			.hue 			= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.u_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.v_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.u_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.black_level 	= {  0x84,  0x86,  0x84,  0x84,  0x86,  0x88 },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57,  0x57 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80,  0x80 },
			.sub_saturation = {  0xa8,  0xaa,  0xaa,  0xac,  0xa8,  0xa6 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a,  0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.burst_dec_c 	= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.c_option 		= {  0x80,  0x80,  0x80,  0x80,  0xa0,  0xa0 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e,  0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x60,  0x60,  0x5e,  0x5b,  0x59,  0x59 },
			.h_delay_b = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_delay_c = {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.y_delay   = {  0x05,  0x05,  0x05,  0x05,  0x05,  0x05 },
		},
		/* clock */
		{
			.clk_adc = {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.clk_dec = {  0x40,  0x40,  0x40,  0x40,  0x40,  0x40 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x01,  0x01,  0x01,  0x01,  0x01,  0x01 },
			.h_scaler2 		= {  0x29,  0x29,  0x29,  0x29,  0x29,  0x29 },
			.h_scaler3 		= {  0xc0,  0xc0,  0xc0,  0xc0,  0xc0,  0xc0 },
			.h_scaler4 		= {  0xc1,  0xc1,  0xc1,  0xc1,  0xc1,  0xc1 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.h_scaler9 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00,  0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05,  0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72,  0x72 },
			.mem_path 		= {  0x10,  0x10,  0x10,  0x10,  0x10,  0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc,  0xdc },
			.format_set1 	= {  0x06,  0x06,  0x06,  0x06,  0x06,  0x06 },
			.format_set2 	= {  0x02,  0x02,  0x02,  0x02,  0x02,  0x02 },
			.vblk_end 		= {  0x21,  0x21,  0x21,  0x21,  0x21,  0x21 },
		},
	},

	[ CVI_HD_25P_EX_SINGLE_ENDED ] =
	{
		.name         = "CVI_HD_25P_EX_SINGLE_ENDED",
		.video_fmt    = CVI_HD_25P_EX,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x22,  0x22,  0x22,  0x22,  0x22, 0x22 },
			.eq_band_sel = {  0x77,  0x67,  0x57,  0x57,  0x57, 0x47 },
			.eq_gain_sel = {  0x78,  0x78,  0x78,  0x7f,  0x7f, 0x7f },
			.deq_a_on    = {  0x00,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.deq_a_sel   = {  0x00,  0x91,  0x92,  0x93,  0x93, 0x93 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC, 0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78, 0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17, 0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1, 0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3, 0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A, 0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2, 0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x88,  0x8c,  0x8a,  0x87,  0x85, 0x84 },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_filter 		= {  0x82,  0x92,  0x92,  0x92,  0xa2, 0xa2 },
			.hue 			= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.v_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.black_level 	= {  0x84,  0x86,  0x84,  0x84,  0x86, 0x88 },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57, 0x57 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.sub_saturation = {  0xa8,  0xaa,  0xaa,  0xac,  0xa8, 0xa6 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a, 0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.burst_dec_c 	= {  0x30,  0x30,  0x30,  0x30,  0x30, 0x30 },
			.c_option 		= {  0x80,  0x80,  0x80,  0x80,  0xa0, 0xa0 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x7b,  0x7b,  0x7a,  0x79,  0x79, 0x7a },
			.h_delay_b = {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.h_delay_c = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.y_delay   = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
		},
		/* clock */
		{
			.clk_adc = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.clk_dec = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
		},
		/* timing_b */
		{
			.h_scaler1		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler2		= {  0x29,  0x29,  0x29,  0x29,  0x29, 0x29 },
			.h_scaler3 		= {  0xc0,  0xc0,  0xc0,  0xc0,  0xc0, 0xc0 },
			.h_scaler4 		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler7		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler9 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72, 0x72 },
			.mem_path 		= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc, 0xdc },
			.format_set1 	= {  0x0b,  0x0b,  0x0b,  0x0b,  0x0b, 0x0b },
			.format_set2 	= {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.vblk_end 		= {  0x21,  0x21,  0x21,  0x21,  0x21, 0x21 },
		},
	},

	[ CVI_HD_30P_EX_SINGLE_ENDED ] =
	{
		.name         = "CVI_HD_30P_EX_SINGLE_ENDED",
		.video_fmt    = CVI_HD_30P_EX,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x22,  0x22,  0x22,  0x22,  0x22, 0x22 },
			.eq_band_sel = {  0x77,  0x67,  0x57,  0x57,  0x57, 0x47 },
			.eq_gain_sel = {  0x78,  0x78,  0x78,  0x7f,  0x7f, 0x7f },
			.deq_a_on    = {  0x00,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.deq_a_sel   = {  0x00,  0x91,  0x92,  0x93,  0x93, 0x93 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC, 0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78, 0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17, 0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1, 0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3, 0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A, 0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2, 0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x88,  0x8c,  0x8a,  0x87,  0x85, 0x84 },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_filter 		= {  0x82,  0x92,  0x92,  0x92,  0xa2, 0xa2 },
			.hue 			= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.v_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.black_level 	= {  0x84,  0x86,  0x84,  0x84,  0x86, 0x88 },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57, 0x57 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.sub_saturation = {  0xa8,  0xaa,  0xaa,  0xac,  0xa8, 0xa6 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a, 0x2a },
			.burst_dec_b	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.burst_dec_c 	= {  0x30,  0x30,  0x30,  0x30,  0x30, 0x30 },
			.c_option 		= {  0x80,  0x80,  0x80,  0x80,  0xa0, 0xa0 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x7b,  0x7b,  0x7a,  0x79,  0x79, 0x7a },
			.h_delay_b = {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.h_delay_c = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.y_delay   = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
		},
		/* clock */
		{
			.clk_adc = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.clk_dec = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler2		= {  0x19,  0x19,  0x19,  0x19,  0x19, 0x19 },
			.h_scaler3		= {  0x20,  0x20,  0x20,  0x20,  0x20, 0x20 },
			.h_scaler4		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler9 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72, 0x72 },
			.mem_path 		= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc, 0xdc },
			.format_set1 	= {  0x0a,  0x0a,  0x0a,  0x0a,  0x0a, 0x0a },
			.format_set2 	= {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.vblk_end 		= {  0x20,  0x20,  0x20,  0x20,  0x20, 0x20 },
		},
	},

	[ CVI_HD_50P_SINGLE_ENDED ] =
	{
		.name         = "CVI_HD_50P_SINGLE_ENDED",
		.video_fmt    = CVI_HD_50P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x62,  0x22,  0x22,  0x22,  0x22, 0x22 },
			.eq_band_sel = {  0x07,  0x77,  0x77,  0x77,  0x67, 0x47 },
			.eq_gain_sel = {  0x78,  0x7f,  0x6f,  0x7f,  0x7f, 0x7f },
			.deq_a_on    = {  0x00,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.deq_a_sel   = {  0x00,  0x92,  0x93,  0x94,  0x95, 0x93 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC, 0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78, 0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17, 0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1, 0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3, 0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A, 0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2, 0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x98,  0x98,  0x98,  0x98,  0x98, 0x98 },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_filter 		= {  0x92,  0x92,  0x92,  0x92,  0xb2, 0xb2 },
			.hue 			= {  0x03,  0x03,  0x04,  0x04,  0x04, 0x04 },
			.u_gain 		= {  0x0c,  0x0c,  0x0c,  0x0c,  0x0c, 0x0c },
			.v_gain 		= {  0x1a,  0x1a,  0x1a,  0x1a,  0x1a, 0x1a },
			.u_offset 		= {  0xfa,  0xfa,  0xfa,  0xfa,  0xfa, 0xfa },
			.v_offset 		= {  0xfa,  0xfa,  0xfa,  0xfa,  0xfa, 0xfa },
			.black_level 	= {  0x86,  0x7a,  0x88,  0x84,  0x84, 0x84 },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x47, 0x37 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.sub_saturation = {  0xa8,  0xa0,  0xa0,  0x90,  0x90, 0x90 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a, 0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.burst_dec_c 	= {  0x30,  0x30,  0x30,  0x30,  0x30, 0x30 },
			.c_option 		= {  0xc0,  0xc0,  0xc0,  0xc0,  0xc0, 0xc0 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.h_delay_b = {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.h_delay_c = {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.y_delay   = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
		},
		/* clock */
		{
			.clk_adc = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.clk_dec = {  0x44,  0x44,  0x44,  0x44,  0x44, 0x44 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler2 		= {  0x29,  0x29,  0x29,  0x29,  0x29, 0x29 },
			.h_scaler3		= {  0xc0,  0xc0,  0xc0,  0xc0,  0xc0, 0xc0 },
			.h_scaler4 		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler5		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler6		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler9 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72, 0x72 },
			.mem_path 		= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc, 0xdc },
			.format_set1 	= {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.format_set2 	= {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.vblk_end 		= {  0x21,  0x21,  0x21,  0x21,  0x21, 0x21 },
		},
	},

	[ CVI_HD_60P_SINGLE_ENDED ] =
	{
		.name         = "CVI_HD_60P_SINGLE_ENDED",
		.video_fmt    = CVI_HD_60P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x62,  0x22,  0x22,  0x22,  0x22, 0x22 },
			.eq_band_sel = {  0x07,  0x77,  0x77,  0x77,  0x67, 0x47 },
			.eq_gain_sel = {  0x78,  0x7f,  0x6f,  0x7f,  0x7f, 0x7f },
			.deq_a_on 	 = {  0x00,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.deq_a_sel   = {  0x00,  0x92,  0x93,  0x94,  0x95, 0x93 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC, 0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78, 0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17, 0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1, 0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3, 0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A, 0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2, 0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x98,  0x98,  0x98,  0x98,  0x98, 0x98 },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_filter 		= {  0x92,  0x92,  0x92,  0x92,  0xb2, 0xb2 },
			.hue 			= {  0x03,  0x03,  0x04,  0x04,  0x04, 0x04 },
			.u_gain 		= {  0x0c,  0x0c,  0x0c,  0x0c,  0x0c, 0x0c },
			.v_gain 		= {  0x1a,  0x1a,  0x1a,  0x1a,  0x1a, 0x1a },
			.u_offset 		= {  0xfa,  0xfa,  0xfa,  0xfa,  0xfa, 0xfa },
			.v_offset 		= {  0xfa,  0xfa,  0xfa,  0xfa,  0xfa, 0xfa },
			.black_level 	= {  0x86,  0x7a,  0x88,  0x84,  0x84, 0x84 },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x47, 0x37 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.sub_saturation = {  0xa8,  0xa0,  0xa0,  0x90,  0x90, 0x90 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a, 0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.burst_dec_c 	= {  0x30,  0x30,  0x30,  0x30,  0x30, 0x30 },
			.c_option 		= {  0xc0,  0xc0,  0xc0,  0xc0,  0xc0, 0xc0 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.h_delay_b = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_delay_c = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.y_delay   = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
		},
		/* clock */
		{
			.clk_adc = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.clk_dec = {  0x44,  0x44,  0x44,  0x44,  0x44, 0x44 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler2		= {  0x19,  0x19,  0x19,  0x19,  0x19, 0x19 },
			.h_scaler3 		= {  0x19,  0x19,  0x19,  0x19,  0x19, 0x19 },
			.h_scaler4 		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler9 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72, 0x72 },
			.mem_path 		= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc, 0xdc },
			.format_set1 	= {  0x04,  0x04,  0x04,  0x04,  0x04, 0x04 },
			.format_set2 	= {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.vblk_end 		= {  0x21,  0x21,  0x21,  0x21,  0x21, 0x21 },
		},
	},

	[ TVI_HD_25P_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_25P_SINGLE_ENDED",
		.video_fmt    = TVI_HD_25P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x22,  0x22,  0x22,  0x22,  0x22, 0x22 },
			.eq_band_sel = {  0x77,  0x67,  0x57,  0x57,  0x57, 0x47 },
			.eq_gain_sel = {  0x78,  0x78,  0x78,  0x7f,  0x7f, 0x7f },
			.deq_a_on    = {  0x00,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.deq_a_sel   = {  0x00,  0x91,  0x92,  0x93,  0x93, 0x93 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC, 0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78, 0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17, 0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1, 0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3, 0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A, 0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2, 0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x82,  0x86,  0x84,  0x81,  0x7f, 0x7e },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_filter 		= {  0x82,  0x92,  0x92,  0xa2,  0xa2, 0xa2 },
			.hue 			= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_gain 		= {  0xe0,  0xe0,  0xe0,  0xe0,  0xe0, 0xe0 },
			.v_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_offset 		= {  0xff,  0xff,  0xff,  0xff,  0xff, 0xff },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.black_level 	= {  0x86,  0x88,  0x86,  0x86,  0x88, 0x8a },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57, 0x57 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.sub_saturation = {  0xa8,  0xaa,  0xaa,  0xac,  0xa8, 0xa6 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a, 0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.burst_dec_c 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_option 		= {  0x80,  0x80,  0x80,  0xb0,  0xb0, 0xb0 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x80,  0x7e,  0x7d,  0x7c,  0x5c, 0x7d },
			.h_delay_b = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_delay_c = {  0x20,  0x20,  0x20,  0x20,  0x20, 0x20 },
			.y_delay   = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
		},
		/* clock */
		{
			.clk_adc = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.clk_dec = {  0x04,  0x04,  0x04,  0x04,  0x04, 0x04 },
		},
		/* timing_b */
		{
			.h_scaler1		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler2		= {  0x59,  0x59,  0x59,  0x59,  0x59, 0x59 },
			.h_scaler3		= {  0xc0,  0xc0,  0xc0,  0x00,  0xc0, 0xc0 },
			.h_scaler4		= {  0x01,  0x01,  0x01,  0x00,  0x01, 0x01 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler9 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72, 0x72 },
			.mem_path 		= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc, 0xdc },
			.format_set1 	= {  0x07,  0x07,  0x07,  0x07,  0x07, 0x07 },
			.format_set2 	= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.vblk_end 		= {  0x21,  0x21,  0x21,  0x21,  0x21, 0x21 },
		},
	},

	[ TVI_HD_30P_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_30P_SINGLE_ENDED",
		.video_fmt    = TVI_HD_30P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x22,  0x22,  0x22,  0x22,  0x22, 0x22 },
			.eq_band_sel = {  0x77,  0x67,  0x57,  0x57,  0x57, 0x47 },
			.eq_gain_sel = {  0x78,  0x78,  0x78,  0x7f,  0x7f, 0x7f },
			.deq_a_on    = {  0x00,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.deq_a_sel   = {  0x00,  0x91,  0x92,  0x93,  0x93, 0x93 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC, 0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78, 0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17, 0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1, 0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3, 0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A, 0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2, 0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x82,  0x86,  0x84,  0x81,  0x7f, 0x7e },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_filter 		= {  0x82,  0x92,  0x92,  0xa2,  0xa2, 0xa2 },
			.hue 			= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_gain 		= {  0xe0,  0xe0,  0xe0,  0xe0,  0xe0, 0xe0 },
			.v_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_offset 		= {  0xff,  0xff,  0xff,  0xff,  0xff, 0xff },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.black_level 	= {  0x86,  0x88,  0x86,  0x86,  0x88, 0x8a },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57, 0x57 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.sub_saturation = {  0xa8,  0xaa,  0xaa,  0xac,  0xa8, 0xa6 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a, 0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.burst_dec_c 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_option 		= {  0x80,  0x80,  0x80,  0xb0,  0xb0, 0xb0 },
			.y_filter_b		= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x20,  0x1e,  0x1d,  0x1c,  0x1c, 0x1d },
			.h_delay_b = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_delay_c = {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.y_delay   = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
		},
		/* clock */
		{
			.clk_adc = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.clk_dec = {  0x44,  0x44,  0x44,  0x44,  0x44, 0x44 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler2 		= {  0x59,  0x59,  0x59,  0x59,  0x59, 0x59 },
			.h_scaler3 		= {  0xff,  0x30,  0x30,  0x30,  0x30, 0x30 },
			.h_scaler4 		= {  0x01,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler9 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72, 0x72 },
			.mem_path 		= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc, 0xdc },
			.format_set1 	= {  0x06,  0x06,  0x06,  0x06,  0x06, 0x06 },
			.format_set2 	= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.vblk_end 		= {  0x20,  0x20,  0x20,  0x20,  0x20, 0x20 },
		},
	},

	[ TVI_HD_B_25P_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_B_25P_SINGLE_ENDED",
		.video_fmt    = TVI_HD_B_25P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x22,  0x22,  0x22,  0x22,  0x22, 0x22 },
			.eq_band_sel = {  0x77,  0x67,  0x57,  0x57,  0x57, 0x47 },
			.eq_gain_sel = {  0x78,  0x78,  0x78,  0x7f,  0x7f, 0x7f },
			.deq_a_on    = {  0x00,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.deq_a_sel   = {  0x00,  0x91,  0x92,  0x93,  0x93, 0x93 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC, 0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78, 0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17, 0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1, 0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3, 0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A, 0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2, 0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x82,  0x86,  0x84,  0x81,  0x7f, 0x7e },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_filter 		= {  0x82,  0x92,  0x92,  0xa2,  0xa2, 0xa2 },
			.hue 			= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_gain 		= {  0xe0,  0xe0,  0xe0,  0xe0,  0xe0, 0xe0 },
			.v_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_offset 		= {  0xff,  0xff,  0xff,  0xff,  0xff, 0xff },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.black_level 	= {  0x86,  0x88,  0x86,  0x86,  0x88, 0x8a },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57, 0x57 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.sub_saturation = {  0xa8,  0xaa,  0xaa,  0xac,  0xa8, 0xa6 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a, 0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.burst_dec_c 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_option 		= {  0x80,  0x80,  0x80,  0xb0,  0xb0, 0xb0 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x80,  0x7e,  0x7d,  0x7c,  0x7c, 0x7d },
			.h_delay_b = {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.h_delay_c = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.y_delay   = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
		},
		/* clock */
		{
			.clk_adc = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.clk_dec = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler2 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler3 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler4 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler9 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72, 0x72 },
			.mem_path 		= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc, 0xdc },
			.format_set1 	= {  0x06,  0x06,  0x06,  0x06,  0x06, 0x06 },
			.format_set2 	= {  0x03,  0x03,  0x03,  0x03,  0x03, 0x03 },
			.vblk_end 		= {  0x20,  0x20,  0x20,  0x20,  0x20, 0x20 },
		},
	},

	[ TVI_HD_B_30P_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_B_30P_SINGLE_ENDED",
		.video_fmt    = TVI_HD_B_30P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x22,  0x22,  0x22,  0x22,  0x22, 0x22 },
			.eq_band_sel = {  0x77,  0x67,  0x57,  0x57,  0x57, 0x47 },
			.eq_gain_sel = {  0x78,  0x78,  0x78,  0x7f,  0x7f, 0x7f },
			.deq_a_on    = {  0x00,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.deq_a_sel   = {  0x00,  0x91,  0x92,  0x93,  0x93, 0x93 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC, 0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78, 0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17, 0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1, 0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3, 0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A, 0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2, 0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x82,  0x86,  0x84,  0x81,  0x7f, 0x7e },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_filter 		= {  0x82,  0x92,  0x92,  0xa2,  0xa2, 0xa2 },
			.hue 			= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_gain 		= {  0xe0,  0xe0,  0xe0,  0xe0,  0xe0, 0xe0 },
			.v_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_offset 		= {  0xff,  0xff,  0xff,  0xff,  0xff, 0xff },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.black_level 	= {  0x86,  0x88,  0x86,  0x86,  0x88, 0x8a },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57, 0x57 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.sub_saturation = {  0xa8,  0xaa,  0xaa,  0xac,  0xa8, 0xa6 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a, 0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.burst_dec_c 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_option 		= {  0x80,  0x80,  0x80,  0xb0,  0xb0, 0xb0 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x80,  0x7e,  0x7d,  0x7c,  0x7c, 0x7d },
			.h_delay_b = {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.h_delay_c = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.y_delay   = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
		},
		/* clock */
		{
			.clk_adc = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.clk_dec = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler2 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler3 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler4 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler9 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72, 0x72 },
			.mem_path 		= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc, 0xdc },
			.format_set1 	= {  0x06,  0x06,  0x06,  0x06,  0x06, 0x06 },
			.format_set2 	= {  0x03,  0x03,  0x03,  0x03,  0x03, 0x03 },
			.vblk_end 		= {  0x20,  0x20,  0x20,  0x20,  0x20, 0x20 },
		},
	},

	[ TVI_HD_25P_EX_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_25P_EX_SINGLE_ENDED",
		.video_fmt    = TVI_HD_25P_EX,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x22,  0x22,  0x22,  0x22,  0x22, 0x22 },
			.eq_band_sel = {  0x77,  0x67,  0x57,  0x57,  0x57, 0x47 },
			.eq_gain_sel = {  0x78,  0x78,  0x78,  0x7f,  0x7f, 0x7f },
			.deq_a_on 	 = {  0x00,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.deq_a_sel   = {  0x00,  0x91,  0x92,  0x93,  0x93, 0x93 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC, 0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78, 0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17, 0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1, 0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3, 0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A, 0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2, 0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x82,  0x86,  0x84,  0x81,  0x7f, 0x7e },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_filter 		= {  0x82,  0x92,  0x92,  0xa2,  0xa2, 0xa2 },
			.hue 			= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_gain 		= {  0xe0,  0xe0,  0xe0,  0xe0,  0xe0, 0xe0 },
			.v_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_offset 		= {  0xff,  0xff,  0xff,  0xff,  0xff, 0xff },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.black_level 	= {  0x86,  0x88,  0x86,  0x86,  0x88, 0x8a },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57, 0x57 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.sub_saturation = {  0xa8,  0xaa,  0xaa,  0xac,  0xa8, 0xa6 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a, 0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.burst_dec_c 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_option 		= {  0x80,  0x80,  0x80,  0xb0,  0xb0, 0xb0 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x60,  0x5e,  0x5d,  0x5c,  0x5c, 0x5d },
			.h_delay_b = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_delay_c = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.y_delay   = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
		},
		/* clock */
		{
			.clk_adc = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.clk_dec = {  0x44,  0x44,  0x44,  0x44,  0x44, 0x44 },
		},
		/* timing_b */
		{
			.h_scaler1		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler2		= {  0x59,  0x59,  0x29,  0x59,  0x59, 0x59 },
			.h_scaler3 		= {  0x00,  0x00,  0xc0,  0x00,  0x00, 0x00 },
			.h_scaler4 		= {  0x00,  0x00,  0xc1,  0x00,  0x00, 0x00 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler9 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72, 0x72 },
			.mem_path 		= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc, 0xdc },
			.format_set1 	= {  0x0b,  0x0b,  0x0b,  0x0b,  0x0b, 0x0b },
			.format_set2 	= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.vblk_end 		= {  0x20,  0x20,  0x20,  0x20,  0x20, 0x20 },
		},
	},

	[ TVI_HD_30P_EX_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_30P_EX_SINGLE_ENDED",
		.video_fmt    = TVI_HD_30P_EX,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x22,  0x22,  0x22,  0x22,  0x22, 0x22 },
			.eq_band_sel = {  0x77,  0x67,  0x57,  0x57,  0x57, 0x47 },
			.eq_gain_sel = {  0x78,  0x78,  0x78,  0x7f,  0x7f, 0x7f },
			.deq_a_on    = {  0x00,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.deq_a_sel   = {  0x00,  0x91,  0x92,  0x93,  0x93, 0x93 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC, 0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78, 0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17, 0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1, 0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3, 0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A, 0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2, 0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x82,  0x86,  0x84,  0x81,  0x7f, 0x7e },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_filter 		= {  0x82,  0x92,  0x92,  0xa2,  0xa2, 0xa2 },
			.hue 			= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_gain 		= {  0xe0,  0xe0,  0xe0,  0xe0,  0xe0, 0xe0 },
			.v_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_offset 		= {  0xff,  0xff,  0xff,  0xff,  0xff, 0xff },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.black_level 	= {  0x86,  0x88,  0x86,  0x86,  0x88, 0x8a },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57, 0x57 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.sub_saturation = {  0xa8,  0xaa,  0xaa,  0xac,  0xa8, 0xa6 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a, 0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.burst_dec_c 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_option 		= {  0x80,  0x80,  0x80,  0xb0,  0xb0, 0xb0 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x80,  0x7e,  0x7d,  0x7c,  0x7c, 0x7d },
			.h_delay_b = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_delay_c = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.y_delay   = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
		},
		/* clock */
		{
			.clk_adc = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.clk_dec = {  0x44,  0x44,  0x44,  0x44,  0x44, 0x44 },
		},
		/* timing_b */
		{
			.h_scaler1		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler2		= {  0x59,  0x59,  0x59,  0x59,  0x59, 0x59 },
			.h_scaler3 		= {  0x30,  0x30,  0x30,  0x30,  0x30, 0x30 },
			.h_scaler4 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler9 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72, 0x72 },
			.mem_path 		= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc, 0xdc },
			.format_set1    = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A, 0x0A },
			.format_set2 	= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.vblk_end 		= {  0x20,  0x20,  0x20,  0x20,  0x20, 0x20 },
		},
	},

	[ TVI_HD_B_25P_EX_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_B_25P_EX_SINGLE_ENDED",
		.video_fmt    = TVI_HD_B_25P_EX,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x22,  0x22,  0x22,  0x22,  0x22, 0x22 },
			.eq_band_sel = {  0x77,  0x67,  0x57,  0x57,  0x57, 0x47 },
			.eq_gain_sel = {  0x78,  0x78,  0x78,  0x7f,  0x7f, 0x7f },
			.deq_a_on    = {  0x00,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.deq_a_sel   = {  0x00,  0x91,  0x92,  0x93,  0x93, 0x93 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC, 0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78, 0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17, 0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1, 0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3, 0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A, 0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2, 0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x82,  0x86,  0x84,  0x81,  0x7f, 0x7e },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_filter 		= {  0x82,  0x92,  0x92,  0xa2,  0xa2, 0xa2 },
			.hue 			= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_gain 		= {  0xe0,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.v_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_offset 		= {  0xff,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.black_level 	= {  0x86,  0x88,  0x86,  0x86,  0x88, 0x8a },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57, 0x57 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.sub_saturation = {  0xa8,  0xaa,  0xaa,  0xac,  0xa8, 0xa6 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a, 0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.burst_dec_c 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_option 		= {  0x80,  0x80,  0x80,  0xb0,  0xb0, 0xb0 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x82,  0x80,  0x7f,  0x7e,  0x7e, 0x7f },
			.h_delay_b = {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.h_delay_c = {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.y_delay   = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
		},
		/* clock */
		{
			.clk_adc = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.clk_dec = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler2 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler3 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler4 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler9 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72, 0x72 },
			.mem_path 		= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc, 0xdc },
			.format_set1 	= {  0x0b,  0x0b,  0x0b,  0x0b,  0x0b, 0x0b },
			.format_set2 	= {  0x03,  0x03,  0x03,  0x03,  0x03, 0x03 },
			.vblk_end 		= {  0x20,  0x20,  0x20,  0x20,  0x20, 0x20 },
		},
	},

	[ TVI_HD_B_30P_EX_SINGLE_ENDED ] =
	{
		.name         = "TVI_HD_B_30P_EX_SINGLE_ENDED",
		.video_fmt    = TVI_HD_B_30P_EX,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x22,  0x22,  0x22,  0x22,  0x22, 0x22 },
			.eq_band_sel = {  0x77,  0x67,  0x57,  0x57,  0x57, 0x47 },
			.eq_gain_sel = {  0x78,  0x78,  0x78,  0x7f,  0x7f, 0x7f },
			.deq_a_on    = {  0x00,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.deq_a_sel   = {  0x00,  0x91,  0x92,  0x93,  0x93, 0x93 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC, 0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78, 0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17, 0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1, 0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3, 0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A, 0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2, 0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x82,  0x86,  0x84,  0x81,  0x7f, 0x7e },
			.h_peaking 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_filter 		= {  0x82,  0x92,  0x92,  0xa2,  0xa2, 0xa2 },
			.hue 			= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_gain 		= {  0xe0,  0xe0,  0xe0,  0xe0,  0xe0, 0xe0 },
			.v_gain 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.u_offset 		= {  0xff,  0xff,  0xff,  0xff,  0xff, 0xff },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.black_level 	= {  0x86,  0x88,  0x86,  0x86,  0x88, 0x8a },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57, 0x57 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.sub_saturation = {  0xa8,  0xaa,  0xaa,  0xac,  0xa8, 0xa6 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a, 0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.burst_dec_c 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.c_option 		= {  0x80,  0x80,  0x80,  0xb0,  0xb0, 0xb0 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x80,  0x7e,  0x7d,  0x7c,  0x7c, 0x7d },
			.h_delay_b = {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.h_delay_c = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.y_delay   = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
		},
		/* clock */
		{
			.clk_adc = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.clk_dec = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler2 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler3 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler4 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler9 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72, 0x72 },
			.mem_path 		= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc, 0xdc },
			.format_set1 	= {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A, 0x0A },
			.format_set2 	= {  0x03,  0x03,  0x03,  0x03,  0x03, 0x03 },
			.vblk_end 		= {  0x20,  0x20,  0x20,  0x20,  0x20, 0x20 },
		},
	},

	[ TVI_FHD_25P_SINGLE_ENDED ] =
	{
		.name         = "TVI_FHD_25P_SINGLE_ENDED",
		.video_fmt    = TVI_FHD_25P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x22,  0x22,  0x22,  0x22,  0x22, 0x22 },
			.eq_band_sel = {  0x77,  0x77,  0x77,  0x67,  0x57, 0x37 },
			.eq_gain_sel = {  0x78,  0x78,  0x6f,  0x7f,  0x7f, 0x7f },
			.deq_a_on    = {  0x00,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.deq_a_sel   = {  0x00,  0x91,  0x93,  0x94,  0x95, 0x93 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC, 0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78, 0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17, 0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1, 0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3, 0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A, 0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2, 0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x82,  0x7c,  0x78,  0x6c,  0x70, 0x68 },
			.h_peaking 		= {  0x3f,  0x3f,  0x3f,  0x3f,  0x3f, 0x3f },
			.c_filter 		= {  0x82,  0x82,  0x92,  0xb2,  0xb2, 0xb2 },
			.hue 			= {  0x00,  0xfe,  0xfe,  0xfe,  0xfe, 0xfe },
			.u_gain 		= {  0xe0,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.v_gain 		= {  0x00,  0xf8,  0xf8,  0xf8,  0xf8, 0xf8 },
			.u_offset 		= {  0xff,  0xff,  0xff,  0xff,  0xff, 0xff },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.black_level 	= {  0x86,  0x88,  0x88,  0x8c,  0x8f, 0x8f },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57, 0x27 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.sub_saturation = {  0xdf,  0xe0,  0xe0,  0xe0,  0xa0, 0x80 },
			.burst_dec_a    = {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a, 0x2a },
			.burst_dec_b    = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.burst_dec_c    = {  0x30,  0x30,  0x30,  0x30,  0x30, 0x30 },
			.c_option 		= {  0x80,  0x80,  0x80,  0xa0,  0xb0, 0xb0 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x82,  0x82,  0x82,  0x82,  0x82, 0x82 },
			.h_delay_b = {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.h_delay_c = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.y_delay   = {  0x05,  0x05,  0x05,  0x05,  0x20, 0x20 },
		},
		/* clock */
		{
			.clk_adc = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.clk_dec = {  0x44,  0x44,  0x44,  0x44,  0x44, 0x44 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler2 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler3		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler4		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler8		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler9 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72, 0x72 },
			.mem_path 		= {  0x00,  0x00,  0x00,  0x10,  0x10, 0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc, 0xdc },
			.format_set1 	= {  0x03,  0x03,  0x03,  0x03,  0x03, 0x03 },
			.format_set2 	= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.vblk_end 		= {  0x20,  0x20,  0x20,  0x20,  0x20, 0x20 },
		},
	},

	[ TVI_FHD_30P_SINGLE_ENDED ] =
	{
		.name         = "TVI_FHD_30P_SINGLE_ENDED",
		.video_fmt    = TVI_FHD_30P,
		.analog_input = SINGLE_ENDED,

		/* base */
		{
			.eq_bypass   = {  0x22,  0x22,  0x22,  0x22,  0x22, 0x22 },
			.eq_band_sel = {  0x77,  0x77,  0x77,  0x67,  0x57, 0x37 },
			.eq_gain_sel = {  0x78,  0x78,  0x6f,  0x7f,  0x7f, 0x7f },
			.deq_a_on    = {  0x00,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.deq_a_sel   = {  0x00,  0x91,  0x93,  0x94,  0x95, 0x93 },
			.deq_b_sel   = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
		},
		/* coeff_ */
		{
			.deqA_01 = {  0xAC,  0xAC,  0xAC,  0xAC,  0xAC, 0xAC },
			.deqA_02 = {  0x78,  0x78,  0x78,  0x78,  0x78, 0x78 },
			.deqA_03 = {  0x17,  0x17,  0x17,  0x17,  0x17, 0x17 },
			.deqA_04 = {  0xC1,  0xC1,  0xC1,  0xC1,  0xC1, 0xC1 },
			.deqA_05 = {  0x40,  0x40,  0x40,  0x40,  0x40, 0x40 },
			.deqA_06 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_07 = {  0xC3,  0xC3,  0xC3,  0xC3,  0xC3, 0xC3 },
			.deqA_08 = {  0x0A,  0x0A,  0x0A,  0x0A,  0x0A, 0x0A },
			.deqA_09 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_10 = {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.deqA_11 = {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.deqA_12 = {  0xB2,  0xB2,  0xB2,  0xB2,  0xB2, 0xB2 },
		},
		/* color */
		{
			.contrast 		= {  0x82,  0x7c,  0x78,  0x6c,  0x70, 0x68 },
			.h_peaking 		= {  0x3f,  0x3f,  0x3f,  0x3f,  0x3f, 0x3f },
			.c_filter 		= {  0x82,  0x82,  0x92,  0xb2,  0xb2, 0xb2 },
			.hue 			= {  0x00,  0xfe,  0xfe,  0xfe,  0xfe, 0xfe },
			.u_gain 		= {  0xe0,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.v_gain 		= {  0x00,  0xf8,  0xf8,  0xf8,  0xf8, 0xf8 },
			.u_offset 		= {  0xff,  0xff,  0xff,  0xff,  0xff, 0xff },
			.v_offset 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.black_level 	= {  0x86,  0x88,  0x88,  0x8c,  0x8f, 0x8f },
			.acc_ref 		= {  0x57,  0x57,  0x57,  0x57,  0x57, 0x27 },
			.cti_delay 		= {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.sub_saturation = {  0xdf,  0xe0,  0xe0,  0xe0,  0xa0, 0x80 },
			.burst_dec_a 	= {  0x2a,  0x2a,  0x2a,  0x2a,  0x2a, 0x2a },
			.burst_dec_b 	= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.burst_dec_c 	= {  0x30,  0x30,  0x30,  0x30,  0x30, 0x30 },
			.c_option 		= {  0x80,  0x80,  0x80,  0xa0,  0xb0, 0xb0 },
			.y_filter_b 	= {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.y_filter_b_sel = {  0x1e,  0x1e,  0x1e,  0x1e,  0x1e, 0x1e },
		},
		/* timing_a */
		{
			.h_delay_a = {  0x80,  0x80,  0x80,  0x80,  0x80, 0x80 },
			.h_delay_b = {  0x10,  0x10,  0x10,  0x10,  0x10, 0x10 },
			.h_delay_c = {  0x03,  0x03,  0x03,  0x02,  0x03, 0x03 },
			.y_delay 	= {  0x07,  0x07,  0x07,  0x05,  0x20, 0x20 },
		},
		/* clock */
		{
			.clk_adc = {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.clk_dec = {  0x44,  0x44,  0x44,  0x44,  0x44, 0x44 },
		},
		/* timing_b */
		{
			.h_scaler1 		= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.h_scaler2 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler3 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler4 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler5 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler6 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler7 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler8 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.h_scaler9 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.pn_auto 		= {  0x00,  0x00,  0x00,  0x00,  0x00, 0x00 },
			.comb_mode 		= {  0x05,  0x05,  0x05,  0x05,  0x05, 0x05 },
			.h_pll_op_a 	= {  0x72,  0x72,  0x72,  0x72,  0x72, 0x72 },
			.mem_path 		= {  0x00,  0x00,  0x00,  0x10,  0x10, 0x10 },
			.fsc_lock_speed = {  0xdc,  0xdc,  0xdc,  0xdc,  0xdc, 0xdc },
			.format_set1 	= {  0x02,  0x02,  0x02,  0x02,  0x02, 0x02 },
			.format_set2 	= {  0x01,  0x01,  0x01,  0x01,  0x01, 0x01 },
			.vblk_end 		= {  0x20,  0x20,  0x20,  0x20,  0x20, 0x20 },
		},
	},





	[ AHD20_1080P_30P_DIFFERENTIAL ] = /* o */
	{
		.name         = "AHD20_1080P_30P_DIFFERENTIAL",
		.video_fmt    = AHD20_1080P_30P,
		.analog_input = DIFFERENTIAL,

	},
};




#endif /* EXTDRV_JAGUAR1_VIDEO_INPUT_TABLE_H_ */
