/* SPDX-License-Identifier: (GPL-2.0+ OR MIT)
 *
 * Copyright (C) 2019 Rockchip Electronics Co., Ltd.
 */

#ifndef _RKISP_REGS_V2X_H
#define _RKISP_REGS_V2X_H

#define CTRL_BASE					0x00000000
#define CTRL_VI_ISP_EN					(CTRL_BASE + 0x00000)
#define CTRL_VI_ISP_PATH				(CTRL_BASE + 0x00004)
#define CTRL_VI_ID					(CTRL_BASE + 0x00008)
#define CTRL_VI_ISP_CLK_CTRL				(CTRL_BASE + 0x0000c)
#define CTRL_VI_ICCL					(CTRL_BASE + 0x00010)
#define CTRL_VI_IRCL					(CTRL_BASE + 0x00014)
#define CTRL_VI_DPCL					(CTRL_BASE + 0x00018)
#define CTRL_SWS_CFG					(CTRL_BASE + 0x0001c)
#define LVDS_CTRL					(CTRL_BASE + 0x00020)
#define LVDS_SAV_EAV_ACT				(CTRL_BASE + 0x00024)
#define LVDS_SAV_EAV_BLK				(CTRL_BASE + 0x00028)

#define IMG_EFF_BASE					0x00000200
#define IMG_EFF_CTRL					(IMG_EFF_BASE + 0x00000)
#define IMG_EFF_COLOR_SEL				(IMG_EFF_BASE + 0x00004)
#define IMG_EFF_MAT_1					(IMG_EFF_BASE + 0x00008)
#define IMG_EFF_MAT_2					(IMG_EFF_BASE + 0x0000c)
#define IMG_EFF_MAT_3					(IMG_EFF_BASE + 0x00010)
#define IMG_EFF_MAT_4					(IMG_EFF_BASE + 0x00014)
#define IMG_EFF_MAT_5					(IMG_EFF_BASE + 0x00018)
#define IMG_EFF_TINT					(IMG_EFF_BASE + 0x0001c)
#define IMG_EFF_CTRL_SHD				(IMG_EFF_BASE + 0x00020)
#define IMG_EFF_SHARPEN					(IMG_EFF_BASE + 0x00024)
#define IMG_EFF_RKSHARP_CTRL				(IMG_EFF_BASE + 0x00030)
#define IMG_EFF_RKSHARP_YAVG_THR			(IMG_EFF_BASE + 0x00034)
#define IMG_EFF_RKSHARP_DELTA_P0_P1			(IMG_EFF_BASE + 0x00038)
#define IMG_EFF_RKSHARP_DELTA_P2_P3			(IMG_EFF_BASE + 0x0003c)
#define IMG_EFF_RKSHARP_DELTA_P4			(IMG_EFF_BASE + 0x00040)
#define IMG_EFF_RKSHARP_NPIXEL_P0_P1_P2_P3		(IMG_EFF_BASE + 0x00044)
#define IMG_EFF_RKSHARP_NPIXEL_P4			(IMG_EFF_BASE + 0x00048)
#define IMG_EFF_RKSHARP_GAUSS_FLAT_COE1			(IMG_EFF_BASE + 0x0004c)
#define IMG_EFF_RKSHARP_GAUSS_FLAT_COE2			(IMG_EFF_BASE + 0x00050)
#define IMG_EFF_RKSHARP_GAUSS_FLAT_COE3			(IMG_EFF_BASE + 0x00054)
#define IMG_EFF_RKSHARP_GAUSS_NOISE_COE1		(IMG_EFF_BASE + 0x00058)
#define IMG_EFF_RKSHARP_GAUSS_NOISE_COE2		(IMG_EFF_BASE + 0x0005c)
#define IMG_EFF_RKSHARP_GAUSS_NOISE_COE3		(IMG_EFF_BASE + 0x00060)
#define IMG_EFF_RKSHARP_GAUSS_OTHER_COE1		(IMG_EFF_BASE + 0x00064)
#define IMG_EFF_RKSHARP_GAUSS_OTHER_COE2		(IMG_EFF_BASE + 0x00068)
#define IMG_EFF_RKSHARP_GAUSS_OTHER_COE3		(IMG_EFF_BASE + 0x0006c)
#define IMG_EFF_RKSHARP_LINE1_FILTER_COE1		(IMG_EFF_BASE + 0x00070)
#define IMG_EFF_RKSHARP_LINE1_FILTER_COE2		(IMG_EFF_BASE + 0x00074)
#define IMG_EFF_RKSHARP_LINE2_FILTER_COE1		(IMG_EFF_BASE + 0x00078)
#define IMG_EFF_RKSHARP_LINE2_FILTER_COE2		(IMG_EFF_BASE + 0x0007c)
#define IMG_EFF_RKSHARP_LINE2_FILTER_COE3		(IMG_EFF_BASE + 0x00080)
#define IMG_EFF_RKSHARP_LINE3_FILTER_COE1		(IMG_EFF_BASE + 0x00084)
#define IMG_EFF_RKSHARP_LINE3_FILTER_COE2		(IMG_EFF_BASE + 0x00088)
#define IMG_EFF_RKSHARP_GRAD_SEQ_P0_P1			(IMG_EFF_BASE + 0x0008c)
#define IMG_EFF_RKSHARP_GRAD_SEQ_P2_P3			(IMG_EFF_BASE + 0x00090)
#define IMG_EFF_RKSHARP_SHARP_FACTOR_P0_P1_P2		(IMG_EFF_BASE + 0x00094)
#define IMG_EFF_RKSHARP_SHARP_FACTOR_P3_P4		(IMG_EFF_BASE + 0x00098)
#define IMG_EFF_RKSHARP_UV_GAUSS_FLAT_COE11_COE14	(IMG_EFF_BASE + 0x0009c)
#define IMG_EFF_RKSHARP_UV_GAUSS_FLAT_COE15_COE23	(IMG_EFF_BASE + 0x000a0)
#define IMG_EFF_RKSHARP_UV_GAUSS_FLAT_COE24_COE32	(IMG_EFF_BASE + 0x000a4)
#define IMG_EFF_RKSHARP_UV_GAUSS_FLAT_COE33_COE35	(IMG_EFF_BASE + 0x000a8)
#define IMG_EFF_RKSHARP_UV_GAUSS_NOISE_COE11_COE14	(IMG_EFF_BASE + 0x000ac)
#define IMG_EFF_RKSHARP_UV_GAUSS_NOISE_COE15_COE23	(IMG_EFF_BASE + 0x000b0)
#define IMG_EFF_RKSHARP_UV_GAUSS_NOISE_COE24_COE32	(IMG_EFF_BASE + 0x000b4)
#define IMG_EFF_RKSHARP_UV_GAUSS_NOISE_COE33_COE35	(IMG_EFF_BASE + 0x000b8)
#define IMG_EFF_RKSHARP_UV_GAUSS_OTHER_COE11_COE14	(IMG_EFF_BASE + 0x000bc)
#define IMG_EFF_RKSHARP_UV_GAUSS_OTHER_COE15_COE23	(IMG_EFF_BASE + 0x000c0)
#define IMG_EFF_RKSHARP_UV_GAUSS_OTHER_COE24_COE32	(IMG_EFF_BASE + 0x000c4)
#define IMG_EFF_RKSHARP_UV_GAUSS_OTHER_COE33_COE35	(IMG_EFF_BASE + 0x000c8)

#define SUPER_IMP_BASE				0x00000300
#define SUPER_IMP_CTRL				(SUPER_IMP_BASE + 0x00000)
#define SUPER_IMP_OFFSET_X			(SUPER_IMP_BASE + 0x00004)
#define SUPER_IMP_OFFSET_Y			(SUPER_IMP_BASE + 0x00008)
#define SUPER_IMP_COLOR_Y			(SUPER_IMP_BASE + 0x0000c)
#define SUPER_IMP_COLOR_CB			(SUPER_IMP_BASE + 0x00010)
#define SUPER_IMP_COLOR_CR			(SUPER_IMP_BASE + 0x00014)

#define ISP_BASE				0x00000400
#define ISP_CTRL				(ISP_BASE + 0x00000)
#define ISP_ACQ_PROP				(ISP_BASE + 0x00004)
#define ISP_CTRL1				(ISP_BASE + 0x00004)
#define ISP_ACQ_H_OFFS				(ISP_BASE + 0x00008)
#define ISP_ACQ_V_OFFS				(ISP_BASE + 0x0000c)
#define ISP_ACQ_H_SIZE				(ISP_BASE + 0x00010)
#define ISP_ACQ_V_SIZE				(ISP_BASE + 0x00014)
#define ISP_ACQ_NR_FRAMES			(ISP_BASE + 0x00018)
#define ISP_GAMMA_DX_LO				(ISP_BASE + 0x0001c)
#define ISP_GAMMA_DX_HI				(ISP_BASE + 0x00020)
#define ISP_GAMMA_R_Y_0				(ISP_BASE + 0x00024)
#define ISP_GAMMA_R_Y_1				(ISP_BASE + 0x00028)
#define ISP_GAMMA_R_Y_2				(ISP_BASE + 0x0002c)
#define ISP_GAMMA_R_Y_3				(ISP_BASE + 0x00030)
#define ISP_GAMMA_R_Y_4				(ISP_BASE + 0x00034)
#define ISP_GAMMA_R_Y_5				(ISP_BASE + 0x00038)
#define ISP_GAMMA_R_Y_6				(ISP_BASE + 0x0003c)
#define ISP_GAMMA_R_Y_7				(ISP_BASE + 0x00040)
#define ISP_GAMMA_R_Y_8				(ISP_BASE + 0x00044)
#define ISP_GAMMA_R_Y_9				(ISP_BASE + 0x00048)
#define ISP_GAMMA_R_Y_10			(ISP_BASE + 0x0004c)
#define ISP_GAMMA_R_Y_11			(ISP_BASE + 0x00050)
#define ISP_GAMMA_R_Y_12			(ISP_BASE + 0x00054)
#define ISP_GAMMA_R_Y_13			(ISP_BASE + 0x00058)
#define ISP_GAMMA_R_Y_14			(ISP_BASE + 0x0005c)
#define ISP_GAMMA_R_Y_15			(ISP_BASE + 0x00060)
#define ISP_GAMMA_R_Y_16			(ISP_BASE + 0x00064)
#define ISP_GAMMA_G_Y_0				(ISP_BASE + 0x00068)
#define ISP_GAMMA_G_Y_1				(ISP_BASE + 0x0006c)
#define ISP_GAMMA_G_Y_2				(ISP_BASE + 0x00070)
#define ISP_GAMMA_G_Y_3				(ISP_BASE + 0x00074)
#define ISP_GAMMA_G_Y_4				(ISP_BASE + 0x00078)
#define ISP_GAMMA_G_Y_5				(ISP_BASE + 0x0007c)
#define ISP_GAMMA_G_Y_6				(ISP_BASE + 0x00080)
#define ISP_GAMMA_G_Y_7				(ISP_BASE + 0x00084)
#define ISP_GAMMA_G_Y_8				(ISP_BASE + 0x00088)
#define ISP_GAMMA_G_Y_9				(ISP_BASE + 0x0008c)
#define ISP_GAMMA_G_Y_10			(ISP_BASE + 0x00090)
#define ISP_GAMMA_G_Y_11			(ISP_BASE + 0x00094)
#define ISP_GAMMA_G_Y_12			(ISP_BASE + 0x00098)
#define ISP_GAMMA_G_Y_13			(ISP_BASE + 0x0009c)
#define ISP_GAMMA_G_Y_14			(ISP_BASE + 0x000a0)
#define ISP_GAMMA_G_Y_15			(ISP_BASE + 0x000a4)
#define ISP_GAMMA_G_Y_16			(ISP_BASE + 0x000a8)
#define ISP_GAMMA_B_Y_0				(ISP_BASE + 0x000ac)
#define ISP_GAMMA_B_Y_1				(ISP_BASE + 0x000b0)
#define ISP_GAMMA_B_Y_2				(ISP_BASE + 0x000b4)
#define ISP_GAMMA_B_Y_3				(ISP_BASE + 0x000b8)
#define ISP_GAMMA_B_Y_4				(ISP_BASE + 0x000bc)
#define ISP_GAMMA_B_Y_5				(ISP_BASE + 0x000c0)
#define ISP_GAMMA_B_Y_6				(ISP_BASE + 0x000c4)
#define ISP_GAMMA_B_Y_7				(ISP_BASE + 0x000c8)
#define ISP_GAMMA_B_Y_8				(ISP_BASE + 0x000cc)
#define ISP_GAMMA_B_Y_9				(ISP_BASE + 0x000d0)
#define ISP_GAMMA_B_Y_10			(ISP_BASE + 0x000d4)
#define ISP_GAMMA_B_Y_11			(ISP_BASE + 0x000d8)
#define ISP_GAMMA_B_Y_12			(ISP_BASE + 0x000dc)
#define ISP_GAMMA_B_Y_13			(ISP_BASE + 0x000e0)
#define ISP_GAMMA_B_Y_14			(ISP_BASE + 0x000e4)
#define ISP_GAMMA_B_Y_15			(ISP_BASE + 0x000e8)
#define ISP_GAMMA_B_Y_16			(ISP_BASE + 0x000ec)

#define ISP_AWB_PROP				(ISP_BASE + 0x00110)
#define ISP_AWB_SIZE				(ISP_BASE + 0x00114)
#define ISP_AWB_OFFS				(ISP_BASE + 0x00118)
#define ISP_AWB_REF				(ISP_BASE + 0x0011c)
#define ISP_AWB_THRESH				(ISP_BASE + 0x00120)
#define ISP_X_COOR_12				(ISP_BASE + 0x00124)
#define ISP_X_COOR_34				(ISP_BASE + 0x00128)
#define ISP_AWB_WHITE_CNT			(ISP_BASE + 0x0012c)
#define ISP_AWB_MEAN				(ISP_BASE + 0x00130)
#define ISP_DEGAIN				(ISP_BASE + 0x00134)
#define ISP_AWB_GAIN_G				(ISP_BASE + 0x00138)
#define ISP_AWB_GAIN_RB				(ISP_BASE + 0x0013c)
#define ISP_REGION0_LINE0			(ISP_BASE + 0x00140)
#define ISP_WP_CNT_REGION0			(ISP_BASE + 0x00160)
#define ISP_WP_CNT_REGION1			(ISP_BASE + 0x00164)
#define ISP_WP_CNT_REGION2			(ISP_BASE + 0x00168)
#define ISP_WP_CNT_REGION3			(ISP_BASE + 0x0016c)

#define ISP21_AWB_GAIN0_G			(ISP_BASE + 0x00138)
#define ISP21_AWB_GAIN0_RB			(ISP_BASE + 0x0013c)
#define ISP21_AWB_GAIN1_G			(ISP_BASE + 0x00140)
#define ISP21_AWB_GAIN1_RB			(ISP_BASE + 0x00144)
#define ISP21_AWB_GAIN2_G			(ISP_BASE + 0x00148)
#define ISP21_AWB_GAIN2_RB			(ISP_BASE + 0x0014c)

#define ISP_CC_COEFF_0				(ISP_BASE + 0x00170)
#define ISP_CC_COEFF_1				(ISP_BASE + 0x00174)
#define ISP_CC_COEFF_2				(ISP_BASE + 0x00178)
#define ISP_CC_COEFF_3				(ISP_BASE + 0x0017c)
#define ISP_CC_COEFF_4				(ISP_BASE + 0x00180)
#define ISP_CC_COEFF_5				(ISP_BASE + 0x00184)
#define ISP_CC_COEFF_6				(ISP_BASE + 0x00188)
#define ISP_CC_COEFF_7				(ISP_BASE + 0x0018c)
#define ISP_CC_COEFF_8				(ISP_BASE + 0x00190)
#define ISP_OUT_H_OFFS				(ISP_BASE + 0x00194)
#define ISP_OUT_V_OFFS				(ISP_BASE + 0x00198)
#define ISP_OUT_H_SIZE				(ISP_BASE + 0x0019c)
#define ISP_OUT_V_SIZE				(ISP_BASE + 0x001a0)
#define ISP_DEMOSAIC				(ISP_BASE + 0x001a4)
#define ISP_FLAGS_SHD				(ISP_BASE + 0x001a8)
#define ISP_OUT_H_OFFS_SHD			(ISP_BASE + 0x001ac)
#define ISP_OUT_V_OFFS_SHD			(ISP_BASE + 0x001b0)
#define ISP_OUT_H_SIZE_SHD			(ISP_BASE + 0x001b4)
#define ISP_OUT_V_SIZE_SHD			(ISP_BASE + 0x001b8)
#define ISP_ISP_IMSC				(ISP_BASE + 0x001bc)
#define ISP_ISP_RIS				(ISP_BASE + 0x001c0)
#define ISP_ISP_MIS				(ISP_BASE + 0x001c4)
#define ISP_ISP_ICR				(ISP_BASE + 0x001c8)
#define ISP_ISP_ISR				(ISP_BASE + 0x001cc)

#define ISP_ISP3A_IMSC				(ISP_BASE + 0x001d0)
#define ISP_ISP3A_RIS				(ISP_BASE + 0x001d4)
#define ISP_ISP3A_MIS				(ISP_BASE + 0x001d8)
#define ISP_ISP3A_ICR				(ISP_BASE + 0x001dc)

#define ISP_ERR					(ISP_BASE + 0x0023c)
#define ISP_ERR_CLR				(ISP_BASE + 0x00240)
#define ISP_FRAME_COUNT				(ISP_BASE + 0x00244)
#define ISP_CT_OFFSET_R				(ISP_BASE + 0x00248)
#define ISP_CT_OFFSET_G				(ISP_BASE + 0x0024c)
#define ISP_CT_OFFSET_B				(ISP_BASE + 0x00250)
#define ISP_DEBUG1				(ISP_BASE + 0x00254)

#define ISP_FLASH_BASE				0x00000660
#define ISP_FLASH_CMD				(ISP_FLASH_BASE + 0x00000)
#define ISP_FLASH_CONFIG			(ISP_FLASH_BASE + 0x00004)
#define ISP_FLASH_PREDIV			(ISP_FLASH_BASE + 0x00008)
#define ISP_FLASH_DELAY				(ISP_FLASH_BASE + 0x0000c)
#define ISP_FLASH_TIME				(ISP_FLASH_BASE + 0x00010)
#define ISP_FLASH_MAXP				(ISP_FLASH_BASE + 0x00014)

#define ISP_SHUTTER_BASE			0x00000680
#define ISP_SHUTTER_CTRL			(ISP_SHUTTER_BASE + 0x00000)
#define ISP_SHUTTER_PREDIV			(ISP_SHUTTER_BASE + 0x00004)
#define ISP_SHUTTER_DELAY			(ISP_SHUTTER_BASE + 0x00008)
#define ISP_SHUTTER_TIME			(ISP_SHUTTER_BASE + 0x0000c)

#define ISP_CCM_BASE				0x00000700
#define ISP_CCM_CTRL				(ISP_CCM_BASE + 0x00000)
#define ISP_CCM_COEFF0_R			(ISP_CCM_BASE + 0x00004)
#define ISP_CCM_COEFF1_R			(ISP_CCM_BASE + 0x00008)
#define ISP_CCM_COEFF0_G			(ISP_CCM_BASE + 0x0000c)
#define ISP_CCM_COEFF1_G			(ISP_CCM_BASE + 0x00010)
#define ISP_CCM_COEFF0_B			(ISP_CCM_BASE + 0x00014)
#define ISP_CCM_COEFF1_B			(ISP_CCM_BASE + 0x00018)
#define ISP_CCM_COEFF0_Y			(ISP_CCM_BASE + 0x0001c)
#define ISP_CCM_COEFF1_Y			(ISP_CCM_BASE + 0x00020)
#define ISP_CCM_ALP_Y0				(ISP_CCM_BASE + 0x00024)
#define ISP_CCM_ALP_Y1				(ISP_CCM_BASE + 0x00028)
#define ISP_CCM_ALP_Y2				(ISP_CCM_BASE + 0x0002c)
#define ISP_CCM_ALP_Y3				(ISP_CCM_BASE + 0x00030)
#define ISP_CCM_ALP_Y4				(ISP_CCM_BASE + 0x00034)
#define ISP_CCM_ALP_Y5				(ISP_CCM_BASE + 0x00038)
#define ISP_CCM_ALP_Y6				(ISP_CCM_BASE + 0x0003c)
#define ISP_CCM_ALP_Y7				(ISP_CCM_BASE + 0x00040)
#define ISP_CCM_ALP_Y8				(ISP_CCM_BASE + 0x00044)
#define ISP_CCM_BOUND_BIT			(ISP_CCM_BASE + 0x00048)

#define CPROC_BASE				0x00000800
#define CPROC_CTRL				(CPROC_BASE + 0x00000)
#define CPROC_CONTRAST				(CPROC_BASE + 0x00004)
#define CPROC_BRIGHTNESS			(CPROC_BASE + 0x00008)
#define CPROC_SATURATION			(CPROC_BASE + 0x0000c)
#define CPROC_HUE				(CPROC_BASE + 0x00010)

#define DUAL_CROP_BASE				0x00000880
#define DUAL_CROP_CTRL				(DUAL_CROP_BASE + 0x00000)
#define DUAL_CROP_M_H_OFFS			(DUAL_CROP_BASE + 0x00004)
#define DUAL_CROP_M_V_OFFS			(DUAL_CROP_BASE + 0x00008)
#define DUAL_CROP_M_H_SIZE			(DUAL_CROP_BASE + 0x0000c)
#define DUAL_CROP_M_V_SIZE			(DUAL_CROP_BASE + 0x00010)
#define DUAL_CROP_S_H_OFFS			(DUAL_CROP_BASE + 0x00014)
#define DUAL_CROP_S_V_OFFS			(DUAL_CROP_BASE + 0x00018)
#define DUAL_CROP_S_H_SIZE			(DUAL_CROP_BASE + 0x0001c)
#define DUAL_CROP_S_V_SIZE			(DUAL_CROP_BASE + 0x00020)

#define ISP_GAMMA_OUT_BASE			0x00000900
#define ISP_GAMMA_OUT_CTRL			(ISP_GAMMA_OUT_BASE + 0x00000)
#define ISP_GAMMA_OUT_OFFSET			(ISP_GAMMA_OUT_BASE + 0x00004)
#define ISP_GAMMA_OUT_Y0			(ISP_GAMMA_OUT_BASE + 0x00010)
#define ISP_GAMMA_OUT_Y1			(ISP_GAMMA_OUT_BASE + 0x00014)
#define ISP_GAMMA_OUT_Y2			(ISP_GAMMA_OUT_BASE + 0x00018)
#define ISP_GAMMA_OUT_Y3			(ISP_GAMMA_OUT_BASE + 0x0001c)
#define ISP_GAMMA_OUT_Y4			(ISP_GAMMA_OUT_BASE + 0x00020)
#define ISP_GAMMA_OUT_Y5			(ISP_GAMMA_OUT_BASE + 0x00024)
#define ISP_GAMMA_OUT_Y6			(ISP_GAMMA_OUT_BASE + 0x00028)
#define ISP_GAMMA_OUT_Y7			(ISP_GAMMA_OUT_BASE + 0x0002c)
#define ISP_GAMMA_OUT_Y8			(ISP_GAMMA_OUT_BASE + 0x00030)
#define ISP_GAMMA_OUT_Y9			(ISP_GAMMA_OUT_BASE + 0x00034)
#define ISP_GAMMA_OUT_Y10			(ISP_GAMMA_OUT_BASE + 0x00038)
#define ISP_GAMMA_OUT_Y11			(ISP_GAMMA_OUT_BASE + 0x0003c)
#define ISP_GAMMA_OUT_Y12			(ISP_GAMMA_OUT_BASE + 0x00040)
#define ISP_GAMMA_OUT_Y13			(ISP_GAMMA_OUT_BASE + 0x00044)
#define ISP_GAMMA_OUT_Y14			(ISP_GAMMA_OUT_BASE + 0x00048)
#define ISP_GAMMA_OUT_Y15			(ISP_GAMMA_OUT_BASE + 0x0004c)
#define ISP_GAMMA_OUT_Y16			(ISP_GAMMA_OUT_BASE + 0x00050)
#define ISP_GAMMA_OUT_Y17			(ISP_GAMMA_OUT_BASE + 0x00054)
#define ISP_GAMMA_OUT_Y18			(ISP_GAMMA_OUT_BASE + 0x00058)
#define ISP_GAMMA_OUT_Y19			(ISP_GAMMA_OUT_BASE + 0x0005c)
#define ISP_GAMMA_OUT_Y20			(ISP_GAMMA_OUT_BASE + 0x00060)
#define ISP_GAMMA_OUT_Y21			(ISP_GAMMA_OUT_BASE + 0x00064)
#define ISP_GAMMA_OUT_Y22			(ISP_GAMMA_OUT_BASE + 0x00068)
#define ISP_GAMMA_OUT_Y23			(ISP_GAMMA_OUT_BASE + 0x0006c)
#define ISP_GAMMA_OUT_Y24			(ISP_GAMMA_OUT_BASE + 0x00070)
#define ISP_GAMMA_OUT_Y25			(ISP_GAMMA_OUT_BASE + 0x00074)
#define ISP_GAMMA_OUT_Y26			(ISP_GAMMA_OUT_BASE + 0x00078)
#define ISP_GAMMA_OUT_Y27			(ISP_GAMMA_OUT_BASE + 0x0007c)
#define ISP_GAMMA_OUT_Y28			(ISP_GAMMA_OUT_BASE + 0x00080)
#define ISP_GAMMA_OUT_Y29			(ISP_GAMMA_OUT_BASE + 0x00084)
#define ISP_GAMMA_OUT_Y30			(ISP_GAMMA_OUT_BASE + 0x00088)
#define ISP_GAMMA_OUT_Y31			(ISP_GAMMA_OUT_BASE + 0x0008c)
#define ISP_GAMMA_OUT_Y32			(ISP_GAMMA_OUT_BASE + 0x00090)
#define ISP_GAMMA_OUT_Y33			(ISP_GAMMA_OUT_BASE + 0x00094)
#define ISP_GAMMA_OUT_Y34			(ISP_GAMMA_OUT_BASE + 0x00098)
#define ISP_GAMMA_OUT_Y35			(ISP_GAMMA_OUT_BASE + 0x0009c)
#define ISP_GAMMA_OUT_Y36			(ISP_GAMMA_OUT_BASE + 0x000a0)
#define ISP_GAMMA_OUT_Y37			(ISP_GAMMA_OUT_BASE + 0x000a4)
#define ISP_GAMMA_OUT_Y38			(ISP_GAMMA_OUT_BASE + 0x000a8)
#define ISP_GAMMA_OUT_Y39			(ISP_GAMMA_OUT_BASE + 0x000ac)
#define ISP_GAMMA_OUT_Y40			(ISP_GAMMA_OUT_BASE + 0x000b0)

#define MAIN_RESIZE_BASE			0x00000C00
#define MAIN_RESIZE_CTRL			(MAIN_RESIZE_BASE + 0x00000)
#define MAIN_RESIZE_SCALE_HY			(MAIN_RESIZE_BASE + 0x00004)
#define MAIN_RESIZE_SCALE_HCB			(MAIN_RESIZE_BASE + 0x00008)
#define MAIN_RESIZE_SCALE_HCR			(MAIN_RESIZE_BASE + 0x0000c)
#define MAIN_RESIZE_SCALE_VY			(MAIN_RESIZE_BASE + 0x00010)
#define MAIN_RESIZE_SCALE_VC			(MAIN_RESIZE_BASE + 0x00014)
#define MAIN_RESIZE_PHASE_HY			(MAIN_RESIZE_BASE + 0x00018)
#define MAIN_RESIZE_PHASE_HC			(MAIN_RESIZE_BASE + 0x0001c)
#define MAIN_RESIZE_PHASE_VY			(MAIN_RESIZE_BASE + 0x00020)
#define MAIN_RESIZE_PHASE_VC			(MAIN_RESIZE_BASE + 0x00024)
#define MAIN_RESIZE_SCALE_LUT_ADDR		(MAIN_RESIZE_BASE + 0x00028)
#define MAIN_RESIZE_SCALE_LUT			(MAIN_RESIZE_BASE + 0x0002c)
#define MAIN_RESIZE_CTRL_SHD			(MAIN_RESIZE_BASE + 0x00030)
#define MAIN_RESIZE_SCALE_HY_SHD		(MAIN_RESIZE_BASE + 0x00034)
#define MAIN_RESIZE_SCALE_HCB_SHD		(MAIN_RESIZE_BASE + 0x00038)
#define MAIN_RESIZE_SCALE_HCR_SHD		(MAIN_RESIZE_BASE + 0x0003c)
#define MAIN_RESIZE_SCALE_VY_SHD		(MAIN_RESIZE_BASE + 0x00040)
#define MAIN_RESIZE_SCALE_VC_SHD		(MAIN_RESIZE_BASE + 0x00044)
#define MAIN_RESIZE_PHASE_HY_SHD		(MAIN_RESIZE_BASE + 0x00048)
#define MAIN_RESIZE_PHASE_HC_SHD		(MAIN_RESIZE_BASE + 0x0004c)
#define MAIN_RESIZE_PHASE_VY_SHD		(MAIN_RESIZE_BASE + 0x00050)
#define MAIN_RESIZE_PHASE_VC_SHD		(MAIN_RESIZE_BASE + 0x00054)

#define SELF_RESIZE_BASE			0x00001000
#define SELF_RESIZE_CTRL			(SELF_RESIZE_BASE + 0x00000)
#define SELF_RESIZE_SCALE_HY			(SELF_RESIZE_BASE + 0x00004)
#define SELF_RESIZE_SCALE_HCB			(SELF_RESIZE_BASE + 0x00008)
#define SELF_RESIZE_SCALE_HCR			(SELF_RESIZE_BASE + 0x0000c)
#define SELF_RESIZE_SCALE_VY			(SELF_RESIZE_BASE + 0x00010)
#define SELF_RESIZE_SCALE_VC			(SELF_RESIZE_BASE + 0x00014)
#define SELF_RESIZE_PHASE_HY			(SELF_RESIZE_BASE + 0x00018)
#define SELF_RESIZE_PHASE_HC			(SELF_RESIZE_BASE + 0x0001c)
#define SELF_RESIZE_PHASE_VY			(SELF_RESIZE_BASE + 0x00020)
#define SELF_RESIZE_PHASE_VC			(SELF_RESIZE_BASE + 0x00024)
#define SELF_RESIZE_SCALE_LUT_ADDR		(SELF_RESIZE_BASE + 0x00028)
#define SELF_RESIZE_SCALE_LUT			(SELF_RESIZE_BASE + 0x0002c)
#define SELF_RESIZE_CTRL_SHD			(SELF_RESIZE_BASE + 0x00030)
#define SELF_RESIZE_SCALE_HY_SHD		(SELF_RESIZE_BASE + 0x00034)
#define SELF_RESIZE_SCALE_HCB_SHD		(SELF_RESIZE_BASE + 0x00038)
#define SELF_RESIZE_SCALE_HCR_SHD		(SELF_RESIZE_BASE + 0x0003c)
#define SELF_RESIZE_SCALE_VY_SHD		(SELF_RESIZE_BASE + 0x00040)
#define SELF_RESIZE_SCALE_VC_SHD		(SELF_RESIZE_BASE + 0x00044)
#define SELF_RESIZE_PHASE_HY_SHD		(SELF_RESIZE_BASE + 0x00048)
#define SELF_RESIZE_PHASE_HC_SHD		(SELF_RESIZE_BASE + 0x0004c)
#define SELF_RESIZE_PHASE_VY_SHD		(SELF_RESIZE_BASE + 0x00050)
#define SELF_RESIZE_PHASE_VC_SHD		(SELF_RESIZE_BASE + 0x00054)

#define MI_BASE					0x00001400
#define MI_WR_CTRL				(MI_BASE + 0x00000)
#define MI_WR_INIT				(MI_BASE + 0x00004)
#define MI_MP_WR_Y_BASE				(MI_BASE + 0x00008)
#define MI_MP_WR_Y_SIZE				(MI_BASE + 0x0000c)
#define MI_MP_WR_Y_OFFS_CNT			(MI_BASE + 0x00010)
#define MI_MP_WR_Y_OFFS_CNT_START		(MI_BASE + 0x00014)
#define MI_MP_WR_Y_IRQ_OFFS			(MI_BASE + 0x00018)
#define MI_MP_WR_CB_BASE			(MI_BASE + 0x0001c)
#define MI_MP_WR_CB_SIZE			(MI_BASE + 0x00020)
#define MI_MP_WR_CB_OFFS_CNT			(MI_BASE + 0x00024)
#define MI_MP_WR_CB_OFFS_CNT_START		(MI_BASE + 0x00028)
#define MI_MP_WR_CR_BASE			(MI_BASE + 0x0002c)
#define MI_MP_WR_CR_SIZE			(MI_BASE + 0x00030)
#define MI_MP_WR_CR_OFFS_CNT			(MI_BASE + 0x00034)
#define MI_MP_WR_CR_OFFS_CNT_START		(MI_BASE + 0x00038)
#define MI_SP_WR_Y_BASE				(MI_BASE + 0x0003c)
#define MI_SP_WR_Y_SIZE				(MI_BASE + 0x00040)
#define MI_SP_WR_Y_OFFS_CNT			(MI_BASE + 0x00044)
#define MI_SP_WR_Y_OFFS_CNT_START		(MI_BASE + 0x00048)
#define MI_SP_WR_Y_LLENGTH			(MI_BASE + 0x0004c)
#define MI_SP_WR_CB_BASE			(MI_BASE + 0x00050)
#define MI_SP_WR_CB_SIZE			(MI_BASE + 0x00054)
#define MI_SP_WR_CB_OFFS_CNT			(MI_BASE + 0x00058)
#define MI_SP_WR_CB_OFFS_CNT_START		(MI_BASE + 0x0005c)
#define MI_SP_WR_CR_BASE			(MI_BASE + 0x00060)
#define MI_SP_WR_CR_SIZE			(MI_BASE + 0x00064)
#define MI_SP_WR_CR_OFFS_CNT			(MI_BASE + 0x00068)
#define MI_SP_WR_CR_OFFS_CNT_START		(MI_BASE + 0x0006c)
#define MI_WR_BYTE_CNT				(MI_BASE + 0x00070)
#define MI_WR_CTRL_SHD				(MI_BASE + 0x00074)
#define MI_MP_WR_Y_BASE_SHD			(MI_BASE + 0x00078)
#define MI_MP_WR_Y_SIZE_SHD			(MI_BASE + 0x0007c)
#define MI_MP_WR_Y_OFFS_CNT_SHD			(MI_BASE + 0x00080)
#define MI_MP_WR_Y_IRQ_OFFS_SHD			(MI_BASE + 0x00084)
#define MI_MP_WR_CB_BASE_SHD			(MI_BASE + 0x00088)
#define MI_MP_WR_CB_SIZE_SHD			(MI_BASE + 0x0008c)
#define MI_MP_WR_CB_OFFS_CNT_SHD		(MI_BASE + 0x00090)
#define MI_MP_WR_CR_BASE_SHD			(MI_BASE + 0x00094)
#define MI_MP_WR_CR_SIZE_SHD			(MI_BASE + 0x00098)
#define MI_MP_WR_CR_OFFS_CNT_SHD		(MI_BASE + 0x0009c)
#define MI_SP_WR_Y_BASE_SHD			(MI_BASE + 0x000a0)
#define MI_SP_WR_Y_SIZE_SHD			(MI_BASE + 0x000a4)
#define MI_SP_WR_Y_OFFS_CNT_SHD			(MI_BASE + 0x000a8)
#define MI_SP_WR_CB_BASE_AD_SHD			(MI_BASE + 0x000b0)
#define MI_SP_WR_CB_SIZE_SHD			(MI_BASE + 0x000b4)
#define MI_SP_WR_CB_OFFS_CNT_SHD		(MI_BASE + 0x000b8)
#define MI_SP_WR_CR_BASE_AD_SHD			(MI_BASE + 0x000bc)
#define MI_SP_WR_CR_SIZE_SHD			(MI_BASE + 0x000c0)
#define MI_SP_WR_CR_OFFS_CNT_SHD		(MI_BASE + 0x000c4)
#define MI_RD_Y_PIC_START_AD			(MI_BASE + 0x000c8)
#define MI_RD_Y_PIC_WIDTH			(MI_BASE + 0x000cc)
#define MI_RD_Y_LLENGTH				(MI_BASE + 0x000d0)
#define MI_RD_Y_PIC_SIZE			(MI_BASE + 0x000d4)
#define MI_RD_CB_PIC_START_AD			(MI_BASE + 0x000d8)
#define MI_RD_CR_PIC_START_AD			(MI_BASE + 0x000e8)
#define MI_IMSC					(MI_BASE + 0x000f8)
#define MI_RIS					(MI_BASE + 0x000fc)
#define MI_MIS					(MI_BASE + 0x00100)
#define MI_ICR					(MI_BASE + 0x00104)
#define MI_ISR					(MI_BASE + 0x00108)
#define MI_STATUS				(MI_BASE + 0x0010c)
#define MI_STATUS_CLR				(MI_BASE + 0x00110)
#define MI_SP_WR_Y_PIC_WIDTH			(MI_BASE + 0x00114)
#define MI_SP_WR_Y_PIC_HEIGHT			(MI_BASE + 0x00118)
#define MI_SP_WR_Y_PIC_SIZE			(MI_BASE + 0x0011c)
#define MI_RD_CTRL				(MI_BASE + 0x00120)
#define MI_RD_START				(MI_BASE + 0x00124)
#define MI_RD_STATUS				(MI_BASE + 0x00128)
#define MI_WR_PIXEL_CNT				(MI_BASE + 0x0012c)
#define MI_MP_WR_Y_BASE2			(MI_BASE + 0x00130)
#define MI_MP_WR_CB_BASE2			(MI_BASE + 0x00134)
#define MI_MP_WR_CR_BASE2			(MI_BASE + 0x00138)
#define MI_WR_XTD_FORMAT_CTRL			(MI_BASE + 0x00148)
#define MI_WR_ID				(MI_BASE + 0x00154)
#define MI_MP_WR_Y_IRQ_OFFS2			(MI_BASE + 0x001e0)
#define MI_MP_WR_Y_IRQ_OFFS2_SHD		(MI_BASE + 0x001e4)
#define MI_MP_WR_Y_LLENGTH			(MI_BASE + 0x001e8)
#define MI_WR_CTRL2				(MI_BASE + 0x00400)
#define MI_WR_ID2				(MI_BASE + 0x00404)
#define MI_RD_CTRL2				(MI_BASE + 0x00408)
#define MI_RD_ID				(MI_BASE + 0x0040c)
#define MI_RD_FIFO_LEVEL			(MI_BASE + 0x0041c)
#define MI_RAW0_WR_BASE				(MI_BASE + 0x00420)
#define MI_RAW0_WR_SIZE				(MI_BASE + 0x00424)
#define MI_RAW0_WR_LENGTH			(MI_BASE + 0x00428)
#define MI_RAW0_WR_BASE_SHD			(MI_BASE + 0x0042c)
#define MI_RAW1_WR_BASE				(MI_BASE + 0x00430)
#define MI_RAW1_WR_SIZE				(MI_BASE + 0x00434)
#define MI_RAW1_WR_LENGTH			(MI_BASE + 0x00438)
#define MI_RAW1_WR_BASE_SHD			(MI_BASE + 0x0043c)
#define MI_RAW2_WR_BASE				(MI_BASE + 0x00440)
#define MI_RAW2_WR_SIZE				(MI_BASE + 0x00444)
#define MI_RAW2_WR_LENGTH			(MI_BASE + 0x00448)
#define MI_RAW2_WR_BASE_SHD			(MI_BASE + 0x0044c)
#define MI_RAW3_WR_BASE				(MI_BASE + 0x00450)
#define MI_RAW3_WR_SIZE				(MI_BASE + 0x00454)
#define MI_RAW3_WR_LENGTH			(MI_BASE + 0x00458)
#define MI_RAW3_WR_BASE_SHD			(MI_BASE + 0x0045c)
#define MI_RW0_WR_LAST_FRAME_ADDR		(MI_BASE + 0x00460)
#define MI_RW1_WR_LAST_FRAME_ADDR		(MI_BASE + 0x00464)
#define MI_RW2_WR_LAST_FRAME_ADDR		(MI_BASE + 0x00468)
#define MI_RW3_WR_LAST_FRAME_ADDR		(MI_BASE + 0x0046c)
#define MI_RAW0_RD_BASE				(MI_BASE + 0x00470)
#define MI_RAW0_RD_LENGTH			(MI_BASE + 0x00474)
#define MI_RAW0_RD_BASE_SHD			(MI_BASE + 0x00478)
#define MI_RAW1_RD_BASE				(MI_BASE + 0x00480)
#define MI_RAW1_RD_LENGTH			(MI_BASE + 0x00484)
#define MI_RAW1_RD_BASE_SHD			(MI_BASE + 0x00488)
#define MI_RAW2_RD_BASE				(MI_BASE + 0x00490)
#define MI_RAW2_RD_LENGTH			(MI_BASE + 0x00494)
#define MI_RAW2_RD_BASE_SHD			(MI_BASE + 0x00498)
#define MI_RAWFBC_WR_BURST_LEN			(MI_BASE + 0x00500)
#define MI_RAWFBC_RD_BURST_LEN			(MI_BASE + 0x00504)
#define MI_RAW0FBC_WR_BASE			(MI_BASE + 0x00510)
#define MI_RAW1FBC_WR_BASE			(MI_BASE + 0x00514)
#define MI_RAW0FBC_RD_BASE			(MI_BASE + 0x00518)
#define MI_RAW1FBC_RD_BASE			(MI_BASE + 0x0051c)
#define MI_RAW0FBC_WR_BASE_SHD			(MI_BASE + 0x00520)
#define MI_RAW1FBC_WR_BASE_SHD			(MI_BASE + 0x00524)
#define MI_RAW0FBC_RD_BASE_SHD			(MI_BASE + 0x00528)
#define MI_RAW1FBC_RD_BASE_SHD			(MI_BASE + 0x0052c)
#define MI_LUT_3D_RD_BASE			(MI_BASE + 0x00540)
#define MI_LUT_LSC_RD_BASE			(MI_BASE + 0x00544)
#define MI_LUT_LDCH_RD_BASE			(MI_BASE + 0x00548)
#define MI_LUT_3D_RD_WSIZE			(MI_BASE + 0x00550)
#define MI_LUT_LSC_RD_WSIZE			(MI_BASE + 0x00554)
#define MI_LUT_LDCH_RD_H_WSIZE			(MI_BASE + 0x00558)
#define MI_LUT_LDCH_RD_V_SIZE			(MI_BASE + 0x0055c)
#define MI_DBR_WR_BASE				(MI_BASE + 0x00560)
#define MI_DBR_WR_SIZE				(MI_BASE + 0x00564)
#define MI_DBR_WR_LENGTH			(MI_BASE + 0x00568)
#define MI_DBR_WR_BASE_SHD			(MI_BASE + 0x0056c)
#define MI_DBR_RD_BASE				(MI_BASE + 0x00570)
#define MI_DBR_RD_LENGTH			(MI_BASE + 0x00574)
#define MI_DBR_RD_BASE_SHD			(MI_BASE + 0x00578)
#define MI_SWS_3A_WR_BASE			(MI_BASE + 0x0057c)
#define MI_GAIN_WR_BASE				(MI_BASE + 0x00580)
#define MI_GAIN_WR_SIZE				(MI_BASE + 0x00584)
#define MI_GAIN_WR_LENGTH			(MI_BASE + 0x00588)
#define MI_GAIN_WR_BASE2			(MI_BASE + 0x0058c)
#define MI_GAIN_WR_BASE_SHD			(MI_BASE + 0x00590)

#define ISP21_MI_BAY3D_WR_BASE			(MI_BASE + 0x005a0)
#define ISP21_MI_BAY3D_WR_SIZE			(MI_BASE + 0x005a4)
#define ISP21_MI_BAY3D_WR_LENGTH		(MI_BASE + 0x005a8)
#define ISP21_MI_BAY3D_WR_BASE_SHD		(MI_BASE + 0x005ac)
#define ISP21_MI_BAY3D_RD_BASE			(MI_BASE + 0x005b0)
#define ISP21_MI_BAY3D_RD_LENGTH		(MI_BASE + 0x005b4)
#define ISP21_MI_BAY3D_RD_BASE_SHD		(MI_BASE + 0x005b8)

#define ISP_MPFBC_BASE				0x000018C0
#define ISP_MPFBC_CTRL				(ISP_MPFBC_BASE + 0x00000)
#define ISP_MPFBC_VIR_WIDTH			(ISP_MPFBC_BASE + 0x00004)
#define ISP_MPFBC_VIR_HEIGHT			(ISP_MPFBC_BASE + 0x00008)
#define ISP_MPFBC_HEAD_PTR			(ISP_MPFBC_BASE + 0x0000c)
#define ISP_MPFBC_PAYL_PTR			(ISP_MPFBC_BASE + 0x00010)
#define ISP_MPFBC_HEAD_PTR2			(ISP_MPFBC_BASE + 0x00014)
#define ISP_MPFBC_PAYL_PTR2			(ISP_MPFBC_BASE + 0x00018)
#define ISP_MPFBC_ENC_POS			(ISP_MPFBC_BASE + 0x00030)

#define CSI2RX_BASE				0x00001C00
#define CSI2RX_CTRL0				(CSI2RX_BASE + 0x00000)
#define CSI2RX_CTRL1				(CSI2RX_BASE + 0x00004)
#define CSI2RX_CTRL2				(CSI2RX_BASE + 0x00008)
#define CSI2RX_CSI2_RESETN			(CSI2RX_BASE + 0x00010)
#define CSI2RX_PHY_STATE_RO			(CSI2RX_BASE + 0x00014)
#define CSI2RX_DATA_IDS_1			(CSI2RX_BASE + 0x00018)
#define CSI2RX_DATA_IDS_2			(CSI2RX_BASE + 0x0001c)
#define CSI2RX_ERR_PHY				(CSI2RX_BASE + 0x00020)
#define CSI2RX_ERR_PACKET			(CSI2RX_BASE + 0x00024)
#define CSI2RX_ERR_OVERFLOW			(CSI2RX_BASE + 0x00028)
#define CSI2RX_ERR_STAT				(CSI2RX_BASE + 0x0002c)
#define CSI2RX_MASK_PHY				(CSI2RX_BASE + 0x00030)
#define CSI2RX_MASK_PACKET			(CSI2RX_BASE + 0x00034)
#define CSI2RX_MASK_OVERFLOW			(CSI2RX_BASE + 0x00038)
#define CSI2RX_MASK_STAT			(CSI2RX_BASE + 0x0003c)
#define CSI2RX_RAW0_WR_CTRL			(CSI2RX_BASE + 0x00040)
#define CSI2RX_RAW0_WR_LINECNT_RO		(CSI2RX_BASE + 0x00044)
#define CSI2RX_RAW0_WR_PIC_SIZE			(CSI2RX_BASE + 0x00048)
#define CSI2RX_RAW0_WR_PIC_OFF			(CSI2RX_BASE + 0x0004c)
#define CSI2RX_RAW1_WR_CTRL			(CSI2RX_BASE + 0x00050)
#define CSI2RX_RAW1_WR_LINECNT_RO		(CSI2RX_BASE + 0x00054)
#define CSI2RX_RAW1_WR_PIC_SIZE			(CSI2RX_BASE + 0x00058)
#define CSI2RX_RAW1_WR_PIC_OFF			(CSI2RX_BASE + 0x0005c)
#define CSI2RX_RAW2_WR_CTRL			(CSI2RX_BASE + 0x00060)
#define CSI2RX_RAW2_WR_LINECNT_RO		(CSI2RX_BASE + 0x00064)
#define CSI2RX_RAW2_WR_PIC_SIZE			(CSI2RX_BASE + 0x00068)
#define CSI2RX_RAW2_WR_PIC_OFF			(CSI2RX_BASE + 0x0006c)
#define CSI2RX_RAW3_WR_CTRL			(CSI2RX_BASE + 0x00070)
#define CSI2RX_RAW3_WR_LINECNT_RO		(CSI2RX_BASE + 0x00074)
#define CSI2RX_RAW3_WR_PIC_SIZE			(CSI2RX_BASE + 0x00078)
#define CSI2RX_RAW3_WR_PIC_OFF			(CSI2RX_BASE + 0x0007c)
#define CSI2RX_RAW_RD_CTRL			(CSI2RX_BASE + 0x00080)
#define CSI2RX_RAW_RD_LINECNT_RO		(CSI2RX_BASE + 0x00084)
#define CSI2RX_RAW_RD_PIC_SIZE			(CSI2RX_BASE + 0x00088)
#define CSI2RX_RAW2_RD_LINECNT_RO		(CSI2RX_BASE + 0x0008c)
#define CSI2RX_RAWFBC_CTRL			(CSI2RX_BASE + 0x00090)
#define CSI2RX_ESPHDR_LCNT			(CSI2RX_BASE + 0x00094)
#define CSI2RX_ESPHDR_IDCD			(CSI2RX_BASE + 0x00098)
#define CSI2RX_VC0_FRAME_NUM_RO			(CSI2RX_BASE + 0x000a0)
#define CSI2RX_VC1_FRAME_NUM_RO			(CSI2RX_BASE + 0x000a4)
#define CSI2RX_VC2_FRAME_NUM_RO			(CSI2RX_BASE + 0x000a8)
#define CSI2RX_VC3_FRAME_NUM_RO			(CSI2RX_BASE + 0x000ac)
#define CSI2RX_ISP_LINECNT_RO			(CSI2RX_BASE + 0x000b0)
#define CSI2RX_RAW_WR_IBUF_STATUS_RO		(CSI2RX_BASE + 0x000b4)
#define CSI2RX_RAW_WR_IBUF3_STATUS_RO		(CSI2RX_BASE + 0x000b8)
#define CSI2RX_CUR_HEADER_RO			(CSI2RX_BASE + 0x000c4)
#define CSI2RX_RAWFBC_EN_SHD			(CSI2RX_BASE + 0x000c8)
#define CSI2RX_FPN_CTRL				(CSI2RX_BASE + 0x000d0)
#define CSI2RX_FPN_TABLE_CTRL			(CSI2RX_BASE + 0x000d4)
#define CSI2RX_FPN_TABLE_DATA			(CSI2RX_BASE + 0x000d8)
#define CSI2RX_Y_STAT_CTRL			(CSI2RX_BASE + 0x000f0)
#define CSI2RX_Y_STAT_RO			(CSI2RX_BASE + 0x000f4)
#define CSI2RX_VERSION				(CSI2RX_BASE + 0x000fc)

#define ISP_LSC_BASE				0x00002200
#define ISP_LSC_CTRL				(ISP_LSC_BASE + 0x00000)
#define ISP_LSC_R_TABLE_ADDR			(ISP_LSC_BASE + 0x00004)
#define ISP_LSC_GR_TABLE_ADDR			(ISP_LSC_BASE + 0x00008)
#define ISP_LSC_B_TABLE_ADDR			(ISP_LSC_BASE + 0x0000c)
#define ISP_LSC_GB_TABLE_ADDR			(ISP_LSC_BASE + 0x00010)
#define ISP_LSC_R_TABLE_DATA			(ISP_LSC_BASE + 0x00014)
#define ISP_LSC_GR_TABLE_DATA			(ISP_LSC_BASE + 0x00018)
#define ISP_LSC_B_TABLE_DATA			(ISP_LSC_BASE + 0x0001c)
#define ISP_LSC_GB_TABLE_DATA			(ISP_LSC_BASE + 0x00020)
#define ISP_LSC_XGRAD_01			(ISP_LSC_BASE + 0x00024)
#define ISP_LSC_XGRAD_23			(ISP_LSC_BASE + 0x00028)
#define ISP_LSC_XGRAD_45			(ISP_LSC_BASE + 0x0002c)
#define ISP_LSC_XGRAD_67			(ISP_LSC_BASE + 0x00030)
#define ISP_LSC_YGRAD_01			(ISP_LSC_BASE + 0x00034)
#define ISP_LSC_YGRAD_23			(ISP_LSC_BASE + 0x00038)
#define ISP_LSC_YGRAD_45			(ISP_LSC_BASE + 0x0003c)
#define ISP_LSC_YGRAD_67			(ISP_LSC_BASE + 0x00040)
#define ISP_LSC_XSIZE_01			(ISP_LSC_BASE + 0x00044)
#define ISP_LSC_XSIZE_23			(ISP_LSC_BASE + 0x00048)
#define ISP_LSC_XSIZE_45			(ISP_LSC_BASE + 0x0004c)
#define ISP_LSC_XSIZE_67			(ISP_LSC_BASE + 0x00050)
#define ISP_LSC_YSIZE_01			(ISP_LSC_BASE + 0x00054)
#define ISP_LSC_YSIZE_23			(ISP_LSC_BASE + 0x00058)
#define ISP_LSC_YSIZE_45			(ISP_LSC_BASE + 0x0005c)
#define ISP_LSC_YSIZE_67			(ISP_LSC_BASE + 0x00060)
#define ISP_LSC_TABLE_SEL			(ISP_LSC_BASE + 0x00064)
#define ISP_LSC_STATUS				(ISP_LSC_BASE + 0x00068)

#define ISP_DEBAYER_BASE			0x00002500
#define ISP_DEBAYER_CONTROL			(ISP_DEBAYER_BASE + 0x00000)
#define ISP_DEBAYER_G_INTERP			(ISP_DEBAYER_BASE + 0x00004)
#define ISP_DEBAYER_G_INTERP_FILTER1		(ISP_DEBAYER_BASE + 0x00008)
#define ISP_DEBAYER_G_INTERP_FILTER2		(ISP_DEBAYER_BASE + 0x0000c)
#define ISP_DEBAYER_G_FILTER			(ISP_DEBAYER_BASE + 0x00010)
#define ISP_DEBAYER_C_FILTER			(ISP_DEBAYER_BASE + 0x00014)

#define ISP21_YNR_BASE				0x00002700
#define ISP21_YNR_GLOBAL_CTRL			(ISP21_YNR_BASE + 0x00000)
#define ISP21_YNR_RNR_MAX_R			(ISP21_YNR_BASE + 0x00004)
#define ISP21_YNR_LOWNR_CTRL0			(ISP21_YNR_BASE + 0x00010)
#define ISP21_YNR_LOWNR_CTRL1			(ISP21_YNR_BASE + 0x00014)
#define ISP21_YNR_LOWNR_CTRL2			(ISP21_YNR_BASE + 0x00018)
#define ISP21_YNR_LOWNR_CTRL3			(ISP21_YNR_BASE + 0x0001c)
#define ISP21_YNR_HIGHNR_CTRL0			(ISP21_YNR_BASE + 0x00020)
#define ISP21_YNR_HIGHNR_CTRL1			(ISP21_YNR_BASE + 0x00024)
#define ISP21_YNR_HIGHNR_BASE_FILTER_WEIGHT	(ISP21_YNR_BASE + 0x00028)
#define ISP21_YNR_GAUSS1_COEFF			(ISP21_YNR_BASE + 0x00030)
#define ISP21_YNR_GAUSS2_COEFF			(ISP21_YNR_BASE + 0x00034)
#define ISP21_YNR_DIRECTION_W_0_3		(ISP21_YNR_BASE + 0x00038)
#define ISP21_YNR_DIRECTION_W_4_7		(ISP21_YNR_BASE + 0x0003c)
#define ISP21_YNR_SGM_DX_0_1			(ISP21_YNR_BASE + 0x00040)
#define ISP21_YNR_SGM_DX_2_3			(ISP21_YNR_BASE + 0x00044)
#define ISP21_YNR_SGM_DX_4_5			(ISP21_YNR_BASE + 0x00048)
#define ISP21_YNR_SGM_DX_6_7			(ISP21_YNR_BASE + 0x0004c)
#define ISP21_YNR_SGM_DX_8_9			(ISP21_YNR_BASE + 0x00050)
#define ISP21_YNR_SGM_DX_10_11			(ISP21_YNR_BASE + 0x00055)
#define ISP21_YNR_SGM_DX_12_13			(ISP21_YNR_BASE + 0x00058)
#define ISP21_YNR_SGM_DX_14_15			(ISP21_YNR_BASE + 0x0005c)
#define ISP21_YNR_SGM_DX_16			(ISP21_YNR_BASE + 0x00060)
#define ISP21_YNR_LSGM_Y_0_1			(ISP21_YNR_BASE + 0x00070)
#define ISP21_YNR_LSGM_Y_2_3			(ISP21_YNR_BASE + 0x00074)
#define ISP21_YNR_LSGM_Y_4_5			(ISP21_YNR_BASE + 0x00078)
#define ISP21_YNR_LSGM_Y_6_7			(ISP21_YNR_BASE + 0x0007c)
#define ISP21_YNR_LSGM_Y_8_9			(ISP21_YNR_BASE + 0x00080)
#define ISP21_YNR_LSGM_Y_10_11			(ISP21_YNR_BASE + 0x00084)
#define ISP21_YNR_LSGM_Y_12_13			(ISP21_YNR_BASE + 0x00088)
#define ISP21_YNR_LSGM_Y_14_15			(ISP21_YNR_BASE + 0x0008c)
#define ISP21_YNR_LSGM_Y_16			(ISP21_YNR_BASE + 0x00090)
#define ISP21_YNR_HSGM_Y_0_1			(ISP21_YNR_BASE + 0x000a0)
#define ISP21_YNR_HSGM_Y_2_3			(ISP21_YNR_BASE + 0x000a4)
#define ISP21_YNR_HSGM_Y_4_5			(ISP21_YNR_BASE + 0x000a8)
#define ISP21_YNR_HSGM_Y_6_7			(ISP21_YNR_BASE + 0x000ac)
#define ISP21_YNR_HSGM_Y_8_9			(ISP21_YNR_BASE + 0x000b0)
#define ISP21_YNR_HSGM_Y_10_11			(ISP21_YNR_BASE + 0x000b4)
#define ISP21_YNR_HSGM_Y_12_13			(ISP21_YNR_BASE + 0x000b8)
#define ISP21_YNR_HSGM_Y_14_15			(ISP21_YNR_BASE + 0x000bc)
#define ISP21_YNR_HSGM_Y_16			(ISP21_YNR_BASE + 0x000c0)
#define ISP21_YNR_RNR_STRENGTH03		(ISP21_YNR_BASE + 0x000d0)
#define ISP21_YNR_RNR_STRENGTH47		(ISP21_YNR_BASE + 0x000d4)
#define ISP21_YNR_RNR_STRENGTH8B		(ISP21_YNR_BASE + 0x000d8)
#define ISP21_YNR_RNR_STRENGTHCF		(ISP21_YNR_BASE + 0x000dc)
#define ISP21_YNR_RNR_STRENGTH16		(ISP21_YNR_BASE + 0x000e0)

#define ISP21_CNR_BASE				0x00002800
#define ISP21_CNR_CTRL				(ISP21_CNR_BASE + 0x00000)
#define ISP21_CNR_EXGAIN			(ISP21_CNR_BASE + 0x00004)
#define ISP21_CNR_GAIN_PARA			(ISP21_CNR_BASE + 0x00008)
#define ISP21_CNR_GAIN_UV_PARA			(ISP21_CNR_BASE + 0x0000c)
#define ISP21_CNR_LMED3				(ISP21_CNR_BASE + 0x00010)
#define ISP21_CNR_LBF5_GAIN			(ISP21_CNR_BASE + 0x00014)
#define ISP21_CNR_LBF5_WEITD0_3			(ISP21_CNR_BASE + 0x00018)
#define ISP21_CNR_LBF5_WEITD4			(ISP21_CNR_BASE + 0x0001c)
#define ISP21_CNR_HMED3				(ISP21_CNR_BASE + 0x00020)
#define ISP21_CNR_HBF5				(ISP21_CNR_BASE + 0x00024)
#define ISP21_CNR_LBF3				(ISP21_CNR_BASE + 0x00028)

#define ISP21_SHARP_BASE			0x00002900
#define ISP21_SHARP_SHARP_EN			(ISP21_SHARP_BASE + 0x00000)
#define ISP21_SHARP_SHARP_RATIO			(ISP21_SHARP_BASE + 0x00004)
#define ISP21_SHARP_SHARP_LUMA_DX		(ISP21_SHARP_BASE + 0x00008)
#define ISP21_SHARP_SHARP_PBF_SIGMA_INV_0	(ISP21_SHARP_BASE + 0x0000c)
#define ISP21_SHARP_SHARP_PBF_SIGMA_INV_1	(ISP21_SHARP_BASE + 0x00010)
#define ISP21_SHARP_SHARP_PBF_SIGMA_INV_2	(ISP21_SHARP_BASE + 0x00014)
#define ISP21_SHARP_SHARP_BF_SIGMA_INV_0	(ISP21_SHARP_BASE + 0x00018)
#define ISP21_SHARP_SHARP_BF_SIGMA_INV_1	(ISP21_SHARP_BASE + 0x0001c)
#define ISP21_SHARP_SHARP_BF_SIGMA_INV_2	(ISP21_SHARP_BASE + 0x00020)
#define ISP21_SHARP_SHARP_SIGMA_SHIFT		(ISP21_SHARP_BASE + 0x00024)
#define ISP21_SHARP_SHARP_EHF_TH_0		(ISP21_SHARP_BASE + 0x00028)
#define ISP21_SHARP_SHARP_EHF_TH_1		(ISP21_SHARP_BASE + 0x0002c)
#define ISP21_SHARP_SHARP_EHF_TH_2		(ISP21_SHARP_BASE + 0x00030)
#define ISP21_SHARP_SHARP_CLIP_HF_0		(ISP21_SHARP_BASE + 0x00034)
#define ISP21_SHARP_SHARP_CLIP_HF_1		(ISP21_SHARP_BASE + 0x00038)
#define ISP21_SHARP_SHARP_CLIP_HF_2		(ISP21_SHARP_BASE + 0x0003c)
#define ISP21_SHARP_SHARP_PBF_COEF		(ISP21_SHARP_BASE + 0x00040)
#define ISP21_SHARP_SHARP_BF_COEF		(ISP21_SHARP_BASE + 0x00044)
#define ISP21_SHARP_SHARP_GAUS_COEF		(ISP21_SHARP_BASE + 0x00048)

#define ISP_WDR_BASE				0x00002A00
#define ISP_WDR_CTRL				(ISP_WDR_BASE + 0x00000)
#define ISP_WDR_WDR_TONECURVE_DYN1		(ISP_WDR_BASE + 0x00004)
#define ISP_WDR_WDR_TONECURVE_DYN2		(ISP_WDR_BASE + 0x00008)
#define ISP_WDR_WDR_TONECURVE_DYN3		(ISP_WDR_BASE + 0x0000c)
#define ISP_WDR_WDR_TONECURVE_DYN4		(ISP_WDR_BASE + 0x00010)
#define ISP_WDR_TONECURVE_YM_0			(ISP_WDR_BASE + 0x00014)
#define ISP_WDR_TONECURVE_YM_1			(ISP_WDR_BASE + 0x00018)
#define ISP_WDR_TONECURVE_YM_2			(ISP_WDR_BASE + 0x0001c)
#define ISP_WDR_TONECURVE_YM_3			(ISP_WDR_BASE + 0x00020)
#define ISP_WDR_TONECURVE_YM_4			(ISP_WDR_BASE + 0x00024)
#define ISP_WDR_TONECURVE_YM_5			(ISP_WDR_BASE + 0x00028)
#define ISP_WDR_TONECURVE_YM_6			(ISP_WDR_BASE + 0x0002c)
#define ISP_WDR_TONECURVE_YM_7			(ISP_WDR_BASE + 0x00030)
#define ISP_WDR_TONECURVE_YM_8			(ISP_WDR_BASE + 0x00034)
#define ISP_WDR_TONECURVE_YM_9			(ISP_WDR_BASE + 0x00038)
#define ISP_WDR_TONECURVE_YM_10			(ISP_WDR_BASE + 0x0003c)
#define ISP_WDR_TONECURVE_YM_11			(ISP_WDR_BASE + 0x00040)
#define ISP_WDR_TONECURVE_YM_12			(ISP_WDR_BASE + 0x00044)
#define ISP_WDR_TONECURVE_YM_13			(ISP_WDR_BASE + 0x00048)
#define ISP_WDR_TONECURVE_YM_14			(ISP_WDR_BASE + 0x0004c)
#define ISP_WDR_TONECURVE_YM_15			(ISP_WDR_BASE + 0x00050)
#define ISP_WDR_TONECURVE_YM_16			(ISP_WDR_BASE + 0x00054)
#define ISP_WDR_TONECURVE_YM_17			(ISP_WDR_BASE + 0x00058)
#define ISP_WDR_TONECURVE_YM_18			(ISP_WDR_BASE + 0x0005c)
#define ISP_WDR_TONECURVE_YM_19			(ISP_WDR_BASE + 0x00060)
#define ISP_WDR_TONECURVE_YM_20			(ISP_WDR_BASE + 0x00064)
#define ISP_WDR_TONECURVE_YM_21			(ISP_WDR_BASE + 0x00068)
#define ISP_WDR_TONECURVE_YM_22			(ISP_WDR_BASE + 0x0006c)
#define ISP_WDR_TONECURVE_YM_23			(ISP_WDR_BASE + 0x00070)
#define ISP_WDR_TONECURVE_YM_24			(ISP_WDR_BASE + 0x00074)
#define ISP_WDR_TONECURVE_YM_25			(ISP_WDR_BASE + 0x00078)
#define ISP_WDR_TONECURVE_YM_26			(ISP_WDR_BASE + 0x0007c)
#define ISP_WDR_TONECURVE_YM_27			(ISP_WDR_BASE + 0x00080)
#define ISP_WDR_TONECURVE_YM_28			(ISP_WDR_BASE + 0x00084)
#define ISP_WDR_TONECURVE_YM_29			(ISP_WDR_BASE + 0x00088)
#define ISP_WDR_TONECURVE_YM_30			(ISP_WDR_BASE + 0x0008c)
#define ISP_WDR_TONECURVE_YM_31			(ISP_WDR_BASE + 0x00090)
#define ISP_WDR_TONECURVE_YM_32			(ISP_WDR_BASE + 0x00094)
#define ISP_WDR_OFFSET				(ISP_WDR_BASE + 0x00098)
#define ISP_WDR_CTRL0				(ISP_WDR_BASE + 0x00150)
#define ISP_WDR_CTRL1				(ISP_WDR_BASE + 0x00154)
#define ISP_WDR_BLKOFF0				(ISP_WDR_BASE + 0x00158)
#define ISP_WDR_AVGCLIP				(ISP_WDR_BASE + 0x0015c)
#define ISP_WDR_COE_0				(ISP_WDR_BASE + 0x00160)
#define ISP_WDR_COE_1				(ISP_WDR_BASE + 0x00164)
#define ISP_WDR_COE_2				(ISP_WDR_BASE + 0x00168)
#define ISP_WDR_COE_OFF				(ISP_WDR_BASE + 0x0016c)
#define ISP_WDR_BLKOFF1				(ISP_WDR_BASE + 0x00174)
#define ISP_WDR_BLKMEAN8_ROW0_0TO3		(ISP_WDR_BASE + 0x00180)
#define ISP_WDR_BLKMEAN8_ROW0_4TO7		(ISP_WDR_BASE + 0x00184)
#define ISP_WDR_BLKMEAN8_ROW1_0TO3		(ISP_WDR_BASE + 0x00188)
#define ISP_WDR_BLKMEAN8_ROW1_4TO7		(ISP_WDR_BASE + 0x0018c)
#define ISP_WDR_BLKMEAN8_ROW2_0TO3		(ISP_WDR_BASE + 0x00190)
#define ISP_WDR_BLKMEAN8_ROW2_4TO7		(ISP_WDR_BASE + 0x00194)
#define ISP_WDR_BLKMEAN8_ROW3_0TO3		(ISP_WDR_BASE + 0x00198)
#define ISP_WDR_BLKMEAN8_ROW3_4TO7		(ISP_WDR_BASE + 0x0019c)
#define ISP_WDR_BLKMEAN8_ROW4_0TO3		(ISP_WDR_BASE + 0x001a0)
#define ISP_WDR_BLKMEAN8_ROW4_4TO7		(ISP_WDR_BASE + 0x001a4)
#define ISP_WDR_BLKMEAN8_ROW5_0TO3		(ISP_WDR_BASE + 0x001a8)
#define ISP_WDR_BLKMEAN8_ROW5_4TO7		(ISP_WDR_BASE + 0x001ac)
#define ISP_WDR_BLKMEAN8_ROW6_0TO3		(ISP_WDR_BASE + 0x001b0)
#define ISP_WDR_BLKMEAN8_ROW6_4TO7		(ISP_WDR_BASE + 0x001b4)
#define ISP_WDR_BLKMEAN8_ROW7_0TO3		(ISP_WDR_BASE + 0x001b8)
#define ISP_WDR_BLKMEAN8_ROW7_4TO7		(ISP_WDR_BASE + 0x001bc)
#define ISP_WDR_BLKMEAN8_ROW8_0TO3		(ISP_WDR_BASE + 0x001c0)
#define ISP_WDR_BLKMEAN8_ROW8_4TO7		(ISP_WDR_BASE + 0x001c4)
#define ISP_WDR_BLKMEAN8_ROW9_0TO3		(ISP_WDR_BASE + 0x001c8)
#define ISP_WDR_BLKMEAN8_ROW9_4TO7		(ISP_WDR_BASE + 0x001cc)

#define ISP_GIC_BASE				0x00002F00
#define ISP_GIC_CONTROL				(ISP_GIC_BASE + 0x00000)
#define ISP_GIC_DIFF_PARA1			(ISP_GIC_BASE + 0x00004)
#define ISP_GIC_DIFF_PARA2			(ISP_GIC_BASE + 0x00008)
#define ISP_GIC_DIFF_PARA3			(ISP_GIC_BASE + 0x0000c)
#define ISP_GIC_DIFF_PARA4			(ISP_GIC_BASE + 0x00010)
#define ISP_GIC_NOISE_PARA1			(ISP_GIC_BASE + 0x00014)
#define ISP_GIC_NOISE_PARA2			(ISP_GIC_BASE + 0x00018)
#define ISP_GIC_NOISE_PARA3			(ISP_GIC_BASE + 0x0001c)
#define ISP_GIC_SIGMA_VALUE0			(ISP_GIC_BASE + 0x00020)
#define ISP_GIC_SIGMA_VALUE1			(ISP_GIC_BASE + 0x00024)
#define ISP_GIC_SIGMA_VALUE2			(ISP_GIC_BASE + 0x00028)
#define ISP_GIC_SIGMA_VALUE3			(ISP_GIC_BASE + 0x0002c)
#define ISP_GIC_SIGMA_VALUE4			(ISP_GIC_BASE + 0x00030)
#define ISP_GIC_SIGMA_VALUE5			(ISP_GIC_BASE + 0x00034)
#define ISP_GIC_SIGMA_VALUE6			(ISP_GIC_BASE + 0x00038)
#define ISP_GIC_SIGMA_VALUE7			(ISP_GIC_BASE + 0x0003c)
#define ISP_GIC_NOISE_CTRL0			(ISP_GIC_BASE + 0x00040)
#define ISP_GIC_NOISE_CTRL1			(ISP_GIC_BASE + 0x00044)

#define ISP_BLS_BASE				0x00003000
#define ISP_BLS_CTRL				(ISP_BLS_BASE + 0x00000)
#define ISP_BLS_SAMPLES				(ISP_BLS_BASE + 0x00004)
#define ISP_BLS_H1_START			(ISP_BLS_BASE + 0x00008)
#define ISP_BLS_H1_STOP				(ISP_BLS_BASE + 0x0000c)
#define ISP_BLS_V1_START			(ISP_BLS_BASE + 0x00010)
#define ISP_BLS_V1_STOP				(ISP_BLS_BASE + 0x00014)
#define ISP_BLS_H2_START			(ISP_BLS_BASE + 0x00018)
#define ISP_BLS_H2_STOP				(ISP_BLS_BASE + 0x0001c)
#define ISP_BLS_V2_START			(ISP_BLS_BASE + 0x00020)
#define ISP_BLS_V2_STOP				(ISP_BLS_BASE + 0x00024)
#define ISP_BLS_A_FIXED				(ISP_BLS_BASE + 0x00028)
#define ISP_BLS_B_FIXED				(ISP_BLS_BASE + 0x0002c)
#define ISP_BLS_C_FIXED				(ISP_BLS_BASE + 0x00030)
#define ISP_BLS_D_FIXED				(ISP_BLS_BASE + 0x00034)
#define ISP_BLS_A_MEASURED			(ISP_BLS_BASE + 0x00038)
#define ISP_BLS_B_MEASURED			(ISP_BLS_BASE + 0x0003c)
#define ISP_BLS_C_MEASURED			(ISP_BLS_BASE + 0x00040)
#define ISP_BLS_D_MEASURED			(ISP_BLS_BASE + 0x00044)
#define ISP_BLS1_A_FIXED			(ISP_BLS_BASE + 0x00048)
#define ISP_BLS1_B_FIXED			(ISP_BLS_BASE + 0x0004c)
#define ISP_BLS1_C_FIXED			(ISP_BLS_BASE + 0x00050)
#define ISP_BLS1_D_FIXED			(ISP_BLS_BASE + 0x00054)

#define ISP_DPCC0_BASE				0x00003400
#define ISP_DPCC1_BASE				0x00003500
#define ISP_DPCC2_BASE				0x00003600
#define ISP_DPCC0_MODE				(ISP_DPCC0_BASE + 0x00000)
#define ISP_DPCC0_OUTPUT_MODE			(ISP_DPCC0_BASE + 0x00004)
#define ISP_DPCC0_SET_USE			(ISP_DPCC0_BASE + 0x00008)
#define ISP_DPCC0_METHODS_SET_1			(ISP_DPCC0_BASE + 0x0000c)
#define ISP_DPCC0_METHODS_SET_2			(ISP_DPCC0_BASE + 0x00010)
#define ISP_DPCC0_METHODS_SET_3			(ISP_DPCC0_BASE + 0x00014)
#define ISP_DPCC0_LINE_THRESH_1			(ISP_DPCC0_BASE + 0x00018)
#define ISP_DPCC0_LINE_MAD_FAC_1		(ISP_DPCC0_BASE + 0x0001c)
#define ISP_DPCC0_PG_FAC_1			(ISP_DPCC0_BASE + 0x00020)
#define ISP_DPCC0_RND_THRESH_1			(ISP_DPCC0_BASE + 0x00024)
#define ISP_DPCC0_RG_FAC_1			(ISP_DPCC0_BASE + 0x00028)
#define ISP_DPCC0_LINE_THRESH_2			(ISP_DPCC0_BASE + 0x0002c)
#define ISP_DPCC0_LINE_MAD_FAC_2		(ISP_DPCC0_BASE + 0x00030)
#define ISP_DPCC0_PG_FAC_2			(ISP_DPCC0_BASE + 0x00034)
#define ISP_DPCC0_RND_THRESH_2			(ISP_DPCC0_BASE + 0x00038)
#define ISP_DPCC0_RG_FAC_2			(ISP_DPCC0_BASE + 0x0003c)
#define ISP_DPCC0_LINE_THRESH_3			(ISP_DPCC0_BASE + 0x00040)
#define ISP_DPCC0_LINE_MAD_FAC_3		(ISP_DPCC0_BASE + 0x00044)
#define ISP_DPCC0_PG_FAC_3			(ISP_DPCC0_BASE + 0x00048)
#define ISP_DPCC0_RND_THRESH_3			(ISP_DPCC0_BASE + 0x0004c)
#define ISP_DPCC0_RG_FAC_3			(ISP_DPCC0_BASE + 0x00050)
#define ISP_DPCC0_RO_LIMITS			(ISP_DPCC0_BASE + 0x00054)
#define ISP_DPCC0_RND_OFFS			(ISP_DPCC0_BASE + 0x00058)
#define ISP_DPCC0_BPT_CTRL			(ISP_DPCC0_BASE + 0x0005c)
#define ISP_DPCC0_BPT_NUMBER			(ISP_DPCC0_BASE + 0x00060)
#define ISP_DPCC0_BPT_ADDR			(ISP_DPCC0_BASE + 0x00064)
#define ISP_DPCC0_BPT_DATA			(ISP_DPCC0_BASE + 0x00068)
#define ISP_DPCC0_BP_CNT			(ISP_DPCC0_BASE + 0x0006c)
#define ISP_DPCC0_PDAF_EN			(ISP_DPCC0_BASE + 0x00070)
#define ISP_DPCC0_PDAF_POINT_EN			(ISP_DPCC0_BASE + 0x00074)
#define ISP_DPCC0_PDAF_OFFSET			(ISP_DPCC0_BASE + 0x00078)
#define ISP_DPCC0_PDAF_WRAP			(ISP_DPCC0_BASE + 0x0007c)
#define ISP_DPCC0_PDAF_SCOPE			(ISP_DPCC0_BASE + 0x00080)
#define ISP_DPCC0_PDAF_POINT_0			(ISP_DPCC0_BASE + 0x00084)
#define ISP_DPCC0_PDAF_POINT_1			(ISP_DPCC0_BASE + 0x00088)
#define ISP_DPCC0_PDAF_POINT_2			(ISP_DPCC0_BASE + 0x0008c)
#define ISP_DPCC0_PDAF_POINT_3			(ISP_DPCC0_BASE + 0x00090)
#define ISP_DPCC0_PDAF_POINT_4			(ISP_DPCC0_BASE + 0x00094)
#define ISP_DPCC0_PDAF_POINT_5			(ISP_DPCC0_BASE + 0x00098)
#define ISP_DPCC0_PDAF_POINT_6			(ISP_DPCC0_BASE + 0x0009c)
#define ISP_DPCC0_PDAF_POINT_7			(ISP_DPCC0_BASE + 0x000a0)
#define ISP_DPCC0_PDAF_FORWARD_MED		(ISP_DPCC0_BASE + 0x000a4)

#define ISP_DPCC1_MODE				(ISP_DPCC1_BASE + 0x00000)
#define ISP_DPCC1_OUTPUT_MODE			(ISP_DPCC1_BASE + 0x00004)
#define ISP_DPCC1_SET_USE			(ISP_DPCC1_BASE + 0x00008)
#define ISP_DPCC1_METHODS_SET_1			(ISP_DPCC1_BASE + 0x0000c)
#define ISP_DPCC1_METHODS_SET_2			(ISP_DPCC1_BASE + 0x00010)
#define ISP_DPCC1_METHODS_SET_3			(ISP_DPCC1_BASE + 0x00014)
#define ISP_DPCC1_LINE_THRESH_1			(ISP_DPCC1_BASE + 0x00018)
#define ISP_DPCC1_LINE_MAD_FAC_1		(ISP_DPCC1_BASE + 0x0001c)
#define ISP_DPCC1_PG_FAC_1			(ISP_DPCC1_BASE + 0x00020)
#define ISP_DPCC1_RND_THRESH_1			(ISP_DPCC1_BASE + 0x00024)
#define ISP_DPCC1_RG_FAC_1			(ISP_DPCC1_BASE + 0x00028)
#define ISP_DPCC1_LINE_THRESH_2			(ISP_DPCC1_BASE + 0x0002c)
#define ISP_DPCC1_LINE_MAD_FAC_2		(ISP_DPCC1_BASE + 0x00030)
#define ISP_DPCC1_PG_FAC_2			(ISP_DPCC1_BASE + 0x00034)
#define ISP_DPCC1_RND_THRESH_2			(ISP_DPCC1_BASE + 0x00038)
#define ISP_DPCC1_RG_FAC_2			(ISP_DPCC1_BASE + 0x0003c)
#define ISP_DPCC1_LINE_THRESH_3			(ISP_DPCC1_BASE + 0x00040)
#define ISP_DPCC1_LINE_MAD_FAC_3		(ISP_DPCC1_BASE + 0x00044)
#define ISP_DPCC1_PG_FAC_3			(ISP_DPCC1_BASE + 0x00048)
#define ISP_DPCC1_RND_THRESH_3			(ISP_DPCC1_BASE + 0x0004c)
#define ISP_DPCC1_RG_FAC_3			(ISP_DPCC1_BASE + 0x00050)
#define ISP_DPCC1_RO_LIMITS			(ISP_DPCC1_BASE + 0x00054)
#define ISP_DPCC1_RND_OFFS			(ISP_DPCC1_BASE + 0x00058)
#define ISP_DPCC1_BPT_CTRL			(ISP_DPCC1_BASE + 0x0005c)
#define ISP_DPCC1_BPT_NUMBER			(ISP_DPCC1_BASE + 0x00060)
#define ISP_DPCC1_BPT_ADDR			(ISP_DPCC1_BASE + 0x00064)
#define ISP_DPCC1_BPT_DATA			(ISP_DPCC1_BASE + 0x00068)
#define ISP_DPCC1_BP_CNT			(ISP_DPCC1_BASE + 0x0006c)
#define ISP_DPCC1_PDAF_EN			(ISP_DPCC1_BASE + 0x00070)
#define ISP_DPCC1_PDAF_POINT_EN			(ISP_DPCC1_BASE + 0x00074)
#define ISP_DPCC1_PDAF_OFFSET			(ISP_DPCC1_BASE + 0x00078)
#define ISP_DPCC1_PDAF_WRAP			(ISP_DPCC1_BASE + 0x0007c)
#define ISP_DPCC1_PDAF_SCOPE			(ISP_DPCC1_BASE + 0x00080)
#define ISP_DPCC1_PDAF_POINT_0			(ISP_DPCC1_BASE + 0x00084)
#define ISP_DPCC1_PDAF_POINT_1			(ISP_DPCC1_BASE + 0x00088)
#define ISP_DPCC1_PDAF_POINT_2			(ISP_DPCC1_BASE + 0x0008c)
#define ISP_DPCC1_PDAF_POINT_3			(ISP_DPCC1_BASE + 0x00090)
#define ISP_DPCC1_PDAF_POINT_4			(ISP_DPCC1_BASE + 0x00094)
#define ISP_DPCC1_PDAF_POINT_5			(ISP_DPCC1_BASE + 0x00098)
#define ISP_DPCC1_PDAF_POINT_6			(ISP_DPCC1_BASE + 0x0009c)
#define ISP_DPCC1_PDAF_POINT_7			(ISP_DPCC1_BASE + 0x000a0)
#define ISP_DPCC1_PDAF_FORWARD_MED		(ISP_DPCC1_BASE + 0x000a4)

#define ISP_DPCC2_MODE				(ISP_DPCC2_BASE + 0x00000)
#define ISP_DPCC2_OUTPUT_MODE			(ISP_DPCC2_BASE + 0x00004)
#define ISP_DPCC2_SET_USE			(ISP_DPCC2_BASE + 0x00008)
#define ISP_DPCC2_METHODS_SET_1			(ISP_DPCC2_BASE + 0x0000c)
#define ISP_DPCC2_METHODS_SET_2			(ISP_DPCC2_BASE + 0x00010)
#define ISP_DPCC2_METHODS_SET_3			(ISP_DPCC2_BASE + 0x00014)
#define ISP_DPCC2_LINE_THRESH_1			(ISP_DPCC2_BASE + 0x00018)
#define ISP_DPCC2_LINE_MAD_FAC_1		(ISP_DPCC2_BASE + 0x0001c)
#define ISP_DPCC2_PG_FAC_1			(ISP_DPCC2_BASE + 0x00020)
#define ISP_DPCC2_RND_THRESH_1			(ISP_DPCC2_BASE + 0x00024)
#define ISP_DPCC2_RG_FAC_1			(ISP_DPCC2_BASE + 0x00028)
#define ISP_DPCC2_LINE_THRESH_2			(ISP_DPCC2_BASE + 0x0002c)
#define ISP_DPCC2_LINE_MAD_FAC_2		(ISP_DPCC2_BASE + 0x00030)
#define ISP_DPCC2_PG_FAC_2			(ISP_DPCC2_BASE + 0x00034)
#define ISP_DPCC2_RND_THRESH_2			(ISP_DPCC2_BASE + 0x00038)
#define ISP_DPCC2_RG_FAC_2			(ISP_DPCC2_BASE + 0x0003c)
#define ISP_DPCC2_LINE_THRESH_3			(ISP_DPCC2_BASE + 0x00040)
#define ISP_DPCC2_LINE_MAD_FAC_3		(ISP_DPCC2_BASE + 0x00044)
#define ISP_DPCC2_PG_FAC_3			(ISP_DPCC2_BASE + 0x00048)
#define ISP_DPCC2_RND_THRESH_3			(ISP_DPCC2_BASE + 0x0004c)
#define ISP_DPCC2_RG_FAC_3			(ISP_DPCC2_BASE + 0x00050)
#define ISP_DPCC2_RO_LIMITS			(ISP_DPCC2_BASE + 0x00054)
#define ISP_DPCC2_RND_OFFS			(ISP_DPCC2_BASE + 0x00058)
#define ISP_DPCC2_BPT_CTRL			(ISP_DPCC2_BASE + 0x0005c)
#define ISP_DPCC2_BPT_NUMBER			(ISP_DPCC2_BASE + 0x00060)
#define ISP_DPCC2_BPT_ADDR			(ISP_DPCC2_BASE + 0x00064)
#define ISP_DPCC2_BPT_DATA			(ISP_DPCC2_BASE + 0x00068)
#define ISP_DPCC2_BP_CNT			(ISP_DPCC2_BASE + 0x0006c)
#define ISP_DPCC2_PDAF_EN			(ISP_DPCC2_BASE + 0x00070)
#define ISP_DPCC2_PDAF_POINT_EN			(ISP_DPCC2_BASE + 0x00074)
#define ISP_DPCC2_PDAF_OFFSET			(ISP_DPCC2_BASE + 0x00078)
#define ISP_DPCC2_PDAF_WRAP			(ISP_DPCC2_BASE + 0x0007c)
#define ISP_DPCC2_PDAF_SCOPE			(ISP_DPCC2_BASE + 0x00080)
#define ISP_DPCC2_PDAF_POINT_0			(ISP_DPCC2_BASE + 0x00084)
#define ISP_DPCC2_PDAF_POINT_1			(ISP_DPCC2_BASE + 0x00088)
#define ISP_DPCC2_PDAF_POINT_2			(ISP_DPCC2_BASE + 0x0008c)
#define ISP_DPCC2_PDAF_POINT_3			(ISP_DPCC2_BASE + 0x00090)
#define ISP_DPCC2_PDAF_POINT_4			(ISP_DPCC2_BASE + 0x00094)
#define ISP_DPCC2_PDAF_POINT_5			(ISP_DPCC2_BASE + 0x00098)
#define ISP_DPCC2_PDAF_POINT_6			(ISP_DPCC2_BASE + 0x0009c)
#define ISP_DPCC2_PDAF_POINT_7			(ISP_DPCC2_BASE + 0x000a0)
#define ISP_DPCC2_PDAF_FORWARD_MED		(ISP_DPCC2_BASE + 0x000a4)

#define ISP_HDRMGE_BASE				0x00003800
#define ISP_HDRMGE_CTRL				(ISP_HDRMGE_BASE + 0x00000)
#define ISP_HDRMGE_GAIN0			(ISP_HDRMGE_BASE + 0x00008)
#define ISP_HDRMGE_GAIN1			(ISP_HDRMGE_BASE + 0x0000c)
#define ISP_HDRMGE_GAIN2			(ISP_HDRMGE_BASE + 0x00010)
#define ISP_HDRMGE_CONS_DIFF			(ISP_HDRMGE_BASE + 0x00014)
#define ISP_HDRMGE_DIFF_Y0			(ISP_HDRMGE_BASE + 0x00020)
#define ISP_HDRMGE_DIFF_Y1			(ISP_HDRMGE_BASE + 0x00024)
#define ISP_HDRMGE_DIFF_Y2			(ISP_HDRMGE_BASE + 0x00028)
#define ISP_HDRMGE_DIFF_Y3			(ISP_HDRMGE_BASE + 0x0002c)
#define ISP_HDRMGE_DIFF_Y4			(ISP_HDRMGE_BASE + 0x00030)
#define ISP_HDRMGE_DIFF_Y5			(ISP_HDRMGE_BASE + 0x00034)
#define ISP_HDRMGE_DIFF_Y6			(ISP_HDRMGE_BASE + 0x00038)
#define ISP_HDRMGE_DIFF_Y7			(ISP_HDRMGE_BASE + 0x0003c)
#define ISP_HDRMGE_DIFF_Y8			(ISP_HDRMGE_BASE + 0x00040)
#define ISP_HDRMGE_DIFF_Y9			(ISP_HDRMGE_BASE + 0x00044)
#define ISP_HDRMGE_DIFF_Y10			(ISP_HDRMGE_BASE + 0x00048)
#define ISP_HDRMGE_DIFF_Y11			(ISP_HDRMGE_BASE + 0x0004c)
#define ISP_HDRMGE_DIFF_Y12			(ISP_HDRMGE_BASE + 0x00050)
#define ISP_HDRMGE_DIFF_Y13			(ISP_HDRMGE_BASE + 0x00054)
#define ISP_HDRMGE_DIFF_Y14			(ISP_HDRMGE_BASE + 0x00058)
#define ISP_HDRMGE_DIFF_Y15			(ISP_HDRMGE_BASE + 0x0005c)
#define ISP_HDRMGE_DIFF_Y16			(ISP_HDRMGE_BASE + 0x00060)
#define ISP_HDRMGE_OVER_Y0			(ISP_HDRMGE_BASE + 0x00070)
#define ISP_HDRMGE_OVER_Y1			(ISP_HDRMGE_BASE + 0x00074)
#define ISP_HDRMGE_OVER_Y2			(ISP_HDRMGE_BASE + 0x00078)
#define ISP_HDRMGE_OVER_Y3			(ISP_HDRMGE_BASE + 0x0007c)
#define ISP_HDRMGE_OVER_Y4			(ISP_HDRMGE_BASE + 0x00080)
#define ISP_HDRMGE_OVER_Y5			(ISP_HDRMGE_BASE + 0x00084)
#define ISP_HDRMGE_OVER_Y6			(ISP_HDRMGE_BASE + 0x00088)
#define ISP_HDRMGE_OVER_Y7			(ISP_HDRMGE_BASE + 0x0008c)
#define ISP_HDRMGE_OVER_Y8			(ISP_HDRMGE_BASE + 0x00090)
#define ISP_HDRMGE_OVER_Y9			(ISP_HDRMGE_BASE + 0x00094)
#define ISP_HDRMGE_OVER_Y10			(ISP_HDRMGE_BASE + 0x00098)
#define ISP_HDRMGE_OVER_Y11			(ISP_HDRMGE_BASE + 0x0009c)
#define ISP_HDRMGE_OVER_Y12			(ISP_HDRMGE_BASE + 0x000a0)
#define ISP_HDRMGE_OVER_Y13			(ISP_HDRMGE_BASE + 0x000a4)
#define ISP_HDRMGE_OVER_Y14			(ISP_HDRMGE_BASE + 0x000a8)
#define ISP_HDRMGE_OVER_Y15			(ISP_HDRMGE_BASE + 0x000ac)
#define ISP_HDRMGE_OVER_Y16			(ISP_HDRMGE_BASE + 0x000b0)

#define ISP_HDRTMO_BASE				0x00003900
#define ISP_HDRTMO_CTRL				(ISP_HDRTMO_BASE + 0x00000)
#define ISP_HDRTMO_CTRL_CFG			(ISP_HDRTMO_BASE + 0x00004)
#define ISP_HDRTMO_LG_CFG0			(ISP_HDRTMO_BASE + 0x00008)
#define ISP_HDRTMO_LG_CFG1			(ISP_HDRTMO_BASE + 0x0000c)
#define ISP_HDRTMO_LG_CFG2			(ISP_HDRTMO_BASE + 0x00010)
#define ISP_HDRTMO_LG_CFG3			(ISP_HDRTMO_BASE + 0x00014)
#define ISP_HDRTMO_LG_CFG4			(ISP_HDRTMO_BASE + 0x00018)
#define ISP_HDRTMO_CLIPRATIO			(ISP_HDRTMO_BASE + 0x00020)
#define ISP_HDRTMO_LG_SCL			(ISP_HDRTMO_BASE + 0x00024)
#define ISP_HDRTMO_LG_MAX			(ISP_HDRTMO_BASE + 0x00028)
#define ISP_HDRTMO_HIST_LOW			(ISP_HDRTMO_BASE + 0x0002c)
#define ISP_HDRTMO_HIST_HIGH			(ISP_HDRTMO_BASE + 0x00030)
#define ISP_HDRTMO_PALPHA			(ISP_HDRTMO_BASE + 0x00034)
#define ISP_HDRTMO_MAXGAIN			(ISP_HDRTMO_BASE + 0x00038)
#define ISP_HDRTMO_LG_RO0			(ISP_HDRTMO_BASE + 0x00040)
#define ISP_HDRTMO_LG_RO1			(ISP_HDRTMO_BASE + 0x00044)
#define ISP_HDRTMO_LG_RO2			(ISP_HDRTMO_BASE + 0x00048)
#define ISP_HDRTMO_LG_RO3			(ISP_HDRTMO_BASE + 0x0004c)
#define ISP_HDRTMO_LG_RO4			(ISP_HDRTMO_BASE + 0x00050)
#define ISP_HDRTMO_LG_RO5			(ISP_HDRTMO_BASE + 0x00054)
#define ISP_HDRTMO_HIST_RO0			(ISP_HDRTMO_BASE + 0x00060)
#define ISP_HDRTMO_HIST_RO1			(ISP_HDRTMO_BASE + 0x00064)
#define ISP_HDRTMO_HIST_RO2			(ISP_HDRTMO_BASE + 0x00068)
#define ISP_HDRTMO_HIST_RO3			(ISP_HDRTMO_BASE + 0x0006c)
#define ISP_HDRTMO_HIST_RO4			(ISP_HDRTMO_BASE + 0x00070)
#define ISP_HDRTMO_HIST_RO5			(ISP_HDRTMO_BASE + 0x00074)
#define ISP_HDRTMO_HIST_RO6			(ISP_HDRTMO_BASE + 0x00078)
#define ISP_HDRTMO_HIST_RO7			(ISP_HDRTMO_BASE + 0x0007c)
#define ISP_HDRTMO_HIST_RO8			(ISP_HDRTMO_BASE + 0x00080)
#define ISP_HDRTMO_HIST_RO9			(ISP_HDRTMO_BASE + 0x00084)
#define ISP_HDRTMO_HIST_RO10			(ISP_HDRTMO_BASE + 0x00088)
#define ISP_HDRTMO_HIST_RO11			(ISP_HDRTMO_BASE + 0x0008c)
#define ISP_HDRTMO_HIST_RO12			(ISP_HDRTMO_BASE + 0x00090)
#define ISP_HDRTMO_HIST_RO13			(ISP_HDRTMO_BASE + 0x00094)
#define ISP_HDRTMO_HIST_RO14			(ISP_HDRTMO_BASE + 0x00098)
#define ISP_HDRTMO_HIST_RO15			(ISP_HDRTMO_BASE + 0x0009c)
#define ISP_HDRTMO_HIST_RO16			(ISP_HDRTMO_BASE + 0x000a0)
#define ISP_HDRTMO_HIST_RO17			(ISP_HDRTMO_BASE + 0x000a4)
#define ISP_HDRTMO_HIST_RO18			(ISP_HDRTMO_BASE + 0x000a8)
#define ISP_HDRTMO_HIST_RO19			(ISP_HDRTMO_BASE + 0x000ac)
#define ISP_HDRTMO_HIST_RO20			(ISP_HDRTMO_BASE + 0x000b0)
#define ISP_HDRTMO_HIST_RO21			(ISP_HDRTMO_BASE + 0x000b4)
#define ISP_HDRTMO_HIST_RO22			(ISP_HDRTMO_BASE + 0x000b8)
#define ISP_HDRTMO_HIST_RO23			(ISP_HDRTMO_BASE + 0x000bc)
#define ISP_HDRTMO_HIST_RO24			(ISP_HDRTMO_BASE + 0x000c0)
#define ISP_HDRTMO_HIST_RO25			(ISP_HDRTMO_BASE + 0x000c4)
#define ISP_HDRTMO_HIST_RO26			(ISP_HDRTMO_BASE + 0x000c8)
#define ISP_HDRTMO_HIST_RO27			(ISP_HDRTMO_BASE + 0x000cc)
#define ISP_HDRTMO_HIST_RO28			(ISP_HDRTMO_BASE + 0x000d0)
#define ISP_HDRTMO_HIST_RO29			(ISP_HDRTMO_BASE + 0x000d4)
#define ISP_HDRTMO_HIST_RO30			(ISP_HDRTMO_BASE + 0x000d8)
#define ISP_HDRTMO_HIST_RO31			(ISP_HDRTMO_BASE + 0x000dc)

#define ISP21_DRC_BASE				0x00003900
#define ISP21_DRC_CTRL0				(ISP21_DRC_BASE + 0x00000)
#define ISP21_DRC_CTRL1				(ISP21_DRC_BASE + 0x00004)
#define ISP21_DRC_LPRATIO			(ISP21_DRC_BASE + 0x00008)
#define ISP21_DRC_EXPLRATIO			(ISP21_DRC_BASE + 0x0000c)
#define ISP21_DRC_SIGMA				(ISP21_DRC_BASE + 0x00010)
#define ISP21_DRC_SPACESGM			(ISP21_DRC_BASE + 0x00014)
#define ISP21_DRC_RANESGM			(ISP21_DRC_BASE + 0x00018)
#define ISP21_DRC_BILAT				(ISP21_DRC_BASE + 0x0001c)
#define ISP21_DRC_GAIN_Y0			(ISP21_DRC_BASE + 0x00020)
#define ISP21_DRC_GAIN_Y1			(ISP21_DRC_BASE + 0x00024)
#define ISP21_DRC_GAIN_Y2			(ISP21_DRC_BASE + 0x00028)
#define ISP21_DRC_GAIN_Y3			(ISP21_DRC_BASE + 0x0002c)
#define ISP21_DRC_GAIN_Y4			(ISP21_DRC_BASE + 0x00030)
#define ISP21_DRC_GAIN_Y5			(ISP21_DRC_BASE + 0x00034)
#define ISP21_DRC_GAIN_Y6			(ISP21_DRC_BASE + 0x00038)
#define ISP21_DRC_GAIN_Y7			(ISP21_DRC_BASE + 0x0003c)
#define ISP21_DRC_GAIN_Y8			(ISP21_DRC_BASE + 0x00040)
#define ISP21_DRC_COMPRES_Y0			(ISP21_DRC_BASE + 0x00044)
#define ISP21_DRC_COMPRES_Y1			(ISP21_DRC_BASE + 0x00048)
#define ISP21_DRC_COMPRES_Y2			(ISP21_DRC_BASE + 0x0004c)
#define ISP21_DRC_COMPRES_Y3			(ISP21_DRC_BASE + 0x00050)
#define ISP21_DRC_COMPRES_Y4			(ISP21_DRC_BASE + 0x00054)
#define ISP21_DRC_COMPRES_Y5			(ISP21_DRC_BASE + 0x00058)
#define ISP21_DRC_COMPRES_Y6			(ISP21_DRC_BASE + 0x0005c)
#define ISP21_DRC_COMPRES_Y7			(ISP21_DRC_BASE + 0x00060)
#define ISP21_DRC_COMPRES_Y8			(ISP21_DRC_BASE + 0x00064)
#define ISP21_DRC_SCALE_Y0			(ISP21_DRC_BASE + 0x00068)
#define ISP21_DRC_SCALE_Y1			(ISP21_DRC_BASE + 0x0006c)
#define ISP21_DRC_SCALE_Y2			(ISP21_DRC_BASE + 0x00070)
#define ISP21_DRC_SCALE_Y3			(ISP21_DRC_BASE + 0x00074)
#define ISP21_DRC_SCALE_Y4			(ISP21_DRC_BASE + 0x00078)
#define ISP21_DRC_SCALE_Y5			(ISP21_DRC_BASE + 0x0007c)
#define ISP21_DRC_SCALE_Y6			(ISP21_DRC_BASE + 0x00080)
#define ISP21_DRC_SCALE_Y7			(ISP21_DRC_BASE + 0x00084)
#define ISP21_DRC_SCALE_Y8			(ISP21_DRC_BASE + 0x00088)
#define ISP21_DRC_IIRWG_GAIN			(ISP21_DRC_BASE + 0x0008c)

#define ISP_RAWNR_BASE				0x00003A00
#define ISP_RAWNR_CTRL				(ISP_RAWNR_BASE + 0x00000)
#define ISP_RAWNR_FILTPAR0			(ISP_RAWNR_BASE + 0x00008)
#define ISP_RAWNR_FILTPAR1			(ISP_RAWNR_BASE + 0x0000c)
#define ISP_RAWNR_FILTPAR2			(ISP_RAWNR_BASE + 0x00010)
#define ISP_RAWNR_DGAIN0			(ISP_RAWNR_BASE + 0x00014)
#define ISP_RAWNR_DGAIN1			(ISP_RAWNR_BASE + 0x00018)
#define ISP_RAWNR_DGAIN2			(ISP_RAWNR_BASE + 0x0001c)
#define ISP_RAWNR_LURTION0_1			(ISP_RAWNR_BASE + 0x00020)
#define ISP_RAWNR_LURTION3_2			(ISP_RAWNR_BASE + 0x00024)
#define ISP_RAWNR_LURTION5_4			(ISP_RAWNR_BASE + 0x00028)
#define ISP_RAWNR_LURTION6_7			(ISP_RAWNR_BASE + 0x0002c)
#define ISP_RAWNR_LULEVEL0_1			(ISP_RAWNR_BASE + 0x00030)
#define ISP_RAWNR_LULEVEL2_3			(ISP_RAWNR_BASE + 0x00034)
#define ISP_RAWNR_LULEVEL4_5			(ISP_RAWNR_BASE + 0x00038)
#define ISP_RAWNR_LULEVEL6_7			(ISP_RAWNR_BASE + 0x0003c)
#define ISP_RAWNR_GAUSS				(ISP_RAWNR_BASE + 0x00040)
#define ISP_RAWNR_SIGMA				(ISP_RAWNR_BASE + 0x00044)
#define ISP_RAWNR_PIX_DIFF			(ISP_RAWNR_BASE + 0x00048)
#define ISP_RAWNR_HILD_DIFF			(ISP_RAWNR_BASE + 0x0004c)
#define ISP_RAWNR_THLD_CHANELW			(ISP_RAWNR_BASE + 0x00050)
#define ISP_RAWNR_LAMDA				(ISP_RAWNR_BASE + 0x00054)
#define ISP_RAWNR_FIXW0_1			(ISP_RAWNR_BASE + 0x00058)
#define ISP_RAWNR_FIXW2_3			(ISP_RAWNR_BASE + 0x0005c)
#define ISP_RAWNR_WLAMDA0			(ISP_RAWNR_BASE + 0x00060)
#define ISP_RAWNR_WLAMDA1			(ISP_RAWNR_BASE + 0x00064)
#define ISP_RAWNR_WLAMDA2			(ISP_RAWNR_BASE + 0x00068)
#define ISP_RAWNR_RGBAIN_FLIP			(ISP_RAWNR_BASE + 0x0006c)

#define ISP21_BAYNR_CTRL			(ISP_RAWNR_BASE + 0x00000)
#define ISP21_BAYNR_DGAIN0			(ISP_RAWNR_BASE + 0x00004)
#define ISP21_BAYNR_DGAIN1			(ISP_RAWNR_BASE + 0x00008)
#define ISP21_BAYNR_PIXDIFF			(ISP_RAWNR_BASE + 0x0000c)
#define ISP21_BAYNR_THLD			(ISP_RAWNR_BASE + 0x00010)
#define ISP21_BAYNR_W1_STRENG			(ISP_RAWNR_BASE + 0x00014)
#define ISP21_BAYNR_SIGMAX01			(ISP_RAWNR_BASE + 0x00018)
#define ISP21_BAYNR_SIGMAX23			(ISP_RAWNR_BASE + 0x0001c)
#define ISP21_BAYNR_SIGMAX45			(ISP_RAWNR_BASE + 0x00020)
#define ISP21_BAYNR_SIGMAX67			(ISP_RAWNR_BASE + 0x00024)
#define ISP21_BAYNR_SIGMAX89			(ISP_RAWNR_BASE + 0x00028)
#define ISP21_BAYNR_SIGMAX1011			(ISP_RAWNR_BASE + 0x0002c)
#define ISP21_BAYNR_SIGMAX1213			(ISP_RAWNR_BASE + 0x00030)
#define ISP21_BAYNR_SIGMAX1415			(ISP_RAWNR_BASE + 0x00034)
#define ISP21_BAYNR_SIGMAY01			(ISP_RAWNR_BASE + 0x00038)
#define ISP21_BAYNR_SIGMAY23			(ISP_RAWNR_BASE + 0x0003c)
#define ISP21_BAYNR_SIGMAY45			(ISP_RAWNR_BASE + 0x00040)
#define ISP21_BAYNR_SIGMAY67			(ISP_RAWNR_BASE + 0x00044)
#define ISP21_BAYNR_SIGMAY89			(ISP_RAWNR_BASE + 0x00048)
#define ISP21_BAYNR_SIGMAY1011			(ISP_RAWNR_BASE + 0x0004c)
#define ISP21_BAYNR_SIGMAY1213			(ISP_RAWNR_BASE + 0x00050)
#define ISP21_BAYNR_SIGMAY1415			(ISP_RAWNR_BASE + 0x00054)
#define ISP21_BAYNR_WRIT_D			(ISP_RAWNR_BASE + 0x00058)

#define ISP21_BAY3D_BASE			0x00003A00
#define ISP21_BAY3D_CTRL			(ISP21_BAY3D_BASE + 0x00080)
#define ISP21_BAY3D_KALRATIO			(ISP21_BAY3D_BASE + 0x00084)
#define ISP21_BAY3D_GLBPK2			(ISP21_BAY3D_BASE + 0x00088)
#define ISP21_BAY3D_KALSTR			(ISP21_BAY3D_BASE + 0x0008c)
#define ISP21_BAY3D_WGTLMT			(ISP21_BAY3D_BASE + 0x00090)
#define ISP21_BAY3D_SIG_X0			(ISP21_BAY3D_BASE + 0x00094)
#define ISP21_BAY3D_SIG_X1			(ISP21_BAY3D_BASE + 0x00098)
#define ISP21_BAY3D_SIG_X2			(ISP21_BAY3D_BASE + 0x0009c)
#define ISP21_BAY3D_SIG_X3			(ISP21_BAY3D_BASE + 0x000a0)
#define ISP21_BAY3D_SIG_X4			(ISP21_BAY3D_BASE + 0x000a4)
#define ISP21_BAY3D_SIG_X5			(ISP21_BAY3D_BASE + 0x000a8)
#define ISP21_BAY3D_SIG_X6			(ISP21_BAY3D_BASE + 0x000ac)
#define ISP21_BAY3D_SIG_X7			(ISP21_BAY3D_BASE + 0x000b0)
#define ISP21_BAY3D_SIG_Y0			(ISP21_BAY3D_BASE + 0x000b4)
#define ISP21_BAY3D_SIG_Y1			(ISP21_BAY3D_BASE + 0x000b8)
#define ISP21_BAY3D_SIG_Y2			(ISP21_BAY3D_BASE + 0x000bc)
#define ISP21_BAY3D_SIG_Y3			(ISP21_BAY3D_BASE + 0x000c0)
#define ISP21_BAY3D_SIG_Y4			(ISP21_BAY3D_BASE + 0x000c4)
#define ISP21_BAY3D_SIG_Y5			(ISP21_BAY3D_BASE + 0x000c8)
#define ISP21_BAY3D_SIG_Y6			(ISP21_BAY3D_BASE + 0x000cc)
#define ISP21_BAY3D_SIG_Y7			(ISP21_BAY3D_BASE + 0x000d0)

#define ISP_LDCH_BASE				0x00003B00
#define ISP_LDCH_STS				(ISP_LDCH_BASE + 0x00000)

#define ISP_DHAZ_BASE				0x00003C00
#define ISP_DHAZ_CTRL				(ISP_DHAZ_BASE + 0x00000)
#define ISP_DHAZ_ADP0				(ISP_DHAZ_BASE + 0x00004)
#define ISP_DHAZ_ADP1				(ISP_DHAZ_BASE + 0x00008)
#define ISP_DHAZ_ADP2				(ISP_DHAZ_BASE + 0x0000c)
#define ISP_DHAZ_ADP_TMAX			(ISP_DHAZ_BASE + 0x00010)
#define ISP_DHAZ_ADP_HIST0			(ISP_DHAZ_BASE + 0x00014)
#define ISP_DHAZ_ADP_HIST1			(ISP_DHAZ_BASE + 0x00018)
#define ISP_DHAZ_HIST_ENH			(ISP_DHAZ_BASE + 0x0001c)
#define ISP_DHAZ_IIR0				(ISP_DHAZ_BASE + 0x00020)
#define ISP_DHAZ_IIR1				(ISP_DHAZ_BASE + 0x00024)
#define ISP_DHAZ_ALPHA0				(ISP_DHAZ_BASE + 0x00028)
#define ISP_DHAZ_ALPHA1				(ISP_DHAZ_BASE + 0x0002c)
#define ISP_DHAZ_BI_DC				(ISP_DHAZ_BASE + 0x00030)
#define ISP_DHAZ_DC_BF0				(ISP_DHAZ_BASE + 0x00034)
#define ISP_DHAZ_DC_BF1				(ISP_DHAZ_BASE + 0x00038)
#define ISP_DHAZ_BI_AIR				(ISP_DHAZ_BASE + 0x0003c)
#define ISP_DHAZ_AIR_BF				(ISP_DHAZ_BASE + 0x00040)
#define ISP_DHAZ_GAUS				(ISP_DHAZ_BASE + 0x00044)
#define ISP_DHAZ_HIST_CONV0			(ISP_DHAZ_BASE + 0x00048)
#define ISP_DHAZ_HIST_CONV1			(ISP_DHAZ_BASE + 0x0004c)
#define ISP_DHAZ_HIST_CONV2			(ISP_DHAZ_BASE + 0x00050)
#define ISP_DHAZ_CTRL_SHD			(ISP_DHAZ_BASE + 0x00060)
#define ISP_DHAZ_ADP_RD0			(ISP_DHAZ_BASE + 0x00064)
#define ISP_DHAZ_ADP_RD1			(ISP_DHAZ_BASE + 0x00068)
#define ISP_DHAZ_HIST_REG0			(ISP_DHAZ_BASE + 0x00070)
#define ISP_DHAZ_HIST_REG1			(ISP_DHAZ_BASE + 0x00074)
#define ISP_DHAZ_HIST_REG2			(ISP_DHAZ_BASE + 0x00078)
#define ISP_DHAZ_HIST_REG3			(ISP_DHAZ_BASE + 0x0007c)
#define ISP_DHAZ_HIST_REG4			(ISP_DHAZ_BASE + 0x00080)
#define ISP_DHAZ_HIST_REG5			(ISP_DHAZ_BASE + 0x00084)
#define ISP_DHAZ_HIST_REG6			(ISP_DHAZ_BASE + 0x00088)
#define ISP_DHAZ_HIST_REG7			(ISP_DHAZ_BASE + 0x0008c)
#define ISP_DHAZ_HIST_REG8			(ISP_DHAZ_BASE + 0x00090)
#define ISP_DHAZ_HIST_REG9			(ISP_DHAZ_BASE + 0x00094)
#define ISP_DHAZ_HIST_REG10			(ISP_DHAZ_BASE + 0x00098)
#define ISP_DHAZ_HIST_REG11			(ISP_DHAZ_BASE + 0x0009c)
#define ISP_DHAZ_HIST_REG12			(ISP_DHAZ_BASE + 0x000a0)
#define ISP_DHAZ_HIST_REG13			(ISP_DHAZ_BASE + 0x000a4)
#define ISP_DHAZ_HIST_REG14			(ISP_DHAZ_BASE + 0x000a8)
#define ISP_DHAZ_HIST_REG15			(ISP_DHAZ_BASE + 0x000ac)
#define ISP_DHAZ_HIST_REG16			(ISP_DHAZ_BASE + 0x000b0)
#define ISP_DHAZ_HIST_REG17			(ISP_DHAZ_BASE + 0x000b4)
#define ISP_DHAZ_HIST_REG18			(ISP_DHAZ_BASE + 0x000b8)
#define ISP_DHAZ_HIST_REG19			(ISP_DHAZ_BASE + 0x000bc)
#define ISP_DHAZ_HIST_REG20			(ISP_DHAZ_BASE + 0x000c0)
#define ISP_DHAZ_HIST_REG21			(ISP_DHAZ_BASE + 0x000c4)
#define ISP_DHAZ_HIST_REG22			(ISP_DHAZ_BASE + 0x000c8)
#define ISP_DHAZ_HIST_REG23			(ISP_DHAZ_BASE + 0x000cc)
#define ISP_DHAZ_HIST_REG24			(ISP_DHAZ_BASE + 0x000d0)
#define ISP_DHAZ_HIST_REG25			(ISP_DHAZ_BASE + 0x000d4)
#define ISP_DHAZ_HIST_REG26			(ISP_DHAZ_BASE + 0x000d8)
#define ISP_DHAZ_HIST_REG27			(ISP_DHAZ_BASE + 0x000dc)
#define ISP_DHAZ_HIST_REG28			(ISP_DHAZ_BASE + 0x000e0)
#define ISP_DHAZ_HIST_REG29			(ISP_DHAZ_BASE + 0x000e4)
#define ISP_DHAZ_HIST_REG30			(ISP_DHAZ_BASE + 0x000e8)
#define ISP_DHAZ_HIST_REG31			(ISP_DHAZ_BASE + 0x000ec)
#define ISP_DHAZ_HIST_REG32			(ISP_DHAZ_BASE + 0x000f0)
#define ISP_DHAZ_HIST_REG33			(ISP_DHAZ_BASE + 0x000f4)
#define ISP_DHAZ_HIST_REG34			(ISP_DHAZ_BASE + 0x000f8)
#define ISP_DHAZ_HIST_REG35			(ISP_DHAZ_BASE + 0x000fc)
#define ISP_DHAZ_HIST_REG36			(ISP_DHAZ_BASE + 0x00100)
#define ISP_DHAZ_HIST_REG37			(ISP_DHAZ_BASE + 0x00104)
#define ISP_DHAZ_HIST_REG38			(ISP_DHAZ_BASE + 0x00108)
#define ISP_DHAZ_HIST_REG39			(ISP_DHAZ_BASE + 0x0010c)
#define ISP_DHAZ_HIST_REG40			(ISP_DHAZ_BASE + 0x00110)
#define ISP_DHAZ_HIST_REG41			(ISP_DHAZ_BASE + 0x00114)
#define ISP_DHAZ_HIST_REG42			(ISP_DHAZ_BASE + 0x00118)
#define ISP_DHAZ_HIST_REG43			(ISP_DHAZ_BASE + 0x0011c)
#define ISP_DHAZ_HIST_REG44			(ISP_DHAZ_BASE + 0x00120)
#define ISP_DHAZ_HIST_REG45			(ISP_DHAZ_BASE + 0x00124)
#define ISP_DHAZ_HIST_REG46			(ISP_DHAZ_BASE + 0x00128)
#define ISP_DHAZ_HIST_REG47			(ISP_DHAZ_BASE + 0x0012c)
#define ISP_DHAZ_HIST_REG48			(ISP_DHAZ_BASE + 0x00130)
#define ISP_DHAZ_HIST_REG49			(ISP_DHAZ_BASE + 0x00134)
#define ISP_DHAZ_HIST_REG50			(ISP_DHAZ_BASE + 0x00138)
#define ISP_DHAZ_HIST_REG51			(ISP_DHAZ_BASE + 0x0013c)
#define ISP_DHAZ_HIST_REG52			(ISP_DHAZ_BASE + 0x00140)
#define ISP_DHAZ_HIST_REG53			(ISP_DHAZ_BASE + 0x00144)
#define ISP_DHAZ_HIST_REG54			(ISP_DHAZ_BASE + 0x00148)
#define ISP_DHAZ_HIST_REG55			(ISP_DHAZ_BASE + 0x0014c)
#define ISP_DHAZ_HIST_REG56			(ISP_DHAZ_BASE + 0x00150)
#define ISP_DHAZ_HIST_REG57			(ISP_DHAZ_BASE + 0x00154)
#define ISP_DHAZ_HIST_REG58			(ISP_DHAZ_BASE + 0x00158)
#define ISP_DHAZ_HIST_REG59			(ISP_DHAZ_BASE + 0x0015c)
#define ISP_DHAZ_HIST_REG60			(ISP_DHAZ_BASE + 0x00160)
#define ISP_DHAZ_HIST_REG61			(ISP_DHAZ_BASE + 0x00164)
#define ISP_DHAZ_HIST_REG62			(ISP_DHAZ_BASE + 0x00168)
#define ISP_DHAZ_HIST_REG63			(ISP_DHAZ_BASE + 0x0016c)
#define ISP_DHAZ_HIST_REG64			(ISP_DHAZ_BASE + 0x00170)
#define ISP_DHAZ_HIST_REG65			(ISP_DHAZ_BASE + 0x00174)
#define ISP_DHAZ_HIST_REG66			(ISP_DHAZ_BASE + 0x00178)
#define ISP_DHAZ_HIST_REG67			(ISP_DHAZ_BASE + 0x0017c)
#define ISP_DHAZ_HIST_REG68			(ISP_DHAZ_BASE + 0x00180)
#define ISP_DHAZ_HIST_REG69			(ISP_DHAZ_BASE + 0x00184)
#define ISP_DHAZ_HIST_REG70			(ISP_DHAZ_BASE + 0x00188)
#define ISP_DHAZ_HIST_REG71			(ISP_DHAZ_BASE + 0x0018c)
#define ISP_DHAZ_HIST_REG72			(ISP_DHAZ_BASE + 0x00190)
#define ISP_DHAZ_HIST_REG73			(ISP_DHAZ_BASE + 0x00194)
#define ISP_DHAZ_HIST_REG74			(ISP_DHAZ_BASE + 0x00198)
#define ISP_DHAZ_HIST_REG75			(ISP_DHAZ_BASE + 0x0019c)
#define ISP_DHAZ_HIST_REG76			(ISP_DHAZ_BASE + 0x001a0)
#define ISP_DHAZ_HIST_REG77			(ISP_DHAZ_BASE + 0x001a4)
#define ISP_DHAZ_HIST_REG78			(ISP_DHAZ_BASE + 0x001a8)
#define ISP_DHAZ_HIST_REG79			(ISP_DHAZ_BASE + 0x001ac)
#define ISP_DHAZ_HIST_REG80			(ISP_DHAZ_BASE + 0x001b0)
#define ISP_DHAZ_HIST_REG81			(ISP_DHAZ_BASE + 0x001b4)
#define ISP_DHAZ_HIST_REG82			(ISP_DHAZ_BASE + 0x001b8)
#define ISP_DHAZ_HIST_REG83			(ISP_DHAZ_BASE + 0x001bc)
#define ISP_DHAZ_HIST_REG84			(ISP_DHAZ_BASE + 0x001c0)
#define ISP_DHAZ_HIST_REG85			(ISP_DHAZ_BASE + 0x001c4)
#define ISP_DHAZ_HIST_REG86			(ISP_DHAZ_BASE + 0x001c8)
#define ISP_DHAZ_HIST_REG87			(ISP_DHAZ_BASE + 0x001cc)
#define ISP_DHAZ_HIST_REG88			(ISP_DHAZ_BASE + 0x001d0)
#define ISP_DHAZ_HIST_REG89			(ISP_DHAZ_BASE + 0x001d4)
#define ISP_DHAZ_HIST_REG90			(ISP_DHAZ_BASE + 0x001d8)
#define ISP_DHAZ_HIST_REG91			(ISP_DHAZ_BASE + 0x001dc)
#define ISP_DHAZ_HIST_REG92			(ISP_DHAZ_BASE + 0x001e0)
#define ISP_DHAZ_HIST_REG93			(ISP_DHAZ_BASE + 0x001e4)
#define ISP_DHAZ_HIST_REG94			(ISP_DHAZ_BASE + 0x001e8)
#define ISP_DHAZ_HIST_REG95			(ISP_DHAZ_BASE + 0x001ec)

#define ISP21_DHAZ_CTRL				(ISP_DHAZ_BASE + 0x00000)
#define ISP21_DHAZ_ADP0				(ISP_DHAZ_BASE + 0x00004)
#define ISP21_DHAZ_ADP1				(ISP_DHAZ_BASE + 0x00008)
#define ISP21_DHAZ_ADP2				(ISP_DHAZ_BASE + 0x0000c)
#define ISP21_DHAZ_ADP_TMAX			(ISP_DHAZ_BASE + 0x00010)
#define ISP21_DHAZ_ADP_HIST0			(ISP_DHAZ_BASE + 0x00014)
#define ISP21_DHAZ_ADP_HIST1			(ISP_DHAZ_BASE + 0x00018)
#define ISP21_DHAZ_ENHANCE			(ISP_DHAZ_BASE + 0x0001c)
#define ISP21_DHAZ_IIR0				(ISP_DHAZ_BASE + 0x00020)
#define ISP21_DHAZ_IIR1				(ISP_DHAZ_BASE + 0x00024)
#define ISP21_DHAZ_SOFT_CFG0			(ISP_DHAZ_BASE + 0x00028)
#define ISP21_DHAZ_SOFT_CFG1			(ISP_DHAZ_BASE + 0x0002c)
#define ISP21_DHAZ_BF_SIGMA			(ISP_DHAZ_BASE + 0x00030)
#define ISP21_DHAZ_BF_WET			(ISP_DHAZ_BASE + 0x00034)
#define ISP21_DHAZ_ENH_CURVE0			(ISP_DHAZ_BASE + 0x00038)
#define ISP21_DHAZ_ENH_CURVE1			(ISP_DHAZ_BASE + 0x0003c)
#define ISP21_DHAZ_ENH_CURVE2			(ISP_DHAZ_BASE + 0x00040)
#define ISP21_DHAZ_ENH_CURVE3			(ISP_DHAZ_BASE + 0x00044)
#define ISP21_DHAZ_ENH_CURVE4			(ISP_DHAZ_BASE + 0x00048)
#define ISP21_DHAZ_ENH_CURVE5			(ISP_DHAZ_BASE + 0x0004c)
#define ISP21_DHAZ_ENH_CURVE6			(ISP_DHAZ_BASE + 0x00050)
#define ISP21_DHAZ_ENH_CURVE7			(ISP_DHAZ_BASE + 0x00054)
#define ISP21_DHAZ_ENH_CURVE8			(ISP_DHAZ_BASE + 0x00058)
#define ISP21_DHAZ_GAUS				(ISP_DHAZ_BASE + 0x0005c)
#define ISP21_DHAZ_CTRL_SHD			(ISP_DHAZ_BASE + 0x00060)
#define ISP21_DHAZ_ADP_RD0			(ISP_DHAZ_BASE + 0x00064)
#define ISP21_DHAZ_ADP_RD1			(ISP_DHAZ_BASE + 0x00068)
#define ISP21_DHAZ_HIST_REG0			(ISP_DHAZ_BASE + 0x00070)
#define ISP21_DHAZ_HIST_REG1			(ISP_DHAZ_BASE + 0x00074)
#define ISP21_DHAZ_HIST_REG2			(ISP_DHAZ_BASE + 0x00078)
#define ISP21_DHAZ_HIST_REG3			(ISP_DHAZ_BASE + 0x0007c)
#define ISP21_DHAZ_HIST_REG4			(ISP_DHAZ_BASE + 0x00080)
#define ISP21_DHAZ_HIST_REG5			(ISP_DHAZ_BASE + 0x00084)
#define ISP21_DHAZ_HIST_REG6			(ISP_DHAZ_BASE + 0x00088)
#define ISP21_DHAZ_HIST_REG7			(ISP_DHAZ_BASE + 0x0008c)
#define ISP21_DHAZ_HIST_REG8			(ISP_DHAZ_BASE + 0x00090)
#define ISP21_DHAZ_HIST_REG9			(ISP_DHAZ_BASE + 0x00094)
#define ISP21_DHAZ_HIST_REG10			(ISP_DHAZ_BASE + 0x00098)
#define ISP21_DHAZ_HIST_REG11			(ISP_DHAZ_BASE + 0x0009c)
#define ISP21_DHAZ_HIST_REG12			(ISP_DHAZ_BASE + 0x000a0)
#define ISP21_DHAZ_HIST_REG13			(ISP_DHAZ_BASE + 0x000a4)
#define ISP21_DHAZ_HIST_REG14			(ISP_DHAZ_BASE + 0x000a8)
#define ISP21_DHAZ_HIST_REG15			(ISP_DHAZ_BASE + 0x000ac)
#define ISP21_DHAZ_HIST_REG16			(ISP_DHAZ_BASE + 0x000b0)
#define ISP21_DHAZ_HIST_REG17			(ISP_DHAZ_BASE + 0x000b4)
#define ISP21_DHAZ_HIST_REG18			(ISP_DHAZ_BASE + 0x000b8)
#define ISP21_DHAZ_HIST_REG19			(ISP_DHAZ_BASE + 0x000bc)
#define ISP21_DHAZ_HIST_REG20			(ISP_DHAZ_BASE + 0x000c0)
#define ISP21_DHAZ_HIST_REG21			(ISP_DHAZ_BASE + 0x000c4)
#define ISP21_DHAZ_HIST_REG22			(ISP_DHAZ_BASE + 0x000c8)
#define ISP21_DHAZ_HIST_REG23			(ISP_DHAZ_BASE + 0x000cc)
#define ISP21_DHAZ_HIST_REG24			(ISP_DHAZ_BASE + 0x000d0)
#define ISP21_DHAZ_HIST_REG25			(ISP_DHAZ_BASE + 0x000d4)
#define ISP21_DHAZ_HIST_REG26			(ISP_DHAZ_BASE + 0x000d8)
#define ISP21_DHAZ_HIST_REG27			(ISP_DHAZ_BASE + 0x000dc)
#define ISP21_DHAZ_HIST_REG28			(ISP_DHAZ_BASE + 0x000e0)
#define ISP21_DHAZ_HIST_REG29			(ISP_DHAZ_BASE + 0x000e4)
#define ISP21_DHAZ_HIST_REG30			(ISP_DHAZ_BASE + 0x000e8)
#define ISP21_DHAZ_HIST_REG31			(ISP_DHAZ_BASE + 0x000ec)

#define ISP_3DLUT_BASE				0x00003E00
#define ISP_3DLUT_CTRL				(ISP_3DLUT_BASE + 0x00000)
#define ISP_3DLUT_UPDATE			(ISP_3DLUT_BASE + 0x00004)

#define ISP_GAIN_BASE				0x00003F00
#define ISP_GAIN_CTRL				(ISP_GAIN_BASE + 0x00000)
#define ISP_GAIN_G0				(ISP_GAIN_BASE + 0x00004)
#define ISP_GAIN_G1_G2				(ISP_GAIN_BASE + 0x00008)
#define ISP_GAIN_IDX0				(ISP_GAIN_BASE + 0x0000c)
#define ISP_GAIN_IDX1				(ISP_GAIN_BASE + 0x00010)
#define ISP_GAIN_IDX2				(ISP_GAIN_BASE + 0x00014)
#define ISP_GAIN_IDX3				(ISP_GAIN_BASE + 0x00018)
#define ISP_GAIN_LUT0				(ISP_GAIN_BASE + 0x0001c)
#define ISP_GAIN_LUT1				(ISP_GAIN_BASE + 0x00020)
#define ISP_GAIN_LUT2				(ISP_GAIN_BASE + 0x00024)
#define ISP_GAIN_LUT3				(ISP_GAIN_BASE + 0x00028)
#define ISP_GAIN_LUT4				(ISP_GAIN_BASE + 0x0002c)
#define ISP_GAIN_LUT5				(ISP_GAIN_BASE + 0x00030)
#define ISP_GAIN_LUT6				(ISP_GAIN_BASE + 0x00034)
#define ISP_GAIN_LUT7				(ISP_GAIN_BASE + 0x00038)
#define ISP_GAIN_LUT8				(ISP_GAIN_BASE + 0x0003c)

#define ISP_AFM_BASE				0x00004100
#define ISP_AFM_CTRL				(ISP_AFM_BASE + 0x00000)
#define ISP_AFM_LT_A				(ISP_AFM_BASE + 0x00004)
#define ISP_AFM_RB_A				(ISP_AFM_BASE + 0x00008)
#define ISP_AFM_LT_B				(ISP_AFM_BASE + 0x0000c)
#define ISP_AFM_RB_B				(ISP_AFM_BASE + 0x00010)
#define ISP_AFM_LT_C				(ISP_AFM_BASE + 0x00014)
#define ISP_AFM_RB_C				(ISP_AFM_BASE + 0x00018)
#define ISP_AFM_THRES				(ISP_AFM_BASE + 0x0001c)
#define ISP_AFM_VAR_SHIFT			(ISP_AFM_BASE + 0x00020)
#define ISP_AFM_SUM_A				(ISP_AFM_BASE + 0x00024)
#define ISP_AFM_SUM_B				(ISP_AFM_BASE + 0x00028)
#define ISP_AFM_SUM_C				(ISP_AFM_BASE + 0x0002c)
#define ISP_AFM_LUM_A				(ISP_AFM_BASE + 0x00030)
#define ISP_AFM_LUM_B				(ISP_AFM_BASE + 0x00034)
#define ISP_AFM_LUM_C				(ISP_AFM_BASE + 0x00038)

#define ISP_HIST_BASE				0x00004200
#define ISP_HIST_HIST_CTRL			(ISP_HIST_BASE + 0x00000)
#define ISP_HIST_HIST_SIZE			(ISP_HIST_BASE + 0x00004)
#define ISP_HIST_HIST_OFFS			(ISP_HIST_BASE + 0x00008)
#define ISP_HIST_HIST_DBG1			(ISP_HIST_BASE + 0x0000c)
#define ISP_HIST_HIST1_CTRL			(ISP_HIST_BASE + 0x00010)
#define ISP_HIST_HIST1_SIZE			(ISP_HIST_BASE + 0x00014)
#define ISP_HIST_HIST1_OFFS			(ISP_HIST_BASE + 0x00018)
#define ISP_HIST_HIST_DBG2			(ISP_HIST_BASE + 0x0001c)
#define ISP_HIST_HIST2_CTRL			(ISP_HIST_BASE + 0x00020)
#define ISP_HIST_HIST2_SIZE			(ISP_HIST_BASE + 0x00024)
#define ISP_HIST_HIST2_OFFS			(ISP_HIST_BASE + 0x00028)
#define ISP_HIST_HIST_DBG3			(ISP_HIST_BASE + 0x0002c)
#define ISP_HIST_HIST3_CTRL			(ISP_HIST_BASE + 0x00030)
#define ISP_HIST_HIST3_SIZE			(ISP_HIST_BASE + 0x00034)
#define ISP_HIST_HIST3_OFFS			(ISP_HIST_BASE + 0x00038)
#define ISP_HIST_HIST_WEIGHT_0			(ISP_HIST_BASE + 0x0003c)
#define ISP_HIST_HIST_BIN			(ISP_HIST_BASE + 0x00120)
#define ISP_HIST_HIST1_BIN			(ISP_HIST_BASE + 0x00160)
#define ISP_HIST_HIST2_BIN			(ISP_HIST_BASE + 0x001a0)
#define ISP_HIST_HIST3_BIN			(ISP_HIST_BASE + 0x001e0)
#define ISP_HIST_HIST1_DBG1			(ISP_HIST_BASE + 0x00220)
#define ISP_HIST_HIST1_DBG2			(ISP_HIST_BASE + 0x00224)
#define ISP_HIST_HIST2_DBG1			(ISP_HIST_BASE + 0x00228)
#define ISP_HIST_HIST2_DBG2			(ISP_HIST_BASE + 0x0022c)
#define ISP_HIST_HIST3_DBG1			(ISP_HIST_BASE + 0x00230)
#define ISP_HIST_HIST3_DBG2			(ISP_HIST_BASE + 0x00234)

#define RAWAE_BIG1_BASE				0x00004400
#define RAWAE_BIG2_BASE				0x00004600
#define RAWAE_BIG3_BASE				0x00004700
#define RAWAE_BIG_CTRL				(0x00000)
#define RAWAE_BIG_BLK_SIZE			(0x00004)
#define RAWAE_BIG_OFFSET			(0x00008)
#define RAWAE_BIG_RAM_CTRL			(0x0000c)
#define RAWAE_BIG_WND1_SIZE			(0x00010)
#define RAWAE_BIG_WND1_OFFSET			(0x00014)
#define RAWAE_BIG_WND2_SIZE			(0x00018)
#define RAWAE_BIG_WND2_OFFSET			(0x0001c)
#define RAWAE_BIG_WND3_SIZE			(0x00020)
#define RAWAE_BIG_WND3_OFFSET			(0x00024)
#define RAWAE_BIG_WND4_SIZE			(0x00028)
#define RAWAE_BIG_WND4_OFFSET			(0x0002c)
#define RAWAE_BIG_WND1_SUMR			(0x00030)
#define RAWAE_BIG_WND2_SUMR			(0x00034)
#define RAWAE_BIG_WND3_SUMR			(0x00038)
#define RAWAE_BIG_WND4_SUMR			(0x0003c)
#define RAWAE_BIG_WND1_SUMG			(0x00040)
#define RAWAE_BIG_WND2_SUMG			(0x00044)
#define RAWAE_BIG_WND3_SUMG			(0x00048)
#define RAWAE_BIG_WND4_SUMG			(0x0004c)
#define RAWAE_BIG_WND1_SUMB			(0x00050)
#define RAWAE_BIG_WND2_SUMB			(0x00054)
#define RAWAE_BIG_WND3_SUMB			(0x00058)
#define RAWAE_BIG_WND4_SUMB			(0x0005c)
#define RAWAE_BIG_RO_DBG1			(0x00060)
#define RAWAE_BIG_RO_DBG2			(0x00064)
#define RAWAE_BIG_RO_DBG3			(0x00068)
#define RAWAE_BIG_RO_MEAN_BASE_ADDR		(0x00080)

#define ISP_RAWAE_LITE_BASE			0x00004500
#define ISP_RAWAE_LITE_CTRL			(ISP_RAWAE_LITE_BASE + 0x00000)
#define ISP_RAWAE_LITE_BLK_SIZ			(ISP_RAWAE_LITE_BASE + 0x00004)
#define ISP_RAWAE_LITE_OFFSET			(ISP_RAWAE_LITE_BASE + 0x00008)
#define ISP_RAWAE_LITE_R2Y_CC			(ISP_RAWAE_LITE_BASE + 0x0000c)
#define ISP_RAWAE_LITE_RO_MEAN			(ISP_RAWAE_LITE_BASE + 0x00010)
#define ISP_RAWAE_LITE_RO_DBG1			(ISP_RAWAE_LITE_BASE + 0x00074)
#define ISP_RAWAE_LITE_RO_DBG2			(ISP_RAWAE_LITE_BASE + 0x00078)

#define ISP_RAWHIST_LITE_BASE			0x00004900
#define ISP_RAWHIST_LITE_CTRL			(ISP_RAWHIST_LITE_BASE + 0x00000)
#define ISP_RAWHIST_LITE_SIZE			(ISP_RAWHIST_LITE_BASE + 0x00004)
#define ISP_RAWHIST_LITE_OFFS			(ISP_RAWHIST_LITE_BASE + 0x00008)
#define ISP_RAWHIST_LITE_RAM_CTRL		(ISP_RAWHIST_LITE_BASE + 0x0000c)
#define ISP_RAWHIST_LITE_RAW2Y_CC		(ISP_RAWHIST_LITE_BASE + 0x00010)
#define ISP_RAWHIST_LITE_DBG1			(ISP_RAWHIST_LITE_BASE + 0x00020)
#define ISP_RAWHIST_LITE_DBG2			(ISP_RAWHIST_LITE_BASE + 0x00024)
#define ISP_RAWHIST_LITE_DBG3			(ISP_RAWHIST_LITE_BASE + 0x00028)
#define ISP_RAWHIST_LITE_WEIGHT			(ISP_RAWHIST_LITE_BASE + 0x00040)
#define ISP_RAWHIST_LITE_RO_BASE_BIN		(ISP_RAWHIST_LITE_BASE + 0x00080)

#define ISP_RAWHIST_BIG1_BASE			0x00004800
#define ISP_RAWHIST_BIG2_BASE			0x00004A00
#define ISP_RAWHIST_BIG3_BASE			0x00004B00
#define ISP_RAWHIST_BIG_CTRL			(0x00000)
#define ISP_RAWHIST_BIG_SIZE			(0x00004)
#define ISP_RAWHIST_BIG_OFFS			(0x00008)
#define ISP_RAWHIST_BIG_HRAM_CTRL		(0x0000c)
#define ISP_RAWHIST_BIG_RAW2Y_CC		(0x00010)
#define ISP_RAWHIST_BIG_WRAM_CTRL		(0x00014)
#define ISP_RAWHIST_BIG_DBG1			(0x00020)
#define ISP_RAWHIST_BIG_DBG2			(0x00024)
#define ISP_RAWHIST_BIG_DBG3			(0x00028)
#define ISP_RAWHIST_BIG_WEIGHT_BASE		(0x00040)
#define ISP_RAWHIST_BIG_RO_BASE_BIN		(0x00080)

#define ISP_YUVAE_BASE				0x00004C00
#define ISP_YUVAE_CTRL				(ISP_YUVAE_BASE + 0x00000)
#define ISP_YUVAE_BLK_SIZE			(ISP_YUVAE_BASE + 0x00004)
#define ISP_YUVAE_OFFSET			(ISP_YUVAE_BASE + 0x00008)
#define ISP_YUVAE_RAM_CTRL			(ISP_YUVAE_BASE + 0x0000c)
#define ISP_YUVAE_WND1_SIZE			(ISP_YUVAE_BASE + 0x00010)
#define ISP_YUVAE_WND1_OFFSET			(ISP_YUVAE_BASE + 0x00014)
#define ISP_YUVAE_WND2_SIZE			(ISP_YUVAE_BASE + 0x00018)
#define ISP_YUVAE_WND2_OFFSET			(ISP_YUVAE_BASE + 0x0001c)
#define ISP_YUVAE_WND3_SIZE			(ISP_YUVAE_BASE + 0x00020)
#define ISP_YUVAE_WND3_OFFSET			(ISP_YUVAE_BASE + 0x00024)
#define ISP_YUVAE_WND4_SIZE			(ISP_YUVAE_BASE + 0x00028)
#define ISP_YUVAE_WND4_OFFSET			(ISP_YUVAE_BASE + 0x0002c)
#define ISP_YUVAE_WND1_SUMY			(ISP_YUVAE_BASE + 0x00030)
#define ISP_YUVAE_WND2_SUMY			(ISP_YUVAE_BASE + 0x00034)
#define ISP_YUVAE_WND3_SUMY			(ISP_YUVAE_BASE + 0x00038)
#define ISP_YUVAE_WND4_SUMY			(ISP_YUVAE_BASE + 0x0003c)
#define ISP_YUVAE_RO_DBG1			(ISP_YUVAE_BASE + 0x00040)
#define ISP_YUVAE_RO_DBG2			(ISP_YUVAE_BASE + 0x00044)
#define ISP_YUVAE_RO_DBG3			(ISP_YUVAE_BASE + 0x00048)
#define ISP_YUVAE_RO_MEAN_BASE_ADDR		(ISP_YUVAE_BASE + 0x00080)

#define ISP_RAWAF_BASE				0x00004D00
#define ISP_RAWAF_CTRL				(ISP_RAWAF_BASE + 0x00000)
#define ISP_RAWAF_LT_A				(ISP_RAWAF_BASE + 0x00004)
#define ISP_RAWAF_RB_A				(ISP_RAWAF_BASE + 0x00008)
#define ISP_RAWAF_LT_B				(ISP_RAWAF_BASE + 0x0000c)
#define ISP_RAWAF_RB_B				(ISP_RAWAF_BASE + 0x00010)
#define ISP_RAWAF_INT_LINE			(ISP_RAWAF_BASE + 0x00014)
#define ISP_RAWAF_GAUS_COE			(ISP_RAWAF_BASE + 0x00018)
#define ISP_RAWAF_THRES				(ISP_RAWAF_BASE + 0x0001c)
#define ISP_RAWAF_VAR_SHIFT			(ISP_RAWAF_BASE + 0x00020)
#define ISP_RAWAF_SUM_A				(ISP_RAWAF_BASE + 0x00024)
#define ISP_RAWAF_SUM_B				(ISP_RAWAF_BASE + 0x00028)
#define ISP_RAWAF_LUM_A				(ISP_RAWAF_BASE + 0x0002c)
#define ISP_RAWAF_LUM_B				(ISP_RAWAF_BASE + 0x00030)
#define ISP_RAWAF_GAMMA_Y0			(ISP_RAWAF_BASE + 0x00034)
#define ISP_RAWAF_GAMMA_Y1			(ISP_RAWAF_BASE + 0x00038)
#define ISP_RAWAF_GAMMA_Y2			(ISP_RAWAF_BASE + 0x0003c)
#define ISP_RAWAF_GAMMA_Y3			(ISP_RAWAF_BASE + 0x00040)
#define ISP_RAWAF_GAMMA_Y4			(ISP_RAWAF_BASE + 0x00044)
#define ISP_RAWAF_GAMMA_Y5			(ISP_RAWAF_BASE + 0x00048)
#define ISP_RAWAF_GAMMA_Y6			(ISP_RAWAF_BASE + 0x0004c)
#define ISP_RAWAF_GAMMA_Y7			(ISP_RAWAF_BASE + 0x00050)
#define ISP_RAWAF_GAMMA_Y8			(ISP_RAWAF_BASE + 0x00054)
#define ISP_RAWAF_INT_STATE			(ISP_RAWAF_BASE + 0x00058)
#define ISP_RAWAF_RAM_DATA			(ISP_RAWAF_BASE + 0x0005c)

#define ISP_RAWAWB_BASE				0x00005000
#define ISP_RAWAWB_CTRL				(ISP_RAWAWB_BASE + 0x00000)
#define ISP_RAWAWB_BLK_CTRL			(ISP_RAWAWB_BASE + 0x00004)
#define ISP_RAWAWB_WIN_OFFS			(ISP_RAWAWB_BASE + 0x00008)
#define ISP_RAWAWB_WIN_SIZE			(ISP_RAWAWB_BASE + 0x0000c)
#define ISP_RAWAWB_LIMIT_RG_MAX			(ISP_RAWAWB_BASE + 0x00010)
#define ISP_RAWAWB_LIMIT_BY_MAX			(ISP_RAWAWB_BASE + 0x00014)
#define ISP_RAWAWB_LIMIT_RG_MIN			(ISP_RAWAWB_BASE + 0x00018)
#define ISP_RAWAWB_LIMIT_BY_MIN			(ISP_RAWAWB_BASE + 0x0001c)
#define ISP_RAWAWB_RGB2Y_0			(ISP_RAWAWB_BASE + 0x00020)
#define ISP_RAWAWB_RGB2Y_1			(ISP_RAWAWB_BASE + 0x00024)
#define ISP_RAWAWB_RGB2U_0			(ISP_RAWAWB_BASE + 0x00028)
#define ISP_RAWAWB_RGB2U_1			(ISP_RAWAWB_BASE + 0x0002c)
#define ISP_RAWAWB_RGB2V_0			(ISP_RAWAWB_BASE + 0x00030)
#define ISP_RAWAWB_RGB2V_1			(ISP_RAWAWB_BASE + 0x00034)
#define ISP_RAWAWB_UV_DETC_VERTEX0_0		(ISP_RAWAWB_BASE + 0x00038)
#define ISP_RAWAWB_UV_DETC_VERTEX1_0		(ISP_RAWAWB_BASE + 0x0003c)
#define ISP_RAWAWB_UV_DETC_VERTEX2_0		(ISP_RAWAWB_BASE + 0x00040)
#define ISP_RAWAWB_UV_DETC_VERTEX3_0		(ISP_RAWAWB_BASE + 0x00044)
#define ISP_RAWAWB_UV_DETC_ISLOPE01_0		(ISP_RAWAWB_BASE + 0x00048)
#define ISP_RAWAWB_UV_DETC_ISLOPE12_0		(ISP_RAWAWB_BASE + 0x0004c)
#define ISP_RAWAWB_UV_DETC_ISLOPE23_0		(ISP_RAWAWB_BASE + 0x00050)
#define ISP_RAWAWB_UV_DETC_ISLOPE30_0		(ISP_RAWAWB_BASE + 0x00054)
#define ISP_RAWAWB_UV_DETC_VERTEX0_1		(ISP_RAWAWB_BASE + 0x00058)
#define ISP_RAWAWB_UV_DETC_VERTEX1_1		(ISP_RAWAWB_BASE + 0x0005c)
#define ISP_RAWAWB_UV_DETC_VERTEX2_1		(ISP_RAWAWB_BASE + 0x00060)
#define ISP_RAWAWB_UV_DETC_VERTEX3_1		(ISP_RAWAWB_BASE + 0x00064)
#define ISP_RAWAWB_UV_DETC_ISLOPE01_1		(ISP_RAWAWB_BASE + 0x00068)
#define ISP_RAWAWB_UV_DETC_ISLOPE12_1		(ISP_RAWAWB_BASE + 0x0006c)
#define ISP_RAWAWB_UV_DETC_ISLOPE23_1		(ISP_RAWAWB_BASE + 0x00070)
#define ISP_RAWAWB_UV_DETC_ISLOPE30_1		(ISP_RAWAWB_BASE + 0x00074)
#define ISP_RAWAWB_UV_DETC_VERTEX0_2		(ISP_RAWAWB_BASE + 0x00078)
#define ISP_RAWAWB_UV_DETC_VERTEX1_2		(ISP_RAWAWB_BASE + 0x0007c)
#define ISP_RAWAWB_UV_DETC_VERTEX2_2		(ISP_RAWAWB_BASE + 0x00080)
#define ISP_RAWAWB_UV_DETC_VERTEX3_2		(ISP_RAWAWB_BASE + 0x00084)
#define ISP_RAWAWB_UV_DETC_ISLOPE01_2		(ISP_RAWAWB_BASE + 0x00088)
#define ISP_RAWAWB_UV_DETC_ISLOPE12_2		(ISP_RAWAWB_BASE + 0x0008c)
#define ISP_RAWAWB_UV_DETC_ISLOPE23_2		(ISP_RAWAWB_BASE + 0x00090)
#define ISP_RAWAWB_UV_DETC_ISLOPE30_2		(ISP_RAWAWB_BASE + 0x00094)
#define ISP_RAWAWB_UV_DETC_VERTEX0_3		(ISP_RAWAWB_BASE + 0x00098)
#define ISP_RAWAWB_UV_DETC_VERTEX1_3		(ISP_RAWAWB_BASE + 0x0009c)
#define ISP_RAWAWB_UV_DETC_VERTEX2_3		(ISP_RAWAWB_BASE + 0x000a0)
#define ISP_RAWAWB_UV_DETC_VERTEX3_3		(ISP_RAWAWB_BASE + 0x000a4)
#define ISP_RAWAWB_UV_DETC_ISLOPE01_3		(ISP_RAWAWB_BASE + 0x000a8)
#define ISP_RAWAWB_UV_DETC_ISLOPE12_3		(ISP_RAWAWB_BASE + 0x000ac)
#define ISP_RAWAWB_UV_DETC_ISLOPE23_3		(ISP_RAWAWB_BASE + 0x000b0)
#define ISP_RAWAWB_UV_DETC_ISLOPE30_3		(ISP_RAWAWB_BASE + 0x000b4)
#define ISP_RAWAWB_UV_DETC_VERTEX0_4		(ISP_RAWAWB_BASE + 0x000b8)
#define ISP_RAWAWB_UV_DETC_VERTEX1_4		(ISP_RAWAWB_BASE + 0x000bc)
#define ISP_RAWAWB_UV_DETC_VERTEX2_4		(ISP_RAWAWB_BASE + 0x000c0)
#define ISP_RAWAWB_UV_DETC_VERTEX3_4		(ISP_RAWAWB_BASE + 0x000c4)
#define ISP_RAWAWB_UV_DETC_ISLOPE01_4		(ISP_RAWAWB_BASE + 0x000c8)
#define ISP_RAWAWB_UV_DETC_ISLOPE12_4		(ISP_RAWAWB_BASE + 0x000cc)
#define ISP_RAWAWB_UV_DETC_ISLOPE23_4		(ISP_RAWAWB_BASE + 0x000d0)
#define ISP_RAWAWB_UV_DETC_ISLOPE30_4		(ISP_RAWAWB_BASE + 0x000d4)
#define ISP_RAWAWB_UV_DETC_VERTEX0_5		(ISP_RAWAWB_BASE + 0x000d8)
#define ISP_RAWAWB_UV_DETC_VERTEX1_5		(ISP_RAWAWB_BASE + 0x000dc)
#define ISP_RAWAWB_UV_DETC_VERTEX2_5		(ISP_RAWAWB_BASE + 0x000e0)
#define ISP_RAWAWB_UV_DETC_VERTEX3_5		(ISP_RAWAWB_BASE + 0x000e4)
#define ISP_RAWAWB_UV_DETC_ISLOPE01_5		(ISP_RAWAWB_BASE + 0x000e8)
#define ISP_RAWAWB_UV_DETC_ISLOPE12_5		(ISP_RAWAWB_BASE + 0x000ec)
#define ISP_RAWAWB_UV_DETC_ISLOPE23_5		(ISP_RAWAWB_BASE + 0x000f0)
#define ISP_RAWAWB_UV_DETC_ISLOPE30_5		(ISP_RAWAWB_BASE + 0x000f4)
#define ISP_RAWAWB_UV_DETC_VERTEX0_6		(ISP_RAWAWB_BASE + 0x000f8)
#define ISP_RAWAWB_UV_DETC_VERTEX1_6		(ISP_RAWAWB_BASE + 0x000fc)
#define ISP_RAWAWB_UV_DETC_VERTEX2_6		(ISP_RAWAWB_BASE + 0x00100)
#define ISP_RAWAWB_UV_DETC_VERTEX3_6		(ISP_RAWAWB_BASE + 0x00104)
#define ISP_RAWAWB_UV_DETC_ISLOPE01_6		(ISP_RAWAWB_BASE + 0x00108)
#define ISP_RAWAWB_UV_DETC_ISLOPE12_6		(ISP_RAWAWB_BASE + 0x0010c)
#define ISP_RAWAWB_UV_DETC_ISLOPE23_6		(ISP_RAWAWB_BASE + 0x00110)
#define ISP_RAWAWB_UV_DETC_ISLOPE30_6		(ISP_RAWAWB_BASE + 0x00114)
#define ISP_RAWAWB_YUV_DETC_B_UV_0		(ISP_RAWAWB_BASE + 0x00118)
#define ISP_RAWAWB_YUV_DETC_SLOPE_VTCUV_0	(ISP_RAWAWB_BASE + 0x0011c)
#define ISP_RAWAWB_YUV_DETC_INV_DSLOPE_0	(ISP_RAWAWB_BASE + 0x00120)
#define ISP_RAWAWB_YUV_DETC_SLOPE_YDIS_0	(ISP_RAWAWB_BASE + 0x00124)
#define ISP_RAWAWB_YUV_DETC_B_YDIS_0		(ISP_RAWAWB_BASE + 0x00128)
#define ISP_RAWAWB_YUV_DETC_B_UV_1		(ISP_RAWAWB_BASE + 0x0012c)
#define ISP_RAWAWB_YUV_DETC_SLOPE_VTCUV_1	(ISP_RAWAWB_BASE + 0x00130)
#define ISP_RAWAWB_YUV_DETC_INV_DSLOPE_1	(ISP_RAWAWB_BASE + 0x00134)
#define ISP_RAWAWB_YUV_DETC_SLOPE_YDIS_1	(ISP_RAWAWB_BASE + 0x00138)
#define ISP_RAWAWB_YUV_DETC_B_YDIS_1		(ISP_RAWAWB_BASE + 0x0013c)
#define ISP_RAWAWB_YUV_DETC_B_UV_2		(ISP_RAWAWB_BASE + 0x00140)
#define ISP_RAWAWB_YUV_DETC_SLOPE_VTCUV_2	(ISP_RAWAWB_BASE + 0x00144)
#define ISP_RAWAWB_YUV_DETC_INV_DSLOPE_2	(ISP_RAWAWB_BASE + 0x00148)
#define ISP_RAWAWB_YUV_DETC_SLOPE_YDIS_2	(ISP_RAWAWB_BASE + 0x0014c)
#define ISP_RAWAWB_YUV_DETC_B_YDIS_2		(ISP_RAWAWB_BASE + 0x00150)
#define ISP_RAWAWB_YUV_DETC_B_UV_3		(ISP_RAWAWB_BASE + 0x00154)
#define ISP_RAWAWB_YUV_DETC_SLOPE_VTCUV_3	(ISP_RAWAWB_BASE + 0x00158)
#define ISP_RAWAWB_YUV_DETC_INV_DSLOPE_3	(ISP_RAWAWB_BASE + 0x0015c)
#define ISP_RAWAWB_YUV_DETC_SLOPE_YDIS_3	(ISP_RAWAWB_BASE + 0x00160)
#define ISP_RAWAWB_YUV_DETC_B_YDIS_3		(ISP_RAWAWB_BASE + 0x00164)
#define ISP_RAWAWB_YUV_DETC_REF_U		(ISP_RAWAWB_BASE + 0x00168)
#define ISP_RAWAWB_YUV_DETC_REF_V		(ISP_RAWAWB_BASE + 0x0016c)
#define ISP_RAWAWB_YUV_DETC_DIS01_0		(ISP_RAWAWB_BASE + 0x00170)
#define ISP_RAWAWB_YUV_DETC_DIS23_0		(ISP_RAWAWB_BASE + 0x00174)
#define ISP_RAWAWB_YUV_DETC_DIS45_0		(ISP_RAWAWB_BASE + 0x00178)
#define ISP_RAWAWB_YUV_DETC_TH03_0		(ISP_RAWAWB_BASE + 0x0017c)
#define ISP_RAWAWB_YUV_DETC_TH45_0		(ISP_RAWAWB_BASE + 0x00180)
#define ISP_RAWAWB_YUV_DETC_DIS01_1		(ISP_RAWAWB_BASE + 0x00184)
#define ISP_RAWAWB_YUV_DETC_DIS23_1		(ISP_RAWAWB_BASE + 0x00188)
#define ISP_RAWAWB_YUV_DETC_DIS45_1		(ISP_RAWAWB_BASE + 0x0018c)
#define ISP_RAWAWB_YUV_DETC_TH03_1		(ISP_RAWAWB_BASE + 0x00190)
#define ISP_RAWAWB_YUV_DETC_TH45_1		(ISP_RAWAWB_BASE + 0x00194)
#define ISP_RAWAWB_YUV_DETC_DIS01_2		(ISP_RAWAWB_BASE + 0x00198)
#define ISP_RAWAWB_YUV_DETC_DIS23_2		(ISP_RAWAWB_BASE + 0x0019c)
#define ISP_RAWAWB_YUV_DETC_DIS45_2		(ISP_RAWAWB_BASE + 0x001a0)
#define ISP_RAWAWB_YUV_DETC_TH03_2		(ISP_RAWAWB_BASE + 0x001a4)
#define ISP_RAWAWB_YUV_DETC_TH45_2		(ISP_RAWAWB_BASE + 0x001a8)
#define ISP_RAWAWB_YUV_DETC_DIS01_3		(ISP_RAWAWB_BASE + 0x001ac)
#define ISP_RAWAWB_YUV_DETC_DIS23_3		(ISP_RAWAWB_BASE + 0x001b0)
#define ISP_RAWAWB_YUV_DETC_DIS45_3		(ISP_RAWAWB_BASE + 0x001b4)
#define ISP_RAWAWB_YUV_DETC_TH03_3		(ISP_RAWAWB_BASE + 0x001b8)
#define ISP_RAWAWB_YUV_DETC_TH45_3		(ISP_RAWAWB_BASE + 0x001bc)
#define ISP_RAWAWB_RGB2XY_WT01			(ISP_RAWAWB_BASE + 0x001fc)
#define ISP_RAWAWB_RGB2XY_WT2			(ISP_RAWAWB_BASE + 0x00200)
#define ISP_RAWAWB_RGB2XY_MAT0_XY		(ISP_RAWAWB_BASE + 0x00204)
#define ISP_RAWAWB_RGB2XY_MAT1_XY		(ISP_RAWAWB_BASE + 0x00208)
#define ISP_RAWAWB_RGB2XY_MAT2_XY		(ISP_RAWAWB_BASE + 0x0020c)
#define ISP_RAWAWB_XY_DETC_NOR_X_0		(ISP_RAWAWB_BASE + 0x00210)
#define ISP_RAWAWB_XY_DETC_NOR_Y_0		(ISP_RAWAWB_BASE + 0x00214)
#define ISP_RAWAWB_XY_DETC_BIG_X_0		(ISP_RAWAWB_BASE + 0x00218)
#define ISP_RAWAWB_XY_DETC_BIG_Y_0		(ISP_RAWAWB_BASE + 0x0021c)
#define ISP_RAWAWB_XY_DETC_SMA_X_0		(ISP_RAWAWB_BASE + 0x00220)
#define ISP_RAWAWB_XY_DETC_SMA_Y_0		(ISP_RAWAWB_BASE + 0x00224)
#define ISP_RAWAWB_XY_DETC_NOR_X_1		(ISP_RAWAWB_BASE + 0x00228)
#define ISP_RAWAWB_XY_DETC_NOR_Y_1		(ISP_RAWAWB_BASE + 0x0022c)
#define ISP_RAWAWB_XY_DETC_BIG_X_1		(ISP_RAWAWB_BASE + 0x00230)
#define ISP_RAWAWB_XY_DETC_BIG_Y_1		(ISP_RAWAWB_BASE + 0x00234)
#define ISP_RAWAWB_XY_DETC_SMA_X_1		(ISP_RAWAWB_BASE + 0x00238)
#define ISP_RAWAWB_XY_DETC_SMA_Y_1		(ISP_RAWAWB_BASE + 0x0023c)
#define ISP_RAWAWB_XY_DETC_NOR_X_2		(ISP_RAWAWB_BASE + 0x00240)
#define ISP_RAWAWB_XY_DETC_NOR_Y_2		(ISP_RAWAWB_BASE + 0x00244)
#define ISP_RAWAWB_XY_DETC_BIG_X_2		(ISP_RAWAWB_BASE + 0x00248)
#define ISP_RAWAWB_XY_DETC_BIG_Y_2		(ISP_RAWAWB_BASE + 0x0024c)
#define ISP_RAWAWB_XY_DETC_SMA_X_2		(ISP_RAWAWB_BASE + 0x00250)
#define ISP_RAWAWB_XY_DETC_SMA_Y_2		(ISP_RAWAWB_BASE + 0x00254)
#define ISP_RAWAWB_XY_DETC_NOR_X_3		(ISP_RAWAWB_BASE + 0x00258)
#define ISP_RAWAWB_XY_DETC_NOR_Y_3		(ISP_RAWAWB_BASE + 0x0025c)
#define ISP_RAWAWB_XY_DETC_BIG_X_3		(ISP_RAWAWB_BASE + 0x00260)
#define ISP_RAWAWB_XY_DETC_BIG_Y_3		(ISP_RAWAWB_BASE + 0x00264)
#define ISP_RAWAWB_XY_DETC_SMA_X_3		(ISP_RAWAWB_BASE + 0x00268)
#define ISP_RAWAWB_XY_DETC_SMA_Y_3		(ISP_RAWAWB_BASE + 0x0026c)
#define ISP_RAWAWB_XY_DETC_NOR_X_4		(ISP_RAWAWB_BASE + 0x00270)
#define ISP_RAWAWB_XY_DETC_NOR_Y_4		(ISP_RAWAWB_BASE + 0x00274)
#define ISP_RAWAWB_XY_DETC_BIG_X_4		(ISP_RAWAWB_BASE + 0x00278)
#define ISP_RAWAWB_XY_DETC_BIG_Y_4		(ISP_RAWAWB_BASE + 0x0027c)
#define ISP_RAWAWB_XY_DETC_SMA_X_4		(ISP_RAWAWB_BASE + 0x00280)
#define ISP_RAWAWB_XY_DETC_SMA_Y_4		(ISP_RAWAWB_BASE + 0x00284)
#define ISP_RAWAWB_XY_DETC_NOR_X_5		(ISP_RAWAWB_BASE + 0x00288)
#define ISP_RAWAWB_XY_DETC_NOR_Y_5		(ISP_RAWAWB_BASE + 0x0028c)
#define ISP_RAWAWB_XY_DETC_BIG_X_5		(ISP_RAWAWB_BASE + 0x00290)
#define ISP_RAWAWB_XY_DETC_BIG_Y_5		(ISP_RAWAWB_BASE + 0x00294)
#define ISP_RAWAWB_XY_DETC_SMA_X_5		(ISP_RAWAWB_BASE + 0x00298)
#define ISP_RAWAWB_XY_DETC_SMA_Y_5		(ISP_RAWAWB_BASE + 0x0029c)
#define ISP_RAWAWB_XY_DETC_NOR_X_6		(ISP_RAWAWB_BASE + 0x002a0)
#define ISP_RAWAWB_XY_DETC_NOR_Y_6		(ISP_RAWAWB_BASE + 0x002a4)
#define ISP_RAWAWB_XY_DETC_BIG_X_6		(ISP_RAWAWB_BASE + 0x002a8)
#define ISP_RAWAWB_XY_DETC_BIG_Y_6		(ISP_RAWAWB_BASE + 0x002ac)
#define ISP_RAWAWB_XY_DETC_SMA_X_6		(ISP_RAWAWB_BASE + 0x002b0)
#define ISP_RAWAWB_XY_DETC_SMA_Y_6		(ISP_RAWAWB_BASE + 0x002b4)
#define ISP_RAWAWB_MULTIWINDOW_EXC_CTRL		(ISP_RAWAWB_BASE + 0x002b8)
#define ISP_RAWAWB_MULTIWINDOW0_OFFS		(ISP_RAWAWB_BASE + 0x002bc)
#define ISP_RAWAWB_MULTIWINDOW0_SIZE		(ISP_RAWAWB_BASE + 0x002c0)
#define ISP_RAWAWB_MULTIWINDOW1_OFFS		(ISP_RAWAWB_BASE + 0x002c4)
#define ISP_RAWAWB_MULTIWINDOW1_SIZE		(ISP_RAWAWB_BASE + 0x002c8)
#define ISP_RAWAWB_MULTIWINDOW2_OFFS		(ISP_RAWAWB_BASE + 0x002cc)
#define ISP_RAWAWB_MULTIWINDOW2_SIZE		(ISP_RAWAWB_BASE + 0x002d0)
#define ISP_RAWAWB_MULTIWINDOW3_OFFS		(ISP_RAWAWB_BASE + 0x002d4)
#define ISP_RAWAWB_MULTIWINDOW3_SIZE		(ISP_RAWAWB_BASE + 0x002d8)
#define ISP_RAWAWB_MULTIWINDOW4_OFFS		(ISP_RAWAWB_BASE + 0x002dc)
#define ISP_RAWAWB_MULTIWINDOW4_SIZE		(ISP_RAWAWB_BASE + 0x002e0)
#define ISP_RAWAWB_MULTIWINDOW5_OFFS		(ISP_RAWAWB_BASE + 0x002e4)
#define ISP_RAWAWB_MULTIWINDOW5_SIZE		(ISP_RAWAWB_BASE + 0x002e8)
#define ISP_RAWAWB_MULTIWINDOW6_OFFS		(ISP_RAWAWB_BASE + 0x002ec)
#define ISP_RAWAWB_MULTIWINDOW6_SIZE		(ISP_RAWAWB_BASE + 0x002f0)
#define ISP_RAWAWB_MULTIWINDOW7_OFFS		(ISP_RAWAWB_BASE + 0x002f4)
#define ISP_RAWAWB_MULTIWINDOW7_SIZE		(ISP_RAWAWB_BASE + 0x002f8)
#define ISP_RAWAWB_EXC_WP_REGION0_XU		(ISP_RAWAWB_BASE + 0x002fc)
#define ISP_RAWAWB_EXC_WP_REGION0_YV		(ISP_RAWAWB_BASE + 0x00300)
#define ISP_RAWAWB_EXC_WP_REGION1_XU		(ISP_RAWAWB_BASE + 0x00304)
#define ISP_RAWAWB_EXC_WP_REGION1_YV		(ISP_RAWAWB_BASE + 0x00308)
#define ISP_RAWAWB_EXC_WP_REGION2_XU		(ISP_RAWAWB_BASE + 0x0030c)
#define ISP_RAWAWB_EXC_WP_REGION2_YV		(ISP_RAWAWB_BASE + 0x00310)
#define ISP_RAWAWB_EXC_WP_REGION3_XU		(ISP_RAWAWB_BASE + 0x00314)
#define ISP_RAWAWB_EXC_WP_REGION3_YV		(ISP_RAWAWB_BASE + 0x00318)
#define ISP_RAWAWB_EXC_WP_REGION4_XU		(ISP_RAWAWB_BASE + 0x0031c)
#define ISP_RAWAWB_EXC_WP_REGION4_YV		(ISP_RAWAWB_BASE + 0x00320)
#define ISP_RAWAWB_EXC_WP_REGION5_XU		(ISP_RAWAWB_BASE + 0x00324)
#define ISP_RAWAWB_EXC_WP_REGION5_YV		(ISP_RAWAWB_BASE + 0x00328)
#define ISP_RAWAWB_EXC_WP_REGION6_XU		(ISP_RAWAWB_BASE + 0x0032c)
#define ISP_RAWAWB_EXC_WP_REGION6_YV		(ISP_RAWAWB_BASE + 0x00330)
#define ISP_RAWAWB_SUM_R_NOR_0			(ISP_RAWAWB_BASE + 0x00340)
#define ISP_RAWAWB_SUM_G_NOR_0			(ISP_RAWAWB_BASE + 0x00344)
#define ISP_RAWAWB_SUM_B_NOR_0			(ISP_RAWAWB_BASE + 0x00348)
#define ISP_RAWAWB_WP_NUM_NOR_0			(ISP_RAWAWB_BASE + 0x0034c)
#define ISP_RAWAWB_SUM_R_BIG_0			(ISP_RAWAWB_BASE + 0x00350)
#define ISP_RAWAWB_SUM_G_BIG_0			(ISP_RAWAWB_BASE + 0x00354)
#define ISP_RAWAWB_SUM_B_BIG_0			(ISP_RAWAWB_BASE + 0x00358)
#define ISP_RAWAWB_WP_NUM_BIG_0			(ISP_RAWAWB_BASE + 0x0035c)
#define ISP_RAWAWB_SUM_R_SMA_0			(ISP_RAWAWB_BASE + 0x00360)
#define ISP_RAWAWB_SUM_G_SMA_0			(ISP_RAWAWB_BASE + 0x00364)
#define ISP_RAWAWB_SUM_B_SMA_0			(ISP_RAWAWB_BASE + 0x00368)
#define ISP_RAWAWB_WP_NUM_SMA_0			(ISP_RAWAWB_BASE + 0x0036c)
#define ISP_RAWAWB_SUM_R_NOR_1			(ISP_RAWAWB_BASE + 0x00370)
#define ISP_RAWAWB_SUM_G_NOR_1			(ISP_RAWAWB_BASE + 0x00374)
#define ISP_RAWAWB_SUM_B_NOR_1			(ISP_RAWAWB_BASE + 0x00378)
#define ISP_RAWAWB_WP_NUM_NOR_1			(ISP_RAWAWB_BASE + 0x0037c)
#define ISP_RAWAWB_SUM_R_BIG_1			(ISP_RAWAWB_BASE + 0x00380)
#define ISP_RAWAWB_SUM_G_BIG_1			(ISP_RAWAWB_BASE + 0x00384)
#define ISP_RAWAWB_SUM_B_BIG_1			(ISP_RAWAWB_BASE + 0x00388)
#define ISP_RAWAWB_WP_NUM_BIG_1			(ISP_RAWAWB_BASE + 0x0038c)
#define ISP_RAWAWB_SUM_R_SMA_1			(ISP_RAWAWB_BASE + 0x00390)
#define ISP_RAWAWB_SUM_G_SMA_1			(ISP_RAWAWB_BASE + 0x00394)
#define ISP_RAWAWB_SUM_B_SMA_1			(ISP_RAWAWB_BASE + 0x00398)
#define ISP_RAWAWB_WP_NUM_SMA_1			(ISP_RAWAWB_BASE + 0x0039c)
#define ISP_RAWAWB_SUM_R_NOR_2			(ISP_RAWAWB_BASE + 0x003a0)
#define ISP_RAWAWB_SUM_G_NOR_2			(ISP_RAWAWB_BASE + 0x003a4)
#define ISP_RAWAWB_SUM_B_NOR_2			(ISP_RAWAWB_BASE + 0x003a8)
#define ISP_RAWAWB_WP_NUM_NOR_2			(ISP_RAWAWB_BASE + 0x003ac)
#define ISP_RAWAWB_SUM_R_BIG_2			(ISP_RAWAWB_BASE + 0x003b0)
#define ISP_RAWAWB_SUM_G_BIG_2			(ISP_RAWAWB_BASE + 0x003b4)
#define ISP_RAWAWB_SUM_B_BIG_2			(ISP_RAWAWB_BASE + 0x003b8)
#define ISP_RAWAWB_WP_NUM_BIG_2			(ISP_RAWAWB_BASE + 0x003bc)
#define ISP_RAWAWB_SUM_R_SMA_2			(ISP_RAWAWB_BASE + 0x003c0)
#define ISP_RAWAWB_SUM_G_SMA_2			(ISP_RAWAWB_BASE + 0x003c4)
#define ISP_RAWAWB_SUM_B_SMA_2			(ISP_RAWAWB_BASE + 0x003c8)
#define ISP_RAWAWB_WP_NUM_SMA_2			(ISP_RAWAWB_BASE + 0x003cc)
#define ISP_RAWAWB_SUM_R_NOR_3			(ISP_RAWAWB_BASE + 0x003d0)
#define ISP_RAWAWB_SUM_G_NOR_3			(ISP_RAWAWB_BASE + 0x003d4)
#define ISP_RAWAWB_SUM_B_NOR_3			(ISP_RAWAWB_BASE + 0x003d8)
#define ISP_RAWAWB_WP_NUM_NOR_3			(ISP_RAWAWB_BASE + 0x003dc)
#define ISP_RAWAWB_SUM_R_BIG_3			(ISP_RAWAWB_BASE + 0x003e0)
#define ISP_RAWAWB_SUM_G_BIG_3			(ISP_RAWAWB_BASE + 0x003e4)
#define ISP_RAWAWB_SUM_B_BIG_3			(ISP_RAWAWB_BASE + 0x003e8)
#define ISP_RAWAWB_WP_NUM_BIG_3			(ISP_RAWAWB_BASE + 0x003ec)
#define ISP_RAWAWB_SUM_R_SMA_3			(ISP_RAWAWB_BASE + 0x003f0)
#define ISP_RAWAWB_SUM_G_SMA_3			(ISP_RAWAWB_BASE + 0x003f4)
#define ISP_RAWAWB_SUM_B_SMA_3			(ISP_RAWAWB_BASE + 0x003f8)
#define ISP_RAWAWB_WP_NUM_SMA_3			(ISP_RAWAWB_BASE + 0x003fc)
#define ISP_RAWAWB_SUM_R_NOR_4			(ISP_RAWAWB_BASE + 0x00400)
#define ISP_RAWAWB_SUM_G_NOR_4			(ISP_RAWAWB_BASE + 0x00404)
#define ISP_RAWAWB_SUM_B_NOR_4			(ISP_RAWAWB_BASE + 0x00408)
#define ISP_RAWAWB_WP_NUM_NOR_4			(ISP_RAWAWB_BASE + 0x0040c)
#define ISP_RAWAWB_SUM_R_BIG_4			(ISP_RAWAWB_BASE + 0x00410)
#define ISP_RAWAWB_SUM_G_BIG_4			(ISP_RAWAWB_BASE + 0x00414)
#define ISP_RAWAWB_SUM_B_BIG_4			(ISP_RAWAWB_BASE + 0x00418)
#define ISP_RAWAWB_WP_NUM_BIG_4			(ISP_RAWAWB_BASE + 0x0041c)
#define ISP_RAWAWB_SUM_R_SMA_4			(ISP_RAWAWB_BASE + 0x00420)
#define ISP_RAWAWB_SUM_G_SMA_4			(ISP_RAWAWB_BASE + 0x00424)
#define ISP_RAWAWB_SUM_B_SMA_4			(ISP_RAWAWB_BASE + 0x00428)
#define ISP_RAWAWB_WP_NUM_SMA_4			(ISP_RAWAWB_BASE + 0x0042c)
#define ISP_RAWAWB_SUM_R_NOR_5			(ISP_RAWAWB_BASE + 0x00430)
#define ISP_RAWAWB_SUM_G_NOR_5			(ISP_RAWAWB_BASE + 0x00434)
#define ISP_RAWAWB_SUM_B_NOR_5			(ISP_RAWAWB_BASE + 0x00438)
#define ISP_RAWAWB_WP_NUM_NOR_5			(ISP_RAWAWB_BASE + 0x0043c)
#define ISP_RAWAWB_SUM_R_BIG_5			(ISP_RAWAWB_BASE + 0x00440)
#define ISP_RAWAWB_SUM_G_BIG_5			(ISP_RAWAWB_BASE + 0x00444)
#define ISP_RAWAWB_SUM_B_BIG_5			(ISP_RAWAWB_BASE + 0x00448)
#define ISP_RAWAWB_WP_NUM_BIG_5			(ISP_RAWAWB_BASE + 0x0044c)
#define ISP_RAWAWB_SUM_R_SMA_5			(ISP_RAWAWB_BASE + 0x00450)
#define ISP_RAWAWB_SUM_G_SMA_5			(ISP_RAWAWB_BASE + 0x00454)
#define ISP_RAWAWB_SUM_B_SMA_5			(ISP_RAWAWB_BASE + 0x00458)
#define ISP_RAWAWB_WP_NUM_SMA_5			(ISP_RAWAWB_BASE + 0x0045c)
#define ISP_RAWAWB_SUM_R_NOR_6			(ISP_RAWAWB_BASE + 0x00460)
#define ISP_RAWAWB_SUM_G_NOR_6			(ISP_RAWAWB_BASE + 0x00464)
#define ISP_RAWAWB_SUM_B_NOR_6			(ISP_RAWAWB_BASE + 0x00468)
#define ISP_RAWAWB_WP_NUM_NOR_6			(ISP_RAWAWB_BASE + 0x0046c)
#define ISP_RAWAWB_SUM_R_BIG_6			(ISP_RAWAWB_BASE + 0x00470)
#define ISP_RAWAWB_SUM_G_BIG_6			(ISP_RAWAWB_BASE + 0x00474)
#define ISP_RAWAWB_SUM_B_BIG_6			(ISP_RAWAWB_BASE + 0x00478)
#define ISP_RAWAWB_WP_NUM_BIG_6			(ISP_RAWAWB_BASE + 0x0047c)
#define ISP_RAWAWB_SUM_R_SMA_6			(ISP_RAWAWB_BASE + 0x00480)
#define ISP_RAWAWB_SUM_G_SMA_6			(ISP_RAWAWB_BASE + 0x00484)
#define ISP_RAWAWB_SUM_B_SMA_6			(ISP_RAWAWB_BASE + 0x00488)
#define ISP_RAWAWB_WP_NUM_SMA_6			(ISP_RAWAWB_BASE + 0x0048c)
#define ISP_RAWAWB_SUM_R_NOR_MULTIWINDOW_0	(ISP_RAWAWB_BASE + 0x00490)
#define ISP_RAWAWB_SUM_G_NOR_MULTIWINDOW_0	(ISP_RAWAWB_BASE + 0x00494)
#define ISP_RAWAWB_SUM_B_NOR_MULTIWINDOW_0	(ISP_RAWAWB_BASE + 0x00498)
#define ISP_RAWAWB_WP_NM_NOR_MULTIWINDOW_0	(ISP_RAWAWB_BASE + 0x0049c)
#define ISP_RAWAWB_SUM_R_BIG_MULTIWINDOW_0	(ISP_RAWAWB_BASE + 0x004a0)
#define ISP_RAWAWB_SUM_G_BIG_MULTIWINDOW_0	(ISP_RAWAWB_BASE + 0x004a4)
#define ISP_RAWAWB_SUM_B_BIG_MULTIWINDOW_0	(ISP_RAWAWB_BASE + 0x004a8)
#define ISP_RAWAWB_WP_NM_BIG_MULTIWINDOW_0	(ISP_RAWAWB_BASE + 0x004ac)
#define ISP_RAWAWB_SUM_R_SMA_MULTIWINDOW_0	(ISP_RAWAWB_BASE + 0x004b0)
#define ISP_RAWAWB_SUM_G_SMA_MULTIWINDOW_0	(ISP_RAWAWB_BASE + 0x004b4)
#define ISP_RAWAWB_SUM_B_SMA_MULTIWINDOW_0	(ISP_RAWAWB_BASE + 0x004b8)
#define ISP_RAWAWB_WP_NM_SMA_MULTIWINDOW_0	(ISP_RAWAWB_BASE + 0x004bc)
#define ISP_RAWAWB_SUM_R_NOR_MULTIWINDOW_1	(ISP_RAWAWB_BASE + 0x004c0)
#define ISP_RAWAWB_SUM_G_NOR_MULTIWINDOW_1	(ISP_RAWAWB_BASE + 0x004c4)
#define ISP_RAWAWB_SUM_B_NOR_MULTIWINDOW_1	(ISP_RAWAWB_BASE + 0x004c8)
#define ISP_RAWAWB_WP_NM_NOR_MULTIWINDOW_1	(ISP_RAWAWB_BASE + 0x004cc)
#define ISP_RAWAWB_SUM_R_BIG_MULTIWINDOW_1	(ISP_RAWAWB_BASE + 0x004d0)
#define ISP_RAWAWB_SUM_G_BIG_MULTIWINDOW_1	(ISP_RAWAWB_BASE + 0x004d4)
#define ISP_RAWAWB_SUM_B_BIG_MULTIWINDOW_1	(ISP_RAWAWB_BASE + 0x004d8)
#define ISP_RAWAWB_WP_NM_BIG_MULTIWINDOW_1	(ISP_RAWAWB_BASE + 0x004dc)
#define ISP_RAWAWB_SUM_R_SMA_MULTIWINDOW_1	(ISP_RAWAWB_BASE + 0x004e0)
#define ISP_RAWAWB_SUM_G_SMA_MULTIWINDOW_1	(ISP_RAWAWB_BASE + 0x004e4)
#define ISP_RAWAWB_SUM_B_SMA_MULTIWINDOW_1	(ISP_RAWAWB_BASE + 0x004e8)
#define ISP_RAWAWB_WP_NM_SMA_MULTIWINDOW_1	(ISP_RAWAWB_BASE + 0x004ec)
#define ISP_RAWAWB_SUM_R_NOR_MULTIWINDOW_2	(ISP_RAWAWB_BASE + 0x004f0)
#define ISP_RAWAWB_SUM_G_NOR_MULTIWINDOW_2	(ISP_RAWAWB_BASE + 0x004f4)
#define ISP_RAWAWB_SUM_B_NOR_MULTIWINDOW_2	(ISP_RAWAWB_BASE + 0x004f8)
#define ISP_RAWAWB_WP_NM_NOR_MULTIWINDOW_2	(ISP_RAWAWB_BASE + 0x004fc)
#define ISP_RAWAWB_SUM_R_BIG_MULTIWINDOW_2	(ISP_RAWAWB_BASE + 0x00500)
#define ISP_RAWAWB_SUM_G_BIG_MULTIWINDOW_2	(ISP_RAWAWB_BASE + 0x00504)
#define ISP_RAWAWB_SUM_B_BIG_MULTIWINDOW_2	(ISP_RAWAWB_BASE + 0x00508)
#define ISP_RAWAWB_WP_NM_BIG_MULTIWINDOW_2	(ISP_RAWAWB_BASE + 0x0050c)
#define ISP_RAWAWB_SUM_R_SMA_MULTIWINDOW_2	(ISP_RAWAWB_BASE + 0x00510)
#define ISP_RAWAWB_SUM_G_SMA_MULTIWINDOW_2	(ISP_RAWAWB_BASE + 0x00514)
#define ISP_RAWAWB_SUM_B_SMA_MULTIWINDOW_2	(ISP_RAWAWB_BASE + 0x00518)
#define ISP_RAWAWB_WP_NM_SMA_MULTIWINDOW_2	(ISP_RAWAWB_BASE + 0x0051c)
#define ISP_RAWAWB_SUM_R_NOR_MULTIWINDOW_3	(ISP_RAWAWB_BASE + 0x00520)
#define ISP_RAWAWB_SUM_G_NOR_MULTIWINDOW_3	(ISP_RAWAWB_BASE + 0x00524)
#define ISP_RAWAWB_SUM_B_NOR_MULTIWINDOW_3	(ISP_RAWAWB_BASE + 0x00528)
#define ISP_RAWAWB_WP_NM_NOR_MULTIWINDOW_3	(ISP_RAWAWB_BASE + 0x0052c)
#define ISP_RAWAWB_SUM_R_BIG_MULTIWINDOW_3	(ISP_RAWAWB_BASE + 0x00530)
#define ISP_RAWAWB_SUM_G_BIG_MULTIWINDOW_3	(ISP_RAWAWB_BASE + 0x00534)
#define ISP_RAWAWB_SUM_B_BIG_MULTIWINDOW_3	(ISP_RAWAWB_BASE + 0x00538)
#define ISP_RAWAWB_WP_NM_BIG_MULTIWINDOW_3	(ISP_RAWAWB_BASE + 0x0053c)
#define ISP_RAWAWB_SUM_R_SMA_MULTIWINDOW_3	(ISP_RAWAWB_BASE + 0x00540)
#define ISP_RAWAWB_SUM_G_SMA_MULTIWINDOW_3	(ISP_RAWAWB_BASE + 0x00544)
#define ISP_RAWAWB_SUM_B_SMA_MULTIWINDOW_3	(ISP_RAWAWB_BASE + 0x00548)
#define ISP_RAWAWB_WP_NM_SMA_MULTIWINDOW_3	(ISP_RAWAWB_BASE + 0x0054c)
#define ISP_RAWAWB_SUM_R_NOR_MULTIWINDOW_4	(ISP_RAWAWB_BASE + 0x00550)
#define ISP_RAWAWB_SUM_G_NOR_MULTIWINDOW_4	(ISP_RAWAWB_BASE + 0x00554)
#define ISP_RAWAWB_SUM_B_NOR_MULTIWINDOW_4	(ISP_RAWAWB_BASE + 0x00558)
#define ISP_RAWAWB_WP_NM_NOR_MULTIWINDOW_4	(ISP_RAWAWB_BASE + 0x0055c)
#define ISP_RAWAWB_SUM_R_BIG_MULTIWINDOW_4	(ISP_RAWAWB_BASE + 0x00560)
#define ISP_RAWAWB_SUM_G_BIG_MULTIWINDOW_4	(ISP_RAWAWB_BASE + 0x00564)
#define ISP_RAWAWB_SUM_B_BIG_MULTIWINDOW_4	(ISP_RAWAWB_BASE + 0x00568)
#define ISP_RAWAWB_WP_NM_BIG_MULTIWINDOW_4	(ISP_RAWAWB_BASE + 0x0056c)
#define ISP_RAWAWB_SUM_R_SMA_MULTIWINDOW_4	(ISP_RAWAWB_BASE + 0x00570)
#define ISP_RAWAWB_SUM_G_SMA_MULTIWINDOW_4	(ISP_RAWAWB_BASE + 0x00574)
#define ISP_RAWAWB_SUM_B_SMA_MULTIWINDOW_4	(ISP_RAWAWB_BASE + 0x00578)
#define ISP_RAWAWB_WP_NM_SMA_MULTIWINDOW_4	(ISP_RAWAWB_BASE + 0x0057c)
#define ISP_RAWAWB_SUM_R_NOR_MULTIWINDOW_5	(ISP_RAWAWB_BASE + 0x00580)
#define ISP_RAWAWB_SUM_G_NOR_MULTIWINDOW_5	(ISP_RAWAWB_BASE + 0x00584)
#define ISP_RAWAWB_SUM_B_NOR_MULTIWINDOW_5	(ISP_RAWAWB_BASE + 0x00588)
#define ISP_RAWAWB_WP_NM_NOR_MULTIWINDOW_5	(ISP_RAWAWB_BASE + 0x0058c)
#define ISP_RAWAWB_SUM_R_BIG_MULTIWINDOW_5	(ISP_RAWAWB_BASE + 0x00590)
#define ISP_RAWAWB_SUM_G_BIG_MULTIWINDOW_5	(ISP_RAWAWB_BASE + 0x00594)
#define ISP_RAWAWB_SUM_B_BIG_MULTIWINDOW_5	(ISP_RAWAWB_BASE + 0x00598)
#define ISP_RAWAWB_WP_NM_BIG_MULTIWINDOW_5	(ISP_RAWAWB_BASE + 0x0059c)
#define ISP_RAWAWB_SUM_R_SMA_MULTIWINDOW_5	(ISP_RAWAWB_BASE + 0x005a0)
#define ISP_RAWAWB_SUM_G_SMA_MULTIWINDOW_5	(ISP_RAWAWB_BASE + 0x005a4)
#define ISP_RAWAWB_SUM_B_SMA_MULTIWINDOW_5	(ISP_RAWAWB_BASE + 0x005a8)
#define ISP_RAWAWB_WP_NM_SMA_MULTIWINDOW_5	(ISP_RAWAWB_BASE + 0x005ac)
#define ISP_RAWAWB_SUM_R_NOR_MULTIWINDOW_6	(ISP_RAWAWB_BASE + 0x005b0)
#define ISP_RAWAWB_SUM_G_NOR_MULTIWINDOW_6	(ISP_RAWAWB_BASE + 0x005b4)
#define ISP_RAWAWB_SUM_B_NOR_MULTIWINDOW_6	(ISP_RAWAWB_BASE + 0x005b8)
#define ISP_RAWAWB_WP_NM_NOR_MULTIWINDOW_6	(ISP_RAWAWB_BASE + 0x005bc)
#define ISP_RAWAWB_SUM_R_BIG_MULTIWINDOW_6	(ISP_RAWAWB_BASE + 0x005c0)
#define ISP_RAWAWB_SUM_G_BIG_MULTIWINDOW_6	(ISP_RAWAWB_BASE + 0x005c4)
#define ISP_RAWAWB_SUM_B_BIG_MULTIWINDOW_6	(ISP_RAWAWB_BASE + 0x005c8)
#define ISP_RAWAWB_WP_NM_BIG_MULTIWINDOW_6	(ISP_RAWAWB_BASE + 0x005cc)
#define ISP_RAWAWB_SUM_R_SMA_MULTIWINDOW_6	(ISP_RAWAWB_BASE + 0x005d0)
#define ISP_RAWAWB_SUM_G_SMA_MULTIWINDOW_6	(ISP_RAWAWB_BASE + 0x005d4)
#define ISP_RAWAWB_SUM_B_SMA_MULTIWINDOW_6	(ISP_RAWAWB_BASE + 0x005d8)
#define ISP_RAWAWB_WP_NM_SMA_MULTIWINDOW_6	(ISP_RAWAWB_BASE + 0x005dc)
#define ISP_RAWAWB_SUM_R_EXC_0			(ISP_RAWAWB_BASE + 0x005e0)
#define ISP_RAWAWB_SUM_G_EXC_0			(ISP_RAWAWB_BASE + 0x005e4)
#define ISP_RAWAWB_SUM_B_EXC_0			(ISP_RAWAWB_BASE + 0x005e8)
#define ISP_RAWAWB_WP_NM_EXC_0			(ISP_RAWAWB_BASE + 0x005ec)
#define ISP_RAWAWB_SUM_R_EXC_1			(ISP_RAWAWB_BASE + 0x005f0)
#define ISP_RAWAWB_SUM_G_EXC_1			(ISP_RAWAWB_BASE + 0x005f4)
#define ISP_RAWAWB_SUM_B_EXC_1			(ISP_RAWAWB_BASE + 0x005f8)
#define ISP_RAWAWB_WP_NM_EXC_1			(ISP_RAWAWB_BASE + 0x005fc)
#define ISP_RAWAWB_SUM_R_EXC_2			(ISP_RAWAWB_BASE + 0x00600)
#define ISP_RAWAWB_SUM_G_EXC_2			(ISP_RAWAWB_BASE + 0x00604)
#define ISP_RAWAWB_SUM_B_EXC_2			(ISP_RAWAWB_BASE + 0x00608)
#define ISP_RAWAWB_WP_NM_EXC_2			(ISP_RAWAWB_BASE + 0x0060c)
#define ISP_RAWAWB_SUM_R_EXC_3			(ISP_RAWAWB_BASE + 0x00610)
#define ISP_RAWAWB_SUM_G_EXC_3			(ISP_RAWAWB_BASE + 0x00614)
#define ISP_RAWAWB_SUM_B_EXC_3			(ISP_RAWAWB_BASE + 0x00618)
#define ISP_RAWAWB_WP_NM_EXC_3			(ISP_RAWAWB_BASE + 0x0061c)
#define ISP_RAWAWB_SUM_R_EXC_4			(ISP_RAWAWB_BASE + 0x00620)
#define ISP_RAWAWB_SUM_G_EXC_4			(ISP_RAWAWB_BASE + 0x00624)
#define ISP_RAWAWB_SUM_B_EXC_4			(ISP_RAWAWB_BASE + 0x00628)
#define ISP_RAWAWB_WP_NM_EXC_4			(ISP_RAWAWB_BASE + 0x0062c)
#define ISP_RAWAWB_SUM_R_EXC_5			(ISP_RAWAWB_BASE + 0x00630)
#define ISP_RAWAWB_SUM_G_EXC_5			(ISP_RAWAWB_BASE + 0x00634)
#define ISP_RAWAWB_SUM_B_EXC_5			(ISP_RAWAWB_BASE + 0x00638)
#define ISP_RAWAWB_WP_NM_EXC_5			(ISP_RAWAWB_BASE + 0x0063c)
#define ISP_RAWAWB_SUM_R_EXC_6			(ISP_RAWAWB_BASE + 0x00640)
#define ISP_RAWAWB_SUM_G_EXC_6			(ISP_RAWAWB_BASE + 0x00644)
#define ISP_RAWAWB_SUM_B_EXC_6			(ISP_RAWAWB_BASE + 0x00648)
#define ISP_RAWAWB_WP_NM_EXC_6			(ISP_RAWAWB_BASE + 0x0064c)
#define ISP_RAWAWB_RAM_CTRL			(ISP_RAWAWB_BASE + 0x00650)
#define ISP_RAWAWB_RAM_DATA			(ISP_RAWAWB_BASE + 0x00660)

#define ISP21_RAWAWB_BASE                        0x00005000
#define ISP21_RAWAWB_CTRL                        (ISP21_RAWAWB_BASE + 0x0000)
#define ISP21_RAWAWB_BLK_CTRL                    (ISP21_RAWAWB_BASE + 0x0004)
#define ISP21_RAWAWB_WIN_OFFS                    (ISP21_RAWAWB_BASE + 0x0008)
#define ISP21_RAWAWB_WIN_SIZE                    (ISP21_RAWAWB_BASE + 0x000c)
#define ISP21_RAWAWB_LIMIT_RG_MAX                (ISP21_RAWAWB_BASE + 0x0010)
#define ISP21_RAWAWB_LIMIT_BY_MAX                (ISP21_RAWAWB_BASE + 0x0014)
#define ISP21_RAWAWB_LIMIT_RG_MIN                (ISP21_RAWAWB_BASE + 0x0018)
#define ISP21_RAWAWB_LIMIT_BY_MIN                (ISP21_RAWAWB_BASE + 0x001c)
#define ISP21_RAWAWB_WEIGHT_CURVE_CTRL           (ISP21_RAWAWB_BASE + 0x0020)
#define ISP21_RAWAWB_YWEIGHT_CURVE_XCOOR03       (ISP21_RAWAWB_BASE + 0x0024)
#define ISP21_RAWAWB_YWEIGHT_CURVE_XCOOR47       (ISP21_RAWAWB_BASE + 0x0028)
#define ISP21_RAWAWB_YWEIGHT_CURVE_XCOOR8        (ISP21_RAWAWB_BASE + 0x002c)
#define ISP21_RAWAWB_YWEIGHT_CURVE_YCOOR03       (ISP21_RAWAWB_BASE + 0x0030)
#define ISP21_RAWAWB_YWEIGHT_CURVE_YCOOR47       (ISP21_RAWAWB_BASE + 0x0034)
#define ISP21_RAWAWB_YWEIGHT_CURVE_YCOOR8        (ISP21_RAWAWB_BASE + 0x0038)
#define ISP21_RAWAWB_PRE_WBGAIN_INV              (ISP21_RAWAWB_BASE + 0x003c)
#define ISP21_RAWAWB_UV_DETC_VERTEX0_0           (ISP21_RAWAWB_BASE + 0x0040)
#define ISP21_RAWAWB_UV_DETC_VERTEX1_0           (ISP21_RAWAWB_BASE + 0x0044)
#define ISP21_RAWAWB_UV_DETC_VERTEX2_0           (ISP21_RAWAWB_BASE + 0x0048)
#define ISP21_RAWAWB_UV_DETC_VERTEX3_0           (ISP21_RAWAWB_BASE + 0x004c)
#define ISP21_RAWAWB_UV_DETC_ISLOPE01_0          (ISP21_RAWAWB_BASE + 0x0050)
#define ISP21_RAWAWB_UV_DETC_ISLOPE12_0          (ISP21_RAWAWB_BASE + 0x0054)
#define ISP21_RAWAWB_UV_DETC_ISLOPE23_0          (ISP21_RAWAWB_BASE + 0x0058)
#define ISP21_RAWAWB_UV_DETC_ISLOPE30_0          (ISP21_RAWAWB_BASE + 0x005c)
#define ISP21_RAWAWB_UV_DETC_VERTEX0_1           (ISP21_RAWAWB_BASE + 0x0060)
#define ISP21_RAWAWB_UV_DETC_VERTEX1_1           (ISP21_RAWAWB_BASE + 0x0064)
#define ISP21_RAWAWB_UV_DETC_VERTEX2_1           (ISP21_RAWAWB_BASE + 0x0068)
#define ISP21_RAWAWB_UV_DETC_VERTEX3_1           (ISP21_RAWAWB_BASE + 0x006c)
#define ISP21_RAWAWB_UV_DETC_ISLOPE01_1          (ISP21_RAWAWB_BASE + 0x0070)
#define ISP21_RAWAWB_UV_DETC_ISLOPE12_1          (ISP21_RAWAWB_BASE + 0x0074)
#define ISP21_RAWAWB_UV_DETC_ISLOPE23_1          (ISP21_RAWAWB_BASE + 0x0078)
#define ISP21_RAWAWB_UV_DETC_ISLOPE30_1          (ISP21_RAWAWB_BASE + 0x007c)
#define ISP21_RAWAWB_UV_DETC_VERTEX0_2           (ISP21_RAWAWB_BASE + 0x0080)
#define ISP21_RAWAWB_UV_DETC_VERTEX1_2           (ISP21_RAWAWB_BASE + 0x0084)
#define ISP21_RAWAWB_UV_DETC_VERTEX2_2           (ISP21_RAWAWB_BASE + 0x0088)
#define ISP21_RAWAWB_UV_DETC_VERTEX3_2           (ISP21_RAWAWB_BASE + 0x008c)
#define ISP21_RAWAWB_UV_DETC_ISLOPE01_2          (ISP21_RAWAWB_BASE + 0x0090)
#define ISP21_RAWAWB_UV_DETC_ISLOPE12_2          (ISP21_RAWAWB_BASE + 0x0094)
#define ISP21_RAWAWB_UV_DETC_ISLOPE23_2          (ISP21_RAWAWB_BASE + 0x0098)
#define ISP21_RAWAWB_UV_DETC_ISLOPE30_2          (ISP21_RAWAWB_BASE + 0x009c)
#define ISP21_RAWAWB_UV_DETC_VERTEX0_3           (ISP21_RAWAWB_BASE + 0x00a0)
#define ISP21_RAWAWB_UV_DETC_VERTEX1_3           (ISP21_RAWAWB_BASE + 0x00a4)
#define ISP21_RAWAWB_UV_DETC_VERTEX2_3           (ISP21_RAWAWB_BASE + 0x00a8)
#define ISP21_RAWAWB_UV_DETC_VERTEX3_3           (ISP21_RAWAWB_BASE + 0x00ac)
#define ISP21_RAWAWB_UV_DETC_ISLOPE01_3          (ISP21_RAWAWB_BASE + 0x00b0)
#define ISP21_RAWAWB_UV_DETC_ISLOPE12_3          (ISP21_RAWAWB_BASE + 0x00b4)
#define ISP21_RAWAWB_UV_DETC_ISLOPE23_3          (ISP21_RAWAWB_BASE + 0x00b8)
#define ISP21_RAWAWB_UV_DETC_ISLOPE30_3          (ISP21_RAWAWB_BASE + 0x00bc)
#define ISP21_RAWAWB_UV_DETC_VERTEX0_4           (ISP21_RAWAWB_BASE + 0x00c0)
#define ISP21_RAWAWB_UV_DETC_VERTEX1_4           (ISP21_RAWAWB_BASE + 0x00c4)
#define ISP21_RAWAWB_UV_DETC_VERTEX2_4           (ISP21_RAWAWB_BASE + 0x00c8)
#define ISP21_RAWAWB_UV_DETC_VERTEX3_4           (ISP21_RAWAWB_BASE + 0x00cc)
#define ISP21_RAWAWB_UV_DETC_ISLOPE01_4          (ISP21_RAWAWB_BASE + 0x00d0)
#define ISP21_RAWAWB_UV_DETC_ISLOPE12_4          (ISP21_RAWAWB_BASE + 0x00d4)
#define ISP21_RAWAWB_UV_DETC_ISLOPE23_4          (ISP21_RAWAWB_BASE + 0x00d8)
#define ISP21_RAWAWB_UV_DETC_ISLOPE30_4          (ISP21_RAWAWB_BASE + 0x00dc)
#define ISP21_RAWAWB_UV_DETC_VERTEX0_5           (ISP21_RAWAWB_BASE + 0x00e0)
#define ISP21_RAWAWB_UV_DETC_VERTEX1_5           (ISP21_RAWAWB_BASE + 0x00e4)
#define ISP21_RAWAWB_UV_DETC_VERTEX2_5           (ISP21_RAWAWB_BASE + 0x00e8)
#define ISP21_RAWAWB_UV_DETC_VERTEX3_5           (ISP21_RAWAWB_BASE + 0x00ec)
#define ISP21_RAWAWB_UV_DETC_ISLOPE01_5          (ISP21_RAWAWB_BASE + 0x00f0)
#define ISP21_RAWAWB_UV_DETC_ISLOPE10_5          (ISP21_RAWAWB_BASE + 0x00f4)
#define ISP21_RAWAWB_UV_DETC_ISLOPE23_5          (ISP21_RAWAWB_BASE + 0x00f8)
#define ISP21_RAWAWB_UV_DETC_ISLOPE30_5          (ISP21_RAWAWB_BASE + 0x00fc)
#define ISP21_RAWAWB_UV_DETC_VERTEX0_6           (ISP21_RAWAWB_BASE + 0x0100)
#define ISP21_RAWAWB_UV_DETC_VERTEX1_6           (ISP21_RAWAWB_BASE + 0x0104)
#define ISP21_RAWAWB_UV_DETC_VERTEX2_6           (ISP21_RAWAWB_BASE + 0x0108)
#define ISP21_RAWAWB_UV_DETC_VERTEX3_6           (ISP21_RAWAWB_BASE + 0x010c)
#define ISP21_RAWAWB_UV_DETC_ISLOPE01_6          (ISP21_RAWAWB_BASE + 0x0110)
#define ISP21_RAWAWB_UV_DETC_ISLOPE10_6          (ISP21_RAWAWB_BASE + 0x0114)
#define ISP21_RAWAWB_UV_DETC_ISLOPE23_6          (ISP21_RAWAWB_BASE + 0x0118)
#define ISP21_RAWAWB_UV_DETC_ISLOPE30_6          (ISP21_RAWAWB_BASE + 0x011c)
#define ISP21_RAWAWB_YUV_RGB2ROTY_0              (ISP21_RAWAWB_BASE + 0x0120)
#define ISP21_RAWAWB_YUV_RGB2ROTY_1              (ISP21_RAWAWB_BASE + 0x0124)
#define ISP21_RAWAWB_YUV_RGB2ROTU_0              (ISP21_RAWAWB_BASE + 0x0128)
#define ISP21_RAWAWB_YUV_RGB2ROTU_1              (ISP21_RAWAWB_BASE + 0x012c)
#define ISP21_RAWAWB_YUV_RGB2ROTV_0              (ISP21_RAWAWB_BASE + 0x0130)
#define ISP21_RAWAWB_YUV_RGB2ROTV_1              (ISP21_RAWAWB_BASE + 0x0134)
#define ISP21_RAWAWB_YUV_X_COOR_Y_0              (ISP21_RAWAWB_BASE + 0x0140)
#define ISP21_RAWAWB_YUV_X_COOR_U_0              (ISP21_RAWAWB_BASE + 0x0144)
#define ISP21_RAWAWB_YUV_X_COOR_V_0              (ISP21_RAWAWB_BASE + 0x0148)
#define ISP21_RAWAWB_YUV_X1X2_DIS_0              (ISP21_RAWAWB_BASE + 0x014c)
#define ISP21_RAWAWB_YUV_INTERP_CURVE_UCOOR_0    (ISP21_RAWAWB_BASE + 0x0150)
#define ISP21_RAWAWB_YUV_INTERP_CURVE_TH0_0      (ISP21_RAWAWB_BASE + 0x0154)
#define ISP21_RAWAWB_YUV_INTERP_CURVE_TH1_0      (ISP21_RAWAWB_BASE + 0x0158)
#define ISP21_RAWAWB_YUV_INTERP_CURVE_TH2_0      (ISP21_RAWAWB_BASE + 0x015c)
#define ISP21_RAWAWB_YUV_X_COOR_Y_1              (ISP21_RAWAWB_BASE + 0x0160)
#define ISP21_RAWAWB_YUV_X_COOR_U_1              (ISP21_RAWAWB_BASE + 0x0164)
#define ISP21_RAWAWB_YUV_X_COOR_V_1              (ISP21_RAWAWB_BASE + 0x0168)
#define ISP21_RAWAWB_YUV_X1X2_DIS_1              (ISP21_RAWAWB_BASE + 0x016c)
#define ISP21_RAWAWB_YUV_INTERP_CURVE_UCOOR_1    (ISP21_RAWAWB_BASE + 0x0170)
#define ISP21_RAWAWB_YUV_INTERP_CURVE_TH0_1      (ISP21_RAWAWB_BASE + 0x0174)
#define ISP21_RAWAWB_YUV_INTERP_CURVE_TH1_1      (ISP21_RAWAWB_BASE + 0x0178)
#define ISP21_RAWAWB_YUV_INTERP_CURVE_TH2_1      (ISP21_RAWAWB_BASE + 0x017c)
#define ISP21_RAWAWB_YUV_X_COOR_Y_2              (ISP21_RAWAWB_BASE + 0x0180)
#define ISP21_RAWAWB_YUV_X_COOR_U_2              (ISP21_RAWAWB_BASE + 0x0184)
#define ISP21_RAWAWB_YUV_X_COOR_V_2              (ISP21_RAWAWB_BASE + 0x0188)
#define ISP21_RAWAWB_YUV_X1X2_DIS_2              (ISP21_RAWAWB_BASE + 0x018c)
#define ISP21_RAWAWB_YUV_INTERP_CURVE_UCOOR_2    (ISP21_RAWAWB_BASE + 0x0190)
#define ISP21_RAWAWB_YUV_INTERP_CURVE_TH0_2      (ISP21_RAWAWB_BASE + 0x0194)
#define ISP21_RAWAWB_YUV_INTERP_CURVE_TH1_2      (ISP21_RAWAWB_BASE + 0x0198)
#define ISP21_RAWAWB_YUV_INTERP_CURVE_TH2_2      (ISP21_RAWAWB_BASE + 0x019c)
#define ISP21_RAWAWB_YUV_X_COOR_Y_3              (ISP21_RAWAWB_BASE + 0x01a0)
#define ISP21_RAWAWB_YUV_X_COOR_U_3              (ISP21_RAWAWB_BASE + 0x01a4)
#define ISP21_RAWAWB_YUV_X_COOR_V_3              (ISP21_RAWAWB_BASE + 0x01a8)
#define ISP21_RAWAWB_YUV_X1X2_DIS_3              (ISP21_RAWAWB_BASE + 0x01ac)
#define ISP21_RAWAWB_YUV_INTERP_CURVE_UCOOR_3    (ISP21_RAWAWB_BASE + 0x01b0)
#define ISP21_RAWAWB_YUV_INTERP_CURVE_TH0_3      (ISP21_RAWAWB_BASE + 0x01b4)
#define ISP21_RAWAWB_YUV_INTERP_CURVE_TH1_3      (ISP21_RAWAWB_BASE + 0x01b8)
#define ISP21_RAWAWB_YUV_INTERP_CURVE_TH2_3      (ISP21_RAWAWB_BASE + 0x01bc)
#define ISP21_RAWAWB_RGB2XY_WT01                 (ISP21_RAWAWB_BASE + 0x01fc)
#define ISP21_RAWAWB_RGB2XY_WT2                  (ISP21_RAWAWB_BASE + 0x0200)
#define ISP21_RAWAWB_RGB2XY_MAT0_XY              (ISP21_RAWAWB_BASE + 0x0204)
#define ISP21_RAWAWB_RGB2XY_MAT1_XY              (ISP21_RAWAWB_BASE + 0x0208)
#define ISP21_RAWAWB_RGB2XY_MAT2_XY              (ISP21_RAWAWB_BASE + 0x020c)
#define ISP21_RAWAWB_XY_DETC_NOR_X_0             (ISP21_RAWAWB_BASE + 0x0210)
#define ISP21_RAWAWB_XY_DETC_NOR_Y_0             (ISP21_RAWAWB_BASE + 0x0214)
#define ISP21_RAWAWB_XY_DETC_BIG_X_0             (ISP21_RAWAWB_BASE + 0x0218)
#define ISP21_RAWAWB_XY_DETC_BIG_Y_0             (ISP21_RAWAWB_BASE + 0x021c)
#define ISP21_RAWAWB_XY_DETC_NOR_X_1             (ISP21_RAWAWB_BASE + 0x0228)
#define ISP21_RAWAWB_XY_DETC_NOR_Y_1             (ISP21_RAWAWB_BASE + 0x022c)
#define ISP21_RAWAWB_XY_DETC_BIG_X_1             (ISP21_RAWAWB_BASE + 0x0230)
#define ISP21_RAWAWB_XY_DETC_BIG_Y_1             (ISP21_RAWAWB_BASE + 0x0234)
#define ISP21_RAWAWB_XY_DETC_NOR_X_2             (ISP21_RAWAWB_BASE + 0x0240)
#define ISP21_RAWAWB_XY_DETC_NOR_Y_2             (ISP21_RAWAWB_BASE + 0x0244)
#define ISP21_RAWAWB_XY_DETC_BIG_X_2             (ISP21_RAWAWB_BASE + 0x0248)
#define ISP21_RAWAWB_XY_DETC_BIG_Y_2             (ISP21_RAWAWB_BASE + 0x024c)
#define ISP21_RAWAWB_XY_DETC_NOR_X_3             (ISP21_RAWAWB_BASE + 0x0258)
#define ISP21_RAWAWB_XY_DETC_NOR_Y_3             (ISP21_RAWAWB_BASE + 0x025c)
#define ISP21_RAWAWB_XY_DETC_BIG_X_3             (ISP21_RAWAWB_BASE + 0x0260)
#define ISP21_RAWAWB_XY_DETC_BIG_Y_3             (ISP21_RAWAWB_BASE + 0x0264)
#define ISP21_RAWAWB_XY_DETC_NOR_X_4             (ISP21_RAWAWB_BASE + 0x0270)
#define ISP21_RAWAWB_XY_DETC_NOR_Y_4             (ISP21_RAWAWB_BASE + 0x0274)
#define ISP21_RAWAWB_XY_DETC_BIG_X_4             (ISP21_RAWAWB_BASE + 0x0278)
#define ISP21_RAWAWB_XY_DETC_BIG_Y_4             (ISP21_RAWAWB_BASE + 0x027c)
#define ISP21_RAWAWB_XY_DETC_NOR_X_5             (ISP21_RAWAWB_BASE + 0x0288)
#define ISP21_RAWAWB_XY_DETC_NOR_Y_5             (ISP21_RAWAWB_BASE + 0x028c)
#define ISP21_RAWAWB_XY_DETC_BIG_X_5             (ISP21_RAWAWB_BASE + 0x0290)
#define ISP21_RAWAWB_XY_DETC_BIG_Y_5             (ISP21_RAWAWB_BASE + 0x0294)
#define ISP21_RAWAWB_XY_DETC_NOR_X_6             (ISP21_RAWAWB_BASE + 0x02a0)
#define ISP21_RAWAWB_XY_DETC_NOR_Y_6             (ISP21_RAWAWB_BASE + 0x02a4)
#define ISP21_RAWAWB_XY_DETC_BIG_X_6             (ISP21_RAWAWB_BASE + 0x02a8)
#define ISP21_RAWAWB_XY_DETC_BIG_Y_6             (ISP21_RAWAWB_BASE + 0x02ac)
#define ISP21_RAWAWB_MULTIWINDOW_EXC_CTRL        (ISP21_RAWAWB_BASE + 0x02b8)
#define ISP21_RAWAWB_EXC_WP_REGION0_XU           (ISP21_RAWAWB_BASE + 0x02fc)
#define ISP21_RAWAWB_EXC_WP_REGION0_YV           (ISP21_RAWAWB_BASE + 0x0300)
#define ISP21_RAWAWB_EXC_WP_REGION1_XU           (ISP21_RAWAWB_BASE + 0x0304)
#define ISP21_RAWAWB_EXC_WP_REGION1_YV           (ISP21_RAWAWB_BASE + 0x0308)
#define ISP21_RAWAWB_EXC_WP_REGION2_XU           (ISP21_RAWAWB_BASE + 0x030c)
#define ISP21_RAWAWB_EXC_WP_REGION2_YV           (ISP21_RAWAWB_BASE + 0x0310)
#define ISP21_RAWAWB_EXC_WP_REGION3_XU           (ISP21_RAWAWB_BASE + 0x0314)
#define ISP21_RAWAWB_EXC_WP_REGION3_YV           (ISP21_RAWAWB_BASE + 0x0318)
#define ISP21_RAWAWB_EXC_WP_REGION4_XU           (ISP21_RAWAWB_BASE + 0x031c)
#define ISP21_RAWAWB_EXC_WP_REGION4_YV           (ISP21_RAWAWB_BASE + 0x0320)
#define ISP21_RAWAWB_EXC_WP_REGION5_XU           (ISP21_RAWAWB_BASE + 0x0324)
#define ISP21_RAWAWB_EXC_WP_REGION5_YV           (ISP21_RAWAWB_BASE + 0x0328)
#define ISP21_RAWAWB_EXC_WP_REGION6_XU           (ISP21_RAWAWB_BASE + 0x032c)
#define ISP21_RAWAWB_EXC_WP_REGION6_YV           (ISP21_RAWAWB_BASE + 0x0330)
#define ISP21_RAWAWB_SUM_RGAIN_NOR_0             (ISP21_RAWAWB_BASE + 0x0340)
#define ISP21_RAWAWB_SUM_BGAIN_NOR_0             (ISP21_RAWAWB_BASE + 0x0348)
#define ISP21_RAWAWB_WP_NUM_NOR_0                (ISP21_RAWAWB_BASE + 0x034c)
#define ISP21_RAWAWB_SUM_RGAIN_BIG_0             (ISP21_RAWAWB_BASE + 0x0350)
#define ISP21_RAWAWB_SUM_BGAIN_BIG_0             (ISP21_RAWAWB_BASE + 0x0358)
#define ISP21_RAWAWB_WP_NUM_BIG_0                (ISP21_RAWAWB_BASE + 0x035c)
#define ISP21_RAWAWB_SUM_RGAIN_NOR_1             (ISP21_RAWAWB_BASE + 0x0370)
#define ISP21_RAWAWB_SUM_BGAIN_NOR_1             (ISP21_RAWAWB_BASE + 0x0378)
#define ISP21_RAWAWB_WP_NUM_NOR_1                (ISP21_RAWAWB_BASE + 0x037c)
#define ISP21_RAWAWB_SUM_RGAIN_BIG_1             (ISP21_RAWAWB_BASE + 0x0380)
#define ISP21_RAWAWB_SUM_BGAIN_BIG_1             (ISP21_RAWAWB_BASE + 0x0388)
#define ISP21_RAWAWB_WP_NUM_BIG_1                (ISP21_RAWAWB_BASE + 0x038c)
#define ISP21_RAWAWB_SUM_RGAIN_NOR_2             (ISP21_RAWAWB_BASE + 0x03a0)
#define ISP21_RAWAWB_SUM_BGAIN_NOR_2             (ISP21_RAWAWB_BASE + 0x03a8)
#define ISP21_RAWAWB_WP_NUM_NOR_2                (ISP21_RAWAWB_BASE + 0x03ac)
#define ISP21_RAWAWB_SUM_RGAIN_BIG_2             (ISP21_RAWAWB_BASE + 0x03b0)
#define ISP21_RAWAWB_SUM_BGAIN_BIG_2             (ISP21_RAWAWB_BASE + 0x03b8)
#define ISP21_RAWAWB_WP_NUM_BIG_2                (ISP21_RAWAWB_BASE + 0x03bc)
#define ISP21_RAWAWB_SUM_RGAIN_NOR_3             (ISP21_RAWAWB_BASE + 0x03d0)
#define ISP21_RAWAWB_SUM_BGAIN_NOR_3             (ISP21_RAWAWB_BASE + 0x03d8)
#define ISP21_RAWAWB_WP_NUM_NOR_3                (ISP21_RAWAWB_BASE + 0x03dc)
#define ISP21_RAWAWB_SUM_RGAIN_BIG_3             (ISP21_RAWAWB_BASE + 0x03e0)
#define ISP21_RAWAWB_SUM_BGAIN_BIG_3             (ISP21_RAWAWB_BASE + 0x03e8)
#define ISP21_RAWAWB_WP_NUM_BIG_3                (ISP21_RAWAWB_BASE + 0x03ec)
#define ISP21_RAWAWB_SUM_RGAIN_NOR_4             (ISP21_RAWAWB_BASE + 0x0400)
#define ISP21_RAWAWB_SUM_BGAIN_NOR_4             (ISP21_RAWAWB_BASE + 0x0408)
#define ISP21_RAWAWB_WP_NUM_NOR_4                (ISP21_RAWAWB_BASE + 0x040c)
#define ISP21_RAWAWB_SUM_RGAIN_BIG_4             (ISP21_RAWAWB_BASE + 0x0410)
#define ISP21_RAWAWB_SUM_BGAIN_BIG_4             (ISP21_RAWAWB_BASE + 0x0418)
#define ISP21_RAWAWB_WP_NUM_BIG_4                (ISP21_RAWAWB_BASE + 0x041c)
#define ISP21_RAWAWB_SUM_RGAIN_NOR_5             (ISP21_RAWAWB_BASE + 0x0430)
#define ISP21_RAWAWB_SUM_BGAIN_NOR_5             (ISP21_RAWAWB_BASE + 0x0438)
#define ISP21_RAWAWB_WP_NUM_NOR_5                (ISP21_RAWAWB_BASE + 0x043c)
#define ISP21_RAWAWB_SUM_RGAIN_BIG_5             (ISP21_RAWAWB_BASE + 0x0440)
#define ISP21_RAWAWB_SUM_BGAIN_BIG_5             (ISP21_RAWAWB_BASE + 0x0448)
#define ISP21_RAWAWB_WP_NUM_BIG_5                (ISP21_RAWAWB_BASE + 0x044c)
#define ISP21_RAWAWB_SUM_RGAIN_NOR_6             (ISP21_RAWAWB_BASE + 0x0460)
#define ISP21_RAWAWB_SUM_BGAIN_NOR_6             (ISP21_RAWAWB_BASE + 0x0468)
#define ISP21_RAWAWB_WP_NUM_NOR_6                (ISP21_RAWAWB_BASE + 0x046c)
#define ISP21_RAWAWB_SUM_RGAIN_BIG_6             (ISP21_RAWAWB_BASE + 0x0470)
#define ISP21_RAWAWB_SUM_BGAIN_BIG_6             (ISP21_RAWAWB_BASE + 0x0478)
#define ISP21_RAWAWB_WP_NUM_BIG_6                (ISP21_RAWAWB_BASE + 0x047c)
#define ISP21_RAWAWB_Y_HIST01                    (ISP21_RAWAWB_BASE + 0x0620)
#define ISP21_RAWAWB_Y_HIST23                    (ISP21_RAWAWB_BASE + 0x0624)
#define ISP21_RAWAWB_Y_HIST45                    (ISP21_RAWAWB_BASE + 0x0628)
#define ISP21_RAWAWB_Y_HIST67                    (ISP21_RAWAWB_BASE + 0x062c)
#define ISP21_RAWAWB_RAM_CTRL                    (ISP21_RAWAWB_BASE + 0x0650)
#define ISP21_RAWAWB_WRAM_CTRL                   (ISP21_RAWAWB_BASE + 0x0654)
#define ISP21_RAWAWB_WRAM_DATA_BASE              (ISP21_RAWAWB_BASE + 0x0660)
#define ISP21_RAWAWB_RAM_DATA_BASE               (ISP21_RAWAWB_BASE + 0x0700)


/* VI_ISP_EN */
#define VI_CCL_EN			BIT(0)
#define VI_ISP_EN_SEL			BIT(1)
#define VI_ISP_BLS_EN			BIT(5)
#define VI_ISP_GAMMA_IN_EN		BIT(6)
#define VI_ISP_HDRMGE_EN		BIT(7)
#define VI_ISP_RAWNR_EN			BIT(9)
#define VI_ISP_LSC_EN			BIT(10)
#define VI_ISP_HDRTMO_EN		BIT(11)
#define VI_ISP_GIC_EN			BTI(12)
#define VI_ISP_DEBAYER_EN		BIT(13)
#define VI_ISP_CCM_EN			BIT(14)
#define VI_ISP_GAMMA12_EN		BIT(15)
#define VI_ISP_RKWDR_EN			BIT(16)
#define VI_ISP_DHAZ_EN			BIT(17)
#define VI_ISP_3DLUT_EN			BIT(18)
#define VI_ISP_AWB_EN			BIT(20)
#define VI_ISP_CP_EN			BIT(21)
#define VI_ISP_RSZ_EN			BIT(22)
#define VI_ISP_EFF_EN			BIT(24)
#define VI_ISP_IMP_EN			BIT(25)

/* VI_ISP_PATH */
#define SW_3A_RAWAE_SEL(a)		(((a) & 0x3) << 16)
#define SW_3A_RAWAF_SEL(a)		(((a) & 0x3) << 18)
#define SW_3A_RAWAWB_SEL(a)		(((a) & 0x3) << 20)
#define SW_3A_RAWAE_SWAP(a)		(((a) & 0x3) << 22)

/* VI_ISP_CLK_CTRL */
#define CLK_CTRL_ISP_RAW		BIT(0)
#define CLK_CTRL_ISP_RGB		BIT(1)
#define CLK_CTRL_ISP_YUV		BIT(2)
#define CLK_CTRL_ISP_3A			BIT(3)
#define CLK_CTRL_MIPI_RAM		BIT(4)
#define CLK_CTRL_ISP_FIFO_RAM		BIT(5)
#define CLK_CTRL_ISP_DEM_RAM		BIT(6)
#define CLK_CTRL_ISP_DPCC_RAM		BIT(7)
#define CLK_CTRL_ISP_IE_RAM		BIT(8)
#define CLK_CTRL_RSZ_RAM		BIT(9)
#define CLK_CTRL_JPEG_RAM		BIT(10)
#define CLK_CTRL_ACLK_ISP		BIT(11)
#define CLK_CTRL_LDC_RAM		BIT(12)
#define CLK_CTRL_MI_LDC			BIT(13)
#define CLK_CTRL_MI_MP			BIT(14)
#define CLK_CTRL_MI_JPEG		BIT(15)
#define CLK_CTRL_MI_DP			BIT(16)
#define CLK_CTRL_MI_Y12			BIT(17)
#define CLK_CTRL_MI_SP			BIT(18)
#define CLK_CTRL_MI_RAW0		BIT(19)
#define CLK_CTRL_MI_RAW1		BIT(20)
#define CLK_CTRL_MI_READ		BIT(21)
#define CLK_CTRL_MI_RAWRD		BIT(22)
#define CLK_CTRL_CP			BIT(23)
#define CLK_CTRL_IE			BIT(24)
#define CLK_CTRL_SI			BIT(25)
#define CLK_CTRL_RSZM			BIT(26)
#define CLK_CTRL_DPMUX			BIT(27)
#define CLK_CTRL_JPEG			BIT(28)
#define CLK_CTRL_RSZS			BIT(29)
#define CLK_CTRL_MIPI			BIT(30)
#define CLK_CTRL_MARVINMI		BIT(31)

/* VI_ICCL */
#define ICCL_ISP_CLK			BIT(0)
#define ICCL_CP_CLK			BIT(1)
#define ICCL_MRSZ_CLK			BIT(3)
#define ICCL_SRSZ_CLK			BIT(4)
#define ICCL_JPEG_CLK			BIT(5)
#define ICCL_MI_CLK			BIT(6)
#define ICCL_IE_CLK			BIT(8)
#define ICCL_SIMP_CLK			BIT(9)
#define ICCL_SMIA_CLK			BIT(10)
#define ICCL_MIPI_CLK			BIT(11)
#define ICCL_MPFBC_CLK			BIT(14)

/* VI_IRCL */
#define IRCL_ISP_SW_RST			BIT(0)
#define IRCL_CP_SW_RST			BIT(1)
#define IRCL_YCS_SW_RST			BIT(2)
#define IRCL_MRSZ_SW_RST		BIT(3)
#define IRCL_SRSZ_SW_RST		BIT(4)
#define IRCL_JPEG_SW_RST		BIT(5)
#define IRCL_MI_SW_RST			BIT(6)
#define IRCL_MARVIN_RST			BIT(7)
#define IRCL_IE_SW_RST			BIT(8)
#define IRCL_SI_SW_RST			BIT(9)
#define IRCL_MIPI_SW_RST		BIT(11)
#define IRCL_3A_SW_RST			BIT(13)

/* VI_DPCL */
#define VI_DPCL_IF_SEL_LVDS		BIT(8)

/* SWS_CFG */
#define SW_SWS_EN			BIT(0)
#define SW_ISP2PP_PIPE_EN		BIT(1)
#define SW_MPIP_DROP_FRM_DIS		BIT(2)
#define SW_SENSOR_ID(a)			(((a) & 0x3) << 4)
#define SW_SWS_TMO_DDR_RD		BIT(8)
#define SW_SWS_WDR_DDR_RD		BIT(9)
#define SW_SWS_DHAZ_DDR_RD		BIT(10)
#define SW_SWS_ISP_DDRLOAD_DIS		BIT(11)
#define SW_SWS_DMA_START_MODE(a)	(((a) & 0x3) << 12)
#define SW_ISP2PP_DIFX16(a)		(((a) & 0xff) << 16)
#define SW_3A_DDR_WRITE_EN		BIT(24)
#define SW_ISP2PP_HOLD			BIT(31)

/* LVDS_CTRL */
#define SW_LVDS_EN			BIT(0)
#define SW_LVDS_MODE			BIT(1)
#define SW_LVDS_WIDTH(a)		(((a) & 0x3) << 2)
#define SW_LVDS_LANE_EN(a)		(((a) & 0xf) << 4)
#define SW_LVDS_MAIN_LANE(a)		(((a) & 0x3) << 8)
#define SW_LVDS_START_X(a)		(((a) & 0x7ff) << 10)
#define SW_LVDS_START_Y(a)		(((a) & 0x7ff) << 21)

#define SW_LVDS_SAV(a)			((a) & 0xfff)
#define SW_LVDS_EAV(a)			(((a) & 0xfff) << 16)

/* ISP CTRL */
#define NOC_HURRY_PRIORITY(a)		(((a) & 0x3) << 30)
#define NOC_HURRY_W_MODE(a)		(((a) & 0x7) << 21)
#define NOC_HURRY_R_MODE(a)		(((a) & 0x7) << 18)

/* ISP CTRL1 */
#define ISP2X_SYS_YNR_FST		BIT(23)
#define ISP2X_SYS_ADRC_FST		BIT(24)
#define ISP2X_SYS_DHAZ_FST		BIT(25)
#define ISP2X_SYS_CNR_FST		BIT(26)
#define ISP2X_SYS_BAY3D_FST		BIT(27)
#define ISP2X_SYS_BIGMODE_FORCEEN	BIT(28)
#define ISP2X_SYS_BIGMODE_MANUAL	BIT(29)

/* isp interrupt */
#define ISP2X_OFF			BIT(0)
#define ISP2X_FRAME			BIT(1)
#define ISP2X_DATA_LOSS			BIT(2)
#define ISP2X_PIC_SIZE_ERROR		BIT(3)
#define ISP2X_SIAWB_DONE		BIT(4)
#define ISP2X_FRAME_IN			BIT(5)
#define ISP2X_V_START			BIT(6)
#define ISP2X_H_START			BIT(7)
#define ISP2X_FLASH_ON			BIT(8)
#define ISP2X_FLASH_OFF			BIT(9)
#define ISP2X_SHUTTER_ON		BIT(10)
#define ISP2X_SHUTTER_OFF		BIT(11)
#define ISP2X_AFM_SUM_OF		BIT(12)
#define ISP2X_AFM_LUM_OF		BIT(13)
#define ISP2X_SIAF_FIN			BIT(14)
#define ISP2X_SIHST_RDY			BIT(15)
#define ISP2X_LSC_LUT_ERR		BIT(16)
#define ISP2X_FLASH_CAP			BIT(17)
#define ISP2X_YUVAE_END			BIT(18)
#define ISP2X_VSM_END			BIT(19)
#define ISP2X_HDR_DONE			BIT(20)
#define ISP2X_DHAZ_DONE			BIT(21)
#define ISP2X_GAIN_DONE			BIT(22)

/* isp3a interrupt */
#define ISP2X_3A_RAWAE_BIG		BIT(0)
#define ISP2X_3A_RAWAE_CH0		BIT(1)
#define ISP2X_3A_RAWAE_CH1		BIT(2)
#define ISP2X_3A_RAWAE_CH2		BIT(3)
#define ISP2X_3A_RAWHIST_BIG		BIT(4)
#define ISP2X_3A_RAWHIST_CH0		BIT(5)
#define ISP2X_3A_RAWHIST_CH1		BIT(6)
#define ISP2X_3A_RAWHIST_CH2		BIT(7)
#define ISP2X_3A_RAWAF_SUM		BIT(8)
#define ISP2X_3A_RAWAF_LUM		BIT(9)
#define ISP2X_3A_RAWAF			BIT(10)
#define ISP2X_3A_RAWAWB			BIT(11)
#define ISP2X_3A_DDR_DONE		BIT(12)

/* MI_WR_CTRL */
#define MI_LUM_BURST_MASK		GENMASK(17, 16)
#define MI_MIPI_LUM_BURST2		BIT(16)
#define MI_MIPI_LUM_BURST4		BIT(17)
#define MI_MIPI_LUM_BURST8		(3 << 16)
#define MI_MIPI_LUM_BURST16		(0 << 16)

/* mi interrupt */
#define MI_MP_FRAME			BIT(0)
#define MI_SP_FRAME			BIT(1)
#define MI_MBLK_LINE			BIT(2)
#define MI_FILL_MP_Y			BIT(3)
#define MI_WRAP_MP_Y			BIT(4)
#define MI_WRAP_MP_CB			BIT(5)
#define MI_WRAP_MP_CR			BIT(6)
#define MI_WRAP_SP_Y			BIT(7)
#define MI_WRAP_SP_CB			BIT(8)
#define MI_WARP_SP_CR			BIT(9)
#define MI_FILL_MP_Y2			BIT(10)
#define MI_DMA_READY			BIT(11)
#define MI_Y12Y_FRAME			BIT(12)
#define MI_Y12C_FRAME			BIT(13)
#define MI_ALL_FRAME			BIT(14)
#define MI_RAW0_WR_FRAME		BIT(16)
#define MI_RAW1_WR_FRAME		BIT(17)
#define MI_RAW2_WR_FRAME		BIT(18)
#define MI_RAW3_WR_FRAME		BIT(19)
#define MI_DBR_WR_FRAME			BIT(20)
#define MI_GAIN_WR_FRAME		BIT(21)
#define MI_MPFBC_FRAME			BIT(31)

/* MI_CTRL2 */
#define SW_BAY3D_FORCEUPD		BIT(22)
#define SW_BAY3D_WR_AUTOUPD		BIT(16)
#define SW_GAIN_WR_AUTOUPD		BIT(13)
#define SW_GAIN_WR_PINGPONG		BIT(12)
#define SW_DBR_WR_AUTOUPD		BIT(10)
#define SW_MIMUX_BYTE_SWAP		BIT(9)
#define SW_MIMUX_EN			BIT(8)
#define SW_RAW3_WR_AUTOUPD		BIT(3)
#define SW_RAW2_WR_AUTOUPD		BIT(2)
#define SW_RAW1_WR_AUTOUPD		BIT(1)
#define SW_RAW0_WR_AUTOUPD		BIT(0)

/* MI_RD_CTRL2 */
#define BAY3D_RW_ONEADDR_EN		BIT(4)

/* MPFBC */
#define SW_MPFBC_EN			BIT(0)
#define SW_MPFBC_MAINISP_MODE		BIT(3)
#define SW_MPFBC_YUV_MODE(a)		(((a) & 0x3) << 1)
#define SW_MPFBC_PINGPONG_EN		BIT(4)

/* CSI2RX */
#define SW_CSI2RX_EN			BIT(0)
#define SW_HDR_ESP_MODE(a)		(((a) & 0x3) << 2)
#define SW_IBUF_OP_MODE(a)		(((a) & 0x0F) << 8)
#define SW_DMA_2FRM_MODE(a)		(((a) & 0x3) << 12)

#define SW_CSI_LANE(a)			((a) & 0x3)
#define SW_CSI_CH0_SEL(a)		(((a) & 0x7) << 4)
#define SW_CSI_CH1_SEL(a)		(((a) & 0x7) << 8)
#define SW_CSI_CH2_SEL(a)		(((a) & 0x7) << 12)
#define SW_CSI_CH3_SEL(a)		(((a) & 0x7) << 16)
#define SW_LVL0_SEL0_CSI1		BIT(20)
#define SW_LVL0_SEL1_RAW0		BIT(21)
#define SW_LVL0_SEL2_RAW1		BIT(22)
#define SW_LVL0_SEL3_RAW3		BIT(23)
#define SW_LVL1_SEL0(a)			(((a) & 0x3) << 24)
#define SW_LVL1_SEL1(a)			(((a) & 0x3) << 26)
#define SW_LVL1_SEL2(a)			(((a) & 0x3) << 28)

#define SW_CSI_ID0(a)			((a) & 0xff)
#define SW_CSI_ID1(a)			(((a) & 0xff) << 8)
#define SW_CSI_ID2(a)			(((a) & 0xff) << 16)
#define SW_CSI_ID3(a)			(((a) & 0xff) << 24)

#define SW_CSI_ID4(a)			((a) & 0xff)
#define SW_CSI_ID5(a)			(((a) & 0xff) << 8)
#define SW_CSI_ID6(a)			(((a) & 0xff) << 16)
#define SW_CSI_ID7(a)			(((a) & 0xff) << 24)

#define PHY_ERR_SOTHS			GENMASK(3, 0)
#define PHY_ERR_SOTSYNCHS		GENMASK(7, 4)
#define PHY_ERR_EOTSYNCHS		GENMASK(11, 8)
#define PHY_ERR_ESC			GENMASK(15, 12)
#define PHY_ERR_CTL			GENMASK(23, 20)

#define PACKET_ERR_F_BNDRY_MATCG	GENMASK(3, 0)
#define PACKET_ERR_F_SEQ		GENMASK(7, 4)
#define PACKET_ERR_FRAME_DATA		GENMASK(11, 8)
#define PACKET_ERR_ID			GENMASK(15, 12)
#define PACKET_ERR_ECC_1BIT		GENMASK(19, 16)
#define PACKET_ERR_ECC_2BIT		BIT(20)
#define PACKET_ERR_CHECKSUM		GENMASK(27, 24)

#define AFIFO0_OVERFLOW			BIT(0)
#define AFIFO1X_OVERFLOW		GENMASK(7, 4)
#define LAFIFO1X_OVERFLOW		GENMASK(11, 8)
#define AFIFO2X_OVERFLOW		GENMASK(14, 12)
#define IBUFX3_OVERFLOW			GENMASK(18, 16)
#define IBUF3R_OVERFLOW			BIT(19)
#define Y_STAT_AFIFOX3_OVERFLOW		GENMASK(22, 20)

#define RAW0_WR_FRAME			BIT(0)
#define RAW1_WR_FRAME			BIT(1)
#define RAW2_WR_FRAME			BIT(2)
#define MIPI_DROP_FRM			BIT(3)
#define RAW0_RD_FRAME			BIT(4)
#define RAW1_RD_FRAME			BIT(5)
#define RAW2_RD_FRAME			BIT(6)
#define RAW_WR_SIZE_ERR			GENMASK(15, 8)
#define MIPI_LINECNT			BIT(16)
#define RAW_RD_SIZE_ERR			GENMASK(19, 17)
#define MIPI_FRAME_ST_VC(a)		(((a) & 0xf) << 20)
#define MIPI_FRAME_END_VC(a)		(((a) & 0xf) << 24)
#define RAW0_Y_STATE			BIT(28)
#define RAW1_Y_STATE			BIT(29)
#define RAW2_Y_STATE			BIT(30)

#define SW_CSI_RAW_WR_EN_ORG		BIT(0)
#define SW_CSI_RAW_WR_SIMG_MODE		BIT(1)
#define SW_CSI_RWA_WR_SIMG_SWP		BIT(2)
#define SW_CSI_RAW_WR_H_OUT		BIT(3)
#define SW_CSI_RAW_WR_CRC_OUT		BIT(4)
#define SW_CSI_RAW_WR_CH_EN(a)		(((a) & 0xff) << 8)
#define SW_CSI_RAW_WR_EN_SHD		BIT(31)

#define SW_CSI_RAW_PIC_V_SIZE(a)	(((a) & 0x3FFF) << 16)
#define SW_CSI_RAW_PIC_H_SIZE(a)	((a) & 0x3FFF)

#define SW_CSI_RAW_PIC_V_OFF(a)		(((a) & 0x3FFF) << 16)
#define SW_CSI_RAW_PIC_H_OFF(a)		((a) & 0x3FFF)

#define SW_CSI_RAW0_RD_EN_ORG		BIT(0)
#define SW_CSI_RAW1_RD_EN_ORG		BIT(1)
#define SW_CSI_RAW2_RD_EN_ORG		BIT(2)
#define SW_CSI_RAW_RD_SIMG_MOD		BIT(3)
#define SW_CSI_RAW_RD_SIMG_SWP		BIT(4)
#define SW_CSI_RAW_RD_CH_SEL(a)		(((a) & 0x7) << 5)

#define SW_RAW_OUT_EN			BIT(0)
#define SW_RAWFBC_EN			BIT(1)
#define SW_RAWFBC_HEAD_DIFF_EN		BIT(4)
#define SW_RAWFBC_HEAD_DIFF_NUM(a)	(((a) & 0x3) << 8)

#define SW_CSI_ESP_LCNT_PADPIX(a)	((a) & 0xFFF)
#define SW_CSI_ESP_LCNT_PADNUM(a)	(((a) & 0x3F) << 12)

#define SW_CSI_ESP_IDCD_OBPIX(a)	((a) & 0x7F)
#define SW_CSI_ESP_IDCD_EFPIX(a)	(((a) & 0x7F) << 16)

#define SW_Y_STAT_INT_MODE_MASK		GENMASK(3, 2)
#define SW_Y_STAT_RD_FRM_ID_MASK	GENMASK(5, 4)
#define SW_Y_STAT_RD_TILE_ID_MASK	GENMASK(7, 6)
#define SW_Y_STAT_EN			BIT(0)
#define SW_Y_STAT_RD_EN			BIT(1)
#define SW_Y_STAT_INT_MODE(a)		(((a) & 0x3) << 2)
#define SW_Y_STAT_RD_FRM_ID(a)		(((a) & 0x3) << 4)
#define SW_Y_STAT_RD_TILE_ID(a)		(((a) & 0x3) << 6)
#define SW_Y_STAT_BLK_R(a)		(((a) & 0x1f) << 8)
#define SW_Y_STAT_BLK_G(a)		(((a) & 0x1f) << 16)
#define SW_Y_STAT_BLK_B(a)		(((a) & 0x1f) << 24)

/* DEBAYER */
#define SW_DEBAYER_EN			BIT(0)
#define SW_DEBAYER_FILTER_G_EN		BIT(4)
#define SW_DEBAYER_FILTER_C_EN		BIT(8)

#define SW_DEBAYER_CLIP_EN		BIT(0)

/* HDRMGE */
#define SW_HDRMGE_EN			BIT(0)
#define SW_HDRMGE_MODE_NORMAL		(0 << 2)
#define SW_HDRMGE_MODE_FRAMEX2		BIT(2)
#define SW_HDRMGE_MODE_FRAMEX3		(2 << 2)

/* BLS */
/* ISP_BLS_CTRL */
#define ISP_BLS_ENA			BIT(0)
#define ISP_BLS_MODE_MEASURED		BIT(1)
#define ISP_BLS_MODE_FIXED		0
#define ISP_BLS_WINDOW_1		(1 << 2)
#define ISP_BLS_WINDOW_2		(2 << 2)
#define ISP_BLS_BLS1_EN		BIT(4)

/* GIC */
/* ISP_GIC_CTRL */
#define ISP_GIC_ENA			BIT(0)
#define ISP_GIC_EDGE_OPEN		BIT(1)

/* DHAZ */
/* ISP_DHAZ_CTRL */
#define ISP_DHAZ_ENMUX			BIT(0)
#define ISP_DHAZ_NOBIGEN		BIT(2)
#define ISP_DHAZ_BIGEN			BIT(3)
#define ISP_DHAZ_DCEN			BIT(4)
#define ISP_DHAZ_HSTEN			BIT(8)
#define ISP_DHAZ_HPARAEN		BIT(12)
#define ISP_DHAZ_HSTCHN			BIT(16)
#define ISP_DHAZ_ENHANCE		BIT(20)

/* HDRTMO */
/* ISP_HDRTMO_CTRL */
#define ISP_HDRTMO_EN			BIT(0)

/* HDRDRC */
/* ISP21_DRC_CTRL0 */
#define ISP_DRC_EN			BIT(0)

/* HDRMGE */
/* ISP_HDRMGE_CTRL */
#define ISP_HDRMGE_MODE_MASK		GENMASK(3, 2)
#define ISP_HDRMGE_EN			BIT(0)

/* RAWNR */
/* ISP_RAWNR_CTRL */
#define ISP_RAWNR_EN			BIT(0)

/* DPCC */
/* ISP_DPCC_CTRL */
#define ISP_DPCC_EN			BIT(0)

/* CCM */
/* ISP_CCM_CTRL */
#define ISP_CCM_EN			BIT(0)

/* 3DLUT */
/* ISP_3DLUT_CTRL */
#define ISP_3DLUT_EN			BIT(0)
#define ISP_3DLUT_BYPASS		BIT(1)

/* DEBAYER */
/* ISP_DEBAYER_CONTROL */
#define ISP_DEBAYER_EN			BIT(0)

/* LSC */
/* ISP_LSC_CTRL */
#define ISP_LSC_EN			BIT(0)
#define ISP_LSC_LUT_EN			BIT(1)
#define ISP_ISP_LSC_TABLE_DATA(v0, v1)	\
	(((v0) & 0x1FFF) | (((v1) & 0x1FFF) << 16))

#define ISP21_YNR_EN			BIT(0)
#define ISP21_CNR_EN			BIT(0)
#define ISP21_SHARP_EN			BIT(0)
#define ISP21_BAYNR_EN			BIT(0)
#define ISP21_BAY3D_EN			BIT(0)

/* ISP21 ISP CTRL0 */
#define ISP21_CGC_RATIO_EN		BIT(29)
#define ISP21_CGC_YUV_LIMIT		BIT(28)
#define ISP21_NOC_HURRY_W1_MODE(a)	(((a) & 0x7) << 24)

/* ISP CTRL1 */
#define ISP21_BIGMODE_MODE		BIT(29)
#define ISP21_BIGMODE_FORCE_EN		BIT(28)
#define ISP21_RAW3D_FST_FRAME		BIT(27)
#define ISP21_CNR_FST_FRAME		BIT(26)
#define ISP21_DHAZ_FST_FRAME		BIT(25)
#define ISP21_ADRC_FST_FRAME		BIT(24)
#define ISP21_YNR_FST_FRAME		BIT(23)
#define ISP21_BT1120_YC_SWAP		BIT(22)
#define ISP21_DUALEDGE_EN		BIT(21)
#define ISP21_BI1120_EN			BIT(20)
#define ISP21_FIELD_INV			BIT(11)

/* ISP21 ACQ_H_OFFS */
#define ISP21_SENSOR_MODE(a)		(((a) & 3) << 30)
#define ISP21_SENSOR_INDEX(a)		(((a) & 3) << 28)
#define ISP21_ACQ_H_OFFS(a)		((a) & 0x7fff)

/* ISP21 ACQ_H_SIZE */
#define ISP21_ACQ_H_SIZE_BAY3DMI(a)	(((a) & 0xffff) << 16)
#define ISP21_ACQ_H_SIZE(a)		((a) & 0x7fff)

/* ISP21 MI_WR_INIT */
#define ISP21_SP_FORCE_UPD		BIT(21)
#define ISP21_MP_FORCE_UPD		BIT(20)

/* ISP21 MI_WR_CTRL2*/
#define ISP21_BAY3D_FORCE_UPD		BIT(22)
#define ISP21_GAIN_FORCE_UPD		BIT(21)
#define ISP21_DBR_FORCE_UPD		BIT(20)
#define ISP21_BAY3D_WR_AUTO_UPD		BIT(16)

/* ISP21 CSI2RX */
#define ISP21_CSI_2PIX_MODE		BIT(1)

#define ISP21_MIPI_DROP_FRM		BIT(31)

#define ISP21_RAW3_WR_FRAME		BIT(3)

#define ISP21_RAW_FORCE_UPD		BIT(31)

/* ISP21 DHAZ/DRC/BAY3D */
#define ISP21_SELF_FORCE_UPD		BIT(31)

static inline bool dmatx0_is_stream_stopped(struct rkisp_stream *stream)
{
	u32 ret = rkisp_read(stream->ispdev, CSI2RX_RAW0_WR_CTRL, true);

	return !(ret & SW_CSI_RAW_WR_EN_SHD);
}

static inline bool dmatx1_is_stream_stopped(struct rkisp_stream *stream)
{
	u32 ret = rkisp_read(stream->ispdev, CSI2RX_RAW1_WR_CTRL, true);

	return !(ret & SW_CSI_RAW_WR_EN_SHD);
}

static inline bool dmatx2_is_stream_stopped(struct rkisp_stream *stream)
{
	u32 ret = rkisp_read(stream->ispdev, CSI2RX_RAW2_WR_CTRL, true);

	return !(ret & SW_CSI_RAW_WR_EN_SHD);
}

static inline bool dmatx3_is_stream_stopped(struct rkisp_stream *stream)
{
	u32 ret = rkisp_read(stream->ispdev, CSI2RX_RAW3_WR_CTRL, true);

	return !(ret & SW_CSI_RAW_WR_EN_SHD);
}

static inline bool is_mpfbc_stopped(void __iomem *base)
{
	u32 ret = readl(base + ISP_MPFBC_CTRL);

	return !(ret & SW_MPFBC_EN);
}

static inline void mi_wr_ctrl2(void __iomem *base, u32 val)
{
	void __iomem *addr = base + MI_WR_CTRL2;

	writel(val | readl(addr), addr);
}

static inline void raw_wr_set_pic_size(struct rkisp_stream *stream,
				       u32 width, u32 height)
{
	void __iomem *base = stream->ispdev->base_addr;

	if (stream->out_isp_fmt.fmt_type == FMT_YUV)
		width *= 2;
	/* hardware received 16bit embedded data */
	else if (stream->out_isp_fmt.fmt_type == FMT_EBD)
		width /= 2;
	writel(height << 16 | width,
	       base + stream->config->dma.pic_size);
}

static inline void raw_wr_set_pic_offs(struct rkisp_stream *stream, u32 val)
{
	void __iomem *base = stream->ispdev->base_addr;

	writel(val, base + stream->config->dma.pic_offs);
}

static inline void raw_wr_ctrl(struct rkisp_stream *stream, u32 val)
{
	void __iomem *base = stream->ispdev->base_addr;

	writel(val, base + stream->config->dma.ctrl);
}

static inline void raw_wr_enable(struct rkisp_stream *stream)
{
	void __iomem *base = stream->ispdev->base_addr;
	void __iomem *addr = base + stream->config->dma.ctrl;
	u32 val = readl(addr);

	val |= ISP21_RAW_FORCE_UPD | SW_CSI_RAW_WR_EN_ORG;
	writel(val, addr);
}

static inline void raw_wr_disable(struct rkisp_stream *stream)
{
	void __iomem *base = stream->ispdev->base_addr;
	void __iomem *addr = base + stream->config->dma.ctrl;
	u32 val = readl(addr);

	val &= ~(ISP21_RAW_FORCE_UPD | SW_CSI_RAW_WR_EN_ORG);
	writel(val, addr);
}

static inline void mi_raw0_rd_set_addr(void __iomem *base, u32 val)
{
	writel(val, base + MI_RAW0_RD_BASE);
}

static inline void mi_raw1_rd_set_addr(void __iomem *base, u32 val)
{
	writel(val, base + MI_RAW1_RD_BASE);
}

static inline void mi_raw2_rd_set_addr(void __iomem *base, u32 val)
{
	writel(val, base + MI_RAW2_RD_BASE);
}

static inline void raw_rd_ctrl(void __iomem *base, u32 val)
{
	writel(val, base + CSI2RX_RAW_RD_CTRL);
}

static inline void mi_raw_length(struct rkisp_stream *stream)
{
	bool is_direct = true;

	if (stream->config->mi.length == MI_RAW0_RD_LENGTH ||
	    stream->config->mi.length == MI_RAW1_RD_LENGTH ||
	    stream->config->mi.length == MI_RAW2_RD_LENGTH)
		is_direct = false;
	rkisp_write(stream->ispdev, stream->config->mi.length,
		    stream->out_fmt.plane_fmt[0].bytesperline, is_direct);
	if (stream->ispdev->isp_ver == ISP_V21 || stream->ispdev->isp_ver == ISP_V30)
		rkisp_set_bits(stream->ispdev, MI_RD_CTRL2, 0, BIT(30), false);
	if (stream->ispdev->hw_dev->is_unite) {
		rkisp_next_write(stream->ispdev, stream->config->mi.length,
				 stream->out_fmt.plane_fmt[0].bytesperline, is_direct);
		rkisp_next_set_bits(stream->ispdev, MI_RD_CTRL2, 0, BIT(30), false);
	}
}

static inline void rx_force_upd(void __iomem *base)
{
	void __iomem *addr = base + CSI2RX_RAW_RD_CTRL;

	writel(ISP21_RAW_FORCE_UPD | readl(addr), addr);
}

#endif /* _RKISP_REGS_V2X_H */
