/* SPDX-License-Identifier: (GPL-2.0+ OR MIT)
 *
 * Copyright (C) 2021 Rockchip Electronics Co., Ltd.
 */

#ifndef _RKISP_REGS_ISP3X_H
#define _RKISP_REGS_ISP3X_H

#define ISP3X_CTRL_BASE				0x00000000
#define ISP3X_VI_ISP_EN				(ISP3X_CTRL_BASE + 0x00000)
#define ISP3X_VI_ISP_PATH			(ISP3X_CTRL_BASE + 0x00004)
#define ISP3X_VI_ID				(ISP3X_CTRL_BASE + 0x00008)
#define ISP3X_VI_ISP_CLK_CTRL			(ISP3X_CTRL_BASE + 0x0000c)
#define ISP3X_VI_ICCL				(ISP3X_CTRL_BASE + 0x00010)
#define ISP3X_VI_IRCL				(ISP3X_CTRL_BASE + 0x00014)
#define ISP3X_VI_DPCL				(ISP3X_CTRL_BASE + 0x00018)
#define ISP3X_SWS_CFG				(ISP3X_CTRL_BASE + 0x0001c)

#define ISP3X_IMG_EFF_BASE			0x00000200
#define ISP3X_IMG_EFF_CTRL			(ISP3X_IMG_EFF_BASE + 0x00000)
#define ISP3X_IMG_EFF_COLOR_SEL			(ISP3X_IMG_EFF_BASE + 0x00004)
#define ISP3X_IMG_EFF_TINT			(ISP3X_IMG_EFF_BASE + 0x0001c)
#define ISP3X_IMG_EFF_CTRL_SHD			(ISP3X_IMG_EFF_BASE + 0x00020)

#define ISP3X_CMSK_BASE				0x00000230
#define ISP3X_CMSK_CTRL0			(ISP3X_CMSK_BASE + 0x00000)
#define ISP3X_CMSK_CTRL1			(ISP3X_CMSK_BASE + 0x00004)
#define ISP3X_CMSK_CTRL2			(ISP3X_CMSK_BASE + 0x00008)
#define ISP3X_CMSK_CTRL3			(ISP3X_CMSK_BASE + 0x0000c)
#define ISP3X_CMSK_CTRL4			(ISP3X_CMSK_BASE + 0x00010)
#define ISP3X_CMSK_CTRL5			(ISP3X_CMSK_BASE + 0x00014)
#define ISP3X_CMSK_CTRL6			(ISP3X_CMSK_BASE + 0x00018)
#define ISP3X_CMSK_PIC_SIZE			(ISP3X_CMSK_BASE + 0x0001c)
#define ISP3X_CMSK_YUV0				(ISP3X_CMSK_BASE + 0x00020)
#define ISP3X_CMSK_YUV1				(ISP3X_CMSK_BASE + 0x00024)
#define ISP3X_CMSK_YUV2				(ISP3X_CMSK_BASE + 0x00028)
#define ISP3X_CMSK_YUV3				(ISP3X_CMSK_BASE + 0x0002c)
#define ISP3X_CMSK_YUV4				(ISP3X_CMSK_BASE + 0x00030)
#define ISP3X_CMSK_YUV5				(ISP3X_CMSK_BASE + 0x00034)
#define ISP3X_CMSK_YUV6				(ISP3X_CMSK_BASE + 0x00038)
#define ISP3X_CMSK_YUV7				(ISP3X_CMSK_BASE + 0x0003c)
#define ISP32_CMSK_YUV8				(ISP3X_CMSK_BASE + 0x00040)
#define ISP32_CMSK_YUV9				(ISP3X_CMSK_BASE + 0x00044)
#define ISP32_CMSK_YUV10			(ISP3X_CMSK_BASE + 0x00048)
#define ISP32_CMSK_YUV11			(ISP3X_CMSK_BASE + 0x0004c)
#define ISP3X_CMSK_OFFS0			(ISP3X_CMSK_BASE + 0x00050)
#define ISP3X_CMSK_SIZE0			(ISP3X_CMSK_BASE + 0x00054)
#define ISP3X_CMSK_OFFS1			(ISP3X_CMSK_BASE + 0x00058)
#define ISP3X_CMSK_SIZE1			(ISP3X_CMSK_BASE + 0x0005c)
#define ISP3X_CMSK_OFFS2			(ISP3X_CMSK_BASE + 0x00060)
#define ISP3X_CMSK_SIZE2			(ISP3X_CMSK_BASE + 0x00064)
#define ISP3X_CMSK_OFFS3			(ISP3X_CMSK_BASE + 0x00068)
#define ISP3X_CMSK_SIZE3			(ISP3X_CMSK_BASE + 0x0006c)
#define ISP3X_CMSK_OFFS4			(ISP3X_CMSK_BASE + 0x00070)
#define ISP3X_CMSK_SIZE4			(ISP3X_CMSK_BASE + 0x00074)
#define ISP3X_CMSK_OFFS5			(ISP3X_CMSK_BASE + 0x00078)
#define ISP3X_CMSK_SIZE5			(ISP3X_CMSK_BASE + 0x0007c)
#define ISP3X_CMSK_OFFS6			(ISP3X_CMSK_BASE + 0x00080)
#define ISP3X_CMSK_SIZE6			(ISP3X_CMSK_BASE + 0x00084)
#define ISP3X_CMSK_OFFS7			(ISP3X_CMSK_BASE + 0x00088)
#define ISP3X_CMSK_SIZE7			(ISP3X_CMSK_BASE + 0x0008c)
#define ISP32_CMSK_OFFS8			(ISP3X_CMSK_BASE + 0x00090)
#define ISP32_CMSK_SIZE8			(ISP3X_CMSK_BASE + 0x00094)
#define ISP32_CMSK_OFFS9			(ISP3X_CMSK_BASE + 0x00098)
#define ISP32_CMSK_SIZE9			(ISP3X_CMSK_BASE + 0x0009c)
#define ISP32_CMSK_OFFS10			(ISP3X_CMSK_BASE + 0x000a0)
#define ISP32_CMSK_SIZE10			(ISP3X_CMSK_BASE + 0x000a4)
#define ISP32_CMSK_OFFS11			(ISP3X_CMSK_BASE + 0x000a8)
#define ISP32_CMSK_SIZE11			(ISP3X_CMSK_BASE + 0x000ac)

#define ISP3X_SUPER_IMP_BASE			0x00000300
#define ISP3X_SUPER_IMP_CTRL			(ISP3X_SUPER_IMP_BASE + 0x00000)
#define ISP3X_SUPER_IMP_OFFSET_X		(ISP3X_SUPER_IMP_BASE + 0x00004)
#define ISP3X_SUPER_IMP_OFFSET_Y		(ISP3X_SUPER_IMP_BASE + 0x00008)
#define ISP3X_SUPER_IMP_COLOR_Y			(ISP3X_SUPER_IMP_BASE + 0x0000c)
#define ISP3X_SUPER_IMP_COLOR_CB		(ISP3X_SUPER_IMP_BASE + 0x00010)
#define ISP3X_SUPER_IMP_COLOR_CR		(ISP3X_SUPER_IMP_BASE + 0x00014)

#define ISP3X_ISP_BASE				0x00000400
#define ISP3X_ISP_CTRL0				(ISP3X_ISP_BASE + 0x00000)
#define ISP3X_ISP_CTRL1				(ISP3X_ISP_BASE + 0x00004)
#define ISP3X_ISP_ACQ_H_OFFS			(ISP3X_ISP_BASE + 0x00008)
#define ISP3X_ISP_ACQ_V_OFFS			(ISP3X_ISP_BASE + 0x0000c)
#define ISP3X_ISP_ACQ_H_SIZE			(ISP3X_ISP_BASE + 0x00010)
#define ISP3X_ISP_ACQ_V_SIZE			(ISP3X_ISP_BASE + 0x00014)
#define ISP3X_ISP_ACQ_NR_FRAMES			(ISP3X_ISP_BASE + 0x00018)
#define ISP3X_ISP_GAMMA_DX_LO			(ISP3X_ISP_BASE + 0x0001c)
#define ISP3X_ISP_GAMMA_DX_HI			(ISP3X_ISP_BASE + 0x00020)
#define ISP3X_ISP_GAMMA_R_Y_0			(ISP3X_ISP_BASE + 0x00024)
#define ISP3X_ISP_GAMMA_R_Y_1			(ISP3X_ISP_BASE + 0x00028)
#define ISP3X_ISP_GAMMA_R_Y_2			(ISP3X_ISP_BASE + 0x0002c)
#define ISP3X_ISP_GAMMA_R_Y_3			(ISP3X_ISP_BASE + 0x00030)
#define ISP3X_ISP_GAMMA_R_Y_4			(ISP3X_ISP_BASE + 0x00034)
#define ISP3X_ISP_GAMMA_R_Y_5			(ISP3X_ISP_BASE + 0x00038)
#define ISP3X_ISP_GAMMA_R_Y_6			(ISP3X_ISP_BASE + 0x0003c)
#define ISP3X_ISP_GAMMA_R_Y_7			(ISP3X_ISP_BASE + 0x00040)
#define ISP3X_ISP_GAMMA_R_Y_8			(ISP3X_ISP_BASE + 0x00044)
#define ISP3X_ISP_GAMMA_R_Y_9			(ISP3X_ISP_BASE + 0x00048)
#define ISP3X_ISP_GAMMA_R_Y_10			(ISP3X_ISP_BASE + 0x0004c)
#define ISP3X_ISP_GAMMA_R_Y_11			(ISP3X_ISP_BASE + 0x00050)
#define ISP3X_ISP_GAMMA_R_Y_12			(ISP3X_ISP_BASE + 0x00054)
#define ISP3X_ISP_GAMMA_R_Y_13			(ISP3X_ISP_BASE + 0x00058)
#define ISP3X_ISP_GAMMA_R_Y_14			(ISP3X_ISP_BASE + 0x0005c)
#define ISP3X_ISP_GAMMA_R_Y_15			(ISP3X_ISP_BASE + 0x00060)
#define ISP3X_ISP_GAMMA_R_Y_16			(ISP3X_ISP_BASE + 0x00064)
#define ISP3X_ISP_GAMMA_G_Y_0			(ISP3X_ISP_BASE + 0x00068)
#define ISP3X_ISP_GAMMA_G_Y_1			(ISP3X_ISP_BASE + 0x0006c)
#define ISP3X_ISP_GAMMA_G_Y_2			(ISP3X_ISP_BASE + 0x00070)
#define ISP3X_ISP_GAMMA_G_Y_3			(ISP3X_ISP_BASE + 0x00074)
#define ISP3X_ISP_GAMMA_G_Y_4			(ISP3X_ISP_BASE + 0x00078)
#define ISP3X_ISP_GAMMA_G_Y_5			(ISP3X_ISP_BASE + 0x0007c)
#define ISP3X_ISP_GAMMA_G_Y_6			(ISP3X_ISP_BASE + 0x00080)
#define ISP3X_ISP_GAMMA_G_Y_7			(ISP3X_ISP_BASE + 0x00084)
#define ISP3X_ISP_GAMMA_G_Y_8			(ISP3X_ISP_BASE + 0x00088)
#define ISP3X_ISP_GAMMA_G_Y_9			(ISP3X_ISP_BASE + 0x0008c)
#define ISP3X_ISP_GAMMA_G_Y_10			(ISP3X_ISP_BASE + 0x00090)
#define ISP3X_ISP_GAMMA_G_Y_11			(ISP3X_ISP_BASE + 0x00094)
#define ISP3X_ISP_GAMMA_G_Y_12			(ISP3X_ISP_BASE + 0x00098)
#define ISP3X_ISP_GAMMA_G_Y_13			(ISP3X_ISP_BASE + 0x0009c)
#define ISP3X_ISP_GAMMA_G_Y_14			(ISP3X_ISP_BASE + 0x000a0)
#define ISP3X_ISP_GAMMA_G_Y_15			(ISP3X_ISP_BASE + 0x000a4)
#define ISP3X_ISP_GAMMA_G_Y_16			(ISP3X_ISP_BASE + 0x000a8)
#define ISP3X_ISP_GAMMA_B_Y_0			(ISP3X_ISP_BASE + 0x000ac)
#define ISP3X_ISP_GAMMA_B_Y_1			(ISP3X_ISP_BASE + 0x000b0)
#define ISP3X_ISP_GAMMA_B_Y_2			(ISP3X_ISP_BASE + 0x000b4)
#define ISP3X_ISP_GAMMA_B_Y_3			(ISP3X_ISP_BASE + 0x000b8)
#define ISP3X_ISP_GAMMA_B_Y_4			(ISP3X_ISP_BASE + 0x000bc)
#define ISP3X_ISP_GAMMA_B_Y_5			(ISP3X_ISP_BASE + 0x000c0)
#define ISP3X_ISP_GAMMA_B_Y_6			(ISP3X_ISP_BASE + 0x000c4)
#define ISP3X_ISP_GAMMA_B_Y_7			(ISP3X_ISP_BASE + 0x000c8)
#define ISP3X_ISP_GAMMA_B_Y_8			(ISP3X_ISP_BASE + 0x000cc)
#define ISP3X_ISP_GAMMA_B_Y_9			(ISP3X_ISP_BASE + 0x000d0)
#define ISP3X_ISP_GAMMA_B_Y_10			(ISP3X_ISP_BASE + 0x000d4)
#define ISP3X_ISP_GAMMA_B_Y_11			(ISP3X_ISP_BASE + 0x000d8)
#define ISP3X_ISP_GAMMA_B_Y_12			(ISP3X_ISP_BASE + 0x000dc)
#define ISP3X_ISP_GAMMA_B_Y_13			(ISP3X_ISP_BASE + 0x000e0)
#define ISP3X_ISP_GAMMA_B_Y_14			(ISP3X_ISP_BASE + 0x000e4)
#define ISP3X_ISP_GAMMA_B_Y_15			(ISP3X_ISP_BASE + 0x000e8)
#define ISP3X_ISP_GAMMA_B_Y_16			(ISP3X_ISP_BASE + 0x000ec)
#define ISP32_ISP_AWB1_GAIN_G			(ISP3X_ISP_BASE + 0x00130)
#define ISP32_ISP_AWB1_GAIN_RB			(ISP3X_ISP_BASE + 0x00134)
#define ISP3X_ISP_AWB_GAIN0_G			(ISP3X_ISP_BASE + 0x00138)
#define ISP3X_ISP_AWB_GAIN0_RB			(ISP3X_ISP_BASE + 0x0013c)
#define ISP3X_ISP_AWB_GAIN1_G			(ISP3X_ISP_BASE + 0x00140)
#define ISP3X_ISP_AWB_GAIN1_RB			(ISP3X_ISP_BASE + 0x00144)
#define ISP3X_ISP_AWB_GAIN2_G			(ISP3X_ISP_BASE + 0x00148)
#define ISP3X_ISP_AWB_GAIN2_RB			(ISP3X_ISP_BASE + 0x0014C)
#define ISP3X_ISP_HURRY_CTRL			(ISP3X_ISP_BASE + 0x00158)
#define ISP3X_ISP_AWQOS_CTRL			(ISP3X_ISP_BASE + 0x0015C)
#define ISP3X_ISP_ARQOS_CTRL			(ISP3X_ISP_BASE + 0x00160)
#define ISP32_ISP_IRQ_CFG0			(ISP3X_ISP_BASE + 0x00164)
#define ISP32_ISP_IRQ_CFG1			(ISP3X_ISP_BASE + 0x00168)
#define ISP3X_ISP_CC_COEFF_0			(ISP3X_ISP_BASE + 0x00170)
#define ISP3X_ISP_CC_COEFF_1			(ISP3X_ISP_BASE + 0x00174)
#define ISP3X_ISP_CC_COEFF_2			(ISP3X_ISP_BASE + 0x00178)
#define ISP3X_ISP_CC_COEFF_3			(ISP3X_ISP_BASE + 0x0017c)
#define ISP3X_ISP_CC_COEFF_4			(ISP3X_ISP_BASE + 0x00180)
#define ISP3X_ISP_CC_COEFF_5			(ISP3X_ISP_BASE + 0x00184)
#define ISP3X_ISP_CC_COEFF_6			(ISP3X_ISP_BASE + 0x00188)
#define ISP3X_ISP_CC_COEFF_7			(ISP3X_ISP_BASE + 0x0018c)
#define ISP3X_ISP_CC_COEFF_8			(ISP3X_ISP_BASE + 0x00190)
#define ISP3X_ISP_OUT_H_OFFS			(ISP3X_ISP_BASE + 0x00194)
#define ISP3X_ISP_OUT_V_OFFS			(ISP3X_ISP_BASE + 0x00198)
#define ISP3X_ISP_OUT_H_SIZE			(ISP3X_ISP_BASE + 0x0019c)
#define ISP3X_ISP_OUT_V_SIZE			(ISP3X_ISP_BASE + 0x001a0)
#define ISP3X_ISP_FLAGS_SHD			(ISP3X_ISP_BASE + 0x001a8)
#define ISP3X_ISP_OUT_H_OFFS_SHD		(ISP3X_ISP_BASE + 0x001ac)
#define ISP3X_ISP_OUT_V_OFFS_SHD		(ISP3X_ISP_BASE + 0x001b0)
#define ISP3X_ISP_OUT_H_SIZE_SHD		(ISP3X_ISP_BASE + 0x001b4)
#define ISP3X_ISP_OUT_V_SIZE_SHD		(ISP3X_ISP_BASE + 0x001b8)
#define ISP3X_ISP_IMSC				(ISP3X_ISP_BASE + 0x001bc)
#define ISP3X_ISP_RIS				(ISP3X_ISP_BASE + 0x001c0)
#define ISP3X_ISP_MIS				(ISP3X_ISP_BASE + 0x001c4)
#define ISP3X_ISP_ICR				(ISP3X_ISP_BASE + 0x001c8)
#define ISP3X_ISP_ISR				(ISP3X_ISP_BASE + 0x001cc)
#define ISP3X_ISP_3A_IMSC			(ISP3X_ISP_BASE + 0x001d0)
#define ISP3X_ISP_3A_RIS			(ISP3X_ISP_BASE + 0x001d4)
#define ISP3X_ISP_3A_MIS			(ISP3X_ISP_BASE + 0x001d8)
#define ISP3X_ISP_3A_ICR			(ISP3X_ISP_BASE + 0x001dc)
#define ISP3X_ISP_ERR				(ISP3X_ISP_BASE + 0x0023c)
#define ISP3X_ISP_ERR_CLR			(ISP3X_ISP_BASE + 0x00240)
#define ISP3X_ISP_FRAME_COUNT			(ISP3X_ISP_BASE + 0x00244)
#define ISP3X_ISP_DEBUG1			(ISP3X_ISP_BASE + 0x00248)
#define ISP3X_ISP_DEBUG2			(ISP3X_ISP_BASE + 0x0024C)
#define ISP3X_ISP_DEBUG3			(ISP3X_ISP_BASE + 0x00250)
#define ISP32_ISP_DEBUG4			(ISP3X_ISP_BASE + 0x00254)
#define ISP32_YNR_LUMA_RCTRL			(ISP3X_ISP_BASE + 0x00290)
#define ISP32_YNR_LUMA_RDATA			(ISP3X_ISP_BASE + 0x00294)

#define ISP3X_FLASH_BASE			0x00000660
#define ISP3X_FLASH_CMD				(ISP3X_FLASH_BASE + 0x00000)
#define ISP3X_FLASH_CONFIG			(ISP3X_FLASH_BASE + 0x00004)
#define ISP3X_FLASH_PREDIV			(ISP3X_FLASH_BASE + 0x00008)
#define ISP3X_FLASH_DELAY			(ISP3X_FLASH_BASE + 0x0000c)
#define ISP3X_FLASH_TIME			(ISP3X_FLASH_BASE + 0x00010)
#define ISP3X_FLASH_MAXP			(ISP3X_FLASH_BASE + 0x00014)

#define ISP3X_SHUTTER_BASE			0x00000680
#define ISP3X_SHUTTER_CTRL			(ISP3X_SHUTTER_BASE + 0x00000)
#define ISP3X_SHUTTER_PREDIV			(ISP3X_SHUTTER_BASE + 0x00004)
#define ISP3X_SHUTTER_DELAY			(ISP3X_SHUTTER_BASE + 0x00008)
#define ISP3X_SHUTTER_TIME			(ISP3X_SHUTTER_BASE + 0x0000c)

#define ISP3X_CCM_BASE				0x00000700
#define ISP3X_CCM_CTRL				(ISP3X_CCM_BASE + 0x00000)
#define ISP3X_CCM_COEFF0_R			(ISP3X_CCM_BASE + 0x00004)
#define ISP3X_CCM_COEFF1_R			(ISP3X_CCM_BASE + 0x00008)
#define ISP3X_CCM_COEFF0_G			(ISP3X_CCM_BASE + 0x0000c)
#define ISP3X_CCM_COEFF1_G			(ISP3X_CCM_BASE + 0x00010)
#define ISP3X_CCM_COEFF0_B			(ISP3X_CCM_BASE + 0x00014)
#define ISP3X_CCM_COEFF1_B			(ISP3X_CCM_BASE + 0x00018)
#define ISP3X_CCM_COEFF0_Y			(ISP3X_CCM_BASE + 0x0001c)
#define ISP3X_CCM_COEFF1_Y			(ISP3X_CCM_BASE + 0x00020)
#define ISP3X_CCM_ALP_Y0			(ISP3X_CCM_BASE + 0x00024)
#define ISP3X_CCM_ALP_Y1			(ISP3X_CCM_BASE + 0x00028)
#define ISP3X_CCM_ALP_Y2			(ISP3X_CCM_BASE + 0x0002c)
#define ISP3X_CCM_ALP_Y3			(ISP3X_CCM_BASE + 0x00030)
#define ISP3X_CCM_ALP_Y4			(ISP3X_CCM_BASE + 0x00034)
#define ISP3X_CCM_ALP_Y5			(ISP3X_CCM_BASE + 0x00038)
#define ISP3X_CCM_ALP_Y6			(ISP3X_CCM_BASE + 0x0003c)
#define ISP3X_CCM_ALP_Y7			(ISP3X_CCM_BASE + 0x00040)
#define ISP3X_CCM_ALP_Y8			(ISP3X_CCM_BASE + 0x00044)
#define ISP3X_CCM_BOUND_BIT			(ISP3X_CCM_BASE + 0x00048)
#define ISP32_CCM_ENHANCE0			(ISP3X_CCM_BASE + 0x0004c)
#define ISP32_CCM_ENHANCE1			(ISP3X_CCM_BASE + 0x00050)

#define ISP3X_CPROC_BASE			0x00000800
#define ISP3X_CPROC_CTRL			(ISP3X_CPROC_BASE + 0x00000)
#define ISP3X_CPROC_CONTRAST			(ISP3X_CPROC_BASE + 0x00004)
#define ISP3X_CPROC_BRIGHTNESS			(ISP3X_CPROC_BASE + 0x00008)
#define ISP3X_CPROC_SATURATION			(ISP3X_CPROC_BASE + 0x0000c)
#define ISP3X_CPROC_HUE				(ISP3X_CPROC_BASE + 0x00010)

#define ISP3X_DUAL_CROP_BASE			0x00000880
#define ISP3X_DUAL_CROP_CTRL			(ISP3X_DUAL_CROP_BASE + 0x00000)
#define ISP3X_DUAL_CROP_M_H_OFFS		(ISP3X_DUAL_CROP_BASE + 0x00004)
#define ISP3X_DUAL_CROP_M_V_OFFS		(ISP3X_DUAL_CROP_BASE + 0x00008)
#define ISP3X_DUAL_CROP_M_H_SIZE		(ISP3X_DUAL_CROP_BASE + 0x0000c)
#define ISP3X_DUAL_CROP_M_V_SIZE		(ISP3X_DUAL_CROP_BASE + 0x00010)
#define ISP3X_DUAL_CROP_S_H_OFFS		(ISP3X_DUAL_CROP_BASE + 0x00014)
#define ISP3X_DUAL_CROP_S_V_OFFS		(ISP3X_DUAL_CROP_BASE + 0x00018)
#define ISP3X_DUAL_CROP_S_H_SIZE		(ISP3X_DUAL_CROP_BASE + 0x0001c)
#define ISP3X_DUAL_CROP_S_V_SIZE		(ISP3X_DUAL_CROP_BASE + 0x00020)
#define ISP3X_DUAL_CROP_M_H_OFFS_SHD		(ISP3X_DUAL_CROP_BASE + 0x00024)
#define ISP3X_DUAL_CROP_M_V_OFFS_SHD		(ISP3X_DUAL_CROP_BASE + 0x00028)
#define ISP3X_DUAL_CROP_M_H_SIZE_SHD		(ISP3X_DUAL_CROP_BASE + 0x0002c)
#define ISP3X_DUAL_CROP_M_V_SIZE_SHD		(ISP3X_DUAL_CROP_BASE + 0x00030)
#define ISP3X_DUAL_CROP_S_H_OFFS_SHD		(ISP3X_DUAL_CROP_BASE + 0x00034)
#define ISP3X_DUAL_CROP_S_V_OFFS_SHD		(ISP3X_DUAL_CROP_BASE + 0x00038)
#define ISP3X_DUAL_CROP_S_H_SIZE_SHD		(ISP3X_DUAL_CROP_BASE + 0x0003c)
#define ISP3X_DUAL_CROP_S_V_SIZE_SHD		(ISP3X_DUAL_CROP_BASE + 0x00040)
#define ISP3X_DUAL_CROP_FBC_H_OFFS		(ISP3X_DUAL_CROP_BASE + 0x00044)
#define ISP3X_DUAL_CROP_FBC_V_OFFS		(ISP3X_DUAL_CROP_BASE + 0x00048)
#define ISP3X_DUAL_CROP_FBC_H_SIZE		(ISP3X_DUAL_CROP_BASE + 0x0004C)
#define ISP3X_DUAL_CROP_FBC_V_SIZE		(ISP3X_DUAL_CROP_BASE + 0x00050)
#define ISP3X_DUAL_CROP_FBC_H_OFFS_SHD		(ISP3X_DUAL_CROP_BASE + 0x00054)
#define ISP3X_DUAL_CROP_FBC_V_OFFS_SHD		(ISP3X_DUAL_CROP_BASE + 0x00058)
#define ISP3X_DUAL_CROP_FBC_H_SIZE_SHD		(ISP3X_DUAL_CROP_BASE + 0x0005C)
#define ISP3X_DUAL_CROP_FBC_V_SIZE_SHD		(ISP3X_DUAL_CROP_BASE + 0x00060)

#define ISP3X_GAMMA_OUT_BASE			0x00000900
#define ISP3X_GAMMA_OUT_CTRL			(ISP3X_GAMMA_OUT_BASE + 0x00000)
#define ISP3X_GAMMA_OUT_OFFSET			(ISP3X_GAMMA_OUT_BASE + 0x00004)
#define ISP3X_GAMMA_OUT_Y0			(ISP3X_GAMMA_OUT_BASE + 0x00010)
#define ISP3X_GAMMA_OUT_Y1			(ISP3X_GAMMA_OUT_BASE + 0x00014)
#define ISP3X_GAMMA_OUT_Y2			(ISP3X_GAMMA_OUT_BASE + 0x00018)
#define ISP3X_GAMMA_OUT_Y3			(ISP3X_GAMMA_OUT_BASE + 0x0001c)
#define ISP3X_GAMMA_OUT_Y4			(ISP3X_GAMMA_OUT_BASE + 0x00020)
#define ISP3X_GAMMA_OUT_Y5			(ISP3X_GAMMA_OUT_BASE + 0x00024)
#define ISP3X_GAMMA_OUT_Y6			(ISP3X_GAMMA_OUT_BASE + 0x00028)
#define ISP3X_GAMMA_OUT_Y7			(ISP3X_GAMMA_OUT_BASE + 0x0002c)
#define ISP3X_GAMMA_OUT_Y8			(ISP3X_GAMMA_OUT_BASE + 0x00030)
#define ISP3X_GAMMA_OUT_Y9			(ISP3X_GAMMA_OUT_BASE + 0x00034)
#define ISP3X_GAMMA_OUT_Y10			(ISP3X_GAMMA_OUT_BASE + 0x00038)
#define ISP3X_GAMMA_OUT_Y11			(ISP3X_GAMMA_OUT_BASE + 0x0003c)
#define ISP3X_GAMMA_OUT_Y12			(ISP3X_GAMMA_OUT_BASE + 0x00040)
#define ISP3X_GAMMA_OUT_Y13			(ISP3X_GAMMA_OUT_BASE + 0x00044)
#define ISP3X_GAMMA_OUT_Y14			(ISP3X_GAMMA_OUT_BASE + 0x00048)
#define ISP3X_GAMMA_OUT_Y15			(ISP3X_GAMMA_OUT_BASE + 0x0004c)
#define ISP3X_GAMMA_OUT_Y16			(ISP3X_GAMMA_OUT_BASE + 0x00050)
#define ISP3X_GAMMA_OUT_Y17			(ISP3X_GAMMA_OUT_BASE + 0x00054)
#define ISP3X_GAMMA_OUT_Y18			(ISP3X_GAMMA_OUT_BASE + 0x00058)
#define ISP3X_GAMMA_OUT_Y19			(ISP3X_GAMMA_OUT_BASE + 0x0005c)
#define ISP3X_GAMMA_OUT_Y20			(ISP3X_GAMMA_OUT_BASE + 0x00060)
#define ISP3X_GAMMA_OUT_Y21			(ISP3X_GAMMA_OUT_BASE + 0x00064)
#define ISP3X_GAMMA_OUT_Y22			(ISP3X_GAMMA_OUT_BASE + 0x00068)
#define ISP3X_GAMMA_OUT_Y23			(ISP3X_GAMMA_OUT_BASE + 0x0006c)
#define ISP3X_GAMMA_OUT_Y24			(ISP3X_GAMMA_OUT_BASE + 0x00070)

#define ISP3X_MAIN_RESIZE_BASE			0x00000C00
#define ISP3X_MAIN_RESIZE_CTRL			(ISP3X_MAIN_RESIZE_BASE + 0x00000)
#define ISP3X_MAIN_RESIZE_SCALE_HY		(ISP3X_MAIN_RESIZE_BASE + 0x00004)
#define ISP3X_MAIN_RESIZE_SCALE_HCB		(ISP3X_MAIN_RESIZE_BASE + 0x00008)
#define ISP3X_MAIN_RESIZE_SCALE_HCR		(ISP3X_MAIN_RESIZE_BASE + 0x0000c)
#define ISP3X_MAIN_RESIZE_SCALE_VY		(ISP3X_MAIN_RESIZE_BASE + 0x00010)
#define ISP3X_MAIN_RESIZE_SCALE_VC		(ISP3X_MAIN_RESIZE_BASE + 0x00014)
#define ISP3X_MAIN_RESIZE_PHASE_HY		(ISP3X_MAIN_RESIZE_BASE + 0x00018)
#define ISP3X_MAIN_RESIZE_PHASE_HC		(ISP3X_MAIN_RESIZE_BASE + 0x0001c)
#define ISP3X_MAIN_RESIZE_PHASE_VY		(ISP3X_MAIN_RESIZE_BASE + 0x00020)
#define ISP3X_MAIN_RESIZE_PHASE_VC		(ISP3X_MAIN_RESIZE_BASE + 0x00024)
#define ISP3X_MAIN_RESIZE_SCALE_LUT_ADDR	(ISP3X_MAIN_RESIZE_BASE + 0x00028)
#define ISP3X_MAIN_RESIZE_SCALE_LUT		(ISP3X_MAIN_RESIZE_BASE + 0x0002c)
#define ISP3X_MAIN_RESIZE_CTRL_SHD		(ISP3X_MAIN_RESIZE_BASE + 0x00030)
#define ISP3X_MAIN_RESIZE_SCALE_HY_SHD		(ISP3X_MAIN_RESIZE_BASE + 0x00034)
#define ISP3X_MAIN_RESIZE_SCALE_HCB_SHD		(ISP3X_MAIN_RESIZE_BASE + 0x00038)
#define ISP3X_MAIN_RESIZE_SCALE_HCR_SHD		(ISP3X_MAIN_RESIZE_BASE + 0x0003c)
#define ISP3X_MAIN_RESIZE_SCALE_VY_SHD		(ISP3X_MAIN_RESIZE_BASE + 0x00040)
#define ISP3X_MAIN_RESIZE_SCALE_VC_SHD		(ISP3X_MAIN_RESIZE_BASE + 0x00044)
#define ISP3X_MAIN_RESIZE_PHASE_HY_SHD		(ISP3X_MAIN_RESIZE_BASE + 0x00048)
#define ISP3X_MAIN_RESIZE_PHASE_HC_SHD		(ISP3X_MAIN_RESIZE_BASE + 0x0004c)
#define ISP3X_MAIN_RESIZE_PHASE_VY_SHD		(ISP3X_MAIN_RESIZE_BASE + 0x00050)
#define ISP3X_MAIN_RESIZE_PHASE_VC_SHD		(ISP3X_MAIN_RESIZE_BASE + 0x00054)
#define ISP3X_MAIN_RESIZE_HY_SIZE		(ISP3X_MAIN_RESIZE_BASE + 0x00058)
#define ISP3X_MAIN_RESIZE_HC_SIZE		(ISP3X_MAIN_RESIZE_BASE + 0x0005C)
#define ISP3X_MAIN_RESIZE_HY_OFFS_MI		(ISP3X_MAIN_RESIZE_BASE + 0x00060)
#define ISP3X_MAIN_RESIZE_HC_OFFS_MI		(ISP3X_MAIN_RESIZE_BASE + 0x00064)
#define ISP3X_MAIN_RESIZE_HY_SIZE_SHD		(ISP3X_MAIN_RESIZE_BASE + 0x00068)
#define ISP3X_MAIN_RESIZE_HC_SIZE_SHD		(ISP3X_MAIN_RESIZE_BASE + 0x0006C)
#define ISP3X_MAIN_RESIZE_HY_OFFS_MI_SHD	(ISP3X_MAIN_RESIZE_BASE + 0x00070)
#define ISP3X_MAIN_RESIZE_HC_OFFS_MI_SHD	(ISP3X_MAIN_RESIZE_BASE + 0x00074)
#define ISP3X_MAIN_RESIZE_IN_CROP_OFFSET	(ISP3X_MAIN_RESIZE_BASE + 0x00078)

#define ISP32_BP_RESIZE_BASE			0x00000E00
#define ISP32_BP_RESIZE_CTRL			(ISP32_BP_RESIZE_BASE + 0x00000)
#define ISP32_BP_RESIZE_SCALE_HY		(ISP32_BP_RESIZE_BASE + 0x00004)
#define ISP32_BP_RESIZE_SCALE_HCB		(ISP32_BP_RESIZE_BASE + 0x00008)
#define ISP32_BP_RESIZE_SCALE_HCR		(ISP32_BP_RESIZE_BASE + 0x0000c)
#define ISP32_BP_RESIZE_SCALE_VY		(ISP32_BP_RESIZE_BASE + 0x00010)
#define ISP32_BP_RESIZE_SCALE_VC		(ISP32_BP_RESIZE_BASE + 0x00014)
#define ISP32_BP_RESIZE_PHASE_HY		(ISP32_BP_RESIZE_BASE + 0x00018)
#define ISP32_BP_RESIZE_PHASE_HC		(ISP32_BP_RESIZE_BASE + 0x0001c)
#define ISP32_BP_RESIZE_PHASE_VY		(ISP32_BP_RESIZE_BASE + 0x00020)
#define ISP32_BP_RESIZE_PHASE_VC		(ISP32_BP_RESIZE_BASE + 0x00024)
#define ISP32_BP_RESIZE_SCALE_LUT_ADDR		(ISP32_BP_RESIZE_BASE + 0x00028)
#define ISP32_BP_RESIZE_SCALE_LUT		(ISP32_BP_RESIZE_BASE + 0x0002c)
#define ISP32_BP_RESIZE_CTRL_SHD		(ISP32_BP_RESIZE_BASE + 0x00030)
#define ISP32_BP_RESIZE_SCALE_HY_SHD		(ISP32_BP_RESIZE_BASE + 0x00034)
#define ISP32_BP_RESIZE_SCALE_HCB_SHD		(ISP32_BP_RESIZE_BASE + 0x00038)
#define ISP32_BP_RESIZE_SCALE_HCR_SHD		(ISP32_BP_RESIZE_BASE + 0x0003c)
#define ISP32_BP_RESIZE_SCALE_VY_SHD		(ISP32_BP_RESIZE_BASE + 0x00040)
#define ISP32_BP_RESIZE_SCALE_VC_SHD		(ISP32_BP_RESIZE_BASE + 0x00044)
#define ISP32_BP_RESIZE_PHASE_HY_SHD		(ISP32_BP_RESIZE_BASE + 0x00048)
#define ISP32_BP_RESIZE_PHASE_HC_SHD		(ISP32_BP_RESIZE_BASE + 0x0004c)
#define ISP32_BP_RESIZE_PHASE_VY_SHD		(ISP32_BP_RESIZE_BASE + 0x00050)
#define ISP32_BP_RESIZE_PHASE_VC_SHD		(ISP32_BP_RESIZE_BASE + 0x00054)

#define ISP3X_SELF_RESIZE_BASE			0x00001000
#define ISP3X_SELF_RESIZE_CTRL			(ISP3X_SELF_RESIZE_BASE + 0x00000)
#define ISP3X_SELF_RESIZE_SCALE_HY		(ISP3X_SELF_RESIZE_BASE + 0x00004)
#define ISP3X_SELF_RESIZE_SCALE_HCB		(ISP3X_SELF_RESIZE_BASE + 0x00008)
#define ISP3X_SELF_RESIZE_SCALE_HCR		(ISP3X_SELF_RESIZE_BASE + 0x0000c)
#define ISP3X_SELF_RESIZE_SCALE_VY		(ISP3X_SELF_RESIZE_BASE + 0x00010)
#define ISP3X_SELF_RESIZE_SCALE_VC		(ISP3X_SELF_RESIZE_BASE + 0x00014)
#define ISP3X_SELF_RESIZE_PHASE_HY		(ISP3X_SELF_RESIZE_BASE + 0x00018)
#define ISP3X_SELF_RESIZE_PHASE_HC		(ISP3X_SELF_RESIZE_BASE + 0x0001c)
#define ISP3X_SELF_RESIZE_PHASE_VY		(ISP3X_SELF_RESIZE_BASE + 0x00020)
#define ISP3X_SELF_RESIZE_PHASE_VC		(ISP3X_SELF_RESIZE_BASE + 0x00024)
#define ISP3X_SELF_RESIZE_SCALE_LUT_ADDR	(ISP3X_SELF_RESIZE_BASE + 0x00028)
#define ISP3X_SELF_RESIZE_SCALE_LUT		(ISP3X_SELF_RESIZE_BASE + 0x0002c)
#define ISP3X_SELF_RESIZE_CTRL_SHD		(ISP3X_SELF_RESIZE_BASE + 0x00030)
#define ISP3X_SELF_RESIZE_SCALE_HY_SHD		(ISP3X_SELF_RESIZE_BASE + 0x00034)
#define ISP3X_SELF_RESIZE_SCALE_HCB_SHD		(ISP3X_SELF_RESIZE_BASE + 0x00038)
#define ISP3X_SELF_RESIZE_SCALE_HCR_SHD		(ISP3X_SELF_RESIZE_BASE + 0x0003c)
#define ISP3X_SELF_RESIZE_SCALE_VY_SHD		(ISP3X_SELF_RESIZE_BASE + 0x00040)
#define ISP3X_SELF_RESIZE_SCALE_VC_SHD		(ISP3X_SELF_RESIZE_BASE + 0x00044)
#define ISP3X_SELF_RESIZE_PHASE_HY_SHD		(ISP3X_SELF_RESIZE_BASE + 0x00048)
#define ISP3X_SELF_RESIZE_PHASE_HC_SHD		(ISP3X_SELF_RESIZE_BASE + 0x0004c)
#define ISP3X_SELF_RESIZE_PHASE_VY_SHD		(ISP3X_SELF_RESIZE_BASE + 0x00050)
#define ISP3X_SELF_RESIZE_PHASE_VC_SHD		(ISP3X_SELF_RESIZE_BASE + 0x00054)
#define ISP3X_SELF_RESIZE_HY_SIZE		(ISP3X_SELF_RESIZE_BASE + 0x00058)
#define ISP3X_SELF_RESIZE_HC_SIZE		(ISP3X_SELF_RESIZE_BASE + 0x0005C)
#define ISP3X_SELF_RESIZE_HY_OFFS_MI		(ISP3X_SELF_RESIZE_BASE + 0x00060)
#define ISP3X_SELF_RESIZE_HC_OFFS_MI		(ISP3X_SELF_RESIZE_BASE + 0x00064)
#define ISP3X_SELF_RESIZE_HY_SIZE_SHD		(ISP3X_SELF_RESIZE_BASE + 0x00068)
#define ISP3X_SELF_RESIZE_HC_SIZE_SHD		(ISP3X_SELF_RESIZE_BASE + 0x0006C)
#define ISP3X_SELF_RESIZE_HY_OFFS_MI_SHD	(ISP3X_SELF_RESIZE_BASE + 0x00070)
#define ISP3X_SELF_RESIZE_HC_OFFS_MI_SHD	(ISP3X_SELF_RESIZE_BASE + 0x00074)
#define ISP3X_SELF_RESIZE_IN_CROP_OFFSET	(ISP3X_SELF_RESIZE_BASE + 0x00078)

#define ISP3X_MI_BASE				0x00001400
#define ISP3X_MI_WR_CTRL			(ISP3X_MI_BASE + 0x00000)
#define ISP3X_MI_WR_INIT			(ISP3X_MI_BASE + 0x00004)
#define ISP3X_MI_MP_WR_Y_BASE			(ISP3X_MI_BASE + 0x00008)
#define ISP3X_MI_MP_WR_Y_SIZE			(ISP3X_MI_BASE + 0x0000c)
#define ISP3X_MI_MP_WR_Y_OFFS_CNT		(ISP3X_MI_BASE + 0x00010)
#define ISP3X_MI_MP_WR_Y_OFFS_CNT_START		(ISP3X_MI_BASE + 0x00014)
#define ISP3X_MI_MP_WR_Y_IRQ_OFFS		(ISP3X_MI_BASE + 0x00018)
#define ISP3X_MI_MP_WR_CB_BASE			(ISP3X_MI_BASE + 0x0001c)
#define ISP3X_MI_MP_WR_CB_SIZE			(ISP3X_MI_BASE + 0x00020)
#define ISP3X_MI_MP_WR_CB_OFFS_CNT		(ISP3X_MI_BASE + 0x00024)
#define ISP3X_MI_MP_WR_CB_OFFS_CNT_START	(ISP3X_MI_BASE + 0x00028)
#define ISP3X_MI_MP_WR_CR_BASE			(ISP3X_MI_BASE + 0x0002c)
#define ISP3X_MI_MP_WR_CR_SIZE			(ISP3X_MI_BASE + 0x00030)
#define ISP3X_MI_MP_WR_CR_OFFS_CNT		(ISP3X_MI_BASE + 0x00034)
#define ISP3X_MI_MP_WR_CR_OFFS_CNT_START	(ISP3X_MI_BASE + 0x00038)
#define ISP3X_MI_SP_WR_Y_BASE			(ISP3X_MI_BASE + 0x0003c)
#define ISP3X_MI_SP_WR_Y_SIZE			(ISP3X_MI_BASE + 0x00040)
#define ISP3X_MI_SP_WR_Y_OFFS_CNT		(ISP3X_MI_BASE + 0x00044)
#define ISP3X_MI_SP_WR_Y_OFFS_CNT_START		(ISP3X_MI_BASE + 0x00048)
#define ISP3X_MI_SP_WR_Y_LLENGTH		(ISP3X_MI_BASE + 0x0004c)
#define ISP3X_MI_SP_WR_CB_BASE			(ISP3X_MI_BASE + 0x00050)
#define ISP3X_MI_SP_WR_CB_SIZE			(ISP3X_MI_BASE + 0x00054)
#define ISP3X_MI_SP_WR_CB_OFFS_CNT		(ISP3X_MI_BASE + 0x00058)
#define ISP3X_MI_SP_WR_CB_OFFS_CNT_START	(ISP3X_MI_BASE + 0x0005c)
#define ISP3X_MI_SP_WR_CR_BASE			(ISP3X_MI_BASE + 0x00060)
#define ISP3X_MI_SP_WR_CR_SIZE			(ISP3X_MI_BASE + 0x00064)
#define ISP3X_MI_SP_WR_CR_OFFS_CNT		(ISP3X_MI_BASE + 0x00068)
#define ISP3X_MI_SP_WR_CR_OFFS_CNT_START	(ISP3X_MI_BASE + 0x0006c)
#define ISP3X_MI_WR_BYTE_CNT			(ISP3X_MI_BASE + 0x00070)
#define ISP3X_MI_WR_CTRL_SHD			(ISP3X_MI_BASE + 0x00074)
#define ISP3X_MI_MP_WR_Y_BASE_SHD		(ISP3X_MI_BASE + 0x00078)
#define ISP3X_MI_MP_WR_Y_SIZE_SHD		(ISP3X_MI_BASE + 0x0007c)
#define ISP3X_MI_MP_WR_Y_OFFS_CNT_SHD		(ISP3X_MI_BASE + 0x00080)
#define ISP3X_MI_MP_WR_Y_IRQ_OFFS_SHD		(ISP3X_MI_BASE + 0x00084)
#define ISP3X_MI_MP_WR_CB_BASE_SHD		(ISP3X_MI_BASE + 0x00088)
#define ISP3X_MI_MP_WR_CB_SIZE_SHD		(ISP3X_MI_BASE + 0x0008c)
#define ISP3X_MI_MP_WR_CB_OFFS_CNT_SHD		(ISP3X_MI_BASE + 0x00090)
#define ISP3X_MI_MP_WR_CR_BASE_SHD		(ISP3X_MI_BASE + 0x00094)
#define ISP3X_MI_MP_WR_CR_SIZE_SHD		(ISP3X_MI_BASE + 0x00098)
#define ISP3X_MI_MP_WR_CR_OFFS_CNT_SHD		(ISP3X_MI_BASE + 0x0009c)
#define ISP3X_MI_SP_WR_Y_BASE_SHD		(ISP3X_MI_BASE + 0x000a0)
#define ISP3X_MI_SP_WR_Y_SIZE_SHD		(ISP3X_MI_BASE + 0x000a4)
#define ISP3X_MI_SP_WR_Y_OFFS_CNT_SHD		(ISP3X_MI_BASE + 0x000a8)
#define ISP3X_MI_SP_WR_CB_BASE_AD_SHD		(ISP3X_MI_BASE + 0x000b0)
#define ISP3X_MI_SP_WR_CB_SIZE_SHD		(ISP3X_MI_BASE + 0x000b4)
#define ISP3X_MI_SP_WR_CB_OFFS_CNT_SHD		(ISP3X_MI_BASE + 0x000b8)
#define ISP3X_MI_SP_WR_CR_BASE_AD_SHD		(ISP3X_MI_BASE + 0x000bc)
#define ISP3X_MI_SP_WR_CR_SIZE_SHD		(ISP3X_MI_BASE + 0x000c0)
#define ISP3X_MI_SP_WR_CR_OFFS_CNT_SHD		(ISP3X_MI_BASE + 0x000c4)
#define ISP3X_MI_IMSC				(ISP3X_MI_BASE + 0x000f8)
#define ISP3X_MI_RIS				(ISP3X_MI_BASE + 0x000fc)
#define ISP3X_MI_MIS				(ISP3X_MI_BASE + 0x00100)
#define ISP3X_MI_ICR				(ISP3X_MI_BASE + 0x00104)
#define ISP3X_MI_ISR				(ISP3X_MI_BASE + 0x00108)
#define ISP3X_MI_STATUS				(ISP3X_MI_BASE + 0x0010c)
#define ISP3X_MI_STATUS_CLR			(ISP3X_MI_BASE + 0x00110)
#define ISP3X_MI_SP_WR_Y_PIC_WIDTH		(ISP3X_MI_BASE + 0x00114)
#define ISP3X_MI_SP_WR_Y_PIC_HEIGHT		(ISP3X_MI_BASE + 0x00118)
#define ISP3X_MI_SP_WR_Y_PIC_SIZE		(ISP3X_MI_BASE + 0x0011c)
#define ISP3X_MI_WR_PIXEL_CNT			(ISP3X_MI_BASE + 0x0012c)
#define ISP3X_MI_MP_WR_Y_BASE2			(ISP3X_MI_BASE + 0x00130)
#define ISP3X_MI_MP_WR_CB_BASE2			(ISP3X_MI_BASE + 0x00134)
#define ISP3X_MI_MP_WR_CR_BASE2			(ISP3X_MI_BASE + 0x00138)
#define ISP3X_MI_SP_WR_Y_BASE2			(ISP3X_MI_BASE + 0x0013C)
#define ISP3X_MI_SP_WR_CB_BASE2			(ISP3X_MI_BASE + 0x00140)
#define ISP3X_MI_SP_WR_CR_BASE2			(ISP3X_MI_BASE + 0x00144)
#define ISP3X_MI_WR_XTD_FORMAT_CTRL		(ISP3X_MI_BASE + 0x00148)
#define ISP3X_MI_WR_ID				(ISP3X_MI_BASE + 0x00154)
#define ISP3X_MI_MP_WR_Y_IRQ_OFFS2		(ISP3X_MI_BASE + 0x001E0)
#define ISP3X_MI_MP_WR_Y_IRQ_OFFS2_SHD		(ISP3X_MI_BASE + 0x001E4)
#define ISP3X_MI_MP_WR_Y_LLENGTH		(ISP3X_MI_BASE + 0x001E8)
#define ISP3X_MI_MP_WR_Y_PIC_WIDTH		(ISP3X_MI_BASE + 0x001EC)
#define ISP3X_MI_MP_WR_Y_PIC_HEIGHT		(ISP3X_MI_BASE + 0x001F0)
#define ISP3X_MI_MP_WR_Y_PIC_SIZE		(ISP3X_MI_BASE + 0x001F4)
#define ISP32_MI_MP_WR_CTRL			(ISP3X_MI_BASE + 0x001F8)
#define ISP3X_MI_BP_WR_CTRL			(ISP3X_MI_BASE + 0x00200)
#define ISP3X_MI_BP_WR_Y_BASE			(ISP3X_MI_BASE + 0x00204)
#define ISP3X_MI_BP_WR_Y_SIZE			(ISP3X_MI_BASE + 0x00208)
#define ISP3X_MI_BP_WR_Y_OFFS_CNT		(ISP3X_MI_BASE + 0x0020C)
#define ISP3X_MI_BP_WR_Y_OFFS_CNT_START		(ISP3X_MI_BASE + 0x00210)
#define ISP3X_MI_BP_WR_Y_LLENGTH		(ISP3X_MI_BASE + 0x00214)
#define ISP3X_MI_BP_WR_Y_PIC_WIDTH		(ISP3X_MI_BASE + 0x00218)
#define ISP3X_MI_BP_WR_Y_PIC_HEIGHT		(ISP3X_MI_BASE + 0x0021C)
#define ISP3X_MI_BP_WR_Y_PIC_SIZE		(ISP3X_MI_BASE + 0x00220)
#define ISP3X_MI_BP_WR_CB_BASE			(ISP3X_MI_BASE + 0x00224)
#define ISP3X_MI_BP_WR_CB_SIZE			(ISP3X_MI_BASE + 0x00228)
#define ISP3X_MI_BP_WR_CB_OFFS_CNT		(ISP3X_MI_BASE + 0x0022C)
#define ISP3X_MI_BP_WR_CB_OFFS_CNT_START	(ISP3X_MI_BASE + 0x00230)
#define ISP3X_MI_BP_WR_Y_BASE_SHD		(ISP3X_MI_BASE + 0x00234)
#define ISP3X_MI_BP_WR_Y_SIZE_SHD		(ISP3X_MI_BASE + 0x00238)
#define ISP3X_MI_BP_WR_Y_OFFS_CNT_SHD		(ISP3X_MI_BASE + 0x0023C)
#define ISP3X_MI_BP_WR_CB_BASE_SHD		(ISP3X_MI_BASE + 0x00240)
#define ISP3X_MI_BP_WR_CB_SIZE_SHD		(ISP3X_MI_BASE + 0x00244)
#define ISP3X_MI_BP_WR_CB_OFFS_CNT_SHD		(ISP3X_MI_BASE + 0x00248)
#define ISP3X_MI_BP_WR_Y_BASE2			(ISP3X_MI_BASE + 0x0024C)
#define ISP3X_MI_BP_WR_CB_BASE2			(ISP3X_MI_BASE + 0x00250)
#define ISP32_MI_MP_WR_Y_END_ADDR		(ISP3X_MI_BASE + 0x00260)
#define ISP32_MI_MP_WR_CB_END_ADDR		(ISP3X_MI_BASE + 0x00264)
#define ISP32_MI_SP_WR_Y_END_ADDR		(ISP3X_MI_BASE + 0x00268)
#define ISP32_MI_SP_WR_CB_END_ADDR		(ISP3X_MI_BASE + 0x0026c)
#define ISP32_MI_BP_WR_Y_END_ADDR		(ISP3X_MI_BASE + 0x00270)
#define ISP32_MI_BP_WR_CB_END_ADDR		(ISP3X_MI_BASE + 0x00274)
#define ISP32_MI_MPDS_WR_Y_END_ADDR		(ISP3X_MI_BASE + 0x00278)
#define ISP32_MI_MPDS_WR_CB_END_ADDR		(ISP3X_MI_BASE + 0x0027c)
#define ISP32_MI_BPDS_WR_Y_END_ADDR		(ISP3X_MI_BASE + 0x00280)
#define ISP32_MI_BPDS_WR_CB_END_ADDR		(ISP3X_MI_BASE + 0x00284)
#define ISP32_MI_MPDS_WR_CTRL			(ISP3X_MI_BASE + 0x002a0)
#define ISP32_MI_MPDS_WR_Y_BASE			(ISP3X_MI_BASE + 0x002a4)
#define ISP32_MI_MPDS_WR_Y_SIZE			(ISP3X_MI_BASE + 0x002a8)
#define ISP32_MI_MPDS_WR_Y_OFFS_CNT		(ISP3X_MI_BASE + 0x002ac)
#define ISP32_MI_MPDS_WR_Y_OFFS_CNT_START	(ISP3X_MI_BASE + 0x002b0)
#define ISP32_MI_MPDS_WR_Y_LLENGTH		(ISP3X_MI_BASE + 0x002b4)
#define ISP32_MI_MPDS_WR_Y_PIC_WIDTH		(ISP3X_MI_BASE + 0x002b8)
#define ISP32_MI_MPDS_WR_Y_PIC_HEIGHT		(ISP3X_MI_BASE + 0x002bc)
#define ISP32_MI_MPDS_WR_Y_PIC_SIZE		(ISP3X_MI_BASE + 0x002c0)
#define ISP32_MI_MPDS_WR_CB_BASE		(ISP3X_MI_BASE + 0x002c4)
#define ISP32_MI_MPDS_WR_CB_SIZE		(ISP3X_MI_BASE + 0x002c8)
#define ISP32_MI_MPDS_WR_CB_OFFS_CNT		(ISP3X_MI_BASE + 0x002cc)
#define ISP32_MI_MPDS_WR_CB_OFFS_CNT_START	(ISP3X_MI_BASE + 0x002d0)
#define ISP32_MI_MPDS_WR_Y_BASE_SHD		(ISP3X_MI_BASE + 0x002d4)
#define ISP32_MI_MPDS_WR_Y_SIZE_SHD		(ISP3X_MI_BASE + 0x002d8)
#define ISP32_MI_MPDS_WR_Y_OFFS_CNT_SHD		(ISP3X_MI_BASE + 0x002dc)
#define ISP32_MI_MPDS_WR_CB_BASE_SHD		(ISP3X_MI_BASE + 0x002e0)
#define ISP32_MI_MPDS_WR_CB_SIZE_SHD		(ISP3X_MI_BASE + 0x002e4)
#define ISP32_MI_MPDS_WR_CB_OFFS_CNT_SHD	(ISP3X_MI_BASE + 0x002e8)
#define ISP32_MI_BPDS_WR_CTRL			(ISP3X_MI_BASE + 0x002f0)
#define ISP32_MI_BPDS_WR_Y_BASE			(ISP3X_MI_BASE + 0x002f4)
#define ISP32_MI_BPDS_WR_Y_SIZE			(ISP3X_MI_BASE + 0x002f8)
#define ISP32_MI_BPDS_WR_Y_OFFS_CNT		(ISP3X_MI_BASE + 0x002fc)
#define ISP32_MI_BPDS_WR_Y_OFFS_CNT_START	(ISP3X_MI_BASE + 0x00300)
#define ISP32_MI_BPDS_WR_Y_LLENGTH		(ISP3X_MI_BASE + 0x00304)
#define ISP32_MI_BPDS_WR_Y_PIC_WIDTH		(ISP3X_MI_BASE + 0x00308)
#define ISP32_MI_BPDS_WR_Y_PIC_HEIGHT		(ISP3X_MI_BASE + 0x0030c)
#define ISP32_MI_BPDS_WR_Y_PIC_SIZE		(ISP3X_MI_BASE + 0x00310)
#define ISP32_MI_BPDS_WR_CB_BASE		(ISP3X_MI_BASE + 0x00314)
#define ISP32_MI_BPDS_WR_CB_SIZE		(ISP3X_MI_BASE + 0x00318)
#define ISP32_MI_BPDS_WR_CB_OFFS_CNT		(ISP3X_MI_BASE + 0x0031c)
#define ISP32_MI_BPDS_WR_CB_OFFS_CNT_START	(ISP3X_MI_BASE + 0x00320)
#define ISP32_MI_BPDS_WR_Y_BASE_SHD		(ISP3X_MI_BASE + 0x00324)
#define ISP32_MI_BPDS_WR_Y_SIZE_SHD		(ISP3X_MI_BASE + 0x00328)
#define ISP32_MI_BPDS_WR_Y_OFFS_CNT_SHD		(ISP3X_MI_BASE + 0x0032c)
#define ISP32_MI_BPDS_WR_CB_BASE_SHD		(ISP3X_MI_BASE + 0x00330)
#define ISP32_MI_BPDS_WR_CB_SIZE_SHD		(ISP3X_MI_BASE + 0x00334)
#define ISP32_MI_BPDS_WR_CB_OFFS_CNT_SHD	(ISP3X_MI_BASE + 0x00338)
#define ISP3X_MI_WR_CTRL2			(ISP3X_MI_BASE + 0x00400)
#define ISP3X_MI_WR_ID2				(ISP3X_MI_BASE + 0x00404)
#define ISP3X_MI_RD_CTRL2			(ISP3X_MI_BASE + 0x00408)
#define ISP3X_MI_RD_ID				(ISP3X_MI_BASE + 0x0040c)
#define ISP32_MI_WR_CTRL2_SHD			(ISP3X_MI_BASE + 0x00410)
#define ISP32_MI_WR_WRAP_CTRL			(ISP3X_MI_BASE + 0x00414)
#define ISP32_MI_WR_VFLIP_CTRL			(ISP3X_MI_BASE + 0x00418)
#define ISP3X_MI_RAW0_RD_BASE			(ISP3X_MI_BASE + 0x00470)
#define ISP3X_MI_RAW0_RD_LENGTH			(ISP3X_MI_BASE + 0x00474)
#define ISP3X_MI_RAW0_RD_BASE_SHD		(ISP3X_MI_BASE + 0x00478)
#define ISP32_MI_RAW0_RD_SIZE			(ISP3X_MI_BASE + 0x0047c)
#define ISP3X_MI_RAW1_RD_BASE			(ISP3X_MI_BASE + 0x00480)
#define ISP3X_MI_RAW1_RD_LENGTH			(ISP3X_MI_BASE + 0x00484)
#define ISP3X_MI_RAW1_RD_BASE_SHD		(ISP3X_MI_BASE + 0x00488)
#define ISP32_MI_RAW1_RD_SIZE			(ISP3X_MI_BASE + 0x0048c)
#define ISP3X_MI_RAWS_RD_BASE			(ISP3X_MI_BASE + 0x00490)
#define ISP3X_MI_RAWS_RD_LENGTH			(ISP3X_MI_BASE + 0x00494)
#define ISP3X_MI_RAWS_RD_BASE_SHD		(ISP3X_MI_BASE + 0x00498)
#define ISP32_MI_RAWS_RD_SIZE			(ISP3X_MI_BASE + 0x0049c)
#define ISP3X_MI_LUT_CAC_RD_BASE		(ISP3X_MI_BASE + 0x00530)
#define ISP3X_MI_LUT_CAC_RD_H_WSIZE		(ISP3X_MI_BASE + 0x00534)
#define ISP3X_MI_LUT_CAC_RD_V_SIZE		(ISP3X_MI_BASE + 0x00538)
#define ISP3X_MI_LUT_3D_RD_BASE			(ISP3X_MI_BASE + 0x00540)
#define ISP3X_MI_LUT_LSC_RD_BASE		(ISP3X_MI_BASE + 0x00544)
#define ISP3X_MI_LUT_LDCH_RD_BASE		(ISP3X_MI_BASE + 0x00548)
#define ISP3X_MI_LUT_3D_RD_WSIZE		(ISP3X_MI_BASE + 0x00550)
#define ISP3X_MI_LUT_LSC_RD_WSIZE		(ISP3X_MI_BASE + 0x00554)
#define ISP3X_MI_LUT_LDCH_RD_H_WSIZE		(ISP3X_MI_BASE + 0x00558)
#define ISP3X_MI_LUT_LDCH_RD_V_SIZE		(ISP3X_MI_BASE + 0x0055C)
#define ISP3X_MI_DBR_WR_BASE			(ISP3X_MI_BASE + 0x00560)
#define ISP3X_MI_DBR_WR_SIZE			(ISP3X_MI_BASE + 0x00564)
#define ISP3X_MI_DBR_WR_LENGTH			(ISP3X_MI_BASE + 0x00568)
#define ISP3X_MI_DBR_WR_BASE_SHD		(ISP3X_MI_BASE + 0x0056C)
#define ISP3X_MI_DBR_RD_BASE			(ISP3X_MI_BASE + 0x00570)
#define ISP3X_MI_DBR_RD_LENGTH			(ISP3X_MI_BASE + 0x00574)
#define ISP3X_MI_DBR_RD_BASE_SHD		(ISP3X_MI_BASE + 0x00578)
#define ISP3X_MI_3A_WR_BASE			(ISP3X_MI_BASE + 0x0057C)
#define ISP3X_MI_GAIN_WR_BASE			(ISP3X_MI_BASE + 0x00580)
#define ISP3X_MI_GAIN_WR_SIZE			(ISP3X_MI_BASE + 0x00584)
#define ISP3X_MI_GAIN_WR_LENGTH			(ISP3X_MI_BASE + 0x00588)
#define ISP3X_MI_GAIN_WR_BASE2			(ISP3X_MI_BASE + 0x0058C)
#define ISP3X_MI_GAIN_WR_BASE_SHD		(ISP3X_MI_BASE + 0x00590)
#define ISP3X_MI_BAY3D_IIR_WR_BASE		(ISP3X_MI_BASE + 0x005A0)
#define ISP3X_MI_BAY3D_IIR_WR_SIZE		(ISP3X_MI_BASE + 0x005A4)
#define ISP3X_MI_BAY3D_IIR_WR_LENGTH		(ISP3X_MI_BASE + 0x005A8)
#define ISP3X_MI_BAY3D_IIR_WR_BASE_SHD		(ISP3X_MI_BASE + 0x005AC)
#define ISP3X_MI_BAY3D_IIR_RD_BASE		(ISP3X_MI_BASE + 0x005B0)
#define ISP3X_MI_BAY3D_IIR_RD_LENGTH		(ISP3X_MI_BASE + 0x005B4)
#define ISP3X_MI_BAY3D_IIR_RD_BASE_SHD		(ISP3X_MI_BASE + 0x005B8)
#define ISP3X_MI_BAY3D_CUR_WR_BASE		(ISP3X_MI_BASE + 0x005C0)
#define ISP3X_MI_BAY3D_CUR_WR_SIZE		(ISP3X_MI_BASE + 0x005C4)
#define ISP3X_MI_BAY3D_CUR_WR_LENGTH		(ISP3X_MI_BASE + 0x005C8)
#define ISP3X_MI_BAY3D_CUR_WR_BASE_SHD		(ISP3X_MI_BASE + 0x005CC)
#define ISP3X_MI_BAY3D_CUR_RD_BASE		(ISP3X_MI_BASE + 0x005D0)
#define ISP3X_MI_BAY3D_CUR_RD_LENGTH		(ISP3X_MI_BASE + 0x005D4)
#define ISP3X_MI_BAY3D_CUR_RD_BASE_SHD		(ISP3X_MI_BASE + 0x005D8)
#define ISP32_MI_BAY3D_CUR_RD_SIZE		(ISP3X_MI_BASE + 0x005DC)
#define ISP3X_MI_BAY3D_DS_WR_BASE		(ISP3X_MI_BASE + 0x005E0)
#define ISP3X_MI_BAY3D_DS_WR_SIZE		(ISP3X_MI_BASE + 0x005E4)
#define ISP3X_MI_BAY3D_DS_WR_LENGTH		(ISP3X_MI_BASE + 0x005E8)
#define ISP3X_MI_BAY3D_DS_WR_BASE_SHD		(ISP3X_MI_BASE + 0x005EC)
#define ISP3X_MI_BAY3D_DS_RD_BASE		(ISP3X_MI_BASE + 0x005F0)
#define ISP3X_MI_BAY3D_DS_RD_LENGTH		(ISP3X_MI_BASE + 0x005F4)
#define ISP3X_MI_BAY3D_DS_RD_BASE_SHD		(ISP3X_MI_BASE + 0x005F8)

#define ISP3X_MPFBC_BASE			0x000018C0
#define ISP3X_MPFBC_CTRL			(ISP3X_MPFBC_BASE + 0x00000)
#define ISP3X_MPFBC_VIR_WIDTH			(ISP3X_MPFBC_BASE + 0x00004)
#define ISP3X_MPFBC_VIR_HEIGHT			(ISP3X_MPFBC_BASE + 0x00008)
#define ISP3X_MPFBC_HEAD_PTR			(ISP3X_MPFBC_BASE + 0x0000c)
#define ISP3X_MPFBC_PAYL_PTR			(ISP3X_MPFBC_BASE + 0x00010)
#define ISP3X_MPFBC_HEAD_PTR2			(ISP3X_MPFBC_BASE + 0x00014)
#define ISP3X_MPFBC_PAYL_PTR2			(ISP3X_MPFBC_BASE + 0x00018)
#define ISP3X_MPFBC_PAYL_WIDTH			(ISP3X_MPFBC_BASE + 0x0001c)
#define ISP3X_MPFBC_HEAD_OFFSET			(ISP3X_MPFBC_BASE + 0x00020)
#define ISP3X_MPFBC_ENC_POS			(ISP3X_MPFBC_BASE + 0x00030)
#define ISP3X_MPFBC_DEBUG			(ISP3X_MPFBC_BASE + 0x00034)

#define ISP3X_CSI2RX_BASE			0x00001C00
#define ISP3X_CSI2RX_CTRL0			(ISP3X_CSI2RX_BASE + 0x00000)
#define ISP3X_CSI2RX_CTRL1			(ISP3X_CSI2RX_BASE + 0x00004)
#define ISP3X_CSI2RX_CTRL2			(ISP3X_CSI2RX_BASE + 0x00008)
#define ISP32_CSI2RX_CTRL3			(ISP3X_CSI2RX_BASE + 0x0000c)
#define ISP3X_CSI2RX_CSI2_RESETN		(ISP3X_CSI2RX_BASE + 0x00010)
#define ISP3X_CSI2RX_PHY_STATE_RO		(ISP3X_CSI2RX_BASE + 0x00014)
#define ISP3X_CSI2RX_DATA_IDS_1			(ISP3X_CSI2RX_BASE + 0x00018)
#define ISP3X_CSI2RX_DATA_IDS_2			(ISP3X_CSI2RX_BASE + 0x0001c)
#define ISP3X_CSI2RX_ERR_PHY			(ISP3X_CSI2RX_BASE + 0x00020)
#define ISP3X_CSI2RX_ERR_PACKET			(ISP3X_CSI2RX_BASE + 0x00024)
#define ISP3X_CSI2RX_ERR_OVERFLOW		(ISP3X_CSI2RX_BASE + 0x00028)
#define ISP3X_CSI2RX_ERR_STAT			(ISP3X_CSI2RX_BASE + 0x0002c)
#define ISP3X_CSI2RX_MASK_PHY			(ISP3X_CSI2RX_BASE + 0x00030)
#define ISP3X_CSI2RX_MASK_PACKET		(ISP3X_CSI2RX_BASE + 0x00034)
#define ISP3X_CSI2RX_MASK_OVERFLOW		(ISP3X_CSI2RX_BASE + 0x00038)
#define ISP3X_CSI2RX_MASK_STAT			(ISP3X_CSI2RX_BASE + 0x0003c)
#define ISP3X_CSI2RX_RAW_RD_CTRL		(ISP3X_CSI2RX_BASE + 0x00080)
#define ISP3X_CSI2RX_RAW_RD_LINECNT_RO		(ISP3X_CSI2RX_BASE + 0x00084)
#define ISP3X_CSI2RX_RAW_RD_PIC_SIZE		(ISP3X_CSI2RX_BASE + 0x00088)
#define ISP3X_CSI2RX_RAW2_RD_LINECNT_RO		(ISP3X_CSI2RX_BASE + 0x0008c)
#define ISP3X_CSI2RX_ISP_LINECNT_RO		(ISP3X_CSI2RX_BASE + 0x000b0)
#define ISP3X_CSI2RX_VERSION			(ISP3X_CSI2RX_BASE + 0x000fc)

#define ISP3X_LSC_BASE				0x00002200
#define ISP3X_LSC_CTRL				(ISP3X_LSC_BASE + 0x00000)
#define ISP3X_LSC_R_TABLE_ADDR			(ISP3X_LSC_BASE + 0x00004)
#define ISP3X_LSC_GR_TABLE_ADDR			(ISP3X_LSC_BASE + 0x00008)
#define ISP3X_LSC_B_TABLE_ADDR			(ISP3X_LSC_BASE + 0x0000c)
#define ISP3X_LSC_GB_TABLE_ADDR			(ISP3X_LSC_BASE + 0x00010)
#define ISP3X_LSC_R_TABLE_DATA			(ISP3X_LSC_BASE + 0x00014)
#define ISP3X_LSC_GR_TABLE_DATA			(ISP3X_LSC_BASE + 0x00018)
#define ISP3X_LSC_B_TABLE_DATA			(ISP3X_LSC_BASE + 0x0001c)
#define ISP3X_LSC_GB_TABLE_DATA			(ISP3X_LSC_BASE + 0x00020)
#define ISP3X_LSC_XGRAD_01			(ISP3X_LSC_BASE + 0x00024)
#define ISP3X_LSC_XGRAD_23			(ISP3X_LSC_BASE + 0x00028)
#define ISP3X_LSC_XGRAD_45			(ISP3X_LSC_BASE + 0x0002c)
#define ISP3X_LSC_XGRAD_67			(ISP3X_LSC_BASE + 0x00030)
#define ISP3X_LSC_YGRAD_01			(ISP3X_LSC_BASE + 0x00034)
#define ISP3X_LSC_YGRAD_23			(ISP3X_LSC_BASE + 0x00038)
#define ISP3X_LSC_YGRAD_45			(ISP3X_LSC_BASE + 0x0003c)
#define ISP3X_LSC_YGRAD_67			(ISP3X_LSC_BASE + 0x00040)
#define ISP3X_LSC_XSIZE_01			(ISP3X_LSC_BASE + 0x00044)
#define ISP3X_LSC_XSIZE_23			(ISP3X_LSC_BASE + 0x00048)
#define ISP3X_LSC_XSIZE_45			(ISP3X_LSC_BASE + 0x0004c)
#define ISP3X_LSC_XSIZE_67			(ISP3X_LSC_BASE + 0x00050)
#define ISP3X_LSC_YSIZE_01			(ISP3X_LSC_BASE + 0x00054)
#define ISP3X_LSC_YSIZE_23			(ISP3X_LSC_BASE + 0x00058)
#define ISP3X_LSC_YSIZE_45			(ISP3X_LSC_BASE + 0x0005c)
#define ISP3X_LSC_YSIZE_67			(ISP3X_LSC_BASE + 0x00060)
#define ISP3X_LSC_TABLE_SEL			(ISP3X_LSC_BASE + 0x00064)
#define ISP3X_LSC_STATUS			(ISP3X_LSC_BASE + 0x00068)
#define ISP3X_LSC_XGRAD_89			(ISP3X_LSC_BASE + 0x00070)
#define ISP3X_LSC_XGRAD_AB			(ISP3X_LSC_BASE + 0x00074)
#define ISP3X_LSC_XGRAD_CD			(ISP3X_LSC_BASE + 0x00078)
#define ISP3X_LSC_XGRAD_EF			(ISP3X_LSC_BASE + 0x0007C)
#define ISP3X_LSC_YGRAD_89			(ISP3X_LSC_BASE + 0x00080)
#define ISP3X_LSC_YGRAD_AB			(ISP3X_LSC_BASE + 0x00084)
#define ISP3X_LSC_YGRAD_CD			(ISP3X_LSC_BASE + 0x00088)
#define ISP3X_LSC_YGRAD_EF			(ISP3X_LSC_BASE + 0x0008C)
#define ISP3X_LSC_XSIZE_89			(ISP3X_LSC_BASE + 0x00090)
#define ISP3X_LSC_XSIZE_AB			(ISP3X_LSC_BASE + 0x00094)
#define ISP3X_LSC_XSIZE_CD			(ISP3X_LSC_BASE + 0x00098)
#define ISP3X_LSC_XSIZE_EF			(ISP3X_LSC_BASE + 0x0009C)
#define ISP3X_LSC_YSIZE_89			(ISP3X_LSC_BASE + 0x000A0)
#define ISP3X_LSC_YSIZE_AB			(ISP3X_LSC_BASE + 0x000A4)
#define ISP3X_LSC_YSIZE_CD			(ISP3X_LSC_BASE + 0x000A8)
#define ISP3X_LSC_YSIZE_EF			(ISP3X_LSC_BASE + 0x000AC)

#define ISP3X_DEBAYER_BASE			0x00002500
#define ISP3X_DEBAYER_CONTROL			(ISP3X_DEBAYER_BASE + 0x00000)
#define ISP3X_DEBAYER_G_INTERP			(ISP3X_DEBAYER_BASE + 0x00004)
#define ISP3X_DEBAYER_G_INTERP_FILTER1		(ISP3X_DEBAYER_BASE + 0x00008)
#define ISP3X_DEBAYER_G_INTERP_FILTER2		(ISP3X_DEBAYER_BASE + 0x0000c)
#define ISP3X_DEBAYER_OFFSET			(ISP3X_DEBAYER_BASE + 0x00010)
#define ISP3X_DEBAYER_C_FILTER			(ISP3X_DEBAYER_BASE + 0x00014)
#define ISP32_DEBAYER_G_INTERP_OFFSET		(ISP3X_DEBAYER_BASE + 0x00010)
#define ISP32_DEBAYER_G_FILTER_OFFSET		(ISP3X_DEBAYER_BASE + 0x00014)
#define ISP32_DEBAYER_C_FILTER_GUIDE_GAUS	(ISP3X_DEBAYER_BASE + 0x00018)
#define ISP32_DEBAYER_C_FILTER_CE_GAUS		(ISP3X_DEBAYER_BASE + 0x0001c)
#define ISP32_DEBAYER_C_FILTER_ALPHA_GAUS	(ISP3X_DEBAYER_BASE + 0x00020)
#define ISP32_DEBAYER_C_FILTER_LOG_OFFSET	(ISP3X_DEBAYER_BASE + 0x00024)
#define ISP32_DEBAYER_C_FILTER_ALPHA		(ISP3X_DEBAYER_BASE + 0x00028)
#define ISP32_DEBAYER_C_FILTER_EDGE		(ISP3X_DEBAYER_BASE + 0x0002c)
#define ISP32_DEBAYER_C_FILTER_IIR_0		(ISP3X_DEBAYER_BASE + 0x00030)
#define ISP32_DEBAYER_C_FILTER_IIR_1		(ISP3X_DEBAYER_BASE + 0x00034)
#define ISP32_DEBAYER_C_FILTER_BF		(ISP3X_DEBAYER_BASE + 0x00038)

#define ISP3X_CAC_BASE				0x00002600
#define ISP3X_CAC_CTRL				(ISP3X_CAC_BASE + 0x00000)
#define ISP3X_CAC_PSF_PARA			(ISP3X_CAC_BASE + 0x00004)
#define ISP3X_CAC_STRENGTH_CENTER		(ISP3X_CAC_BASE + 0x00008)
#define ISP3X_CAC_STRENGTH0			(ISP3X_CAC_BASE + 0x0000C)
#define ISP3X_CAC_STRENGTH1			(ISP3X_CAC_BASE + 0x00010)
#define ISP3X_CAC_STRENGTH2			(ISP3X_CAC_BASE + 0x00014)
#define ISP3X_CAC_STRENGTH3			(ISP3X_CAC_BASE + 0x00018)
#define ISP3X_CAC_STRENGTH4			(ISP3X_CAC_BASE + 0x0001C)
#define ISP3X_CAC_STRENGTH5			(ISP3X_CAC_BASE + 0x00020)
#define ISP3X_CAC_STRENGTH6			(ISP3X_CAC_BASE + 0x00024)
#define ISP3X_CAC_STRENGTH7			(ISP3X_CAC_BASE + 0x00028)
#define ISP3X_CAC_STRENGTH8			(ISP3X_CAC_BASE + 0x0002C)
#define ISP3X_CAC_STRENGTH9			(ISP3X_CAC_BASE + 0x00030)
#define ISP3X_CAC_STRENGTH10			(ISP3X_CAC_BASE + 0x00034)
#define ISP32_CAC_FLAT_THED			(ISP3X_CAC_BASE + 0x00038)
#define ISP32_CAC_OFFSET			(ISP3X_CAC_BASE + 0x0003c)
#define ISP3X_CAC_PSF_CFG0			(ISP3X_CAC_BASE + 0x00040)
#define ISP3X_CAC_PSF_CFG1			(ISP3X_CAC_BASE + 0x00044)
#define ISP3X_CAC_PSF_CFG2			(ISP3X_CAC_BASE + 0x00048)
#define ISP3X_CAC_PSF_CFG3			(ISP3X_CAC_BASE + 0x0004C)
#define ISP3X_CAC_PSF_CFG4			(ISP3X_CAC_BASE + 0x00050)
#define ISP3X_CAC_PSF_CFG5			(ISP3X_CAC_BASE + 0x00054)
#define ISP3X_CAC_PSF_CFG6			(ISP3X_CAC_BASE + 0x00058)
#define ISP3X_CAC_PSF_CFG7			(ISP3X_CAC_BASE + 0x0005C)
#define ISP3X_CAC_PSF_CFG8			(ISP3X_CAC_BASE + 0x00060)
#define ISP3X_CAC_PSF_CFG9			(ISP3X_CAC_BASE + 0x00064)
#define ISP3X_CAC_PSF_CFG10			(ISP3X_CAC_BASE + 0x00068)
#define ISP3X_CAC_PSF_CFG11			(ISP3X_CAC_BASE + 0x0006C)
#define ISP3X_CAC_PSF_CFG12			(ISP3X_CAC_BASE + 0x00070)
#define ISP3X_CAC_PSF_CFG13			(ISP3X_CAC_BASE + 0x00074)
#define ISP3X_CAC_PSF_CFG14			(ISP3X_CAC_BASE + 0x00078)
#define ISP3X_CAC_PSF_CFG15			(ISP3X_CAC_BASE + 0x0007C)
#define ISP3X_CAC_RO_CNT			(ISP3X_CAC_BASE + 0x00080)
#define ISP32_CAC_EXPO_THED_B			(ISP3X_CAC_BASE + 0x00080)
#define ISP32_CAC_EXPO_THED_R			(ISP3X_CAC_BASE + 0x00084)
#define ISP32_CAC_EXPO_ADJ_B			(ISP3X_CAC_BASE + 0x00088)
#define ISP32_CAC_EXPO_ADJ_R			(ISP3X_CAC_BASE + 0x0008c)
#define ISP32_CAC_RO_CNT			(ISP3X_CAC_BASE + 0x000fc)

#define ISP3X_YNR_BASE				0x00002700
#define ISP3X_YNR_GLOBAL_CTRL			(ISP3X_YNR_BASE + 0x00000)
#define ISP3X_YNR_RNR_MAX_R			(ISP3X_YNR_BASE + 0x00004)
#define ISP3X_YNR_RNR_CENTER_COOR		(ISP3X_YNR_BASE + 0x00008)
#define ISP3X_YNR_LOCAL_GAIN_CTRL		(ISP3X_YNR_BASE + 0x0000C)
#define ISP3X_YNR_LOWNR_CTRL0			(ISP3X_YNR_BASE + 0x00010)
#define ISP3X_YNR_LOWNR_CTRL1			(ISP3X_YNR_BASE + 0x00014)
#define ISP3X_YNR_LOWNR_CTRL2			(ISP3X_YNR_BASE + 0x00018)
#define ISP3X_YNR_LOWNR_CTRL3			(ISP3X_YNR_BASE + 0x0001c)
#define ISP3X_YNR_HIGHNR_CTRL0			(ISP3X_YNR_BASE + 0x00020)
#define ISP3X_YNR_HIGHNR_CTRL1			(ISP3X_YNR_BASE + 0x00024)
#define ISP3X_YNR_HIGHNR_BASE_FILTER_WEIGHT	(ISP3X_YNR_BASE + 0x00028)
#define ISP3X_YNR_LOWNR_CTRL4			(ISP3X_YNR_BASE + 0x0002c)
#define ISP3X_YNR_GAUSS1_COEFF			(ISP3X_YNR_BASE + 0x00030)
#define ISP3X_YNR_GAUSS2_COEFF			(ISP3X_YNR_BASE + 0x00034)
#define ISP3X_YNR_DIRECTION_W_0_3		(ISP3X_YNR_BASE + 0x00038)
#define ISP3X_YNR_DIRECTION_W_4_7		(ISP3X_YNR_BASE + 0x0003c)
#define ISP3X_YNR_SGM_DX_0_1			(ISP3X_YNR_BASE + 0x00040)
#define ISP3X_YNR_SGM_DX_2_3			(ISP3X_YNR_BASE + 0x00044)
#define ISP3X_YNR_SGM_DX_4_5			(ISP3X_YNR_BASE + 0x00048)
#define ISP3X_YNR_SGM_DX_6_7			(ISP3X_YNR_BASE + 0x0004c)
#define ISP3X_YNR_SGM_DX_8_9			(ISP3X_YNR_BASE + 0x00050)
#define ISP3X_YNR_SGM_DX_10_11			(ISP3X_YNR_BASE + 0x00055)
#define ISP3X_YNR_SGM_DX_12_13			(ISP3X_YNR_BASE + 0x00058)
#define ISP3X_YNR_SGM_DX_14_15			(ISP3X_YNR_BASE + 0x0005c)
#define ISP3X_YNR_SGM_DX_16			(ISP3X_YNR_BASE + 0x00060)
#define ISP3X_YNR_LSGM_Y_0_1			(ISP3X_YNR_BASE + 0x00070)
#define ISP3X_YNR_LSGM_Y_2_3			(ISP3X_YNR_BASE + 0x00074)
#define ISP3X_YNR_LSGM_Y_4_5			(ISP3X_YNR_BASE + 0x00078)
#define ISP3X_YNR_LSGM_Y_6_7			(ISP3X_YNR_BASE + 0x0007c)
#define ISP3X_YNR_LSGM_Y_8_9			(ISP3X_YNR_BASE + 0x00080)
#define ISP3X_YNR_LSGM_Y_10_11			(ISP3X_YNR_BASE + 0x00084)
#define ISP3X_YNR_LSGM_Y_12_13			(ISP3X_YNR_BASE + 0x00088)
#define ISP3X_YNR_LSGM_Y_14_15			(ISP3X_YNR_BASE + 0x0008c)
#define ISP3X_YNR_LSGM_Y_16			(ISP3X_YNR_BASE + 0x00090)
#define ISP3X_YNR_HSGM_Y_0_1			(ISP3X_YNR_BASE + 0x000a0)
#define ISP3X_YNR_HSGM_Y_2_3			(ISP3X_YNR_BASE + 0x000a4)
#define ISP3X_YNR_HSGM_Y_4_5			(ISP3X_YNR_BASE + 0x000a8)
#define ISP3X_YNR_HSGM_Y_6_7			(ISP3X_YNR_BASE + 0x000ac)
#define ISP3X_YNR_HSGM_Y_8_9			(ISP3X_YNR_BASE + 0x000b0)
#define ISP3X_YNR_HSGM_Y_10_11			(ISP3X_YNR_BASE + 0x000b4)
#define ISP3X_YNR_HSGM_Y_12_13			(ISP3X_YNR_BASE + 0x000b8)
#define ISP3X_YNR_HSGM_Y_14_15			(ISP3X_YNR_BASE + 0x000bc)
#define ISP3X_YNR_HSGM_Y_16			(ISP3X_YNR_BASE + 0x000c0)
#define ISP3X_YNR_RNR_STRENGTH03		(ISP3X_YNR_BASE + 0x000d0)
#define ISP3X_YNR_RNR_STRENGTH47		(ISP3X_YNR_BASE + 0x000d4)
#define ISP3X_YNR_RNR_STRENGTH8B		(ISP3X_YNR_BASE + 0x000d8)
#define ISP3X_YNR_RNR_STRENGTHCF		(ISP3X_YNR_BASE + 0x000dc)
#define ISP3X_YNR_RNR_STRENGTH16		(ISP3X_YNR_BASE + 0x000e0)
#define ISP32_YNR_NLM_SIGMA_GAIN		(ISP3X_YNR_BASE + 0x000f0)
#define ISP32_YNR_NLM_COE			(ISP3X_YNR_BASE + 0x000f4)
#define ISP32_YNR_NLM_WEIGHT			(ISP3X_YNR_BASE + 0x000f8)
#define ISP32_YNR_NLM_NR_WEIGHT			(ISP3X_YNR_BASE + 0x000fc)

#define ISP3X_CNR_BASE				0x00002800
#define ISP3X_CNR_CTRL				(ISP3X_CNR_BASE + 0x00000)
#define ISP3X_CNR_EXGAIN			(ISP3X_CNR_BASE + 0x00004)
#define ISP3X_CNR_GAIN_PARA			(ISP3X_CNR_BASE + 0x00008)
#define ISP32_CNR_THUMB1			(ISP3X_CNR_BASE + 0x00008)
#define ISP3X_CNR_GAIN_UV_PARA			(ISP3X_CNR_BASE + 0x0000c)
#define ISP32_CNR_THUMB_BF_RATIO		(ISP3X_CNR_BASE + 0x0000c)
#define ISP3X_CNR_LMED3				(ISP3X_CNR_BASE + 0x00010)
#define ISP32_CNR_LBF_WEITD			(ISP3X_CNR_BASE + 0x00010)
#define ISP3X_CNR_LBF5_GAIN			(ISP3X_CNR_BASE + 0x00014)
#define ISP32_CNR_IIR_PARA1			(ISP3X_CNR_BASE + 0x00014)
#define ISP3X_CNR_LBF5_WEITD0_3			(ISP3X_CNR_BASE + 0x00018)
#define ISP32_CNR_IIR_PARA2			(ISP3X_CNR_BASE + 0x00018)
#define ISP3X_CNR_LBF5_WEITD4			(ISP3X_CNR_BASE + 0x0001c)
#define ISP32_CNR_GAUS_COE1			(ISP3X_CNR_BASE + 0x0001c)
#define ISP3X_CNR_HMED3				(ISP3X_CNR_BASE + 0x00020)
#define ISP32_CNR_GAUS_COE2			(ISP3X_CNR_BASE + 0x00020)
#define ISP3X_CNR_HBF5				(ISP3X_CNR_BASE + 0x00024)
#define ISP32_CNR_GAUS_RATIO			(ISP3X_CNR_BASE + 0x00024)
#define ISP3X_CNR_LBF3				(ISP3X_CNR_BASE + 0x00028)
#define ISP32_CNR_BF_PARA1			(ISP3X_CNR_BASE + 0x00028)
#define ISP32_CNR_BF_PARA2			(ISP3X_CNR_BASE + 0x0002C)
#define ISP3X_CNR_SIGMA0			(ISP3X_CNR_BASE + 0x0002C)
#define ISP3X_CNR_SIGMA1			(ISP3X_CNR_BASE + 0x00030)
#define ISP3X_CNR_SIGMA2			(ISP3X_CNR_BASE + 0x00034)
#define ISP3X_CNR_SIGMA3			(ISP3X_CNR_BASE + 0x00038)
#define ISP32_CNR_SIGMA0			(ISP3X_CNR_BASE + 0x00030)
#define ISP32_CNR_SIGMA1			(ISP3X_CNR_BASE + 0x00034)
#define ISP32_CNR_SIGMA2			(ISP3X_CNR_BASE + 0x00038)
#define ISP32_CNR_SIGMA3			(ISP3X_CNR_BASE + 0x0003c)
#define ISP32_CNR_IIR_GLOBAL_GAIN		(ISP3X_CNR_BASE + 0x00040)

#define ISP3X_SHARP_BASE			0x00002900
#define ISP3X_SHARP_EN				(ISP3X_SHARP_BASE + 0x00000)
#define ISP3X_SHARP_RATIO			(ISP3X_SHARP_BASE + 0x00004)
#define ISP3X_SHARP_LUMA_DX			(ISP3X_SHARP_BASE + 0x00008)
#define ISP3X_SHARP_PBF_SIGMA_INV_0		(ISP3X_SHARP_BASE + 0x0000c)
#define ISP3X_SHARP_PBF_SIGMA_INV_1		(ISP3X_SHARP_BASE + 0x00010)
#define ISP3X_SHARP_PBF_SIGMA_INV_2		(ISP3X_SHARP_BASE + 0x00014)
#define ISP3X_SHARP_BF_SIGMA_INV_0		(ISP3X_SHARP_BASE + 0x00018)
#define ISP3X_SHARP_BF_SIGMA_INV_1		(ISP3X_SHARP_BASE + 0x0001c)
#define ISP3X_SHARP_BF_SIGMA_INV_2		(ISP3X_SHARP_BASE + 0x00020)
#define ISP3X_SHARP_SIGMA_SHIFT			(ISP3X_SHARP_BASE + 0x00024)
#define ISP3X_SHARP_EHF_TH_0			(ISP3X_SHARP_BASE + 0x00028)
#define ISP3X_SHARP_EHF_TH_1			(ISP3X_SHARP_BASE + 0x0002c)
#define ISP3X_SHARP_EHF_TH_2			(ISP3X_SHARP_BASE + 0x00030)
#define ISP3X_SHARP_CLIP_HF_0			(ISP3X_SHARP_BASE + 0x00034)
#define ISP3X_SHARP_CLIP_HF_1			(ISP3X_SHARP_BASE + 0x00038)
#define ISP3X_SHARP_CLIP_HF_2			(ISP3X_SHARP_BASE + 0x0003c)
#define ISP3X_SHARP_PBF_COEF			(ISP3X_SHARP_BASE + 0x00040)
#define ISP3X_SHARP_BF_COEF			(ISP3X_SHARP_BASE + 0x00044)
#define ISP3X_SHARP_GAUS_COEF0			(ISP3X_SHARP_BASE + 0x00048)
#define ISP3X_SHARP_GAUS_COEF1			(ISP3X_SHARP_BASE + 0x0004C)
#define ISP32_SHARP_GAIN			(ISP3X_SHARP_BASE + 0x00050)
#define ISP32_SHARP_GAIN_ADJUST0		(ISP3X_SHARP_BASE + 0x00054)
#define ISP32_SHARP_GAIN_ADJUST1		(ISP3X_SHARP_BASE + 0x00058)
#define ISP32_SHARP_GAIN_ADJUST2		(ISP3X_SHARP_BASE + 0x0005c)
#define ISP32_SHARP_GAIN_ADJUST3		(ISP3X_SHARP_BASE + 0x00060)
#define ISP32_SHARP_GAIN_ADJUST4		(ISP3X_SHARP_BASE + 0x00064)
#define ISP32_SHARP_GAIN_ADJUST5		(ISP3X_SHARP_BASE + 0x00068)
#define ISP32_SHARP_GAIN_ADJUST6		(ISP3X_SHARP_BASE + 0x0006c)
#define ISP32_SHARP_CENTER			(ISP3X_SHARP_BASE + 0x00070)
#define ISP32_SHARP_GAIN_DIS_STRENGTH0		(ISP3X_SHARP_BASE + 0x00074)
#define ISP32_SHARP_GAIN_DIS_STRENGTH1		(ISP3X_SHARP_BASE + 0x00078)
#define ISP32_SHARP_GAIN_DIS_STRENGTH2		(ISP3X_SHARP_BASE + 0x0007c)
#define ISP32_SHARP_GAIN_DIS_STRENGTH3		(ISP3X_SHARP_BASE + 0x00080)
#define ISP32_SHARP_GAIN_DIS_STRENGTH4		(ISP3X_SHARP_BASE + 0x00084)
#define ISP32_SHARP_GAIN_DIS_STRENGTH5		(ISP3X_SHARP_BASE + 0x00088)
#define ISP32_SHARP_TEXTURE			(ISP3X_SHARP_BASE + 0x0008c)

#define ISP3X_BAY3D_BASE			0x00002C00
#define ISP3X_BAY3D_CTRL			(ISP3X_BAY3D_BASE + 0x00000)
#define ISP3X_BAY3D_KALRATIO			(ISP3X_BAY3D_BASE + 0x00004)
#define ISP3X_BAY3D_GLBPK2			(ISP3X_BAY3D_BASE + 0x00008)
#define ISP32_BAY3D_CTRL1			(ISP3X_BAY3D_BASE + 0x0000c)
#define ISP3X_BAY3D_WGTLMT			(ISP3X_BAY3D_BASE + 0x00010)
#define ISP3X_BAY3D_SIG0_X0			(ISP3X_BAY3D_BASE + 0x00014)
#define ISP3X_BAY3D_SIG0_X1			(ISP3X_BAY3D_BASE + 0x00018)
#define ISP3X_BAY3D_SIG0_X2			(ISP3X_BAY3D_BASE + 0x0001C)
#define ISP3X_BAY3D_SIG0_X3			(ISP3X_BAY3D_BASE + 0x00020)
#define ISP3X_BAY3D_SIG0_X4			(ISP3X_BAY3D_BASE + 0x00024)
#define ISP3X_BAY3D_SIG0_X5			(ISP3X_BAY3D_BASE + 0x00028)
#define ISP3X_BAY3D_SIG0_X6			(ISP3X_BAY3D_BASE + 0x0002C)
#define ISP3X_BAY3D_SIG0_X7			(ISP3X_BAY3D_BASE + 0x00030)
#define ISP3X_BAY3D_SIG0_Y0			(ISP3X_BAY3D_BASE + 0x00034)
#define ISP3X_BAY3D_SIG0_Y1			(ISP3X_BAY3D_BASE + 0x00038)
#define ISP3X_BAY3D_SIG0_Y2			(ISP3X_BAY3D_BASE + 0x0003C)
#define ISP3X_BAY3D_SIG0_Y3			(ISP3X_BAY3D_BASE + 0x00040)
#define ISP3X_BAY3D_SIG0_Y4			(ISP3X_BAY3D_BASE + 0x00044)
#define ISP3X_BAY3D_SIG0_Y5			(ISP3X_BAY3D_BASE + 0x00048)
#define ISP3X_BAY3D_SIG0_Y6			(ISP3X_BAY3D_BASE + 0x0004C)
#define ISP3X_BAY3D_SIG0_Y7			(ISP3X_BAY3D_BASE + 0x00050)
#define ISP3X_BAY3D_SIG1_X0			(ISP3X_BAY3D_BASE + 0x00054)
#define ISP3X_BAY3D_SIG1_X1			(ISP3X_BAY3D_BASE + 0x00058)
#define ISP3X_BAY3D_SIG1_X2			(ISP3X_BAY3D_BASE + 0x0005C)
#define ISP3X_BAY3D_SIG1_X3			(ISP3X_BAY3D_BASE + 0x00060)
#define ISP3X_BAY3D_SIG1_X4			(ISP3X_BAY3D_BASE + 0x00064)
#define ISP3X_BAY3D_SIG1_X5			(ISP3X_BAY3D_BASE + 0x00068)
#define ISP3X_BAY3D_SIG1_X6			(ISP3X_BAY3D_BASE + 0x0006C)
#define ISP3X_BAY3D_SIG1_X7			(ISP3X_BAY3D_BASE + 0x00070)
#define ISP3X_BAY3D_SIG1_Y0			(ISP3X_BAY3D_BASE + 0x00074)
#define ISP3X_BAY3D_SIG1_Y1			(ISP3X_BAY3D_BASE + 0x00078)
#define ISP3X_BAY3D_SIG1_Y2			(ISP3X_BAY3D_BASE + 0x0007C)
#define ISP3X_BAY3D_SIG1_Y3			(ISP3X_BAY3D_BASE + 0x00080)
#define ISP3X_BAY3D_SIG1_Y4			(ISP3X_BAY3D_BASE + 0x00084)
#define ISP3X_BAY3D_SIG1_Y5			(ISP3X_BAY3D_BASE + 0x00088)
#define ISP3X_BAY3D_SIG1_Y6			(ISP3X_BAY3D_BASE + 0x0008C)
#define ISP3X_BAY3D_SIG1_Y7			(ISP3X_BAY3D_BASE + 0x00090)
#define ISP3X_BAY3D_SIG2_Y0			(ISP3X_BAY3D_BASE + 0x00094)
#define ISP3X_BAY3D_SIG2_Y1			(ISP3X_BAY3D_BASE + 0x00098)
#define ISP3X_BAY3D_SIG2_Y2			(ISP3X_BAY3D_BASE + 0x0009C)
#define ISP3X_BAY3D_SIG2_Y3			(ISP3X_BAY3D_BASE + 0x000A0)
#define ISP3X_BAY3D_SIG2_Y4			(ISP3X_BAY3D_BASE + 0x000A4)
#define ISP3X_BAY3D_SIG2_Y5			(ISP3X_BAY3D_BASE + 0x000A8)
#define ISP3X_BAY3D_SIG2_Y6			(ISP3X_BAY3D_BASE + 0x000AC)
#define ISP3X_BAY3D_SIG2_Y7			(ISP3X_BAY3D_BASE + 0x000B0)
#define ISP3X_BAY3D_LODIF_STAT0			(ISP3X_BAY3D_BASE + 0x000B4)
#define ISP3X_BAY3D_LODIF_STAT1			(ISP3X_BAY3D_BASE + 0x000B8)
#define ISP3X_BAY3D_HIDIF_STAT0			(ISP3X_BAY3D_BASE + 0x000BC)
#define ISP3X_BAY3D_HIDIF_STAT1			(ISP3X_BAY3D_BASE + 0x000C0)
#define ISP3X_BAY3D_MI_ST			(ISP3X_BAY3D_BASE + 0x000C8)
#define ISP3X_BAY3D_RO_CNT			(ISP3X_BAY3D_BASE + 0x000CC)
#define ISP3X_BAY3D_RO_FIFO_CUR			(ISP3X_BAY3D_BASE + 0x000D0)
#define ISP3X_BAY3D_RO_FIFO_IIR			(ISP3X_BAY3D_BASE + 0x000D4)
#define ISP3X_BAY3D_RO_FIFO_DS			(ISP3X_BAY3D_BASE + 0x000D8)
#define ISP3X_BAY3D_RO_FIFO_STATE		(ISP3X_BAY3D_BASE + 0x000DC)
#define ISP3X_BAY3D_IN_IRQ_LINECNT		(ISP3X_BAY3D_BASE + 0x000E0)
#define ISP32_BAY3D_HISIGRAT			(ISP3X_BAY3D_BASE + 0x000E4)
#define ISP32_BAY3D_HISIGOFF			(ISP3X_BAY3D_BASE + 0x000E8)
#define ISP32_BAY3D_LOSIG			(ISP3X_BAY3D_BASE + 0x000EC)
#define ISP32_BAY3D_SIGPK			(ISP3X_BAY3D_BASE + 0x000F0)
#define ISP32_BAY3D_SIGGAUS			(ISP3X_BAY3D_BASE + 0x000F4)
#define ISP32_BAY3D_WRMI			(ISP3X_BAY3D_BASE + 0x000F8)
#define ISP32_BAY3D_RDMI			(ISP3X_BAY3D_BASE + 0x000FC)

#define ISP3X_GIC_BASE				0x00002F00
#define ISP3X_GIC_CONTROL			(ISP3X_GIC_BASE + 0x00000)
#define ISP3X_GIC_DIFF_PARA1			(ISP3X_GIC_BASE + 0x00004)
#define ISP3X_GIC_DIFF_PARA2			(ISP3X_GIC_BASE + 0x00008)
#define ISP3X_GIC_DIFF_PARA3			(ISP3X_GIC_BASE + 0x0000c)
#define ISP3X_GIC_DIFF_PARA4			(ISP3X_GIC_BASE + 0x00010)
#define ISP3X_GIC_NOISE_PARA1			(ISP3X_GIC_BASE + 0x00014)
#define ISP3X_GIC_NOISE_PARA2			(ISP3X_GIC_BASE + 0x00018)
#define ISP3X_GIC_NOISE_PARA3			(ISP3X_GIC_BASE + 0x0001c)
#define ISP3X_GIC_SIGMA_VALUE0			(ISP3X_GIC_BASE + 0x00020)
#define ISP3X_GIC_SIGMA_VALUE1			(ISP3X_GIC_BASE + 0x00024)
#define ISP3X_GIC_SIGMA_VALUE2			(ISP3X_GIC_BASE + 0x00028)
#define ISP3X_GIC_SIGMA_VALUE3			(ISP3X_GIC_BASE + 0x0002c)
#define ISP3X_GIC_SIGMA_VALUE4			(ISP3X_GIC_BASE + 0x00030)
#define ISP3X_GIC_SIGMA_VALUE5			(ISP3X_GIC_BASE + 0x00034)
#define ISP3X_GIC_SIGMA_VALUE6			(ISP3X_GIC_BASE + 0x00038)
#define ISP3X_GIC_SIGMA_VALUE7			(ISP3X_GIC_BASE + 0x0003c)

#define ISP3X_BLS_BASE				0x00003000
#define ISP3X_BLS_CTRL				(ISP3X_BLS_BASE + 0x00000)
#define ISP3X_BLS_SAMPLES			(ISP3X_BLS_BASE + 0x00004)
#define ISP3X_BLS_H1_START			(ISP3X_BLS_BASE + 0x00008)
#define ISP3X_BLS_H1_STOP			(ISP3X_BLS_BASE + 0x0000c)
#define ISP3X_BLS_V1_START			(ISP3X_BLS_BASE + 0x00010)
#define ISP3X_BLS_V1_STOP			(ISP3X_BLS_BASE + 0x00014)
#define ISP3X_BLS_H2_START			(ISP3X_BLS_BASE + 0x00018)
#define ISP3X_BLS_H2_STOP			(ISP3X_BLS_BASE + 0x0001c)
#define ISP3X_BLS_V2_START			(ISP3X_BLS_BASE + 0x00020)
#define ISP3X_BLS_V2_STOP			(ISP3X_BLS_BASE + 0x00024)
#define ISP3X_BLS_A_FIXED			(ISP3X_BLS_BASE + 0x00028)
#define ISP3X_BLS_B_FIXED			(ISP3X_BLS_BASE + 0x0002c)
#define ISP3X_BLS_C_FIXED			(ISP3X_BLS_BASE + 0x00030)
#define ISP3X_BLS_D_FIXED			(ISP3X_BLS_BASE + 0x00034)
#define ISP3X_BLS_A_MEASURED			(ISP3X_BLS_BASE + 0x00038)
#define ISP3X_BLS_B_MEASURED			(ISP3X_BLS_BASE + 0x0003c)
#define ISP3X_BLS_C_MEASURED			(ISP3X_BLS_BASE + 0x00040)
#define ISP3X_BLS_D_MEASURED			(ISP3X_BLS_BASE + 0x00044)
#define ISP3X_BLS1_A_FIXED			(ISP3X_BLS_BASE + 0x00048)
#define ISP3X_BLS1_B_FIXED			(ISP3X_BLS_BASE + 0x0004c)
#define ISP3X_BLS1_C_FIXED			(ISP3X_BLS_BASE + 0x00050)
#define ISP3X_BLS1_D_FIXED			(ISP3X_BLS_BASE + 0x00054)
#define ISP32_BLS2_A_FIXED			(ISP3X_BLS_BASE + 0x00058)
#define ISP32_BLS2_B_FIXED			(ISP3X_BLS_BASE + 0x0005c)
#define ISP32_BLS2_C_FIXED			(ISP3X_BLS_BASE + 0x00060)
#define ISP32_BLS2_D_FIXED			(ISP3X_BLS_BASE + 0x00064)
#define ISP32_BLS_ISP_OB_OFFSET			(ISP3X_BLS_BASE + 0x00068)
#define ISP32_BLS_ISP_OB_PREDGAIN		(ISP3X_BLS_BASE + 0x0006c)
#define ISP32_BLS_ISP_OB_MAX			(ISP3X_BLS_BASE + 0x00070)

#define ISP32_EXPD_BASE				0x00003200
#define ISP32_EXPD_CTRL				(ISP32_EXPD_BASE + 0x00000)
#define ISP32_EXPD_X00_01			(ISP32_EXPD_BASE + 0x00004)
#define ISP32_EXPD_X02_03			(ISP32_EXPD_BASE + 0x00008)
#define ISP32_EXPD_X04_05			(ISP32_EXPD_BASE + 0x0000C)
#define ISP32_EXPD_X06_07			(ISP32_EXPD_BASE + 0x00010)
#define ISP32_EXPD_X08_09			(ISP32_EXPD_BASE + 0x00014)
#define ISP32_EXPD_X10_11			(ISP32_EXPD_BASE + 0x00018)
#define ISP32_EXPD_X12_13			(ISP32_EXPD_BASE + 0x0001C)
#define ISP32_EXPD_X14_15			(ISP32_EXPD_BASE + 0x00020)
#define ISP32_EXPD_Y00_01			(ISP32_EXPD_BASE + 0x00024)
#define ISP32_EXPD_Y02_03			(ISP32_EXPD_BASE + 0x00028)
#define ISP32_EXPD_Y04_05			(ISP32_EXPD_BASE + 0x0002C)
#define ISP32_EXPD_Y06_07			(ISP32_EXPD_BASE + 0x00030)
#define ISP32_EXPD_Y08_09			(ISP32_EXPD_BASE + 0x00034)
#define ISP32_EXPD_Y10_11			(ISP32_EXPD_BASE + 0x00038)
#define ISP32_EXPD_Y12_13			(ISP32_EXPD_BASE + 0x0003C)
#define ISP32_EXPD_Y14_15			(ISP32_EXPD_BASE + 0x00040)
#define ISP32_EXPD_Y16				(ISP32_EXPD_BASE + 0x00044)
#define ISP32_EXPD_K0				(ISP32_EXPD_BASE + 0x00048)
#define ISP32_EXPD_K1				(ISP32_EXPD_BASE + 0x0004c)
#define ISP32_EXPD_K2				(ISP32_EXPD_BASE + 0x00050)
#define ISP32_EXPD_K3				(ISP32_EXPD_BASE + 0x00054)
#define ISP32_EXPD_K4				(ISP32_EXPD_BASE + 0x00058)
#define ISP32_EXPD_K5				(ISP32_EXPD_BASE + 0x0005C)
#define ISP32_EXPD_K6				(ISP32_EXPD_BASE + 0x00060)
#define ISP32_EXPD_K7				(ISP32_EXPD_BASE + 0x00064)
#define ISP32_EXPD_K8				(ISP32_EXPD_BASE + 0x00068)
#define ISP32_EXPD_K9				(ISP32_EXPD_BASE + 0x0006C)
#define ISP32_EXPD_K10				(ISP32_EXPD_BASE + 0x00070)
#define ISP32_EXPD_K11				(ISP32_EXPD_BASE + 0x00074)
#define ISP32_EXPD_K12				(ISP32_EXPD_BASE + 0x00078)
#define ISP32_EXPD_K13				(ISP32_EXPD_BASE + 0x0007C)
#define ISP32_EXPD_K14				(ISP32_EXPD_BASE + 0x00080)
#define ISP32_EXPD_K15				(ISP32_EXPD_BASE + 0x00084)

#define ISP32_VSM_BASE				0x00003380
#define ISP32_VSM_MODE				(ISP32_VSM_BASE + 0x00000)
#define ISP32_VSM_H_OFFS			(ISP32_VSM_BASE + 0x00004)
#define ISP32_VSM_V_OFFS			(ISP32_VSM_BASE + 0x00008)
#define ISP32_VSM_H_SIZE			(ISP32_VSM_BASE + 0x0000C)
#define ISP32_VSM_V_SIZE			(ISP32_VSM_BASE + 0x00010)
#define ISP32_VSM_H_SEGMENTS			(ISP32_VSM_BASE + 0x00014)
#define ISP32_VSM_V_SEGMENTS			(ISP32_VSM_BASE + 0x00018)
#define ISP32_VSM_DELTA_H			(ISP32_VSM_BASE + 0x0001C)
#define ISP32_VSM_DELTA_V			(ISP32_VSM_BASE + 0x00020)

#define ISP3X_DPCC0_BASE			0x00003400
#define ISP3X_DPCC1_BASE			0x00003500
#define ISP3X_DPCC2_BASE			0x00003600
#define ISP3X_DPCC0_MODE			(ISP3X_DPCC0_BASE + 0x00000)
#define ISP3X_DPCC0_OUTPUT_MODE			(ISP3X_DPCC0_BASE + 0x00004)
#define ISP3X_DPCC0_SET_USE			(ISP3X_DPCC0_BASE + 0x00008)
#define ISP3X_DPCC0_METHODS_SET_1		(ISP3X_DPCC0_BASE + 0x0000c)
#define ISP3X_DPCC0_METHODS_SET_2		(ISP3X_DPCC0_BASE + 0x00010)
#define ISP3X_DPCC0_METHODS_SET_3		(ISP3X_DPCC0_BASE + 0x00014)
#define ISP3X_DPCC0_LINE_THRESH_1		(ISP3X_DPCC0_BASE + 0x00018)
#define ISP3X_DPCC0_LINE_MAD_FAC_1		(ISP3X_DPCC0_BASE + 0x0001c)
#define ISP3X_DPCC0_PG_FAC_1			(ISP3X_DPCC0_BASE + 0x00020)
#define ISP3X_DPCC0_RND_THRESH_1		(ISP3X_DPCC0_BASE + 0x00024)
#define ISP3X_DPCC0_RG_FAC_1			(ISP3X_DPCC0_BASE + 0x00028)
#define ISP3X_DPCC0_LINE_THRESH_2		(ISP3X_DPCC0_BASE + 0x0002c)
#define ISP3X_DPCC0_LINE_MAD_FAC_2		(ISP3X_DPCC0_BASE + 0x00030)
#define ISP3X_DPCC0_PG_FAC_2			(ISP3X_DPCC0_BASE + 0x00034)
#define ISP3X_DPCC0_RND_THRESH_2		(ISP3X_DPCC0_BASE + 0x00038)
#define ISP3X_DPCC0_RG_FAC_2			(ISP3X_DPCC0_BASE + 0x0003c)
#define ISP3X_DPCC0_LINE_THRESH_3		(ISP3X_DPCC0_BASE + 0x00040)
#define ISP3X_DPCC0_LINE_MAD_FAC_3		(ISP3X_DPCC0_BASE + 0x00044)
#define ISP3X_DPCC0_PG_FAC_3			(ISP3X_DPCC0_BASE + 0x00048)
#define ISP3X_DPCC0_RND_THRESH_3		(ISP3X_DPCC0_BASE + 0x0004c)
#define ISP3X_DPCC0_RG_FAC_3			(ISP3X_DPCC0_BASE + 0x00050)
#define ISP3X_DPCC0_RO_LIMITS			(ISP3X_DPCC0_BASE + 0x00054)
#define ISP3X_DPCC0_RND_OFFS			(ISP3X_DPCC0_BASE + 0x00058)
#define ISP3X_DPCC0_BPT_CTRL			(ISP3X_DPCC0_BASE + 0x0005c)
#define ISP3X_DPCC0_BPT_NUMBER			(ISP3X_DPCC0_BASE + 0x00060)
#define ISP3X_DPCC0_BPT_ADDR			(ISP3X_DPCC0_BASE + 0x00064)
#define ISP3X_DPCC0_BPT_DATA			(ISP3X_DPCC0_BASE + 0x00068)
#define ISP3X_DPCC0_BP_CNT			(ISP3X_DPCC0_BASE + 0x0006c)
#define ISP3X_DPCC0_PDAF_EN			(ISP3X_DPCC0_BASE + 0x00070)
#define ISP3X_DPCC0_PDAF_POINT_EN		(ISP3X_DPCC0_BASE + 0x00074)
#define ISP3X_DPCC0_PDAF_OFFSET			(ISP3X_DPCC0_BASE + 0x00078)
#define ISP3X_DPCC0_PDAF_WRAP			(ISP3X_DPCC0_BASE + 0x0007c)
#define ISP3X_DPCC0_PDAF_SCOPE			(ISP3X_DPCC0_BASE + 0x00080)
#define ISP3X_DPCC0_PDAF_POINT_0		(ISP3X_DPCC0_BASE + 0x00084)
#define ISP3X_DPCC0_PDAF_POINT_1		(ISP3X_DPCC0_BASE + 0x00088)
#define ISP3X_DPCC0_PDAF_POINT_2		(ISP3X_DPCC0_BASE + 0x0008c)
#define ISP3X_DPCC0_PDAF_POINT_3		(ISP3X_DPCC0_BASE + 0x00090)
#define ISP3X_DPCC0_PDAF_POINT_4		(ISP3X_DPCC0_BASE + 0x00094)
#define ISP3X_DPCC0_PDAF_POINT_5		(ISP3X_DPCC0_BASE + 0x00098)
#define ISP3X_DPCC0_PDAF_POINT_6		(ISP3X_DPCC0_BASE + 0x0009c)
#define ISP3X_DPCC0_PDAF_POINT_7		(ISP3X_DPCC0_BASE + 0x000a0)
#define ISP3X_DPCC0_PDAF_FORWARD_MED		(ISP3X_DPCC0_BASE + 0x000a4)

#define ISP3X_DPCC1_MODE			(ISP3X_DPCC1_BASE + 0x00000)
#define ISP3X_DPCC1_OUTPUT_MODE			(ISP3X_DPCC1_BASE + 0x00004)
#define ISP3X_DPCC1_SET_USE			(ISP3X_DPCC1_BASE + 0x00008)
#define ISP3X_DPCC1_METHODS_SET_1		(ISP3X_DPCC1_BASE + 0x0000c)
#define ISP3X_DPCC1_METHODS_SET_2		(ISP3X_DPCC1_BASE + 0x00010)
#define ISP3X_DPCC1_METHODS_SET_3		(ISP3X_DPCC1_BASE + 0x00014)
#define ISP3X_DPCC1_LINE_THRESH_1		(ISP3X_DPCC1_BASE + 0x00018)
#define ISP3X_DPCC1_LINE_MAD_FAC_1		(ISP3X_DPCC1_BASE + 0x0001c)
#define ISP3X_DPCC1_PG_FAC_1			(ISP3X_DPCC1_BASE + 0x00020)
#define ISP3X_DPCC1_RND_THRESH_1		(ISP3X_DPCC1_BASE + 0x00024)
#define ISP3X_DPCC1_RG_FAC_1			(ISP3X_DPCC1_BASE + 0x00028)
#define ISP3X_DPCC1_LINE_THRESH_2		(ISP3X_DPCC1_BASE + 0x0002c)
#define ISP3X_DPCC1_LINE_MAD_FAC_2		(ISP3X_DPCC1_BASE + 0x00030)
#define ISP3X_DPCC1_PG_FAC_2			(ISP3X_DPCC1_BASE + 0x00034)
#define ISP3X_DPCC1_RND_THRESH_2		(ISP3X_DPCC1_BASE + 0x00038)
#define ISP3X_DPCC1_RG_FAC_2			(ISP3X_DPCC1_BASE + 0x0003c)
#define ISP3X_DPCC1_LINE_THRESH_3		(ISP3X_DPCC1_BASE + 0x00040)
#define ISP3X_DPCC1_LINE_MAD_FAC_3		(ISP3X_DPCC1_BASE + 0x00044)
#define ISP3X_DPCC1_PG_FAC_3			(ISP3X_DPCC1_BASE + 0x00048)
#define ISP3X_DPCC1_RND_THRESH_3		(ISP3X_DPCC1_BASE + 0x0004c)
#define ISP3X_DPCC1_RG_FAC_3			(ISP3X_DPCC1_BASE + 0x00050)
#define ISP3X_DPCC1_RO_LIMITS			(ISP3X_DPCC1_BASE + 0x00054)
#define ISP3X_DPCC1_RND_OFFS			(ISP3X_DPCC1_BASE + 0x00058)
#define ISP3X_DPCC1_BPT_CTRL			(ISP3X_DPCC1_BASE + 0x0005c)
#define ISP3X_DPCC1_BPT_NUMBER			(ISP3X_DPCC1_BASE + 0x00060)
#define ISP3X_DPCC1_BPT_ADDR			(ISP3X_DPCC1_BASE + 0x00064)
#define ISP3X_DPCC1_BPT_DATA			(ISP3X_DPCC1_BASE + 0x00068)
#define ISP3X_DPCC1_BP_CNT			(ISP3X_DPCC1_BASE + 0x0006c)
#define ISP3X_DPCC1_PDAF_EN			(ISP3X_DPCC1_BASE + 0x00070)
#define ISP3X_DPCC1_PDAF_POINT_EN		(ISP3X_DPCC1_BASE + 0x00074)
#define ISP3X_DPCC1_PDAF_OFFSET			(ISP3X_DPCC1_BASE + 0x00078)
#define ISP3X_DPCC1_PDAF_WRAP			(ISP3X_DPCC1_BASE + 0x0007c)
#define ISP3X_DPCC1_PDAF_SCOPE			(ISP3X_DPCC1_BASE + 0x00080)
#define ISP3X_DPCC1_PDAF_POINT_0		(ISP3X_DPCC1_BASE + 0x00084)
#define ISP3X_DPCC1_PDAF_POINT_1		(ISP3X_DPCC1_BASE + 0x00088)
#define ISP3X_DPCC1_PDAF_POINT_2		(ISP3X_DPCC1_BASE + 0x0008c)
#define ISP3X_DPCC1_PDAF_POINT_3		(ISP3X_DPCC1_BASE + 0x00090)
#define ISP3X_DPCC1_PDAF_POINT_4		(ISP3X_DPCC1_BASE + 0x00094)
#define ISP3X_DPCC1_PDAF_POINT_5		(ISP3X_DPCC1_BASE + 0x00098)
#define ISP3X_DPCC1_PDAF_POINT_6		(ISP3X_DPCC1_BASE + 0x0009c)
#define ISP3X_DPCC1_PDAF_POINT_7		(ISP3X_DPCC1_BASE + 0x000a0)
#define ISP3X_DPCC1_PDAF_FORWARD_MED		(ISP3X_DPCC1_BASE + 0x000a4)

#define ISP3X_DPCC2_MODE			(ISP3X_DPCC2_BASE + 0x00000)
#define ISP3X_DPCC2_OUTPUT_MODE			(ISP3X_DPCC2_BASE + 0x00004)
#define ISP3X_DPCC2_SET_USE			(ISP3X_DPCC2_BASE + 0x00008)
#define ISP3X_DPCC2_METHODS_SET_1		(ISP3X_DPCC2_BASE + 0x0000c)
#define ISP3X_DPCC2_METHODS_SET_2		(ISP3X_DPCC2_BASE + 0x00010)
#define ISP3X_DPCC2_METHODS_SET_3		(ISP3X_DPCC2_BASE + 0x00014)
#define ISP3X_DPCC2_LINE_THRESH_1		(ISP3X_DPCC2_BASE + 0x00018)
#define ISP3X_DPCC2_LINE_MAD_FAC_1		(ISP3X_DPCC2_BASE + 0x0001c)
#define ISP3X_DPCC2_PG_FAC_1			(ISP3X_DPCC2_BASE + 0x00020)
#define ISP3X_DPCC2_RND_THRESH_1		(ISP3X_DPCC2_BASE + 0x00024)
#define ISP3X_DPCC2_RG_FAC_1			(ISP3X_DPCC2_BASE + 0x00028)
#define ISP3X_DPCC2_LINE_THRESH_2		(ISP3X_DPCC2_BASE + 0x0002c)
#define ISP3X_DPCC2_LINE_MAD_FAC_2		(ISP3X_DPCC2_BASE + 0x00030)
#define ISP3X_DPCC2_PG_FAC_2			(ISP3X_DPCC2_BASE + 0x00034)
#define ISP3X_DPCC2_RND_THRESH_2		(ISP3X_DPCC2_BASE + 0x00038)
#define ISP3X_DPCC2_RG_FAC_2			(ISP3X_DPCC2_BASE + 0x0003c)
#define ISP3X_DPCC2_LINE_THRESH_3		(ISP3X_DPCC2_BASE + 0x00040)
#define ISP3X_DPCC2_LINE_MAD_FAC_3		(ISP3X_DPCC2_BASE + 0x00044)
#define ISP3X_DPCC2_PG_FAC_3			(ISP3X_DPCC2_BASE + 0x00048)
#define ISP3X_DPCC2_RND_THRESH_3		(ISP3X_DPCC2_BASE + 0x0004c)
#define ISP3X_DPCC2_RG_FAC_3			(ISP3X_DPCC2_BASE + 0x00050)
#define ISP3X_DPCC2_RO_LIMITS			(ISP3X_DPCC2_BASE + 0x00054)
#define ISP3X_DPCC2_RND_OFFS			(ISP3X_DPCC2_BASE + 0x00058)
#define ISP3X_DPCC2_BPT_CTRL			(ISP3X_DPCC2_BASE + 0x0005c)
#define ISP3X_DPCC2_BPT_NUMBER			(ISP3X_DPCC2_BASE + 0x00060)
#define ISP3X_DPCC2_BPT_ADDR			(ISP3X_DPCC2_BASE + 0x00064)
#define ISP3X_DPCC2_BPT_DATA			(ISP3X_DPCC2_BASE + 0x00068)
#define ISP3X_DPCC2_BP_CNT			(ISP3X_DPCC2_BASE + 0x0006c)
#define ISP3X_DPCC2_PDAF_EN			(ISP3X_DPCC2_BASE + 0x00070)
#define ISP3X_DPCC2_PDAF_POINT_EN		(ISP3X_DPCC2_BASE + 0x00074)
#define ISP3X_DPCC2_PDAF_OFFSET			(ISP3X_DPCC2_BASE + 0x00078)
#define ISP3X_DPCC2_PDAF_WRAP			(ISP3X_DPCC2_BASE + 0x0007c)
#define ISP3X_DPCC2_PDAF_SCOPE			(ISP3X_DPCC2_BASE + 0x00080)
#define ISP3X_DPCC2_PDAF_POINT_0		(ISP3X_DPCC2_BASE + 0x00084)
#define ISP3X_DPCC2_PDAF_POINT_1		(ISP3X_DPCC2_BASE + 0x00088)
#define ISP3X_DPCC2_PDAF_POINT_2		(ISP3X_DPCC2_BASE + 0x0008c)
#define ISP3X_DPCC2_PDAF_POINT_3		(ISP3X_DPCC2_BASE + 0x00090)
#define ISP3X_DPCC2_PDAF_POINT_4		(ISP3X_DPCC2_BASE + 0x00094)
#define ISP3X_DPCC2_PDAF_POINT_5		(ISP3X_DPCC2_BASE + 0x00098)
#define ISP3X_DPCC2_PDAF_POINT_6		(ISP3X_DPCC2_BASE + 0x0009c)
#define ISP3X_DPCC2_PDAF_POINT_7		(ISP3X_DPCC2_BASE + 0x000a0)
#define ISP3X_DPCC2_PDAF_FORWARD_MED		(ISP3X_DPCC2_BASE + 0x000a4)

#define ISP3X_HDRMGE_BASE			0x00003800
#define ISP3X_HDRMGE_CTRL			(ISP3X_HDRMGE_BASE + 0x00000)
#define ISP3X_HDRMGE_GAIN0			(ISP3X_HDRMGE_BASE + 0x00008)
#define ISP3X_HDRMGE_GAIN1			(ISP3X_HDRMGE_BASE + 0x0000c)
#define ISP3X_HDRMGE_GAIN2			(ISP3X_HDRMGE_BASE + 0x00010)
#define ISP3X_HDRMGE_LIGHTZ			(ISP3X_HDRMGE_BASE + 0x00014)
#define ISP3X_HDRMGE_MS_DIFF			(ISP3X_HDRMGE_BASE + 0x00018)
#define ISP3X_HDRMGE_LM_DIFF			(ISP3X_HDRMGE_BASE + 0x0001C)
#define ISP3X_HDRMGE_DIFF_Y0			(ISP3X_HDRMGE_BASE + 0x00020)
#define ISP3X_HDRMGE_DIFF_Y1			(ISP3X_HDRMGE_BASE + 0x00024)
#define ISP3X_HDRMGE_DIFF_Y2			(ISP3X_HDRMGE_BASE + 0x00028)
#define ISP3X_HDRMGE_DIFF_Y3			(ISP3X_HDRMGE_BASE + 0x0002c)
#define ISP3X_HDRMGE_DIFF_Y4			(ISP3X_HDRMGE_BASE + 0x00030)
#define ISP3X_HDRMGE_DIFF_Y5			(ISP3X_HDRMGE_BASE + 0x00034)
#define ISP3X_HDRMGE_DIFF_Y6			(ISP3X_HDRMGE_BASE + 0x00038)
#define ISP3X_HDRMGE_DIFF_Y7			(ISP3X_HDRMGE_BASE + 0x0003c)
#define ISP3X_HDRMGE_DIFF_Y8			(ISP3X_HDRMGE_BASE + 0x00040)
#define ISP3X_HDRMGE_DIFF_Y9			(ISP3X_HDRMGE_BASE + 0x00044)
#define ISP3X_HDRMGE_DIFF_Y10			(ISP3X_HDRMGE_BASE + 0x00048)
#define ISP3X_HDRMGE_DIFF_Y11			(ISP3X_HDRMGE_BASE + 0x0004c)
#define ISP3X_HDRMGE_DIFF_Y12			(ISP3X_HDRMGE_BASE + 0x00050)
#define ISP3X_HDRMGE_DIFF_Y13			(ISP3X_HDRMGE_BASE + 0x00054)
#define ISP3X_HDRMGE_DIFF_Y14			(ISP3X_HDRMGE_BASE + 0x00058)
#define ISP3X_HDRMGE_DIFF_Y15			(ISP3X_HDRMGE_BASE + 0x0005c)
#define ISP3X_HDRMGE_DIFF_Y16			(ISP3X_HDRMGE_BASE + 0x00060)
#define ISP3X_HDRMGE_OVER_Y0			(ISP3X_HDRMGE_BASE + 0x00070)
#define ISP3X_HDRMGE_OVER_Y1			(ISP3X_HDRMGE_BASE + 0x00074)
#define ISP3X_HDRMGE_OVER_Y2			(ISP3X_HDRMGE_BASE + 0x00078)
#define ISP3X_HDRMGE_OVER_Y3			(ISP3X_HDRMGE_BASE + 0x0007c)
#define ISP3X_HDRMGE_OVER_Y4			(ISP3X_HDRMGE_BASE + 0x00080)
#define ISP3X_HDRMGE_OVER_Y5			(ISP3X_HDRMGE_BASE + 0x00084)
#define ISP3X_HDRMGE_OVER_Y6			(ISP3X_HDRMGE_BASE + 0x00088)
#define ISP3X_HDRMGE_OVER_Y7			(ISP3X_HDRMGE_BASE + 0x0008c)
#define ISP3X_HDRMGE_OVER_Y8			(ISP3X_HDRMGE_BASE + 0x00090)
#define ISP3X_HDRMGE_OVER_Y9			(ISP3X_HDRMGE_BASE + 0x00094)
#define ISP3X_HDRMGE_OVER_Y10			(ISP3X_HDRMGE_BASE + 0x00098)
#define ISP3X_HDRMGE_OVER_Y11			(ISP3X_HDRMGE_BASE + 0x0009c)
#define ISP3X_HDRMGE_OVER_Y12			(ISP3X_HDRMGE_BASE + 0x000a0)
#define ISP3X_HDRMGE_OVER_Y13			(ISP3X_HDRMGE_BASE + 0x000a4)
#define ISP3X_HDRMGE_OVER_Y14			(ISP3X_HDRMGE_BASE + 0x000a8)
#define ISP3X_HDRMGE_OVER_Y15			(ISP3X_HDRMGE_BASE + 0x000ac)
#define ISP3X_HDRMGE_OVER_Y16			(ISP3X_HDRMGE_BASE + 0x000b0)
#define ISP32_HDRMGE_EACH_GAIN			(ISP3X_HDRMGE_BASE + 0x000b4)

#define ISP3X_DRC_BASE				0x00003900
#define ISP3X_DRC_CTRL0				(ISP3X_DRC_BASE + 0x00000)
#define ISP3X_DRC_CTRL1				(ISP3X_DRC_BASE + 0x00004)
#define ISP3X_DRC_LPRATIO			(ISP3X_DRC_BASE + 0x00008)
#define ISP3X_DRC_EXPLRATIO			(ISP3X_DRC_BASE + 0x0000c)
#define ISP3X_DRC_SIGMA				(ISP3X_DRC_BASE + 0x00010)
#define ISP3X_DRC_SPACESGM			(ISP3X_DRC_BASE + 0x00014)
#define ISP3X_DRC_RANESGM			(ISP3X_DRC_BASE + 0x00018)
#define ISP3X_DRC_BILAT				(ISP3X_DRC_BASE + 0x0001c)
#define ISP3X_DRC_GAIN_Y0			(ISP3X_DRC_BASE + 0x00020)
#define ISP3X_DRC_GAIN_Y1			(ISP3X_DRC_BASE + 0x00024)
#define ISP3X_DRC_GAIN_Y2			(ISP3X_DRC_BASE + 0x00028)
#define ISP3X_DRC_GAIN_Y3			(ISP3X_DRC_BASE + 0x0002c)
#define ISP3X_DRC_GAIN_Y4			(ISP3X_DRC_BASE + 0x00030)
#define ISP3X_DRC_GAIN_Y5			(ISP3X_DRC_BASE + 0x00034)
#define ISP3X_DRC_GAIN_Y6			(ISP3X_DRC_BASE + 0x00038)
#define ISP3X_DRC_GAIN_Y7			(ISP3X_DRC_BASE + 0x0003c)
#define ISP3X_DRC_GAIN_Y8			(ISP3X_DRC_BASE + 0x00040)
#define ISP3X_DRC_COMPRES_Y0			(ISP3X_DRC_BASE + 0x00044)
#define ISP3X_DRC_COMPRES_Y1			(ISP3X_DRC_BASE + 0x00048)
#define ISP3X_DRC_COMPRES_Y2			(ISP3X_DRC_BASE + 0x0004c)
#define ISP3X_DRC_COMPRES_Y3			(ISP3X_DRC_BASE + 0x00050)
#define ISP3X_DRC_COMPRES_Y4			(ISP3X_DRC_BASE + 0x00054)
#define ISP3X_DRC_COMPRES_Y5			(ISP3X_DRC_BASE + 0x00058)
#define ISP3X_DRC_COMPRES_Y6			(ISP3X_DRC_BASE + 0x0005c)
#define ISP3X_DRC_COMPRES_Y7			(ISP3X_DRC_BASE + 0x00060)
#define ISP3X_DRC_COMPRES_Y8			(ISP3X_DRC_BASE + 0x00064)
#define ISP3X_DRC_SCALE_Y0			(ISP3X_DRC_BASE + 0x00068)
#define ISP3X_DRC_SCALE_Y1			(ISP3X_DRC_BASE + 0x0006c)
#define ISP3X_DRC_SCALE_Y2			(ISP3X_DRC_BASE + 0x00070)
#define ISP3X_DRC_SCALE_Y3			(ISP3X_DRC_BASE + 0x00074)
#define ISP3X_DRC_SCALE_Y4			(ISP3X_DRC_BASE + 0x00078)
#define ISP3X_DRC_SCALE_Y5			(ISP3X_DRC_BASE + 0x0007c)
#define ISP3X_DRC_SCALE_Y6			(ISP3X_DRC_BASE + 0x00080)
#define ISP3X_DRC_SCALE_Y7			(ISP3X_DRC_BASE + 0x00084)
#define ISP3X_DRC_SCALE_Y8			(ISP3X_DRC_BASE + 0x00088)
#define ISP3X_DRC_IIRWG_GAIN			(ISP3X_DRC_BASE + 0x0008c)
#define ISP32_DRC_LUM3X2_CTRL			(ISP3X_DRC_BASE + 0x00090)
#define ISP32_DRC_LUM3X2_GAS			(ISP3X_DRC_BASE + 0x00094)

#define ISP3X_BAYNR_BASE			0x00003A00
#define ISP3X_BAYNR_CTRL			(ISP3X_BAYNR_BASE + 0x00000)
#define ISP3X_BAYNR_DGAIN0			(ISP3X_BAYNR_BASE + 0x00004)
#define ISP3X_BAYNR_DGAIN1			(ISP3X_BAYNR_BASE + 0x00008)
#define ISP3X_BAYNR_PIXDIFF			(ISP3X_BAYNR_BASE + 0x0000c)
#define ISP3X_BAYNR_THLD			(ISP3X_BAYNR_BASE + 0x00010)
#define ISP3X_BAYNR_W1_STRENG			(ISP3X_BAYNR_BASE + 0x00014)
#define ISP3X_BAYNR_SIGMAX01			(ISP3X_BAYNR_BASE + 0x00018)
#define ISP3X_BAYNR_SIGMAX23			(ISP3X_BAYNR_BASE + 0x0001c)
#define ISP3X_BAYNR_SIGMAX45			(ISP3X_BAYNR_BASE + 0x00020)
#define ISP3X_BAYNR_SIGMAX67			(ISP3X_BAYNR_BASE + 0x00024)
#define ISP3X_BAYNR_SIGMAX89			(ISP3X_BAYNR_BASE + 0x00028)
#define ISP3X_BAYNR_SIGMAX1011			(ISP3X_BAYNR_BASE + 0x0002c)
#define ISP3X_BAYNR_SIGMAX1213			(ISP3X_BAYNR_BASE + 0x00030)
#define ISP3X_BAYNR_SIGMAX1415			(ISP3X_BAYNR_BASE + 0x00034)
#define ISP3X_BAYNR_SIGMAY01			(ISP3X_BAYNR_BASE + 0x00038)
#define ISP3X_BAYNR_SIGMAY23			(ISP3X_BAYNR_BASE + 0x0003c)
#define ISP3X_BAYNR_SIGMAY45			(ISP3X_BAYNR_BASE + 0x00040)
#define ISP3X_BAYNR_SIGMAY67			(ISP3X_BAYNR_BASE + 0x00044)
#define ISP3X_BAYNR_SIGMAY89			(ISP3X_BAYNR_BASE + 0x00048)
#define ISP3X_BAYNR_SIGMAY1011			(ISP3X_BAYNR_BASE + 0x0004c)
#define ISP3X_BAYNR_SIGMAY1213			(ISP3X_BAYNR_BASE + 0x00050)
#define ISP3X_BAYNR_SIGMAY1415			(ISP3X_BAYNR_BASE + 0x00054)
#define ISP3X_BAYNR_WRIT_D			(ISP3X_BAYNR_BASE + 0x00058)
#define ISP3X_BAYNR_LG_OFF			(ISP3X_BAYNR_BASE + 0x0005c)
#define ISP3X_BAYNR_DAT_MAX			(ISP3X_BAYNR_BASE + 0x00060)
#define ISP32_BAYNR_SIGOFF			(ISP3X_BAYNR_BASE + 0x00064)
#define ISP32_BAYNR_GAINX03			(ISP3X_BAYNR_BASE + 0x00068)
#define ISP32_BAYNR_GAINX47			(ISP3X_BAYNR_BASE + 0x0006c)
#define ISP32_BAYNR_GAINX811			(ISP3X_BAYNR_BASE + 0x00070)
#define ISP32_BAYNR_GAINX1215			(ISP3X_BAYNR_BASE + 0x00074)
#define ISP32_BAYNR_GAINY01			(ISP3X_BAYNR_BASE + 0x00078)
#define ISP32_BAYNR_GAINX23			(ISP3X_BAYNR_BASE + 0x0007c)
#define ISP32_BAYNR_GAINX45			(ISP3X_BAYNR_BASE + 0x00080)
#define ISP32_BAYNR_GAINX67			(ISP3X_BAYNR_BASE + 0x00084)
#define ISP32_BAYNR_GAINX89			(ISP3X_BAYNR_BASE + 0x00088)
#define ISP32_BAYNR_GAINX1011			(ISP3X_BAYNR_BASE + 0x0008c)
#define ISP32_BAYNR_GAINX1213			(ISP3X_BAYNR_BASE + 0x00090)
#define ISP32_BAYNR_GAINX1415			(ISP3X_BAYNR_BASE + 0x00094)

#define ISP3X_LDCH_BASE				0x00003B00
#define ISP3X_LDCH_STS				(ISP3X_LDCH_BASE + 0x00000)
#define ISP32_LDCH_BIC_TABLE0			(ISP3X_LDCH_BASE + 0x00004)
#define ISP32_LDCH_BIC_TABLE1			(ISP3X_LDCH_BASE + 0x00008)
#define ISP32_LDCH_BIC_TABLE2			(ISP3X_LDCH_BASE + 0x0000c)
#define ISP32_LDCH_BIC_TABLE3			(ISP3X_LDCH_BASE + 0x00010)
#define ISP32_LDCH_BIC_TABLE4			(ISP3X_LDCH_BASE + 0x00014)
#define ISP32_LDCH_BIC_TABLE5			(ISP3X_LDCH_BASE + 0x00018)
#define ISP32_LDCH_BIC_TABLE6			(ISP3X_LDCH_BASE + 0x0001c)
#define ISP32_LDCH_BIC_TABLE7			(ISP3X_LDCH_BASE + 0x00020)
#define ISP32_LDCH_BIC_TABLE8			(ISP3X_LDCH_BASE + 0x00024)

#define ISP3X_DHAZ_BASE				0x00003C00
#define ISP3X_DHAZ_CTRL				(ISP3X_DHAZ_BASE + 0x00000)
#define ISP3X_DHAZ_ADP0				(ISP3X_DHAZ_BASE + 0x00004)
#define ISP3X_DHAZ_ADP1				(ISP3X_DHAZ_BASE + 0x00008)
#define ISP3X_DHAZ_ADP2				(ISP3X_DHAZ_BASE + 0x0000c)
#define ISP3X_DHAZ_ADP_TMAX			(ISP3X_DHAZ_BASE + 0x00010)
#define ISP3X_DHAZ_ADP_HIST0			(ISP3X_DHAZ_BASE + 0x00014)
#define ISP3X_DHAZ_ADP_HIST1			(ISP3X_DHAZ_BASE + 0x00018)
#define ISP3X_DHAZ_ENHANCE			(ISP3X_DHAZ_BASE + 0x0001c)
#define ISP3X_DHAZ_IIR0				(ISP3X_DHAZ_BASE + 0x00020)
#define ISP3X_DHAZ_IIR1				(ISP3X_DHAZ_BASE + 0x00024)
#define ISP3X_DHAZ_SOFT_CFG0			(ISP3X_DHAZ_BASE + 0x00028)
#define ISP3X_DHAZ_SOFT_CFG1			(ISP3X_DHAZ_BASE + 0x0002c)
#define ISP3X_DHAZ_BF_SIGMA			(ISP3X_DHAZ_BASE + 0x00030)
#define ISP3X_DHAZ_BF_WET			(ISP3X_DHAZ_BASE + 0x00034)
#define ISP3X_DHAZ_ENH_CURVE0			(ISP3X_DHAZ_BASE + 0x00038)
#define ISP3X_DHAZ_ENH_CURVE1			(ISP3X_DHAZ_BASE + 0x0003c)
#define ISP3X_DHAZ_ENH_CURVE2			(ISP3X_DHAZ_BASE + 0x00040)
#define ISP3X_DHAZ_ENH_CURVE3			(ISP3X_DHAZ_BASE + 0x00044)
#define ISP3X_DHAZ_ENH_CURVE4			(ISP3X_DHAZ_BASE + 0x00048)
#define ISP3X_DHAZ_ENH_CURVE5			(ISP3X_DHAZ_BASE + 0x0004c)
#define ISP3X_DHAZ_ENH_CURVE6			(ISP3X_DHAZ_BASE + 0x00050)
#define ISP3X_DHAZ_ENH_CURVE7			(ISP3X_DHAZ_BASE + 0x00054)
#define ISP3X_DHAZ_ENH_CURVE8			(ISP3X_DHAZ_BASE + 0x00058)
#define ISP3X_DHAZ_GAUS				(ISP3X_DHAZ_BASE + 0x0005c)
#define ISP3X_DHAZ_GAIN_IDX0			(ISP3X_DHAZ_BASE + 0x00060)
#define ISP3X_DHAZ_GAIN_IDX1			(ISP3X_DHAZ_BASE + 0x00064)
#define ISP3X_DHAZ_GAIN_IDX2			(ISP3X_DHAZ_BASE + 0x00068)
#define ISP3X_DHAZ_GAIN_IDX3			(ISP3X_DHAZ_BASE + 0x0006C)
#define ISP3X_DHAZ_GAIN_LUT0			(ISP3X_DHAZ_BASE + 0x00070)
#define ISP3X_DHAZ_GAIN_LUT1			(ISP3X_DHAZ_BASE + 0x00074)
#define ISP3X_DHAZ_GAIN_LUT2			(ISP3X_DHAZ_BASE + 0x00078)
#define ISP3X_DHAZ_GAIN_LUT3			(ISP3X_DHAZ_BASE + 0x0007C)
#define ISP3X_DHAZ_GAIN_LUT4			(ISP3X_DHAZ_BASE + 0x00080)
#define ISP3X_DHAZ_GAIN_LUT5			(ISP3X_DHAZ_BASE + 0x00084)
#define ISP3X_DHAZ_GAIN_LUT6			(ISP3X_DHAZ_BASE + 0x00088)
#define ISP3X_DHAZ_GAIN_LUT7			(ISP3X_DHAZ_BASE + 0x0008C)
#define ISP3X_DHAZ_GAIN_LUT8			(ISP3X_DHAZ_BASE + 0x00090)
#define ISP3X_DHAZ_SUMH_RD			(ISP3X_DHAZ_BASE + 0x0009C)
#define ISP3X_DHAZ_ADT_WR0			(ISP3X_DHAZ_BASE + 0x000A0)
#define ISP3X_DHAZ_ADT_WR1			(ISP3X_DHAZ_BASE + 0x000A4)
#define ISP3X_DHAZ_HIST_WR0			(ISP3X_DHAZ_BASE + 0x000A8)
#define ISP3X_DHAZ_HIST_WR1			(ISP3X_DHAZ_BASE + 0x000AC)
#define ISP3X_DHAZ_HIST_WR2			(ISP3X_DHAZ_BASE + 0x000B0)
#define ISP3X_DHAZ_HIST_WR3			(ISP3X_DHAZ_BASE + 0x000B4)
#define ISP3X_DHAZ_HIST_WR4			(ISP3X_DHAZ_BASE + 0x000B8)
#define ISP3X_DHAZ_HIST_WR5			(ISP3X_DHAZ_BASE + 0x000BC)
#define ISP3X_DHAZ_HIST_WR6			(ISP3X_DHAZ_BASE + 0x000C0)
#define ISP3X_DHAZ_HIST_WR7			(ISP3X_DHAZ_BASE + 0x000C4)
#define ISP3X_DHAZ_HIST_WR8			(ISP3X_DHAZ_BASE + 0x000C8)
#define ISP3X_DHAZ_HIST_WR9			(ISP3X_DHAZ_BASE + 0x000CC)
#define ISP3X_DHAZ_HIST_WR10			(ISP3X_DHAZ_BASE + 0x000D0)
#define ISP3X_DHAZ_HIST_WR11			(ISP3X_DHAZ_BASE + 0x000D4)
#define ISP3X_DHAZ_HIST_WR12			(ISP3X_DHAZ_BASE + 0x000D8)
#define ISP3X_DHAZ_HIST_WR13			(ISP3X_DHAZ_BASE + 0x000DC)
#define ISP3X_DHAZ_HIST_WR14			(ISP3X_DHAZ_BASE + 0x000E0)
#define ISP3X_DHAZ_HIST_WR15			(ISP3X_DHAZ_BASE + 0x000E4)
#define ISP3X_DHAZ_HIST_WR16			(ISP3X_DHAZ_BASE + 0x000E8)
#define ISP3X_DHAZ_HIST_WR17			(ISP3X_DHAZ_BASE + 0x000EC)
#define ISP3X_DHAZ_HIST_WR18			(ISP3X_DHAZ_BASE + 0x000F0)
#define ISP3X_DHAZ_HIST_WR19			(ISP3X_DHAZ_BASE + 0x000F4)
#define ISP3X_DHAZ_HIST_WR20			(ISP3X_DHAZ_BASE + 0x000F8)
#define ISP3X_DHAZ_HIST_WR21			(ISP3X_DHAZ_BASE + 0x000FC)
#define ISP3X_DHAZ_CTRL_SHD			(ISP3X_DHAZ_BASE + 0x00100)
#define ISP3X_DHAZ_ADP_RD0			(ISP3X_DHAZ_BASE + 0x00104)
#define ISP3X_DHAZ_ADP_RD1			(ISP3X_DHAZ_BASE + 0x00108)
#define ISP3X_DHAZ_HIST_REG0			(ISP3X_DHAZ_BASE + 0x00110)
#define ISP3X_DHAZ_HIST_REG1			(ISP3X_DHAZ_BASE + 0x00114)
#define ISP3X_DHAZ_HIST_REG2			(ISP3X_DHAZ_BASE + 0x00118)
#define ISP3X_DHAZ_HIST_REG3			(ISP3X_DHAZ_BASE + 0x0011C)
#define ISP3X_DHAZ_HIST_REG4			(ISP3X_DHAZ_BASE + 0x00120)
#define ISP3X_DHAZ_HIST_REG5			(ISP3X_DHAZ_BASE + 0x00124)
#define ISP3X_DHAZ_HIST_REG6			(ISP3X_DHAZ_BASE + 0x00128)
#define ISP3X_DHAZ_HIST_REG7			(ISP3X_DHAZ_BASE + 0x0012C)
#define ISP3X_DHAZ_HIST_REG8			(ISP3X_DHAZ_BASE + 0x00130)
#define ISP3X_DHAZ_HIST_REG9			(ISP3X_DHAZ_BASE + 0x00134)
#define ISP3X_DHAZ_HIST_REG10			(ISP3X_DHAZ_BASE + 0x00138)
#define ISP3X_DHAZ_HIST_REG11			(ISP3X_DHAZ_BASE + 0x0013C)
#define ISP3X_DHAZ_HIST_REG12			(ISP3X_DHAZ_BASE + 0x00140)
#define ISP3X_DHAZ_HIST_REG13			(ISP3X_DHAZ_BASE + 0x00144)
#define ISP3X_DHAZ_HIST_REG14			(ISP3X_DHAZ_BASE + 0x00148)
#define ISP3X_DHAZ_HIST_REG15			(ISP3X_DHAZ_BASE + 0x0014C)
#define ISP3X_DHAZ_HIST_REG16			(ISP3X_DHAZ_BASE + 0x00150)
#define ISP3X_DHAZ_HIST_REG17			(ISP3X_DHAZ_BASE + 0x00154)
#define ISP3X_DHAZ_HIST_REG18			(ISP3X_DHAZ_BASE + 0x00158)
#define ISP3X_DHAZ_HIST_REG19			(ISP3X_DHAZ_BASE + 0x0015C)
#define ISP3X_DHAZ_HIST_REG20			(ISP3X_DHAZ_BASE + 0x00160)
#define ISP3X_DHAZ_HIST_REG21			(ISP3X_DHAZ_BASE + 0x00164)
#define ISP3X_DHAZ_HIST_REG22			(ISP3X_DHAZ_BASE + 0x00168)
#define ISP3X_DHAZ_HIST_REG23			(ISP3X_DHAZ_BASE + 0x0016C)
#define ISP3X_DHAZ_HIST_REG24			(ISP3X_DHAZ_BASE + 0x00170)
#define ISP3X_DHAZ_HIST_REG25			(ISP3X_DHAZ_BASE + 0x00174)
#define ISP3X_DHAZ_HIST_REG26			(ISP3X_DHAZ_BASE + 0x00178)
#define ISP3X_DHAZ_HIST_REG27			(ISP3X_DHAZ_BASE + 0x0017C)
#define ISP3X_DHAZ_HIST_REG28			(ISP3X_DHAZ_BASE + 0x00180)
#define ISP3X_DHAZ_HIST_REG29			(ISP3X_DHAZ_BASE + 0x00184)
#define ISP3X_DHAZ_HIST_REG30			(ISP3X_DHAZ_BASE + 0x00188)
#define ISP3X_DHAZ_HIST_REG31			(ISP3X_DHAZ_BASE + 0x0018C)
#define ISP32_DHAZ_ENH_LUMA0			(ISP3X_DHAZ_BASE + 0x00190)
#define ISP32_DHAZ_ENH_LUMA1			(ISP3X_DHAZ_BASE + 0x00194)
#define ISP32_DHAZ_ENH_LUMA2			(ISP3X_DHAZ_BASE + 0x00198)
#define ISP32_DHAZ_ENH_LUMA3			(ISP3X_DHAZ_BASE + 0x0019c)
#define ISP32_DHAZ_ENH_LUMA4			(ISP3X_DHAZ_BASE + 0x001a0)
#define ISP32_DHAZ_ENH_LUMA5			(ISP3X_DHAZ_BASE + 0x001a4)

#define ISP3X_3DLUT_BASE			0x00003E00
#define ISP3X_3DLUT_CTRL			(ISP3X_3DLUT_BASE + 0x00000)
#define ISP3X_3DLUT_UPDATE			(ISP3X_3DLUT_BASE + 0x00004)

#define ISP3X_GAIN_BASE				0x00003F00
#define ISP3X_GAIN_CTRL				(ISP3X_GAIN_BASE + 0x00000)
#define ISP3X_GAIN_G0				(ISP3X_GAIN_BASE + 0x00004)
#define ISP3X_GAIN_G1_G2			(ISP3X_GAIN_BASE + 0x00008)
#define ISP3X_GAIN_FIFO_STATUS			(ISP3X_GAIN_BASE + 0x0000C)

#define ISP3X_RAWAE_LITE_BASE			0x00004500
#define ISP3X_RAWAE_LITE_CTRL			(ISP3X_RAWAE_LITE_BASE + 0x00000)
#define ISP3X_RAWAE_LITE_BLK_SIZ		(ISP3X_RAWAE_LITE_BASE + 0x00004)
#define ISP3X_RAWAE_LITE_OFFSET			(ISP3X_RAWAE_LITE_BASE + 0x00008)
#define ISP3X_RAWAE_LITE_RO_MEAN		(ISP3X_RAWAE_LITE_BASE + 0x00010)
#define ISP3X_RAWAE_LITE_RO_DBG1		(ISP3X_RAWAE_LITE_BASE + 0x00074)
#define ISP3X_RAWAE_LITE_RO_DBG2		(ISP3X_RAWAE_LITE_BASE + 0x00078)

#define ISP3X_RAWAE_BIG1_BASE			0x00004400
#define ISP3X_RAWAE_BIG2_BASE			0x00004600
#define ISP3X_RAWAE_BIG3_BASE			0x00004700
#define ISP3X_RAWAE_BIG_CTRL			0x00000
#define ISP3X_RAWAE_BIG_BLK_SIZE		0x00004
#define ISP3X_RAWAE_BIG_OFFSET			0x00008
#define ISP3X_RAWAE_BIG_RAM_CTRL		0x0000c
#define ISP3X_RAWAE_BIG_WND1_SIZE		0x00010
#define ISP3X_RAWAE_BIG_WND1_OFFSET		0x00014
#define ISP3X_RAWAE_BIG_WND2_SIZE		0x00018
#define ISP3X_RAWAE_BIG_WND2_OFFSET		0x0001c
#define ISP3X_RAWAE_BIG_WND3_SIZE		0x00020
#define ISP3X_RAWAE_BIG_WND3_OFFSET		0x00024
#define ISP3X_RAWAE_BIG_WND4_SIZE		0x00028
#define ISP3X_RAWAE_BIG_WND4_OFFSET		0x0002c
#define ISP3X_RAWAE_BIG_WND1_SUMR		0x00030
#define ISP3X_RAWAE_BIG_WND2_SUMR		0x00034
#define ISP3X_RAWAE_BIG_WND3_SUMR		0x00038
#define ISP3X_RAWAE_BIG_WND4_SUMR		0x0003c
#define ISP3X_RAWAE_BIG_WND1_SUMG		0x00040
#define ISP3X_RAWAE_BIG_WND2_SUMG		0x00044
#define ISP3X_RAWAE_BIG_WND3_SUMG		0x00048
#define ISP3X_RAWAE_BIG_WND4_SUMG		0x0004c
#define ISP3X_RAWAE_BIG_WND1_SUMB		0x00050
#define ISP3X_RAWAE_BIG_WND2_SUMB		0x00054
#define ISP3X_RAWAE_BIG_WND3_SUMB		0x00058
#define ISP3X_RAWAE_BIG_WND4_SUMB		0x0005c
#define ISP3X_RAWAE_BIG_RO_DBG1			0x00060
#define ISP3X_RAWAE_BIG_RO_DBG2			0x00064
#define ISP3X_RAWAE_BIG_RO_DBG3			0x00068
#define ISP3X_RAWAE_BIG_RO_MEAN_BASE_ADDR	0x00080

#define ISP3X_RAWHIST_LITE_BASE			0x00004900
#define ISP3X_RAWHIST_LITE_CTRL			(ISP3X_RAWHIST_LITE_BASE + 0x00000)
#define ISP3X_RAWHIST_LITE_SIZE			(ISP3X_RAWHIST_LITE_BASE + 0x00004)
#define ISP3X_RAWHIST_LITE_OFFS			(ISP3X_RAWHIST_LITE_BASE + 0x00008)
#define ISP3X_RAWHIST_LITE_RAM_CTRL		(ISP3X_RAWHIST_LITE_BASE + 0x0000c)
#define ISP3X_RAWHIST_LITE_RAW2Y_CC		(ISP3X_RAWHIST_LITE_BASE + 0x00010)
#define ISP3X_RAWHIST_LITE_DBG1			(ISP3X_RAWHIST_LITE_BASE + 0x00020)
#define ISP3X_RAWHIST_LITE_DBG2			(ISP3X_RAWHIST_LITE_BASE + 0x00024)
#define ISP3X_RAWHIST_LITE_DBG3			(ISP3X_RAWHIST_LITE_BASE + 0x00028)
#define ISP3X_RAWHIST_LITE_WEIGHT		(ISP3X_RAWHIST_LITE_BASE + 0x00040)
#define ISP3X_RAWHIST_LITE_RO_BASE_BIN		(ISP3X_RAWHIST_LITE_BASE + 0x00080)

#define ISP3X_RAWHIST_BIG1_BASE			0x00004800
#define ISP3X_RAWHIST_BIG2_BASE			0x00004A00
#define ISP3X_RAWHIST_BIG3_BASE			0x00004B00
#define ISP3X_RAWHIST_BIG_CTRL			0x00000
#define ISP3X_RAWHIST_BIG_SIZE			0x00004
#define ISP3X_RAWHIST_BIG_OFFS			0x00008
#define ISP3X_RAWHIST_BIG_HRAM_CTRL		0x0000C
#define ISP3X_RAWHIST_BIG_RAW2Y_CC		0x00010
#define ISP3X_RAWHIST_BIG_WRAM_CTRL		0x00014
#define ISP3X_RAWHIST_BIG_DBG1			0x00020
#define ISP3X_RAWHIST_BIG_DBG2			0x00024
#define ISP3X_RAWHIST_BIG_DBG3			0x00028
#define ISP3X_RAWHIST_BIG_WEIGHT_BASE		0x00040
#define ISP3X_RAWHIST_BIG_RO_BASE_BIN		0x00080

#define ISP3X_RAWAF_BASE			0x00004D00
#define ISP3X_RAWAF_CTRL			(ISP3X_RAWAF_BASE + 0x00000)
#define ISP3X_RAWAF_OFFSET_WINA			(ISP3X_RAWAF_BASE + 0x00004)
#define ISP3X_RAWAF_SIZE_WINA			(ISP3X_RAWAF_BASE + 0x00008)
#define ISP3X_RAWAF_OFFSET_WINB			(ISP3X_RAWAF_BASE + 0x0000c)
#define ISP3X_RAWAF_SIZE_WINB			(ISP3X_RAWAF_BASE + 0x00010)
#define ISP3X_RAWAF_INT_LINE			(ISP3X_RAWAF_BASE + 0x00014)
#define ISP3X_RAWAF_THRES			(ISP3X_RAWAF_BASE + 0x0001c)
#define ISP3X_RAWAF_VAR_SHIFT			(ISP3X_RAWAF_BASE + 0x00020)
#define ISP3X_RAWAF_HVIIR_VAR_SHIFT		(ISP3X_RAWAF_BASE + 0x00024)
#define ISP3X_RAWAF_SUM_B			(ISP3X_RAWAF_BASE + 0x00028)
#define ISP3X_RAWAF_LUM_B			(ISP3X_RAWAF_BASE + 0x00030)
#define ISP3X_RAWAF_GAMMA_Y0			(ISP3X_RAWAF_BASE + 0x00034)
#define ISP3X_RAWAF_GAMMA_Y1			(ISP3X_RAWAF_BASE + 0x00038)
#define ISP3X_RAWAF_GAMMA_Y2			(ISP3X_RAWAF_BASE + 0x0003c)
#define ISP3X_RAWAF_GAMMA_Y3			(ISP3X_RAWAF_BASE + 0x00040)
#define ISP3X_RAWAF_GAMMA_Y4			(ISP3X_RAWAF_BASE + 0x00044)
#define ISP3X_RAWAF_GAMMA_Y5			(ISP3X_RAWAF_BASE + 0x00048)
#define ISP3X_RAWAF_GAMMA_Y6			(ISP3X_RAWAF_BASE + 0x0004c)
#define ISP3X_RAWAF_GAMMA_Y7			(ISP3X_RAWAF_BASE + 0x00050)
#define ISP3X_RAWAF_GAMMA_Y8			(ISP3X_RAWAF_BASE + 0x00054)
#define ISP3X_RAWAF_INT_STATE			(ISP3X_RAWAF_BASE + 0x00058)
#define ISP3X_RAWAF_HIIR_THRESH			(ISP3X_RAWAF_BASE + 0x0005c)
#define ISP3X_RAWAF_H1_IIR1_COE01		(ISP3X_RAWAF_BASE + 0x00060)
#define ISP3X_RAWAF_H1_IIR1_COE23		(ISP3X_RAWAF_BASE + 0x00064)
#define ISP3X_RAWAF_H1_IIR1_COE45		(ISP3X_RAWAF_BASE + 0x00068)
#define ISP3X_RAWAF_H_CURVEL			(ISP3X_RAWAF_BASE + 0x0006C)
#define ISP3X_RAWAF_H1_IIR2_COE01		(ISP3X_RAWAF_BASE + 0x00070)
#define ISP3X_RAWAF_H1_IIR2_COE23		(ISP3X_RAWAF_BASE + 0x00074)
#define ISP3X_RAWAF_H1_IIR2_COE45		(ISP3X_RAWAF_BASE + 0x00078)
#define ISP3X_RAWAF_H_CURVEH			(ISP3X_RAWAF_BASE + 0x0007C)
#define ISP3X_RAWAF_H2_IIR1_COE01		(ISP3X_RAWAF_BASE + 0x00080)
#define ISP3X_RAWAF_H2_IIR1_COE23		(ISP3X_RAWAF_BASE + 0x00084)
#define ISP3X_RAWAF_H2_IIR1_COE45		(ISP3X_RAWAF_BASE + 0x00088)
#define ISP3X_RAWAF_V_CURVEL			(ISP3X_RAWAF_BASE + 0x0008C)
#define ISP3X_RAWAF_H2_IIR2_COE01		(ISP3X_RAWAF_BASE + 0x00090)
#define ISP3X_RAWAF_H2_IIR2_COE23		(ISP3X_RAWAF_BASE + 0x00094)
#define ISP3X_RAWAF_H2_IIR2_COE45		(ISP3X_RAWAF_BASE + 0x00098)
#define ISP3X_RAWAF_V_CURVEH			(ISP3X_RAWAF_BASE + 0x0009C)
#define ISP3X_RAWAF_V_IIR_COE0			(ISP3X_RAWAF_BASE + 0x000A0)
#define ISP3X_RAWAF_V_IIR_COE1			(ISP3X_RAWAF_BASE + 0x000A4)
#define ISP3X_RAWAF_V_IIR_COE2			(ISP3X_RAWAF_BASE + 0x000A8)
#define ISP3X_RAWAF_V_IIR_COE3			(ISP3X_RAWAF_BASE + 0x000AC)
#define ISP3X_RAWAF_V_IIR_COE4			(ISP3X_RAWAF_BASE + 0x000B0)
#define ISP3X_RAWAF_V_IIR_COE5			(ISP3X_RAWAF_BASE + 0x000B4)
#define ISP3X_RAWAF_V_IIR_COE6			(ISP3X_RAWAF_BASE + 0x000B8)
#define ISP3X_RAWAF_V_IIR_COE7			(ISP3X_RAWAF_BASE + 0x000BC)
#define ISP3X_RAWAF_V_IIR_COE8			(ISP3X_RAWAF_BASE + 0x000C0)
#define ISP3X_RAWAF_V_FIR_COE0			(ISP3X_RAWAF_BASE + 0x000C4)
#define ISP3X_RAWAF_V_FIR_COE1			(ISP3X_RAWAF_BASE + 0x000C8)
#define ISP3X_RAWAF_V_FIR_COE2			(ISP3X_RAWAF_BASE + 0x000CC)
#define ISP32_RAWAF_V_FIR_COE0			(ISP3X_RAWAF_BASE + 0x000b0)
#define ISP32_RAWAF_V_FIR_COE1			(ISP3X_RAWAF_BASE + 0x000b4)
#define ISP32_RAWAF_V_FIR_COE2			(ISP3X_RAWAF_BASE + 0x000b8)
#define ISP32_RAWAF_GAUS_COE03			(ISP3X_RAWAF_BASE + 0x000c0)
#define ISP32_RAWAF_GAUS_COE47			(ISP3X_RAWAF_BASE + 0x000c4)
#define ISP32_RAWAF_GAUS_COE8			(ISP3X_RAWAF_BASE + 0x000c8)
#define ISP3X_RAWAF_HIGHLIT_THRESH		(ISP3X_RAWAF_BASE + 0x000D0)
#define ISP3X_RAWAF_HIGHLIT_CNT_WINB		(ISP3X_RAWAF_BASE + 0x000D8)
#define ISP3X_RAWAF_RAM_DATA			(ISP3X_RAWAF_BASE + 0x000E0)

#define ISP3X_RAWAWB_BASE			0x00005000
#define ISP3X_RAWAWB_CTRL			(ISP3X_RAWAWB_BASE + 0x0000)
#define ISP3X_RAWAWB_BLK_CTRL			(ISP3X_RAWAWB_BASE + 0x0004)
#define ISP3X_RAWAWB_WIN_OFFS			(ISP3X_RAWAWB_BASE + 0x0008)
#define ISP3X_RAWAWB_WIN_SIZE			(ISP3X_RAWAWB_BASE + 0x000c)
#define ISP3X_RAWAWB_LIMIT_RG_MAX		(ISP3X_RAWAWB_BASE + 0x0010)
#define ISP3X_RAWAWB_LIMIT_BY_MAX		(ISP3X_RAWAWB_BASE + 0x0014)
#define ISP3X_RAWAWB_LIMIT_RG_MIN		(ISP3X_RAWAWB_BASE + 0x0018)
#define ISP3X_RAWAWB_LIMIT_BY_MIN		(ISP3X_RAWAWB_BASE + 0x001c)
#define ISP3X_RAWAWB_WEIGHT_CURVE_CTRL		(ISP3X_RAWAWB_BASE + 0x0020)
#define ISP3X_RAWAWB_YWEIGHT_CURVE_XCOOR03	(ISP3X_RAWAWB_BASE + 0x0024)
#define ISP3X_RAWAWB_YWEIGHT_CURVE_XCOOR47	(ISP3X_RAWAWB_BASE + 0x0028)
#define ISP3X_RAWAWB_YWEIGHT_CURVE_XCOOR8	(ISP3X_RAWAWB_BASE + 0x002c)
#define ISP3X_RAWAWB_YWEIGHT_CURVE_YCOOR03	(ISP3X_RAWAWB_BASE + 0x0030)
#define ISP3X_RAWAWB_YWEIGHT_CURVE_YCOOR47	(ISP3X_RAWAWB_BASE + 0x0034)
#define ISP3X_RAWAWB_YWEIGHT_CURVE_YCOOR8	(ISP3X_RAWAWB_BASE + 0x0038)
#define ISP3X_RAWAWB_PRE_WBGAIN_INV		(ISP3X_RAWAWB_BASE + 0x003c)
#define ISP3X_RAWAWB_UV_DETC_VERTEX0_0		(ISP3X_RAWAWB_BASE + 0x0040)
#define ISP3X_RAWAWB_UV_DETC_VERTEX1_0		(ISP3X_RAWAWB_BASE + 0x0044)
#define ISP3X_RAWAWB_UV_DETC_VERTEX2_0		(ISP3X_RAWAWB_BASE + 0x0048)
#define ISP3X_RAWAWB_UV_DETC_VERTEX3_0		(ISP3X_RAWAWB_BASE + 0x004c)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE01_0		(ISP3X_RAWAWB_BASE + 0x0050)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE12_0		(ISP3X_RAWAWB_BASE + 0x0054)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE23_0		(ISP3X_RAWAWB_BASE + 0x0058)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE30_0		(ISP3X_RAWAWB_BASE + 0x005c)
#define ISP3X_RAWAWB_UV_DETC_VERTEX0_1		(ISP3X_RAWAWB_BASE + 0x0060)
#define ISP3X_RAWAWB_UV_DETC_VERTEX1_1		(ISP3X_RAWAWB_BASE + 0x0064)
#define ISP3X_RAWAWB_UV_DETC_VERTEX2_1		(ISP3X_RAWAWB_BASE + 0x0068)
#define ISP3X_RAWAWB_UV_DETC_VERTEX3_1		(ISP3X_RAWAWB_BASE + 0x006c)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE01_1		(ISP3X_RAWAWB_BASE + 0x0070)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE12_1		(ISP3X_RAWAWB_BASE + 0x0074)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE23_1		(ISP3X_RAWAWB_BASE + 0x0078)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE30_1		(ISP3X_RAWAWB_BASE + 0x007c)
#define ISP3X_RAWAWB_UV_DETC_VERTEX0_2		(ISP3X_RAWAWB_BASE + 0x0080)
#define ISP3X_RAWAWB_UV_DETC_VERTEX1_2		(ISP3X_RAWAWB_BASE + 0x0084)
#define ISP3X_RAWAWB_UV_DETC_VERTEX2_2		(ISP3X_RAWAWB_BASE + 0x0088)
#define ISP3X_RAWAWB_UV_DETC_VERTEX3_2		(ISP3X_RAWAWB_BASE + 0x008c)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE01_2		(ISP3X_RAWAWB_BASE + 0x0090)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE12_2		(ISP3X_RAWAWB_BASE + 0x0094)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE23_2		(ISP3X_RAWAWB_BASE + 0x0098)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE30_2		(ISP3X_RAWAWB_BASE + 0x009c)
#define ISP3X_RAWAWB_UV_DETC_VERTEX0_3		(ISP3X_RAWAWB_BASE + 0x00a0)
#define ISP3X_RAWAWB_UV_DETC_VERTEX1_3		(ISP3X_RAWAWB_BASE + 0x00a4)
#define ISP3X_RAWAWB_UV_DETC_VERTEX2_3		(ISP3X_RAWAWB_BASE + 0x00a8)
#define ISP3X_RAWAWB_UV_DETC_VERTEX3_3		(ISP3X_RAWAWB_BASE + 0x00ac)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE01_3		(ISP3X_RAWAWB_BASE + 0x00b0)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE12_3		(ISP3X_RAWAWB_BASE + 0x00b4)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE23_3		(ISP3X_RAWAWB_BASE + 0x00b8)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE30_3		(ISP3X_RAWAWB_BASE + 0x00bc)
#define ISP3X_RAWAWB_UV_DETC_VERTEX0_4		(ISP3X_RAWAWB_BASE + 0x00c0)
#define ISP3X_RAWAWB_UV_DETC_VERTEX1_4		(ISP3X_RAWAWB_BASE + 0x00c4)
#define ISP3X_RAWAWB_UV_DETC_VERTEX2_4		(ISP3X_RAWAWB_BASE + 0x00c8)
#define ISP3X_RAWAWB_UV_DETC_VERTEX3_4		(ISP3X_RAWAWB_BASE + 0x00cc)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE01_4		(ISP3X_RAWAWB_BASE + 0x00d0)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE12_4		(ISP3X_RAWAWB_BASE + 0x00d4)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE23_4		(ISP3X_RAWAWB_BASE + 0x00d8)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE30_4		(ISP3X_RAWAWB_BASE + 0x00dc)
#define ISP3X_RAWAWB_UV_DETC_VERTEX0_5		(ISP3X_RAWAWB_BASE + 0x00e0)
#define ISP3X_RAWAWB_UV_DETC_VERTEX1_5		(ISP3X_RAWAWB_BASE + 0x00e4)
#define ISP3X_RAWAWB_UV_DETC_VERTEX2_5		(ISP3X_RAWAWB_BASE + 0x00e8)
#define ISP3X_RAWAWB_UV_DETC_VERTEX3_5		(ISP3X_RAWAWB_BASE + 0x00ec)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE01_5		(ISP3X_RAWAWB_BASE + 0x00f0)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE10_5		(ISP3X_RAWAWB_BASE + 0x00f4)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE23_5		(ISP3X_RAWAWB_BASE + 0x00f8)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE30_5		(ISP3X_RAWAWB_BASE + 0x00fc)
#define ISP3X_RAWAWB_UV_DETC_VERTEX0_6		(ISP3X_RAWAWB_BASE + 0x0100)
#define ISP3X_RAWAWB_UV_DETC_VERTEX1_6		(ISP3X_RAWAWB_BASE + 0x0104)
#define ISP3X_RAWAWB_UV_DETC_VERTEX2_6		(ISP3X_RAWAWB_BASE + 0x0108)
#define ISP3X_RAWAWB_UV_DETC_VERTEX3_6		(ISP3X_RAWAWB_BASE + 0x010c)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE01_6		(ISP3X_RAWAWB_BASE + 0x0110)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE10_6		(ISP3X_RAWAWB_BASE + 0x0114)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE23_6		(ISP3X_RAWAWB_BASE + 0x0118)
#define ISP3X_RAWAWB_UV_DETC_ISLOPE30_6		(ISP3X_RAWAWB_BASE + 0x011c)
#define ISP3X_RAWAWB_YUV_RGB2ROTY_0		(ISP3X_RAWAWB_BASE + 0x0120)
#define ISP3X_RAWAWB_YUV_RGB2ROTY_1		(ISP3X_RAWAWB_BASE + 0x0124)
#define ISP3X_RAWAWB_YUV_RGB2ROTU_0		(ISP3X_RAWAWB_BASE + 0x0128)
#define ISP3X_RAWAWB_YUV_RGB2ROTU_1		(ISP3X_RAWAWB_BASE + 0x012c)
#define ISP3X_RAWAWB_YUV_RGB2ROTV_0		(ISP3X_RAWAWB_BASE + 0x0130)
#define ISP3X_RAWAWB_YUV_RGB2ROTV_1		(ISP3X_RAWAWB_BASE + 0x0134)
#define ISP3X_RAWAWB_YUV_X_COOR_Y_0		(ISP3X_RAWAWB_BASE + 0x0140)
#define ISP3X_RAWAWB_YUV_X_COOR_U_0		(ISP3X_RAWAWB_BASE + 0x0144)
#define ISP3X_RAWAWB_YUV_X_COOR_V_0		(ISP3X_RAWAWB_BASE + 0x0148)
#define ISP3X_RAWAWB_YUV_X1X2_DIS_0		(ISP3X_RAWAWB_BASE + 0x014c)
#define ISP3X_RAWAWB_YUV_INTERP_CURVE_UCOOR_0	(ISP3X_RAWAWB_BASE + 0x0150)
#define ISP3X_RAWAWB_YUV_INTERP_CURVE_TH0_0	(ISP3X_RAWAWB_BASE + 0x0154)
#define ISP3X_RAWAWB_YUV_INTERP_CURVE_TH1_0	(ISP3X_RAWAWB_BASE + 0x0158)
#define ISP3X_RAWAWB_YUV_INTERP_CURVE_TH2_0	(ISP3X_RAWAWB_BASE + 0x015c)
#define ISP3X_RAWAWB_YUV_X_COOR_Y_1		(ISP3X_RAWAWB_BASE + 0x0160)
#define ISP3X_RAWAWB_YUV_X_COOR_U_1		(ISP3X_RAWAWB_BASE + 0x0164)
#define ISP3X_RAWAWB_YUV_X_COOR_V_1		(ISP3X_RAWAWB_BASE + 0x0168)
#define ISP3X_RAWAWB_YUV_X1X2_DIS_1		(ISP3X_RAWAWB_BASE + 0x016c)
#define ISP3X_RAWAWB_YUV_INTERP_CURVE_UCOOR_1	(ISP3X_RAWAWB_BASE + 0x0170)
#define ISP3X_RAWAWB_YUV_INTERP_CURVE_TH0_1	(ISP3X_RAWAWB_BASE + 0x0174)
#define ISP3X_RAWAWB_YUV_INTERP_CURVE_TH1_1	(ISP3X_RAWAWB_BASE + 0x0178)
#define ISP3X_RAWAWB_YUV_INTERP_CURVE_TH2_1	(ISP3X_RAWAWB_BASE + 0x017c)
#define ISP3X_RAWAWB_YUV_X_COOR_Y_2		(ISP3X_RAWAWB_BASE + 0x0180)
#define ISP3X_RAWAWB_YUV_X_COOR_U_2		(ISP3X_RAWAWB_BASE + 0x0184)
#define ISP3X_RAWAWB_YUV_X_COOR_V_2		(ISP3X_RAWAWB_BASE + 0x0188)
#define ISP3X_RAWAWB_YUV_X1X2_DIS_2		(ISP3X_RAWAWB_BASE + 0x018c)
#define ISP3X_RAWAWB_YUV_INTERP_CURVE_UCOOR_2	(ISP3X_RAWAWB_BASE + 0x0190)
#define ISP3X_RAWAWB_YUV_INTERP_CURVE_TH0_2	(ISP3X_RAWAWB_BASE + 0x0194)
#define ISP3X_RAWAWB_YUV_INTERP_CURVE_TH1_2	(ISP3X_RAWAWB_BASE + 0x0198)
#define ISP3X_RAWAWB_YUV_INTERP_CURVE_TH2_2	(ISP3X_RAWAWB_BASE + 0x019c)
#define ISP3X_RAWAWB_YUV_X_COOR_Y_3		(ISP3X_RAWAWB_BASE + 0x01a0)
#define ISP3X_RAWAWB_YUV_X_COOR_U_3		(ISP3X_RAWAWB_BASE + 0x01a4)
#define ISP3X_RAWAWB_YUV_X_COOR_V_3		(ISP3X_RAWAWB_BASE + 0x01a8)
#define ISP3X_RAWAWB_YUV_X1X2_DIS_3		(ISP3X_RAWAWB_BASE + 0x01ac)
#define ISP3X_RAWAWB_YUV_INTERP_CURVE_UCOOR_3	(ISP3X_RAWAWB_BASE + 0x01b0)
#define ISP3X_RAWAWB_YUV_INTERP_CURVE_TH0_3	(ISP3X_RAWAWB_BASE + 0x01b4)
#define ISP3X_RAWAWB_YUV_INTERP_CURVE_TH1_3	(ISP3X_RAWAWB_BASE + 0x01b8)
#define ISP3X_RAWAWB_YUV_INTERP_CURVE_TH2_3	(ISP3X_RAWAWB_BASE + 0x01bc)
#define ISP3X_RAWAWB_RGB2XY_WT01		(ISP3X_RAWAWB_BASE + 0x01fc)
#define ISP3X_RAWAWB_RGB2XY_WT2			(ISP3X_RAWAWB_BASE + 0x0200)
#define ISP3X_RAWAWB_RGB2XY_MAT0_XY		(ISP3X_RAWAWB_BASE + 0x0204)
#define ISP3X_RAWAWB_RGB2XY_MAT1_XY		(ISP3X_RAWAWB_BASE + 0x0208)
#define ISP3X_RAWAWB_RGB2XY_MAT2_XY		(ISP3X_RAWAWB_BASE + 0x020c)
#define ISP3X_RAWAWB_XY_DETC_NOR_X_0		(ISP3X_RAWAWB_BASE + 0x0210)
#define ISP3X_RAWAWB_XY_DETC_NOR_Y_0		(ISP3X_RAWAWB_BASE + 0x0214)
#define ISP3X_RAWAWB_XY_DETC_BIG_X_0		(ISP3X_RAWAWB_BASE + 0x0218)
#define ISP3X_RAWAWB_XY_DETC_BIG_Y_0		(ISP3X_RAWAWB_BASE + 0x021c)
#define ISP3X_RAWAWB_XY_DETC_NOR_X_1		(ISP3X_RAWAWB_BASE + 0x0228)
#define ISP3X_RAWAWB_XY_DETC_NOR_Y_1		(ISP3X_RAWAWB_BASE + 0x022c)
#define ISP3X_RAWAWB_XY_DETC_BIG_X_1		(ISP3X_RAWAWB_BASE + 0x0230)
#define ISP3X_RAWAWB_XY_DETC_BIG_Y_1		(ISP3X_RAWAWB_BASE + 0x0234)
#define ISP3X_RAWAWB_XY_DETC_NOR_X_2		(ISP3X_RAWAWB_BASE + 0x0240)
#define ISP3X_RAWAWB_XY_DETC_NOR_Y_2		(ISP3X_RAWAWB_BASE + 0x0244)
#define ISP3X_RAWAWB_XY_DETC_BIG_X_2		(ISP3X_RAWAWB_BASE + 0x0248)
#define ISP3X_RAWAWB_XY_DETC_BIG_Y_2		(ISP3X_RAWAWB_BASE + 0x024c)
#define ISP3X_RAWAWB_XY_DETC_NOR_X_3		(ISP3X_RAWAWB_BASE + 0x0258)
#define ISP3X_RAWAWB_XY_DETC_NOR_Y_3		(ISP3X_RAWAWB_BASE + 0x025c)
#define ISP3X_RAWAWB_XY_DETC_BIG_X_3		(ISP3X_RAWAWB_BASE + 0x0260)
#define ISP3X_RAWAWB_XY_DETC_BIG_Y_3		(ISP3X_RAWAWB_BASE + 0x0264)
#define ISP3X_RAWAWB_XY_DETC_NOR_X_4		(ISP3X_RAWAWB_BASE + 0x0270)
#define ISP3X_RAWAWB_XY_DETC_NOR_Y_4		(ISP3X_RAWAWB_BASE + 0x0274)
#define ISP3X_RAWAWB_XY_DETC_BIG_X_4		(ISP3X_RAWAWB_BASE + 0x0278)
#define ISP3X_RAWAWB_XY_DETC_BIG_Y_4		(ISP3X_RAWAWB_BASE + 0x027c)
#define ISP3X_RAWAWB_XY_DETC_NOR_X_5		(ISP3X_RAWAWB_BASE + 0x0288)
#define ISP3X_RAWAWB_XY_DETC_NOR_Y_5		(ISP3X_RAWAWB_BASE + 0x028c)
#define ISP3X_RAWAWB_XY_DETC_BIG_X_5		(ISP3X_RAWAWB_BASE + 0x0290)
#define ISP3X_RAWAWB_XY_DETC_BIG_Y_5		(ISP3X_RAWAWB_BASE + 0x0294)
#define ISP3X_RAWAWB_XY_DETC_NOR_X_6		(ISP3X_RAWAWB_BASE + 0x02a0)
#define ISP3X_RAWAWB_XY_DETC_NOR_Y_6		(ISP3X_RAWAWB_BASE + 0x02a4)
#define ISP3X_RAWAWB_XY_DETC_BIG_X_6		(ISP3X_RAWAWB_BASE + 0x02a8)
#define ISP3X_RAWAWB_XY_DETC_BIG_Y_6		(ISP3X_RAWAWB_BASE + 0x02ac)
#define ISP3X_RAWAWB_MULTIWINDOW_EXC_CTRL	(ISP3X_RAWAWB_BASE + 0x02b8)
#define ISP3X_RAWAWB_MULTIWINDOW0_OFFS		(ISP3X_RAWAWB_BASE + 0x02bc)
#define ISP3X_RAWAWB_MULTIWINDOW0_SIZE		(ISP3X_RAWAWB_BASE + 0x02c0)
#define ISP3X_RAWAWB_MULTIWINDOW1_OFFS		(ISP3X_RAWAWB_BASE + 0x02c4)
#define ISP3X_RAWAWB_MULTIWINDOW1_SIZE		(ISP3X_RAWAWB_BASE + 0x02c8)
#define ISP3X_RAWAWB_MULTIWINDOW2_OFFS		(ISP3X_RAWAWB_BASE + 0x02cc)
#define ISP3X_RAWAWB_MULTIWINDOW2_SIZE		(ISP3X_RAWAWB_BASE + 0x02d0)
#define ISP3X_RAWAWB_MULTIWINDOW3_OFFS		(ISP3X_RAWAWB_BASE + 0x02d4)
#define ISP3X_RAWAWB_MULTIWINDOW3_SIZE		(ISP3X_RAWAWB_BASE + 0x02d8)
#define ISP3X_RAWAWB_EXC_WP_REGION0_XU		(ISP3X_RAWAWB_BASE + 0x02fc)
#define ISP3X_RAWAWB_EXC_WP_REGION0_YV		(ISP3X_RAWAWB_BASE + 0x0300)
#define ISP3X_RAWAWB_EXC_WP_REGION1_XU		(ISP3X_RAWAWB_BASE + 0x0304)
#define ISP3X_RAWAWB_EXC_WP_REGION1_YV		(ISP3X_RAWAWB_BASE + 0x0308)
#define ISP3X_RAWAWB_EXC_WP_REGION2_XU		(ISP3X_RAWAWB_BASE + 0x030c)
#define ISP3X_RAWAWB_EXC_WP_REGION2_YV		(ISP3X_RAWAWB_BASE + 0x0310)
#define ISP3X_RAWAWB_EXC_WP_REGION3_XU		(ISP3X_RAWAWB_BASE + 0x0314)
#define ISP3X_RAWAWB_EXC_WP_REGION3_YV		(ISP3X_RAWAWB_BASE + 0x0318)
#define ISP3X_RAWAWB_EXC_WP_REGION4_XU		(ISP3X_RAWAWB_BASE + 0x031c)
#define ISP3X_RAWAWB_EXC_WP_REGION4_YV		(ISP3X_RAWAWB_BASE + 0x0320)
#define ISP3X_RAWAWB_EXC_WP_REGION5_XU		(ISP3X_RAWAWB_BASE + 0x0324)
#define ISP3X_RAWAWB_EXC_WP_REGION5_YV		(ISP3X_RAWAWB_BASE + 0x0328)
#define ISP3X_RAWAWB_EXC_WP_REGION6_XU		(ISP3X_RAWAWB_BASE + 0x032c)
#define ISP3X_RAWAWB_EXC_WP_REGION6_YV		(ISP3X_RAWAWB_BASE + 0x0330)
#define ISP32_RAWAWB_EXC_WP_WEIGHT0_3		(ISP3X_RAWAWB_BASE + 0x0334)
#define ISP32_RAWAWB_EXC_WP_WEIGHT4_6		(ISP3X_RAWAWB_BASE + 0x0338)
#define ISP3X_RAWAWB_SUM_RGAIN_NOR_0		(ISP3X_RAWAWB_BASE + 0x0340)
#define ISP3X_RAWAWB_SUM_BGAIN_NOR_0		(ISP3X_RAWAWB_BASE + 0x0348)
#define ISP3X_RAWAWB_WP_NUM_NOR_0		(ISP3X_RAWAWB_BASE + 0x034c)
#define ISP3X_RAWAWB_SUM_RGAIN_BIG_0		(ISP3X_RAWAWB_BASE + 0x0350)
#define ISP3X_RAWAWB_SUM_BGAIN_BIG_0		(ISP3X_RAWAWB_BASE + 0x0358)
#define ISP3X_RAWAWB_WP_NUM_BIG_0		(ISP3X_RAWAWB_BASE + 0x035c)
#define ISP3X_RAWAWB_SUM_RGAIN_NOR_1		(ISP3X_RAWAWB_BASE + 0x0370)
#define ISP3X_RAWAWB_SUM_BGAIN_NOR_1		(ISP3X_RAWAWB_BASE + 0x0378)
#define ISP3X_RAWAWB_WP_NUM_NOR_1		(ISP3X_RAWAWB_BASE + 0x037c)
#define ISP3X_RAWAWB_SUM_RGAIN_BIG_1		(ISP3X_RAWAWB_BASE + 0x0380)
#define ISP3X_RAWAWB_SUM_BGAIN_BIG_1		(ISP3X_RAWAWB_BASE + 0x0388)
#define ISP3X_RAWAWB_WP_NUM_BIG_1		(ISP3X_RAWAWB_BASE + 0x038c)
#define ISP3X_RAWAWB_SUM_RGAIN_NOR_2		(ISP3X_RAWAWB_BASE + 0x03a0)
#define ISP3X_RAWAWB_SUM_BGAIN_NOR_2		(ISP3X_RAWAWB_BASE + 0x03a8)
#define ISP3X_RAWAWB_WP_NUM_NOR_2		(ISP3X_RAWAWB_BASE + 0x03ac)
#define ISP3X_RAWAWB_SUM_RGAIN_BIG_2		(ISP3X_RAWAWB_BASE + 0x03b0)
#define ISP3X_RAWAWB_SUM_BGAIN_BIG_2		(ISP3X_RAWAWB_BASE + 0x03b8)
#define ISP3X_RAWAWB_WP_NUM_BIG_2		(ISP3X_RAWAWB_BASE + 0x03bc)
#define ISP3X_RAWAWB_SUM_RGAIN_NOR_3		(ISP3X_RAWAWB_BASE + 0x03d0)
#define ISP3X_RAWAWB_SUM_BGAIN_NOR_3		(ISP3X_RAWAWB_BASE + 0x03d8)
#define ISP3X_RAWAWB_WP_NUM_NOR_3		(ISP3X_RAWAWB_BASE + 0x03dc)
#define ISP3X_RAWAWB_SUM_RGAIN_BIG_3		(ISP3X_RAWAWB_BASE + 0x03e0)
#define ISP3X_RAWAWB_SUM_BGAIN_BIG_3		(ISP3X_RAWAWB_BASE + 0x03e8)
#define ISP3X_RAWAWB_WP_NUM_BIG_3		(ISP3X_RAWAWB_BASE + 0x03ec)
#define ISP3X_RAWAWB_SUM_RGAIN_NOR_4		(ISP3X_RAWAWB_BASE + 0x0400)
#define ISP3X_RAWAWB_SUM_BGAIN_NOR_4		(ISP3X_RAWAWB_BASE + 0x0408)
#define ISP3X_RAWAWB_WP_NUM_NOR_4		(ISP3X_RAWAWB_BASE + 0x040c)
#define ISP3X_RAWAWB_SUM_RGAIN_BIG_4		(ISP3X_RAWAWB_BASE + 0x0410)
#define ISP3X_RAWAWB_SUM_BGAIN_BIG_4		(ISP3X_RAWAWB_BASE + 0x0418)
#define ISP3X_RAWAWB_WP_NUM_BIG_4		(ISP3X_RAWAWB_BASE + 0x041c)
#define ISP3X_RAWAWB_SUM_RGAIN_NOR_5		(ISP3X_RAWAWB_BASE + 0x0430)
#define ISP3X_RAWAWB_SUM_BGAIN_NOR_5		(ISP3X_RAWAWB_BASE + 0x0438)
#define ISP3X_RAWAWB_WP_NUM_NOR_5		(ISP3X_RAWAWB_BASE + 0x043c)
#define ISP3X_RAWAWB_SUM_RGAIN_BIG_5		(ISP3X_RAWAWB_BASE + 0x0440)
#define ISP3X_RAWAWB_SUM_BGAIN_BIG_5		(ISP3X_RAWAWB_BASE + 0x0448)
#define ISP3X_RAWAWB_WP_NUM_BIG_5		(ISP3X_RAWAWB_BASE + 0x044c)
#define ISP3X_RAWAWB_SUM_RGAIN_NOR_6		(ISP3X_RAWAWB_BASE + 0x0460)
#define ISP3X_RAWAWB_SUM_BGAIN_NOR_6		(ISP3X_RAWAWB_BASE + 0x0468)
#define ISP3X_RAWAWB_WP_NUM_NOR_6		(ISP3X_RAWAWB_BASE + 0x046c)
#define ISP3X_RAWAWB_SUM_RGAIN_BIG_6		(ISP3X_RAWAWB_BASE + 0x0470)
#define ISP3X_RAWAWB_SUM_BGAIN_BIG_6		(ISP3X_RAWAWB_BASE + 0x0478)
#define ISP3X_RAWAWB_WP_NUM_BIG_6		(ISP3X_RAWAWB_BASE + 0x047c)
#define ISP3X_RAWAWB_SUM_R_NOR_MULTIWINDOW0	(ISP3X_RAWAWB_BASE + 0x0490)
#define ISP3X_RAWAWB_SUM_B_NOR_MULTIWINDOW0	(ISP3X_RAWAWB_BASE + 0x0498)
#define ISP3X_RAWAWB_WP_NM_NOR_MULTIWINDOW0	(ISP3X_RAWAWB_BASE + 0x049c)
#define ISP3X_RAWAWB_SUM_R_BIG_MULTIWINDOW0	(ISP3X_RAWAWB_BASE + 0x04a0)
#define ISP3X_RAWAWB_SUM_B_BIG_MULTIWINDOW0	(ISP3X_RAWAWB_BASE + 0x04a8)
#define ISP3X_RAWAWB_WP_NM_BIG_MULTIWINDOW0	(ISP3X_RAWAWB_BASE + 0x04ac)
#define ISP3X_RAWAWB_SUM_R_NOR_MULTIWINDOW1	(ISP3X_RAWAWB_BASE + 0x04c0)
#define ISP3X_RAWAWB_SUM_B_NOR_MULTIWINDOW1	(ISP3X_RAWAWB_BASE + 0x04c8)
#define ISP3X_RAWAWB_WP_NM_NOR_MULTIWINDOW1	(ISP3X_RAWAWB_BASE + 0x04cc)
#define ISP3X_RAWAWB_SUM_R_BIG_MULTIWINDOW1	(ISP3X_RAWAWB_BASE + 0x04d0)
#define ISP3X_RAWAWB_SUM_B_BIG_MULTIWINDOW1	(ISP3X_RAWAWB_BASE + 0x04d8)
#define ISP3X_RAWAWB_WP_NM_BIG_MULTIWINDOW1	(ISP3X_RAWAWB_BASE + 0x04dc)
#define ISP3X_RAWAWB_SUM_R_NOR_MULTIWINDOW2	(ISP3X_RAWAWB_BASE + 0x04f0)
#define ISP3X_RAWAWB_SUM_B_NOR_MULTIWINDOW2	(ISP3X_RAWAWB_BASE + 0x04f8)
#define ISP3X_RAWAWB_WP_NM_NOR_MULTIWINDOW2	(ISP3X_RAWAWB_BASE + 0x04fc)
#define ISP3X_RAWAWB_SUM_R_BIG_MULTIWINDOW2	(ISP3X_RAWAWB_BASE + 0x0500)
#define ISP3X_RAWAWB_SUM_B_BIG_MULTIWINDOW2	(ISP3X_RAWAWB_BASE + 0x0508)
#define ISP3X_RAWAWB_WP_NM_BIG_MULTIWINDOW2	(ISP3X_RAWAWB_BASE + 0x050c)
#define ISP3X_RAWAWB_SUM_R_NOR_MULTIWINDOW3	(ISP3X_RAWAWB_BASE + 0x0520)
#define ISP3X_RAWAWB_SUM_B_NOR_MULTIWINDOW3	(ISP3X_RAWAWB_BASE + 0x0528)
#define ISP3X_RAWAWB_WP_NM_NOR_MULTIWINDOW3	(ISP3X_RAWAWB_BASE + 0x052c)
#define ISP3X_RAWAWB_SUM_R_BIG_MULTIWINDOW3	(ISP3X_RAWAWB_BASE + 0x0530)
#define ISP3X_RAWAWB_SUM_B_BIG_MULTIWINDOW3	(ISP3X_RAWAWB_BASE + 0x0538)
#define ISP3X_RAWAWB_WP_NM_BIG_MULTIWINDOW3	(ISP3X_RAWAWB_BASE + 0x053c)
#define ISP3X_RAWAWB_SUM_R_EXC0			(ISP3X_RAWAWB_BASE + 0x05e0)
#define ISP3X_RAWAWB_SUM_B_EXC0			(ISP3X_RAWAWB_BASE + 0x05e8)
#define ISP3X_RAWAWB_WP_NM_EXC0			(ISP3X_RAWAWB_BASE + 0x05ec)
#define ISP3X_RAWAWB_SUM_R_EXC1			(ISP3X_RAWAWB_BASE + 0x05f0)
#define ISP3X_RAWAWB_SUM_B_EXC1			(ISP3X_RAWAWB_BASE + 0x05f8)
#define ISP3X_RAWAWB_WP_NM_EXC1			(ISP3X_RAWAWB_BASE + 0x05fc)
#define ISP3X_RAWAWB_SUM_R_EXC2			(ISP3X_RAWAWB_BASE + 0x0600)
#define ISP3X_RAWAWB_SUM_B_EXC2			(ISP3X_RAWAWB_BASE + 0x0608)
#define ISP3X_RAWAWB_WP_NM_EXC2			(ISP3X_RAWAWB_BASE + 0x060c)
#define ISP3X_RAWAWB_SUM_R_EXC3			(ISP3X_RAWAWB_BASE + 0x0610)
#define ISP3X_RAWAWB_SUM_B_EXC3			(ISP3X_RAWAWB_BASE + 0x0618)
#define ISP3X_RAWAWB_WP_NM_EXC3			(ISP3X_RAWAWB_BASE + 0x061c)
#define ISP3X_RAWAWB_Y_HIST01			(ISP3X_RAWAWB_BASE + 0x0620)
#define ISP3X_RAWAWB_Y_HIST23			(ISP3X_RAWAWB_BASE + 0x0624)
#define ISP3X_RAWAWB_Y_HIST45			(ISP3X_RAWAWB_BASE + 0x0628)
#define ISP3X_RAWAWB_Y_HIST67			(ISP3X_RAWAWB_BASE + 0x062c)
#define ISP3X_RAWAWB_WPNUM2_0			(ISP3X_RAWAWB_BASE + 0x0630)
#define ISP3X_RAWAWB_WPNUM2_1			(ISP3X_RAWAWB_BASE + 0x0634)
#define ISP3X_RAWAWB_WPNUM2_2			(ISP3X_RAWAWB_BASE + 0x0638)
#define ISP3X_RAWAWB_WPNUM2_3			(ISP3X_RAWAWB_BASE + 0x063c)
#define ISP3X_RAWAWB_WPNUM2_4			(ISP3X_RAWAWB_BASE + 0x0640)
#define ISP3X_RAWAWB_WPNUM2_5			(ISP3X_RAWAWB_BASE + 0x0644)
#define ISP3X_RAWAWB_WPNUM2_6			(ISP3X_RAWAWB_BASE + 0x0648)
#define ISP3X_RAWAWB_RAM_CTRL			(ISP3X_RAWAWB_BASE + 0x0650)
#define ISP3X_RAWAWB_WRAM_CTRL			(ISP3X_RAWAWB_BASE + 0x0654)
#define ISP3X_RAWAWB_WRAM_DATA_BASE		(ISP3X_RAWAWB_BASE + 0x0660)
#define ISP3X_RAWAWB_RAM_DATA_BASE		(ISP3X_RAWAWB_BASE + 0x0700)

/* VI_ISP_PATH */
#define ISP3X_RAWAE3_SEL(x)		(((x) & 3) << 16)
#define ISP3X_RAWAF_SEL(x)		(((x) & 3) << 18)
#define ISP3X_RAWAWB_SEL(x)		(((x) & 3) << 20)
#define ISP3X_RAWAE012_SEL(x)		(((x) & 3) << 22)
#define ISP3X_LSC_CFG_SEL(x)		(((x) & 3) << 24)
#define ISP32_BNR2AWB_SEL		BIT(26)
#define ISP32_DRC2AWB_SEL		BIT(27)

/* VI_ICCL */
#define ISP32_BRSZ_CLK_ENABLE		BIT(13)

/* SWS_CFG */
#define ISP3X_SW_ACK_FRM_PRO_DIS	BIT(3)
#define ISP3X_3A_DDR_WRITE_EN		BIT(24)
#define ISP3X_SW_MIPI2ISP_FIFO_DIS	BIT(25)
#define ISP3X_SW_3D_DBR_START_MODE	BIT(26)

/* CMSK */
#define ISP3X_SW_CMSK_EN		BIT(0)
#define ISP3X_SW_CMSK_EN_MP		BIT(1)
#define ISP3X_SW_CMSK_EN_SP		BIT(2)
#define ISP3X_SW_CMSK_EN_BP		BIT(3)
#define ISP3X_SW_CMSK_BLKSIZE(x)	(((x) & 3) << 4)

#define ISP32_SW_CMSK_EN_PATH		GENMASK(3, 0)
#define ISP32_SW_CMSK_EN_PATH_SHD       GENMASK(11, 8)

#define ISP3X_SW_CMSK_FORCE_UPD		BIT(31)

#define ISP3X_SW_CMSK_ORDER_MODE	BIT(1)

#define ISP3X_SW_CMSK_YUV(x, y, z)	(((x) & 0xff) | ((y) & 0xff) << 8 | ((z) & 0xff) << 16)

/* ISP CTRL0 */
#define ISP32_MIR_ENABLE		BIT(5)
#define ISP3X_SW_CGC_YUV_LIMIT		BIT(28)
#define ISP3X_SW_CGC_RATIO_EN		BIT(29)

/* ISP CTRL1 */
#define ISP3X_YNR_FST_FRAME		BIT(23)
#define ISP3X_ADRC_FST_FRAME		BIT(24)
#define ISP3X_DHAZ_FST_FRAME		BIT(25)
#define ISP3X_CNR_FST_FRAME		BIT(26)
#define ISP3X_RAW3D_FST_FRAME		BIT(27)
#define ISP3X_BIGMODE_FORCE_EN		BIT(28)
#define ISP3X_BIGMODE_MANUAL		BIT(29)

/* ISP ACQ_H_OFFS */
#define ISP3X_SENSOR_MODE(x)		(((x) & 3) << 30)
#define ISP3X_SENSOR_INDEX(x)		(((x) & 3) << 28)
#define ISP3X_ACQ_H_OFFS(x)		((x) & 0x7fff)

/* isp interrupt */
#define ISP3X_OFF			BIT(0)
#define ISP3X_FRAME			BIT(1)
#define ISP3X_DATA_LOSS			BIT(2)
#define ISP3X_PIC_SIZE_ERROR		BIT(3)
#define ISP3X_SIAWB_DONE		BIT(4)
#define ISP3X_FRAME_IN			BIT(5)
#define ISP3X_V_START			BIT(6)
#define ISP3X_H_START			BIT(7)
#define ISP3X_FLASH_ON			BIT(8)
#define ISP3X_FLASH_OFF			BIT(9)
#define ISP3X_SHUTTER_ON		BIT(10)
#define ISP3X_SHUTTER_OFF		BIT(11)
#define ISP3X_AFM_SUM_OF		BIT(12)
#define ISP3X_AFM_LUM_OF		BIT(13)
#define ISP3X_SIAF_FIN			BIT(14)
#define ISP3X_SIHST_RDY			BIT(15)
#define ISP3X_LSC_LUT_ERR		BIT(16)
#define ISP3X_FLASH_CAP			BIT(17)
#define ISP3X_EXP_END			BIT(18)
#define ISP3X_HDR_DONE			BIT(20)
#define ISP3X_DHAZ_DONE			BIT(21)
#define ISP3X_GIAN_ERR			BIT(22)
#define ISP3X_OUT_FRM_END		BIT(23)
#define ISP3X_OUT_FRM_HALF		BIT(24)
#define ISP3X_OUT_FRM_QUARTER		BIT(25)
#define ISP3X_BAY3D_IN_DONE		BIT(26)
#define ISP3X_BAY3D_IN_LINECNT_DONE	BIT(27)
#define ISP3X_BAY3D_POST_ST		BIT(28)
#define ISP3X_BAY3D_FRM_END		BIT(29)
#define ISP3X_FETCH_LUT_END		BIT(30)

/* isp3a interrupt */
#define ISP3X_3A_RAWAE_BIG		BIT(0)
#define ISP3X_3A_RAWAE_CH0		BIT(1)
#define ISP3X_3A_RAWAE_CH1		BIT(2)
#define ISP3X_3A_RAWAE_CH2		BIT(3)
#define ISP3X_3A_RAWHIST_BIG		BIT(4)
#define ISP3X_3A_RAWHIST_CH0		BIT(5)
#define ISP3X_3A_RAWHIST_CH1		BIT(6)
#define ISP3X_3A_RAWHIST_CH2		BIT(7)
#define ISP3X_3A_RAWAF_SUM		BIT(8)
#define ISP3X_3A_RAWAF_LUM		BIT(9)
#define ISP3X_3A_RAWAF			BIT(10)
#define ISP3X_3A_RAWAWB			BIT(11)
#define ISP3X_3A_DDR_DONE		BIT(12)

#define ISP3X_ISP_OUT_LINE(a)		((a) & 0x3fff)

#define ISP32_YNR_LUMA_RDBK_ST		BIT(0)
#define ISP32_YNR_LUMA_RDBK_OFFS(a)	(((a) & 0x3fff) << 16)
#define ISP32_YNR_LUMA_RDBK_RDY		BIT(31)

/* DUAL CROP */
#define ISP3X_DUAL_CROP_FBC_MODE	BIT(8)

/* GAMMA OUT */
#define ISP3X_GAMMA_OUT_EN		BIT(0)
#define ISP3X_GAMMA_OUT_EQU_SEGM	BIT(1)
#define ISP3X_GAMMA_OUT_FINALX4_DENSE	BIT(2)

/* RESIZE */
#define ISP3X_SCL_HPHASE_EN		BIT(10)
#define ISP3X_SCL_CLIP_EN		BIT(11)
#define ISP3X_SCL_IN_CLIP_EN		BIT(12)

/* mi interrupt */
#define ISP3X_MI_MP_FRAME		BIT(0)
#define ISP3X_MI_SP_FRAME		BIT(1)
#define ISP3X_MI_MBLK_LINE		BIT(2)
#define ISP3X_MI_FILL_MP_Y		BIT(3)
#define ISP3X_MI_WRAP_MP_Y		BIT(4)
#define ISP3X_MI_WRAP_MP_CB		BIT(5)
#define ISP3X_MI_WRAP_MP_CR		BIT(6)
#define ISP3X_MI_WRAP_SP_Y		BIT(7)
#define ISP3X_MI_WRAP_SP_CB		BIT(8)
#define ISP3X_MI_WARP_SP_CR		BIT(9)
#define ISP3X_MI_FILL_MP_Y2		BIT(10)
#define ISP3X_MI_DMA_READY		BIT(11)
#define ISP3X_MI_Y12Y_FRAME		BIT(12)
#define ISP3X_MI_Y12C_FRAME		BIT(13)
#define ISP3X_MI_ALL_FRAME		BIT(14)
#define ISP3X_MI_DBR_WR_FRAME		BIT(20)
#define ISP3X_MI_GAIN_WR_FRAME		BIT(21)
#define ISP3X_MI_BAY3D_IIR_FRAME	BIT(22)
#define ISP3X_MI_BAY3D_CUR_FRAME	BIT(23)
#define ISP3X_MI_BAY3D_DS_FRAME		BIT(24)
#define ISP3X_MI_BP_FRAME		BIT(25)
#define ISP3X_MI_WRAP_BP_Y		BIT(26)
#define ISP3X_MI_WRAP_BP_CB		BIT(27)
#define ISP32_MI_MPDS_FRAME		BIT(28)
#define ISP32_MI_BPDS_FRAME		BIT(29)
#define ISP3X_MI_BUS_ERR		BIT(30)
#define ISP3X_MI_MPFBC_FRAME		BIT(31)

/* MI_WR_XTD_FORMAT_CTRL */
#define ISP3X_MI_XTD_FORMAT_MP_UV_SWAP	BIT(0)
#define ISP3X_MI_XTD_FORMAT_SP_UV_SWAP	BIT(1)

/* MI_WR_CTRL2 */
#define ISP3X_MPSELF_UPD		BIT(4)
#define ISP3X_SPSELF_UPD		BIT(5)
#define ISP3X_BPSELF_UPD		BIT(6)
#define ISP3X_BAY3D_RDSELF_UPD		BIT(7)
#define ISP3X_DBR_ENABLE		BIT(8)
#define ISP3X_MIMUX_RAW_ALIGN		BIT(9)
#define ISP3X_DBR_WR_AUTO_UPD		BIT(10)
#define ISP3X_DBR_RDSELF_UPD		BIT(11)
#define ISP3X_GAIN_WR_PINGPONG		BIT(12)
#define ISP3X_GAIN_WR_AUTO_UPD		BIT(13)
#define ISP3X_BAY3D_IIR_WR_AUTO_UPD	BIT(16)
#define ISP3X_BAY3D_CUR_WR_AUTO_UPD	BIT(17)
#define ISP3X_BAY3D_DS_WR_AUTO_UPD	BIT(18)
#define ISP3X_DBR_WRSELF_UPD		BIT(20)
#define ISP3X_GAINSELF_UPD		BIT(21)
#define ISP3X_BAY3D_IIRSELF_UPD		BIT(22)
#define ISP3X_BAY3D_CURSELF_UPD		BIT(23)
#define ISP3X_BAY3D_DSSELF_UPD		BIT(24)
#define ISP32_MPDSSELF_FORCE_UPD	BIT(25)
#define ISP32_BPDSSELF_FORCE_UPD	BIT(26)
#define ISP3X_DBR_ST_MODE		BIT(30)
#define ISP3X_DBR_ST			BIT(31)

/* WR_OUTPUT_FORMAT */
#define ISP32_MI_OUTPUT_MASK		GENMASK(10, 8)
#define ISP32_MI_OUTPUT_YUV400		0
#define ISP32_MI_OUTPUT_YUV420		BIT(8)
#define ISP32_MI_OUTPUT_YUV422		BIT(9)

/* MI_WR_CTRL2_SHD */
#define ISP32_BP_EN_IN_SHD		BIT(4)
#define ISP32_DBR_WR_EN_IN_SHD		BIT(5)
#define ISP32_GAIN_WR_EN_IN_SHD		BIT(6)
#define ISP32_BAY3D_CUR_WR_EN_IN_SHD	BIT(8)
#define ISP32_BAY3D_IIR_WR_EN_IN_SHD	BIT(9)
#define ISP32_BAY3D_DS_WR_EN_IN_SHD	BIT(10)
#define ISP32_MPDS_EN_IN_SHD		BIT(12)
#define ISP32_BPDS_EN_IN_SHD		BIT(13)
#define ISP32_BP_EN_OUT_SHD		BIT(20)
#define ISP32_DBR_WR_EN_OUT_SHD		BIT(21)
#define ISP32_GAIN_WR_EN_OUT_SHD	BIT(22)
#define ISP32_BAY3D_CUR_WR_EN_OUT_SHD	BIT(24)
#define ISP32_BAY3D_IIR_WR_EN_OUT_SHD	BIT(25)
#define ISP32_BAY3D_DS_WR_EN_OUT_SHD	BIT(26)
#define ISP32_MPDS_EN_OUT_SHD		BIT(28)
#define ISP32_BPDS_EN_OUT_SHD		BIT(29)

/* BP_WR_CTRL */
#define ISP3X_BP_ENABLE			BIT(0)
#define ISP3X_BP_AUTO_UPD		BIT(1)
#define ISP3X_BP_PINGPONG		BIT(2)
#define ISP3X_BP_FORMAT_PLA		0
#define ISP3X_BP_FORMAT_SPLA		BIT(4)
#define ISP3X_BP_FORMAT_INT		BIT(5)
#define ISP3X_BP_FORMAT_MASK		GENMASK(5, 4)
#define ISP3X_BP_OUTPUT_YUV400		0
#define ISP3X_BP_OUTPUT_YUV420		BIT(8)
#define ISP3X_BP_OUTPUT_YUV422		BIT(9)
#define ISP3X_BP_OUTPUT_MASK		GENMASK(10, 8)

/* MPDS/BPDS WR_CTRL */
#define ISP32_DS_ENABLE			BIT(0)
#define ISP32_DS_AUTO_UPD		BIT(1)
#define ISP32_DS_FORMAT_PLA		0
#define ISP32_DS_FORMAT_SPLA		BIT(4)
#define ISP32_DS_FORMAT_INT		BIT(5)
#define ISP32_DS_FORMAT_MASK		GENMASK(5, 4)
#define ISP32_DS_OUTPUT_YUV400		0
#define ISP32_DS_OUTPUT_YUV420		BIT(8)
#define ISP32_DS_OUTPUT_YUV422		BIT(9)
#define ISP32_DS_OUTPUT_MASK		GENMASK(10, 8)
#define ISP32_DS_RAM_CLK_DIS		BIT(30)
#define ISP32_DS_DS_DIS			BIT(31)

/* WRAP_CTRL */
#define ISP32_MP_WR_INIT_OFFSET_EN	BIT(0)
#define ISP32_SP_WR_INIT_OFFSET_EN	BIT(1)
#define ISP32_BP_WR_INIT_OFFSET_EN	BIT(2)
#define ISP32_MPDS_WR_INIT_OFFSET_EN	BIT(4)
#define ISP32_BPDS_WR_INIT_OFFSET_EN	BIT(5)
#define ISP32_MP_DYNAMIC_UPD_ADDR	BIT(8)
#define ISP32_SP_DYNAMIC_UPD_ADDR	BIT(9)
#define ISP32_BP_DYNAMIC_UPD_ADDR	BIT(10)
#define ISP32_MPDS_DYNAMIC_UPD_ADDR	BIT(11)
#define ISP32_BPDS_DYNAMIC_UPD_ADDR	BIT(12)
#define ISP32_MP_WR_FRMEND_UPD_DIS	BIT(24)
#define ISP32_SP_WR_FRMEND_UPD_DIS	BIT(25)
#define ISP32_BP_WR_FRMEND_UPD_DIS	BIT(26)
#define ISP32_MPDS_WR_FRMEND_UPD_DIS	BIT(27)
#define ISP32_BPDS_WR_FRMEND_UPD_DIS	BIT(28)

/* VFLIP_CTRL */
#define ISP32_MP_WR_V_FLIP		BIT(0)
#define ISP32_SP_WR_V_FLIP		BIT(1)
#define ISP32_BP_WR_V_FLIP		BIT(2)
#define ISP32_MPDS_WR_V_FLIP		BIT(4)
#define ISP32_BPDS_WR_V_FIIP		BIT(5)

/* MPFBC */
#define ISP3X_MPFBC_YUV_MASK		GENMASK(2, 1)
#define ISP3X_MPFBC_EN			BIT(0)
#define ISP3X_MPFBC_YUV420		0
#define ISP3X_MPFBC_YUV422		BIT(1)
#define ISP3X_MPFBC_PINGPONG_EN		BIT(4)
#define ISP3X_MPFBC_UNCOMPRESSED	BIT(5)
#define ISP3X_MPFBC_SPARSE_MODE		BIT(6)
#define ISP3X_MPFBC_FROM_SCL		BIT(7)
#define ISP3X_SEPERATE_YUV_CFG		BIT(8)
#define ISP3X_MP_YUV_MODE		BIT(9)
#define ISP3X_SP_YUV_MODE		BIT(10)
#define ISP3X_BP_YUV_MODE		BIT(11)
#define ISP3X_HEAD_OFFSET_EN		BIT(12)
#define ISP3X_HEAD_OUT_OPT_DIS		BIT(29)
#define ISP3X_MPFBC_WORKING		BIT(30)
#define ISP3X_MPFBC_FORCE_UPD		BIT(31)
#define ISP3X_MPFBC_EN_SHD		BIT(31)

/* CSI2RX */

/* DEBAYER */

/* CAC */
#define ISP3X_CAC_EN			BIT(0)
#define ISP3X_CAC_BYPASS		BIT(1)
#define ISP3X_CAC_CLEAR			BIT(2)
#define ISP3X_CAC_CENTER_EN		BIT(3)
#define ISP3X_CAC_LUT_EN		BIT(4)
#define ISP3X_CAC_LUT_MODE(x)		(((x) & 0x3) << 24)

/* CNR */
#define ISP3X_CNR_GLOBAL_GAIN_ALPHA_MAX	GENMASK(15, 12)

/* YNR */
#define ISP3X_YNR_EN_SHD		BIT(31)

/* BLS */
#define ISP32_BLS_BLS2_EN		BIT(5)

/* BAY3D */
#define ISP32_BAY3D_BWSAVING(a)		(((a) & 0x1) << 13)

/* GIC */

/* LDCH */
#define ISP3X_LDCH_EN			BIT(0)
#define ISP3X_LDCH_LUT_MODE(x)		(((x) & 0x3) << 24)
#define ISP3X_LDCH_MAP_ERR		BIT(29)

/* DHAZ */
#define ISP3X_DHAZ_ENMUX		BIT(0)
#define ISP3X_DHAZ_DC_EN		BIT(4)
#define ISP3X_DHAZ_HIST_EN		BIT(8)
#define ISP3X_DHAZ_HPARA_EN		BIT(12)
#define ISP3X_DHAZ_AIR_LC_EN		BIT(16)
#define ISP3X_DHAZ_ENHANCE_EN		BIT(20)
#define ISP3X_DHAZ_CKG_DIS		BIT(24)
#define ISP3X_DHAZ_SOFT_WR_EN		BIT(25)
#define ISP3X_DHAZ_ROUND_EN		BIT(26)

/* HDRTMO */

/* HDRDRC */

/* HDRMGE */

/* RAWNR */

/* EXPD */
#define ISP32_EXPD_EN			BIT(0)
#define ISP32_EXPD_K_SHIFT(a)		(((a) & 0xf) << 4)
#define ISP32_EXPD_MODE(a)		(((a) & 0x3) << 8)

#define ISP32_EXPD_DATA(a, b)		((a) | (b) << 16)

/* GAIN */
#define ISP3X_GAIN_2DDR_EN		BIT(24)
#define ISP3X_GAIN_2DDR_mode(a)		(((a) & 0x3) << 25)

/* DPCC */
#define ISP3X_DPCC_WORKING		BIT(30)

/* CCM */
#define ISP3X_CCM_HIGHY_ADJ_DIS		BIT(1)
#define ISP32_CCM_ENH_ADJ_EN		BIT(2)
#define ISP32_CCM_ASYM_ADJ_EN		BIT(3)

/* 3DLUT */
#define ISP3X_3DLUT_EN			BIT(0)
#define ISP3X_3DLUT_LUT_MODE(x)		(((x) & 0x3) << 24)
#define ISP3X_3DLUT_LUT_ERR		BIT(29)

/* DEBAYER */

/* LSC */
#define ISP3X_LSC_ACTIVE_TABLE		BIT(1)
#define ISP3X_LSC_TABLE_ADDRESS_0	0
#define ISP3X_LSC_TABLE_ADDRESS_153	153

#define ISP3X_LSC_SECTOR_16X16		BIT(2)

/* RAWAE */
#define ISP3X_RAWAE_LITE_EN		BIT(0)
#define ISP3X_RAWAE_LITE_WNDNUM		BIT(1)

#define ISP3X_RAWAE_BIG_EN		BIT(0)
#define ISP3X_RAWAE_BIG_WND0_NUM(x)	(((x) & 0x3) << 1)
#define ISP3X_RAWAE_BIG_WND1_EN		BIT(4)
#define ISP3X_RAWAE_BIG_WND2_EN		BIT(5)
#define ISP3X_RAWAE_BIG_WND3_EN		BIT(6)
#define ISP3X_RAWAE_BIG_WND4_EN		BIT(7)

/* RAWHIST */
#define ISP3X_RAWHIST_EN		BIT(0)
#define ISP3X_RAWHIST_STEPSIZE(x)	(((x) & 0x7) << 1)
#define ISP3X_RAWHIST_MODE(x)		(((x) & 0x7) << 8)
#define ISP3X_RAWHIST_WATERLINE(x)	(((x) & 0xfff) << 12)
#define ISP3X_RAWHIST_DATASEL(x)	(((x) & 0x7) << 24)
#define ISP3X_RAWHIST_WND_NUM(x)	(((x) & 0x3) << 28)

#define ISP3X_RAWHIST_RAM_EN		BIT(31)

/* RAWAF */
#define ISP3X_RAWAF_EN			BIT(0)
#define ISP3X_RAWAF_GAMMA_EN		BIT(1)
#define ISP3X_RAWAF_GAUS_EN		BIT(2)
#define ISP3X_RAWAF_V1_FIR		BIT(3)
#define ISP3X_RAWAF_HIIR_EN		BIT(4)
#define ISP3X_RAWAF_VIIR_EN		BIT(5)
#define ISP3X_RAWAF_ACCU_8BIT		BIT(6)
#define ISP3X_RAWAF_LDG_EN		BIT(7)
#define ISP3X_RAWAF_H1_FV		BIT(8)
#define ISP3X_RAWAF_H2_FV		BIT(9)
#define ISP3X_RAWAF_V1_FV		BIT(10)
#define ISP3X_RAWAF_V2_FV		BIT(11)
#define ISP3X_RAWAF_AE_MODE		BIT(12)
#define ISP3X_RAWAF_Y_MODE		BIT(13)

#define ISP3X_RAWAF_INELINE0(x)		((x) & 0xf)
#define ISP3X_RAWAF_INTLINE0_EN		BIT(27)

/* RAWAWB */
#define ISP32_RAWAWB_2DDR_PATH_EN	BIT(23)
#define ISP32_RAWAWB_2DDR_PATH_DS	BIT(27)
#define ISP32_RAWAWB_2DDR_PATH_ERR	BIT(29)

#endif /* _RKISP_REGS_V3X_H */
