/****************************************************************************** 
* 
* Copyright(c) 2007 - 2011 Realtek Corporation. All rights reserved. 
* 
* This program is free software; you can redistribute it and/or modify it 
* under the terms of version 2 of the GNU General Public License as 
* published by the Free Software Foundation. 
* 
* This program is distributed in the hope that it will be useful, but WITHOUT 
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
* more details. 
* 
* You should have received a copy of the GNU General Public License along with 
* this program; if not, write to the Free Software Foundation, Inc., 
* 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA 
* 
* 
******************************************************************************/

/*Image2HeaderVersion: 2.25*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8822B_SUPPORT == 1)
static BOOLEAN
CheckPositive(
	IN  PDM_ODM_T     pDM_Odm,
	IN  const u4Byte  Condition1,
	IN  const u4Byte  Condition2,
	IN	const u4Byte  Condition3,
	IN	const u4Byte  Condition4
)
{
	u1Byte    _BoardType = ((pDM_Odm->BoardType & BIT4) >> 4) << 0 | /* _GLNA*/
				((pDM_Odm->BoardType & BIT3) >> 3) << 1 | /* _GPA*/ 
				((pDM_Odm->BoardType & BIT7) >> 7) << 2 | /* _ALNA*/
				((pDM_Odm->BoardType & BIT6) >> 6) << 3 | /* _APA */
				((pDM_Odm->BoardType & BIT2) >> 2) << 4;  /* _BT*/  

	u4Byte	cond1   = Condition1, cond2 = Condition2, cond3 = Condition3, cond4 = Condition4;

	u1Byte	cut_version_for_para   = (pDM_Odm->CutVersion == ODM_CUT_A) ? 15 : pDM_Odm->CutVersion;
	u1Byte	pkg_type_for_para   = (pDM_Odm->PackageType == 0) ? 15 : pDM_Odm->PackageType;

	u4Byte    driver1 = cut_version_for_para       << 24 | 
				(pDM_Odm->SupportInterface & 0xF0) << 16 | 
				pDM_Odm->SupportPlatform  << 16 | 
				pkg_type_for_para      << 12 | 
				(pDM_Odm->SupportInterface & 0x0F) << 8  |
				_BoardType;

	u4Byte    driver2 = (pDM_Odm->TypeGLNA & 0xFF) <<  0 |  
				(pDM_Odm->TypeGPA & 0xFF)  <<  8 | 
				(pDM_Odm->TypeALNA & 0xFF) << 16 | 
				(pDM_Odm->TypeAPA & 0xFF)  << 24; 

u4Byte    driver3 = 0;

	u4Byte    driver4 = (pDM_Odm->TypeGLNA & 0xFF00) >>  8 |
				(pDM_Odm->TypeGPA & 0xFF00) |
				(pDM_Odm->TypeALNA & 0xFF00) << 8 |
				(pDM_Odm->TypeAPA & 0xFF00)  << 16;

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("===> CheckPositive (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n", cond1, cond2, cond3, cond4));
	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("===> CheckPositive (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n", driver1, driver2, driver3, driver4));

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("	(Platform, Interface) = (0x%X, 0x%X)\n", pDM_Odm->SupportPlatform, pDM_Odm->SupportInterface));
	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("	(Board, Package) = (0x%X, 0x%X)\n", pDM_Odm->BoardType, pDM_Odm->PackageType));


	/*============== Value Defined Check ===============*/
	/*QFN Type [15:12] and Cut Version [27:24] need to do value check*/
	
	if (((cond1 & 0x0000F000) != 0) && ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return FALSE;
	if (((cond1 & 0x0F000000) != 0) && ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return FALSE;

	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1   &= 0x00FF0FFF; 
	driver1 &= 0x00FF0FFF; 

	if ((cond1 & driver1) == cond1) {
		u4Byte bitMask = 0;

		if ((cond1 & 0x0F) == 0) /* BoardType is DONTCARE*/
			return TRUE;

		if ((cond1 & BIT0) != 0) /*GLNA*/
			bitMask |= 0x000000FF;
		if ((cond1 & BIT1) != 0) /*GPA*/
			bitMask |= 0x0000FF00;
		if ((cond1 & BIT2) != 0) /*ALNA*/
			bitMask |= 0x00FF0000;
		if ((cond1 & BIT3) != 0) /*APA*/
			bitMask |= 0xFF000000;

		if (((cond2 & bitMask) == (driver2 & bitMask)) && ((cond4 & bitMask) == (driver4 & bitMask)))  /* BoardType of each RF path is matched*/
			return TRUE;
		else
			return FALSE;
	} else
		return FALSE;
}
static BOOLEAN
CheckNegative(
	IN  PDM_ODM_T     pDM_Odm,
	IN  const u4Byte  Condition1,
	IN  const u4Byte  Condition2
)
{
	return TRUE;
}

/******************************************************************************
*                           RadioA.TXT
******************************************************************************/

u4Byte Array_MP_8822B_RadioA[] = { 
		0x000, 0x00030000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0xA0000000,	0x00000000,
		0x001, 0x00040029,
	0xB0000000,	0x00000000,
		0x018, 0x00010D24,
		0x0EF, 0x00080000,
		0x033, 0x00000002,
		0x03E, 0x0000003F,
		0x03F, 0x000C0F4E,
		0x033, 0x00000001,
		0x03E, 0x00000034,
		0x03F, 0x0004080E,
		0x0EF, 0x00080000,
		0x0DF, 0x00002449,
		0x033, 0x00000024,
		0x03E, 0x0000003F,
		0x03F, 0x00060FDE,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000025,
		0x03E, 0x00000037,
		0x03F, 0x0007EFCE,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000026,
		0x03E, 0x00000037,
		0x03F, 0x000DEFCE,
		0x0EF, 0x00000000,
		0x07F, 0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0xA0000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0xB0000000,	0x00000000,
		0x0B1, 0x0007DBE4,
		0x0B2, 0x000225D1,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C330,
	0xA0000000,	0x00000000,
		0x0B3, 0x000FC760,
	0xB0000000,	0x00000000,
		0x0B4, 0x00099DD0,
		0x0B5, 0x000400FC,
		0x0B6, 0x000187F0,
		0x0B7, 0x00030018,
		0x0B8, 0x00080800,
		0x0B9, 0x00000000,
		0x0BA, 0x00008000,
		0x0BB, 0x00000000,
		0x0BC, 0x00040030,
		0x0BD, 0x00000000,
		0x0BE, 0x00000000,
		0x0BF, 0x00000000,
		0x0C0, 0x00000000,
		0x0C1, 0x00000000,
		0x0C2, 0x00000000,
		0x0C3, 0x00000000,
		0x0C4, 0x00002402,
		0x0C5, 0x00000009,
		0x0C6, 0x00040299,
		0x0C7, 0x00055555,
		0x0C8, 0x0000C16C,
		0x0C9, 0x0001C140,
		0x0CA, 0x00000000,
		0x0CB, 0x00000000,
		0x0CC, 0x00000000,
		0x0CD, 0x00000000,
		0x0CE, 0x00090C00,
		0x0CF, 0x0006D200,
		0x0DF, 0x00000009,
		0x018, 0x00010524,
		0x089, 0x00000207,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x08A, 0x000FE186,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x08A, 0x000FE186,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FE186,
	0xA0000000,	0x00000000,
		0x08A, 0x000FF186,
	0xB0000000,	0x00000000,
		0x08B, 0x00061E3C,
		0x08C, 0x000112C7,
		0x08D, 0x000F4988,
		0x08E, 0x00064D40,
		0x0EF, 0x00020000,
		0x033, 0x00000007,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
	0xB0000000,	0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000DFF86,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0xA0000000,	0x00000000,
		0x03F, 0x000C3186,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0xA0000000,	0x00000000,
		0x03E, 0x00004080,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000005,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x000040C8,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x000040C8,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000040C8,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000040C8,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x000040C8,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004084,
	0xA0000000,	0x00000000,
		0x03E, 0x000040C8,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000004,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004190,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004190,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004190,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004190,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004190,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004108,
	0xA0000000,	0x00000000,
		0x03E, 0x00004190,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000003,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004998,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004998,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004998,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004998,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004998,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x0000490C,
	0xA0000000,	0x00000000,
		0x03E, 0x00004998,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000002,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00005840,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00005840,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005840,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005840,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00005840,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00005E00,
	0xA0000000,	0x00000000,
		0x03E, 0x00005840,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000001,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x000058C2,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x000058C2,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000058C2,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000058C2,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x000058C2,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00005862,
	0xA0000000,	0x00000000,
		0x03E, 0x000058C2,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00005930,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00005930,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005930,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005930,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00005930,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00005948,
	0xA0000000,	0x00000000,
		0x03E, 0x00005930,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x0000000F,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
	0xB0000000,	0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000DFF86,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000DFF86,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0xA0000000,	0x00000000,
		0x03F, 0x000C3186,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
		0x033, 0x0000000D,
		0x03E, 0x000040C8,
		0x03F, 0x000C3186,
		0x033, 0x0000000C,
		0x03E, 0x00004190,
		0x03F, 0x000C3186,
		0x033, 0x0000000B,
		0x03E, 0x00004998,
		0x03F, 0x000C3186,
		0x033, 0x0000000A,
		0x03E, 0x00005840,
		0x03F, 0x000C3186,
		0x033, 0x00000009,
		0x03E, 0x000058C2,
		0x03F, 0x000C3186,
		0x033, 0x00000008,
		0x03E, 0x00005930,
		0x03F, 0x000C3186,
		0x033, 0x00000017,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
	0xB0000000,	0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0xA0000000,	0x00000000,
		0x03F, 0x000C3186,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
		0x033, 0x00000015,
		0x03E, 0x000040C8,
		0x03F, 0x000C3186,
		0x033, 0x00000014,
		0x03E, 0x00004190,
		0x03F, 0x000C3186,
		0x033, 0x00000013,
		0x03E, 0x00004998,
		0x03F, 0x000C3186,
		0x033, 0x00000012,
		0x03E, 0x00005840,
		0x03F, 0x000C3186,
		0x033, 0x00000011,
		0x03E, 0x000058C2,
		0x03F, 0x000C3186,
		0x033, 0x00000010,
		0x03E, 0x00005930,
		0x03F, 0x000C3186,
		0x0EF, 0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000A,
		0x033, 0x00000001,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000006,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000005,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
		0x018, 0x00000401,
		0x084, 0x00001209,
		0x086, 0x000001A0,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0xA0000000,	0x00000000,
		0x087, 0x000E8180,
	0xB0000000,	0x00000000,
		0x088, 0x00070020,
		0x0DE, 0x00000010,
		0x0EF, 0x00008000,
		0x033, 0x0000000F,
		0x03F, 0x0000003C,
		0x033, 0x0000000E,
		0x03F, 0x00000038,
		0x033, 0x0000000D,
		0x03F, 0x00000030,
		0x033, 0x0000000C,
		0x03F, 0x00000028,
		0x033, 0x0000000B,
		0x03F, 0x00000020,
		0x033, 0x0000000A,
		0x03F, 0x00000018,
		0x033, 0x00000009,
		0x03F, 0x00000010,
		0x033, 0x00000008,
		0x03F, 0x00000008,
		0x033, 0x00000007,
		0x03F, 0x0000003C,
		0x033, 0x00000006,
		0x03F, 0x00000038,
		0x033, 0x00000005,
		0x03F, 0x00000030,
		0x033, 0x00000004,
		0x03F, 0x00000028,
		0x033, 0x00000003,
		0x03F, 0x00000020,
		0x033, 0x00000002,
		0x03F, 0x00000018,
		0x033, 0x00000001,
		0x03F, 0x00000010,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x0EF, 0x00000000,
		0x0B8, 0x00080A00,
		0x0B0, 0x000FF0FA,
		0x0FE, 0x00000000,
		0x0CA, 0x00080000,
		0x0C9, 0x0001C141,
		0x0FE, 0x00000000,
		0x0B0, 0x000FF0F8,
		0x018, 0x00018D24,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0x018, 0x00010D24,
		0x01B, 0x00075A40,
		0x0EE, 0x00000002,
		0x033, 0x00000000,
		0x03F, 0x00000004,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000004,
		0x033, 0x00000003,
		0x03F, 0x00000004,
		0x033, 0x00000004,
		0x03F, 0x00000004,
		0x033, 0x00000005,
		0x03F, 0x00000006,
		0x033, 0x00000006,
		0x03F, 0x00000002,
		0x033, 0x00000007,
		0x03F, 0x00000000,
		0x0EE, 0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D3D1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D3D1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D3D1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0xA0000000,	0x00000000,
		0x061, 0x0005D3D0,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0xB0000000,	0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A3,
		0x030, 0x000014A3,
		0x030, 0x000024A3,
		0x030, 0x000034A3,
		0x030, 0x000044A3,
		0x030, 0x000054A3,
		0x030, 0x000064A3,
		0x030, 0x000074A3,
		0x030, 0x000084A3,
		0x030, 0x000094A3,
		0x030, 0x0000A4A3,
		0x030, 0x0000B4A3,
		0x0EF, 0x00000000,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A3,
		0x030, 0x000014A3,
		0x030, 0x000024A3,
		0x030, 0x000034A3,
		0x030, 0x000044A3,
		0x030, 0x000054A3,
		0x030, 0x000064A3,
		0x030, 0x000074A3,
		0x030, 0x000084A3,
		0x030, 0x000094A3,
		0x030, 0x0000A4A3,
		0x030, 0x0000B4A3,
		0x0EF, 0x00000000,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A3,
		0x030, 0x000014A3,
		0x030, 0x000024A3,
		0x030, 0x000034A3,
		0x030, 0x000044A3,
		0x030, 0x000054A3,
		0x030, 0x000064A3,
		0x030, 0x000074A3,
		0x030, 0x000084A3,
		0x030, 0x000094A3,
		0x030, 0x0000A4A3,
		0x030, 0x0000B4A3,
		0x0EF, 0x00000000,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000002A6,
		0x030, 0x000012A6,
		0x030, 0x000022A6,
		0x030, 0x000032A6,
		0x030, 0x000042A6,
		0x030, 0x000052A6,
		0x030, 0x000062A6,
		0x030, 0x000072A6,
		0x030, 0x000082A6,
		0x030, 0x000092A6,
		0x030, 0x0000A2A6,
		0x030, 0x0000B2A6,
		0x0EF, 0x00000000,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
		0x0EF, 0x00000000,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
		0x0EF, 0x00000000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
		0x0EF, 0x00000000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000002A1,
		0x030, 0x000012A1,
		0x030, 0x000022A1,
		0x030, 0x000032A1,
		0x030, 0x000042A1,
		0x030, 0x000052A1,
		0x030, 0x000062A1,
		0x030, 0x000072A1,
		0x030, 0x000082A1,
		0x030, 0x000092A1,
		0x030, 0x0000A2A1,
		0x030, 0x0000B2A1,
		0x0EF, 0x00000000,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000002A6,
		0x030, 0x000012A6,
		0x030, 0x000022A6,
		0x030, 0x000032A6,
		0x030, 0x000042A6,
		0x030, 0x000052A6,
		0x030, 0x000062A6,
		0x030, 0x000072A6,
		0x030, 0x000082A6,
		0x030, 0x000092A6,
		0x030, 0x0000A2A6,
		0x030, 0x0000B2A6,
		0x0EF, 0x00000000,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x00000384,
		0x030, 0x00001384,
		0x030, 0x00002384,
		0x030, 0x00003384,
		0x030, 0x00004425,
		0x030, 0x00005425,
		0x030, 0x00006425,
		0x030, 0x00007425,
		0x030, 0x000083A4,
		0x030, 0x000093A4,
		0x030, 0x0000A3A4,
		0x030, 0x0000B3A4,
		0x0EF, 0x00000000,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000003A3,
		0x030, 0x000013A3,
		0x030, 0x000023A3,
		0x030, 0x000033A3,
		0x030, 0x00004355,
		0x030, 0x00005355,
		0x030, 0x00006355,
		0x030, 0x00007355,
		0x030, 0x00008314,
		0x030, 0x00009314,
		0x030, 0x0000A314,
		0x030, 0x0000B314,
		0x0EF, 0x00000000,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000003A1,
		0x030, 0x000013A1,
		0x030, 0x000023A1,
		0x030, 0x000033A1,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A5,
		0x030, 0x000093A5,
		0x030, 0x0000A3A5,
		0x030, 0x0000B3A5,
		0x0EF, 0x00000000,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000002A1,
		0x030, 0x000012A1,
		0x030, 0x000022A1,
		0x030, 0x000032A1,
		0x030, 0x000042A1,
		0x030, 0x000052A1,
		0x030, 0x000062A1,
		0x030, 0x000072A1,
		0x030, 0x000082A1,
		0x030, 0x000092A1,
		0x030, 0x0000A2A1,
		0x030, 0x0000B2A1,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x00000463,
		0x030, 0x00001463,
		0x030, 0x00002463,
		0x030, 0x00003463,
		0x030, 0x00004545,
		0x030, 0x00005545,
		0x030, 0x00006545,
		0x030, 0x00007545,
		0x030, 0x00008565,
		0x030, 0x00009565,
		0x030, 0x0000A565,
		0x030, 0x0000B565,
		0x0EF, 0x00000000,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x00000303,
		0x030, 0x00001303,
		0x030, 0x00002303,
		0x030, 0x00003303,
		0x030, 0x000043A4,
		0x030, 0x000053A4,
		0x030, 0x000063A4,
		0x030, 0x000073A4,
		0x030, 0x00008365,
		0x030, 0x00009365,
		0x030, 0x0000A365,
		0x030, 0x0000B365,
		0x0EF, 0x00000000,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x00004343,
		0x030, 0x00005343,
		0x030, 0x00006343,
		0x030, 0x00007343,
		0x030, 0x00008364,
		0x030, 0x00009364,
		0x030, 0x0000A364,
		0x030, 0x0000B364,
		0x0EF, 0x00000000,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000003A0,
		0x030, 0x000013A0,
		0x030, 0x000023A0,
		0x030, 0x000033A0,
		0x030, 0x00004430,
		0x030, 0x00005430,
		0x030, 0x00006430,
		0x030, 0x00007430,
		0x030, 0x00008372,
		0x030, 0x00009372,
		0x030, 0x0000A372,
		0x030, 0x0000B372,
		0x0EF, 0x00000000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000003A0,
		0x030, 0x000013A0,
		0x030, 0x000023A0,
		0x030, 0x000033A0,
		0x030, 0x000043A1,
		0x030, 0x000053A1,
		0x030, 0x000063A1,
		0x030, 0x000073A1,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000003D0,
		0x030, 0x000013D0,
		0x030, 0x000023D0,
		0x030, 0x000033D0,
		0x030, 0x000043D0,
		0x030, 0x000053D0,
		0x030, 0x000063D0,
		0x030, 0x000073D0,
		0x030, 0x000083D0,
		0x030, 0x000093D0,
		0x030, 0x0000A3D0,
		0x030, 0x0000B3D0,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A3,
		0x030, 0x000013A3,
		0x030, 0x000023A3,
		0x030, 0x000033A3,
		0x030, 0x000043A3,
		0x030, 0x000053A3,
		0x030, 0x000063A3,
		0x030, 0x000073A3,
		0x030, 0x000083A3,
		0x030, 0x000093A3,
		0x030, 0x0000A3A3,
		0x030, 0x0000B3A3,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000660,
		0x030, 0x00001443,
		0x030, 0x00002221,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000776,
		0x030, 0x00001455,
		0x030, 0x00002325,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000777,
		0x030, 0x00001442,
		0x030, 0x00002222,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000775,
		0x030, 0x00001343,
		0x030, 0x00002210,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000775,
		0x030, 0x00001422,
		0x030, 0x00002210,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000800,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x00000068,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x00000068,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x00000068,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C0C,
		0x033, 0x00000021,
		0x03F, 0x00000C29,
		0x033, 0x00000022,
		0x03F, 0x00000C2C,
		0x033, 0x00000023,
		0x03F, 0x00000C69,
		0x033, 0x00000024,
		0x03F, 0x00000CA8,
		0x033, 0x00000025,
		0x03F, 0x00000CE8,
		0x033, 0x00000026,
		0x03F, 0x00000CEB,
		0x033, 0x00000027,
		0x03F, 0x00000CEE,
		0x033, 0x00000028,
		0x03F, 0x00000CF1,
		0x033, 0x00000029,
		0x03F, 0x00000CF4,
		0x033, 0x0000002A,
		0x03F, 0x00000CF7,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042B,
		0x033, 0x00000021,
		0x03F, 0x0000082A,
		0x033, 0x00000022,
		0x03F, 0x00000849,
		0x033, 0x00000023,
		0x03F, 0x0000084C,
		0x033, 0x00000024,
		0x03F, 0x00000C4C,
		0x033, 0x00000025,
		0x03F, 0x00000CA9,
		0x033, 0x00000026,
		0x03F, 0x00000CEA,
		0x033, 0x00000027,
		0x03F, 0x00000CED,
		0x033, 0x00000028,
		0x03F, 0x00000CF0,
		0x033, 0x00000029,
		0x03F, 0x00000CF3,
		0x033, 0x0000002A,
		0x03F, 0x00000CF6,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x00000068,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000429,
		0x033, 0x00000021,
		0x03F, 0x00000828,
		0x033, 0x00000022,
		0x03F, 0x00000847,
		0x033, 0x00000023,
		0x03F, 0x0000084A,
		0x033, 0x00000024,
		0x03F, 0x00000C4B,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000CEA,
		0x033, 0x00000027,
		0x03F, 0x00000CED,
		0x033, 0x00000028,
		0x03F, 0x00000CF0,
		0x033, 0x00000029,
		0x03F, 0x00000CF3,
		0x033, 0x0000002A,
		0x03F, 0x00000CF6,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042B,
		0x033, 0x00000021,
		0x03F, 0x0000082A,
		0x033, 0x00000022,
		0x03F, 0x00000849,
		0x033, 0x00000023,
		0x03F, 0x0000084C,
		0x033, 0x00000024,
		0x03F, 0x00000C4C,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CEB,
		0x033, 0x00000028,
		0x03F, 0x00000CEE,
		0x033, 0x00000029,
		0x03F, 0x00000CF1,
		0x033, 0x0000002A,
		0x03F, 0x00000CF4,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042B,
		0x033, 0x00000021,
		0x03F, 0x0000082A,
		0x033, 0x00000022,
		0x03F, 0x00000849,
		0x033, 0x00000023,
		0x03F, 0x0000084C,
		0x033, 0x00000024,
		0x03F, 0x00000C4C,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CEB,
		0x033, 0x00000028,
		0x03F, 0x00000CEE,
		0x033, 0x00000029,
		0x03F, 0x00000CF1,
		0x033, 0x0000002A,
		0x03F, 0x00000CF4,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0xB0000000,	0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x00000068,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x00000068,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x00000068,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000080B,
		0x033, 0x00000061,
		0x03F, 0x0000080E,
		0x033, 0x00000062,
		0x03F, 0x00000848,
		0x033, 0x00000063,
		0x03F, 0x00000869,
		0x033, 0x00000064,
		0x03F, 0x000008A9,
		0x033, 0x00000065,
		0x03F, 0x00000CE8,
		0x033, 0x00000066,
		0x03F, 0x00000CEB,
		0x033, 0x00000067,
		0x03F, 0x00000CEE,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042B,
		0x033, 0x00000061,
		0x03F, 0x0000082A,
		0x033, 0x00000062,
		0x03F, 0x00000849,
		0x033, 0x00000063,
		0x03F, 0x0000084C,
		0x033, 0x00000064,
		0x03F, 0x00000C4C,
		0x033, 0x00000065,
		0x03F, 0x00000CA9,
		0x033, 0x00000066,
		0x03F, 0x00000CEA,
		0x033, 0x00000067,
		0x03F, 0x00000CED,
		0x033, 0x00000068,
		0x03F, 0x00000CF0,
		0x033, 0x00000069,
		0x03F, 0x00000CF3,
		0x033, 0x0000006A,
		0x03F, 0x00000CF6,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x00000068,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000429,
		0x033, 0x00000061,
		0x03F, 0x00000828,
		0x033, 0x00000062,
		0x03F, 0x00000847,
		0x033, 0x00000063,
		0x03F, 0x0000084A,
		0x033, 0x00000064,
		0x03F, 0x00000C4B,
		0x033, 0x00000065,
		0x03F, 0x00000C8A,
		0x033, 0x00000066,
		0x03F, 0x00000CEA,
		0x033, 0x00000067,
		0x03F, 0x00000CED,
		0x033, 0x00000068,
		0x03F, 0x00000CF0,
		0x033, 0x00000069,
		0x03F, 0x00000CF3,
		0x033, 0x0000006A,
		0x03F, 0x00000CF6,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042C,
		0x033, 0x00000061,
		0x03F, 0x0000082B,
		0x033, 0x00000062,
		0x03F, 0x0000084A,
		0x033, 0x00000063,
		0x03F, 0x0000084D,
		0x033, 0x00000064,
		0x03F, 0x00000C4D,
		0x033, 0x00000065,
		0x03F, 0x00000C8B,
		0x033, 0x00000066,
		0x03F, 0x00000C8E,
		0x033, 0x00000067,
		0x03F, 0x00000CEC,
		0x033, 0x00000068,
		0x03F, 0x00000CEF,
		0x033, 0x00000069,
		0x03F, 0x00000CF2,
		0x033, 0x0000006A,
		0x03F, 0x00000CF5,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042C,
		0x033, 0x00000061,
		0x03F, 0x0000082B,
		0x033, 0x00000062,
		0x03F, 0x0000084A,
		0x033, 0x00000063,
		0x03F, 0x0000084D,
		0x033, 0x00000064,
		0x03F, 0x00000C4D,
		0x033, 0x00000065,
		0x03F, 0x00000C8B,
		0x033, 0x00000066,
		0x03F, 0x00000C8E,
		0x033, 0x00000067,
		0x03F, 0x00000CEC,
		0x033, 0x00000068,
		0x03F, 0x00000CEF,
		0x033, 0x00000069,
		0x03F, 0x00000CF2,
		0x033, 0x0000006A,
		0x03F, 0x00000CF5,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0xB0000000,	0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x00000047,
		0x033, 0x000000A5,
		0x03F, 0x0000004A,
		0x033, 0x000000A6,
		0x03F, 0x0000004D,
		0x033, 0x000000A7,
		0x03F, 0x00000050,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x00000094,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x00000047,
		0x033, 0x000000A5,
		0x03F, 0x0000004A,
		0x033, 0x000000A6,
		0x03F, 0x0000004D,
		0x033, 0x000000A7,
		0x03F, 0x00000050,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x00000094,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x00000047,
		0x033, 0x000000A5,
		0x03F, 0x0000004A,
		0x033, 0x000000A6,
		0x03F, 0x0000004D,
		0x033, 0x000000A7,
		0x03F, 0x00000050,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x00000094,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C0A,
		0x033, 0x000000A1,
		0x03F, 0x00000C0D,
		0x033, 0x000000A2,
		0x03F, 0x00000C2A,
		0x033, 0x000000A3,
		0x03F, 0x00000C2D,
		0x033, 0x000000A4,
		0x03F, 0x00000C6A,
		0x033, 0x000000A5,
		0x03F, 0x00000CE8,
		0x033, 0x000000A6,
		0x03F, 0x00000CEB,
		0x033, 0x000000A7,
		0x03F, 0x00000CEE,
		0x033, 0x000000A8,
		0x03F, 0x00000CF1,
		0x033, 0x000000A9,
		0x03F, 0x00000CF4,
		0x033, 0x000000AA,
		0x03F, 0x00000CF7,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000042A,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x00000848,
		0x033, 0x000000A3,
		0x03F, 0x0000084B,
		0x033, 0x000000A4,
		0x03F, 0x00000C4C,
		0x033, 0x000000A5,
		0x03F, 0x00000CA9,
		0x033, 0x000000A6,
		0x03F, 0x00000CEA,
		0x033, 0x000000A7,
		0x03F, 0x00000CED,
		0x033, 0x000000A8,
		0x03F, 0x00000CF0,
		0x033, 0x000000A9,
		0x03F, 0x00000CF3,
		0x033, 0x000000AA,
		0x03F, 0x00000CF6,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C09,
		0x033, 0x000000A1,
		0x03F, 0x00000C0C,
		0x033, 0x000000A2,
		0x03F, 0x00000C0F,
		0x033, 0x000000A3,
		0x03F, 0x00000C2C,
		0x033, 0x000000A4,
		0x03F, 0x00000C2F,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000C90,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x00000047,
		0x033, 0x000000A5,
		0x03F, 0x0000004A,
		0x033, 0x000000A6,
		0x03F, 0x0000004D,
		0x033, 0x000000A7,
		0x03F, 0x00000050,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x00000094,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C09,
		0x033, 0x000000A1,
		0x03F, 0x00000C0C,
		0x033, 0x000000A2,
		0x03F, 0x00000C0F,
		0x033, 0x000000A3,
		0x03F, 0x00000C2C,
		0x033, 0x000000A4,
		0x03F, 0x00000C2F,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000C90,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000429,
		0x033, 0x000000A1,
		0x03F, 0x00000828,
		0x033, 0x000000A2,
		0x03F, 0x00000847,
		0x033, 0x000000A3,
		0x03F, 0x0000084A,
		0x033, 0x000000A4,
		0x03F, 0x00000C4B,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000CEA,
		0x033, 0x000000A7,
		0x03F, 0x00000CED,
		0x033, 0x000000A8,
		0x03F, 0x00000CF0,
		0x033, 0x000000A9,
		0x03F, 0x00000CF3,
		0x033, 0x000000AA,
		0x03F, 0x00000CF6,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C09,
		0x033, 0x000000A1,
		0x03F, 0x00000C0C,
		0x033, 0x000000A2,
		0x03F, 0x00000C0F,
		0x033, 0x000000A3,
		0x03F, 0x00000C2C,
		0x033, 0x000000A4,
		0x03F, 0x00000C2F,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000C90,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000042A,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x00000848,
		0x033, 0x000000A3,
		0x03F, 0x0000084B,
		0x033, 0x000000A4,
		0x03F, 0x00000C4C,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CEB,
		0x033, 0x000000A8,
		0x03F, 0x00000CEE,
		0x033, 0x000000A9,
		0x03F, 0x00000CF1,
		0x033, 0x000000AA,
		0x03F, 0x00000CF4,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000042A,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x00000848,
		0x033, 0x000000A3,
		0x03F, 0x0000084B,
		0x033, 0x000000A4,
		0x03F, 0x00000C4C,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CEB,
		0x033, 0x000000A8,
		0x03F, 0x00000CEE,
		0x033, 0x000000A9,
		0x03F, 0x00000CF1,
		0x033, 0x000000AA,
		0x03F, 0x00000CF4,
	0xA0000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C09,
		0x033, 0x000000A1,
		0x03F, 0x00000C0C,
		0x033, 0x000000A2,
		0x03F, 0x00000C0F,
		0x033, 0x000000A3,
		0x03F, 0x00000C2C,
		0x033, 0x000000A4,
		0x03F, 0x00000C2F,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000C90,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000400,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0xA0000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x000004BB,
		0x033, 0x00000001,
		0x03F, 0x000004BB,
		0x033, 0x00000002,
		0x03F, 0x000004BB,
		0x033, 0x00000003,
		0x03F, 0x000004BB,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000100,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0xA0000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000F34,
		0x033, 0x00000001,
		0x03F, 0x00000F34,
		0x033, 0x00000002,
		0x03F, 0x00000F34,
		0x033, 0x00000003,
		0x03F, 0x00000F34,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0xA0000000,	0x00000000,
		0x081, 0x0000F000,
		0x087, 0x00016040,
		0x051, 0x00000C00,
		0x052, 0x0007C241,
		0x053, 0x0001C069,
		0x054, 0x00078032,
		0x057, 0x0000CE0A,
		0x058, 0x00058750,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000800,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0xA0000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0005142C,
		0x033, 0x00000001,
		0x03F, 0x0005144B,
		0x033, 0x00000002,
		0x03F, 0x0005144E,
		0x033, 0x00000003,
		0x03F, 0x00051C69,
		0x033, 0x00000004,
		0x03F, 0x00051C6C,
		0x033, 0x00000005,
		0x03F, 0x00051C6F,
		0x033, 0x00000006,
		0x03F, 0x00051CEB,
		0x033, 0x00000007,
		0x03F, 0x00051CEE,
		0x033, 0x00000008,
		0x03F, 0x00051CF1,
		0x033, 0x00000009,
		0x03F, 0x00051CF4,
		0x033, 0x0000000A,
		0x03F, 0x00051CF7,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000010,
		0x033, 0x00000000,
		0x008, 0x0009C060,
		0x033, 0x00000001,
		0x008, 0x0009C060,
		0x0EF, 0x00000000,
		0x033, 0x000000A2,
		0x0EF, 0x00080000,
		0x03E, 0x0000593F,
		0x03F, 0x000C0F4F,
		0x0EF, 0x00000000,
		0x033, 0x000000A3,
		0x0EF, 0x00080000,
		0x03E, 0x00005934,
		0x03F, 0x0005AFCF,
		0x0EF, 0x00000000,

};

void
ODM_ReadAndConfig_MP_8822B_RadioA(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u1Byte     cCond;
	BOOLEAN bMatched = TRUE, bSkipped = FALSE;
	u4Byte     ArrayLen    = sizeof(Array_MP_8822B_RadioA)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8822B_RadioA;
	
	u4Byte	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8822B_RadioA\n"));

	while ((i + 1) < ArrayLen) {
		v1 = Array[i];
		v2 = Array[i + 1];

		if (v1 & (BIT31 | BIT30)) {/*positive & negative condition*/
			if (v1 & BIT31) {/* positive condition*/
				cCond  = (u1Byte)((v1 & (BIT29|BIT28)) >> 28);
				if (cCond == COND_ENDIF) {/*end*/
					bMatched = TRUE;
					bSkipped = FALSE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (cCond == COND_ELSE) { /*else*/
					bMatched = bSkipped?FALSE:TRUE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT30) { /*negative condition*/
				if (bSkipped == FALSE) {
					if (CheckPositive(pDM_Odm, pre_v1, pre_v2, v1, v2)) {
						bMatched = TRUE;
						bSkipped = TRUE;
					} else {
						bMatched = FALSE;
						bSkipped = FALSE;
					}
				} else
					bMatched = FALSE;
			}
		} else {
			if (bMatched)
				odm_ConfigRF_RadioA_8822B(pDM_Odm, v1, v2);
		}
		i = i + 2;
	}
}

u4Byte
ODM_GetVersion_MP_8822B_RadioA(void)
{
	   return 68;
}

/******************************************************************************
*                           RadioB.TXT
******************************************************************************/

u4Byte Array_MP_8822B_RadioB[] = { 
		0x000, 0x00030000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0xA0000000,	0x00000000,
		0x001, 0x00040029,
	0xB0000000,	0x00000000,
		0x018, 0x00010D24,
		0x0EF, 0x00080000,
		0x033, 0x00000002,
		0x03E, 0x0000003F,
		0x03F, 0x000C0F4E,
		0x033, 0x00000001,
		0x03E, 0x00000034,
		0x03F, 0x0004080E,
		0x0EF, 0x00080000,
		0x0DF, 0x00002449,
		0x033, 0x00000024,
		0x03E, 0x0000003F,
		0x03F, 0x00060FDE,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000025,
		0x03E, 0x00000037,
		0x03F, 0x0007EFCE,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000026,
		0x03E, 0x00000037,
		0x03F, 0x000DEFCE,
		0x0EF, 0x00000000,
		0x0DF, 0x00000009,
		0x018, 0x00010524,
		0x089, 0x00000207,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x08A, 0x000FE186,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x08A, 0x000FE186,
	0xA0000000,	0x00000000,
		0x08A, 0x000FF186,
	0xB0000000,	0x00000000,
		0x08B, 0x00061E3C,
		0x08C, 0x000112C7,
		0x08D, 0x000F4988,
		0x08E, 0x00064D40,
		0x0EF, 0x00020000,
		0x033, 0x00000007,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
	0xB0000000,	0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0xA0000000,	0x00000000,
		0x03F, 0x000C3186,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
		0x033, 0x00000005,
		0x03E, 0x000040C8,
		0x03F, 0x000C3186,
		0x033, 0x00000004,
		0x03E, 0x00004190,
		0x03F, 0x000C3186,
		0x033, 0x00000003,
		0x03E, 0x00004998,
		0x03F, 0x000C3186,
		0x033, 0x00000002,
		0x03E, 0x00005840,
		0x03F, 0x000C3186,
		0x033, 0x00000001,
		0x03E, 0x000058C2,
		0x03F, 0x000C3186,
		0x033, 0x00000000,
		0x03E, 0x00005930,
		0x03F, 0x000C3186,
		0x033, 0x0000000F,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
	0xB0000000,	0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0xA0000000,	0x00000000,
		0x03F, 0x000C3186,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
		0x033, 0x0000000D,
		0x03E, 0x000040C8,
		0x03F, 0x000C3186,
		0x033, 0x0000000C,
		0x03E, 0x00004190,
		0x03F, 0x000C3186,
		0x033, 0x0000000B,
		0x03E, 0x00004998,
		0x03F, 0x000C3186,
		0x033, 0x0000000A,
		0x03E, 0x00005840,
		0x03F, 0x000C3186,
		0x033, 0x00000009,
		0x03E, 0x000058C2,
		0x03F, 0x000C3186,
		0x033, 0x00000008,
		0x03E, 0x00005930,
		0x03F, 0x000C3186,
		0x033, 0x00000017,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
	0xB0000000,	0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000DFF86,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000DFF86,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0xA0000000,	0x00000000,
		0x03F, 0x000C3186,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
		0x033, 0x00000015,
		0x03E, 0x000040C8,
		0x03F, 0x000C3186,
		0x033, 0x00000014,
		0x03E, 0x00004190,
		0x03F, 0x000C3186,
		0x033, 0x00000013,
		0x03E, 0x00004998,
		0x03F, 0x000C3186,
		0x033, 0x00000012,
		0x03E, 0x00005840,
		0x03F, 0x000C3186,
		0x033, 0x00000011,
		0x03E, 0x000058C2,
		0x03F, 0x000C3186,
		0x033, 0x00000010,
		0x03E, 0x00005930,
		0x03F, 0x000C3186,
		0x0EF, 0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000A,
		0x033, 0x00000001,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000002,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000005,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
		0x018, 0x00000401,
		0x084, 0x00001209,
		0x086, 0x000001A0,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0xA0000000,	0x00000000,
		0x087, 0x000E8180,
	0xB0000000,	0x00000000,
		0x088, 0x00070020,
		0x0DE, 0x00000010,
		0x0EF, 0x00008000,
		0x033, 0x0000000F,
		0x03F, 0x0000003C,
		0x033, 0x0000000E,
		0x03F, 0x00000038,
		0x033, 0x0000000D,
		0x03F, 0x00000030,
		0x033, 0x0000000C,
		0x03F, 0x00000028,
		0x033, 0x0000000B,
		0x03F, 0x00000020,
		0x033, 0x0000000A,
		0x03F, 0x00000018,
		0x033, 0x00000009,
		0x03F, 0x00000010,
		0x033, 0x00000008,
		0x03F, 0x00000008,
		0x033, 0x00000007,
		0x03F, 0x0000003C,
		0x033, 0x00000006,
		0x03F, 0x00000038,
		0x033, 0x00000005,
		0x03F, 0x00000030,
		0x033, 0x00000004,
		0x03F, 0x00000028,
		0x033, 0x00000003,
		0x03F, 0x00000020,
		0x033, 0x00000002,
		0x03F, 0x00000018,
		0x033, 0x00000001,
		0x03F, 0x00000010,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x0EF, 0x00000000,
		0x018, 0x00018D24,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0x018, 0x00010D24,
		0x01B, 0x00075A40,
		0x0EE, 0x00000002,
		0x033, 0x00000000,
		0x03F, 0x00000004,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000004,
		0x033, 0x00000003,
		0x03F, 0x00000004,
		0x033, 0x00000004,
		0x03F, 0x00000004,
		0x033, 0x00000005,
		0x03F, 0x00000006,
		0x033, 0x00000006,
		0x03F, 0x00000002,
		0x033, 0x00000007,
		0x03F, 0x00000000,
		0x0EE, 0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D3D1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D3D1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D3D1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0xA0000000,	0x00000000,
		0x061, 0x0005D3D0,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000200,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x030, 0x000004A3,
		0x030, 0x000014A3,
		0x030, 0x000024A3,
		0x030, 0x000034A3,
		0x030, 0x000044A3,
		0x030, 0x000054A3,
		0x030, 0x000064A3,
		0x030, 0x000074A3,
		0x030, 0x000084A3,
		0x030, 0x000094A3,
		0x030, 0x0000A4A3,
		0x030, 0x0000B4A3,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x030, 0x000004A3,
		0x030, 0x000014A3,
		0x030, 0x000024A3,
		0x030, 0x000034A3,
		0x030, 0x000044A3,
		0x030, 0x000054A3,
		0x030, 0x000064A3,
		0x030, 0x000074A3,
		0x030, 0x000084A3,
		0x030, 0x000094A3,
		0x030, 0x0000A4A3,
		0x030, 0x0000B4A3,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000004A3,
		0x030, 0x000014A3,
		0x030, 0x000024A3,
		0x030, 0x000034A3,
		0x030, 0x000044A3,
		0x030, 0x000054A3,
		0x030, 0x000064A3,
		0x030, 0x000074A3,
		0x030, 0x000084A3,
		0x030, 0x000094A3,
		0x030, 0x0000A4A3,
		0x030, 0x0000B4A3,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000002A6,
		0x030, 0x000012A6,
		0x030, 0x000022A6,
		0x030, 0x000032A6,
		0x030, 0x000042A6,
		0x030, 0x000052A6,
		0x030, 0x000062A6,
		0x030, 0x000072A6,
		0x030, 0x000082A6,
		0x030, 0x000092A6,
		0x030, 0x0000A2A6,
		0x030, 0x0000B2A6,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000002A1,
		0x030, 0x000012A1,
		0x030, 0x000022A1,
		0x030, 0x000032A1,
		0x030, 0x000042A1,
		0x030, 0x000052A1,
		0x030, 0x000062A1,
		0x030, 0x000072A1,
		0x030, 0x000082A1,
		0x030, 0x000092A1,
		0x030, 0x0000A2A1,
		0x030, 0x0000B2A1,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000002A6,
		0x030, 0x000012A6,
		0x030, 0x000022A6,
		0x030, 0x000032A6,
		0x030, 0x000042A6,
		0x030, 0x000052A6,
		0x030, 0x000062A6,
		0x030, 0x000072A6,
		0x030, 0x000082A6,
		0x030, 0x000092A6,
		0x030, 0x0000A2A6,
		0x030, 0x0000B2A6,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000002F4,
		0x030, 0x000012F4,
		0x030, 0x000022F4,
		0x030, 0x000032F4,
		0x030, 0x00004365,
		0x030, 0x00005365,
		0x030, 0x00006365,
		0x030, 0x00007365,
		0x030, 0x000082A4,
		0x030, 0x000092A4,
		0x030, 0x0000A2A4,
		0x030, 0x0000B2A4,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000004A4,
		0x030, 0x000014A4,
		0x030, 0x000024A4,
		0x030, 0x000034A4,
		0x030, 0x000043A4,
		0x030, 0x000053A4,
		0x030, 0x000063A4,
		0x030, 0x000073A4,
		0x030, 0x000083A5,
		0x030, 0x000093A5,
		0x030, 0x0000A3A5,
		0x030, 0x0000B3A5,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A1,
		0x030, 0x000013A1,
		0x030, 0x000023A1,
		0x030, 0x000033A1,
		0x030, 0x000043A3,
		0x030, 0x000053A3,
		0x030, 0x000063A3,
		0x030, 0x000073A3,
		0x030, 0x000083A6,
		0x030, 0x000093A6,
		0x030, 0x0000A3A6,
		0x030, 0x0000B3A6,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000002A1,
		0x030, 0x000012A1,
		0x030, 0x000022A1,
		0x030, 0x000032A1,
		0x030, 0x000042A1,
		0x030, 0x000052A1,
		0x030, 0x000062A1,
		0x030, 0x000072A1,
		0x030, 0x000082A1,
		0x030, 0x000092A1,
		0x030, 0x0000A2A1,
		0x030, 0x0000B2A1,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000382,
		0x030, 0x00001382,
		0x030, 0x00002382,
		0x030, 0x00003382,
		0x030, 0x00004445,
		0x030, 0x00005445,
		0x030, 0x00006445,
		0x030, 0x00007445,
		0x030, 0x00008425,
		0x030, 0x00009425,
		0x030, 0x0000A425,
		0x030, 0x0000B425,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000303,
		0x030, 0x00001303,
		0x030, 0x00002303,
		0x030, 0x00003303,
		0x030, 0x000043A4,
		0x030, 0x000053A4,
		0x030, 0x000063A4,
		0x030, 0x000073A4,
		0x030, 0x00008365,
		0x030, 0x00009365,
		0x030, 0x0000A365,
		0x030, 0x0000B365,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A1,
		0x030, 0x000013A1,
		0x030, 0x000023A1,
		0x030, 0x000033A1,
		0x030, 0x00004364,
		0x030, 0x00005364,
		0x030, 0x00006364,
		0x030, 0x00007364,
		0x030, 0x00008564,
		0x030, 0x00009564,
		0x030, 0x0000A564,
		0x030, 0x0000B564,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000004A1,
		0x030, 0x000014A1,
		0x030, 0x000024A1,
		0x030, 0x000034A1,
		0x030, 0x000043A1,
		0x030, 0x000053A1,
		0x030, 0x000063A1,
		0x030, 0x000073A1,
		0x030, 0x000083A1,
		0x030, 0x000093A1,
		0x030, 0x0000A3A1,
		0x030, 0x0000B3A1,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000043A1,
		0x030, 0x000053A1,
		0x030, 0x000063A1,
		0x030, 0x000073A1,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0xA0000000,	0x00000000,
		0x030, 0x000002D0,
		0x030, 0x000012D0,
		0x030, 0x000022D0,
		0x030, 0x000032D0,
		0x030, 0x000042D0,
		0x030, 0x000052D0,
		0x030, 0x000062D0,
		0x030, 0x000072D0,
		0x030, 0x000082D0,
		0x030, 0x000092D0,
		0x030, 0x0000A2D0,
		0x030, 0x0000B2D0,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000080,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A3,
		0x030, 0x000013A3,
		0x030, 0x000023A3,
		0x030, 0x000033A3,
		0x030, 0x000043A4,
		0x030, 0x000053A4,
		0x030, 0x000063A4,
		0x030, 0x000073A4,
		0x030, 0x000083A3,
		0x030, 0x000093A3,
		0x030, 0x0000A3A3,
		0x030, 0x0000B3A3,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0xA0000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000040,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000660,
		0x030, 0x00001341,
		0x030, 0x00002220,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000764,
		0x030, 0x00001452,
		0x030, 0x00002220,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000777,
		0x030, 0x00001442,
		0x030, 0x00002222,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000775,
		0x030, 0x00001222,
		0x030, 0x00002210,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000775,
		0x030, 0x00001422,
		0x030, 0x00002210,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0xA0000000,	0x00000000,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000800,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x00000068,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x00000068,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x00000068,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000828,
		0x033, 0x00000021,
		0x03F, 0x0000082B,
		0x033, 0x00000022,
		0x03F, 0x00000868,
		0x033, 0x00000023,
		0x03F, 0x00000889,
		0x033, 0x00000024,
		0x03F, 0x000008AA,
		0x033, 0x00000025,
		0x03F, 0x00000CE8,
		0x033, 0x00000026,
		0x03F, 0x00000CEB,
		0x033, 0x00000027,
		0x03F, 0x00000CEE,
		0x033, 0x00000028,
		0x03F, 0x00000CF1,
		0x033, 0x00000029,
		0x03F, 0x00000CF4,
		0x033, 0x0000002A,
		0x03F, 0x00000CF7,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042A,
		0x033, 0x00000021,
		0x03F, 0x00000829,
		0x033, 0x00000022,
		0x03F, 0x00000848,
		0x033, 0x00000023,
		0x03F, 0x0000084B,
		0x033, 0x00000024,
		0x03F, 0x00000C4C,
		0x033, 0x00000025,
		0x03F, 0x00000C8B,
		0x033, 0x00000026,
		0x03F, 0x00000CEA,
		0x033, 0x00000027,
		0x03F, 0x00000CED,
		0x033, 0x00000028,
		0x03F, 0x00000CF0,
		0x033, 0x00000029,
		0x03F, 0x00000CF3,
		0x033, 0x0000002A,
		0x03F, 0x00000CF6,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x00000068,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000429,
		0x033, 0x00000021,
		0x03F, 0x00000828,
		0x033, 0x00000022,
		0x03F, 0x00000847,
		0x033, 0x00000023,
		0x03F, 0x0000084A,
		0x033, 0x00000024,
		0x03F, 0x00000C4B,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000CEA,
		0x033, 0x00000027,
		0x03F, 0x00000CED,
		0x033, 0x00000028,
		0x03F, 0x00000CF0,
		0x033, 0x00000029,
		0x03F, 0x00000CF3,
		0x033, 0x0000002A,
		0x03F, 0x00000CF6,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042B,
		0x033, 0x00000021,
		0x03F, 0x0000082A,
		0x033, 0x00000022,
		0x03F, 0x00000849,
		0x033, 0x00000023,
		0x03F, 0x0000084C,
		0x033, 0x00000024,
		0x03F, 0x00000C4C,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CEB,
		0x033, 0x00000028,
		0x03F, 0x00000CEE,
		0x033, 0x00000029,
		0x03F, 0x00000CF1,
		0x033, 0x0000002A,
		0x03F, 0x00000CF4,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042B,
		0x033, 0x00000021,
		0x03F, 0x0000082A,
		0x033, 0x00000022,
		0x03F, 0x00000849,
		0x033, 0x00000023,
		0x03F, 0x0000084C,
		0x033, 0x00000024,
		0x03F, 0x00000C4C,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CEB,
		0x033, 0x00000028,
		0x03F, 0x00000CEE,
		0x033, 0x00000029,
		0x03F, 0x00000CF1,
		0x033, 0x0000002A,
		0x03F, 0x00000CF4,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0xB0000000,	0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x00000068,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x00000068,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x00000068,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000842,
		0x033, 0x00000061,
		0x03F, 0x00000845,
		0x033, 0x00000062,
		0x03F, 0x00000866,
		0x033, 0x00000063,
		0x03F, 0x000008A6,
		0x033, 0x00000064,
		0x03F, 0x000008C8,
		0x033, 0x00000065,
		0x03F, 0x00000CE8,
		0x033, 0x00000066,
		0x03F, 0x00000CEB,
		0x033, 0x00000067,
		0x03F, 0x00000CEE,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042A,
		0x033, 0x00000061,
		0x03F, 0x00000829,
		0x033, 0x00000062,
		0x03F, 0x00000848,
		0x033, 0x00000063,
		0x03F, 0x0000084B,
		0x033, 0x00000064,
		0x03F, 0x00000C69,
		0x033, 0x00000065,
		0x03F, 0x00000CA9,
		0x033, 0x00000066,
		0x03F, 0x00000CEA,
		0x033, 0x00000067,
		0x03F, 0x00000CED,
		0x033, 0x00000068,
		0x03F, 0x00000CF0,
		0x033, 0x00000069,
		0x03F, 0x00000CF3,
		0x033, 0x0000006A,
		0x03F, 0x00000CF6,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x00000068,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000429,
		0x033, 0x00000061,
		0x03F, 0x00000828,
		0x033, 0x00000062,
		0x03F, 0x00000847,
		0x033, 0x00000063,
		0x03F, 0x0000084A,
		0x033, 0x00000064,
		0x03F, 0x00000C4B,
		0x033, 0x00000065,
		0x03F, 0x00000C8A,
		0x033, 0x00000066,
		0x03F, 0x00000CEA,
		0x033, 0x00000067,
		0x03F, 0x00000CED,
		0x033, 0x00000068,
		0x03F, 0x00000CF0,
		0x033, 0x00000069,
		0x03F, 0x00000CF3,
		0x033, 0x0000006A,
		0x03F, 0x00000CF6,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042C,
		0x033, 0x00000061,
		0x03F, 0x0000082B,
		0x033, 0x00000062,
		0x03F, 0x0000084A,
		0x033, 0x00000063,
		0x03F, 0x0000084D,
		0x033, 0x00000064,
		0x03F, 0x00000C4E,
		0x033, 0x00000065,
		0x03F, 0x00000C8C,
		0x033, 0x00000066,
		0x03F, 0x00000C8F,
		0x033, 0x00000067,
		0x03F, 0x00000CEC,
		0x033, 0x00000068,
		0x03F, 0x00000CEF,
		0x033, 0x00000069,
		0x03F, 0x00000CF2,
		0x033, 0x0000006A,
		0x03F, 0x00000CF5,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042C,
		0x033, 0x00000061,
		0x03F, 0x0000082B,
		0x033, 0x00000062,
		0x03F, 0x0000084A,
		0x033, 0x00000063,
		0x03F, 0x0000084D,
		0x033, 0x00000064,
		0x03F, 0x00000C4E,
		0x033, 0x00000065,
		0x03F, 0x00000C8C,
		0x033, 0x00000066,
		0x03F, 0x00000C8F,
		0x033, 0x00000067,
		0x03F, 0x00000CEC,
		0x033, 0x00000068,
		0x03F, 0x00000CEF,
		0x033, 0x00000069,
		0x03F, 0x00000CF2,
		0x033, 0x0000006A,
		0x03F, 0x00000CF5,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0xB0000000,	0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x00000047,
		0x033, 0x000000A5,
		0x03F, 0x0000004A,
		0x033, 0x000000A6,
		0x03F, 0x0000004D,
		0x033, 0x000000A7,
		0x03F, 0x00000050,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x00000094,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x00000047,
		0x033, 0x000000A5,
		0x03F, 0x0000004A,
		0x033, 0x000000A6,
		0x03F, 0x0000004D,
		0x033, 0x000000A7,
		0x03F, 0x00000050,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x00000094,
	0x9300200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x00000047,
		0x033, 0x000000A5,
		0x03F, 0x0000004A,
		0x033, 0x000000A6,
		0x03F, 0x0000004D,
		0x033, 0x000000A7,
		0x03F, 0x00000050,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x00000094,
	0x93012100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000826,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x0000082C,
		0x033, 0x000000A3,
		0x03F, 0x0000082F,
		0x033, 0x000000A4,
		0x03F, 0x0000086C,
		0x033, 0x000000A5,
		0x03F, 0x00000CE8,
		0x033, 0x000000A6,
		0x03F, 0x00000CEB,
		0x033, 0x000000A7,
		0x03F, 0x00000CEE,
		0x033, 0x000000A8,
		0x03F, 0x00000CF1,
		0x033, 0x000000A9,
		0x03F, 0x00000CF4,
		0x033, 0x000000AA,
		0x03F, 0x00000CF7,
	0x93002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000042A,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x00000848,
		0x033, 0x000000A3,
		0x03F, 0x0000084B,
		0x033, 0x000000A4,
		0x03F, 0x00000C4C,
		0x033, 0x000000A5,
		0x03F, 0x00000CA9,
		0x033, 0x000000A6,
		0x03F, 0x00000CEA,
		0x033, 0x000000A7,
		0x03F, 0x00000CED,
		0x033, 0x000000A8,
		0x03F, 0x00000CF0,
		0x033, 0x000000A9,
		0x03F, 0x00000CF3,
		0x033, 0x000000AA,
		0x03F, 0x00000CF6,
	0x93011000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C09,
		0x033, 0x000000A1,
		0x03F, 0x00000C0C,
		0x033, 0x000000A2,
		0x03F, 0x00000C0F,
		0x033, 0x000000A3,
		0x03F, 0x00000C2C,
		0x033, 0x000000A4,
		0x03F, 0x00000C2F,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000C90,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x00000047,
		0x033, 0x000000A5,
		0x03F, 0x0000004A,
		0x033, 0x000000A6,
		0x03F, 0x0000004D,
		0x033, 0x000000A7,
		0x03F, 0x00000050,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x00000094,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C09,
		0x033, 0x000000A1,
		0x03F, 0x00000C0C,
		0x033, 0x000000A2,
		0x03F, 0x00000C0F,
		0x033, 0x000000A3,
		0x03F, 0x00000C2C,
		0x033, 0x000000A4,
		0x03F, 0x00000C2F,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000C90,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x93002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000429,
		0x033, 0x000000A1,
		0x03F, 0x00000828,
		0x033, 0x000000A2,
		0x03F, 0x00000847,
		0x033, 0x000000A3,
		0x03F, 0x0000084A,
		0x033, 0x000000A4,
		0x03F, 0x00000C4B,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000CEA,
		0x033, 0x000000A7,
		0x03F, 0x00000CED,
		0x033, 0x000000A8,
		0x03F, 0x00000CF0,
		0x033, 0x000000A9,
		0x03F, 0x00000CF3,
		0x033, 0x000000AA,
		0x03F, 0x00000CF6,
	0x93001000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C09,
		0x033, 0x000000A1,
		0x03F, 0x00000C0C,
		0x033, 0x000000A2,
		0x03F, 0x00000C0F,
		0x033, 0x000000A3,
		0x03F, 0x00000C2C,
		0x033, 0x000000A4,
		0x03F, 0x00000C2F,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000C90,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000042A,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x00000848,
		0x033, 0x000000A3,
		0x03F, 0x0000084B,
		0x033, 0x000000A4,
		0x03F, 0x00000C4C,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CEC,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000042A,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x00000848,
		0x033, 0x000000A3,
		0x03F, 0x0000084B,
		0x033, 0x000000A4,
		0x03F, 0x00000C4C,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CEC,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0xA0000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C09,
		0x033, 0x000000A1,
		0x03F, 0x00000C0C,
		0x033, 0x000000A2,
		0x03F, 0x00000C0F,
		0x033, 0x000000A3,
		0x03F, 0x00000C2C,
		0x033, 0x000000A4,
		0x03F, 0x00000C2F,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000C90,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000400,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0xA0000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x000004BB,
		0x033, 0x00000001,
		0x03F, 0x000004BB,
		0x033, 0x00000002,
		0x03F, 0x000004BB,
		0x033, 0x00000003,
		0x03F, 0x000004BB,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000100,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0xA0000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000F34,
		0x033, 0x00000001,
		0x03F, 0x00000F34,
		0x033, 0x00000002,
		0x03F, 0x00000F34,
		0x033, 0x00000003,
		0x03F, 0x00000F34,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0xA0000000,	0x00000000,
		0x081, 0x0000F000,
		0x087, 0x00016040,
		0x051, 0x00000C00,
		0x052, 0x0007C241,
		0x053, 0x0001C069,
		0x054, 0x00078032,
		0x057, 0x0000CE0A,
		0x058, 0x00058750,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000800,
	0x8300100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x9300100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x9300100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x9300200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x9000100f,	0x0a0a0a0a,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x9000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0xA0000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0005142C,
		0x033, 0x00000001,
		0x03F, 0x0005142F,
		0x033, 0x00000002,
		0x03F, 0x00051432,
		0x033, 0x00000003,
		0x03F, 0x00051C87,
		0x033, 0x00000004,
		0x03F, 0x00051C8A,
		0x033, 0x00000005,
		0x03F, 0x00051C8D,
		0x033, 0x00000006,
		0x03F, 0x00051CEB,
		0x033, 0x00000007,
		0x03F, 0x00051CEE,
		0x033, 0x00000008,
		0x03F, 0x00051CF1,
		0x033, 0x00000009,
		0x03F, 0x00051CF4,
		0x033, 0x0000000A,
		0x03F, 0x00051CF7,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000010,
		0x033, 0x00000000,
		0x008, 0x0009C060,
		0x033, 0x00000001,
		0x008, 0x0009C060,
		0x0EF, 0x00000000,
		0x033, 0x000000A2,
		0x0EF, 0x00080000,
		0x03E, 0x0000593F,
		0x03F, 0x000C0F4F,
		0x0EF, 0x00000000,
		0x033, 0x000000A3,
		0x0EF, 0x00080000,
		0x03E, 0x00005934,
		0x03F, 0x0005AFCF,
		0x0EF, 0x00000000,

};

void
ODM_ReadAndConfig_MP_8822B_RadioB(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u1Byte     cCond;
	BOOLEAN bMatched = TRUE, bSkipped = FALSE;
	u4Byte     ArrayLen    = sizeof(Array_MP_8822B_RadioB)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8822B_RadioB;
	
	u4Byte	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8822B_RadioB\n"));

	while ((i + 1) < ArrayLen) {
		v1 = Array[i];
		v2 = Array[i + 1];

		if (v1 & (BIT31 | BIT30)) {/*positive & negative condition*/
			if (v1 & BIT31) {/* positive condition*/
				cCond  = (u1Byte)((v1 & (BIT29|BIT28)) >> 28);
				if (cCond == COND_ENDIF) {/*end*/
					bMatched = TRUE;
					bSkipped = FALSE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (cCond == COND_ELSE) { /*else*/
					bMatched = bSkipped?FALSE:TRUE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT30) { /*negative condition*/
				if (bSkipped == FALSE) {
					if (CheckPositive(pDM_Odm, pre_v1, pre_v2, v1, v2)) {
						bMatched = TRUE;
						bSkipped = TRUE;
					} else {
						bMatched = FALSE;
						bSkipped = FALSE;
					}
				} else
					bMatched = FALSE;
			}
		} else {
			if (bMatched)
				odm_ConfigRF_RadioB_8822B(pDM_Odm, v1, v2);
		}
		i = i + 2;
	}
}

u4Byte
ODM_GetVersion_MP_8822B_RadioB(void)
{
	   return 68;
}

/******************************************************************************
*                           TxPowerTrack.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 2, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 19, 19, 19, 19},
	{0, 1, 2, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 17, 18, 18, 18, 18, 18, 18},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 12, 13, 14, 15, 15, 16, 16, 17, 17, 17, 17, 17, 17},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 9, 10, 11, 11, 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 20, 20, 20, 20},
	{0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 11, 11, 12, 13, 14, 15, 16, 16, 17, 17, 18, 18, 18, 18},
	{0, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 11, 12, 12, 13, 14, 15, 15, 16, 17, 17, 18, 18, 18, 18, 18},
};
u1Byte gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_8822B[]    = {0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_8822B[]    = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_8822B[]    = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_8822B[]    = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_8822B[] = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_8822B[] = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_8822B[] = {0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_8822B[] = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void
ODM_ReadAndConfig_MP_8822B_TxPowerTrack(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_MP_8822B\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_P, gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_N, gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_P, gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_N, gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_P, gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_N, gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           TxPowerTrack_type0.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_type0_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_type0_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 12, 13, 14, 14, 15, 15, 15, 16, 16},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_type0_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_type0_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
};
u1Byte gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_type0_8822B[]    = {0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_type0_8822B[]    = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_type0_8822B[]    = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_type0_8822B[]    = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_type0_8822B[] = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_type0_8822B[] = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_type0_8822B[] = {0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_type0_8822B[] = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void
ODM_ReadAndConfig_MP_8822B_TxPowerTrack_type0(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_MP_8822B\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_type0_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_type0_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_P, gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_type0_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_N, gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_type0_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_type0_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_type0_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_P, gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_type0_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_N, gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_type0_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_type0_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_type0_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_P, gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_type0_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_N, gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_type0_8822B, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           TxPowerTrack_type1.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_type1_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 2, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_type1_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 19, 19, 19, 19},
	{0, 1, 2, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 17, 18, 18, 18, 18, 18, 18},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 12, 13, 14, 15, 15, 16, 16, 17, 17, 17, 17, 17, 17},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_type1_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 9, 10, 11, 11, 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_type1_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 20, 20, 20, 20},
	{0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 11, 11, 12, 13, 14, 15, 16, 16, 17, 17, 18, 18, 18, 18},
	{0, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 11, 12, 12, 13, 14, 15, 15, 16, 17, 17, 18, 18, 18, 18, 18},
};
u1Byte gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_type1_8822B[]    = {0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_type1_8822B[]    = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_type1_8822B[]    = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_type1_8822B[]    = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_type1_8822B[] = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_type1_8822B[] = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_type1_8822B[] = {0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_type1_8822B[] = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void
ODM_ReadAndConfig_MP_8822B_TxPowerTrack_type1(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_MP_8822B\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_type1_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_type1_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_P, gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_type1_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_N, gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_type1_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_type1_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_type1_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_P, gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_type1_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_N, gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_type1_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_type1_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_type1_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_P, gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_type1_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_N, gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_type1_8822B, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           TxPowerTrack_type10.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_type10_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_type10_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 12, 13, 14, 14, 15, 15, 15, 16, 16},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_type10_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_type10_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
};
u1Byte gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_type10_8822B[]    = {0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_type10_8822B[]    = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_type10_8822B[]    = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_type10_8822B[]    = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_type10_8822B[] = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_type10_8822B[] = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_type10_8822B[] = {0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_type10_8822B[] = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void
ODM_ReadAndConfig_MP_8822B_TxPowerTrack_type10(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_MP_8822B\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_type10_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_type10_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_P, gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_type10_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_N, gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_type10_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_type10_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_type10_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_P, gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_type10_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_N, gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_type10_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_type10_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_type10_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_P, gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_type10_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_N, gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_type10_8822B, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           TxPowerTrack_type2.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_type2_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_type2_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_type2_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_type2_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
};
u1Byte gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_type2_8822B[]    = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_type2_8822B[]    = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u1Byte gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_type2_8822B[]    = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_type2_8822B[]    = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_type2_8822B[] = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_type2_8822B[] = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_type2_8822B[] = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_type2_8822B[] = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};

void
ODM_ReadAndConfig_MP_8822B_TxPowerTrack_type2(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_MP_8822B\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_type2_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_type2_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_P, gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_type2_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_N, gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_type2_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_type2_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_type2_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_P, gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_type2_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_N, gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_type2_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_type2_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_type2_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_P, gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_type2_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_N, gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_type2_8822B, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           TxPowerTrack_Type3_Type5.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_Type3_Type5_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_Type3_Type5_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_Type3_Type5_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_Type3_Type5_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};
u1Byte gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_Type3_Type5_8822B[]    = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_Type3_Type5_8822B[]    = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u1Byte gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_Type3_Type5_8822B[]    = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_Type3_Type5_8822B[]    = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_Type3_Type5_8822B[] = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_Type3_Type5_8822B[] = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_Type3_Type5_8822B[] = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_Type3_Type5_8822B[] = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};

void
ODM_ReadAndConfig_MP_8822B_TxPowerTrack_Type3_Type5(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_MP_8822B\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_P, gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_N, gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_P, gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_N, gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_P, gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_N, gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           TxPowerTrack_type4.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_type4_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_type4_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_type4_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_type4_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
};
u1Byte gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_type4_8822B[]    = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_type4_8822B[]    = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u1Byte gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_type4_8822B[]    = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_type4_8822B[]    = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_type4_8822B[] = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_type4_8822B[] = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_type4_8822B[] = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_type4_8822B[] = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};

void
ODM_ReadAndConfig_MP_8822B_TxPowerTrack_type4(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_MP_8822B\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_type4_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_type4_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_P, gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_type4_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_N, gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_type4_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_type4_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_type4_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_P, gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_type4_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_N, gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_type4_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_type4_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_type4_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_P, gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_type4_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_N, gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_type4_8822B, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           TxPowerTrack_type6.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_type6_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
	{0, 1, 2, 3, 4, 5, 5, 6, 7, 7, 8, 9, 9, 10, 10, 11, 12, 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
	{0, 1, 2, 3, 4, 4, 5, 5, 6, 7, 8, 9, 10, 11, 12, 12, 13, 13, 14, 15, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_type6_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 19, 19, 19, 19},
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 9, 9, 11, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 20, 21, 21, 21, 21, 21, 21},
	{0, 1, 2, 3, 4, 5, 6, 6, 7, 7, 8, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 20, 20, 21, 21, 21},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_type6_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 12, 13, 14, 14, 15, 15, 16, 16, 16, 17, 17, 17, 17, 17},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 8, 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15, 15, 15, 15},
	{0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_type6_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13, 14, 15, 15, 16, 17, 18, 19, 20, 20, 21, 21, 21, 21, 21},
	{0, 1, 2, 2, 3, 4, 4, 5, 7, 7, 8, 9, 10, 11, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 19, 19, 20, 20, 21, 21},
	{0, 1, 2, 3, 3, 4, 5, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 19, 20, 20, 20, 20, 20},
};
u1Byte gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_type6_8822B[]    = {0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_type6_8822B[]    = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_type6_8822B[]    = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_type6_8822B[]    = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_type6_8822B[] = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_type6_8822B[] = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_type6_8822B[] = {0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_type6_8822B[] = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void
ODM_ReadAndConfig_MP_8822B_TxPowerTrack_type6(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_MP_8822B\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_type6_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_type6_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_P, gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_type6_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_N, gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_type6_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_type6_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_type6_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_P, gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_type6_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_N, gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_type6_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_type6_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_type6_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_P, gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_type6_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_N, gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_type6_8822B, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           TxPowerTrack_type7.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_type7_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
	{0, 1, 2, 3, 4, 5, 5, 6, 7, 7, 8, 9, 9, 10, 10, 11, 12, 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
	{0, 1, 2, 3, 4, 4, 5, 5, 6, 7, 8, 9, 10, 11, 12, 12, 13, 13, 14, 15, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_type7_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 19, 19, 19, 19},
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 9, 9, 11, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 20, 21, 21, 21, 21, 21, 21},
	{0, 1, 2, 3, 4, 5, 6, 6, 7, 7, 8, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 20, 20, 21, 21, 21},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_type7_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 12, 13, 14, 14, 15, 15, 16, 16, 16, 17, 17, 17, 17, 17},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 8, 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15, 15, 15, 15},
	{0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_type7_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13, 14, 15, 15, 16, 17, 18, 19, 20, 20, 21, 21, 21, 21, 21},
	{0, 1, 2, 2, 3, 4, 4, 5, 7, 7, 8, 9, 10, 11, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 19, 19, 20, 20, 21, 21},
	{0, 1, 2, 3, 3, 4, 5, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 19, 20, 20, 20, 20, 20},
};
u1Byte gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_type7_8822B[]    = {0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_type7_8822B[]    = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_type7_8822B[]    = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_type7_8822B[]    = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_type7_8822B[] = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_type7_8822B[] = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_type7_8822B[] = {0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_type7_8822B[] = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void
ODM_ReadAndConfig_MP_8822B_TxPowerTrack_type7(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_MP_8822B\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_type7_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_type7_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_P, gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_type7_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_N, gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_type7_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_type7_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_type7_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_P, gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_type7_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_N, gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_type7_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_type7_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_type7_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_P, gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_type7_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_N, gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_type7_8822B, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           TxPowerTrack_Type8.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_Type8_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_Type8_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_Type8_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_Type8_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};
u1Byte gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_Type8_8822B[]    = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_Type8_8822B[]    = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u1Byte gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_Type8_8822B[]    = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_Type8_8822B[]    = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_Type8_8822B[] = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_Type8_8822B[] = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_Type8_8822B[] = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_Type8_8822B[] = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};

void
ODM_ReadAndConfig_MP_8822B_TxPowerTrack_Type8(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_MP_8822B\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_Type8_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_Type8_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_P, gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_Type8_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_N, gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_Type8_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_Type8_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_Type8_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_P, gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_Type8_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_N, gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_Type8_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_Type8_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_Type8_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_P, gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_Type8_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_N, gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_Type8_8822B, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           TxPowerTrack_type9.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_type9_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_type9_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 12, 13, 14, 14, 15, 15, 15, 16, 16},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_type9_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_type9_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
};
u1Byte gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_type9_8822B[]    = {0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_type9_8822B[]    = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_type9_8822B[]    = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_type9_8822B[]    = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_type9_8822B[] = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_type9_8822B[] = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_type9_8822B[] = {0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_type9_8822B[] = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void
ODM_ReadAndConfig_MP_8822B_TxPowerTrack_type9(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_MP_8822B\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_type9_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_type9_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_P, gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_type9_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_N, gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_type9_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_type9_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_type9_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_P, gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_type9_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_N, gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_type9_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_type9_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_type9_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_P, gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_type9_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_N, gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_type9_8822B, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           TXPWR_LMT.TXT
******************************************************************************/

const char *Array_MP_8822B_TXPWR_LMT[] = { 
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "26", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "20", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "28",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "26", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "30", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "32", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "34", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "34", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "34", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "34", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "34", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "32", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "30", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "28", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "22", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "14", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "26", 
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "01", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "30", 
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "02", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "32", 
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "34", 
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "34", 
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "34", 
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "34", 
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "34", 
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "32", 
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "30", 
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "26", 
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "20", 
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "12", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "14", 
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "13", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "26", 
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "01", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "28", 
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "02", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "30", 
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "30", 
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "32", 
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "32", 
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "32", 
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "30", 
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "30", 
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "28", 
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "26", 
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "20", 
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "12", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "14", 
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "13", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "26", 
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "26", 
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "30", 
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "32", 
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "30", 
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "26", 
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "26", 
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "20", 
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "14", 
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "24", 
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "24", 
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "26", 
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "28", 
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "26", 
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "26", 
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "26", 
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "20", 
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "14", 
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "36", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "40", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "44", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "48", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "52", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "56", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "60", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "28", 
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "64", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "26", 
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "100", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "104", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "108", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "112", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "116", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "120", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "124", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "128", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "132", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "136", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "28", 
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "140", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "28", 
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "144", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "63", 
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "63", 
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "63", 
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "63", 
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "63", 
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "36", "32", 
	"MKK", "5G", "20M", "HT", "1T", "36", "28",
	"FCC", "5G", "20M", "HT", "1T", "40", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "40", "32", 
	"MKK", "5G", "20M", "HT", "1T", "40", "28",
	"FCC", "5G", "20M", "HT", "1T", "44", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "44", "32", 
	"MKK", "5G", "20M", "HT", "1T", "44", "28",
	"FCC", "5G", "20M", "HT", "1T", "48", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "48", "32", 
	"MKK", "5G", "20M", "HT", "1T", "48", "28",
	"FCC", "5G", "20M", "HT", "1T", "52", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "52", "32", 
	"MKK", "5G", "20M", "HT", "1T", "52", "28",
	"FCC", "5G", "20M", "HT", "1T", "56", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "56", "32", 
	"MKK", "5G", "20M", "HT", "1T", "56", "28",
	"FCC", "5G", "20M", "HT", "1T", "60", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "60", "32", 
	"MKK", "5G", "20M", "HT", "1T", "60", "28",
	"FCC", "5G", "20M", "HT", "1T", "64", "28", 
	"ETSI", "5G", "20M", "HT", "1T", "64", "32", 
	"MKK", "5G", "20M", "HT", "1T", "64", "28",
	"FCC", "5G", "20M", "HT", "1T", "100", "26", 
	"ETSI", "5G", "20M", "HT", "1T", "100", "32", 
	"MKK", "5G", "20M", "HT", "1T", "100", "32",
	"FCC", "5G", "20M", "HT", "1T", "104", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "104", "32", 
	"MKK", "5G", "20M", "HT", "1T", "104", "32",
	"FCC", "5G", "20M", "HT", "1T", "108", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "108", "32", 
	"MKK", "5G", "20M", "HT", "1T", "108", "32",
	"FCC", "5G", "20M", "HT", "1T", "112", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "112", "32", 
	"MKK", "5G", "20M", "HT", "1T", "112", "32",
	"FCC", "5G", "20M", "HT", "1T", "116", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "116", "32", 
	"MKK", "5G", "20M", "HT", "1T", "116", "32",
	"FCC", "5G", "20M", "HT", "1T", "120", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "120", "32", 
	"MKK", "5G", "20M", "HT", "1T", "120", "32",
	"FCC", "5G", "20M", "HT", "1T", "124", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "124", "32", 
	"MKK", "5G", "20M", "HT", "1T", "124", "32",
	"FCC", "5G", "20M", "HT", "1T", "128", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "128", "32", 
	"MKK", "5G", "20M", "HT", "1T", "128", "32",
	"FCC", "5G", "20M", "HT", "1T", "132", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "132", "32", 
	"MKK", "5G", "20M", "HT", "1T", "132", "32",
	"FCC", "5G", "20M", "HT", "1T", "136", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "136", "32", 
	"MKK", "5G", "20M", "HT", "1T", "136", "32",
	"FCC", "5G", "20M", "HT", "1T", "140", "26", 
	"ETSI", "5G", "20M", "HT", "1T", "140", "32", 
	"MKK", "5G", "20M", "HT", "1T", "140", "32",
	"FCC", "5G", "20M", "HT", "1T", "144", "26", 
	"ETSI", "5G", "20M", "HT", "1T", "144", "63", 
	"MKK", "5G", "20M", "HT", "1T", "144", "63",
	"FCC", "5G", "20M", "HT", "1T", "149", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "149", "63", 
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "153", "63", 
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "157", "63", 
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "161", "63", 
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "165", "63", 
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "2T", "36", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "36", "20", 
	"MKK", "5G", "20M", "HT", "2T", "36", "22",
	"FCC", "5G", "20M", "HT", "2T", "40", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "40", "20", 
	"MKK", "5G", "20M", "HT", "2T", "40", "22",
	"FCC", "5G", "20M", "HT", "2T", "44", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "44", "20", 
	"MKK", "5G", "20M", "HT", "2T", "44", "22",
	"FCC", "5G", "20M", "HT", "2T", "48", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "48", "20", 
	"MKK", "5G", "20M", "HT", "2T", "48", "22",
	"FCC", "5G", "20M", "HT", "2T", "52", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "52", "20", 
	"MKK", "5G", "20M", "HT", "2T", "52", "22",
	"FCC", "5G", "20M", "HT", "2T", "56", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "56", "20", 
	"MKK", "5G", "20M", "HT", "2T", "56", "22",
	"FCC", "5G", "20M", "HT", "2T", "60", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "60", "20", 
	"MKK", "5G", "20M", "HT", "2T", "60", "22",
	"FCC", "5G", "20M", "HT", "2T", "64", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "64", "20", 
	"MKK", "5G", "20M", "HT", "2T", "64", "22",
	"FCC", "5G", "20M", "HT", "2T", "100", "26", 
	"ETSI", "5G", "20M", "HT", "2T", "100", "20", 
	"MKK", "5G", "20M", "HT", "2T", "100", "30",
	"FCC", "5G", "20M", "HT", "2T", "104", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "104", "20", 
	"MKK", "5G", "20M", "HT", "2T", "104", "30",
	"FCC", "5G", "20M", "HT", "2T", "108", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "108", "20", 
	"MKK", "5G", "20M", "HT", "2T", "108", "30",
	"FCC", "5G", "20M", "HT", "2T", "112", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "112", "20", 
	"MKK", "5G", "20M", "HT", "2T", "112", "30",
	"FCC", "5G", "20M", "HT", "2T", "116", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "116", "20", 
	"MKK", "5G", "20M", "HT", "2T", "116", "30",
	"FCC", "5G", "20M", "HT", "2T", "120", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "120", "20", 
	"MKK", "5G", "20M", "HT", "2T", "120", "30",
	"FCC", "5G", "20M", "HT", "2T", "124", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "124", "20", 
	"MKK", "5G", "20M", "HT", "2T", "124", "30",
	"FCC", "5G", "20M", "HT", "2T", "128", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "128", "20", 
	"MKK", "5G", "20M", "HT", "2T", "128", "30",
	"FCC", "5G", "20M", "HT", "2T", "132", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "132", "20", 
	"MKK", "5G", "20M", "HT", "2T", "132", "30",
	"FCC", "5G", "20M", "HT", "2T", "136", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "136", "20", 
	"MKK", "5G", "20M", "HT", "2T", "136", "30",
	"FCC", "5G", "20M", "HT", "2T", "140", "26", 
	"ETSI", "5G", "20M", "HT", "2T", "140", "20", 
	"MKK", "5G", "20M", "HT", "2T", "140", "30",
	"FCC", "5G", "20M", "HT", "2T", "144", "26", 
	"ETSI", "5G", "20M", "HT", "2T", "144", "63", 
	"MKK", "5G", "20M", "HT", "2T", "144", "63",
	"FCC", "5G", "20M", "HT", "2T", "149", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "149", "63", 
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"FCC", "5G", "20M", "HT", "2T", "153", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "153", "63", 
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"FCC", "5G", "20M", "HT", "2T", "157", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "157", "63", 
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"FCC", "5G", "20M", "HT", "2T", "161", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "161", "63", 
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"FCC", "5G", "20M", "HT", "2T", "165", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "165", "63", 
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "22", 
	"ETSI", "5G", "40M", "HT", "1T", "38", "30", 
	"MKK", "5G", "40M", "HT", "1T", "38", "30",
	"FCC", "5G", "40M", "HT", "1T", "46", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "46", "30", 
	"MKK", "5G", "40M", "HT", "1T", "46", "30",
	"FCC", "5G", "40M", "HT", "1T", "54", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "54", "30", 
	"MKK", "5G", "40M", "HT", "1T", "54", "30",
	"FCC", "5G", "40M", "HT", "1T", "62", "24", 
	"ETSI", "5G", "40M", "HT", "1T", "62", "30", 
	"MKK", "5G", "40M", "HT", "1T", "62", "30",
	"FCC", "5G", "40M", "HT", "1T", "102", "24", 
	"ETSI", "5G", "40M", "HT", "1T", "102", "30", 
	"MKK", "5G", "40M", "HT", "1T", "102", "30",
	"FCC", "5G", "40M", "HT", "1T", "110", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "110", "30", 
	"MKK", "5G", "40M", "HT", "1T", "110", "30",
	"FCC", "5G", "40M", "HT", "1T", "118", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "118", "30", 
	"MKK", "5G", "40M", "HT", "1T", "118", "30",
	"FCC", "5G", "40M", "HT", "1T", "126", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "126", "30", 
	"MKK", "5G", "40M", "HT", "1T", "126", "30",
	"FCC", "5G", "40M", "HT", "1T", "134", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "134", "30", 
	"MKK", "5G", "40M", "HT", "1T", "134", "30",
	"FCC", "5G", "40M", "HT", "1T", "142", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "142", "63", 
	"MKK", "5G", "40M", "HT", "1T", "142", "63",
	"FCC", "5G", "40M", "HT", "1T", "151", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "151", "63", 
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "159", "63", 
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "40M", "HT", "2T", "38", "20", 
	"ETSI", "5G", "40M", "HT", "2T", "38", "20", 
	"MKK", "5G", "40M", "HT", "2T", "38", "22",
	"FCC", "5G", "40M", "HT", "2T", "46", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "46", "20", 
	"MKK", "5G", "40M", "HT", "2T", "46", "22",
	"FCC", "5G", "40M", "HT", "2T", "54", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "54", "20", 
	"MKK", "5G", "40M", "HT", "2T", "54", "22",
	"FCC", "5G", "40M", "HT", "2T", "62", "22", 
	"ETSI", "5G", "40M", "HT", "2T", "62", "20", 
	"MKK", "5G", "40M", "HT", "2T", "62", "22",
	"FCC", "5G", "40M", "HT", "2T", "102", "22", 
	"ETSI", "5G", "40M", "HT", "2T", "102", "20", 
	"MKK", "5G", "40M", "HT", "2T", "102", "30",
	"FCC", "5G", "40M", "HT", "2T", "110", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "110", "20", 
	"MKK", "5G", "40M", "HT", "2T", "110", "30",
	"FCC", "5G", "40M", "HT", "2T", "118", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "118", "20", 
	"MKK", "5G", "40M", "HT", "2T", "118", "30",
	"FCC", "5G", "40M", "HT", "2T", "126", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "126", "20", 
	"MKK", "5G", "40M", "HT", "2T", "126", "30",
	"FCC", "5G", "40M", "HT", "2T", "134", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "134", "20", 
	"MKK", "5G", "40M", "HT", "2T", "134", "30",
	"FCC", "5G", "40M", "HT", "2T", "142", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "142", "63", 
	"MKK", "5G", "40M", "HT", "2T", "142", "63",
	"FCC", "5G", "40M", "HT", "2T", "151", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "151", "63", 
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"FCC", "5G", "40M", "HT", "2T", "159", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "159", "63", 
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "20", 
	"ETSI", "5G", "80M", "VHT", "1T", "42", "30", 
	"MKK", "5G", "80M", "VHT", "1T", "42", "28",
	"FCC", "5G", "80M", "VHT", "1T", "58", "20", 
	"ETSI", "5G", "80M", "VHT", "1T", "58", "30", 
	"MKK", "5G", "80M", "VHT", "1T", "58", "28",
	"FCC", "5G", "80M", "VHT", "1T", "106", "20", 
	"ETSI", "5G", "80M", "VHT", "1T", "106", "30", 
	"MKK", "5G", "80M", "VHT", "1T", "106", "30",
	"FCC", "5G", "80M", "VHT", "1T", "122", "30", 
	"ETSI", "5G", "80M", "VHT", "1T", "122", "30", 
	"MKK", "5G", "80M", "VHT", "1T", "122", "30",
	"FCC", "5G", "80M", "VHT", "1T", "138", "30", 
	"ETSI", "5G", "80M", "VHT", "1T", "138", "63", 
	"MKK", "5G", "80M", "VHT", "1T", "138", "63",
	"FCC", "5G", "80M", "VHT", "1T", "155", "30", 
	"ETSI", "5G", "80M", "VHT", "1T", "155", "63", 
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"FCC", "5G", "80M", "VHT", "2T", "42", "18", 
	"ETSI", "5G", "80M", "VHT", "2T", "42", "20", 
	"MKK", "5G", "80M", "VHT", "2T", "42", "22",
	"FCC", "5G", "80M", "VHT", "2T", "58", "18", 
	"ETSI", "5G", "80M", "VHT", "2T", "58", "20", 
	"MKK", "5G", "80M", "VHT", "2T", "58", "22",
	"FCC", "5G", "80M", "VHT", "2T", "106", "20", 
	"ETSI", "5G", "80M", "VHT", "2T", "106", "20", 
	"MKK", "5G", "80M", "VHT", "2T", "106", "30",
	"FCC", "5G", "80M", "VHT", "2T", "122", "30", 
	"ETSI", "5G", "80M", "VHT", "2T", "122", "20", 
	"MKK", "5G", "80M", "VHT", "2T", "122", "30",
	"FCC", "5G", "80M", "VHT", "2T", "138", "30", 
	"ETSI", "5G", "80M", "VHT", "2T", "138", "63", 
	"MKK", "5G", "80M", "VHT", "2T", "138", "63",
	"FCC", "5G", "80M", "VHT", "2T", "155", "30", 
	"ETSI", "5G", "80M", "VHT", "2T", "155", "63", 
	"MKK", "5G", "80M", "VHT", "2T", "155", "63"
};

void
ODM_ReadAndConfig_MP_8822B_TXPWR_LMT(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i           = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u4Byte     ArrayLen    = sizeof(Array_MP_8822B_TXPWR_LMT)/sizeof(u1Byte);
	pu1Byte    Array      = (pu1Byte)Array_MP_8822B_TXPWR_LMT;
#else
	u4Byte     ArrayLen    = sizeof(Array_MP_8822B_TXPWR_LMT)/sizeof(pu1Byte);
	pu1Byte    *Array      = (pu1Byte *)Array_MP_8822B_TXPWR_LMT;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	PADAPTER		Adapter = pDM_Odm->Adapter;
	HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(Adapter);

	PlatformZeroMemory(pHalData->BufOfLinesPwrLmt, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	pHalData->nLinesReadPwrLmt = ArrayLen/7;
#endif

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8822B_TXPWR_LMT\n"));

	for (i = 0; i < ArrayLen; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u1Byte regulation = Array[i];
		u1Byte band = Array[i+1];
		u1Byte bandwidth = Array[i+2];
		u1Byte rate = Array[i+3];
		u1Byte rfPath = Array[i+4];
		u1Byte chnl = Array[i+5];
		u1Byte val = Array[i+6];
#else
		pu1Byte regulation = Array[i];
		pu1Byte band = Array[i+1];
		pu1Byte bandwidth = Array[i+2];
		pu1Byte rate = Array[i+3];
		pu1Byte rfPath = Array[i+4];
		pu1Byte chnl = Array[i+5];
		pu1Byte val = Array[i+6];
#endif
	
		odm_ConfigBB_TXPWR_LMT_8822B(pDM_Odm, regulation, band, bandwidth, rate, rfPath, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)pHalData->BufOfLinesPwrLmt[i/7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			regulation, band, bandwidth, rate, rfPath, chnl, val);
#endif
	}

}

/******************************************************************************
*                           TXPWR_LMT_type5.TXT
******************************************************************************/

const char *Array_MP_8822B_TXPWR_LMT_type5[] = { 
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "32", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "26", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "20", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "28", 
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "28",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "26", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "30", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "32", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "34", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "34", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "34", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "34", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "34", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "32", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "30", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "28", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "22", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "14", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "30", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "26", 
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "01", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "30", 
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "02", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "32", 
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "34", 
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "34", 
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "34", 
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "34", 
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "34", 
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "32", 
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "30", 
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "26", 
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "20", 
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "12", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "14", 
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "30", 
	"MKK", "2.4G", "20M", "HT", "1T", "13", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "26", 
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "01", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "28", 
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "02", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "30", 
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "30", 
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "32", 
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "32", 
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "32", 
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "30", 
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "30", 
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "28", 
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "26", 
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "20", 
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "12", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "14", 
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "18", 
	"MKK", "2.4G", "20M", "HT", "2T", "13", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "26", 
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "26", 
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "30", 
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "32", 
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "30", 
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "26", 
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "26", 
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "20", 
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "14", 
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "30", 
	"MKK", "2.4G", "40M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "24", 
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "24", 
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "26", 
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "28", 
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "26", 
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "26", 
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "26", 
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "20", 
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "14", 
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "18", 
	"MKK", "2.4G", "40M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "36", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "40", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "44", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "48", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "52", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "56", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "60", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "28", 
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "64", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "26", 
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "100", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "104", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "108", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "112", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "116", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "120", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "124", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "128", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "132", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "136", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "28", 
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "140", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "28", 
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "144", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "63", 
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "63", 
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "63", 
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "63", 
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "63", 
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "36", "32", 
	"MKK", "5G", "20M", "HT", "1T", "36", "28",
	"FCC", "5G", "20M", "HT", "1T", "40", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "40", "32", 
	"MKK", "5G", "20M", "HT", "1T", "40", "28",
	"FCC", "5G", "20M", "HT", "1T", "44", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "44", "32", 
	"MKK", "5G", "20M", "HT", "1T", "44", "28",
	"FCC", "5G", "20M", "HT", "1T", "48", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "48", "32", 
	"MKK", "5G", "20M", "HT", "1T", "48", "28",
	"FCC", "5G", "20M", "HT", "1T", "52", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "52", "32", 
	"MKK", "5G", "20M", "HT", "1T", "52", "28",
	"FCC", "5G", "20M", "HT", "1T", "56", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "56", "32", 
	"MKK", "5G", "20M", "HT", "1T", "56", "28",
	"FCC", "5G", "20M", "HT", "1T", "60", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "60", "32", 
	"MKK", "5G", "20M", "HT", "1T", "60", "28",
	"FCC", "5G", "20M", "HT", "1T", "64", "28", 
	"ETSI", "5G", "20M", "HT", "1T", "64", "32", 
	"MKK", "5G", "20M", "HT", "1T", "64", "28",
	"FCC", "5G", "20M", "HT", "1T", "100", "26", 
	"ETSI", "5G", "20M", "HT", "1T", "100", "32", 
	"MKK", "5G", "20M", "HT", "1T", "100", "32",
	"FCC", "5G", "20M", "HT", "1T", "104", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "104", "32", 
	"MKK", "5G", "20M", "HT", "1T", "104", "32",
	"FCC", "5G", "20M", "HT", "1T", "108", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "108", "32", 
	"MKK", "5G", "20M", "HT", "1T", "108", "32",
	"FCC", "5G", "20M", "HT", "1T", "112", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "112", "32", 
	"MKK", "5G", "20M", "HT", "1T", "112", "32",
	"FCC", "5G", "20M", "HT", "1T", "116", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "116", "32", 
	"MKK", "5G", "20M", "HT", "1T", "116", "32",
	"FCC", "5G", "20M", "HT", "1T", "120", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "120", "32", 
	"MKK", "5G", "20M", "HT", "1T", "120", "32",
	"FCC", "5G", "20M", "HT", "1T", "124", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "124", "32", 
	"MKK", "5G", "20M", "HT", "1T", "124", "32",
	"FCC", "5G", "20M", "HT", "1T", "128", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "128", "32", 
	"MKK", "5G", "20M", "HT", "1T", "128", "32",
	"FCC", "5G", "20M", "HT", "1T", "132", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "132", "32", 
	"MKK", "5G", "20M", "HT", "1T", "132", "32",
	"FCC", "5G", "20M", "HT", "1T", "136", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "136", "32", 
	"MKK", "5G", "20M", "HT", "1T", "136", "32",
	"FCC", "5G", "20M", "HT", "1T", "140", "26", 
	"ETSI", "5G", "20M", "HT", "1T", "140", "32", 
	"MKK", "5G", "20M", "HT", "1T", "140", "32",
	"FCC", "5G", "20M", "HT", "1T", "144", "26", 
	"ETSI", "5G", "20M", "HT", "1T", "144", "63", 
	"MKK", "5G", "20M", "HT", "1T", "144", "63",
	"FCC", "5G", "20M", "HT", "1T", "149", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "149", "63", 
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "153", "63", 
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "157", "63", 
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "161", "63", 
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "165", "63", 
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "2T", "36", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "36", "20", 
	"MKK", "5G", "20M", "HT", "2T", "36", "22",
	"FCC", "5G", "20M", "HT", "2T", "40", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "40", "20", 
	"MKK", "5G", "20M", "HT", "2T", "40", "22",
	"FCC", "5G", "20M", "HT", "2T", "44", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "44", "20", 
	"MKK", "5G", "20M", "HT", "2T", "44", "22",
	"FCC", "5G", "20M", "HT", "2T", "48", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "48", "20", 
	"MKK", "5G", "20M", "HT", "2T", "48", "22",
	"FCC", "5G", "20M", "HT", "2T", "52", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "52", "20", 
	"MKK", "5G", "20M", "HT", "2T", "52", "22",
	"FCC", "5G", "20M", "HT", "2T", "56", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "56", "20", 
	"MKK", "5G", "20M", "HT", "2T", "56", "22",
	"FCC", "5G", "20M", "HT", "2T", "60", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "60", "20", 
	"MKK", "5G", "20M", "HT", "2T", "60", "22",
	"FCC", "5G", "20M", "HT", "2T", "64", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "64", "20", 
	"MKK", "5G", "20M", "HT", "2T", "64", "22",
	"FCC", "5G", "20M", "HT", "2T", "100", "26", 
	"ETSI", "5G", "20M", "HT", "2T", "100", "20", 
	"MKK", "5G", "20M", "HT", "2T", "100", "30",
	"FCC", "5G", "20M", "HT", "2T", "104", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "104", "20", 
	"MKK", "5G", "20M", "HT", "2T", "104", "30",
	"FCC", "5G", "20M", "HT", "2T", "108", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "108", "20", 
	"MKK", "5G", "20M", "HT", "2T", "108", "30",
	"FCC", "5G", "20M", "HT", "2T", "112", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "112", "20", 
	"MKK", "5G", "20M", "HT", "2T", "112", "30",
	"FCC", "5G", "20M", "HT", "2T", "116", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "116", "20", 
	"MKK", "5G", "20M", "HT", "2T", "116", "30",
	"FCC", "5G", "20M", "HT", "2T", "120", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "120", "20", 
	"MKK", "5G", "20M", "HT", "2T", "120", "30",
	"FCC", "5G", "20M", "HT", "2T", "124", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "124", "20", 
	"MKK", "5G", "20M", "HT", "2T", "124", "30",
	"FCC", "5G", "20M", "HT", "2T", "128", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "128", "20", 
	"MKK", "5G", "20M", "HT", "2T", "128", "30",
	"FCC", "5G", "20M", "HT", "2T", "132", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "132", "20", 
	"MKK", "5G", "20M", "HT", "2T", "132", "30",
	"FCC", "5G", "20M", "HT", "2T", "136", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "136", "20", 
	"MKK", "5G", "20M", "HT", "2T", "136", "30",
	"FCC", "5G", "20M", "HT", "2T", "140", "26", 
	"ETSI", "5G", "20M", "HT", "2T", "140", "20", 
	"MKK", "5G", "20M", "HT", "2T", "140", "30",
	"FCC", "5G", "20M", "HT", "2T", "144", "26", 
	"ETSI", "5G", "20M", "HT", "2T", "144", "63", 
	"MKK", "5G", "20M", "HT", "2T", "144", "63",
	"FCC", "5G", "20M", "HT", "2T", "149", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "149", "63", 
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"FCC", "5G", "20M", "HT", "2T", "153", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "153", "63", 
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"FCC", "5G", "20M", "HT", "2T", "157", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "157", "63", 
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"FCC", "5G", "20M", "HT", "2T", "161", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "161", "63", 
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"FCC", "5G", "20M", "HT", "2T", "165", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "165", "63", 
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "22", 
	"ETSI", "5G", "40M", "HT", "1T", "38", "30", 
	"MKK", "5G", "40M", "HT", "1T", "38", "30",
	"FCC", "5G", "40M", "HT", "1T", "46", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "46", "30", 
	"MKK", "5G", "40M", "HT", "1T", "46", "30",
	"FCC", "5G", "40M", "HT", "1T", "54", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "54", "30", 
	"MKK", "5G", "40M", "HT", "1T", "54", "30",
	"FCC", "5G", "40M", "HT", "1T", "62", "24", 
	"ETSI", "5G", "40M", "HT", "1T", "62", "30", 
	"MKK", "5G", "40M", "HT", "1T", "62", "30",
	"FCC", "5G", "40M", "HT", "1T", "102", "24", 
	"ETSI", "5G", "40M", "HT", "1T", "102", "30", 
	"MKK", "5G", "40M", "HT", "1T", "102", "30",
	"FCC", "5G", "40M", "HT", "1T", "110", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "110", "30", 
	"MKK", "5G", "40M", "HT", "1T", "110", "30",
	"FCC", "5G", "40M", "HT", "1T", "118", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "118", "30", 
	"MKK", "5G", "40M", "HT", "1T", "118", "30",
	"FCC", "5G", "40M", "HT", "1T", "126", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "126", "30", 
	"MKK", "5G", "40M", "HT", "1T", "126", "30",
	"FCC", "5G", "40M", "HT", "1T", "134", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "134", "30", 
	"MKK", "5G", "40M", "HT", "1T", "134", "30",
	"FCC", "5G", "40M", "HT", "1T", "142", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "142", "63", 
	"MKK", "5G", "40M", "HT", "1T", "142", "63",
	"FCC", "5G", "40M", "HT", "1T", "151", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "151", "63", 
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "159", "63", 
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "40M", "HT", "2T", "38", "20", 
	"ETSI", "5G", "40M", "HT", "2T", "38", "20", 
	"MKK", "5G", "40M", "HT", "2T", "38", "22",
	"FCC", "5G", "40M", "HT", "2T", "46", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "46", "20", 
	"MKK", "5G", "40M", "HT", "2T", "46", "22",
	"FCC", "5G", "40M", "HT", "2T", "54", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "54", "20", 
	"MKK", "5G", "40M", "HT", "2T", "54", "22",
	"FCC", "5G", "40M", "HT", "2T", "62", "22", 
	"ETSI", "5G", "40M", "HT", "2T", "62", "20", 
	"MKK", "5G", "40M", "HT", "2T", "62", "22",
	"FCC", "5G", "40M", "HT", "2T", "102", "22", 
	"ETSI", "5G", "40M", "HT", "2T", "102", "20", 
	"MKK", "5G", "40M", "HT", "2T", "102", "30",
	"FCC", "5G", "40M", "HT", "2T", "110", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "110", "20", 
	"MKK", "5G", "40M", "HT", "2T", "110", "30",
	"FCC", "5G", "40M", "HT", "2T", "118", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "118", "20", 
	"MKK", "5G", "40M", "HT", "2T", "118", "30",
	"FCC", "5G", "40M", "HT", "2T", "126", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "126", "20", 
	"MKK", "5G", "40M", "HT", "2T", "126", "30",
	"FCC", "5G", "40M", "HT", "2T", "134", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "134", "20", 
	"MKK", "5G", "40M", "HT", "2T", "134", "30",
	"FCC", "5G", "40M", "HT", "2T", "142", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "142", "63", 
	"MKK", "5G", "40M", "HT", "2T", "142", "63",
	"FCC", "5G", "40M", "HT", "2T", "151", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "151", "63", 
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"FCC", "5G", "40M", "HT", "2T", "159", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "159", "63", 
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "20", 
	"ETSI", "5G", "80M", "VHT", "1T", "42", "30", 
	"MKK", "5G", "80M", "VHT", "1T", "42", "28",
	"FCC", "5G", "80M", "VHT", "1T", "58", "20", 
	"ETSI", "5G", "80M", "VHT", "1T", "58", "30", 
	"MKK", "5G", "80M", "VHT", "1T", "58", "28",
	"FCC", "5G", "80M", "VHT", "1T", "106", "20", 
	"ETSI", "5G", "80M", "VHT", "1T", "106", "30", 
	"MKK", "5G", "80M", "VHT", "1T", "106", "30",
	"FCC", "5G", "80M", "VHT", "1T", "122", "30", 
	"ETSI", "5G", "80M", "VHT", "1T", "122", "30", 
	"MKK", "5G", "80M", "VHT", "1T", "122", "30",
	"FCC", "5G", "80M", "VHT", "1T", "138", "30", 
	"ETSI", "5G", "80M", "VHT", "1T", "138", "63", 
	"MKK", "5G", "80M", "VHT", "1T", "138", "63",
	"FCC", "5G", "80M", "VHT", "1T", "155", "30", 
	"ETSI", "5G", "80M", "VHT", "1T", "155", "63", 
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"FCC", "5G", "80M", "VHT", "2T", "42", "18", 
	"ETSI", "5G", "80M", "VHT", "2T", "42", "20", 
	"MKK", "5G", "80M", "VHT", "2T", "42", "22",
	"FCC", "5G", "80M", "VHT", "2T", "58", "18", 
	"ETSI", "5G", "80M", "VHT", "2T", "58", "20", 
	"MKK", "5G", "80M", "VHT", "2T", "58", "22",
	"FCC", "5G", "80M", "VHT", "2T", "106", "20", 
	"ETSI", "5G", "80M", "VHT", "2T", "106", "20", 
	"MKK", "5G", "80M", "VHT", "2T", "106", "30",
	"FCC", "5G", "80M", "VHT", "2T", "122", "30", 
	"ETSI", "5G", "80M", "VHT", "2T", "122", "20", 
	"MKK", "5G", "80M", "VHT", "2T", "122", "30",
	"FCC", "5G", "80M", "VHT", "2T", "138", "30", 
	"ETSI", "5G", "80M", "VHT", "2T", "138", "63", 
	"MKK", "5G", "80M", "VHT", "2T", "138", "63",
	"FCC", "5G", "80M", "VHT", "2T", "155", "30", 
	"ETSI", "5G", "80M", "VHT", "2T", "155", "63", 
	"MKK", "5G", "80M", "VHT", "2T", "155", "63"
};

void
ODM_ReadAndConfig_MP_8822B_TXPWR_LMT_type5(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i           = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u4Byte     ArrayLen    = sizeof(Array_MP_8822B_TXPWR_LMT_type5)/sizeof(u1Byte);
	pu1Byte    Array      = (pu1Byte)Array_MP_8822B_TXPWR_LMT_type5;
#else
	u4Byte     ArrayLen    = sizeof(Array_MP_8822B_TXPWR_LMT_type5)/sizeof(pu1Byte);
	pu1Byte    *Array      = (pu1Byte *)Array_MP_8822B_TXPWR_LMT_type5;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	PADAPTER		Adapter = pDM_Odm->Adapter;
	HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(Adapter);

	PlatformZeroMemory(pHalData->BufOfLinesPwrLmt, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	pHalData->nLinesReadPwrLmt = ArrayLen/7;
#endif

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8822B_TXPWR_LMT_type5\n"));

	for (i = 0; i < ArrayLen; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u1Byte regulation = Array[i];
		u1Byte band = Array[i+1];
		u1Byte bandwidth = Array[i+2];
		u1Byte rate = Array[i+3];
		u1Byte rfPath = Array[i+4];
		u1Byte chnl = Array[i+5];
		u1Byte val = Array[i+6];
#else
		pu1Byte regulation = Array[i];
		pu1Byte band = Array[i+1];
		pu1Byte bandwidth = Array[i+2];
		pu1Byte rate = Array[i+3];
		pu1Byte rfPath = Array[i+4];
		pu1Byte chnl = Array[i+5];
		pu1Byte val = Array[i+6];
#endif
	
		odm_ConfigBB_TXPWR_LMT_8822B(pDM_Odm, regulation, band, bandwidth, rate, rfPath, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)pHalData->BufOfLinesPwrLmt[i/7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			regulation, band, bandwidth, rate, rfPath, chnl, val);
#endif
	}

}

#endif /* end of HWIMG_SUPPORT*/

