/*
 * Copyright (c) 2015 South Silicon Valley Microelectronics Inc.
 * Copyright (c) 2015 iComm Corporation
 *
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or 
 * (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License 
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#define SYS_REG_BASE 0xc0000000
#define WBOOT_REG_BASE 0xc0000100
#define TU0_US_REG_BASE 0xc0000200
#define TU1_US_REG_BASE 0xc0000210
#define TU2_US_REG_BASE 0xc0000220
#define TU3_US_REG_BASE 0xc0000230
#define TM0_MS_REG_BASE 0xc0000240
#define TM1_MS_REG_BASE 0xc0000250
#define TM2_MS_REG_BASE 0xc0000260
#define TM3_MS_REG_BASE 0xc0000270
#define MCU_WDT_REG_BASE 0xc0000280
#define SYS_WDT_REG_BASE 0xc0000284
#define GPIO_REG_BASE 0xc0000300
#define SD_REG_BASE 0xc0000800
#define SPI_REG_BASE 0xc0000a00
#define CSR_I2C_MST_BASE 0xc0000b00
#define UART_REG_BASE 0xc0000c00
#define DAT_UART_REG_BASE 0xc0000d00
#define INT_REG_BASE 0xc0000e00
#define DBG_SPI_REG_BASE 0xc0000f00
#define FLASH_SPI_REG_BASE 0xc0001000
#define DMA_REG_BASE 0xc0001c00
#define CSR_PMU_BASE 0xc0001d00
#define CSR_RTC_BASE 0xc0001d20
#define RTC_RAM_BASE 0xc0001d80
#define D2_DMA_REG_BASE 0xc0001e00
#define HCI_REG_BASE 0xc1000000
#define CO_REG_BASE 0xc2000000
#define EFS_REG_BASE 0xc2000100
#define SMS4_REG_BASE 0xc3000000
#define MRX_REG_BASE 0xc6000000
#define AMPDU_REG_BASE 0xc6001000
#define MT_REG_CSR_BASE 0xc6002000
#define TXQ0_MT_Q_REG_CSR_BASE 0xc6002100
#define TXQ1_MT_Q_REG_CSR_BASE 0xc6002200
#define TXQ2_MT_Q_REG_CSR_BASE 0xc6002300
#define TXQ3_MT_Q_REG_CSR_BASE 0xc6002400
#define TXQ4_MT_Q_REG_CSR_BASE 0xc6002500
#define HIF_INFO_BASE 0xca000000
#define PHY_RATE_INFO_BASE 0xca000200
#define MAC_GLB_SET_BASE 0xca000300
#define BTCX_REG_BASE 0xca000400
#define MIB_REG_BASE 0xca000800
#define CBR_A_REG_BASE 0xcb000000
#define MB_REG_BASE 0xcd000000
#define ID_MNG_REG_BASE 0xcd010000
#define CSR_PHY_BASE 0xce000000
#define CSR_RF_BASE 0xce010000
#define MMU_REG_BASE 0xcf000000
#define SYS_REG_BANK_SIZE 0x000000b4
#define WBOOT_REG_BANK_SIZE 0x0000000c
#define TU0_US_REG_BANK_SIZE 0x00000010
#define TU1_US_REG_BANK_SIZE 0x00000010
#define TU2_US_REG_BANK_SIZE 0x00000010
#define TU3_US_REG_BANK_SIZE 0x00000010
#define TM0_MS_REG_BANK_SIZE 0x00000010
#define TM1_MS_REG_BANK_SIZE 0x00000010
#define TM2_MS_REG_BANK_SIZE 0x00000010
#define TM3_MS_REG_BANK_SIZE 0x00000010
#define MCU_WDT_REG_BANK_SIZE 0x00000004
#define SYS_WDT_REG_BANK_SIZE 0x00000004
#define GPIO_REG_BANK_SIZE 0x000000d4
#define SD_REG_BANK_SIZE 0x00000180
#define SPI_REG_BANK_SIZE 0x00000040
#define CSR_I2C_MST_BANK_SIZE 0x00000018
#define UART_REG_BANK_SIZE 0x00000028
#define DAT_UART_REG_BANK_SIZE 0x00000028
#define INT_REG_BANK_SIZE 0x0000004c
#define DBG_SPI_REG_BANK_SIZE 0x00000040
#define FLASH_SPI_REG_BANK_SIZE 0x0000002c
#define DMA_REG_BANK_SIZE 0x00000014
#define CSR_PMU_BANK_SIZE 0x00000100
#define CSR_RTC_BANK_SIZE 0x000000e0
#define RTC_RAM_BANK_SIZE 0x00000080
#define D2_DMA_REG_BANK_SIZE 0x00000014
#define HCI_REG_BANK_SIZE 0x000000cc
#define CO_REG_BANK_SIZE 0x000000ac
#define EFS_REG_BANK_SIZE 0x0000006c
#define SMS4_REG_BANK_SIZE 0x00000070
#define MRX_REG_BANK_SIZE 0x00000198
#define AMPDU_REG_BANK_SIZE 0x00000014
#define MT_REG_CSR_BANK_SIZE 0x00000100
#define TXQ0_MT_Q_REG_CSR_BANK_SIZE 0x0000001c
#define TXQ1_MT_Q_REG_CSR_BANK_SIZE 0x0000001c
#define TXQ2_MT_Q_REG_CSR_BANK_SIZE 0x0000001c
#define TXQ3_MT_Q_REG_CSR_BANK_SIZE 0x0000001c
#define TXQ4_MT_Q_REG_CSR_BANK_SIZE 0x0000001c
#define HIF_INFO_BANK_SIZE 0x0000009c
#define PHY_RATE_INFO_BANK_SIZE 0x000000b8
#define MAC_GLB_SET_BANK_SIZE 0x0000003c
#define BTCX_REG_BANK_SIZE 0x0000000c
#define MIB_REG_BANK_SIZE 0x00000480
#define CBR_A_REG_BANK_SIZE 0x001203fc
#define MB_REG_BANK_SIZE 0x000000a0
#define ID_MNG_REG_BANK_SIZE 0x00000084
#define CSR_PHY_BANK_SIZE 0x000071c0
#define CSR_RF_BANK_SIZE 0x000000b0
#define MMU_REG_BANK_SIZE 0x000000c0
#define ADR_BRG_SW_RST (SYS_REG_BASE+0x00000000)
#define ADR_BOOT (SYS_REG_BASE+0x00000004)
#define ADR_CHIP_ID_0 (SYS_REG_BASE+0x00000008)
#define ADR_CHIP_ID_1 (SYS_REG_BASE+0x0000000c)
#define ADR_CHIP_ID_2 (SYS_REG_BASE+0x00000010)
#define ADR_CHIP_ID_3 (SYS_REG_BASE+0x00000014)
#define ADR_CLOCK_SELECTION (SYS_REG_BASE+0x00000018)
#define ADR_PLATFORM_CLOCK_ENABLE (SYS_REG_BASE+0x0000001c)
#define ADR_SYS_CSR_CLOCK_ENABLE (SYS_REG_BASE+0x00000020)
#define ADR_MCU_DBG_SEL (SYS_REG_BASE+0x00000024)
#define ADR_MCU_DBG_DATA (SYS_REG_BASE+0x00000028)
#define ADR_AHB_BRG_STATUS (SYS_REG_BASE+0x0000002c)
#define ADR_BIST_BIST_CTRL (SYS_REG_BASE+0x00000030)
#define ADR_BIST_MODE_REG_IN (SYS_REG_BASE+0x00000034)
#define ADR_BIST_MODE_REG_OUT (SYS_REG_BASE+0x00000038)
#define ADR_BIST_MONITOR_BUS_LSB (SYS_REG_BASE+0x0000003c)
#define ADR_BIST_MONITOR_BUS_MSB (SYS_REG_BASE+0x00000040)
#define ADR_TB_ADR_SEL (SYS_REG_BASE+0x00000044)
#define ADR_TB_RDATA (SYS_REG_BASE+0x00000048)
#define ADR_UART_W2B (SYS_REG_BASE+0x0000004c)
#define ADR_AHB_ILL_ADDR (SYS_REG_BASE+0x00000050)
#define ADR_AHB_FEN_ADDR (SYS_REG_BASE+0x00000054)
#define ADR_AHB_ILLFEN_STATUS (SYS_REG_BASE+0x00000058)
#define ADR_PWM_A (SYS_REG_BASE+0x00000080)
#define ADR_PWM_B (SYS_REG_BASE+0x00000084)
#define ADR_HBUSREQ_LOCK (SYS_REG_BASE+0x00000090)
#define ADR_HBURST_LOCK (SYS_REG_BASE+0x00000094)
#define ADR_PRESCALER_USTIMER (SYS_REG_BASE+0x000000a0)
#define ADR_BIST_MODE_REG_IN_MMU (SYS_REG_BASE+0x000000a4)
#define ADR_BIST_MODE_REG_OUT_MMU (SYS_REG_BASE+0x000000a8)
#define ADR_BIST_MONITOR_BUS_MMU (SYS_REG_BASE+0x000000ac)
#define ADR_TEST_MODE (SYS_REG_BASE+0x000000b0)
#define ADR_BOOT_INFO (WBOOT_REG_BASE+0x00000000)
#define ADR_SD_INIT_CFG (WBOOT_REG_BASE+0x00000004)
#define ADR_SPARE_UART_INFO (WBOOT_REG_BASE+0x00000008)
#define ADR_TU0_MICROSECOND_TIMER (TU0_US_REG_BASE+0x00000000)
#define ADR_TU0_CURRENT_MICROSECOND_TIME_VALUE (TU0_US_REG_BASE+0x00000004)
#define ADR_TU0_DUMMY_BIT_0 (TU0_US_REG_BASE+0x00000008)
#define ADR_TU0_DUMMY_BIT_1 (TU0_US_REG_BASE+0x0000000c)
#define ADR_TU1_MICROSECOND_TIMER (TU1_US_REG_BASE+0x00000000)
#define ADR_TU1_CURRENT_MICROSECOND_TIME_VALUE (TU1_US_REG_BASE+0x00000004)
#define ADR_TU1_DUMMY_BIT_0 (TU1_US_REG_BASE+0x00000008)
#define ADR_TU1_DUMMY_BIT_1 (TU1_US_REG_BASE+0x0000000c)
#define ADR_TU2_MICROSECOND_TIMER (TU2_US_REG_BASE+0x00000000)
#define ADR_TU2_CURRENT_MICROSECOND_TIME_VALUE (TU2_US_REG_BASE+0x00000004)
#define ADR_TU2_DUMMY_BIT_0 (TU2_US_REG_BASE+0x00000008)
#define ADR_TU2_DUMMY_BIT_1 (TU2_US_REG_BASE+0x0000000c)
#define ADR_TU3_MICROSECOND_TIMER (TU3_US_REG_BASE+0x00000000)
#define ADR_TU3_CURRENT_MICROSECOND_TIME_VALUE (TU3_US_REG_BASE+0x00000004)
#define ADR_TU3_DUMMY_BIT_0 (TU3_US_REG_BASE+0x00000008)
#define ADR_TU3_DUMMY_BIT_1 (TU3_US_REG_BASE+0x0000000c)
#define ADR_TM0_MILISECOND_TIMER (TM0_MS_REG_BASE+0x00000000)
#define ADR_TM0_CURRENT_MILISECOND_TIME_VALUE (TM0_MS_REG_BASE+0x00000004)
#define ADR_TM0_DUMMY_BIT_0 (TM0_MS_REG_BASE+0x00000008)
#define ADR_TM0_DUMMY_BIT_1 (TM0_MS_REG_BASE+0x0000000c)
#define ADR_TM1_MILISECOND_TIMER (TM1_MS_REG_BASE+0x00000000)
#define ADR_TM1_CURRENT_MILISECOND_TIME_VALUE (TM1_MS_REG_BASE+0x00000004)
#define ADR_TM1_DUMMY_BIT_0 (TM1_MS_REG_BASE+0x00000008)
#define ADR_TM1_DUMMY_BIT_1 (TM1_MS_REG_BASE+0x0000000c)
#define ADR_TM2_MILISECOND_TIMER (TM2_MS_REG_BASE+0x00000000)
#define ADR_TM2_CURRENT_MILISECOND_TIME_VALUE (TM2_MS_REG_BASE+0x00000004)
#define ADR_TM2_DUMMY_BIT_0 (TM2_MS_REG_BASE+0x00000008)
#define ADR_TM2_DUMMY_BIT_1 (TM2_MS_REG_BASE+0x0000000c)
#define ADR_TM3_MILISECOND_TIMER (TM3_MS_REG_BASE+0x00000000)
#define ADR_TM3_CURRENT_MILISECOND_TIME_VALUE (TM3_MS_REG_BASE+0x00000004)
#define ADR_TM3_DUMMY_BIT_0 (TM3_MS_REG_BASE+0x00000008)
#define ADR_TM3_DUMMY_BIT_1 (TM3_MS_REG_BASE+0x0000000c)
#define ADR_MCU_WDOG_REG (MCU_WDT_REG_BASE+0x00000000)
#define ADR_SYS_WDOG_REG (SYS_WDT_REG_BASE+0x00000000)
#define ADR_PAD6 (GPIO_REG_BASE+0x00000000)
#define ADR_PAD7 (GPIO_REG_BASE+0x00000004)
#define ADR_PAD8 (GPIO_REG_BASE+0x00000008)
#define ADR_PAD9 (GPIO_REG_BASE+0x0000000c)
#define ADR_PAD11 (GPIO_REG_BASE+0x00000010)
#define ADR_PAD15 (GPIO_REG_BASE+0x00000014)
#define ADR_PAD16 (GPIO_REG_BASE+0x00000018)
#define ADR_PAD17 (GPIO_REG_BASE+0x0000001c)
#define ADR_PAD18 (GPIO_REG_BASE+0x00000020)
#define ADR_PAD19 (GPIO_REG_BASE+0x00000024)
#define ADR_PAD20 (GPIO_REG_BASE+0x00000028)
#define ADR_PAD21 (GPIO_REG_BASE+0x0000002c)
#define ADR_PAD22 (GPIO_REG_BASE+0x00000030)
#define ADR_PAD24 (GPIO_REG_BASE+0x00000034)
#define ADR_PAD25 (GPIO_REG_BASE+0x00000038)
#define ADR_PAD27 (GPIO_REG_BASE+0x0000003c)
#define ADR_PAD28 (GPIO_REG_BASE+0x00000040)
#define ADR_PAD29 (GPIO_REG_BASE+0x00000044)
#define ADR_PAD30 (GPIO_REG_BASE+0x00000048)
#define ADR_PAD31 (GPIO_REG_BASE+0x0000004c)
#define ADR_PAD32 (GPIO_REG_BASE+0x00000050)
#define ADR_PAD33 (GPIO_REG_BASE+0x00000054)
#define ADR_PAD34 (GPIO_REG_BASE+0x00000058)
#define ADR_PAD42 (GPIO_REG_BASE+0x0000005c)
#define ADR_PAD43 (GPIO_REG_BASE+0x00000060)
#define ADR_PAD44 (GPIO_REG_BASE+0x00000064)
#define ADR_PAD45 (GPIO_REG_BASE+0x00000068)
#define ADR_PAD46 (GPIO_REG_BASE+0x0000006c)
#define ADR_PAD47 (GPIO_REG_BASE+0x00000070)
#define ADR_PAD48 (GPIO_REG_BASE+0x00000074)
#define ADR_PAD49 (GPIO_REG_BASE+0x00000078)
#define ADR_PAD50 (GPIO_REG_BASE+0x0000007c)
#define ADR_PAD51 (GPIO_REG_BASE+0x00000080)
#define ADR_PAD52 (GPIO_REG_BASE+0x00000084)
#define ADR_PAD53 (GPIO_REG_BASE+0x00000088)
#define ADR_PAD54 (GPIO_REG_BASE+0x0000008c)
#define ADR_PAD56 (GPIO_REG_BASE+0x00000090)
#define ADR_PAD57 (GPIO_REG_BASE+0x00000094)
#define ADR_PAD58 (GPIO_REG_BASE+0x00000098)
#define ADR_PAD59 (GPIO_REG_BASE+0x0000009c)
#define ADR_PAD60 (GPIO_REG_BASE+0x000000a0)
#define ADR_PAD61 (GPIO_REG_BASE+0x000000a4)
#define ADR_PAD62 (GPIO_REG_BASE+0x000000a8)
#define ADR_PAD64 (GPIO_REG_BASE+0x000000ac)
#define ADR_PAD65 (GPIO_REG_BASE+0x000000b0)
#define ADR_PAD66 (GPIO_REG_BASE+0x000000b4)
#define ADR_PAD68 (GPIO_REG_BASE+0x000000b8)
#define ADR_PAD67 (GPIO_REG_BASE+0x000000bc)
#define ADR_PAD69 (GPIO_REG_BASE+0x000000c0)
#define ADR_PAD70 (GPIO_REG_BASE+0x000000c4)
#define ADR_PAD231 (GPIO_REG_BASE+0x000000c8)
#define ADR_PIN_SEL_0 (GPIO_REG_BASE+0x000000cc)
#define ADR_PIN_SEL_1 (GPIO_REG_BASE+0x000000d0)
#define ADR_IO_PORT_REG (SD_REG_BASE+0x00000000)
#define ADR_INT_MASK_REG (SD_REG_BASE+0x00000004)
#define ADR_INT_STATUS_REG (SD_REG_BASE+0x00000008)
#define ADR_FN1_STATUS_REG (SD_REG_BASE+0x0000000c)
#define ADR_CARD_PKT_STATUS_TEST (SD_REG_BASE+0x00000010)
#define ADR_SYSTEM_INFORMATION_REG (SD_REG_BASE+0x0000001c)
#define ADR_CARD_RCA_REG (SD_REG_BASE+0x00000020)
#define ADR_SDIO_FIFO_WR_THLD_REG (SD_REG_BASE+0x00000024)
#define ADR_SDIO_FIFO_WR_LIMIT_REG (SD_REG_BASE+0x00000028)
#define ADR_SDIO_TX_DATA_BATCH_SIZE_REG (SD_REG_BASE+0x0000002c)
#define ADR_SDIO_THLD_FOR_CMD53RD_REG (SD_REG_BASE+0x00000030)
#define ADR_SDIO_RX_DATA_BATCH_SIZE_REG (SD_REG_BASE+0x00000034)
#define ADR_SDIO_LOG_START_END_DATA_REG (SD_REG_BASE+0x00000038)
#define ADR_SDIO_BYTE_MODE_BATCH_SIZE_REG (SD_REG_BASE+0x00000040)
#define ADR_SDIO_LAST_CMD_INDEX_CRC_REG (SD_REG_BASE+0x00000044)
#define ADR_SDIO_LAST_CMD_ARG_REG (SD_REG_BASE+0x00000048)
#define ADR_SDIO_BUS_STATE_DEBUG_MONITOR (SD_REG_BASE+0x0000004c)
#define ADR_SDIO_CARD_STATUS_REG (SD_REG_BASE+0x00000050)
#define ADR_R5_RESP_FLAG_OUT_TIMING (SD_REG_BASE+0x00000054)
#define ADR_CMD52_DATA_FOR_LAST_TIME (SD_REG_BASE+0x0000005c)
#define ADR_FN1_DMA_START_ADDR_REG (SD_REG_BASE+0x00000060)
#define ADR_FN1_INT_CTRL_RESET (SD_REG_BASE+0x00000064)
#define ADR_IO_REG_PORT_REG (SD_REG_BASE+0x00000070)
#define ADR_SDIO_FIFO_ERROR_CNT (SD_REG_BASE+0x0000007c)
#define ADR_SDIO_CRC7_CRC16_ERROR_REG (SD_REG_BASE+0x00000080)
#define ADR_SDIO_BLOCK_CNT_INFO (SD_REG_BASE+0x00000084)
#define ADR_RX_DATA_CMD52_ABORT_COUNT (SD_REG_BASE+0x0000008c)
#define ADR_FIFO_PTR_READ_BLOCK_CNT (SD_REG_BASE+0x00000090)
#define ADR_TX_TIME_OUT_READ_CTRL (SD_REG_BASE+0x00000094)
#define ADR_SDIO_TX_ALLOC_REG (SD_REG_BASE+0x00000098)
#define ADR_SDIO_TX_INFORM (SD_REG_BASE+0x0000009c)
#define ADR_F1_BLOCK_SIZE_0_REG (SD_REG_BASE+0x000000a0)
#define ADR_SDIO_COMMAND_LOG_DATA_31_0 (SD_REG_BASE+0x000000b0)
#define ADR_SDIO_COMMAND_LOG_DATA_63_32 (SD_REG_BASE+0x000000b4)
#define ADR_SYSTEM_INFORMATION_REGISTER (SD_REG_BASE+0x000000bc)
#define ADR_CCCR_00H_REG (SD_REG_BASE+0x000000c0)
#define ADR_CCCR_04H_REG (SD_REG_BASE+0x000000c4)
#define ADR_CCCR_08H_REG (SD_REG_BASE+0x000000c8)
#define ADR_CCCR_13H_REG (SD_REG_BASE+0x000000d0)
#define ADR_FBR_100H_REG (SD_REG_BASE+0x000000e0)
#define ADR_FBR_109H_REG (SD_REG_BASE+0x000000e8)
#define ADR_F0_CIS_CONTENT_REG_0 (SD_REG_BASE+0x00000100)
#define ADR_F0_CIS_CONTENT_REG_1 (SD_REG_BASE+0x00000104)
#define ADR_F0_CIS_CONTENT_REG_2 (SD_REG_BASE+0x00000108)
#define ADR_F0_CIS_CONTENT_REG_3 (SD_REG_BASE+0x0000010c)
#define ADR_F0_CIS_CONTENT_REG_4 (SD_REG_BASE+0x00000110)
#define ADR_F0_CIS_CONTENT_REG_5 (SD_REG_BASE+0x00000114)
#define ADR_F0_CIS_CONTENT_REG_6 (SD_REG_BASE+0x00000118)
#define ADR_F0_CIS_CONTENT_REG_7 (SD_REG_BASE+0x0000011c)
#define ADR_F0_CIS_CONTENT_REG_8 (SD_REG_BASE+0x00000120)
#define ADR_F0_CIS_CONTENT_REG_9 (SD_REG_BASE+0x00000124)
#define ADR_F0_CIS_CONTENT_REG_10 (SD_REG_BASE+0x00000128)
#define ADR_F0_CIS_CONTENT_REG_11 (SD_REG_BASE+0x0000012c)
#define ADR_F0_CIS_CONTENT_REG_12 (SD_REG_BASE+0x00000130)
#define ADR_F0_CIS_CONTENT_REG_13 (SD_REG_BASE+0x00000134)
#define ADR_F0_CIS_CONTENT_REG_14 (SD_REG_BASE+0x00000138)
#define ADR_F0_CIS_CONTENT_REG_15 (SD_REG_BASE+0x0000013c)
#define ADR_F1_CIS_CONTENT_REG_0 (SD_REG_BASE+0x00000140)
#define ADR_F1_CIS_CONTENT_REG_1 (SD_REG_BASE+0x00000144)
#define ADR_F1_CIS_CONTENT_REG_2 (SD_REG_BASE+0x00000148)
#define ADR_F1_CIS_CONTENT_REG_3 (SD_REG_BASE+0x0000014c)
#define ADR_F1_CIS_CONTENT_REG_4 (SD_REG_BASE+0x00000150)
#define ADR_F1_CIS_CONTENT_REG_5 (SD_REG_BASE+0x00000154)
#define ADR_F1_CIS_CONTENT_REG_6 (SD_REG_BASE+0x00000158)
#define ADR_F1_CIS_CONTENT_REG_7 (SD_REG_BASE+0x0000015c)
#define ADR_F1_CIS_CONTENT_REG_8 (SD_REG_BASE+0x00000160)
#define ADR_F1_CIS_CONTENT_REG_9 (SD_REG_BASE+0x00000164)
#define ADR_F1_CIS_CONTENT_REG_10 (SD_REG_BASE+0x00000168)
#define ADR_F1_CIS_CONTENT_REG_11 (SD_REG_BASE+0x0000016c)
#define ADR_F1_CIS_CONTENT_REG_12 (SD_REG_BASE+0x00000170)
#define ADR_F1_CIS_CONTENT_REG_13 (SD_REG_BASE+0x00000174)
#define ADR_F1_CIS_CONTENT_REG_14 (SD_REG_BASE+0x00000178)
#define ADR_F1_CIS_CONTENT_REG_15 (SD_REG_BASE+0x0000017c)
#define ADR_SPI_MODE (SPI_REG_BASE+0x00000000)
#define ADR_RX_QUOTA (SPI_REG_BASE+0x00000004)
#define ADR_CONDITION_NUMBER (SPI_REG_BASE+0x00000008)
#define ADR_HOST_PATH (SPI_REG_BASE+0x0000000c)
#define ADR_TX_SEG (SPI_REG_BASE+0x00000010)
#define ADR_DEBUG_BURST_MODE (SPI_REG_BASE+0x00000014)
#define ADR_SPI_TO_PHY_PARAM1 (SPI_REG_BASE+0x00000018)
#define ADR_SPI_TO_PHY_PARAM2 (SPI_REG_BASE+0x0000001c)
#define ADR_SPI_STS (SPI_REG_BASE+0x00000020)
#define ADR_TX_ALLOC_SET (SPI_REG_BASE+0x00000024)
#define ADR_TX_ALLOC (SPI_REG_BASE+0x00000028)
#define ADR_DBG_CNT (SPI_REG_BASE+0x0000002c)
#define ADR_DBG_CNT2 (SPI_REG_BASE+0x00000030)
#define ADR_DBG_CNT3 (SPI_REG_BASE+0x00000034)
#define ADR_DBG_CNT4 (SPI_REG_BASE+0x00000038)
#define ADR_INT_TAG (SPI_REG_BASE+0x0000003c)
#define ADR_I2CM_EN (CSR_I2C_MST_BASE+0x00000000)
#define ADR_I2CM_DEV_A (CSR_I2C_MST_BASE+0x00000004)
#define ADR_I2CM_LEN (CSR_I2C_MST_BASE+0x00000008)
#define ADR_I2CM_WDAT (CSR_I2C_MST_BASE+0x0000000c)
#define ADR_I2CM_RDAT (CSR_I2C_MST_BASE+0x00000010)
#define ADR_I2CM_EN_2 (CSR_I2C_MST_BASE+0x00000014)
#define ADR_UART_DATA (UART_REG_BASE+0x00000000)
#define ADR_UART_IER (UART_REG_BASE+0x00000004)
#define ADR_UART_FCR (UART_REG_BASE+0x00000008)
#define ADR_UART_LCR (UART_REG_BASE+0x0000000c)
#define ADR_UART_MCR (UART_REG_BASE+0x00000010)
#define ADR_UART_LSR (UART_REG_BASE+0x00000014)
#define ADR_UART_MSR (UART_REG_BASE+0x00000018)
#define ADR_UART_SPR (UART_REG_BASE+0x0000001c)
#define ADR_UART_RTHR (UART_REG_BASE+0x00000020)
#define ADR_UART_ISR (UART_REG_BASE+0x00000024)
#define ADR_DAT_UART_DATA (DAT_UART_REG_BASE+0x00000000)
#define ADR_DAT_UART_IER (DAT_UART_REG_BASE+0x00000004)
#define ADR_DAT_UART_FCR (DAT_UART_REG_BASE+0x00000008)
#define ADR_DAT_UART_LCR (DAT_UART_REG_BASE+0x0000000c)
#define ADR_DAT_UART_MCR (DAT_UART_REG_BASE+0x00000010)
#define ADR_DAT_UART_LSR (DAT_UART_REG_BASE+0x00000014)
#define ADR_DAT_UART_MSR (DAT_UART_REG_BASE+0x00000018)
#define ADR_DAT_UART_SPR (DAT_UART_REG_BASE+0x0000001c)
#define ADR_DAT_UART_RTHR (DAT_UART_REG_BASE+0x00000020)
#define ADR_DAT_UART_ISR (DAT_UART_REG_BASE+0x00000024)
#define ADR_INT_MASK (INT_REG_BASE+0x00000000)
#define ADR_INT_MODE (INT_REG_BASE+0x00000004)
#define ADR_INT_IRQ_STS (INT_REG_BASE+0x00000008)
#define ADR_INT_FIQ_STS (INT_REG_BASE+0x0000000c)
#define ADR_INT_IRQ_RAW (INT_REG_BASE+0x00000010)
#define ADR_INT_FIQ_RAW (INT_REG_BASE+0x00000014)
#define ADR_INT_PERI_MASK (INT_REG_BASE+0x00000018)
#define ADR_INT_PERI_STS (INT_REG_BASE+0x0000001c)
#define ADR_INT_PERI_RAW (INT_REG_BASE+0x00000020)
#define ADR_INT_GPI_CFG (INT_REG_BASE+0x00000024)
#define ADR_SYS_INT_FOR_HOST (INT_REG_BASE+0x00000028)
#define ADR_SPI_IPC (INT_REG_BASE+0x00000034)
#define ADR_SDIO_IPC (INT_REG_BASE+0x00000038)
#define ADR_SDIO_MASK (INT_REG_BASE+0x0000003c)
#define ADR_SDIO_IRQ_STS (INT_REG_BASE+0x00000040)
#define ADR_SD_PERI_MASK (INT_REG_BASE+0x00000044)
#define ADR_SD_PERI_STS (INT_REG_BASE+0x00000048)
#define ADR_DBG_SPI_MODE (DBG_SPI_REG_BASE+0x00000000)
#define ADR_DBG_RX_QUOTA (DBG_SPI_REG_BASE+0x00000004)
#define ADR_DBG_CONDITION_NUMBER (DBG_SPI_REG_BASE+0x00000008)
#define ADR_DBG_HOST_PATH (DBG_SPI_REG_BASE+0x0000000c)
#define ADR_DBG_TX_SEG (DBG_SPI_REG_BASE+0x00000010)
#define ADR_DBG_DEBUG_BURST_MODE (DBG_SPI_REG_BASE+0x00000014)
#define ADR_DBG_SPI_TO_PHY_PARAM1 (DBG_SPI_REG_BASE+0x00000018)
#define ADR_DBG_SPI_TO_PHY_PARAM2 (DBG_SPI_REG_BASE+0x0000001c)
#define ADR_DBG_SPI_STS (DBG_SPI_REG_BASE+0x00000020)
#define ADR_DBG_TX_ALLOC_SET (DBG_SPI_REG_BASE+0x00000024)
#define ADR_DBG_TX_ALLOC (DBG_SPI_REG_BASE+0x00000028)
#define ADR_DBG_DBG_CNT (DBG_SPI_REG_BASE+0x0000002c)
#define ADR_DBG_DBG_CNT2 (DBG_SPI_REG_BASE+0x00000030)
#define ADR_DBG_DBG_CNT3 (DBG_SPI_REG_BASE+0x00000034)
#define ADR_DBG_DBG_CNT4 (DBG_SPI_REG_BASE+0x00000038)
#define ADR_DBG_INT_TAG (DBG_SPI_REG_BASE+0x0000003c)
#define ADR_BOOT_ADDR (FLASH_SPI_REG_BASE+0x00000000)
#define ADR_VERIFY_DATA (FLASH_SPI_REG_BASE+0x00000004)
#define ADR_FLASH_ADDR (FLASH_SPI_REG_BASE+0x00000008)
#define ADR_SRAM_ADDR (FLASH_SPI_REG_BASE+0x0000000c)
#define ADR_LEN (FLASH_SPI_REG_BASE+0x00000010)
#define ADR_SPI_PARAM (FLASH_SPI_REG_BASE+0x00000014)
#define ADR_SPI_PARAM2 (FLASH_SPI_REG_BASE+0x00000018)
#define ADR_CHECK_SUM_RESULT (FLASH_SPI_REG_BASE+0x0000001c)
#define ADR_CHECK_SUM_IN_FILE (FLASH_SPI_REG_BASE+0x00000020)
#define ADR_COMMAND_LEN (FLASH_SPI_REG_BASE+0x00000024)
#define ADR_COMMAND_ADDR (FLASH_SPI_REG_BASE+0x00000028)
#define ADR_DMA_ADR_SRC (DMA_REG_BASE+0x00000000)
#define ADR_DMA_ADR_DST (DMA_REG_BASE+0x00000004)
#define ADR_DMA_CTRL (DMA_REG_BASE+0x00000008)
#define ADR_DMA_INT (DMA_REG_BASE+0x0000000c)
#define ADR_DMA_FILL_CONST (DMA_REG_BASE+0x00000010)
#define ADR_PMU_0 (CSR_PMU_BASE+0x00000000)
#define ADR_PMU_1 (CSR_PMU_BASE+0x00000004)
#define ADR_PMU_2 (CSR_PMU_BASE+0x00000008)
#define ADR_PMU_3 (CSR_PMU_BASE+0x0000000c)
#define ADR_RTC_1 (CSR_RTC_BASE+0x00000000)
#define ADR_RTC_2 (CSR_RTC_BASE+0x00000004)
#define ADR_RTC_3W (CSR_RTC_BASE+0x00000008)
#define ADR_RTC_3R (CSR_RTC_BASE+0x00000008)
#define ADR_RTC_4 (CSR_RTC_BASE+0x0000000c)
#define ADR_RTC_RAM (RTC_RAM_BASE+0x00000000)
#define ADR_D2_DMA_ADR_SRC (D2_DMA_REG_BASE+0x00000000)
#define ADR_D2_DMA_ADR_DST (D2_DMA_REG_BASE+0x00000004)
#define ADR_D2_DMA_CTRL (D2_DMA_REG_BASE+0x00000008)
#define ADR_D2_DMA_INT (D2_DMA_REG_BASE+0x0000000c)
#define ADR_D2_DMA_FILL_CONST (D2_DMA_REG_BASE+0x00000010)
#define ADR_CONTROL (HCI_REG_BASE+0x00000000)
#define ADR_SDIO_WAKE_MODE (HCI_REG_BASE+0x00000004)
#define ADR_TX_FLOW_0 (HCI_REG_BASE+0x00000008)
#define ADR_TX_FLOW_1 (HCI_REG_BASE+0x0000000c)
#define ADR_THREASHOLD (HCI_REG_BASE+0x00000018)
#define ADR_TXFID_INCREASE (HCI_REG_BASE+0x00000020)
#define ADR_GLOBAL_SEQUENCE (HCI_REG_BASE+0x00000028)
#define ADR_HCI_TX_RX_INFO_SIZE (HCI_REG_BASE+0x00000030)
#define ADR_HCI_TX_INFO_CLEAR (HCI_REG_BASE+0x00000034)
#define ADR_TX_ETHER_TYPE_0 (HCI_REG_BASE+0x00000050)
#define ADR_TX_ETHER_TYPE_1 (HCI_REG_BASE+0x00000054)
#define ADR_RX_ETHER_TYPE_0 (HCI_REG_BASE+0x00000060)
#define ADR_RX_ETHER_TYPE_1 (HCI_REG_BASE+0x00000064)
#define ADR_PACKET_COUNTER_INFO_0 (HCI_REG_BASE+0x00000070)
#define ADR_PACKET_COUNTER_INFO_1 (HCI_REG_BASE+0x00000074)
#define ADR_PACKET_COUNTER_INFO_2 (HCI_REG_BASE+0x00000078)
#define ADR_PACKET_COUNTER_INFO_3 (HCI_REG_BASE+0x0000007c)
#define ADR_PACKET_COUNTER_INFO_4 (HCI_REG_BASE+0x00000080)
#define ADR_PACKET_COUNTER_INFO_5 (HCI_REG_BASE+0x00000084)
#define ADR_PACKET_COUNTER_INFO_6 (HCI_REG_BASE+0x00000088)
#define ADR_PACKET_COUNTER_INFO_7 (HCI_REG_BASE+0x0000008c)
#define ADR_SDIO_TX_RX_FAIL_COUNTER_0 (HCI_REG_BASE+0x00000090)
#define ADR_SDIO_TX_RX_FAIL_COUNTER_1 (HCI_REG_BASE+0x00000094)
#define ADR_HCI_STATE_DEBUG_MODE_0 (HCI_REG_BASE+0x000000a0)
#define ADR_HCI_STATE_DEBUG_MODE_1 (HCI_REG_BASE+0x000000a4)
#define ADR_HCI_STATE_DEBUG_MODE_2 (HCI_REG_BASE+0x000000a8)
#define ADR_HCI_STATE_DEBUG_MODE_3 (HCI_REG_BASE+0x000000ac)
#define ADR_HCI_STATE_DEBUG_MODE_4 (HCI_REG_BASE+0x000000b0)
#define ADR_HCI_STATE_DEBUG_MODE_5 (HCI_REG_BASE+0x000000b4)
#define ADR_HCI_STATE_DEBUG_MODE_6 (HCI_REG_BASE+0x000000b8)
#define ADR_HCI_STATE_DEBUG_MODE_7 (HCI_REG_BASE+0x000000bc)
#define ADR_HCI_STATE_DEBUG_MODE_8 (HCI_REG_BASE+0x000000c0)
#define ADR_HCI_STATE_DEBUG_MODE_9 (HCI_REG_BASE+0x000000c4)
#define ADR_HCI_STATE_DEBUG_MODE_10 (HCI_REG_BASE+0x000000c8)
#define ADR_CS_START_ADDR (CO_REG_BASE+0x00000000)
#define ADR_CS_ADD_LEN (CO_REG_BASE+0x00000004)
#define ADR_CS_CMD (CO_REG_BASE+0x00000008)
#define ADR_CS_INI_BUF (CO_REG_BASE+0x0000000c)
#define ADR_CS_PSEUDO_BUF (CO_REG_BASE+0x00000010)
#define ADR_CS_CHECK_SUM (CO_REG_BASE+0x00000014)
#define ADR_RAND_EN (CO_REG_BASE+0x00000018)
#define ADR_RAND_NUM (CO_REG_BASE+0x0000001c)
#define ADR_MUL_OP1 (CO_REG_BASE+0x00000060)
#define ADR_MUL_OP2 (CO_REG_BASE+0x00000064)
#define ADR_MUL_ANS0 (CO_REG_BASE+0x00000068)
#define ADR_MUL_ANS1 (CO_REG_BASE+0x0000006c)
#define ADR_DMA_RDATA (CO_REG_BASE+0x00000070)
#define ADR_DMA_WDATA (CO_REG_BASE+0x00000074)
#define ADR_DMA_LEN (CO_REG_BASE+0x00000078)
#define ADR_DMA_CLR (CO_REG_BASE+0x0000007c)
#define ADR_NAV_DATA (CO_REG_BASE+0x00000080)
#define ADR_CO_NAV (CO_REG_BASE+0x00000084)
#define ADR_SHA_DST_ADDR (CO_REG_BASE+0x000000a0)
#define ADR_SHA_SRC_ADDR (CO_REG_BASE+0x000000a4)
#define ADR_SHA_SETTING (CO_REG_BASE+0x000000a8)
#define ADR_EFUSE_CLK_FREQ (EFS_REG_BASE+0x00000000)
#define ADR_EFUSE_LDO_TIME (EFS_REG_BASE+0x00000004)
#define ADR_EFUSE_AHB_RDATA_0 (EFS_REG_BASE+0x00000008)
#define ADR_EFUSE_WDATA_0 (EFS_REG_BASE+0x00000008)
#define ADR_EFUSE_AHB_RDATA_1 (EFS_REG_BASE+0x0000000c)
#define ADR_EFUSE_WDATA_1 (EFS_REG_BASE+0x0000000c)
#define ADR_EFUSE_AHB_RDATA_2 (EFS_REG_BASE+0x00000010)
#define ADR_EFUSE_WDATA_2 (EFS_REG_BASE+0x00000010)
#define ADR_EFUSE_AHB_RDATA_3 (EFS_REG_BASE+0x00000014)
#define ADR_EFUSE_WDATA_3 (EFS_REG_BASE+0x00000014)
#define ADR_EFUSE_AHB_RDATA_4 (EFS_REG_BASE+0x00000018)
#define ADR_EFUSE_WDATA_4 (EFS_REG_BASE+0x00000018)
#define ADR_EFUSE_AHB_RDATA_5 (EFS_REG_BASE+0x0000001c)
#define ADR_EFUSE_WDATA_5 (EFS_REG_BASE+0x0000001c)
#define ADR_EFUSE_AHB_RDATA_6 (EFS_REG_BASE+0x00000020)
#define ADR_EFUSE_WDATA_6 (EFS_REG_BASE+0x00000020)
#define ADR_EFUSE_AHB_RDATA_7 (EFS_REG_BASE+0x00000024)
#define ADR_EFUSE_WDATA_7 (EFS_REG_BASE+0x00000024)
#define ADR_EFUSE_SPI_RD0_EN (EFS_REG_BASE+0x00000028)
#define ADR_EFUSE_SPI_RD1_EN (EFS_REG_BASE+0x0000002c)
#define ADR_EFUSE_SPI_RD2_EN (EFS_REG_BASE+0x00000030)
#define ADR_EFUSE_SPI_RD3_EN (EFS_REG_BASE+0x00000034)
#define ADR_EFUSE_SPI_RD4_EN (EFS_REG_BASE+0x00000038)
#define ADR_EFUSE_SPI_RD5_EN (EFS_REG_BASE+0x0000003c)
#define ADR_EFUSE_SPI_RD6_EN (EFS_REG_BASE+0x00000040)
#define ADR_EFUSE_SPI_RD7_EN (EFS_REG_BASE+0x00000044)
#define ADR_EFUSE_SPI_BUSY (EFS_REG_BASE+0x00000048)
#define ADR_EFUSE_SPI_RDATA_0 (EFS_REG_BASE+0x0000004c)
#define ADR_EFUSE_SPI_RDATA_1 (EFS_REG_BASE+0x00000050)
#define ADR_EFUSE_SPI_RDATA_2 (EFS_REG_BASE+0x00000054)
#define ADR_EFUSE_SPI_RDATA_3 (EFS_REG_BASE+0x00000058)
#define ADR_EFUSE_SPI_RDATA_4 (EFS_REG_BASE+0x0000005c)
#define ADR_EFUSE_SPI_RDATA_5 (EFS_REG_BASE+0x00000060)
#define ADR_EFUSE_SPI_RDATA_6 (EFS_REG_BASE+0x00000064)
#define ADR_EFUSE_SPI_RDATA_7 (EFS_REG_BASE+0x00000068)
#define ADR_SMS4_CFG1 (SMS4_REG_BASE+0x00000000)
#define ADR_SMS4_CFG2 (SMS4_REG_BASE+0x00000004)
#define ADR_SMS4_MODE1 (SMS4_REG_BASE+0x00000008)
#define ADR_SMS4_TRIG (SMS4_REG_BASE+0x00000010)
#define ADR_SMS4_STATUS1 (SMS4_REG_BASE+0x00000014)
#define ADR_SMS4_STATUS2 (SMS4_REG_BASE+0x00000018)
#define ADR_SMS4_DATA_IN0 (SMS4_REG_BASE+0x00000020)
#define ADR_SMS4_DATA_IN1 (SMS4_REG_BASE+0x00000024)
#define ADR_SMS4_DATA_IN2 (SMS4_REG_BASE+0x00000028)
#define ADR_SMS4_DATA_IN3 (SMS4_REG_BASE+0x0000002c)
#define ADR_SMS4_DATA_OUT0 (SMS4_REG_BASE+0x00000030)
#define ADR_SMS4_DATA_OUT1 (SMS4_REG_BASE+0x00000034)
#define ADR_SMS4_DATA_OUT2 (SMS4_REG_BASE+0x00000038)
#define ADR_SMS4_DATA_OUT3 (SMS4_REG_BASE+0x0000003c)
#define ADR_SMS4_KEY_0 (SMS4_REG_BASE+0x00000040)
#define ADR_SMS4_KEY_1 (SMS4_REG_BASE+0x00000044)
#define ADR_SMS4_KEY_2 (SMS4_REG_BASE+0x00000048)
#define ADR_SMS4_KEY_3 (SMS4_REG_BASE+0x0000004c)
#define ADR_SMS4_MODE_IV0 (SMS4_REG_BASE+0x00000050)
#define ADR_SMS4_MODE_IV1 (SMS4_REG_BASE+0x00000054)
#define ADR_SMS4_MODE_IV2 (SMS4_REG_BASE+0x00000058)
#define ADR_SMS4_MODE_IV3 (SMS4_REG_BASE+0x0000005c)
#define ADR_SMS4_OFB_ENC0 (SMS4_REG_BASE+0x00000060)
#define ADR_SMS4_OFB_ENC1 (SMS4_REG_BASE+0x00000064)
#define ADR_SMS4_OFB_ENC2 (SMS4_REG_BASE+0x00000068)
#define ADR_SMS4_OFB_ENC3 (SMS4_REG_BASE+0x0000006c)
#define ADR_MRX_MCAST_TB0_0 (MRX_REG_BASE+0x00000000)
#define ADR_MRX_MCAST_TB0_1 (MRX_REG_BASE+0x00000004)
#define ADR_MRX_MCAST_MK0_0 (MRX_REG_BASE+0x00000008)
#define ADR_MRX_MCAST_MK0_1 (MRX_REG_BASE+0x0000000c)
#define ADR_MRX_MCAST_CTRL0 (MRX_REG_BASE+0x00000010)
#define ADR_MRX_MCAST_TB1_0 (MRX_REG_BASE+0x00000014)
#define ADR_MRX_MCAST_TB1_1 (MRX_REG_BASE+0x00000018)
#define ADR_MRX_MCAST_MK1_0 (MRX_REG_BASE+0x0000001c)
#define ADR_MRX_MCAST_MK1_1 (MRX_REG_BASE+0x00000020)
#define ADR_MRX_MCAST_CTRL1 (MRX_REG_BASE+0x00000024)
#define ADR_MRX_MCAST_TB2_0 (MRX_REG_BASE+0x00000028)
#define ADR_MRX_MCAST_TB2_1 (MRX_REG_BASE+0x0000002c)
#define ADR_MRX_MCAST_MK2_0 (MRX_REG_BASE+0x00000030)
#define ADR_MRX_MCAST_MK2_1 (MRX_REG_BASE+0x00000034)
#define ADR_MRX_MCAST_CTRL2 (MRX_REG_BASE+0x00000038)
#define ADR_MRX_MCAST_TB3_0 (MRX_REG_BASE+0x0000003c)
#define ADR_MRX_MCAST_TB3_1 (MRX_REG_BASE+0x00000040)
#define ADR_MRX_MCAST_MK3_0 (MRX_REG_BASE+0x00000044)
#define ADR_MRX_MCAST_MK3_1 (MRX_REG_BASE+0x00000048)
#define ADR_MRX_MCAST_CTRL3 (MRX_REG_BASE+0x0000004c)
#define ADR_MRX_PHY_INFO (MRX_REG_BASE+0x00000050)
#define ADR_MRX_BA_DBG (MRX_REG_BASE+0x00000054)
#define ADR_MRX_FLT_TB0 (MRX_REG_BASE+0x00000070)
#define ADR_MRX_FLT_TB1 (MRX_REG_BASE+0x00000074)
#define ADR_MRX_FLT_TB2 (MRX_REG_BASE+0x00000078)
#define ADR_MRX_FLT_TB3 (MRX_REG_BASE+0x0000007c)
#define ADR_MRX_FLT_TB4 (MRX_REG_BASE+0x00000080)
#define ADR_MRX_FLT_TB5 (MRX_REG_BASE+0x00000084)
#define ADR_MRX_FLT_TB6 (MRX_REG_BASE+0x00000088)
#define ADR_MRX_FLT_TB7 (MRX_REG_BASE+0x0000008c)
#define ADR_MRX_FLT_TB8 (MRX_REG_BASE+0x00000090)
#define ADR_MRX_FLT_TB9 (MRX_REG_BASE+0x00000094)
#define ADR_MRX_FLT_TB10 (MRX_REG_BASE+0x00000098)
#define ADR_MRX_FLT_TB11 (MRX_REG_BASE+0x0000009c)
#define ADR_MRX_FLT_TB12 (MRX_REG_BASE+0x000000a0)
#define ADR_MRX_FLT_TB13 (MRX_REG_BASE+0x000000a4)
#define ADR_MRX_FLT_TB14 (MRX_REG_BASE+0x000000a8)
#define ADR_MRX_FLT_TB15 (MRX_REG_BASE+0x000000ac)
#define ADR_MRX_FLT_EN0 (MRX_REG_BASE+0x000000b0)
#define ADR_MRX_FLT_EN1 (MRX_REG_BASE+0x000000b4)
#define ADR_MRX_FLT_EN2 (MRX_REG_BASE+0x000000b8)
#define ADR_MRX_FLT_EN3 (MRX_REG_BASE+0x000000bc)
#define ADR_MRX_FLT_EN4 (MRX_REG_BASE+0x000000c0)
#define ADR_MRX_FLT_EN5 (MRX_REG_BASE+0x000000c4)
#define ADR_MRX_FLT_EN6 (MRX_REG_BASE+0x000000c8)
#define ADR_MRX_FLT_EN7 (MRX_REG_BASE+0x000000cc)
#define ADR_MRX_FLT_EN8 (MRX_REG_BASE+0x000000d0)
#define ADR_MRX_LEN_FLT (MRX_REG_BASE+0x000000d4)
#define ADR_RX_FLOW_DATA (MRX_REG_BASE+0x000000e0)
#define ADR_RX_FLOW_MNG (MRX_REG_BASE+0x000000e4)
#define ADR_RX_FLOW_CTRL (MRX_REG_BASE+0x000000e8)
#define ADR_RX_TIME_STAMP_CFG (MRX_REG_BASE+0x000000ec)
#define ADR_DBG_FF_FULL (MRX_REG_BASE+0x000000f0)
#define ADR_DBG_WFF_FULL (MRX_REG_BASE+0x000000f4)
#define ADR_DBG_MB_FULL (MRX_REG_BASE+0x000000f8)
#define ADR_BA_CTRL (MRX_REG_BASE+0x00000100)
#define ADR_BA_TA_0 (MRX_REG_BASE+0x00000104)
#define ADR_BA_TA_1 (MRX_REG_BASE+0x00000108)
#define ADR_BA_TID (MRX_REG_BASE+0x0000010c)
#define ADR_BA_ST_SEQ (MRX_REG_BASE+0x00000110)
#define ADR_BA_SB0 (MRX_REG_BASE+0x00000114)
#define ADR_BA_SB1 (MRX_REG_BASE+0x00000118)
#define ADR_MRX_WATCH_DOG (MRX_REG_BASE+0x0000011c)
#define ADR_ACK_GEN_EN (MRX_REG_BASE+0x00000120)
#define ADR_ACK_GEN_PARA (MRX_REG_BASE+0x00000124)
#define ADR_ACK_GEN_RA_0 (MRX_REG_BASE+0x00000128)
#define ADR_ACK_GEN_RA_1 (MRX_REG_BASE+0x0000012c)
#define ADR_MIB_LEN_FAIL (MRX_REG_BASE+0x00000130)
#define ADR_TRAP_HW_ID (MRX_REG_BASE+0x00000134)
#define ADR_ID_IN_USE (MRX_REG_BASE+0x00000138)
#define ADR_MRX_ERR (MRX_REG_BASE+0x0000013c)
#define ADR_WSID0_TID0_RX_SEQ (MRX_REG_BASE+0x00000140)
#define ADR_WSID0_TID1_RX_SEQ (MRX_REG_BASE+0x00000144)
#define ADR_WSID0_TID2_RX_SEQ (MRX_REG_BASE+0x00000148)
#define ADR_WSID0_TID3_RX_SEQ (MRX_REG_BASE+0x0000014c)
#define ADR_WSID0_TID4_RX_SEQ (MRX_REG_BASE+0x00000150)
#define ADR_WSID0_TID5_RX_SEQ (MRX_REG_BASE+0x00000154)
#define ADR_WSID0_TID6_RX_SEQ (MRX_REG_BASE+0x00000158)
#define ADR_WSID0_TID7_RX_SEQ (MRX_REG_BASE+0x0000015c)
#define ADR_WSID1_TID0_RX_SEQ (MRX_REG_BASE+0x00000170)
#define ADR_WSID1_TID1_RX_SEQ (MRX_REG_BASE+0x00000174)
#define ADR_WSID1_TID2_RX_SEQ (MRX_REG_BASE+0x00000178)
#define ADR_WSID1_TID3_RX_SEQ (MRX_REG_BASE+0x0000017c)
#define ADR_WSID1_TID4_RX_SEQ (MRX_REG_BASE+0x00000180)
#define ADR_WSID1_TID5_RX_SEQ (MRX_REG_BASE+0x00000184)
#define ADR_WSID1_TID6_RX_SEQ (MRX_REG_BASE+0x00000188)
#define ADR_WSID1_TID7_RX_SEQ (MRX_REG_BASE+0x0000018c)
#define ADR_HDR_ADDR_SEL (MRX_REG_BASE+0x00000190)
#define ADR_FRAME_TYPE_CNTR_SET (MRX_REG_BASE+0x00000194)
#define ADR_PHY_INFO (AMPDU_REG_BASE+0x00000000)
#define ADR_AMPDU_SIG (AMPDU_REG_BASE+0x00000004)
#define ADR_MIB_AMPDU (AMPDU_REG_BASE+0x00000008)
#define ADR_LEN_FLT (AMPDU_REG_BASE+0x0000000c)
#define ADR_MIB_DELIMITER (AMPDU_REG_BASE+0x00000010)
#define ADR_MTX_INT_STS (MT_REG_CSR_BASE+0x00000000)
#define ADR_MTX_INT_EN (MT_REG_CSR_BASE+0x00000004)
#define ADR_MTX_MISC_EN (MT_REG_CSR_BASE+0x00000008)
#define ADR_MTX_EDCCA_TOUT (MT_REG_CSR_BASE+0x00000010)
#define ADR_MTX_BCN_INT_STS (MT_REG_CSR_BASE+0x000000a0)
#define ADR_MTX_BCN_EN_INT (MT_REG_CSR_BASE+0x000000a4)
#define ADR_MTX_BCN_EN_MISC (MT_REG_CSR_BASE+0x000000a8)
#define ADR_MTX_BCN_MISC (MT_REG_CSR_BASE+0x000000ac)
#define ADR_MTX_BCN_PRD (MT_REG_CSR_BASE+0x000000b0)
#define ADR_MTX_BCN_TSF_L (MT_REG_CSR_BASE+0x000000b4)
#define ADR_MTX_BCN_TSF_U (MT_REG_CSR_BASE+0x000000b8)
#define ADR_MTX_BCN_CFG0 (MT_REG_CSR_BASE+0x000000bc)
#define ADR_MTX_BCN_CFG1 (MT_REG_CSR_BASE+0x000000c0)
#define ADR_MTX_STATUS (MT_REG_CSR_BASE+0x000000cc)
#define ADR_MTX_DBG_CTRL (MT_REG_CSR_BASE+0x000000d0)
#define ADR_MTX_DBG_DAT0 (MT_REG_CSR_BASE+0x000000d4)
#define ADR_MTX_DBG_DAT1 (MT_REG_CSR_BASE+0x000000d8)
#define ADR_MTX_DBG_DAT2 (MT_REG_CSR_BASE+0x000000dc)
#define ADR_MTX_DUR_TOUT (MT_REG_CSR_BASE+0x000000e0)
#define ADR_MTX_DUR_IFS (MT_REG_CSR_BASE+0x000000e4)
#define ADR_MTX_DUR_SIFS_G (MT_REG_CSR_BASE+0x000000e8)
#define ADR_MTX_DBG_DAT3 (MT_REG_CSR_BASE+0x000000ec)
#define ADR_MTX_NAV (MT_REG_CSR_BASE+0x000000f0)
#define ADR_MTX_MIB_WSID0 (MT_REG_CSR_BASE+0x000000f4)
#define ADR_MTX_MIB_WSID1 (MT_REG_CSR_BASE+0x000000f8)
#define ADR_MTX_DBG_DAT4 (MT_REG_CSR_BASE+0x000000fc)
#define ADR_TXQ0_MTX_Q_MISC_EN (TXQ0_MT_Q_REG_CSR_BASE+0x00000000)
#define ADR_TXQ0_MTX_Q_AIFSN (TXQ0_MT_Q_REG_CSR_BASE+0x00000004)
#define ADR_TXQ0_MTX_Q_BKF_CNT (TXQ0_MT_Q_REG_CSR_BASE+0x00000008)
#define ADR_TXQ0_MTX_Q_RC_LIMIT (TXQ0_MT_Q_REG_CSR_BASE+0x0000000c)
#define ADR_TXQ0_MTX_Q_ID_MAP_L (TXQ0_MT_Q_REG_CSR_BASE+0x00000010)
#define ADR_TXQ0_MTX_Q_TXOP_CH_THD (TXQ0_MT_Q_REG_CSR_BASE+0x00000014)
#define ADR_TXQ0_MTX_Q_TXOP_OV_THD (TXQ0_MT_Q_REG_CSR_BASE+0x00000018)
#define ADR_TXQ1_MTX_Q_MISC_EN (TXQ1_MT_Q_REG_CSR_BASE+0x00000000)
#define ADR_TXQ1_MTX_Q_AIFSN (TXQ1_MT_Q_REG_CSR_BASE+0x00000004)
#define ADR_TXQ1_MTX_Q_BKF_CNT (TXQ1_MT_Q_REG_CSR_BASE+0x00000008)
#define ADR_TXQ1_MTX_Q_RC_LIMIT (TXQ1_MT_Q_REG_CSR_BASE+0x0000000c)
#define ADR_TXQ1_MTX_Q_ID_MAP_L (TXQ1_MT_Q_REG_CSR_BASE+0x00000010)
#define ADR_TXQ1_MTX_Q_TXOP_CH_THD (TXQ1_MT_Q_REG_CSR_BASE+0x00000014)
#define ADR_TXQ1_MTX_Q_TXOP_OV_THD (TXQ1_MT_Q_REG_CSR_BASE+0x00000018)
#define ADR_TXQ2_MTX_Q_MISC_EN (TXQ2_MT_Q_REG_CSR_BASE+0x00000000)
#define ADR_TXQ2_MTX_Q_AIFSN (TXQ2_MT_Q_REG_CSR_BASE+0x00000004)
#define ADR_TXQ2_MTX_Q_BKF_CNT (TXQ2_MT_Q_REG_CSR_BASE+0x00000008)
#define ADR_TXQ2_MTX_Q_RC_LIMIT (TXQ2_MT_Q_REG_CSR_BASE+0x0000000c)
#define ADR_TXQ2_MTX_Q_ID_MAP_L (TXQ2_MT_Q_REG_CSR_BASE+0x00000010)
#define ADR_TXQ2_MTX_Q_TXOP_CH_THD (TXQ2_MT_Q_REG_CSR_BASE+0x00000014)
#define ADR_TXQ2_MTX_Q_TXOP_OV_THD (TXQ2_MT_Q_REG_CSR_BASE+0x00000018)
#define ADR_TXQ3_MTX_Q_MISC_EN (TXQ3_MT_Q_REG_CSR_BASE+0x00000000)
#define ADR_TXQ3_MTX_Q_AIFSN (TXQ3_MT_Q_REG_CSR_BASE+0x00000004)
#define ADR_TXQ3_MTX_Q_BKF_CNT (TXQ3_MT_Q_REG_CSR_BASE+0x00000008)
#define ADR_TXQ3_MTX_Q_RC_LIMIT (TXQ3_MT_Q_REG_CSR_BASE+0x0000000c)
#define ADR_TXQ3_MTX_Q_ID_MAP_L (TXQ3_MT_Q_REG_CSR_BASE+0x00000010)
#define ADR_TXQ3_MTX_Q_TXOP_CH_THD (TXQ3_MT_Q_REG_CSR_BASE+0x00000014)
#define ADR_TXQ3_MTX_Q_TXOP_OV_THD (TXQ3_MT_Q_REG_CSR_BASE+0x00000018)
#define ADR_TXQ4_MTX_Q_MISC_EN (TXQ4_MT_Q_REG_CSR_BASE+0x00000000)
#define ADR_TXQ4_MTX_Q_AIFSN (TXQ4_MT_Q_REG_CSR_BASE+0x00000004)
#define ADR_TXQ4_MTX_Q_BKF_CNT (TXQ4_MT_Q_REG_CSR_BASE+0x00000008)
#define ADR_TXQ4_MTX_Q_RC_LIMIT (TXQ4_MT_Q_REG_CSR_BASE+0x0000000c)
#define ADR_TXQ4_MTX_Q_ID_MAP_L (TXQ4_MT_Q_REG_CSR_BASE+0x00000010)
#define ADR_TXQ4_MTX_Q_TXOP_CH_THD (TXQ4_MT_Q_REG_CSR_BASE+0x00000014)
#define ADR_TXQ4_MTX_Q_TXOP_OV_THD (TXQ4_MT_Q_REG_CSR_BASE+0x00000018)
#define ADR_WSID0 (HIF_INFO_BASE+0x00000000)
#define ADR_PEER_MAC0_0 (HIF_INFO_BASE+0x00000004)
#define ADR_PEER_MAC0_1 (HIF_INFO_BASE+0x00000008)
#define ADR_TX_ACK_POLICY_0_0 (HIF_INFO_BASE+0x0000000c)
#define ADR_TX_SEQ_CTRL_0_0 (HIF_INFO_BASE+0x00000010)
#define ADR_TX_ACK_POLICY_0_1 (HIF_INFO_BASE+0x00000014)
#define ADR_TX_SEQ_CTRL_0_1 (HIF_INFO_BASE+0x00000018)
#define ADR_TX_ACK_POLICY_0_2 (HIF_INFO_BASE+0x0000001c)
#define ADR_TX_SEQ_CTRL_0_2 (HIF_INFO_BASE+0x00000020)
#define ADR_TX_ACK_POLICY_0_3 (HIF_INFO_BASE+0x00000024)
#define ADR_TX_SEQ_CTRL_0_3 (HIF_INFO_BASE+0x00000028)
#define ADR_TX_ACK_POLICY_0_4 (HIF_INFO_BASE+0x0000002c)
#define ADR_TX_SEQ_CTRL_0_4 (HIF_INFO_BASE+0x00000030)
#define ADR_TX_ACK_POLICY_0_5 (HIF_INFO_BASE+0x00000034)
#define ADR_TX_SEQ_CTRL_0_5 (HIF_INFO_BASE+0x00000038)
#define ADR_TX_ACK_POLICY_0_6 (HIF_INFO_BASE+0x0000003c)
#define ADR_TX_SEQ_CTRL_0_6 (HIF_INFO_BASE+0x00000040)
#define ADR_TX_ACK_POLICY_0_7 (HIF_INFO_BASE+0x00000044)
#define ADR_TX_SEQ_CTRL_0_7 (HIF_INFO_BASE+0x00000048)
#define ADR_WSID1 (HIF_INFO_BASE+0x00000050)
#define ADR_PEER_MAC1_0 (HIF_INFO_BASE+0x00000054)
#define ADR_PEER_MAC1_1 (HIF_INFO_BASE+0x00000058)
#define ADR_TX_ACK_POLICY_1_0 (HIF_INFO_BASE+0x0000005c)
#define ADR_TX_SEQ_CTRL_1_0 (HIF_INFO_BASE+0x00000060)
#define ADR_TX_ACK_POLICY_1_1 (HIF_INFO_BASE+0x00000064)
#define ADR_TX_SEQ_CTRL_1_1 (HIF_INFO_BASE+0x00000068)
#define ADR_TX_ACK_POLICY_1_2 (HIF_INFO_BASE+0x0000006c)
#define ADR_TX_SEQ_CTRL_1_2 (HIF_INFO_BASE+0x00000070)
#define ADR_TX_ACK_POLICY_1_3 (HIF_INFO_BASE+0x00000074)
#define ADR_TX_SEQ_CTRL_1_3 (HIF_INFO_BASE+0x00000078)
#define ADR_TX_ACK_POLICY_1_4 (HIF_INFO_BASE+0x0000007c)
#define ADR_TX_SEQ_CTRL_1_4 (HIF_INFO_BASE+0x00000080)
#define ADR_TX_ACK_POLICY_1_5 (HIF_INFO_BASE+0x00000084)
#define ADR_TX_SEQ_CTRL_1_5 (HIF_INFO_BASE+0x00000088)
#define ADR_TX_ACK_POLICY_1_6 (HIF_INFO_BASE+0x0000008c)
#define ADR_TX_SEQ_CTRL_1_6 (HIF_INFO_BASE+0x00000090)
#define ADR_TX_ACK_POLICY_1_7 (HIF_INFO_BASE+0x00000094)
#define ADR_TX_SEQ_CTRL_1_7 (HIF_INFO_BASE+0x00000098)
#define ADR_INFO0 (PHY_RATE_INFO_BASE+0x00000000)
#define ADR_INFO1 (PHY_RATE_INFO_BASE+0x00000004)
#define ADR_INFO2 (PHY_RATE_INFO_BASE+0x00000008)
#define ADR_INFO3 (PHY_RATE_INFO_BASE+0x0000000c)
#define ADR_INFO4 (PHY_RATE_INFO_BASE+0x00000010)
#define ADR_INFO5 (PHY_RATE_INFO_BASE+0x00000014)
#define ADR_INFO6 (PHY_RATE_INFO_BASE+0x00000018)
#define ADR_INFO7 (PHY_RATE_INFO_BASE+0x0000001c)
#define ADR_INFO8 (PHY_RATE_INFO_BASE+0x00000020)
#define ADR_INFO9 (PHY_RATE_INFO_BASE+0x00000024)
#define ADR_INFO10 (PHY_RATE_INFO_BASE+0x00000028)
#define ADR_INFO11 (PHY_RATE_INFO_BASE+0x0000002c)
#define ADR_INFO12 (PHY_RATE_INFO_BASE+0x00000030)
#define ADR_INFO13 (PHY_RATE_INFO_BASE+0x00000034)
#define ADR_INFO14 (PHY_RATE_INFO_BASE+0x00000038)
#define ADR_INFO15 (PHY_RATE_INFO_BASE+0x0000003c)
#define ADR_INFO16 (PHY_RATE_INFO_BASE+0x00000040)
#define ADR_INFO17 (PHY_RATE_INFO_BASE+0x00000044)
#define ADR_INFO18 (PHY_RATE_INFO_BASE+0x00000048)
#define ADR_INFO19 (PHY_RATE_INFO_BASE+0x0000004c)
#define ADR_INFO20 (PHY_RATE_INFO_BASE+0x00000050)
#define ADR_INFO21 (PHY_RATE_INFO_BASE+0x00000054)
#define ADR_INFO22 (PHY_RATE_INFO_BASE+0x00000058)
#define ADR_INFO23 (PHY_RATE_INFO_BASE+0x0000005c)
#define ADR_INFO24 (PHY_RATE_INFO_BASE+0x00000060)
#define ADR_INFO25 (PHY_RATE_INFO_BASE+0x00000064)
#define ADR_INFO26 (PHY_RATE_INFO_BASE+0x00000068)
#define ADR_INFO27 (PHY_RATE_INFO_BASE+0x0000006c)
#define ADR_INFO28 (PHY_RATE_INFO_BASE+0x00000070)
#define ADR_INFO29 (PHY_RATE_INFO_BASE+0x00000074)
#define ADR_INFO30 (PHY_RATE_INFO_BASE+0x00000078)
#define ADR_INFO31 (PHY_RATE_INFO_BASE+0x0000007c)
#define ADR_INFO32 (PHY_RATE_INFO_BASE+0x00000080)
#define ADR_INFO33 (PHY_RATE_INFO_BASE+0x00000084)
#define ADR_INFO34 (PHY_RATE_INFO_BASE+0x00000088)
#define ADR_INFO35 (PHY_RATE_INFO_BASE+0x0000008c)
#define ADR_INFO36 (PHY_RATE_INFO_BASE+0x00000090)
#define ADR_INFO37 (PHY_RATE_INFO_BASE+0x00000094)
#define ADR_INFO38 (PHY_RATE_INFO_BASE+0x00000098)
#define ADR_INFO_MASK (PHY_RATE_INFO_BASE+0x0000009c)
#define ADR_INFO_RATE_OFFSET (PHY_RATE_INFO_BASE+0x000000a0)
#define ADR_INFO_IDX_ADDR (PHY_RATE_INFO_BASE+0x000000a4)
#define ADR_INFO_LEN_ADDR (PHY_RATE_INFO_BASE+0x000000a8)
#define ADR_IC_TIME_TAG_0 (PHY_RATE_INFO_BASE+0x000000ac)
#define ADR_IC_TIME_TAG_1 (PHY_RATE_INFO_BASE+0x000000b0)
#define ADR_PACKET_ID_ALLOCATION_PRIORITY (PHY_RATE_INFO_BASE+0x000000b4)
#define ADR_MAC_MODE (MAC_GLB_SET_BASE+0x00000000)
#define ADR_ALL_SOFTWARE_RESET (MAC_GLB_SET_BASE+0x00000004)
#define ADR_ENG_SOFTWARE_RESET (MAC_GLB_SET_BASE+0x00000008)
#define ADR_CSR_SOFTWARE_RESET (MAC_GLB_SET_BASE+0x0000000c)
#define ADR_MAC_CLOCK_ENABLE (MAC_GLB_SET_BASE+0x00000010)
#define ADR_MAC_ENGINE_CLOCK_ENABLE (MAC_GLB_SET_BASE+0x00000014)
#define ADR_MAC_CSR_CLOCK_ENABLE (MAC_GLB_SET_BASE+0x00000018)
#define ADR_GLBLE_SET (MAC_GLB_SET_BASE+0x0000001c)
#define ADR_REASON_TRAP0 (MAC_GLB_SET_BASE+0x00000020)
#define ADR_REASON_TRAP1 (MAC_GLB_SET_BASE+0x00000024)
#define ADR_BSSID_0 (MAC_GLB_SET_BASE+0x00000028)
#define ADR_BSSID_1 (MAC_GLB_SET_BASE+0x0000002c)
#define ADR_SCRT_STATE (MAC_GLB_SET_BASE+0x0000002c)
#define ADR_STA_MAC_0 (MAC_GLB_SET_BASE+0x00000030)
#define ADR_STA_MAC_1 (MAC_GLB_SET_BASE+0x00000034)
#define ADR_SCRT_SET (MAC_GLB_SET_BASE+0x00000038)
#define ADR_BTCX0 (BTCX_REG_BASE+0x00000000)
#define ADR_BTCX1 (BTCX_REG_BASE+0x00000004)
#define ADR_SWITCH_CTL (BTCX_REG_BASE+0x00000008)
#define ADR_MIB_EN (MIB_REG_BASE+0x00000000)
#define ADR_MTX_WSID0_SUCC (MIB_REG_BASE+0x00000118)
#define ADR_MTX_WSID0_FRM (MIB_REG_BASE+0x00000128)
#define ADR_MTX_WSID0_RETRY (MIB_REG_BASE+0x00000138)
#define ADR_MTX_WSID0_TOTAL (MIB_REG_BASE+0x00000148)
#define ADR_MTX_GROUP (MIB_REG_BASE+0x0000016c)
#define ADR_MTX_FAIL (MIB_REG_BASE+0x00000170)
#define ADR_MTX_RETRY (MIB_REG_BASE+0x00000174)
#define ADR_MTX_MULTI_RETRY (MIB_REG_BASE+0x00000178)
#define ADR_MTX_RTS_SUCCESS (MIB_REG_BASE+0x0000017c)
#define ADR_MTX_RTS_FAIL (MIB_REG_BASE+0x00000180)
#define ADR_MTX_ACK_FAIL (MIB_REG_BASE+0x00000184)
#define ADR_MTX_FRM (MIB_REG_BASE+0x00000188)
#define ADR_MTX_ACK_TX (MIB_REG_BASE+0x0000018c)
#define ADR_MTX_CTS_TX (MIB_REG_BASE+0x00000190)
#define ADR_MRX_DUP_FRM (MIB_REG_BASE+0x00000194)
#define ADR_MRX_FRG_FRM (MIB_REG_BASE+0x00000198)
#define ADR_MRX_GROUP_FRM (MIB_REG_BASE+0x0000019c)
#define ADR_MRX_FCS_ERR (MIB_REG_BASE+0x000001a0)
#define ADR_MRX_FCS_SUCC (MIB_REG_BASE+0x000001a4)
#define ADR_MRX_MISS (MIB_REG_BASE+0x000001a8)
#define ADR_MRX_ALC_FAIL (MIB_REG_BASE+0x000001ac)
#define ADR_MRX_DAT_NTF (MIB_REG_BASE+0x000001b0)
#define ADR_MRX_RTS_NTF (MIB_REG_BASE+0x000001b4)
#define ADR_MRX_CTS_NTF (MIB_REG_BASE+0x000001b8)
#define ADR_MRX_ACK_NTF (MIB_REG_BASE+0x000001bc)
#define ADR_MRX_BA_NTF (MIB_REG_BASE+0x000001c0)
#define ADR_MRX_DATA_NTF (MIB_REG_BASE+0x000001c4)
#define ADR_MRX_MNG_NTF (MIB_REG_BASE+0x000001c8)
#define ADR_MRX_DAT_CRC_NTF (MIB_REG_BASE+0x000001cc)
#define ADR_MRX_BAR_NTF (MIB_REG_BASE+0x000001d0)
#define ADR_MRX_MB_MISS (MIB_REG_BASE+0x000001d4)
#define ADR_MRX_NIDLE_MISS (MIB_REG_BASE+0x000001d8)
#define ADR_MRX_CSR_NTF (MIB_REG_BASE+0x000001dc)
#define ADR_DBG_Q0_FRM_SUCCESS (MIB_REG_BASE+0x00000218)
#define ADR_DBG_Q0_FRM_FAIL (MIB_REG_BASE+0x0000021c)
#define ADR_DBG_Q0_ACK_SUCCESS (MIB_REG_BASE+0x00000220)
#define ADR_DBG_Q0_ACK_FAIL (MIB_REG_BASE+0x00000224)
#define ADR_DBG_Q1_FRM_SUCCESS (MIB_REG_BASE+0x00000268)
#define ADR_DBG_Q1_FRM_FAIL (MIB_REG_BASE+0x0000026c)
#define ADR_DBG_Q1_ACK_SUCCESS (MIB_REG_BASE+0x00000270)
#define ADR_DBG_Q1_ACK_FAIL (MIB_REG_BASE+0x00000274)
#define ADR_DBG_Q2_FRM_SUCCESS (MIB_REG_BASE+0x00000318)
#define ADR_DBG_Q2_FRM_FAIL (MIB_REG_BASE+0x0000031c)
#define ADR_DBG_Q2_ACK_SUCCESS (MIB_REG_BASE+0x00000320)
#define ADR_DBG_Q2_ACK_FAIL (MIB_REG_BASE+0x00000324)
#define ADR_DBG_Q3_FRM_SUCCESS (MIB_REG_BASE+0x00000368)
#define ADR_DBG_Q3_FRM_FAIL (MIB_REG_BASE+0x0000036c)
#define ADR_DBG_Q3_ACK_SUCCESS (MIB_REG_BASE+0x00000370)
#define ADR_DBG_Q3_ACK_FAIL (MIB_REG_BASE+0x00000374)
#define ADR_MIB_SCRT_TKIP0 (MIB_REG_BASE+0x00000418)
#define ADR_MIB_SCRT_TKIP1 (MIB_REG_BASE+0x0000041c)
#define ADR_MIB_SCRT_TKIP2 (MIB_REG_BASE+0x00000420)
#define ADR_MIB_SCRT_CCMP0 (MIB_REG_BASE+0x00000424)
#define ADR_MIB_SCRT_CCMP1 (MIB_REG_BASE+0x00000428)
#define ADR_DBG_LEN_CRC_FAIL (MIB_REG_BASE+0x00000468)
#define ADR_DBG_LEN_ALC_FAIL (MIB_REG_BASE+0x0000046c)
#define ADR_DBG_AMPDU_PASS (MIB_REG_BASE+0x00000470)
#define ADR_DBG_AMPDU_FAIL (MIB_REG_BASE+0x00000474)
#define ADR_ID_ALC_FAIL1 (MIB_REG_BASE+0x00000478)
#define ADR_ID_ALC_FAIL2 (MIB_REG_BASE+0x0000047c)
#define ADR_CBR_HARD_WIRE_PIN_REGISTER (CBR_A_REG_BASE+0x00110000)
#define ADR_CBR_MANUAL_ENABLE_REGISTER (CBR_A_REG_BASE+0x00110004)
#define ADR_CBR_LDO_REGISTER (CBR_A_REG_BASE+0x00110008)
#define ADR_CBR_ABB_REGISTER_1 (CBR_A_REG_BASE+0x0011000c)
#define ADR_CBR_ABB_REGISTER_2 (CBR_A_REG_BASE+0x00110010)
#define ADR_CBR_TX_FE_REGISTER (CBR_A_REG_BASE+0x00110014)
#define ADR_CBR_RX_FE_REGISTER_1 (CBR_A_REG_BASE+0x00110018)
#define ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1 (CBR_A_REG_BASE+0x0011001c)
#define ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2 (CBR_A_REG_BASE+0x00110020)
#define ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3 (CBR_A_REG_BASE+0x00110024)
#define ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4 (CBR_A_REG_BASE+0x00110028)
#define ADR_CBR_RX_FSM_REGISTER (CBR_A_REG_BASE+0x0011002c)
#define ADR_CBR_RX_ADC_REGISTER (CBR_A_REG_BASE+0x00110030)
#define ADR_CBR_TX_DAC_REGISTER (CBR_A_REG_BASE+0x00110034)
#define ADR_CBR_SX_ENABLE_RGISTER (CBR_A_REG_BASE+0x00110038)
#define ADR_CBR_SYN_RGISTER_1 (CBR_A_REG_BASE+0x0011003c)
#define ADR_CBR_SYN_RGISTER_2 (CBR_A_REG_BASE+0x00110040)
#define ADR_CBR_SYN_PFD_CHP (CBR_A_REG_BASE+0x00110044)
#define ADR_CBR_SYN_VCO_LOBF (CBR_A_REG_BASE+0x00110048)
#define ADR_CBR_SYN_DIV_SDM_XOSC (CBR_A_REG_BASE+0x0011004c)
#define ADR_CBR_SYN_LCK1 (CBR_A_REG_BASE+0x00110050)
#define ADR_CBR_SYN_LCK2 (CBR_A_REG_BASE+0x00110054)
#define ADR_CBR_DPLL_VCO_REGISTER (CBR_A_REG_BASE+0x00110058)
#define ADR_CBR_DPLL_CP_PFD_REGISTER (CBR_A_REG_BASE+0x0011005c)
#define ADR_CBR_DPLL_DIVIDER_REGISTER (CBR_A_REG_BASE+0x00110060)
#define ADR_CBR_DCOC_IDAC_REGISTER1 (CBR_A_REG_BASE+0x00110064)
#define ADR_CBR_DCOC_IDAC_REGISTER2 (CBR_A_REG_BASE+0x00110068)
#define ADR_CBR_DCOC_IDAC_REGISTER3 (CBR_A_REG_BASE+0x0011006c)
#define ADR_CBR_DCOC_IDAC_REGISTER4 (CBR_A_REG_BASE+0x00110070)
#define ADR_CBR_DCOC_IDAC_REGISTER5 (CBR_A_REG_BASE+0x00110074)
#define ADR_CBR_DCOC_IDAC_REGISTER6 (CBR_A_REG_BASE+0x00110078)
#define ADR_CBR_DCOC_IDAC_REGISTER7 (CBR_A_REG_BASE+0x0011007c)
#define ADR_CBR_DCOC_IDAC_REGISTER8 (CBR_A_REG_BASE+0x00110080)
#define ADR_CBR_RCAL_REGISTER (CBR_A_REG_BASE+0x00110084)
#define ADR_CBR_MANUAL_REGISTER (CBR_A_REG_BASE+0x00110088)
#define ADR_CBR_TRX_DUMMY_REGISTER (CBR_A_REG_BASE+0x0011008c)
#define ADR_CBR_SX_DUMMY_REGISTER (CBR_A_REG_BASE+0x00110090)
#define ADR_CBR_READ_ONLY_FLAGS_1 (CBR_A_REG_BASE+0x00110094)
#define ADR_CBR_READ_ONLY_FLAGS_2 (CBR_A_REG_BASE+0x00110098)
#define ADR_CBR_RG_PKT_GEN_0 (CBR_A_REG_BASE+0x00120080)
#define ADR_CBR_RG_PKT_GEN_1 (CBR_A_REG_BASE+0x00120084)
#define ADR_CBR_RG_PKT_GEN_2 (CBR_A_REG_BASE+0x00120088)
#define ADR_CBR_RG_INTEGRATION (CBR_A_REG_BASE+0x00120090)
#define ADR_CBR_RG_PKT_GEN_TXCNT (CBR_A_REG_BASE+0x00120094)
#define ADR_CBR_PATTERN_GEN (CBR_A_REG_BASE+0x001203f8)
#define ADR_MB_CPU_INT (MB_REG_BASE+0x00000004)
#define ADR_CPU_ID_TB0 (MB_REG_BASE+0x00000008)
#define ADR_CPU_ID_TB1 (MB_REG_BASE+0x0000000c)
#define ADR_CH0_TRIG_1 (MB_REG_BASE+0x00000010)
#define ADR_CH0_TRIG_0 (MB_REG_BASE+0x00000010)
#define ADR_CH0_PRI_TRIG (MB_REG_BASE+0x00000014)
#define ADR_MCU_STATUS (MB_REG_BASE+0x00000018)
#define ADR_RD_IN_FFCNT1 (MB_REG_BASE+0x0000001c)
#define ADR_RD_IN_FFCNT2 (MB_REG_BASE+0x00000020)
#define ADR_RD_FFIN_FULL (MB_REG_BASE+0x00000024)
#define ADR_MBOX_HALT_CFG (MB_REG_BASE+0x0000002c)
#define ADR_MB_DBG_CFG1 (MB_REG_BASE+0x00000030)
#define ADR_MB_DBG_CFG2 (MB_REG_BASE+0x00000034)
#define ADR_MB_DBG_CFG3 (MB_REG_BASE+0x00000038)
#define ADR_MB_DBG_CFG4 (MB_REG_BASE+0x0000003c)
#define ADR_MB_OUT_QUEUE_CFG (MB_REG_BASE+0x00000040)
#define ADR_MB_OUT_QUEUE_FLUSH (MB_REG_BASE+0x00000044)
#define ADR_RD_FFOUT_CNT1 (MB_REG_BASE+0x00000048)
#define ADR_RD_FFOUT_CNT2 (MB_REG_BASE+0x0000004c)
#define ADR_RD_FFOUT_CNT3 (MB_REG_BASE+0x00000050)
#define ADR_RD_FFOUT_FULL (MB_REG_BASE+0x00000054)
#define ADR_MB_THRESHOLD6 (MB_REG_BASE+0x0000006c)
#define ADR_MB_THRESHOLD7 (MB_REG_BASE+0x00000070)
#define ADR_MB_THRESHOLD8 (MB_REG_BASE+0x00000074)
#define ADR_MB_THRESHOLD9 (MB_REG_BASE+0x00000078)
#define ADR_MB_THRESHOLD10 (MB_REG_BASE+0x0000007c)
#define ADR_MB_TRASH_CFG (MB_REG_BASE+0x00000080)
#define ADR_MB_IN_FF_FLUSH (MB_REG_BASE+0x00000084)
#define ADR_CPU_ID_TB2 (MB_REG_BASE+0x00000088)
#define ADR_CPU_ID_TB3 (MB_REG_BASE+0x0000008c)
#define ADR_PHY_IQ_LOG_CFG0 (MB_REG_BASE+0x00000090)
#define ADR_PHY_IQ_LOG_CFG1 (MB_REG_BASE+0x00000094)
#define ADR_PHY_IQ_LOG_LEN (MB_REG_BASE+0x00000098)
#define ADR_PHY_IQ_LOG_PTR (MB_REG_BASE+0x0000009c)
#define ADR_WR_ALC (ID_MNG_REG_BASE+0x00000000)
#define ADR_GETID (ID_MNG_REG_BASE+0x00000000)
#define ADR_CH_STA_PRI (ID_MNG_REG_BASE+0x00000004)
#define ADR_RD_ID0 (ID_MNG_REG_BASE+0x00000008)
#define ADR_RD_ID1 (ID_MNG_REG_BASE+0x0000000c)
#define ADR_IMD_CFG (ID_MNG_REG_BASE+0x00000010)
#define ADR_IMD_STA (ID_MNG_REG_BASE+0x00000014)
#define ADR_ALC_STA (ID_MNG_REG_BASE+0x00000018)
#define ADR_TRX_ID_COUNT (ID_MNG_REG_BASE+0x0000001c)
#define ADR_TRX_ID_THRESHOLD (ID_MNG_REG_BASE+0x00000020)
#define ADR_TX_ID0 (ID_MNG_REG_BASE+0x00000024)
#define ADR_TX_ID1 (ID_MNG_REG_BASE+0x00000028)
#define ADR_RX_ID0 (ID_MNG_REG_BASE+0x0000002c)
#define ADR_RX_ID1 (ID_MNG_REG_BASE+0x00000030)
#define ADR_RTN_STA (ID_MNG_REG_BASE+0x00000034)
#define ADR_ID_LEN_THREADSHOLD1 (ID_MNG_REG_BASE+0x00000038)
#define ADR_ID_LEN_THREADSHOLD2 (ID_MNG_REG_BASE+0x0000003c)
#define ADR_CH_ARB_PRI (ID_MNG_REG_BASE+0x00000040)
#define ADR_TX_ID_REMAIN_STATUS (ID_MNG_REG_BASE+0x00000044)
#define ADR_ID_INFO_STA (ID_MNG_REG_BASE+0x00000048)
#define ADR_TX_LIMIT_INTR (ID_MNG_REG_BASE+0x0000004c)
#define ADR_TX_ID_ALL_INFO (ID_MNG_REG_BASE+0x00000050)
#define ADR_RD_ID2 (ID_MNG_REG_BASE+0x00000054)
#define ADR_RD_ID3 (ID_MNG_REG_BASE+0x00000058)
#define ADR_TX_ID2 (ID_MNG_REG_BASE+0x0000005c)
#define ADR_TX_ID3 (ID_MNG_REG_BASE+0x00000060)
#define ADR_RX_ID2 (ID_MNG_REG_BASE+0x00000064)
#define ADR_RX_ID3 (ID_MNG_REG_BASE+0x00000068)
#define ADR_TX_ID_ALL_INFO2 (ID_MNG_REG_BASE+0x0000006c)
#define ADR_TX_ID_ALL_INFO_A (ID_MNG_REG_BASE+0x00000070)
#define ADR_TX_ID_ALL_INFO_B (ID_MNG_REG_BASE+0x00000074)
#define ADR_TX_ID_REMAIN_STATUS2 (ID_MNG_REG_BASE+0x00000078)
#define ADR_ALC_ID_INFO (ID_MNG_REG_BASE+0x0000007c)
#define ADR_ALC_ID_INF1 (ID_MNG_REG_BASE+0x00000080)
#define ADR_PHY_EN_0 (CSR_PHY_BASE+0x00000000)
#define ADR_PHY_EN_1 (CSR_PHY_BASE+0x00000004)
#define ADR_SVN_VERSION_REG (CSR_PHY_BASE+0x00000008)
#define ADR_PHY_PKT_GEN_0 (CSR_PHY_BASE+0x0000000c)
#define ADR_PHY_PKT_GEN_1 (CSR_PHY_BASE+0x00000010)
#define ADR_PHY_PKT_GEN_2 (CSR_PHY_BASE+0x00000014)
#define ADR_PHY_PKT_GEN_3 (CSR_PHY_BASE+0x00000018)
#define ADR_PHY_PKT_GEN_4 (CSR_PHY_BASE+0x0000001c)
#define ADR_PHY_REG_00 (CSR_PHY_BASE+0x00000020)
#define ADR_PHY_REG_01 (CSR_PHY_BASE+0x0000002c)
#define ADR_PHY_REG_02_AGC (CSR_PHY_BASE+0x00000030)
#define ADR_PHY_REG_03_AGC (CSR_PHY_BASE+0x00000034)
#define ADR_PHY_REG_04_AGC (CSR_PHY_BASE+0x00000038)
#define ADR_PHY_REG_05_AGC (CSR_PHY_BASE+0x0000003c)
#define ADR_PHY_REG_06_11B_DAGC (CSR_PHY_BASE+0x00000040)
#define ADR_PHY_REG_07_11B_DAGC (CSR_PHY_BASE+0x00000044)
#define ADR_PHY_REG_08_11GN_DAGC (CSR_PHY_BASE+0x00000048)
#define ADR_PHY_REG_09_11GN_DAGC (CSR_PHY_BASE+0x0000004c)
#define ADR_PHY_READ_REG_00_DIG_PWR (CSR_PHY_BASE+0x00000050)
#define ADR_PHY_READ_REG_01_RF_GAIN_PWR (CSR_PHY_BASE+0x00000054)
#define ADR_PHY_READ_REG_02_RF_GAIN_PWR (CSR_PHY_BASE+0x00000058)
#define ADR_PHY_READ_REG_03_RF_GAIN_PWR (CSR_PHY_BASE+0x0000005c)
#define ADR_PHY_REG_10_TX_DES (CSR_PHY_BASE+0x00000060)
#define ADR_PHY_REG_11_TX_DES (CSR_PHY_BASE+0x00000064)
#define ADR_PHY_REG_12_TX_DES (CSR_PHY_BASE+0x00000068)
#define ADR_PHY_REG_13_RX_DES (CSR_PHY_BASE+0x0000006c)
#define ADR_PHY_REG_14_RX_DES (CSR_PHY_BASE+0x00000070)
#define ADR_PHY_REG_15_RX_DES (CSR_PHY_BASE+0x00000074)
#define ADR_PHY_REG_16_TX_DES_EXCP (CSR_PHY_BASE+0x00000078)
#define ADR_PHY_REG_17_TX_DES_EXCP (CSR_PHY_BASE+0x0000007c)
#define ADR_PHY_REG_18_RSSI_SNR (CSR_PHY_BASE+0x00000080)
#define ADR_PHY_REG_19_DAC_MANUAL (CSR_PHY_BASE+0x00000084)
#define ADR_PHY_REG_20_MRX_CNT (CSR_PHY_BASE+0x00000088)
#define ADR_PHY_REG_21_TRX_RAMP (CSR_PHY_BASE+0x00000094)
#define ADR_PHY_REG_22_TRX_RAMP (CSR_PHY_BASE+0x00000098)
#define ADR_PHY_REG_23_ANT (CSR_PHY_BASE+0x0000009c)
#define ADR_PHY_REG_24_MTX_LEN_CNT (CSR_PHY_BASE+0x000000a0)
#define ADR_PHY_REG_25_MTX_LEN_CNT (CSR_PHY_BASE+0x000000a4)
#define ADR_PHY_REG_26_MRX_LEN_CNT (CSR_PHY_BASE+0x000000a8)
#define ADR_PHY_REG_27_MRX_LEN_CNT (CSR_PHY_BASE+0x000000ac)
#define ADR_PHY_READ_REG_04 (CSR_PHY_BASE+0x000000b0)
#define ADR_PHY_READ_REG_05 (CSR_PHY_BASE+0x000000b4)
#define ADR_PHY_REG_28_BIST (CSR_PHY_BASE+0x000000b8)
#define ADR_PHY_READ_REG_06_BIST (CSR_PHY_BASE+0x000000d8)
#define ADR_PHY_READ_REG_07_BIST (CSR_PHY_BASE+0x000000f0)
#define ADR_PHY_REG_29_MTRX_MAC (CSR_PHY_BASE+0x000000fc)
#define ADR_PHY_READ_REG_08_MTRX_MAC (CSR_PHY_BASE+0x00000100)
#define ADR_PHY_READ_REG_09_MTRX_MAC (CSR_PHY_BASE+0x00000104)
#define ADR_PHY_REG_30_TX_UP_FIL (CSR_PHY_BASE+0x00000108)
#define ADR_PHY_REG_31_TX_UP_FIL (CSR_PHY_BASE+0x0000010c)
#define ADR_PHY_REG_32_TX_UP_FIL (CSR_PHY_BASE+0x00000110)
#define ADR_PHY_READ_TBUS (CSR_PHY_BASE+0x000003fc)
#define ADR_TX_11B_FIL_COEF_00 (CSR_PHY_BASE+0x00001000)
#define ADR_TX_11B_FIL_COEF_01 (CSR_PHY_BASE+0x00001004)
#define ADR_TX_11B_FIL_COEF_02 (CSR_PHY_BASE+0x00001008)
#define ADR_TX_11B_FIL_COEF_03 (CSR_PHY_BASE+0x0000100c)
#define ADR_TX_11B_FIL_COEF_04 (CSR_PHY_BASE+0x00001010)
#define ADR_TX_11B_FIL_COEF_05 (CSR_PHY_BASE+0x00001014)
#define ADR_TX_11B_FIL_COEF_06 (CSR_PHY_BASE+0x00001018)
#define ADR_TX_11B_FIL_COEF_07 (CSR_PHY_BASE+0x0000101c)
#define ADR_TX_11B_FIL_COEF_08 (CSR_PHY_BASE+0x00001020)
#define ADR_TX_11B_FIL_COEF_09 (CSR_PHY_BASE+0x00001024)
#define ADR_TX_11B_FIL_COEF_10 (CSR_PHY_BASE+0x00001028)
#define ADR_TX_11B_FIL_COEF_11 (CSR_PHY_BASE+0x0000102c)
#define ADR_TX_11B_FIL_COEF_12 (CSR_PHY_BASE+0x00001030)
#define ADR_TX_11B_FIL_COEF_13 (CSR_PHY_BASE+0x00001034)
#define ADR_TX_11B_FIL_COEF_14 (CSR_PHY_BASE+0x00001038)
#define ADR_TX_11B_FIL_COEF_15 (CSR_PHY_BASE+0x0000103c)
#define ADR_TX_11B_FIL_COEF_16 (CSR_PHY_BASE+0x00001040)
#define ADR_TX_11B_FIL_COEF_17 (CSR_PHY_BASE+0x00001044)
#define ADR_TX_11B_FIL_COEF_18 (CSR_PHY_BASE+0x00001048)
#define ADR_TX_11B_FIL_COEF_19 (CSR_PHY_BASE+0x0000104c)
#define ADR_TX_11B_FIL_COEF_20 (CSR_PHY_BASE+0x00001050)
#define ADR_TX_11B_FIL_COEF_21 (CSR_PHY_BASE+0x00001054)
#define ADR_TX_11B_FIL_COEF_22 (CSR_PHY_BASE+0x00001058)
#define ADR_TX_11B_FIL_COEF_23 (CSR_PHY_BASE+0x0000105c)
#define ADR_TX_11B_FIL_COEF_24 (CSR_PHY_BASE+0x00001060)
#define ADR_TX_11B_FIL_COEF_25 (CSR_PHY_BASE+0x00001064)
#define ADR_TX_11B_FIL_COEF_26 (CSR_PHY_BASE+0x00001068)
#define ADR_TX_11B_FIL_COEF_27 (CSR_PHY_BASE+0x0000106c)
#define ADR_TX_11B_FIL_COEF_28 (CSR_PHY_BASE+0x00001070)
#define ADR_TX_11B_FIL_COEF_29 (CSR_PHY_BASE+0x00001074)
#define ADR_TX_11B_FIL_COEF_30 (CSR_PHY_BASE+0x00001078)
#define ADR_TX_11B_FIL_COEF_31 (CSR_PHY_BASE+0x0000107c)
#define ADR_TX_11B_FIL_COEF_32 (CSR_PHY_BASE+0x00001080)
#define ADR_TX_11B_FIL_COEF_33 (CSR_PHY_BASE+0x00001084)
#define ADR_TX_11B_FIL_COEF_34 (CSR_PHY_BASE+0x00001088)
#define ADR_TX_11B_FIL_COEF_35 (CSR_PHY_BASE+0x0000108c)
#define ADR_TX_11B_FIL_COEF_36 (CSR_PHY_BASE+0x00001090)
#define ADR_TX_11B_FIL_COEF_37 (CSR_PHY_BASE+0x00001094)
#define ADR_TX_11B_FIL_COEF_38 (CSR_PHY_BASE+0x00001098)
#define ADR_TX_11B_FIL_COEF_39 (CSR_PHY_BASE+0x0000109c)
#define ADR_TX_11B_FIL_COEF_40 (CSR_PHY_BASE+0x000010a0)
#define ADR_TX_11B_PLCP (CSR_PHY_BASE+0x000010a4)
#define ADR_TX_11B_RAMP (CSR_PHY_BASE+0x000010b4)
#define ADR_TX_11B_EN_CNT_RST_N (CSR_PHY_BASE+0x000010d4)
#define ADR_TX_11B_EN_CNT (CSR_PHY_BASE+0x000010d8)
#define ADR_TX_11B_PKT_GEN_CNT (CSR_PHY_BASE+0x00001c00)
#define ADR_RX_11B_DES_DLY (CSR_PHY_BASE+0x00002000)
#define ADR_RX_11B_CCA_0 (CSR_PHY_BASE+0x00002004)
#define ADR_RX_11B_CCA_1 (CSR_PHY_BASE+0x00002008)
#define ADR_RX_11B_TR_KP_KI_0 (CSR_PHY_BASE+0x0000200c)
#define ADR_RX_11B_TR_KP_KI_1 (CSR_PHY_BASE+0x00002010)
#define ADR_RX_11B_CE_CNT_THRESHOLD (CSR_PHY_BASE+0x00002014)
#define ADR_RX_11B_CE_MU_0 (CSR_PHY_BASE+0x00002018)
#define ADR_RX_11B_CE_MU_1 (CSR_PHY_BASE+0x0000201c)
#define ADR_RX_11B_EQ_MU_0 (CSR_PHY_BASE+0x00002020)
#define ADR_RX_11B_EQ_MU_1 (CSR_PHY_BASE+0x00002024)
#define ADR_RX_11B_EQ_CR_KP_KI (CSR_PHY_BASE+0x00002028)
#define ADR_RX_11B_LPF_RATE (CSR_PHY_BASE+0x0000202c)
#define ADR_RX_11B_CIT_CNT_THRESHOLD (CSR_PHY_BASE+0x00002030)
#define ADR_RX_11B_EQ_CH_MAIN_TAP (CSR_PHY_BASE+0x00002034)
#define ADR_RX_11B_SEARCH_CNT_TH (CSR_PHY_BASE+0x0000209c)
#define ADR_RX_11B_CCA_CONTROL (CSR_PHY_BASE+0x000020a0)
#define ADR_RX_11B_FREQUENCY_OFFSET (CSR_PHY_BASE+0x000023d4)
#define ADR_RX_11B_SNR_RSSI (CSR_PHY_BASE+0x000023d8)
#define ADR_RX_11B_SFD_CRC_CNT (CSR_PHY_BASE+0x000023e4)
#define ADR_RX_11B_PKT_ERR_AND_PKT_ERR_CNT (CSR_PHY_BASE+0x000023e8)
#define ADR_RX_11B_PKT_CCA_AND_PKT_CNT (CSR_PHY_BASE+0x000023ec)
#define ADR_RX_11B_SFD_FILED_0 (CSR_PHY_BASE+0x000023f0)
#define ADR_RX_11B_SFD_FIELD_1 (CSR_PHY_BASE+0x000023f4)
#define ADR_RX_11B_PKT_STAT_EN (CSR_PHY_BASE+0x000023f8)
#define ADR_RX_11B_SOFT_RST (CSR_PHY_BASE+0x000023fc)
#define ADR_TX_11GN_RAMP (CSR_PHY_BASE+0x000030a4)
#define ADR_TX_11GN_PLCP (CSR_PHY_BASE+0x000030b8)
#define ADR_TX_11GN_PKT_GEN_CNT (CSR_PHY_BASE+0x00003c00)
#define ADR_TX_11GN_PLCP_CRC_ERR_CNT (CSR_PHY_BASE+0x00003c08)
#define ADR_RX_11GN_DES_DLY (CSR_PHY_BASE+0x00004000)
#define ADR_RX_11GN_TR_0 (CSR_PHY_BASE+0x00004004)
#define ADR_RX_11GN_TR_1 (CSR_PHY_BASE+0x00004008)
#define ADR_RX_11GN_TR_2 (CSR_PHY_BASE+0x0000400c)
#define ADR_RX_11GN_CCA_0 (CSR_PHY_BASE+0x00004010)
#define ADR_RX_11GN_CCA_1 (CSR_PHY_BASE+0x00004014)
#define ADR_RX_11GN_CCA_2 (CSR_PHY_BASE+0x00004018)
#define ADR_RX_11GN_CCA_FFT_SCALE (CSR_PHY_BASE+0x0000401c)
#define ADR_RX_11GN_SOFT_DEMAP_0 (CSR_PHY_BASE+0x00004020)
#define ADR_RX_11GN_SOFT_DEMAP_1 (CSR_PHY_BASE+0x00004024)
#define ADR_RX_11GN_SOFT_DEMAP_2 (CSR_PHY_BASE+0x00004028)
#define ADR_RX_11GN_SOFT_DEMAP_3 (CSR_PHY_BASE+0x0000402c)
#define ADR_RX_11GN_SOFT_DEMAP_4 (CSR_PHY_BASE+0x00004030)
#define ADR_RX_11GN_SOFT_DEMAP_5 (CSR_PHY_BASE+0x00004034)
#define ADR_RX_11GN_SYM_BOUND_0 (CSR_PHY_BASE+0x00004038)
#define ADR_RX_11GN_SYM_BOUND_1 (CSR_PHY_BASE+0x0000409c)
#define ADR_RX_11GN_CCA_PWR (CSR_PHY_BASE+0x000040c0)
#define ADR_RX_11GN_CCA_CNT (CSR_PHY_BASE+0x000040c4)
#define ADR_RX_11GN_CCA_ATCOR_RE_CHECK (CSR_PHY_BASE+0x000040c8)
#define ADR_RX_11GN_VTB_TB (CSR_PHY_BASE+0x00004130)
#define ADR_RX_11GN_ERR_UPDATE (CSR_PHY_BASE+0x00004164)
#define ADR_RX_11GN_SHORT_GI (CSR_PHY_BASE+0x00004180)
#define ADR_RX_11GN_CHANNEL_UPDATE (CSR_PHY_BASE+0x00004188)
#define ADR_RX_11GN_PKT_FORMAT_0 (CSR_PHY_BASE+0x00004190)
#define ADR_RX_11GN_PKT_FORMAT_1 (CSR_PHY_BASE+0x00004194)
#define ADR_RX_11GN_TX_TIME (CSR_PHY_BASE+0x00004380)
#define ADR_RX_11GN_STBC_TR_KP_KI (CSR_PHY_BASE+0x00004384)
#define ADR_RX_11GN_BIST_0 (CSR_PHY_BASE+0x00004388)
#define ADR_RX_11GN_BIST_1 (CSR_PHY_BASE+0x0000438c)
#define ADR_RX_11GN_BIST_2 (CSR_PHY_BASE+0x000043c0)
#define ADR_RX_11GN_BIST_3 (CSR_PHY_BASE+0x000043c4)
#define ADR_RX_11GN_BIST_4 (CSR_PHY_BASE+0x000043c8)
#define ADR_RX_11GN_BIST_5 (CSR_PHY_BASE+0x000043cc)
#define ADR_RX_11GN_SPECTRUM_ANALYZER (CSR_PHY_BASE+0x000043d4)
#define ADR_RX_11GN_READ_0 (CSR_PHY_BASE+0x000043d8)
#define ADR_RX_11GN_FREQ_OFFSET (CSR_PHY_BASE+0x000043dc)
#define ADR_RX_11GN_SIGNAL_FIELD_0 (CSR_PHY_BASE+0x000043e0)
#define ADR_RX_11GN_SIGNAL_FIELD_1 (CSR_PHY_BASE+0x000043e4)
#define ADR_RX_11GN_PKT_ERR_CNT (CSR_PHY_BASE+0x000043e8)
#define ADR_RX_11GN_PKT_CCA_AND_PKT_CNT (CSR_PHY_BASE+0x000043ec)
#define ADR_RX_11GN_SERVICE_LENGTH_FIELD (CSR_PHY_BASE+0x000043f0)
#define ADR_RX_11GN_RATE (CSR_PHY_BASE+0x000043f4)
#define ADR_RX_11GN_STAT_EN (CSR_PHY_BASE+0x000043f8)
#define ADR_RX_11GN_SOFT_RST (CSR_PHY_BASE+0x000043fc)
#define ADR_RF_CONTROL_0 (CSR_PHY_BASE+0x00007000)
#define ADR_RF_CONTROL_1 (CSR_PHY_BASE+0x00007004)
#define ADR_TX_IQ_CONTROL_0 (CSR_PHY_BASE+0x00007040)
#define ADR_TX_IQ_CONTROL_1 (CSR_PHY_BASE+0x00007044)
#define ADR_TX_IQ_CONTROL_2 (CSR_PHY_BASE+0x00007048)
#define ADR_TX_COMPENSATION_CONTROL (CSR_PHY_BASE+0x0000704c)
#define ADR_RX_COMPENSATION_CONTROL (CSR_PHY_BASE+0x00007050)
#define ADR_RX_OBSERVATION_CIRCUIT_0 (CSR_PHY_BASE+0x00007058)
#define ADR_RX_OBSERVATION_CIRCUIT_1 (CSR_PHY_BASE+0x0000705c)
#define ADR_RX_OBSERVATION_CIRCUIT_2 (CSR_PHY_BASE+0x00007060)
#define ADR_RX_OBSERVATION_CIRCUIT_3 (CSR_PHY_BASE+0x00007064)
#define ADR_RF_IQ_CONTROL_0 (CSR_PHY_BASE+0x0000706c)
#define ADR_RF_IQ_CONTROL_1 (CSR_PHY_BASE+0x00007070)
#define ADR_RF_IQ_CONTROL_2 (CSR_PHY_BASE+0x00007074)
#define ADR_RF_IQ_CONTROL_3 (CSR_PHY_BASE+0x00007078)
#define ADR_DPD_CONTROL (CSR_PHY_BASE+0x0000711c)
#define ADR_DPD_GAIN_TABLE_0 (CSR_PHY_BASE+0x00007120)
#define ADR_DPD_GAIN_TABLE_1 (CSR_PHY_BASE+0x00007124)
#define ADR_DPD_GAIN_TABLE_2 (CSR_PHY_BASE+0x00007128)
#define ADR_DPD_GAIN_TABLE_3 (CSR_PHY_BASE+0x00007130)
#define ADR_DPD_GAIN_TABLE_4 (CSR_PHY_BASE+0x00007134)
#define ADR_DPD_GAIN_TABLE_5 (CSR_PHY_BASE+0x00007138)
#define ADR_DPD_GAIN_TABLE_6 (CSR_PHY_BASE+0x0000713c)
#define ADR_DPD_GAIN_TABLE_7 (CSR_PHY_BASE+0x00007140)
#define ADR_DPD_GAIN_TABLE_8 (CSR_PHY_BASE+0x00007144)
#define ADR_DPD_GAIN_TABLE_9 (CSR_PHY_BASE+0x00007148)
#define ADR_DPD_GAIN_TABLE_A (CSR_PHY_BASE+0x0000714c)
#define ADR_DPD_GAIN_TABLE_B (CSR_PHY_BASE+0x00007150)
#define ADR_DPD_GAIN_TABLE_C (CSR_PHY_BASE+0x00007154)
#define ADR_DPD_PH_TABLE_0 (CSR_PHY_BASE+0x00007170)
#define ADR_DPD_PH_TABLE_1 (CSR_PHY_BASE+0x00007174)
#define ADR_DPD_PH_TABLE_2 (CSR_PHY_BASE+0x00007178)
#define ADR_DPD_PH_TABLE_3 (CSR_PHY_BASE+0x00007180)
#define ADR_DPD_PH_TABLE_4 (CSR_PHY_BASE+0x00007184)
#define ADR_DPD_PH_TABLE_5 (CSR_PHY_BASE+0x00007188)
#define ADR_DPD_PH_TABLE_6 (CSR_PHY_BASE+0x0000718c)
#define ADR_DPD_PH_TABLE_7 (CSR_PHY_BASE+0x00007190)
#define ADR_DPD_PH_TABLE_8 (CSR_PHY_BASE+0x00007194)
#define ADR_DPD_PH_TABLE_9 (CSR_PHY_BASE+0x00007198)
#define ADR_DPD_PH_TABLE_A (CSR_PHY_BASE+0x0000719c)
#define ADR_DPD_PH_TABLE_B (CSR_PHY_BASE+0x000071a0)
#define ADR_DPD_PH_TABLE_C (CSR_PHY_BASE+0x000071a4)
#define ADR_DPD_GAIN_ESTIMATION_0 (CSR_PHY_BASE+0x000071b0)
#define ADR_DPD_GAIN_ESTIMATION_1 (CSR_PHY_BASE+0x000071b4)
#define ADR_DPD_GAIN_ESTIMATION_2 (CSR_PHY_BASE+0x000071b8)
#define ADR_TX_GAIN_FACTOR (CSR_PHY_BASE+0x000071bc)
#define ADR_HARD_WIRE_PIN_REGISTER (CSR_RF_BASE+0x00000000)
#define ADR_MANUAL_ENABLE_REGISTER (CSR_RF_BASE+0x00000004)
#define ADR_LDO_REGISTER (CSR_RF_BASE+0x00000008)
#define ADR_ABB_REGISTER_1 (CSR_RF_BASE+0x0000000c)
#define ADR_ABB_REGISTER_2 (CSR_RF_BASE+0x00000010)
#define ADR_TX_FE_REGISTER (CSR_RF_BASE+0x00000014)
#define ADR_RX_FE_REGISTER_1 (CSR_RF_BASE+0x00000018)
#define ADR_RX_FE_GAIN_DECODER_REGISTER_1 (CSR_RF_BASE+0x0000001c)
#define ADR_RX_FE_GAIN_DECODER_REGISTER_2 (CSR_RF_BASE+0x00000020)
#define ADR_RX_FE_GAIN_DECODER_REGISTER_3 (CSR_RF_BASE+0x00000024)
#define ADR_RX_FE_GAIN_DECODER_REGISTER_4 (CSR_RF_BASE+0x00000028)
#define ADR_RX_TX_FSM_REGISTER (CSR_RF_BASE+0x0000002c)
#define ADR_RX_ADC_REGISTER (CSR_RF_BASE+0x00000030)
#define ADR_TX_DAC_REGISTER (CSR_RF_BASE+0x00000034)
#define ADR_SX_ENABLE_REGISTER (CSR_RF_BASE+0x00000038)
#define ADR_SYN_REGISTER_1 (CSR_RF_BASE+0x0000003c)
#define ADR_SYN_REGISTER_2 (CSR_RF_BASE+0x00000040)
#define ADR_SYN_PFD_CHP (CSR_RF_BASE+0x00000044)
#define ADR_SYN_VCO_LOBF (CSR_RF_BASE+0x00000048)
#define ADR_SYN_DIV_SDM_XOSC (CSR_RF_BASE+0x0000004c)
#define ADR_SYN_KVCO_XO_FINE_TUNE_CBANK (CSR_RF_BASE+0x00000050)
#define ADR_SYN_LCK_VT (CSR_RF_BASE+0x00000054)
#define ADR_DPLL_VCO_REGISTER (CSR_RF_BASE+0x00000058)
#define ADR_DPLL_CP_PFD_REGISTER (CSR_RF_BASE+0x0000005c)
#define ADR_DPLL_DIVIDER_REGISTER (CSR_RF_BASE+0x00000060)
#define ADR_DCOC_IDAC_REGISTER1 (CSR_RF_BASE+0x00000064)
#define ADR_DCOC_IDAC_REGISTER2 (CSR_RF_BASE+0x00000068)
#define ADR_DCOC_IDAC_REGISTER3 (CSR_RF_BASE+0x0000006c)
#define ADR_DCOC_IDAC_REGISTER4 (CSR_RF_BASE+0x00000070)
#define ADR_DCOC_IDAC_REGISTER5 (CSR_RF_BASE+0x00000074)
#define ADR_DCOC_IDAC_REGISTER6 (CSR_RF_BASE+0x00000078)
#define ADR_DCOC_IDAC_REGISTER7 (CSR_RF_BASE+0x0000007c)
#define ADR_DCOC_IDAC_REGISTER8 (CSR_RF_BASE+0x00000080)
#define ADR_RCAL_REGISTER (CSR_RF_BASE+0x00000084)
#define ADR_SX_LCK_BIN_REGISTERS_I (CSR_RF_BASE+0x00000088)
#define ADR_TRX_DUMMY_REGISTER (CSR_RF_BASE+0x0000008c)
#define ADR_SX_DUMMY_REGISTER (CSR_RF_BASE+0x00000090)
#define ADR_READ_ONLY_FLAGS_1 (CSR_RF_BASE+0x00000094)
#define ADR_READ_ONLY_FLAGS_2 (CSR_RF_BASE+0x00000098)
#define ADR_DPLL_FB_DIVIDER_REGISTERS_I (CSR_RF_BASE+0x0000009c)
#define ADR_DPLL_FB_DIVIDER_REGISTERS_II (CSR_RF_BASE+0x000000a0)
#define ADR_SX_LCK_BIN_REGISTERS_II (CSR_RF_BASE+0x000000a4)
#define ADR_RC_OSC_32K_CAL_REGISTERS (CSR_RF_BASE+0x000000a8)
#define ADR_RF_D_DIGITAL_DEBUG_PORT_REGISTER (CSR_RF_BASE+0x000000ac)
#define ADR_MMU_CTRL (MMU_REG_BASE+0x00000000)
#define ADR_HS_CTRL (MMU_REG_BASE+0x00000004)
#define ADR_CPU_POR0_7 (MMU_REG_BASE+0x00000008)
#define ADR_CPU_POR8_F (MMU_REG_BASE+0x0000000c)
#define ADR_REG_LEN_CTRL (MMU_REG_BASE+0x00000010)
#define ADR_DMN_READ_BYPASS (MMU_REG_BASE+0x00000014)
#define ADR_ALC_RLS_ABORT (MMU_REG_BASE+0x00000018)
#define ADR_DEBUG_CTL (MMU_REG_BASE+0x00000020)
#define ADR_DEBUG_OUT (MMU_REG_BASE+0x00000024)
#define ADR_MMU_STATUS (MMU_REG_BASE+0x00000028)
#define ADR_DMN_STATUS (MMU_REG_BASE+0x0000002c)
#define ADR_TAG_STATUS (MMU_REG_BASE+0x00000030)
#define ADR_DMN_MCU_STATUS (MMU_REG_BASE+0x00000034)
#define ADR_MB_IDTBL_0_STATUS (MMU_REG_BASE+0x00000040)
#define ADR_MB_IDTBL_1_STATUS (MMU_REG_BASE+0x00000044)
#define ADR_MB_IDTBL_2_STATUS (MMU_REG_BASE+0x00000048)
#define ADR_MB_IDTBL_3_STATUS (MMU_REG_BASE+0x0000004c)
#define ADR_PKT_IDTBL_0_STATUS (MMU_REG_BASE+0x00000050)
#define ADR_PKT_IDTBL_1_STATUS (MMU_REG_BASE+0x00000054)
#define ADR_PKT_IDTBL_2_STATUS (MMU_REG_BASE+0x00000058)
#define ADR_PKT_IDTBL_3_STATUS (MMU_REG_BASE+0x0000005c)
#define ADR_DMN_IDTBL_0_STATUS (MMU_REG_BASE+0x00000060)
#define ADR_DMN_IDTBL_1_STATUS (MMU_REG_BASE+0x00000064)
#define ADR_DMN_IDTBL_2_STATUS (MMU_REG_BASE+0x00000068)
#define ADR_DMN_IDTBL_3_STATUS (MMU_REG_BASE+0x0000006c)
#define ADR_MB_NEQID_0_STATUS (MMU_REG_BASE+0x00000070)
#define ADR_MB_NEQID_1_STATUS (MMU_REG_BASE+0x00000074)
#define ADR_MB_NEQID_2_STATUS (MMU_REG_BASE+0x00000078)
#define ADR_MB_NEQID_3_STATUS (MMU_REG_BASE+0x0000007c)
#define ADR_PKT_NEQID_0_STATUS (MMU_REG_BASE+0x00000080)
#define ADR_PKT_NEQID_1_STATUS (MMU_REG_BASE+0x00000084)
#define ADR_PKT_NEQID_2_STATUS (MMU_REG_BASE+0x00000088)
#define ADR_PKT_NEQID_3_STATUS (MMU_REG_BASE+0x0000008c)
#define ADR_ALC_NOCHG_ID_STATUS (MMU_REG_BASE+0x00000090)
#define ADR_TAG_SRAM0_F_STATUS_0 (MMU_REG_BASE+0x000000a0)
#define ADR_TAG_SRAM0_F_STATUS_1 (MMU_REG_BASE+0x000000a4)
#define ADR_TAG_SRAM0_F_STATUS_2 (MMU_REG_BASE+0x000000a8)
#define ADR_TAG_SRAM0_F_STATUS_3 (MMU_REG_BASE+0x000000ac)
#define ADR_TAG_SRAM0_F_STATUS_4 (MMU_REG_BASE+0x000000b0)
#define ADR_TAG_SRAM0_F_STATUS_5 (MMU_REG_BASE+0x000000b4)
#define ADR_TAG_SRAM0_F_STATUS_6 (MMU_REG_BASE+0x000000b8)
#define ADR_TAG_SRAM0_F_STATUS_7 (MMU_REG_BASE+0x000000bc)
#define GET_MCU_ENABLE (((REG32(ADR_BRG_SW_RST)) & 0x00000001 ) >> 0)
#define GET_MAC_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00000002 ) >> 1)
#define GET_MCU_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00000004 ) >> 2)
#define GET_SDIO_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00000008 ) >> 3)
#define GET_SPI_SLV_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00000010 ) >> 4)
#define GET_UART_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00000020 ) >> 5)
#define GET_DMA_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00000040 ) >> 6)
#define GET_WDT_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00000080 ) >> 7)
#define GET_I2C_SLV_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00000100 ) >> 8)
#define GET_INT_CTL_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00000200 ) >> 9)
#define GET_BTCX_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00000400 ) >> 10)
#define GET_GPIO_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00000800 ) >> 11)
#define GET_US0TMR_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00001000 ) >> 12)
#define GET_US1TMR_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00002000 ) >> 13)
#define GET_US2TMR_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00004000 ) >> 14)
#define GET_US3TMR_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00008000 ) >> 15)
#define GET_MS0TMR_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00010000 ) >> 16)
#define GET_MS1TMR_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00020000 ) >> 17)
#define GET_MS2TMR_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00040000 ) >> 18)
#define GET_MS3TMR_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00080000 ) >> 19)
#define GET_RF_BB_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00100000 ) >> 20)
#define GET_SYS_ALL_RST (((REG32(ADR_BRG_SW_RST)) & 0x00200000 ) >> 21)
#define GET_DAT_UART_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00400000 ) >> 22)
#define GET_I2C_MST_SW_RST (((REG32(ADR_BRG_SW_RST)) & 0x00800000 ) >> 23)
#define GET_RG_REBOOT (((REG32(ADR_BOOT)) & 0x00000001 ) >> 0)
#define GET_TRAP_IMG_FLS (((REG32(ADR_BOOT)) & 0x00010000 ) >> 16)
#define GET_TRAP_REBOOT (((REG32(ADR_BOOT)) & 0x00020000 ) >> 17)
#define GET_TRAP_BOOT_FLS (((REG32(ADR_BOOT)) & 0x00040000 ) >> 18)
#define GET_CHIP_ID_31_0 (((REG32(ADR_CHIP_ID_0)) & 0xffffffff ) >> 0)
#define GET_CHIP_ID_63_32 (((REG32(ADR_CHIP_ID_1)) & 0xffffffff ) >> 0)
#define GET_CHIP_ID_95_64 (((REG32(ADR_CHIP_ID_2)) & 0xffffffff ) >> 0)
#define GET_CHIP_ID_127_96 (((REG32(ADR_CHIP_ID_3)) & 0xffffffff ) >> 0)
#define GET_CK_SEL_1_0 (((REG32(ADR_CLOCK_SELECTION)) & 0x00000003 ) >> 0)
#define GET_CK_SEL_2 (((REG32(ADR_CLOCK_SELECTION)) & 0x00000004 ) >> 2)
#define GET_SYS_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00000001 ) >> 0)
#define GET_MAC_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00000002 ) >> 1)
#define GET_MCU_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00000004 ) >> 2)
#define GET_SDIO_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00000008 ) >> 3)
#define GET_SPI_SLV_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00000010 ) >> 4)
#define GET_UART_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00000020 ) >> 5)
#define GET_DMA_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00000040 ) >> 6)
#define GET_WDT_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00000080 ) >> 7)
#define GET_I2C_SLV_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00000100 ) >> 8)
#define GET_INT_CTL_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00000200 ) >> 9)
#define GET_BTCX_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00000400 ) >> 10)
#define GET_GPIO_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00000800 ) >> 11)
#define GET_US0TMR_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00001000 ) >> 12)
#define GET_US1TMR_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00002000 ) >> 13)
#define GET_US2TMR_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00004000 ) >> 14)
#define GET_US3TMR_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00008000 ) >> 15)
#define GET_MS0TMR_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00010000 ) >> 16)
#define GET_MS1TMR_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00020000 ) >> 17)
#define GET_MS2TMR_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00040000 ) >> 18)
#define GET_MS3TMR_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00080000 ) >> 19)
#define GET_BIST_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00100000 ) >> 20)
#define GET_I2C_MST_CLK_EN (((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0x00800000 ) >> 23)
#define GET_BTCX_CSR_CLK_EN (((REG32(ADR_SYS_CSR_CLOCK_ENABLE)) & 0x00000400 ) >> 10)
#define GET_MCU_DBG_SEL (((REG32(ADR_MCU_DBG_SEL)) & 0x0000003f ) >> 0)
#define GET_MCU_STOP_NOGRANT (((REG32(ADR_MCU_DBG_SEL)) & 0x00000100 ) >> 8)
#define GET_MCU_STOP_ANYTIME (((REG32(ADR_MCU_DBG_SEL)) & 0x00000200 ) >> 9)
#define GET_MCU_DBG_DATA (((REG32(ADR_MCU_DBG_DATA)) & 0xffffffff ) >> 0)
#define GET_AHB_SW_RST (((REG32(ADR_AHB_BRG_STATUS)) & 0x00000001 ) >> 0)
#define GET_AHB_ERR_RST (((REG32(ADR_AHB_BRG_STATUS)) & 0x00000002 ) >> 1)
#define GET_REG_AHB_DEBUG_MX (((REG32(ADR_AHB_BRG_STATUS)) & 0x00000030 ) >> 4)
#define GET_REG_PKT_W_NBRT (((REG32(ADR_AHB_BRG_STATUS)) & 0x00000100 ) >> 8)
#define GET_REG_PKT_R_NBRT (((REG32(ADR_AHB_BRG_STATUS)) & 0x00000200 ) >> 9)
#define GET_IQ_SRAM_SEL_0 (((REG32(ADR_AHB_BRG_STATUS)) & 0x00001000 ) >> 12)
#define GET_IQ_SRAM_SEL_1 (((REG32(ADR_AHB_BRG_STATUS)) & 0x00002000 ) >> 13)
#define GET_IQ_SRAM_SEL_2 (((REG32(ADR_AHB_BRG_STATUS)) & 0x00004000 ) >> 14)
#define GET_AHB_STATUS (((REG32(ADR_AHB_BRG_STATUS)) & 0xffff0000 ) >> 16)
#define GET_PARALLEL_DR (((REG32(ADR_BIST_BIST_CTRL)) & 0x00000001 ) >> 0)
#define GET_MBRUN (((REG32(ADR_BIST_BIST_CTRL)) & 0x00000010 ) >> 4)
#define GET_SHIFT_DR (((REG32(ADR_BIST_BIST_CTRL)) & 0x00000100 ) >> 8)
#define GET_MODE_REG_SI (((REG32(ADR_BIST_BIST_CTRL)) & 0x00000200 ) >> 9)
#define GET_SIMULATION_MODE (((REG32(ADR_BIST_BIST_CTRL)) & 0x00000400 ) >> 10)
#define GET_DBIST_MODE (((REG32(ADR_BIST_BIST_CTRL)) & 0x00000800 ) >> 11)
#define GET_MODE_REG_IN (((REG32(ADR_BIST_MODE_REG_IN)) & 0x001fffff ) >> 0)
#define GET_MODE_REG_OUT_MCU (((REG32(ADR_BIST_MODE_REG_OUT)) & 0x001fffff ) >> 0)
#define GET_MODE_REG_SO_MCU (((REG32(ADR_BIST_MODE_REG_OUT)) & 0x80000000 ) >> 31)
#define GET_MONITOR_BUS_MCU_31_0 (((REG32(ADR_BIST_MONITOR_BUS_LSB)) & 0xffffffff ) >> 0)
#define GET_MONITOR_BUS_MCU_33_32 (((REG32(ADR_BIST_MONITOR_BUS_MSB)) & 0x00000003 ) >> 0)
#define GET_TB_ADR_SEL (((REG32(ADR_TB_ADR_SEL)) & 0x0000ffff ) >> 0)
#define GET_TB_CS (((REG32(ADR_TB_ADR_SEL)) & 0x80000000 ) >> 31)
#define GET_TB_RDATA (((REG32(ADR_TB_RDATA)) & 0xffffffff ) >> 0)
#define GET_UART_W2B_EN (((REG32(ADR_UART_W2B)) & 0x00000001 ) >> 0)
#define GET_DATA_UART_W2B_EN (((REG32(ADR_UART_W2B)) & 0x00000010 ) >> 4)
#define GET_AHB_ILL_ADDR (((REG32(ADR_AHB_ILL_ADDR)) & 0xffffffff ) >> 0)
#define GET_AHB_FEN_ADDR (((REG32(ADR_AHB_FEN_ADDR)) & 0xffffffff ) >> 0)
#define GET_ILL_ADDR_CLR (((REG32(ADR_AHB_ILLFEN_STATUS)) & 0x00000001 ) >> 0)
#define GET_FENCE_HIT_CLR (((REG32(ADR_AHB_ILLFEN_STATUS)) & 0x00000002 ) >> 1)
#define GET_ILL_ADDR_INT (((REG32(ADR_AHB_ILLFEN_STATUS)) & 0x00000010 ) >> 4)
#define GET_FENCE_HIT_INT (((REG32(ADR_AHB_ILLFEN_STATUS)) & 0x00000020 ) >> 5)
#define GET_PWM_INI_VALUE_P_A (((REG32(ADR_PWM_A)) & 0x000000ff ) >> 0)
#define GET_PWM_INI_VALUE_N_A (((REG32(ADR_PWM_A)) & 0x0000ff00 ) >> 8)
#define GET_PWM_POST_SCALER_A (((REG32(ADR_PWM_A)) & 0x000f0000 ) >> 16)
#define GET_PWM_ALWAYSON_A (((REG32(ADR_PWM_A)) & 0x20000000 ) >> 29)
#define GET_PWM_INVERT_A (((REG32(ADR_PWM_A)) & 0x40000000 ) >> 30)
#define GET_PWM_ENABLE_A (((REG32(ADR_PWM_A)) & 0x80000000 ) >> 31)
#define GET_PWM_INI_VALUE_P_B (((REG32(ADR_PWM_B)) & 0x000000ff ) >> 0)
#define GET_PWM_INI_VALUE_N_B (((REG32(ADR_PWM_B)) & 0x0000ff00 ) >> 8)
#define GET_PWM_POST_SCALER_B (((REG32(ADR_PWM_B)) & 0x000f0000 ) >> 16)
#define GET_PWM_ALWAYSON_B (((REG32(ADR_PWM_B)) & 0x20000000 ) >> 29)
#define GET_PWM_INVERT_B (((REG32(ADR_PWM_B)) & 0x40000000 ) >> 30)
#define GET_PWM_ENABLE_B (((REG32(ADR_PWM_B)) & 0x80000000 ) >> 31)
#define GET_HBUSREQ_LOCK (((REG32(ADR_HBUSREQ_LOCK)) & 0x00001fff ) >> 0)
#define GET_HBURST_LOCK (((REG32(ADR_HBURST_LOCK)) & 0x00001fff ) >> 0)
#define GET_PRESCALER_USTIMER (((REG32(ADR_PRESCALER_USTIMER)) & 0x000001ff ) >> 0)
#define GET_MODE_REG_IN_MMU (((REG32(ADR_BIST_MODE_REG_IN_MMU)) & 0x0000ffff ) >> 0)
#define GET_MODE_REG_OUT_MMU (((REG32(ADR_BIST_MODE_REG_OUT_MMU)) & 0x0000ffff ) >> 0)
#define GET_MODE_REG_SO_MMU (((REG32(ADR_BIST_MODE_REG_OUT_MMU)) & 0x80000000 ) >> 31)
#define GET_MONITOR_BUS_MMU (((REG32(ADR_BIST_MONITOR_BUS_MMU)) & 0x0007ffff ) >> 0)
#define GET_TEST_MODE0 (((REG32(ADR_TEST_MODE)) & 0x00000001 ) >> 0)
#define GET_TEST_MODE1 (((REG32(ADR_TEST_MODE)) & 0x00000002 ) >> 1)
#define GET_TEST_MODE2 (((REG32(ADR_TEST_MODE)) & 0x00000004 ) >> 2)
#define GET_TEST_MODE3 (((REG32(ADR_TEST_MODE)) & 0x00000008 ) >> 3)
#define GET_TEST_MODE4 (((REG32(ADR_TEST_MODE)) & 0x00000010 ) >> 4)
#define GET_TEST_MODE_ALL (((REG32(ADR_TEST_MODE)) & 0x00000020 ) >> 5)
#define GET_WDT_INIT (((REG32(ADR_BOOT_INFO)) & 0x00000001 ) >> 0)
#define GET_SD_HOST_INIT (((REG32(ADR_BOOT_INFO)) & 0x00000002 ) >> 1)
#define GET_ALLOW_SD_RESET (((REG32(ADR_SD_INIT_CFG)) & 0x00000001 ) >> 0)
#define GET_UART_NRTS (((REG32(ADR_SPARE_UART_INFO)) & 0x00000001 ) >> 0)
#define GET_UART_NCTS (((REG32(ADR_SPARE_UART_INFO)) & 0x00000002 ) >> 1)
#define GET_TU0_TM_INIT_VALUE (((REG32(ADR_TU0_MICROSECOND_TIMER)) & 0x0000ffff ) >> 0)
#define GET_TU0_TM_MODE (((REG32(ADR_TU0_MICROSECOND_TIMER)) & 0x00010000 ) >> 16)
#define GET_TU0_TM_INT_STS_DONE (((REG32(ADR_TU0_MICROSECOND_TIMER)) & 0x00020000 ) >> 17)
#define GET_TU0_TM_INT_MASK (((REG32(ADR_TU0_MICROSECOND_TIMER)) & 0x00040000 ) >> 18)
#define GET_TU0_TM_CUR_VALUE (((REG32(ADR_TU0_CURRENT_MICROSECOND_TIME_VALUE)) & 0x0000ffff ) >> 0)
#define GET_TU1_TM_INIT_VALUE (((REG32(ADR_TU1_MICROSECOND_TIMER)) & 0x0000ffff ) >> 0)
#define GET_TU1_TM_MODE (((REG32(ADR_TU1_MICROSECOND_TIMER)) & 0x00010000 ) >> 16)
#define GET_TU1_TM_INT_STS_DONE (((REG32(ADR_TU1_MICROSECOND_TIMER)) & 0x00020000 ) >> 17)
#define GET_TU1_TM_INT_MASK (((REG32(ADR_TU1_MICROSECOND_TIMER)) & 0x00040000 ) >> 18)
#define GET_TU1_TM_CUR_VALUE (((REG32(ADR_TU1_CURRENT_MICROSECOND_TIME_VALUE)) & 0x0000ffff ) >> 0)
#define GET_TU2_TM_INIT_VALUE (((REG32(ADR_TU2_MICROSECOND_TIMER)) & 0x0000ffff ) >> 0)
#define GET_TU2_TM_MODE (((REG32(ADR_TU2_MICROSECOND_TIMER)) & 0x00010000 ) >> 16)
#define GET_TU2_TM_INT_STS_DONE (((REG32(ADR_TU2_MICROSECOND_TIMER)) & 0x00020000 ) >> 17)
#define GET_TU2_TM_INT_MASK (((REG32(ADR_TU2_MICROSECOND_TIMER)) & 0x00040000 ) >> 18)
#define GET_TU2_TM_CUR_VALUE (((REG32(ADR_TU2_CURRENT_MICROSECOND_TIME_VALUE)) & 0x0000ffff ) >> 0)
#define GET_TU3_TM_INIT_VALUE (((REG32(ADR_TU3_MICROSECOND_TIMER)) & 0x0000ffff ) >> 0)
#define GET_TU3_TM_MODE (((REG32(ADR_TU3_MICROSECOND_TIMER)) & 0x00010000 ) >> 16)
#define GET_TU3_TM_INT_STS_DONE (((REG32(ADR_TU3_MICROSECOND_TIMER)) & 0x00020000 ) >> 17)
#define GET_TU3_TM_INT_MASK (((REG32(ADR_TU3_MICROSECOND_TIMER)) & 0x00040000 ) >> 18)
#define GET_TU3_TM_CUR_VALUE (((REG32(ADR_TU3_CURRENT_MICROSECOND_TIME_VALUE)) & 0x0000ffff ) >> 0)
#define GET_TM0_TM_INIT_VALUE (((REG32(ADR_TM0_MILISECOND_TIMER)) & 0x0000ffff ) >> 0)
#define GET_TM0_TM_MODE (((REG32(ADR_TM0_MILISECOND_TIMER)) & 0x00010000 ) >> 16)
#define GET_TM0_TM_INT_STS_DONE (((REG32(ADR_TM0_MILISECOND_TIMER)) & 0x00020000 ) >> 17)
#define GET_TM0_TM_INT_MASK (((REG32(ADR_TM0_MILISECOND_TIMER)) & 0x00040000 ) >> 18)
#define GET_TM0_TM_CUR_VALUE (((REG32(ADR_TM0_CURRENT_MILISECOND_TIME_VALUE)) & 0x0000ffff ) >> 0)
#define GET_TM1_TM_INIT_VALUE (((REG32(ADR_TM1_MILISECOND_TIMER)) & 0x0000ffff ) >> 0)
#define GET_TM1_TM_MODE (((REG32(ADR_TM1_MILISECOND_TIMER)) & 0x00010000 ) >> 16)
#define GET_TM1_TM_INT_STS_DONE (((REG32(ADR_TM1_MILISECOND_TIMER)) & 0x00020000 ) >> 17)
#define GET_TM1_TM_INT_MASK (((REG32(ADR_TM1_MILISECOND_TIMER)) & 0x00040000 ) >> 18)
#define GET_TM1_TM_CUR_VALUE (((REG32(ADR_TM1_CURRENT_MILISECOND_TIME_VALUE)) & 0x0000ffff ) >> 0)
#define GET_TM2_TM_INIT_VALUE (((REG32(ADR_TM2_MILISECOND_TIMER)) & 0x0000ffff ) >> 0)
#define GET_TM2_TM_MODE (((REG32(ADR_TM2_MILISECOND_TIMER)) & 0x00010000 ) >> 16)
#define GET_TM2_TM_INT_STS_DONE (((REG32(ADR_TM2_MILISECOND_TIMER)) & 0x00020000 ) >> 17)
#define GET_TM2_TM_INT_MASK (((REG32(ADR_TM2_MILISECOND_TIMER)) & 0x00040000 ) >> 18)
#define GET_TM2_TM_CUR_VALUE (((REG32(ADR_TM2_CURRENT_MILISECOND_TIME_VALUE)) & 0x0000ffff ) >> 0)
#define GET_TM3_TM_INIT_VALUE (((REG32(ADR_TM3_MILISECOND_TIMER)) & 0x0000ffff ) >> 0)
#define GET_TM3_TM_MODE (((REG32(ADR_TM3_MILISECOND_TIMER)) & 0x00010000 ) >> 16)
#define GET_TM3_TM_INT_STS_DONE (((REG32(ADR_TM3_MILISECOND_TIMER)) & 0x00020000 ) >> 17)
#define GET_TM3_TM_INT_MASK (((REG32(ADR_TM3_MILISECOND_TIMER)) & 0x00040000 ) >> 18)
#define GET_TM3_TM_CUR_VALUE (((REG32(ADR_TM3_CURRENT_MILISECOND_TIME_VALUE)) & 0x0000ffff ) >> 0)
#define GET_MCU_WDT_TIME_CNT (((REG32(ADR_MCU_WDOG_REG)) & 0x0000ffff ) >> 0)
#define GET_MCU_WDT_STATUS (((REG32(ADR_MCU_WDOG_REG)) & 0x00020000 ) >> 17)
#define GET_MCU_WDOG_ENA (((REG32(ADR_MCU_WDOG_REG)) & 0x80000000 ) >> 31)
#define GET_SYS_WDT_TIME_CNT (((REG32(ADR_SYS_WDOG_REG)) & 0x0000ffff ) >> 0)
#define GET_SYS_WDT_STATUS (((REG32(ADR_SYS_WDOG_REG)) & 0x00020000 ) >> 17)
#define GET_SYS_WDOG_ENA (((REG32(ADR_SYS_WDOG_REG)) & 0x80000000 ) >> 31)
#define GET_XLNA_EN_O_OE (((REG32(ADR_PAD6)) & 0x00000001 ) >> 0)
#define GET_XLNA_EN_O_PE (((REG32(ADR_PAD6)) & 0x00000002 ) >> 1)
#define GET_PAD6_IE (((REG32(ADR_PAD6)) & 0x00000008 ) >> 3)
#define GET_PAD6_SEL_I (((REG32(ADR_PAD6)) & 0x00000030 ) >> 4)
#define GET_PAD6_OD (((REG32(ADR_PAD6)) & 0x00000100 ) >> 8)
#define GET_PAD6_SEL_O (((REG32(ADR_PAD6)) & 0x00001000 ) >> 12)
#define GET_XLNA_EN_O_C (((REG32(ADR_PAD6)) & 0x10000000 ) >> 28)
#define GET_WIFI_TX_SW_O_OE (((REG32(ADR_PAD7)) & 0x00000001 ) >> 0)
#define GET_WIFI_TX_SW_O_PE (((REG32(ADR_PAD7)) & 0x00000002 ) >> 1)
#define GET_PAD7_IE (((REG32(ADR_PAD7)) & 0x00000008 ) >> 3)
#define GET_PAD7_SEL_I (((REG32(ADR_PAD7)) & 0x00000030 ) >> 4)
#define GET_PAD7_OD (((REG32(ADR_PAD7)) & 0x00000100 ) >> 8)
#define GET_PAD7_SEL_O (((REG32(ADR_PAD7)) & 0x00001000 ) >> 12)
#define GET_WIFI_TX_SW_O_C (((REG32(ADR_PAD7)) & 0x10000000 ) >> 28)
#define GET_WIFI_RX_SW_O_OE (((REG32(ADR_PAD8)) & 0x00000001 ) >> 0)
#define GET_WIFI_RX_SW_O_PE (((REG32(ADR_PAD8)) & 0x00000002 ) >> 1)
#define GET_PAD8_IE (((REG32(ADR_PAD8)) & 0x00000008 ) >> 3)
#define GET_PAD8_SEL_I (((REG32(ADR_PAD8)) & 0x00000030 ) >> 4)
#define GET_PAD8_OD (((REG32(ADR_PAD8)) & 0x00000100 ) >> 8)
#define GET_WIFI_RX_SW_O_C (((REG32(ADR_PAD8)) & 0x10000000 ) >> 28)
#define GET_BT_SW_O_OE (((REG32(ADR_PAD9)) & 0x00000001 ) >> 0)
#define GET_BT_SW_O_PE (((REG32(ADR_PAD9)) & 0x00000002 ) >> 1)
#define GET_PAD9_IE (((REG32(ADR_PAD9)) & 0x00000008 ) >> 3)
#define GET_PAD9_SEL_I (((REG32(ADR_PAD9)) & 0x00000030 ) >> 4)
#define GET_PAD9_OD (((REG32(ADR_PAD9)) & 0x00000100 ) >> 8)
#define GET_PAD9_SEL_O (((REG32(ADR_PAD9)) & 0x00001000 ) >> 12)
#define GET_BT_SW_O_C (((REG32(ADR_PAD9)) & 0x10000000 ) >> 28)
#define GET_XPA_EN_O_OE (((REG32(ADR_PAD11)) & 0x00000001 ) >> 0)
#define GET_XPA_EN_O_PE (((REG32(ADR_PAD11)) & 0x00000002 ) >> 1)
#define GET_PAD11_IE (((REG32(ADR_PAD11)) & 0x00000008 ) >> 3)
#define GET_PAD11_SEL_I (((REG32(ADR_PAD11)) & 0x00000030 ) >> 4)
#define GET_PAD11_OD (((REG32(ADR_PAD11)) & 0x00000100 ) >> 8)
#define GET_PAD11_SEL_O (((REG32(ADR_PAD11)) & 0x00001000 ) >> 12)
#define GET_XPA_EN_O_C (((REG32(ADR_PAD11)) & 0x10000000 ) >> 28)
#define GET_PAD15_OE (((REG32(ADR_PAD15)) & 0x00000001 ) >> 0)
#define GET_PAD15_PE (((REG32(ADR_PAD15)) & 0x00000002 ) >> 1)
#define GET_PAD15_DS (((REG32(ADR_PAD15)) & 0x00000004 ) >> 2)
#define GET_PAD15_IE (((REG32(ADR_PAD15)) & 0x00000008 ) >> 3)
#define GET_PAD15_SEL_I (((REG32(ADR_PAD15)) & 0x00000030 ) >> 4)
#define GET_PAD15_OD (((REG32(ADR_PAD15)) & 0x00000100 ) >> 8)
#define GET_PAD15_SEL_O (((REG32(ADR_PAD15)) & 0x00001000 ) >> 12)
#define GET_TEST_1_ID (((REG32(ADR_PAD15)) & 0x10000000 ) >> 28)
#define GET_PAD16_OE (((REG32(ADR_PAD16)) & 0x00000001 ) >> 0)
#define GET_PAD16_PE (((REG32(ADR_PAD16)) & 0x00000002 ) >> 1)
#define GET_PAD16_DS (((REG32(ADR_PAD16)) & 0x00000004 ) >> 2)
#define GET_PAD16_IE (((REG32(ADR_PAD16)) & 0x00000008 ) >> 3)
#define GET_PAD16_SEL_I (((REG32(ADR_PAD16)) & 0x00000030 ) >> 4)
#define GET_PAD16_OD (((REG32(ADR_PAD16)) & 0x00000100 ) >> 8)
#define GET_PAD16_SEL_O (((REG32(ADR_PAD16)) & 0x00001000 ) >> 12)
#define GET_TEST_2_ID (((REG32(ADR_PAD16)) & 0x10000000 ) >> 28)
#define GET_PAD17_OE (((REG32(ADR_PAD17)) & 0x00000001 ) >> 0)
#define GET_PAD17_PE (((REG32(ADR_PAD17)) & 0x00000002 ) >> 1)
#define GET_PAD17_DS (((REG32(ADR_PAD17)) & 0x00000004 ) >> 2)
#define GET_PAD17_IE (((REG32(ADR_PAD17)) & 0x00000008 ) >> 3)
#define GET_PAD17_SEL_I (((REG32(ADR_PAD17)) & 0x00000030 ) >> 4)
#define GET_PAD17_OD (((REG32(ADR_PAD17)) & 0x00000100 ) >> 8)
#define GET_PAD17_SEL_O (((REG32(ADR_PAD17)) & 0x00001000 ) >> 12)
#define GET_TEST_3_ID (((REG32(ADR_PAD17)) & 0x10000000 ) >> 28)
#define GET_PAD18_OE (((REG32(ADR_PAD18)) & 0x00000001 ) >> 0)
#define GET_PAD18_PE (((REG32(ADR_PAD18)) & 0x00000002 ) >> 1)
#define GET_PAD18_DS (((REG32(ADR_PAD18)) & 0x00000004 ) >> 2)
#define GET_PAD18_IE (((REG32(ADR_PAD18)) & 0x00000008 ) >> 3)
#define GET_PAD18_SEL_I (((REG32(ADR_PAD18)) & 0x00000030 ) >> 4)
#define GET_PAD18_OD (((REG32(ADR_PAD18)) & 0x00000100 ) >> 8)
#define GET_PAD18_SEL_O (((REG32(ADR_PAD18)) & 0x00003000 ) >> 12)
#define GET_TEST_4_ID (((REG32(ADR_PAD18)) & 0x10000000 ) >> 28)
#define GET_PAD19_OE (((REG32(ADR_PAD19)) & 0x00000001 ) >> 0)
#define GET_PAD19_PE (((REG32(ADR_PAD19)) & 0x00000002 ) >> 1)
#define GET_PAD19_DS (((REG32(ADR_PAD19)) & 0x00000004 ) >> 2)
#define GET_PAD19_IE (((REG32(ADR_PAD19)) & 0x00000008 ) >> 3)
#define GET_PAD19_SEL_I (((REG32(ADR_PAD19)) & 0x00000030 ) >> 4)
#define GET_PAD19_OD (((REG32(ADR_PAD19)) & 0x00000100 ) >> 8)
#define GET_PAD19_SEL_O (((REG32(ADR_PAD19)) & 0x00007000 ) >> 12)
#define GET_SHORT_TO_20_ID (((REG32(ADR_PAD19)) & 0x10000000 ) >> 28)
#define GET_PAD20_OE (((REG32(ADR_PAD20)) & 0x00000001 ) >> 0)
#define GET_PAD20_PE (((REG32(ADR_PAD20)) & 0x00000002 ) >> 1)
#define GET_PAD20_DS (((REG32(ADR_PAD20)) & 0x00000004 ) >> 2)
#define GET_PAD20_IE (((REG32(ADR_PAD20)) & 0x00000008 ) >> 3)
#define GET_PAD20_SEL_I (((REG32(ADR_PAD20)) & 0x000000f0 ) >> 4)
#define GET_PAD20_OD (((REG32(ADR_PAD20)) & 0x00000100 ) >> 8)
#define GET_PAD20_SEL_O (((REG32(ADR_PAD20)) & 0x00003000 ) >> 12)
#define GET_STRAP0 (((REG32(ADR_PAD20)) & 0x08000000 ) >> 27)
#define GET_GPIO_TEST_1_ID (((REG32(ADR_PAD20)) & 0x10000000 ) >> 28)
#define GET_PAD21_OE (((REG32(ADR_PAD21)) & 0x00000001 ) >> 0)
#define GET_PAD21_PE (((REG32(ADR_PAD21)) & 0x00000002 ) >> 1)
#define GET_PAD21_DS (((REG32(ADR_PAD21)) & 0x00000004 ) >> 2)
#define GET_PAD21_IE (((REG32(ADR_PAD21)) & 0x00000008 ) >> 3)
#define GET_PAD21_SEL_I (((REG32(ADR_PAD21)) & 0x00000070 ) >> 4)
#define GET_PAD21_OD (((REG32(ADR_PAD21)) & 0x00000100 ) >> 8)
#define GET_PAD21_SEL_O (((REG32(ADR_PAD21)) & 0x00003000 ) >> 12)
#define GET_STRAP3 (((REG32(ADR_PAD21)) & 0x08000000 ) >> 27)
#define GET_GPIO_TEST_2_ID (((REG32(ADR_PAD21)) & 0x10000000 ) >> 28)
#define GET_PAD22_OE (((REG32(ADR_PAD22)) & 0x00000001 ) >> 0)
#define GET_PAD22_PE (((REG32(ADR_PAD22)) & 0x00000002 ) >> 1)
#define GET_PAD22_DS (((REG32(ADR_PAD22)) & 0x00000004 ) >> 2)
#define GET_PAD22_IE (((REG32(ADR_PAD22)) & 0x00000008 ) >> 3)
#define GET_PAD22_SEL_I (((REG32(ADR_PAD22)) & 0x00000070 ) >> 4)
#define GET_PAD22_OD (((REG32(ADR_PAD22)) & 0x00000100 ) >> 8)
#define GET_PAD22_SEL_O (((REG32(ADR_PAD22)) & 0x00007000 ) >> 12)
#define GET_PAD22_SEL_OE (((REG32(ADR_PAD22)) & 0x00100000 ) >> 20)
#define GET_GPIO_TEST_3_ID (((REG32(ADR_PAD22)) & 0x10000000 ) >> 28)
#define GET_PAD24_OE (((REG32(ADR_PAD24)) & 0x00000001 ) >> 0)
#define GET_PAD24_PE (((REG32(ADR_PAD24)) & 0x00000002 ) >> 1)
#define GET_PAD24_DS (((REG32(ADR_PAD24)) & 0x00000004 ) >> 2)
#define GET_PAD24_IE (((REG32(ADR_PAD24)) & 0x00000008 ) >> 3)
#define GET_PAD24_SEL_I (((REG32(ADR_PAD24)) & 0x00000030 ) >> 4)
#define GET_PAD24_OD (((REG32(ADR_PAD24)) & 0x00000100 ) >> 8)
#define GET_PAD24_SEL_O (((REG32(ADR_PAD24)) & 0x00007000 ) >> 12)
#define GET_GPIO_TEST_4_ID (((REG32(ADR_PAD24)) & 0x10000000 ) >> 28)
#define GET_PAD25_OE (((REG32(ADR_PAD25)) & 0x00000001 ) >> 0)
#define GET_PAD25_PE (((REG32(ADR_PAD25)) & 0x00000002 ) >> 1)
#define GET_PAD25_DS (((REG32(ADR_PAD25)) & 0x00000004 ) >> 2)
#define GET_PAD25_IE (((REG32(ADR_PAD25)) & 0x00000008 ) >> 3)
#define GET_PAD25_SEL_I (((REG32(ADR_PAD25)) & 0x00000070 ) >> 4)
#define GET_PAD25_OD (((REG32(ADR_PAD25)) & 0x00000100 ) >> 8)
#define GET_PAD25_SEL_O (((REG32(ADR_PAD25)) & 0x00007000 ) >> 12)
#define GET_PAD25_SEL_OE (((REG32(ADR_PAD25)) & 0x00100000 ) >> 20)
#define GET_STRAP1 (((REG32(ADR_PAD25)) & 0x08000000 ) >> 27)
#define GET_GPIO_1_ID (((REG32(ADR_PAD25)) & 0x10000000 ) >> 28)
#define GET_PAD27_OE (((REG32(ADR_PAD27)) & 0x00000001 ) >> 0)
#define GET_PAD27_PE (((REG32(ADR_PAD27)) & 0x00000002 ) >> 1)
#define GET_PAD27_DS (((REG32(ADR_PAD27)) & 0x00000004 ) >> 2)
#define GET_PAD27_IE (((REG32(ADR_PAD27)) & 0x00000008 ) >> 3)
#define GET_PAD27_SEL_I (((REG32(ADR_PAD27)) & 0x00000070 ) >> 4)
#define GET_PAD27_OD (((REG32(ADR_PAD27)) & 0x00000100 ) >> 8)
#define GET_PAD27_SEL_O (((REG32(ADR_PAD27)) & 0x00007000 ) >> 12)
#define GET_GPIO_2_ID (((REG32(ADR_PAD27)) & 0x10000000 ) >> 28)
#define GET_PAD28_OE (((REG32(ADR_PAD28)) & 0x00000001 ) >> 0)
#define GET_PAD28_PE (((REG32(ADR_PAD28)) & 0x00000002 ) >> 1)
#define GET_PAD28_DS (((REG32(ADR_PAD28)) & 0x00000004 ) >> 2)
#define GET_PAD28_IE (((REG32(ADR_PAD28)) & 0x00000008 ) >> 3)
#define GET_PAD28_SEL_I (((REG32(ADR_PAD28)) & 0x00000070 ) >> 4)
#define GET_PAD28_OD (((REG32(ADR_PAD28)) & 0x00000100 ) >> 8)
#define GET_PAD28_SEL_O (((REG32(ADR_PAD28)) & 0x0000f000 ) >> 12)
#define GET_PAD28_SEL_OE (((REG32(ADR_PAD28)) & 0x00100000 ) >> 20)
#define GET_GPIO_3_ID (((REG32(ADR_PAD28)) & 0x10000000 ) >> 28)
#define GET_PAD29_OE (((REG32(ADR_PAD29)) & 0x00000001 ) >> 0)
#define GET_PAD29_PE (((REG32(ADR_PAD29)) & 0x00000002 ) >> 1)
#define GET_PAD29_DS (((REG32(ADR_PAD29)) & 0x00000004 ) >> 2)
#define GET_PAD29_IE (((REG32(ADR_PAD29)) & 0x00000008 ) >> 3)
#define GET_PAD29_SEL_I (((REG32(ADR_PAD29)) & 0x00000070 ) >> 4)
#define GET_PAD29_OD (((REG32(ADR_PAD29)) & 0x00000100 ) >> 8)
#define GET_PAD29_SEL_O (((REG32(ADR_PAD29)) & 0x00007000 ) >> 12)
#define GET_GPIO_TEST_5_ID (((REG32(ADR_PAD29)) & 0x10000000 ) >> 28)
#define GET_PAD30_OE (((REG32(ADR_PAD30)) & 0x00000001 ) >> 0)
#define GET_PAD30_PE (((REG32(ADR_PAD30)) & 0x00000002 ) >> 1)
#define GET_PAD30_DS (((REG32(ADR_PAD30)) & 0x00000004 ) >> 2)
#define GET_PAD30_IE (((REG32(ADR_PAD30)) & 0x00000008 ) >> 3)
#define GET_PAD30_SEL_I (((REG32(ADR_PAD30)) & 0x00000030 ) >> 4)
#define GET_PAD30_OD (((REG32(ADR_PAD30)) & 0x00000100 ) >> 8)
#define GET_PAD30_SEL_O (((REG32(ADR_PAD30)) & 0x00003000 ) >> 12)
#define GET_TEST_6_ID (((REG32(ADR_PAD30)) & 0x10000000 ) >> 28)
#define GET_PAD31_OE (((REG32(ADR_PAD31)) & 0x00000001 ) >> 0)
#define GET_PAD31_PE (((REG32(ADR_PAD31)) & 0x00000002 ) >> 1)
#define GET_PAD31_DS (((REG32(ADR_PAD31)) & 0x00000004 ) >> 2)
#define GET_PAD31_IE (((REG32(ADR_PAD31)) & 0x00000008 ) >> 3)
#define GET_PAD31_SEL_I (((REG32(ADR_PAD31)) & 0x00000030 ) >> 4)
#define GET_PAD31_OD (((REG32(ADR_PAD31)) & 0x00000100 ) >> 8)
#define GET_PAD31_SEL_O (((REG32(ADR_PAD31)) & 0x00003000 ) >> 12)
#define GET_TEST_7_ID (((REG32(ADR_PAD31)) & 0x10000000 ) >> 28)
#define GET_PAD32_OE (((REG32(ADR_PAD32)) & 0x00000001 ) >> 0)
#define GET_PAD32_PE (((REG32(ADR_PAD32)) & 0x00000002 ) >> 1)
#define GET_PAD32_DS (((REG32(ADR_PAD32)) & 0x00000004 ) >> 2)
#define GET_PAD32_IE (((REG32(ADR_PAD32)) & 0x00000008 ) >> 3)
#define GET_PAD32_SEL_I (((REG32(ADR_PAD32)) & 0x00000030 ) >> 4)
#define GET_PAD32_OD (((REG32(ADR_PAD32)) & 0x00000100 ) >> 8)
#define GET_PAD32_SEL_O (((REG32(ADR_PAD32)) & 0x00003000 ) >> 12)
#define GET_TEST_8_ID (((REG32(ADR_PAD32)) & 0x10000000 ) >> 28)
#define GET_PAD33_OE (((REG32(ADR_PAD33)) & 0x00000001 ) >> 0)
#define GET_PAD33_PE (((REG32(ADR_PAD33)) & 0x00000002 ) >> 1)
#define GET_PAD33_DS (((REG32(ADR_PAD33)) & 0x00000004 ) >> 2)
#define GET_PAD33_IE (((REG32(ADR_PAD33)) & 0x00000008 ) >> 3)
#define GET_PAD33_SEL_I (((REG32(ADR_PAD33)) & 0x00000030 ) >> 4)
#define GET_PAD33_OD (((REG32(ADR_PAD33)) & 0x00000100 ) >> 8)
#define GET_PAD33_SEL_O (((REG32(ADR_PAD33)) & 0x00003000 ) >> 12)
#define GET_TEST_9_ID (((REG32(ADR_PAD33)) & 0x10000000 ) >> 28)
#define GET_PAD34_OE (((REG32(ADR_PAD34)) & 0x00000001 ) >> 0)
#define GET_PAD34_PE (((REG32(ADR_PAD34)) & 0x00000002 ) >> 1)
#define GET_PAD34_DS (((REG32(ADR_PAD34)) & 0x00000004 ) >> 2)
#define GET_PAD34_IE (((REG32(ADR_PAD34)) & 0x00000008 ) >> 3)
#define GET_PAD34_SEL_I (((REG32(ADR_PAD34)) & 0x00000030 ) >> 4)
#define GET_PAD34_OD (((REG32(ADR_PAD34)) & 0x00000100 ) >> 8)
#define GET_PAD34_SEL_O (((REG32(ADR_PAD34)) & 0x00003000 ) >> 12)
#define GET_TEST_10_ID (((REG32(ADR_PAD34)) & 0x10000000 ) >> 28)
#define GET_PAD42_OE (((REG32(ADR_PAD42)) & 0x00000001 ) >> 0)
#define GET_PAD42_PE (((REG32(ADR_PAD42)) & 0x00000002 ) >> 1)
#define GET_PAD42_DS (((REG32(ADR_PAD42)) & 0x00000004 ) >> 2)
#define GET_PAD42_IE (((REG32(ADR_PAD42)) & 0x00000008 ) >> 3)
#define GET_PAD42_SEL_I (((REG32(ADR_PAD42)) & 0x00000030 ) >> 4)
#define GET_PAD42_OD (((REG32(ADR_PAD42)) & 0x00000100 ) >> 8)
#define GET_PAD42_SEL_O (((REG32(ADR_PAD42)) & 0x00001000 ) >> 12)
#define GET_TEST_11_ID (((REG32(ADR_PAD42)) & 0x10000000 ) >> 28)
#define GET_PAD43_OE (((REG32(ADR_PAD43)) & 0x00000001 ) >> 0)
#define GET_PAD43_PE (((REG32(ADR_PAD43)) & 0x00000002 ) >> 1)
#define GET_PAD43_DS (((REG32(ADR_PAD43)) & 0x00000004 ) >> 2)
#define GET_PAD43_IE (((REG32(ADR_PAD43)) & 0x00000008 ) >> 3)
#define GET_PAD43_SEL_I (((REG32(ADR_PAD43)) & 0x00000030 ) >> 4)
#define GET_PAD43_OD (((REG32(ADR_PAD43)) & 0x00000100 ) >> 8)
#define GET_PAD43_SEL_O (((REG32(ADR_PAD43)) & 0x00001000 ) >> 12)
#define GET_TEST_12_ID (((REG32(ADR_PAD43)) & 0x10000000 ) >> 28)
#define GET_PAD44_OE (((REG32(ADR_PAD44)) & 0x00000001 ) >> 0)
#define GET_PAD44_PE (((REG32(ADR_PAD44)) & 0x00000002 ) >> 1)
#define GET_PAD44_DS (((REG32(ADR_PAD44)) & 0x00000004 ) >> 2)
#define GET_PAD44_IE (((REG32(ADR_PAD44)) & 0x00000008 ) >> 3)
#define GET_PAD44_SEL_I (((REG32(ADR_PAD44)) & 0x00000030 ) >> 4)
#define GET_PAD44_OD (((REG32(ADR_PAD44)) & 0x00000100 ) >> 8)
#define GET_PAD44_SEL_O (((REG32(ADR_PAD44)) & 0x00003000 ) >> 12)
#define GET_TEST_13_ID (((REG32(ADR_PAD44)) & 0x10000000 ) >> 28)
#define GET_PAD45_OE (((REG32(ADR_PAD45)) & 0x00000001 ) >> 0)
#define GET_PAD45_PE (((REG32(ADR_PAD45)) & 0x00000002 ) >> 1)
#define GET_PAD45_DS (((REG32(ADR_PAD45)) & 0x00000004 ) >> 2)
#define GET_PAD45_IE (((REG32(ADR_PAD45)) & 0x00000008 ) >> 3)
#define GET_PAD45_SEL_I (((REG32(ADR_PAD45)) & 0x00000030 ) >> 4)
#define GET_PAD45_OD (((REG32(ADR_PAD45)) & 0x00000100 ) >> 8)
#define GET_PAD45_SEL_O (((REG32(ADR_PAD45)) & 0x00003000 ) >> 12)
#define GET_TEST_14_ID (((REG32(ADR_PAD45)) & 0x10000000 ) >> 28)
#define GET_PAD46_OE (((REG32(ADR_PAD46)) & 0x00000001 ) >> 0)
#define GET_PAD46_PE (((REG32(ADR_PAD46)) & 0x00000002 ) >> 1)
#define GET_PAD46_DS (((REG32(ADR_PAD46)) & 0x00000004 ) >> 2)
#define GET_PAD46_IE (((REG32(ADR_PAD46)) & 0x00000008 ) >> 3)
#define GET_PAD46_SEL_I (((REG32(ADR_PAD46)) & 0x00000030 ) >> 4)
#define GET_PAD46_OD (((REG32(ADR_PAD46)) & 0x00000100 ) >> 8)
#define GET_PAD46_SEL_O (((REG32(ADR_PAD46)) & 0x00003000 ) >> 12)
#define GET_TEST_15_ID (((REG32(ADR_PAD46)) & 0x10000000 ) >> 28)
#define GET_PAD47_OE (((REG32(ADR_PAD47)) & 0x00000001 ) >> 0)
#define GET_PAD47_PE (((REG32(ADR_PAD47)) & 0x00000002 ) >> 1)
#define GET_PAD47_DS (((REG32(ADR_PAD47)) & 0x00000004 ) >> 2)
#define GET_PAD47_SEL_I (((REG32(ADR_PAD47)) & 0x00000030 ) >> 4)
#define GET_PAD47_OD (((REG32(ADR_PAD47)) & 0x00000100 ) >> 8)
#define GET_PAD47_SEL_O (((REG32(ADR_PAD47)) & 0x00003000 ) >> 12)
#define GET_PAD47_SEL_OE (((REG32(ADR_PAD47)) & 0x00100000 ) >> 20)
#define GET_GPIO_9_ID (((REG32(ADR_PAD47)) & 0x10000000 ) >> 28)
#define GET_PAD48_OE (((REG32(ADR_PAD48)) & 0x00000001 ) >> 0)
#define GET_PAD48_PE (((REG32(ADR_PAD48)) & 0x00000002 ) >> 1)
#define GET_PAD48_DS (((REG32(ADR_PAD48)) & 0x00000004 ) >> 2)
#define GET_PAD48_IE (((REG32(ADR_PAD48)) & 0x00000008 ) >> 3)
#define GET_PAD48_SEL_I (((REG32(ADR_PAD48)) & 0x00000070 ) >> 4)
#define GET_PAD48_OD (((REG32(ADR_PAD48)) & 0x00000100 ) >> 8)
#define GET_PAD48_PE_SEL (((REG32(ADR_PAD48)) & 0x00000800 ) >> 11)
#define GET_PAD48_SEL_O (((REG32(ADR_PAD48)) & 0x00003000 ) >> 12)
#define GET_PAD48_SEL_OE (((REG32(ADR_PAD48)) & 0x00100000 ) >> 20)
#define GET_GPIO_10_ID (((REG32(ADR_PAD48)) & 0x10000000 ) >> 28)
#define GET_PAD49_OE (((REG32(ADR_PAD49)) & 0x00000001 ) >> 0)
#define GET_PAD49_PE (((REG32(ADR_PAD49)) & 0x00000002 ) >> 1)
#define GET_PAD49_DS (((REG32(ADR_PAD49)) & 0x00000004 ) >> 2)
#define GET_PAD49_IE (((REG32(ADR_PAD49)) & 0x00000008 ) >> 3)
#define GET_PAD49_SEL_I (((REG32(ADR_PAD49)) & 0x00000070 ) >> 4)
#define GET_PAD49_OD (((REG32(ADR_PAD49)) & 0x00000100 ) >> 8)
#define GET_PAD49_SEL_O (((REG32(ADR_PAD49)) & 0x00003000 ) >> 12)
#define GET_PAD49_SEL_OE (((REG32(ADR_PAD49)) & 0x00100000 ) >> 20)
#define GET_GPIO_11_ID (((REG32(ADR_PAD49)) & 0x10000000 ) >> 28)
#define GET_PAD50_OE (((REG32(ADR_PAD50)) & 0x00000001 ) >> 0)
#define GET_PAD50_PE (((REG32(ADR_PAD50)) & 0x00000002 ) >> 1)
#define GET_PAD50_DS (((REG32(ADR_PAD50)) & 0x00000004 ) >> 2)
#define GET_PAD50_IE (((REG32(ADR_PAD50)) & 0x00000008 ) >> 3)
#define GET_PAD50_SEL_I (((REG32(ADR_PAD50)) & 0x00000070 ) >> 4)
#define GET_PAD50_OD (((REG32(ADR_PAD50)) & 0x00000100 ) >> 8)
#define GET_PAD50_SEL_O (((REG32(ADR_PAD50)) & 0x00003000 ) >> 12)
#define GET_PAD50_SEL_OE (((REG32(ADR_PAD50)) & 0x00100000 ) >> 20)
#define GET_GPIO_12_ID (((REG32(ADR_PAD50)) & 0x10000000 ) >> 28)
#define GET_PAD51_OE (((REG32(ADR_PAD51)) & 0x00000001 ) >> 0)
#define GET_PAD51_PE (((REG32(ADR_PAD51)) & 0x00000002 ) >> 1)
#define GET_PAD51_DS (((REG32(ADR_PAD51)) & 0x00000004 ) >> 2)
#define GET_PAD51_IE (((REG32(ADR_PAD51)) & 0x00000008 ) >> 3)
#define GET_PAD51_SEL_I (((REG32(ADR_PAD51)) & 0x00000030 ) >> 4)
#define GET_PAD51_OD (((REG32(ADR_PAD51)) & 0x00000100 ) >> 8)
#define GET_PAD51_SEL_O (((REG32(ADR_PAD51)) & 0x00001000 ) >> 12)
#define GET_PAD51_SEL_OE (((REG32(ADR_PAD51)) & 0x00100000 ) >> 20)
#define GET_GPIO_13_ID (((REG32(ADR_PAD51)) & 0x10000000 ) >> 28)
#define GET_PAD52_OE (((REG32(ADR_PAD52)) & 0x00000001 ) >> 0)
#define GET_PAD52_PE (((REG32(ADR_PAD52)) & 0x00000002 ) >> 1)
#define GET_PAD52_DS (((REG32(ADR_PAD52)) & 0x00000004 ) >> 2)
#define GET_PAD52_SEL_I (((REG32(ADR_PAD52)) & 0x00000030 ) >> 4)
#define GET_PAD52_OD (((REG32(ADR_PAD52)) & 0x00000100 ) >> 8)
#define GET_PAD52_SEL_O (((REG32(ADR_PAD52)) & 0x00001000 ) >> 12)
#define GET_PAD52_SEL_OE (((REG32(ADR_PAD52)) & 0x00100000 ) >> 20)
#define GET_GPIO_14_ID (((REG32(ADR_PAD52)) & 0x10000000 ) >> 28)
#define GET_PAD53_OE (((REG32(ADR_PAD53)) & 0x00000001 ) >> 0)
#define GET_PAD53_PE (((REG32(ADR_PAD53)) & 0x00000002 ) >> 1)
#define GET_PAD53_DS (((REG32(ADR_PAD53)) & 0x00000004 ) >> 2)
#define GET_PAD53_IE (((REG32(ADR_PAD53)) & 0x00000008 ) >> 3)
#define GET_PAD53_SEL_I (((REG32(ADR_PAD53)) & 0x00000030 ) >> 4)
#define GET_PAD53_OD (((REG32(ADR_PAD53)) & 0x00000100 ) >> 8)
#define GET_PAD53_SEL_O (((REG32(ADR_PAD53)) & 0x00001000 ) >> 12)
#define GET_JTAG_TMS_ID (((REG32(ADR_PAD53)) & 0x10000000 ) >> 28)
#define GET_PAD54_OE (((REG32(ADR_PAD54)) & 0x00000001 ) >> 0)
#define GET_PAD54_PE (((REG32(ADR_PAD54)) & 0x00000002 ) >> 1)
#define GET_PAD54_DS (((REG32(ADR_PAD54)) & 0x00000004 ) >> 2)
#define GET_PAD54_OD (((REG32(ADR_PAD54)) & 0x00000100 ) >> 8)
#define GET_PAD54_SEL_O (((REG32(ADR_PAD54)) & 0x00003000 ) >> 12)
#define GET_JTAG_TCK_ID (((REG32(ADR_PAD54)) & 0x10000000 ) >> 28)
#define GET_PAD56_PE (((REG32(ADR_PAD56)) & 0x00000002 ) >> 1)
#define GET_PAD56_DS (((REG32(ADR_PAD56)) & 0x00000004 ) >> 2)
#define GET_PAD56_SEL_I (((REG32(ADR_PAD56)) & 0x00000010 ) >> 4)
#define GET_PAD56_OD (((REG32(ADR_PAD56)) & 0x00000100 ) >> 8)
#define GET_JTAG_TDI_ID (((REG32(ADR_PAD56)) & 0x10000000 ) >> 28)
#define GET_PAD57_OE (((REG32(ADR_PAD57)) & 0x00000001 ) >> 0)
#define GET_PAD57_PE (((REG32(ADR_PAD57)) & 0x00000002 ) >> 1)
#define GET_PAD57_DS (((REG32(ADR_PAD57)) & 0x00000004 ) >> 2)
#define GET_PAD57_IE (((REG32(ADR_PAD57)) & 0x00000008 ) >> 3)
#define GET_PAD57_SEL_I (((REG32(ADR_PAD57)) & 0x00000030 ) >> 4)
#define GET_PAD57_OD (((REG32(ADR_PAD57)) & 0x00000100 ) >> 8)
#define GET_PAD57_SEL_O (((REG32(ADR_PAD57)) & 0x00003000 ) >> 12)
#define GET_PAD57_SEL_OE (((REG32(ADR_PAD57)) & 0x00100000 ) >> 20)
#define GET_JTAG_TDO_ID (((REG32(ADR_PAD57)) & 0x10000000 ) >> 28)
#define GET_PAD58_OE (((REG32(ADR_PAD58)) & 0x00000001 ) >> 0)
#define GET_PAD58_PE (((REG32(ADR_PAD58)) & 0x00000002 ) >> 1)
#define GET_PAD58_DS (((REG32(ADR_PAD58)) & 0x00000004 ) >> 2)
#define GET_PAD58_IE (((REG32(ADR_PAD58)) & 0x00000008 ) >> 3)
#define GET_PAD58_SEL_I (((REG32(ADR_PAD58)) & 0x00000030 ) >> 4)
#define GET_PAD58_OD (((REG32(ADR_PAD58)) & 0x00000100 ) >> 8)
#define GET_PAD58_SEL_O (((REG32(ADR_PAD58)) & 0x00001000 ) >> 12)
#define GET_TEST_16_ID (((REG32(ADR_PAD58)) & 0x10000000 ) >> 28)
#define GET_PAD59_OE (((REG32(ADR_PAD59)) & 0x00000001 ) >> 0)
#define GET_PAD59_PE (((REG32(ADR_PAD59)) & 0x00000002 ) >> 1)
#define GET_PAD59_DS (((REG32(ADR_PAD59)) & 0x00000004 ) >> 2)
#define GET_PAD59_IE (((REG32(ADR_PAD59)) & 0x00000008 ) >> 3)
#define GET_PAD59_SEL_I (((REG32(ADR_PAD59)) & 0x00000030 ) >> 4)
#define GET_PAD59_OD (((REG32(ADR_PAD59)) & 0x00000100 ) >> 8)
#define GET_PAD59_SEL_O (((REG32(ADR_PAD59)) & 0x00001000 ) >> 12)
#define GET_TEST_17_ID (((REG32(ADR_PAD59)) & 0x10000000 ) >> 28)
#define GET_PAD60_OE (((REG32(ADR_PAD60)) & 0x00000001 ) >> 0)
#define GET_PAD60_PE (((REG32(ADR_PAD60)) & 0x00000002 ) >> 1)
#define GET_PAD60_DS (((REG32(ADR_PAD60)) & 0x00000004 ) >> 2)
#define GET_PAD60_IE (((REG32(ADR_PAD60)) & 0x00000008 ) >> 3)
#define GET_PAD60_SEL_I (((REG32(ADR_PAD60)) & 0x00000030 ) >> 4)
#define GET_PAD60_OD (((REG32(ADR_PAD60)) & 0x00000100 ) >> 8)
#define GET_PAD60_SEL_O (((REG32(ADR_PAD60)) & 0x00001000 ) >> 12)
#define GET_TEST_18_ID (((REG32(ADR_PAD60)) & 0x10000000 ) >> 28)
#define GET_PAD61_OE (((REG32(ADR_PAD61)) & 0x00000001 ) >> 0)
#define GET_PAD61_PE (((REG32(ADR_PAD61)) & 0x00000002 ) >> 1)
#define GET_PAD61_DS (((REG32(ADR_PAD61)) & 0x00000004 ) >> 2)
#define GET_PAD61_IE (((REG32(ADR_PAD61)) & 0x00000008 ) >> 3)
#define GET_PAD61_SEL_I (((REG32(ADR_PAD61)) & 0x00000010 ) >> 4)
#define GET_PAD61_OD (((REG32(ADR_PAD61)) & 0x00000100 ) >> 8)
#define GET_PAD61_SEL_O (((REG32(ADR_PAD61)) & 0x00003000 ) >> 12)
#define GET_TEST_19_ID (((REG32(ADR_PAD61)) & 0x10000000 ) >> 28)
#define GET_PAD62_OE (((REG32(ADR_PAD62)) & 0x00000001 ) >> 0)
#define GET_PAD62_PE (((REG32(ADR_PAD62)) & 0x00000002 ) >> 1)
#define GET_PAD62_DS (((REG32(ADR_PAD62)) & 0x00000004 ) >> 2)
#define GET_PAD62_IE (((REG32(ADR_PAD62)) & 0x00000008 ) >> 3)
#define GET_PAD62_SEL_I (((REG32(ADR_PAD62)) & 0x00000010 ) >> 4)
#define GET_PAD62_OD (((REG32(ADR_PAD62)) & 0x00000100 ) >> 8)
#define GET_PAD62_SEL_O (((REG32(ADR_PAD62)) & 0x00001000 ) >> 12)
#define GET_TEST_20_ID (((REG32(ADR_PAD62)) & 0x10000000 ) >> 28)
#define GET_PAD64_OE (((REG32(ADR_PAD64)) & 0x00000001 ) >> 0)
#define GET_PAD64_PE (((REG32(ADR_PAD64)) & 0x00000002 ) >> 1)
#define GET_PAD64_DS (((REG32(ADR_PAD64)) & 0x00000004 ) >> 2)
#define GET_PAD64_IE (((REG32(ADR_PAD64)) & 0x00000008 ) >> 3)
#define GET_PAD64_SEL_I (((REG32(ADR_PAD64)) & 0x00000070 ) >> 4)
#define GET_PAD64_OD (((REG32(ADR_PAD64)) & 0x00000100 ) >> 8)
#define GET_PAD64_SEL_O (((REG32(ADR_PAD64)) & 0x00003000 ) >> 12)
#define GET_PAD64_SEL_OE (((REG32(ADR_PAD64)) & 0x00100000 ) >> 20)
#define GET_GPIO_15_IP_ID (((REG32(ADR_PAD64)) & 0x10000000 ) >> 28)
#define GET_PAD65_OE (((REG32(ADR_PAD65)) & 0x00000001 ) >> 0)
#define GET_PAD65_PE (((REG32(ADR_PAD65)) & 0x00000002 ) >> 1)
#define GET_PAD65_DS (((REG32(ADR_PAD65)) & 0x00000004 ) >> 2)
#define GET_PAD65_IE (((REG32(ADR_PAD65)) & 0x00000008 ) >> 3)
#define GET_PAD65_SEL_I (((REG32(ADR_PAD65)) & 0x00000070 ) >> 4)
#define GET_PAD65_OD (((REG32(ADR_PAD65)) & 0x00000100 ) >> 8)
#define GET_PAD65_SEL_O (((REG32(ADR_PAD65)) & 0x00001000 ) >> 12)
#define GET_GPIO_TEST_7_IN_ID (((REG32(ADR_PAD65)) & 0x10000000 ) >> 28)
#define GET_PAD66_OE (((REG32(ADR_PAD66)) & 0x00000001 ) >> 0)
#define GET_PAD66_PE (((REG32(ADR_PAD66)) & 0x00000002 ) >> 1)
#define GET_PAD66_DS (((REG32(ADR_PAD66)) & 0x00000004 ) >> 2)
#define GET_PAD66_IE (((REG32(ADR_PAD66)) & 0x00000008 ) >> 3)
#define GET_PAD66_SEL_I (((REG32(ADR_PAD66)) & 0x00000030 ) >> 4)
#define GET_PAD66_OD (((REG32(ADR_PAD66)) & 0x00000100 ) >> 8)
#define GET_PAD66_SEL_O (((REG32(ADR_PAD66)) & 0x00003000 ) >> 12)
#define GET_GPIO_17_QP_ID (((REG32(ADR_PAD66)) & 0x10000000 ) >> 28)
#define GET_PAD68_OE (((REG32(ADR_PAD68)) & 0x00000001 ) >> 0)
#define GET_PAD68_PE (((REG32(ADR_PAD68)) & 0x00000002 ) >> 1)
#define GET_PAD68_DS (((REG32(ADR_PAD68)) & 0x00000004 ) >> 2)
#define GET_PAD68_IE (((REG32(ADR_PAD68)) & 0x00000008 ) >> 3)
#define GET_PAD68_OD (((REG32(ADR_PAD68)) & 0x00000100 ) >> 8)
#define GET_PAD68_SEL_O (((REG32(ADR_PAD68)) & 0x00001000 ) >> 12)
#define GET_GPIO_19_ID (((REG32(ADR_PAD68)) & 0x10000000 ) >> 28)
#define GET_PAD67_OE (((REG32(ADR_PAD67)) & 0x00000001 ) >> 0)
#define GET_PAD67_PE (((REG32(ADR_PAD67)) & 0x00000002 ) >> 1)
#define GET_PAD67_DS (((REG32(ADR_PAD67)) & 0x00000004 ) >> 2)
#define GET_PAD67_IE (((REG32(ADR_PAD67)) & 0x00000008 ) >> 3)
#define GET_PAD67_SEL_I (((REG32(ADR_PAD67)) & 0x00000070 ) >> 4)
#define GET_PAD67_OD (((REG32(ADR_PAD67)) & 0x00000100 ) >> 8)
#define GET_PAD67_SEL_O (((REG32(ADR_PAD67)) & 0x00003000 ) >> 12)
#define GET_GPIO_TEST_8_QN_ID (((REG32(ADR_PAD67)) & 0x10000000 ) >> 28)
#define GET_PAD69_OE (((REG32(ADR_PAD69)) & 0x00000001 ) >> 0)
#define GET_PAD69_PE (((REG32(ADR_PAD69)) & 0x00000002 ) >> 1)
#define GET_PAD69_DS (((REG32(ADR_PAD69)) & 0x00000004 ) >> 2)
#define GET_PAD69_IE (((REG32(ADR_PAD69)) & 0x00000008 ) >> 3)
#define GET_PAD69_SEL_I (((REG32(ADR_PAD69)) & 0x00000030 ) >> 4)
#define GET_PAD69_OD (((REG32(ADR_PAD69)) & 0x00000100 ) >> 8)
#define GET_PAD69_SEL_O (((REG32(ADR_PAD69)) & 0x00001000 ) >> 12)
#define GET_STRAP2 (((REG32(ADR_PAD69)) & 0x08000000 ) >> 27)
#define GET_GPIO_20_ID (((REG32(ADR_PAD69)) & 0x10000000 ) >> 28)
#define GET_PAD70_OE (((REG32(ADR_PAD70)) & 0x00000001 ) >> 0)
#define GET_PAD70_PE (((REG32(ADR_PAD70)) & 0x00000002 ) >> 1)
#define GET_PAD70_DS (((REG32(ADR_PAD70)) & 0x00000004 ) >> 2)
#define GET_PAD70_IE (((REG32(ADR_PAD70)) & 0x00000008 ) >> 3)
#define GET_PAD70_SEL_I (((REG32(ADR_PAD70)) & 0x00000030 ) >> 4)
#define GET_PAD70_OD (((REG32(ADR_PAD70)) & 0x00000100 ) >> 8)
#define GET_PAD70_SEL_O (((REG32(ADR_PAD70)) & 0x00007000 ) >> 12)
#define GET_GPIO_21_ID (((REG32(ADR_PAD70)) & 0x10000000 ) >> 28)
#define GET_PAD231_OE (((REG32(ADR_PAD231)) & 0x00000001 ) >> 0)
#define GET_PAD231_PE (((REG32(ADR_PAD231)) & 0x00000002 ) >> 1)
#define GET_PAD231_DS (((REG32(ADR_PAD231)) & 0x00000004 ) >> 2)
#define GET_PAD231_IE (((REG32(ADR_PAD231)) & 0x00000008 ) >> 3)
#define GET_PAD231_OD (((REG32(ADR_PAD231)) & 0x00000100 ) >> 8)
#define GET_PIN_40_OR_56_ID (((REG32(ADR_PAD231)) & 0x10000000 ) >> 28)
#define GET_MP_PHY2RX_DATA__0_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00000001 ) >> 0)
#define GET_MP_PHY2RX_DATA__1_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00000002 ) >> 1)
#define GET_MP_TX_FF_RPTR__1_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00000004 ) >> 2)
#define GET_MP_RX_FF_WPTR__2_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00000008 ) >> 3)
#define GET_MP_RX_FF_WPTR__1_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00000010 ) >> 4)
#define GET_MP_RX_FF_WPTR__0_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00000020 ) >> 5)
#define GET_MP_PHY2RX_DATA__2_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00000040 ) >> 6)
#define GET_MP_PHY2RX_DATA__4_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00000080 ) >> 7)
#define GET_I2CM_SDA_ID_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00000300 ) >> 8)
#define GET_CRYSTAL_OUT_REQ_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00000400 ) >> 10)
#define GET_MP_PHY2RX_DATA__5_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00000800 ) >> 11)
#define GET_MP_PHY2RX_DATA__3_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00001000 ) >> 12)
#define GET_UART_RXD_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00006000 ) >> 13)
#define GET_MP_PHY2RX_DATA__6_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00008000 ) >> 15)
#define GET_DAT_UART_NCTS_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00010000 ) >> 16)
#define GET_GPIO_LOG_STOP_SEL (((REG32(ADR_PIN_SEL_0)) & 0x000e0000 ) >> 17)
#define GET_MP_TX_FF_RPTR__0_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00100000 ) >> 20)
#define GET_MP_PHY_RX_WRST_N_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00200000 ) >> 21)
#define GET_EXT_32K_SEL (((REG32(ADR_PIN_SEL_0)) & 0x00c00000 ) >> 22)
#define GET_MP_PHY2RX_DATA__7_SEL (((REG32(ADR_PIN_SEL_0)) & 0x01000000 ) >> 24)
#define GET_MP_TX_FF_RPTR__2_SEL (((REG32(ADR_PIN_SEL_0)) & 0x02000000 ) >> 25)
#define GET_PMUINT_WAKE_SEL (((REG32(ADR_PIN_SEL_0)) & 0x1c000000 ) >> 26)
#define GET_I2CM_SCL_ID_SEL (((REG32(ADR_PIN_SEL_0)) & 0x20000000 ) >> 29)
#define GET_MP_MRX_RX_EN_SEL (((REG32(ADR_PIN_SEL_0)) & 0x40000000 ) >> 30)
#define GET_DAT_UART_RXD_SEL_0 (((REG32(ADR_PIN_SEL_0)) & 0x80000000 ) >> 31)
#define GET_DAT_UART_RXD_SEL_1 (((REG32(ADR_PIN_SEL_1)) & 0x00000001 ) >> 0)
#define GET_SPI_DI_SEL (((REG32(ADR_PIN_SEL_1)) & 0x00000002 ) >> 1)
#define GET_IO_PORT_REG (((REG32(ADR_IO_PORT_REG)) & 0x0001ffff ) >> 0)
#define GET_MASK_RX_INT (((REG32(ADR_INT_MASK_REG)) & 0x00000001 ) >> 0)
#define GET_MASK_TX_INT (((REG32(ADR_INT_MASK_REG)) & 0x00000002 ) >> 1)
#define GET_MASK_SOC_SYSTEM_INT (((REG32(ADR_INT_MASK_REG)) & 0x00000004 ) >> 2)
#define GET_EDCA0_LOW_THR_INT_MASK (((REG32(ADR_INT_MASK_REG)) & 0x00000008 ) >> 3)
#define GET_EDCA1_LOW_THR_INT_MASK (((REG32(ADR_INT_MASK_REG)) & 0x00000010 ) >> 4)
#define GET_EDCA2_LOW_THR_INT_MASK (((REG32(ADR_INT_MASK_REG)) & 0x00000020 ) >> 5)
#define GET_EDCA3_LOW_THR_INT_MASK (((REG32(ADR_INT_MASK_REG)) & 0x00000040 ) >> 6)
#define GET_TX_LIMIT_INT_MASK (((REG32(ADR_INT_MASK_REG)) & 0x00000080 ) >> 7)
#define GET_RX_INT (((REG32(ADR_INT_STATUS_REG)) & 0x00000001 ) >> 0)
#define GET_TX_COMPLETE_INT (((REG32(ADR_INT_STATUS_REG)) & 0x00000002 ) >> 1)
#define GET_SOC_SYSTEM_INT_STATUS (((REG32(ADR_INT_STATUS_REG)) & 0x00000004 ) >> 2)
#define GET_EDCA0_LOW_THR_INT_STS (((REG32(ADR_INT_STATUS_REG)) & 0x00000008 ) >> 3)
#define GET_EDCA1_LOW_THR_INT_STS (((REG32(ADR_INT_STATUS_REG)) & 0x00000010 ) >> 4)
#define GET_EDCA2_LOW_THR_INT_STS (((REG32(ADR_INT_STATUS_REG)) & 0x00000020 ) >> 5)
#define GET_EDCA3_LOW_THR_INT_STS (((REG32(ADR_INT_STATUS_REG)) & 0x00000040 ) >> 6)
#define GET_TX_LIMIT_INT_STS (((REG32(ADR_INT_STATUS_REG)) & 0x00000080 ) >> 7)
#define GET_HOST_TRIGGERED_RX_INT (((REG32(ADR_INT_STATUS_REG)) & 0x00000100 ) >> 8)
#define GET_HOST_TRIGGERED_TX_INT (((REG32(ADR_INT_STATUS_REG)) & 0x00000200 ) >> 9)
#define GET_SOC_TRIGGER_RX_INT (((REG32(ADR_INT_STATUS_REG)) & 0x00000400 ) >> 10)
#define GET_SOC_TRIGGER_TX_INT (((REG32(ADR_INT_STATUS_REG)) & 0x00000800 ) >> 11)
#define GET_RDY_FOR_TX_RX (((REG32(ADR_FN1_STATUS_REG)) & 0x00000001 ) >> 0)
#define GET_RDY_FOR_FW_DOWNLOAD (((REG32(ADR_FN1_STATUS_REG)) & 0x00000002 ) >> 1)
#define GET_ILLEGAL_CMD_RESP_OPTION (((REG32(ADR_FN1_STATUS_REG)) & 0x00000004 ) >> 2)
#define GET_SDIO_TRX_DATA_SEQUENCE (((REG32(ADR_FN1_STATUS_REG)) & 0x00000008 ) >> 3)
#define GET_GPIO_INT_TRIGGER_OPTION (((REG32(ADR_FN1_STATUS_REG)) & 0x00000010 ) >> 4)
#define GET_TRIGGER_FUNCTION_SETTING (((REG32(ADR_FN1_STATUS_REG)) & 0x00000060 ) >> 5)
#define GET_CMD52_ABORT_RESPONSE (((REG32(ADR_FN1_STATUS_REG)) & 0x00000080 ) >> 7)
#define GET_RX_PACKET_LENGTH (((REG32(ADR_CARD_PKT_STATUS_TEST)) & 0x0000ffff ) >> 0)
#define GET_CARD_FW_DL_STATUS (((REG32(ADR_CARD_PKT_STATUS_TEST)) & 0x00ff0000 ) >> 16)
#define GET_TX_RX_LOOP_BACK_TEST (((REG32(ADR_CARD_PKT_STATUS_TEST)) & 0x01000000 ) >> 24)
#define GET_SDIO_LOOP_BACK_TEST (((REG32(ADR_CARD_PKT_STATUS_TEST)) & 0x02000000 ) >> 25)
#define GET_CMD52_ABORT_ACTIVE (((REG32(ADR_CARD_PKT_STATUS_TEST)) & 0x10000000 ) >> 28)
#define GET_CMD52_RESET_ACTIVE (((REG32(ADR_CARD_PKT_STATUS_TEST)) & 0x20000000 ) >> 29)
#define GET_SDIO_PARTIAL_RESET_ACTIVE (((REG32(ADR_CARD_PKT_STATUS_TEST)) & 0x40000000 ) >> 30)
#define GET_SDIO_ALL_RESE_ACTIVE (((REG32(ADR_CARD_PKT_STATUS_TEST)) & 0x80000000 ) >> 31)
#define GET_RX_PACKET_LENGTH2 (((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0x0000ffff ) >> 0)
#define GET_RX_INT1 (((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0x00010000 ) >> 16)
#define GET_TX_DONE (((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0x00020000 ) >> 17)
#define GET_HCI_TRX_FINISH (((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0x00040000 ) >> 18)
#define GET_ALLOCATE_STATUS (((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0x00080000 ) >> 19)
#define GET_HCI_INPUT_FF_CNT (((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0x00f00000 ) >> 20)
#define GET_HCI_OUTPUT_FF_CNT (((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0x1f000000 ) >> 24)
#define GET_AHB_HANG4 (((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0x20000000 ) >> 29)
#define GET_HCI_IN_QUE_EMPTY (((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0x40000000 ) >> 30)
#define GET_SYSTEM_INT (((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0x80000000 ) >> 31)
#define GET_CARD_RCA_REG (((REG32(ADR_CARD_RCA_REG)) & 0x0000ffff ) >> 0)
#define GET_SDIO_FIFO_WR_THLD_REG (((REG32(ADR_SDIO_FIFO_WR_THLD_REG)) & 0x000001ff ) >> 0)
#define GET_SDIO_FIFO_WR_LIMIT_REG (((REG32(ADR_SDIO_FIFO_WR_LIMIT_REG)) & 0x000001ff ) >> 0)
#define GET_SDIO_TX_DATA_BATCH_SIZE_REG (((REG32(ADR_SDIO_TX_DATA_BATCH_SIZE_REG)) & 0x000001ff ) >> 0)
#define GET_SDIO_THLD_FOR_CMD53RD_REG (((REG32(ADR_SDIO_THLD_FOR_CMD53RD_REG)) & 0x000001ff ) >> 0)
#define GET_SDIO_RX_DATA_BATCH_SIZE_REG (((REG32(ADR_SDIO_RX_DATA_BATCH_SIZE_REG)) & 0x000001ff ) >> 0)
#define GET_START_BYTE_VALUE (((REG32(ADR_SDIO_LOG_START_END_DATA_REG)) & 0x000000ff ) >> 0)
#define GET_END_BYTE_VALUE (((REG32(ADR_SDIO_LOG_START_END_DATA_REG)) & 0x0000ff00 ) >> 8)
#define GET_SDIO_BYTE_MODE_BATCH_SIZE_REG (((REG32(ADR_SDIO_BYTE_MODE_BATCH_SIZE_REG)) & 0x000000ff ) >> 0)
#define GET_SDIO_LAST_CMD_INDEX_REG (((REG32(ADR_SDIO_LAST_CMD_INDEX_CRC_REG)) & 0x0000003f ) >> 0)
#define GET_SDIO_LAST_CMD_CRC_REG (((REG32(ADR_SDIO_LAST_CMD_INDEX_CRC_REG)) & 0x00007f00 ) >> 8)
#define GET_SDIO_LAST_CMD_ARG_REG (((REG32(ADR_SDIO_LAST_CMD_ARG_REG)) & 0xffffffff ) >> 0)
#define GET_SDIO_BUS_STATE_REG (((REG32(ADR_SDIO_BUS_STATE_DEBUG_MONITOR)) & 0x0000001f ) >> 0)
#define GET_SDIO_BUSY_LONG_CNT (((REG32(ADR_SDIO_BUS_STATE_DEBUG_MONITOR)) & 0xffff0000 ) >> 16)
#define GET_SDIO_CARD_STATUS_REG (((REG32(ADR_SDIO_CARD_STATUS_REG)) & 0xffffffff ) >> 0)
#define GET_R5_RESPONSE_FLAG (((REG32(ADR_R5_RESP_FLAG_OUT_TIMING)) & 0x000000ff ) >> 0)
#define GET_RESP_OUT_EDGE (((REG32(ADR_R5_RESP_FLAG_OUT_TIMING)) & 0x00000100 ) >> 8)
#define GET_DAT_OUT_EDGE (((REG32(ADR_R5_RESP_FLAG_OUT_TIMING)) & 0x00000200 ) >> 9)
#define GET_MCU_TO_SDIO_INFO_MASK (((REG32(ADR_R5_RESP_FLAG_OUT_TIMING)) & 0x00010000 ) >> 16)
#define GET_INT_THROUGH_PIN (((REG32(ADR_R5_RESP_FLAG_OUT_TIMING)) & 0x00020000 ) >> 17)
#define GET_WRITE_DATA (((REG32(ADR_CMD52_DATA_FOR_LAST_TIME)) & 0x000000ff ) >> 0)
#define GET_WRITE_ADDRESS (((REG32(ADR_CMD52_DATA_FOR_LAST_TIME)) & 0x0000ff00 ) >> 8)
#define GET_READ_DATA (((REG32(ADR_CMD52_DATA_FOR_LAST_TIME)) & 0x00ff0000 ) >> 16)
#define GET_READ_ADDRESS (((REG32(ADR_CMD52_DATA_FOR_LAST_TIME)) & 0xff000000 ) >> 24)
#define GET_FN1_DMA_START_ADDR_REG (((REG32(ADR_FN1_DMA_START_ADDR_REG)) & 0xffffffff ) >> 0)
#define GET_SDIO_TO_MCU_INFO (((REG32(ADR_FN1_INT_CTRL_RESET)) & 0x000000ff ) >> 0)
#define GET_SDIO_PARTIAL_RESET (((REG32(ADR_FN1_INT_CTRL_RESET)) & 0x00000100 ) >> 8)
#define GET_SDIO_ALL_RESET (((REG32(ADR_FN1_INT_CTRL_RESET)) & 0x00000200 ) >> 9)
#define GET_PERI_MAC_ALL_RESET (((REG32(ADR_FN1_INT_CTRL_RESET)) & 0x00000400 ) >> 10)
#define GET_MAC_ALL_RESET (((REG32(ADR_FN1_INT_CTRL_RESET)) & 0x00000800 ) >> 11)
#define GET_AHB_BRIDGE_RESET (((REG32(ADR_FN1_INT_CTRL_RESET)) & 0x00001000 ) >> 12)
#define GET_IO_REG_PORT_REG (((REG32(ADR_IO_REG_PORT_REG)) & 0x0001ffff ) >> 0)
#define GET_SDIO_FIFO_EMPTY_CNT (((REG32(ADR_SDIO_FIFO_ERROR_CNT)) & 0x0000ffff ) >> 0)
#define GET_SDIO_FIFO_FULL_CNT (((REG32(ADR_SDIO_FIFO_ERROR_CNT)) & 0xffff0000 ) >> 16)
#define GET_SDIO_CRC7_ERROR_CNT (((REG32(ADR_SDIO_CRC7_CRC16_ERROR_REG)) & 0x0000ffff ) >> 0)
#define GET_SDIO_CRC16_ERROR_CNT (((REG32(ADR_SDIO_CRC7_CRC16_ERROR_REG)) & 0xffff0000 ) >> 16)
#define GET_SDIO_RD_BLOCK_CNT (((REG32(ADR_SDIO_BLOCK_CNT_INFO)) & 0x000001ff ) >> 0)
#define GET_SDIO_WR_BLOCK_CNT (((REG32(ADR_SDIO_BLOCK_CNT_INFO)) & 0x01ff0000 ) >> 16)
#define GET_CMD52_RD_ABORT_CNT (((REG32(ADR_RX_DATA_CMD52_ABORT_COUNT)) & 0x000f0000 ) >> 16)
#define GET_CMD52_WR_ABORT_CNT (((REG32(ADR_RX_DATA_CMD52_ABORT_COUNT)) & 0x00f00000 ) >> 20)
#define GET_SDIO_FIFO_WR_PTR_REG (((REG32(ADR_FIFO_PTR_READ_BLOCK_CNT)) & 0x000000ff ) >> 0)
#define GET_SDIO_FIFO_RD_PTR_REG (((REG32(ADR_FIFO_PTR_READ_BLOCK_CNT)) & 0x0000ff00 ) >> 8)
#define GET_SDIO_READ_DATA_CTRL (((REG32(ADR_TX_TIME_OUT_READ_CTRL)) & 0x00010000 ) >> 16)
#define GET_TX_SIZE_BEFORE_SHIFT (((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0x000000ff ) >> 0)
#define GET_TX_SIZE_SHIFT_BITS (((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0x00000700 ) >> 8)
#define GET_SDIO_TX_ALLOC_STATE (((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0x00001000 ) >> 12)
#define GET_ALLOCATE_STATUS2 (((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0x00010000 ) >> 16)
#define GET_NO_ALLOCATE_SEND_ERROR (((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0x00020000 ) >> 17)
#define GET_DOUBLE_ALLOCATE_ERROR (((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0x00040000 ) >> 18)
#define GET_TX_DONE_STATUS (((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0x00080000 ) >> 19)
#define GET_AHB_HANG2 (((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0x00100000 ) >> 20)
#define GET_HCI_TRX_FINISH2 (((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0x00200000 ) >> 21)
#define GET_INTR_RX (((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0x00400000 ) >> 22)
#define GET_HCI_INPUT_QUEUE_FULL (((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0x00800000 ) >> 23)
#define GET_ALLOCATESTATUS (((REG32(ADR_SDIO_TX_INFORM)) & 0x00000001 ) >> 0)
#define GET_HCI_TRX_FINISH3 (((REG32(ADR_SDIO_TX_INFORM)) & 0x00000002 ) >> 1)
#define GET_HCI_IN_QUE_EMPTY2 (((REG32(ADR_SDIO_TX_INFORM)) & 0x00000004 ) >> 2)
#define GET_MTX_MNG_UPTHOLD_INT (((REG32(ADR_SDIO_TX_INFORM)) & 0x00000008 ) >> 3)
#define GET_EDCA0_UPTHOLD_INT (((REG32(ADR_SDIO_TX_INFORM)) & 0x00000010 ) >> 4)
#define GET_EDCA1_UPTHOLD_INT (((REG32(ADR_SDIO_TX_INFORM)) & 0x00000020 ) >> 5)
#define GET_EDCA2_UPTHOLD_INT (((REG32(ADR_SDIO_TX_INFORM)) & 0x00000040 ) >> 6)
#define GET_EDCA3_UPTHOLD_INT (((REG32(ADR_SDIO_TX_INFORM)) & 0x00000080 ) >> 7)
#define GET_TX_PAGE_REMAIN2 (((REG32(ADR_SDIO_TX_INFORM)) & 0x0000ff00 ) >> 8)
#define GET_TX_ID_REMAIN3 (((REG32(ADR_SDIO_TX_INFORM)) & 0x007f0000 ) >> 16)
#define GET_HCI_OUTPUT_FF_CNT_0 (((REG32(ADR_SDIO_TX_INFORM)) & 0x00800000 ) >> 23)
#define GET_HCI_OUTPUT_FF_CNT2 (((REG32(ADR_SDIO_TX_INFORM)) & 0x0f000000 ) >> 24)
#define GET_HCI_INPUT_FF_CNT2 (((REG32(ADR_SDIO_TX_INFORM)) & 0xf0000000 ) >> 28)
#define GET_F1_BLOCK_SIZE_0_REG (((REG32(ADR_F1_BLOCK_SIZE_0_REG)) & 0x00000fff ) >> 0)
#define GET_START_BYTE_VALUE2 (((REG32(ADR_SDIO_COMMAND_LOG_DATA_31_0)) & 0x000000ff ) >> 0)
#define GET_COMMAND_COUNTER (((REG32(ADR_SDIO_COMMAND_LOG_DATA_31_0)) & 0x0000ff00 ) >> 8)
#define GET_CMD_LOG_PART1 (((REG32(ADR_SDIO_COMMAND_LOG_DATA_31_0)) & 0xffff0000 ) >> 16)
#define GET_CMD_LOG_PART2 (((REG32(ADR_SDIO_COMMAND_LOG_DATA_63_32)) & 0x00ffffff ) >> 0)
#define GET_END_BYTE_VALUE2 (((REG32(ADR_SDIO_COMMAND_LOG_DATA_63_32)) & 0xff000000 ) >> 24)
#define GET_RX_PACKET_LENGTH3 (((REG32(ADR_SYSTEM_INFORMATION_REGISTER)) & 0x0000ffff ) >> 0)
#define GET_RX_INT3 (((REG32(ADR_SYSTEM_INFORMATION_REGISTER)) & 0x00010000 ) >> 16)
#define GET_TX_ID_REMAIN2 (((REG32(ADR_SYSTEM_INFORMATION_REGISTER)) & 0x00fe0000 ) >> 17)
#define GET_TX_PAGE_REMAIN3 (((REG32(ADR_SYSTEM_INFORMATION_REGISTER)) & 0xff000000 ) >> 24)
#define GET_CCCR_00H_REG (((REG32(ADR_CCCR_00H_REG)) & 0x000000ff ) >> 0)
#define GET_CCCR_02H_REG (((REG32(ADR_CCCR_00H_REG)) & 0x00ff0000 ) >> 16)
#define GET_CCCR_03H_REG (((REG32(ADR_CCCR_00H_REG)) & 0xff000000 ) >> 24)
#define GET_CCCR_04H_REG (((REG32(ADR_CCCR_04H_REG)) & 0x000000ff ) >> 0)
#define GET_CCCR_05H_REG (((REG32(ADR_CCCR_04H_REG)) & 0x0000ff00 ) >> 8)
#define GET_CCCR_06H_REG (((REG32(ADR_CCCR_04H_REG)) & 0x000f0000 ) >> 16)
#define GET_CCCR_07H_REG (((REG32(ADR_CCCR_04H_REG)) & 0xff000000 ) >> 24)
#define GET_SUPPORT_DIRECT_COMMAND_SDIO (((REG32(ADR_CCCR_08H_REG)) & 0x00000001 ) >> 0)
#define GET_SUPPORT_MULTIPLE_BLOCK_TRANSFER (((REG32(ADR_CCCR_08H_REG)) & 0x00000002 ) >> 1)
#define GET_SUPPORT_READ_WAIT (((REG32(ADR_CCCR_08H_REG)) & 0x00000004 ) >> 2)
#define GET_SUPPORT_BUS_CONTROL (((REG32(ADR_CCCR_08H_REG)) & 0x00000008 ) >> 3)
#define GET_SUPPORT_BLOCK_GAP_INTERRUPT (((REG32(ADR_CCCR_08H_REG)) & 0x00000010 ) >> 4)
#define GET_ENABLE_BLOCK_GAP_INTERRUPT (((REG32(ADR_CCCR_08H_REG)) & 0x00000020 ) >> 5)
#define GET_LOW_SPEED_CARD (((REG32(ADR_CCCR_08H_REG)) & 0x00000040 ) >> 6)
#define GET_LOW_SPEED_CARD_4BIT (((REG32(ADR_CCCR_08H_REG)) & 0x00000080 ) >> 7)
#define GET_COMMON_CIS_PONTER (((REG32(ADR_CCCR_08H_REG)) & 0x01ffff00 ) >> 8)
#define GET_SUPPORT_HIGH_SPEED (((REG32(ADR_CCCR_13H_REG)) & 0x01000000 ) >> 24)
#define GET_BSS (((REG32(ADR_CCCR_13H_REG)) & 0x0e000000 ) >> 25)
#define GET_FBR_100H_REG (((REG32(ADR_FBR_100H_REG)) & 0x0000000f ) >> 0)
#define GET_CSASUPPORT (((REG32(ADR_FBR_100H_REG)) & 0x00000040 ) >> 6)
#define GET_ENABLECSA (((REG32(ADR_FBR_100H_REG)) & 0x00000080 ) >> 7)
#define GET_FBR_101H_REG (((REG32(ADR_FBR_100H_REG)) & 0x0000ff00 ) >> 8)
#define GET_FBR_109H_REG (((REG32(ADR_FBR_109H_REG)) & 0x01ffff00 ) >> 8)
#define GET_F0_CIS_CONTENT_REG_31_0 (((REG32(ADR_F0_CIS_CONTENT_REG_0)) & 0xffffffff ) >> 0)
#define GET_F0_CIS_CONTENT_REG_63_32 (((REG32(ADR_F0_CIS_CONTENT_REG_1)) & 0xffffffff ) >> 0)
#define GET_F0_CIS_CONTENT_REG_95_64 (((REG32(ADR_F0_CIS_CONTENT_REG_2)) & 0xffffffff ) >> 0)
#define GET_F0_CIS_CONTENT_REG_127_96 (((REG32(ADR_F0_CIS_CONTENT_REG_3)) & 0xffffffff ) >> 0)
#define GET_F0_CIS_CONTENT_REG_159_128 (((REG32(ADR_F0_CIS_CONTENT_REG_4)) & 0xffffffff ) >> 0)
#define GET_F0_CIS_CONTENT_REG_191_160 (((REG32(ADR_F0_CIS_CONTENT_REG_5)) & 0xffffffff ) >> 0)
#define GET_F0_CIS_CONTENT_REG_223_192 (((REG32(ADR_F0_CIS_CONTENT_REG_6)) & 0xffffffff ) >> 0)
#define GET_F0_CIS_CONTENT_REG_255_224 (((REG32(ADR_F0_CIS_CONTENT_REG_7)) & 0xffffffff ) >> 0)
#define GET_F0_CIS_CONTENT_REG_287_256 (((REG32(ADR_F0_CIS_CONTENT_REG_8)) & 0xffffffff ) >> 0)
#define GET_F0_CIS_CONTENT_REG_319_288 (((REG32(ADR_F0_CIS_CONTENT_REG_9)) & 0xffffffff ) >> 0)
#define GET_F0_CIS_CONTENT_REG_351_320 (((REG32(ADR_F0_CIS_CONTENT_REG_10)) & 0xffffffff ) >> 0)
#define GET_F0_CIS_CONTENT_REG_383_352 (((REG32(ADR_F0_CIS_CONTENT_REG_11)) & 0xffffffff ) >> 0)
#define GET_F0_CIS_CONTENT_REG_415_384 (((REG32(ADR_F0_CIS_CONTENT_REG_12)) & 0xffffffff ) >> 0)
#define GET_F0_CIS_CONTENT_REG_447_416 (((REG32(ADR_F0_CIS_CONTENT_REG_13)) & 0xffffffff ) >> 0)
#define GET_F0_CIS_CONTENT_REG_479_448 (((REG32(ADR_F0_CIS_CONTENT_REG_14)) & 0xffffffff ) >> 0)
#define GET_F0_CIS_CONTENT_REG_511_480 (((REG32(ADR_F0_CIS_CONTENT_REG_15)) & 0xffffffff ) >> 0)
#define GET_F1_CIS_CONTENT_REG_31_0 (((REG32(ADR_F1_CIS_CONTENT_REG_0)) & 0xffffffff ) >> 0)
#define GET_F1_CIS_CONTENT_REG_63_32 (((REG32(ADR_F1_CIS_CONTENT_REG_1)) & 0xffffffff ) >> 0)
#define GET_F1_CIS_CONTENT_REG_95_64 (((REG32(ADR_F1_CIS_CONTENT_REG_2)) & 0xffffffff ) >> 0)
#define GET_F1_CIS_CONTENT_REG_127_96 (((REG32(ADR_F1_CIS_CONTENT_REG_3)) & 0xffffffff ) >> 0)
#define GET_F1_CIS_CONTENT_REG_159_128 (((REG32(ADR_F1_CIS_CONTENT_REG_4)) & 0xffffffff ) >> 0)
#define GET_F1_CIS_CONTENT_REG_191_160 (((REG32(ADR_F1_CIS_CONTENT_REG_5)) & 0xffffffff ) >> 0)
#define GET_F1_CIS_CONTENT_REG_223_192 (((REG32(ADR_F1_CIS_CONTENT_REG_6)) & 0xffffffff ) >> 0)
#define GET_F1_CIS_CONTENT_REG_255_224 (((REG32(ADR_F1_CIS_CONTENT_REG_7)) & 0xffffffff ) >> 0)
#define GET_F1_CIS_CONTENT_REG_287_256 (((REG32(ADR_F1_CIS_CONTENT_REG_8)) & 0xffffffff ) >> 0)
#define GET_F1_CIS_CONTENT_REG_319_288 (((REG32(ADR_F1_CIS_CONTENT_REG_9)) & 0xffffffff ) >> 0)
#define GET_F1_CIS_CONTENT_REG_351_320 (((REG32(ADR_F1_CIS_CONTENT_REG_10)) & 0xffffffff ) >> 0)
#define GET_F1_CIS_CONTENT_REG_383_352 (((REG32(ADR_F1_CIS_CONTENT_REG_11)) & 0xffffffff ) >> 0)
#define GET_F1_CIS_CONTENT_REG_415_384 (((REG32(ADR_F1_CIS_CONTENT_REG_12)) & 0xffffffff ) >> 0)
#define GET_F1_CIS_CONTENT_REG_447_416 (((REG32(ADR_F1_CIS_CONTENT_REG_13)) & 0xffffffff ) >> 0)
#define GET_F1_CIS_CONTENT_REG_479_448 (((REG32(ADR_F1_CIS_CONTENT_REG_14)) & 0xffffffff ) >> 0)
#define GET_F1_CIS_CONTENT_REG_511_480 (((REG32(ADR_F1_CIS_CONTENT_REG_15)) & 0xffffffff ) >> 0)
#define GET_SPI_MODE (((REG32(ADR_SPI_MODE)) & 0xffffffff ) >> 0)
#define GET_RX_QUOTA (((REG32(ADR_RX_QUOTA)) & 0x0000ffff ) >> 0)
#define GET_CONDI_NUM (((REG32(ADR_CONDITION_NUMBER)) & 0x000000ff ) >> 0)
#define GET_HOST_PATH (((REG32(ADR_HOST_PATH)) & 0x00000001 ) >> 0)
#define GET_TX_SEG (((REG32(ADR_TX_SEG)) & 0xffffffff ) >> 0)
#define GET_BRST_MODE (((REG32(ADR_DEBUG_BURST_MODE)) & 0x00000001 ) >> 0)
#define GET_CLK_WIDTH (((REG32(ADR_SPI_TO_PHY_PARAM1)) & 0x0000ffff ) >> 0)
#define GET_CSN_INTER (((REG32(ADR_SPI_TO_PHY_PARAM1)) & 0xffff0000 ) >> 16)
#define GET_BACK_DLY (((REG32(ADR_SPI_TO_PHY_PARAM2)) & 0x0000ffff ) >> 0)
#define GET_FRONT_DLY (((REG32(ADR_SPI_TO_PHY_PARAM2)) & 0xffff0000 ) >> 16)
#define GET_RX_FIFO_FAIL (((REG32(ADR_SPI_STS)) & 0x00000002 ) >> 1)
#define GET_RX_HOST_FAIL (((REG32(ADR_SPI_STS)) & 0x00000004 ) >> 2)
#define GET_TX_FIFO_FAIL (((REG32(ADR_SPI_STS)) & 0x00000008 ) >> 3)
#define GET_TX_HOST_FAIL (((REG32(ADR_SPI_STS)) & 0x00000010 ) >> 4)
#define GET_SPI_DOUBLE_ALLOC (((REG32(ADR_SPI_STS)) & 0x00000020 ) >> 5)
#define GET_SPI_TX_NO_ALLOC (((REG32(ADR_SPI_STS)) & 0x00000040 ) >> 6)
#define GET_RDATA_RDY (((REG32(ADR_SPI_STS)) & 0x00000080 ) >> 7)
#define GET_SPI_ALLOC_STATUS (((REG32(ADR_SPI_STS)) & 0x00000100 ) >> 8)
#define GET_SPI_DBG_WR_FIFO_FULL (((REG32(ADR_SPI_STS)) & 0x00000200 ) >> 9)
#define GET_RX_LEN (((REG32(ADR_SPI_STS)) & 0xffff0000 ) >> 16)
#define GET_SPI_TX_ALLOC_SIZE_SHIFT_BITS (((REG32(ADR_TX_ALLOC_SET)) & 0x00000007 ) >> 0)
#define GET_SPI_HOST_TX_ALLOC_PKBUF (((REG32(ADR_TX_ALLOC_SET)) & 0x00000100 ) >> 8)
#define GET_SPI_TX_ALLOC_SIZE (((REG32(ADR_TX_ALLOC)) & 0x000000ff ) >> 0)
#define GET_RD_DAT_CNT (((REG32(ADR_DBG_CNT)) & 0x0000ffff ) >> 0)
#define GET_RD_STS_CNT (((REG32(ADR_DBG_CNT)) & 0xffff0000 ) >> 16)
#define GET_JUDGE_CNT (((REG32(ADR_DBG_CNT2)) & 0x0000ffff ) >> 0)
#define GET_RD_STS_CNT_CLR (((REG32(ADR_DBG_CNT2)) & 0x00010000 ) >> 16)
#define GET_RD_DAT_CNT_CLR (((REG32(ADR_DBG_CNT2)) & 0x00020000 ) >> 17)
#define GET_JUDGE_CNT_CLR (((REG32(ADR_DBG_CNT2)) & 0x00040000 ) >> 18)
#define GET_TX_DONE_CNT (((REG32(ADR_DBG_CNT3)) & 0x0000ffff ) >> 0)
#define GET_TX_DISCARD_CNT (((REG32(ADR_DBG_CNT3)) & 0xffff0000 ) >> 16)
#define GET_TX_SET_CNT (((REG32(ADR_DBG_CNT4)) & 0x0000ffff ) >> 0)
#define GET_TX_DISCARD_CNT_CLR (((REG32(ADR_DBG_CNT4)) & 0x00010000 ) >> 16)
#define GET_TX_DONE_CNT_CLR (((REG32(ADR_DBG_CNT4)) & 0x00020000 ) >> 17)
#define GET_TX_SET_CNT_CLR (((REG32(ADR_DBG_CNT4)) & 0x00040000 ) >> 18)
#define GET_DAT_MODE_OFF (((REG32(ADR_DBG_CNT4)) & 0x00080000 ) >> 19)
#define GET_TX_FIFO_RESIDUE (((REG32(ADR_DBG_CNT4)) & 0x00700000 ) >> 20)
#define GET_RX_FIFO_RESIDUE (((REG32(ADR_DBG_CNT4)) & 0x07000000 ) >> 24)
#define GET_RX_RDY (((REG32(ADR_INT_TAG)) & 0x00000001 ) >> 0)
#define GET_SDIO_SYS_INT (((REG32(ADR_INT_TAG)) & 0x00000004 ) >> 2)
#define GET_EDCA0_LOWTHOLD_INT (((REG32(ADR_INT_TAG)) & 0x00000008 ) >> 3)
#define GET_EDCA1_LOWTHOLD_INT (((REG32(ADR_INT_TAG)) & 0x00000010 ) >> 4)
#define GET_EDCA2_LOWTHOLD_INT (((REG32(ADR_INT_TAG)) & 0x00000020 ) >> 5)
#define GET_EDCA3_LOWTHOLD_INT (((REG32(ADR_INT_TAG)) & 0x00000040 ) >> 6)
#define GET_TX_LIMIT_INT_IN (((REG32(ADR_INT_TAG)) & 0x00000080 ) >> 7)
#define GET_SPI_FN1 (((REG32(ADR_INT_TAG)) & 0x00007f00 ) >> 8)
#define GET_SPI_CLK_EN_INT (((REG32(ADR_INT_TAG)) & 0x00008000 ) >> 15)
#define GET_SPI_HOST_MASK (((REG32(ADR_INT_TAG)) & 0x00ff0000 ) >> 16)
#define GET_I2CM_INT_WDONE (((REG32(ADR_I2CM_EN)) & 0x00000001 ) >> 0)
#define GET_I2CM_INT_RDONE (((REG32(ADR_I2CM_EN)) & 0x00000002 ) >> 1)
#define GET_I2CM_IDLE (((REG32(ADR_I2CM_EN)) & 0x00000004 ) >> 2)
#define GET_I2CM_INT_MISMATCH (((REG32(ADR_I2CM_EN)) & 0x00000008 ) >> 3)
#define GET_I2CM_PSCL (((REG32(ADR_I2CM_EN)) & 0x00003ff0 ) >> 4)
#define GET_I2CM_MANUAL_MODE (((REG32(ADR_I2CM_EN)) & 0x00010000 ) >> 16)
#define GET_I2CM_INT_WDATA_NEED (((REG32(ADR_I2CM_EN)) & 0x00020000 ) >> 17)
#define GET_I2CM_INT_RDATA_NEED (((REG32(ADR_I2CM_EN)) & 0x00040000 ) >> 18)
#define GET_I2CM_DEV_A (((REG32(ADR_I2CM_DEV_A)) & 0x000003ff ) >> 0)
#define GET_I2CM_DEV_A10B (((REG32(ADR_I2CM_DEV_A)) & 0x00004000 ) >> 14)
#define GET_I2CM_RX (((REG32(ADR_I2CM_DEV_A)) & 0x00008000 ) >> 15)
#define GET_I2CM_LEN (((REG32(ADR_I2CM_LEN)) & 0x0000ffff ) >> 0)
#define GET_I2CM_T_LEFT (((REG32(ADR_I2CM_LEN)) & 0x00070000 ) >> 16)
#define GET_I2CM_R_GET (((REG32(ADR_I2CM_LEN)) & 0x07000000 ) >> 24)
#define GET_I2CM_WDAT (((REG32(ADR_I2CM_WDAT)) & 0xffffffff ) >> 0)
#define GET_I2CM_RDAT (((REG32(ADR_I2CM_RDAT)) & 0xffffffff ) >> 0)
#define GET_I2CM_SR_LEN (((REG32(ADR_I2CM_EN_2)) & 0x0000ffff ) >> 0)
#define GET_I2CM_SR_RX (((REG32(ADR_I2CM_EN_2)) & 0x00010000 ) >> 16)
#define GET_I2CM_REPEAT_START (((REG32(ADR_I2CM_EN_2)) & 0x00020000 ) >> 17)
#define GET_UART_DATA (((REG32(ADR_UART_DATA)) & 0x000000ff ) >> 0)
#define GET_DATA_RDY_IE (((REG32(ADR_UART_IER)) & 0x00000001 ) >> 0)
#define GET_THR_EMPTY_IE (((REG32(ADR_UART_IER)) & 0x00000002 ) >> 1)
#define GET_RX_LINESTS_IE (((REG32(ADR_UART_IER)) & 0x00000004 ) >> 2)
#define GET_MDM_STS_IE (((REG32(ADR_UART_IER)) & 0x00000008 ) >> 3)
#define GET_DMA_RXEND_IE (((REG32(ADR_UART_IER)) & 0x00000040 ) >> 6)
#define GET_DMA_TXEND_IE (((REG32(ADR_UART_IER)) & 0x00000080 ) >> 7)
#define GET_FIFO_EN (((REG32(ADR_UART_FCR)) & 0x00000001 ) >> 0)
#define GET_RXFIFO_RST (((REG32(ADR_UART_FCR)) & 0x00000002 ) >> 1)
#define GET_TXFIFO_RST (((REG32(ADR_UART_FCR)) & 0x00000004 ) >> 2)
#define GET_DMA_MODE (((REG32(ADR_UART_FCR)) & 0x00000008 ) >> 3)
#define GET_EN_AUTO_RTS (((REG32(ADR_UART_FCR)) & 0x00000010 ) >> 4)
#define GET_EN_AUTO_CTS (((REG32(ADR_UART_FCR)) & 0x00000020 ) >> 5)
#define GET_RXFIFO_TRGLVL (((REG32(ADR_UART_FCR)) & 0x000000c0 ) >> 6)
#define GET_WORD_LEN (((REG32(ADR_UART_LCR)) & 0x00000003 ) >> 0)
#define GET_STOP_BIT (((REG32(ADR_UART_LCR)) & 0x00000004 ) >> 2)
#define GET_PARITY_EN (((REG32(ADR_UART_LCR)) & 0x00000008 ) >> 3)
#define GET_EVEN_PARITY (((REG32(ADR_UART_LCR)) & 0x00000010 ) >> 4)
#define GET_FORCE_PARITY (((REG32(ADR_UART_LCR)) & 0x00000020 ) >> 5)
#define GET_SET_BREAK (((REG32(ADR_UART_LCR)) & 0x00000040 ) >> 6)
#define GET_DLAB (((REG32(ADR_UART_LCR)) & 0x00000080 ) >> 7)
#define GET_DTR (((REG32(ADR_UART_MCR)) & 0x00000001 ) >> 0)
#define GET_RTS (((REG32(ADR_UART_MCR)) & 0x00000002 ) >> 1)
#define GET_OUT_1 (((REG32(ADR_UART_MCR)) & 0x00000004 ) >> 2)
#define GET_OUT_2 (((REG32(ADR_UART_MCR)) & 0x00000008 ) >> 3)
#define GET_LOOP_BACK (((REG32(ADR_UART_MCR)) & 0x00000010 ) >> 4)
#define GET_DATA_RDY (((REG32(ADR_UART_LSR)) & 0x00000001 ) >> 0)
#define GET_OVERRUN_ERR (((REG32(ADR_UART_LSR)) & 0x00000002 ) >> 1)
#define GET_PARITY_ERR (((REG32(ADR_UART_LSR)) & 0x00000004 ) >> 2)
#define GET_FRAMING_ERR (((REG32(ADR_UART_LSR)) & 0x00000008 ) >> 3)
#define GET_BREAK_INT (((REG32(ADR_UART_LSR)) & 0x00000010 ) >> 4)
#define GET_THR_EMPTY (((REG32(ADR_UART_LSR)) & 0x00000020 ) >> 5)
#define GET_TX_EMPTY (((REG32(ADR_UART_LSR)) & 0x00000040 ) >> 6)
#define GET_FIFODATA_ERR (((REG32(ADR_UART_LSR)) & 0x00000080 ) >> 7)
#define GET_DELTA_CTS (((REG32(ADR_UART_MSR)) & 0x00000001 ) >> 0)
#define GET_DELTA_DSR (((REG32(ADR_UART_MSR)) & 0x00000002 ) >> 1)
#define GET_TRAILEDGE_RI (((REG32(ADR_UART_MSR)) & 0x00000004 ) >> 2)
#define GET_DELTA_CD (((REG32(ADR_UART_MSR)) & 0x00000008 ) >> 3)
#define GET_CTS (((REG32(ADR_UART_MSR)) & 0x00000010 ) >> 4)
#define GET_DSR (((REG32(ADR_UART_MSR)) & 0x00000020 ) >> 5)
#define GET_RI (((REG32(ADR_UART_MSR)) & 0x00000040 ) >> 6)
#define GET_CD (((REG32(ADR_UART_MSR)) & 0x00000080 ) >> 7)
#define GET_BRDC_DIV (((REG32(ADR_UART_SPR)) & 0x0000ffff ) >> 0)
#define GET_RTHR_L (((REG32(ADR_UART_RTHR)) & 0x0000000f ) >> 0)
#define GET_RTHR_H (((REG32(ADR_UART_RTHR)) & 0x000000f0 ) >> 4)
#define GET_INT_IDCODE (((REG32(ADR_UART_ISR)) & 0x0000000f ) >> 0)
#define GET_FIFOS_ENABLED (((REG32(ADR_UART_ISR)) & 0x000000c0 ) >> 6)
#define GET_DAT_UART_DATA (((REG32(ADR_DAT_UART_DATA)) & 0x000000ff ) >> 0)
#define GET_DAT_DATA_RDY_IE (((REG32(ADR_DAT_UART_IER)) & 0x00000001 ) >> 0)
#define GET_DAT_THR_EMPTY_IE (((REG32(ADR_DAT_UART_IER)) & 0x00000002 ) >> 1)
#define GET_DAT_RX_LINESTS_IE (((REG32(ADR_DAT_UART_IER)) & 0x00000004 ) >> 2)
#define GET_DAT_MDM_STS_IE (((REG32(ADR_DAT_UART_IER)) & 0x00000008 ) >> 3)
#define GET_DAT_DMA_RXEND_IE (((REG32(ADR_DAT_UART_IER)) & 0x00000040 ) >> 6)
#define GET_DAT_DMA_TXEND_IE (((REG32(ADR_DAT_UART_IER)) & 0x00000080 ) >> 7)
#define GET_DAT_FIFO_EN (((REG32(ADR_DAT_UART_FCR)) & 0x00000001 ) >> 0)
#define GET_DAT_RXFIFO_RST (((REG32(ADR_DAT_UART_FCR)) & 0x00000002 ) >> 1)
#define GET_DAT_TXFIFO_RST (((REG32(ADR_DAT_UART_FCR)) & 0x00000004 ) >> 2)
#define GET_DAT_DMA_MODE (((REG32(ADR_DAT_UART_FCR)) & 0x00000008 ) >> 3)
#define GET_DAT_EN_AUTO_RTS (((REG32(ADR_DAT_UART_FCR)) & 0x00000010 ) >> 4)
#define GET_DAT_EN_AUTO_CTS (((REG32(ADR_DAT_UART_FCR)) & 0x00000020 ) >> 5)
#define GET_DAT_RXFIFO_TRGLVL (((REG32(ADR_DAT_UART_FCR)) & 0x000000c0 ) >> 6)
#define GET_DAT_WORD_LEN (((REG32(ADR_DAT_UART_LCR)) & 0x00000003 ) >> 0)
#define GET_DAT_STOP_BIT (((REG32(ADR_DAT_UART_LCR)) & 0x00000004 ) >> 2)
#define GET_DAT_PARITY_EN (((REG32(ADR_DAT_UART_LCR)) & 0x00000008 ) >> 3)
#define GET_DAT_EVEN_PARITY (((REG32(ADR_DAT_UART_LCR)) & 0x00000010 ) >> 4)
#define GET_DAT_FORCE_PARITY (((REG32(ADR_DAT_UART_LCR)) & 0x00000020 ) >> 5)
#define GET_DAT_SET_BREAK (((REG32(ADR_DAT_UART_LCR)) & 0x00000040 ) >> 6)
#define GET_DAT_DLAB (((REG32(ADR_DAT_UART_LCR)) & 0x00000080 ) >> 7)
#define GET_DAT_DTR (((REG32(ADR_DAT_UART_MCR)) & 0x00000001 ) >> 0)
#define GET_DAT_RTS (((REG32(ADR_DAT_UART_MCR)) & 0x00000002 ) >> 1)
#define GET_DAT_OUT_1 (((REG32(ADR_DAT_UART_MCR)) & 0x00000004 ) >> 2)
#define GET_DAT_OUT_2 (((REG32(ADR_DAT_UART_MCR)) & 0x00000008 ) >> 3)
#define GET_DAT_LOOP_BACK (((REG32(ADR_DAT_UART_MCR)) & 0x00000010 ) >> 4)
#define GET_DAT_DATA_RDY (((REG32(ADR_DAT_UART_LSR)) & 0x00000001 ) >> 0)
#define GET_DAT_OVERRUN_ERR (((REG32(ADR_DAT_UART_LSR)) & 0x00000002 ) >> 1)
#define GET_DAT_PARITY_ERR (((REG32(ADR_DAT_UART_LSR)) & 0x00000004 ) >> 2)
#define GET_DAT_FRAMING_ERR (((REG32(ADR_DAT_UART_LSR)) & 0x00000008 ) >> 3)
#define GET_DAT_BREAK_INT (((REG32(ADR_DAT_UART_LSR)) & 0x00000010 ) >> 4)
#define GET_DAT_THR_EMPTY (((REG32(ADR_DAT_UART_LSR)) & 0x00000020 ) >> 5)
#define GET_DAT_TX_EMPTY (((REG32(ADR_DAT_UART_LSR)) & 0x00000040 ) >> 6)
#define GET_DAT_FIFODATA_ERR (((REG32(ADR_DAT_UART_LSR)) & 0x00000080 ) >> 7)
#define GET_DAT_DELTA_CTS (((REG32(ADR_DAT_UART_MSR)) & 0x00000001 ) >> 0)
#define GET_DAT_DELTA_DSR (((REG32(ADR_DAT_UART_MSR)) & 0x00000002 ) >> 1)
#define GET_DAT_TRAILEDGE_RI (((REG32(ADR_DAT_UART_MSR)) & 0x00000004 ) >> 2)
#define GET_DAT_DELTA_CD (((REG32(ADR_DAT_UART_MSR)) & 0x00000008 ) >> 3)
#define GET_DAT_CTS (((REG32(ADR_DAT_UART_MSR)) & 0x00000010 ) >> 4)
#define GET_DAT_DSR (((REG32(ADR_DAT_UART_MSR)) & 0x00000020 ) >> 5)
#define GET_DAT_RI (((REG32(ADR_DAT_UART_MSR)) & 0x00000040 ) >> 6)
#define GET_DAT_CD (((REG32(ADR_DAT_UART_MSR)) & 0x00000080 ) >> 7)
#define GET_DAT_BRDC_DIV (((REG32(ADR_DAT_UART_SPR)) & 0x0000ffff ) >> 0)
#define GET_DAT_RTHR_L (((REG32(ADR_DAT_UART_RTHR)) & 0x0000000f ) >> 0)
#define GET_DAT_RTHR_H (((REG32(ADR_DAT_UART_RTHR)) & 0x000000f0 ) >> 4)
#define GET_DAT_INT_IDCODE (((REG32(ADR_DAT_UART_ISR)) & 0x0000000f ) >> 0)
#define GET_DAT_FIFOS_ENABLED (((REG32(ADR_DAT_UART_ISR)) & 0x000000c0 ) >> 6)
#define GET_MASK_TOP (((REG32(ADR_INT_MASK)) & 0xffffffff ) >> 0)
#define GET_INT_MODE (((REG32(ADR_INT_MODE)) & 0xffffffff ) >> 0)
#define GET_IRQ_PHY_0 (((REG32(ADR_INT_IRQ_STS)) & 0x00000001 ) >> 0)
#define GET_IRQ_PHY_1 (((REG32(ADR_INT_IRQ_STS)) & 0x00000002 ) >> 1)
#define GET_IRQ_SDIO (((REG32(ADR_INT_IRQ_STS)) & 0x00000004 ) >> 2)
#define GET_IRQ_BEACON_DONE (((REG32(ADR_INT_IRQ_STS)) & 0x00000008 ) >> 3)
#define GET_IRQ_BEACON (((REG32(ADR_INT_IRQ_STS)) & 0x00000010 ) >> 4)
#define GET_IRQ_PRE_BEACON (((REG32(ADR_INT_IRQ_STS)) & 0x00000020 ) >> 5)
#define GET_IRQ_EDCA0_TX_DONE (((REG32(ADR_INT_IRQ_STS)) & 0x00000040 ) >> 6)
#define GET_IRQ_EDCA1_TX_DONE (((REG32(ADR_INT_IRQ_STS)) & 0x00000080 ) >> 7)
#define GET_IRQ_EDCA2_TX_DONE (((REG32(ADR_INT_IRQ_STS)) & 0x00000100 ) >> 8)
#define GET_IRQ_EDCA3_TX_DONE (((REG32(ADR_INT_IRQ_STS)) & 0x00000200 ) >> 9)
#define GET_IRQ_EDCA4_TX_DONE (((REG32(ADR_INT_IRQ_STS)) & 0x00000400 ) >> 10)
#define GET_IRQ_BEACON_DTIM (((REG32(ADR_INT_IRQ_STS)) & 0x00001000 ) >> 12)
#define GET_IRQ_EDCA0_LOWTHOLD_INT (((REG32(ADR_INT_IRQ_STS)) & 0x00002000 ) >> 13)
#define GET_IRQ_EDCA1_LOWTHOLD_INT (((REG32(ADR_INT_IRQ_STS)) & 0x00004000 ) >> 14)
#define GET_IRQ_EDCA2_LOWTHOLD_INT (((REG32(ADR_INT_IRQ_STS)) & 0x00008000 ) >> 15)
#define GET_IRQ_EDCA3_LOWTHOLD_INT (((REG32(ADR_INT_IRQ_STS)) & 0x00010000 ) >> 16)
#define GET_IRQ_FENCE_HIT_INT (((REG32(ADR_INT_IRQ_STS)) & 0x00020000 ) >> 17)
#define GET_IRQ_ILL_ADDR_INT (((REG32(ADR_INT_IRQ_STS)) & 0x00040000 ) >> 18)
#define GET_IRQ_MBOX (((REG32(ADR_INT_IRQ_STS)) & 0x00080000 ) >> 19)
#define GET_IRQ_US_TIMER0 (((REG32(ADR_INT_IRQ_STS)) & 0x00100000 ) >> 20)
#define GET_IRQ_US_TIMER1 (((REG32(ADR_INT_IRQ_STS)) & 0x00200000 ) >> 21)
#define GET_IRQ_US_TIMER2 (((REG32(ADR_INT_IRQ_STS)) & 0x00400000 ) >> 22)
#define GET_IRQ_US_TIMER3 (((REG32(ADR_INT_IRQ_STS)) & 0x00800000 ) >> 23)
#define GET_IRQ_MS_TIMER0 (((REG32(ADR_INT_IRQ_STS)) & 0x01000000 ) >> 24)
#define GET_IRQ_MS_TIMER1 (((REG32(ADR_INT_IRQ_STS)) & 0x02000000 ) >> 25)
#define GET_IRQ_MS_TIMER2 (((REG32(ADR_INT_IRQ_STS)) & 0x04000000 ) >> 26)
#define GET_IRQ_MS_TIMER3 (((REG32(ADR_INT_IRQ_STS)) & 0x08000000 ) >> 27)
#define GET_IRQ_TX_LIMIT_INT (((REG32(ADR_INT_IRQ_STS)) & 0x10000000 ) >> 28)
#define GET_IRQ_DMA0 (((REG32(ADR_INT_IRQ_STS)) & 0x20000000 ) >> 29)
#define GET_IRQ_CO_DMA (((REG32(ADR_INT_IRQ_STS)) & 0x40000000 ) >> 30)
#define GET_IRQ_PERI_GROUP (((REG32(ADR_INT_IRQ_STS)) & 0x80000000 ) >> 31)
#define GET_FIQ_STATUS (((REG32(ADR_INT_FIQ_STS)) & 0xffffffff ) >> 0)
#define GET_IRQ_RAW (((REG32(ADR_INT_IRQ_RAW)) & 0xffffffff ) >> 0)
#define GET_FIQ_RAW (((REG32(ADR_INT_FIQ_RAW)) & 0xffffffff ) >> 0)
#define GET_INT_PERI_MASK (((REG32(ADR_INT_PERI_MASK)) & 0xffffffff ) >> 0)
#define GET_PERI_RTC (((REG32(ADR_INT_PERI_STS)) & 0x00000001 ) >> 0)
#define GET_IRQ_UART0_TX (((REG32(ADR_INT_PERI_STS)) & 0x00000002 ) >> 1)
#define GET_IRQ_UART0_RX (((REG32(ADR_INT_PERI_STS)) & 0x00000004 ) >> 2)
#define GET_PERI_GPI_2 (((REG32(ADR_INT_PERI_STS)) & 0x00000008 ) >> 3)
#define GET_IRQ_SPI_IPC (((REG32(ADR_INT_PERI_STS)) & 0x00000010 ) >> 4)
#define GET_PERI_GPI_1_0 (((REG32(ADR_INT_PERI_STS)) & 0x00000060 ) >> 5)
#define GET_SCRT_INT_1 (((REG32(ADR_INT_PERI_STS)) & 0x00000080 ) >> 7)
#define GET_MMU_ALC_ERR (((REG32(ADR_INT_PERI_STS)) & 0x00000100 ) >> 8)
#define GET_MMU_RLS_ERR (((REG32(ADR_INT_PERI_STS)) & 0x00000200 ) >> 9)
#define GET_ID_MNG_INT_1 (((REG32(ADR_INT_PERI_STS)) & 0x00000400 ) >> 10)
#define GET_MBOX_INT_1 (((REG32(ADR_INT_PERI_STS)) & 0x00000800 ) >> 11)
#define GET_MBOX_INT_2 (((REG32(ADR_INT_PERI_STS)) & 0x00001000 ) >> 12)
#define GET_MBOX_INT_3 (((REG32(ADR_INT_PERI_STS)) & 0x00002000 ) >> 13)
#define GET_HCI_INT_1 (((REG32(ADR_INT_PERI_STS)) & 0x00004000 ) >> 14)
#define GET_UART_RX_TIMEOUT (((REG32(ADR_INT_PERI_STS)) & 0x00008000 ) >> 15)
#define GET_UART_MULTI_IRQ (((REG32(ADR_INT_PERI_STS)) & 0x00010000 ) >> 16)
#define GET_ID_MNG_INT_2 (((REG32(ADR_INT_PERI_STS)) & 0x00020000 ) >> 17)
#define GET_DMN_NOHIT_INT (((REG32(ADR_INT_PERI_STS)) & 0x00040000 ) >> 18)
#define GET_ID_THOLD_RX (((REG32(ADR_INT_PERI_STS)) & 0x00080000 ) >> 19)
#define GET_ID_THOLD_TX (((REG32(ADR_INT_PERI_STS)) & 0x00100000 ) >> 20)
#define GET_ID_DOUBLE_RLS (((REG32(ADR_INT_PERI_STS)) & 0x00200000 ) >> 21)
#define GET_RX_ID_LEN_THOLD (((REG32(ADR_INT_PERI_STS)) & 0x00400000 ) >> 22)
#define GET_TX_ID_LEN_THOLD (((REG32(ADR_INT_PERI_STS)) & 0x00800000 ) >> 23)
#define GET_ALL_ID_LEN_THOLD (((REG32(ADR_INT_PERI_STS)) & 0x01000000 ) >> 24)
#define GET_DMN_MCU_INT (((REG32(ADR_INT_PERI_STS)) & 0x02000000 ) >> 25)
#define GET_IRQ_DAT_UART_TX (((REG32(ADR_INT_PERI_STS)) & 0x04000000 ) >> 26)
#define GET_IRQ_DAT_UART_RX (((REG32(ADR_INT_PERI_STS)) & 0x08000000 ) >> 27)
#define GET_DAT_UART_RX_TIMEOUT (((REG32(ADR_INT_PERI_STS)) & 0x10000000 ) >> 28)
#define GET_DAT_UART_MULTI_IRQ (((REG32(ADR_INT_PERI_STS)) & 0x20000000 ) >> 29)
#define GET_ALR_ABT_NOCHG_INT_IRQ (((REG32(ADR_INT_PERI_STS)) & 0x40000000 ) >> 30)
#define GET_TBLNEQ_MNGPKT_INT_IRQ (((REG32(ADR_INT_PERI_STS)) & 0x80000000 ) >> 31)
#define GET_INTR_PERI_RAW (((REG32(ADR_INT_PERI_RAW)) & 0xffffffff ) >> 0)
#define GET_INTR_GPI00_CFG (((REG32(ADR_INT_GPI_CFG)) & 0x00000003 ) >> 0)
#define GET_INTR_GPI01_CFG (((REG32(ADR_INT_GPI_CFG)) & 0x0000000c ) >> 2)
#define GET_SYS_RST_INT (((REG32(ADR_SYS_INT_FOR_HOST)) & 0x00000001 ) >> 0)
#define GET_SPI_IPC_ADDR (((REG32(ADR_SPI_IPC)) & 0xffffffff ) >> 0)
#define GET_SD_MASK_TOP (((REG32(ADR_SDIO_MASK)) & 0xffffffff ) >> 0)
#define GET_IRQ_PHY_0_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00000001 ) >> 0)
#define GET_IRQ_PHY_1_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00000002 ) >> 1)
#define GET_IRQ_SDIO_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00000004 ) >> 2)
#define GET_IRQ_BEACON_DONE_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00000008 ) >> 3)
#define GET_IRQ_BEACON_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00000010 ) >> 4)
#define GET_IRQ_PRE_BEACON_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00000020 ) >> 5)
#define GET_IRQ_EDCA0_TX_DONE_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00000040 ) >> 6)
#define GET_IRQ_EDCA1_TX_DONE_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00000080 ) >> 7)
#define GET_IRQ_EDCA2_TX_DONE_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00000100 ) >> 8)
#define GET_IRQ_EDCA3_TX_DONE_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00000200 ) >> 9)
#define GET_IRQ_EDCA4_TX_DONE_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00000400 ) >> 10)
#define GET_IRQ_BEACON_DTIM_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00001000 ) >> 12)
#define GET_IRQ_EDCA0_LOWTHOLD_INT_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00002000 ) >> 13)
#define GET_IRQ_EDCA1_LOWTHOLD_INT_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00004000 ) >> 14)
#define GET_IRQ_EDCA2_LOWTHOLD_INT_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00008000 ) >> 15)
#define GET_IRQ_EDCA3_LOWTHOLD_INT_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00010000 ) >> 16)
#define GET_IRQ_FENCE_HIT_INT_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00020000 ) >> 17)
#define GET_IRQ_ILL_ADDR_INT_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00040000 ) >> 18)
#define GET_IRQ_MBOX_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00080000 ) >> 19)
#define GET_IRQ_US_TIMER0_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00100000 ) >> 20)
#define GET_IRQ_US_TIMER1_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00200000 ) >> 21)
#define GET_IRQ_US_TIMER2_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00400000 ) >> 22)
#define GET_IRQ_US_TIMER3_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x00800000 ) >> 23)
#define GET_IRQ_MS_TIMER0_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x01000000 ) >> 24)
#define GET_IRQ_MS_TIMER1_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x02000000 ) >> 25)
#define GET_IRQ_MS_TIMER2_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x04000000 ) >> 26)
#define GET_IRQ_MS_TIMER3_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x08000000 ) >> 27)
#define GET_IRQ_TX_LIMIT_INT_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x10000000 ) >> 28)
#define GET_IRQ_DMA0_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x20000000 ) >> 29)
#define GET_IRQ_CO_DMA_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x40000000 ) >> 30)
#define GET_IRQ_PERI_GROUP_SD (((REG32(ADR_SDIO_IRQ_STS)) & 0x80000000 ) >> 31)
#define GET_INT_PERI_MASK_SD (((REG32(ADR_SD_PERI_MASK)) & 0xffffffff ) >> 0)
#define GET_PERI_RTC_SD (((REG32(ADR_SD_PERI_STS)) & 0x00000001 ) >> 0)
#define GET_IRQ_UART0_TX_SD (((REG32(ADR_SD_PERI_STS)) & 0x00000002 ) >> 1)
#define GET_IRQ_UART0_RX_SD (((REG32(ADR_SD_PERI_STS)) & 0x00000004 ) >> 2)
#define GET_PERI_GPI_SD_2 (((REG32(ADR_SD_PERI_STS)) & 0x00000008 ) >> 3)
#define GET_IRQ_SPI_IPC_SD (((REG32(ADR_SD_PERI_STS)) & 0x00000010 ) >> 4)
#define GET_PERI_GPI_SD_1_0 (((REG32(ADR_SD_PERI_STS)) & 0x00000060 ) >> 5)
#define GET_SCRT_INT_1_SD (((REG32(ADR_SD_PERI_STS)) & 0x00000080 ) >> 7)
#define GET_MMU_ALC_ERR_SD (((REG32(ADR_SD_PERI_STS)) & 0x00000100 ) >> 8)
#define GET_MMU_RLS_ERR_SD (((REG32(ADR_SD_PERI_STS)) & 0x00000200 ) >> 9)
#define GET_ID_MNG_INT_1_SD (((REG32(ADR_SD_PERI_STS)) & 0x00000400 ) >> 10)
#define GET_MBOX_INT_1_SD (((REG32(ADR_SD_PERI_STS)) & 0x00000800 ) >> 11)
#define GET_MBOX_INT_2_SD (((REG32(ADR_SD_PERI_STS)) & 0x00001000 ) >> 12)
#define GET_MBOX_INT_3_SD (((REG32(ADR_SD_PERI_STS)) & 0x00002000 ) >> 13)
#define GET_HCI_INT_1_SD (((REG32(ADR_SD_PERI_STS)) & 0x00004000 ) >> 14)
#define GET_UART_RX_TIMEOUT_SD (((REG32(ADR_SD_PERI_STS)) & 0x00008000 ) >> 15)
#define GET_UART_MULTI_IRQ_SD (((REG32(ADR_SD_PERI_STS)) & 0x00010000 ) >> 16)
#define GET_ID_MNG_INT_2_SD (((REG32(ADR_SD_PERI_STS)) & 0x00020000 ) >> 17)
#define GET_DMN_NOHIT_INT_SD (((REG32(ADR_SD_PERI_STS)) & 0x00040000 ) >> 18)
#define GET_ID_THOLD_RX_SD (((REG32(ADR_SD_PERI_STS)) & 0x00080000 ) >> 19)
#define GET_ID_THOLD_TX_SD (((REG32(ADR_SD_PERI_STS)) & 0x00100000 ) >> 20)
#define GET_ID_DOUBLE_RLS_SD (((REG32(ADR_SD_PERI_STS)) & 0x00200000 ) >> 21)
#define GET_RX_ID_LEN_THOLD_SD (((REG32(ADR_SD_PERI_STS)) & 0x00400000 ) >> 22)
#define GET_TX_ID_LEN_THOLD_SD (((REG32(ADR_SD_PERI_STS)) & 0x00800000 ) >> 23)
#define GET_ALL_ID_LEN_THOLD_SD (((REG32(ADR_SD_PERI_STS)) & 0x01000000 ) >> 24)
#define GET_DMN_MCU_INT_SD (((REG32(ADR_SD_PERI_STS)) & 0x02000000 ) >> 25)
#define GET_IRQ_DAT_UART_TX_SD (((REG32(ADR_SD_PERI_STS)) & 0x04000000 ) >> 26)
#define GET_IRQ_DAT_UART_RX_SD (((REG32(ADR_SD_PERI_STS)) & 0x08000000 ) >> 27)
#define GET_DAT_UART_RX_TIMEOUT_SD (((REG32(ADR_SD_PERI_STS)) & 0x10000000 ) >> 28)
#define GET_DAT_UART_MULTI_IRQ_SD (((REG32(ADR_SD_PERI_STS)) & 0x20000000 ) >> 29)
#define GET_ALR_ABT_NOCHG_INT_IRQ_SD (((REG32(ADR_SD_PERI_STS)) & 0x40000000 ) >> 30)
#define GET_TBLNEQ_MNGPKT_INT_IRQ_SD (((REG32(ADR_SD_PERI_STS)) & 0x80000000 ) >> 31)
#define GET_DBG_SPI_MODE (((REG32(ADR_DBG_SPI_MODE)) & 0xffffffff ) >> 0)
#define GET_DBG_RX_QUOTA (((REG32(ADR_DBG_RX_QUOTA)) & 0x0000ffff ) >> 0)
#define GET_DBG_CONDI_NUM (((REG32(ADR_DBG_CONDITION_NUMBER)) & 0x000000ff ) >> 0)
#define GET_DBG_HOST_PATH (((REG32(ADR_DBG_HOST_PATH)) & 0x00000001 ) >> 0)
#define GET_DBG_TX_SEG (((REG32(ADR_DBG_TX_SEG)) & 0xffffffff ) >> 0)
#define GET_DBG_BRST_MODE (((REG32(ADR_DBG_DEBUG_BURST_MODE)) & 0x00000001 ) >> 0)
#define GET_DBG_CLK_WIDTH (((REG32(ADR_DBG_SPI_TO_PHY_PARAM1)) & 0x0000ffff ) >> 0)
#define GET_DBG_CSN_INTER (((REG32(ADR_DBG_SPI_TO_PHY_PARAM1)) & 0xffff0000 ) >> 16)
#define GET_DBG_BACK_DLY (((REG32(ADR_DBG_SPI_TO_PHY_PARAM2)) & 0x0000ffff ) >> 0)
#define GET_DBG_FRONT_DLY (((REG32(ADR_DBG_SPI_TO_PHY_PARAM2)) & 0xffff0000 ) >> 16)
#define GET_DBG_RX_FIFO_FAIL (((REG32(ADR_DBG_SPI_STS)) & 0x00000002 ) >> 1)
#define GET_DBG_RX_HOST_FAIL (((REG32(ADR_DBG_SPI_STS)) & 0x00000004 ) >> 2)
#define GET_DBG_TX_FIFO_FAIL (((REG32(ADR_DBG_SPI_STS)) & 0x00000008 ) >> 3)
#define GET_DBG_TX_HOST_FAIL (((REG32(ADR_DBG_SPI_STS)) & 0x00000010 ) >> 4)
#define GET_DBG_SPI_DOUBLE_ALLOC (((REG32(ADR_DBG_SPI_STS)) & 0x00000020 ) >> 5)
#define GET_DBG_SPI_TX_NO_ALLOC (((REG32(ADR_DBG_SPI_STS)) & 0x00000040 ) >> 6)
#define GET_DBG_RDATA_RDY (((REG32(ADR_DBG_SPI_STS)) & 0x00000080 ) >> 7)
#define GET_DBG_SPI_ALLOC_STATUS (((REG32(ADR_DBG_SPI_STS)) & 0x00000100 ) >> 8)
#define GET_DBG_SPI_DBG_WR_FIFO_FULL (((REG32(ADR_DBG_SPI_STS)) & 0x00000200 ) >> 9)
#define GET_DBG_RX_LEN (((REG32(ADR_DBG_SPI_STS)) & 0xffff0000 ) >> 16)
#define GET_DBG_SPI_TX_ALLOC_SIZE_SHIFT_BITS (((REG32(ADR_DBG_TX_ALLOC_SET)) & 0x00000007 ) >> 0)
#define GET_DBG_SPI_HOST_TX_ALLOC_PKBUF (((REG32(ADR_DBG_TX_ALLOC_SET)) & 0x00000100 ) >> 8)
#define GET_DBG_SPI_TX_ALLOC_SIZE (((REG32(ADR_DBG_TX_ALLOC)) & 0x000000ff ) >> 0)
#define GET_DBG_RD_DAT_CNT (((REG32(ADR_DBG_DBG_CNT)) & 0x0000ffff ) >> 0)
#define GET_DBG_RD_STS_CNT (((REG32(ADR_DBG_DBG_CNT)) & 0xffff0000 ) >> 16)
#define GET_DBG_JUDGE_CNT (((REG32(ADR_DBG_DBG_CNT2)) & 0x0000ffff ) >> 0)
#define GET_DBG_RD_STS_CNT_CLR (((REG32(ADR_DBG_DBG_CNT2)) & 0x00010000 ) >> 16)
#define GET_DBG_RD_DAT_CNT_CLR (((REG32(ADR_DBG_DBG_CNT2)) & 0x00020000 ) >> 17)
#define GET_DBG_JUDGE_CNT_CLR (((REG32(ADR_DBG_DBG_CNT2)) & 0x00040000 ) >> 18)
#define GET_DBG_TX_DONE_CNT (((REG32(ADR_DBG_DBG_CNT3)) & 0x0000ffff ) >> 0)
#define GET_DBG_TX_DISCARD_CNT (((REG32(ADR_DBG_DBG_CNT3)) & 0xffff0000 ) >> 16)
#define GET_DBG_TX_SET_CNT (((REG32(ADR_DBG_DBG_CNT4)) & 0x0000ffff ) >> 0)
#define GET_DBG_TX_DISCARD_CNT_CLR (((REG32(ADR_DBG_DBG_CNT4)) & 0x00010000 ) >> 16)
#define GET_DBG_TX_DONE_CNT_CLR (((REG32(ADR_DBG_DBG_CNT4)) & 0x00020000 ) >> 17)
#define GET_DBG_TX_SET_CNT_CLR (((REG32(ADR_DBG_DBG_CNT4)) & 0x00040000 ) >> 18)
#define GET_DBG_DAT_MODE_OFF (((REG32(ADR_DBG_DBG_CNT4)) & 0x00080000 ) >> 19)
#define GET_DBG_TX_FIFO_RESIDUE (((REG32(ADR_DBG_DBG_CNT4)) & 0x00700000 ) >> 20)
#define GET_DBG_RX_FIFO_RESIDUE (((REG32(ADR_DBG_DBG_CNT4)) & 0x07000000 ) >> 24)
#define GET_DBG_RX_RDY (((REG32(ADR_DBG_INT_TAG)) & 0x00000001 ) >> 0)
#define GET_DBG_SDIO_SYS_INT (((REG32(ADR_DBG_INT_TAG)) & 0x00000004 ) >> 2)
#define GET_DBG_EDCA0_LOWTHOLD_INT (((REG32(ADR_DBG_INT_TAG)) & 0x00000008 ) >> 3)
#define GET_DBG_EDCA1_LOWTHOLD_INT (((REG32(ADR_DBG_INT_TAG)) & 0x00000010 ) >> 4)
#define GET_DBG_EDCA2_LOWTHOLD_INT (((REG32(ADR_DBG_INT_TAG)) & 0x00000020 ) >> 5)
#define GET_DBG_EDCA3_LOWTHOLD_INT (((REG32(ADR_DBG_INT_TAG)) & 0x00000040 ) >> 6)
#define GET_DBG_TX_LIMIT_INT_IN (((REG32(ADR_DBG_INT_TAG)) & 0x00000080 ) >> 7)
#define GET_DBG_SPI_FN1 (((REG32(ADR_DBG_INT_TAG)) & 0x00007f00 ) >> 8)
#define GET_DBG_SPI_CLK_EN_INT (((REG32(ADR_DBG_INT_TAG)) & 0x00008000 ) >> 15)
#define GET_DBG_SPI_HOST_MASK (((REG32(ADR_DBG_INT_TAG)) & 0x00ff0000 ) >> 16)
#define GET_BOOT_ADDR (((REG32(ADR_BOOT_ADDR)) & 0x00ffffff ) >> 0)
#define GET_CHECK_SUM_FAIL (((REG32(ADR_BOOT_ADDR)) & 0x80000000 ) >> 31)
#define GET_VERIFY_DATA (((REG32(ADR_VERIFY_DATA)) & 0xffffffff ) >> 0)
#define GET_FLASH_ADDR (((REG32(ADR_FLASH_ADDR)) & 0x00ffffff ) >> 0)
#define GET_FLASH_CMD_CLR (((REG32(ADR_FLASH_ADDR)) & 0x10000000 ) >> 28)
#define GET_FLASH_DMA_CLR (((REG32(ADR_FLASH_ADDR)) & 0x20000000 ) >> 29)
#define GET_DMA_EN (((REG32(ADR_FLASH_ADDR)) & 0x40000000 ) >> 30)
#define GET_DMA_BUSY (((REG32(ADR_FLASH_ADDR)) & 0x80000000 ) >> 31)
#define GET_SRAM_ADDR (((REG32(ADR_SRAM_ADDR)) & 0xffffffff ) >> 0)
#define GET_FLASH_DMA_LEN (((REG32(ADR_LEN)) & 0xffffffff ) >> 0)
#define GET_FLASH_FRONT_DLY (((REG32(ADR_SPI_PARAM)) & 0x0000ffff ) >> 0)
#define GET_FLASH_BACK_DLY (((REG32(ADR_SPI_PARAM)) & 0xffff0000 ) >> 16)
#define GET_FLASH_CLK_WIDTH (((REG32(ADR_SPI_PARAM2)) & 0x0000ffff ) >> 0)
#define GET_SPI_BUSY (((REG32(ADR_SPI_PARAM2)) & 0x00010000 ) >> 16)
#define GET_FLS_REMAP (((REG32(ADR_SPI_PARAM2)) & 0x00020000 ) >> 17)
#define GET_PBUS_SWP (((REG32(ADR_SPI_PARAM2)) & 0x00040000 ) >> 18)
#define GET_BIT_MODE1 (((REG32(ADR_SPI_PARAM2)) & 0x00080000 ) >> 19)
#define GET_BIT_MODE2 (((REG32(ADR_SPI_PARAM2)) & 0x00100000 ) >> 20)
#define GET_BIT_MODE4 (((REG32(ADR_SPI_PARAM2)) & 0x00200000 ) >> 21)
#define GET_BOOT_CHECK_SUM (((REG32(ADR_CHECK_SUM_RESULT)) & 0xffffffff ) >> 0)
#define GET_CHECK_SUM_TAG (((REG32(ADR_CHECK_SUM_IN_FILE)) & 0xffffffff ) >> 0)
#define GET_CMD_LEN (((REG32(ADR_COMMAND_LEN)) & 0x0000ffff ) >> 0)
#define GET_CMD_ADDR (((REG32(ADR_COMMAND_ADDR)) & 0xffffffff ) >> 0)
#define GET_DMA_ADR_SRC (((REG32(ADR_DMA_ADR_SRC)) & 0xffffffff ) >> 0)
#define GET_DMA_ADR_DST (((REG32(ADR_DMA_ADR_DST)) & 0xffffffff ) >> 0)
#define GET_DMA_SRC_SIZE (((REG32(ADR_DMA_CTRL)) & 0x00000007 ) >> 0)
#define GET_DMA_SRC_INC (((REG32(ADR_DMA_CTRL)) & 0x00000008 ) >> 3)
#define GET_DMA_DST_SIZE (((REG32(ADR_DMA_CTRL)) & 0x00000070 ) >> 4)
#define GET_DMA_DST_INC (((REG32(ADR_DMA_CTRL)) & 0x00000080 ) >> 7)
#define GET_DMA_FAST_FILL (((REG32(ADR_DMA_CTRL)) & 0x00000100 ) >> 8)
#define GET_DMA_SDIO_KICK (((REG32(ADR_DMA_CTRL)) & 0x00001000 ) >> 12)
#define GET_DMA_BADR_EN (((REG32(ADR_DMA_CTRL)) & 0x00002000 ) >> 13)
#define GET_DMA_LEN (((REG32(ADR_DMA_CTRL)) & 0xffff0000 ) >> 16)
#define GET_DMA_INT_MASK (((REG32(ADR_DMA_INT)) & 0x00000001 ) >> 0)
#define GET_DMA_STS (((REG32(ADR_DMA_INT)) & 0x00000100 ) >> 8)
#define GET_DMA_FINISH (((REG32(ADR_DMA_INT)) & 0x80000000 ) >> 31)
#define GET_DMA_CONST (((REG32(ADR_DMA_FILL_CONST)) & 0xffffffff ) >> 0)
#define GET_SLEEP_WAKE_CNT (((REG32(ADR_PMU_0)) & 0x00ffffff ) >> 0)
#define GET_RG_DLDO_LEVEL (((REG32(ADR_PMU_0)) & 0x07000000 ) >> 24)
#define GET_RG_DLDO_BOOST_IQ (((REG32(ADR_PMU_0)) & 0x08000000 ) >> 27)
#define GET_RG_BUCK_LEVEL (((REG32(ADR_PMU_0)) & 0x70000000 ) >> 28)
#define GET_RG_BUCK_VREF_SEL (((REG32(ADR_PMU_0)) & 0x80000000 ) >> 31)
#define GET_RG_RTC_OSC_RES_SW_MANUAL (((REG32(ADR_PMU_1)) & 0x000003ff ) >> 0)
#define GET_RG_RTC_OSC_RES_SW (((REG32(ADR_PMU_1)) & 0x03ff0000 ) >> 16)
#define GET_RTC_OSC_CAL_RES_RDY (((REG32(ADR_PMU_1)) & 0x80000000 ) >> 31)
#define GET_RG_DCDC_MODE (((REG32(ADR_PMU_2)) & 0x00000001 ) >> 0)
#define GET_RG_BUCK_EN_PSM (((REG32(ADR_PMU_2)) & 0x00000010 ) >> 4)
#define GET_RG_BUCK_PSM_VTH (((REG32(ADR_PMU_2)) & 0x00000100 ) >> 8)
#define GET_RG_RTC_OSC_RES_SW_MANUAL_EN (((REG32(ADR_PMU_2)) & 0x00001000 ) >> 12)
#define GET_RG_RTC_RDY_DEGLITCH_TIMER (((REG32(ADR_PMU_2)) & 0x00006000 ) >> 13)
#define GET_RTC_CAL_ENA (((REG32(ADR_PMU_2)) & 0x00010000 ) >> 16)
#define GET_PMU_WAKE_TRIG_EVENT (((REG32(ADR_PMU_3)) & 0x00000003 ) >> 0)
#define GET_DIGI_TOP_POR_MASK (((REG32(ADR_PMU_3)) & 0x00000010 ) >> 4)
#define GET_PMU_ENTER_SLEEP_MODE (((REG32(ADR_PMU_3)) & 0x00000100 ) >> 8)
#define GET_RG_RTC_DUMMIES (((REG32(ADR_PMU_3)) & 0xffff0000 ) >> 16)
#define GET_RTC_EN (((REG32(ADR_RTC_1)) & 0x00000001 ) >> 0)
#define GET_RTC_SRC (((REG32(ADR_RTC_1)) & 0x00000002 ) >> 1)
#define GET_RTC_TICK_CNT (((REG32(ADR_RTC_1)) & 0x7fff0000 ) >> 16)
#define GET_RTC_INT_SEC_MASK (((REG32(ADR_RTC_2)) & 0x00000001 ) >> 0)
#define GET_RTC_INT_ALARM_MASK (((REG32(ADR_RTC_2)) & 0x00000002 ) >> 1)
#define GET_RTC_INT_SEC (((REG32(ADR_RTC_2)) & 0x00010000 ) >> 16)
#define GET_RTC_INT_ALARM (((REG32(ADR_RTC_2)) & 0x00020000 ) >> 17)
#define GET_RTC_SEC_START_CNT (((REG32(ADR_RTC_3W)) & 0xffffffff ) >> 0)
#define GET_RTC_SEC_CNT (((REG32(ADR_RTC_3R)) & 0xffffffff ) >> 0)
#define GET_RTC_SEC_ALARM_VALUE (((REG32(ADR_RTC_4)) & 0xffffffff ) >> 0)
#define GET_D2_DMA_ADR_SRC (((REG32(ADR_D2_DMA_ADR_SRC)) & 0xffffffff ) >> 0)
#define GET_D2_DMA_ADR_DST (((REG32(ADR_D2_DMA_ADR_DST)) & 0xffffffff ) >> 0)
#define GET_D2_DMA_SRC_SIZE (((REG32(ADR_D2_DMA_CTRL)) & 0x00000007 ) >> 0)
#define GET_D2_DMA_SRC_INC (((REG32(ADR_D2_DMA_CTRL)) & 0x00000008 ) >> 3)
#define GET_D2_DMA_DST_SIZE (((REG32(ADR_D2_DMA_CTRL)) & 0x00000070 ) >> 4)
#define GET_D2_DMA_DST_INC (((REG32(ADR_D2_DMA_CTRL)) & 0x00000080 ) >> 7)
#define GET_D2_DMA_FAST_FILL (((REG32(ADR_D2_DMA_CTRL)) & 0x00000100 ) >> 8)
#define GET_D2_DMA_SDIO_KICK (((REG32(ADR_D2_DMA_CTRL)) & 0x00001000 ) >> 12)
#define GET_D2_DMA_BADR_EN (((REG32(ADR_D2_DMA_CTRL)) & 0x00002000 ) >> 13)
#define GET_D2_DMA_LEN (((REG32(ADR_D2_DMA_CTRL)) & 0xffff0000 ) >> 16)
#define GET_D2_DMA_INT_MASK (((REG32(ADR_D2_DMA_INT)) & 0x00000001 ) >> 0)
#define GET_D2_DMA_STS (((REG32(ADR_D2_DMA_INT)) & 0x00000100 ) >> 8)
#define GET_D2_DMA_FINISH (((REG32(ADR_D2_DMA_INT)) & 0x80000000 ) >> 31)
#define GET_D2_DMA_CONST (((REG32(ADR_D2_DMA_FILL_CONST)) & 0xffffffff ) >> 0)
#define GET_TRAP_UNKNOWN_TYPE (((REG32(ADR_CONTROL)) & 0x00000001 ) >> 0)
#define GET_TX_ON_DEMAND_ENA (((REG32(ADR_CONTROL)) & 0x00000002 ) >> 1)
#define GET_RX_2_HOST (((REG32(ADR_CONTROL)) & 0x00000004 ) >> 2)
#define GET_AUTO_SEQNO (((REG32(ADR_CONTROL)) & 0x00000008 ) >> 3)
#define GET_BYPASSS_TX_PARSER_ENCAP (((REG32(ADR_CONTROL)) & 0x00000010 ) >> 4)
#define GET_HDR_STRIP (((REG32(ADR_CONTROL)) & 0x00000020 ) >> 5)
#define GET_ERP_PROTECT (((REG32(ADR_CONTROL)) & 0x000000c0 ) >> 6)
#define GET_PRO_VER (((REG32(ADR_CONTROL)) & 0x00000300 ) >> 8)
#define GET_TXQ_ID0 (((REG32(ADR_CONTROL)) & 0x00007000 ) >> 12)
#define GET_TXQ_ID1 (((REG32(ADR_CONTROL)) & 0x00070000 ) >> 16)
#define GET_TX_ETHER_TRAP_EN (((REG32(ADR_CONTROL)) & 0x00100000 ) >> 20)
#define GET_RX_ETHER_TRAP_EN (((REG32(ADR_CONTROL)) & 0x00200000 ) >> 21)
#define GET_RX_NULL_TRAP_EN (((REG32(ADR_CONTROL)) & 0x00400000 ) >> 22)
#define GET_RX_GET_TX_QUEUE_EN (((REG32(ADR_CONTROL)) & 0x02000000 ) >> 25)
#define GET_HCI_INQ_SEL (((REG32(ADR_CONTROL)) & 0x04000000 ) >> 26)
#define GET_TRX_DEBUG_CNT_ENA (((REG32(ADR_CONTROL)) & 0x10000000 ) >> 28)
#define GET_WAKE_SOON_WITH_SCK (((REG32(ADR_SDIO_WAKE_MODE)) & 0x00000001 ) >> 0)
#define GET_TX_FLOW_CTRL (((REG32(ADR_TX_FLOW_0)) & 0x0000ffff ) >> 0)
#define GET_TX_FLOW_MGMT (((REG32(ADR_TX_FLOW_0)) & 0xffff0000 ) >> 16)
#define GET_TX_FLOW_DATA (((REG32(ADR_TX_FLOW_1)) & 0xffffffff ) >> 0)
#define GET_DOT11RTSTHRESHOLD (((REG32(ADR_THREASHOLD)) & 0xffff0000 ) >> 16)
#define GET_TXF_ID (((REG32(ADR_TXFID_INCREASE)) & 0x0000003f ) >> 0)
#define GET_SEQ_CTRL (((REG32(ADR_GLOBAL_SEQUENCE)) & 0x0000ffff ) >> 0)
#define GET_TX_PBOFFSET (((REG32(ADR_HCI_TX_RX_INFO_SIZE)) & 0x000000ff ) >> 0)
#define GET_TX_INFO_SIZE (((REG32(ADR_HCI_TX_RX_INFO_SIZE)) & 0x0000ff00 ) >> 8)
#define GET_RX_INFO_SIZE (((REG32(ADR_HCI_TX_RX_INFO_SIZE)) & 0x00ff0000 ) >> 16)
#define GET_RX_LAST_PHY_SIZE (((REG32(ADR_HCI_TX_RX_INFO_SIZE)) & 0xff000000 ) >> 24)
#define GET_TX_INFO_CLEAR_SIZE (((REG32(ADR_HCI_TX_INFO_CLEAR)) & 0x0000003f ) >> 0)
#define GET_TX_INFO_CLEAR_ENABLE (((REG32(ADR_HCI_TX_INFO_CLEAR)) & 0x00000100 ) >> 8)
#define GET_TXTRAP_ETHTYPE1 (((REG32(ADR_TX_ETHER_TYPE_1)) & 0x0000ffff ) >> 0)
#define GET_TXTRAP_ETHTYPE0 (((REG32(ADR_TX_ETHER_TYPE_1)) & 0xffff0000 ) >> 16)
#define GET_RXTRAP_ETHTYPE1 (((REG32(ADR_RX_ETHER_TYPE_1)) & 0x0000ffff ) >> 0)
#define GET_RXTRAP_ETHTYPE0 (((REG32(ADR_RX_ETHER_TYPE_1)) & 0xffff0000 ) >> 16)
#define GET_TX_PKT_COUNTER (((REG32(ADR_PACKET_COUNTER_INFO_0)) & 0xffffffff ) >> 0)
#define GET_RX_PKT_COUNTER (((REG32(ADR_PACKET_COUNTER_INFO_1)) & 0xffffffff ) >> 0)
#define GET_HOST_CMD_COUNTER (((REG32(ADR_PACKET_COUNTER_INFO_2)) & 0x000000ff ) >> 0)
#define GET_HOST_EVENT_COUNTER (((REG32(ADR_PACKET_COUNTER_INFO_3)) & 0x000000ff ) >> 0)
#define GET_TX_PKT_DROP_COUNTER (((REG32(ADR_PACKET_COUNTER_INFO_4)) & 0x000000ff ) >> 0)
#define GET_RX_PKT_DROP_COUNTER (((REG32(ADR_PACKET_COUNTER_INFO_5)) & 0x000000ff ) >> 0)
#define GET_TX_PKT_TRAP_COUNTER (((REG32(ADR_PACKET_COUNTER_INFO_6)) & 0x000000ff ) >> 0)
#define GET_RX_PKT_TRAP_COUNTER (((REG32(ADR_PACKET_COUNTER_INFO_7)) & 0x000000ff ) >> 0)
#define GET_HOST_TX_FAIL_COUNTER (((REG32(ADR_SDIO_TX_RX_FAIL_COUNTER_0)) & 0x000000ff ) >> 0)
#define GET_HOST_RX_FAIL_COUNTER (((REG32(ADR_SDIO_TX_RX_FAIL_COUNTER_1)) & 0x000000ff ) >> 0)
#define GET_HCI_STATE_MONITOR (((REG32(ADR_HCI_STATE_DEBUG_MODE_0)) & 0xffffffff ) >> 0)
#define GET_HCI_ST_TIMEOUT_MONITOR (((REG32(ADR_HCI_STATE_DEBUG_MODE_1)) & 0xffffffff ) >> 0)
#define GET_TX_ON_DEMAND_LENGTH (((REG32(ADR_HCI_STATE_DEBUG_MODE_2)) & 0xffffffff ) >> 0)
#define GET_HCI_MONITOR_REG1 (((REG32(ADR_HCI_STATE_DEBUG_MODE_3)) & 0xffffffff ) >> 0)
#define GET_HCI_MONITOR_REG2 (((REG32(ADR_HCI_STATE_DEBUG_MODE_4)) & 0xffffffff ) >> 0)
#define GET_HCI_TX_ALLOC_TIME_31_0 (((REG32(ADR_HCI_STATE_DEBUG_MODE_5)) & 0xffffffff ) >> 0)
#define GET_HCI_TX_ALLOC_TIME_47_32 (((REG32(ADR_HCI_STATE_DEBUG_MODE_6)) & 0x0000ffff ) >> 0)
#define GET_HCI_MB_MAX_CNT (((REG32(ADR_HCI_STATE_DEBUG_MODE_6)) & 0x00ff0000 ) >> 16)
#define GET_HCI_TX_ALLOC_CNT_31_0 (((REG32(ADR_HCI_STATE_DEBUG_MODE_7)) & 0xffffffff ) >> 0)
#define GET_HCI_TX_ALLOC_CNT_47_32 (((REG32(ADR_HCI_STATE_DEBUG_MODE_8)) & 0x0000ffff ) >> 0)
#define GET_HCI_PROC_CNT (((REG32(ADR_HCI_STATE_DEBUG_MODE_8)) & 0x00ff0000 ) >> 16)
#define GET_SDIO_TRANS_CNT (((REG32(ADR_HCI_STATE_DEBUG_MODE_8)) & 0xff000000 ) >> 24)
#define GET_SDIO_TX_INVALID_CNT_31_0 (((REG32(ADR_HCI_STATE_DEBUG_MODE_9)) & 0xffffffff ) >> 0)
#define GET_SDIO_TX_INVALID_CNT_47_32 (((REG32(ADR_HCI_STATE_DEBUG_MODE_10)) & 0x0000ffff ) >> 0)
#define GET_CS_START_ADDR (((REG32(ADR_CS_START_ADDR)) & 0x0000ffff ) >> 0)
#define GET_CS_PKT_ID (((REG32(ADR_CS_START_ADDR)) & 0x007f0000 ) >> 16)
#define GET_ADD_LEN (((REG32(ADR_CS_ADD_LEN)) & 0x0000ffff ) >> 0)
#define GET_CS_ADDER_EN (((REG32(ADR_CS_CMD)) & 0x00000001 ) >> 0)
#define GET_PSEUDO (((REG32(ADR_CS_CMD)) & 0x00000002 ) >> 1)
#define GET_CALCULATE (((REG32(ADR_CS_INI_BUF)) & 0xffffffff ) >> 0)
#define GET_L4_LEN (((REG32(ADR_CS_PSEUDO_BUF)) & 0x0000ffff ) >> 0)
#define GET_L4_PROTOL (((REG32(ADR_CS_PSEUDO_BUF)) & 0x00ff0000 ) >> 16)
#define GET_CHECK_SUM (((REG32(ADR_CS_CHECK_SUM)) & 0x0000ffff ) >> 0)
#define GET_RAND_EN (((REG32(ADR_RAND_EN)) & 0x00000001 ) >> 0)
#define GET_RAND_NUM (((REG32(ADR_RAND_NUM)) & 0xffffffff ) >> 0)
#define GET_MUL_OP1 (((REG32(ADR_MUL_OP1)) & 0xffffffff ) >> 0)
#define GET_MUL_OP2 (((REG32(ADR_MUL_OP2)) & 0xffffffff ) >> 0)
#define GET_MUL_ANS0 (((REG32(ADR_MUL_ANS0)) & 0xffffffff ) >> 0)
#define GET_MUL_ANS1 (((REG32(ADR_MUL_ANS1)) & 0xffffffff ) >> 0)
#define GET_RD_ADDR (((REG32(ADR_DMA_RDATA)) & 0x0000ffff ) >> 0)
#define GET_RD_ID (((REG32(ADR_DMA_RDATA)) & 0x007f0000 ) >> 16)
#define GET_WR_ADDR (((REG32(ADR_DMA_WDATA)) & 0x0000ffff ) >> 0)
#define GET_WR_ID (((REG32(ADR_DMA_WDATA)) & 0x007f0000 ) >> 16)
#define GET_LEN (((REG32(ADR_DMA_LEN)) & 0x0000ffff ) >> 0)
#define GET_CLR (((REG32(ADR_DMA_CLR)) & 0x00000001 ) >> 0)
#define GET_PHY_MODE (((REG32(ADR_NAV_DATA)) & 0x00000003 ) >> 0)
#define GET_SHRT_PREAM (((REG32(ADR_NAV_DATA)) & 0x00000004 ) >> 2)
#define GET_SHRT_GI (((REG32(ADR_NAV_DATA)) & 0x00000008 ) >> 3)
#define GET_DATA_RATE (((REG32(ADR_NAV_DATA)) & 0x000007f0 ) >> 4)
#define GET_MCS (((REG32(ADR_NAV_DATA)) & 0x00007000 ) >> 12)
#define GET_FRAME_LEN (((REG32(ADR_NAV_DATA)) & 0xffff0000 ) >> 16)
#define GET_DURATION (((REG32(ADR_CO_NAV)) & 0x0000ffff ) >> 0)
#define GET_SHA_DST_ADDR (((REG32(ADR_SHA_DST_ADDR)) & 0xffffffff ) >> 0)
#define GET_SHA_SRC_ADDR (((REG32(ADR_SHA_SRC_ADDR)) & 0xffffffff ) >> 0)
#define GET_SHA_BUSY (((REG32(ADR_SHA_SETTING)) & 0x00000001 ) >> 0)
#define GET_SHA_ENDIAN (((REG32(ADR_SHA_SETTING)) & 0x00000002 ) >> 1)
#define GET_EFS_CLKFREQ (((REG32(ADR_EFUSE_CLK_FREQ)) & 0x00000fff ) >> 0)
#define GET_LOW_ACTIVE (((REG32(ADR_EFUSE_CLK_FREQ)) & 0x00010000 ) >> 16)
#define GET_EFS_CLKFREQ_RD (((REG32(ADR_EFUSE_CLK_FREQ)) & 0x0ff00000 ) >> 20)
#define GET_EFS_PRE_RD (((REG32(ADR_EFUSE_CLK_FREQ)) & 0xf0000000 ) >> 28)
#define GET_EFS_LDO_ON (((REG32(ADR_EFUSE_LDO_TIME)) & 0x0000ffff ) >> 0)
#define GET_EFS_LDO_OFF (((REG32(ADR_EFUSE_LDO_TIME)) & 0xffff0000 ) >> 16)
#define GET_EFS_RDATA_0 (((REG32(ADR_EFUSE_AHB_RDATA_0)) & 0xffffffff ) >> 0)
#define GET_EFS_WDATA_0 (((REG32(ADR_EFUSE_WDATA_0)) & 0xffffffff ) >> 0)
#define GET_EFS_RDATA_1 (((REG32(ADR_EFUSE_AHB_RDATA_1)) & 0xffffffff ) >> 0)
#define GET_EFS_WDATA_1 (((REG32(ADR_EFUSE_WDATA_1)) & 0xffffffff ) >> 0)
#define GET_EFS_RDATA_2 (((REG32(ADR_EFUSE_AHB_RDATA_2)) & 0xffffffff ) >> 0)
#define GET_EFS_WDATA_2 (((REG32(ADR_EFUSE_WDATA_2)) & 0xffffffff ) >> 0)
#define GET_EFS_RDATA_3 (((REG32(ADR_EFUSE_AHB_RDATA_3)) & 0xffffffff ) >> 0)
#define GET_EFS_WDATA_3 (((REG32(ADR_EFUSE_WDATA_3)) & 0xffffffff ) >> 0)
#define GET_EFS_RDATA_4 (((REG32(ADR_EFUSE_AHB_RDATA_4)) & 0xffffffff ) >> 0)
#define GET_EFS_WDATA_4 (((REG32(ADR_EFUSE_WDATA_4)) & 0xffffffff ) >> 0)
#define GET_EFS_RDATA_5 (((REG32(ADR_EFUSE_AHB_RDATA_5)) & 0xffffffff ) >> 0)
#define GET_EFS_WDATA_5 (((REG32(ADR_EFUSE_WDATA_5)) & 0xffffffff ) >> 0)
#define GET_EFS_RDATA_6 (((REG32(ADR_EFUSE_AHB_RDATA_6)) & 0xffffffff ) >> 0)
#define GET_EFS_WDATA_6 (((REG32(ADR_EFUSE_WDATA_6)) & 0xffffffff ) >> 0)
#define GET_EFS_RDATA_7 (((REG32(ADR_EFUSE_AHB_RDATA_7)) & 0xffffffff ) >> 0)
#define GET_EFS_WDATA_7 (((REG32(ADR_EFUSE_WDATA_7)) & 0xffffffff ) >> 0)
#define GET_EFS_SPI_RD0_EN (((REG32(ADR_EFUSE_SPI_RD0_EN)) & 0x00000001 ) >> 0)
#define GET_EFS_SPI_RD1_EN (((REG32(ADR_EFUSE_SPI_RD1_EN)) & 0x00000001 ) >> 0)
#define GET_EFS_SPI_RD2_EN (((REG32(ADR_EFUSE_SPI_RD2_EN)) & 0x00000001 ) >> 0)
#define GET_EFS_SPI_RD3_EN (((REG32(ADR_EFUSE_SPI_RD3_EN)) & 0x00000001 ) >> 0)
#define GET_EFS_SPI_RD4_EN (((REG32(ADR_EFUSE_SPI_RD4_EN)) & 0x00000001 ) >> 0)
#define GET_EFS_SPI_RD5_EN (((REG32(ADR_EFUSE_SPI_RD5_EN)) & 0x00000001 ) >> 0)
#define GET_EFS_SPI_RD6_EN (((REG32(ADR_EFUSE_SPI_RD6_EN)) & 0x00000001 ) >> 0)
#define GET_EFS_SPI_RD7_EN (((REG32(ADR_EFUSE_SPI_RD7_EN)) & 0x00000001 ) >> 0)
#define GET_EFS_SPI_RBUSY (((REG32(ADR_EFUSE_SPI_BUSY)) & 0x00000001 ) >> 0)
#define GET_EFS_SPI_RDATA_0 (((REG32(ADR_EFUSE_SPI_RDATA_0)) & 0xffffffff ) >> 0)
#define GET_EFS_SPI_RDATA_1 (((REG32(ADR_EFUSE_SPI_RDATA_1)) & 0xffffffff ) >> 0)
#define GET_EFS_SPI_RDATA_2 (((REG32(ADR_EFUSE_SPI_RDATA_2)) & 0xffffffff ) >> 0)
#define GET_EFS_SPI_RDATA_3 (((REG32(ADR_EFUSE_SPI_RDATA_3)) & 0xffffffff ) >> 0)
#define GET_EFS_SPI_RDATA_4 (((REG32(ADR_EFUSE_SPI_RDATA_4)) & 0xffffffff ) >> 0)
#define GET_EFS_SPI_RDATA_5 (((REG32(ADR_EFUSE_SPI_RDATA_5)) & 0xffffffff ) >> 0)
#define GET_EFS_SPI_RDATA_6 (((REG32(ADR_EFUSE_SPI_RDATA_6)) & 0xffffffff ) >> 0)
#define GET_EFS_SPI_RDATA_7 (((REG32(ADR_EFUSE_SPI_RDATA_7)) & 0xffffffff ) >> 0)
#define GET_GET_RK (((REG32(ADR_SMS4_CFG1)) & 0x00000001 ) >> 0)
#define GET_FORCE_GET_RK (((REG32(ADR_SMS4_CFG1)) & 0x00000002 ) >> 1)
#define GET_SMS4_DESCRY_EN (((REG32(ADR_SMS4_CFG1)) & 0x00000010 ) >> 4)
#define GET_DEC_DOUT_MSB (((REG32(ADR_SMS4_CFG2)) & 0x00000001 ) >> 0)
#define GET_DEC_DIN_MSB (((REG32(ADR_SMS4_CFG2)) & 0x00000002 ) >> 1)
#define GET_ENC_DOUT_MSB (((REG32(ADR_SMS4_CFG2)) & 0x00000004 ) >> 2)
#define GET_ENC_DIN_MSB (((REG32(ADR_SMS4_CFG2)) & 0x00000008 ) >> 3)
#define GET_KEY_DIN_MSB (((REG32(ADR_SMS4_CFG2)) & 0x00000010 ) >> 4)
#define GET_SMS4_CBC_EN (((REG32(ADR_SMS4_MODE1)) & 0x00000001 ) >> 0)
#define GET_SMS4_CFB_EN (((REG32(ADR_SMS4_MODE1)) & 0x00000002 ) >> 1)
#define GET_SMS4_OFB_EN (((REG32(ADR_SMS4_MODE1)) & 0x00000004 ) >> 2)
#define GET_SMS4_START_TRIG (((REG32(ADR_SMS4_TRIG)) & 0x00000001 ) >> 0)
#define GET_SMS4_BUSY (((REG32(ADR_SMS4_STATUS1)) & 0x00000001 ) >> 0)
#define GET_SMS4_DONE (((REG32(ADR_SMS4_STATUS2)) & 0x00000001 ) >> 0)
#define GET_SMS4_DATAIN_0 (((REG32(ADR_SMS4_DATA_IN0)) & 0xffffffff ) >> 0)
#define GET_SMS4_DATAIN_1 (((REG32(ADR_SMS4_DATA_IN1)) & 0xffffffff ) >> 0)
#define GET_SMS4_DATAIN_2 (((REG32(ADR_SMS4_DATA_IN2)) & 0xffffffff ) >> 0)
#define GET_SMS4_DATAIN_3 (((REG32(ADR_SMS4_DATA_IN3)) & 0xffffffff ) >> 0)
#define GET_SMS4_DATAOUT_0 (((REG32(ADR_SMS4_DATA_OUT0)) & 0xffffffff ) >> 0)
#define GET_SMS4_DATAOUT_1 (((REG32(ADR_SMS4_DATA_OUT1)) & 0xffffffff ) >> 0)
#define GET_SMS4_DATAOUT_2 (((REG32(ADR_SMS4_DATA_OUT2)) & 0xffffffff ) >> 0)
#define GET_SMS4_DATAOUT_3 (((REG32(ADR_SMS4_DATA_OUT3)) & 0xffffffff ) >> 0)
#define GET_SMS4_KEY_0 (((REG32(ADR_SMS4_KEY_0)) & 0xffffffff ) >> 0)
#define GET_SMS4_KEY_1 (((REG32(ADR_SMS4_KEY_1)) & 0xffffffff ) >> 0)
#define GET_SMS4_KEY_2 (((REG32(ADR_SMS4_KEY_2)) & 0xffffffff ) >> 0)
#define GET_SMS4_KEY_3 (((REG32(ADR_SMS4_KEY_3)) & 0xffffffff ) >> 0)
#define GET_SMS4_MODE_IV0 (((REG32(ADR_SMS4_MODE_IV0)) & 0xffffffff ) >> 0)
#define GET_SMS4_MODE_IV1 (((REG32(ADR_SMS4_MODE_IV1)) & 0xffffffff ) >> 0)
#define GET_SMS4_MODE_IV2 (((REG32(ADR_SMS4_MODE_IV2)) & 0xffffffff ) >> 0)
#define GET_SMS4_MODE_IV3 (((REG32(ADR_SMS4_MODE_IV3)) & 0xffffffff ) >> 0)
#define GET_SMS4_OFB_ENC0 (((REG32(ADR_SMS4_OFB_ENC0)) & 0xffffffff ) >> 0)
#define GET_SMS4_OFB_ENC1 (((REG32(ADR_SMS4_OFB_ENC1)) & 0xffffffff ) >> 0)
#define GET_SMS4_OFB_ENC2 (((REG32(ADR_SMS4_OFB_ENC2)) & 0xffffffff ) >> 0)
#define GET_SMS4_OFB_ENC3 (((REG32(ADR_SMS4_OFB_ENC3)) & 0xffffffff ) >> 0)
#define GET_MRX_MCAST_TB0_31_0 (((REG32(ADR_MRX_MCAST_TB0_0)) & 0xffffffff ) >> 0)
#define GET_MRX_MCAST_TB0_47_32 (((REG32(ADR_MRX_MCAST_TB0_1)) & 0x0000ffff ) >> 0)
#define GET_MRX_MCAST_MASK0_31_0 (((REG32(ADR_MRX_MCAST_MK0_0)) & 0xffffffff ) >> 0)
#define GET_MRX_MCAST_MASK0_47_32 (((REG32(ADR_MRX_MCAST_MK0_1)) & 0x0000ffff ) >> 0)
#define GET_MRX_MCAST_CTRL_0 (((REG32(ADR_MRX_MCAST_CTRL0)) & 0x00000003 ) >> 0)
#define GET_MRX_MCAST_TB1_31_0 (((REG32(ADR_MRX_MCAST_TB1_0)) & 0xffffffff ) >> 0)
#define GET_MRX_MCAST_TB1_47_32 (((REG32(ADR_MRX_MCAST_TB1_1)) & 0x0000ffff ) >> 0)
#define GET_MRX_MCAST_MASK1_31_0 (((REG32(ADR_MRX_MCAST_MK1_0)) & 0xffffffff ) >> 0)
#define GET_MRX_MCAST_MASK1_47_32 (((REG32(ADR_MRX_MCAST_MK1_1)) & 0x0000ffff ) >> 0)
#define GET_MRX_MCAST_CTRL_1 (((REG32(ADR_MRX_MCAST_CTRL1)) & 0x00000003 ) >> 0)
#define GET_MRX_MCAST_TB2_31_0 (((REG32(ADR_MRX_MCAST_TB2_0)) & 0xffffffff ) >> 0)
#define GET_MRX_MCAST_TB2_47_32 (((REG32(ADR_MRX_MCAST_TB2_1)) & 0x0000ffff ) >> 0)
#define GET_MRX_MCAST_MASK2_31_0 (((REG32(ADR_MRX_MCAST_MK2_0)) & 0xffffffff ) >> 0)
#define GET_MRX_MCAST_MASK2_47_32 (((REG32(ADR_MRX_MCAST_MK2_1)) & 0x0000ffff ) >> 0)
#define GET_MRX_MCAST_CTRL_2 (((REG32(ADR_MRX_MCAST_CTRL2)) & 0x00000003 ) >> 0)
#define GET_MRX_MCAST_TB3_31_0 (((REG32(ADR_MRX_MCAST_TB3_0)) & 0xffffffff ) >> 0)
#define GET_MRX_MCAST_TB3_47_32 (((REG32(ADR_MRX_MCAST_TB3_1)) & 0x0000ffff ) >> 0)
#define GET_MRX_MCAST_MASK3_31_0 (((REG32(ADR_MRX_MCAST_MK3_0)) & 0xffffffff ) >> 0)
#define GET_MRX_MCAST_MASK3_47_32 (((REG32(ADR_MRX_MCAST_MK3_1)) & 0x0000ffff ) >> 0)
#define GET_MRX_MCAST_CTRL_3 (((REG32(ADR_MRX_MCAST_CTRL3)) & 0x00000003 ) >> 0)
#define GET_MRX_PHY_INFO (((REG32(ADR_MRX_PHY_INFO)) & 0xffffffff ) >> 0)
#define GET_DBG_BA_TYPE (((REG32(ADR_MRX_BA_DBG)) & 0x0000003f ) >> 0)
#define GET_DBG_BA_SEQ (((REG32(ADR_MRX_BA_DBG)) & 0x000fff00 ) >> 8)
#define GET_MRX_FLT_TB0 (((REG32(ADR_MRX_FLT_TB0)) & 0x00007fff ) >> 0)
#define GET_MRX_FLT_TB1 (((REG32(ADR_MRX_FLT_TB1)) & 0x00007fff ) >> 0)
#define GET_MRX_FLT_TB2 (((REG32(ADR_MRX_FLT_TB2)) & 0x00007fff ) >> 0)
#define GET_MRX_FLT_TB3 (((REG32(ADR_MRX_FLT_TB3)) & 0x00007fff ) >> 0)
#define GET_MRX_FLT_TB4 (((REG32(ADR_MRX_FLT_TB4)) & 0x00007fff ) >> 0)
#define GET_MRX_FLT_TB5 (((REG32(ADR_MRX_FLT_TB5)) & 0x00007fff ) >> 0)
#define GET_MRX_FLT_TB6 (((REG32(ADR_MRX_FLT_TB6)) & 0x00007fff ) >> 0)
#define GET_MRX_FLT_TB7 (((REG32(ADR_MRX_FLT_TB7)) & 0x00007fff ) >> 0)
#define GET_MRX_FLT_TB8 (((REG32(ADR_MRX_FLT_TB8)) & 0x00007fff ) >> 0)
#define GET_MRX_FLT_TB9 (((REG32(ADR_MRX_FLT_TB9)) & 0x00007fff ) >> 0)
#define GET_MRX_FLT_TB10 (((REG32(ADR_MRX_FLT_TB10)) & 0x00007fff ) >> 0)
#define GET_MRX_FLT_TB11 (((REG32(ADR_MRX_FLT_TB11)) & 0x00007fff ) >> 0)
#define GET_MRX_FLT_TB12 (((REG32(ADR_MRX_FLT_TB12)) & 0x00007fff ) >> 0)
#define GET_MRX_FLT_TB13 (((REG32(ADR_MRX_FLT_TB13)) & 0x00007fff ) >> 0)
#define GET_MRX_FLT_TB14 (((REG32(ADR_MRX_FLT_TB14)) & 0x00007fff ) >> 0)
#define GET_MRX_FLT_TB15 (((REG32(ADR_MRX_FLT_TB15)) & 0x00007fff ) >> 0)
#define GET_MRX_FLT_EN0 (((REG32(ADR_MRX_FLT_EN0)) & 0x0000ffff ) >> 0)
#define GET_MRX_FLT_EN1 (((REG32(ADR_MRX_FLT_EN1)) & 0x0000ffff ) >> 0)
#define GET_MRX_FLT_EN2 (((REG32(ADR_MRX_FLT_EN2)) & 0x0000ffff ) >> 0)
#define GET_MRX_FLT_EN3 (((REG32(ADR_MRX_FLT_EN3)) & 0x0000ffff ) >> 0)
#define GET_MRX_FLT_EN4 (((REG32(ADR_MRX_FLT_EN4)) & 0x0000ffff ) >> 0)
#define GET_MRX_FLT_EN5 (((REG32(ADR_MRX_FLT_EN5)) & 0x0000ffff ) >> 0)
#define GET_MRX_FLT_EN6 (((REG32(ADR_MRX_FLT_EN6)) & 0x0000ffff ) >> 0)
#define GET_MRX_FLT_EN7 (((REG32(ADR_MRX_FLT_EN7)) & 0x0000ffff ) >> 0)
#define GET_MRX_FLT_EN8 (((REG32(ADR_MRX_FLT_EN8)) & 0x0000ffff ) >> 0)
#define GET_MRX_LEN_FLT (((REG32(ADR_MRX_LEN_FLT)) & 0x0000ffff ) >> 0)
#define GET_RX_FLOW_DATA (((REG32(ADR_RX_FLOW_DATA)) & 0xffffffff ) >> 0)
#define GET_RX_FLOW_MNG (((REG32(ADR_RX_FLOW_MNG)) & 0x0000ffff ) >> 0)
#define GET_RX_FLOW_CTRL (((REG32(ADR_RX_FLOW_CTRL)) & 0x0000ffff ) >> 0)
#define GET_MRX_STP_EN (((REG32(ADR_RX_TIME_STAMP_CFG)) & 0x00000001 ) >> 0)
#define GET_MRX_STP_OFST (((REG32(ADR_RX_TIME_STAMP_CFG)) & 0x0000ff00 ) >> 8)
#define GET_DBG_FF_FULL (((REG32(ADR_DBG_FF_FULL)) & 0x0000ffff ) >> 0)
#define GET_DBG_FF_FULL_CLR (((REG32(ADR_DBG_FF_FULL)) & 0x80000000 ) >> 31)
#define GET_DBG_WFF_FULL (((REG32(ADR_DBG_WFF_FULL)) & 0x0000ffff ) >> 0)
#define GET_DBG_WFF_FULL_CLR (((REG32(ADR_DBG_WFF_FULL)) & 0x80000000 ) >> 31)
#define GET_DBG_MB_FULL (((REG32(ADR_DBG_MB_FULL)) & 0x0000ffff ) >> 0)
#define GET_DBG_MB_FULL_CLR (((REG32(ADR_DBG_MB_FULL)) & 0x80000000 ) >> 31)
#define GET_BA_CTRL (((REG32(ADR_BA_CTRL)) & 0x00000003 ) >> 0)
#define GET_BA_DBG_EN (((REG32(ADR_BA_CTRL)) & 0x00000004 ) >> 2)
#define GET_BA_AGRE_EN (((REG32(ADR_BA_CTRL)) & 0x00000008 ) >> 3)
#define GET_BA_TA_31_0 (((REG32(ADR_BA_TA_0)) & 0xffffffff ) >> 0)
#define GET_BA_TA_47_32 (((REG32(ADR_BA_TA_1)) & 0x0000ffff ) >> 0)
#define GET_BA_TID (((REG32(ADR_BA_TID)) & 0x0000000f ) >> 0)
#define GET_BA_ST_SEQ (((REG32(ADR_BA_ST_SEQ)) & 0x00000fff ) >> 0)
#define GET_BA_SB0 (((REG32(ADR_BA_SB0)) & 0xffffffff ) >> 0)
#define GET_BA_SB1 (((REG32(ADR_BA_SB1)) & 0xffffffff ) >> 0)
#define GET_MRX_WD (((REG32(ADR_MRX_WATCH_DOG)) & 0x0001ffff ) >> 0)
#define GET_ACK_GEN_EN (((REG32(ADR_ACK_GEN_EN)) & 0x00000001 ) >> 0)
#define GET_BA_GEN_EN (((REG32(ADR_ACK_GEN_EN)) & 0x00000002 ) >> 1)
#define GET_ACK_GEN_DUR (((REG32(ADR_ACK_GEN_PARA)) & 0x0000ffff ) >> 0)
#define GET_ACK_GEN_INFO (((REG32(ADR_ACK_GEN_PARA)) & 0x003f0000 ) >> 16)
#define GET_ACK_GEN_RA_31_0 (((REG32(ADR_ACK_GEN_RA_0)) & 0xffffffff ) >> 0)
#define GET_ACK_GEN_RA_47_32 (((REG32(ADR_ACK_GEN_RA_1)) & 0x0000ffff ) >> 0)
#define GET_MIB_LEN_FAIL (((REG32(ADR_MIB_LEN_FAIL)) & 0x0000ffff ) >> 0)
#define GET_TRAP_HW_ID (((REG32(ADR_TRAP_HW_ID)) & 0x0000000f ) >> 0)
#define GET_ID_IN_USE (((REG32(ADR_ID_IN_USE)) & 0x000000ff ) >> 0)
#define GET_MRX_ERR (((REG32(ADR_MRX_ERR)) & 0xffffffff ) >> 0)
#define GET_W0_T0_SEQ (((REG32(ADR_WSID0_TID0_RX_SEQ)) & 0x0000ffff ) >> 0)
#define GET_W0_T1_SEQ (((REG32(ADR_WSID0_TID1_RX_SEQ)) & 0x0000ffff ) >> 0)
#define GET_W0_T2_SEQ (((REG32(ADR_WSID0_TID2_RX_SEQ)) & 0x0000ffff ) >> 0)
#define GET_W0_T3_SEQ (((REG32(ADR_WSID0_TID3_RX_SEQ)) & 0x0000ffff ) >> 0)
#define GET_W0_T4_SEQ (((REG32(ADR_WSID0_TID4_RX_SEQ)) & 0x0000ffff ) >> 0)
#define GET_W0_T5_SEQ (((REG32(ADR_WSID0_TID5_RX_SEQ)) & 0x0000ffff ) >> 0)
#define GET_W0_T6_SEQ (((REG32(ADR_WSID0_TID6_RX_SEQ)) & 0x0000ffff ) >> 0)
#define GET_W0_T7_SEQ (((REG32(ADR_WSID0_TID7_RX_SEQ)) & 0x0000ffff ) >> 0)
#define GET_W1_T0_SEQ (((REG32(ADR_WSID1_TID0_RX_SEQ)) & 0x0000ffff ) >> 0)
#define GET_W1_T1_SEQ (((REG32(ADR_WSID1_TID1_RX_SEQ)) & 0x0000ffff ) >> 0)
#define GET_W1_T2_SEQ (((REG32(ADR_WSID1_TID2_RX_SEQ)) & 0x0000ffff ) >> 0)
#define GET_W1_T3_SEQ (((REG32(ADR_WSID1_TID3_RX_SEQ)) & 0x0000ffff ) >> 0)
#define GET_W1_T4_SEQ (((REG32(ADR_WSID1_TID4_RX_SEQ)) & 0x0000ffff ) >> 0)
#define GET_W1_T5_SEQ (((REG32(ADR_WSID1_TID5_RX_SEQ)) & 0x0000ffff ) >> 0)
#define GET_W1_T6_SEQ (((REG32(ADR_WSID1_TID6_RX_SEQ)) & 0x0000ffff ) >> 0)
#define GET_W1_T7_SEQ (((REG32(ADR_WSID1_TID7_RX_SEQ)) & 0x0000ffff ) >> 0)
#define GET_ADDR1A_SEL (((REG32(ADR_HDR_ADDR_SEL)) & 0x00000003 ) >> 0)
#define GET_ADDR2A_SEL (((REG32(ADR_HDR_ADDR_SEL)) & 0x0000000c ) >> 2)
#define GET_ADDR3A_SEL (((REG32(ADR_HDR_ADDR_SEL)) & 0x00000030 ) >> 4)
#define GET_ADDR1B_SEL (((REG32(ADR_HDR_ADDR_SEL)) & 0x000000c0 ) >> 6)
#define GET_ADDR2B_SEL (((REG32(ADR_HDR_ADDR_SEL)) & 0x00000300 ) >> 8)
#define GET_ADDR3B_SEL (((REG32(ADR_HDR_ADDR_SEL)) & 0x00000c00 ) >> 10)
#define GET_ADDR3C_SEL (((REG32(ADR_HDR_ADDR_SEL)) & 0x00003000 ) >> 12)
#define GET_FRM_CTRL (((REG32(ADR_FRAME_TYPE_CNTR_SET)) & 0x0000003f ) >> 0)
#define GET_CSR_PHY_INFO (((REG32(ADR_PHY_INFO)) & 0x00007fff ) >> 0)
#define GET_AMPDU_SIG (((REG32(ADR_AMPDU_SIG)) & 0x000000ff ) >> 0)
#define GET_MIB_AMPDU (((REG32(ADR_MIB_AMPDU)) & 0xffffffff ) >> 0)
#define GET_LEN_FLT (((REG32(ADR_LEN_FLT)) & 0x0000ffff ) >> 0)
#define GET_MIB_DELIMITER (((REG32(ADR_MIB_DELIMITER)) & 0x0000ffff ) >> 0)
#define GET_MTX_INT_Q0_Q_EMPTY (((REG32(ADR_MTX_INT_STS)) & 0x00010000 ) >> 16)
#define GET_MTX_INT_Q0_TXOP_RUNOUT (((REG32(ADR_MTX_INT_STS)) & 0x00020000 ) >> 17)
#define GET_MTX_INT_Q1_Q_EMPTY (((REG32(ADR_MTX_INT_STS)) & 0x00040000 ) >> 18)
#define GET_MTX_INT_Q1_TXOP_RUNOUT (((REG32(ADR_MTX_INT_STS)) & 0x00080000 ) >> 19)
#define GET_MTX_INT_Q2_Q_EMPTY (((REG32(ADR_MTX_INT_STS)) & 0x00100000 ) >> 20)
#define GET_MTX_INT_Q2_TXOP_RUNOUT (((REG32(ADR_MTX_INT_STS)) & 0x00200000 ) >> 21)
#define GET_MTX_INT_Q3_Q_EMPTY (((REG32(ADR_MTX_INT_STS)) & 0x00400000 ) >> 22)
#define GET_MTX_INT_Q3_TXOP_RUNOUT (((REG32(ADR_MTX_INT_STS)) & 0x00800000 ) >> 23)
#define GET_MTX_INT_Q4_Q_EMPTY (((REG32(ADR_MTX_INT_STS)) & 0x01000000 ) >> 24)
#define GET_MTX_INT_Q4_TXOP_RUNOUT (((REG32(ADR_MTX_INT_STS)) & 0x02000000 ) >> 25)
#define GET_MTX_EN_INT_Q0_Q_EMPTY (((REG32(ADR_MTX_INT_EN)) & 0x00010000 ) >> 16)
#define GET_MTX_EN_INT_Q0_TXOP_RUNOUT (((REG32(ADR_MTX_INT_EN)) & 0x00020000 ) >> 17)
#define GET_MTX_EN_INT_Q1_Q_EMPTY (((REG32(ADR_MTX_INT_EN)) & 0x00040000 ) >> 18)
#define GET_MTX_EN_INT_Q1_TXOP_RUNOUT (((REG32(ADR_MTX_INT_EN)) & 0x00080000 ) >> 19)
#define GET_MTX_EN_INT_Q2_Q_EMPTY (((REG32(ADR_MTX_INT_EN)) & 0x00100000 ) >> 20)
#define GET_MTX_EN_INT_Q2_TXOP_RUNOUT (((REG32(ADR_MTX_INT_EN)) & 0x00200000 ) >> 21)
#define GET_MTX_EN_INT_Q3_Q_EMPTY (((REG32(ADR_MTX_INT_EN)) & 0x00400000 ) >> 22)
#define GET_MTX_EN_INT_Q3_TXOP_RUNOUT (((REG32(ADR_MTX_INT_EN)) & 0x00800000 ) >> 23)
#define GET_MTX_EN_INT_Q4_Q_EMPTY (((REG32(ADR_MTX_INT_EN)) & 0x01000000 ) >> 24)
#define GET_MTX_EN_INT_Q4_TXOP_RUNOUT (((REG32(ADR_MTX_INT_EN)) & 0x02000000 ) >> 25)
#define GET_MTX_MTX2PHY_SLOW (((REG32(ADR_MTX_MISC_EN)) & 0x00000001 ) >> 0)
#define GET_MTX_M2M_SLOW_PRD (((REG32(ADR_MTX_MISC_EN)) & 0x0000000e ) >> 1)
#define GET_MTX_AMPDU_CRC_AUTO (((REG32(ADR_MTX_MISC_EN)) & 0x00000020 ) >> 5)
#define GET_MTX_FAST_RSP_MODE (((REG32(ADR_MTX_MISC_EN)) & 0x00000040 ) >> 6)
#define GET_MTX_RAW_DATA_MODE (((REG32(ADR_MTX_MISC_EN)) & 0x00000080 ) >> 7)
#define GET_MTX_ACK_DUR0 (((REG32(ADR_MTX_MISC_EN)) & 0x00000100 ) >> 8)
#define GET_MTX_TSF_AUTO_BCN (((REG32(ADR_MTX_MISC_EN)) & 0x00000400 ) >> 10)
#define GET_MTX_TSF_AUTO_MISC (((REG32(ADR_MTX_MISC_EN)) & 0x00000800 ) >> 11)
#define GET_MTX_FORCE_CS_IDLE (((REG32(ADR_MTX_MISC_EN)) & 0x00001000 ) >> 12)
#define GET_MTX_FORCE_BKF_RXEN0 (((REG32(ADR_MTX_MISC_EN)) & 0x00002000 ) >> 13)
#define GET_MTX_FORCE_DMA_RXEN0 (((REG32(ADR_MTX_MISC_EN)) & 0x00004000 ) >> 14)
#define GET_MTX_FORCE_RXEN0 (((REG32(ADR_MTX_MISC_EN)) & 0x00008000 ) >> 15)
#define GET_MTX_HALT_Q_MB (((REG32(ADR_MTX_MISC_EN)) & 0x003f0000 ) >> 16)
#define GET_MTX_CTS_SET_DIF (((REG32(ADR_MTX_MISC_EN)) & 0x00400000 ) >> 22)
#define GET_MTX_AMPDU_SET_DIF (((REG32(ADR_MTX_MISC_EN)) & 0x00800000 ) >> 23)
#define GET_MTX_EDCCA_TOUT (((REG32(ADR_MTX_EDCCA_TOUT)) & 0x000003ff ) >> 0)
#define GET_MTX_INT_BCN (((REG32(ADR_MTX_BCN_INT_STS)) & 0x00000002 ) >> 1)
#define GET_MTX_INT_DTIM (((REG32(ADR_MTX_BCN_INT_STS)) & 0x00000008 ) >> 3)
#define GET_MTX_EN_INT_BCN (((REG32(ADR_MTX_BCN_EN_INT)) & 0x00000002 ) >> 1)
#define GET_MTX_EN_INT_DTIM (((REG32(ADR_MTX_BCN_EN_INT)) & 0x00000008 ) >> 3)
#define GET_MTX_BCN_TIMER_EN (((REG32(ADR_MTX_BCN_EN_MISC)) & 0x00000001 ) >> 0)
#define GET_MTX_TIME_STAMP_AUTO_FILL (((REG32(ADR_MTX_BCN_EN_MISC)) & 0x00000002 ) >> 1)
#define GET_MTX_TSF_TIMER_EN (((REG32(ADR_MTX_BCN_EN_MISC)) & 0x00000020 ) >> 5)
#define GET_MTX_HALT_MNG_UNTIL_DTIM (((REG32(ADR_MTX_BCN_EN_MISC)) & 0x00000040 ) >> 6)
#define GET_MTX_INT_DTIM_NUM (((REG32(ADR_MTX_BCN_EN_MISC)) & 0x0000ff00 ) >> 8)
#define GET_MTX_AUTO_FLUSH_Q4 (((REG32(ADR_MTX_BCN_EN_MISC)) & 0x00010000 ) >> 16)
#define GET_MTX_BCN_PKTID_CH_LOCK (((REG32(ADR_MTX_BCN_MISC)) & 0x00000001 ) >> 0)
#define GET_MTX_BCN_CFG_VLD (((REG32(ADR_MTX_BCN_MISC)) & 0x00000006 ) >> 1)
#define GET_MTX_AUTO_BCN_ONGOING (((REG32(ADR_MTX_BCN_MISC)) & 0x00000008 ) >> 3)
#define GET_MTX_BCN_TIMER (((REG32(ADR_MTX_BCN_MISC)) & 0xffff0000 ) >> 16)
#define GET_MTX_BCN_PERIOD (((REG32(ADR_MTX_BCN_PRD)) & 0x0000ffff ) >> 0)
#define GET_MTX_DTIM_NUM (((REG32(ADR_MTX_BCN_PRD)) & 0xff000000 ) >> 24)
#define GET_MTX_BCN_TSF_L (((REG32(ADR_MTX_BCN_TSF_L)) & 0xffffffff ) >> 0)
#define GET_MTX_BCN_TSF_U (((REG32(ADR_MTX_BCN_TSF_U)) & 0xffffffff ) >> 0)
#define GET_MTX_BCN_PKT_ID0 (((REG32(ADR_MTX_BCN_CFG0)) & 0x0000007f ) >> 0)
#define GET_MTX_DTIM_OFST0 (((REG32(ADR_MTX_BCN_CFG0)) & 0x03ff0000 ) >> 16)
#define GET_MTX_BCN_PKT_ID1 (((REG32(ADR_MTX_BCN_CFG1)) & 0x0000007f ) >> 0)
#define GET_MTX_DTIM_OFST1 (((REG32(ADR_MTX_BCN_CFG1)) & 0x03ff0000 ) >> 16)
#define GET_MTX_CCA (((REG32(ADR_MTX_STATUS)) & 0x00000001 ) >> 0)
#define GET_MRX_CCA (((REG32(ADR_MTX_STATUS)) & 0x00000002 ) >> 1)
#define GET_MTX_DMA_FSM (((REG32(ADR_MTX_STATUS)) & 0x0000001c ) >> 2)
#define GET_CH_ST_FSM (((REG32(ADR_MTX_STATUS)) & 0x000000e0 ) >> 5)
#define GET_MTX_GNT_LOCK (((REG32(ADR_MTX_STATUS)) & 0x00000100 ) >> 8)
#define GET_MTX_DMA_REQ (((REG32(ADR_MTX_STATUS)) & 0x00000200 ) >> 9)
#define GET_MTX_Q_REQ (((REG32(ADR_MTX_STATUS)) & 0x00000400 ) >> 10)
#define GET_MTX_TX_EN (((REG32(ADR_MTX_STATUS)) & 0x00000800 ) >> 11)
#define GET_MRX_RX_EN (((REG32(ADR_MTX_STATUS)) & 0x00001000 ) >> 12)
#define GET_DBG_PRTC_PRD (((REG32(ADR_MTX_STATUS)) & 0x00002000 ) >> 13)
#define GET_DBG_DMA_RDY (((REG32(ADR_MTX_STATUS)) & 0x00004000 ) >> 14)
#define GET_DBG_WAIT_RSP (((REG32(ADR_MTX_STATUS)) & 0x00008000 ) >> 15)
#define GET_DBG_CFRM_BUSY (((REG32(ADR_MTX_STATUS)) & 0x00010000 ) >> 16)
#define GET_DBG_RST (((REG32(ADR_MTX_DBG_CTRL)) & 0x00000001 ) >> 0)
#define GET_DBG_MODE (((REG32(ADR_MTX_DBG_CTRL)) & 0x00000002 ) >> 1)
#define GET_MB_REQ_DUR (((REG32(ADR_MTX_DBG_DAT0)) & 0x0000ffff ) >> 0)
#define GET_RX_EN_DUR (((REG32(ADR_MTX_DBG_DAT0)) & 0xffff0000 ) >> 16)
#define GET_RX_CS_DUR (((REG32(ADR_MTX_DBG_DAT1)) & 0x0000ffff ) >> 0)
#define GET_TX_CCA_DUR (((REG32(ADR_MTX_DBG_DAT1)) & 0xffff0000 ) >> 16)
#define GET_Q_REQ_DUR (((REG32(ADR_MTX_DBG_DAT2)) & 0x0000ffff ) >> 0)
#define GET_CH_STA0_DUR (((REG32(ADR_MTX_DBG_DAT2)) & 0xffff0000 ) >> 16)
#define GET_MTX_DUR_RSP_TOUT_B (((REG32(ADR_MTX_DUR_TOUT)) & 0x000000ff ) >> 0)
#define GET_MTX_DUR_RSP_TOUT_G (((REG32(ADR_MTX_DUR_TOUT)) & 0x0000ff00 ) >> 8)
#define GET_MTX_DUR_RSP_SIFS (((REG32(ADR_MTX_DUR_IFS)) & 0x000000ff ) >> 0)
#define GET_MTX_DUR_BURST_SIFS (((REG32(ADR_MTX_DUR_IFS)) & 0x0000ff00 ) >> 8)
#define GET_MTX_DUR_SLOT (((REG32(ADR_MTX_DUR_IFS)) & 0x003f0000 ) >> 16)
#define GET_MTX_DUR_RSP_EIFS (((REG32(ADR_MTX_DUR_IFS)) & 0xffc00000 ) >> 22)
#define GET_MTX_DUR_RSP_SIFS_G (((REG32(ADR_MTX_DUR_SIFS_G)) & 0x000000ff ) >> 0)
#define GET_MTX_DUR_BURST_SIFS_G (((REG32(ADR_MTX_DUR_SIFS_G)) & 0x0000ff00 ) >> 8)
#define GET_MTX_DUR_SLOT_G (((REG32(ADR_MTX_DUR_SIFS_G)) & 0x003f0000 ) >> 16)
#define GET_MTX_DUR_RSP_EIFS_G (((REG32(ADR_MTX_DUR_SIFS_G)) & 0xffc00000 ) >> 22)
#define GET_CH_STA1_DUR (((REG32(ADR_MTX_DBG_DAT3)) & 0x0000ffff ) >> 0)
#define GET_CH_STA2_DUR (((REG32(ADR_MTX_DBG_DAT3)) & 0xffff0000 ) >> 16)
#define GET_MTX_NAV (((REG32(ADR_MTX_NAV)) & 0x0000ffff ) >> 0)
#define GET_MTX_MIB_CNT0 (((REG32(ADR_MTX_MIB_WSID0)) & 0x3fffffff ) >> 0)
#define GET_MTX_MIB_EN0 (((REG32(ADR_MTX_MIB_WSID0)) & 0x40000000 ) >> 30)
#define GET_MTX_MIB_CNT1 (((REG32(ADR_MTX_MIB_WSID1)) & 0x3fffffff ) >> 0)
#define GET_MTX_MIB_EN1 (((REG32(ADR_MTX_MIB_WSID1)) & 0x40000000 ) >> 30)
#define GET_CH_STA3_DUR (((REG32(ADR_MTX_DBG_DAT4)) & 0x0000ffff ) >> 0)
#define GET_CH_STA4_DUR (((REG32(ADR_MTX_DBG_DAT4)) & 0xffff0000 ) >> 16)
#define GET_TXQ0_MTX_Q_PRE_LD (((REG32(ADR_TXQ0_MTX_Q_MISC_EN)) & 0x00000002 ) >> 1)
#define GET_TXQ0_MTX_Q_BKF_CNT_FIXED (((REG32(ADR_TXQ0_MTX_Q_MISC_EN)) & 0x00000004 ) >> 2)
#define GET_TXQ0_MTX_Q_TXOP_SUB_FRM_TIME (((REG32(ADR_TXQ0_MTX_Q_MISC_EN)) & 0x00000008 ) >> 3)
#define GET_TXQ0_MTX_Q_MB_NO_RLS (((REG32(ADR_TXQ0_MTX_Q_MISC_EN)) & 0x00000010 ) >> 4)
#define GET_TXQ0_MTX_Q_TXOP_FRC_BUR (((REG32(ADR_TXQ0_MTX_Q_MISC_EN)) & 0x00000020 ) >> 5)
#define GET_TXQ0_MTX_Q_RND_MODE (((REG32(ADR_TXQ0_MTX_Q_MISC_EN)) & 0x000000c0 ) >> 6)
#define GET_TXQ0_MTX_Q_AIFSN (((REG32(ADR_TXQ0_MTX_Q_AIFSN)) & 0x0000000f ) >> 0)
#define GET_TXQ0_MTX_Q_ECWMIN (((REG32(ADR_TXQ0_MTX_Q_AIFSN)) & 0x00000f00 ) >> 8)
#define GET_TXQ0_MTX_Q_ECWMAX (((REG32(ADR_TXQ0_MTX_Q_AIFSN)) & 0x0000f000 ) >> 12)
#define GET_TXQ0_MTX_Q_TXOP_LIMIT (((REG32(ADR_TXQ0_MTX_Q_AIFSN)) & 0xffff0000 ) >> 16)
#define GET_TXQ0_MTX_Q_BKF_CNT (((REG32(ADR_TXQ0_MTX_Q_BKF_CNT)) & 0x0000ffff ) >> 0)
#define GET_TXQ0_MTX_Q_SRC_LIMIT (((REG32(ADR_TXQ0_MTX_Q_RC_LIMIT)) & 0x000000ff ) >> 0)
#define GET_TXQ0_MTX_Q_LRC_LIMIT (((REG32(ADR_TXQ0_MTX_Q_RC_LIMIT)) & 0x0000ff00 ) >> 8)
#define GET_TXQ0_MTX_Q_ID_MAP_L (((REG32(ADR_TXQ0_MTX_Q_ID_MAP_L)) & 0xffffffff ) >> 0)
#define GET_TXQ0_MTX_Q_TXOP_CH_THD (((REG32(ADR_TXQ0_MTX_Q_TXOP_CH_THD)) & 0x0000ffff ) >> 0)
#define GET_TXQ0_MTX_Q_TXOP_OV_THD (((REG32(ADR_TXQ0_MTX_Q_TXOP_OV_THD)) & 0x0000ffff ) >> 0)
#define GET_TXQ1_MTX_Q_PRE_LD (((REG32(ADR_TXQ1_MTX_Q_MISC_EN)) & 0x00000002 ) >> 1)
#define GET_TXQ1_MTX_Q_BKF_CNT_FIXED (((REG32(ADR_TXQ1_MTX_Q_MISC_EN)) & 0x00000004 ) >> 2)
#define GET_TXQ1_MTX_Q_TXOP_SUB_FRM_TIME (((REG32(ADR_TXQ1_MTX_Q_MISC_EN)) & 0x00000008 ) >> 3)
#define GET_TXQ1_MTX_Q_MB_NO_RLS (((REG32(ADR_TXQ1_MTX_Q_MISC_EN)) & 0x00000010 ) >> 4)
#define GET_TXQ1_MTX_Q_TXOP_FRC_BUR (((REG32(ADR_TXQ1_MTX_Q_MISC_EN)) & 0x00000020 ) >> 5)
#define GET_TXQ1_MTX_Q_RND_MODE (((REG32(ADR_TXQ1_MTX_Q_MISC_EN)) & 0x000000c0 ) >> 6)
#define GET_TXQ1_MTX_Q_AIFSN (((REG32(ADR_TXQ1_MTX_Q_AIFSN)) & 0x0000000f ) >> 0)
#define GET_TXQ1_MTX_Q_ECWMIN (((REG32(ADR_TXQ1_MTX_Q_AIFSN)) & 0x00000f00 ) >> 8)
#define GET_TXQ1_MTX_Q_ECWMAX (((REG32(ADR_TXQ1_MTX_Q_AIFSN)) & 0x0000f000 ) >> 12)
#define GET_TXQ1_MTX_Q_TXOP_LIMIT (((REG32(ADR_TXQ1_MTX_Q_AIFSN)) & 0xffff0000 ) >> 16)
#define GET_TXQ1_MTX_Q_BKF_CNT (((REG32(ADR_TXQ1_MTX_Q_BKF_CNT)) & 0x0000ffff ) >> 0)
#define GET_TXQ1_MTX_Q_SRC_LIMIT (((REG32(ADR_TXQ1_MTX_Q_RC_LIMIT)) & 0x000000ff ) >> 0)
#define GET_TXQ1_MTX_Q_LRC_LIMIT (((REG32(ADR_TXQ1_MTX_Q_RC_LIMIT)) & 0x0000ff00 ) >> 8)
#define GET_TXQ1_MTX_Q_ID_MAP_L (((REG32(ADR_TXQ1_MTX_Q_ID_MAP_L)) & 0xffffffff ) >> 0)
#define GET_TXQ1_MTX_Q_TXOP_CH_THD (((REG32(ADR_TXQ1_MTX_Q_TXOP_CH_THD)) & 0x0000ffff ) >> 0)
#define GET_TXQ1_MTX_Q_TXOP_OV_THD (((REG32(ADR_TXQ1_MTX_Q_TXOP_OV_THD)) & 0x0000ffff ) >> 0)
#define GET_TXQ2_MTX_Q_PRE_LD (((REG32(ADR_TXQ2_MTX_Q_MISC_EN)) & 0x00000002 ) >> 1)
#define GET_TXQ2_MTX_Q_BKF_CNT_FIXED (((REG32(ADR_TXQ2_MTX_Q_MISC_EN)) & 0x00000004 ) >> 2)
#define GET_TXQ2_MTX_Q_TXOP_SUB_FRM_TIME (((REG32(ADR_TXQ2_MTX_Q_MISC_EN)) & 0x00000008 ) >> 3)
#define GET_TXQ2_MTX_Q_MB_NO_RLS (((REG32(ADR_TXQ2_MTX_Q_MISC_EN)) & 0x00000010 ) >> 4)
#define GET_TXQ2_MTX_Q_TXOP_FRC_BUR (((REG32(ADR_TXQ2_MTX_Q_MISC_EN)) & 0x00000020 ) >> 5)
#define GET_TXQ2_MTX_Q_RND_MODE (((REG32(ADR_TXQ2_MTX_Q_MISC_EN)) & 0x000000c0 ) >> 6)
#define GET_TXQ2_MTX_Q_AIFSN (((REG32(ADR_TXQ2_MTX_Q_AIFSN)) & 0x0000000f ) >> 0)
#define GET_TXQ2_MTX_Q_ECWMIN (((REG32(ADR_TXQ2_MTX_Q_AIFSN)) & 0x00000f00 ) >> 8)
#define GET_TXQ2_MTX_Q_ECWMAX (((REG32(ADR_TXQ2_MTX_Q_AIFSN)) & 0x0000f000 ) >> 12)
#define GET_TXQ2_MTX_Q_TXOP_LIMIT (((REG32(ADR_TXQ2_MTX_Q_AIFSN)) & 0xffff0000 ) >> 16)
#define GET_TXQ2_MTX_Q_BKF_CNT (((REG32(ADR_TXQ2_MTX_Q_BKF_CNT)) & 0x0000ffff ) >> 0)
#define GET_TXQ2_MTX_Q_SRC_LIMIT (((REG32(ADR_TXQ2_MTX_Q_RC_LIMIT)) & 0x000000ff ) >> 0)
#define GET_TXQ2_MTX_Q_LRC_LIMIT (((REG32(ADR_TXQ2_MTX_Q_RC_LIMIT)) & 0x0000ff00 ) >> 8)
#define GET_TXQ2_MTX_Q_ID_MAP_L (((REG32(ADR_TXQ2_MTX_Q_ID_MAP_L)) & 0xffffffff ) >> 0)
#define GET_TXQ2_MTX_Q_TXOP_CH_THD (((REG32(ADR_TXQ2_MTX_Q_TXOP_CH_THD)) & 0x0000ffff ) >> 0)
#define GET_TXQ2_MTX_Q_TXOP_OV_THD (((REG32(ADR_TXQ2_MTX_Q_TXOP_OV_THD)) & 0x0000ffff ) >> 0)
#define GET_TXQ3_MTX_Q_PRE_LD (((REG32(ADR_TXQ3_MTX_Q_MISC_EN)) & 0x00000002 ) >> 1)
#define GET_TXQ3_MTX_Q_BKF_CNT_FIXED (((REG32(ADR_TXQ3_MTX_Q_MISC_EN)) & 0x00000004 ) >> 2)
#define GET_TXQ3_MTX_Q_TXOP_SUB_FRM_TIME (((REG32(ADR_TXQ3_MTX_Q_MISC_EN)) & 0x00000008 ) >> 3)
#define GET_TXQ3_MTX_Q_MB_NO_RLS (((REG32(ADR_TXQ3_MTX_Q_MISC_EN)) & 0x00000010 ) >> 4)
#define GET_TXQ3_MTX_Q_TXOP_FRC_BUR (((REG32(ADR_TXQ3_MTX_Q_MISC_EN)) & 0x00000020 ) >> 5)
#define GET_TXQ3_MTX_Q_RND_MODE (((REG32(ADR_TXQ3_MTX_Q_MISC_EN)) & 0x000000c0 ) >> 6)
#define GET_TXQ3_MTX_Q_AIFSN (((REG32(ADR_TXQ3_MTX_Q_AIFSN)) & 0x0000000f ) >> 0)
#define GET_TXQ3_MTX_Q_ECWMIN (((REG32(ADR_TXQ3_MTX_Q_AIFSN)) & 0x00000f00 ) >> 8)
#define GET_TXQ3_MTX_Q_ECWMAX (((REG32(ADR_TXQ3_MTX_Q_AIFSN)) & 0x0000f000 ) >> 12)
#define GET_TXQ3_MTX_Q_TXOP_LIMIT (((REG32(ADR_TXQ3_MTX_Q_AIFSN)) & 0xffff0000 ) >> 16)
#define GET_TXQ3_MTX_Q_BKF_CNT (((REG32(ADR_TXQ3_MTX_Q_BKF_CNT)) & 0x0000ffff ) >> 0)
#define GET_TXQ3_MTX_Q_SRC_LIMIT (((REG32(ADR_TXQ3_MTX_Q_RC_LIMIT)) & 0x000000ff ) >> 0)
#define GET_TXQ3_MTX_Q_LRC_LIMIT (((REG32(ADR_TXQ3_MTX_Q_RC_LIMIT)) & 0x0000ff00 ) >> 8)
#define GET_TXQ3_MTX_Q_ID_MAP_L (((REG32(ADR_TXQ3_MTX_Q_ID_MAP_L)) & 0xffffffff ) >> 0)
#define GET_TXQ3_MTX_Q_TXOP_CH_THD (((REG32(ADR_TXQ3_MTX_Q_TXOP_CH_THD)) & 0x0000ffff ) >> 0)
#define GET_TXQ3_MTX_Q_TXOP_OV_THD (((REG32(ADR_TXQ3_MTX_Q_TXOP_OV_THD)) & 0x0000ffff ) >> 0)
#define GET_TXQ4_MTX_Q_PRE_LD (((REG32(ADR_TXQ4_MTX_Q_MISC_EN)) & 0x00000002 ) >> 1)
#define GET_TXQ4_MTX_Q_BKF_CNT_FIXED (((REG32(ADR_TXQ4_MTX_Q_MISC_EN)) & 0x00000004 ) >> 2)
#define GET_TXQ4_MTX_Q_TXOP_SUB_FRM_TIME (((REG32(ADR_TXQ4_MTX_Q_MISC_EN)) & 0x00000008 ) >> 3)
#define GET_TXQ4_MTX_Q_MB_NO_RLS (((REG32(ADR_TXQ4_MTX_Q_MISC_EN)) & 0x00000010 ) >> 4)
#define GET_TXQ4_MTX_Q_TXOP_FRC_BUR (((REG32(ADR_TXQ4_MTX_Q_MISC_EN)) & 0x00000020 ) >> 5)
#define GET_TXQ4_MTX_Q_RND_MODE (((REG32(ADR_TXQ4_MTX_Q_MISC_EN)) & 0x000000c0 ) >> 6)
#define GET_TXQ4_MTX_Q_AIFSN (((REG32(ADR_TXQ4_MTX_Q_AIFSN)) & 0x0000000f ) >> 0)
#define GET_TXQ4_MTX_Q_ECWMIN (((REG32(ADR_TXQ4_MTX_Q_AIFSN)) & 0x00000f00 ) >> 8)
#define GET_TXQ4_MTX_Q_ECWMAX (((REG32(ADR_TXQ4_MTX_Q_AIFSN)) & 0x0000f000 ) >> 12)
#define GET_TXQ4_MTX_Q_TXOP_LIMIT (((REG32(ADR_TXQ4_MTX_Q_AIFSN)) & 0xffff0000 ) >> 16)
#define GET_TXQ4_MTX_Q_BKF_CNT (((REG32(ADR_TXQ4_MTX_Q_BKF_CNT)) & 0x0000ffff ) >> 0)
#define GET_TXQ4_MTX_Q_SRC_LIMIT (((REG32(ADR_TXQ4_MTX_Q_RC_LIMIT)) & 0x000000ff ) >> 0)
#define GET_TXQ4_MTX_Q_LRC_LIMIT (((REG32(ADR_TXQ4_MTX_Q_RC_LIMIT)) & 0x0000ff00 ) >> 8)
#define GET_TXQ4_MTX_Q_ID_MAP_L (((REG32(ADR_TXQ4_MTX_Q_ID_MAP_L)) & 0xffffffff ) >> 0)
#define GET_TXQ4_MTX_Q_TXOP_CH_THD (((REG32(ADR_TXQ4_MTX_Q_TXOP_CH_THD)) & 0x0000ffff ) >> 0)
#define GET_TXQ4_MTX_Q_TXOP_OV_THD (((REG32(ADR_TXQ4_MTX_Q_TXOP_OV_THD)) & 0x0000ffff ) >> 0)
#define GET_VALID0 (((REG32(ADR_WSID0)) & 0x00000001 ) >> 0)
#define GET_PEER_QOS_EN0 (((REG32(ADR_WSID0)) & 0x00000002 ) >> 1)
#define GET_PEER_OP_MODE0 (((REG32(ADR_WSID0)) & 0x0000000c ) >> 2)
#define GET_PEER_HT_MODE0 (((REG32(ADR_WSID0)) & 0x00000030 ) >> 4)
#define GET_PEER_MAC0_31_0 (((REG32(ADR_PEER_MAC0_0)) & 0xffffffff ) >> 0)
#define GET_PEER_MAC0_47_32 (((REG32(ADR_PEER_MAC0_1)) & 0x0000ffff ) >> 0)
#define GET_TX_ACK_POLICY_0_0 (((REG32(ADR_TX_ACK_POLICY_0_0)) & 0x00000003 ) >> 0)
#define GET_TX_SEQ_CTRL_0_0 (((REG32(ADR_TX_SEQ_CTRL_0_0)) & 0x00000fff ) >> 0)
#define GET_TX_ACK_POLICY_0_1 (((REG32(ADR_TX_ACK_POLICY_0_1)) & 0x00000003 ) >> 0)
#define GET_TX_SEQ_CTRL_0_1 (((REG32(ADR_TX_SEQ_CTRL_0_1)) & 0x00000fff ) >> 0)
#define GET_TX_ACK_POLICY_0_2 (((REG32(ADR_TX_ACK_POLICY_0_2)) & 0x00000003 ) >> 0)
#define GET_TX_SEQ_CTRL_0_2 (((REG32(ADR_TX_SEQ_CTRL_0_2)) & 0x00000fff ) >> 0)
#define GET_TX_ACK_POLICY_0_3 (((REG32(ADR_TX_ACK_POLICY_0_3)) & 0x00000003 ) >> 0)
#define GET_TX_SEQ_CTRL_0_3 (((REG32(ADR_TX_SEQ_CTRL_0_3)) & 0x00000fff ) >> 0)
#define GET_TX_ACK_POLICY_0_4 (((REG32(ADR_TX_ACK_POLICY_0_4)) & 0x00000003 ) >> 0)
#define GET_TX_SEQ_CTRL_0_4 (((REG32(ADR_TX_SEQ_CTRL_0_4)) & 0x00000fff ) >> 0)
#define GET_TX_ACK_POLICY_0_5 (((REG32(ADR_TX_ACK_POLICY_0_5)) & 0x00000003 ) >> 0)
#define GET_TX_SEQ_CTRL_0_5 (((REG32(ADR_TX_SEQ_CTRL_0_5)) & 0x00000fff ) >> 0)
#define GET_TX_ACK_POLICY_0_6 (((REG32(ADR_TX_ACK_POLICY_0_6)) & 0x00000003 ) >> 0)
#define GET_TX_SEQ_CTRL_0_6 (((REG32(ADR_TX_SEQ_CTRL_0_6)) & 0x00000fff ) >> 0)
#define GET_TX_ACK_POLICY_0_7 (((REG32(ADR_TX_ACK_POLICY_0_7)) & 0x00000003 ) >> 0)
#define GET_TX_SEQ_CTRL_0_7 (((REG32(ADR_TX_SEQ_CTRL_0_7)) & 0x00000fff ) >> 0)
#define GET_VALID1 (((REG32(ADR_WSID1)) & 0x00000001 ) >> 0)
#define GET_PEER_QOS_EN1 (((REG32(ADR_WSID1)) & 0x00000002 ) >> 1)
#define GET_PEER_OP_MODE1 (((REG32(ADR_WSID1)) & 0x0000000c ) >> 2)
#define GET_PEER_HT_MODE1 (((REG32(ADR_WSID1)) & 0x00000030 ) >> 4)
#define GET_PEER_MAC1_31_0 (((REG32(ADR_PEER_MAC1_0)) & 0xffffffff ) >> 0)
#define GET_PEER_MAC1_47_32 (((REG32(ADR_PEER_MAC1_1)) & 0x0000ffff ) >> 0)
#define GET_TX_ACK_POLICY_1_0 (((REG32(ADR_TX_ACK_POLICY_1_0)) & 0x00000003 ) >> 0)
#define GET_TX_SEQ_CTRL_1_0 (((REG32(ADR_TX_SEQ_CTRL_1_0)) & 0x00000fff ) >> 0)
#define GET_TX_ACK_POLICY_1_1 (((REG32(ADR_TX_ACK_POLICY_1_1)) & 0x00000003 ) >> 0)
#define GET_TX_SEQ_CTRL_1_1 (((REG32(ADR_TX_SEQ_CTRL_1_1)) & 0x00000fff ) >> 0)
#define GET_TX_ACK_POLICY_1_2 (((REG32(ADR_TX_ACK_POLICY_1_2)) & 0x00000003 ) >> 0)
#define GET_TX_SEQ_CTRL_1_2 (((REG32(ADR_TX_SEQ_CTRL_1_2)) & 0x00000fff ) >> 0)
#define GET_TX_ACK_POLICY_1_3 (((REG32(ADR_TX_ACK_POLICY_1_3)) & 0x00000003 ) >> 0)
#define GET_TX_SEQ_CTRL_1_3 (((REG32(ADR_TX_SEQ_CTRL_1_3)) & 0x00000fff ) >> 0)
#define GET_TX_ACK_POLICY_1_4 (((REG32(ADR_TX_ACK_POLICY_1_4)) & 0x00000003 ) >> 0)
#define GET_TX_SEQ_CTRL_1_4 (((REG32(ADR_TX_SEQ_CTRL_1_4)) & 0x00000fff ) >> 0)
#define GET_TX_ACK_POLICY_1_5 (((REG32(ADR_TX_ACK_POLICY_1_5)) & 0x00000003 ) >> 0)
#define GET_TX_SEQ_CTRL_1_5 (((REG32(ADR_TX_SEQ_CTRL_1_5)) & 0x00000fff ) >> 0)
#define GET_TX_ACK_POLICY_1_6 (((REG32(ADR_TX_ACK_POLICY_1_6)) & 0x00000003 ) >> 0)
#define GET_TX_SEQ_CTRL_1_6 (((REG32(ADR_TX_SEQ_CTRL_1_6)) & 0x00000fff ) >> 0)
#define GET_TX_ACK_POLICY_1_7 (((REG32(ADR_TX_ACK_POLICY_1_7)) & 0x00000003 ) >> 0)
#define GET_TX_SEQ_CTRL_1_7 (((REG32(ADR_TX_SEQ_CTRL_1_7)) & 0x00000fff ) >> 0)
#define GET_INFO0 (((REG32(ADR_INFO0)) & 0xffffffff ) >> 0)
#define GET_INFO1 (((REG32(ADR_INFO1)) & 0xffffffff ) >> 0)
#define GET_INFO2 (((REG32(ADR_INFO2)) & 0xffffffff ) >> 0)
#define GET_INFO3 (((REG32(ADR_INFO3)) & 0xffffffff ) >> 0)
#define GET_INFO4 (((REG32(ADR_INFO4)) & 0xffffffff ) >> 0)
#define GET_INFO5 (((REG32(ADR_INFO5)) & 0xffffffff ) >> 0)
#define GET_INFO6 (((REG32(ADR_INFO6)) & 0xffffffff ) >> 0)
#define GET_INFO7 (((REG32(ADR_INFO7)) & 0xffffffff ) >> 0)
#define GET_INFO8 (((REG32(ADR_INFO8)) & 0xffffffff ) >> 0)
#define GET_INFO9 (((REG32(ADR_INFO9)) & 0xffffffff ) >> 0)
#define GET_INFO10 (((REG32(ADR_INFO10)) & 0xffffffff ) >> 0)
#define GET_INFO11 (((REG32(ADR_INFO11)) & 0xffffffff ) >> 0)
#define GET_INFO12 (((REG32(ADR_INFO12)) & 0xffffffff ) >> 0)
#define GET_INFO13 (((REG32(ADR_INFO13)) & 0xffffffff ) >> 0)
#define GET_INFO14 (((REG32(ADR_INFO14)) & 0xffffffff ) >> 0)
#define GET_INFO15 (((REG32(ADR_INFO15)) & 0xffffffff ) >> 0)
#define GET_INFO16 (((REG32(ADR_INFO16)) & 0xffffffff ) >> 0)
#define GET_INFO17 (((REG32(ADR_INFO17)) & 0xffffffff ) >> 0)
#define GET_INFO18 (((REG32(ADR_INFO18)) & 0xffffffff ) >> 0)
#define GET_INFO19 (((REG32(ADR_INFO19)) & 0xffffffff ) >> 0)
#define GET_INFO20 (((REG32(ADR_INFO20)) & 0xffffffff ) >> 0)
#define GET_INFO21 (((REG32(ADR_INFO21)) & 0xffffffff ) >> 0)
#define GET_INFO22 (((REG32(ADR_INFO22)) & 0xffffffff ) >> 0)
#define GET_INFO23 (((REG32(ADR_INFO23)) & 0xffffffff ) >> 0)
#define GET_INFO24 (((REG32(ADR_INFO24)) & 0xffffffff ) >> 0)
#define GET_INFO25 (((REG32(ADR_INFO25)) & 0xffffffff ) >> 0)
#define GET_INFO26 (((REG32(ADR_INFO26)) & 0xffffffff ) >> 0)
#define GET_INFO27 (((REG32(ADR_INFO27)) & 0xffffffff ) >> 0)
#define GET_INFO28 (((REG32(ADR_INFO28)) & 0xffffffff ) >> 0)
#define GET_INFO29 (((REG32(ADR_INFO29)) & 0xffffffff ) >> 0)
#define GET_INFO30 (((REG32(ADR_INFO30)) & 0xffffffff ) >> 0)
#define GET_INFO31 (((REG32(ADR_INFO31)) & 0xffffffff ) >> 0)
#define GET_INFO32 (((REG32(ADR_INFO32)) & 0xffffffff ) >> 0)
#define GET_INFO33 (((REG32(ADR_INFO33)) & 0xffffffff ) >> 0)
#define GET_INFO34 (((REG32(ADR_INFO34)) & 0xffffffff ) >> 0)
#define GET_INFO35 (((REG32(ADR_INFO35)) & 0xffffffff ) >> 0)
#define GET_INFO36 (((REG32(ADR_INFO36)) & 0xffffffff ) >> 0)
#define GET_INFO37 (((REG32(ADR_INFO37)) & 0xffffffff ) >> 0)
#define GET_INFO38 (((REG32(ADR_INFO38)) & 0xffffffff ) >> 0)
#define GET_INFO_MASK (((REG32(ADR_INFO_MASK)) & 0xffffffff ) >> 0)
#define GET_INFO_DEF_RATE (((REG32(ADR_INFO_RATE_OFFSET)) & 0x0000003f ) >> 0)
#define GET_INFO_MRX_OFFSET (((REG32(ADR_INFO_RATE_OFFSET)) & 0x000f0000 ) >> 16)
#define GET_BCAST_RATEUNKNOW (((REG32(ADR_INFO_RATE_OFFSET)) & 0x3f000000 ) >> 24)
#define GET_INFO_IDX_TBL_ADDR (((REG32(ADR_INFO_IDX_ADDR)) & 0xffffffff ) >> 0)
#define GET_INFO_LEN_TBL_ADDR (((REG32(ADR_INFO_LEN_ADDR)) & 0xffffffff ) >> 0)
#define GET_IC_TAG_31_0 (((REG32(ADR_IC_TIME_TAG_0)) & 0xffffffff ) >> 0)
#define GET_IC_TAG_63_32 (((REG32(ADR_IC_TIME_TAG_1)) & 0xffffffff ) >> 0)
#define GET_CH1_PRI (((REG32(ADR_PACKET_ID_ALLOCATION_PRIORITY)) & 0x00000003 ) >> 0)
#define GET_CH2_PRI (((REG32(ADR_PACKET_ID_ALLOCATION_PRIORITY)) & 0x00000300 ) >> 8)
#define GET_CH3_PRI (((REG32(ADR_PACKET_ID_ALLOCATION_PRIORITY)) & 0x00030000 ) >> 16)
#define GET_RG_MAC_LPBK (((REG32(ADR_MAC_MODE)) & 0x00000001 ) >> 0)
#define GET_RG_MAC_M2M (((REG32(ADR_MAC_MODE)) & 0x00000002 ) >> 1)
#define GET_RG_PHY_LPBK (((REG32(ADR_MAC_MODE)) & 0x00000004 ) >> 2)
#define GET_RG_LPBK_RX_EN (((REG32(ADR_MAC_MODE)) & 0x00000008 ) >> 3)
#define GET_EXT_MAC_MODE (((REG32(ADR_MAC_MODE)) & 0x00000010 ) >> 4)
#define GET_EXT_PHY_MODE (((REG32(ADR_MAC_MODE)) & 0x00000020 ) >> 5)
#define GET_ASIC_TAG (((REG32(ADR_MAC_MODE)) & 0xff000000 ) >> 24)
#define GET_HCI_SW_RST (((REG32(ADR_ALL_SOFTWARE_RESET)) & 0x00000001 ) >> 0)
#define GET_CO_PROC_SW_RST (((REG32(ADR_ALL_SOFTWARE_RESET)) & 0x00000002 ) >> 1)
#define GET_MTX_MISC_SW_RST (((REG32(ADR_ALL_SOFTWARE_RESET)) & 0x00000008 ) >> 3)
#define GET_MTX_QUE_SW_RST (((REG32(ADR_ALL_SOFTWARE_RESET)) & 0x00000010 ) >> 4)
#define GET_MTX_CHST_SW_RST (((REG32(ADR_ALL_SOFTWARE_RESET)) & 0x00000020 ) >> 5)
#define GET_MTX_BCN_SW_RST (((REG32(ADR_ALL_SOFTWARE_RESET)) & 0x00000040 ) >> 6)
#define GET_MRX_SW_RST (((REG32(ADR_ALL_SOFTWARE_RESET)) & 0x00000080 ) >> 7)
#define GET_AMPDU_SW_RST (((REG32(ADR_ALL_SOFTWARE_RESET)) & 0x00000100 ) >> 8)
#define GET_MMU_SW_RST (((REG32(ADR_ALL_SOFTWARE_RESET)) & 0x00000200 ) >> 9)
#define GET_ID_MNG_SW_RST (((REG32(ADR_ALL_SOFTWARE_RESET)) & 0x00000800 ) >> 11)
#define GET_MBOX_SW_RST (((REG32(ADR_ALL_SOFTWARE_RESET)) & 0x00001000 ) >> 12)
#define GET_SCRT_SW_RST (((REG32(ADR_ALL_SOFTWARE_RESET)) & 0x00002000 ) >> 13)
#define GET_MIC_SW_RST (((REG32(ADR_ALL_SOFTWARE_RESET)) & 0x00004000 ) >> 14)
#define GET_CO_PROC_ENG_RST (((REG32(ADR_ENG_SOFTWARE_RESET)) & 0x00000002 ) >> 1)
#define GET_MTX_MISC_ENG_RST (((REG32(ADR_ENG_SOFTWARE_RESET)) & 0x00000008 ) >> 3)
#define GET_MTX_QUE_ENG_RST (((REG32(ADR_ENG_SOFTWARE_RESET)) & 0x00000010 ) >> 4)
#define GET_MTX_CHST_ENG_RST (((REG32(ADR_ENG_SOFTWARE_RESET)) & 0x00000020 ) >> 5)
#define GET_MTX_BCN_ENG_RST (((REG32(ADR_ENG_SOFTWARE_RESET)) & 0x00000040 ) >> 6)
#define GET_MRX_ENG_RST (((REG32(ADR_ENG_SOFTWARE_RESET)) & 0x00000080 ) >> 7)
#define GET_AMPDU_ENG_RST (((REG32(ADR_ENG_SOFTWARE_RESET)) & 0x00000100 ) >> 8)
#define GET_ID_MNG_ENG_RST (((REG32(ADR_ENG_SOFTWARE_RESET)) & 0x00004000 ) >> 14)
#define GET_MBOX_ENG_RST (((REG32(ADR_ENG_SOFTWARE_RESET)) & 0x00008000 ) >> 15)
#define GET_SCRT_ENG_RST (((REG32(ADR_ENG_SOFTWARE_RESET)) & 0x00010000 ) >> 16)
#define GET_MIC_ENG_RST (((REG32(ADR_ENG_SOFTWARE_RESET)) & 0x00020000 ) >> 17)
#define GET_CO_PROC_CSR_RST (((REG32(ADR_CSR_SOFTWARE_RESET)) & 0x00000002 ) >> 1)
#define GET_MTX_MISC_CSR_RST (((REG32(ADR_CSR_SOFTWARE_RESET)) & 0x00000008 ) >> 3)
#define GET_MTX_QUE0_CSR_RST (((REG32(ADR_CSR_SOFTWARE_RESET)) & 0x00000010 ) >> 4)
#define GET_MTX_QUE1_CSR_RST (((REG32(ADR_CSR_SOFTWARE_RESET)) & 0x00000020 ) >> 5)
#define GET_MTX_QUE2_CSR_RST (((REG32(ADR_CSR_SOFTWARE_RESET)) & 0x00000040 ) >> 6)
#define GET_MTX_QUE3_CSR_RST (((REG32(ADR_CSR_SOFTWARE_RESET)) & 0x00000080 ) >> 7)
#define GET_MTX_QUE4_CSR_RST (((REG32(ADR_CSR_SOFTWARE_RESET)) & 0x00000100 ) >> 8)
#define GET_MTX_QUE5_CSR_RST (((REG32(ADR_CSR_SOFTWARE_RESET)) & 0x00000200 ) >> 9)
#define GET_MRX_CSR_RST (((REG32(ADR_CSR_SOFTWARE_RESET)) & 0x00000400 ) >> 10)
#define GET_AMPDU_CSR_RST (((REG32(ADR_CSR_SOFTWARE_RESET)) & 0x00000800 ) >> 11)
#define GET_SCRT_CSR_RST (((REG32(ADR_CSR_SOFTWARE_RESET)) & 0x00002000 ) >> 13)
#define GET_ID_MNG_CSR_RST (((REG32(ADR_CSR_SOFTWARE_RESET)) & 0x00004000 ) >> 14)
#define GET_MBOX_CSR_RST (((REG32(ADR_CSR_SOFTWARE_RESET)) & 0x00008000 ) >> 15)
#define GET_HCI_CLK_EN (((REG32(ADR_MAC_CLOCK_ENABLE)) & 0x00000001 ) >> 0)
#define GET_CO_PROC_CLK_EN (((REG32(ADR_MAC_CLOCK_ENABLE)) & 0x00000002 ) >> 1)
#define GET_MTX_MISC_CLK_EN (((REG32(ADR_MAC_CLOCK_ENABLE)) & 0x00000008 ) >> 3)
#define GET_MTX_QUE_CLK_EN (((REG32(ADR_MAC_CLOCK_ENABLE)) & 0x00000010 ) >> 4)
#define GET_MRX_CLK_EN (((REG32(ADR_MAC_CLOCK_ENABLE)) & 0x00000020 ) >> 5)
#define GET_AMPDU_CLK_EN (((REG32(ADR_MAC_CLOCK_ENABLE)) & 0x00000040 ) >> 6)
#define GET_MMU_CLK_EN (((REG32(ADR_MAC_CLOCK_ENABLE)) & 0x00000080 ) >> 7)
#define GET_ID_MNG_CLK_EN (((REG32(ADR_MAC_CLOCK_ENABLE)) & 0x00000200 ) >> 9)
#define GET_MBOX_CLK_EN (((REG32(ADR_MAC_CLOCK_ENABLE)) & 0x00000400 ) >> 10)
#define GET_SCRT_CLK_EN (((REG32(ADR_MAC_CLOCK_ENABLE)) & 0x00000800 ) >> 11)
#define GET_MIC_CLK_EN (((REG32(ADR_MAC_CLOCK_ENABLE)) & 0x00001000 ) >> 12)
#define GET_MIB_CLK_EN (((REG32(ADR_MAC_CLOCK_ENABLE)) & 0x00002000 ) >> 13)
#define GET_HCI_ENG_CLK_EN (((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0x00000001 ) >> 0)
#define GET_CO_PROC_ENG_CLK_EN (((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0x00000002 ) >> 1)
#define GET_MTX_MISC_ENG_CLK_EN (((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0x00000008 ) >> 3)
#define GET_MTX_QUE_ENG_CLK_EN (((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0x00000010 ) >> 4)
#define GET_MRX_ENG_CLK_EN (((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0x00000020 ) >> 5)
#define GET_AMPDU_ENG_CLK_EN (((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0x00000040 ) >> 6)
#define GET_ID_MNG_ENG_CLK_EN (((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0x00001000 ) >> 12)
#define GET_MBOX_ENG_CLK_EN (((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0x00002000 ) >> 13)
#define GET_SCRT_ENG_CLK_EN (((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0x00004000 ) >> 14)
#define GET_MIC_ENG_CLK_EN (((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0x00008000 ) >> 15)
#define GET_CO_PROC_CSR_CLK_EN (((REG32(ADR_MAC_CSR_CLOCK_ENABLE)) & 0x00000002 ) >> 1)
#define GET_MRX_CSR_CLK_EN (((REG32(ADR_MAC_CSR_CLOCK_ENABLE)) & 0x00000400 ) >> 10)
#define GET_AMPDU_CSR_CLK_EN (((REG32(ADR_MAC_CSR_CLOCK_ENABLE)) & 0x00000800 ) >> 11)
#define GET_SCRT_CSR_CLK_EN (((REG32(ADR_MAC_CSR_CLOCK_ENABLE)) & 0x00002000 ) >> 13)
#define GET_ID_MNG_CSR_CLK_EN (((REG32(ADR_MAC_CSR_CLOCK_ENABLE)) & 0x00004000 ) >> 14)
#define GET_MBOX_CSR_CLK_EN (((REG32(ADR_MAC_CSR_CLOCK_ENABLE)) & 0x00008000 ) >> 15)
#define GET_OP_MODE (((REG32(ADR_GLBLE_SET)) & 0x00000003 ) >> 0)
#define GET_HT_MODE (((REG32(ADR_GLBLE_SET)) & 0x0000000c ) >> 2)
#define GET_QOS_EN (((REG32(ADR_GLBLE_SET)) & 0x00000010 ) >> 4)
#define GET_PB_OFFSET (((REG32(ADR_GLBLE_SET)) & 0x0000ff00 ) >> 8)
#define GET_SNIFFER_MODE (((REG32(ADR_GLBLE_SET)) & 0x00010000 ) >> 16)
#define GET_DUP_FLT (((REG32(ADR_GLBLE_SET)) & 0x00020000 ) >> 17)
#define GET_TX_PKT_RSVD (((REG32(ADR_GLBLE_SET)) & 0x001c0000 ) >> 18)
#define GET_AMPDU_SNIFFER (((REG32(ADR_GLBLE_SET)) & 0x00200000 ) >> 21)
#define GET_REASON_TRAP0 (((REG32(ADR_REASON_TRAP0)) & 0xffffffff ) >> 0)
#define GET_REASON_TRAP1 (((REG32(ADR_REASON_TRAP1)) & 0xffffffff ) >> 0)
#define GET_BSSID_31_0 (((REG32(ADR_BSSID_0)) & 0xffffffff ) >> 0)
#define GET_BSSID_47_32 (((REG32(ADR_BSSID_1)) & 0x0000ffff ) >> 0)
#define GET_SCRT_STATE (((REG32(ADR_SCRT_STATE)) & 0x0000000f ) >> 0)
#define GET_STA_MAC_31_0 (((REG32(ADR_STA_MAC_0)) & 0xffffffff ) >> 0)
#define GET_STA_MAC_47_32 (((REG32(ADR_STA_MAC_1)) & 0x0000ffff ) >> 0)
#define GET_PAIR_SCRT (((REG32(ADR_SCRT_SET)) & 0x00000007 ) >> 0)
#define GET_GRP_SCRT (((REG32(ADR_SCRT_SET)) & 0x00000038 ) >> 3)
#define GET_SCRT_PKT_ID (((REG32(ADR_SCRT_SET)) & 0x00001fc0 ) >> 6)
#define GET_SCRT_RPLY_IGNORE (((REG32(ADR_SCRT_SET)) & 0x00010000 ) >> 16)
#define GET_COEXIST_EN (((REG32(ADR_BTCX0)) & 0x00000001 ) >> 0)
#define GET_WIRE_MODE (((REG32(ADR_BTCX0)) & 0x0000000e ) >> 1)
#define GET_WL_RX_PRI (((REG32(ADR_BTCX0)) & 0x00000010 ) >> 4)
#define GET_WL_TX_PRI (((REG32(ADR_BTCX0)) & 0x00000020 ) >> 5)
#define GET_GURAN_USE_EN (((REG32(ADR_BTCX0)) & 0x00000100 ) >> 8)
#define GET_GURAN_USE_CTRL (((REG32(ADR_BTCX0)) & 0x00000200 ) >> 9)
#define GET_BEACON_TIMEOUT_EN (((REG32(ADR_BTCX0)) & 0x00000400 ) >> 10)
#define GET_WLAN_ACT_POL (((REG32(ADR_BTCX0)) & 0x00000800 ) >> 11)
#define GET_DUAL_ANT_EN (((REG32(ADR_BTCX0)) & 0x00001000 ) >> 12)
#define GET_TRSW_PHY_POL (((REG32(ADR_BTCX0)) & 0x00010000 ) >> 16)
#define GET_WIFI_TX_SW_POL (((REG32(ADR_BTCX0)) & 0x00020000 ) >> 17)
#define GET_WIFI_RX_SW_POL (((REG32(ADR_BTCX0)) & 0x00040000 ) >> 18)
#define GET_BT_SW_POL (((REG32(ADR_BTCX0)) & 0x00080000 ) >> 19)
#define GET_BT_PRI_SMP_TIME (((REG32(ADR_BTCX1)) & 0x000000ff ) >> 0)
#define GET_BT_STA_SMP_TIME (((REG32(ADR_BTCX1)) & 0x0000ff00 ) >> 8)
#define GET_BEACON_TIMEOUT (((REG32(ADR_BTCX1)) & 0x00ff0000 ) >> 16)
#define GET_WLAN_REMAIN_TIME (((REG32(ADR_BTCX1)) & 0xff000000 ) >> 24)
#define GET_SW_MANUAL_EN (((REG32(ADR_SWITCH_CTL)) & 0x00000001 ) >> 0)
#define GET_SW_WL_TX (((REG32(ADR_SWITCH_CTL)) & 0x00000002 ) >> 1)
#define GET_SW_WL_RX (((REG32(ADR_SWITCH_CTL)) & 0x00000004 ) >> 2)
#define GET_SW_BT_TRX (((REG32(ADR_SWITCH_CTL)) & 0x00000008 ) >> 3)
#define GET_BT_TXBAR_MANUAL_EN (((REG32(ADR_SWITCH_CTL)) & 0x00000010 ) >> 4)
#define GET_BT_TXBAR_SET (((REG32(ADR_SWITCH_CTL)) & 0x00000020 ) >> 5)
#define GET_BT_BUSY_MANUAL_EN (((REG32(ADR_SWITCH_CTL)) & 0x00000100 ) >> 8)
#define GET_BT_BUSY_SET (((REG32(ADR_SWITCH_CTL)) & 0x00000200 ) >> 9)
#define GET_G0_PKT_CLS_MIB_EN (((REG32(ADR_MIB_EN)) & 0x00000004 ) >> 2)
#define GET_G0_PKT_CLS_ONGOING (((REG32(ADR_MIB_EN)) & 0x00000008 ) >> 3)
#define GET_G1_PKT_CLS_MIB_EN (((REG32(ADR_MIB_EN)) & 0x00000010 ) >> 4)
#define GET_G1_PKT_CLS_ONGOING (((REG32(ADR_MIB_EN)) & 0x00000020 ) >> 5)
#define GET_Q0_PKT_CLS_MIB_EN (((REG32(ADR_MIB_EN)) & 0x00000040 ) >> 6)
#define GET_Q0_PKT_CLS_ONGOING (((REG32(ADR_MIB_EN)) & 0x00000080 ) >> 7)
#define GET_Q1_PKT_CLS_MIB_EN (((REG32(ADR_MIB_EN)) & 0x00000100 ) >> 8)
#define GET_Q1_PKT_CLS_ONGOING (((REG32(ADR_MIB_EN)) & 0x00000200 ) >> 9)
#define GET_Q2_PKT_CLS_MIB_EN (((REG32(ADR_MIB_EN)) & 0x00000400 ) >> 10)
#define GET_Q2_PKT_CLS_ONGOING (((REG32(ADR_MIB_EN)) & 0x00000800 ) >> 11)
#define GET_Q3_PKT_CLS_MIB_EN (((REG32(ADR_MIB_EN)) & 0x00001000 ) >> 12)
#define GET_Q3_PKT_CLS_ONGOING (((REG32(ADR_MIB_EN)) & 0x00002000 ) >> 13)
#define GET_SCRT_PKT_CLS_MIB_EN (((REG32(ADR_MIB_EN)) & 0x00004000 ) >> 14)
#define GET_SCRT_PKT_CLS_ONGOING (((REG32(ADR_MIB_EN)) & 0x00008000 ) >> 15)
#define GET_MISC_PKT_CLS_MIB_EN (((REG32(ADR_MIB_EN)) & 0x00010000 ) >> 16)
#define GET_MISC_PKT_CLS_ONGOING (((REG32(ADR_MIB_EN)) & 0x00020000 ) >> 17)
#define GET_MTX_WSID0_SUCC (((REG32(ADR_MTX_WSID0_SUCC)) & 0x0000ffff ) >> 0)
#define GET_MTX_WSID0_FRM (((REG32(ADR_MTX_WSID0_FRM)) & 0x0000ffff ) >> 0)
#define GET_MTX_WSID0_RETRY (((REG32(ADR_MTX_WSID0_RETRY)) & 0x0000ffff ) >> 0)
#define GET_MTX_WSID0_TOTAL (((REG32(ADR_MTX_WSID0_TOTAL)) & 0x0000ffff ) >> 0)
#define GET_MTX_GRP (((REG32(ADR_MTX_GROUP)) & 0x000fffff ) >> 0)
#define GET_MTX_FAIL (((REG32(ADR_MTX_FAIL)) & 0x0000ffff ) >> 0)
#define GET_MTX_RETRY (((REG32(ADR_MTX_RETRY)) & 0x000fffff ) >> 0)
#define GET_MTX_MULTI_RETRY (((REG32(ADR_MTX_MULTI_RETRY)) & 0x000fffff ) >> 0)
#define GET_MTX_RTS_SUCC (((REG32(ADR_MTX_RTS_SUCCESS)) & 0x0000ffff ) >> 0)
#define GET_MTX_RTS_FAIL (((REG32(ADR_MTX_RTS_FAIL)) & 0x0000ffff ) >> 0)
#define GET_MTX_ACK_FAIL (((REG32(ADR_MTX_ACK_FAIL)) & 0x0000ffff ) >> 0)
#define GET_MTX_FRM (((REG32(ADR_MTX_FRM)) & 0x000fffff ) >> 0)
#define GET_MTX_ACK_TX (((REG32(ADR_MTX_ACK_TX)) & 0x0000ffff ) >> 0)
#define GET_MTX_CTS_TX (((REG32(ADR_MTX_CTS_TX)) & 0x0000ffff ) >> 0)
#define GET_MRX_DUP (((REG32(ADR_MRX_DUP_FRM)) & 0x0000ffff ) >> 0)
#define GET_MRX_FRG (((REG32(ADR_MRX_FRG_FRM)) & 0x000fffff ) >> 0)
#define GET_MRX_GRP (((REG32(ADR_MRX_GROUP_FRM)) & 0x000fffff ) >> 0)
#define GET_MRX_FCS_ERR (((REG32(ADR_MRX_FCS_ERR)) & 0x0000ffff ) >> 0)
#define GET_MRX_FCS_SUC (((REG32(ADR_MRX_FCS_SUCC)) & 0x0000ffff ) >> 0)
#define GET_MRX_MISS (((REG32(ADR_MRX_MISS)) & 0x0000ffff ) >> 0)
#define GET_MRX_ALC_FAIL (((REG32(ADR_MRX_ALC_FAIL)) & 0x0000ffff ) >> 0)
#define GET_MRX_DAT_NTF (((REG32(ADR_MRX_DAT_NTF)) & 0x0000ffff ) >> 0)
#define GET_MRX_RTS_NTF (((REG32(ADR_MRX_RTS_NTF)) & 0x0000ffff ) >> 0)
#define GET_MRX_CTS_NTF (((REG32(ADR_MRX_CTS_NTF)) & 0x0000ffff ) >> 0)
#define GET_MRX_ACK_NTF (((REG32(ADR_MRX_ACK_NTF)) & 0x0000ffff ) >> 0)
#define GET_MRX_BA_NTF (((REG32(ADR_MRX_BA_NTF)) & 0x0000ffff ) >> 0)
#define GET_MRX_DATA_NTF (((REG32(ADR_MRX_DATA_NTF)) & 0x0000ffff ) >> 0)
#define GET_MRX_MNG_NTF (((REG32(ADR_MRX_MNG_NTF)) & 0x0000ffff ) >> 0)
#define GET_MRX_DAT_CRC_NTF (((REG32(ADR_MRX_DAT_CRC_NTF)) & 0x0000ffff ) >> 0)
#define GET_MRX_BAR_NTF (((REG32(ADR_MRX_BAR_NTF)) & 0x0000ffff ) >> 0)
#define GET_MRX_MB_MISS (((REG32(ADR_MRX_MB_MISS)) & 0x0000ffff ) >> 0)
#define GET_MRX_NIDLE_MISS (((REG32(ADR_MRX_NIDLE_MISS)) & 0x0000ffff ) >> 0)
#define GET_MRX_CSR_NTF (((REG32(ADR_MRX_CSR_NTF)) & 0x0000ffff ) >> 0)
#define GET_DBG_Q0_SUCC (((REG32(ADR_DBG_Q0_FRM_SUCCESS)) & 0x0000ffff ) >> 0)
#define GET_DBG_Q0_FAIL (((REG32(ADR_DBG_Q0_FRM_FAIL)) & 0x0000ffff ) >> 0)
#define GET_DBG_Q0_ACK_SUCC (((REG32(ADR_DBG_Q0_ACK_SUCCESS)) & 0x0000ffff ) >> 0)
#define GET_DBG_Q0_ACK_FAIL (((REG32(ADR_DBG_Q0_ACK_FAIL)) & 0x0000ffff ) >> 0)
#define GET_DBG_Q1_SUCC (((REG32(ADR_DBG_Q1_FRM_SUCCESS)) & 0x0000ffff ) >> 0)
#define GET_DBG_Q1_FAIL (((REG32(ADR_DBG_Q1_FRM_FAIL)) & 0x0000ffff ) >> 0)
#define GET_DBG_Q1_ACK_SUCC (((REG32(ADR_DBG_Q1_ACK_SUCCESS)) & 0x0000ffff ) >> 0)
#define GET_DBG_Q1_ACK_FAIL (((REG32(ADR_DBG_Q1_ACK_FAIL)) & 0x0000ffff ) >> 0)
#define GET_DBG_Q2_SUCC (((REG32(ADR_DBG_Q2_FRM_SUCCESS)) & 0x0000ffff ) >> 0)
#define GET_DBG_Q2_FAIL (((REG32(ADR_DBG_Q2_FRM_FAIL)) & 0x0000ffff ) >> 0)
#define GET_DBG_Q2_ACK_SUCC (((REG32(ADR_DBG_Q2_ACK_SUCCESS)) & 0x0000ffff ) >> 0)
#define GET_DBG_Q2_ACK_FAIL (((REG32(ADR_DBG_Q2_ACK_FAIL)) & 0x0000ffff ) >> 0)
#define GET_DBG_Q3_SUCC (((REG32(ADR_DBG_Q3_FRM_SUCCESS)) & 0x0000ffff ) >> 0)
#define GET_DBG_Q3_FAIL (((REG32(ADR_DBG_Q3_FRM_FAIL)) & 0x0000ffff ) >> 0)
#define GET_DBG_Q3_ACK_SUCC (((REG32(ADR_DBG_Q3_ACK_SUCCESS)) & 0x0000ffff ) >> 0)
#define GET_DBG_Q3_ACK_FAIL (((REG32(ADR_DBG_Q3_ACK_FAIL)) & 0x0000ffff ) >> 0)
#define GET_SCRT_TKIP_CERR (((REG32(ADR_MIB_SCRT_TKIP0)) & 0x000fffff ) >> 0)
#define GET_SCRT_TKIP_MIC_ERR (((REG32(ADR_MIB_SCRT_TKIP1)) & 0x000fffff ) >> 0)
#define GET_SCRT_TKIP_RPLY (((REG32(ADR_MIB_SCRT_TKIP2)) & 0x000fffff ) >> 0)
#define GET_SCRT_CCMP_RPLY (((REG32(ADR_MIB_SCRT_CCMP0)) & 0x000fffff ) >> 0)
#define GET_SCRT_CCMP_CERR (((REG32(ADR_MIB_SCRT_CCMP1)) & 0x000fffff ) >> 0)
#define GET_DBG_LEN_CRC_FAIL (((REG32(ADR_DBG_LEN_CRC_FAIL)) & 0x0000ffff ) >> 0)
#define GET_DBG_LEN_ALC_FAIL (((REG32(ADR_DBG_LEN_ALC_FAIL)) & 0x0000ffff ) >> 0)
#define GET_DBG_AMPDU_PASS (((REG32(ADR_DBG_AMPDU_PASS)) & 0x0000ffff ) >> 0)
#define GET_DBG_AMPDU_FAIL (((REG32(ADR_DBG_AMPDU_FAIL)) & 0x0000ffff ) >> 0)
#define GET_RXID_ALC_CNT_FAIL (((REG32(ADR_ID_ALC_FAIL1)) & 0x0000ffff ) >> 0)
#define GET_RXID_ALC_LEN_FAIL (((REG32(ADR_ID_ALC_FAIL2)) & 0x0000ffff ) >> 0)
#define GET_CBR_RG_EN_MANUAL (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00000001 ) >> 0)
#define GET_CBR_RG_TX_EN (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00000002 ) >> 1)
#define GET_CBR_RG_TX_PA_EN (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00000004 ) >> 2)
#define GET_CBR_RG_TX_DAC_EN (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00000008 ) >> 3)
#define GET_CBR_RG_RX_AGC (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00000010 ) >> 4)
#define GET_CBR_RG_RX_GAIN_MANUAL (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00000020 ) >> 5)
#define GET_CBR_RG_RFG (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x000000c0 ) >> 6)
#define GET_CBR_RG_PGAG (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00000f00 ) >> 8)
#define GET_CBR_RG_MODE (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00003000 ) >> 12)
#define GET_CBR_RG_EN_TX_TRSW (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00004000 ) >> 14)
#define GET_CBR_RG_EN_SX (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00008000 ) >> 15)
#define GET_CBR_RG_EN_RX_LNA (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00010000 ) >> 16)
#define GET_CBR_RG_EN_RX_MIXER (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00020000 ) >> 17)
#define GET_CBR_RG_EN_RX_DIV2 (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00040000 ) >> 18)
#define GET_CBR_RG_EN_RX_LOBUF (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00080000 ) >> 19)
#define GET_CBR_RG_EN_RX_TZ (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00100000 ) >> 20)
#define GET_CBR_RG_EN_RX_FILTER (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00200000 ) >> 21)
#define GET_CBR_RG_EN_RX_HPF (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00400000 ) >> 22)
#define GET_CBR_RG_EN_RX_RSSI (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x00800000 ) >> 23)
#define GET_CBR_RG_EN_ADC (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x01000000 ) >> 24)
#define GET_CBR_RG_EN_TX_MOD (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x02000000 ) >> 25)
#define GET_CBR_RG_EN_TX_DIV2 (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x04000000 ) >> 26)
#define GET_CBR_RG_EN_TX_DIV2_BUF (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x08000000 ) >> 27)
#define GET_CBR_RG_EN_TX_LOBF (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x10000000 ) >> 28)
#define GET_CBR_RG_EN_RX_LOBF (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x20000000 ) >> 29)
#define GET_CBR_RG_SEL_DPLL_CLK (((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0x40000000 ) >> 30)
#define GET_CBR_RG_EN_TX_DPD (((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0x00000001 ) >> 0)
#define GET_CBR_RG_EN_TX_TSSI (((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0x00000002 ) >> 1)
#define GET_CBR_RG_EN_RX_IQCAL (((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0x00000004 ) >> 2)
#define GET_CBR_RG_EN_TX_DAC_CAL (((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0x00000008 ) >> 3)
#define GET_CBR_RG_EN_TX_SELF_MIXER (((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0x00000010 ) >> 4)
#define GET_CBR_RG_EN_TX_DAC_OUT (((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0x00000020 ) >> 5)
#define GET_CBR_RG_EN_LDO_RX_FE (((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0x00000040 ) >> 6)
#define GET_CBR_RG_EN_LDO_ABB (((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0x00000080 ) >> 7)
#define GET_CBR_RG_EN_LDO_AFE (((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0x00000100 ) >> 8)
#define GET_CBR_RG_EN_SX_CHPLDO (((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0x00000200 ) >> 9)
#define GET_CBR_RG_EN_SX_LOBFLDO (((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0x00000400 ) >> 10)
#define GET_CBR_RG_EN_IREF_RX (((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0x00000800 ) >> 11)
#define GET_CBR_RG_DCDC_MODE (((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0x00001000 ) >> 12)
#define GET_CBR_RG_LDO_LEVEL_RX_FE (((REG32(ADR_CBR_LDO_REGISTER)) & 0x00000007 ) >> 0)
#define GET_CBR_RG_LDO_LEVEL_ABB (((REG32(ADR_CBR_LDO_REGISTER)) & 0x00000038 ) >> 3)
#define GET_CBR_RG_LDO_LEVEL_AFE (((REG32(ADR_CBR_LDO_REGISTER)) & 0x000001c0 ) >> 6)
#define GET_CBR_RG_SX_LDO_CHP_LEVEL (((REG32(ADR_CBR_LDO_REGISTER)) & 0x00000e00 ) >> 9)
#define GET_CBR_RG_SX_LDO_LOBF_LEVEL (((REG32(ADR_CBR_LDO_REGISTER)) & 0x00007000 ) >> 12)
#define GET_CBR_RG_SX_LDO_XOSC_LEVEL (((REG32(ADR_CBR_LDO_REGISTER)) & 0x00038000 ) >> 15)
#define GET_CBR_RG_DP_LDO_LEVEL (((REG32(ADR_CBR_LDO_REGISTER)) & 0x001c0000 ) >> 18)
#define GET_CBR_RG_SX_LDO_VCO_LEVEL (((REG32(ADR_CBR_LDO_REGISTER)) & 0x00e00000 ) >> 21)
#define GET_CBR_RG_TX_LDO_TX_LEVEL (((REG32(ADR_CBR_LDO_REGISTER)) & 0x07000000 ) >> 24)
#define GET_CBR_RG_BUCK_LEVEL (((REG32(ADR_CBR_LDO_REGISTER)) & 0x38000000 ) >> 27)
#define GET_CBR_RG_EN_RX_PADSW (((REG32(ADR_CBR_ABB_REGISTER_1)) & 0x00000001 ) >> 0)
#define GET_CBR_RG_EN_RX_TESTNODE (((REG32(ADR_CBR_ABB_REGISTER_1)) & 0x00000002 ) >> 1)
#define GET_CBR_RG_RX_ABBCFIX (((REG32(ADR_CBR_ABB_REGISTER_1)) & 0x00000004 ) >> 2)
#define GET_CBR_RG_RX_ABBCTUNE (((REG32(ADR_CBR_ABB_REGISTER_1)) & 0x000001f8 ) >> 3)
#define GET_CBR_RG_RX_ABBOUT_TRI_STATE (((REG32(ADR_CBR_ABB_REGISTER_1)) & 0x00000200 ) >> 9)
#define GET_CBR_RG_RX_ABB_N_MODE (((REG32(ADR_CBR_ABB_REGISTER_1)) & 0x00000400 ) >> 10)
#define GET_CBR_RG_RX_EN_LOOPA (((REG32(ADR_CBR_ABB_REGISTER_1)) & 0x00000800 ) >> 11)
#define GET_CBR_RG_RX_FILTERI1ST (((REG32(ADR_CBR_ABB_REGISTER_1)) & 0x00003000 ) >> 12)
#define GET_CBR_RG_RX_FILTERI2ND (((REG32(ADR_CBR_ABB_REGISTER_1)) & 0x0000c000 ) >> 14)
#define GET_CBR_RG_RX_FILTERI3RD (((REG32(ADR_CBR_ABB_REGISTER_1)) & 0x00030000 ) >> 16)
#define GET_CBR_RG_RX_FILTERI_COURSE (((REG32(ADR_CBR_ABB_REGISTER_1)) & 0x000c0000 ) >> 18)
#define GET_CBR_RG_RX_FILTERVCM (((REG32(ADR_CBR_ABB_REGISTER_1)) & 0x00300000 ) >> 20)
#define GET_CBR_RG_RX_HPF3M (((REG32(ADR_CBR_ABB_REGISTER_1)) & 0x00400000 ) >> 22)
#define GET_CBR_RG_RX_HPF300K (((REG32(ADR_CBR_ABB_REGISTER_1)) & 0x00800000 ) >> 23)
#define GET_CBR_RG_RX_HPFI (((REG32(ADR_CBR_ABB_REGISTER_1)) & 0x03000000 ) >> 24)
#define GET_CBR_RG_RX_HPF_FINALCORNER (((REG32(ADR_CBR_ABB_REGISTER_1)) & 0x0c000000 ) >> 26)
#define GET_CBR_RG_RX_HPF_SETTLE1_C (((REG32(ADR_CBR_ABB_REGISTER_1)) & 0x30000000 ) >> 28)
#define GET_CBR_RG_RX_HPF_SETTLE1_R (((REG32(ADR_CBR_ABB_REGISTER_2)) & 0x00000003 ) >> 0)
#define GET_CBR_RG_RX_HPF_SETTLE2_C (((REG32(ADR_CBR_ABB_REGISTER_2)) & 0x0000000c ) >> 2)
#define GET_CBR_RG_RX_HPF_SETTLE2_R (((REG32(ADR_CBR_ABB_REGISTER_2)) & 0x00000030 ) >> 4)
#define GET_CBR_RG_RX_HPF_VCMCON2 (((REG32(ADR_CBR_ABB_REGISTER_2)) & 0x000000c0 ) >> 6)
#define GET_CBR_RG_RX_HPF_VCMCON (((REG32(ADR_CBR_ABB_REGISTER_2)) & 0x00000300 ) >> 8)
#define GET_CBR_RG_RX_OUTVCM (((REG32(ADR_CBR_ABB_REGISTER_2)) & 0x00000c00 ) >> 10)
#define GET_CBR_RG_RX_TZI (((REG32(ADR_CBR_ABB_REGISTER_2)) & 0x00003000 ) >> 12)
#define GET_CBR_RG_RX_TZ_OUT_TRISTATE (((REG32(ADR_CBR_ABB_REGISTER_2)) & 0x00004000 ) >> 14)
#define GET_CBR_RG_RX_TZ_VCM (((REG32(ADR_CBR_ABB_REGISTER_2)) & 0x00018000 ) >> 15)
#define GET_CBR_RG_EN_RX_RSSI_TESTNODE (((REG32(ADR_CBR_ABB_REGISTER_2)) & 0x000e0000 ) >> 17)
#define GET_CBR_RG_RX_ADCRSSI_CLKSEL (((REG32(ADR_CBR_ABB_REGISTER_2)) & 0x00100000 ) >> 20)
#define GET_CBR_RG_RX_ADCRSSI_VCM (((REG32(ADR_CBR_ABB_REGISTER_2)) & 0x00600000 ) >> 21)
#define GET_CBR_RG_RX_REC_LPFCORNER (((REG32(ADR_CBR_ABB_REGISTER_2)) & 0x01800000 ) >> 23)
#define GET_CBR_RG_RSSI_CLOCK_GATING (((REG32(ADR_CBR_ABB_REGISTER_2)) & 0x02000000 ) >> 25)
#define GET_CBR_RG_TXPGA_CAPSW (((REG32(ADR_CBR_TX_FE_REGISTER)) & 0x00000003 ) >> 0)
#define GET_CBR_RG_TXPGA_MAIN (((REG32(ADR_CBR_TX_FE_REGISTER)) & 0x000000fc ) >> 2)
#define GET_CBR_RG_TXPGA_STEER (((REG32(ADR_CBR_TX_FE_REGISTER)) & 0x00003f00 ) >> 8)
#define GET_CBR_RG_TXMOD_GMCELL (((REG32(ADR_CBR_TX_FE_REGISTER)) & 0x0000c000 ) >> 14)
#define GET_CBR_RG_TXLPF_GMCELL (((REG32(ADR_CBR_TX_FE_REGISTER)) & 0x00030000 ) >> 16)
#define GET_CBR_RG_PACELL_EN (((REG32(ADR_CBR_TX_FE_REGISTER)) & 0x001c0000 ) >> 18)
#define GET_CBR_RG_PABIAS_CTRL (((REG32(ADR_CBR_TX_FE_REGISTER)) & 0x01e00000 ) >> 21)
#define GET_CBR_RG_PABIAS_AB (((REG32(ADR_CBR_TX_FE_REGISTER)) & 0x02000000 ) >> 25)
#define GET_CBR_RG_TX_DIV_VSET (((REG32(ADR_CBR_TX_FE_REGISTER)) & 0x0c000000 ) >> 26)
#define GET_CBR_RG_TX_LOBUF_VSET (((REG32(ADR_CBR_TX_FE_REGISTER)) & 0x30000000 ) >> 28)
#define GET_CBR_RG_RX_SQDC (((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0x00000007 ) >> 0)
#define GET_CBR_RG_RX_DIV2_CORE (((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0x00000018 ) >> 3)
#define GET_CBR_RG_RX_LOBUF (((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0x00000060 ) >> 5)
#define GET_CBR_RG_TX_DPDGM_BIAS (((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0x00000780 ) >> 7)
#define GET_CBR_RG_TX_DPD_DIV (((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0x00007800 ) >> 11)
#define GET_CBR_RG_TX_TSSI_BIAS (((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0x00038000 ) >> 15)
#define GET_CBR_RG_TX_TSSI_DIV (((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0x001c0000 ) >> 18)
#define GET_CBR_RG_TX_TSSI_TESTMODE (((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0x00200000 ) >> 21)
#define GET_CBR_RG_TX_TSSI_TEST (((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0x00c00000 ) >> 22)
#define GET_CBR_RG_RX_HG_LNA_GC (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0x00000003 ) >> 0)
#define GET_CBR_RG_RX_HG_LNAHGN_BIAS (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0x0000003c ) >> 2)
#define GET_CBR_RG_RX_HG_LNAHGP_BIAS (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0x000003c0 ) >> 6)
#define GET_CBR_RG_RX_HG_LNALG_BIAS (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0x00003c00 ) >> 10)
#define GET_CBR_RG_RX_HG_TZ_GC (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0x0000c000 ) >> 14)
#define GET_CBR_RG_RX_HG_TZ_CAP (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0x00070000 ) >> 16)
#define GET_CBR_RG_RX_MG_LNA_GC (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0x00000003 ) >> 0)
#define GET_CBR_RG_RX_MG_LNAHGN_BIAS (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0x0000003c ) >> 2)
#define GET_CBR_RG_RX_MG_LNAHGP_BIAS (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0x000003c0 ) >> 6)
#define GET_CBR_RG_RX_MG_LNALG_BIAS (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0x00003c00 ) >> 10)
#define GET_CBR_RG_RX_MG_TZ_GC (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0x0000c000 ) >> 14)
#define GET_CBR_RG_RX_MG_TZ_CAP (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0x00070000 ) >> 16)
#define GET_CBR_RG_RX_LG_LNA_GC (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0x00000003 ) >> 0)
#define GET_CBR_RG_RX_LG_LNAHGN_BIAS (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0x0000003c ) >> 2)
#define GET_CBR_RG_RX_LG_LNAHGP_BIAS (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0x000003c0 ) >> 6)
#define GET_CBR_RG_RX_LG_LNALG_BIAS (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0x00003c00 ) >> 10)
#define GET_CBR_RG_RX_LG_TZ_GC (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0x0000c000 ) >> 14)
#define GET_CBR_RG_RX_LG_TZ_CAP (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0x00070000 ) >> 16)
#define GET_CBR_RG_RX_ULG_LNA_GC (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0x00000003 ) >> 0)
#define GET_CBR_RG_RX_ULG_LNAHGN_BIAS (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0x0000003c ) >> 2)
#define GET_CBR_RG_RX_ULG_LNAHGP_BIAS (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0x000003c0 ) >> 6)
#define GET_CBR_RG_RX_ULG_LNALG_BIAS (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0x00003c00 ) >> 10)
#define GET_CBR_RG_RX_ULG_TZ_GC (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0x0000c000 ) >> 14)
#define GET_CBR_RG_RX_ULG_TZ_CAP (((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0x00070000 ) >> 16)
#define GET_CBR_RG_HPF1_FAST_SET_X (((REG32(ADR_CBR_RX_FSM_REGISTER)) & 0x00000001 ) >> 0)
#define GET_CBR_RG_HPF1_FAST_SET_Y (((REG32(ADR_CBR_RX_FSM_REGISTER)) & 0x00000002 ) >> 1)
#define GET_CBR_RG_HPF1_FAST_SET_Z (((REG32(ADR_CBR_RX_FSM_REGISTER)) & 0x00000004 ) >> 2)
#define GET_CBR_RG_HPF_T1A (((REG32(ADR_CBR_RX_FSM_REGISTER)) & 0x00000018 ) >> 3)
#define GET_CBR_RG_HPF_T1B (((REG32(ADR_CBR_RX_FSM_REGISTER)) & 0x00000060 ) >> 5)
#define GET_CBR_RG_HPF_T1C (((REG32(ADR_CBR_RX_FSM_REGISTER)) & 0x00000180 ) >> 7)
#define GET_CBR_RG_RX_LNA_TRI_SEL (((REG32(ADR_CBR_RX_FSM_REGISTER)) & 0x00000600 ) >> 9)
#define GET_CBR_RG_RX_LNA_SETTLE (((REG32(ADR_CBR_RX_FSM_REGISTER)) & 0x00001800 ) >> 11)
#define GET_CBR_RG_ADC_CLKSEL (((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0x00000001 ) >> 0)
#define GET_CBR_RG_ADC_DIBIAS (((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0x00000006 ) >> 1)
#define GET_CBR_RG_ADC_DIVR (((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0x00000008 ) >> 3)
#define GET_CBR_RG_ADC_DVCMI (((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0x00000030 ) >> 4)
#define GET_CBR_RG_ADC_SAMSEL (((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0x000003c0 ) >> 6)
#define GET_CBR_RG_ADC_STNBY (((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0x00000400 ) >> 10)
#define GET_CBR_RG_ADC_TESTMODE (((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0x00000800 ) >> 11)
#define GET_CBR_RG_ADC_TSEL (((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0x0000f000 ) >> 12)
#define GET_CBR_RG_ADC_VRSEL (((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0x00030000 ) >> 16)
#define GET_CBR_RG_DICMP (((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0x000c0000 ) >> 18)
#define GET_CBR_RG_DIOP (((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0x00300000 ) >> 20)
#define GET_CBR_RG_DACI1ST (((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0x00000003 ) >> 0)
#define GET_CBR_RG_TX_DACLPF_ICOURSE (((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0x0000000c ) >> 2)
#define GET_CBR_RG_TX_DACLPF_IFINE (((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0x00000030 ) >> 4)
#define GET_CBR_RG_TX_DACLPF_VCM (((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0x000000c0 ) >> 6)
#define GET_CBR_RG_TX_DAC_CKEDGE_SEL (((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0x00000100 ) >> 8)
#define GET_CBR_RG_TX_DAC_IBIAS (((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0x00000600 ) >> 9)
#define GET_CBR_RG_TX_DAC_OS (((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0x00003800 ) >> 11)
#define GET_CBR_RG_TX_DAC_RCAL (((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0x0000c000 ) >> 14)
#define GET_CBR_RG_TX_DAC_TSEL (((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0x000f0000 ) >> 16)
#define GET_CBR_RG_TX_EN_VOLTAGE_IN (((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0x00100000 ) >> 20)
#define GET_CBR_RG_TXLPF_BYPASS (((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0x00200000 ) >> 21)
#define GET_CBR_RG_TXLPF_BOOSTI (((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0x00400000 ) >> 22)
#define GET_CBR_RG_EN_SX_R3 (((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0x00000001 ) >> 0)
#define GET_CBR_RG_EN_SX_CH (((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0x00000002 ) >> 1)
#define GET_CBR_RG_EN_SX_CHP (((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0x00000004 ) >> 2)
#define GET_CBR_RG_EN_SX_DIVCK (((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0x00000008 ) >> 3)
#define GET_CBR_RG_EN_SX_VCOBF (((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0x00000010 ) >> 4)
#define GET_CBR_RG_EN_SX_VCO (((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0x00000020 ) >> 5)
#define GET_CBR_RG_EN_SX_MOD (((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0x00000040 ) >> 6)
#define GET_CBR_RG_EN_SX_LCK (((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0x00000080 ) >> 7)
#define GET_CBR_RG_EN_SX_DITHER (((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0x00000100 ) >> 8)
#define GET_CBR_RG_EN_SX_DELCAL (((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0x00000200 ) >> 9)
#define GET_CBR_RG_EN_SX_PC_BYPASS (((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0x00000400 ) >> 10)
#define GET_CBR_RG_EN_SX_VT_MON (((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0x00000800 ) >> 11)
#define GET_CBR_RG_EN_SX_VT_MON_DG (((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0x00001000 ) >> 12)
#define GET_CBR_RG_EN_SX_DIV (((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0x00002000 ) >> 13)
#define GET_CBR_RG_EN_SX_LPF (((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0x00004000 ) >> 14)
#define GET_CBR_RG_SX_RFCTRL_F (((REG32(ADR_CBR_SYN_RGISTER_1)) & 0x00ffffff ) >> 0)
#define GET_CBR_RG_SX_SEL_CP (((REG32(ADR_CBR_SYN_RGISTER_1)) & 0x0f000000 ) >> 24)
#define GET_CBR_RG_SX_SEL_CS (((REG32(ADR_CBR_SYN_RGISTER_1)) & 0xf0000000 ) >> 28)
#define GET_CBR_RG_SX_RFCTRL_CH (((REG32(ADR_CBR_SYN_RGISTER_2)) & 0x000007ff ) >> 0)
#define GET_CBR_RG_SX_SEL_C3 (((REG32(ADR_CBR_SYN_RGISTER_2)) & 0x00007800 ) >> 11)
#define GET_CBR_RG_SX_SEL_RS (((REG32(ADR_CBR_SYN_RGISTER_2)) & 0x000f8000 ) >> 15)
#define GET_CBR_RG_SX_SEL_R3 (((REG32(ADR_CBR_SYN_RGISTER_2)) & 0x01f00000 ) >> 20)
#define GET_CBR_RG_SX_SEL_ICHP (((REG32(ADR_CBR_SYN_PFD_CHP)) & 0x0000001f ) >> 0)
#define GET_CBR_RG_SX_SEL_PCHP (((REG32(ADR_CBR_SYN_PFD_CHP)) & 0x000003e0 ) >> 5)
#define GET_CBR_RG_SX_SEL_CHP_REGOP (((REG32(ADR_CBR_SYN_PFD_CHP)) & 0x00003c00 ) >> 10)
#define GET_CBR_RG_SX_SEL_CHP_UNIOP (((REG32(ADR_CBR_SYN_PFD_CHP)) & 0x0003c000 ) >> 14)
#define GET_CBR_RG_SX_CHP_IOST_POL (((REG32(ADR_CBR_SYN_PFD_CHP)) & 0x00040000 ) >> 18)
#define GET_CBR_RG_SX_CHP_IOST (((REG32(ADR_CBR_SYN_PFD_CHP)) & 0x00380000 ) >> 19)
#define GET_CBR_RG_SX_PFDSEL (((REG32(ADR_CBR_SYN_PFD_CHP)) & 0x00400000 ) >> 22)
#define GET_CBR_RG_SX_PFD_SET (((REG32(ADR_CBR_SYN_PFD_CHP)) & 0x00800000 ) >> 23)
#define GET_CBR_RG_SX_PFD_SET1 (((REG32(ADR_CBR_SYN_PFD_CHP)) & 0x01000000 ) >> 24)
#define GET_CBR_RG_SX_PFD_SET2 (((REG32(ADR_CBR_SYN_PFD_CHP)) & 0x02000000 ) >> 25)
#define GET_CBR_RG_SX_VBNCAS_SEL (((REG32(ADR_CBR_SYN_PFD_CHP)) & 0x04000000 ) >> 26)
#define GET_CBR_RG_SX_PFD_RST_H (((REG32(ADR_CBR_SYN_PFD_CHP)) & 0x08000000 ) >> 27)
#define GET_CBR_RG_SX_PFD_TRUP (((REG32(ADR_CBR_SYN_PFD_CHP)) & 0x10000000 ) >> 28)
#define GET_CBR_RG_SX_PFD_TRDN (((REG32(ADR_CBR_SYN_PFD_CHP)) & 0x20000000 ) >> 29)
#define GET_CBR_RG_SX_PFD_TRSEL (((REG32(ADR_CBR_SYN_PFD_CHP)) & 0x40000000 ) >> 30)
#define GET_CBR_RG_SX_VCOBA_R (((REG32(ADR_CBR_SYN_VCO_LOBF)) & 0x00000007 ) >> 0)
#define GET_CBR_RG_SX_VCORSEL (((REG32(ADR_CBR_SYN_VCO_LOBF)) & 0x000000f8 ) >> 3)
#define GET_CBR_RG_SX_VCOCUSEL (((REG32(ADR_CBR_SYN_VCO_LOBF)) & 0x00000f00 ) >> 8)
#define GET_CBR_RG_SX_RXBFSEL (((REG32(ADR_CBR_SYN_VCO_LOBF)) & 0x0000f000 ) >> 12)
#define GET_CBR_RG_SX_TXBFSEL (((REG32(ADR_CBR_SYN_VCO_LOBF)) & 0x000f0000 ) >> 16)
#define GET_CBR_RG_SX_VCOBFSEL (((REG32(ADR_CBR_SYN_VCO_LOBF)) & 0x00f00000 ) >> 20)
#define GET_CBR_RG_SX_DIVBFSEL (((REG32(ADR_CBR_SYN_VCO_LOBF)) & 0x0f000000 ) >> 24)
#define GET_CBR_RG_SX_GNDR_SEL (((REG32(ADR_CBR_SYN_VCO_LOBF)) & 0xf0000000 ) >> 28)
#define GET_CBR_RG_SX_DITHER_WEIGHT (((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0x00000003 ) >> 0)
#define GET_CBR_RG_SX_MOD_ERRCMP (((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0x0000000c ) >> 2)
#define GET_CBR_RG_SX_MOD_ORDER (((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0x00000030 ) >> 4)
#define GET_CBR_RG_SX_SDM_D1 (((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0x00000040 ) >> 6)
#define GET_CBR_RG_SX_SDM_D2 (((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0x00000080 ) >> 7)
#define GET_CBR_RG_SDM_PASS (((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0x00000100 ) >> 8)
#define GET_CBR_RG_SX_RST_H_DIV (((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0x00000200 ) >> 9)
#define GET_CBR_RG_SX_SDM_EDGE (((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0x00000400 ) >> 10)
#define GET_CBR_RG_SX_XO_GM (((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0x00001800 ) >> 11)
#define GET_CBR_RG_SX_REFBYTWO (((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0x00002000 ) >> 13)
#define GET_CBR_RG_SX_XO_SWCAP (((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0x0003c000 ) >> 14)
#define GET_CBR_RG_SX_SDMLUT_INV (((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0x00040000 ) >> 18)
#define GET_CBR_RG_SX_LCKEN (((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0x00080000 ) >> 19)
#define GET_CBR_RG_SX_PREVDD (((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0x00f00000 ) >> 20)
#define GET_CBR_RG_SX_PSCONTERVDD (((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0x0f000000 ) >> 24)
#define GET_CBR_RG_SX_MOD_ERR_DELAY (((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0x30000000 ) >> 28)
#define GET_CBR_RG_SX_MODDB (((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0x40000000 ) >> 30)
#define GET_CBR_RG_SX_CV_CURVE_SEL (((REG32(ADR_CBR_SYN_LCK1)) & 0x00000003 ) >> 0)
#define GET_CBR_RG_SX_SEL_DELAY (((REG32(ADR_CBR_SYN_LCK1)) & 0x0000007c ) >> 2)
#define GET_CBR_RG_SX_REF_CYCLE (((REG32(ADR_CBR_SYN_LCK1)) & 0x00000780 ) >> 7)
#define GET_CBR_RG_SX_VCOBY16 (((REG32(ADR_CBR_SYN_LCK1)) & 0x00000800 ) >> 11)
#define GET_CBR_RG_SX_VCOBY32 (((REG32(ADR_CBR_SYN_LCK1)) & 0x00001000 ) >> 12)
#define GET_CBR_RG_SX_PH (((REG32(ADR_CBR_SYN_LCK1)) & 0x00002000 ) >> 13)
#define GET_CBR_RG_SX_PL (((REG32(ADR_CBR_SYN_LCK1)) & 0x00004000 ) >> 14)
#define GET_CBR_RG_SX_VT_MON_MODE (((REG32(ADR_CBR_SYN_LCK2)) & 0x00000001 ) >> 0)
#define GET_CBR_RG_SX_VT_TH_HI (((REG32(ADR_CBR_SYN_LCK2)) & 0x00000006 ) >> 1)
#define GET_CBR_RG_SX_VT_TH_LO (((REG32(ADR_CBR_SYN_LCK2)) & 0x00000018 ) >> 3)
#define GET_CBR_RG_SX_VT_SET (((REG32(ADR_CBR_SYN_LCK2)) & 0x00000020 ) >> 5)
#define GET_CBR_RG_SX_VT_MON_TMR (((REG32(ADR_CBR_SYN_LCK2)) & 0x00007fc0 ) >> 6)
#define GET_CBR_RG_IDEAL_CYCLE (((REG32(ADR_CBR_SYN_LCK2)) & 0x0fff8000 ) >> 15)
#define GET_CBR_RG_EN_DP_VT_MON (((REG32(ADR_CBR_DPLL_VCO_REGISTER)) & 0x00000001 ) >> 0)
#define GET_CBR_RG_DP_VT_TH_HI (((REG32(ADR_CBR_DPLL_VCO_REGISTER)) & 0x00000006 ) >> 1)
#define GET_CBR_RG_DP_VT_TH_LO (((REG32(ADR_CBR_DPLL_VCO_REGISTER)) & 0x00000018 ) >> 3)
#define GET_CBR_RG_DP_VT_MON_TMR (((REG32(ADR_CBR_DPLL_VCO_REGISTER)) & 0x00003fe0 ) >> 5)
#define GET_CBR_RG_DP_CK320BY2 (((REG32(ADR_CBR_DPLL_VCO_REGISTER)) & 0x00004000 ) >> 14)
#define GET_CBR_RG_SX_DELCTRL (((REG32(ADR_CBR_DPLL_VCO_REGISTER)) & 0x001f8000 ) >> 15)
#define GET_CBR_RG_DP_OD_TEST (((REG32(ADR_CBR_DPLL_VCO_REGISTER)) & 0x00200000 ) >> 21)
#define GET_CBR_RG_DP_BBPLL_BP (((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0x00000001 ) >> 0)
#define GET_CBR_RG_DP_BBPLL_ICP (((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0x00000006 ) >> 1)
#define GET_CBR_RG_DP_BBPLL_IDUAL (((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0x00000018 ) >> 3)
#define GET_CBR_RG_DP_BBPLL_OD_TEST (((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0x000001e0 ) >> 5)
#define GET_CBR_RG_DP_BBPLL_PD (((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0x00000200 ) >> 9)
#define GET_CBR_RG_DP_BBPLL_TESTSEL (((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0x00001c00 ) >> 10)
#define GET_CBR_RG_DP_BBPLL_PFD_DLY (((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0x00006000 ) >> 13)
#define GET_CBR_RG_DP_RP (((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0x00038000 ) >> 15)
#define GET_CBR_RG_DP_RHP (((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0x000c0000 ) >> 18)
#define GET_CBR_RG_DP_DR3 (((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0x00700000 ) >> 20)
#define GET_CBR_RG_DP_DCP (((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0x07800000 ) >> 23)
#define GET_CBR_RG_DP_DCS (((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0x78000000 ) >> 27)
#define GET_CBR_RG_DP_FBDIV (((REG32(ADR_CBR_DPLL_DIVIDER_REGISTER)) & 0x00000fff ) >> 0)
#define GET_CBR_RG_DP_FODIV (((REG32(ADR_CBR_DPLL_DIVIDER_REGISTER)) & 0x003ff000 ) >> 12)
#define GET_CBR_RG_DP_REFDIV (((REG32(ADR_CBR_DPLL_DIVIDER_REGISTER)) & 0xffc00000 ) >> 22)
#define GET_CBR_RG_IDACAI_PGAG15 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER1)) & 0x0000003f ) >> 0)
#define GET_CBR_RG_IDACAQ_PGAG15 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER1)) & 0x00000fc0 ) >> 6)
#define GET_CBR_RG_IDACAI_PGAG14 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER1)) & 0x0003f000 ) >> 12)
#define GET_CBR_RG_IDACAQ_PGAG14 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER1)) & 0x00fc0000 ) >> 18)
#define GET_CBR_RG_IDACAI_PGAG13 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER2)) & 0x0000003f ) >> 0)
#define GET_CBR_RG_IDACAQ_PGAG13 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER2)) & 0x00000fc0 ) >> 6)
#define GET_CBR_RG_IDACAI_PGAG12 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER2)) & 0x0003f000 ) >> 12)
#define GET_CBR_RG_IDACAQ_PGAG12 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER2)) & 0x00fc0000 ) >> 18)
#define GET_CBR_RG_IDACAI_PGAG11 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER3)) & 0x0000003f ) >> 0)
#define GET_CBR_RG_IDACAQ_PGAG11 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER3)) & 0x00000fc0 ) >> 6)
#define GET_CBR_RG_IDACAI_PGAG10 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER3)) & 0x0003f000 ) >> 12)
#define GET_CBR_RG_IDACAQ_PGAG10 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER3)) & 0x00fc0000 ) >> 18)
#define GET_CBR_RG_IDACAI_PGAG9 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER4)) & 0x0000003f ) >> 0)
#define GET_CBR_RG_IDACAQ_PGAG9 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER4)) & 0x00000fc0 ) >> 6)
#define GET_CBR_RG_IDACAI_PGAG8 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER4)) & 0x0003f000 ) >> 12)
#define GET_CBR_RG_IDACAQ_PGAG8 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER4)) & 0x00fc0000 ) >> 18)
#define GET_CBR_RG_IDACAI_PGAG7 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER5)) & 0x0000003f ) >> 0)
#define GET_CBR_RG_IDACAQ_PGAG7 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER5)) & 0x00000fc0 ) >> 6)
#define GET_CBR_RG_IDACAI_PGAG6 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER5)) & 0x0003f000 ) >> 12)
#define GET_CBR_RG_IDACAQ_PGAG6 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER5)) & 0x00fc0000 ) >> 18)
#define GET_CBR_RG_IDACAI_PGAG5 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER6)) & 0x0000003f ) >> 0)
#define GET_CBR_RG_IDACAQ_PGAG5 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER6)) & 0x00000fc0 ) >> 6)
#define GET_CBR_RG_IDACAI_PGAG4 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER6)) & 0x0003f000 ) >> 12)
#define GET_CBR_RG_IDACAQ_PGAG4 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER6)) & 0x00fc0000 ) >> 18)
#define GET_CBR_RG_IDACAI_PGAG3 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER7)) & 0x0000003f ) >> 0)
#define GET_CBR_RG_IDACAQ_PGAG3 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER7)) & 0x00000fc0 ) >> 6)
#define GET_CBR_RG_IDACAI_PGAG2 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER7)) & 0x0003f000 ) >> 12)
#define GET_CBR_RG_IDACAQ_PGAG2 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER7)) & 0x00fc0000 ) >> 18)
#define GET_CBR_RG_IDACAI_PGAG1 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER8)) & 0x0000003f ) >> 0)
#define GET_CBR_RG_IDACAQ_PGAG1 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER8)) & 0x00000fc0 ) >> 6)
#define GET_CBR_RG_IDACAI_PGAG0 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER8)) & 0x0003f000 ) >> 12)
#define GET_CBR_RG_IDACAQ_PGAG0 (((REG32(ADR_CBR_DCOC_IDAC_REGISTER8)) & 0x00fc0000 ) >> 18)
#define GET_CBR_RG_EN_RCAL (((REG32(ADR_CBR_RCAL_REGISTER)) & 0x00000001 ) >> 0)
#define GET_CBR_RG_RCAL_SPD (((REG32(ADR_CBR_RCAL_REGISTER)) & 0x00000002 ) >> 1)
#define GET_CBR_RG_RCAL_TMR (((REG32(ADR_CBR_RCAL_REGISTER)) & 0x000001fc ) >> 2)
#define GET_CBR_RG_RCAL_CODE_CWR (((REG32(ADR_CBR_RCAL_REGISTER)) & 0x00000200 ) >> 9)
#define GET_CBR_RG_RCAL_CODE_CWD (((REG32(ADR_CBR_RCAL_REGISTER)) & 0x00007c00 ) >> 10)
#define GET_CBR_RG_SX_SUB_SEL_CWR (((REG32(ADR_CBR_MANUAL_REGISTER)) & 0x00000001 ) >> 0)
#define GET_CBR_RG_SX_SUB_SEL_CWD (((REG32(ADR_CBR_MANUAL_REGISTER)) & 0x000000fe ) >> 1)
#define GET_CBR_RG_DP_BBPLL_BS_CWR (((REG32(ADR_CBR_MANUAL_REGISTER)) & 0x00000100 ) >> 8)
#define GET_CBR_RG_DP_BBPLL_BS_CWD (((REG32(ADR_CBR_MANUAL_REGISTER)) & 0x00007e00 ) >> 9)
#define GET_CBR_RCAL_RDY (((REG32(ADR_CBR_READ_ONLY_FLAGS_1)) & 0x00000001 ) >> 0)
#define GET_CBR_DA_LCK_RDY (((REG32(ADR_CBR_READ_ONLY_FLAGS_1)) & 0x00000002 ) >> 1)
#define GET_CBR_VT_MON_RDY (((REG32(ADR_CBR_READ_ONLY_FLAGS_1)) & 0x00000004 ) >> 2)
#define GET_CBR_DP_VT_MON_RDY (((REG32(ADR_CBR_READ_ONLY_FLAGS_1)) & 0x00000008 ) >> 3)
#define GET_CBR_CH_RDY (((REG32(ADR_CBR_READ_ONLY_FLAGS_1)) & 0x00000010 ) >> 4)
#define GET_CBR_DA_R_CODE_LUT (((REG32(ADR_CBR_READ_ONLY_FLAGS_1)) & 0x000007c0 ) >> 6)
#define GET_CBR_AD_SX_VT_MON_Q (((REG32(ADR_CBR_READ_ONLY_FLAGS_1)) & 0x00001800 ) >> 11)
#define GET_CBR_AD_DP_VT_MON_Q (((REG32(ADR_CBR_READ_ONLY_FLAGS_1)) & 0x00006000 ) >> 13)
#define GET_CBR_DA_R_CAL_CODE (((REG32(ADR_CBR_READ_ONLY_FLAGS_2)) & 0x0000001f ) >> 0)
#define GET_CBR_DA_SX_SUB_SEL (((REG32(ADR_CBR_READ_ONLY_FLAGS_2)) & 0x00000fe0 ) >> 5)
#define GET_CBR_DA_DP_BBPLL_BS (((REG32(ADR_CBR_READ_ONLY_FLAGS_2)) & 0x0003f000 ) >> 12)
#define GET_CBR_TX_EN (((REG32(ADR_CBR_RG_PKT_GEN_0)) & 0x00000001 ) >> 0)
#define GET_CBR_TX_CNT_RST (((REG32(ADR_CBR_RG_PKT_GEN_0)) & 0x00000002 ) >> 1)
#define GET_CBR_IFS_TIME (((REG32(ADR_CBR_RG_PKT_GEN_0)) & 0x000000fc ) >> 2)
#define GET_CBR_LENGTH_TARGET (((REG32(ADR_CBR_RG_PKT_GEN_0)) & 0x000fff00 ) >> 8)
#define GET_CBR_TX_CNT_TARGET (((REG32(ADR_CBR_RG_PKT_GEN_0)) & 0xff000000 ) >> 24)
#define GET_CBR_TC_CNT_TARGET (((REG32(ADR_CBR_RG_PKT_GEN_1)) & 0x00ffffff ) >> 0)
#define GET_CBR_PLCP_PSDU_DATA_MEM (((REG32(ADR_CBR_RG_PKT_GEN_2)) & 0x000000ff ) >> 0)
#define GET_CBR_PLCP_PSDU_PREAMBLE_SHORT (((REG32(ADR_CBR_RG_PKT_GEN_2)) & 0x00000100 ) >> 8)
#define GET_CBR_PLCP_BYTE_LENGTH (((REG32(ADR_CBR_RG_PKT_GEN_2)) & 0x001ffe00 ) >> 9)
#define GET_CBR_PLCP_PSDU_RATE (((REG32(ADR_CBR_RG_PKT_GEN_2)) & 0x00600000 ) >> 21)
#define GET_CBR_TAIL_TIME (((REG32(ADR_CBR_RG_PKT_GEN_2)) & 0x1f800000 ) >> 23)
#define GET_CBR_RG_O_PAD_PD (((REG32(ADR_CBR_RG_INTEGRATION)) & 0x00000001 ) >> 0)
#define GET_CBR_RG_I_PAD_PD (((REG32(ADR_CBR_RG_INTEGRATION)) & 0x00000002 ) >> 1)
#define GET_CBR_SEL_ADCKP_INV (((REG32(ADR_CBR_RG_INTEGRATION)) & 0x00000004 ) >> 2)
#define GET_CBR_RG_PAD_DS (((REG32(ADR_CBR_RG_INTEGRATION)) & 0x00000008 ) >> 3)
#define GET_CBR_SEL_ADCKP_MUX (((REG32(ADR_CBR_RG_INTEGRATION)) & 0x00000010 ) >> 4)
#define GET_CBR_RG_PAD_DS_CLK (((REG32(ADR_CBR_RG_INTEGRATION)) & 0x00000020 ) >> 5)
#define GET_CBR_INTP_SEL (((REG32(ADR_CBR_RG_INTEGRATION)) & 0x00000200 ) >> 9)
#define GET_CBR_IQ_SWP (((REG32(ADR_CBR_RG_INTEGRATION)) & 0x00000400 ) >> 10)
#define GET_CBR_RG_EN_EXT_DA (((REG32(ADR_CBR_RG_INTEGRATION)) & 0x00000800 ) >> 11)
#define GET_CBR_RG_DIS_DA_OFFSET (((REG32(ADR_CBR_RG_INTEGRATION)) & 0x00001000 ) >> 12)
#define GET_CBR_DBG_SEL (((REG32(ADR_CBR_RG_INTEGRATION)) & 0x000f0000 ) >> 16)
#define GET_CBR_DBG_EN (((REG32(ADR_CBR_RG_INTEGRATION)) & 0x00100000 ) >> 20)
#define GET_CBR_RG_PKT_GEN_TX_CNT (((REG32(ADR_CBR_RG_PKT_GEN_TXCNT)) & 0xffffffff ) >> 0)
#define GET_CBR_TP_SEL (((REG32(ADR_CBR_PATTERN_GEN)) & 0x0000001f ) >> 0)
#define GET_CBR_IDEAL_IQ_EN (((REG32(ADR_CBR_PATTERN_GEN)) & 0x00000020 ) >> 5)
#define GET_CBR_DATA_OUT_SEL (((REG32(ADR_CBR_PATTERN_GEN)) & 0x000001c0 ) >> 6)
#define GET_CBR_TWO_TONE_EN (((REG32(ADR_CBR_PATTERN_GEN)) & 0x00000200 ) >> 9)
#define GET_CBR_FREQ_SEL (((REG32(ADR_CBR_PATTERN_GEN)) & 0x00ff0000 ) >> 16)
#define GET_CBR_IQ_SCALE (((REG32(ADR_CBR_PATTERN_GEN)) & 0xff000000 ) >> 24)
#define GET_CPU_QUE_POP (((REG32(ADR_MB_CPU_INT)) & 0x00000001 ) >> 0)
#define GET_CPU_INT (((REG32(ADR_MB_CPU_INT)) & 0x00000004 ) >> 2)
#define GET_CPU_ID_TB0 (((REG32(ADR_CPU_ID_TB0)) & 0xffffffff ) >> 0)
#define GET_CPU_ID_TB1 (((REG32(ADR_CPU_ID_TB1)) & 0xffffffff ) >> 0)
#define GET_HW_PKTID (((REG32(ADR_CH0_TRIG_1)) & 0x000007ff ) >> 0)
#define GET_CH0_INT_ADDR (((REG32(ADR_CH0_TRIG_0)) & 0xffffffff ) >> 0)
#define GET_PRI_HW_PKTID (((REG32(ADR_CH0_PRI_TRIG)) & 0x000007ff ) >> 0)
#define GET_CH0_FULL (((REG32(ADR_MCU_STATUS)) & 0x00000001 ) >> 0)
#define GET_FF0_EMPTY (((REG32(ADR_MCU_STATUS)) & 0x00000002 ) >> 1)
#define GET_RLS_BUSY (((REG32(ADR_MCU_STATUS)) & 0x00000200 ) >> 9)
#define GET_RLS_COUNT_CLR (((REG32(ADR_MCU_STATUS)) & 0x00000400 ) >> 10)
#define GET_RTN_COUNT_CLR (((REG32(ADR_MCU_STATUS)) & 0x00000800 ) >> 11)
#define GET_RLS_COUNT (((REG32(ADR_MCU_STATUS)) & 0x00ff0000 ) >> 16)
#define GET_RTN_COUNT (((REG32(ADR_MCU_STATUS)) & 0xff000000 ) >> 24)
#define GET_FF0_CNT (((REG32(ADR_RD_IN_FFCNT1)) & 0x0000001f ) >> 0)
#define GET_FF1_CNT (((REG32(ADR_RD_IN_FFCNT1)) & 0x000001e0 ) >> 5)
#define GET_FF3_CNT (((REG32(ADR_RD_IN_FFCNT1)) & 0x00003800 ) >> 11)
#define GET_FF5_CNT (((REG32(ADR_RD_IN_FFCNT1)) & 0x000e0000 ) >> 17)
#define GET_FF6_CNT (((REG32(ADR_RD_IN_FFCNT1)) & 0x00700000 ) >> 20)
#define GET_FF7_CNT (((REG32(ADR_RD_IN_FFCNT1)) & 0x03800000 ) >> 23)
#define GET_FF8_CNT (((REG32(ADR_RD_IN_FFCNT1)) & 0x1c000000 ) >> 26)
#define GET_FF9_CNT (((REG32(ADR_RD_IN_FFCNT1)) & 0xe0000000 ) >> 29)
#define GET_FF10_CNT (((REG32(ADR_RD_IN_FFCNT2)) & 0x00000007 ) >> 0)
#define GET_FF11_CNT (((REG32(ADR_RD_IN_FFCNT2)) & 0x00000038 ) >> 3)
#define GET_FF12_CNT (((REG32(ADR_RD_IN_FFCNT2)) & 0x000001c0 ) >> 6)
#define GET_FF13_CNT (((REG32(ADR_RD_IN_FFCNT2)) & 0x00000600 ) >> 9)
#define GET_FF14_CNT (((REG32(ADR_RD_IN_FFCNT2)) & 0x00001800 ) >> 11)
#define GET_FF15_CNT (((REG32(ADR_RD_IN_FFCNT2)) & 0x00006000 ) >> 13)
#define GET_FF4_CNT (((REG32(ADR_RD_IN_FFCNT2)) & 0x000f8000 ) >> 15)
#define GET_FF2_CNT (((REG32(ADR_RD_IN_FFCNT2)) & 0x00700000 ) >> 20)
#define GET_CH1_FULL (((REG32(ADR_RD_FFIN_FULL)) & 0x00000002 ) >> 1)
#define GET_CH2_FULL (((REG32(ADR_RD_FFIN_FULL)) & 0x00000004 ) >> 2)
#define GET_CH3_FULL (((REG32(ADR_RD_FFIN_FULL)) & 0x00000008 ) >> 3)
#define GET_CH4_FULL (((REG32(ADR_RD_FFIN_FULL)) & 0x00000010 ) >> 4)
#define GET_CH5_FULL (((REG32(ADR_RD_FFIN_FULL)) & 0x00000020 ) >> 5)
#define GET_CH6_FULL (((REG32(ADR_RD_FFIN_FULL)) & 0x00000040 ) >> 6)
#define GET_CH7_FULL (((REG32(ADR_RD_FFIN_FULL)) & 0x00000080 ) >> 7)
#define GET_CH8_FULL (((REG32(ADR_RD_FFIN_FULL)) & 0x00000100 ) >> 8)
#define GET_CH9_FULL (((REG32(ADR_RD_FFIN_FULL)) & 0x00000200 ) >> 9)
#define GET_CH10_FULL (((REG32(ADR_RD_FFIN_FULL)) & 0x00000400 ) >> 10)
#define GET_CH11_FULL (((REG32(ADR_RD_FFIN_FULL)) & 0x00000800 ) >> 11)
#define GET_CH12_FULL (((REG32(ADR_RD_FFIN_FULL)) & 0x00001000 ) >> 12)
#define GET_CH13_FULL (((REG32(ADR_RD_FFIN_FULL)) & 0x00002000 ) >> 13)
#define GET_CH14_FULL (((REG32(ADR_RD_FFIN_FULL)) & 0x00004000 ) >> 14)
#define GET_CH15_FULL (((REG32(ADR_RD_FFIN_FULL)) & 0x00008000 ) >> 15)
#define GET_HALT_CH0 (((REG32(ADR_MBOX_HALT_CFG)) & 0x00000001 ) >> 0)
#define GET_HALT_CH1 (((REG32(ADR_MBOX_HALT_CFG)) & 0x00000002 ) >> 1)
#define GET_HALT_CH2 (((REG32(ADR_MBOX_HALT_CFG)) & 0x00000004 ) >> 2)
#define GET_HALT_CH3 (((REG32(ADR_MBOX_HALT_CFG)) & 0x00000008 ) >> 3)
#define GET_HALT_CH4 (((REG32(ADR_MBOX_HALT_CFG)) & 0x00000010 ) >> 4)
#define GET_HALT_CH5 (((REG32(ADR_MBOX_HALT_CFG)) & 0x00000020 ) >> 5)
#define GET_HALT_CH6 (((REG32(ADR_MBOX_HALT_CFG)) & 0x00000040 ) >> 6)
#define GET_HALT_CH7 (((REG32(ADR_MBOX_HALT_CFG)) & 0x00000080 ) >> 7)
#define GET_HALT_CH8 (((REG32(ADR_MBOX_HALT_CFG)) & 0x00000100 ) >> 8)
#define GET_HALT_CH9 (((REG32(ADR_MBOX_HALT_CFG)) & 0x00000200 ) >> 9)
#define GET_HALT_CH10 (((REG32(ADR_MBOX_HALT_CFG)) & 0x00000400 ) >> 10)
#define GET_HALT_CH11 (((REG32(ADR_MBOX_HALT_CFG)) & 0x00000800 ) >> 11)
#define GET_HALT_CH12 (((REG32(ADR_MBOX_HALT_CFG)) & 0x00001000 ) >> 12)
#define GET_HALT_CH13 (((REG32(ADR_MBOX_HALT_CFG)) & 0x00002000 ) >> 13)
#define GET_HALT_CH14 (((REG32(ADR_MBOX_HALT_CFG)) & 0x00004000 ) >> 14)
#define GET_HALT_CH15 (((REG32(ADR_MBOX_HALT_CFG)) & 0x00008000 ) >> 15)
#define GET_STOP_MBOX (((REG32(ADR_MBOX_HALT_CFG)) & 0x00010000 ) >> 16)
#define GET_MB_ERR_AUTO_HALT_EN (((REG32(ADR_MBOX_HALT_CFG)) & 0x00100000 ) >> 20)
#define GET_MB_EXCEPT_CLR (((REG32(ADR_MBOX_HALT_CFG)) & 0x00200000 ) >> 21)
#define GET_MB_EXCEPT_CASE (((REG32(ADR_MBOX_HALT_CFG)) & 0xff000000 ) >> 24)
#define GET_MB_DBG_TIME_STEP (((REG32(ADR_MB_DBG_CFG1)) & 0x0000ffff ) >> 0)
#define GET_DBG_TYPE (((REG32(ADR_MB_DBG_CFG1)) & 0x00030000 ) >> 16)
#define GET_MB_DBG_CLR (((REG32(ADR_MB_DBG_CFG1)) & 0x00040000 ) >> 18)
#define GET_DBG_ALC_LOG_EN (((REG32(ADR_MB_DBG_CFG1)) & 0x00080000 ) >> 19)
#define GET_MB_DBG_COUNTER_EN (((REG32(ADR_MB_DBG_CFG1)) & 0x01000000 ) >> 24)
#define GET_MB_DBG_EN (((REG32(ADR_MB_DBG_CFG1)) & 0x80000000 ) >> 31)
#define GET_MB_DBG_RECORD_CNT (((REG32(ADR_MB_DBG_CFG2)) & 0x0000ffff ) >> 0)
#define GET_MB_DBG_LENGTH (((REG32(ADR_MB_DBG_CFG2)) & 0xffff0000 ) >> 16)
#define GET_MB_DBG_CFG_ADDR (((REG32(ADR_MB_DBG_CFG3)) & 0xffffffff ) >> 0)
#define GET_DBG_HWID0_WR_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00000001 ) >> 0)
#define GET_DBG_HWID1_WR_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00000002 ) >> 1)
#define GET_DBG_HWID2_WR_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00000004 ) >> 2)
#define GET_DBG_HWID3_WR_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00000008 ) >> 3)
#define GET_DBG_HWID4_WR_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00000010 ) >> 4)
#define GET_DBG_HWID5_WR_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00000020 ) >> 5)
#define GET_DBG_HWID6_WR_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00000040 ) >> 6)
#define GET_DBG_HWID7_WR_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00000080 ) >> 7)
#define GET_DBG_HWID8_WR_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00000100 ) >> 8)
#define GET_DBG_HWID9_WR_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00000200 ) >> 9)
#define GET_DBG_HWID10_WR_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00000400 ) >> 10)
#define GET_DBG_HWID11_WR_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00000800 ) >> 11)
#define GET_DBG_HWID12_WR_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00001000 ) >> 12)
#define GET_DBG_HWID13_WR_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00002000 ) >> 13)
#define GET_DBG_HWID14_WR_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00004000 ) >> 14)
#define GET_DBG_HWID15_WR_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00008000 ) >> 15)
#define GET_DBG_HWID0_RD_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00010000 ) >> 16)
#define GET_DBG_HWID1_RD_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00020000 ) >> 17)
#define GET_DBG_HWID2_RD_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00040000 ) >> 18)
#define GET_DBG_HWID3_RD_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00080000 ) >> 19)
#define GET_DBG_HWID4_RD_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00100000 ) >> 20)
#define GET_DBG_HWID5_RD_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00200000 ) >> 21)
#define GET_DBG_HWID6_RD_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00400000 ) >> 22)
#define GET_DBG_HWID7_RD_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x00800000 ) >> 23)
#define GET_DBG_HWID8_RD_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x01000000 ) >> 24)
#define GET_DBG_HWID9_RD_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x02000000 ) >> 25)
#define GET_DBG_HWID10_RD_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x04000000 ) >> 26)
#define GET_DBG_HWID11_RD_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x08000000 ) >> 27)
#define GET_DBG_HWID12_RD_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x10000000 ) >> 28)
#define GET_DBG_HWID13_RD_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x20000000 ) >> 29)
#define GET_DBG_HWID14_RD_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x40000000 ) >> 30)
#define GET_DBG_HWID15_RD_EN (((REG32(ADR_MB_DBG_CFG4)) & 0x80000000 ) >> 31)
#define GET_MB_OUT_QUEUE_EN (((REG32(ADR_MB_OUT_QUEUE_CFG)) & 0x00000002 ) >> 1)
#define GET_CH0_QUEUE_FLUSH (((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0x00000001 ) >> 0)
#define GET_CH1_QUEUE_FLUSH (((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0x00000002 ) >> 1)
#define GET_CH2_QUEUE_FLUSH (((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0x00000004 ) >> 2)
#define GET_CH3_QUEUE_FLUSH (((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0x00000008 ) >> 3)
#define GET_CH4_QUEUE_FLUSH (((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0x00000010 ) >> 4)
#define GET_CH5_QUEUE_FLUSH (((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0x00000020 ) >> 5)
#define GET_CH6_QUEUE_FLUSH (((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0x00000040 ) >> 6)
#define GET_CH7_QUEUE_FLUSH (((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0x00000080 ) >> 7)
#define GET_CH8_QUEUE_FLUSH (((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0x00000100 ) >> 8)
#define GET_CH9_QUEUE_FLUSH (((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0x00000200 ) >> 9)
#define GET_CH10_QUEUE_FLUSH (((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0x00000400 ) >> 10)
#define GET_CH11_QUEUE_FLUSH (((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0x00000800 ) >> 11)
#define GET_CH12_QUEUE_FLUSH (((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0x00001000 ) >> 12)
#define GET_CH13_QUEUE_FLUSH (((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0x00002000 ) >> 13)
#define GET_CH14_QUEUE_FLUSH (((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0x00004000 ) >> 14)
#define GET_CH15_QUEUE_FLUSH (((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0x00008000 ) >> 15)
#define GET_FFO0_CNT (((REG32(ADR_RD_FFOUT_CNT1)) & 0x0000001f ) >> 0)
#define GET_FFO1_CNT (((REG32(ADR_RD_FFOUT_CNT1)) & 0x000003e0 ) >> 5)
#define GET_FFO2_CNT (((REG32(ADR_RD_FFOUT_CNT1)) & 0x00000c00 ) >> 10)
#define GET_FFO3_CNT (((REG32(ADR_RD_FFOUT_CNT1)) & 0x000f8000 ) >> 15)
#define GET_FFO4_CNT (((REG32(ADR_RD_FFOUT_CNT1)) & 0x00300000 ) >> 20)
#define GET_FFO5_CNT (((REG32(ADR_RD_FFOUT_CNT1)) & 0x0e000000 ) >> 25)
#define GET_FFO6_CNT (((REG32(ADR_RD_FFOUT_CNT2)) & 0x0000000f ) >> 0)
#define GET_FFO7_CNT (((REG32(ADR_RD_FFOUT_CNT2)) & 0x000003e0 ) >> 5)
#define GET_FFO8_CNT (((REG32(ADR_RD_FFOUT_CNT2)) & 0x00007c00 ) >> 10)
#define GET_FFO9_CNT (((REG32(ADR_RD_FFOUT_CNT2)) & 0x000f8000 ) >> 15)
#define GET_FFO10_CNT (((REG32(ADR_RD_FFOUT_CNT2)) & 0x00f00000 ) >> 20)
#define GET_FFO11_CNT (((REG32(ADR_RD_FFOUT_CNT2)) & 0x3e000000 ) >> 25)
#define GET_FFO12_CNT (((REG32(ADR_RD_FFOUT_CNT3)) & 0x00000007 ) >> 0)
#define GET_FFO13_CNT (((REG32(ADR_RD_FFOUT_CNT3)) & 0x00000060 ) >> 5)
#define GET_FFO14_CNT (((REG32(ADR_RD_FFOUT_CNT3)) & 0x00000c00 ) >> 10)
#define GET_FFO15_CNT (((REG32(ADR_RD_FFOUT_CNT3)) & 0x001f8000 ) >> 15)
#define GET_CH0_FFO_FULL (((REG32(ADR_RD_FFOUT_FULL)) & 0x00000001 ) >> 0)
#define GET_CH1_FFO_FULL (((REG32(ADR_RD_FFOUT_FULL)) & 0x00000002 ) >> 1)
#define GET_CH2_FFO_FULL (((REG32(ADR_RD_FFOUT_FULL)) & 0x00000004 ) >> 2)
#define GET_CH3_FFO_FULL (((REG32(ADR_RD_FFOUT_FULL)) & 0x00000008 ) >> 3)
#define GET_CH4_FFO_FULL (((REG32(ADR_RD_FFOUT_FULL)) & 0x00000010 ) >> 4)
#define GET_CH5_FFO_FULL (((REG32(ADR_RD_FFOUT_FULL)) & 0x00000020 ) >> 5)
#define GET_CH6_FFO_FULL (((REG32(ADR_RD_FFOUT_FULL)) & 0x00000040 ) >> 6)
#define GET_CH7_FFO_FULL (((REG32(ADR_RD_FFOUT_FULL)) & 0x00000080 ) >> 7)
#define GET_CH8_FFO_FULL (((REG32(ADR_RD_FFOUT_FULL)) & 0x00000100 ) >> 8)
#define GET_CH9_FFO_FULL (((REG32(ADR_RD_FFOUT_FULL)) & 0x00000200 ) >> 9)
#define GET_CH10_FFO_FULL (((REG32(ADR_RD_FFOUT_FULL)) & 0x00000400 ) >> 10)
#define GET_CH11_FFO_FULL (((REG32(ADR_RD_FFOUT_FULL)) & 0x00000800 ) >> 11)
#define GET_CH12_FFO_FULL (((REG32(ADR_RD_FFOUT_FULL)) & 0x00001000 ) >> 12)
#define GET_CH13_FFO_FULL (((REG32(ADR_RD_FFOUT_FULL)) & 0x00002000 ) >> 13)
#define GET_CH14_FFO_FULL (((REG32(ADR_RD_FFOUT_FULL)) & 0x00004000 ) >> 14)
#define GET_CH15_FFO_FULL (((REG32(ADR_RD_FFOUT_FULL)) & 0x00008000 ) >> 15)
#define GET_CH0_LOWTHOLD_INT (((REG32(ADR_MB_THRESHOLD6)) & 0x00000001 ) >> 0)
#define GET_CH1_LOWTHOLD_INT (((REG32(ADR_MB_THRESHOLD6)) & 0x00000002 ) >> 1)
#define GET_CH2_LOWTHOLD_INT (((REG32(ADR_MB_THRESHOLD6)) & 0x00000004 ) >> 2)
#define GET_CH3_LOWTHOLD_INT (((REG32(ADR_MB_THRESHOLD6)) & 0x00000008 ) >> 3)
#define GET_CH4_LOWTHOLD_INT (((REG32(ADR_MB_THRESHOLD6)) & 0x00000010 ) >> 4)
#define GET_CH5_LOWTHOLD_INT (((REG32(ADR_MB_THRESHOLD6)) & 0x00000020 ) >> 5)
#define GET_CH6_LOWTHOLD_INT (((REG32(ADR_MB_THRESHOLD6)) & 0x00000040 ) >> 6)
#define GET_CH7_LOWTHOLD_INT (((REG32(ADR_MB_THRESHOLD6)) & 0x00000080 ) >> 7)
#define GET_CH8_LOWTHOLD_INT (((REG32(ADR_MB_THRESHOLD6)) & 0x00000100 ) >> 8)
#define GET_CH9_LOWTHOLD_INT (((REG32(ADR_MB_THRESHOLD6)) & 0x00000200 ) >> 9)
#define GET_CH10_LOWTHOLD_INT (((REG32(ADR_MB_THRESHOLD6)) & 0x00000400 ) >> 10)
#define GET_CH11_LOWTHOLD_INT (((REG32(ADR_MB_THRESHOLD6)) & 0x00000800 ) >> 11)
#define GET_CH12_LOWTHOLD_INT (((REG32(ADR_MB_THRESHOLD6)) & 0x00001000 ) >> 12)
#define GET_CH13_LOWTHOLD_INT (((REG32(ADR_MB_THRESHOLD6)) & 0x00002000 ) >> 13)
#define GET_CH14_LOWTHOLD_INT (((REG32(ADR_MB_THRESHOLD6)) & 0x00004000 ) >> 14)
#define GET_CH15_LOWTHOLD_INT (((REG32(ADR_MB_THRESHOLD6)) & 0x00008000 ) >> 15)
#define GET_MB_LOW_THOLD_EN (((REG32(ADR_MB_THRESHOLD6)) & 0x80000000 ) >> 31)
#define GET_CH0_LOWTHOLD (((REG32(ADR_MB_THRESHOLD7)) & 0x0000001f ) >> 0)
#define GET_CH1_LOWTHOLD (((REG32(ADR_MB_THRESHOLD7)) & 0x00001f00 ) >> 8)
#define GET_CH2_LOWTHOLD (((REG32(ADR_MB_THRESHOLD7)) & 0x001f0000 ) >> 16)
#define GET_CH3_LOWTHOLD (((REG32(ADR_MB_THRESHOLD7)) & 0x1f000000 ) >> 24)
#define GET_CH4_LOWTHOLD (((REG32(ADR_MB_THRESHOLD8)) & 0x0000001f ) >> 0)
#define GET_CH5_LOWTHOLD (((REG32(ADR_MB_THRESHOLD8)) & 0x00001f00 ) >> 8)
#define GET_CH6_LOWTHOLD (((REG32(ADR_MB_THRESHOLD8)) & 0x001f0000 ) >> 16)
#define GET_CH7_LOWTHOLD (((REG32(ADR_MB_THRESHOLD8)) & 0x1f000000 ) >> 24)
#define GET_CH8_LOWTHOLD (((REG32(ADR_MB_THRESHOLD9)) & 0x0000001f ) >> 0)
#define GET_CH9_LOWTHOLD (((REG32(ADR_MB_THRESHOLD9)) & 0x00001f00 ) >> 8)
#define GET_CH10_LOWTHOLD (((REG32(ADR_MB_THRESHOLD9)) & 0x001f0000 ) >> 16)
#define GET_CH11_LOWTHOLD (((REG32(ADR_MB_THRESHOLD9)) & 0x1f000000 ) >> 24)
#define GET_CH12_LOWTHOLD (((REG32(ADR_MB_THRESHOLD10)) & 0x0000001f ) >> 0)
#define GET_CH13_LOWTHOLD (((REG32(ADR_MB_THRESHOLD10)) & 0x00001f00 ) >> 8)
#define GET_CH14_LOWTHOLD (((REG32(ADR_MB_THRESHOLD10)) & 0x001f0000 ) >> 16)
#define GET_CH15_LOWTHOLD (((REG32(ADR_MB_THRESHOLD10)) & 0x1f000000 ) >> 24)
#define GET_TRASH_TIMEOUT_EN (((REG32(ADR_MB_TRASH_CFG)) & 0x00000001 ) >> 0)
#define GET_TRASH_CAN_INT (((REG32(ADR_MB_TRASH_CFG)) & 0x00000002 ) >> 1)
#define GET_TRASH_INT_ID (((REG32(ADR_MB_TRASH_CFG)) & 0x000007f0 ) >> 4)
#define GET_TRASH_TIMEOUT (((REG32(ADR_MB_TRASH_CFG)) & 0x03ff0000 ) >> 16)
#define GET_CH0_WRFF_FLUSH (((REG32(ADR_MB_IN_FF_FLUSH)) & 0x00000001 ) >> 0)
#define GET_CH1_WRFF_FLUSH (((REG32(ADR_MB_IN_FF_FLUSH)) & 0x00000002 ) >> 1)
#define GET_CH2_WRFF_FLUSH (((REG32(ADR_MB_IN_FF_FLUSH)) & 0x00000004 ) >> 2)
#define GET_CH3_WRFF_FLUSH (((REG32(ADR_MB_IN_FF_FLUSH)) & 0x00000008 ) >> 3)
#define GET_CH4_WRFF_FLUSH (((REG32(ADR_MB_IN_FF_FLUSH)) & 0x00000010 ) >> 4)
#define GET_CH5_WRFF_FLUSH (((REG32(ADR_MB_IN_FF_FLUSH)) & 0x00000020 ) >> 5)
#define GET_CH6_WRFF_FLUSH (((REG32(ADR_MB_IN_FF_FLUSH)) & 0x00000040 ) >> 6)
#define GET_CH7_WRFF_FLUSH (((REG32(ADR_MB_IN_FF_FLUSH)) & 0x00000080 ) >> 7)
#define GET_CH8_WRFF_FLUSH (((REG32(ADR_MB_IN_FF_FLUSH)) & 0x00000100 ) >> 8)
#define GET_CH9_WRFF_FLUSH (((REG32(ADR_MB_IN_FF_FLUSH)) & 0x00000200 ) >> 9)
#define GET_CH10_WRFF_FLUSH (((REG32(ADR_MB_IN_FF_FLUSH)) & 0x00000400 ) >> 10)
#define GET_CH11_WRFF_FLUSH (((REG32(ADR_MB_IN_FF_FLUSH)) & 0x00000800 ) >> 11)
#define GET_CH12_WRFF_FLUSH (((REG32(ADR_MB_IN_FF_FLUSH)) & 0x00001000 ) >> 12)
#define GET_CH13_WRFF_FLUSH (((REG32(ADR_MB_IN_FF_FLUSH)) & 0x00002000 ) >> 13)
#define GET_CH14_WRFF_FLUSH (((REG32(ADR_MB_IN_FF_FLUSH)) & 0x00004000 ) >> 14)
#define GET_CPU_ID_TB2 (((REG32(ADR_CPU_ID_TB2)) & 0xffffffff ) >> 0)
#define GET_CPU_ID_TB3 (((REG32(ADR_CPU_ID_TB3)) & 0xffffffff ) >> 0)
#define GET_IQ_LOG_EN (((REG32(ADR_PHY_IQ_LOG_CFG0)) & 0x00000001 ) >> 0)
#define GET_IQ_LOG_STOP_MODE (((REG32(ADR_PHY_IQ_LOG_CFG1)) & 0x00000001 ) >> 0)
#define GET_GPIO_STOP_EN (((REG32(ADR_PHY_IQ_LOG_CFG1)) & 0x00000010 ) >> 4)
#define GET_GPIO_STOP_POL (((REG32(ADR_PHY_IQ_LOG_CFG1)) & 0x00000020 ) >> 5)
#define GET_IQ_LOG_TIMER (((REG32(ADR_PHY_IQ_LOG_CFG1)) & 0xffff0000 ) >> 16)
#define GET_IQ_LOG_LEN (((REG32(ADR_PHY_IQ_LOG_LEN)) & 0x0000ffff ) >> 0)
#define GET_IQ_LOG_TAIL_ADR (((REG32(ADR_PHY_IQ_LOG_PTR)) & 0x0000ffff ) >> 0)
#define GET_ALC_LENG (((REG32(ADR_WR_ALC)) & 0x0003ffff ) >> 0)
#define GET_CH0_DYN_PRI (((REG32(ADR_WR_ALC)) & 0x00300000 ) >> 20)
#define GET_MCU_PKTID (((REG32(ADR_GETID)) & 0xffffffff ) >> 0)
#define GET_CH0_STA_PRI (((REG32(ADR_CH_STA_PRI)) & 0x00000003 ) >> 0)
#define GET_CH1_STA_PRI (((REG32(ADR_CH_STA_PRI)) & 0x00000030 ) >> 4)
#define GET_CH2_STA_PRI (((REG32(ADR_CH_STA_PRI)) & 0x00000300 ) >> 8)
#define GET_CH3_STA_PRI (((REG32(ADR_CH_STA_PRI)) & 0x00003000 ) >> 12)
#define GET_ID_TB0 (((REG32(ADR_RD_ID0)) & 0xffffffff ) >> 0)
#define GET_ID_TB1 (((REG32(ADR_RD_ID1)) & 0xffffffff ) >> 0)
#define GET_ID_MNG_HALT (((REG32(ADR_IMD_CFG)) & 0x00000010 ) >> 4)
#define GET_ID_MNG_ERR_HALT_EN (((REG32(ADR_IMD_CFG)) & 0x00000020 ) >> 5)
#define GET_ID_EXCEPT_FLG_CLR (((REG32(ADR_IMD_CFG)) & 0x00000040 ) >> 6)
#define GET_ID_EXCEPT_FLG (((REG32(ADR_IMD_CFG)) & 0x00000080 ) >> 7)
#define GET_ID_FULL (((REG32(ADR_IMD_STA)) & 0x00000001 ) >> 0)
#define GET_ID_MNG_BUSY (((REG32(ADR_IMD_STA)) & 0x00000002 ) >> 1)
#define GET_REQ_LOCK (((REG32(ADR_IMD_STA)) & 0x00000004 ) >> 2)
#define GET_CH0_REQ_LOCK (((REG32(ADR_IMD_STA)) & 0x00000010 ) >> 4)
#define GET_CH1_REQ_LOCK (((REG32(ADR_IMD_STA)) & 0x00000020 ) >> 5)
#define GET_CH2_REQ_LOCK (((REG32(ADR_IMD_STA)) & 0x00000040 ) >> 6)
#define GET_CH3_REQ_LOCK (((REG32(ADR_IMD_STA)) & 0x00000080 ) >> 7)
#define GET_REQ_LOCK_INT_EN (((REG32(ADR_IMD_STA)) & 0x00000100 ) >> 8)
#define GET_REQ_LOCK_INT (((REG32(ADR_IMD_STA)) & 0x00000200 ) >> 9)
#define GET_MCU_ALC_READY (((REG32(ADR_ALC_STA)) & 0x00000001 ) >> 0)
#define GET_ALC_FAIL (((REG32(ADR_ALC_STA)) & 0x00000002 ) >> 1)
#define GET_ALC_BUSY (((REG32(ADR_ALC_STA)) & 0x00000004 ) >> 2)
#define GET_CH0_NVLD (((REG32(ADR_ALC_STA)) & 0x00000010 ) >> 4)
#define GET_CH1_NVLD (((REG32(ADR_ALC_STA)) & 0x00000020 ) >> 5)
#define GET_CH2_NVLD (((REG32(ADR_ALC_STA)) & 0x00000040 ) >> 6)
#define GET_CH3_NVLD (((REG32(ADR_ALC_STA)) & 0x00000080 ) >> 7)
#define GET_ALC_INT_ID (((REG32(ADR_ALC_STA)) & 0x00007f00 ) >> 8)
#define GET_ALC_TIMEOUT (((REG32(ADR_ALC_STA)) & 0x03ff0000 ) >> 16)
#define GET_ALC_TIMEOUT_INT_EN (((REG32(ADR_ALC_STA)) & 0x40000000 ) >> 30)
#define GET_ALC_TIMEOUT_INT (((REG32(ADR_ALC_STA)) & 0x80000000 ) >> 31)
#define GET_TX_ID_COUNT (((REG32(ADR_TRX_ID_COUNT)) & 0x000000ff ) >> 0)
#define GET_RX_ID_COUNT (((REG32(ADR_TRX_ID_COUNT)) & 0x0000ff00 ) >> 8)
#define GET_TX_ID_THOLD (((REG32(ADR_TRX_ID_THRESHOLD)) & 0x000000ff ) >> 0)
#define GET_RX_ID_THOLD (((REG32(ADR_TRX_ID_THRESHOLD)) & 0x0000ff00 ) >> 8)
#define GET_ID_THOLD_RX_INT (((REG32(ADR_TRX_ID_THRESHOLD)) & 0x00010000 ) >> 16)
#define GET_RX_INT_CH (((REG32(ADR_TRX_ID_THRESHOLD)) & 0x000e0000 ) >> 17)
#define GET_ID_THOLD_TX_INT (((REG32(ADR_TRX_ID_THRESHOLD)) & 0x00100000 ) >> 20)
#define GET_TX_INT_CH (((REG32(ADR_TRX_ID_THRESHOLD)) & 0x00e00000 ) >> 21)
#define GET_ID_THOLD_INT_EN (((REG32(ADR_TRX_ID_THRESHOLD)) & 0x01000000 ) >> 24)
#define GET_TX_ID_TB0 (((REG32(ADR_TX_ID0)) & 0xffffffff ) >> 0)
#define GET_TX_ID_TB1 (((REG32(ADR_TX_ID1)) & 0xffffffff ) >> 0)
#define GET_RX_ID_TB0 (((REG32(ADR_RX_ID0)) & 0xffffffff ) >> 0)
#define GET_RX_ID_TB1 (((REG32(ADR_RX_ID1)) & 0xffffffff ) >> 0)
#define GET_DOUBLE_RLS_INT_EN (((REG32(ADR_RTN_STA)) & 0x00000001 ) >> 0)
#define GET_ID_DOUBLE_RLS_INT (((REG32(ADR_RTN_STA)) & 0x00000002 ) >> 1)
#define GET_DOUBLE_RLS_ID (((REG32(ADR_RTN_STA)) & 0x00007f00 ) >> 8)
#define GET_ID_LEN_THOLD_INT_EN (((REG32(ADR_ID_LEN_THREADSHOLD1)) & 0x00000001 ) >> 0)
#define GET_ALL_ID_LEN_THOLD_INT (((REG32(ADR_ID_LEN_THREADSHOLD1)) & 0x00000002 ) >> 1)
#define GET_TX_ID_LEN_THOLD_INT (((REG32(ADR_ID_LEN_THREADSHOLD1)) & 0x00000004 ) >> 2)
#define GET_RX_ID_LEN_THOLD_INT (((REG32(ADR_ID_LEN_THREADSHOLD1)) & 0x00000008 ) >> 3)
#define GET_ID_TX_LEN_THOLD (((REG32(ADR_ID_LEN_THREADSHOLD1)) & 0x00001ff0 ) >> 4)
#define GET_ID_RX_LEN_THOLD (((REG32(ADR_ID_LEN_THREADSHOLD1)) & 0x003fe000 ) >> 13)
#define GET_ID_LEN_THOLD (((REG32(ADR_ID_LEN_THREADSHOLD1)) & 0x7fc00000 ) >> 22)
#define GET_ALL_ID_ALC_LEN (((REG32(ADR_ID_LEN_THREADSHOLD2)) & 0x000001ff ) >> 0)
#define GET_TX_ID_ALC_LEN (((REG32(ADR_ID_LEN_THREADSHOLD2)) & 0x0003fe00 ) >> 9)
#define GET_RX_ID_ALC_LEN (((REG32(ADR_ID_LEN_THREADSHOLD2)) & 0x07fc0000 ) >> 18)
#define GET_CH_ARB_EN (((REG32(ADR_CH_ARB_PRI)) & 0x00000001 ) >> 0)
#define GET_CH_PRI1 (((REG32(ADR_CH_ARB_PRI)) & 0x00000030 ) >> 4)
#define GET_CH_PRI2 (((REG32(ADR_CH_ARB_PRI)) & 0x00000300 ) >> 8)
#define GET_CH_PRI3 (((REG32(ADR_CH_ARB_PRI)) & 0x00003000 ) >> 12)
#define GET_CH_PRI4 (((REG32(ADR_CH_ARB_PRI)) & 0x00030000 ) >> 16)
#define GET_TX_ID_REMAIN (((REG32(ADR_TX_ID_REMAIN_STATUS)) & 0x0000007f ) >> 0)
#define GET_TX_PAGE_REMAIN (((REG32(ADR_TX_ID_REMAIN_STATUS)) & 0x0001ff00 ) >> 8)
#define GET_ID_PAGE_MAX_SIZE (((REG32(ADR_ID_INFO_STA)) & 0x000001ff ) >> 0)
#define GET_TX_PAGE_LIMIT (((REG32(ADR_TX_LIMIT_INTR)) & 0x000001ff ) >> 0)
#define GET_TX_COUNT_LIMIT (((REG32(ADR_TX_LIMIT_INTR)) & 0x00ff0000 ) >> 16)
#define GET_TX_LIMIT_INT (((REG32(ADR_TX_LIMIT_INTR)) & 0x40000000 ) >> 30)
#define GET_TX_LIMIT_INT_EN (((REG32(ADR_TX_LIMIT_INTR)) & 0x80000000 ) >> 31)
#define GET_TX_PAGE_USE_7_0 (((REG32(ADR_TX_ID_ALL_INFO)) & 0x000000ff ) >> 0)
#define GET_TX_ID_USE_5_0 (((REG32(ADR_TX_ID_ALL_INFO)) & 0x00003f00 ) >> 8)
#define GET_EDCA0_FFO_CNT (((REG32(ADR_TX_ID_ALL_INFO)) & 0x0003c000 ) >> 14)
#define GET_EDCA1_FFO_CNT_3_0 (((REG32(ADR_TX_ID_ALL_INFO)) & 0x003c0000 ) >> 18)
#define GET_EDCA2_FFO_CNT (((REG32(ADR_TX_ID_ALL_INFO)) & 0x07c00000 ) >> 22)
#define GET_EDCA3_FFO_CNT (((REG32(ADR_TX_ID_ALL_INFO)) & 0xf8000000 ) >> 27)
#define GET_ID_TB2 (((REG32(ADR_RD_ID2)) & 0xffffffff ) >> 0)
#define GET_ID_TB3 (((REG32(ADR_RD_ID3)) & 0xffffffff ) >> 0)
#define GET_TX_ID_TB2 (((REG32(ADR_TX_ID2)) & 0xffffffff ) >> 0)
#define GET_TX_ID_TB3 (((REG32(ADR_TX_ID3)) & 0xffffffff ) >> 0)
#define GET_RX_ID_TB2 (((REG32(ADR_RX_ID2)) & 0xffffffff ) >> 0)
#define GET_RX_ID_TB3 (((REG32(ADR_RX_ID3)) & 0xffffffff ) >> 0)
#define GET_TX_PAGE_USE2 (((REG32(ADR_TX_ID_ALL_INFO2)) & 0x000001ff ) >> 0)
#define GET_TX_ID_USE2 (((REG32(ADR_TX_ID_ALL_INFO2)) & 0x0001fe00 ) >> 9)
#define GET_EDCA4_FFO_CNT (((REG32(ADR_TX_ID_ALL_INFO2)) & 0x001e0000 ) >> 17)
#define GET_TX_PAGE_USE3 (((REG32(ADR_TX_ID_ALL_INFO_A)) & 0x000001ff ) >> 0)
#define GET_TX_ID_USE3 (((REG32(ADR_TX_ID_ALL_INFO_A)) & 0x0001fe00 ) >> 9)
#define GET_EDCA1_FFO_CNT2 (((REG32(ADR_TX_ID_ALL_INFO_A)) & 0x03e00000 ) >> 21)
#define GET_EDCA4_FFO_CNT2 (((REG32(ADR_TX_ID_ALL_INFO_A)) & 0x3c000000 ) >> 26)
#define GET_TX_PAGE_USE4 (((REG32(ADR_TX_ID_ALL_INFO_B)) & 0x000001ff ) >> 0)
#define GET_TX_ID_USE4 (((REG32(ADR_TX_ID_ALL_INFO_B)) & 0x0001fe00 ) >> 9)
#define GET_EDCA2_FFO_CNT2 (((REG32(ADR_TX_ID_ALL_INFO_B)) & 0x003e0000 ) >> 17)
#define GET_EDCA3_FFO_CNT2 (((REG32(ADR_TX_ID_ALL_INFO_B)) & 0x07c00000 ) >> 22)
#define GET_TX_ID_IFO_LEN (((REG32(ADR_TX_ID_REMAIN_STATUS2)) & 0x000001ff ) >> 0)
#define GET_RX_ID_IFO_LEN (((REG32(ADR_TX_ID_REMAIN_STATUS2)) & 0x01ff0000 ) >> 16)
#define GET_MAX_ALL_ALC_ID_CNT (((REG32(ADR_ALC_ID_INFO)) & 0x000000ff ) >> 0)
#define GET_MAX_TX_ALC_ID_CNT (((REG32(ADR_ALC_ID_INFO)) & 0x0000ff00 ) >> 8)
#define GET_MAX_RX_ALC_ID_CNT (((REG32(ADR_ALC_ID_INFO)) & 0x00ff0000 ) >> 16)
#define GET_MAX_ALL_ID_ALC_LEN (((REG32(ADR_ALC_ID_INF1)) & 0x000001ff ) >> 0)
#define GET_MAX_TX_ID_ALC_LEN (((REG32(ADR_ALC_ID_INF1)) & 0x0003fe00 ) >> 9)
#define GET_MAX_RX_ID_ALC_LEN (((REG32(ADR_ALC_ID_INF1)) & 0x07fc0000 ) >> 18)
#define GET_RG_PMDLBK (((REG32(ADR_PHY_EN_0)) & 0x00000001 ) >> 0)
#define GET_RG_RDYACK_SEL (((REG32(ADR_PHY_EN_0)) & 0x00000006 ) >> 1)
#define GET_RG_ADEDGE_SEL (((REG32(ADR_PHY_EN_0)) & 0x00000008 ) >> 3)
#define GET_RG_SIGN_SWAP (((REG32(ADR_PHY_EN_0)) & 0x00000010 ) >> 4)
#define GET_RG_IQ_SWAP (((REG32(ADR_PHY_EN_0)) & 0x00000020 ) >> 5)
#define GET_RG_Q_INV (((REG32(ADR_PHY_EN_0)) & 0x00000040 ) >> 6)
#define GET_RG_I_INV (((REG32(ADR_PHY_EN_0)) & 0x00000080 ) >> 7)
#define GET_RG_BYPASS_ACI (((REG32(ADR_PHY_EN_0)) & 0x00000100 ) >> 8)
#define GET_RG_LBK_ANA_PATH (((REG32(ADR_PHY_EN_0)) & 0x00000200 ) >> 9)
#define GET_RG_SPECTRUM_LEAKY_FACTOR (((REG32(ADR_PHY_EN_0)) & 0x00000c00 ) >> 10)
#define GET_RG_SPECTRUM_BW (((REG32(ADR_PHY_EN_0)) & 0x00003000 ) >> 12)
#define GET_RG_SPECTRUM_FREQ_MANUAL (((REG32(ADR_PHY_EN_0)) & 0x00004000 ) >> 14)
#define GET_RG_SPECTRUM_EN (((REG32(ADR_PHY_EN_0)) & 0x00008000 ) >> 15)
#define GET_RG_TXPWRLVL_SET (((REG32(ADR_PHY_EN_0)) & 0x00ff0000 ) >> 16)
#define GET_RG_TXPWRLVL_SEL (((REG32(ADR_PHY_EN_0)) & 0x01000000 ) >> 24)
#define GET_RG_RF_BB_CLK_SEL (((REG32(ADR_PHY_EN_0)) & 0x80000000 ) >> 31)
#define GET_RG_PHY_MD_EN (((REG32(ADR_PHY_EN_1)) & 0x00000001 ) >> 0)
#define GET_RG_PHYRX_MD_EN (((REG32(ADR_PHY_EN_1)) & 0x00000002 ) >> 1)
#define GET_RG_PHYTX_MD_EN (((REG32(ADR_PHY_EN_1)) & 0x00000004 ) >> 2)
#define GET_RG_PHY11GN_MD_EN (((REG32(ADR_PHY_EN_1)) & 0x00000008 ) >> 3)
#define GET_RG_PHY11B_MD_EN (((REG32(ADR_PHY_EN_1)) & 0x00000010 ) >> 4)
#define GET_RG_PHYRXFIFO_MD_EN (((REG32(ADR_PHY_EN_1)) & 0x00000020 ) >> 5)
#define GET_RG_PHYTXFIFO_MD_EN (((REG32(ADR_PHY_EN_1)) & 0x00000040 ) >> 6)
#define GET_RG_PHY11BGN_MD_EN (((REG32(ADR_PHY_EN_1)) & 0x00000100 ) >> 8)
#define GET_RG_FORCE_11GN_EN (((REG32(ADR_PHY_EN_1)) & 0x00001000 ) >> 12)
#define GET_RG_FORCE_11B_EN (((REG32(ADR_PHY_EN_1)) & 0x00002000 ) >> 13)
#define GET_RG_FFT_MEM_CLK_EN_RX (((REG32(ADR_PHY_EN_1)) & 0x00004000 ) >> 14)
#define GET_RG_FFT_MEM_CLK_EN_TX (((REG32(ADR_PHY_EN_1)) & 0x00008000 ) >> 15)
#define GET_RG_PHY_IQ_TRIG_SEL (((REG32(ADR_PHY_EN_1)) & 0x000f0000 ) >> 16)
#define GET_RG_SPECTRUM_FREQ (((REG32(ADR_PHY_EN_1)) & 0x3ff00000 ) >> 20)
#define GET_SVN_VERSION (((REG32(ADR_SVN_VERSION_REG)) & 0xffffffff ) >> 0)
#define GET_RG_LENGTH (((REG32(ADR_PHY_PKT_GEN_0)) & 0x0000ffff ) >> 0)
#define GET_RG_PKT_MODE (((REG32(ADR_PHY_PKT_GEN_0)) & 0x00070000 ) >> 16)
#define GET_RG_CH_BW (((REG32(ADR_PHY_PKT_GEN_0)) & 0x00380000 ) >> 19)
#define GET_RG_PRM (((REG32(ADR_PHY_PKT_GEN_0)) & 0x00400000 ) >> 22)
#define GET_RG_SHORTGI (((REG32(ADR_PHY_PKT_GEN_0)) & 0x00800000 ) >> 23)
#define GET_RG_RATE (((REG32(ADR_PHY_PKT_GEN_0)) & 0x7f000000 ) >> 24)
#define GET_RG_L_LENGTH (((REG32(ADR_PHY_PKT_GEN_1)) & 0x00000fff ) >> 0)
#define GET_RG_L_RATE (((REG32(ADR_PHY_PKT_GEN_1)) & 0x00007000 ) >> 12)
#define GET_RG_SERVICE (((REG32(ADR_PHY_PKT_GEN_1)) & 0xffff0000 ) >> 16)
#define GET_RG_SMOOTHING (((REG32(ADR_PHY_PKT_GEN_2)) & 0x00000001 ) >> 0)
#define GET_RG_NO_SOUND (((REG32(ADR_PHY_PKT_GEN_2)) & 0x00000002 ) >> 1)
#define GET_RG_AGGREGATE (((REG32(ADR_PHY_PKT_GEN_2)) & 0x00000004 ) >> 2)
#define GET_RG_STBC (((REG32(ADR_PHY_PKT_GEN_2)) & 0x00000018 ) >> 3)
#define GET_RG_FEC (((REG32(ADR_PHY_PKT_GEN_2)) & 0x00000020 ) >> 5)
#define GET_RG_N_ESS (((REG32(ADR_PHY_PKT_GEN_2)) & 0x000000c0 ) >> 6)
#define GET_RG_TXPWRLVL (((REG32(ADR_PHY_PKT_GEN_2)) & 0x0000ff00 ) >> 8)
#define GET_RG_TX_START (((REG32(ADR_PHY_PKT_GEN_3)) & 0x00000001 ) >> 0)
#define GET_RG_IFS_TIME (((REG32(ADR_PHY_PKT_GEN_3)) & 0x000000fc ) >> 2)
#define GET_RG_CONTINUOUS_DATA (((REG32(ADR_PHY_PKT_GEN_3)) & 0x00000100 ) >> 8)
#define GET_RG_DATA_SEL (((REG32(ADR_PHY_PKT_GEN_3)) & 0x00000600 ) >> 9)
#define GET_RG_TX_D (((REG32(ADR_PHY_PKT_GEN_3)) & 0x00ff0000 ) >> 16)
#define GET_RG_TX_CNT_TARGET (((REG32(ADR_PHY_PKT_GEN_4)) & 0xffffffff ) >> 0)
#define GET_RG_FFT_IFFT_MODE (((REG32(ADR_PHY_REG_00)) & 0x000000c0 ) >> 6)
#define GET_RG_DAC_DBG_MODE (((REG32(ADR_PHY_REG_00)) & 0x00000100 ) >> 8)
#define GET_RG_DAC_SGN_SWAP (((REG32(ADR_PHY_REG_00)) & 0x00000200 ) >> 9)
#define GET_RG_TXD_SEL (((REG32(ADR_PHY_REG_00)) & 0x00000c00 ) >> 10)
#define GET_RG_UP8X (((REG32(ADR_PHY_REG_00)) & 0x00ff0000 ) >> 16)
#define GET_RG_IQ_DC_BYP (((REG32(ADR_PHY_REG_00)) & 0x01000000 ) >> 24)
#define GET_RG_IQ_DC_LEAKY_FACTOR (((REG32(ADR_PHY_REG_00)) & 0x30000000 ) >> 28)
#define GET_RG_DAC_DCEN (((REG32(ADR_PHY_REG_01)) & 0x00000001 ) >> 0)
#define GET_RG_DAC_DCQ (((REG32(ADR_PHY_REG_01)) & 0x00003ff0 ) >> 4)
#define GET_RG_DAC_DCI (((REG32(ADR_PHY_REG_01)) & 0x03ff0000 ) >> 16)
#define GET_RG_PGA_REFDB_SAT (((REG32(ADR_PHY_REG_02_AGC)) & 0x0000007f ) >> 0)
#define GET_RG_PGA_REFDB_TOP (((REG32(ADR_PHY_REG_02_AGC)) & 0x00007f00 ) >> 8)
#define GET_RG_PGA_REF_UND (((REG32(ADR_PHY_REG_02_AGC)) & 0x03ff0000 ) >> 16)
#define GET_RG_RF_REF_SAT (((REG32(ADR_PHY_REG_02_AGC)) & 0xf0000000 ) >> 28)
#define GET_RG_PGAGC_SET (((REG32(ADR_PHY_REG_03_AGC)) & 0x0000000f ) >> 0)
#define GET_RG_PGAGC_OW (((REG32(ADR_PHY_REG_03_AGC)) & 0x00000010 ) >> 4)
#define GET_RG_RFGC_SET (((REG32(ADR_PHY_REG_03_AGC)) & 0x00000060 ) >> 5)
#define GET_RG_RFGC_OW (((REG32(ADR_PHY_REG_03_AGC)) & 0x00000080 ) >> 7)
#define GET_RG_WAIT_T_RXAGC (((REG32(ADR_PHY_REG_03_AGC)) & 0x00003f00 ) >> 8)
#define GET_RG_RXAGC_SET (((REG32(ADR_PHY_REG_03_AGC)) & 0x00004000 ) >> 14)
#define GET_RG_RXAGC_OW (((REG32(ADR_PHY_REG_03_AGC)) & 0x00008000 ) >> 15)
#define GET_RG_WAIT_T_FINAL (((REG32(ADR_PHY_REG_03_AGC)) & 0x003f0000 ) >> 16)
#define GET_RG_WAIT_T (((REG32(ADR_PHY_REG_03_AGC)) & 0x3f000000 ) >> 24)
#define GET_RG_ULG_PGA_SAT_PGA_GAIN (((REG32(ADR_PHY_REG_04_AGC)) & 0x0000000f ) >> 0)
#define GET_RG_LG_PGA_UND_PGA_GAIN (((REG32(ADR_PHY_REG_04_AGC)) & 0x000000f0 ) >> 4)
#define GET_RG_LG_PGA_SAT_PGA_GAIN (((REG32(ADR_PHY_REG_04_AGC)) & 0x00000f00 ) >> 8)
#define GET_RG_LG_RF_SAT_PGA_GAIN (((REG32(ADR_PHY_REG_04_AGC)) & 0x0000f000 ) >> 12)
#define GET_RG_MG_RF_SAT_PGANOREF_PGA_GAIN (((REG32(ADR_PHY_REG_04_AGC)) & 0x000f0000 ) >> 16)
#define GET_RG_HG_PGA_SAT2_PGA_GAIN (((REG32(ADR_PHY_REG_04_AGC)) & 0x00f00000 ) >> 20)
#define GET_RG_HG_PGA_SAT1_PGA_GAIN (((REG32(ADR_PHY_REG_04_AGC)) & 0x0f000000 ) >> 24)
#define GET_RG_HG_RF_SAT_PGA_GAIN (((REG32(ADR_PHY_REG_04_AGC)) & 0xf0000000 ) >> 28)
#define GET_RG_MG_PGA_JB_TH (((REG32(ADR_PHY_REG_05_AGC)) & 0x0000000f ) >> 0)
#define GET_RG_MA_PGA_LOW_TH_CNT_LMT (((REG32(ADR_PHY_REG_05_AGC)) & 0x001f0000 ) >> 16)
#define GET_RG_WR_RFGC_INIT_SET (((REG32(ADR_PHY_REG_05_AGC)) & 0x00600000 ) >> 21)
#define GET_RG_WR_RFGC_INIT_EN (((REG32(ADR_PHY_REG_05_AGC)) & 0x00800000 ) >> 23)
#define GET_RG_MA_PGA_HIGH_TH_CNT_LMT (((REG32(ADR_PHY_REG_05_AGC)) & 0x1f000000 ) >> 24)
#define GET_RG_AGC_THRESHOLD (((REG32(ADR_PHY_REG_06_11B_DAGC)) & 0x00003fff ) >> 0)
#define GET_RG_ACI_POINT_CNT_LMT_11B (((REG32(ADR_PHY_REG_06_11B_DAGC)) & 0x007f0000 ) >> 16)
#define GET_RG_ACI_DAGC_LEAKY_FACTOR_11B (((REG32(ADR_PHY_REG_06_11B_DAGC)) & 0x03000000 ) >> 24)
#define GET_RG_WR_ACI_GAIN_INI_SEL_11B (((REG32(ADR_PHY_REG_07_11B_DAGC)) & 0x000000ff ) >> 0)
#define GET_RG_WR_ACI_GAIN_SEL_11B (((REG32(ADR_PHY_REG_07_11B_DAGC)) & 0x0000ff00 ) >> 8)
#define GET_RG_ACI_DAGC_SET_VALUE_11B (((REG32(ADR_PHY_REG_07_11B_DAGC)) & 0x007f0000 ) >> 16)
#define GET_RG_WR_ACI_GAIN_OW_11B (((REG32(ADR_PHY_REG_07_11B_DAGC)) & 0x80000000 ) >> 31)
#define GET_RG_ACI_POINT_CNT_LMT_11GN (((REG32(ADR_PHY_REG_08_11GN_DAGC)) & 0x000000ff ) >> 0)
#define GET_RG_ACI_DAGC_LEAKY_FACTOR_11GN (((REG32(ADR_PHY_REG_08_11GN_DAGC)) & 0x00000300 ) >> 8)
#define GET_RG_ACI_DAGC_DONE_CNT_LMT_11GN (((REG32(ADR_PHY_REG_08_11GN_DAGC)) & 0xff000000 ) >> 24)
#define GET_RG_ACI_DAGC_SET_VALUE_11GN (((REG32(ADR_PHY_REG_09_11GN_DAGC)) & 0x0000007f ) >> 0)
#define GET_RG_ACI_GAIN_INI_VAL_11GN (((REG32(ADR_PHY_REG_09_11GN_DAGC)) & 0x0000ff00 ) >> 8)
#define GET_RG_ACI_GAIN_OW_VAL_11GN (((REG32(ADR_PHY_REG_09_11GN_DAGC)) & 0x00ff0000 ) >> 16)
#define GET_RG_ACI_GAIN_OW_11GN (((REG32(ADR_PHY_REG_09_11GN_DAGC)) & 0x80000000 ) >> 31)
#define GET_RO_CCA_PWR_MA_11GN (((REG32(ADR_PHY_READ_REG_00_DIG_PWR)) & 0x0000007f ) >> 0)
#define GET_RO_ED_STATE (((REG32(ADR_PHY_READ_REG_00_DIG_PWR)) & 0x00008000 ) >> 15)
#define GET_RO_CCA_PWR_MA_11B (((REG32(ADR_PHY_READ_REG_00_DIG_PWR)) & 0x007f0000 ) >> 16)
#define GET_RO_PGA_PWR_FF1 (((REG32(ADR_PHY_READ_REG_01_RF_GAIN_PWR)) & 0x00003fff ) >> 0)
#define GET_RO_RF_PWR_FF1 (((REG32(ADR_PHY_READ_REG_01_RF_GAIN_PWR)) & 0x000f0000 ) >> 16)
#define GET_RO_PGAGC_FF1 (((REG32(ADR_PHY_READ_REG_01_RF_GAIN_PWR)) & 0x0f000000 ) >> 24)
#define GET_RO_RFGC_FF1 (((REG32(ADR_PHY_READ_REG_01_RF_GAIN_PWR)) & 0x30000000 ) >> 28)
#define GET_RO_PGA_PWR_FF2 (((REG32(ADR_PHY_READ_REG_02_RF_GAIN_PWR)) & 0x00003fff ) >> 0)
#define GET_RO_RF_PWR_FF2 (((REG32(ADR_PHY_READ_REG_02_RF_GAIN_PWR)) & 0x000f0000 ) >> 16)
#define GET_RO_PGAGC_FF2 (((REG32(ADR_PHY_READ_REG_02_RF_GAIN_PWR)) & 0x0f000000 ) >> 24)
#define GET_RO_RFGC_FF2 (((REG32(ADR_PHY_READ_REG_02_RF_GAIN_PWR)) & 0x30000000 ) >> 28)
#define GET_RO_PGA_PWR_FF3 (((REG32(ADR_PHY_READ_REG_03_RF_GAIN_PWR)) & 0x00003fff ) >> 0)
#define GET_RO_RF_PWR_FF3 (((REG32(ADR_PHY_READ_REG_03_RF_GAIN_PWR)) & 0x000f0000 ) >> 16)
#define GET_RO_PGAGC_FF3 (((REG32(ADR_PHY_READ_REG_03_RF_GAIN_PWR)) & 0x0f000000 ) >> 24)
#define GET_RO_RFGC_FF3 (((REG32(ADR_PHY_READ_REG_03_RF_GAIN_PWR)) & 0x30000000 ) >> 28)
#define GET_RG_TX_DES_RATE (((REG32(ADR_PHY_REG_10_TX_DES)) & 0x0000001f ) >> 0)
#define GET_RG_TX_DES_MODE (((REG32(ADR_PHY_REG_10_TX_DES)) & 0x00001f00 ) >> 8)
#define GET_RG_TX_DES_LEN_LO (((REG32(ADR_PHY_REG_10_TX_DES)) & 0x001f0000 ) >> 16)
#define GET_RG_TX_DES_LEN_UP (((REG32(ADR_PHY_REG_10_TX_DES)) & 0x1f000000 ) >> 24)
#define GET_RG_TX_DES_SRVC_UP (((REG32(ADR_PHY_REG_11_TX_DES)) & 0x0000001f ) >> 0)
#define GET_RG_TX_DES_L_LEN_LO (((REG32(ADR_PHY_REG_11_TX_DES)) & 0x00001f00 ) >> 8)
#define GET_RG_TX_DES_L_LEN_UP (((REG32(ADR_PHY_REG_11_TX_DES)) & 0x001f0000 ) >> 16)
#define GET_RG_TX_DES_TYPE (((REG32(ADR_PHY_REG_11_TX_DES)) & 0x1f000000 ) >> 24)
#define GET_RG_TX_DES_L_LEN_UP_COMB (((REG32(ADR_PHY_REG_12_TX_DES)) & 0x00000001 ) >> 0)
#define GET_RG_TX_DES_TYPE_COMB (((REG32(ADR_PHY_REG_12_TX_DES)) & 0x00000010 ) >> 4)
#define GET_RG_TX_DES_RATE_COMB (((REG32(ADR_PHY_REG_12_TX_DES)) & 0x00000100 ) >> 8)
#define GET_RG_TX_DES_MODE_COMB (((REG32(ADR_PHY_REG_12_TX_DES)) & 0x00001000 ) >> 12)
#define GET_RG_TX_DES_PWRLVL (((REG32(ADR_PHY_REG_12_TX_DES)) & 0x001f0000 ) >> 16)
#define GET_RG_TX_DES_SRVC_LO (((REG32(ADR_PHY_REG_12_TX_DES)) & 0x1f000000 ) >> 24)
#define GET_RG_RX_DES_RATE (((REG32(ADR_PHY_REG_13_RX_DES)) & 0x0000003f ) >> 0)
#define GET_RG_RX_DES_MODE (((REG32(ADR_PHY_REG_13_RX_DES)) & 0x00003f00 ) >> 8)
#define GET_RG_RX_DES_LEN_LO (((REG32(ADR_PHY_REG_13_RX_DES)) & 0x003f0000 ) >> 16)
#define GET_RG_RX_DES_LEN_UP (((REG32(ADR_PHY_REG_13_RX_DES)) & 0x3f000000 ) >> 24)
#define GET_RG_RX_DES_SRVC_UP (((REG32(ADR_PHY_REG_14_RX_DES)) & 0x0000003f ) >> 0)
#define GET_RG_RX_DES_L_LEN_LO (((REG32(ADR_PHY_REG_14_RX_DES)) & 0x00003f00 ) >> 8)
#define GET_RG_RX_DES_L_LEN_UP (((REG32(ADR_PHY_REG_14_RX_DES)) & 0x003f0000 ) >> 16)
#define GET_RG_RX_DES_TYPE (((REG32(ADR_PHY_REG_14_RX_DES)) & 0x3f000000 ) >> 24)
#define GET_RG_RX_DES_L_LEN_UP_COMB (((REG32(ADR_PHY_REG_15_RX_DES)) & 0x00000001 ) >> 0)
#define GET_RG_RX_DES_TYPE_COMB (((REG32(ADR_PHY_REG_15_RX_DES)) & 0x00000010 ) >> 4)
#define GET_RG_RX_DES_RATE_COMB (((REG32(ADR_PHY_REG_15_RX_DES)) & 0x00000100 ) >> 8)
#define GET_RG_RX_DES_MODE_COMB (((REG32(ADR_PHY_REG_15_RX_DES)) & 0x00001000 ) >> 12)
#define GET_RG_RX_DES_SNR (((REG32(ADR_PHY_REG_15_RX_DES)) & 0x000f0000 ) >> 16)
#define GET_RG_RX_DES_RCPI (((REG32(ADR_PHY_REG_15_RX_DES)) & 0x00f00000 ) >> 20)
#define GET_RG_RX_DES_SRVC_LO (((REG32(ADR_PHY_REG_15_RX_DES)) & 0x3f000000 ) >> 24)
#define GET_RO_TX_DES_EXCP_RATE_CNT (((REG32(ADR_PHY_REG_16_TX_DES_EXCP)) & 0x000000ff ) >> 0)
#define GET_RO_TX_DES_EXCP_CH_BW_CNT (((REG32(ADR_PHY_REG_16_TX_DES_EXCP)) & 0x0000ff00 ) >> 8)
#define GET_RO_TX_DES_EXCP_MODE_CNT (((REG32(ADR_PHY_REG_16_TX_DES_EXCP)) & 0x00ff0000 ) >> 16)
#define GET_RG_TX_DES_EXCP_RATE_DEFAULT (((REG32(ADR_PHY_REG_16_TX_DES_EXCP)) & 0x07000000 ) >> 24)
#define GET_RG_TX_DES_EXCP_MODE_DEFAULT (((REG32(ADR_PHY_REG_16_TX_DES_EXCP)) & 0x70000000 ) >> 28)
#define GET_RG_TX_DES_EXCP_CLR (((REG32(ADR_PHY_REG_16_TX_DES_EXCP)) & 0x80000000 ) >> 31)
#define GET_RG_TX_DES_ACK_WIDTH (((REG32(ADR_PHY_REG_17_TX_DES_EXCP)) & 0x00000001 ) >> 0)
#define GET_RG_TX_DES_ACK_PRD (((REG32(ADR_PHY_REG_17_TX_DES_EXCP)) & 0x0000000e ) >> 1)
#define GET_RG_RX_DES_SNR_GN (((REG32(ADR_PHY_REG_17_TX_DES_EXCP)) & 0x003f0000 ) >> 16)
#define GET_RG_RX_DES_RCPI_GN (((REG32(ADR_PHY_REG_17_TX_DES_EXCP)) & 0x3f000000 ) >> 24)
#define GET_RG_TST_TBUS_SEL (((REG32(ADR_PHY_REG_18_RSSI_SNR)) & 0x0000000f ) >> 0)
#define GET_RG_RSSI_OFFSET (((REG32(ADR_PHY_REG_18_RSSI_SNR)) & 0x00ff0000 ) >> 16)
#define GET_RG_RSSI_INV (((REG32(ADR_PHY_REG_18_RSSI_SNR)) & 0x01000000 ) >> 24)
#define GET_RG_TST_ADC_ON (((REG32(ADR_PHY_REG_18_RSSI_SNR)) & 0x40000000 ) >> 30)
#define GET_RG_TST_EXT_GAIN (((REG32(ADR_PHY_REG_18_RSSI_SNR)) & 0x80000000 ) >> 31)
#define GET_RG_DAC_Q_SET (((REG32(ADR_PHY_REG_19_DAC_MANUAL)) & 0x000003ff ) >> 0)
#define GET_RG_DAC_I_SET (((REG32(ADR_PHY_REG_19_DAC_MANUAL)) & 0x003ff000 ) >> 12)
#define GET_RG_DAC_EN_MAN (((REG32(ADR_PHY_REG_19_DAC_MANUAL)) & 0x10000000 ) >> 28)
#define GET_RG_IQC_FFT_EN (((REG32(ADR_PHY_REG_19_DAC_MANUAL)) & 0x20000000 ) >> 29)
#define GET_RG_DAC_MAN_Q_EN (((REG32(ADR_PHY_REG_19_DAC_MANUAL)) & 0x40000000 ) >> 30)
#define GET_RG_DAC_MAN_I_EN (((REG32(ADR_PHY_REG_19_DAC_MANUAL)) & 0x80000000 ) >> 31)
#define GET_RO_MRX_EN_CNT (((REG32(ADR_PHY_REG_20_MRX_CNT)) & 0x0000ffff ) >> 0)
#define GET_RG_MRX_EN_CNT_RST_N (((REG32(ADR_PHY_REG_20_MRX_CNT)) & 0x80000000 ) >> 31)
#define GET_RG_PA_RISE_TIME (((REG32(ADR_PHY_REG_21_TRX_RAMP)) & 0x000000ff ) >> 0)
#define GET_RG_RFTX_RISE_TIME (((REG32(ADR_PHY_REG_21_TRX_RAMP)) & 0x0000ff00 ) >> 8)
#define GET_RG_DAC_RISE_TIME (((REG32(ADR_PHY_REG_21_TRX_RAMP)) & 0x00ff0000 ) >> 16)
#define GET_RG_SW_RISE_TIME (((REG32(ADR_PHY_REG_21_TRX_RAMP)) & 0xff000000 ) >> 24)
#define GET_RG_PA_FALL_TIME (((REG32(ADR_PHY_REG_22_TRX_RAMP)) & 0x000000ff ) >> 0)
#define GET_RG_RFTX_FALL_TIME (((REG32(ADR_PHY_REG_22_TRX_RAMP)) & 0x0000ff00 ) >> 8)
#define GET_RG_DAC_FALL_TIME (((REG32(ADR_PHY_REG_22_TRX_RAMP)) & 0x00ff0000 ) >> 16)
#define GET_RG_SW_FALL_TIME (((REG32(ADR_PHY_REG_22_TRX_RAMP)) & 0xff000000 ) >> 24)
#define GET_RG_ANT_SW_0 (((REG32(ADR_PHY_REG_23_ANT)) & 0x00000007 ) >> 0)
#define GET_RG_ANT_SW_1 (((REG32(ADR_PHY_REG_23_ANT)) & 0x00000038 ) >> 3)
#define GET_RG_MTX_LEN_LOWER_TH_0 (((REG32(ADR_PHY_REG_24_MTX_LEN_CNT)) & 0x00001fff ) >> 0)
#define GET_RG_MTX_LEN_UPPER_TH_0 (((REG32(ADR_PHY_REG_24_MTX_LEN_CNT)) & 0x1fff0000 ) >> 16)
#define GET_RG_MTX_LEN_CNT_EN_0 (((REG32(ADR_PHY_REG_24_MTX_LEN_CNT)) & 0x80000000 ) >> 31)
#define GET_RG_MTX_LEN_LOWER_TH_1 (((REG32(ADR_PHY_REG_25_MTX_LEN_CNT)) & 0x00001fff ) >> 0)
#define GET_RG_MTX_LEN_UPPER_TH_1 (((REG32(ADR_PHY_REG_25_MTX_LEN_CNT)) & 0x1fff0000 ) >> 16)
#define GET_RG_MTX_LEN_CNT_EN_1 (((REG32(ADR_PHY_REG_25_MTX_LEN_CNT)) & 0x80000000 ) >> 31)
#define GET_RG_MRX_LEN_LOWER_TH_0 (((REG32(ADR_PHY_REG_26_MRX_LEN_CNT)) & 0x00001fff ) >> 0)
#define GET_RG_MRX_LEN_UPPER_TH_0 (((REG32(ADR_PHY_REG_26_MRX_LEN_CNT)) & 0x1fff0000 ) >> 16)
#define GET_RG_MRX_LEN_CNT_EN_0 (((REG32(ADR_PHY_REG_26_MRX_LEN_CNT)) & 0x80000000 ) >> 31)
#define GET_RG_MRX_LEN_LOWER_TH_1 (((REG32(ADR_PHY_REG_27_MRX_LEN_CNT)) & 0x00001fff ) >> 0)
#define GET_RG_MRX_LEN_UPPER_TH_1 (((REG32(ADR_PHY_REG_27_MRX_LEN_CNT)) & 0x1fff0000 ) >> 16)
#define GET_RG_MRX_LEN_CNT_EN_1 (((REG32(ADR_PHY_REG_27_MRX_LEN_CNT)) & 0x80000000 ) >> 31)
#define GET_RO_MTX_LEN_CNT_1 (((REG32(ADR_PHY_READ_REG_04)) & 0x0000ffff ) >> 0)
#define GET_RO_MTX_LEN_CNT_0 (((REG32(ADR_PHY_READ_REG_04)) & 0xffff0000 ) >> 16)
#define GET_RO_MRX_LEN_CNT_1 (((REG32(ADR_PHY_READ_REG_05)) & 0x0000ffff ) >> 0)
#define GET_RO_MRX_LEN_CNT_0 (((REG32(ADR_PHY_READ_REG_05)) & 0xffff0000 ) >> 16)
#define GET_RG_MODE_REG_IN_16 (((REG32(ADR_PHY_REG_28_BIST)) & 0x0000ffff ) >> 0)
#define GET_RG_PARALLEL_DR_16 (((REG32(ADR_PHY_REG_28_BIST)) & 0x00100000 ) >> 20)
#define GET_RG_MBRUN_16 (((REG32(ADR_PHY_REG_28_BIST)) & 0x01000000 ) >> 24)
#define GET_RG_SHIFT_DR_16 (((REG32(ADR_PHY_REG_28_BIST)) & 0x10000000 ) >> 28)
#define GET_RG_MODE_REG_SI_16 (((REG32(ADR_PHY_REG_28_BIST)) & 0x20000000 ) >> 29)
#define GET_RG_SIMULATION_MODE_16 (((REG32(ADR_PHY_REG_28_BIST)) & 0x40000000 ) >> 30)
#define GET_RG_DBIST_MODE_16 (((REG32(ADR_PHY_REG_28_BIST)) & 0x80000000 ) >> 31)
#define GET_RO_MODE_REG_OUT_16 (((REG32(ADR_PHY_READ_REG_06_BIST)) & 0x0000ffff ) >> 0)
#define GET_RO_MODE_REG_SO_16 (((REG32(ADR_PHY_READ_REG_06_BIST)) & 0x01000000 ) >> 24)
#define GET_RO_MONITOR_BUS_16 (((REG32(ADR_PHY_READ_REG_07_BIST)) & 0x0007ffff ) >> 0)
#define GET_RG_MRX_TYPE_1 (((REG32(ADR_PHY_REG_29_MTRX_MAC)) & 0x000000ff ) >> 0)
#define GET_RG_MRX_TYPE_0 (((REG32(ADR_PHY_REG_29_MTRX_MAC)) & 0x0000ff00 ) >> 8)
#define GET_RG_MTX_TYPE_1 (((REG32(ADR_PHY_REG_29_MTRX_MAC)) & 0x00ff0000 ) >> 16)
#define GET_RG_MTX_TYPE_0 (((REG32(ADR_PHY_REG_29_MTRX_MAC)) & 0xff000000 ) >> 24)
#define GET_RO_MTX_TYPE_CNT_1 (((REG32(ADR_PHY_READ_REG_08_MTRX_MAC)) & 0x0000ffff ) >> 0)
#define GET_RO_MTX_TYPE_CNT_0 (((REG32(ADR_PHY_READ_REG_08_MTRX_MAC)) & 0xffff0000 ) >> 16)
#define GET_RO_MRX_TYPE_CNT_1 (((REG32(ADR_PHY_READ_REG_09_MTRX_MAC)) & 0x0000ffff ) >> 0)
#define GET_RO_MRX_TYPE_CNT_0 (((REG32(ADR_PHY_READ_REG_09_MTRX_MAC)) & 0xffff0000 ) >> 16)
#define GET_RG_HB_COEF0 (((REG32(ADR_PHY_REG_30_TX_UP_FIL)) & 0x00000fff ) >> 0)
#define GET_RG_HB_COEF1 (((REG32(ADR_PHY_REG_30_TX_UP_FIL)) & 0x0fff0000 ) >> 16)
#define GET_RG_HB_COEF2 (((REG32(ADR_PHY_REG_31_TX_UP_FIL)) & 0x00000fff ) >> 0)
#define GET_RG_HB_COEF3 (((REG32(ADR_PHY_REG_31_TX_UP_FIL)) & 0x0fff0000 ) >> 16)
#define GET_RG_HB_COEF4 (((REG32(ADR_PHY_REG_32_TX_UP_FIL)) & 0x00000fff ) >> 0)
#define GET_RO_TBUS_O (((REG32(ADR_PHY_READ_TBUS)) & 0x000fffff ) >> 0)
#define GET_RG_LPF4_00 (((REG32(ADR_TX_11B_FIL_COEF_00)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_01 (((REG32(ADR_TX_11B_FIL_COEF_01)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_02 (((REG32(ADR_TX_11B_FIL_COEF_02)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_03 (((REG32(ADR_TX_11B_FIL_COEF_03)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_04 (((REG32(ADR_TX_11B_FIL_COEF_04)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_05 (((REG32(ADR_TX_11B_FIL_COEF_05)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_06 (((REG32(ADR_TX_11B_FIL_COEF_06)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_07 (((REG32(ADR_TX_11B_FIL_COEF_07)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_08 (((REG32(ADR_TX_11B_FIL_COEF_08)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_09 (((REG32(ADR_TX_11B_FIL_COEF_09)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_10 (((REG32(ADR_TX_11B_FIL_COEF_10)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_11 (((REG32(ADR_TX_11B_FIL_COEF_11)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_12 (((REG32(ADR_TX_11B_FIL_COEF_12)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_13 (((REG32(ADR_TX_11B_FIL_COEF_13)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_14 (((REG32(ADR_TX_11B_FIL_COEF_14)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_15 (((REG32(ADR_TX_11B_FIL_COEF_15)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_16 (((REG32(ADR_TX_11B_FIL_COEF_16)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_17 (((REG32(ADR_TX_11B_FIL_COEF_17)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_18 (((REG32(ADR_TX_11B_FIL_COEF_18)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_19 (((REG32(ADR_TX_11B_FIL_COEF_19)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_20 (((REG32(ADR_TX_11B_FIL_COEF_20)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_21 (((REG32(ADR_TX_11B_FIL_COEF_21)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_22 (((REG32(ADR_TX_11B_FIL_COEF_22)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_23 (((REG32(ADR_TX_11B_FIL_COEF_23)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_24 (((REG32(ADR_TX_11B_FIL_COEF_24)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_25 (((REG32(ADR_TX_11B_FIL_COEF_25)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_26 (((REG32(ADR_TX_11B_FIL_COEF_26)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_27 (((REG32(ADR_TX_11B_FIL_COEF_27)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_28 (((REG32(ADR_TX_11B_FIL_COEF_28)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_29 (((REG32(ADR_TX_11B_FIL_COEF_29)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_30 (((REG32(ADR_TX_11B_FIL_COEF_30)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_31 (((REG32(ADR_TX_11B_FIL_COEF_31)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_32 (((REG32(ADR_TX_11B_FIL_COEF_32)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_33 (((REG32(ADR_TX_11B_FIL_COEF_33)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_34 (((REG32(ADR_TX_11B_FIL_COEF_34)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_35 (((REG32(ADR_TX_11B_FIL_COEF_35)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_36 (((REG32(ADR_TX_11B_FIL_COEF_36)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_37 (((REG32(ADR_TX_11B_FIL_COEF_37)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_38 (((REG32(ADR_TX_11B_FIL_COEF_38)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_39 (((REG32(ADR_TX_11B_FIL_COEF_39)) & 0x00001fff ) >> 0)
#define GET_RG_LPF4_40 (((REG32(ADR_TX_11B_FIL_COEF_40)) & 0x00001fff ) >> 0)
#define GET_RG_BP_SMB (((REG32(ADR_TX_11B_PLCP)) & 0x00002000 ) >> 13)
#define GET_RG_EN_SRVC (((REG32(ADR_TX_11B_PLCP)) & 0x00004000 ) >> 14)
#define GET_RG_DES_SPD (((REG32(ADR_TX_11B_PLCP)) & 0x00030000 ) >> 16)
#define GET_RG_BB_11B_RISE_TIME (((REG32(ADR_TX_11B_RAMP)) & 0x000000ff ) >> 0)
#define GET_RG_BB_11B_FALL_TIME (((REG32(ADR_TX_11B_RAMP)) & 0x0000ff00 ) >> 8)
#define GET_RG_WR_TX_EN_CNT_RST_N (((REG32(ADR_TX_11B_EN_CNT_RST_N)) & 0x00000001 ) >> 0)
#define GET_RO_TX_EN_CNT (((REG32(ADR_TX_11B_EN_CNT)) & 0x0000ffff ) >> 0)
#define GET_RO_TX_CNT (((REG32(ADR_TX_11B_PKT_GEN_CNT)) & 0xffffffff ) >> 0)
#define GET_RG_POS_DES_11B_L_EXT (((REG32(ADR_RX_11B_DES_DLY)) & 0x0000000f ) >> 0)
#define GET_RG_PRE_DES_11B_DLY (((REG32(ADR_RX_11B_DES_DLY)) & 0x000000f0 ) >> 4)
#define GET_RG_CNT_CCA_LMT (((REG32(ADR_RX_11B_CCA_0)) & 0x000f0000 ) >> 16)
#define GET_RG_BYPASS_DESCRAMBLER (((REG32(ADR_RX_11B_CCA_0)) & 0x20000000 ) >> 29)
#define GET_RG_BYPASS_AGC (((REG32(ADR_RX_11B_CCA_0)) & 0x80000000 ) >> 31)
#define GET_RG_CCA_BIT_CNT_LMT_RX (((REG32(ADR_RX_11B_CCA_1)) & 0x000000f0 ) >> 4)
#define GET_RG_CCA_SCALE_BF (((REG32(ADR_RX_11B_CCA_1)) & 0x007f0000 ) >> 16)
#define GET_RG_PEAK_IDX_CNT_SEL (((REG32(ADR_RX_11B_CCA_1)) & 0x30000000 ) >> 28)
#define GET_RG_TR_KI_T2 (((REG32(ADR_RX_11B_TR_KP_KI_0)) & 0x00000007 ) >> 0)
#define GET_RG_TR_KP_T2 (((REG32(ADR_RX_11B_TR_KP_KI_0)) & 0x00000070 ) >> 4)
#define GET_RG_TR_KI_T1 (((REG32(ADR_RX_11B_TR_KP_KI_0)) & 0x00000700 ) >> 8)
#define GET_RG_TR_KP_T1 (((REG32(ADR_RX_11B_TR_KP_KI_0)) & 0x00007000 ) >> 12)
#define GET_RG_CR_KI_T1 (((REG32(ADR_RX_11B_TR_KP_KI_1)) & 0x00070000 ) >> 16)
#define GET_RG_CR_KP_T1 (((REG32(ADR_RX_11B_TR_KP_KI_1)) & 0x00700000 ) >> 20)
#define GET_RG_CHIP_CNT_SLICER (((REG32(ADR_RX_11B_CE_CNT_THRESHOLD)) & 0x0000001f ) >> 0)
#define GET_RG_CE_T4_CNT_LMT (((REG32(ADR_RX_11B_CE_CNT_THRESHOLD)) & 0x0000ff00 ) >> 8)
#define GET_RG_CE_T3_CNT_LMT (((REG32(ADR_RX_11B_CE_CNT_THRESHOLD)) & 0x00ff0000 ) >> 16)
#define GET_RG_CE_T2_CNT_LMT (((REG32(ADR_RX_11B_CE_CNT_THRESHOLD)) & 0xff000000 ) >> 24)
#define GET_RG_CE_MU_T1 (((REG32(ADR_RX_11B_CE_MU_0)) & 0x00000007 ) >> 0)
#define GET_RG_CE_DLY_SEL (((REG32(ADR_RX_11B_CE_MU_0)) & 0x003f0000 ) >> 16)
#define GET_RG_CE_MU_T8 (((REG32(ADR_RX_11B_CE_MU_1)) & 0x00000007 ) >> 0)
#define GET_RG_CE_MU_T7 (((REG32(ADR_RX_11B_CE_MU_1)) & 0x00000070 ) >> 4)
#define GET_RG_CE_MU_T6 (((REG32(ADR_RX_11B_CE_MU_1)) & 0x00000700 ) >> 8)
#define GET_RG_CE_MU_T5 (((REG32(ADR_RX_11B_CE_MU_1)) & 0x00007000 ) >> 12)
#define GET_RG_CE_MU_T4 (((REG32(ADR_RX_11B_CE_MU_1)) & 0x00070000 ) >> 16)
#define GET_RG_CE_MU_T3 (((REG32(ADR_RX_11B_CE_MU_1)) & 0x00700000 ) >> 20)
#define GET_RG_CE_MU_T2 (((REG32(ADR_RX_11B_CE_MU_1)) & 0x07000000 ) >> 24)
#define GET_RG_EQ_MU_FB_T2 (((REG32(ADR_RX_11B_EQ_MU_0)) & 0x0000000f ) >> 0)
#define GET_RG_EQ_MU_FF_T2 (((REG32(ADR_RX_11B_EQ_MU_0)) & 0x000000f0 ) >> 4)
#define GET_RG_EQ_MU_FB_T1 (((REG32(ADR_RX_11B_EQ_MU_0)) & 0x000f0000 ) >> 16)
#define GET_RG_EQ_MU_FF_T1 (((REG32(ADR_RX_11B_EQ_MU_0)) & 0x00f00000 ) >> 20)
#define GET_RG_EQ_MU_FB_T4 (((REG32(ADR_RX_11B_EQ_MU_1)) & 0x0000000f ) >> 0)
#define GET_RG_EQ_MU_FF_T4 (((REG32(ADR_RX_11B_EQ_MU_1)) & 0x000000f0 ) >> 4)
#define GET_RG_EQ_MU_FB_T3 (((REG32(ADR_RX_11B_EQ_MU_1)) & 0x000f0000 ) >> 16)
#define GET_RG_EQ_MU_FF_T3 (((REG32(ADR_RX_11B_EQ_MU_1)) & 0x00f00000 ) >> 20)
#define GET_RG_EQ_KI_T2 (((REG32(ADR_RX_11B_EQ_CR_KP_KI)) & 0x00000700 ) >> 8)
#define GET_RG_EQ_KP_T2 (((REG32(ADR_RX_11B_EQ_CR_KP_KI)) & 0x00007000 ) >> 12)
#define GET_RG_EQ_KI_T1 (((REG32(ADR_RX_11B_EQ_CR_KP_KI)) & 0x00070000 ) >> 16)
#define GET_RG_EQ_KP_T1 (((REG32(ADR_RX_11B_EQ_CR_KP_KI)) & 0x00700000 ) >> 20)
#define GET_RG_TR_LPF_RATE (((REG32(ADR_RX_11B_LPF_RATE)) & 0x003fffff ) >> 0)
#define GET_RG_CE_BIT_CNT_LMT (((REG32(ADR_RX_11B_CIT_CNT_THRESHOLD)) & 0x0000007f ) >> 0)
#define GET_RG_CE_CH_MAIN_SET (((REG32(ADR_RX_11B_CIT_CNT_THRESHOLD)) & 0x00000080 ) >> 7)
#define GET_RG_TC_BIT_CNT_LMT (((REG32(ADR_RX_11B_CIT_CNT_THRESHOLD)) & 0x00007f00 ) >> 8)
#define GET_RG_CR_BIT_CNT_LMT (((REG32(ADR_RX_11B_CIT_CNT_THRESHOLD)) & 0x007f0000 ) >> 16)
#define GET_RG_TR_BIT_CNT_LMT (((REG32(ADR_RX_11B_CIT_CNT_THRESHOLD)) & 0x7f000000 ) >> 24)
#define GET_RG_EQ_MAIN_TAP_MAN (((REG32(ADR_RX_11B_EQ_CH_MAIN_TAP)) & 0x00000001 ) >> 0)
#define GET_RG_EQ_MAIN_TAP_COEF (((REG32(ADR_RX_11B_EQ_CH_MAIN_TAP)) & 0x07ff0000 ) >> 16)
#define GET_RG_PWRON_DLY_TH_11B (((REG32(ADR_RX_11B_SEARCH_CNT_TH)) & 0x000000ff ) >> 0)
#define GET_RG_SFD_BIT_CNT_LMT (((REG32(ADR_RX_11B_SEARCH_CNT_TH)) & 0x00ff0000 ) >> 16)
#define GET_RG_CCA_PWR_TH_RX (((REG32(ADR_RX_11B_CCA_CONTROL)) & 0x00007fff ) >> 0)
#define GET_RG_CCA_PWR_CNT_TH (((REG32(ADR_RX_11B_CCA_CONTROL)) & 0x001f0000 ) >> 16)
#define GET_B_FREQ_OS (((REG32(ADR_RX_11B_FREQUENCY_OFFSET)) & 0x000007ff ) >> 0)
#define GET_B_SNR (((REG32(ADR_RX_11B_SNR_RSSI)) & 0x0000007f ) >> 0)
#define GET_B_RCPI (((REG32(ADR_RX_11B_SNR_RSSI)) & 0x007f0000 ) >> 16)
#define GET_CRC_CNT (((REG32(ADR_RX_11B_SFD_CRC_CNT)) & 0x0000ffff ) >> 0)
#define GET_SFD_CNT (((REG32(ADR_RX_11B_SFD_CRC_CNT)) & 0xffff0000 ) >> 16)
#define GET_B_PACKET_ERR_CNT (((REG32(ADR_RX_11B_PKT_ERR_AND_PKT_ERR_CNT)) & 0x0000ffff ) >> 0)
#define GET_PACKET_ERR (((REG32(ADR_RX_11B_PKT_ERR_AND_PKT_ERR_CNT)) & 0x00010000 ) >> 16)
#define GET_B_PACKET_CNT (((REG32(ADR_RX_11B_PKT_CCA_AND_PKT_CNT)) & 0x0000ffff ) >> 0)
#define GET_B_CCA_CNT (((REG32(ADR_RX_11B_PKT_CCA_AND_PKT_CNT)) & 0xffff0000 ) >> 16)
#define GET_B_LENGTH_FIELD (((REG32(ADR_RX_11B_SFD_FILED_0)) & 0x0000ffff ) >> 0)
#define GET_SFD_FIELD (((REG32(ADR_RX_11B_SFD_FILED_0)) & 0xffff0000 ) >> 16)
#define GET_SIGNAL_FIELD (((REG32(ADR_RX_11B_SFD_FIELD_1)) & 0x000000ff ) >> 0)
#define GET_B_SERVICE_FIELD (((REG32(ADR_RX_11B_SFD_FIELD_1)) & 0x0000ff00 ) >> 8)
#define GET_CRC_CORRECT (((REG32(ADR_RX_11B_SFD_FIELD_1)) & 0x00010000 ) >> 16)
#define GET_DEBUG_SEL (((REG32(ADR_RX_11B_PKT_STAT_EN)) & 0x0000000f ) >> 0)
#define GET_RG_PACKET_STAT_EN_11B (((REG32(ADR_RX_11B_PKT_STAT_EN)) & 0x00100000 ) >> 20)
#define GET_RG_BIT_REVERSE (((REG32(ADR_RX_11B_PKT_STAT_EN)) & 0x00200000 ) >> 21)
#define GET_RX_PHY_11B_SOFT_RST_N (((REG32(ADR_RX_11B_SOFT_RST)) & 0x00000001 ) >> 0)
#define GET_RG_CE_BYPASS_TAP (((REG32(ADR_RX_11B_SOFT_RST)) & 0x000000f0 ) >> 4)
#define GET_RG_EQ_BYPASS_FBW_TAP (((REG32(ADR_RX_11B_SOFT_RST)) & 0x00000f00 ) >> 8)
#define GET_RG_BB_11GN_RISE_TIME (((REG32(ADR_TX_11GN_RAMP)) & 0x000000ff ) >> 0)
#define GET_RG_BB_11GN_FALL_TIME (((REG32(ADR_TX_11GN_RAMP)) & 0x0000ff00 ) >> 8)
#define GET_RG_HTCARR52_FFT_SCALE (((REG32(ADR_TX_11GN_PLCP)) & 0x000003ff ) >> 0)
#define GET_RG_HTCARR56_FFT_SCALE (((REG32(ADR_TX_11GN_PLCP)) & 0x003ff000 ) >> 12)
#define GET_RG_PACKET_STAT_EN (((REG32(ADR_TX_11GN_PLCP)) & 0x00800000 ) >> 23)
#define GET_RG_SMB_DEF (((REG32(ADR_TX_11GN_PLCP)) & 0x7f000000 ) >> 24)
#define GET_RG_CONTINUOUS_DATA_11GN (((REG32(ADR_TX_11GN_PLCP)) & 0x80000000 ) >> 31)
#define GET_RO_TX_CNT_R (((REG32(ADR_TX_11GN_PKT_GEN_CNT)) & 0xffffffff ) >> 0)
#define GET_RO_PACKET_ERR_CNT (((REG32(ADR_TX_11GN_PLCP_CRC_ERR_CNT)) & 0x0000ffff ) >> 0)
#define GET_RG_POS_DES_11GN_L_EXT (((REG32(ADR_RX_11GN_DES_DLY)) & 0x0000000f ) >> 0)
#define GET_RG_PRE_DES_11GN_DLY (((REG32(ADR_RX_11GN_DES_DLY)) & 0x000000f0 ) >> 4)
#define GET_RG_TR_LPF_KI_G_T1 (((REG32(ADR_RX_11GN_TR_0)) & 0x0000000f ) >> 0)
#define GET_RG_TR_LPF_KP_G_T1 (((REG32(ADR_RX_11GN_TR_0)) & 0x000000f0 ) >> 4)
#define GET_RG_TR_CNT_T1 (((REG32(ADR_RX_11GN_TR_0)) & 0x0000ff00 ) >> 8)
#define GET_RG_TR_LPF_KI_G_T0 (((REG32(ADR_RX_11GN_TR_0)) & 0x000f0000 ) >> 16)
#define GET_RG_TR_LPF_KP_G_T0 (((REG32(ADR_RX_11GN_TR_0)) & 0x00f00000 ) >> 20)
#define GET_RG_TR_CNT_T0 (((REG32(ADR_RX_11GN_TR_0)) & 0xff000000 ) >> 24)
#define GET_RG_TR_LPF_KI_G_T2 (((REG32(ADR_RX_11GN_TR_1)) & 0x0000000f ) >> 0)
#define GET_RG_TR_LPF_KP_G_T2 (((REG32(ADR_RX_11GN_TR_1)) & 0x000000f0 ) >> 4)
#define GET_RG_TR_CNT_T2 (((REG32(ADR_RX_11GN_TR_1)) & 0x0000ff00 ) >> 8)
#define GET_RG_TR_LPF_KI_G (((REG32(ADR_RX_11GN_TR_2)) & 0x0000000f ) >> 0)
#define GET_RG_TR_LPF_KP_G (((REG32(ADR_RX_11GN_TR_2)) & 0x000000f0 ) >> 4)
#define GET_RG_TR_LPF_RATE_G (((REG32(ADR_RX_11GN_TR_2)) & 0x3fffff00 ) >> 8)
#define GET_RG_CR_LPF_KI_G (((REG32(ADR_RX_11GN_CCA_0)) & 0x00000007 ) >> 0)
#define GET_RG_SYM_BOUND_CNT (((REG32(ADR_RX_11GN_CCA_0)) & 0x00007f00 ) >> 8)
#define GET_RG_XSCOR32_RATIO (((REG32(ADR_RX_11GN_CCA_0)) & 0x007f0000 ) >> 16)
#define GET_RG_ATCOR64_CNT_LMT (((REG32(ADR_RX_11GN_CCA_0)) & 0x7f000000 ) >> 24)
#define GET_RG_ATCOR16_CNT_LMT2 (((REG32(ADR_RX_11GN_CCA_1)) & 0x00007f00 ) >> 8)
#define GET_RG_ATCOR16_CNT_LMT1 (((REG32(ADR_RX_11GN_CCA_1)) & 0x007f0000 ) >> 16)
#define GET_RG_ATCOR16_RATIO_SB (((REG32(ADR_RX_11GN_CCA_1)) & 0x7f000000 ) >> 24)
#define GET_RG_XSCOR64_CNT_LMT2 (((REG32(ADR_RX_11GN_CCA_2)) & 0x007f0000 ) >> 16)
#define GET_RG_XSCOR64_CNT_LMT1 (((REG32(ADR_RX_11GN_CCA_2)) & 0x7f000000 ) >> 24)
#define GET_RG_RX_FFT_SCALE (((REG32(ADR_RX_11GN_CCA_FFT_SCALE)) & 0x000003ff ) >> 0)
#define GET_RG_VITERBI_AB_SWAP (((REG32(ADR_RX_11GN_CCA_FFT_SCALE)) & 0x00010000 ) >> 16)
#define GET_RG_ATCOR16_CNT_TH (((REG32(ADR_RX_11GN_CCA_FFT_SCALE)) & 0x0f000000 ) >> 24)
#define GET_RG_NORMSQUARE_LOW_SNR_7 (((REG32(ADR_RX_11GN_SOFT_DEMAP_0)) & 0x000000ff ) >> 0)
#define GET_RG_NORMSQUARE_LOW_SNR_6 (((REG32(ADR_RX_11GN_SOFT_DEMAP_0)) & 0x0000ff00 ) >> 8)
#define GET_RG_NORMSQUARE_LOW_SNR_5 (((REG32(ADR_RX_11GN_SOFT_DEMAP_0)) & 0x00ff0000 ) >> 16)
#define GET_RG_NORMSQUARE_LOW_SNR_4 (((REG32(ADR_RX_11GN_SOFT_DEMAP_0)) & 0xff000000 ) >> 24)
#define GET_RG_NORMSQUARE_LOW_SNR_8 (((REG32(ADR_RX_11GN_SOFT_DEMAP_1)) & 0xff000000 ) >> 24)
#define GET_RG_NORMSQUARE_SNR_3 (((REG32(ADR_RX_11GN_SOFT_DEMAP_2)) & 0x000000ff ) >> 0)
#define GET_RG_NORMSQUARE_SNR_2 (((REG32(ADR_RX_11GN_SOFT_DEMAP_2)) & 0x0000ff00 ) >> 8)
#define GET_RG_NORMSQUARE_SNR_1 (((REG32(ADR_RX_11GN_SOFT_DEMAP_2)) & 0x00ff0000 ) >> 16)
#define GET_RG_NORMSQUARE_SNR_0 (((REG32(ADR_RX_11GN_SOFT_DEMAP_2)) & 0xff000000 ) >> 24)
#define GET_RG_NORMSQUARE_SNR_7 (((REG32(ADR_RX_11GN_SOFT_DEMAP_3)) & 0x000000ff ) >> 0)
#define GET_RG_NORMSQUARE_SNR_6 (((REG32(ADR_RX_11GN_SOFT_DEMAP_3)) & 0x0000ff00 ) >> 8)
#define GET_RG_NORMSQUARE_SNR_5 (((REG32(ADR_RX_11GN_SOFT_DEMAP_3)) & 0x00ff0000 ) >> 16)
#define GET_RG_NORMSQUARE_SNR_4 (((REG32(ADR_RX_11GN_SOFT_DEMAP_3)) & 0xff000000 ) >> 24)
#define GET_RG_NORMSQUARE_SNR_8 (((REG32(ADR_RX_11GN_SOFT_DEMAP_4)) & 0xff000000 ) >> 24)
#define GET_RG_SNR_TH_64QAM (((REG32(ADR_RX_11GN_SOFT_DEMAP_5)) & 0x0000007f ) >> 0)
#define GET_RG_SNR_TH_16QAM (((REG32(ADR_RX_11GN_SOFT_DEMAP_5)) & 0x00007f00 ) >> 8)
#define GET_RG_ATCOR16_CNT_PLUS_LMT2 (((REG32(ADR_RX_11GN_SYM_BOUND_0)) & 0x0000007f ) >> 0)
#define GET_RG_ATCOR16_CNT_PLUS_LMT1 (((REG32(ADR_RX_11GN_SYM_BOUND_0)) & 0x00007f00 ) >> 8)
#define GET_RG_SYM_BOUND_METHOD (((REG32(ADR_RX_11GN_SYM_BOUND_0)) & 0x00030000 ) >> 16)
#define GET_RG_PWRON_DLY_TH_11GN (((REG32(ADR_RX_11GN_SYM_BOUND_1)) & 0x000000ff ) >> 0)
#define GET_RG_SB_START_CNT (((REG32(ADR_RX_11GN_SYM_BOUND_1)) & 0x00007f00 ) >> 8)
#define GET_RG_POW16_CNT_TH (((REG32(ADR_RX_11GN_CCA_PWR)) & 0x000000f0 ) >> 4)
#define GET_RG_POW16_SHORT_CNT_LMT (((REG32(ADR_RX_11GN_CCA_PWR)) & 0x00000700 ) >> 8)
#define GET_RG_POW16_TH_L (((REG32(ADR_RX_11GN_CCA_PWR)) & 0x7f000000 ) >> 24)
#define GET_RG_XSCOR16_SHORT_CNT_LMT (((REG32(ADR_RX_11GN_CCA_CNT)) & 0x00000007 ) >> 0)
#define GET_RG_XSCOR16_RATIO (((REG32(ADR_RX_11GN_CCA_CNT)) & 0x00007f00 ) >> 8)
#define GET_RG_ATCOR16_SHORT_CNT_LMT (((REG32(ADR_RX_11GN_CCA_CNT)) & 0x00070000 ) >> 16)
#define GET_RG_ATCOR16_RATIO_CCD (((REG32(ADR_RX_11GN_CCA_CNT)) & 0x7f000000 ) >> 24)
#define GET_RG_ATCOR64_ACC_LMT (((REG32(ADR_RX_11GN_CCA_ATCOR_RE_CHECK)) & 0x0000007f ) >> 0)
#define GET_RG_ATCOR16_SHORT_CNT_LMT2 (((REG32(ADR_RX_11GN_CCA_ATCOR_RE_CHECK)) & 0x00070000 ) >> 16)
#define GET_RG_VITERBI_TB_BITS (((REG32(ADR_RX_11GN_VTB_TB)) & 0xff000000 ) >> 24)
#define GET_RG_CR_CNT_UPDATE (((REG32(ADR_RX_11GN_ERR_UPDATE)) & 0x000000ff ) >> 0)
#define GET_RG_TR_CNT_UPDATE (((REG32(ADR_RX_11GN_ERR_UPDATE)) & 0x00ff0000 ) >> 16)
#define GET_RG_BYPASS_CPE_MA (((REG32(ADR_RX_11GN_SHORT_GI)) & 0x00000010 ) >> 4)
#define GET_RG_PILOT_BNDRY_SHIFT (((REG32(ADR_RX_11GN_SHORT_GI)) & 0x00000700 ) >> 8)
#define GET_RG_EQ_SHORT_GI_SHIFT (((REG32(ADR_RX_11GN_SHORT_GI)) & 0x00007000 ) >> 12)
#define GET_RG_FFT_WDW_SHORT_SHIFT (((REG32(ADR_RX_11GN_SHORT_GI)) & 0x00070000 ) >> 16)
#define GET_RG_CHSMTH_COEF (((REG32(ADR_RX_11GN_CHANNEL_UPDATE)) & 0x00030000 ) >> 16)
#define GET_RG_CHSMTH_EN (((REG32(ADR_RX_11GN_CHANNEL_UPDATE)) & 0x00040000 ) >> 18)
#define GET_RG_CHEST_DD_FACTOR (((REG32(ADR_RX_11GN_CHANNEL_UPDATE)) & 0x07000000 ) >> 24)
#define GET_RG_CH_UPDATE (((REG32(ADR_RX_11GN_CHANNEL_UPDATE)) & 0x80000000 ) >> 31)
#define GET_RG_FMT_DET_MM_TH (((REG32(ADR_RX_11GN_PKT_FORMAT_0)) & 0x000000ff ) >> 0)
#define GET_RG_FMT_DET_GF_TH (((REG32(ADR_RX_11GN_PKT_FORMAT_0)) & 0x0000ff00 ) >> 8)
#define GET_RG_DO_NOT_CHECK_L_RATE (((REG32(ADR_RX_11GN_PKT_FORMAT_0)) & 0x02000000 ) >> 25)
#define GET_RG_FMT_DET_LENGTH_TH (((REG32(ADR_RX_11GN_PKT_FORMAT_1)) & 0x0000ffff ) >> 0)
#define GET_RG_L_LENGTH_MAX (((REG32(ADR_RX_11GN_PKT_FORMAT_1)) & 0xffff0000 ) >> 16)
#define GET_RG_TX_TIME_EXT (((REG32(ADR_RX_11GN_TX_TIME)) & 0x000000ff ) >> 0)
#define GET_RG_MAC_DES_SPACE (((REG32(ADR_RX_11GN_TX_TIME)) & 0x00f00000 ) >> 20)
#define GET_RG_TR_LPF_STBC_GF_KI_G (((REG32(ADR_RX_11GN_STBC_TR_KP_KI)) & 0x0000000f ) >> 0)
#define GET_RG_TR_LPF_STBC_GF_KP_G (((REG32(ADR_RX_11GN_STBC_TR_KP_KI)) & 0x000000f0 ) >> 4)
#define GET_RG_TR_LPF_STBC_MF_KI_G (((REG32(ADR_RX_11GN_STBC_TR_KP_KI)) & 0x00000f00 ) >> 8)
#define GET_RG_TR_LPF_STBC_MF_KP_G (((REG32(ADR_RX_11GN_STBC_TR_KP_KI)) & 0x0000f000 ) >> 12)
#define GET_RG_MODE_REG_IN_80 (((REG32(ADR_RX_11GN_BIST_0)) & 0x0001ffff ) >> 0)
#define GET_RG_PARALLEL_DR_80 (((REG32(ADR_RX_11GN_BIST_0)) & 0x00100000 ) >> 20)
#define GET_RG_MBRUN_80 (((REG32(ADR_RX_11GN_BIST_0)) & 0x01000000 ) >> 24)
#define GET_RG_SHIFT_DR_80 (((REG32(ADR_RX_11GN_BIST_0)) & 0x10000000 ) >> 28)
#define GET_RG_MODE_REG_SI_80 (((REG32(ADR_RX_11GN_BIST_0)) & 0x20000000 ) >> 29)
#define GET_RG_SIMULATION_MODE_80 (((REG32(ADR_RX_11GN_BIST_0)) & 0x40000000 ) >> 30)
#define GET_RG_DBIST_MODE_80 (((REG32(ADR_RX_11GN_BIST_0)) & 0x80000000 ) >> 31)
#define GET_RG_MODE_REG_IN_64 (((REG32(ADR_RX_11GN_BIST_1)) & 0x0000ffff ) >> 0)
#define GET_RG_PARALLEL_DR_64 (((REG32(ADR_RX_11GN_BIST_1)) & 0x00100000 ) >> 20)
#define GET_RG_MBRUN_64 (((REG32(ADR_RX_11GN_BIST_1)) & 0x01000000 ) >> 24)
#define GET_RG_SHIFT_DR_64 (((REG32(ADR_RX_11GN_BIST_1)) & 0x10000000 ) >> 28)
#define GET_RG_MODE_REG_SI_64 (((REG32(ADR_RX_11GN_BIST_1)) & 0x20000000 ) >> 29)
#define GET_RG_SIMULATION_MODE_64 (((REG32(ADR_RX_11GN_BIST_1)) & 0x40000000 ) >> 30)
#define GET_RG_DBIST_MODE_64 (((REG32(ADR_RX_11GN_BIST_1)) & 0x80000000 ) >> 31)
#define GET_RO_MODE_REG_OUT_80 (((REG32(ADR_RX_11GN_BIST_2)) & 0x0001ffff ) >> 0)
#define GET_RO_MODE_REG_SO_80 (((REG32(ADR_RX_11GN_BIST_2)) & 0x01000000 ) >> 24)
#define GET_RO_MONITOR_BUS_80 (((REG32(ADR_RX_11GN_BIST_3)) & 0x003fffff ) >> 0)
#define GET_RO_MODE_REG_OUT_64 (((REG32(ADR_RX_11GN_BIST_4)) & 0x0000ffff ) >> 0)
#define GET_RO_MODE_REG_SO_64 (((REG32(ADR_RX_11GN_BIST_4)) & 0x01000000 ) >> 24)
#define GET_RO_MONITOR_BUS_64 (((REG32(ADR_RX_11GN_BIST_5)) & 0x0007ffff ) >> 0)
#define GET_RO_SPECTRUM_DATA (((REG32(ADR_RX_11GN_SPECTRUM_ANALYZER)) & 0xffffffff ) >> 0)
#define GET_GN_SNR (((REG32(ADR_RX_11GN_READ_0)) & 0x0000007f ) >> 0)
#define GET_GN_NOISE_PWR (((REG32(ADR_RX_11GN_READ_0)) & 0x00007f00 ) >> 8)
#define GET_GN_RCPI (((REG32(ADR_RX_11GN_READ_0)) & 0x007f0000 ) >> 16)
#define GET_GN_SIGNAL_PWR (((REG32(ADR_RX_11GN_READ_0)) & 0x7f000000 ) >> 24)
#define GET_RO_FREQ_OS_LTS (((REG32(ADR_RX_11GN_FREQ_OFFSET)) & 0x00007fff ) >> 0)
#define GET_CSTATE (((REG32(ADR_RX_11GN_FREQ_OFFSET)) & 0x000f0000 ) >> 16)
#define GET_SIGNAL_FIELD0 (((REG32(ADR_RX_11GN_SIGNAL_FIELD_0)) & 0x00ffffff ) >> 0)
#define GET_SIGNAL_FIELD1 (((REG32(ADR_RX_11GN_SIGNAL_FIELD_1)) & 0x00ffffff ) >> 0)
#define GET_GN_PACKET_ERR_CNT (((REG32(ADR_RX_11GN_PKT_ERR_CNT)) & 0x0000ffff ) >> 0)
#define GET_GN_PACKET_CNT (((REG32(ADR_RX_11GN_PKT_CCA_AND_PKT_CNT)) & 0x0000ffff ) >> 0)
#define GET_GN_CCA_CNT (((REG32(ADR_RX_11GN_PKT_CCA_AND_PKT_CNT)) & 0xffff0000 ) >> 16)
#define GET_GN_LENGTH_FIELD (((REG32(ADR_RX_11GN_SERVICE_LENGTH_FIELD)) & 0x0000ffff ) >> 0)
#define GET_GN_SERVICE_FIELD (((REG32(ADR_RX_11GN_SERVICE_LENGTH_FIELD)) & 0xffff0000 ) >> 16)
#define GET_RO_HT_MCS_40M (((REG32(ADR_RX_11GN_RATE)) & 0x0000007f ) >> 0)
#define GET_RO_L_RATE_40M (((REG32(ADR_RX_11GN_RATE)) & 0x00003f00 ) >> 8)
#define GET_RG_DAGC_CNT_TH (((REG32(ADR_RX_11GN_STAT_EN)) & 0x00000003 ) >> 0)
#define GET_RG_PACKET_STAT_EN_11GN (((REG32(ADR_RX_11GN_STAT_EN)) & 0x00100000 ) >> 20)
#define GET_RX_PHY_11GN_SOFT_RST_N (((REG32(ADR_RX_11GN_SOFT_RST)) & 0x00000001 ) >> 0)
#define GET_RG_RIFS_EN (((REG32(ADR_RX_11GN_SOFT_RST)) & 0x00000002 ) >> 1)
#define GET_RG_STBC_EN (((REG32(ADR_RX_11GN_SOFT_RST)) & 0x00000004 ) >> 2)
#define GET_RG_COR_SEL (((REG32(ADR_RX_11GN_SOFT_RST)) & 0x00000008 ) >> 3)
#define GET_RG_INI_PHASE (((REG32(ADR_RX_11GN_SOFT_RST)) & 0x00000030 ) >> 4)
#define GET_RG_HT_LTF_SEL_EQ (((REG32(ADR_RX_11GN_SOFT_RST)) & 0x00000040 ) >> 6)
#define GET_RG_HT_LTF_SEL_PILOT (((REG32(ADR_RX_11GN_SOFT_RST)) & 0x00000080 ) >> 7)
#define GET_RG_CCA_PWR_SEL (((REG32(ADR_RX_11GN_SOFT_RST)) & 0x00000200 ) >> 9)
#define GET_RG_CCA_XSCOR_PWR_SEL (((REG32(ADR_RX_11GN_SOFT_RST)) & 0x00000400 ) >> 10)
#define GET_RG_CCA_XSCOR_AVGPWR_SEL (((REG32(ADR_RX_11GN_SOFT_RST)) & 0x00000800 ) >> 11)
#define GET_RG_DEBUG_SEL (((REG32(ADR_RX_11GN_SOFT_RST)) & 0x0000f000 ) >> 12)
#define GET_RG_POST_CLK_EN (((REG32(ADR_RX_11GN_SOFT_RST)) & 0x00010000 ) >> 16)
#define GET_IQCAL_RF_TX_EN (((REG32(ADR_RF_CONTROL_0)) & 0x00000001 ) >> 0)
#define GET_IQCAL_RF_TX_PA_EN (((REG32(ADR_RF_CONTROL_0)) & 0x00000002 ) >> 1)
#define GET_IQCAL_RF_TX_DAC_EN (((REG32(ADR_RF_CONTROL_0)) & 0x00000004 ) >> 2)
#define GET_IQCAL_RF_RX_AGC (((REG32(ADR_RF_CONTROL_0)) & 0x00000008 ) >> 3)
#define GET_IQCAL_RF_PGAG (((REG32(ADR_RF_CONTROL_0)) & 0x00000f00 ) >> 8)
#define GET_IQCAL_RF_RFG (((REG32(ADR_RF_CONTROL_0)) & 0x00003000 ) >> 12)
#define GET_RG_TONEGEN_FREQ (((REG32(ADR_RF_CONTROL_0)) & 0x007f0000 ) >> 16)
#define GET_RG_TONEGEN_EN (((REG32(ADR_RF_CONTROL_0)) & 0x00800000 ) >> 23)
#define GET_RG_TONEGEN_INIT_PH (((REG32(ADR_RF_CONTROL_0)) & 0x7f000000 ) >> 24)
#define GET_RG_TONEGEN2_FREQ (((REG32(ADR_RF_CONTROL_1)) & 0x0000007f ) >> 0)
#define GET_RG_TONEGEN2_EN (((REG32(ADR_RF_CONTROL_1)) & 0x00000080 ) >> 7)
#define GET_RG_TONEGEN2_SCALE (((REG32(ADR_RF_CONTROL_1)) & 0x0000ff00 ) >> 8)
#define GET_RG_TXIQ_CLP_THD_I (((REG32(ADR_TX_IQ_CONTROL_0)) & 0x000003ff ) >> 0)
#define GET_RG_TXIQ_CLP_THD_Q (((REG32(ADR_TX_IQ_CONTROL_0)) & 0x03ff0000 ) >> 16)
#define GET_RG_TX_I_SCALE (((REG32(ADR_TX_IQ_CONTROL_1)) & 0x000000ff ) >> 0)
#define GET_RG_TX_Q_SCALE (((REG32(ADR_TX_IQ_CONTROL_1)) & 0x0000ff00 ) >> 8)
#define GET_RG_TX_IQ_SWP (((REG32(ADR_TX_IQ_CONTROL_1)) & 0x00010000 ) >> 16)
#define GET_RG_TX_SGN_OUT (((REG32(ADR_TX_IQ_CONTROL_1)) & 0x00020000 ) >> 17)
#define GET_RG_TXIQ_EMU_IDX (((REG32(ADR_TX_IQ_CONTROL_1)) & 0x003c0000 ) >> 18)
#define GET_RG_TX_IQ_SRC (((REG32(ADR_TX_IQ_CONTROL_1)) & 0x03000000 ) >> 24)
#define GET_RG_TX_I_DC (((REG32(ADR_TX_IQ_CONTROL_2)) & 0x000003ff ) >> 0)
#define GET_RG_TX_Q_DC (((REG32(ADR_TX_IQ_CONTROL_2)) & 0x03ff0000 ) >> 16)
#define GET_RG_TX_IQ_THETA (((REG32(ADR_TX_COMPENSATION_CONTROL)) & 0x0000001f ) >> 0)
#define GET_RG_TX_IQ_ALPHA (((REG32(ADR_TX_COMPENSATION_CONTROL)) & 0x00001f00 ) >> 8)
#define GET_RG_TXIQ_NOSHRINK (((REG32(ADR_TX_COMPENSATION_CONTROL)) & 0x00002000 ) >> 13)
#define GET_RG_TX_I_OFFSET (((REG32(ADR_TX_COMPENSATION_CONTROL)) & 0x00ff0000 ) >> 16)
#define GET_RG_TX_Q_OFFSET (((REG32(ADR_TX_COMPENSATION_CONTROL)) & 0xff000000 ) >> 24)
#define GET_RG_RX_IQ_THETA (((REG32(ADR_RX_COMPENSATION_CONTROL)) & 0x0000001f ) >> 0)
#define GET_RG_RX_IQ_ALPHA (((REG32(ADR_RX_COMPENSATION_CONTROL)) & 0x00001f00 ) >> 8)
#define GET_RG_RXIQ_NOSHRINK (((REG32(ADR_RX_COMPENSATION_CONTROL)) & 0x00002000 ) >> 13)
#define GET_RG_MA_DPTH (((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0x0000000f ) >> 0)
#define GET_RG_INTG_PH (((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0x000003f0 ) >> 4)
#define GET_RG_INTG_PRD (((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0x00001c00 ) >> 10)
#define GET_RG_INTG_MU (((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0x00006000 ) >> 13)
#define GET_RG_IQCAL_SPRM_SELQ (((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0x00010000 ) >> 16)
#define GET_RG_IQCAL_SPRM_EN (((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0x00020000 ) >> 17)
#define GET_RG_IQCAL_SPRM_FREQ (((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0x00fc0000 ) >> 18)
#define GET_RG_IQCAL_IQCOL_EN (((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0x01000000 ) >> 24)
#define GET_RG_IQCAL_ALPHA_ESTM_EN (((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0x02000000 ) >> 25)
#define GET_RG_IQCAL_DC_EN (((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0x04000000 ) >> 26)
#define GET_RG_PHEST_STBY (((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0x08000000 ) >> 27)
#define GET_RG_PHEST_EN (((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0x10000000 ) >> 28)
#define GET_RG_GP_DIV_EN (((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0x20000000 ) >> 29)
#define GET_RG_DPD_GAIN_EST_EN (((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0x40000000 ) >> 30)
#define GET_RG_IQCAL_MULT_OP0 (((REG32(ADR_RX_OBSERVATION_CIRCUIT_1)) & 0x000003ff ) >> 0)
#define GET_RG_IQCAL_MULT_OP1 (((REG32(ADR_RX_OBSERVATION_CIRCUIT_1)) & 0x03ff0000 ) >> 16)
#define GET_RO_IQCAL_O (((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0x000fffff ) >> 0)
#define GET_RO_IQCAL_SPRM_RDY (((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0x00100000 ) >> 20)
#define GET_RO_IQCAL_IQCOL_RDY (((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0x00200000 ) >> 21)
#define GET_RO_IQCAL_ALPHA_ESTM_RDY (((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0x00400000 ) >> 22)
#define GET_RO_IQCAL_DC_RDY (((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0x00800000 ) >> 23)
#define GET_RO_IQCAL_MULT_RDY (((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0x01000000 ) >> 24)
#define GET_RO_FFT_ENRG_RDY (((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0x02000000 ) >> 25)
#define GET_RO_PHEST_RDY (((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0x04000000 ) >> 26)
#define GET_RO_GP_DIV_RDY (((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0x08000000 ) >> 27)
#define GET_RO_GAIN_EST_RDY (((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0x10000000 ) >> 28)
#define GET_RO_AMP_O (((REG32(ADR_RX_OBSERVATION_CIRCUIT_3)) & 0x000001ff ) >> 0)
#define GET_RG_RX_I_SCALE (((REG32(ADR_RF_IQ_CONTROL_0)) & 0x000000ff ) >> 0)
#define GET_RG_RX_Q_SCALE (((REG32(ADR_RF_IQ_CONTROL_0)) & 0x0000ff00 ) >> 8)
#define GET_RG_RX_I_OFFSET (((REG32(ADR_RF_IQ_CONTROL_0)) & 0x00ff0000 ) >> 16)
#define GET_RG_RX_Q_OFFSET (((REG32(ADR_RF_IQ_CONTROL_0)) & 0xff000000 ) >> 24)
#define GET_RG_RX_IQ_SWP (((REG32(ADR_RF_IQ_CONTROL_1)) & 0x00000001 ) >> 0)
#define GET_RG_RX_SGN_IN (((REG32(ADR_RF_IQ_CONTROL_1)) & 0x00000002 ) >> 1)
#define GET_RG_RX_IQ_SRC (((REG32(ADR_RF_IQ_CONTROL_1)) & 0x0000000c ) >> 2)
#define GET_RG_ACI_GAIN (((REG32(ADR_RF_IQ_CONTROL_1)) & 0x00000ff0 ) >> 4)
#define GET_RG_FFT_EN (((REG32(ADR_RF_IQ_CONTROL_1)) & 0x00001000 ) >> 12)
#define GET_RG_FFT_MOD (((REG32(ADR_RF_IQ_CONTROL_1)) & 0x00002000 ) >> 13)
#define GET_RG_FFT_SCALE (((REG32(ADR_RF_IQ_CONTROL_1)) & 0x00ffc000 ) >> 14)
#define GET_RG_FFT_ENRG_FREQ (((REG32(ADR_RF_IQ_CONTROL_1)) & 0x3f000000 ) >> 24)
#define GET_RG_FPGA_80M_PH_UP (((REG32(ADR_RF_IQ_CONTROL_1)) & 0x40000000 ) >> 30)
#define GET_RG_FPGA_80M_PH_STP (((REG32(ADR_RF_IQ_CONTROL_1)) & 0x80000000 ) >> 31)
#define GET_RG_ADC2LA_SEL (((REG32(ADR_RF_IQ_CONTROL_2)) & 0x00000001 ) >> 0)
#define GET_RG_ADC2LA_CLKPH (((REG32(ADR_RF_IQ_CONTROL_2)) & 0x00000002 ) >> 1)
#define GET_RG_RXIQ_EMU_IDX (((REG32(ADR_RF_IQ_CONTROL_3)) & 0x0000000f ) >> 0)
#define GET_RG_IQCAL_BP_ACI (((REG32(ADR_RF_IQ_CONTROL_3)) & 0x00000010 ) >> 4)
#define GET_RG_DPD_AM_EN (((REG32(ADR_DPD_CONTROL)) & 0x00000001 ) >> 0)
#define GET_RG_DPD_PM_EN (((REG32(ADR_DPD_CONTROL)) & 0x00000002 ) >> 1)
#define GET_RG_DPD_PM_AMSEL (((REG32(ADR_DPD_CONTROL)) & 0x00000004 ) >> 2)
#define GET_RG_DPD_020_GAIN (((REG32(ADR_DPD_GAIN_TABLE_0)) & 0x000003ff ) >> 0)
#define GET_RG_DPD_040_GAIN (((REG32(ADR_DPD_GAIN_TABLE_0)) & 0x03ff0000 ) >> 16)
#define GET_RG_DPD_060_GAIN (((REG32(ADR_DPD_GAIN_TABLE_1)) & 0x000003ff ) >> 0)
#define GET_RG_DPD_080_GAIN (((REG32(ADR_DPD_GAIN_TABLE_1)) & 0x03ff0000 ) >> 16)
#define GET_RG_DPD_0A0_GAIN (((REG32(ADR_DPD_GAIN_TABLE_2)) & 0x000003ff ) >> 0)
#define GET_RG_DPD_0C0_GAIN (((REG32(ADR_DPD_GAIN_TABLE_2)) & 0x03ff0000 ) >> 16)
#define GET_RG_DPD_0D0_GAIN (((REG32(ADR_DPD_GAIN_TABLE_3)) & 0x000003ff ) >> 0)
#define GET_RG_DPD_0E0_GAIN (((REG32(ADR_DPD_GAIN_TABLE_3)) & 0x03ff0000 ) >> 16)
#define GET_RG_DPD_0F0_GAIN (((REG32(ADR_DPD_GAIN_TABLE_4)) & 0x000003ff ) >> 0)
#define GET_RG_DPD_100_GAIN (((REG32(ADR_DPD_GAIN_TABLE_4)) & 0x03ff0000 ) >> 16)
#define GET_RG_DPD_110_GAIN (((REG32(ADR_DPD_GAIN_TABLE_5)) & 0x000003ff ) >> 0)
#define GET_RG_DPD_120_GAIN (((REG32(ADR_DPD_GAIN_TABLE_5)) & 0x03ff0000 ) >> 16)
#define GET_RG_DPD_130_GAIN (((REG32(ADR_DPD_GAIN_TABLE_6)) & 0x000003ff ) >> 0)
#define GET_RG_DPD_140_GAIN (((REG32(ADR_DPD_GAIN_TABLE_6)) & 0x03ff0000 ) >> 16)
#define GET_RG_DPD_150_GAIN (((REG32(ADR_DPD_GAIN_TABLE_7)) & 0x000003ff ) >> 0)
#define GET_RG_DPD_160_GAIN (((REG32(ADR_DPD_GAIN_TABLE_7)) & 0x03ff0000 ) >> 16)
#define GET_RG_DPD_170_GAIN (((REG32(ADR_DPD_GAIN_TABLE_8)) & 0x000003ff ) >> 0)
#define GET_RG_DPD_180_GAIN (((REG32(ADR_DPD_GAIN_TABLE_8)) & 0x03ff0000 ) >> 16)
#define GET_RG_DPD_190_GAIN (((REG32(ADR_DPD_GAIN_TABLE_9)) & 0x000003ff ) >> 0)
#define GET_RG_DPD_1A0_GAIN (((REG32(ADR_DPD_GAIN_TABLE_9)) & 0x03ff0000 ) >> 16)
#define GET_RG_DPD_1B0_GAIN (((REG32(ADR_DPD_GAIN_TABLE_A)) & 0x000003ff ) >> 0)
#define GET_RG_DPD_1C0_GAIN (((REG32(ADR_DPD_GAIN_TABLE_A)) & 0x03ff0000 ) >> 16)
#define GET_RG_DPD_1D0_GAIN (((REG32(ADR_DPD_GAIN_TABLE_B)) & 0x000003ff ) >> 0)
#define GET_RG_DPD_1E0_GAIN (((REG32(ADR_DPD_GAIN_TABLE_B)) & 0x03ff0000 ) >> 16)
#define GET_RG_DPD_1F0_GAIN (((REG32(ADR_DPD_GAIN_TABLE_C)) & 0x000003ff ) >> 0)
#define GET_RG_DPD_200_GAIN (((REG32(ADR_DPD_GAIN_TABLE_C)) & 0x03ff0000 ) >> 16)
#define GET_RG_DPD_020_PH (((REG32(ADR_DPD_PH_TABLE_0)) & 0x00001fff ) >> 0)
#define GET_RG_DPD_040_PH (((REG32(ADR_DPD_PH_TABLE_0)) & 0x1fff0000 ) >> 16)
#define GET_RG_DPD_060_PH (((REG32(ADR_DPD_PH_TABLE_1)) & 0x00001fff ) >> 0)
#define GET_RG_DPD_080_PH (((REG32(ADR_DPD_PH_TABLE_1)) & 0x1fff0000 ) >> 16)
#define GET_RG_DPD_0A0_PH (((REG32(ADR_DPD_PH_TABLE_2)) & 0x00001fff ) >> 0)
#define GET_RG_DPD_0C0_PH (((REG32(ADR_DPD_PH_TABLE_2)) & 0x1fff0000 ) >> 16)
#define GET_RG_DPD_0D0_PH (((REG32(ADR_DPD_PH_TABLE_3)) & 0x00001fff ) >> 0)
#define GET_RG_DPD_0E0_PH (((REG32(ADR_DPD_PH_TABLE_3)) & 0x1fff0000 ) >> 16)
#define GET_RG_DPD_0F0_PH (((REG32(ADR_DPD_PH_TABLE_4)) & 0x00001fff ) >> 0)
#define GET_RG_DPD_100_PH (((REG32(ADR_DPD_PH_TABLE_4)) & 0x1fff0000 ) >> 16)
#define GET_RG_DPD_110_PH (((REG32(ADR_DPD_PH_TABLE_5)) & 0x00001fff ) >> 0)
#define GET_RG_DPD_120_PH (((REG32(ADR_DPD_PH_TABLE_5)) & 0x1fff0000 ) >> 16)
#define GET_RG_DPD_130_PH (((REG32(ADR_DPD_PH_TABLE_6)) & 0x00001fff ) >> 0)
#define GET_RG_DPD_140_PH (((REG32(ADR_DPD_PH_TABLE_6)) & 0x1fff0000 ) >> 16)
#define GET_RG_DPD_150_PH (((REG32(ADR_DPD_PH_TABLE_7)) & 0x00001fff ) >> 0)
#define GET_RG_DPD_160_PH (((REG32(ADR_DPD_PH_TABLE_7)) & 0x1fff0000 ) >> 16)
#define GET_RG_DPD_170_PH (((REG32(ADR_DPD_PH_TABLE_8)) & 0x00001fff ) >> 0)
#define GET_RG_DPD_180_PH (((REG32(ADR_DPD_PH_TABLE_8)) & 0x1fff0000 ) >> 16)
#define GET_RG_DPD_190_PH (((REG32(ADR_DPD_PH_TABLE_9)) & 0x00001fff ) >> 0)
#define GET_RG_DPD_1A0_PH (((REG32(ADR_DPD_PH_TABLE_9)) & 0x1fff0000 ) >> 16)
#define GET_RG_DPD_1B0_PH (((REG32(ADR_DPD_PH_TABLE_A)) & 0x00001fff ) >> 0)
#define GET_RG_DPD_1C0_PH (((REG32(ADR_DPD_PH_TABLE_A)) & 0x1fff0000 ) >> 16)
#define GET_RG_DPD_1D0_PH (((REG32(ADR_DPD_PH_TABLE_B)) & 0x00001fff ) >> 0)
#define GET_RG_DPD_1E0_PH (((REG32(ADR_DPD_PH_TABLE_B)) & 0x1fff0000 ) >> 16)
#define GET_RG_DPD_1F0_PH (((REG32(ADR_DPD_PH_TABLE_C)) & 0x00001fff ) >> 0)
#define GET_RG_DPD_200_PH (((REG32(ADR_DPD_PH_TABLE_C)) & 0x1fff0000 ) >> 16)
#define GET_RG_DPD_GAIN_EST_Y0 (((REG32(ADR_DPD_GAIN_ESTIMATION_0)) & 0x000001ff ) >> 0)
#define GET_RG_DPD_GAIN_EST_Y1 (((REG32(ADR_DPD_GAIN_ESTIMATION_0)) & 0x01ff0000 ) >> 16)
#define GET_RG_DPD_LOOP_GAIN (((REG32(ADR_DPD_GAIN_ESTIMATION_1)) & 0x000003ff ) >> 0)
#define GET_RG_DPD_GAIN_EST_X0 (((REG32(ADR_DPD_GAIN_ESTIMATION_2)) & 0x000001ff ) >> 0)
#define GET_RO_DPD_GAIN (((REG32(ADR_DPD_GAIN_ESTIMATION_2)) & 0x03ff0000 ) >> 16)
#define GET_TX_SCALE_11B (((REG32(ADR_TX_GAIN_FACTOR)) & 0x000000ff ) >> 0)
#define GET_TX_SCALE_11B_P0D5 (((REG32(ADR_TX_GAIN_FACTOR)) & 0x0000ff00 ) >> 8)
#define GET_TX_SCALE_11G (((REG32(ADR_TX_GAIN_FACTOR)) & 0x00ff0000 ) >> 16)
#define GET_TX_SCALE_11G_P0D5 (((REG32(ADR_TX_GAIN_FACTOR)) & 0xff000000 ) >> 24)
#define GET_RG_EN_MANUAL (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00000001 ) >> 0)
#define GET_RG_TX_EN (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00000002 ) >> 1)
#define GET_RG_TX_PA_EN (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00000004 ) >> 2)
#define GET_RG_TX_DAC_EN (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00000008 ) >> 3)
#define GET_RG_RX_AGC (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00000010 ) >> 4)
#define GET_RG_RX_GAIN_MANUAL (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00000020 ) >> 5)
#define GET_RG_RFG (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x000000c0 ) >> 6)
#define GET_RG_PGAG (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00000f00 ) >> 8)
#define GET_RG_MODE (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00003000 ) >> 12)
#define GET_RG_EN_TX_TRSW (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00004000 ) >> 14)
#define GET_RG_EN_SX (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00008000 ) >> 15)
#define GET_RG_EN_RX_LNA (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00010000 ) >> 16)
#define GET_RG_EN_RX_MIXER (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00020000 ) >> 17)
#define GET_RG_EN_RX_DIV2 (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00040000 ) >> 18)
#define GET_RG_EN_RX_LOBUF (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00080000 ) >> 19)
#define GET_RG_EN_RX_TZ (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00100000 ) >> 20)
#define GET_RG_EN_RX_FILTER (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00200000 ) >> 21)
#define GET_RG_EN_RX_HPF (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00400000 ) >> 22)
#define GET_RG_EN_RX_RSSI (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x00800000 ) >> 23)
#define GET_RG_EN_ADC (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x01000000 ) >> 24)
#define GET_RG_EN_TX_MOD (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x02000000 ) >> 25)
#define GET_RG_EN_TX_DIV2 (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x04000000 ) >> 26)
#define GET_RG_EN_TX_DIV2_BUF (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x08000000 ) >> 27)
#define GET_RG_EN_TX_LOBF (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x10000000 ) >> 28)
#define GET_RG_EN_RX_LOBF (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x20000000 ) >> 29)
#define GET_RG_SEL_DPLL_CLK (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x40000000 ) >> 30)
#define GET_RG_EN_CLK_960MBY13_UART (((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x80000000 ) >> 31)
#define GET_RG_EN_TX_DPD (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00000001 ) >> 0)
#define GET_RG_EN_TX_TSSI (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00000002 ) >> 1)
#define GET_RG_EN_RX_IQCAL (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00000004 ) >> 2)
#define GET_RG_EN_TX_DAC_CAL (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00000008 ) >> 3)
#define GET_RG_EN_TX_SELF_MIXER (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00000010 ) >> 4)
#define GET_RG_EN_TX_DAC_OUT (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00000020 ) >> 5)
#define GET_RG_EN_LDO_RX_FE (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00000040 ) >> 6)
#define GET_RG_EN_LDO_ABB (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00000080 ) >> 7)
#define GET_RG_EN_LDO_AFE (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00000100 ) >> 8)
#define GET_RG_EN_SX_CHPLDO (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00000200 ) >> 9)
#define GET_RG_EN_SX_LOBFLDO (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00000400 ) >> 10)
#define GET_RG_EN_IREF_RX (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00000800 ) >> 11)
#define GET_RG_EN_TX_DAC_VOUT (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00002000 ) >> 13)
#define GET_RG_EN_SX_LCK_BIN (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00004000 ) >> 14)
#define GET_RG_RTC_CAL_MODE (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00010000 ) >> 16)
#define GET_RG_EN_IQPAD_IOSW (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00020000 ) >> 17)
#define GET_RG_EN_TESTPAD_IOSW (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00040000 ) >> 18)
#define GET_RG_EN_TRXBF_BYPASS (((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0x00080000 ) >> 19)
#define GET_RG_LDO_LEVEL_RX_FE (((REG32(ADR_LDO_REGISTER)) & 0x00000007 ) >> 0)
#define GET_RG_LDO_LEVEL_ABB (((REG32(ADR_LDO_REGISTER)) & 0x00000038 ) >> 3)
#define GET_RG_LDO_LEVEL_AFE (((REG32(ADR_LDO_REGISTER)) & 0x000001c0 ) >> 6)
#define GET_RG_SX_LDO_CHP_LEVEL (((REG32(ADR_LDO_REGISTER)) & 0x00000e00 ) >> 9)
#define GET_RG_SX_LDO_LOBF_LEVEL (((REG32(ADR_LDO_REGISTER)) & 0x00007000 ) >> 12)
#define GET_RG_SX_LDO_XOSC_LEVEL (((REG32(ADR_LDO_REGISTER)) & 0x00038000 ) >> 15)
#define GET_RG_DP_LDO_LEVEL (((REG32(ADR_LDO_REGISTER)) & 0x001c0000 ) >> 18)
#define GET_RG_SX_LDO_VCO_LEVEL (((REG32(ADR_LDO_REGISTER)) & 0x00e00000 ) >> 21)
#define GET_RG_TX_LDO_TX_LEVEL (((REG32(ADR_LDO_REGISTER)) & 0x07000000 ) >> 24)
#define GET_RG_EN_RX_PADSW (((REG32(ADR_ABB_REGISTER_1)) & 0x00000001 ) >> 0)
#define GET_RG_EN_RX_TESTNODE (((REG32(ADR_ABB_REGISTER_1)) & 0x00000002 ) >> 1)
#define GET_RG_RX_ABBCFIX (((REG32(ADR_ABB_REGISTER_1)) & 0x00000004 ) >> 2)
#define GET_RG_RX_ABBCTUNE (((REG32(ADR_ABB_REGISTER_1)) & 0x000001f8 ) >> 3)
#define GET_RG_RX_ABBOUT_TRI_STATE (((REG32(ADR_ABB_REGISTER_1)) & 0x00000200 ) >> 9)
#define GET_RG_RX_ABB_N_MODE (((REG32(ADR_ABB_REGISTER_1)) & 0x00000400 ) >> 10)
#define GET_RG_RX_EN_LOOPA (((REG32(ADR_ABB_REGISTER_1)) & 0x00000800 ) >> 11)
#define GET_RG_RX_FILTERI1ST (((REG32(ADR_ABB_REGISTER_1)) & 0x00003000 ) >> 12)
#define GET_RG_RX_FILTERI2ND (((REG32(ADR_ABB_REGISTER_1)) & 0x0000c000 ) >> 14)
#define GET_RG_RX_FILTERI3RD (((REG32(ADR_ABB_REGISTER_1)) & 0x00030000 ) >> 16)
#define GET_RG_RX_FILTERI_COURSE (((REG32(ADR_ABB_REGISTER_1)) & 0x000c0000 ) >> 18)
#define GET_RG_RX_FILTERVCM (((REG32(ADR_ABB_REGISTER_1)) & 0x00300000 ) >> 20)
#define GET_RG_RX_HPF3M (((REG32(ADR_ABB_REGISTER_1)) & 0x00400000 ) >> 22)
#define GET_RG_RX_HPF300K (((REG32(ADR_ABB_REGISTER_1)) & 0x00800000 ) >> 23)
#define GET_RG_RX_HPFI (((REG32(ADR_ABB_REGISTER_1)) & 0x03000000 ) >> 24)
#define GET_RG_RX_HPF_FINALCORNER (((REG32(ADR_ABB_REGISTER_1)) & 0x0c000000 ) >> 26)
#define GET_RG_RX_HPF_SETTLE1_C (((REG32(ADR_ABB_REGISTER_1)) & 0x30000000 ) >> 28)
#define GET_RG_RX_HPF_SETTLE1_R (((REG32(ADR_ABB_REGISTER_2)) & 0x00000003 ) >> 0)
#define GET_RG_RX_HPF_SETTLE2_C (((REG32(ADR_ABB_REGISTER_2)) & 0x0000000c ) >> 2)
#define GET_RG_RX_HPF_SETTLE2_R (((REG32(ADR_ABB_REGISTER_2)) & 0x00000030 ) >> 4)
#define GET_RG_RX_HPF_VCMCON2 (((REG32(ADR_ABB_REGISTER_2)) & 0x000000c0 ) >> 6)
#define GET_RG_RX_HPF_VCMCON (((REG32(ADR_ABB_REGISTER_2)) & 0x00000300 ) >> 8)
#define GET_RG_RX_OUTVCM (((REG32(ADR_ABB_REGISTER_2)) & 0x00000c00 ) >> 10)
#define GET_RG_RX_TZI (((REG32(ADR_ABB_REGISTER_2)) & 0x00003000 ) >> 12)
#define GET_RG_RX_TZ_OUT_TRISTATE (((REG32(ADR_ABB_REGISTER_2)) & 0x00004000 ) >> 14)
#define GET_RG_RX_TZ_VCM (((REG32(ADR_ABB_REGISTER_2)) & 0x00018000 ) >> 15)
#define GET_RG_EN_RX_RSSI_TESTNODE (((REG32(ADR_ABB_REGISTER_2)) & 0x000e0000 ) >> 17)
#define GET_RG_RX_ADCRSSI_CLKSEL (((REG32(ADR_ABB_REGISTER_2)) & 0x00100000 ) >> 20)
#define GET_RG_RX_ADCRSSI_VCM (((REG32(ADR_ABB_REGISTER_2)) & 0x00600000 ) >> 21)
#define GET_RG_RX_REC_LPFCORNER (((REG32(ADR_ABB_REGISTER_2)) & 0x01800000 ) >> 23)
#define GET_RG_RSSI_CLOCK_GATING (((REG32(ADR_ABB_REGISTER_2)) & 0x02000000 ) >> 25)
#define GET_RG_TXPGA_CAPSW (((REG32(ADR_TX_FE_REGISTER)) & 0x00000003 ) >> 0)
#define GET_RG_TXPGA_MAIN (((REG32(ADR_TX_FE_REGISTER)) & 0x000000fc ) >> 2)
#define GET_RG_TXPGA_STEER (((REG32(ADR_TX_FE_REGISTER)) & 0x00003f00 ) >> 8)
#define GET_RG_TXMOD_GMCELL (((REG32(ADR_TX_FE_REGISTER)) & 0x0000c000 ) >> 14)
#define GET_RG_TXLPF_GMCELL (((REG32(ADR_TX_FE_REGISTER)) & 0x00030000 ) >> 16)
#define GET_RG_PACELL_EN (((REG32(ADR_TX_FE_REGISTER)) & 0x001c0000 ) >> 18)
#define GET_RG_PABIAS_CTRL (((REG32(ADR_TX_FE_REGISTER)) & 0x01e00000 ) >> 21)
#define GET_RG_TX_DIV_VSET (((REG32(ADR_TX_FE_REGISTER)) & 0x0c000000 ) >> 26)
#define GET_RG_TX_LOBUF_VSET (((REG32(ADR_TX_FE_REGISTER)) & 0x30000000 ) >> 28)
#define GET_RG_RX_SQDC (((REG32(ADR_RX_FE_REGISTER_1)) & 0x00000007 ) >> 0)
#define GET_RG_RX_DIV2_CORE (((REG32(ADR_RX_FE_REGISTER_1)) & 0x00000018 ) >> 3)
#define GET_RG_RX_LOBUF (((REG32(ADR_RX_FE_REGISTER_1)) & 0x00000060 ) >> 5)
#define GET_RG_TX_DPDGM_BIAS (((REG32(ADR_RX_FE_REGISTER_1)) & 0x00000780 ) >> 7)
#define GET_RG_TX_DPD_DIV (((REG32(ADR_RX_FE_REGISTER_1)) & 0x00007800 ) >> 11)
#define GET_RG_TX_TSSI_BIAS (((REG32(ADR_RX_FE_REGISTER_1)) & 0x00038000 ) >> 15)
#define GET_RG_TX_TSSI_DIV (((REG32(ADR_RX_FE_REGISTER_1)) & 0x001c0000 ) >> 18)
#define GET_RG_TX_TSSI_TESTMODE (((REG32(ADR_RX_FE_REGISTER_1)) & 0x00200000 ) >> 21)
#define GET_RG_TX_TSSI_TEST (((REG32(ADR_RX_FE_REGISTER_1)) & 0x00c00000 ) >> 22)
#define GET_RG_PACASCODE_CTRL (((REG32(ADR_RX_FE_REGISTER_1)) & 0x07000000 ) >> 24)
#define GET_RG_RX_HG_LNA_GC (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0x00000003 ) >> 0)
#define GET_RG_RX_HG_LNAHGN_BIAS (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0x0000003c ) >> 2)
#define GET_RG_RX_HG_LNAHGP_BIAS (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0x000003c0 ) >> 6)
#define GET_RG_RX_HG_LNALG_BIAS (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0x00003c00 ) >> 10)
#define GET_RG_RX_HG_TZ_GC (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0x0000c000 ) >> 14)
#define GET_RG_RX_HG_TZ_CAP (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0x00070000 ) >> 16)
#define GET_RG_RX_MG_LNA_GC (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0x00000003 ) >> 0)
#define GET_RG_RX_MG_LNAHGN_BIAS (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0x0000003c ) >> 2)
#define GET_RG_RX_MG_LNAHGP_BIAS (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0x000003c0 ) >> 6)
#define GET_RG_RX_MG_LNALG_BIAS (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0x00003c00 ) >> 10)
#define GET_RG_RX_MG_TZ_GC (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0x0000c000 ) >> 14)
#define GET_RG_RX_MG_TZ_CAP (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0x00070000 ) >> 16)
#define GET_RG_RX_LG_LNA_GC (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0x00000003 ) >> 0)
#define GET_RG_RX_LG_LNAHGN_BIAS (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0x0000003c ) >> 2)
#define GET_RG_RX_LG_LNAHGP_BIAS (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0x000003c0 ) >> 6)
#define GET_RG_RX_LG_LNALG_BIAS (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0x00003c00 ) >> 10)
#define GET_RG_RX_LG_TZ_GC (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0x0000c000 ) >> 14)
#define GET_RG_RX_LG_TZ_CAP (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0x00070000 ) >> 16)
#define GET_RG_RX_ULG_LNA_GC (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0x00000003 ) >> 0)
#define GET_RG_RX_ULG_LNAHGN_BIAS (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0x0000003c ) >> 2)
#define GET_RG_RX_ULG_LNAHGP_BIAS (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0x000003c0 ) >> 6)
#define GET_RG_RX_ULG_LNALG_BIAS (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0x00003c00 ) >> 10)
#define GET_RG_RX_ULG_TZ_GC (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0x0000c000 ) >> 14)
#define GET_RG_RX_ULG_TZ_CAP (((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0x00070000 ) >> 16)
#define GET_RG_HPF1_FAST_SET_X (((REG32(ADR_RX_TX_FSM_REGISTER)) & 0x00000001 ) >> 0)
#define GET_RG_HPF1_FAST_SET_Y (((REG32(ADR_RX_TX_FSM_REGISTER)) & 0x00000002 ) >> 1)
#define GET_RG_HPF1_FAST_SET_Z (((REG32(ADR_RX_TX_FSM_REGISTER)) & 0x00000004 ) >> 2)
#define GET_RG_HPF_T1A (((REG32(ADR_RX_TX_FSM_REGISTER)) & 0x00000018 ) >> 3)
#define GET_RG_HPF_T1B (((REG32(ADR_RX_TX_FSM_REGISTER)) & 0x00000060 ) >> 5)
#define GET_RG_HPF_T1C (((REG32(ADR_RX_TX_FSM_REGISTER)) & 0x00000180 ) >> 7)
#define GET_RG_RX_LNA_TRI_SEL (((REG32(ADR_RX_TX_FSM_REGISTER)) & 0x00000600 ) >> 9)
#define GET_RG_RX_LNA_SETTLE (((REG32(ADR_RX_TX_FSM_REGISTER)) & 0x00001800 ) >> 11)
#define GET_RG_TXGAIN_PHYCTRL (((REG32(ADR_RX_TX_FSM_REGISTER)) & 0x00002000 ) >> 13)
#define GET_RG_TX_GAIN (((REG32(ADR_RX_TX_FSM_REGISTER)) & 0x003fc000 ) >> 14)
#define GET_RG_TXGAIN_MANUAL (((REG32(ADR_RX_TX_FSM_REGISTER)) & 0x00400000 ) >> 22)
#define GET_RG_TX_GAIN_OFFSET (((REG32(ADR_RX_TX_FSM_REGISTER)) & 0x07800000 ) >> 23)
#define GET_RG_ADC_CLKSEL (((REG32(ADR_RX_ADC_REGISTER)) & 0x00000001 ) >> 0)
#define GET_RG_ADC_DIBIAS (((REG32(ADR_RX_ADC_REGISTER)) & 0x00000006 ) >> 1)
#define GET_RG_ADC_DIVR (((REG32(ADR_RX_ADC_REGISTER)) & 0x00000008 ) >> 3)
#define GET_RG_ADC_DVCMI (((REG32(ADR_RX_ADC_REGISTER)) & 0x00000030 ) >> 4)
#define GET_RG_ADC_SAMSEL (((REG32(ADR_RX_ADC_REGISTER)) & 0x000003c0 ) >> 6)
#define GET_RG_ADC_STNBY (((REG32(ADR_RX_ADC_REGISTER)) & 0x00000400 ) >> 10)
#define GET_RG_ADC_TESTMODE (((REG32(ADR_RX_ADC_REGISTER)) & 0x00000800 ) >> 11)
#define GET_RG_ADC_TSEL (((REG32(ADR_RX_ADC_REGISTER)) & 0x0000f000 ) >> 12)
#define GET_RG_ADC_VRSEL (((REG32(ADR_RX_ADC_REGISTER)) & 0x00030000 ) >> 16)
#define GET_RG_DICMP (((REG32(ADR_RX_ADC_REGISTER)) & 0x000c0000 ) >> 18)
#define GET_RG_DIOP (((REG32(ADR_RX_ADC_REGISTER)) & 0x00300000 ) >> 20)
#define GET_RG_SARADC_VRSEL (((REG32(ADR_RX_ADC_REGISTER)) & 0x00c00000 ) >> 22)
#define GET_RG_EN_SAR_TEST (((REG32(ADR_RX_ADC_REGISTER)) & 0x03000000 ) >> 24)
#define GET_RG_SARADC_THERMAL (((REG32(ADR_RX_ADC_REGISTER)) & 0x04000000 ) >> 26)
#define GET_RG_SARADC_TSSI (((REG32(ADR_RX_ADC_REGISTER)) & 0x08000000 ) >> 27)
#define GET_RG_CLK_SAR_SEL (((REG32(ADR_RX_ADC_REGISTER)) & 0x30000000 ) >> 28)
#define GET_RG_EN_SARADC (((REG32(ADR_RX_ADC_REGISTER)) & 0x40000000 ) >> 30)
#define GET_RG_DACI1ST (((REG32(ADR_TX_DAC_REGISTER)) & 0x00000003 ) >> 0)
#define GET_RG_TX_DACLPF_ICOURSE (((REG32(ADR_TX_DAC_REGISTER)) & 0x0000000c ) >> 2)
#define GET_RG_TX_DACLPF_IFINE (((REG32(ADR_TX_DAC_REGISTER)) & 0x00000030 ) >> 4)
#define GET_RG_TX_DACLPF_VCM (((REG32(ADR_TX_DAC_REGISTER)) & 0x000000c0 ) >> 6)
#define GET_RG_TX_DAC_CKEDGE_SEL (((REG32(ADR_TX_DAC_REGISTER)) & 0x00000100 ) >> 8)
#define GET_RG_TX_DAC_IBIAS (((REG32(ADR_TX_DAC_REGISTER)) & 0x00000600 ) >> 9)
#define GET_RG_TX_DAC_OS (((REG32(ADR_TX_DAC_REGISTER)) & 0x00003800 ) >> 11)
#define GET_RG_TX_DAC_RCAL (((REG32(ADR_TX_DAC_REGISTER)) & 0x0000c000 ) >> 14)
#define GET_RG_TX_DAC_TSEL (((REG32(ADR_TX_DAC_REGISTER)) & 0x000f0000 ) >> 16)
#define GET_RG_TX_EN_VOLTAGE_IN (((REG32(ADR_TX_DAC_REGISTER)) & 0x00100000 ) >> 20)
#define GET_RG_TXLPF_BYPASS (((REG32(ADR_TX_DAC_REGISTER)) & 0x00200000 ) >> 21)
#define GET_RG_TXLPF_BOOSTI (((REG32(ADR_TX_DAC_REGISTER)) & 0x00400000 ) >> 22)
#define GET_RG_TX_DAC_IOFFSET (((REG32(ADR_TX_DAC_REGISTER)) & 0x07800000 ) >> 23)
#define GET_RG_TX_DAC_QOFFSET (((REG32(ADR_TX_DAC_REGISTER)) & 0x78000000 ) >> 27)
#define GET_RG_EN_SX_R3 (((REG32(ADR_SX_ENABLE_REGISTER)) & 0x00000001 ) >> 0)
#define GET_RG_EN_SX_CH (((REG32(ADR_SX_ENABLE_REGISTER)) & 0x00000002 ) >> 1)
#define GET_RG_EN_SX_CHP (((REG32(ADR_SX_ENABLE_REGISTER)) & 0x00000004 ) >> 2)
#define GET_RG_EN_SX_DIVCK (((REG32(ADR_SX_ENABLE_REGISTER)) & 0x00000008 ) >> 3)
#define GET_RG_EN_SX_VCOBF (((REG32(ADR_SX_ENABLE_REGISTER)) & 0x00000010 ) >> 4)
#define GET_RG_EN_SX_VCO (((REG32(ADR_SX_ENABLE_REGISTER)) & 0x00000020 ) >> 5)
#define GET_RG_EN_SX_MOD (((REG32(ADR_SX_ENABLE_REGISTER)) & 0x00000040 ) >> 6)
#define GET_RG_EN_SX_DITHER (((REG32(ADR_SX_ENABLE_REGISTER)) & 0x00000100 ) >> 8)
#define GET_RG_EN_SX_VT_MON (((REG32(ADR_SX_ENABLE_REGISTER)) & 0x00000800 ) >> 11)
#define GET_RG_EN_SX_VT_MON_DG (((REG32(ADR_SX_ENABLE_REGISTER)) & 0x00001000 ) >> 12)
#define GET_RG_EN_SX_DIV (((REG32(ADR_SX_ENABLE_REGISTER)) & 0x00002000 ) >> 13)
#define GET_RG_EN_SX_LPF (((REG32(ADR_SX_ENABLE_REGISTER)) & 0x00004000 ) >> 14)
#define GET_RG_EN_DPL_MOD (((REG32(ADR_SX_ENABLE_REGISTER)) & 0x00008000 ) >> 15)
#define GET_RG_DPL_MOD_ORDER (((REG32(ADR_SX_ENABLE_REGISTER)) & 0x00030000 ) >> 16)
#define GET_RG_SX_RFCTRL_F (((REG32(ADR_SYN_REGISTER_1)) & 0x00ffffff ) >> 0)
#define GET_RG_SX_SEL_CP (((REG32(ADR_SYN_REGISTER_1)) & 0x0f000000 ) >> 24)
#define GET_RG_SX_SEL_CS (((REG32(ADR_SYN_REGISTER_1)) & 0xf0000000 ) >> 28)
#define GET_RG_SX_RFCTRL_CH (((REG32(ADR_SYN_REGISTER_2)) & 0x000007ff ) >> 0)
#define GET_RG_SX_SEL_C3 (((REG32(ADR_SYN_REGISTER_2)) & 0x00007800 ) >> 11)
#define GET_RG_SX_SEL_RS (((REG32(ADR_SYN_REGISTER_2)) & 0x000f8000 ) >> 15)
#define GET_RG_SX_SEL_R3 (((REG32(ADR_SYN_REGISTER_2)) & 0x01f00000 ) >> 20)
#define GET_RG_SX_SEL_ICHP (((REG32(ADR_SYN_PFD_CHP)) & 0x0000001f ) >> 0)
#define GET_RG_SX_SEL_PCHP (((REG32(ADR_SYN_PFD_CHP)) & 0x000003e0 ) >> 5)
#define GET_RG_SX_SEL_CHP_REGOP (((REG32(ADR_SYN_PFD_CHP)) & 0x00003c00 ) >> 10)
#define GET_RG_SX_SEL_CHP_UNIOP (((REG32(ADR_SYN_PFD_CHP)) & 0x0003c000 ) >> 14)
#define GET_RG_SX_CHP_IOST_POL (((REG32(ADR_SYN_PFD_CHP)) & 0x00040000 ) >> 18)
#define GET_RG_SX_CHP_IOST (((REG32(ADR_SYN_PFD_CHP)) & 0x00380000 ) >> 19)
#define GET_RG_SX_PFDSEL (((REG32(ADR_SYN_PFD_CHP)) & 0x00400000 ) >> 22)
#define GET_RG_SX_PFD_SET (((REG32(ADR_SYN_PFD_CHP)) & 0x00800000 ) >> 23)
#define GET_RG_SX_PFD_SET1 (((REG32(ADR_SYN_PFD_CHP)) & 0x01000000 ) >> 24)
#define GET_RG_SX_PFD_SET2 (((REG32(ADR_SYN_PFD_CHP)) & 0x02000000 ) >> 25)
#define GET_RG_SX_VBNCAS_SEL (((REG32(ADR_SYN_PFD_CHP)) & 0x04000000 ) >> 26)
#define GET_RG_SX_PFD_RST_H (((REG32(ADR_SYN_PFD_CHP)) & 0x08000000 ) >> 27)
#define GET_RG_SX_PFD_TRUP (((REG32(ADR_SYN_PFD_CHP)) & 0x10000000 ) >> 28)
#define GET_RG_SX_PFD_TRDN (((REG32(ADR_SYN_PFD_CHP)) & 0x20000000 ) >> 29)
#define GET_RG_SX_PFD_TRSEL (((REG32(ADR_SYN_PFD_CHP)) & 0x40000000 ) >> 30)
#define GET_RG_SX_VCOBA_R (((REG32(ADR_SYN_VCO_LOBF)) & 0x00000007 ) >> 0)
#define GET_RG_SX_VCORSEL (((REG32(ADR_SYN_VCO_LOBF)) & 0x000000f8 ) >> 3)
#define GET_RG_SX_VCOCUSEL (((REG32(ADR_SYN_VCO_LOBF)) & 0x00000f00 ) >> 8)
#define GET_RG_SX_RXBFSEL (((REG32(ADR_SYN_VCO_LOBF)) & 0x0000f000 ) >> 12)
#define GET_RG_SX_TXBFSEL (((REG32(ADR_SYN_VCO_LOBF)) & 0x000f0000 ) >> 16)
#define GET_RG_SX_VCOBFSEL (((REG32(ADR_SYN_VCO_LOBF)) & 0x00f00000 ) >> 20)
#define GET_RG_SX_DIVBFSEL (((REG32(ADR_SYN_VCO_LOBF)) & 0x0f000000 ) >> 24)
#define GET_RG_SX_GNDR_SEL (((REG32(ADR_SYN_VCO_LOBF)) & 0xf0000000 ) >> 28)
#define GET_RG_SX_DITHER_WEIGHT (((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0x00000003 ) >> 0)
#define GET_RG_SX_MOD_ORDER (((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0x00000030 ) >> 4)
#define GET_RG_SX_RST_H_DIV (((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0x00000200 ) >> 9)
#define GET_RG_SX_SDM_EDGE (((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0x00000400 ) >> 10)
#define GET_RG_SX_XO_GM (((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0x00001800 ) >> 11)
#define GET_RG_SX_REFBYTWO (((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0x00002000 ) >> 13)
#define GET_RG_SX_LCKEN (((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0x00080000 ) >> 19)
#define GET_RG_SX_PREVDD (((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0x00f00000 ) >> 20)
#define GET_RG_SX_PSCONTERVDD (((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0x0f000000 ) >> 24)
#define GET_RG_SX_PH (((REG32(ADR_SYN_KVCO_XO_FINE_TUNE_CBANK)) & 0x00002000 ) >> 13)
#define GET_RG_SX_PL (((REG32(ADR_SYN_KVCO_XO_FINE_TUNE_CBANK)) & 0x00004000 ) >> 14)
#define GET_RG_XOSC_CBANK_XO (((REG32(ADR_SYN_KVCO_XO_FINE_TUNE_CBANK)) & 0x00078000 ) >> 15)
#define GET_RG_XOSC_CBANK_XI (((REG32(ADR_SYN_KVCO_XO_FINE_TUNE_CBANK)) & 0x00780000 ) >> 19)
#define GET_RG_SX_VT_MON_MODE (((REG32(ADR_SYN_LCK_VT)) & 0x00000001 ) >> 0)
#define GET_RG_SX_VT_TH_HI (((REG32(ADR_SYN_LCK_VT)) & 0x00000006 ) >> 1)
#define GET_RG_SX_VT_TH_LO (((REG32(ADR_SYN_LCK_VT)) & 0x00000018 ) >> 3)
#define GET_RG_SX_VT_SET (((REG32(ADR_SYN_LCK_VT)) & 0x00000020 ) >> 5)
#define GET_RG_SX_VT_MON_TMR (((REG32(ADR_SYN_LCK_VT)) & 0x00007fc0 ) >> 6)
#define GET_RG_EN_DP_VT_MON (((REG32(ADR_DPLL_VCO_REGISTER)) & 0x00000001 ) >> 0)
#define GET_RG_DP_VT_TH_HI (((REG32(ADR_DPLL_VCO_REGISTER)) & 0x00000006 ) >> 1)
#define GET_RG_DP_VT_TH_LO (((REG32(ADR_DPLL_VCO_REGISTER)) & 0x00000018 ) >> 3)
#define GET_RG_DP_CK320BY2 (((REG32(ADR_DPLL_VCO_REGISTER)) & 0x00004000 ) >> 14)
#define GET_RG_DP_OD_TEST (((REG32(ADR_DPLL_VCO_REGISTER)) & 0x00200000 ) >> 21)
#define GET_RG_DP_BBPLL_BP (((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0x00000001 ) >> 0)
#define GET_RG_DP_BBPLL_ICP (((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0x00000006 ) >> 1)
#define GET_RG_DP_BBPLL_IDUAL (((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0x00000018 ) >> 3)
#define GET_RG_DP_BBPLL_OD_TEST (((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0x000001e0 ) >> 5)
#define GET_RG_DP_BBPLL_PD (((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0x00000200 ) >> 9)
#define GET_RG_DP_BBPLL_TESTSEL (((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0x00001c00 ) >> 10)
#define GET_RG_DP_BBPLL_PFD_DLY (((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0x00006000 ) >> 13)
#define GET_RG_DP_RP (((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0x00038000 ) >> 15)
#define GET_RG_DP_RHP (((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0x000c0000 ) >> 18)
#define GET_RG_DP_BBPLL_SDM_EDGE (((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0x80000000 ) >> 31)
#define GET_RG_DP_FODIV (((REG32(ADR_DPLL_DIVIDER_REGISTER)) & 0x0007f000 ) >> 12)
#define GET_RG_DP_REFDIV (((REG32(ADR_DPLL_DIVIDER_REGISTER)) & 0x1fc00000 ) >> 22)
#define GET_RG_IDACAI_PGAG15 (((REG32(ADR_DCOC_IDAC_REGISTER1)) & 0x0000003f ) >> 0)
#define GET_RG_IDACAQ_PGAG15 (((REG32(ADR_DCOC_IDAC_REGISTER1)) & 0x00000fc0 ) >> 6)
#define GET_RG_IDACAI_PGAG14 (((REG32(ADR_DCOC_IDAC_REGISTER1)) & 0x0003f000 ) >> 12)
#define GET_RG_IDACAQ_PGAG14 (((REG32(ADR_DCOC_IDAC_REGISTER1)) & 0x00fc0000 ) >> 18)
#define GET_RG_DP_BBPLL_BS (((REG32(ADR_DCOC_IDAC_REGISTER1)) & 0x3f000000 ) >> 24)
#define GET_RG_IDACAI_PGAG13 (((REG32(ADR_DCOC_IDAC_REGISTER2)) & 0x0000003f ) >> 0)
#define GET_RG_IDACAQ_PGAG13 (((REG32(ADR_DCOC_IDAC_REGISTER2)) & 0x00000fc0 ) >> 6)
#define GET_RG_IDACAI_PGAG12 (((REG32(ADR_DCOC_IDAC_REGISTER2)) & 0x0003f000 ) >> 12)
#define GET_RG_IDACAQ_PGAG12 (((REG32(ADR_DCOC_IDAC_REGISTER2)) & 0x00fc0000 ) >> 18)
#define GET_RG_IDACAI_PGAG11 (((REG32(ADR_DCOC_IDAC_REGISTER3)) & 0x0000003f ) >> 0)
#define GET_RG_IDACAQ_PGAG11 (((REG32(ADR_DCOC_IDAC_REGISTER3)) & 0x00000fc0 ) >> 6)
#define GET_RG_IDACAI_PGAG10 (((REG32(ADR_DCOC_IDAC_REGISTER3)) & 0x0003f000 ) >> 12)
#define GET_RG_IDACAQ_PGAG10 (((REG32(ADR_DCOC_IDAC_REGISTER3)) & 0x00fc0000 ) >> 18)
#define GET_RG_IDACAI_PGAG9 (((REG32(ADR_DCOC_IDAC_REGISTER4)) & 0x0000003f ) >> 0)
#define GET_RG_IDACAQ_PGAG9 (((REG32(ADR_DCOC_IDAC_REGISTER4)) & 0x00000fc0 ) >> 6)
#define GET_RG_IDACAI_PGAG8 (((REG32(ADR_DCOC_IDAC_REGISTER4)) & 0x0003f000 ) >> 12)
#define GET_RG_IDACAQ_PGAG8 (((REG32(ADR_DCOC_IDAC_REGISTER4)) & 0x00fc0000 ) >> 18)
#define GET_RG_IDACAI_PGAG7 (((REG32(ADR_DCOC_IDAC_REGISTER5)) & 0x0000003f ) >> 0)
#define GET_RG_IDACAQ_PGAG7 (((REG32(ADR_DCOC_IDAC_REGISTER5)) & 0x00000fc0 ) >> 6)
#define GET_RG_IDACAI_PGAG6 (((REG32(ADR_DCOC_IDAC_REGISTER5)) & 0x0003f000 ) >> 12)
#define GET_RG_IDACAQ_PGAG6 (((REG32(ADR_DCOC_IDAC_REGISTER5)) & 0x00fc0000 ) >> 18)
#define GET_RG_IDACAI_PGAG5 (((REG32(ADR_DCOC_IDAC_REGISTER6)) & 0x0000003f ) >> 0)
#define GET_RG_IDACAQ_PGAG5 (((REG32(ADR_DCOC_IDAC_REGISTER6)) & 0x00000fc0 ) >> 6)
#define GET_RG_IDACAI_PGAG4 (((REG32(ADR_DCOC_IDAC_REGISTER6)) & 0x0003f000 ) >> 12)
#define GET_RG_IDACAQ_PGAG4 (((REG32(ADR_DCOC_IDAC_REGISTER6)) & 0x00fc0000 ) >> 18)
#define GET_RG_IDACAI_PGAG3 (((REG32(ADR_DCOC_IDAC_REGISTER7)) & 0x0000003f ) >> 0)
#define GET_RG_IDACAQ_PGAG3 (((REG32(ADR_DCOC_IDAC_REGISTER7)) & 0x00000fc0 ) >> 6)
#define GET_RG_IDACAI_PGAG2 (((REG32(ADR_DCOC_IDAC_REGISTER7)) & 0x0003f000 ) >> 12)
#define GET_RG_IDACAQ_PGAG2 (((REG32(ADR_DCOC_IDAC_REGISTER7)) & 0x00fc0000 ) >> 18)
#define GET_RG_IDACAI_PGAG1 (((REG32(ADR_DCOC_IDAC_REGISTER8)) & 0x0000003f ) >> 0)
#define GET_RG_IDACAQ_PGAG1 (((REG32(ADR_DCOC_IDAC_REGISTER8)) & 0x00000fc0 ) >> 6)
#define GET_RG_IDACAI_PGAG0 (((REG32(ADR_DCOC_IDAC_REGISTER8)) & 0x0003f000 ) >> 12)
#define GET_RG_IDACAQ_PGAG0 (((REG32(ADR_DCOC_IDAC_REGISTER8)) & 0x00fc0000 ) >> 18)
#define GET_RG_EN_RCAL (((REG32(ADR_RCAL_REGISTER)) & 0x00000001 ) >> 0)
#define GET_RG_RCAL_SPD (((REG32(ADR_RCAL_REGISTER)) & 0x00000002 ) >> 1)
#define GET_RG_RCAL_TMR (((REG32(ADR_RCAL_REGISTER)) & 0x000001fc ) >> 2)
#define GET_RG_RCAL_CODE_CWR (((REG32(ADR_RCAL_REGISTER)) & 0x00000200 ) >> 9)
#define GET_RG_RCAL_CODE_CWD (((REG32(ADR_RCAL_REGISTER)) & 0x00007c00 ) >> 10)
#define GET_RG_SX_SUB_SEL_CWR (((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0x00000001 ) >> 0)
#define GET_RG_SX_SUB_SEL_CWD (((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0x000000fe ) >> 1)
#define GET_RG_SX_LCK_BIN_OFFSET (((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0x00078000 ) >> 15)
#define GET_RG_SX_LCK_BIN_PRECISION (((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0x00080000 ) >> 19)
#define GET_RG_SX_LOCK_EN_N (((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0x00100000 ) >> 20)
#define GET_RG_SX_LOCK_MANUAL (((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0x00200000 ) >> 21)
#define GET_RG_SX_SUB_MANUAL (((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0x00400000 ) >> 22)
#define GET_RG_SX_SUB_SEL (((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0x3f800000 ) >> 23)
#define GET_RG_SX_MUX_SEL_VTH_BINL (((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0x40000000 ) >> 30)
#define GET_RG_TRX_DUMMMY (((REG32(ADR_TRX_DUMMY_REGISTER)) & 0xffffffff ) >> 0)
#define GET_RG_SX_DUMMMY (((REG32(ADR_SX_DUMMY_REGISTER)) & 0xffffffff ) >> 0)
#define GET_RCAL_RDY (((REG32(ADR_READ_ONLY_FLAGS_1)) & 0x00000001 ) >> 0)
#define GET_LCK_BIN_RDY (((REG32(ADR_READ_ONLY_FLAGS_1)) & 0x00000002 ) >> 1)
#define GET_VT_MON_RDY (((REG32(ADR_READ_ONLY_FLAGS_1)) & 0x00000004 ) >> 2)
#define GET_DA_R_CODE_LUT (((REG32(ADR_READ_ONLY_FLAGS_1)) & 0x000007c0 ) >> 6)
#define GET_AD_SX_VT_MON_Q (((REG32(ADR_READ_ONLY_FLAGS_1)) & 0x00001800 ) >> 11)
#define GET_AD_DP_VT_MON_Q (((REG32(ADR_READ_ONLY_FLAGS_1)) & 0x00006000 ) >> 13)
#define GET_RTC_CAL_RDY (((REG32(ADR_READ_ONLY_FLAGS_1)) & 0x00008000 ) >> 15)
#define GET_RG_SARADC_BIT (((REG32(ADR_READ_ONLY_FLAGS_1)) & 0x003f0000 ) >> 16)
#define GET_SAR_ADC_FSM_RDY (((REG32(ADR_READ_ONLY_FLAGS_1)) & 0x00400000 ) >> 22)
#define GET_AD_CIRCUIT_VERSION (((REG32(ADR_READ_ONLY_FLAGS_1)) & 0x07800000 ) >> 23)
#define GET_DA_R_CAL_CODE (((REG32(ADR_READ_ONLY_FLAGS_2)) & 0x0000001f ) >> 0)
#define GET_DA_SX_SUB_SEL (((REG32(ADR_READ_ONLY_FLAGS_2)) & 0x00000fe0 ) >> 5)
#define GET_RG_DPL_RFCTRL_CH (((REG32(ADR_DPLL_FB_DIVIDER_REGISTERS_I)) & 0x000007ff ) >> 0)
#define GET_RG_RSSIADC_RO_BIT (((REG32(ADR_DPLL_FB_DIVIDER_REGISTERS_I)) & 0x00007800 ) >> 11)
#define GET_RG_RX_ADC_I_RO_BIT (((REG32(ADR_DPLL_FB_DIVIDER_REGISTERS_I)) & 0x007f8000 ) >> 15)
#define GET_RG_RX_ADC_Q_RO_BIT (((REG32(ADR_DPLL_FB_DIVIDER_REGISTERS_I)) & 0x7f800000 ) >> 23)
#define GET_RG_DPL_RFCTRL_F (((REG32(ADR_DPLL_FB_DIVIDER_REGISTERS_II)) & 0x00ffffff ) >> 0)
#define GET_RG_SX_TARGET_CNT (((REG32(ADR_SX_LCK_BIN_REGISTERS_II)) & 0x00001fff ) >> 0)
#define GET_RG_RTC_OFFSET (((REG32(ADR_RC_OSC_32K_CAL_REGISTERS)) & 0x000000ff ) >> 0)
#define GET_RG_RTC_CAL_TARGET_COUNT (((REG32(ADR_RC_OSC_32K_CAL_REGISTERS)) & 0x000fff00 ) >> 8)
#define GET_RG_RF_D_REG (((REG32(ADR_RF_D_DIGITAL_DEBUG_PORT_REGISTER)) & 0x0000ffff ) >> 0)
#define GET_DIRECT_MODE (((REG32(ADR_MMU_CTRL)) & 0x00000001 ) >> 0)
#define GET_TAG_INTERLEAVE_MD (((REG32(ADR_MMU_CTRL)) & 0x00000002 ) >> 1)
#define GET_DIS_DEMAND (((REG32(ADR_MMU_CTRL)) & 0x00000004 ) >> 2)
#define GET_SAME_ID_ALLOC_MD (((REG32(ADR_MMU_CTRL)) & 0x00000008 ) >> 3)
#define GET_HS_ACCESS_MD (((REG32(ADR_MMU_CTRL)) & 0x00000010 ) >> 4)
#define GET_SRAM_ACCESS_MD (((REG32(ADR_MMU_CTRL)) & 0x00000020 ) >> 5)
#define GET_NOHIT_RPASS_MD (((REG32(ADR_MMU_CTRL)) & 0x00000040 ) >> 6)
#define GET_DMN_FLAG_CLR (((REG32(ADR_MMU_CTRL)) & 0x00000080 ) >> 7)
#define GET_ERR_SW_RST_N (((REG32(ADR_MMU_CTRL)) & 0x00000100 ) >> 8)
#define GET_ALR_SW_RST_N (((REG32(ADR_MMU_CTRL)) & 0x00000200 ) >> 9)
#define GET_MCH_SW_RST_N (((REG32(ADR_MMU_CTRL)) & 0x00000400 ) >> 10)
#define GET_TAG_SW_RST_N (((REG32(ADR_MMU_CTRL)) & 0x00000800 ) >> 11)
#define GET_ABT_SW_RST_N (((REG32(ADR_MMU_CTRL)) & 0x00001000 ) >> 12)
#define GET_MMU_VER (((REG32(ADR_MMU_CTRL)) & 0x0000e000 ) >> 13)
#define GET_MMU_SHARE_MCU (((REG32(ADR_MMU_CTRL)) & 0x00ff0000 ) >> 16)
#define GET_HS_WR (((REG32(ADR_HS_CTRL)) & 0x00000001 ) >> 0)
#define GET_HS_FLAG (((REG32(ADR_HS_CTRL)) & 0x00000010 ) >> 4)
#define GET_HS_ID (((REG32(ADR_HS_CTRL)) & 0x00007f00 ) >> 8)
#define GET_HS_CHANNEL (((REG32(ADR_HS_CTRL)) & 0x000f0000 ) >> 16)
#define GET_HS_PAGE (((REG32(ADR_HS_CTRL)) & 0x00f00000 ) >> 20)
#define GET_HS_DATA (((REG32(ADR_HS_CTRL)) & 0xff000000 ) >> 24)
#define GET_CPU_POR0 (((REG32(ADR_CPU_POR0_7)) & 0x0000000f ) >> 0)
#define GET_CPU_POR1 (((REG32(ADR_CPU_POR0_7)) & 0x000000f0 ) >> 4)
#define GET_CPU_POR2 (((REG32(ADR_CPU_POR0_7)) & 0x00000f00 ) >> 8)
#define GET_CPU_POR3 (((REG32(ADR_CPU_POR0_7)) & 0x0000f000 ) >> 12)
#define GET_CPU_POR4 (((REG32(ADR_CPU_POR0_7)) & 0x000f0000 ) >> 16)
#define GET_CPU_POR5 (((REG32(ADR_CPU_POR0_7)) & 0x00f00000 ) >> 20)
#define GET_CPU_POR6 (((REG32(ADR_CPU_POR0_7)) & 0x0f000000 ) >> 24)
#define GET_CPU_POR7 (((REG32(ADR_CPU_POR0_7)) & 0xf0000000 ) >> 28)
#define GET_CPU_POR8 (((REG32(ADR_CPU_POR8_F)) & 0x0000000f ) >> 0)
#define GET_CPU_POR9 (((REG32(ADR_CPU_POR8_F)) & 0x000000f0 ) >> 4)
#define GET_CPU_PORA (((REG32(ADR_CPU_POR8_F)) & 0x00000f00 ) >> 8)
#define GET_CPU_PORB (((REG32(ADR_CPU_POR8_F)) & 0x0000f000 ) >> 12)
#define GET_CPU_PORC (((REG32(ADR_CPU_POR8_F)) & 0x000f0000 ) >> 16)
#define GET_CPU_PORD (((REG32(ADR_CPU_POR8_F)) & 0x00f00000 ) >> 20)
#define GET_CPU_PORE (((REG32(ADR_CPU_POR8_F)) & 0x0f000000 ) >> 24)
#define GET_CPU_PORF (((REG32(ADR_CPU_POR8_F)) & 0xf0000000 ) >> 28)
#define GET_ACC_WR_LEN (((REG32(ADR_REG_LEN_CTRL)) & 0x0000003f ) >> 0)
#define GET_ACC_RD_LEN (((REG32(ADR_REG_LEN_CTRL)) & 0x00003f00 ) >> 8)
#define GET_REQ_NACK_CLR (((REG32(ADR_REG_LEN_CTRL)) & 0x00008000 ) >> 15)
#define GET_NACK_FLAG_BUS (((REG32(ADR_REG_LEN_CTRL)) & 0xffff0000 ) >> 16)
#define GET_DMN_R_PASS (((REG32(ADR_DMN_READ_BYPASS)) & 0x0000ffff ) >> 0)
#define GET_PARA_ALC_RLS (((REG32(ADR_DMN_READ_BYPASS)) & 0x00010000 ) >> 16)
#define GET_REQ_PORNS_CHGEN (((REG32(ADR_DMN_READ_BYPASS)) & 0x01000000 ) >> 24)
#define GET_ALC_ABT_ID (((REG32(ADR_ALC_RLS_ABORT)) & 0x0000007f ) >> 0)
#define GET_ALC_ABT_INT (((REG32(ADR_ALC_RLS_ABORT)) & 0x00008000 ) >> 15)
#define GET_RLS_ABT_ID (((REG32(ADR_ALC_RLS_ABORT)) & 0x007f0000 ) >> 16)
#define GET_RLS_ABT_INT (((REG32(ADR_ALC_RLS_ABORT)) & 0x80000000 ) >> 31)
#define GET_DEBUG_CTL (((REG32(ADR_DEBUG_CTL)) & 0x000000ff ) >> 0)
#define GET_DEBUG_H16 (((REG32(ADR_DEBUG_CTL)) & 0x00000100 ) >> 8)
#define GET_DEBUG_OUT (((REG32(ADR_DEBUG_OUT)) & 0xffffffff ) >> 0)
#define GET_ALC_ERR (((REG32(ADR_MMU_STATUS)) & 0x00000001 ) >> 0)
#define GET_RLS_ERR (((REG32(ADR_MMU_STATUS)) & 0x00000002 ) >> 1)
#define GET_AL_STATE (((REG32(ADR_MMU_STATUS)) & 0x00000700 ) >> 8)
#define GET_RL_STATE (((REG32(ADR_MMU_STATUS)) & 0x00007000 ) >> 12)
#define GET_ALC_ERR_ID (((REG32(ADR_MMU_STATUS)) & 0x007f0000 ) >> 16)
#define GET_RLS_ERR_ID (((REG32(ADR_MMU_STATUS)) & 0x7f000000 ) >> 24)
#define GET_DMN_NOHIT_FLAG (((REG32(ADR_DMN_STATUS)) & 0x00000001 ) >> 0)
#define GET_DMN_FLAG (((REG32(ADR_DMN_STATUS)) & 0x00000002 ) >> 1)
#define GET_DMN_WR (((REG32(ADR_DMN_STATUS)) & 0x00000008 ) >> 3)
#define GET_DMN_PORT (((REG32(ADR_DMN_STATUS)) & 0x000000f0 ) >> 4)
#define GET_DMN_NHIT_ID (((REG32(ADR_DMN_STATUS)) & 0x00007f00 ) >> 8)
#define GET_DMN_NHIT_ADDR (((REG32(ADR_DMN_STATUS)) & 0xffff0000 ) >> 16)
#define GET_TX_MOUNT (((REG32(ADR_TAG_STATUS)) & 0x000000ff ) >> 0)
#define GET_RX_MOUNT (((REG32(ADR_TAG_STATUS)) & 0x0000ff00 ) >> 8)
#define GET_AVA_TAG (((REG32(ADR_TAG_STATUS)) & 0x01ff0000 ) >> 16)
#define GET_PKTBUF_FULL (((REG32(ADR_TAG_STATUS)) & 0x80000000 ) >> 31)
#define GET_DMN_NOHIT_MCU (((REG32(ADR_DMN_MCU_STATUS)) & 0x00000001 ) >> 0)
#define GET_DMN_MCU_FLAG (((REG32(ADR_DMN_MCU_STATUS)) & 0x00000002 ) >> 1)
#define GET_DMN_MCU_WR (((REG32(ADR_DMN_MCU_STATUS)) & 0x00000008 ) >> 3)
#define GET_DMN_MCU_PORT (((REG32(ADR_DMN_MCU_STATUS)) & 0x000000f0 ) >> 4)
#define GET_DMN_MCU_ID (((REG32(ADR_DMN_MCU_STATUS)) & 0x00007f00 ) >> 8)
#define GET_DMN_MCU_ADDR (((REG32(ADR_DMN_MCU_STATUS)) & 0xffff0000 ) >> 16)
#define GET_MB_IDTBL_31_0 (((REG32(ADR_MB_IDTBL_0_STATUS)) & 0xffffffff ) >> 0)
#define GET_MB_IDTBL_63_32 (((REG32(ADR_MB_IDTBL_1_STATUS)) & 0xffffffff ) >> 0)
#define GET_MB_IDTBL_95_64 (((REG32(ADR_MB_IDTBL_2_STATUS)) & 0xffffffff ) >> 0)
#define GET_MB_IDTBL_127_96 (((REG32(ADR_MB_IDTBL_3_STATUS)) & 0xffffffff ) >> 0)
#define GET_PKT_IDTBL_31_0 (((REG32(ADR_PKT_IDTBL_0_STATUS)) & 0xffffffff ) >> 0)
#define GET_PKT_IDTBL_63_32 (((REG32(ADR_PKT_IDTBL_1_STATUS)) & 0xffffffff ) >> 0)
#define GET_PKT_IDTBL_95_64 (((REG32(ADR_PKT_IDTBL_2_STATUS)) & 0xffffffff ) >> 0)
#define GET_PKT_IDTBL_127_96 (((REG32(ADR_PKT_IDTBL_3_STATUS)) & 0xffffffff ) >> 0)
#define GET_DMN_IDTBL_31_0 (((REG32(ADR_DMN_IDTBL_0_STATUS)) & 0xffffffff ) >> 0)
#define GET_DMN_IDTBL_63_32 (((REG32(ADR_DMN_IDTBL_1_STATUS)) & 0xffffffff ) >> 0)
#define GET_DMN_IDTBL_95_64 (((REG32(ADR_DMN_IDTBL_2_STATUS)) & 0xffffffff ) >> 0)
#define GET_DMN_IDTBL_127_96 (((REG32(ADR_DMN_IDTBL_3_STATUS)) & 0xffffffff ) >> 0)
#define GET_NEQ_MB_ID_31_0 (((REG32(ADR_MB_NEQID_0_STATUS)) & 0xffffffff ) >> 0)
#define GET_NEQ_MB_ID_63_32 (((REG32(ADR_MB_NEQID_1_STATUS)) & 0xffffffff ) >> 0)
#define GET_NEQ_MB_ID_95_64 (((REG32(ADR_MB_NEQID_2_STATUS)) & 0xffffffff ) >> 0)
#define GET_NEQ_MB_ID_127_96 (((REG32(ADR_MB_NEQID_3_STATUS)) & 0xffffffff ) >> 0)
#define GET_NEQ_PKT_ID_31_0 (((REG32(ADR_PKT_NEQID_0_STATUS)) & 0xffffffff ) >> 0)
#define GET_NEQ_PKT_ID_63_32 (((REG32(ADR_PKT_NEQID_1_STATUS)) & 0xffffffff ) >> 0)
#define GET_NEQ_PKT_ID_95_64 (((REG32(ADR_PKT_NEQID_2_STATUS)) & 0xffffffff ) >> 0)
#define GET_NEQ_PKT_ID_127_96 (((REG32(ADR_PKT_NEQID_3_STATUS)) & 0xffffffff ) >> 0)
#define GET_ALC_NOCHG_ID (((REG32(ADR_ALC_NOCHG_ID_STATUS)) & 0x0000007f ) >> 0)
#define GET_ALC_NOCHG_INT (((REG32(ADR_ALC_NOCHG_ID_STATUS)) & 0x00008000 ) >> 15)
#define GET_NEQ_PKT_FLAG (((REG32(ADR_ALC_NOCHG_ID_STATUS)) & 0x00010000 ) >> 16)
#define GET_NEQ_MB_FLAG (((REG32(ADR_ALC_NOCHG_ID_STATUS)) & 0x01000000 ) >> 24)
#define GET_SRAM_TAG_0 (((REG32(ADR_TAG_SRAM0_F_STATUS_0)) & 0x0000ffff ) >> 0)
#define GET_SRAM_TAG_1 (((REG32(ADR_TAG_SRAM0_F_STATUS_0)) & 0xffff0000 ) >> 16)
#define GET_SRAM_TAG_2 (((REG32(ADR_TAG_SRAM0_F_STATUS_1)) & 0x0000ffff ) >> 0)
#define GET_SRAM_TAG_3 (((REG32(ADR_TAG_SRAM0_F_STATUS_1)) & 0xffff0000 ) >> 16)
#define GET_SRAM_TAG_4 (((REG32(ADR_TAG_SRAM0_F_STATUS_2)) & 0x0000ffff ) >> 0)
#define GET_SRAM_TAG_5 (((REG32(ADR_TAG_SRAM0_F_STATUS_2)) & 0xffff0000 ) >> 16)
#define GET_SRAM_TAG_6 (((REG32(ADR_TAG_SRAM0_F_STATUS_3)) & 0x0000ffff ) >> 0)
#define GET_SRAM_TAG_7 (((REG32(ADR_TAG_SRAM0_F_STATUS_3)) & 0xffff0000 ) >> 16)
#define GET_SRAM_TAG_8 (((REG32(ADR_TAG_SRAM0_F_STATUS_4)) & 0x0000ffff ) >> 0)
#define GET_SRAM_TAG_9 (((REG32(ADR_TAG_SRAM0_F_STATUS_4)) & 0xffff0000 ) >> 16)
#define GET_SRAM_TAG_10 (((REG32(ADR_TAG_SRAM0_F_STATUS_5)) & 0x0000ffff ) >> 0)
#define GET_SRAM_TAG_11 (((REG32(ADR_TAG_SRAM0_F_STATUS_5)) & 0xffff0000 ) >> 16)
#define GET_SRAM_TAG_12 (((REG32(ADR_TAG_SRAM0_F_STATUS_6)) & 0x0000ffff ) >> 0)
#define GET_SRAM_TAG_13 (((REG32(ADR_TAG_SRAM0_F_STATUS_6)) & 0xffff0000 ) >> 16)
#define GET_SRAM_TAG_14 (((REG32(ADR_TAG_SRAM0_F_STATUS_7)) & 0x0000ffff ) >> 0)
#define GET_SRAM_TAG_15 (((REG32(ADR_TAG_SRAM0_F_STATUS_7)) & 0xffff0000 ) >> 16)
#define SET_MCU_ENABLE(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 0) | ((REG32(ADR_BRG_SW_RST)) & 0xfffffffe))
#define SET_MAC_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 1) | ((REG32(ADR_BRG_SW_RST)) & 0xfffffffd))
#define SET_MCU_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 2) | ((REG32(ADR_BRG_SW_RST)) & 0xfffffffb))
#define SET_SDIO_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 3) | ((REG32(ADR_BRG_SW_RST)) & 0xfffffff7))
#define SET_SPI_SLV_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 4) | ((REG32(ADR_BRG_SW_RST)) & 0xffffffef))
#define SET_UART_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 5) | ((REG32(ADR_BRG_SW_RST)) & 0xffffffdf))
#define SET_DMA_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 6) | ((REG32(ADR_BRG_SW_RST)) & 0xffffffbf))
#define SET_WDT_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 7) | ((REG32(ADR_BRG_SW_RST)) & 0xffffff7f))
#define SET_I2C_SLV_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 8) | ((REG32(ADR_BRG_SW_RST)) & 0xfffffeff))
#define SET_INT_CTL_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 9) | ((REG32(ADR_BRG_SW_RST)) & 0xfffffdff))
#define SET_BTCX_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 10) | ((REG32(ADR_BRG_SW_RST)) & 0xfffffbff))
#define SET_GPIO_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 11) | ((REG32(ADR_BRG_SW_RST)) & 0xfffff7ff))
#define SET_US0TMR_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 12) | ((REG32(ADR_BRG_SW_RST)) & 0xffffefff))
#define SET_US1TMR_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 13) | ((REG32(ADR_BRG_SW_RST)) & 0xffffdfff))
#define SET_US2TMR_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 14) | ((REG32(ADR_BRG_SW_RST)) & 0xffffbfff))
#define SET_US3TMR_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 15) | ((REG32(ADR_BRG_SW_RST)) & 0xffff7fff))
#define SET_MS0TMR_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 16) | ((REG32(ADR_BRG_SW_RST)) & 0xfffeffff))
#define SET_MS1TMR_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 17) | ((REG32(ADR_BRG_SW_RST)) & 0xfffdffff))
#define SET_MS2TMR_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 18) | ((REG32(ADR_BRG_SW_RST)) & 0xfffbffff))
#define SET_MS3TMR_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 19) | ((REG32(ADR_BRG_SW_RST)) & 0xfff7ffff))
#define SET_RF_BB_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 20) | ((REG32(ADR_BRG_SW_RST)) & 0xffefffff))
#define SET_SYS_ALL_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 21) | ((REG32(ADR_BRG_SW_RST)) & 0xffdfffff))
#define SET_DAT_UART_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 22) | ((REG32(ADR_BRG_SW_RST)) & 0xffbfffff))
#define SET_I2C_MST_SW_RST(_VAL_) (REG32(ADR_BRG_SW_RST)) = (((_VAL_) << 23) | ((REG32(ADR_BRG_SW_RST)) & 0xff7fffff))
#define SET_RG_REBOOT(_VAL_) (REG32(ADR_BOOT)) = (((_VAL_) << 0) | ((REG32(ADR_BOOT)) & 0xfffffffe))
#define SET_TRAP_IMG_FLS(_VAL_) (REG32(ADR_BOOT)) = (((_VAL_) << 16) | ((REG32(ADR_BOOT)) & 0xfffeffff))
#define SET_TRAP_REBOOT(_VAL_) (REG32(ADR_BOOT)) = (((_VAL_) << 17) | ((REG32(ADR_BOOT)) & 0xfffdffff))
#define SET_TRAP_BOOT_FLS(_VAL_) (REG32(ADR_BOOT)) = (((_VAL_) << 18) | ((REG32(ADR_BOOT)) & 0xfffbffff))
#define SET_CHIP_ID_31_0(_VAL_) (REG32(ADR_CHIP_ID_0)) = (((_VAL_) << 0) | ((REG32(ADR_CHIP_ID_0)) & 0x00000000))
#define SET_CHIP_ID_63_32(_VAL_) (REG32(ADR_CHIP_ID_1)) = (((_VAL_) << 0) | ((REG32(ADR_CHIP_ID_1)) & 0x00000000))
#define SET_CHIP_ID_95_64(_VAL_) (REG32(ADR_CHIP_ID_2)) = (((_VAL_) << 0) | ((REG32(ADR_CHIP_ID_2)) & 0x00000000))
#define SET_CHIP_ID_127_96(_VAL_) (REG32(ADR_CHIP_ID_3)) = (((_VAL_) << 0) | ((REG32(ADR_CHIP_ID_3)) & 0x00000000))
#define SET_CK_SEL_1_0(_VAL_) (REG32(ADR_CLOCK_SELECTION)) = (((_VAL_) << 0) | ((REG32(ADR_CLOCK_SELECTION)) & 0xfffffffc))
#define SET_CK_SEL_2(_VAL_) (REG32(ADR_CLOCK_SELECTION)) = (((_VAL_) << 2) | ((REG32(ADR_CLOCK_SELECTION)) & 0xfffffffb))
#define SET_SYS_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 0) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xfffffffe))
#define SET_MAC_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 1) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xfffffffd))
#define SET_MCU_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 2) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xfffffffb))
#define SET_SDIO_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 3) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xfffffff7))
#define SET_SPI_SLV_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 4) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xffffffef))
#define SET_UART_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 5) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xffffffdf))
#define SET_DMA_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 6) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xffffffbf))
#define SET_WDT_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 7) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xffffff7f))
#define SET_I2C_SLV_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 8) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xfffffeff))
#define SET_INT_CTL_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 9) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xfffffdff))
#define SET_BTCX_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 10) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xfffffbff))
#define SET_GPIO_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 11) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xfffff7ff))
#define SET_US0TMR_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 12) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xffffefff))
#define SET_US1TMR_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 13) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xffffdfff))
#define SET_US2TMR_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 14) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xffffbfff))
#define SET_US3TMR_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 15) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xffff7fff))
#define SET_MS0TMR_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 16) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xfffeffff))
#define SET_MS1TMR_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 17) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xfffdffff))
#define SET_MS2TMR_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 18) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xfffbffff))
#define SET_MS3TMR_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 19) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xfff7ffff))
#define SET_BIST_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 20) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xffefffff))
#define SET_I2C_MST_CLK_EN(_VAL_) (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (((_VAL_) << 23) | ((REG32(ADR_PLATFORM_CLOCK_ENABLE)) & 0xff7fffff))
#define SET_BTCX_CSR_CLK_EN(_VAL_) (REG32(ADR_SYS_CSR_CLOCK_ENABLE)) = (((_VAL_) << 10) | ((REG32(ADR_SYS_CSR_CLOCK_ENABLE)) & 0xfffffbff))
#define SET_MCU_DBG_SEL(_VAL_) (REG32(ADR_MCU_DBG_SEL)) = (((_VAL_) << 0) | ((REG32(ADR_MCU_DBG_SEL)) & 0xffffffc0))
#define SET_MCU_STOP_NOGRANT(_VAL_) (REG32(ADR_MCU_DBG_SEL)) = (((_VAL_) << 8) | ((REG32(ADR_MCU_DBG_SEL)) & 0xfffffeff))
#define SET_MCU_STOP_ANYTIME(_VAL_) (REG32(ADR_MCU_DBG_SEL)) = (((_VAL_) << 9) | ((REG32(ADR_MCU_DBG_SEL)) & 0xfffffdff))
#define SET_MCU_DBG_DATA(_VAL_) (REG32(ADR_MCU_DBG_DATA)) = (((_VAL_) << 0) | ((REG32(ADR_MCU_DBG_DATA)) & 0x00000000))
#define SET_AHB_SW_RST(_VAL_) (REG32(ADR_AHB_BRG_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_AHB_BRG_STATUS)) & 0xfffffffe))
#define SET_AHB_ERR_RST(_VAL_) (REG32(ADR_AHB_BRG_STATUS)) = (((_VAL_) << 1) | ((REG32(ADR_AHB_BRG_STATUS)) & 0xfffffffd))
#define SET_REG_AHB_DEBUG_MX(_VAL_) (REG32(ADR_AHB_BRG_STATUS)) = (((_VAL_) << 4) | ((REG32(ADR_AHB_BRG_STATUS)) & 0xffffffcf))
#define SET_REG_PKT_W_NBRT(_VAL_) (REG32(ADR_AHB_BRG_STATUS)) = (((_VAL_) << 8) | ((REG32(ADR_AHB_BRG_STATUS)) & 0xfffffeff))
#define SET_REG_PKT_R_NBRT(_VAL_) (REG32(ADR_AHB_BRG_STATUS)) = (((_VAL_) << 9) | ((REG32(ADR_AHB_BRG_STATUS)) & 0xfffffdff))
#define SET_IQ_SRAM_SEL_0(_VAL_) (REG32(ADR_AHB_BRG_STATUS)) = (((_VAL_) << 12) | ((REG32(ADR_AHB_BRG_STATUS)) & 0xffffefff))
#define SET_IQ_SRAM_SEL_1(_VAL_) (REG32(ADR_AHB_BRG_STATUS)) = (((_VAL_) << 13) | ((REG32(ADR_AHB_BRG_STATUS)) & 0xffffdfff))
#define SET_IQ_SRAM_SEL_2(_VAL_) (REG32(ADR_AHB_BRG_STATUS)) = (((_VAL_) << 14) | ((REG32(ADR_AHB_BRG_STATUS)) & 0xffffbfff))
#define SET_AHB_STATUS(_VAL_) (REG32(ADR_AHB_BRG_STATUS)) = (((_VAL_) << 16) | ((REG32(ADR_AHB_BRG_STATUS)) & 0x0000ffff))
#define SET_PARALLEL_DR(_VAL_) (REG32(ADR_BIST_BIST_CTRL)) = (((_VAL_) << 0) | ((REG32(ADR_BIST_BIST_CTRL)) & 0xfffffffe))
#define SET_MBRUN(_VAL_) (REG32(ADR_BIST_BIST_CTRL)) = (((_VAL_) << 4) | ((REG32(ADR_BIST_BIST_CTRL)) & 0xffffffef))
#define SET_SHIFT_DR(_VAL_) (REG32(ADR_BIST_BIST_CTRL)) = (((_VAL_) << 8) | ((REG32(ADR_BIST_BIST_CTRL)) & 0xfffffeff))
#define SET_MODE_REG_SI(_VAL_) (REG32(ADR_BIST_BIST_CTRL)) = (((_VAL_) << 9) | ((REG32(ADR_BIST_BIST_CTRL)) & 0xfffffdff))
#define SET_SIMULATION_MODE(_VAL_) (REG32(ADR_BIST_BIST_CTRL)) = (((_VAL_) << 10) | ((REG32(ADR_BIST_BIST_CTRL)) & 0xfffffbff))
#define SET_DBIST_MODE(_VAL_) (REG32(ADR_BIST_BIST_CTRL)) = (((_VAL_) << 11) | ((REG32(ADR_BIST_BIST_CTRL)) & 0xfffff7ff))
#define SET_MODE_REG_IN(_VAL_) (REG32(ADR_BIST_MODE_REG_IN)) = (((_VAL_) << 0) | ((REG32(ADR_BIST_MODE_REG_IN)) & 0xffe00000))
#define SET_MODE_REG_OUT_MCU(_VAL_) (REG32(ADR_BIST_MODE_REG_OUT)) = (((_VAL_) << 0) | ((REG32(ADR_BIST_MODE_REG_OUT)) & 0xffe00000))
#define SET_MODE_REG_SO_MCU(_VAL_) (REG32(ADR_BIST_MODE_REG_OUT)) = (((_VAL_) << 31) | ((REG32(ADR_BIST_MODE_REG_OUT)) & 0x7fffffff))
#define SET_MONITOR_BUS_MCU_31_0(_VAL_) (REG32(ADR_BIST_MONITOR_BUS_LSB)) = (((_VAL_) << 0) | ((REG32(ADR_BIST_MONITOR_BUS_LSB)) & 0x00000000))
#define SET_MONITOR_BUS_MCU_33_32(_VAL_) (REG32(ADR_BIST_MONITOR_BUS_MSB)) = (((_VAL_) << 0) | ((REG32(ADR_BIST_MONITOR_BUS_MSB)) & 0xfffffffc))
#define SET_TB_ADR_SEL(_VAL_) (REG32(ADR_TB_ADR_SEL)) = (((_VAL_) << 0) | ((REG32(ADR_TB_ADR_SEL)) & 0xffff0000))
#define SET_TB_CS(_VAL_) (REG32(ADR_TB_ADR_SEL)) = (((_VAL_) << 31) | ((REG32(ADR_TB_ADR_SEL)) & 0x7fffffff))
#define SET_TB_RDATA(_VAL_) (REG32(ADR_TB_RDATA)) = (((_VAL_) << 0) | ((REG32(ADR_TB_RDATA)) & 0x00000000))
#define SET_UART_W2B_EN(_VAL_) (REG32(ADR_UART_W2B)) = (((_VAL_) << 0) | ((REG32(ADR_UART_W2B)) & 0xfffffffe))
#define SET_DATA_UART_W2B_EN(_VAL_) (REG32(ADR_UART_W2B)) = (((_VAL_) << 4) | ((REG32(ADR_UART_W2B)) & 0xffffffef))
#define SET_AHB_ILL_ADDR(_VAL_) (REG32(ADR_AHB_ILL_ADDR)) = (((_VAL_) << 0) | ((REG32(ADR_AHB_ILL_ADDR)) & 0x00000000))
#define SET_AHB_FEN_ADDR(_VAL_) (REG32(ADR_AHB_FEN_ADDR)) = (((_VAL_) << 0) | ((REG32(ADR_AHB_FEN_ADDR)) & 0x00000000))
#define SET_ILL_ADDR_CLR(_VAL_) (REG32(ADR_AHB_ILLFEN_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_AHB_ILLFEN_STATUS)) & 0xfffffffe))
#define SET_FENCE_HIT_CLR(_VAL_) (REG32(ADR_AHB_ILLFEN_STATUS)) = (((_VAL_) << 1) | ((REG32(ADR_AHB_ILLFEN_STATUS)) & 0xfffffffd))
#define SET_ILL_ADDR_INT(_VAL_) (REG32(ADR_AHB_ILLFEN_STATUS)) = (((_VAL_) << 4) | ((REG32(ADR_AHB_ILLFEN_STATUS)) & 0xffffffef))
#define SET_FENCE_HIT_INT(_VAL_) (REG32(ADR_AHB_ILLFEN_STATUS)) = (((_VAL_) << 5) | ((REG32(ADR_AHB_ILLFEN_STATUS)) & 0xffffffdf))
#define SET_PWM_INI_VALUE_P_A(_VAL_) (REG32(ADR_PWM_A)) = (((_VAL_) << 0) | ((REG32(ADR_PWM_A)) & 0xffffff00))
#define SET_PWM_INI_VALUE_N_A(_VAL_) (REG32(ADR_PWM_A)) = (((_VAL_) << 8) | ((REG32(ADR_PWM_A)) & 0xffff00ff))
#define SET_PWM_POST_SCALER_A(_VAL_) (REG32(ADR_PWM_A)) = (((_VAL_) << 16) | ((REG32(ADR_PWM_A)) & 0xfff0ffff))
#define SET_PWM_ALWAYSON_A(_VAL_) (REG32(ADR_PWM_A)) = (((_VAL_) << 29) | ((REG32(ADR_PWM_A)) & 0xdfffffff))
#define SET_PWM_INVERT_A(_VAL_) (REG32(ADR_PWM_A)) = (((_VAL_) << 30) | ((REG32(ADR_PWM_A)) & 0xbfffffff))
#define SET_PWM_ENABLE_A(_VAL_) (REG32(ADR_PWM_A)) = (((_VAL_) << 31) | ((REG32(ADR_PWM_A)) & 0x7fffffff))
#define SET_PWM_INI_VALUE_P_B(_VAL_) (REG32(ADR_PWM_B)) = (((_VAL_) << 0) | ((REG32(ADR_PWM_B)) & 0xffffff00))
#define SET_PWM_INI_VALUE_N_B(_VAL_) (REG32(ADR_PWM_B)) = (((_VAL_) << 8) | ((REG32(ADR_PWM_B)) & 0xffff00ff))
#define SET_PWM_POST_SCALER_B(_VAL_) (REG32(ADR_PWM_B)) = (((_VAL_) << 16) | ((REG32(ADR_PWM_B)) & 0xfff0ffff))
#define SET_PWM_ALWAYSON_B(_VAL_) (REG32(ADR_PWM_B)) = (((_VAL_) << 29) | ((REG32(ADR_PWM_B)) & 0xdfffffff))
#define SET_PWM_INVERT_B(_VAL_) (REG32(ADR_PWM_B)) = (((_VAL_) << 30) | ((REG32(ADR_PWM_B)) & 0xbfffffff))
#define SET_PWM_ENABLE_B(_VAL_) (REG32(ADR_PWM_B)) = (((_VAL_) << 31) | ((REG32(ADR_PWM_B)) & 0x7fffffff))
#define SET_HBUSREQ_LOCK(_VAL_) (REG32(ADR_HBUSREQ_LOCK)) = (((_VAL_) << 0) | ((REG32(ADR_HBUSREQ_LOCK)) & 0xffffe000))
#define SET_HBURST_LOCK(_VAL_) (REG32(ADR_HBURST_LOCK)) = (((_VAL_) << 0) | ((REG32(ADR_HBURST_LOCK)) & 0xffffe000))
#define SET_PRESCALER_USTIMER(_VAL_) (REG32(ADR_PRESCALER_USTIMER)) = (((_VAL_) << 0) | ((REG32(ADR_PRESCALER_USTIMER)) & 0xfffffe00))
#define SET_MODE_REG_IN_MMU(_VAL_) (REG32(ADR_BIST_MODE_REG_IN_MMU)) = (((_VAL_) << 0) | ((REG32(ADR_BIST_MODE_REG_IN_MMU)) & 0xffff0000))
#define SET_MODE_REG_OUT_MMU(_VAL_) (REG32(ADR_BIST_MODE_REG_OUT_MMU)) = (((_VAL_) << 0) | ((REG32(ADR_BIST_MODE_REG_OUT_MMU)) & 0xffff0000))
#define SET_MODE_REG_SO_MMU(_VAL_) (REG32(ADR_BIST_MODE_REG_OUT_MMU)) = (((_VAL_) << 31) | ((REG32(ADR_BIST_MODE_REG_OUT_MMU)) & 0x7fffffff))
#define SET_MONITOR_BUS_MMU(_VAL_) (REG32(ADR_BIST_MONITOR_BUS_MMU)) = (((_VAL_) << 0) | ((REG32(ADR_BIST_MONITOR_BUS_MMU)) & 0xfff80000))
#define SET_TEST_MODE0(_VAL_) (REG32(ADR_TEST_MODE)) = (((_VAL_) << 0) | ((REG32(ADR_TEST_MODE)) & 0xfffffffe))
#define SET_TEST_MODE1(_VAL_) (REG32(ADR_TEST_MODE)) = (((_VAL_) << 1) | ((REG32(ADR_TEST_MODE)) & 0xfffffffd))
#define SET_TEST_MODE2(_VAL_) (REG32(ADR_TEST_MODE)) = (((_VAL_) << 2) | ((REG32(ADR_TEST_MODE)) & 0xfffffffb))
#define SET_TEST_MODE3(_VAL_) (REG32(ADR_TEST_MODE)) = (((_VAL_) << 3) | ((REG32(ADR_TEST_MODE)) & 0xfffffff7))
#define SET_TEST_MODE4(_VAL_) (REG32(ADR_TEST_MODE)) = (((_VAL_) << 4) | ((REG32(ADR_TEST_MODE)) & 0xffffffef))
#define SET_TEST_MODE_ALL(_VAL_) (REG32(ADR_TEST_MODE)) = (((_VAL_) << 5) | ((REG32(ADR_TEST_MODE)) & 0xffffffdf))
#define SET_WDT_INIT(_VAL_) (REG32(ADR_BOOT_INFO)) = (((_VAL_) << 0) | ((REG32(ADR_BOOT_INFO)) & 0xfffffffe))
#define SET_SD_HOST_INIT(_VAL_) (REG32(ADR_BOOT_INFO)) = (((_VAL_) << 1) | ((REG32(ADR_BOOT_INFO)) & 0xfffffffd))
#define SET_ALLOW_SD_RESET(_VAL_) (REG32(ADR_SD_INIT_CFG)) = (((_VAL_) << 0) | ((REG32(ADR_SD_INIT_CFG)) & 0xfffffffe))
#define SET_UART_NRTS(_VAL_) (REG32(ADR_SPARE_UART_INFO)) = (((_VAL_) << 0) | ((REG32(ADR_SPARE_UART_INFO)) & 0xfffffffe))
#define SET_UART_NCTS(_VAL_) (REG32(ADR_SPARE_UART_INFO)) = (((_VAL_) << 1) | ((REG32(ADR_SPARE_UART_INFO)) & 0xfffffffd))
#define SET_TU0_TM_INIT_VALUE(_VAL_) (REG32(ADR_TU0_MICROSECOND_TIMER)) = (((_VAL_) << 0) | ((REG32(ADR_TU0_MICROSECOND_TIMER)) & 0xffff0000))
#define SET_TU0_TM_MODE(_VAL_) (REG32(ADR_TU0_MICROSECOND_TIMER)) = (((_VAL_) << 16) | ((REG32(ADR_TU0_MICROSECOND_TIMER)) & 0xfffeffff))
#define SET_TU0_TM_INT_STS_DONE(_VAL_) (REG32(ADR_TU0_MICROSECOND_TIMER)) = (((_VAL_) << 17) | ((REG32(ADR_TU0_MICROSECOND_TIMER)) & 0xfffdffff))
#define SET_TU0_TM_INT_MASK(_VAL_) (REG32(ADR_TU0_MICROSECOND_TIMER)) = (((_VAL_) << 18) | ((REG32(ADR_TU0_MICROSECOND_TIMER)) & 0xfffbffff))
#define SET_TU0_TM_CUR_VALUE(_VAL_) (REG32(ADR_TU0_CURRENT_MICROSECOND_TIME_VALUE)) = (((_VAL_) << 0) | ((REG32(ADR_TU0_CURRENT_MICROSECOND_TIME_VALUE)) & 0xffff0000))
#define SET_TU1_TM_INIT_VALUE(_VAL_) (REG32(ADR_TU1_MICROSECOND_TIMER)) = (((_VAL_) << 0) | ((REG32(ADR_TU1_MICROSECOND_TIMER)) & 0xffff0000))
#define SET_TU1_TM_MODE(_VAL_) (REG32(ADR_TU1_MICROSECOND_TIMER)) = (((_VAL_) << 16) | ((REG32(ADR_TU1_MICROSECOND_TIMER)) & 0xfffeffff))
#define SET_TU1_TM_INT_STS_DONE(_VAL_) (REG32(ADR_TU1_MICROSECOND_TIMER)) = (((_VAL_) << 17) | ((REG32(ADR_TU1_MICROSECOND_TIMER)) & 0xfffdffff))
#define SET_TU1_TM_INT_MASK(_VAL_) (REG32(ADR_TU1_MICROSECOND_TIMER)) = (((_VAL_) << 18) | ((REG32(ADR_TU1_MICROSECOND_TIMER)) & 0xfffbffff))
#define SET_TU1_TM_CUR_VALUE(_VAL_) (REG32(ADR_TU1_CURRENT_MICROSECOND_TIME_VALUE)) = (((_VAL_) << 0) | ((REG32(ADR_TU1_CURRENT_MICROSECOND_TIME_VALUE)) & 0xffff0000))
#define SET_TU2_TM_INIT_VALUE(_VAL_) (REG32(ADR_TU2_MICROSECOND_TIMER)) = (((_VAL_) << 0) | ((REG32(ADR_TU2_MICROSECOND_TIMER)) & 0xffff0000))
#define SET_TU2_TM_MODE(_VAL_) (REG32(ADR_TU2_MICROSECOND_TIMER)) = (((_VAL_) << 16) | ((REG32(ADR_TU2_MICROSECOND_TIMER)) & 0xfffeffff))
#define SET_TU2_TM_INT_STS_DONE(_VAL_) (REG32(ADR_TU2_MICROSECOND_TIMER)) = (((_VAL_) << 17) | ((REG32(ADR_TU2_MICROSECOND_TIMER)) & 0xfffdffff))
#define SET_TU2_TM_INT_MASK(_VAL_) (REG32(ADR_TU2_MICROSECOND_TIMER)) = (((_VAL_) << 18) | ((REG32(ADR_TU2_MICROSECOND_TIMER)) & 0xfffbffff))
#define SET_TU2_TM_CUR_VALUE(_VAL_) (REG32(ADR_TU2_CURRENT_MICROSECOND_TIME_VALUE)) = (((_VAL_) << 0) | ((REG32(ADR_TU2_CURRENT_MICROSECOND_TIME_VALUE)) & 0xffff0000))
#define SET_TU3_TM_INIT_VALUE(_VAL_) (REG32(ADR_TU3_MICROSECOND_TIMER)) = (((_VAL_) << 0) | ((REG32(ADR_TU3_MICROSECOND_TIMER)) & 0xffff0000))
#define SET_TU3_TM_MODE(_VAL_) (REG32(ADR_TU3_MICROSECOND_TIMER)) = (((_VAL_) << 16) | ((REG32(ADR_TU3_MICROSECOND_TIMER)) & 0xfffeffff))
#define SET_TU3_TM_INT_STS_DONE(_VAL_) (REG32(ADR_TU3_MICROSECOND_TIMER)) = (((_VAL_) << 17) | ((REG32(ADR_TU3_MICROSECOND_TIMER)) & 0xfffdffff))
#define SET_TU3_TM_INT_MASK(_VAL_) (REG32(ADR_TU3_MICROSECOND_TIMER)) = (((_VAL_) << 18) | ((REG32(ADR_TU3_MICROSECOND_TIMER)) & 0xfffbffff))
#define SET_TU3_TM_CUR_VALUE(_VAL_) (REG32(ADR_TU3_CURRENT_MICROSECOND_TIME_VALUE)) = (((_VAL_) << 0) | ((REG32(ADR_TU3_CURRENT_MICROSECOND_TIME_VALUE)) & 0xffff0000))
#define SET_TM0_TM_INIT_VALUE(_VAL_) (REG32(ADR_TM0_MILISECOND_TIMER)) = (((_VAL_) << 0) | ((REG32(ADR_TM0_MILISECOND_TIMER)) & 0xffff0000))
#define SET_TM0_TM_MODE(_VAL_) (REG32(ADR_TM0_MILISECOND_TIMER)) = (((_VAL_) << 16) | ((REG32(ADR_TM0_MILISECOND_TIMER)) & 0xfffeffff))
#define SET_TM0_TM_INT_STS_DONE(_VAL_) (REG32(ADR_TM0_MILISECOND_TIMER)) = (((_VAL_) << 17) | ((REG32(ADR_TM0_MILISECOND_TIMER)) & 0xfffdffff))
#define SET_TM0_TM_INT_MASK(_VAL_) (REG32(ADR_TM0_MILISECOND_TIMER)) = (((_VAL_) << 18) | ((REG32(ADR_TM0_MILISECOND_TIMER)) & 0xfffbffff))
#define SET_TM0_TM_CUR_VALUE(_VAL_) (REG32(ADR_TM0_CURRENT_MILISECOND_TIME_VALUE)) = (((_VAL_) << 0) | ((REG32(ADR_TM0_CURRENT_MILISECOND_TIME_VALUE)) & 0xffff0000))
#define SET_TM1_TM_INIT_VALUE(_VAL_) (REG32(ADR_TM1_MILISECOND_TIMER)) = (((_VAL_) << 0) | ((REG32(ADR_TM1_MILISECOND_TIMER)) & 0xffff0000))
#define SET_TM1_TM_MODE(_VAL_) (REG32(ADR_TM1_MILISECOND_TIMER)) = (((_VAL_) << 16) | ((REG32(ADR_TM1_MILISECOND_TIMER)) & 0xfffeffff))
#define SET_TM1_TM_INT_STS_DONE(_VAL_) (REG32(ADR_TM1_MILISECOND_TIMER)) = (((_VAL_) << 17) | ((REG32(ADR_TM1_MILISECOND_TIMER)) & 0xfffdffff))
#define SET_TM1_TM_INT_MASK(_VAL_) (REG32(ADR_TM1_MILISECOND_TIMER)) = (((_VAL_) << 18) | ((REG32(ADR_TM1_MILISECOND_TIMER)) & 0xfffbffff))
#define SET_TM1_TM_CUR_VALUE(_VAL_) (REG32(ADR_TM1_CURRENT_MILISECOND_TIME_VALUE)) = (((_VAL_) << 0) | ((REG32(ADR_TM1_CURRENT_MILISECOND_TIME_VALUE)) & 0xffff0000))
#define SET_TM2_TM_INIT_VALUE(_VAL_) (REG32(ADR_TM2_MILISECOND_TIMER)) = (((_VAL_) << 0) | ((REG32(ADR_TM2_MILISECOND_TIMER)) & 0xffff0000))
#define SET_TM2_TM_MODE(_VAL_) (REG32(ADR_TM2_MILISECOND_TIMER)) = (((_VAL_) << 16) | ((REG32(ADR_TM2_MILISECOND_TIMER)) & 0xfffeffff))
#define SET_TM2_TM_INT_STS_DONE(_VAL_) (REG32(ADR_TM2_MILISECOND_TIMER)) = (((_VAL_) << 17) | ((REG32(ADR_TM2_MILISECOND_TIMER)) & 0xfffdffff))
#define SET_TM2_TM_INT_MASK(_VAL_) (REG32(ADR_TM2_MILISECOND_TIMER)) = (((_VAL_) << 18) | ((REG32(ADR_TM2_MILISECOND_TIMER)) & 0xfffbffff))
#define SET_TM2_TM_CUR_VALUE(_VAL_) (REG32(ADR_TM2_CURRENT_MILISECOND_TIME_VALUE)) = (((_VAL_) << 0) | ((REG32(ADR_TM2_CURRENT_MILISECOND_TIME_VALUE)) & 0xffff0000))
#define SET_TM3_TM_INIT_VALUE(_VAL_) (REG32(ADR_TM3_MILISECOND_TIMER)) = (((_VAL_) << 0) | ((REG32(ADR_TM3_MILISECOND_TIMER)) & 0xffff0000))
#define SET_TM3_TM_MODE(_VAL_) (REG32(ADR_TM3_MILISECOND_TIMER)) = (((_VAL_) << 16) | ((REG32(ADR_TM3_MILISECOND_TIMER)) & 0xfffeffff))
#define SET_TM3_TM_INT_STS_DONE(_VAL_) (REG32(ADR_TM3_MILISECOND_TIMER)) = (((_VAL_) << 17) | ((REG32(ADR_TM3_MILISECOND_TIMER)) & 0xfffdffff))
#define SET_TM3_TM_INT_MASK(_VAL_) (REG32(ADR_TM3_MILISECOND_TIMER)) = (((_VAL_) << 18) | ((REG32(ADR_TM3_MILISECOND_TIMER)) & 0xfffbffff))
#define SET_TM3_TM_CUR_VALUE(_VAL_) (REG32(ADR_TM3_CURRENT_MILISECOND_TIME_VALUE)) = (((_VAL_) << 0) | ((REG32(ADR_TM3_CURRENT_MILISECOND_TIME_VALUE)) & 0xffff0000))
#define SET_MCU_WDT_TIME_CNT(_VAL_) (REG32(ADR_MCU_WDOG_REG)) = (((_VAL_) << 0) | ((REG32(ADR_MCU_WDOG_REG)) & 0xffff0000))
#define SET_MCU_WDT_STATUS(_VAL_) (REG32(ADR_MCU_WDOG_REG)) = (((_VAL_) << 17) | ((REG32(ADR_MCU_WDOG_REG)) & 0xfffdffff))
#define SET_MCU_WDOG_ENA(_VAL_) (REG32(ADR_MCU_WDOG_REG)) = (((_VAL_) << 31) | ((REG32(ADR_MCU_WDOG_REG)) & 0x7fffffff))
#define SET_SYS_WDT_TIME_CNT(_VAL_) (REG32(ADR_SYS_WDOG_REG)) = (((_VAL_) << 0) | ((REG32(ADR_SYS_WDOG_REG)) & 0xffff0000))
#define SET_SYS_WDT_STATUS(_VAL_) (REG32(ADR_SYS_WDOG_REG)) = (((_VAL_) << 17) | ((REG32(ADR_SYS_WDOG_REG)) & 0xfffdffff))
#define SET_SYS_WDOG_ENA(_VAL_) (REG32(ADR_SYS_WDOG_REG)) = (((_VAL_) << 31) | ((REG32(ADR_SYS_WDOG_REG)) & 0x7fffffff))
#define SET_XLNA_EN_O_OE(_VAL_) (REG32(ADR_PAD6)) = (((_VAL_) << 0) | ((REG32(ADR_PAD6)) & 0xfffffffe))
#define SET_XLNA_EN_O_PE(_VAL_) (REG32(ADR_PAD6)) = (((_VAL_) << 1) | ((REG32(ADR_PAD6)) & 0xfffffffd))
#define SET_PAD6_IE(_VAL_) (REG32(ADR_PAD6)) = (((_VAL_) << 3) | ((REG32(ADR_PAD6)) & 0xfffffff7))
#define SET_PAD6_SEL_I(_VAL_) (REG32(ADR_PAD6)) = (((_VAL_) << 4) | ((REG32(ADR_PAD6)) & 0xffffffcf))
#define SET_PAD6_OD(_VAL_) (REG32(ADR_PAD6)) = (((_VAL_) << 8) | ((REG32(ADR_PAD6)) & 0xfffffeff))
#define SET_PAD6_SEL_O(_VAL_) (REG32(ADR_PAD6)) = (((_VAL_) << 12) | ((REG32(ADR_PAD6)) & 0xffffefff))
#define SET_XLNA_EN_O_C(_VAL_) (REG32(ADR_PAD6)) = (((_VAL_) << 28) | ((REG32(ADR_PAD6)) & 0xefffffff))
#define SET_WIFI_TX_SW_O_OE(_VAL_) (REG32(ADR_PAD7)) = (((_VAL_) << 0) | ((REG32(ADR_PAD7)) & 0xfffffffe))
#define SET_WIFI_TX_SW_O_PE(_VAL_) (REG32(ADR_PAD7)) = (((_VAL_) << 1) | ((REG32(ADR_PAD7)) & 0xfffffffd))
#define SET_PAD7_IE(_VAL_) (REG32(ADR_PAD7)) = (((_VAL_) << 3) | ((REG32(ADR_PAD7)) & 0xfffffff7))
#define SET_PAD7_SEL_I(_VAL_) (REG32(ADR_PAD7)) = (((_VAL_) << 4) | ((REG32(ADR_PAD7)) & 0xffffffcf))
#define SET_PAD7_OD(_VAL_) (REG32(ADR_PAD7)) = (((_VAL_) << 8) | ((REG32(ADR_PAD7)) & 0xfffffeff))
#define SET_PAD7_SEL_O(_VAL_) (REG32(ADR_PAD7)) = (((_VAL_) << 12) | ((REG32(ADR_PAD7)) & 0xffffefff))
#define SET_WIFI_TX_SW_O_C(_VAL_) (REG32(ADR_PAD7)) = (((_VAL_) << 28) | ((REG32(ADR_PAD7)) & 0xefffffff))
#define SET_WIFI_RX_SW_O_OE(_VAL_) (REG32(ADR_PAD8)) = (((_VAL_) << 0) | ((REG32(ADR_PAD8)) & 0xfffffffe))
#define SET_WIFI_RX_SW_O_PE(_VAL_) (REG32(ADR_PAD8)) = (((_VAL_) << 1) | ((REG32(ADR_PAD8)) & 0xfffffffd))
#define SET_PAD8_IE(_VAL_) (REG32(ADR_PAD8)) = (((_VAL_) << 3) | ((REG32(ADR_PAD8)) & 0xfffffff7))
#define SET_PAD8_SEL_I(_VAL_) (REG32(ADR_PAD8)) = (((_VAL_) << 4) | ((REG32(ADR_PAD8)) & 0xffffffcf))
#define SET_PAD8_OD(_VAL_) (REG32(ADR_PAD8)) = (((_VAL_) << 8) | ((REG32(ADR_PAD8)) & 0xfffffeff))
#define SET_WIFI_RX_SW_O_C(_VAL_) (REG32(ADR_PAD8)) = (((_VAL_) << 28) | ((REG32(ADR_PAD8)) & 0xefffffff))
#define SET_BT_SW_O_OE(_VAL_) (REG32(ADR_PAD9)) = (((_VAL_) << 0) | ((REG32(ADR_PAD9)) & 0xfffffffe))
#define SET_BT_SW_O_PE(_VAL_) (REG32(ADR_PAD9)) = (((_VAL_) << 1) | ((REG32(ADR_PAD9)) & 0xfffffffd))
#define SET_PAD9_IE(_VAL_) (REG32(ADR_PAD9)) = (((_VAL_) << 3) | ((REG32(ADR_PAD9)) & 0xfffffff7))
#define SET_PAD9_SEL_I(_VAL_) (REG32(ADR_PAD9)) = (((_VAL_) << 4) | ((REG32(ADR_PAD9)) & 0xffffffcf))
#define SET_PAD9_OD(_VAL_) (REG32(ADR_PAD9)) = (((_VAL_) << 8) | ((REG32(ADR_PAD9)) & 0xfffffeff))
#define SET_PAD9_SEL_O(_VAL_) (REG32(ADR_PAD9)) = (((_VAL_) << 12) | ((REG32(ADR_PAD9)) & 0xffffefff))
#define SET_BT_SW_O_C(_VAL_) (REG32(ADR_PAD9)) = (((_VAL_) << 28) | ((REG32(ADR_PAD9)) & 0xefffffff))
#define SET_XPA_EN_O_OE(_VAL_) (REG32(ADR_PAD11)) = (((_VAL_) << 0) | ((REG32(ADR_PAD11)) & 0xfffffffe))
#define SET_XPA_EN_O_PE(_VAL_) (REG32(ADR_PAD11)) = (((_VAL_) << 1) | ((REG32(ADR_PAD11)) & 0xfffffffd))
#define SET_PAD11_IE(_VAL_) (REG32(ADR_PAD11)) = (((_VAL_) << 3) | ((REG32(ADR_PAD11)) & 0xfffffff7))
#define SET_PAD11_SEL_I(_VAL_) (REG32(ADR_PAD11)) = (((_VAL_) << 4) | ((REG32(ADR_PAD11)) & 0xffffffcf))
#define SET_PAD11_OD(_VAL_) (REG32(ADR_PAD11)) = (((_VAL_) << 8) | ((REG32(ADR_PAD11)) & 0xfffffeff))
#define SET_PAD11_SEL_O(_VAL_) (REG32(ADR_PAD11)) = (((_VAL_) << 12) | ((REG32(ADR_PAD11)) & 0xffffefff))
#define SET_XPA_EN_O_C(_VAL_) (REG32(ADR_PAD11)) = (((_VAL_) << 28) | ((REG32(ADR_PAD11)) & 0xefffffff))
#define SET_PAD15_OE(_VAL_) (REG32(ADR_PAD15)) = (((_VAL_) << 0) | ((REG32(ADR_PAD15)) & 0xfffffffe))
#define SET_PAD15_PE(_VAL_) (REG32(ADR_PAD15)) = (((_VAL_) << 1) | ((REG32(ADR_PAD15)) & 0xfffffffd))
#define SET_PAD15_DS(_VAL_) (REG32(ADR_PAD15)) = (((_VAL_) << 2) | ((REG32(ADR_PAD15)) & 0xfffffffb))
#define SET_PAD15_IE(_VAL_) (REG32(ADR_PAD15)) = (((_VAL_) << 3) | ((REG32(ADR_PAD15)) & 0xfffffff7))
#define SET_PAD15_SEL_I(_VAL_) (REG32(ADR_PAD15)) = (((_VAL_) << 4) | ((REG32(ADR_PAD15)) & 0xffffffcf))
#define SET_PAD15_OD(_VAL_) (REG32(ADR_PAD15)) = (((_VAL_) << 8) | ((REG32(ADR_PAD15)) & 0xfffffeff))
#define SET_PAD15_SEL_O(_VAL_) (REG32(ADR_PAD15)) = (((_VAL_) << 12) | ((REG32(ADR_PAD15)) & 0xffffefff))
#define SET_TEST_1_ID(_VAL_) (REG32(ADR_PAD15)) = (((_VAL_) << 28) | ((REG32(ADR_PAD15)) & 0xefffffff))
#define SET_PAD16_OE(_VAL_) (REG32(ADR_PAD16)) = (((_VAL_) << 0) | ((REG32(ADR_PAD16)) & 0xfffffffe))
#define SET_PAD16_PE(_VAL_) (REG32(ADR_PAD16)) = (((_VAL_) << 1) | ((REG32(ADR_PAD16)) & 0xfffffffd))
#define SET_PAD16_DS(_VAL_) (REG32(ADR_PAD16)) = (((_VAL_) << 2) | ((REG32(ADR_PAD16)) & 0xfffffffb))
#define SET_PAD16_IE(_VAL_) (REG32(ADR_PAD16)) = (((_VAL_) << 3) | ((REG32(ADR_PAD16)) & 0xfffffff7))
#define SET_PAD16_SEL_I(_VAL_) (REG32(ADR_PAD16)) = (((_VAL_) << 4) | ((REG32(ADR_PAD16)) & 0xffffffcf))
#define SET_PAD16_OD(_VAL_) (REG32(ADR_PAD16)) = (((_VAL_) << 8) | ((REG32(ADR_PAD16)) & 0xfffffeff))
#define SET_PAD16_SEL_O(_VAL_) (REG32(ADR_PAD16)) = (((_VAL_) << 12) | ((REG32(ADR_PAD16)) & 0xffffefff))
#define SET_TEST_2_ID(_VAL_) (REG32(ADR_PAD16)) = (((_VAL_) << 28) | ((REG32(ADR_PAD16)) & 0xefffffff))
#define SET_PAD17_OE(_VAL_) (REG32(ADR_PAD17)) = (((_VAL_) << 0) | ((REG32(ADR_PAD17)) & 0xfffffffe))
#define SET_PAD17_PE(_VAL_) (REG32(ADR_PAD17)) = (((_VAL_) << 1) | ((REG32(ADR_PAD17)) & 0xfffffffd))
#define SET_PAD17_DS(_VAL_) (REG32(ADR_PAD17)) = (((_VAL_) << 2) | ((REG32(ADR_PAD17)) & 0xfffffffb))
#define SET_PAD17_IE(_VAL_) (REG32(ADR_PAD17)) = (((_VAL_) << 3) | ((REG32(ADR_PAD17)) & 0xfffffff7))
#define SET_PAD17_SEL_I(_VAL_) (REG32(ADR_PAD17)) = (((_VAL_) << 4) | ((REG32(ADR_PAD17)) & 0xffffffcf))
#define SET_PAD17_OD(_VAL_) (REG32(ADR_PAD17)) = (((_VAL_) << 8) | ((REG32(ADR_PAD17)) & 0xfffffeff))
#define SET_PAD17_SEL_O(_VAL_) (REG32(ADR_PAD17)) = (((_VAL_) << 12) | ((REG32(ADR_PAD17)) & 0xffffefff))
#define SET_TEST_3_ID(_VAL_) (REG32(ADR_PAD17)) = (((_VAL_) << 28) | ((REG32(ADR_PAD17)) & 0xefffffff))
#define SET_PAD18_OE(_VAL_) (REG32(ADR_PAD18)) = (((_VAL_) << 0) | ((REG32(ADR_PAD18)) & 0xfffffffe))
#define SET_PAD18_PE(_VAL_) (REG32(ADR_PAD18)) = (((_VAL_) << 1) | ((REG32(ADR_PAD18)) & 0xfffffffd))
#define SET_PAD18_DS(_VAL_) (REG32(ADR_PAD18)) = (((_VAL_) << 2) | ((REG32(ADR_PAD18)) & 0xfffffffb))
#define SET_PAD18_IE(_VAL_) (REG32(ADR_PAD18)) = (((_VAL_) << 3) | ((REG32(ADR_PAD18)) & 0xfffffff7))
#define SET_PAD18_SEL_I(_VAL_) (REG32(ADR_PAD18)) = (((_VAL_) << 4) | ((REG32(ADR_PAD18)) & 0xffffffcf))
#define SET_PAD18_OD(_VAL_) (REG32(ADR_PAD18)) = (((_VAL_) << 8) | ((REG32(ADR_PAD18)) & 0xfffffeff))
#define SET_PAD18_SEL_O(_VAL_) (REG32(ADR_PAD18)) = (((_VAL_) << 12) | ((REG32(ADR_PAD18)) & 0xffffcfff))
#define SET_TEST_4_ID(_VAL_) (REG32(ADR_PAD18)) = (((_VAL_) << 28) | ((REG32(ADR_PAD18)) & 0xefffffff))
#define SET_PAD19_OE(_VAL_) (REG32(ADR_PAD19)) = (((_VAL_) << 0) | ((REG32(ADR_PAD19)) & 0xfffffffe))
#define SET_PAD19_PE(_VAL_) (REG32(ADR_PAD19)) = (((_VAL_) << 1) | ((REG32(ADR_PAD19)) & 0xfffffffd))
#define SET_PAD19_DS(_VAL_) (REG32(ADR_PAD19)) = (((_VAL_) << 2) | ((REG32(ADR_PAD19)) & 0xfffffffb))
#define SET_PAD19_IE(_VAL_) (REG32(ADR_PAD19)) = (((_VAL_) << 3) | ((REG32(ADR_PAD19)) & 0xfffffff7))
#define SET_PAD19_SEL_I(_VAL_) (REG32(ADR_PAD19)) = (((_VAL_) << 4) | ((REG32(ADR_PAD19)) & 0xffffffcf))
#define SET_PAD19_OD(_VAL_) (REG32(ADR_PAD19)) = (((_VAL_) << 8) | ((REG32(ADR_PAD19)) & 0xfffffeff))
#define SET_PAD19_SEL_O(_VAL_) (REG32(ADR_PAD19)) = (((_VAL_) << 12) | ((REG32(ADR_PAD19)) & 0xffff8fff))
#define SET_SHORT_TO_20_ID(_VAL_) (REG32(ADR_PAD19)) = (((_VAL_) << 28) | ((REG32(ADR_PAD19)) & 0xefffffff))
#define SET_PAD20_OE(_VAL_) (REG32(ADR_PAD20)) = (((_VAL_) << 0) | ((REG32(ADR_PAD20)) & 0xfffffffe))
#define SET_PAD20_PE(_VAL_) (REG32(ADR_PAD20)) = (((_VAL_) << 1) | ((REG32(ADR_PAD20)) & 0xfffffffd))
#define SET_PAD20_DS(_VAL_) (REG32(ADR_PAD20)) = (((_VAL_) << 2) | ((REG32(ADR_PAD20)) & 0xfffffffb))
#define SET_PAD20_IE(_VAL_) (REG32(ADR_PAD20)) = (((_VAL_) << 3) | ((REG32(ADR_PAD20)) & 0xfffffff7))
#define SET_PAD20_SEL_I(_VAL_) (REG32(ADR_PAD20)) = (((_VAL_) << 4) | ((REG32(ADR_PAD20)) & 0xffffff0f))
#define SET_PAD20_OD(_VAL_) (REG32(ADR_PAD20)) = (((_VAL_) << 8) | ((REG32(ADR_PAD20)) & 0xfffffeff))
#define SET_PAD20_SEL_O(_VAL_) (REG32(ADR_PAD20)) = (((_VAL_) << 12) | ((REG32(ADR_PAD20)) & 0xffffcfff))
#define SET_STRAP0(_VAL_) (REG32(ADR_PAD20)) = (((_VAL_) << 27) | ((REG32(ADR_PAD20)) & 0xf7ffffff))
#define SET_GPIO_TEST_1_ID(_VAL_) (REG32(ADR_PAD20)) = (((_VAL_) << 28) | ((REG32(ADR_PAD20)) & 0xefffffff))
#define SET_PAD21_OE(_VAL_) (REG32(ADR_PAD21)) = (((_VAL_) << 0) | ((REG32(ADR_PAD21)) & 0xfffffffe))
#define SET_PAD21_PE(_VAL_) (REG32(ADR_PAD21)) = (((_VAL_) << 1) | ((REG32(ADR_PAD21)) & 0xfffffffd))
#define SET_PAD21_DS(_VAL_) (REG32(ADR_PAD21)) = (((_VAL_) << 2) | ((REG32(ADR_PAD21)) & 0xfffffffb))
#define SET_PAD21_IE(_VAL_) (REG32(ADR_PAD21)) = (((_VAL_) << 3) | ((REG32(ADR_PAD21)) & 0xfffffff7))
#define SET_PAD21_SEL_I(_VAL_) (REG32(ADR_PAD21)) = (((_VAL_) << 4) | ((REG32(ADR_PAD21)) & 0xffffff8f))
#define SET_PAD21_OD(_VAL_) (REG32(ADR_PAD21)) = (((_VAL_) << 8) | ((REG32(ADR_PAD21)) & 0xfffffeff))
#define SET_PAD21_SEL_O(_VAL_) (REG32(ADR_PAD21)) = (((_VAL_) << 12) | ((REG32(ADR_PAD21)) & 0xffffcfff))
#define SET_STRAP3(_VAL_) (REG32(ADR_PAD21)) = (((_VAL_) << 27) | ((REG32(ADR_PAD21)) & 0xf7ffffff))
#define SET_GPIO_TEST_2_ID(_VAL_) (REG32(ADR_PAD21)) = (((_VAL_) << 28) | ((REG32(ADR_PAD21)) & 0xefffffff))
#define SET_PAD22_OE(_VAL_) (REG32(ADR_PAD22)) = (((_VAL_) << 0) | ((REG32(ADR_PAD22)) & 0xfffffffe))
#define SET_PAD22_PE(_VAL_) (REG32(ADR_PAD22)) = (((_VAL_) << 1) | ((REG32(ADR_PAD22)) & 0xfffffffd))
#define SET_PAD22_DS(_VAL_) (REG32(ADR_PAD22)) = (((_VAL_) << 2) | ((REG32(ADR_PAD22)) & 0xfffffffb))
#define SET_PAD22_IE(_VAL_) (REG32(ADR_PAD22)) = (((_VAL_) << 3) | ((REG32(ADR_PAD22)) & 0xfffffff7))
#define SET_PAD22_SEL_I(_VAL_) (REG32(ADR_PAD22)) = (((_VAL_) << 4) | ((REG32(ADR_PAD22)) & 0xffffff8f))
#define SET_PAD22_OD(_VAL_) (REG32(ADR_PAD22)) = (((_VAL_) << 8) | ((REG32(ADR_PAD22)) & 0xfffffeff))
#define SET_PAD22_SEL_O(_VAL_) (REG32(ADR_PAD22)) = (((_VAL_) << 12) | ((REG32(ADR_PAD22)) & 0xffff8fff))
#define SET_PAD22_SEL_OE(_VAL_) (REG32(ADR_PAD22)) = (((_VAL_) << 20) | ((REG32(ADR_PAD22)) & 0xffefffff))
#define SET_GPIO_TEST_3_ID(_VAL_) (REG32(ADR_PAD22)) = (((_VAL_) << 28) | ((REG32(ADR_PAD22)) & 0xefffffff))
#define SET_PAD24_OE(_VAL_) (REG32(ADR_PAD24)) = (((_VAL_) << 0) | ((REG32(ADR_PAD24)) & 0xfffffffe))
#define SET_PAD24_PE(_VAL_) (REG32(ADR_PAD24)) = (((_VAL_) << 1) | ((REG32(ADR_PAD24)) & 0xfffffffd))
#define SET_PAD24_DS(_VAL_) (REG32(ADR_PAD24)) = (((_VAL_) << 2) | ((REG32(ADR_PAD24)) & 0xfffffffb))
#define SET_PAD24_IE(_VAL_) (REG32(ADR_PAD24)) = (((_VAL_) << 3) | ((REG32(ADR_PAD24)) & 0xfffffff7))
#define SET_PAD24_SEL_I(_VAL_) (REG32(ADR_PAD24)) = (((_VAL_) << 4) | ((REG32(ADR_PAD24)) & 0xffffffcf))
#define SET_PAD24_OD(_VAL_) (REG32(ADR_PAD24)) = (((_VAL_) << 8) | ((REG32(ADR_PAD24)) & 0xfffffeff))
#define SET_PAD24_SEL_O(_VAL_) (REG32(ADR_PAD24)) = (((_VAL_) << 12) | ((REG32(ADR_PAD24)) & 0xffff8fff))
#define SET_GPIO_TEST_4_ID(_VAL_) (REG32(ADR_PAD24)) = (((_VAL_) << 28) | ((REG32(ADR_PAD24)) & 0xefffffff))
#define SET_PAD25_OE(_VAL_) (REG32(ADR_PAD25)) = (((_VAL_) << 0) | ((REG32(ADR_PAD25)) & 0xfffffffe))
#define SET_PAD25_PE(_VAL_) (REG32(ADR_PAD25)) = (((_VAL_) << 1) | ((REG32(ADR_PAD25)) & 0xfffffffd))
#define SET_PAD25_DS(_VAL_) (REG32(ADR_PAD25)) = (((_VAL_) << 2) | ((REG32(ADR_PAD25)) & 0xfffffffb))
#define SET_PAD25_IE(_VAL_) (REG32(ADR_PAD25)) = (((_VAL_) << 3) | ((REG32(ADR_PAD25)) & 0xfffffff7))
#define SET_PAD25_SEL_I(_VAL_) (REG32(ADR_PAD25)) = (((_VAL_) << 4) | ((REG32(ADR_PAD25)) & 0xffffff8f))
#define SET_PAD25_OD(_VAL_) (REG32(ADR_PAD25)) = (((_VAL_) << 8) | ((REG32(ADR_PAD25)) & 0xfffffeff))
#define SET_PAD25_SEL_O(_VAL_) (REG32(ADR_PAD25)) = (((_VAL_) << 12) | ((REG32(ADR_PAD25)) & 0xffff8fff))
#define SET_PAD25_SEL_OE(_VAL_) (REG32(ADR_PAD25)) = (((_VAL_) << 20) | ((REG32(ADR_PAD25)) & 0xffefffff))
#define SET_STRAP1(_VAL_) (REG32(ADR_PAD25)) = (((_VAL_) << 27) | ((REG32(ADR_PAD25)) & 0xf7ffffff))
#define SET_GPIO_1_ID(_VAL_) (REG32(ADR_PAD25)) = (((_VAL_) << 28) | ((REG32(ADR_PAD25)) & 0xefffffff))
#define SET_PAD27_OE(_VAL_) (REG32(ADR_PAD27)) = (((_VAL_) << 0) | ((REG32(ADR_PAD27)) & 0xfffffffe))
#define SET_PAD27_PE(_VAL_) (REG32(ADR_PAD27)) = (((_VAL_) << 1) | ((REG32(ADR_PAD27)) & 0xfffffffd))
#define SET_PAD27_DS(_VAL_) (REG32(ADR_PAD27)) = (((_VAL_) << 2) | ((REG32(ADR_PAD27)) & 0xfffffffb))
#define SET_PAD27_IE(_VAL_) (REG32(ADR_PAD27)) = (((_VAL_) << 3) | ((REG32(ADR_PAD27)) & 0xfffffff7))
#define SET_PAD27_SEL_I(_VAL_) (REG32(ADR_PAD27)) = (((_VAL_) << 4) | ((REG32(ADR_PAD27)) & 0xffffff8f))
#define SET_PAD27_OD(_VAL_) (REG32(ADR_PAD27)) = (((_VAL_) << 8) | ((REG32(ADR_PAD27)) & 0xfffffeff))
#define SET_PAD27_SEL_O(_VAL_) (REG32(ADR_PAD27)) = (((_VAL_) << 12) | ((REG32(ADR_PAD27)) & 0xffff8fff))
#define SET_GPIO_2_ID(_VAL_) (REG32(ADR_PAD27)) = (((_VAL_) << 28) | ((REG32(ADR_PAD27)) & 0xefffffff))
#define SET_PAD28_OE(_VAL_) (REG32(ADR_PAD28)) = (((_VAL_) << 0) | ((REG32(ADR_PAD28)) & 0xfffffffe))
#define SET_PAD28_PE(_VAL_) (REG32(ADR_PAD28)) = (((_VAL_) << 1) | ((REG32(ADR_PAD28)) & 0xfffffffd))
#define SET_PAD28_DS(_VAL_) (REG32(ADR_PAD28)) = (((_VAL_) << 2) | ((REG32(ADR_PAD28)) & 0xfffffffb))
#define SET_PAD28_IE(_VAL_) (REG32(ADR_PAD28)) = (((_VAL_) << 3) | ((REG32(ADR_PAD28)) & 0xfffffff7))
#define SET_PAD28_SEL_I(_VAL_) (REG32(ADR_PAD28)) = (((_VAL_) << 4) | ((REG32(ADR_PAD28)) & 0xffffff8f))
#define SET_PAD28_OD(_VAL_) (REG32(ADR_PAD28)) = (((_VAL_) << 8) | ((REG32(ADR_PAD28)) & 0xfffffeff))
#define SET_PAD28_SEL_O(_VAL_) (REG32(ADR_PAD28)) = (((_VAL_) << 12) | ((REG32(ADR_PAD28)) & 0xffff0fff))
#define SET_PAD28_SEL_OE(_VAL_) (REG32(ADR_PAD28)) = (((_VAL_) << 20) | ((REG32(ADR_PAD28)) & 0xffefffff))
#define SET_GPIO_3_ID(_VAL_) (REG32(ADR_PAD28)) = (((_VAL_) << 28) | ((REG32(ADR_PAD28)) & 0xefffffff))
#define SET_PAD29_OE(_VAL_) (REG32(ADR_PAD29)) = (((_VAL_) << 0) | ((REG32(ADR_PAD29)) & 0xfffffffe))
#define SET_PAD29_PE(_VAL_) (REG32(ADR_PAD29)) = (((_VAL_) << 1) | ((REG32(ADR_PAD29)) & 0xfffffffd))
#define SET_PAD29_DS(_VAL_) (REG32(ADR_PAD29)) = (((_VAL_) << 2) | ((REG32(ADR_PAD29)) & 0xfffffffb))
#define SET_PAD29_IE(_VAL_) (REG32(ADR_PAD29)) = (((_VAL_) << 3) | ((REG32(ADR_PAD29)) & 0xfffffff7))
#define SET_PAD29_SEL_I(_VAL_) (REG32(ADR_PAD29)) = (((_VAL_) << 4) | ((REG32(ADR_PAD29)) & 0xffffff8f))
#define SET_PAD29_OD(_VAL_) (REG32(ADR_PAD29)) = (((_VAL_) << 8) | ((REG32(ADR_PAD29)) & 0xfffffeff))
#define SET_PAD29_SEL_O(_VAL_) (REG32(ADR_PAD29)) = (((_VAL_) << 12) | ((REG32(ADR_PAD29)) & 0xffff8fff))
#define SET_GPIO_TEST_5_ID(_VAL_) (REG32(ADR_PAD29)) = (((_VAL_) << 28) | ((REG32(ADR_PAD29)) & 0xefffffff))
#define SET_PAD30_OE(_VAL_) (REG32(ADR_PAD30)) = (((_VAL_) << 0) | ((REG32(ADR_PAD30)) & 0xfffffffe))
#define SET_PAD30_PE(_VAL_) (REG32(ADR_PAD30)) = (((_VAL_) << 1) | ((REG32(ADR_PAD30)) & 0xfffffffd))
#define SET_PAD30_DS(_VAL_) (REG32(ADR_PAD30)) = (((_VAL_) << 2) | ((REG32(ADR_PAD30)) & 0xfffffffb))
#define SET_PAD30_IE(_VAL_) (REG32(ADR_PAD30)) = (((_VAL_) << 3) | ((REG32(ADR_PAD30)) & 0xfffffff7))
#define SET_PAD30_SEL_I(_VAL_) (REG32(ADR_PAD30)) = (((_VAL_) << 4) | ((REG32(ADR_PAD30)) & 0xffffffcf))
#define SET_PAD30_OD(_VAL_) (REG32(ADR_PAD30)) = (((_VAL_) << 8) | ((REG32(ADR_PAD30)) & 0xfffffeff))
#define SET_PAD30_SEL_O(_VAL_) (REG32(ADR_PAD30)) = (((_VAL_) << 12) | ((REG32(ADR_PAD30)) & 0xffffcfff))
#define SET_TEST_6_ID(_VAL_) (REG32(ADR_PAD30)) = (((_VAL_) << 28) | ((REG32(ADR_PAD30)) & 0xefffffff))
#define SET_PAD31_OE(_VAL_) (REG32(ADR_PAD31)) = (((_VAL_) << 0) | ((REG32(ADR_PAD31)) & 0xfffffffe))
#define SET_PAD31_PE(_VAL_) (REG32(ADR_PAD31)) = (((_VAL_) << 1) | ((REG32(ADR_PAD31)) & 0xfffffffd))
#define SET_PAD31_DS(_VAL_) (REG32(ADR_PAD31)) = (((_VAL_) << 2) | ((REG32(ADR_PAD31)) & 0xfffffffb))
#define SET_PAD31_IE(_VAL_) (REG32(ADR_PAD31)) = (((_VAL_) << 3) | ((REG32(ADR_PAD31)) & 0xfffffff7))
#define SET_PAD31_SEL_I(_VAL_) (REG32(ADR_PAD31)) = (((_VAL_) << 4) | ((REG32(ADR_PAD31)) & 0xffffffcf))
#define SET_PAD31_OD(_VAL_) (REG32(ADR_PAD31)) = (((_VAL_) << 8) | ((REG32(ADR_PAD31)) & 0xfffffeff))
#define SET_PAD31_SEL_O(_VAL_) (REG32(ADR_PAD31)) = (((_VAL_) << 12) | ((REG32(ADR_PAD31)) & 0xffffcfff))
#define SET_TEST_7_ID(_VAL_) (REG32(ADR_PAD31)) = (((_VAL_) << 28) | ((REG32(ADR_PAD31)) & 0xefffffff))
#define SET_PAD32_OE(_VAL_) (REG32(ADR_PAD32)) = (((_VAL_) << 0) | ((REG32(ADR_PAD32)) & 0xfffffffe))
#define SET_PAD32_PE(_VAL_) (REG32(ADR_PAD32)) = (((_VAL_) << 1) | ((REG32(ADR_PAD32)) & 0xfffffffd))
#define SET_PAD32_DS(_VAL_) (REG32(ADR_PAD32)) = (((_VAL_) << 2) | ((REG32(ADR_PAD32)) & 0xfffffffb))
#define SET_PAD32_IE(_VAL_) (REG32(ADR_PAD32)) = (((_VAL_) << 3) | ((REG32(ADR_PAD32)) & 0xfffffff7))
#define SET_PAD32_SEL_I(_VAL_) (REG32(ADR_PAD32)) = (((_VAL_) << 4) | ((REG32(ADR_PAD32)) & 0xffffffcf))
#define SET_PAD32_OD(_VAL_) (REG32(ADR_PAD32)) = (((_VAL_) << 8) | ((REG32(ADR_PAD32)) & 0xfffffeff))
#define SET_PAD32_SEL_O(_VAL_) (REG32(ADR_PAD32)) = (((_VAL_) << 12) | ((REG32(ADR_PAD32)) & 0xffffcfff))
#define SET_TEST_8_ID(_VAL_) (REG32(ADR_PAD32)) = (((_VAL_) << 28) | ((REG32(ADR_PAD32)) & 0xefffffff))
#define SET_PAD33_OE(_VAL_) (REG32(ADR_PAD33)) = (((_VAL_) << 0) | ((REG32(ADR_PAD33)) & 0xfffffffe))
#define SET_PAD33_PE(_VAL_) (REG32(ADR_PAD33)) = (((_VAL_) << 1) | ((REG32(ADR_PAD33)) & 0xfffffffd))
#define SET_PAD33_DS(_VAL_) (REG32(ADR_PAD33)) = (((_VAL_) << 2) | ((REG32(ADR_PAD33)) & 0xfffffffb))
#define SET_PAD33_IE(_VAL_) (REG32(ADR_PAD33)) = (((_VAL_) << 3) | ((REG32(ADR_PAD33)) & 0xfffffff7))
#define SET_PAD33_SEL_I(_VAL_) (REG32(ADR_PAD33)) = (((_VAL_) << 4) | ((REG32(ADR_PAD33)) & 0xffffffcf))
#define SET_PAD33_OD(_VAL_) (REG32(ADR_PAD33)) = (((_VAL_) << 8) | ((REG32(ADR_PAD33)) & 0xfffffeff))
#define SET_PAD33_SEL_O(_VAL_) (REG32(ADR_PAD33)) = (((_VAL_) << 12) | ((REG32(ADR_PAD33)) & 0xffffcfff))
#define SET_TEST_9_ID(_VAL_) (REG32(ADR_PAD33)) = (((_VAL_) << 28) | ((REG32(ADR_PAD33)) & 0xefffffff))
#define SET_PAD34_OE(_VAL_) (REG32(ADR_PAD34)) = (((_VAL_) << 0) | ((REG32(ADR_PAD34)) & 0xfffffffe))
#define SET_PAD34_PE(_VAL_) (REG32(ADR_PAD34)) = (((_VAL_) << 1) | ((REG32(ADR_PAD34)) & 0xfffffffd))
#define SET_PAD34_DS(_VAL_) (REG32(ADR_PAD34)) = (((_VAL_) << 2) | ((REG32(ADR_PAD34)) & 0xfffffffb))
#define SET_PAD34_IE(_VAL_) (REG32(ADR_PAD34)) = (((_VAL_) << 3) | ((REG32(ADR_PAD34)) & 0xfffffff7))
#define SET_PAD34_SEL_I(_VAL_) (REG32(ADR_PAD34)) = (((_VAL_) << 4) | ((REG32(ADR_PAD34)) & 0xffffffcf))
#define SET_PAD34_OD(_VAL_) (REG32(ADR_PAD34)) = (((_VAL_) << 8) | ((REG32(ADR_PAD34)) & 0xfffffeff))
#define SET_PAD34_SEL_O(_VAL_) (REG32(ADR_PAD34)) = (((_VAL_) << 12) | ((REG32(ADR_PAD34)) & 0xffffcfff))
#define SET_TEST_10_ID(_VAL_) (REG32(ADR_PAD34)) = (((_VAL_) << 28) | ((REG32(ADR_PAD34)) & 0xefffffff))
#define SET_PAD42_OE(_VAL_) (REG32(ADR_PAD42)) = (((_VAL_) << 0) | ((REG32(ADR_PAD42)) & 0xfffffffe))
#define SET_PAD42_PE(_VAL_) (REG32(ADR_PAD42)) = (((_VAL_) << 1) | ((REG32(ADR_PAD42)) & 0xfffffffd))
#define SET_PAD42_DS(_VAL_) (REG32(ADR_PAD42)) = (((_VAL_) << 2) | ((REG32(ADR_PAD42)) & 0xfffffffb))
#define SET_PAD42_IE(_VAL_) (REG32(ADR_PAD42)) = (((_VAL_) << 3) | ((REG32(ADR_PAD42)) & 0xfffffff7))
#define SET_PAD42_SEL_I(_VAL_) (REG32(ADR_PAD42)) = (((_VAL_) << 4) | ((REG32(ADR_PAD42)) & 0xffffffcf))
#define SET_PAD42_OD(_VAL_) (REG32(ADR_PAD42)) = (((_VAL_) << 8) | ((REG32(ADR_PAD42)) & 0xfffffeff))
#define SET_PAD42_SEL_O(_VAL_) (REG32(ADR_PAD42)) = (((_VAL_) << 12) | ((REG32(ADR_PAD42)) & 0xffffefff))
#define SET_TEST_11_ID(_VAL_) (REG32(ADR_PAD42)) = (((_VAL_) << 28) | ((REG32(ADR_PAD42)) & 0xefffffff))
#define SET_PAD43_OE(_VAL_) (REG32(ADR_PAD43)) = (((_VAL_) << 0) | ((REG32(ADR_PAD43)) & 0xfffffffe))
#define SET_PAD43_PE(_VAL_) (REG32(ADR_PAD43)) = (((_VAL_) << 1) | ((REG32(ADR_PAD43)) & 0xfffffffd))
#define SET_PAD43_DS(_VAL_) (REG32(ADR_PAD43)) = (((_VAL_) << 2) | ((REG32(ADR_PAD43)) & 0xfffffffb))
#define SET_PAD43_IE(_VAL_) (REG32(ADR_PAD43)) = (((_VAL_) << 3) | ((REG32(ADR_PAD43)) & 0xfffffff7))
#define SET_PAD43_SEL_I(_VAL_) (REG32(ADR_PAD43)) = (((_VAL_) << 4) | ((REG32(ADR_PAD43)) & 0xffffffcf))
#define SET_PAD43_OD(_VAL_) (REG32(ADR_PAD43)) = (((_VAL_) << 8) | ((REG32(ADR_PAD43)) & 0xfffffeff))
#define SET_PAD43_SEL_O(_VAL_) (REG32(ADR_PAD43)) = (((_VAL_) << 12) | ((REG32(ADR_PAD43)) & 0xffffefff))
#define SET_TEST_12_ID(_VAL_) (REG32(ADR_PAD43)) = (((_VAL_) << 28) | ((REG32(ADR_PAD43)) & 0xefffffff))
#define SET_PAD44_OE(_VAL_) (REG32(ADR_PAD44)) = (((_VAL_) << 0) | ((REG32(ADR_PAD44)) & 0xfffffffe))
#define SET_PAD44_PE(_VAL_) (REG32(ADR_PAD44)) = (((_VAL_) << 1) | ((REG32(ADR_PAD44)) & 0xfffffffd))
#define SET_PAD44_DS(_VAL_) (REG32(ADR_PAD44)) = (((_VAL_) << 2) | ((REG32(ADR_PAD44)) & 0xfffffffb))
#define SET_PAD44_IE(_VAL_) (REG32(ADR_PAD44)) = (((_VAL_) << 3) | ((REG32(ADR_PAD44)) & 0xfffffff7))
#define SET_PAD44_SEL_I(_VAL_) (REG32(ADR_PAD44)) = (((_VAL_) << 4) | ((REG32(ADR_PAD44)) & 0xffffffcf))
#define SET_PAD44_OD(_VAL_) (REG32(ADR_PAD44)) = (((_VAL_) << 8) | ((REG32(ADR_PAD44)) & 0xfffffeff))
#define SET_PAD44_SEL_O(_VAL_) (REG32(ADR_PAD44)) = (((_VAL_) << 12) | ((REG32(ADR_PAD44)) & 0xffffcfff))
#define SET_TEST_13_ID(_VAL_) (REG32(ADR_PAD44)) = (((_VAL_) << 28) | ((REG32(ADR_PAD44)) & 0xefffffff))
#define SET_PAD45_OE(_VAL_) (REG32(ADR_PAD45)) = (((_VAL_) << 0) | ((REG32(ADR_PAD45)) & 0xfffffffe))
#define SET_PAD45_PE(_VAL_) (REG32(ADR_PAD45)) = (((_VAL_) << 1) | ((REG32(ADR_PAD45)) & 0xfffffffd))
#define SET_PAD45_DS(_VAL_) (REG32(ADR_PAD45)) = (((_VAL_) << 2) | ((REG32(ADR_PAD45)) & 0xfffffffb))
#define SET_PAD45_IE(_VAL_) (REG32(ADR_PAD45)) = (((_VAL_) << 3) | ((REG32(ADR_PAD45)) & 0xfffffff7))
#define SET_PAD45_SEL_I(_VAL_) (REG32(ADR_PAD45)) = (((_VAL_) << 4) | ((REG32(ADR_PAD45)) & 0xffffffcf))
#define SET_PAD45_OD(_VAL_) (REG32(ADR_PAD45)) = (((_VAL_) << 8) | ((REG32(ADR_PAD45)) & 0xfffffeff))
#define SET_PAD45_SEL_O(_VAL_) (REG32(ADR_PAD45)) = (((_VAL_) << 12) | ((REG32(ADR_PAD45)) & 0xffffcfff))
#define SET_TEST_14_ID(_VAL_) (REG32(ADR_PAD45)) = (((_VAL_) << 28) | ((REG32(ADR_PAD45)) & 0xefffffff))
#define SET_PAD46_OE(_VAL_) (REG32(ADR_PAD46)) = (((_VAL_) << 0) | ((REG32(ADR_PAD46)) & 0xfffffffe))
#define SET_PAD46_PE(_VAL_) (REG32(ADR_PAD46)) = (((_VAL_) << 1) | ((REG32(ADR_PAD46)) & 0xfffffffd))
#define SET_PAD46_DS(_VAL_) (REG32(ADR_PAD46)) = (((_VAL_) << 2) | ((REG32(ADR_PAD46)) & 0xfffffffb))
#define SET_PAD46_IE(_VAL_) (REG32(ADR_PAD46)) = (((_VAL_) << 3) | ((REG32(ADR_PAD46)) & 0xfffffff7))
#define SET_PAD46_SEL_I(_VAL_) (REG32(ADR_PAD46)) = (((_VAL_) << 4) | ((REG32(ADR_PAD46)) & 0xffffffcf))
#define SET_PAD46_OD(_VAL_) (REG32(ADR_PAD46)) = (((_VAL_) << 8) | ((REG32(ADR_PAD46)) & 0xfffffeff))
#define SET_PAD46_SEL_O(_VAL_) (REG32(ADR_PAD46)) = (((_VAL_) << 12) | ((REG32(ADR_PAD46)) & 0xffffcfff))
#define SET_TEST_15_ID(_VAL_) (REG32(ADR_PAD46)) = (((_VAL_) << 28) | ((REG32(ADR_PAD46)) & 0xefffffff))
#define SET_PAD47_OE(_VAL_) (REG32(ADR_PAD47)) = (((_VAL_) << 0) | ((REG32(ADR_PAD47)) & 0xfffffffe))
#define SET_PAD47_PE(_VAL_) (REG32(ADR_PAD47)) = (((_VAL_) << 1) | ((REG32(ADR_PAD47)) & 0xfffffffd))
#define SET_PAD47_DS(_VAL_) (REG32(ADR_PAD47)) = (((_VAL_) << 2) | ((REG32(ADR_PAD47)) & 0xfffffffb))
#define SET_PAD47_SEL_I(_VAL_) (REG32(ADR_PAD47)) = (((_VAL_) << 4) | ((REG32(ADR_PAD47)) & 0xffffffcf))
#define SET_PAD47_OD(_VAL_) (REG32(ADR_PAD47)) = (((_VAL_) << 8) | ((REG32(ADR_PAD47)) & 0xfffffeff))
#define SET_PAD47_SEL_O(_VAL_) (REG32(ADR_PAD47)) = (((_VAL_) << 12) | ((REG32(ADR_PAD47)) & 0xffffcfff))
#define SET_PAD47_SEL_OE(_VAL_) (REG32(ADR_PAD47)) = (((_VAL_) << 20) | ((REG32(ADR_PAD47)) & 0xffefffff))
#define SET_GPIO_9_ID(_VAL_) (REG32(ADR_PAD47)) = (((_VAL_) << 28) | ((REG32(ADR_PAD47)) & 0xefffffff))
#define SET_PAD48_OE(_VAL_) (REG32(ADR_PAD48)) = (((_VAL_) << 0) | ((REG32(ADR_PAD48)) & 0xfffffffe))
#define SET_PAD48_PE(_VAL_) (REG32(ADR_PAD48)) = (((_VAL_) << 1) | ((REG32(ADR_PAD48)) & 0xfffffffd))
#define SET_PAD48_DS(_VAL_) (REG32(ADR_PAD48)) = (((_VAL_) << 2) | ((REG32(ADR_PAD48)) & 0xfffffffb))
#define SET_PAD48_IE(_VAL_) (REG32(ADR_PAD48)) = (((_VAL_) << 3) | ((REG32(ADR_PAD48)) & 0xfffffff7))
#define SET_PAD48_SEL_I(_VAL_) (REG32(ADR_PAD48)) = (((_VAL_) << 4) | ((REG32(ADR_PAD48)) & 0xffffff8f))
#define SET_PAD48_OD(_VAL_) (REG32(ADR_PAD48)) = (((_VAL_) << 8) | ((REG32(ADR_PAD48)) & 0xfffffeff))
#define SET_PAD48_PE_SEL(_VAL_) (REG32(ADR_PAD48)) = (((_VAL_) << 11) | ((REG32(ADR_PAD48)) & 0xfffff7ff))
#define SET_PAD48_SEL_O(_VAL_) (REG32(ADR_PAD48)) = (((_VAL_) << 12) | ((REG32(ADR_PAD48)) & 0xffffcfff))
#define SET_PAD48_SEL_OE(_VAL_) (REG32(ADR_PAD48)) = (((_VAL_) << 20) | ((REG32(ADR_PAD48)) & 0xffefffff))
#define SET_GPIO_10_ID(_VAL_) (REG32(ADR_PAD48)) = (((_VAL_) << 28) | ((REG32(ADR_PAD48)) & 0xefffffff))
#define SET_PAD49_OE(_VAL_) (REG32(ADR_PAD49)) = (((_VAL_) << 0) | ((REG32(ADR_PAD49)) & 0xfffffffe))
#define SET_PAD49_PE(_VAL_) (REG32(ADR_PAD49)) = (((_VAL_) << 1) | ((REG32(ADR_PAD49)) & 0xfffffffd))
#define SET_PAD49_DS(_VAL_) (REG32(ADR_PAD49)) = (((_VAL_) << 2) | ((REG32(ADR_PAD49)) & 0xfffffffb))
#define SET_PAD49_IE(_VAL_) (REG32(ADR_PAD49)) = (((_VAL_) << 3) | ((REG32(ADR_PAD49)) & 0xfffffff7))
#define SET_PAD49_SEL_I(_VAL_) (REG32(ADR_PAD49)) = (((_VAL_) << 4) | ((REG32(ADR_PAD49)) & 0xffffff8f))
#define SET_PAD49_OD(_VAL_) (REG32(ADR_PAD49)) = (((_VAL_) << 8) | ((REG32(ADR_PAD49)) & 0xfffffeff))
#define SET_PAD49_SEL_O(_VAL_) (REG32(ADR_PAD49)) = (((_VAL_) << 12) | ((REG32(ADR_PAD49)) & 0xffffcfff))
#define SET_PAD49_SEL_OE(_VAL_) (REG32(ADR_PAD49)) = (((_VAL_) << 20) | ((REG32(ADR_PAD49)) & 0xffefffff))
#define SET_GPIO_11_ID(_VAL_) (REG32(ADR_PAD49)) = (((_VAL_) << 28) | ((REG32(ADR_PAD49)) & 0xefffffff))
#define SET_PAD50_OE(_VAL_) (REG32(ADR_PAD50)) = (((_VAL_) << 0) | ((REG32(ADR_PAD50)) & 0xfffffffe))
#define SET_PAD50_PE(_VAL_) (REG32(ADR_PAD50)) = (((_VAL_) << 1) | ((REG32(ADR_PAD50)) & 0xfffffffd))
#define SET_PAD50_DS(_VAL_) (REG32(ADR_PAD50)) = (((_VAL_) << 2) | ((REG32(ADR_PAD50)) & 0xfffffffb))
#define SET_PAD50_IE(_VAL_) (REG32(ADR_PAD50)) = (((_VAL_) << 3) | ((REG32(ADR_PAD50)) & 0xfffffff7))
#define SET_PAD50_SEL_I(_VAL_) (REG32(ADR_PAD50)) = (((_VAL_) << 4) | ((REG32(ADR_PAD50)) & 0xffffff8f))
#define SET_PAD50_OD(_VAL_) (REG32(ADR_PAD50)) = (((_VAL_) << 8) | ((REG32(ADR_PAD50)) & 0xfffffeff))
#define SET_PAD50_SEL_O(_VAL_) (REG32(ADR_PAD50)) = (((_VAL_) << 12) | ((REG32(ADR_PAD50)) & 0xffffcfff))
#define SET_PAD50_SEL_OE(_VAL_) (REG32(ADR_PAD50)) = (((_VAL_) << 20) | ((REG32(ADR_PAD50)) & 0xffefffff))
#define SET_GPIO_12_ID(_VAL_) (REG32(ADR_PAD50)) = (((_VAL_) << 28) | ((REG32(ADR_PAD50)) & 0xefffffff))
#define SET_PAD51_OE(_VAL_) (REG32(ADR_PAD51)) = (((_VAL_) << 0) | ((REG32(ADR_PAD51)) & 0xfffffffe))
#define SET_PAD51_PE(_VAL_) (REG32(ADR_PAD51)) = (((_VAL_) << 1) | ((REG32(ADR_PAD51)) & 0xfffffffd))
#define SET_PAD51_DS(_VAL_) (REG32(ADR_PAD51)) = (((_VAL_) << 2) | ((REG32(ADR_PAD51)) & 0xfffffffb))
#define SET_PAD51_IE(_VAL_) (REG32(ADR_PAD51)) = (((_VAL_) << 3) | ((REG32(ADR_PAD51)) & 0xfffffff7))
#define SET_PAD51_SEL_I(_VAL_) (REG32(ADR_PAD51)) = (((_VAL_) << 4) | ((REG32(ADR_PAD51)) & 0xffffffcf))
#define SET_PAD51_OD(_VAL_) (REG32(ADR_PAD51)) = (((_VAL_) << 8) | ((REG32(ADR_PAD51)) & 0xfffffeff))
#define SET_PAD51_SEL_O(_VAL_) (REG32(ADR_PAD51)) = (((_VAL_) << 12) | ((REG32(ADR_PAD51)) & 0xffffefff))
#define SET_PAD51_SEL_OE(_VAL_) (REG32(ADR_PAD51)) = (((_VAL_) << 20) | ((REG32(ADR_PAD51)) & 0xffefffff))
#define SET_GPIO_13_ID(_VAL_) (REG32(ADR_PAD51)) = (((_VAL_) << 28) | ((REG32(ADR_PAD51)) & 0xefffffff))
#define SET_PAD52_OE(_VAL_) (REG32(ADR_PAD52)) = (((_VAL_) << 0) | ((REG32(ADR_PAD52)) & 0xfffffffe))
#define SET_PAD52_PE(_VAL_) (REG32(ADR_PAD52)) = (((_VAL_) << 1) | ((REG32(ADR_PAD52)) & 0xfffffffd))
#define SET_PAD52_DS(_VAL_) (REG32(ADR_PAD52)) = (((_VAL_) << 2) | ((REG32(ADR_PAD52)) & 0xfffffffb))
#define SET_PAD52_SEL_I(_VAL_) (REG32(ADR_PAD52)) = (((_VAL_) << 4) | ((REG32(ADR_PAD52)) & 0xffffffcf))
#define SET_PAD52_OD(_VAL_) (REG32(ADR_PAD52)) = (((_VAL_) << 8) | ((REG32(ADR_PAD52)) & 0xfffffeff))
#define SET_PAD52_SEL_O(_VAL_) (REG32(ADR_PAD52)) = (((_VAL_) << 12) | ((REG32(ADR_PAD52)) & 0xffffefff))
#define SET_PAD52_SEL_OE(_VAL_) (REG32(ADR_PAD52)) = (((_VAL_) << 20) | ((REG32(ADR_PAD52)) & 0xffefffff))
#define SET_GPIO_14_ID(_VAL_) (REG32(ADR_PAD52)) = (((_VAL_) << 28) | ((REG32(ADR_PAD52)) & 0xefffffff))
#define SET_PAD53_OE(_VAL_) (REG32(ADR_PAD53)) = (((_VAL_) << 0) | ((REG32(ADR_PAD53)) & 0xfffffffe))
#define SET_PAD53_PE(_VAL_) (REG32(ADR_PAD53)) = (((_VAL_) << 1) | ((REG32(ADR_PAD53)) & 0xfffffffd))
#define SET_PAD53_DS(_VAL_) (REG32(ADR_PAD53)) = (((_VAL_) << 2) | ((REG32(ADR_PAD53)) & 0xfffffffb))
#define SET_PAD53_IE(_VAL_) (REG32(ADR_PAD53)) = (((_VAL_) << 3) | ((REG32(ADR_PAD53)) & 0xfffffff7))
#define SET_PAD53_SEL_I(_VAL_) (REG32(ADR_PAD53)) = (((_VAL_) << 4) | ((REG32(ADR_PAD53)) & 0xffffffcf))
#define SET_PAD53_OD(_VAL_) (REG32(ADR_PAD53)) = (((_VAL_) << 8) | ((REG32(ADR_PAD53)) & 0xfffffeff))
#define SET_PAD53_SEL_O(_VAL_) (REG32(ADR_PAD53)) = (((_VAL_) << 12) | ((REG32(ADR_PAD53)) & 0xffffefff))
#define SET_JTAG_TMS_ID(_VAL_) (REG32(ADR_PAD53)) = (((_VAL_) << 28) | ((REG32(ADR_PAD53)) & 0xefffffff))
#define SET_PAD54_OE(_VAL_) (REG32(ADR_PAD54)) = (((_VAL_) << 0) | ((REG32(ADR_PAD54)) & 0xfffffffe))
#define SET_PAD54_PE(_VAL_) (REG32(ADR_PAD54)) = (((_VAL_) << 1) | ((REG32(ADR_PAD54)) & 0xfffffffd))
#define SET_PAD54_DS(_VAL_) (REG32(ADR_PAD54)) = (((_VAL_) << 2) | ((REG32(ADR_PAD54)) & 0xfffffffb))
#define SET_PAD54_OD(_VAL_) (REG32(ADR_PAD54)) = (((_VAL_) << 8) | ((REG32(ADR_PAD54)) & 0xfffffeff))
#define SET_PAD54_SEL_O(_VAL_) (REG32(ADR_PAD54)) = (((_VAL_) << 12) | ((REG32(ADR_PAD54)) & 0xffffcfff))
#define SET_JTAG_TCK_ID(_VAL_) (REG32(ADR_PAD54)) = (((_VAL_) << 28) | ((REG32(ADR_PAD54)) & 0xefffffff))
#define SET_PAD56_PE(_VAL_) (REG32(ADR_PAD56)) = (((_VAL_) << 1) | ((REG32(ADR_PAD56)) & 0xfffffffd))
#define SET_PAD56_DS(_VAL_) (REG32(ADR_PAD56)) = (((_VAL_) << 2) | ((REG32(ADR_PAD56)) & 0xfffffffb))
#define SET_PAD56_SEL_I(_VAL_) (REG32(ADR_PAD56)) = (((_VAL_) << 4) | ((REG32(ADR_PAD56)) & 0xffffffef))
#define SET_PAD56_OD(_VAL_) (REG32(ADR_PAD56)) = (((_VAL_) << 8) | ((REG32(ADR_PAD56)) & 0xfffffeff))
#define SET_JTAG_TDI_ID(_VAL_) (REG32(ADR_PAD56)) = (((_VAL_) << 28) | ((REG32(ADR_PAD56)) & 0xefffffff))
#define SET_PAD57_OE(_VAL_) (REG32(ADR_PAD57)) = (((_VAL_) << 0) | ((REG32(ADR_PAD57)) & 0xfffffffe))
#define SET_PAD57_PE(_VAL_) (REG32(ADR_PAD57)) = (((_VAL_) << 1) | ((REG32(ADR_PAD57)) & 0xfffffffd))
#define SET_PAD57_DS(_VAL_) (REG32(ADR_PAD57)) = (((_VAL_) << 2) | ((REG32(ADR_PAD57)) & 0xfffffffb))
#define SET_PAD57_IE(_VAL_) (REG32(ADR_PAD57)) = (((_VAL_) << 3) | ((REG32(ADR_PAD57)) & 0xfffffff7))
#define SET_PAD57_SEL_I(_VAL_) (REG32(ADR_PAD57)) = (((_VAL_) << 4) | ((REG32(ADR_PAD57)) & 0xffffffcf))
#define SET_PAD57_OD(_VAL_) (REG32(ADR_PAD57)) = (((_VAL_) << 8) | ((REG32(ADR_PAD57)) & 0xfffffeff))
#define SET_PAD57_SEL_O(_VAL_) (REG32(ADR_PAD57)) = (((_VAL_) << 12) | ((REG32(ADR_PAD57)) & 0xffffcfff))
#define SET_PAD57_SEL_OE(_VAL_) (REG32(ADR_PAD57)) = (((_VAL_) << 20) | ((REG32(ADR_PAD57)) & 0xffefffff))
#define SET_JTAG_TDO_ID(_VAL_) (REG32(ADR_PAD57)) = (((_VAL_) << 28) | ((REG32(ADR_PAD57)) & 0xefffffff))
#define SET_PAD58_OE(_VAL_) (REG32(ADR_PAD58)) = (((_VAL_) << 0) | ((REG32(ADR_PAD58)) & 0xfffffffe))
#define SET_PAD58_PE(_VAL_) (REG32(ADR_PAD58)) = (((_VAL_) << 1) | ((REG32(ADR_PAD58)) & 0xfffffffd))
#define SET_PAD58_DS(_VAL_) (REG32(ADR_PAD58)) = (((_VAL_) << 2) | ((REG32(ADR_PAD58)) & 0xfffffffb))
#define SET_PAD58_IE(_VAL_) (REG32(ADR_PAD58)) = (((_VAL_) << 3) | ((REG32(ADR_PAD58)) & 0xfffffff7))
#define SET_PAD58_SEL_I(_VAL_) (REG32(ADR_PAD58)) = (((_VAL_) << 4) | ((REG32(ADR_PAD58)) & 0xffffffcf))
#define SET_PAD58_OD(_VAL_) (REG32(ADR_PAD58)) = (((_VAL_) << 8) | ((REG32(ADR_PAD58)) & 0xfffffeff))
#define SET_PAD58_SEL_O(_VAL_) (REG32(ADR_PAD58)) = (((_VAL_) << 12) | ((REG32(ADR_PAD58)) & 0xffffefff))
#define SET_TEST_16_ID(_VAL_) (REG32(ADR_PAD58)) = (((_VAL_) << 28) | ((REG32(ADR_PAD58)) & 0xefffffff))
#define SET_PAD59_OE(_VAL_) (REG32(ADR_PAD59)) = (((_VAL_) << 0) | ((REG32(ADR_PAD59)) & 0xfffffffe))
#define SET_PAD59_PE(_VAL_) (REG32(ADR_PAD59)) = (((_VAL_) << 1) | ((REG32(ADR_PAD59)) & 0xfffffffd))
#define SET_PAD59_DS(_VAL_) (REG32(ADR_PAD59)) = (((_VAL_) << 2) | ((REG32(ADR_PAD59)) & 0xfffffffb))
#define SET_PAD59_IE(_VAL_) (REG32(ADR_PAD59)) = (((_VAL_) << 3) | ((REG32(ADR_PAD59)) & 0xfffffff7))
#define SET_PAD59_SEL_I(_VAL_) (REG32(ADR_PAD59)) = (((_VAL_) << 4) | ((REG32(ADR_PAD59)) & 0xffffffcf))
#define SET_PAD59_OD(_VAL_) (REG32(ADR_PAD59)) = (((_VAL_) << 8) | ((REG32(ADR_PAD59)) & 0xfffffeff))
#define SET_PAD59_SEL_O(_VAL_) (REG32(ADR_PAD59)) = (((_VAL_) << 12) | ((REG32(ADR_PAD59)) & 0xffffefff))
#define SET_TEST_17_ID(_VAL_) (REG32(ADR_PAD59)) = (((_VAL_) << 28) | ((REG32(ADR_PAD59)) & 0xefffffff))
#define SET_PAD60_OE(_VAL_) (REG32(ADR_PAD60)) = (((_VAL_) << 0) | ((REG32(ADR_PAD60)) & 0xfffffffe))
#define SET_PAD60_PE(_VAL_) (REG32(ADR_PAD60)) = (((_VAL_) << 1) | ((REG32(ADR_PAD60)) & 0xfffffffd))
#define SET_PAD60_DS(_VAL_) (REG32(ADR_PAD60)) = (((_VAL_) << 2) | ((REG32(ADR_PAD60)) & 0xfffffffb))
#define SET_PAD60_IE(_VAL_) (REG32(ADR_PAD60)) = (((_VAL_) << 3) | ((REG32(ADR_PAD60)) & 0xfffffff7))
#define SET_PAD60_SEL_I(_VAL_) (REG32(ADR_PAD60)) = (((_VAL_) << 4) | ((REG32(ADR_PAD60)) & 0xffffffcf))
#define SET_PAD60_OD(_VAL_) (REG32(ADR_PAD60)) = (((_VAL_) << 8) | ((REG32(ADR_PAD60)) & 0xfffffeff))
#define SET_PAD60_SEL_O(_VAL_) (REG32(ADR_PAD60)) = (((_VAL_) << 12) | ((REG32(ADR_PAD60)) & 0xffffefff))
#define SET_TEST_18_ID(_VAL_) (REG32(ADR_PAD60)) = (((_VAL_) << 28) | ((REG32(ADR_PAD60)) & 0xefffffff))
#define SET_PAD61_OE(_VAL_) (REG32(ADR_PAD61)) = (((_VAL_) << 0) | ((REG32(ADR_PAD61)) & 0xfffffffe))
#define SET_PAD61_PE(_VAL_) (REG32(ADR_PAD61)) = (((_VAL_) << 1) | ((REG32(ADR_PAD61)) & 0xfffffffd))
#define SET_PAD61_DS(_VAL_) (REG32(ADR_PAD61)) = (((_VAL_) << 2) | ((REG32(ADR_PAD61)) & 0xfffffffb))
#define SET_PAD61_IE(_VAL_) (REG32(ADR_PAD61)) = (((_VAL_) << 3) | ((REG32(ADR_PAD61)) & 0xfffffff7))
#define SET_PAD61_SEL_I(_VAL_) (REG32(ADR_PAD61)) = (((_VAL_) << 4) | ((REG32(ADR_PAD61)) & 0xffffffef))
#define SET_PAD61_OD(_VAL_) (REG32(ADR_PAD61)) = (((_VAL_) << 8) | ((REG32(ADR_PAD61)) & 0xfffffeff))
#define SET_PAD61_SEL_O(_VAL_) (REG32(ADR_PAD61)) = (((_VAL_) << 12) | ((REG32(ADR_PAD61)) & 0xffffcfff))
#define SET_TEST_19_ID(_VAL_) (REG32(ADR_PAD61)) = (((_VAL_) << 28) | ((REG32(ADR_PAD61)) & 0xefffffff))
#define SET_PAD62_OE(_VAL_) (REG32(ADR_PAD62)) = (((_VAL_) << 0) | ((REG32(ADR_PAD62)) & 0xfffffffe))
#define SET_PAD62_PE(_VAL_) (REG32(ADR_PAD62)) = (((_VAL_) << 1) | ((REG32(ADR_PAD62)) & 0xfffffffd))
#define SET_PAD62_DS(_VAL_) (REG32(ADR_PAD62)) = (((_VAL_) << 2) | ((REG32(ADR_PAD62)) & 0xfffffffb))
#define SET_PAD62_IE(_VAL_) (REG32(ADR_PAD62)) = (((_VAL_) << 3) | ((REG32(ADR_PAD62)) & 0xfffffff7))
#define SET_PAD62_SEL_I(_VAL_) (REG32(ADR_PAD62)) = (((_VAL_) << 4) | ((REG32(ADR_PAD62)) & 0xffffffef))
#define SET_PAD62_OD(_VAL_) (REG32(ADR_PAD62)) = (((_VAL_) << 8) | ((REG32(ADR_PAD62)) & 0xfffffeff))
#define SET_PAD62_SEL_O(_VAL_) (REG32(ADR_PAD62)) = (((_VAL_) << 12) | ((REG32(ADR_PAD62)) & 0xffffefff))
#define SET_TEST_20_ID(_VAL_) (REG32(ADR_PAD62)) = (((_VAL_) << 28) | ((REG32(ADR_PAD62)) & 0xefffffff))
#define SET_PAD64_OE(_VAL_) (REG32(ADR_PAD64)) = (((_VAL_) << 0) | ((REG32(ADR_PAD64)) & 0xfffffffe))
#define SET_PAD64_PE(_VAL_) (REG32(ADR_PAD64)) = (((_VAL_) << 1) | ((REG32(ADR_PAD64)) & 0xfffffffd))
#define SET_PAD64_DS(_VAL_) (REG32(ADR_PAD64)) = (((_VAL_) << 2) | ((REG32(ADR_PAD64)) & 0xfffffffb))
#define SET_PAD64_IE(_VAL_) (REG32(ADR_PAD64)) = (((_VAL_) << 3) | ((REG32(ADR_PAD64)) & 0xfffffff7))
#define SET_PAD64_SEL_I(_VAL_) (REG32(ADR_PAD64)) = (((_VAL_) << 4) | ((REG32(ADR_PAD64)) & 0xffffff8f))
#define SET_PAD64_OD(_VAL_) (REG32(ADR_PAD64)) = (((_VAL_) << 8) | ((REG32(ADR_PAD64)) & 0xfffffeff))
#define SET_PAD64_SEL_O(_VAL_) (REG32(ADR_PAD64)) = (((_VAL_) << 12) | ((REG32(ADR_PAD64)) & 0xffffcfff))
#define SET_PAD64_SEL_OE(_VAL_) (REG32(ADR_PAD64)) = (((_VAL_) << 20) | ((REG32(ADR_PAD64)) & 0xffefffff))
#define SET_GPIO_15_IP_ID(_VAL_) (REG32(ADR_PAD64)) = (((_VAL_) << 28) | ((REG32(ADR_PAD64)) & 0xefffffff))
#define SET_PAD65_OE(_VAL_) (REG32(ADR_PAD65)) = (((_VAL_) << 0) | ((REG32(ADR_PAD65)) & 0xfffffffe))
#define SET_PAD65_PE(_VAL_) (REG32(ADR_PAD65)) = (((_VAL_) << 1) | ((REG32(ADR_PAD65)) & 0xfffffffd))
#define SET_PAD65_DS(_VAL_) (REG32(ADR_PAD65)) = (((_VAL_) << 2) | ((REG32(ADR_PAD65)) & 0xfffffffb))
#define SET_PAD65_IE(_VAL_) (REG32(ADR_PAD65)) = (((_VAL_) << 3) | ((REG32(ADR_PAD65)) & 0xfffffff7))
#define SET_PAD65_SEL_I(_VAL_) (REG32(ADR_PAD65)) = (((_VAL_) << 4) | ((REG32(ADR_PAD65)) & 0xffffff8f))
#define SET_PAD65_OD(_VAL_) (REG32(ADR_PAD65)) = (((_VAL_) << 8) | ((REG32(ADR_PAD65)) & 0xfffffeff))
#define SET_PAD65_SEL_O(_VAL_) (REG32(ADR_PAD65)) = (((_VAL_) << 12) | ((REG32(ADR_PAD65)) & 0xffffefff))
#define SET_GPIO_TEST_7_IN_ID(_VAL_) (REG32(ADR_PAD65)) = (((_VAL_) << 28) | ((REG32(ADR_PAD65)) & 0xefffffff))
#define SET_PAD66_OE(_VAL_) (REG32(ADR_PAD66)) = (((_VAL_) << 0) | ((REG32(ADR_PAD66)) & 0xfffffffe))
#define SET_PAD66_PE(_VAL_) (REG32(ADR_PAD66)) = (((_VAL_) << 1) | ((REG32(ADR_PAD66)) & 0xfffffffd))
#define SET_PAD66_DS(_VAL_) (REG32(ADR_PAD66)) = (((_VAL_) << 2) | ((REG32(ADR_PAD66)) & 0xfffffffb))
#define SET_PAD66_IE(_VAL_) (REG32(ADR_PAD66)) = (((_VAL_) << 3) | ((REG32(ADR_PAD66)) & 0xfffffff7))
#define SET_PAD66_SEL_I(_VAL_) (REG32(ADR_PAD66)) = (((_VAL_) << 4) | ((REG32(ADR_PAD66)) & 0xffffffcf))
#define SET_PAD66_OD(_VAL_) (REG32(ADR_PAD66)) = (((_VAL_) << 8) | ((REG32(ADR_PAD66)) & 0xfffffeff))
#define SET_PAD66_SEL_O(_VAL_) (REG32(ADR_PAD66)) = (((_VAL_) << 12) | ((REG32(ADR_PAD66)) & 0xffffcfff))
#define SET_GPIO_17_QP_ID(_VAL_) (REG32(ADR_PAD66)) = (((_VAL_) << 28) | ((REG32(ADR_PAD66)) & 0xefffffff))
#define SET_PAD68_OE(_VAL_) (REG32(ADR_PAD68)) = (((_VAL_) << 0) | ((REG32(ADR_PAD68)) & 0xfffffffe))
#define SET_PAD68_PE(_VAL_) (REG32(ADR_PAD68)) = (((_VAL_) << 1) | ((REG32(ADR_PAD68)) & 0xfffffffd))
#define SET_PAD68_DS(_VAL_) (REG32(ADR_PAD68)) = (((_VAL_) << 2) | ((REG32(ADR_PAD68)) & 0xfffffffb))
#define SET_PAD68_IE(_VAL_) (REG32(ADR_PAD68)) = (((_VAL_) << 3) | ((REG32(ADR_PAD68)) & 0xfffffff7))
#define SET_PAD68_OD(_VAL_) (REG32(ADR_PAD68)) = (((_VAL_) << 8) | ((REG32(ADR_PAD68)) & 0xfffffeff))
#define SET_PAD68_SEL_O(_VAL_) (REG32(ADR_PAD68)) = (((_VAL_) << 12) | ((REG32(ADR_PAD68)) & 0xffffefff))
#define SET_GPIO_19_ID(_VAL_) (REG32(ADR_PAD68)) = (((_VAL_) << 28) | ((REG32(ADR_PAD68)) & 0xefffffff))
#define SET_PAD67_OE(_VAL_) (REG32(ADR_PAD67)) = (((_VAL_) << 0) | ((REG32(ADR_PAD67)) & 0xfffffffe))
#define SET_PAD67_PE(_VAL_) (REG32(ADR_PAD67)) = (((_VAL_) << 1) | ((REG32(ADR_PAD67)) & 0xfffffffd))
#define SET_PAD67_DS(_VAL_) (REG32(ADR_PAD67)) = (((_VAL_) << 2) | ((REG32(ADR_PAD67)) & 0xfffffffb))
#define SET_PAD67_IE(_VAL_) (REG32(ADR_PAD67)) = (((_VAL_) << 3) | ((REG32(ADR_PAD67)) & 0xfffffff7))
#define SET_PAD67_SEL_I(_VAL_) (REG32(ADR_PAD67)) = (((_VAL_) << 4) | ((REG32(ADR_PAD67)) & 0xffffff8f))
#define SET_PAD67_OD(_VAL_) (REG32(ADR_PAD67)) = (((_VAL_) << 8) | ((REG32(ADR_PAD67)) & 0xfffffeff))
#define SET_PAD67_SEL_O(_VAL_) (REG32(ADR_PAD67)) = (((_VAL_) << 12) | ((REG32(ADR_PAD67)) & 0xffffcfff))
#define SET_GPIO_TEST_8_QN_ID(_VAL_) (REG32(ADR_PAD67)) = (((_VAL_) << 28) | ((REG32(ADR_PAD67)) & 0xefffffff))
#define SET_PAD69_OE(_VAL_) (REG32(ADR_PAD69)) = (((_VAL_) << 0) | ((REG32(ADR_PAD69)) & 0xfffffffe))
#define SET_PAD69_PE(_VAL_) (REG32(ADR_PAD69)) = (((_VAL_) << 1) | ((REG32(ADR_PAD69)) & 0xfffffffd))
#define SET_PAD69_DS(_VAL_) (REG32(ADR_PAD69)) = (((_VAL_) << 2) | ((REG32(ADR_PAD69)) & 0xfffffffb))
#define SET_PAD69_IE(_VAL_) (REG32(ADR_PAD69)) = (((_VAL_) << 3) | ((REG32(ADR_PAD69)) & 0xfffffff7))
#define SET_PAD69_SEL_I(_VAL_) (REG32(ADR_PAD69)) = (((_VAL_) << 4) | ((REG32(ADR_PAD69)) & 0xffffffcf))
#define SET_PAD69_OD(_VAL_) (REG32(ADR_PAD69)) = (((_VAL_) << 8) | ((REG32(ADR_PAD69)) & 0xfffffeff))
#define SET_PAD69_SEL_O(_VAL_) (REG32(ADR_PAD69)) = (((_VAL_) << 12) | ((REG32(ADR_PAD69)) & 0xffffefff))
#define SET_STRAP2(_VAL_) (REG32(ADR_PAD69)) = (((_VAL_) << 27) | ((REG32(ADR_PAD69)) & 0xf7ffffff))
#define SET_GPIO_20_ID(_VAL_) (REG32(ADR_PAD69)) = (((_VAL_) << 28) | ((REG32(ADR_PAD69)) & 0xefffffff))
#define SET_PAD70_OE(_VAL_) (REG32(ADR_PAD70)) = (((_VAL_) << 0) | ((REG32(ADR_PAD70)) & 0xfffffffe))
#define SET_PAD70_PE(_VAL_) (REG32(ADR_PAD70)) = (((_VAL_) << 1) | ((REG32(ADR_PAD70)) & 0xfffffffd))
#define SET_PAD70_DS(_VAL_) (REG32(ADR_PAD70)) = (((_VAL_) << 2) | ((REG32(ADR_PAD70)) & 0xfffffffb))
#define SET_PAD70_IE(_VAL_) (REG32(ADR_PAD70)) = (((_VAL_) << 3) | ((REG32(ADR_PAD70)) & 0xfffffff7))
#define SET_PAD70_SEL_I(_VAL_) (REG32(ADR_PAD70)) = (((_VAL_) << 4) | ((REG32(ADR_PAD70)) & 0xffffffcf))
#define SET_PAD70_OD(_VAL_) (REG32(ADR_PAD70)) = (((_VAL_) << 8) | ((REG32(ADR_PAD70)) & 0xfffffeff))
#define SET_PAD70_SEL_O(_VAL_) (REG32(ADR_PAD70)) = (((_VAL_) << 12) | ((REG32(ADR_PAD70)) & 0xffff8fff))
#define SET_GPIO_21_ID(_VAL_) (REG32(ADR_PAD70)) = (((_VAL_) << 28) | ((REG32(ADR_PAD70)) & 0xefffffff))
#define SET_PAD231_OE(_VAL_) (REG32(ADR_PAD231)) = (((_VAL_) << 0) | ((REG32(ADR_PAD231)) & 0xfffffffe))
#define SET_PAD231_PE(_VAL_) (REG32(ADR_PAD231)) = (((_VAL_) << 1) | ((REG32(ADR_PAD231)) & 0xfffffffd))
#define SET_PAD231_DS(_VAL_) (REG32(ADR_PAD231)) = (((_VAL_) << 2) | ((REG32(ADR_PAD231)) & 0xfffffffb))
#define SET_PAD231_IE(_VAL_) (REG32(ADR_PAD231)) = (((_VAL_) << 3) | ((REG32(ADR_PAD231)) & 0xfffffff7))
#define SET_PAD231_OD(_VAL_) (REG32(ADR_PAD231)) = (((_VAL_) << 8) | ((REG32(ADR_PAD231)) & 0xfffffeff))
#define SET_PIN_40_OR_56_ID(_VAL_) (REG32(ADR_PAD231)) = (((_VAL_) << 28) | ((REG32(ADR_PAD231)) & 0xefffffff))
#define SET_MP_PHY2RX_DATA__0_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 0) | ((REG32(ADR_PIN_SEL_0)) & 0xfffffffe))
#define SET_MP_PHY2RX_DATA__1_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 1) | ((REG32(ADR_PIN_SEL_0)) & 0xfffffffd))
#define SET_MP_TX_FF_RPTR__1_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 2) | ((REG32(ADR_PIN_SEL_0)) & 0xfffffffb))
#define SET_MP_RX_FF_WPTR__2_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 3) | ((REG32(ADR_PIN_SEL_0)) & 0xfffffff7))
#define SET_MP_RX_FF_WPTR__1_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 4) | ((REG32(ADR_PIN_SEL_0)) & 0xffffffef))
#define SET_MP_RX_FF_WPTR__0_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 5) | ((REG32(ADR_PIN_SEL_0)) & 0xffffffdf))
#define SET_MP_PHY2RX_DATA__2_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 6) | ((REG32(ADR_PIN_SEL_0)) & 0xffffffbf))
#define SET_MP_PHY2RX_DATA__4_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 7) | ((REG32(ADR_PIN_SEL_0)) & 0xffffff7f))
#define SET_I2CM_SDA_ID_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 8) | ((REG32(ADR_PIN_SEL_0)) & 0xfffffcff))
#define SET_CRYSTAL_OUT_REQ_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 10) | ((REG32(ADR_PIN_SEL_0)) & 0xfffffbff))
#define SET_MP_PHY2RX_DATA__5_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 11) | ((REG32(ADR_PIN_SEL_0)) & 0xfffff7ff))
#define SET_MP_PHY2RX_DATA__3_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 12) | ((REG32(ADR_PIN_SEL_0)) & 0xffffefff))
#define SET_UART_RXD_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 13) | ((REG32(ADR_PIN_SEL_0)) & 0xffff9fff))
#define SET_MP_PHY2RX_DATA__6_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 15) | ((REG32(ADR_PIN_SEL_0)) & 0xffff7fff))
#define SET_DAT_UART_NCTS_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 16) | ((REG32(ADR_PIN_SEL_0)) & 0xfffeffff))
#define SET_GPIO_LOG_STOP_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 17) | ((REG32(ADR_PIN_SEL_0)) & 0xfff1ffff))
#define SET_MP_TX_FF_RPTR__0_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 20) | ((REG32(ADR_PIN_SEL_0)) & 0xffefffff))
#define SET_MP_PHY_RX_WRST_N_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 21) | ((REG32(ADR_PIN_SEL_0)) & 0xffdfffff))
#define SET_EXT_32K_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 22) | ((REG32(ADR_PIN_SEL_0)) & 0xff3fffff))
#define SET_MP_PHY2RX_DATA__7_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 24) | ((REG32(ADR_PIN_SEL_0)) & 0xfeffffff))
#define SET_MP_TX_FF_RPTR__2_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 25) | ((REG32(ADR_PIN_SEL_0)) & 0xfdffffff))
#define SET_PMUINT_WAKE_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 26) | ((REG32(ADR_PIN_SEL_0)) & 0xe3ffffff))
#define SET_I2CM_SCL_ID_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 29) | ((REG32(ADR_PIN_SEL_0)) & 0xdfffffff))
#define SET_MP_MRX_RX_EN_SEL(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 30) | ((REG32(ADR_PIN_SEL_0)) & 0xbfffffff))
#define SET_DAT_UART_RXD_SEL_0(_VAL_) (REG32(ADR_PIN_SEL_0)) = (((_VAL_) << 31) | ((REG32(ADR_PIN_SEL_0)) & 0x7fffffff))
#define SET_DAT_UART_RXD_SEL_1(_VAL_) (REG32(ADR_PIN_SEL_1)) = (((_VAL_) << 0) | ((REG32(ADR_PIN_SEL_1)) & 0xfffffffe))
#define SET_SPI_DI_SEL(_VAL_) (REG32(ADR_PIN_SEL_1)) = (((_VAL_) << 1) | ((REG32(ADR_PIN_SEL_1)) & 0xfffffffd))
#define SET_IO_PORT_REG(_VAL_) (REG32(ADR_IO_PORT_REG)) = (((_VAL_) << 0) | ((REG32(ADR_IO_PORT_REG)) & 0xfffe0000))
#define SET_MASK_RX_INT(_VAL_) (REG32(ADR_INT_MASK_REG)) = (((_VAL_) << 0) | ((REG32(ADR_INT_MASK_REG)) & 0xfffffffe))
#define SET_MASK_TX_INT(_VAL_) (REG32(ADR_INT_MASK_REG)) = (((_VAL_) << 1) | ((REG32(ADR_INT_MASK_REG)) & 0xfffffffd))
#define SET_MASK_SOC_SYSTEM_INT(_VAL_) (REG32(ADR_INT_MASK_REG)) = (((_VAL_) << 2) | ((REG32(ADR_INT_MASK_REG)) & 0xfffffffb))
#define SET_EDCA0_LOW_THR_INT_MASK(_VAL_) (REG32(ADR_INT_MASK_REG)) = (((_VAL_) << 3) | ((REG32(ADR_INT_MASK_REG)) & 0xfffffff7))
#define SET_EDCA1_LOW_THR_INT_MASK(_VAL_) (REG32(ADR_INT_MASK_REG)) = (((_VAL_) << 4) | ((REG32(ADR_INT_MASK_REG)) & 0xffffffef))
#define SET_EDCA2_LOW_THR_INT_MASK(_VAL_) (REG32(ADR_INT_MASK_REG)) = (((_VAL_) << 5) | ((REG32(ADR_INT_MASK_REG)) & 0xffffffdf))
#define SET_EDCA3_LOW_THR_INT_MASK(_VAL_) (REG32(ADR_INT_MASK_REG)) = (((_VAL_) << 6) | ((REG32(ADR_INT_MASK_REG)) & 0xffffffbf))
#define SET_TX_LIMIT_INT_MASK(_VAL_) (REG32(ADR_INT_MASK_REG)) = (((_VAL_) << 7) | ((REG32(ADR_INT_MASK_REG)) & 0xffffff7f))
#define SET_RX_INT(_VAL_) (REG32(ADR_INT_STATUS_REG)) = (((_VAL_) << 0) | ((REG32(ADR_INT_STATUS_REG)) & 0xfffffffe))
#define SET_TX_COMPLETE_INT(_VAL_) (REG32(ADR_INT_STATUS_REG)) = (((_VAL_) << 1) | ((REG32(ADR_INT_STATUS_REG)) & 0xfffffffd))
#define SET_SOC_SYSTEM_INT_STATUS(_VAL_) (REG32(ADR_INT_STATUS_REG)) = (((_VAL_) << 2) | ((REG32(ADR_INT_STATUS_REG)) & 0xfffffffb))
#define SET_EDCA0_LOW_THR_INT_STS(_VAL_) (REG32(ADR_INT_STATUS_REG)) = (((_VAL_) << 3) | ((REG32(ADR_INT_STATUS_REG)) & 0xfffffff7))
#define SET_EDCA1_LOW_THR_INT_STS(_VAL_) (REG32(ADR_INT_STATUS_REG)) = (((_VAL_) << 4) | ((REG32(ADR_INT_STATUS_REG)) & 0xffffffef))
#define SET_EDCA2_LOW_THR_INT_STS(_VAL_) (REG32(ADR_INT_STATUS_REG)) = (((_VAL_) << 5) | ((REG32(ADR_INT_STATUS_REG)) & 0xffffffdf))
#define SET_EDCA3_LOW_THR_INT_STS(_VAL_) (REG32(ADR_INT_STATUS_REG)) = (((_VAL_) << 6) | ((REG32(ADR_INT_STATUS_REG)) & 0xffffffbf))
#define SET_TX_LIMIT_INT_STS(_VAL_) (REG32(ADR_INT_STATUS_REG)) = (((_VAL_) << 7) | ((REG32(ADR_INT_STATUS_REG)) & 0xffffff7f))
#define SET_HOST_TRIGGERED_RX_INT(_VAL_) (REG32(ADR_INT_STATUS_REG)) = (((_VAL_) << 8) | ((REG32(ADR_INT_STATUS_REG)) & 0xfffffeff))
#define SET_HOST_TRIGGERED_TX_INT(_VAL_) (REG32(ADR_INT_STATUS_REG)) = (((_VAL_) << 9) | ((REG32(ADR_INT_STATUS_REG)) & 0xfffffdff))
#define SET_SOC_TRIGGER_RX_INT(_VAL_) (REG32(ADR_INT_STATUS_REG)) = (((_VAL_) << 10) | ((REG32(ADR_INT_STATUS_REG)) & 0xfffffbff))
#define SET_SOC_TRIGGER_TX_INT(_VAL_) (REG32(ADR_INT_STATUS_REG)) = (((_VAL_) << 11) | ((REG32(ADR_INT_STATUS_REG)) & 0xfffff7ff))
#define SET_RDY_FOR_TX_RX(_VAL_) (REG32(ADR_FN1_STATUS_REG)) = (((_VAL_) << 0) | ((REG32(ADR_FN1_STATUS_REG)) & 0xfffffffe))
#define SET_RDY_FOR_FW_DOWNLOAD(_VAL_) (REG32(ADR_FN1_STATUS_REG)) = (((_VAL_) << 1) | ((REG32(ADR_FN1_STATUS_REG)) & 0xfffffffd))
#define SET_ILLEGAL_CMD_RESP_OPTION(_VAL_) (REG32(ADR_FN1_STATUS_REG)) = (((_VAL_) << 2) | ((REG32(ADR_FN1_STATUS_REG)) & 0xfffffffb))
#define SET_SDIO_TRX_DATA_SEQUENCE(_VAL_) (REG32(ADR_FN1_STATUS_REG)) = (((_VAL_) << 3) | ((REG32(ADR_FN1_STATUS_REG)) & 0xfffffff7))
#define SET_GPIO_INT_TRIGGER_OPTION(_VAL_) (REG32(ADR_FN1_STATUS_REG)) = (((_VAL_) << 4) | ((REG32(ADR_FN1_STATUS_REG)) & 0xffffffef))
#define SET_TRIGGER_FUNCTION_SETTING(_VAL_) (REG32(ADR_FN1_STATUS_REG)) = (((_VAL_) << 5) | ((REG32(ADR_FN1_STATUS_REG)) & 0xffffff9f))
#define SET_CMD52_ABORT_RESPONSE(_VAL_) (REG32(ADR_FN1_STATUS_REG)) = (((_VAL_) << 7) | ((REG32(ADR_FN1_STATUS_REG)) & 0xffffff7f))
#define SET_RX_PACKET_LENGTH(_VAL_) (REG32(ADR_CARD_PKT_STATUS_TEST)) = (((_VAL_) << 0) | ((REG32(ADR_CARD_PKT_STATUS_TEST)) & 0xffff0000))
#define SET_CARD_FW_DL_STATUS(_VAL_) (REG32(ADR_CARD_PKT_STATUS_TEST)) = (((_VAL_) << 16) | ((REG32(ADR_CARD_PKT_STATUS_TEST)) & 0xff00ffff))
#define SET_TX_RX_LOOP_BACK_TEST(_VAL_) (REG32(ADR_CARD_PKT_STATUS_TEST)) = (((_VAL_) << 24) | ((REG32(ADR_CARD_PKT_STATUS_TEST)) & 0xfeffffff))
#define SET_SDIO_LOOP_BACK_TEST(_VAL_) (REG32(ADR_CARD_PKT_STATUS_TEST)) = (((_VAL_) << 25) | ((REG32(ADR_CARD_PKT_STATUS_TEST)) & 0xfdffffff))
#define SET_CMD52_ABORT_ACTIVE(_VAL_) (REG32(ADR_CARD_PKT_STATUS_TEST)) = (((_VAL_) << 28) | ((REG32(ADR_CARD_PKT_STATUS_TEST)) & 0xefffffff))
#define SET_CMD52_RESET_ACTIVE(_VAL_) (REG32(ADR_CARD_PKT_STATUS_TEST)) = (((_VAL_) << 29) | ((REG32(ADR_CARD_PKT_STATUS_TEST)) & 0xdfffffff))
#define SET_SDIO_PARTIAL_RESET_ACTIVE(_VAL_) (REG32(ADR_CARD_PKT_STATUS_TEST)) = (((_VAL_) << 30) | ((REG32(ADR_CARD_PKT_STATUS_TEST)) & 0xbfffffff))
#define SET_SDIO_ALL_RESE_ACTIVE(_VAL_) (REG32(ADR_CARD_PKT_STATUS_TEST)) = (((_VAL_) << 31) | ((REG32(ADR_CARD_PKT_STATUS_TEST)) & 0x7fffffff))
#define SET_RX_PACKET_LENGTH2(_VAL_) (REG32(ADR_SYSTEM_INFORMATION_REG)) = (((_VAL_) << 0) | ((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0xffff0000))
#define SET_RX_INT1(_VAL_) (REG32(ADR_SYSTEM_INFORMATION_REG)) = (((_VAL_) << 16) | ((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0xfffeffff))
#define SET_TX_DONE(_VAL_) (REG32(ADR_SYSTEM_INFORMATION_REG)) = (((_VAL_) << 17) | ((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0xfffdffff))
#define SET_HCI_TRX_FINISH(_VAL_) (REG32(ADR_SYSTEM_INFORMATION_REG)) = (((_VAL_) << 18) | ((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0xfffbffff))
#define SET_ALLOCATE_STATUS(_VAL_) (REG32(ADR_SYSTEM_INFORMATION_REG)) = (((_VAL_) << 19) | ((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0xfff7ffff))
#define SET_HCI_INPUT_FF_CNT(_VAL_) (REG32(ADR_SYSTEM_INFORMATION_REG)) = (((_VAL_) << 20) | ((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0xff0fffff))
#define SET_HCI_OUTPUT_FF_CNT(_VAL_) (REG32(ADR_SYSTEM_INFORMATION_REG)) = (((_VAL_) << 24) | ((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0xe0ffffff))
#define SET_AHB_HANG4(_VAL_) (REG32(ADR_SYSTEM_INFORMATION_REG)) = (((_VAL_) << 29) | ((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0xdfffffff))
#define SET_HCI_IN_QUE_EMPTY(_VAL_) (REG32(ADR_SYSTEM_INFORMATION_REG)) = (((_VAL_) << 30) | ((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0xbfffffff))
#define SET_SYSTEM_INT(_VAL_) (REG32(ADR_SYSTEM_INFORMATION_REG)) = (((_VAL_) << 31) | ((REG32(ADR_SYSTEM_INFORMATION_REG)) & 0x7fffffff))
#define SET_CARD_RCA_REG(_VAL_) (REG32(ADR_CARD_RCA_REG)) = (((_VAL_) << 0) | ((REG32(ADR_CARD_RCA_REG)) & 0xffff0000))
#define SET_SDIO_FIFO_WR_THLD_REG(_VAL_) (REG32(ADR_SDIO_FIFO_WR_THLD_REG)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_FIFO_WR_THLD_REG)) & 0xfffffe00))
#define SET_SDIO_FIFO_WR_LIMIT_REG(_VAL_) (REG32(ADR_SDIO_FIFO_WR_LIMIT_REG)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_FIFO_WR_LIMIT_REG)) & 0xfffffe00))
#define SET_SDIO_TX_DATA_BATCH_SIZE_REG(_VAL_) (REG32(ADR_SDIO_TX_DATA_BATCH_SIZE_REG)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_TX_DATA_BATCH_SIZE_REG)) & 0xfffffe00))
#define SET_SDIO_THLD_FOR_CMD53RD_REG(_VAL_) (REG32(ADR_SDIO_THLD_FOR_CMD53RD_REG)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_THLD_FOR_CMD53RD_REG)) & 0xfffffe00))
#define SET_SDIO_RX_DATA_BATCH_SIZE_REG(_VAL_) (REG32(ADR_SDIO_RX_DATA_BATCH_SIZE_REG)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_RX_DATA_BATCH_SIZE_REG)) & 0xfffffe00))
#define SET_START_BYTE_VALUE(_VAL_) (REG32(ADR_SDIO_LOG_START_END_DATA_REG)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_LOG_START_END_DATA_REG)) & 0xffffff00))
#define SET_END_BYTE_VALUE(_VAL_) (REG32(ADR_SDIO_LOG_START_END_DATA_REG)) = (((_VAL_) << 8) | ((REG32(ADR_SDIO_LOG_START_END_DATA_REG)) & 0xffff00ff))
#define SET_SDIO_BYTE_MODE_BATCH_SIZE_REG(_VAL_) (REG32(ADR_SDIO_BYTE_MODE_BATCH_SIZE_REG)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_BYTE_MODE_BATCH_SIZE_REG)) & 0xffffff00))
#define SET_SDIO_LAST_CMD_INDEX_REG(_VAL_) (REG32(ADR_SDIO_LAST_CMD_INDEX_CRC_REG)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_LAST_CMD_INDEX_CRC_REG)) & 0xffffffc0))
#define SET_SDIO_LAST_CMD_CRC_REG(_VAL_) (REG32(ADR_SDIO_LAST_CMD_INDEX_CRC_REG)) = (((_VAL_) << 8) | ((REG32(ADR_SDIO_LAST_CMD_INDEX_CRC_REG)) & 0xffff80ff))
#define SET_SDIO_LAST_CMD_ARG_REG(_VAL_) (REG32(ADR_SDIO_LAST_CMD_ARG_REG)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_LAST_CMD_ARG_REG)) & 0x00000000))
#define SET_SDIO_BUS_STATE_REG(_VAL_) (REG32(ADR_SDIO_BUS_STATE_DEBUG_MONITOR)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_BUS_STATE_DEBUG_MONITOR)) & 0xffffffe0))
#define SET_SDIO_BUSY_LONG_CNT(_VAL_) (REG32(ADR_SDIO_BUS_STATE_DEBUG_MONITOR)) = (((_VAL_) << 16) | ((REG32(ADR_SDIO_BUS_STATE_DEBUG_MONITOR)) & 0x0000ffff))
#define SET_SDIO_CARD_STATUS_REG(_VAL_) (REG32(ADR_SDIO_CARD_STATUS_REG)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_CARD_STATUS_REG)) & 0x00000000))
#define SET_R5_RESPONSE_FLAG(_VAL_) (REG32(ADR_R5_RESP_FLAG_OUT_TIMING)) = (((_VAL_) << 0) | ((REG32(ADR_R5_RESP_FLAG_OUT_TIMING)) & 0xffffff00))
#define SET_RESP_OUT_EDGE(_VAL_) (REG32(ADR_R5_RESP_FLAG_OUT_TIMING)) = (((_VAL_) << 8) | ((REG32(ADR_R5_RESP_FLAG_OUT_TIMING)) & 0xfffffeff))
#define SET_DAT_OUT_EDGE(_VAL_) (REG32(ADR_R5_RESP_FLAG_OUT_TIMING)) = (((_VAL_) << 9) | ((REG32(ADR_R5_RESP_FLAG_OUT_TIMING)) & 0xfffffdff))
#define SET_MCU_TO_SDIO_INFO_MASK(_VAL_) (REG32(ADR_R5_RESP_FLAG_OUT_TIMING)) = (((_VAL_) << 16) | ((REG32(ADR_R5_RESP_FLAG_OUT_TIMING)) & 0xfffeffff))
#define SET_INT_THROUGH_PIN(_VAL_) (REG32(ADR_R5_RESP_FLAG_OUT_TIMING)) = (((_VAL_) << 17) | ((REG32(ADR_R5_RESP_FLAG_OUT_TIMING)) & 0xfffdffff))
#define SET_WRITE_DATA(_VAL_) (REG32(ADR_CMD52_DATA_FOR_LAST_TIME)) = (((_VAL_) << 0) | ((REG32(ADR_CMD52_DATA_FOR_LAST_TIME)) & 0xffffff00))
#define SET_WRITE_ADDRESS(_VAL_) (REG32(ADR_CMD52_DATA_FOR_LAST_TIME)) = (((_VAL_) << 8) | ((REG32(ADR_CMD52_DATA_FOR_LAST_TIME)) & 0xffff00ff))
#define SET_READ_DATA(_VAL_) (REG32(ADR_CMD52_DATA_FOR_LAST_TIME)) = (((_VAL_) << 16) | ((REG32(ADR_CMD52_DATA_FOR_LAST_TIME)) & 0xff00ffff))
#define SET_READ_ADDRESS(_VAL_) (REG32(ADR_CMD52_DATA_FOR_LAST_TIME)) = (((_VAL_) << 24) | ((REG32(ADR_CMD52_DATA_FOR_LAST_TIME)) & 0x00ffffff))
#define SET_FN1_DMA_START_ADDR_REG(_VAL_) (REG32(ADR_FN1_DMA_START_ADDR_REG)) = (((_VAL_) << 0) | ((REG32(ADR_FN1_DMA_START_ADDR_REG)) & 0x00000000))
#define SET_SDIO_TO_MCU_INFO(_VAL_) (REG32(ADR_FN1_INT_CTRL_RESET)) = (((_VAL_) << 0) | ((REG32(ADR_FN1_INT_CTRL_RESET)) & 0xffffff00))
#define SET_SDIO_PARTIAL_RESET(_VAL_) (REG32(ADR_FN1_INT_CTRL_RESET)) = (((_VAL_) << 8) | ((REG32(ADR_FN1_INT_CTRL_RESET)) & 0xfffffeff))
#define SET_SDIO_ALL_RESET(_VAL_) (REG32(ADR_FN1_INT_CTRL_RESET)) = (((_VAL_) << 9) | ((REG32(ADR_FN1_INT_CTRL_RESET)) & 0xfffffdff))
#define SET_PERI_MAC_ALL_RESET(_VAL_) (REG32(ADR_FN1_INT_CTRL_RESET)) = (((_VAL_) << 10) | ((REG32(ADR_FN1_INT_CTRL_RESET)) & 0xfffffbff))
#define SET_MAC_ALL_RESET(_VAL_) (REG32(ADR_FN1_INT_CTRL_RESET)) = (((_VAL_) << 11) | ((REG32(ADR_FN1_INT_CTRL_RESET)) & 0xfffff7ff))
#define SET_AHB_BRIDGE_RESET(_VAL_) (REG32(ADR_FN1_INT_CTRL_RESET)) = (((_VAL_) << 12) | ((REG32(ADR_FN1_INT_CTRL_RESET)) & 0xffffefff))
#define SET_IO_REG_PORT_REG(_VAL_) (REG32(ADR_IO_REG_PORT_REG)) = (((_VAL_) << 0) | ((REG32(ADR_IO_REG_PORT_REG)) & 0xfffe0000))
#define SET_SDIO_FIFO_EMPTY_CNT(_VAL_) (REG32(ADR_SDIO_FIFO_ERROR_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_FIFO_ERROR_CNT)) & 0xffff0000))
#define SET_SDIO_FIFO_FULL_CNT(_VAL_) (REG32(ADR_SDIO_FIFO_ERROR_CNT)) = (((_VAL_) << 16) | ((REG32(ADR_SDIO_FIFO_ERROR_CNT)) & 0x0000ffff))
#define SET_SDIO_CRC7_ERROR_CNT(_VAL_) (REG32(ADR_SDIO_CRC7_CRC16_ERROR_REG)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_CRC7_CRC16_ERROR_REG)) & 0xffff0000))
#define SET_SDIO_CRC16_ERROR_CNT(_VAL_) (REG32(ADR_SDIO_CRC7_CRC16_ERROR_REG)) = (((_VAL_) << 16) | ((REG32(ADR_SDIO_CRC7_CRC16_ERROR_REG)) & 0x0000ffff))
#define SET_SDIO_RD_BLOCK_CNT(_VAL_) (REG32(ADR_SDIO_BLOCK_CNT_INFO)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_BLOCK_CNT_INFO)) & 0xfffffe00))
#define SET_SDIO_WR_BLOCK_CNT(_VAL_) (REG32(ADR_SDIO_BLOCK_CNT_INFO)) = (((_VAL_) << 16) | ((REG32(ADR_SDIO_BLOCK_CNT_INFO)) & 0xfe00ffff))
#define SET_CMD52_RD_ABORT_CNT(_VAL_) (REG32(ADR_RX_DATA_CMD52_ABORT_COUNT)) = (((_VAL_) << 16) | ((REG32(ADR_RX_DATA_CMD52_ABORT_COUNT)) & 0xfff0ffff))
#define SET_CMD52_WR_ABORT_CNT(_VAL_) (REG32(ADR_RX_DATA_CMD52_ABORT_COUNT)) = (((_VAL_) << 20) | ((REG32(ADR_RX_DATA_CMD52_ABORT_COUNT)) & 0xff0fffff))
#define SET_SDIO_FIFO_WR_PTR_REG(_VAL_) (REG32(ADR_FIFO_PTR_READ_BLOCK_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_FIFO_PTR_READ_BLOCK_CNT)) & 0xffffff00))
#define SET_SDIO_FIFO_RD_PTR_REG(_VAL_) (REG32(ADR_FIFO_PTR_READ_BLOCK_CNT)) = (((_VAL_) << 8) | ((REG32(ADR_FIFO_PTR_READ_BLOCK_CNT)) & 0xffff00ff))
#define SET_SDIO_READ_DATA_CTRL(_VAL_) (REG32(ADR_TX_TIME_OUT_READ_CTRL)) = (((_VAL_) << 16) | ((REG32(ADR_TX_TIME_OUT_READ_CTRL)) & 0xfffeffff))
#define SET_TX_SIZE_BEFORE_SHIFT(_VAL_) (REG32(ADR_SDIO_TX_ALLOC_REG)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0xffffff00))
#define SET_TX_SIZE_SHIFT_BITS(_VAL_) (REG32(ADR_SDIO_TX_ALLOC_REG)) = (((_VAL_) << 8) | ((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0xfffff8ff))
#define SET_SDIO_TX_ALLOC_STATE(_VAL_) (REG32(ADR_SDIO_TX_ALLOC_REG)) = (((_VAL_) << 12) | ((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0xffffefff))
#define SET_ALLOCATE_STATUS2(_VAL_) (REG32(ADR_SDIO_TX_ALLOC_REG)) = (((_VAL_) << 16) | ((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0xfffeffff))
#define SET_NO_ALLOCATE_SEND_ERROR(_VAL_) (REG32(ADR_SDIO_TX_ALLOC_REG)) = (((_VAL_) << 17) | ((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0xfffdffff))
#define SET_DOUBLE_ALLOCATE_ERROR(_VAL_) (REG32(ADR_SDIO_TX_ALLOC_REG)) = (((_VAL_) << 18) | ((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0xfffbffff))
#define SET_TX_DONE_STATUS(_VAL_) (REG32(ADR_SDIO_TX_ALLOC_REG)) = (((_VAL_) << 19) | ((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0xfff7ffff))
#define SET_AHB_HANG2(_VAL_) (REG32(ADR_SDIO_TX_ALLOC_REG)) = (((_VAL_) << 20) | ((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0xffefffff))
#define SET_HCI_TRX_FINISH2(_VAL_) (REG32(ADR_SDIO_TX_ALLOC_REG)) = (((_VAL_) << 21) | ((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0xffdfffff))
#define SET_INTR_RX(_VAL_) (REG32(ADR_SDIO_TX_ALLOC_REG)) = (((_VAL_) << 22) | ((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0xffbfffff))
#define SET_HCI_INPUT_QUEUE_FULL(_VAL_) (REG32(ADR_SDIO_TX_ALLOC_REG)) = (((_VAL_) << 23) | ((REG32(ADR_SDIO_TX_ALLOC_REG)) & 0xff7fffff))
#define SET_ALLOCATESTATUS(_VAL_) (REG32(ADR_SDIO_TX_INFORM)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_TX_INFORM)) & 0xfffffffe))
#define SET_HCI_TRX_FINISH3(_VAL_) (REG32(ADR_SDIO_TX_INFORM)) = (((_VAL_) << 1) | ((REG32(ADR_SDIO_TX_INFORM)) & 0xfffffffd))
#define SET_HCI_IN_QUE_EMPTY2(_VAL_) (REG32(ADR_SDIO_TX_INFORM)) = (((_VAL_) << 2) | ((REG32(ADR_SDIO_TX_INFORM)) & 0xfffffffb))
#define SET_MTX_MNG_UPTHOLD_INT(_VAL_) (REG32(ADR_SDIO_TX_INFORM)) = (((_VAL_) << 3) | ((REG32(ADR_SDIO_TX_INFORM)) & 0xfffffff7))
#define SET_EDCA0_UPTHOLD_INT(_VAL_) (REG32(ADR_SDIO_TX_INFORM)) = (((_VAL_) << 4) | ((REG32(ADR_SDIO_TX_INFORM)) & 0xffffffef))
#define SET_EDCA1_UPTHOLD_INT(_VAL_) (REG32(ADR_SDIO_TX_INFORM)) = (((_VAL_) << 5) | ((REG32(ADR_SDIO_TX_INFORM)) & 0xffffffdf))
#define SET_EDCA2_UPTHOLD_INT(_VAL_) (REG32(ADR_SDIO_TX_INFORM)) = (((_VAL_) << 6) | ((REG32(ADR_SDIO_TX_INFORM)) & 0xffffffbf))
#define SET_EDCA3_UPTHOLD_INT(_VAL_) (REG32(ADR_SDIO_TX_INFORM)) = (((_VAL_) << 7) | ((REG32(ADR_SDIO_TX_INFORM)) & 0xffffff7f))
#define SET_TX_PAGE_REMAIN2(_VAL_) (REG32(ADR_SDIO_TX_INFORM)) = (((_VAL_) << 8) | ((REG32(ADR_SDIO_TX_INFORM)) & 0xffff00ff))
#define SET_TX_ID_REMAIN3(_VAL_) (REG32(ADR_SDIO_TX_INFORM)) = (((_VAL_) << 16) | ((REG32(ADR_SDIO_TX_INFORM)) & 0xff80ffff))
#define SET_HCI_OUTPUT_FF_CNT_0(_VAL_) (REG32(ADR_SDIO_TX_INFORM)) = (((_VAL_) << 23) | ((REG32(ADR_SDIO_TX_INFORM)) & 0xff7fffff))
#define SET_HCI_OUTPUT_FF_CNT2(_VAL_) (REG32(ADR_SDIO_TX_INFORM)) = (((_VAL_) << 24) | ((REG32(ADR_SDIO_TX_INFORM)) & 0xf0ffffff))
#define SET_HCI_INPUT_FF_CNT2(_VAL_) (REG32(ADR_SDIO_TX_INFORM)) = (((_VAL_) << 28) | ((REG32(ADR_SDIO_TX_INFORM)) & 0x0fffffff))
#define SET_F1_BLOCK_SIZE_0_REG(_VAL_) (REG32(ADR_F1_BLOCK_SIZE_0_REG)) = (((_VAL_) << 0) | ((REG32(ADR_F1_BLOCK_SIZE_0_REG)) & 0xfffff000))
#define SET_START_BYTE_VALUE2(_VAL_) (REG32(ADR_SDIO_COMMAND_LOG_DATA_31_0)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_COMMAND_LOG_DATA_31_0)) & 0xffffff00))
#define SET_COMMAND_COUNTER(_VAL_) (REG32(ADR_SDIO_COMMAND_LOG_DATA_31_0)) = (((_VAL_) << 8) | ((REG32(ADR_SDIO_COMMAND_LOG_DATA_31_0)) & 0xffff00ff))
#define SET_CMD_LOG_PART1(_VAL_) (REG32(ADR_SDIO_COMMAND_LOG_DATA_31_0)) = (((_VAL_) << 16) | ((REG32(ADR_SDIO_COMMAND_LOG_DATA_31_0)) & 0x0000ffff))
#define SET_CMD_LOG_PART2(_VAL_) (REG32(ADR_SDIO_COMMAND_LOG_DATA_63_32)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_COMMAND_LOG_DATA_63_32)) & 0xff000000))
#define SET_END_BYTE_VALUE2(_VAL_) (REG32(ADR_SDIO_COMMAND_LOG_DATA_63_32)) = (((_VAL_) << 24) | ((REG32(ADR_SDIO_COMMAND_LOG_DATA_63_32)) & 0x00ffffff))
#define SET_RX_PACKET_LENGTH3(_VAL_) (REG32(ADR_SYSTEM_INFORMATION_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_SYSTEM_INFORMATION_REGISTER)) & 0xffff0000))
#define SET_RX_INT3(_VAL_) (REG32(ADR_SYSTEM_INFORMATION_REGISTER)) = (((_VAL_) << 16) | ((REG32(ADR_SYSTEM_INFORMATION_REGISTER)) & 0xfffeffff))
#define SET_TX_ID_REMAIN2(_VAL_) (REG32(ADR_SYSTEM_INFORMATION_REGISTER)) = (((_VAL_) << 17) | ((REG32(ADR_SYSTEM_INFORMATION_REGISTER)) & 0xff01ffff))
#define SET_TX_PAGE_REMAIN3(_VAL_) (REG32(ADR_SYSTEM_INFORMATION_REGISTER)) = (((_VAL_) << 24) | ((REG32(ADR_SYSTEM_INFORMATION_REGISTER)) & 0x00ffffff))
#define SET_CCCR_00H_REG(_VAL_) (REG32(ADR_CCCR_00H_REG)) = (((_VAL_) << 0) | ((REG32(ADR_CCCR_00H_REG)) & 0xffffff00))
#define SET_CCCR_02H_REG(_VAL_) (REG32(ADR_CCCR_00H_REG)) = (((_VAL_) << 16) | ((REG32(ADR_CCCR_00H_REG)) & 0xff00ffff))
#define SET_CCCR_03H_REG(_VAL_) (REG32(ADR_CCCR_00H_REG)) = (((_VAL_) << 24) | ((REG32(ADR_CCCR_00H_REG)) & 0x00ffffff))
#define SET_CCCR_04H_REG(_VAL_) (REG32(ADR_CCCR_04H_REG)) = (((_VAL_) << 0) | ((REG32(ADR_CCCR_04H_REG)) & 0xffffff00))
#define SET_CCCR_05H_REG(_VAL_) (REG32(ADR_CCCR_04H_REG)) = (((_VAL_) << 8) | ((REG32(ADR_CCCR_04H_REG)) & 0xffff00ff))
#define SET_CCCR_06H_REG(_VAL_) (REG32(ADR_CCCR_04H_REG)) = (((_VAL_) << 16) | ((REG32(ADR_CCCR_04H_REG)) & 0xfff0ffff))
#define SET_CCCR_07H_REG(_VAL_) (REG32(ADR_CCCR_04H_REG)) = (((_VAL_) << 24) | ((REG32(ADR_CCCR_04H_REG)) & 0x00ffffff))
#define SET_SUPPORT_DIRECT_COMMAND_SDIO(_VAL_) (REG32(ADR_CCCR_08H_REG)) = (((_VAL_) << 0) | ((REG32(ADR_CCCR_08H_REG)) & 0xfffffffe))
#define SET_SUPPORT_MULTIPLE_BLOCK_TRANSFER(_VAL_) (REG32(ADR_CCCR_08H_REG)) = (((_VAL_) << 1) | ((REG32(ADR_CCCR_08H_REG)) & 0xfffffffd))
#define SET_SUPPORT_READ_WAIT(_VAL_) (REG32(ADR_CCCR_08H_REG)) = (((_VAL_) << 2) | ((REG32(ADR_CCCR_08H_REG)) & 0xfffffffb))
#define SET_SUPPORT_BUS_CONTROL(_VAL_) (REG32(ADR_CCCR_08H_REG)) = (((_VAL_) << 3) | ((REG32(ADR_CCCR_08H_REG)) & 0xfffffff7))
#define SET_SUPPORT_BLOCK_GAP_INTERRUPT(_VAL_) (REG32(ADR_CCCR_08H_REG)) = (((_VAL_) << 4) | ((REG32(ADR_CCCR_08H_REG)) & 0xffffffef))
#define SET_ENABLE_BLOCK_GAP_INTERRUPT(_VAL_) (REG32(ADR_CCCR_08H_REG)) = (((_VAL_) << 5) | ((REG32(ADR_CCCR_08H_REG)) & 0xffffffdf))
#define SET_LOW_SPEED_CARD(_VAL_) (REG32(ADR_CCCR_08H_REG)) = (((_VAL_) << 6) | ((REG32(ADR_CCCR_08H_REG)) & 0xffffffbf))
#define SET_LOW_SPEED_CARD_4BIT(_VAL_) (REG32(ADR_CCCR_08H_REG)) = (((_VAL_) << 7) | ((REG32(ADR_CCCR_08H_REG)) & 0xffffff7f))
#define SET_COMMON_CIS_PONTER(_VAL_) (REG32(ADR_CCCR_08H_REG)) = (((_VAL_) << 8) | ((REG32(ADR_CCCR_08H_REG)) & 0xfe0000ff))
#define SET_SUPPORT_HIGH_SPEED(_VAL_) (REG32(ADR_CCCR_13H_REG)) = (((_VAL_) << 24) | ((REG32(ADR_CCCR_13H_REG)) & 0xfeffffff))
#define SET_BSS(_VAL_) (REG32(ADR_CCCR_13H_REG)) = (((_VAL_) << 25) | ((REG32(ADR_CCCR_13H_REG)) & 0xf1ffffff))
#define SET_FBR_100H_REG(_VAL_) (REG32(ADR_FBR_100H_REG)) = (((_VAL_) << 0) | ((REG32(ADR_FBR_100H_REG)) & 0xfffffff0))
#define SET_CSASUPPORT(_VAL_) (REG32(ADR_FBR_100H_REG)) = (((_VAL_) << 6) | ((REG32(ADR_FBR_100H_REG)) & 0xffffffbf))
#define SET_ENABLECSA(_VAL_) (REG32(ADR_FBR_100H_REG)) = (((_VAL_) << 7) | ((REG32(ADR_FBR_100H_REG)) & 0xffffff7f))
#define SET_FBR_101H_REG(_VAL_) (REG32(ADR_FBR_100H_REG)) = (((_VAL_) << 8) | ((REG32(ADR_FBR_100H_REG)) & 0xffff00ff))
#define SET_FBR_109H_REG(_VAL_) (REG32(ADR_FBR_109H_REG)) = (((_VAL_) << 8) | ((REG32(ADR_FBR_109H_REG)) & 0xfe0000ff))
#define SET_F0_CIS_CONTENT_REG_31_0(_VAL_) (REG32(ADR_F0_CIS_CONTENT_REG_0)) = (((_VAL_) << 0) | ((REG32(ADR_F0_CIS_CONTENT_REG_0)) & 0x00000000))
#define SET_F0_CIS_CONTENT_REG_63_32(_VAL_) (REG32(ADR_F0_CIS_CONTENT_REG_1)) = (((_VAL_) << 0) | ((REG32(ADR_F0_CIS_CONTENT_REG_1)) & 0x00000000))
#define SET_F0_CIS_CONTENT_REG_95_64(_VAL_) (REG32(ADR_F0_CIS_CONTENT_REG_2)) = (((_VAL_) << 0) | ((REG32(ADR_F0_CIS_CONTENT_REG_2)) & 0x00000000))
#define SET_F0_CIS_CONTENT_REG_127_96(_VAL_) (REG32(ADR_F0_CIS_CONTENT_REG_3)) = (((_VAL_) << 0) | ((REG32(ADR_F0_CIS_CONTENT_REG_3)) & 0x00000000))
#define SET_F0_CIS_CONTENT_REG_159_128(_VAL_) (REG32(ADR_F0_CIS_CONTENT_REG_4)) = (((_VAL_) << 0) | ((REG32(ADR_F0_CIS_CONTENT_REG_4)) & 0x00000000))
#define SET_F0_CIS_CONTENT_REG_191_160(_VAL_) (REG32(ADR_F0_CIS_CONTENT_REG_5)) = (((_VAL_) << 0) | ((REG32(ADR_F0_CIS_CONTENT_REG_5)) & 0x00000000))
#define SET_F0_CIS_CONTENT_REG_223_192(_VAL_) (REG32(ADR_F0_CIS_CONTENT_REG_6)) = (((_VAL_) << 0) | ((REG32(ADR_F0_CIS_CONTENT_REG_6)) & 0x00000000))
#define SET_F0_CIS_CONTENT_REG_255_224(_VAL_) (REG32(ADR_F0_CIS_CONTENT_REG_7)) = (((_VAL_) << 0) | ((REG32(ADR_F0_CIS_CONTENT_REG_7)) & 0x00000000))
#define SET_F0_CIS_CONTENT_REG_287_256(_VAL_) (REG32(ADR_F0_CIS_CONTENT_REG_8)) = (((_VAL_) << 0) | ((REG32(ADR_F0_CIS_CONTENT_REG_8)) & 0x00000000))
#define SET_F0_CIS_CONTENT_REG_319_288(_VAL_) (REG32(ADR_F0_CIS_CONTENT_REG_9)) = (((_VAL_) << 0) | ((REG32(ADR_F0_CIS_CONTENT_REG_9)) & 0x00000000))
#define SET_F0_CIS_CONTENT_REG_351_320(_VAL_) (REG32(ADR_F0_CIS_CONTENT_REG_10)) = (((_VAL_) << 0) | ((REG32(ADR_F0_CIS_CONTENT_REG_10)) & 0x00000000))
#define SET_F0_CIS_CONTENT_REG_383_352(_VAL_) (REG32(ADR_F0_CIS_CONTENT_REG_11)) = (((_VAL_) << 0) | ((REG32(ADR_F0_CIS_CONTENT_REG_11)) & 0x00000000))
#define SET_F0_CIS_CONTENT_REG_415_384(_VAL_) (REG32(ADR_F0_CIS_CONTENT_REG_12)) = (((_VAL_) << 0) | ((REG32(ADR_F0_CIS_CONTENT_REG_12)) & 0x00000000))
#define SET_F0_CIS_CONTENT_REG_447_416(_VAL_) (REG32(ADR_F0_CIS_CONTENT_REG_13)) = (((_VAL_) << 0) | ((REG32(ADR_F0_CIS_CONTENT_REG_13)) & 0x00000000))
#define SET_F0_CIS_CONTENT_REG_479_448(_VAL_) (REG32(ADR_F0_CIS_CONTENT_REG_14)) = (((_VAL_) << 0) | ((REG32(ADR_F0_CIS_CONTENT_REG_14)) & 0x00000000))
#define SET_F0_CIS_CONTENT_REG_511_480(_VAL_) (REG32(ADR_F0_CIS_CONTENT_REG_15)) = (((_VAL_) << 0) | ((REG32(ADR_F0_CIS_CONTENT_REG_15)) & 0x00000000))
#define SET_F1_CIS_CONTENT_REG_31_0(_VAL_) (REG32(ADR_F1_CIS_CONTENT_REG_0)) = (((_VAL_) << 0) | ((REG32(ADR_F1_CIS_CONTENT_REG_0)) & 0x00000000))
#define SET_F1_CIS_CONTENT_REG_63_32(_VAL_) (REG32(ADR_F1_CIS_CONTENT_REG_1)) = (((_VAL_) << 0) | ((REG32(ADR_F1_CIS_CONTENT_REG_1)) & 0x00000000))
#define SET_F1_CIS_CONTENT_REG_95_64(_VAL_) (REG32(ADR_F1_CIS_CONTENT_REG_2)) = (((_VAL_) << 0) | ((REG32(ADR_F1_CIS_CONTENT_REG_2)) & 0x00000000))
#define SET_F1_CIS_CONTENT_REG_127_96(_VAL_) (REG32(ADR_F1_CIS_CONTENT_REG_3)) = (((_VAL_) << 0) | ((REG32(ADR_F1_CIS_CONTENT_REG_3)) & 0x00000000))
#define SET_F1_CIS_CONTENT_REG_159_128(_VAL_) (REG32(ADR_F1_CIS_CONTENT_REG_4)) = (((_VAL_) << 0) | ((REG32(ADR_F1_CIS_CONTENT_REG_4)) & 0x00000000))
#define SET_F1_CIS_CONTENT_REG_191_160(_VAL_) (REG32(ADR_F1_CIS_CONTENT_REG_5)) = (((_VAL_) << 0) | ((REG32(ADR_F1_CIS_CONTENT_REG_5)) & 0x00000000))
#define SET_F1_CIS_CONTENT_REG_223_192(_VAL_) (REG32(ADR_F1_CIS_CONTENT_REG_6)) = (((_VAL_) << 0) | ((REG32(ADR_F1_CIS_CONTENT_REG_6)) & 0x00000000))
#define SET_F1_CIS_CONTENT_REG_255_224(_VAL_) (REG32(ADR_F1_CIS_CONTENT_REG_7)) = (((_VAL_) << 0) | ((REG32(ADR_F1_CIS_CONTENT_REG_7)) & 0x00000000))
#define SET_F1_CIS_CONTENT_REG_287_256(_VAL_) (REG32(ADR_F1_CIS_CONTENT_REG_8)) = (((_VAL_) << 0) | ((REG32(ADR_F1_CIS_CONTENT_REG_8)) & 0x00000000))
#define SET_F1_CIS_CONTENT_REG_319_288(_VAL_) (REG32(ADR_F1_CIS_CONTENT_REG_9)) = (((_VAL_) << 0) | ((REG32(ADR_F1_CIS_CONTENT_REG_9)) & 0x00000000))
#define SET_F1_CIS_CONTENT_REG_351_320(_VAL_) (REG32(ADR_F1_CIS_CONTENT_REG_10)) = (((_VAL_) << 0) | ((REG32(ADR_F1_CIS_CONTENT_REG_10)) & 0x00000000))
#define SET_F1_CIS_CONTENT_REG_383_352(_VAL_) (REG32(ADR_F1_CIS_CONTENT_REG_11)) = (((_VAL_) << 0) | ((REG32(ADR_F1_CIS_CONTENT_REG_11)) & 0x00000000))
#define SET_F1_CIS_CONTENT_REG_415_384(_VAL_) (REG32(ADR_F1_CIS_CONTENT_REG_12)) = (((_VAL_) << 0) | ((REG32(ADR_F1_CIS_CONTENT_REG_12)) & 0x00000000))
#define SET_F1_CIS_CONTENT_REG_447_416(_VAL_) (REG32(ADR_F1_CIS_CONTENT_REG_13)) = (((_VAL_) << 0) | ((REG32(ADR_F1_CIS_CONTENT_REG_13)) & 0x00000000))
#define SET_F1_CIS_CONTENT_REG_479_448(_VAL_) (REG32(ADR_F1_CIS_CONTENT_REG_14)) = (((_VAL_) << 0) | ((REG32(ADR_F1_CIS_CONTENT_REG_14)) & 0x00000000))
#define SET_F1_CIS_CONTENT_REG_511_480(_VAL_) (REG32(ADR_F1_CIS_CONTENT_REG_15)) = (((_VAL_) << 0) | ((REG32(ADR_F1_CIS_CONTENT_REG_15)) & 0x00000000))
#define SET_SPI_MODE(_VAL_) (REG32(ADR_SPI_MODE)) = (((_VAL_) << 0) | ((REG32(ADR_SPI_MODE)) & 0x00000000))
#define SET_RX_QUOTA(_VAL_) (REG32(ADR_RX_QUOTA)) = (((_VAL_) << 0) | ((REG32(ADR_RX_QUOTA)) & 0xffff0000))
#define SET_CONDI_NUM(_VAL_) (REG32(ADR_CONDITION_NUMBER)) = (((_VAL_) << 0) | ((REG32(ADR_CONDITION_NUMBER)) & 0xffffff00))
#define SET_HOST_PATH(_VAL_) (REG32(ADR_HOST_PATH)) = (((_VAL_) << 0) | ((REG32(ADR_HOST_PATH)) & 0xfffffffe))
#define SET_TX_SEG(_VAL_) (REG32(ADR_TX_SEG)) = (((_VAL_) << 0) | ((REG32(ADR_TX_SEG)) & 0x00000000))
#define SET_BRST_MODE(_VAL_) (REG32(ADR_DEBUG_BURST_MODE)) = (((_VAL_) << 0) | ((REG32(ADR_DEBUG_BURST_MODE)) & 0xfffffffe))
#define SET_CLK_WIDTH(_VAL_) (REG32(ADR_SPI_TO_PHY_PARAM1)) = (((_VAL_) << 0) | ((REG32(ADR_SPI_TO_PHY_PARAM1)) & 0xffff0000))
#define SET_CSN_INTER(_VAL_) (REG32(ADR_SPI_TO_PHY_PARAM1)) = (((_VAL_) << 16) | ((REG32(ADR_SPI_TO_PHY_PARAM1)) & 0x0000ffff))
#define SET_BACK_DLY(_VAL_) (REG32(ADR_SPI_TO_PHY_PARAM2)) = (((_VAL_) << 0) | ((REG32(ADR_SPI_TO_PHY_PARAM2)) & 0xffff0000))
#define SET_FRONT_DLY(_VAL_) (REG32(ADR_SPI_TO_PHY_PARAM2)) = (((_VAL_) << 16) | ((REG32(ADR_SPI_TO_PHY_PARAM2)) & 0x0000ffff))
#define SET_RX_FIFO_FAIL(_VAL_) (REG32(ADR_SPI_STS)) = (((_VAL_) << 1) | ((REG32(ADR_SPI_STS)) & 0xfffffffd))
#define SET_RX_HOST_FAIL(_VAL_) (REG32(ADR_SPI_STS)) = (((_VAL_) << 2) | ((REG32(ADR_SPI_STS)) & 0xfffffffb))
#define SET_TX_FIFO_FAIL(_VAL_) (REG32(ADR_SPI_STS)) = (((_VAL_) << 3) | ((REG32(ADR_SPI_STS)) & 0xfffffff7))
#define SET_TX_HOST_FAIL(_VAL_) (REG32(ADR_SPI_STS)) = (((_VAL_) << 4) | ((REG32(ADR_SPI_STS)) & 0xffffffef))
#define SET_SPI_DOUBLE_ALLOC(_VAL_) (REG32(ADR_SPI_STS)) = (((_VAL_) << 5) | ((REG32(ADR_SPI_STS)) & 0xffffffdf))
#define SET_SPI_TX_NO_ALLOC(_VAL_) (REG32(ADR_SPI_STS)) = (((_VAL_) << 6) | ((REG32(ADR_SPI_STS)) & 0xffffffbf))
#define SET_RDATA_RDY(_VAL_) (REG32(ADR_SPI_STS)) = (((_VAL_) << 7) | ((REG32(ADR_SPI_STS)) & 0xffffff7f))
#define SET_SPI_ALLOC_STATUS(_VAL_) (REG32(ADR_SPI_STS)) = (((_VAL_) << 8) | ((REG32(ADR_SPI_STS)) & 0xfffffeff))
#define SET_SPI_DBG_WR_FIFO_FULL(_VAL_) (REG32(ADR_SPI_STS)) = (((_VAL_) << 9) | ((REG32(ADR_SPI_STS)) & 0xfffffdff))
#define SET_RX_LEN(_VAL_) (REG32(ADR_SPI_STS)) = (((_VAL_) << 16) | ((REG32(ADR_SPI_STS)) & 0x0000ffff))
#define SET_SPI_TX_ALLOC_SIZE_SHIFT_BITS(_VAL_) (REG32(ADR_TX_ALLOC_SET)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ALLOC_SET)) & 0xfffffff8))
#define SET_SPI_HOST_TX_ALLOC_PKBUF(_VAL_) (REG32(ADR_TX_ALLOC_SET)) = (((_VAL_) << 8) | ((REG32(ADR_TX_ALLOC_SET)) & 0xfffffeff))
#define SET_SPI_TX_ALLOC_SIZE(_VAL_) (REG32(ADR_TX_ALLOC)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ALLOC)) & 0xffffff00))
#define SET_RD_DAT_CNT(_VAL_) (REG32(ADR_DBG_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_CNT)) & 0xffff0000))
#define SET_RD_STS_CNT(_VAL_) (REG32(ADR_DBG_CNT)) = (((_VAL_) << 16) | ((REG32(ADR_DBG_CNT)) & 0x0000ffff))
#define SET_JUDGE_CNT(_VAL_) (REG32(ADR_DBG_CNT2)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_CNT2)) & 0xffff0000))
#define SET_RD_STS_CNT_CLR(_VAL_) (REG32(ADR_DBG_CNT2)) = (((_VAL_) << 16) | ((REG32(ADR_DBG_CNT2)) & 0xfffeffff))
#define SET_RD_DAT_CNT_CLR(_VAL_) (REG32(ADR_DBG_CNT2)) = (((_VAL_) << 17) | ((REG32(ADR_DBG_CNT2)) & 0xfffdffff))
#define SET_JUDGE_CNT_CLR(_VAL_) (REG32(ADR_DBG_CNT2)) = (((_VAL_) << 18) | ((REG32(ADR_DBG_CNT2)) & 0xfffbffff))
#define SET_TX_DONE_CNT(_VAL_) (REG32(ADR_DBG_CNT3)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_CNT3)) & 0xffff0000))
#define SET_TX_DISCARD_CNT(_VAL_) (REG32(ADR_DBG_CNT3)) = (((_VAL_) << 16) | ((REG32(ADR_DBG_CNT3)) & 0x0000ffff))
#define SET_TX_SET_CNT(_VAL_) (REG32(ADR_DBG_CNT4)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_CNT4)) & 0xffff0000))
#define SET_TX_DISCARD_CNT_CLR(_VAL_) (REG32(ADR_DBG_CNT4)) = (((_VAL_) << 16) | ((REG32(ADR_DBG_CNT4)) & 0xfffeffff))
#define SET_TX_DONE_CNT_CLR(_VAL_) (REG32(ADR_DBG_CNT4)) = (((_VAL_) << 17) | ((REG32(ADR_DBG_CNT4)) & 0xfffdffff))
#define SET_TX_SET_CNT_CLR(_VAL_) (REG32(ADR_DBG_CNT4)) = (((_VAL_) << 18) | ((REG32(ADR_DBG_CNT4)) & 0xfffbffff))
#define SET_DAT_MODE_OFF(_VAL_) (REG32(ADR_DBG_CNT4)) = (((_VAL_) << 19) | ((REG32(ADR_DBG_CNT4)) & 0xfff7ffff))
#define SET_TX_FIFO_RESIDUE(_VAL_) (REG32(ADR_DBG_CNT4)) = (((_VAL_) << 20) | ((REG32(ADR_DBG_CNT4)) & 0xff8fffff))
#define SET_RX_FIFO_RESIDUE(_VAL_) (REG32(ADR_DBG_CNT4)) = (((_VAL_) << 24) | ((REG32(ADR_DBG_CNT4)) & 0xf8ffffff))
#define SET_RX_RDY(_VAL_) (REG32(ADR_INT_TAG)) = (((_VAL_) << 0) | ((REG32(ADR_INT_TAG)) & 0xfffffffe))
#define SET_SDIO_SYS_INT(_VAL_) (REG32(ADR_INT_TAG)) = (((_VAL_) << 2) | ((REG32(ADR_INT_TAG)) & 0xfffffffb))
#define SET_EDCA0_LOWTHOLD_INT(_VAL_) (REG32(ADR_INT_TAG)) = (((_VAL_) << 3) | ((REG32(ADR_INT_TAG)) & 0xfffffff7))
#define SET_EDCA1_LOWTHOLD_INT(_VAL_) (REG32(ADR_INT_TAG)) = (((_VAL_) << 4) | ((REG32(ADR_INT_TAG)) & 0xffffffef))
#define SET_EDCA2_LOWTHOLD_INT(_VAL_) (REG32(ADR_INT_TAG)) = (((_VAL_) << 5) | ((REG32(ADR_INT_TAG)) & 0xffffffdf))
#define SET_EDCA3_LOWTHOLD_INT(_VAL_) (REG32(ADR_INT_TAG)) = (((_VAL_) << 6) | ((REG32(ADR_INT_TAG)) & 0xffffffbf))
#define SET_TX_LIMIT_INT_IN(_VAL_) (REG32(ADR_INT_TAG)) = (((_VAL_) << 7) | ((REG32(ADR_INT_TAG)) & 0xffffff7f))
#define SET_SPI_FN1(_VAL_) (REG32(ADR_INT_TAG)) = (((_VAL_) << 8) | ((REG32(ADR_INT_TAG)) & 0xffff80ff))
#define SET_SPI_CLK_EN_INT(_VAL_) (REG32(ADR_INT_TAG)) = (((_VAL_) << 15) | ((REG32(ADR_INT_TAG)) & 0xffff7fff))
#define SET_SPI_HOST_MASK(_VAL_) (REG32(ADR_INT_TAG)) = (((_VAL_) << 16) | ((REG32(ADR_INT_TAG)) & 0xff00ffff))
#define SET_I2CM_INT_WDONE(_VAL_) (REG32(ADR_I2CM_EN)) = (((_VAL_) << 0) | ((REG32(ADR_I2CM_EN)) & 0xfffffffe))
#define SET_I2CM_INT_RDONE(_VAL_) (REG32(ADR_I2CM_EN)) = (((_VAL_) << 1) | ((REG32(ADR_I2CM_EN)) & 0xfffffffd))
#define SET_I2CM_IDLE(_VAL_) (REG32(ADR_I2CM_EN)) = (((_VAL_) << 2) | ((REG32(ADR_I2CM_EN)) & 0xfffffffb))
#define SET_I2CM_INT_MISMATCH(_VAL_) (REG32(ADR_I2CM_EN)) = (((_VAL_) << 3) | ((REG32(ADR_I2CM_EN)) & 0xfffffff7))
#define SET_I2CM_PSCL(_VAL_) (REG32(ADR_I2CM_EN)) = (((_VAL_) << 4) | ((REG32(ADR_I2CM_EN)) & 0xffffc00f))
#define SET_I2CM_MANUAL_MODE(_VAL_) (REG32(ADR_I2CM_EN)) = (((_VAL_) << 16) | ((REG32(ADR_I2CM_EN)) & 0xfffeffff))
#define SET_I2CM_INT_WDATA_NEED(_VAL_) (REG32(ADR_I2CM_EN)) = (((_VAL_) << 17) | ((REG32(ADR_I2CM_EN)) & 0xfffdffff))
#define SET_I2CM_INT_RDATA_NEED(_VAL_) (REG32(ADR_I2CM_EN)) = (((_VAL_) << 18) | ((REG32(ADR_I2CM_EN)) & 0xfffbffff))
#define SET_I2CM_DEV_A(_VAL_) (REG32(ADR_I2CM_DEV_A)) = (((_VAL_) << 0) | ((REG32(ADR_I2CM_DEV_A)) & 0xfffffc00))
#define SET_I2CM_DEV_A10B(_VAL_) (REG32(ADR_I2CM_DEV_A)) = (((_VAL_) << 14) | ((REG32(ADR_I2CM_DEV_A)) & 0xffffbfff))
#define SET_I2CM_RX(_VAL_) (REG32(ADR_I2CM_DEV_A)) = (((_VAL_) << 15) | ((REG32(ADR_I2CM_DEV_A)) & 0xffff7fff))
#define SET_I2CM_LEN(_VAL_) (REG32(ADR_I2CM_LEN)) = (((_VAL_) << 0) | ((REG32(ADR_I2CM_LEN)) & 0xffff0000))
#define SET_I2CM_T_LEFT(_VAL_) (REG32(ADR_I2CM_LEN)) = (((_VAL_) << 16) | ((REG32(ADR_I2CM_LEN)) & 0xfff8ffff))
#define SET_I2CM_R_GET(_VAL_) (REG32(ADR_I2CM_LEN)) = (((_VAL_) << 24) | ((REG32(ADR_I2CM_LEN)) & 0xf8ffffff))
#define SET_I2CM_WDAT(_VAL_) (REG32(ADR_I2CM_WDAT)) = (((_VAL_) << 0) | ((REG32(ADR_I2CM_WDAT)) & 0x00000000))
#define SET_I2CM_RDAT(_VAL_) (REG32(ADR_I2CM_RDAT)) = (((_VAL_) << 0) | ((REG32(ADR_I2CM_RDAT)) & 0x00000000))
#define SET_I2CM_SR_LEN(_VAL_) (REG32(ADR_I2CM_EN_2)) = (((_VAL_) << 0) | ((REG32(ADR_I2CM_EN_2)) & 0xffff0000))
#define SET_I2CM_SR_RX(_VAL_) (REG32(ADR_I2CM_EN_2)) = (((_VAL_) << 16) | ((REG32(ADR_I2CM_EN_2)) & 0xfffeffff))
#define SET_I2CM_REPEAT_START(_VAL_) (REG32(ADR_I2CM_EN_2)) = (((_VAL_) << 17) | ((REG32(ADR_I2CM_EN_2)) & 0xfffdffff))
#define SET_UART_DATA(_VAL_) (REG32(ADR_UART_DATA)) = (((_VAL_) << 0) | ((REG32(ADR_UART_DATA)) & 0xffffff00))
#define SET_DATA_RDY_IE(_VAL_) (REG32(ADR_UART_IER)) = (((_VAL_) << 0) | ((REG32(ADR_UART_IER)) & 0xfffffffe))
#define SET_THR_EMPTY_IE(_VAL_) (REG32(ADR_UART_IER)) = (((_VAL_) << 1) | ((REG32(ADR_UART_IER)) & 0xfffffffd))
#define SET_RX_LINESTS_IE(_VAL_) (REG32(ADR_UART_IER)) = (((_VAL_) << 2) | ((REG32(ADR_UART_IER)) & 0xfffffffb))
#define SET_MDM_STS_IE(_VAL_) (REG32(ADR_UART_IER)) = (((_VAL_) << 3) | ((REG32(ADR_UART_IER)) & 0xfffffff7))
#define SET_DMA_RXEND_IE(_VAL_) (REG32(ADR_UART_IER)) = (((_VAL_) << 6) | ((REG32(ADR_UART_IER)) & 0xffffffbf))
#define SET_DMA_TXEND_IE(_VAL_) (REG32(ADR_UART_IER)) = (((_VAL_) << 7) | ((REG32(ADR_UART_IER)) & 0xffffff7f))
#define SET_FIFO_EN(_VAL_) (REG32(ADR_UART_FCR)) = (((_VAL_) << 0) | ((REG32(ADR_UART_FCR)) & 0xfffffffe))
#define SET_RXFIFO_RST(_VAL_) (REG32(ADR_UART_FCR)) = (((_VAL_) << 1) | ((REG32(ADR_UART_FCR)) & 0xfffffffd))
#define SET_TXFIFO_RST(_VAL_) (REG32(ADR_UART_FCR)) = (((_VAL_) << 2) | ((REG32(ADR_UART_FCR)) & 0xfffffffb))
#define SET_DMA_MODE(_VAL_) (REG32(ADR_UART_FCR)) = (((_VAL_) << 3) | ((REG32(ADR_UART_FCR)) & 0xfffffff7))
#define SET_EN_AUTO_RTS(_VAL_) (REG32(ADR_UART_FCR)) = (((_VAL_) << 4) | ((REG32(ADR_UART_FCR)) & 0xffffffef))
#define SET_EN_AUTO_CTS(_VAL_) (REG32(ADR_UART_FCR)) = (((_VAL_) << 5) | ((REG32(ADR_UART_FCR)) & 0xffffffdf))
#define SET_RXFIFO_TRGLVL(_VAL_) (REG32(ADR_UART_FCR)) = (((_VAL_) << 6) | ((REG32(ADR_UART_FCR)) & 0xffffff3f))
#define SET_WORD_LEN(_VAL_) (REG32(ADR_UART_LCR)) = (((_VAL_) << 0) | ((REG32(ADR_UART_LCR)) & 0xfffffffc))
#define SET_STOP_BIT(_VAL_) (REG32(ADR_UART_LCR)) = (((_VAL_) << 2) | ((REG32(ADR_UART_LCR)) & 0xfffffffb))
#define SET_PARITY_EN(_VAL_) (REG32(ADR_UART_LCR)) = (((_VAL_) << 3) | ((REG32(ADR_UART_LCR)) & 0xfffffff7))
#define SET_EVEN_PARITY(_VAL_) (REG32(ADR_UART_LCR)) = (((_VAL_) << 4) | ((REG32(ADR_UART_LCR)) & 0xffffffef))
#define SET_FORCE_PARITY(_VAL_) (REG32(ADR_UART_LCR)) = (((_VAL_) << 5) | ((REG32(ADR_UART_LCR)) & 0xffffffdf))
#define SET_SET_BREAK(_VAL_) (REG32(ADR_UART_LCR)) = (((_VAL_) << 6) | ((REG32(ADR_UART_LCR)) & 0xffffffbf))
#define SET_DLAB(_VAL_) (REG32(ADR_UART_LCR)) = (((_VAL_) << 7) | ((REG32(ADR_UART_LCR)) & 0xffffff7f))
#define SET_DTR(_VAL_) (REG32(ADR_UART_MCR)) = (((_VAL_) << 0) | ((REG32(ADR_UART_MCR)) & 0xfffffffe))
#define SET_RTS(_VAL_) (REG32(ADR_UART_MCR)) = (((_VAL_) << 1) | ((REG32(ADR_UART_MCR)) & 0xfffffffd))
#define SET_OUT_1(_VAL_) (REG32(ADR_UART_MCR)) = (((_VAL_) << 2) | ((REG32(ADR_UART_MCR)) & 0xfffffffb))
#define SET_OUT_2(_VAL_) (REG32(ADR_UART_MCR)) = (((_VAL_) << 3) | ((REG32(ADR_UART_MCR)) & 0xfffffff7))
#define SET_LOOP_BACK(_VAL_) (REG32(ADR_UART_MCR)) = (((_VAL_) << 4) | ((REG32(ADR_UART_MCR)) & 0xffffffef))
#define SET_DATA_RDY(_VAL_) (REG32(ADR_UART_LSR)) = (((_VAL_) << 0) | ((REG32(ADR_UART_LSR)) & 0xfffffffe))
#define SET_OVERRUN_ERR(_VAL_) (REG32(ADR_UART_LSR)) = (((_VAL_) << 1) | ((REG32(ADR_UART_LSR)) & 0xfffffffd))
#define SET_PARITY_ERR(_VAL_) (REG32(ADR_UART_LSR)) = (((_VAL_) << 2) | ((REG32(ADR_UART_LSR)) & 0xfffffffb))
#define SET_FRAMING_ERR(_VAL_) (REG32(ADR_UART_LSR)) = (((_VAL_) << 3) | ((REG32(ADR_UART_LSR)) & 0xfffffff7))
#define SET_BREAK_INT(_VAL_) (REG32(ADR_UART_LSR)) = (((_VAL_) << 4) | ((REG32(ADR_UART_LSR)) & 0xffffffef))
#define SET_THR_EMPTY(_VAL_) (REG32(ADR_UART_LSR)) = (((_VAL_) << 5) | ((REG32(ADR_UART_LSR)) & 0xffffffdf))
#define SET_TX_EMPTY(_VAL_) (REG32(ADR_UART_LSR)) = (((_VAL_) << 6) | ((REG32(ADR_UART_LSR)) & 0xffffffbf))
#define SET_FIFODATA_ERR(_VAL_) (REG32(ADR_UART_LSR)) = (((_VAL_) << 7) | ((REG32(ADR_UART_LSR)) & 0xffffff7f))
#define SET_DELTA_CTS(_VAL_) (REG32(ADR_UART_MSR)) = (((_VAL_) << 0) | ((REG32(ADR_UART_MSR)) & 0xfffffffe))
#define SET_DELTA_DSR(_VAL_) (REG32(ADR_UART_MSR)) = (((_VAL_) << 1) | ((REG32(ADR_UART_MSR)) & 0xfffffffd))
#define SET_TRAILEDGE_RI(_VAL_) (REG32(ADR_UART_MSR)) = (((_VAL_) << 2) | ((REG32(ADR_UART_MSR)) & 0xfffffffb))
#define SET_DELTA_CD(_VAL_) (REG32(ADR_UART_MSR)) = (((_VAL_) << 3) | ((REG32(ADR_UART_MSR)) & 0xfffffff7))
#define SET_CTS(_VAL_) (REG32(ADR_UART_MSR)) = (((_VAL_) << 4) | ((REG32(ADR_UART_MSR)) & 0xffffffef))
#define SET_DSR(_VAL_) (REG32(ADR_UART_MSR)) = (((_VAL_) << 5) | ((REG32(ADR_UART_MSR)) & 0xffffffdf))
#define SET_RI(_VAL_) (REG32(ADR_UART_MSR)) = (((_VAL_) << 6) | ((REG32(ADR_UART_MSR)) & 0xffffffbf))
#define SET_CD(_VAL_) (REG32(ADR_UART_MSR)) = (((_VAL_) << 7) | ((REG32(ADR_UART_MSR)) & 0xffffff7f))
#define SET_BRDC_DIV(_VAL_) (REG32(ADR_UART_SPR)) = (((_VAL_) << 0) | ((REG32(ADR_UART_SPR)) & 0xffff0000))
#define SET_RTHR_L(_VAL_) (REG32(ADR_UART_RTHR)) = (((_VAL_) << 0) | ((REG32(ADR_UART_RTHR)) & 0xfffffff0))
#define SET_RTHR_H(_VAL_) (REG32(ADR_UART_RTHR)) = (((_VAL_) << 4) | ((REG32(ADR_UART_RTHR)) & 0xffffff0f))
#define SET_INT_IDCODE(_VAL_) (REG32(ADR_UART_ISR)) = (((_VAL_) << 0) | ((REG32(ADR_UART_ISR)) & 0xfffffff0))
#define SET_FIFOS_ENABLED(_VAL_) (REG32(ADR_UART_ISR)) = (((_VAL_) << 6) | ((REG32(ADR_UART_ISR)) & 0xffffff3f))
#define SET_DAT_UART_DATA(_VAL_) (REG32(ADR_DAT_UART_DATA)) = (((_VAL_) << 0) | ((REG32(ADR_DAT_UART_DATA)) & 0xffffff00))
#define SET_DAT_DATA_RDY_IE(_VAL_) (REG32(ADR_DAT_UART_IER)) = (((_VAL_) << 0) | ((REG32(ADR_DAT_UART_IER)) & 0xfffffffe))
#define SET_DAT_THR_EMPTY_IE(_VAL_) (REG32(ADR_DAT_UART_IER)) = (((_VAL_) << 1) | ((REG32(ADR_DAT_UART_IER)) & 0xfffffffd))
#define SET_DAT_RX_LINESTS_IE(_VAL_) (REG32(ADR_DAT_UART_IER)) = (((_VAL_) << 2) | ((REG32(ADR_DAT_UART_IER)) & 0xfffffffb))
#define SET_DAT_MDM_STS_IE(_VAL_) (REG32(ADR_DAT_UART_IER)) = (((_VAL_) << 3) | ((REG32(ADR_DAT_UART_IER)) & 0xfffffff7))
#define SET_DAT_DMA_RXEND_IE(_VAL_) (REG32(ADR_DAT_UART_IER)) = (((_VAL_) << 6) | ((REG32(ADR_DAT_UART_IER)) & 0xffffffbf))
#define SET_DAT_DMA_TXEND_IE(_VAL_) (REG32(ADR_DAT_UART_IER)) = (((_VAL_) << 7) | ((REG32(ADR_DAT_UART_IER)) & 0xffffff7f))
#define SET_DAT_FIFO_EN(_VAL_) (REG32(ADR_DAT_UART_FCR)) = (((_VAL_) << 0) | ((REG32(ADR_DAT_UART_FCR)) & 0xfffffffe))
#define SET_DAT_RXFIFO_RST(_VAL_) (REG32(ADR_DAT_UART_FCR)) = (((_VAL_) << 1) | ((REG32(ADR_DAT_UART_FCR)) & 0xfffffffd))
#define SET_DAT_TXFIFO_RST(_VAL_) (REG32(ADR_DAT_UART_FCR)) = (((_VAL_) << 2) | ((REG32(ADR_DAT_UART_FCR)) & 0xfffffffb))
#define SET_DAT_DMA_MODE(_VAL_) (REG32(ADR_DAT_UART_FCR)) = (((_VAL_) << 3) | ((REG32(ADR_DAT_UART_FCR)) & 0xfffffff7))
#define SET_DAT_EN_AUTO_RTS(_VAL_) (REG32(ADR_DAT_UART_FCR)) = (((_VAL_) << 4) | ((REG32(ADR_DAT_UART_FCR)) & 0xffffffef))
#define SET_DAT_EN_AUTO_CTS(_VAL_) (REG32(ADR_DAT_UART_FCR)) = (((_VAL_) << 5) | ((REG32(ADR_DAT_UART_FCR)) & 0xffffffdf))
#define SET_DAT_RXFIFO_TRGLVL(_VAL_) (REG32(ADR_DAT_UART_FCR)) = (((_VAL_) << 6) | ((REG32(ADR_DAT_UART_FCR)) & 0xffffff3f))
#define SET_DAT_WORD_LEN(_VAL_) (REG32(ADR_DAT_UART_LCR)) = (((_VAL_) << 0) | ((REG32(ADR_DAT_UART_LCR)) & 0xfffffffc))
#define SET_DAT_STOP_BIT(_VAL_) (REG32(ADR_DAT_UART_LCR)) = (((_VAL_) << 2) | ((REG32(ADR_DAT_UART_LCR)) & 0xfffffffb))
#define SET_DAT_PARITY_EN(_VAL_) (REG32(ADR_DAT_UART_LCR)) = (((_VAL_) << 3) | ((REG32(ADR_DAT_UART_LCR)) & 0xfffffff7))
#define SET_DAT_EVEN_PARITY(_VAL_) (REG32(ADR_DAT_UART_LCR)) = (((_VAL_) << 4) | ((REG32(ADR_DAT_UART_LCR)) & 0xffffffef))
#define SET_DAT_FORCE_PARITY(_VAL_) (REG32(ADR_DAT_UART_LCR)) = (((_VAL_) << 5) | ((REG32(ADR_DAT_UART_LCR)) & 0xffffffdf))
#define SET_DAT_SET_BREAK(_VAL_) (REG32(ADR_DAT_UART_LCR)) = (((_VAL_) << 6) | ((REG32(ADR_DAT_UART_LCR)) & 0xffffffbf))
#define SET_DAT_DLAB(_VAL_) (REG32(ADR_DAT_UART_LCR)) = (((_VAL_) << 7) | ((REG32(ADR_DAT_UART_LCR)) & 0xffffff7f))
#define SET_DAT_DTR(_VAL_) (REG32(ADR_DAT_UART_MCR)) = (((_VAL_) << 0) | ((REG32(ADR_DAT_UART_MCR)) & 0xfffffffe))
#define SET_DAT_RTS(_VAL_) (REG32(ADR_DAT_UART_MCR)) = (((_VAL_) << 1) | ((REG32(ADR_DAT_UART_MCR)) & 0xfffffffd))
#define SET_DAT_OUT_1(_VAL_) (REG32(ADR_DAT_UART_MCR)) = (((_VAL_) << 2) | ((REG32(ADR_DAT_UART_MCR)) & 0xfffffffb))
#define SET_DAT_OUT_2(_VAL_) (REG32(ADR_DAT_UART_MCR)) = (((_VAL_) << 3) | ((REG32(ADR_DAT_UART_MCR)) & 0xfffffff7))
#define SET_DAT_LOOP_BACK(_VAL_) (REG32(ADR_DAT_UART_MCR)) = (((_VAL_) << 4) | ((REG32(ADR_DAT_UART_MCR)) & 0xffffffef))
#define SET_DAT_DATA_RDY(_VAL_) (REG32(ADR_DAT_UART_LSR)) = (((_VAL_) << 0) | ((REG32(ADR_DAT_UART_LSR)) & 0xfffffffe))
#define SET_DAT_OVERRUN_ERR(_VAL_) (REG32(ADR_DAT_UART_LSR)) = (((_VAL_) << 1) | ((REG32(ADR_DAT_UART_LSR)) & 0xfffffffd))
#define SET_DAT_PARITY_ERR(_VAL_) (REG32(ADR_DAT_UART_LSR)) = (((_VAL_) << 2) | ((REG32(ADR_DAT_UART_LSR)) & 0xfffffffb))
#define SET_DAT_FRAMING_ERR(_VAL_) (REG32(ADR_DAT_UART_LSR)) = (((_VAL_) << 3) | ((REG32(ADR_DAT_UART_LSR)) & 0xfffffff7))
#define SET_DAT_BREAK_INT(_VAL_) (REG32(ADR_DAT_UART_LSR)) = (((_VAL_) << 4) | ((REG32(ADR_DAT_UART_LSR)) & 0xffffffef))
#define SET_DAT_THR_EMPTY(_VAL_) (REG32(ADR_DAT_UART_LSR)) = (((_VAL_) << 5) | ((REG32(ADR_DAT_UART_LSR)) & 0xffffffdf))
#define SET_DAT_TX_EMPTY(_VAL_) (REG32(ADR_DAT_UART_LSR)) = (((_VAL_) << 6) | ((REG32(ADR_DAT_UART_LSR)) & 0xffffffbf))
#define SET_DAT_FIFODATA_ERR(_VAL_) (REG32(ADR_DAT_UART_LSR)) = (((_VAL_) << 7) | ((REG32(ADR_DAT_UART_LSR)) & 0xffffff7f))
#define SET_DAT_DELTA_CTS(_VAL_) (REG32(ADR_DAT_UART_MSR)) = (((_VAL_) << 0) | ((REG32(ADR_DAT_UART_MSR)) & 0xfffffffe))
#define SET_DAT_DELTA_DSR(_VAL_) (REG32(ADR_DAT_UART_MSR)) = (((_VAL_) << 1) | ((REG32(ADR_DAT_UART_MSR)) & 0xfffffffd))
#define SET_DAT_TRAILEDGE_RI(_VAL_) (REG32(ADR_DAT_UART_MSR)) = (((_VAL_) << 2) | ((REG32(ADR_DAT_UART_MSR)) & 0xfffffffb))
#define SET_DAT_DELTA_CD(_VAL_) (REG32(ADR_DAT_UART_MSR)) = (((_VAL_) << 3) | ((REG32(ADR_DAT_UART_MSR)) & 0xfffffff7))
#define SET_DAT_CTS(_VAL_) (REG32(ADR_DAT_UART_MSR)) = (((_VAL_) << 4) | ((REG32(ADR_DAT_UART_MSR)) & 0xffffffef))
#define SET_DAT_DSR(_VAL_) (REG32(ADR_DAT_UART_MSR)) = (((_VAL_) << 5) | ((REG32(ADR_DAT_UART_MSR)) & 0xffffffdf))
#define SET_DAT_RI(_VAL_) (REG32(ADR_DAT_UART_MSR)) = (((_VAL_) << 6) | ((REG32(ADR_DAT_UART_MSR)) & 0xffffffbf))
#define SET_DAT_CD(_VAL_) (REG32(ADR_DAT_UART_MSR)) = (((_VAL_) << 7) | ((REG32(ADR_DAT_UART_MSR)) & 0xffffff7f))
#define SET_DAT_BRDC_DIV(_VAL_) (REG32(ADR_DAT_UART_SPR)) = (((_VAL_) << 0) | ((REG32(ADR_DAT_UART_SPR)) & 0xffff0000))
#define SET_DAT_RTHR_L(_VAL_) (REG32(ADR_DAT_UART_RTHR)) = (((_VAL_) << 0) | ((REG32(ADR_DAT_UART_RTHR)) & 0xfffffff0))
#define SET_DAT_RTHR_H(_VAL_) (REG32(ADR_DAT_UART_RTHR)) = (((_VAL_) << 4) | ((REG32(ADR_DAT_UART_RTHR)) & 0xffffff0f))
#define SET_DAT_INT_IDCODE(_VAL_) (REG32(ADR_DAT_UART_ISR)) = (((_VAL_) << 0) | ((REG32(ADR_DAT_UART_ISR)) & 0xfffffff0))
#define SET_DAT_FIFOS_ENABLED(_VAL_) (REG32(ADR_DAT_UART_ISR)) = (((_VAL_) << 6) | ((REG32(ADR_DAT_UART_ISR)) & 0xffffff3f))
#define SET_MASK_TOP(_VAL_) (REG32(ADR_INT_MASK)) = (((_VAL_) << 0) | ((REG32(ADR_INT_MASK)) & 0x00000000))
#define SET_INT_MODE(_VAL_) (REG32(ADR_INT_MODE)) = (((_VAL_) << 0) | ((REG32(ADR_INT_MODE)) & 0x00000000))
#define SET_IRQ_PHY_0(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 0) | ((REG32(ADR_INT_IRQ_STS)) & 0xfffffffe))
#define SET_IRQ_PHY_1(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 1) | ((REG32(ADR_INT_IRQ_STS)) & 0xfffffffd))
#define SET_IRQ_SDIO(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 2) | ((REG32(ADR_INT_IRQ_STS)) & 0xfffffffb))
#define SET_IRQ_BEACON_DONE(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 3) | ((REG32(ADR_INT_IRQ_STS)) & 0xfffffff7))
#define SET_IRQ_BEACON(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 4) | ((REG32(ADR_INT_IRQ_STS)) & 0xffffffef))
#define SET_IRQ_PRE_BEACON(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 5) | ((REG32(ADR_INT_IRQ_STS)) & 0xffffffdf))
#define SET_IRQ_EDCA0_TX_DONE(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 6) | ((REG32(ADR_INT_IRQ_STS)) & 0xffffffbf))
#define SET_IRQ_EDCA1_TX_DONE(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 7) | ((REG32(ADR_INT_IRQ_STS)) & 0xffffff7f))
#define SET_IRQ_EDCA2_TX_DONE(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 8) | ((REG32(ADR_INT_IRQ_STS)) & 0xfffffeff))
#define SET_IRQ_EDCA3_TX_DONE(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 9) | ((REG32(ADR_INT_IRQ_STS)) & 0xfffffdff))
#define SET_IRQ_EDCA4_TX_DONE(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 10) | ((REG32(ADR_INT_IRQ_STS)) & 0xfffffbff))
#define SET_IRQ_BEACON_DTIM(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 12) | ((REG32(ADR_INT_IRQ_STS)) & 0xffffefff))
#define SET_IRQ_EDCA0_LOWTHOLD_INT(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 13) | ((REG32(ADR_INT_IRQ_STS)) & 0xffffdfff))
#define SET_IRQ_EDCA1_LOWTHOLD_INT(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 14) | ((REG32(ADR_INT_IRQ_STS)) & 0xffffbfff))
#define SET_IRQ_EDCA2_LOWTHOLD_INT(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 15) | ((REG32(ADR_INT_IRQ_STS)) & 0xffff7fff))
#define SET_IRQ_EDCA3_LOWTHOLD_INT(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 16) | ((REG32(ADR_INT_IRQ_STS)) & 0xfffeffff))
#define SET_IRQ_FENCE_HIT_INT(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 17) | ((REG32(ADR_INT_IRQ_STS)) & 0xfffdffff))
#define SET_IRQ_ILL_ADDR_INT(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 18) | ((REG32(ADR_INT_IRQ_STS)) & 0xfffbffff))
#define SET_IRQ_MBOX(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 19) | ((REG32(ADR_INT_IRQ_STS)) & 0xfff7ffff))
#define SET_IRQ_US_TIMER0(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 20) | ((REG32(ADR_INT_IRQ_STS)) & 0xffefffff))
#define SET_IRQ_US_TIMER1(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 21) | ((REG32(ADR_INT_IRQ_STS)) & 0xffdfffff))
#define SET_IRQ_US_TIMER2(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 22) | ((REG32(ADR_INT_IRQ_STS)) & 0xffbfffff))
#define SET_IRQ_US_TIMER3(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 23) | ((REG32(ADR_INT_IRQ_STS)) & 0xff7fffff))
#define SET_IRQ_MS_TIMER0(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 24) | ((REG32(ADR_INT_IRQ_STS)) & 0xfeffffff))
#define SET_IRQ_MS_TIMER1(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 25) | ((REG32(ADR_INT_IRQ_STS)) & 0xfdffffff))
#define SET_IRQ_MS_TIMER2(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 26) | ((REG32(ADR_INT_IRQ_STS)) & 0xfbffffff))
#define SET_IRQ_MS_TIMER3(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 27) | ((REG32(ADR_INT_IRQ_STS)) & 0xf7ffffff))
#define SET_IRQ_TX_LIMIT_INT(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 28) | ((REG32(ADR_INT_IRQ_STS)) & 0xefffffff))
#define SET_IRQ_DMA0(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 29) | ((REG32(ADR_INT_IRQ_STS)) & 0xdfffffff))
#define SET_IRQ_CO_DMA(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 30) | ((REG32(ADR_INT_IRQ_STS)) & 0xbfffffff))
#define SET_IRQ_PERI_GROUP(_VAL_) (REG32(ADR_INT_IRQ_STS)) = (((_VAL_) << 31) | ((REG32(ADR_INT_IRQ_STS)) & 0x7fffffff))
#define SET_FIQ_STATUS(_VAL_) (REG32(ADR_INT_FIQ_STS)) = (((_VAL_) << 0) | ((REG32(ADR_INT_FIQ_STS)) & 0x00000000))
#define SET_IRQ_RAW(_VAL_) (REG32(ADR_INT_IRQ_RAW)) = (((_VAL_) << 0) | ((REG32(ADR_INT_IRQ_RAW)) & 0x00000000))
#define SET_FIQ_RAW(_VAL_) (REG32(ADR_INT_FIQ_RAW)) = (((_VAL_) << 0) | ((REG32(ADR_INT_FIQ_RAW)) & 0x00000000))
#define SET_INT_PERI_MASK(_VAL_) (REG32(ADR_INT_PERI_MASK)) = (((_VAL_) << 0) | ((REG32(ADR_INT_PERI_MASK)) & 0x00000000))
#define SET_PERI_RTC(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 0) | ((REG32(ADR_INT_PERI_STS)) & 0xfffffffe))
#define SET_IRQ_UART0_TX(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 1) | ((REG32(ADR_INT_PERI_STS)) & 0xfffffffd))
#define SET_IRQ_UART0_RX(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 2) | ((REG32(ADR_INT_PERI_STS)) & 0xfffffffb))
#define SET_PERI_GPI_2(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 3) | ((REG32(ADR_INT_PERI_STS)) & 0xfffffff7))
#define SET_IRQ_SPI_IPC(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 4) | ((REG32(ADR_INT_PERI_STS)) & 0xffffffef))
#define SET_PERI_GPI_1_0(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 5) | ((REG32(ADR_INT_PERI_STS)) & 0xffffff9f))
#define SET_SCRT_INT_1(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 7) | ((REG32(ADR_INT_PERI_STS)) & 0xffffff7f))
#define SET_MMU_ALC_ERR(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 8) | ((REG32(ADR_INT_PERI_STS)) & 0xfffffeff))
#define SET_MMU_RLS_ERR(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 9) | ((REG32(ADR_INT_PERI_STS)) & 0xfffffdff))
#define SET_ID_MNG_INT_1(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 10) | ((REG32(ADR_INT_PERI_STS)) & 0xfffffbff))
#define SET_MBOX_INT_1(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 11) | ((REG32(ADR_INT_PERI_STS)) & 0xfffff7ff))
#define SET_MBOX_INT_2(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 12) | ((REG32(ADR_INT_PERI_STS)) & 0xffffefff))
#define SET_MBOX_INT_3(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 13) | ((REG32(ADR_INT_PERI_STS)) & 0xffffdfff))
#define SET_HCI_INT_1(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 14) | ((REG32(ADR_INT_PERI_STS)) & 0xffffbfff))
#define SET_UART_RX_TIMEOUT(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 15) | ((REG32(ADR_INT_PERI_STS)) & 0xffff7fff))
#define SET_UART_MULTI_IRQ(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 16) | ((REG32(ADR_INT_PERI_STS)) & 0xfffeffff))
#define SET_ID_MNG_INT_2(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 17) | ((REG32(ADR_INT_PERI_STS)) & 0xfffdffff))
#define SET_DMN_NOHIT_INT(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 18) | ((REG32(ADR_INT_PERI_STS)) & 0xfffbffff))
#define SET_ID_THOLD_RX(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 19) | ((REG32(ADR_INT_PERI_STS)) & 0xfff7ffff))
#define SET_ID_THOLD_TX(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 20) | ((REG32(ADR_INT_PERI_STS)) & 0xffefffff))
#define SET_ID_DOUBLE_RLS(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 21) | ((REG32(ADR_INT_PERI_STS)) & 0xffdfffff))
#define SET_RX_ID_LEN_THOLD(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 22) | ((REG32(ADR_INT_PERI_STS)) & 0xffbfffff))
#define SET_TX_ID_LEN_THOLD(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 23) | ((REG32(ADR_INT_PERI_STS)) & 0xff7fffff))
#define SET_ALL_ID_LEN_THOLD(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 24) | ((REG32(ADR_INT_PERI_STS)) & 0xfeffffff))
#define SET_DMN_MCU_INT(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 25) | ((REG32(ADR_INT_PERI_STS)) & 0xfdffffff))
#define SET_IRQ_DAT_UART_TX(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 26) | ((REG32(ADR_INT_PERI_STS)) & 0xfbffffff))
#define SET_IRQ_DAT_UART_RX(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 27) | ((REG32(ADR_INT_PERI_STS)) & 0xf7ffffff))
#define SET_DAT_UART_RX_TIMEOUT(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 28) | ((REG32(ADR_INT_PERI_STS)) & 0xefffffff))
#define SET_DAT_UART_MULTI_IRQ(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 29) | ((REG32(ADR_INT_PERI_STS)) & 0xdfffffff))
#define SET_ALR_ABT_NOCHG_INT_IRQ(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 30) | ((REG32(ADR_INT_PERI_STS)) & 0xbfffffff))
#define SET_TBLNEQ_MNGPKT_INT_IRQ(_VAL_) (REG32(ADR_INT_PERI_STS)) = (((_VAL_) << 31) | ((REG32(ADR_INT_PERI_STS)) & 0x7fffffff))
#define SET_INTR_PERI_RAW(_VAL_) (REG32(ADR_INT_PERI_RAW)) = (((_VAL_) << 0) | ((REG32(ADR_INT_PERI_RAW)) & 0x00000000))
#define SET_INTR_GPI00_CFG(_VAL_) (REG32(ADR_INT_GPI_CFG)) = (((_VAL_) << 0) | ((REG32(ADR_INT_GPI_CFG)) & 0xfffffffc))
#define SET_INTR_GPI01_CFG(_VAL_) (REG32(ADR_INT_GPI_CFG)) = (((_VAL_) << 2) | ((REG32(ADR_INT_GPI_CFG)) & 0xfffffff3))
#define SET_SYS_RST_INT(_VAL_) (REG32(ADR_SYS_INT_FOR_HOST)) = (((_VAL_) << 0) | ((REG32(ADR_SYS_INT_FOR_HOST)) & 0xfffffffe))
#define SET_SPI_IPC_ADDR(_VAL_) (REG32(ADR_SPI_IPC)) = (((_VAL_) << 0) | ((REG32(ADR_SPI_IPC)) & 0x00000000))
#define SET_SD_MASK_TOP(_VAL_) (REG32(ADR_SDIO_MASK)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_MASK)) & 0x00000000))
#define SET_IRQ_PHY_0_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xfffffffe))
#define SET_IRQ_PHY_1_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 1) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xfffffffd))
#define SET_IRQ_SDIO_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 2) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xfffffffb))
#define SET_IRQ_BEACON_DONE_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 3) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xfffffff7))
#define SET_IRQ_BEACON_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 4) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xffffffef))
#define SET_IRQ_PRE_BEACON_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 5) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xffffffdf))
#define SET_IRQ_EDCA0_TX_DONE_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 6) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xffffffbf))
#define SET_IRQ_EDCA1_TX_DONE_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 7) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xffffff7f))
#define SET_IRQ_EDCA2_TX_DONE_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 8) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xfffffeff))
#define SET_IRQ_EDCA3_TX_DONE_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 9) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xfffffdff))
#define SET_IRQ_EDCA4_TX_DONE_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 10) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xfffffbff))
#define SET_IRQ_BEACON_DTIM_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 12) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xffffefff))
#define SET_IRQ_EDCA0_LOWTHOLD_INT_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 13) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xffffdfff))
#define SET_IRQ_EDCA1_LOWTHOLD_INT_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 14) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xffffbfff))
#define SET_IRQ_EDCA2_LOWTHOLD_INT_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 15) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xffff7fff))
#define SET_IRQ_EDCA3_LOWTHOLD_INT_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 16) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xfffeffff))
#define SET_IRQ_FENCE_HIT_INT_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 17) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xfffdffff))
#define SET_IRQ_ILL_ADDR_INT_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 18) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xfffbffff))
#define SET_IRQ_MBOX_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 19) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xfff7ffff))
#define SET_IRQ_US_TIMER0_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 20) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xffefffff))
#define SET_IRQ_US_TIMER1_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 21) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xffdfffff))
#define SET_IRQ_US_TIMER2_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 22) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xffbfffff))
#define SET_IRQ_US_TIMER3_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 23) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xff7fffff))
#define SET_IRQ_MS_TIMER0_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 24) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xfeffffff))
#define SET_IRQ_MS_TIMER1_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 25) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xfdffffff))
#define SET_IRQ_MS_TIMER2_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 26) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xfbffffff))
#define SET_IRQ_MS_TIMER3_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 27) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xf7ffffff))
#define SET_IRQ_TX_LIMIT_INT_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 28) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xefffffff))
#define SET_IRQ_DMA0_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 29) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xdfffffff))
#define SET_IRQ_CO_DMA_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 30) | ((REG32(ADR_SDIO_IRQ_STS)) & 0xbfffffff))
#define SET_IRQ_PERI_GROUP_SD(_VAL_) (REG32(ADR_SDIO_IRQ_STS)) = (((_VAL_) << 31) | ((REG32(ADR_SDIO_IRQ_STS)) & 0x7fffffff))
#define SET_INT_PERI_MASK_SD(_VAL_) (REG32(ADR_SD_PERI_MASK)) = (((_VAL_) << 0) | ((REG32(ADR_SD_PERI_MASK)) & 0x00000000))
#define SET_PERI_RTC_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 0) | ((REG32(ADR_SD_PERI_STS)) & 0xfffffffe))
#define SET_IRQ_UART0_TX_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 1) | ((REG32(ADR_SD_PERI_STS)) & 0xfffffffd))
#define SET_IRQ_UART0_RX_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 2) | ((REG32(ADR_SD_PERI_STS)) & 0xfffffffb))
#define SET_PERI_GPI_SD_2(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 3) | ((REG32(ADR_SD_PERI_STS)) & 0xfffffff7))
#define SET_IRQ_SPI_IPC_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 4) | ((REG32(ADR_SD_PERI_STS)) & 0xffffffef))
#define SET_PERI_GPI_SD_1_0(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 5) | ((REG32(ADR_SD_PERI_STS)) & 0xffffff9f))
#define SET_SCRT_INT_1_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 7) | ((REG32(ADR_SD_PERI_STS)) & 0xffffff7f))
#define SET_MMU_ALC_ERR_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 8) | ((REG32(ADR_SD_PERI_STS)) & 0xfffffeff))
#define SET_MMU_RLS_ERR_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 9) | ((REG32(ADR_SD_PERI_STS)) & 0xfffffdff))
#define SET_ID_MNG_INT_1_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 10) | ((REG32(ADR_SD_PERI_STS)) & 0xfffffbff))
#define SET_MBOX_INT_1_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 11) | ((REG32(ADR_SD_PERI_STS)) & 0xfffff7ff))
#define SET_MBOX_INT_2_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 12) | ((REG32(ADR_SD_PERI_STS)) & 0xffffefff))
#define SET_MBOX_INT_3_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 13) | ((REG32(ADR_SD_PERI_STS)) & 0xffffdfff))
#define SET_HCI_INT_1_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 14) | ((REG32(ADR_SD_PERI_STS)) & 0xffffbfff))
#define SET_UART_RX_TIMEOUT_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 15) | ((REG32(ADR_SD_PERI_STS)) & 0xffff7fff))
#define SET_UART_MULTI_IRQ_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 16) | ((REG32(ADR_SD_PERI_STS)) & 0xfffeffff))
#define SET_ID_MNG_INT_2_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 17) | ((REG32(ADR_SD_PERI_STS)) & 0xfffdffff))
#define SET_DMN_NOHIT_INT_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 18) | ((REG32(ADR_SD_PERI_STS)) & 0xfffbffff))
#define SET_ID_THOLD_RX_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 19) | ((REG32(ADR_SD_PERI_STS)) & 0xfff7ffff))
#define SET_ID_THOLD_TX_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 20) | ((REG32(ADR_SD_PERI_STS)) & 0xffefffff))
#define SET_ID_DOUBLE_RLS_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 21) | ((REG32(ADR_SD_PERI_STS)) & 0xffdfffff))
#define SET_RX_ID_LEN_THOLD_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 22) | ((REG32(ADR_SD_PERI_STS)) & 0xffbfffff))
#define SET_TX_ID_LEN_THOLD_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 23) | ((REG32(ADR_SD_PERI_STS)) & 0xff7fffff))
#define SET_ALL_ID_LEN_THOLD_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 24) | ((REG32(ADR_SD_PERI_STS)) & 0xfeffffff))
#define SET_DMN_MCU_INT_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 25) | ((REG32(ADR_SD_PERI_STS)) & 0xfdffffff))
#define SET_IRQ_DAT_UART_TX_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 26) | ((REG32(ADR_SD_PERI_STS)) & 0xfbffffff))
#define SET_IRQ_DAT_UART_RX_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 27) | ((REG32(ADR_SD_PERI_STS)) & 0xf7ffffff))
#define SET_DAT_UART_RX_TIMEOUT_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 28) | ((REG32(ADR_SD_PERI_STS)) & 0xefffffff))
#define SET_DAT_UART_MULTI_IRQ_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 29) | ((REG32(ADR_SD_PERI_STS)) & 0xdfffffff))
#define SET_ALR_ABT_NOCHG_INT_IRQ_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 30) | ((REG32(ADR_SD_PERI_STS)) & 0xbfffffff))
#define SET_TBLNEQ_MNGPKT_INT_IRQ_SD(_VAL_) (REG32(ADR_SD_PERI_STS)) = (((_VAL_) << 31) | ((REG32(ADR_SD_PERI_STS)) & 0x7fffffff))
#define SET_DBG_SPI_MODE(_VAL_) (REG32(ADR_DBG_SPI_MODE)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_SPI_MODE)) & 0x00000000))
#define SET_DBG_RX_QUOTA(_VAL_) (REG32(ADR_DBG_RX_QUOTA)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_RX_QUOTA)) & 0xffff0000))
#define SET_DBG_CONDI_NUM(_VAL_) (REG32(ADR_DBG_CONDITION_NUMBER)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_CONDITION_NUMBER)) & 0xffffff00))
#define SET_DBG_HOST_PATH(_VAL_) (REG32(ADR_DBG_HOST_PATH)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_HOST_PATH)) & 0xfffffffe))
#define SET_DBG_TX_SEG(_VAL_) (REG32(ADR_DBG_TX_SEG)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_TX_SEG)) & 0x00000000))
#define SET_DBG_BRST_MODE(_VAL_) (REG32(ADR_DBG_DEBUG_BURST_MODE)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_DEBUG_BURST_MODE)) & 0xfffffffe))
#define SET_DBG_CLK_WIDTH(_VAL_) (REG32(ADR_DBG_SPI_TO_PHY_PARAM1)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_SPI_TO_PHY_PARAM1)) & 0xffff0000))
#define SET_DBG_CSN_INTER(_VAL_) (REG32(ADR_DBG_SPI_TO_PHY_PARAM1)) = (((_VAL_) << 16) | ((REG32(ADR_DBG_SPI_TO_PHY_PARAM1)) & 0x0000ffff))
#define SET_DBG_BACK_DLY(_VAL_) (REG32(ADR_DBG_SPI_TO_PHY_PARAM2)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_SPI_TO_PHY_PARAM2)) & 0xffff0000))
#define SET_DBG_FRONT_DLY(_VAL_) (REG32(ADR_DBG_SPI_TO_PHY_PARAM2)) = (((_VAL_) << 16) | ((REG32(ADR_DBG_SPI_TO_PHY_PARAM2)) & 0x0000ffff))
#define SET_DBG_RX_FIFO_FAIL(_VAL_) (REG32(ADR_DBG_SPI_STS)) = (((_VAL_) << 1) | ((REG32(ADR_DBG_SPI_STS)) & 0xfffffffd))
#define SET_DBG_RX_HOST_FAIL(_VAL_) (REG32(ADR_DBG_SPI_STS)) = (((_VAL_) << 2) | ((REG32(ADR_DBG_SPI_STS)) & 0xfffffffb))
#define SET_DBG_TX_FIFO_FAIL(_VAL_) (REG32(ADR_DBG_SPI_STS)) = (((_VAL_) << 3) | ((REG32(ADR_DBG_SPI_STS)) & 0xfffffff7))
#define SET_DBG_TX_HOST_FAIL(_VAL_) (REG32(ADR_DBG_SPI_STS)) = (((_VAL_) << 4) | ((REG32(ADR_DBG_SPI_STS)) & 0xffffffef))
#define SET_DBG_SPI_DOUBLE_ALLOC(_VAL_) (REG32(ADR_DBG_SPI_STS)) = (((_VAL_) << 5) | ((REG32(ADR_DBG_SPI_STS)) & 0xffffffdf))
#define SET_DBG_SPI_TX_NO_ALLOC(_VAL_) (REG32(ADR_DBG_SPI_STS)) = (((_VAL_) << 6) | ((REG32(ADR_DBG_SPI_STS)) & 0xffffffbf))
#define SET_DBG_RDATA_RDY(_VAL_) (REG32(ADR_DBG_SPI_STS)) = (((_VAL_) << 7) | ((REG32(ADR_DBG_SPI_STS)) & 0xffffff7f))
#define SET_DBG_SPI_ALLOC_STATUS(_VAL_) (REG32(ADR_DBG_SPI_STS)) = (((_VAL_) << 8) | ((REG32(ADR_DBG_SPI_STS)) & 0xfffffeff))
#define SET_DBG_SPI_DBG_WR_FIFO_FULL(_VAL_) (REG32(ADR_DBG_SPI_STS)) = (((_VAL_) << 9) | ((REG32(ADR_DBG_SPI_STS)) & 0xfffffdff))
#define SET_DBG_RX_LEN(_VAL_) (REG32(ADR_DBG_SPI_STS)) = (((_VAL_) << 16) | ((REG32(ADR_DBG_SPI_STS)) & 0x0000ffff))
#define SET_DBG_SPI_TX_ALLOC_SIZE_SHIFT_BITS(_VAL_) (REG32(ADR_DBG_TX_ALLOC_SET)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_TX_ALLOC_SET)) & 0xfffffff8))
#define SET_DBG_SPI_HOST_TX_ALLOC_PKBUF(_VAL_) (REG32(ADR_DBG_TX_ALLOC_SET)) = (((_VAL_) << 8) | ((REG32(ADR_DBG_TX_ALLOC_SET)) & 0xfffffeff))
#define SET_DBG_SPI_TX_ALLOC_SIZE(_VAL_) (REG32(ADR_DBG_TX_ALLOC)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_TX_ALLOC)) & 0xffffff00))
#define SET_DBG_RD_DAT_CNT(_VAL_) (REG32(ADR_DBG_DBG_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_DBG_CNT)) & 0xffff0000))
#define SET_DBG_RD_STS_CNT(_VAL_) (REG32(ADR_DBG_DBG_CNT)) = (((_VAL_) << 16) | ((REG32(ADR_DBG_DBG_CNT)) & 0x0000ffff))
#define SET_DBG_JUDGE_CNT(_VAL_) (REG32(ADR_DBG_DBG_CNT2)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_DBG_CNT2)) & 0xffff0000))
#define SET_DBG_RD_STS_CNT_CLR(_VAL_) (REG32(ADR_DBG_DBG_CNT2)) = (((_VAL_) << 16) | ((REG32(ADR_DBG_DBG_CNT2)) & 0xfffeffff))
#define SET_DBG_RD_DAT_CNT_CLR(_VAL_) (REG32(ADR_DBG_DBG_CNT2)) = (((_VAL_) << 17) | ((REG32(ADR_DBG_DBG_CNT2)) & 0xfffdffff))
#define SET_DBG_JUDGE_CNT_CLR(_VAL_) (REG32(ADR_DBG_DBG_CNT2)) = (((_VAL_) << 18) | ((REG32(ADR_DBG_DBG_CNT2)) & 0xfffbffff))
#define SET_DBG_TX_DONE_CNT(_VAL_) (REG32(ADR_DBG_DBG_CNT3)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_DBG_CNT3)) & 0xffff0000))
#define SET_DBG_TX_DISCARD_CNT(_VAL_) (REG32(ADR_DBG_DBG_CNT3)) = (((_VAL_) << 16) | ((REG32(ADR_DBG_DBG_CNT3)) & 0x0000ffff))
#define SET_DBG_TX_SET_CNT(_VAL_) (REG32(ADR_DBG_DBG_CNT4)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_DBG_CNT4)) & 0xffff0000))
#define SET_DBG_TX_DISCARD_CNT_CLR(_VAL_) (REG32(ADR_DBG_DBG_CNT4)) = (((_VAL_) << 16) | ((REG32(ADR_DBG_DBG_CNT4)) & 0xfffeffff))
#define SET_DBG_TX_DONE_CNT_CLR(_VAL_) (REG32(ADR_DBG_DBG_CNT4)) = (((_VAL_) << 17) | ((REG32(ADR_DBG_DBG_CNT4)) & 0xfffdffff))
#define SET_DBG_TX_SET_CNT_CLR(_VAL_) (REG32(ADR_DBG_DBG_CNT4)) = (((_VAL_) << 18) | ((REG32(ADR_DBG_DBG_CNT4)) & 0xfffbffff))
#define SET_DBG_DAT_MODE_OFF(_VAL_) (REG32(ADR_DBG_DBG_CNT4)) = (((_VAL_) << 19) | ((REG32(ADR_DBG_DBG_CNT4)) & 0xfff7ffff))
#define SET_DBG_TX_FIFO_RESIDUE(_VAL_) (REG32(ADR_DBG_DBG_CNT4)) = (((_VAL_) << 20) | ((REG32(ADR_DBG_DBG_CNT4)) & 0xff8fffff))
#define SET_DBG_RX_FIFO_RESIDUE(_VAL_) (REG32(ADR_DBG_DBG_CNT4)) = (((_VAL_) << 24) | ((REG32(ADR_DBG_DBG_CNT4)) & 0xf8ffffff))
#define SET_DBG_RX_RDY(_VAL_) (REG32(ADR_DBG_INT_TAG)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_INT_TAG)) & 0xfffffffe))
#define SET_DBG_SDIO_SYS_INT(_VAL_) (REG32(ADR_DBG_INT_TAG)) = (((_VAL_) << 2) | ((REG32(ADR_DBG_INT_TAG)) & 0xfffffffb))
#define SET_DBG_EDCA0_LOWTHOLD_INT(_VAL_) (REG32(ADR_DBG_INT_TAG)) = (((_VAL_) << 3) | ((REG32(ADR_DBG_INT_TAG)) & 0xfffffff7))
#define SET_DBG_EDCA1_LOWTHOLD_INT(_VAL_) (REG32(ADR_DBG_INT_TAG)) = (((_VAL_) << 4) | ((REG32(ADR_DBG_INT_TAG)) & 0xffffffef))
#define SET_DBG_EDCA2_LOWTHOLD_INT(_VAL_) (REG32(ADR_DBG_INT_TAG)) = (((_VAL_) << 5) | ((REG32(ADR_DBG_INT_TAG)) & 0xffffffdf))
#define SET_DBG_EDCA3_LOWTHOLD_INT(_VAL_) (REG32(ADR_DBG_INT_TAG)) = (((_VAL_) << 6) | ((REG32(ADR_DBG_INT_TAG)) & 0xffffffbf))
#define SET_DBG_TX_LIMIT_INT_IN(_VAL_) (REG32(ADR_DBG_INT_TAG)) = (((_VAL_) << 7) | ((REG32(ADR_DBG_INT_TAG)) & 0xffffff7f))
#define SET_DBG_SPI_FN1(_VAL_) (REG32(ADR_DBG_INT_TAG)) = (((_VAL_) << 8) | ((REG32(ADR_DBG_INT_TAG)) & 0xffff80ff))
#define SET_DBG_SPI_CLK_EN_INT(_VAL_) (REG32(ADR_DBG_INT_TAG)) = (((_VAL_) << 15) | ((REG32(ADR_DBG_INT_TAG)) & 0xffff7fff))
#define SET_DBG_SPI_HOST_MASK(_VAL_) (REG32(ADR_DBG_INT_TAG)) = (((_VAL_) << 16) | ((REG32(ADR_DBG_INT_TAG)) & 0xff00ffff))
#define SET_BOOT_ADDR(_VAL_) (REG32(ADR_BOOT_ADDR)) = (((_VAL_) << 0) | ((REG32(ADR_BOOT_ADDR)) & 0xff000000))
#define SET_CHECK_SUM_FAIL(_VAL_) (REG32(ADR_BOOT_ADDR)) = (((_VAL_) << 31) | ((REG32(ADR_BOOT_ADDR)) & 0x7fffffff))
#define SET_VERIFY_DATA(_VAL_) (REG32(ADR_VERIFY_DATA)) = (((_VAL_) << 0) | ((REG32(ADR_VERIFY_DATA)) & 0x00000000))
#define SET_FLASH_ADDR(_VAL_) (REG32(ADR_FLASH_ADDR)) = (((_VAL_) << 0) | ((REG32(ADR_FLASH_ADDR)) & 0xff000000))
#define SET_FLASH_CMD_CLR(_VAL_) (REG32(ADR_FLASH_ADDR)) = (((_VAL_) << 28) | ((REG32(ADR_FLASH_ADDR)) & 0xefffffff))
#define SET_FLASH_DMA_CLR(_VAL_) (REG32(ADR_FLASH_ADDR)) = (((_VAL_) << 29) | ((REG32(ADR_FLASH_ADDR)) & 0xdfffffff))
#define SET_DMA_EN(_VAL_) (REG32(ADR_FLASH_ADDR)) = (((_VAL_) << 30) | ((REG32(ADR_FLASH_ADDR)) & 0xbfffffff))
#define SET_DMA_BUSY(_VAL_) (REG32(ADR_FLASH_ADDR)) = (((_VAL_) << 31) | ((REG32(ADR_FLASH_ADDR)) & 0x7fffffff))
#define SET_SRAM_ADDR(_VAL_) (REG32(ADR_SRAM_ADDR)) = (((_VAL_) << 0) | ((REG32(ADR_SRAM_ADDR)) & 0x00000000))
#define SET_FLASH_DMA_LEN(_VAL_) (REG32(ADR_LEN)) = (((_VAL_) << 0) | ((REG32(ADR_LEN)) & 0x00000000))
#define SET_FLASH_FRONT_DLY(_VAL_) (REG32(ADR_SPI_PARAM)) = (((_VAL_) << 0) | ((REG32(ADR_SPI_PARAM)) & 0xffff0000))
#define SET_FLASH_BACK_DLY(_VAL_) (REG32(ADR_SPI_PARAM)) = (((_VAL_) << 16) | ((REG32(ADR_SPI_PARAM)) & 0x0000ffff))
#define SET_FLASH_CLK_WIDTH(_VAL_) (REG32(ADR_SPI_PARAM2)) = (((_VAL_) << 0) | ((REG32(ADR_SPI_PARAM2)) & 0xffff0000))
#define SET_SPI_BUSY(_VAL_) (REG32(ADR_SPI_PARAM2)) = (((_VAL_) << 16) | ((REG32(ADR_SPI_PARAM2)) & 0xfffeffff))
#define SET_FLS_REMAP(_VAL_) (REG32(ADR_SPI_PARAM2)) = (((_VAL_) << 17) | ((REG32(ADR_SPI_PARAM2)) & 0xfffdffff))
#define SET_PBUS_SWP(_VAL_) (REG32(ADR_SPI_PARAM2)) = (((_VAL_) << 18) | ((REG32(ADR_SPI_PARAM2)) & 0xfffbffff))
#define SET_BIT_MODE1(_VAL_) (REG32(ADR_SPI_PARAM2)) = (((_VAL_) << 19) | ((REG32(ADR_SPI_PARAM2)) & 0xfff7ffff))
#define SET_BIT_MODE2(_VAL_) (REG32(ADR_SPI_PARAM2)) = (((_VAL_) << 20) | ((REG32(ADR_SPI_PARAM2)) & 0xffefffff))
#define SET_BIT_MODE4(_VAL_) (REG32(ADR_SPI_PARAM2)) = (((_VAL_) << 21) | ((REG32(ADR_SPI_PARAM2)) & 0xffdfffff))
#define SET_BOOT_CHECK_SUM(_VAL_) (REG32(ADR_CHECK_SUM_RESULT)) = (((_VAL_) << 0) | ((REG32(ADR_CHECK_SUM_RESULT)) & 0x00000000))
#define SET_CHECK_SUM_TAG(_VAL_) (REG32(ADR_CHECK_SUM_IN_FILE)) = (((_VAL_) << 0) | ((REG32(ADR_CHECK_SUM_IN_FILE)) & 0x00000000))
#define SET_CMD_LEN(_VAL_) (REG32(ADR_COMMAND_LEN)) = (((_VAL_) << 0) | ((REG32(ADR_COMMAND_LEN)) & 0xffff0000))
#define SET_CMD_ADDR(_VAL_) (REG32(ADR_COMMAND_ADDR)) = (((_VAL_) << 0) | ((REG32(ADR_COMMAND_ADDR)) & 0x00000000))
#define SET_DMA_ADR_SRC(_VAL_) (REG32(ADR_DMA_ADR_SRC)) = (((_VAL_) << 0) | ((REG32(ADR_DMA_ADR_SRC)) & 0x00000000))
#define SET_DMA_ADR_DST(_VAL_) (REG32(ADR_DMA_ADR_DST)) = (((_VAL_) << 0) | ((REG32(ADR_DMA_ADR_DST)) & 0x00000000))
#define SET_DMA_SRC_SIZE(_VAL_) (REG32(ADR_DMA_CTRL)) = (((_VAL_) << 0) | ((REG32(ADR_DMA_CTRL)) & 0xfffffff8))
#define SET_DMA_SRC_INC(_VAL_) (REG32(ADR_DMA_CTRL)) = (((_VAL_) << 3) | ((REG32(ADR_DMA_CTRL)) & 0xfffffff7))
#define SET_DMA_DST_SIZE(_VAL_) (REG32(ADR_DMA_CTRL)) = (((_VAL_) << 4) | ((REG32(ADR_DMA_CTRL)) & 0xffffff8f))
#define SET_DMA_DST_INC(_VAL_) (REG32(ADR_DMA_CTRL)) = (((_VAL_) << 7) | ((REG32(ADR_DMA_CTRL)) & 0xffffff7f))
#define SET_DMA_FAST_FILL(_VAL_) (REG32(ADR_DMA_CTRL)) = (((_VAL_) << 8) | ((REG32(ADR_DMA_CTRL)) & 0xfffffeff))
#define SET_DMA_SDIO_KICK(_VAL_) (REG32(ADR_DMA_CTRL)) = (((_VAL_) << 12) | ((REG32(ADR_DMA_CTRL)) & 0xffffefff))
#define SET_DMA_BADR_EN(_VAL_) (REG32(ADR_DMA_CTRL)) = (((_VAL_) << 13) | ((REG32(ADR_DMA_CTRL)) & 0xffffdfff))
#define SET_DMA_LEN(_VAL_) (REG32(ADR_DMA_CTRL)) = (((_VAL_) << 16) | ((REG32(ADR_DMA_CTRL)) & 0x0000ffff))
#define SET_DMA_INT_MASK(_VAL_) (REG32(ADR_DMA_INT)) = (((_VAL_) << 0) | ((REG32(ADR_DMA_INT)) & 0xfffffffe))
#define SET_DMA_STS(_VAL_) (REG32(ADR_DMA_INT)) = (((_VAL_) << 8) | ((REG32(ADR_DMA_INT)) & 0xfffffeff))
#define SET_DMA_FINISH(_VAL_) (REG32(ADR_DMA_INT)) = (((_VAL_) << 31) | ((REG32(ADR_DMA_INT)) & 0x7fffffff))
#define SET_DMA_CONST(_VAL_) (REG32(ADR_DMA_FILL_CONST)) = (((_VAL_) << 0) | ((REG32(ADR_DMA_FILL_CONST)) & 0x00000000))
#define SET_SLEEP_WAKE_CNT(_VAL_) (REG32(ADR_PMU_0)) = (((_VAL_) << 0) | ((REG32(ADR_PMU_0)) & 0xff000000))
#define SET_RG_DLDO_LEVEL(_VAL_) (REG32(ADR_PMU_0)) = (((_VAL_) << 24) | ((REG32(ADR_PMU_0)) & 0xf8ffffff))
#define SET_RG_DLDO_BOOST_IQ(_VAL_) (REG32(ADR_PMU_0)) = (((_VAL_) << 27) | ((REG32(ADR_PMU_0)) & 0xf7ffffff))
#define SET_RG_BUCK_LEVEL(_VAL_) (REG32(ADR_PMU_0)) = (((_VAL_) << 28) | ((REG32(ADR_PMU_0)) & 0x8fffffff))
#define SET_RG_BUCK_VREF_SEL(_VAL_) (REG32(ADR_PMU_0)) = (((_VAL_) << 31) | ((REG32(ADR_PMU_0)) & 0x7fffffff))
#define SET_RG_RTC_OSC_RES_SW_MANUAL(_VAL_) (REG32(ADR_PMU_1)) = (((_VAL_) << 0) | ((REG32(ADR_PMU_1)) & 0xfffffc00))
#define SET_RG_RTC_OSC_RES_SW(_VAL_) (REG32(ADR_PMU_1)) = (((_VAL_) << 16) | ((REG32(ADR_PMU_1)) & 0xfc00ffff))
#define SET_RTC_OSC_CAL_RES_RDY(_VAL_) (REG32(ADR_PMU_1)) = (((_VAL_) << 31) | ((REG32(ADR_PMU_1)) & 0x7fffffff))
#define SET_RG_DCDC_MODE(_VAL_) (REG32(ADR_PMU_2)) = (((_VAL_) << 0) | ((REG32(ADR_PMU_2)) & 0xfffffffe))
#define SET_RG_BUCK_EN_PSM(_VAL_) (REG32(ADR_PMU_2)) = (((_VAL_) << 4) | ((REG32(ADR_PMU_2)) & 0xffffffef))
#define SET_RG_BUCK_PSM_VTH(_VAL_) (REG32(ADR_PMU_2)) = (((_VAL_) << 8) | ((REG32(ADR_PMU_2)) & 0xfffffeff))
#define SET_RG_RTC_OSC_RES_SW_MANUAL_EN(_VAL_) (REG32(ADR_PMU_2)) = (((_VAL_) << 12) | ((REG32(ADR_PMU_2)) & 0xffffefff))
#define SET_RG_RTC_RDY_DEGLITCH_TIMER(_VAL_) (REG32(ADR_PMU_2)) = (((_VAL_) << 13) | ((REG32(ADR_PMU_2)) & 0xffff9fff))
#define SET_RTC_CAL_ENA(_VAL_) (REG32(ADR_PMU_2)) = (((_VAL_) << 16) | ((REG32(ADR_PMU_2)) & 0xfffeffff))
#define SET_PMU_WAKE_TRIG_EVENT(_VAL_) (REG32(ADR_PMU_3)) = (((_VAL_) << 0) | ((REG32(ADR_PMU_3)) & 0xfffffffc))
#define SET_DIGI_TOP_POR_MASK(_VAL_) (REG32(ADR_PMU_3)) = (((_VAL_) << 4) | ((REG32(ADR_PMU_3)) & 0xffffffef))
#define SET_PMU_ENTER_SLEEP_MODE(_VAL_) (REG32(ADR_PMU_3)) = (((_VAL_) << 8) | ((REG32(ADR_PMU_3)) & 0xfffffeff))
#define SET_RG_RTC_DUMMIES(_VAL_) (REG32(ADR_PMU_3)) = (((_VAL_) << 16) | ((REG32(ADR_PMU_3)) & 0x0000ffff))
#define SET_RTC_EN(_VAL_) (REG32(ADR_RTC_1)) = (((_VAL_) << 0) | ((REG32(ADR_RTC_1)) & 0xfffffffe))
#define SET_RTC_SRC(_VAL_) (REG32(ADR_RTC_1)) = (((_VAL_) << 1) | ((REG32(ADR_RTC_1)) & 0xfffffffd))
#define SET_RTC_TICK_CNT(_VAL_) (REG32(ADR_RTC_1)) = (((_VAL_) << 16) | ((REG32(ADR_RTC_1)) & 0x8000ffff))
#define SET_RTC_INT_SEC_MASK(_VAL_) (REG32(ADR_RTC_2)) = (((_VAL_) << 0) | ((REG32(ADR_RTC_2)) & 0xfffffffe))
#define SET_RTC_INT_ALARM_MASK(_VAL_) (REG32(ADR_RTC_2)) = (((_VAL_) << 1) | ((REG32(ADR_RTC_2)) & 0xfffffffd))
#define SET_RTC_INT_SEC(_VAL_) (REG32(ADR_RTC_2)) = (((_VAL_) << 16) | ((REG32(ADR_RTC_2)) & 0xfffeffff))
#define SET_RTC_INT_ALARM(_VAL_) (REG32(ADR_RTC_2)) = (((_VAL_) << 17) | ((REG32(ADR_RTC_2)) & 0xfffdffff))
#define SET_RTC_SEC_START_CNT(_VAL_) (REG32(ADR_RTC_3W)) = (((_VAL_) << 0) | ((REG32(ADR_RTC_3W)) & 0x00000000))
#define SET_RTC_SEC_CNT(_VAL_) (REG32(ADR_RTC_3R)) = (((_VAL_) << 0) | ((REG32(ADR_RTC_3R)) & 0x00000000))
#define SET_RTC_SEC_ALARM_VALUE(_VAL_) (REG32(ADR_RTC_4)) = (((_VAL_) << 0) | ((REG32(ADR_RTC_4)) & 0x00000000))
#define SET_D2_DMA_ADR_SRC(_VAL_) (REG32(ADR_D2_DMA_ADR_SRC)) = (((_VAL_) << 0) | ((REG32(ADR_D2_DMA_ADR_SRC)) & 0x00000000))
#define SET_D2_DMA_ADR_DST(_VAL_) (REG32(ADR_D2_DMA_ADR_DST)) = (((_VAL_) << 0) | ((REG32(ADR_D2_DMA_ADR_DST)) & 0x00000000))
#define SET_D2_DMA_SRC_SIZE(_VAL_) (REG32(ADR_D2_DMA_CTRL)) = (((_VAL_) << 0) | ((REG32(ADR_D2_DMA_CTRL)) & 0xfffffff8))
#define SET_D2_DMA_SRC_INC(_VAL_) (REG32(ADR_D2_DMA_CTRL)) = (((_VAL_) << 3) | ((REG32(ADR_D2_DMA_CTRL)) & 0xfffffff7))
#define SET_D2_DMA_DST_SIZE(_VAL_) (REG32(ADR_D2_DMA_CTRL)) = (((_VAL_) << 4) | ((REG32(ADR_D2_DMA_CTRL)) & 0xffffff8f))
#define SET_D2_DMA_DST_INC(_VAL_) (REG32(ADR_D2_DMA_CTRL)) = (((_VAL_) << 7) | ((REG32(ADR_D2_DMA_CTRL)) & 0xffffff7f))
#define SET_D2_DMA_FAST_FILL(_VAL_) (REG32(ADR_D2_DMA_CTRL)) = (((_VAL_) << 8) | ((REG32(ADR_D2_DMA_CTRL)) & 0xfffffeff))
#define SET_D2_DMA_SDIO_KICK(_VAL_) (REG32(ADR_D2_DMA_CTRL)) = (((_VAL_) << 12) | ((REG32(ADR_D2_DMA_CTRL)) & 0xffffefff))
#define SET_D2_DMA_BADR_EN(_VAL_) (REG32(ADR_D2_DMA_CTRL)) = (((_VAL_) << 13) | ((REG32(ADR_D2_DMA_CTRL)) & 0xffffdfff))
#define SET_D2_DMA_LEN(_VAL_) (REG32(ADR_D2_DMA_CTRL)) = (((_VAL_) << 16) | ((REG32(ADR_D2_DMA_CTRL)) & 0x0000ffff))
#define SET_D2_DMA_INT_MASK(_VAL_) (REG32(ADR_D2_DMA_INT)) = (((_VAL_) << 0) | ((REG32(ADR_D2_DMA_INT)) & 0xfffffffe))
#define SET_D2_DMA_STS(_VAL_) (REG32(ADR_D2_DMA_INT)) = (((_VAL_) << 8) | ((REG32(ADR_D2_DMA_INT)) & 0xfffffeff))
#define SET_D2_DMA_FINISH(_VAL_) (REG32(ADR_D2_DMA_INT)) = (((_VAL_) << 31) | ((REG32(ADR_D2_DMA_INT)) & 0x7fffffff))
#define SET_D2_DMA_CONST(_VAL_) (REG32(ADR_D2_DMA_FILL_CONST)) = (((_VAL_) << 0) | ((REG32(ADR_D2_DMA_FILL_CONST)) & 0x00000000))
#define SET_TRAP_UNKNOWN_TYPE(_VAL_) (REG32(ADR_CONTROL)) = (((_VAL_) << 0) | ((REG32(ADR_CONTROL)) & 0xfffffffe))
#define SET_TX_ON_DEMAND_ENA(_VAL_) (REG32(ADR_CONTROL)) = (((_VAL_) << 1) | ((REG32(ADR_CONTROL)) & 0xfffffffd))
#define SET_RX_2_HOST(_VAL_) (REG32(ADR_CONTROL)) = (((_VAL_) << 2) | ((REG32(ADR_CONTROL)) & 0xfffffffb))
#define SET_AUTO_SEQNO(_VAL_) (REG32(ADR_CONTROL)) = (((_VAL_) << 3) | ((REG32(ADR_CONTROL)) & 0xfffffff7))
#define SET_BYPASSS_TX_PARSER_ENCAP(_VAL_) (REG32(ADR_CONTROL)) = (((_VAL_) << 4) | ((REG32(ADR_CONTROL)) & 0xffffffef))
#define SET_HDR_STRIP(_VAL_) (REG32(ADR_CONTROL)) = (((_VAL_) << 5) | ((REG32(ADR_CONTROL)) & 0xffffffdf))
#define SET_ERP_PROTECT(_VAL_) (REG32(ADR_CONTROL)) = (((_VAL_) << 6) | ((REG32(ADR_CONTROL)) & 0xffffff3f))
#define SET_PRO_VER(_VAL_) (REG32(ADR_CONTROL)) = (((_VAL_) << 8) | ((REG32(ADR_CONTROL)) & 0xfffffcff))
#define SET_TXQ_ID0(_VAL_) (REG32(ADR_CONTROL)) = (((_VAL_) << 12) | ((REG32(ADR_CONTROL)) & 0xffff8fff))
#define SET_TXQ_ID1(_VAL_) (REG32(ADR_CONTROL)) = (((_VAL_) << 16) | ((REG32(ADR_CONTROL)) & 0xfff8ffff))
#define SET_TX_ETHER_TRAP_EN(_VAL_) (REG32(ADR_CONTROL)) = (((_VAL_) << 20) | ((REG32(ADR_CONTROL)) & 0xffefffff))
#define SET_RX_ETHER_TRAP_EN(_VAL_) (REG32(ADR_CONTROL)) = (((_VAL_) << 21) | ((REG32(ADR_CONTROL)) & 0xffdfffff))
#define SET_RX_NULL_TRAP_EN(_VAL_) (REG32(ADR_CONTROL)) = (((_VAL_) << 22) | ((REG32(ADR_CONTROL)) & 0xffbfffff))
#define SET_RX_GET_TX_QUEUE_EN(_VAL_) (REG32(ADR_CONTROL)) = (((_VAL_) << 25) | ((REG32(ADR_CONTROL)) & 0xfdffffff))
#define SET_HCI_INQ_SEL(_VAL_) (REG32(ADR_CONTROL)) = (((_VAL_) << 26) | ((REG32(ADR_CONTROL)) & 0xfbffffff))
#define SET_TRX_DEBUG_CNT_ENA(_VAL_) (REG32(ADR_CONTROL)) = (((_VAL_) << 28) | ((REG32(ADR_CONTROL)) & 0xefffffff))
#define SET_WAKE_SOON_WITH_SCK(_VAL_) (REG32(ADR_SDIO_WAKE_MODE)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_WAKE_MODE)) & 0xfffffffe))
#define SET_TX_FLOW_CTRL(_VAL_) (REG32(ADR_TX_FLOW_0)) = (((_VAL_) << 0) | ((REG32(ADR_TX_FLOW_0)) & 0xffff0000))
#define SET_TX_FLOW_MGMT(_VAL_) (REG32(ADR_TX_FLOW_0)) = (((_VAL_) << 16) | ((REG32(ADR_TX_FLOW_0)) & 0x0000ffff))
#define SET_TX_FLOW_DATA(_VAL_) (REG32(ADR_TX_FLOW_1)) = (((_VAL_) << 0) | ((REG32(ADR_TX_FLOW_1)) & 0x00000000))
#define SET_DOT11RTSTHRESHOLD(_VAL_) (REG32(ADR_THREASHOLD)) = (((_VAL_) << 16) | ((REG32(ADR_THREASHOLD)) & 0x0000ffff))
#define SET_TXF_ID(_VAL_) (REG32(ADR_TXFID_INCREASE)) = (((_VAL_) << 0) | ((REG32(ADR_TXFID_INCREASE)) & 0xffffffc0))
#define SET_SEQ_CTRL(_VAL_) (REG32(ADR_GLOBAL_SEQUENCE)) = (((_VAL_) << 0) | ((REG32(ADR_GLOBAL_SEQUENCE)) & 0xffff0000))
#define SET_TX_PBOFFSET(_VAL_) (REG32(ADR_HCI_TX_RX_INFO_SIZE)) = (((_VAL_) << 0) | ((REG32(ADR_HCI_TX_RX_INFO_SIZE)) & 0xffffff00))
#define SET_TX_INFO_SIZE(_VAL_) (REG32(ADR_HCI_TX_RX_INFO_SIZE)) = (((_VAL_) << 8) | ((REG32(ADR_HCI_TX_RX_INFO_SIZE)) & 0xffff00ff))
#define SET_RX_INFO_SIZE(_VAL_) (REG32(ADR_HCI_TX_RX_INFO_SIZE)) = (((_VAL_) << 16) | ((REG32(ADR_HCI_TX_RX_INFO_SIZE)) & 0xff00ffff))
#define SET_RX_LAST_PHY_SIZE(_VAL_) (REG32(ADR_HCI_TX_RX_INFO_SIZE)) = (((_VAL_) << 24) | ((REG32(ADR_HCI_TX_RX_INFO_SIZE)) & 0x00ffffff))
#define SET_TX_INFO_CLEAR_SIZE(_VAL_) (REG32(ADR_HCI_TX_INFO_CLEAR)) = (((_VAL_) << 0) | ((REG32(ADR_HCI_TX_INFO_CLEAR)) & 0xffffffc0))
#define SET_TX_INFO_CLEAR_ENABLE(_VAL_) (REG32(ADR_HCI_TX_INFO_CLEAR)) = (((_VAL_) << 8) | ((REG32(ADR_HCI_TX_INFO_CLEAR)) & 0xfffffeff))
#define SET_TXTRAP_ETHTYPE1(_VAL_) (REG32(ADR_TX_ETHER_TYPE_1)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ETHER_TYPE_1)) & 0xffff0000))
#define SET_TXTRAP_ETHTYPE0(_VAL_) (REG32(ADR_TX_ETHER_TYPE_1)) = (((_VAL_) << 16) | ((REG32(ADR_TX_ETHER_TYPE_1)) & 0x0000ffff))
#define SET_RXTRAP_ETHTYPE1(_VAL_) (REG32(ADR_RX_ETHER_TYPE_1)) = (((_VAL_) << 0) | ((REG32(ADR_RX_ETHER_TYPE_1)) & 0xffff0000))
#define SET_RXTRAP_ETHTYPE0(_VAL_) (REG32(ADR_RX_ETHER_TYPE_1)) = (((_VAL_) << 16) | ((REG32(ADR_RX_ETHER_TYPE_1)) & 0x0000ffff))
#define SET_TX_PKT_COUNTER(_VAL_) (REG32(ADR_PACKET_COUNTER_INFO_0)) = (((_VAL_) << 0) | ((REG32(ADR_PACKET_COUNTER_INFO_0)) & 0x00000000))
#define SET_RX_PKT_COUNTER(_VAL_) (REG32(ADR_PACKET_COUNTER_INFO_1)) = (((_VAL_) << 0) | ((REG32(ADR_PACKET_COUNTER_INFO_1)) & 0x00000000))
#define SET_HOST_CMD_COUNTER(_VAL_) (REG32(ADR_PACKET_COUNTER_INFO_2)) = (((_VAL_) << 0) | ((REG32(ADR_PACKET_COUNTER_INFO_2)) & 0xffffff00))
#define SET_HOST_EVENT_COUNTER(_VAL_) (REG32(ADR_PACKET_COUNTER_INFO_3)) = (((_VAL_) << 0) | ((REG32(ADR_PACKET_COUNTER_INFO_3)) & 0xffffff00))
#define SET_TX_PKT_DROP_COUNTER(_VAL_) (REG32(ADR_PACKET_COUNTER_INFO_4)) = (((_VAL_) << 0) | ((REG32(ADR_PACKET_COUNTER_INFO_4)) & 0xffffff00))
#define SET_RX_PKT_DROP_COUNTER(_VAL_) (REG32(ADR_PACKET_COUNTER_INFO_5)) = (((_VAL_) << 0) | ((REG32(ADR_PACKET_COUNTER_INFO_5)) & 0xffffff00))
#define SET_TX_PKT_TRAP_COUNTER(_VAL_) (REG32(ADR_PACKET_COUNTER_INFO_6)) = (((_VAL_) << 0) | ((REG32(ADR_PACKET_COUNTER_INFO_6)) & 0xffffff00))
#define SET_RX_PKT_TRAP_COUNTER(_VAL_) (REG32(ADR_PACKET_COUNTER_INFO_7)) = (((_VAL_) << 0) | ((REG32(ADR_PACKET_COUNTER_INFO_7)) & 0xffffff00))
#define SET_HOST_TX_FAIL_COUNTER(_VAL_) (REG32(ADR_SDIO_TX_RX_FAIL_COUNTER_0)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_TX_RX_FAIL_COUNTER_0)) & 0xffffff00))
#define SET_HOST_RX_FAIL_COUNTER(_VAL_) (REG32(ADR_SDIO_TX_RX_FAIL_COUNTER_1)) = (((_VAL_) << 0) | ((REG32(ADR_SDIO_TX_RX_FAIL_COUNTER_1)) & 0xffffff00))
#define SET_HCI_STATE_MONITOR(_VAL_) (REG32(ADR_HCI_STATE_DEBUG_MODE_0)) = (((_VAL_) << 0) | ((REG32(ADR_HCI_STATE_DEBUG_MODE_0)) & 0x00000000))
#define SET_HCI_ST_TIMEOUT_MONITOR(_VAL_) (REG32(ADR_HCI_STATE_DEBUG_MODE_1)) = (((_VAL_) << 0) | ((REG32(ADR_HCI_STATE_DEBUG_MODE_1)) & 0x00000000))
#define SET_TX_ON_DEMAND_LENGTH(_VAL_) (REG32(ADR_HCI_STATE_DEBUG_MODE_2)) = (((_VAL_) << 0) | ((REG32(ADR_HCI_STATE_DEBUG_MODE_2)) & 0x00000000))
#define SET_HCI_MONITOR_REG1(_VAL_) (REG32(ADR_HCI_STATE_DEBUG_MODE_3)) = (((_VAL_) << 0) | ((REG32(ADR_HCI_STATE_DEBUG_MODE_3)) & 0x00000000))
#define SET_HCI_MONITOR_REG2(_VAL_) (REG32(ADR_HCI_STATE_DEBUG_MODE_4)) = (((_VAL_) << 0) | ((REG32(ADR_HCI_STATE_DEBUG_MODE_4)) & 0x00000000))
#define SET_HCI_TX_ALLOC_TIME_31_0(_VAL_) (REG32(ADR_HCI_STATE_DEBUG_MODE_5)) = (((_VAL_) << 0) | ((REG32(ADR_HCI_STATE_DEBUG_MODE_5)) & 0x00000000))
#define SET_HCI_TX_ALLOC_TIME_47_32(_VAL_) (REG32(ADR_HCI_STATE_DEBUG_MODE_6)) = (((_VAL_) << 0) | ((REG32(ADR_HCI_STATE_DEBUG_MODE_6)) & 0xffff0000))
#define SET_HCI_MB_MAX_CNT(_VAL_) (REG32(ADR_HCI_STATE_DEBUG_MODE_6)) = (((_VAL_) << 16) | ((REG32(ADR_HCI_STATE_DEBUG_MODE_6)) & 0xff00ffff))
#define SET_HCI_TX_ALLOC_CNT_31_0(_VAL_) (REG32(ADR_HCI_STATE_DEBUG_MODE_7)) = (((_VAL_) << 0) | ((REG32(ADR_HCI_STATE_DEBUG_MODE_7)) & 0x00000000))
#define SET_HCI_TX_ALLOC_CNT_47_32(_VAL_) (REG32(ADR_HCI_STATE_DEBUG_MODE_8)) = (((_VAL_) << 0) | ((REG32(ADR_HCI_STATE_DEBUG_MODE_8)) & 0xffff0000))
#define SET_HCI_PROC_CNT(_VAL_) (REG32(ADR_HCI_STATE_DEBUG_MODE_8)) = (((_VAL_) << 16) | ((REG32(ADR_HCI_STATE_DEBUG_MODE_8)) & 0xff00ffff))
#define SET_SDIO_TRANS_CNT(_VAL_) (REG32(ADR_HCI_STATE_DEBUG_MODE_8)) = (((_VAL_) << 24) | ((REG32(ADR_HCI_STATE_DEBUG_MODE_8)) & 0x00ffffff))
#define SET_SDIO_TX_INVALID_CNT_31_0(_VAL_) (REG32(ADR_HCI_STATE_DEBUG_MODE_9)) = (((_VAL_) << 0) | ((REG32(ADR_HCI_STATE_DEBUG_MODE_9)) & 0x00000000))
#define SET_SDIO_TX_INVALID_CNT_47_32(_VAL_) (REG32(ADR_HCI_STATE_DEBUG_MODE_10)) = (((_VAL_) << 0) | ((REG32(ADR_HCI_STATE_DEBUG_MODE_10)) & 0xffff0000))
#define SET_CS_START_ADDR(_VAL_) (REG32(ADR_CS_START_ADDR)) = (((_VAL_) << 0) | ((REG32(ADR_CS_START_ADDR)) & 0xffff0000))
#define SET_CS_PKT_ID(_VAL_) (REG32(ADR_CS_START_ADDR)) = (((_VAL_) << 16) | ((REG32(ADR_CS_START_ADDR)) & 0xff80ffff))
#define SET_ADD_LEN(_VAL_) (REG32(ADR_CS_ADD_LEN)) = (((_VAL_) << 0) | ((REG32(ADR_CS_ADD_LEN)) & 0xffff0000))
#define SET_CS_ADDER_EN(_VAL_) (REG32(ADR_CS_CMD)) = (((_VAL_) << 0) | ((REG32(ADR_CS_CMD)) & 0xfffffffe))
#define SET_PSEUDO(_VAL_) (REG32(ADR_CS_CMD)) = (((_VAL_) << 1) | ((REG32(ADR_CS_CMD)) & 0xfffffffd))
#define SET_CALCULATE(_VAL_) (REG32(ADR_CS_INI_BUF)) = (((_VAL_) << 0) | ((REG32(ADR_CS_INI_BUF)) & 0x00000000))
#define SET_L4_LEN(_VAL_) (REG32(ADR_CS_PSEUDO_BUF)) = (((_VAL_) << 0) | ((REG32(ADR_CS_PSEUDO_BUF)) & 0xffff0000))
#define SET_L4_PROTOL(_VAL_) (REG32(ADR_CS_PSEUDO_BUF)) = (((_VAL_) << 16) | ((REG32(ADR_CS_PSEUDO_BUF)) & 0xff00ffff))
#define SET_CHECK_SUM(_VAL_) (REG32(ADR_CS_CHECK_SUM)) = (((_VAL_) << 0) | ((REG32(ADR_CS_CHECK_SUM)) & 0xffff0000))
#define SET_RAND_EN(_VAL_) (REG32(ADR_RAND_EN)) = (((_VAL_) << 0) | ((REG32(ADR_RAND_EN)) & 0xfffffffe))
#define SET_RAND_NUM(_VAL_) (REG32(ADR_RAND_NUM)) = (((_VAL_) << 0) | ((REG32(ADR_RAND_NUM)) & 0x00000000))
#define SET_MUL_OP1(_VAL_) (REG32(ADR_MUL_OP1)) = (((_VAL_) << 0) | ((REG32(ADR_MUL_OP1)) & 0x00000000))
#define SET_MUL_OP2(_VAL_) (REG32(ADR_MUL_OP2)) = (((_VAL_) << 0) | ((REG32(ADR_MUL_OP2)) & 0x00000000))
#define SET_MUL_ANS0(_VAL_) (REG32(ADR_MUL_ANS0)) = (((_VAL_) << 0) | ((REG32(ADR_MUL_ANS0)) & 0x00000000))
#define SET_MUL_ANS1(_VAL_) (REG32(ADR_MUL_ANS1)) = (((_VAL_) << 0) | ((REG32(ADR_MUL_ANS1)) & 0x00000000))
#define SET_RD_ADDR(_VAL_) (REG32(ADR_DMA_RDATA)) = (((_VAL_) << 0) | ((REG32(ADR_DMA_RDATA)) & 0xffff0000))
#define SET_RD_ID(_VAL_) (REG32(ADR_DMA_RDATA)) = (((_VAL_) << 16) | ((REG32(ADR_DMA_RDATA)) & 0xff80ffff))
#define SET_WR_ADDR(_VAL_) (REG32(ADR_DMA_WDATA)) = (((_VAL_) << 0) | ((REG32(ADR_DMA_WDATA)) & 0xffff0000))
#define SET_WR_ID(_VAL_) (REG32(ADR_DMA_WDATA)) = (((_VAL_) << 16) | ((REG32(ADR_DMA_WDATA)) & 0xff80ffff))
#define SET_LEN(_VAL_) (REG32(ADR_DMA_LEN)) = (((_VAL_) << 0) | ((REG32(ADR_DMA_LEN)) & 0xffff0000))
#define SET_CLR(_VAL_) (REG32(ADR_DMA_CLR)) = (((_VAL_) << 0) | ((REG32(ADR_DMA_CLR)) & 0xfffffffe))
#define SET_PHY_MODE(_VAL_) (REG32(ADR_NAV_DATA)) = (((_VAL_) << 0) | ((REG32(ADR_NAV_DATA)) & 0xfffffffc))
#define SET_SHRT_PREAM(_VAL_) (REG32(ADR_NAV_DATA)) = (((_VAL_) << 2) | ((REG32(ADR_NAV_DATA)) & 0xfffffffb))
#define SET_SHRT_GI(_VAL_) (REG32(ADR_NAV_DATA)) = (((_VAL_) << 3) | ((REG32(ADR_NAV_DATA)) & 0xfffffff7))
#define SET_DATA_RATE(_VAL_) (REG32(ADR_NAV_DATA)) = (((_VAL_) << 4) | ((REG32(ADR_NAV_DATA)) & 0xfffff80f))
#define SET_MCS(_VAL_) (REG32(ADR_NAV_DATA)) = (((_VAL_) << 12) | ((REG32(ADR_NAV_DATA)) & 0xffff8fff))
#define SET_FRAME_LEN(_VAL_) (REG32(ADR_NAV_DATA)) = (((_VAL_) << 16) | ((REG32(ADR_NAV_DATA)) & 0x0000ffff))
#define SET_DURATION(_VAL_) (REG32(ADR_CO_NAV)) = (((_VAL_) << 0) | ((REG32(ADR_CO_NAV)) & 0xffff0000))
#define SET_SHA_DST_ADDR(_VAL_) (REG32(ADR_SHA_DST_ADDR)) = (((_VAL_) << 0) | ((REG32(ADR_SHA_DST_ADDR)) & 0x00000000))
#define SET_SHA_SRC_ADDR(_VAL_) (REG32(ADR_SHA_SRC_ADDR)) = (((_VAL_) << 0) | ((REG32(ADR_SHA_SRC_ADDR)) & 0x00000000))
#define SET_SHA_BUSY(_VAL_) (REG32(ADR_SHA_SETTING)) = (((_VAL_) << 0) | ((REG32(ADR_SHA_SETTING)) & 0xfffffffe))
#define SET_SHA_ENDIAN(_VAL_) (REG32(ADR_SHA_SETTING)) = (((_VAL_) << 1) | ((REG32(ADR_SHA_SETTING)) & 0xfffffffd))
#define SET_EFS_CLKFREQ(_VAL_) (REG32(ADR_EFUSE_CLK_FREQ)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_CLK_FREQ)) & 0xfffff000))
#define SET_LOW_ACTIVE(_VAL_) (REG32(ADR_EFUSE_CLK_FREQ)) = (((_VAL_) << 16) | ((REG32(ADR_EFUSE_CLK_FREQ)) & 0xfffeffff))
#define SET_EFS_CLKFREQ_RD(_VAL_) (REG32(ADR_EFUSE_CLK_FREQ)) = (((_VAL_) << 20) | ((REG32(ADR_EFUSE_CLK_FREQ)) & 0xf00fffff))
#define SET_EFS_PRE_RD(_VAL_) (REG32(ADR_EFUSE_CLK_FREQ)) = (((_VAL_) << 28) | ((REG32(ADR_EFUSE_CLK_FREQ)) & 0x0fffffff))
#define SET_EFS_LDO_ON(_VAL_) (REG32(ADR_EFUSE_LDO_TIME)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_LDO_TIME)) & 0xffff0000))
#define SET_EFS_LDO_OFF(_VAL_) (REG32(ADR_EFUSE_LDO_TIME)) = (((_VAL_) << 16) | ((REG32(ADR_EFUSE_LDO_TIME)) & 0x0000ffff))
#define SET_EFS_RDATA_0(_VAL_) (REG32(ADR_EFUSE_AHB_RDATA_0)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_AHB_RDATA_0)) & 0x00000000))
#define SET_EFS_WDATA_0(_VAL_) (REG32(ADR_EFUSE_WDATA_0)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_WDATA_0)) & 0x00000000))
#define SET_EFS_RDATA_1(_VAL_) (REG32(ADR_EFUSE_AHB_RDATA_1)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_AHB_RDATA_1)) & 0x00000000))
#define SET_EFS_WDATA_1(_VAL_) (REG32(ADR_EFUSE_WDATA_1)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_WDATA_1)) & 0x00000000))
#define SET_EFS_RDATA_2(_VAL_) (REG32(ADR_EFUSE_AHB_RDATA_2)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_AHB_RDATA_2)) & 0x00000000))
#define SET_EFS_WDATA_2(_VAL_) (REG32(ADR_EFUSE_WDATA_2)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_WDATA_2)) & 0x00000000))
#define SET_EFS_RDATA_3(_VAL_) (REG32(ADR_EFUSE_AHB_RDATA_3)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_AHB_RDATA_3)) & 0x00000000))
#define SET_EFS_WDATA_3(_VAL_) (REG32(ADR_EFUSE_WDATA_3)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_WDATA_3)) & 0x00000000))
#define SET_EFS_RDATA_4(_VAL_) (REG32(ADR_EFUSE_AHB_RDATA_4)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_AHB_RDATA_4)) & 0x00000000))
#define SET_EFS_WDATA_4(_VAL_) (REG32(ADR_EFUSE_WDATA_4)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_WDATA_4)) & 0x00000000))
#define SET_EFS_RDATA_5(_VAL_) (REG32(ADR_EFUSE_AHB_RDATA_5)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_AHB_RDATA_5)) & 0x00000000))
#define SET_EFS_WDATA_5(_VAL_) (REG32(ADR_EFUSE_WDATA_5)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_WDATA_5)) & 0x00000000))
#define SET_EFS_RDATA_6(_VAL_) (REG32(ADR_EFUSE_AHB_RDATA_6)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_AHB_RDATA_6)) & 0x00000000))
#define SET_EFS_WDATA_6(_VAL_) (REG32(ADR_EFUSE_WDATA_6)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_WDATA_6)) & 0x00000000))
#define SET_EFS_RDATA_7(_VAL_) (REG32(ADR_EFUSE_AHB_RDATA_7)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_AHB_RDATA_7)) & 0x00000000))
#define SET_EFS_WDATA_7(_VAL_) (REG32(ADR_EFUSE_WDATA_7)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_WDATA_7)) & 0x00000000))
#define SET_EFS_SPI_RD0_EN(_VAL_) (REG32(ADR_EFUSE_SPI_RD0_EN)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_SPI_RD0_EN)) & 0xfffffffe))
#define SET_EFS_SPI_RD1_EN(_VAL_) (REG32(ADR_EFUSE_SPI_RD1_EN)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_SPI_RD1_EN)) & 0xfffffffe))
#define SET_EFS_SPI_RD2_EN(_VAL_) (REG32(ADR_EFUSE_SPI_RD2_EN)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_SPI_RD2_EN)) & 0xfffffffe))
#define SET_EFS_SPI_RD3_EN(_VAL_) (REG32(ADR_EFUSE_SPI_RD3_EN)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_SPI_RD3_EN)) & 0xfffffffe))
#define SET_EFS_SPI_RD4_EN(_VAL_) (REG32(ADR_EFUSE_SPI_RD4_EN)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_SPI_RD4_EN)) & 0xfffffffe))
#define SET_EFS_SPI_RD5_EN(_VAL_) (REG32(ADR_EFUSE_SPI_RD5_EN)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_SPI_RD5_EN)) & 0xfffffffe))
#define SET_EFS_SPI_RD6_EN(_VAL_) (REG32(ADR_EFUSE_SPI_RD6_EN)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_SPI_RD6_EN)) & 0xfffffffe))
#define SET_EFS_SPI_RD7_EN(_VAL_) (REG32(ADR_EFUSE_SPI_RD7_EN)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_SPI_RD7_EN)) & 0xfffffffe))
#define SET_EFS_SPI_RBUSY(_VAL_) (REG32(ADR_EFUSE_SPI_BUSY)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_SPI_BUSY)) & 0xfffffffe))
#define SET_EFS_SPI_RDATA_0(_VAL_) (REG32(ADR_EFUSE_SPI_RDATA_0)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_SPI_RDATA_0)) & 0x00000000))
#define SET_EFS_SPI_RDATA_1(_VAL_) (REG32(ADR_EFUSE_SPI_RDATA_1)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_SPI_RDATA_1)) & 0x00000000))
#define SET_EFS_SPI_RDATA_2(_VAL_) (REG32(ADR_EFUSE_SPI_RDATA_2)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_SPI_RDATA_2)) & 0x00000000))
#define SET_EFS_SPI_RDATA_3(_VAL_) (REG32(ADR_EFUSE_SPI_RDATA_3)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_SPI_RDATA_3)) & 0x00000000))
#define SET_EFS_SPI_RDATA_4(_VAL_) (REG32(ADR_EFUSE_SPI_RDATA_4)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_SPI_RDATA_4)) & 0x00000000))
#define SET_EFS_SPI_RDATA_5(_VAL_) (REG32(ADR_EFUSE_SPI_RDATA_5)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_SPI_RDATA_5)) & 0x00000000))
#define SET_EFS_SPI_RDATA_6(_VAL_) (REG32(ADR_EFUSE_SPI_RDATA_6)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_SPI_RDATA_6)) & 0x00000000))
#define SET_EFS_SPI_RDATA_7(_VAL_) (REG32(ADR_EFUSE_SPI_RDATA_7)) = (((_VAL_) << 0) | ((REG32(ADR_EFUSE_SPI_RDATA_7)) & 0x00000000))
#define SET_GET_RK(_VAL_) (REG32(ADR_SMS4_CFG1)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_CFG1)) & 0xfffffffe))
#define SET_FORCE_GET_RK(_VAL_) (REG32(ADR_SMS4_CFG1)) = (((_VAL_) << 1) | ((REG32(ADR_SMS4_CFG1)) & 0xfffffffd))
#define SET_SMS4_DESCRY_EN(_VAL_) (REG32(ADR_SMS4_CFG1)) = (((_VAL_) << 4) | ((REG32(ADR_SMS4_CFG1)) & 0xffffffef))
#define SET_DEC_DOUT_MSB(_VAL_) (REG32(ADR_SMS4_CFG2)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_CFG2)) & 0xfffffffe))
#define SET_DEC_DIN_MSB(_VAL_) (REG32(ADR_SMS4_CFG2)) = (((_VAL_) << 1) | ((REG32(ADR_SMS4_CFG2)) & 0xfffffffd))
#define SET_ENC_DOUT_MSB(_VAL_) (REG32(ADR_SMS4_CFG2)) = (((_VAL_) << 2) | ((REG32(ADR_SMS4_CFG2)) & 0xfffffffb))
#define SET_ENC_DIN_MSB(_VAL_) (REG32(ADR_SMS4_CFG2)) = (((_VAL_) << 3) | ((REG32(ADR_SMS4_CFG2)) & 0xfffffff7))
#define SET_KEY_DIN_MSB(_VAL_) (REG32(ADR_SMS4_CFG2)) = (((_VAL_) << 4) | ((REG32(ADR_SMS4_CFG2)) & 0xffffffef))
#define SET_SMS4_CBC_EN(_VAL_) (REG32(ADR_SMS4_MODE1)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_MODE1)) & 0xfffffffe))
#define SET_SMS4_CFB_EN(_VAL_) (REG32(ADR_SMS4_MODE1)) = (((_VAL_) << 1) | ((REG32(ADR_SMS4_MODE1)) & 0xfffffffd))
#define SET_SMS4_OFB_EN(_VAL_) (REG32(ADR_SMS4_MODE1)) = (((_VAL_) << 2) | ((REG32(ADR_SMS4_MODE1)) & 0xfffffffb))
#define SET_SMS4_START_TRIG(_VAL_) (REG32(ADR_SMS4_TRIG)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_TRIG)) & 0xfffffffe))
#define SET_SMS4_BUSY(_VAL_) (REG32(ADR_SMS4_STATUS1)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_STATUS1)) & 0xfffffffe))
#define SET_SMS4_DONE(_VAL_) (REG32(ADR_SMS4_STATUS2)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_STATUS2)) & 0xfffffffe))
#define SET_SMS4_DATAIN_0(_VAL_) (REG32(ADR_SMS4_DATA_IN0)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_DATA_IN0)) & 0x00000000))
#define SET_SMS4_DATAIN_1(_VAL_) (REG32(ADR_SMS4_DATA_IN1)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_DATA_IN1)) & 0x00000000))
#define SET_SMS4_DATAIN_2(_VAL_) (REG32(ADR_SMS4_DATA_IN2)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_DATA_IN2)) & 0x00000000))
#define SET_SMS4_DATAIN_3(_VAL_) (REG32(ADR_SMS4_DATA_IN3)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_DATA_IN3)) & 0x00000000))
#define SET_SMS4_DATAOUT_0(_VAL_) (REG32(ADR_SMS4_DATA_OUT0)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_DATA_OUT0)) & 0x00000000))
#define SET_SMS4_DATAOUT_1(_VAL_) (REG32(ADR_SMS4_DATA_OUT1)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_DATA_OUT1)) & 0x00000000))
#define SET_SMS4_DATAOUT_2(_VAL_) (REG32(ADR_SMS4_DATA_OUT2)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_DATA_OUT2)) & 0x00000000))
#define SET_SMS4_DATAOUT_3(_VAL_) (REG32(ADR_SMS4_DATA_OUT3)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_DATA_OUT3)) & 0x00000000))
#define SET_SMS4_KEY_0(_VAL_) (REG32(ADR_SMS4_KEY_0)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_KEY_0)) & 0x00000000))
#define SET_SMS4_KEY_1(_VAL_) (REG32(ADR_SMS4_KEY_1)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_KEY_1)) & 0x00000000))
#define SET_SMS4_KEY_2(_VAL_) (REG32(ADR_SMS4_KEY_2)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_KEY_2)) & 0x00000000))
#define SET_SMS4_KEY_3(_VAL_) (REG32(ADR_SMS4_KEY_3)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_KEY_3)) & 0x00000000))
#define SET_SMS4_MODE_IV0(_VAL_) (REG32(ADR_SMS4_MODE_IV0)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_MODE_IV0)) & 0x00000000))
#define SET_SMS4_MODE_IV1(_VAL_) (REG32(ADR_SMS4_MODE_IV1)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_MODE_IV1)) & 0x00000000))
#define SET_SMS4_MODE_IV2(_VAL_) (REG32(ADR_SMS4_MODE_IV2)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_MODE_IV2)) & 0x00000000))
#define SET_SMS4_MODE_IV3(_VAL_) (REG32(ADR_SMS4_MODE_IV3)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_MODE_IV3)) & 0x00000000))
#define SET_SMS4_OFB_ENC0(_VAL_) (REG32(ADR_SMS4_OFB_ENC0)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_OFB_ENC0)) & 0x00000000))
#define SET_SMS4_OFB_ENC1(_VAL_) (REG32(ADR_SMS4_OFB_ENC1)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_OFB_ENC1)) & 0x00000000))
#define SET_SMS4_OFB_ENC2(_VAL_) (REG32(ADR_SMS4_OFB_ENC2)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_OFB_ENC2)) & 0x00000000))
#define SET_SMS4_OFB_ENC3(_VAL_) (REG32(ADR_SMS4_OFB_ENC3)) = (((_VAL_) << 0) | ((REG32(ADR_SMS4_OFB_ENC3)) & 0x00000000))
#define SET_MRX_MCAST_TB0_31_0(_VAL_) (REG32(ADR_MRX_MCAST_TB0_0)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_TB0_0)) & 0x00000000))
#define SET_MRX_MCAST_TB0_47_32(_VAL_) (REG32(ADR_MRX_MCAST_TB0_1)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_TB0_1)) & 0xffff0000))
#define SET_MRX_MCAST_MASK0_31_0(_VAL_) (REG32(ADR_MRX_MCAST_MK0_0)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_MK0_0)) & 0x00000000))
#define SET_MRX_MCAST_MASK0_47_32(_VAL_) (REG32(ADR_MRX_MCAST_MK0_1)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_MK0_1)) & 0xffff0000))
#define SET_MRX_MCAST_CTRL_0(_VAL_) (REG32(ADR_MRX_MCAST_CTRL0)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_CTRL0)) & 0xfffffffc))
#define SET_MRX_MCAST_TB1_31_0(_VAL_) (REG32(ADR_MRX_MCAST_TB1_0)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_TB1_0)) & 0x00000000))
#define SET_MRX_MCAST_TB1_47_32(_VAL_) (REG32(ADR_MRX_MCAST_TB1_1)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_TB1_1)) & 0xffff0000))
#define SET_MRX_MCAST_MASK1_31_0(_VAL_) (REG32(ADR_MRX_MCAST_MK1_0)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_MK1_0)) & 0x00000000))
#define SET_MRX_MCAST_MASK1_47_32(_VAL_) (REG32(ADR_MRX_MCAST_MK1_1)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_MK1_1)) & 0xffff0000))
#define SET_MRX_MCAST_CTRL_1(_VAL_) (REG32(ADR_MRX_MCAST_CTRL1)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_CTRL1)) & 0xfffffffc))
#define SET_MRX_MCAST_TB2_31_0(_VAL_) (REG32(ADR_MRX_MCAST_TB2_0)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_TB2_0)) & 0x00000000))
#define SET_MRX_MCAST_TB2_47_32(_VAL_) (REG32(ADR_MRX_MCAST_TB2_1)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_TB2_1)) & 0xffff0000))
#define SET_MRX_MCAST_MASK2_31_0(_VAL_) (REG32(ADR_MRX_MCAST_MK2_0)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_MK2_0)) & 0x00000000))
#define SET_MRX_MCAST_MASK2_47_32(_VAL_) (REG32(ADR_MRX_MCAST_MK2_1)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_MK2_1)) & 0xffff0000))
#define SET_MRX_MCAST_CTRL_2(_VAL_) (REG32(ADR_MRX_MCAST_CTRL2)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_CTRL2)) & 0xfffffffc))
#define SET_MRX_MCAST_TB3_31_0(_VAL_) (REG32(ADR_MRX_MCAST_TB3_0)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_TB3_0)) & 0x00000000))
#define SET_MRX_MCAST_TB3_47_32(_VAL_) (REG32(ADR_MRX_MCAST_TB3_1)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_TB3_1)) & 0xffff0000))
#define SET_MRX_MCAST_MASK3_31_0(_VAL_) (REG32(ADR_MRX_MCAST_MK3_0)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_MK3_0)) & 0x00000000))
#define SET_MRX_MCAST_MASK3_47_32(_VAL_) (REG32(ADR_MRX_MCAST_MK3_1)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_MK3_1)) & 0xffff0000))
#define SET_MRX_MCAST_CTRL_3(_VAL_) (REG32(ADR_MRX_MCAST_CTRL3)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MCAST_CTRL3)) & 0xfffffffc))
#define SET_MRX_PHY_INFO(_VAL_) (REG32(ADR_MRX_PHY_INFO)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_PHY_INFO)) & 0x00000000))
#define SET_DBG_BA_TYPE(_VAL_) (REG32(ADR_MRX_BA_DBG)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_BA_DBG)) & 0xffffffc0))
#define SET_DBG_BA_SEQ(_VAL_) (REG32(ADR_MRX_BA_DBG)) = (((_VAL_) << 8) | ((REG32(ADR_MRX_BA_DBG)) & 0xfff000ff))
#define SET_MRX_FLT_TB0(_VAL_) (REG32(ADR_MRX_FLT_TB0)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_TB0)) & 0xffff8000))
#define SET_MRX_FLT_TB1(_VAL_) (REG32(ADR_MRX_FLT_TB1)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_TB1)) & 0xffff8000))
#define SET_MRX_FLT_TB2(_VAL_) (REG32(ADR_MRX_FLT_TB2)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_TB2)) & 0xffff8000))
#define SET_MRX_FLT_TB3(_VAL_) (REG32(ADR_MRX_FLT_TB3)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_TB3)) & 0xffff8000))
#define SET_MRX_FLT_TB4(_VAL_) (REG32(ADR_MRX_FLT_TB4)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_TB4)) & 0xffff8000))
#define SET_MRX_FLT_TB5(_VAL_) (REG32(ADR_MRX_FLT_TB5)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_TB5)) & 0xffff8000))
#define SET_MRX_FLT_TB6(_VAL_) (REG32(ADR_MRX_FLT_TB6)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_TB6)) & 0xffff8000))
#define SET_MRX_FLT_TB7(_VAL_) (REG32(ADR_MRX_FLT_TB7)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_TB7)) & 0xffff8000))
#define SET_MRX_FLT_TB8(_VAL_) (REG32(ADR_MRX_FLT_TB8)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_TB8)) & 0xffff8000))
#define SET_MRX_FLT_TB9(_VAL_) (REG32(ADR_MRX_FLT_TB9)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_TB9)) & 0xffff8000))
#define SET_MRX_FLT_TB10(_VAL_) (REG32(ADR_MRX_FLT_TB10)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_TB10)) & 0xffff8000))
#define SET_MRX_FLT_TB11(_VAL_) (REG32(ADR_MRX_FLT_TB11)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_TB11)) & 0xffff8000))
#define SET_MRX_FLT_TB12(_VAL_) (REG32(ADR_MRX_FLT_TB12)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_TB12)) & 0xffff8000))
#define SET_MRX_FLT_TB13(_VAL_) (REG32(ADR_MRX_FLT_TB13)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_TB13)) & 0xffff8000))
#define SET_MRX_FLT_TB14(_VAL_) (REG32(ADR_MRX_FLT_TB14)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_TB14)) & 0xffff8000))
#define SET_MRX_FLT_TB15(_VAL_) (REG32(ADR_MRX_FLT_TB15)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_TB15)) & 0xffff8000))
#define SET_MRX_FLT_EN0(_VAL_) (REG32(ADR_MRX_FLT_EN0)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_EN0)) & 0xffff0000))
#define SET_MRX_FLT_EN1(_VAL_) (REG32(ADR_MRX_FLT_EN1)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_EN1)) & 0xffff0000))
#define SET_MRX_FLT_EN2(_VAL_) (REG32(ADR_MRX_FLT_EN2)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_EN2)) & 0xffff0000))
#define SET_MRX_FLT_EN3(_VAL_) (REG32(ADR_MRX_FLT_EN3)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_EN3)) & 0xffff0000))
#define SET_MRX_FLT_EN4(_VAL_) (REG32(ADR_MRX_FLT_EN4)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_EN4)) & 0xffff0000))
#define SET_MRX_FLT_EN5(_VAL_) (REG32(ADR_MRX_FLT_EN5)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_EN5)) & 0xffff0000))
#define SET_MRX_FLT_EN6(_VAL_) (REG32(ADR_MRX_FLT_EN6)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_EN6)) & 0xffff0000))
#define SET_MRX_FLT_EN7(_VAL_) (REG32(ADR_MRX_FLT_EN7)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_EN7)) & 0xffff0000))
#define SET_MRX_FLT_EN8(_VAL_) (REG32(ADR_MRX_FLT_EN8)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FLT_EN8)) & 0xffff0000))
#define SET_MRX_LEN_FLT(_VAL_) (REG32(ADR_MRX_LEN_FLT)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_LEN_FLT)) & 0xffff0000))
#define SET_RX_FLOW_DATA(_VAL_) (REG32(ADR_RX_FLOW_DATA)) = (((_VAL_) << 0) | ((REG32(ADR_RX_FLOW_DATA)) & 0x00000000))
#define SET_RX_FLOW_MNG(_VAL_) (REG32(ADR_RX_FLOW_MNG)) = (((_VAL_) << 0) | ((REG32(ADR_RX_FLOW_MNG)) & 0xffff0000))
#define SET_RX_FLOW_CTRL(_VAL_) (REG32(ADR_RX_FLOW_CTRL)) = (((_VAL_) << 0) | ((REG32(ADR_RX_FLOW_CTRL)) & 0xffff0000))
#define SET_MRX_STP_EN(_VAL_) (REG32(ADR_RX_TIME_STAMP_CFG)) = (((_VAL_) << 0) | ((REG32(ADR_RX_TIME_STAMP_CFG)) & 0xfffffffe))
#define SET_MRX_STP_OFST(_VAL_) (REG32(ADR_RX_TIME_STAMP_CFG)) = (((_VAL_) << 8) | ((REG32(ADR_RX_TIME_STAMP_CFG)) & 0xffff00ff))
#define SET_DBG_FF_FULL(_VAL_) (REG32(ADR_DBG_FF_FULL)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_FF_FULL)) & 0xffff0000))
#define SET_DBG_FF_FULL_CLR(_VAL_) (REG32(ADR_DBG_FF_FULL)) = (((_VAL_) << 31) | ((REG32(ADR_DBG_FF_FULL)) & 0x7fffffff))
#define SET_DBG_WFF_FULL(_VAL_) (REG32(ADR_DBG_WFF_FULL)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_WFF_FULL)) & 0xffff0000))
#define SET_DBG_WFF_FULL_CLR(_VAL_) (REG32(ADR_DBG_WFF_FULL)) = (((_VAL_) << 31) | ((REG32(ADR_DBG_WFF_FULL)) & 0x7fffffff))
#define SET_DBG_MB_FULL(_VAL_) (REG32(ADR_DBG_MB_FULL)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_MB_FULL)) & 0xffff0000))
#define SET_DBG_MB_FULL_CLR(_VAL_) (REG32(ADR_DBG_MB_FULL)) = (((_VAL_) << 31) | ((REG32(ADR_DBG_MB_FULL)) & 0x7fffffff))
#define SET_BA_CTRL(_VAL_) (REG32(ADR_BA_CTRL)) = (((_VAL_) << 0) | ((REG32(ADR_BA_CTRL)) & 0xfffffffc))
#define SET_BA_DBG_EN(_VAL_) (REG32(ADR_BA_CTRL)) = (((_VAL_) << 2) | ((REG32(ADR_BA_CTRL)) & 0xfffffffb))
#define SET_BA_AGRE_EN(_VAL_) (REG32(ADR_BA_CTRL)) = (((_VAL_) << 3) | ((REG32(ADR_BA_CTRL)) & 0xfffffff7))
#define SET_BA_TA_31_0(_VAL_) (REG32(ADR_BA_TA_0)) = (((_VAL_) << 0) | ((REG32(ADR_BA_TA_0)) & 0x00000000))
#define SET_BA_TA_47_32(_VAL_) (REG32(ADR_BA_TA_1)) = (((_VAL_) << 0) | ((REG32(ADR_BA_TA_1)) & 0xffff0000))
#define SET_BA_TID(_VAL_) (REG32(ADR_BA_TID)) = (((_VAL_) << 0) | ((REG32(ADR_BA_TID)) & 0xfffffff0))
#define SET_BA_ST_SEQ(_VAL_) (REG32(ADR_BA_ST_SEQ)) = (((_VAL_) << 0) | ((REG32(ADR_BA_ST_SEQ)) & 0xfffff000))
#define SET_BA_SB0(_VAL_) (REG32(ADR_BA_SB0)) = (((_VAL_) << 0) | ((REG32(ADR_BA_SB0)) & 0x00000000))
#define SET_BA_SB1(_VAL_) (REG32(ADR_BA_SB1)) = (((_VAL_) << 0) | ((REG32(ADR_BA_SB1)) & 0x00000000))
#define SET_MRX_WD(_VAL_) (REG32(ADR_MRX_WATCH_DOG)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_WATCH_DOG)) & 0xfffe0000))
#define SET_ACK_GEN_EN(_VAL_) (REG32(ADR_ACK_GEN_EN)) = (((_VAL_) << 0) | ((REG32(ADR_ACK_GEN_EN)) & 0xfffffffe))
#define SET_BA_GEN_EN(_VAL_) (REG32(ADR_ACK_GEN_EN)) = (((_VAL_) << 1) | ((REG32(ADR_ACK_GEN_EN)) & 0xfffffffd))
#define SET_ACK_GEN_DUR(_VAL_) (REG32(ADR_ACK_GEN_PARA)) = (((_VAL_) << 0) | ((REG32(ADR_ACK_GEN_PARA)) & 0xffff0000))
#define SET_ACK_GEN_INFO(_VAL_) (REG32(ADR_ACK_GEN_PARA)) = (((_VAL_) << 16) | ((REG32(ADR_ACK_GEN_PARA)) & 0xffc0ffff))
#define SET_ACK_GEN_RA_31_0(_VAL_) (REG32(ADR_ACK_GEN_RA_0)) = (((_VAL_) << 0) | ((REG32(ADR_ACK_GEN_RA_0)) & 0x00000000))
#define SET_ACK_GEN_RA_47_32(_VAL_) (REG32(ADR_ACK_GEN_RA_1)) = (((_VAL_) << 0) | ((REG32(ADR_ACK_GEN_RA_1)) & 0xffff0000))
#define SET_MIB_LEN_FAIL(_VAL_) (REG32(ADR_MIB_LEN_FAIL)) = (((_VAL_) << 0) | ((REG32(ADR_MIB_LEN_FAIL)) & 0xffff0000))
#define SET_TRAP_HW_ID(_VAL_) (REG32(ADR_TRAP_HW_ID)) = (((_VAL_) << 0) | ((REG32(ADR_TRAP_HW_ID)) & 0xfffffff0))
#define SET_ID_IN_USE(_VAL_) (REG32(ADR_ID_IN_USE)) = (((_VAL_) << 0) | ((REG32(ADR_ID_IN_USE)) & 0xffffff00))
#define SET_MRX_ERR(_VAL_) (REG32(ADR_MRX_ERR)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_ERR)) & 0x00000000))
#define SET_W0_T0_SEQ(_VAL_) (REG32(ADR_WSID0_TID0_RX_SEQ)) = (((_VAL_) << 0) | ((REG32(ADR_WSID0_TID0_RX_SEQ)) & 0xffff0000))
#define SET_W0_T1_SEQ(_VAL_) (REG32(ADR_WSID0_TID1_RX_SEQ)) = (((_VAL_) << 0) | ((REG32(ADR_WSID0_TID1_RX_SEQ)) & 0xffff0000))
#define SET_W0_T2_SEQ(_VAL_) (REG32(ADR_WSID0_TID2_RX_SEQ)) = (((_VAL_) << 0) | ((REG32(ADR_WSID0_TID2_RX_SEQ)) & 0xffff0000))
#define SET_W0_T3_SEQ(_VAL_) (REG32(ADR_WSID0_TID3_RX_SEQ)) = (((_VAL_) << 0) | ((REG32(ADR_WSID0_TID3_RX_SEQ)) & 0xffff0000))
#define SET_W0_T4_SEQ(_VAL_) (REG32(ADR_WSID0_TID4_RX_SEQ)) = (((_VAL_) << 0) | ((REG32(ADR_WSID0_TID4_RX_SEQ)) & 0xffff0000))
#define SET_W0_T5_SEQ(_VAL_) (REG32(ADR_WSID0_TID5_RX_SEQ)) = (((_VAL_) << 0) | ((REG32(ADR_WSID0_TID5_RX_SEQ)) & 0xffff0000))
#define SET_W0_T6_SEQ(_VAL_) (REG32(ADR_WSID0_TID6_RX_SEQ)) = (((_VAL_) << 0) | ((REG32(ADR_WSID0_TID6_RX_SEQ)) & 0xffff0000))
#define SET_W0_T7_SEQ(_VAL_) (REG32(ADR_WSID0_TID7_RX_SEQ)) = (((_VAL_) << 0) | ((REG32(ADR_WSID0_TID7_RX_SEQ)) & 0xffff0000))
#define SET_W1_T0_SEQ(_VAL_) (REG32(ADR_WSID1_TID0_RX_SEQ)) = (((_VAL_) << 0) | ((REG32(ADR_WSID1_TID0_RX_SEQ)) & 0xffff0000))
#define SET_W1_T1_SEQ(_VAL_) (REG32(ADR_WSID1_TID1_RX_SEQ)) = (((_VAL_) << 0) | ((REG32(ADR_WSID1_TID1_RX_SEQ)) & 0xffff0000))
#define SET_W1_T2_SEQ(_VAL_) (REG32(ADR_WSID1_TID2_RX_SEQ)) = (((_VAL_) << 0) | ((REG32(ADR_WSID1_TID2_RX_SEQ)) & 0xffff0000))
#define SET_W1_T3_SEQ(_VAL_) (REG32(ADR_WSID1_TID3_RX_SEQ)) = (((_VAL_) << 0) | ((REG32(ADR_WSID1_TID3_RX_SEQ)) & 0xffff0000))
#define SET_W1_T4_SEQ(_VAL_) (REG32(ADR_WSID1_TID4_RX_SEQ)) = (((_VAL_) << 0) | ((REG32(ADR_WSID1_TID4_RX_SEQ)) & 0xffff0000))
#define SET_W1_T5_SEQ(_VAL_) (REG32(ADR_WSID1_TID5_RX_SEQ)) = (((_VAL_) << 0) | ((REG32(ADR_WSID1_TID5_RX_SEQ)) & 0xffff0000))
#define SET_W1_T6_SEQ(_VAL_) (REG32(ADR_WSID1_TID6_RX_SEQ)) = (((_VAL_) << 0) | ((REG32(ADR_WSID1_TID6_RX_SEQ)) & 0xffff0000))
#define SET_W1_T7_SEQ(_VAL_) (REG32(ADR_WSID1_TID7_RX_SEQ)) = (((_VAL_) << 0) | ((REG32(ADR_WSID1_TID7_RX_SEQ)) & 0xffff0000))
#define SET_ADDR1A_SEL(_VAL_) (REG32(ADR_HDR_ADDR_SEL)) = (((_VAL_) << 0) | ((REG32(ADR_HDR_ADDR_SEL)) & 0xfffffffc))
#define SET_ADDR2A_SEL(_VAL_) (REG32(ADR_HDR_ADDR_SEL)) = (((_VAL_) << 2) | ((REG32(ADR_HDR_ADDR_SEL)) & 0xfffffff3))
#define SET_ADDR3A_SEL(_VAL_) (REG32(ADR_HDR_ADDR_SEL)) = (((_VAL_) << 4) | ((REG32(ADR_HDR_ADDR_SEL)) & 0xffffffcf))
#define SET_ADDR1B_SEL(_VAL_) (REG32(ADR_HDR_ADDR_SEL)) = (((_VAL_) << 6) | ((REG32(ADR_HDR_ADDR_SEL)) & 0xffffff3f))
#define SET_ADDR2B_SEL(_VAL_) (REG32(ADR_HDR_ADDR_SEL)) = (((_VAL_) << 8) | ((REG32(ADR_HDR_ADDR_SEL)) & 0xfffffcff))
#define SET_ADDR3B_SEL(_VAL_) (REG32(ADR_HDR_ADDR_SEL)) = (((_VAL_) << 10) | ((REG32(ADR_HDR_ADDR_SEL)) & 0xfffff3ff))
#define SET_ADDR3C_SEL(_VAL_) (REG32(ADR_HDR_ADDR_SEL)) = (((_VAL_) << 12) | ((REG32(ADR_HDR_ADDR_SEL)) & 0xffffcfff))
#define SET_FRM_CTRL(_VAL_) (REG32(ADR_FRAME_TYPE_CNTR_SET)) = (((_VAL_) << 0) | ((REG32(ADR_FRAME_TYPE_CNTR_SET)) & 0xffffffc0))
#define SET_CSR_PHY_INFO(_VAL_) (REG32(ADR_PHY_INFO)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_INFO)) & 0xffff8000))
#define SET_AMPDU_SIG(_VAL_) (REG32(ADR_AMPDU_SIG)) = (((_VAL_) << 0) | ((REG32(ADR_AMPDU_SIG)) & 0xffffff00))
#define SET_MIB_AMPDU(_VAL_) (REG32(ADR_MIB_AMPDU)) = (((_VAL_) << 0) | ((REG32(ADR_MIB_AMPDU)) & 0x00000000))
#define SET_LEN_FLT(_VAL_) (REG32(ADR_LEN_FLT)) = (((_VAL_) << 0) | ((REG32(ADR_LEN_FLT)) & 0xffff0000))
#define SET_MIB_DELIMITER(_VAL_) (REG32(ADR_MIB_DELIMITER)) = (((_VAL_) << 0) | ((REG32(ADR_MIB_DELIMITER)) & 0xffff0000))
#define SET_MTX_INT_Q0_Q_EMPTY(_VAL_) (REG32(ADR_MTX_INT_STS)) = (((_VAL_) << 16) | ((REG32(ADR_MTX_INT_STS)) & 0xfffeffff))
#define SET_MTX_INT_Q0_TXOP_RUNOUT(_VAL_) (REG32(ADR_MTX_INT_STS)) = (((_VAL_) << 17) | ((REG32(ADR_MTX_INT_STS)) & 0xfffdffff))
#define SET_MTX_INT_Q1_Q_EMPTY(_VAL_) (REG32(ADR_MTX_INT_STS)) = (((_VAL_) << 18) | ((REG32(ADR_MTX_INT_STS)) & 0xfffbffff))
#define SET_MTX_INT_Q1_TXOP_RUNOUT(_VAL_) (REG32(ADR_MTX_INT_STS)) = (((_VAL_) << 19) | ((REG32(ADR_MTX_INT_STS)) & 0xfff7ffff))
#define SET_MTX_INT_Q2_Q_EMPTY(_VAL_) (REG32(ADR_MTX_INT_STS)) = (((_VAL_) << 20) | ((REG32(ADR_MTX_INT_STS)) & 0xffefffff))
#define SET_MTX_INT_Q2_TXOP_RUNOUT(_VAL_) (REG32(ADR_MTX_INT_STS)) = (((_VAL_) << 21) | ((REG32(ADR_MTX_INT_STS)) & 0xffdfffff))
#define SET_MTX_INT_Q3_Q_EMPTY(_VAL_) (REG32(ADR_MTX_INT_STS)) = (((_VAL_) << 22) | ((REG32(ADR_MTX_INT_STS)) & 0xffbfffff))
#define SET_MTX_INT_Q3_TXOP_RUNOUT(_VAL_) (REG32(ADR_MTX_INT_STS)) = (((_VAL_) << 23) | ((REG32(ADR_MTX_INT_STS)) & 0xff7fffff))
#define SET_MTX_INT_Q4_Q_EMPTY(_VAL_) (REG32(ADR_MTX_INT_STS)) = (((_VAL_) << 24) | ((REG32(ADR_MTX_INT_STS)) & 0xfeffffff))
#define SET_MTX_INT_Q4_TXOP_RUNOUT(_VAL_) (REG32(ADR_MTX_INT_STS)) = (((_VAL_) << 25) | ((REG32(ADR_MTX_INT_STS)) & 0xfdffffff))
#define SET_MTX_EN_INT_Q0_Q_EMPTY(_VAL_) (REG32(ADR_MTX_INT_EN)) = (((_VAL_) << 16) | ((REG32(ADR_MTX_INT_EN)) & 0xfffeffff))
#define SET_MTX_EN_INT_Q0_TXOP_RUNOUT(_VAL_) (REG32(ADR_MTX_INT_EN)) = (((_VAL_) << 17) | ((REG32(ADR_MTX_INT_EN)) & 0xfffdffff))
#define SET_MTX_EN_INT_Q1_Q_EMPTY(_VAL_) (REG32(ADR_MTX_INT_EN)) = (((_VAL_) << 18) | ((REG32(ADR_MTX_INT_EN)) & 0xfffbffff))
#define SET_MTX_EN_INT_Q1_TXOP_RUNOUT(_VAL_) (REG32(ADR_MTX_INT_EN)) = (((_VAL_) << 19) | ((REG32(ADR_MTX_INT_EN)) & 0xfff7ffff))
#define SET_MTX_EN_INT_Q2_Q_EMPTY(_VAL_) (REG32(ADR_MTX_INT_EN)) = (((_VAL_) << 20) | ((REG32(ADR_MTX_INT_EN)) & 0xffefffff))
#define SET_MTX_EN_INT_Q2_TXOP_RUNOUT(_VAL_) (REG32(ADR_MTX_INT_EN)) = (((_VAL_) << 21) | ((REG32(ADR_MTX_INT_EN)) & 0xffdfffff))
#define SET_MTX_EN_INT_Q3_Q_EMPTY(_VAL_) (REG32(ADR_MTX_INT_EN)) = (((_VAL_) << 22) | ((REG32(ADR_MTX_INT_EN)) & 0xffbfffff))
#define SET_MTX_EN_INT_Q3_TXOP_RUNOUT(_VAL_) (REG32(ADR_MTX_INT_EN)) = (((_VAL_) << 23) | ((REG32(ADR_MTX_INT_EN)) & 0xff7fffff))
#define SET_MTX_EN_INT_Q4_Q_EMPTY(_VAL_) (REG32(ADR_MTX_INT_EN)) = (((_VAL_) << 24) | ((REG32(ADR_MTX_INT_EN)) & 0xfeffffff))
#define SET_MTX_EN_INT_Q4_TXOP_RUNOUT(_VAL_) (REG32(ADR_MTX_INT_EN)) = (((_VAL_) << 25) | ((REG32(ADR_MTX_INT_EN)) & 0xfdffffff))
#define SET_MTX_MTX2PHY_SLOW(_VAL_) (REG32(ADR_MTX_MISC_EN)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_MISC_EN)) & 0xfffffffe))
#define SET_MTX_M2M_SLOW_PRD(_VAL_) (REG32(ADR_MTX_MISC_EN)) = (((_VAL_) << 1) | ((REG32(ADR_MTX_MISC_EN)) & 0xfffffff1))
#define SET_MTX_AMPDU_CRC_AUTO(_VAL_) (REG32(ADR_MTX_MISC_EN)) = (((_VAL_) << 5) | ((REG32(ADR_MTX_MISC_EN)) & 0xffffffdf))
#define SET_MTX_FAST_RSP_MODE(_VAL_) (REG32(ADR_MTX_MISC_EN)) = (((_VAL_) << 6) | ((REG32(ADR_MTX_MISC_EN)) & 0xffffffbf))
#define SET_MTX_RAW_DATA_MODE(_VAL_) (REG32(ADR_MTX_MISC_EN)) = (((_VAL_) << 7) | ((REG32(ADR_MTX_MISC_EN)) & 0xffffff7f))
#define SET_MTX_ACK_DUR0(_VAL_) (REG32(ADR_MTX_MISC_EN)) = (((_VAL_) << 8) | ((REG32(ADR_MTX_MISC_EN)) & 0xfffffeff))
#define SET_MTX_TSF_AUTO_BCN(_VAL_) (REG32(ADR_MTX_MISC_EN)) = (((_VAL_) << 10) | ((REG32(ADR_MTX_MISC_EN)) & 0xfffffbff))
#define SET_MTX_TSF_AUTO_MISC(_VAL_) (REG32(ADR_MTX_MISC_EN)) = (((_VAL_) << 11) | ((REG32(ADR_MTX_MISC_EN)) & 0xfffff7ff))
#define SET_MTX_FORCE_CS_IDLE(_VAL_) (REG32(ADR_MTX_MISC_EN)) = (((_VAL_) << 12) | ((REG32(ADR_MTX_MISC_EN)) & 0xffffefff))
#define SET_MTX_FORCE_BKF_RXEN0(_VAL_) (REG32(ADR_MTX_MISC_EN)) = (((_VAL_) << 13) | ((REG32(ADR_MTX_MISC_EN)) & 0xffffdfff))
#define SET_MTX_FORCE_DMA_RXEN0(_VAL_) (REG32(ADR_MTX_MISC_EN)) = (((_VAL_) << 14) | ((REG32(ADR_MTX_MISC_EN)) & 0xffffbfff))
#define SET_MTX_FORCE_RXEN0(_VAL_) (REG32(ADR_MTX_MISC_EN)) = (((_VAL_) << 15) | ((REG32(ADR_MTX_MISC_EN)) & 0xffff7fff))
#define SET_MTX_HALT_Q_MB(_VAL_) (REG32(ADR_MTX_MISC_EN)) = (((_VAL_) << 16) | ((REG32(ADR_MTX_MISC_EN)) & 0xffc0ffff))
#define SET_MTX_CTS_SET_DIF(_VAL_) (REG32(ADR_MTX_MISC_EN)) = (((_VAL_) << 22) | ((REG32(ADR_MTX_MISC_EN)) & 0xffbfffff))
#define SET_MTX_AMPDU_SET_DIF(_VAL_) (REG32(ADR_MTX_MISC_EN)) = (((_VAL_) << 23) | ((REG32(ADR_MTX_MISC_EN)) & 0xff7fffff))
#define SET_MTX_EDCCA_TOUT(_VAL_) (REG32(ADR_MTX_EDCCA_TOUT)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_EDCCA_TOUT)) & 0xfffffc00))
#define SET_MTX_INT_BCN(_VAL_) (REG32(ADR_MTX_BCN_INT_STS)) = (((_VAL_) << 1) | ((REG32(ADR_MTX_BCN_INT_STS)) & 0xfffffffd))
#define SET_MTX_INT_DTIM(_VAL_) (REG32(ADR_MTX_BCN_INT_STS)) = (((_VAL_) << 3) | ((REG32(ADR_MTX_BCN_INT_STS)) & 0xfffffff7))
#define SET_MTX_EN_INT_BCN(_VAL_) (REG32(ADR_MTX_BCN_EN_INT)) = (((_VAL_) << 1) | ((REG32(ADR_MTX_BCN_EN_INT)) & 0xfffffffd))
#define SET_MTX_EN_INT_DTIM(_VAL_) (REG32(ADR_MTX_BCN_EN_INT)) = (((_VAL_) << 3) | ((REG32(ADR_MTX_BCN_EN_INT)) & 0xfffffff7))
#define SET_MTX_BCN_TIMER_EN(_VAL_) (REG32(ADR_MTX_BCN_EN_MISC)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_BCN_EN_MISC)) & 0xfffffffe))
#define SET_MTX_TIME_STAMP_AUTO_FILL(_VAL_) (REG32(ADR_MTX_BCN_EN_MISC)) = (((_VAL_) << 1) | ((REG32(ADR_MTX_BCN_EN_MISC)) & 0xfffffffd))
#define SET_MTX_TSF_TIMER_EN(_VAL_) (REG32(ADR_MTX_BCN_EN_MISC)) = (((_VAL_) << 5) | ((REG32(ADR_MTX_BCN_EN_MISC)) & 0xffffffdf))
#define SET_MTX_HALT_MNG_UNTIL_DTIM(_VAL_) (REG32(ADR_MTX_BCN_EN_MISC)) = (((_VAL_) << 6) | ((REG32(ADR_MTX_BCN_EN_MISC)) & 0xffffffbf))
#define SET_MTX_INT_DTIM_NUM(_VAL_) (REG32(ADR_MTX_BCN_EN_MISC)) = (((_VAL_) << 8) | ((REG32(ADR_MTX_BCN_EN_MISC)) & 0xffff00ff))
#define SET_MTX_AUTO_FLUSH_Q4(_VAL_) (REG32(ADR_MTX_BCN_EN_MISC)) = (((_VAL_) << 16) | ((REG32(ADR_MTX_BCN_EN_MISC)) & 0xfffeffff))
#define SET_MTX_BCN_PKTID_CH_LOCK(_VAL_) (REG32(ADR_MTX_BCN_MISC)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_BCN_MISC)) & 0xfffffffe))
#define SET_MTX_BCN_CFG_VLD(_VAL_) (REG32(ADR_MTX_BCN_MISC)) = (((_VAL_) << 1) | ((REG32(ADR_MTX_BCN_MISC)) & 0xfffffff9))
#define SET_MTX_AUTO_BCN_ONGOING(_VAL_) (REG32(ADR_MTX_BCN_MISC)) = (((_VAL_) << 3) | ((REG32(ADR_MTX_BCN_MISC)) & 0xfffffff7))
#define SET_MTX_BCN_TIMER(_VAL_) (REG32(ADR_MTX_BCN_MISC)) = (((_VAL_) << 16) | ((REG32(ADR_MTX_BCN_MISC)) & 0x0000ffff))
#define SET_MTX_BCN_PERIOD(_VAL_) (REG32(ADR_MTX_BCN_PRD)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_BCN_PRD)) & 0xffff0000))
#define SET_MTX_DTIM_NUM(_VAL_) (REG32(ADR_MTX_BCN_PRD)) = (((_VAL_) << 24) | ((REG32(ADR_MTX_BCN_PRD)) & 0x00ffffff))
#define SET_MTX_BCN_TSF_L(_VAL_) (REG32(ADR_MTX_BCN_TSF_L)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_BCN_TSF_L)) & 0x00000000))
#define SET_MTX_BCN_TSF_U(_VAL_) (REG32(ADR_MTX_BCN_TSF_U)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_BCN_TSF_U)) & 0x00000000))
#define SET_MTX_BCN_PKT_ID0(_VAL_) (REG32(ADR_MTX_BCN_CFG0)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_BCN_CFG0)) & 0xffffff80))
#define SET_MTX_DTIM_OFST0(_VAL_) (REG32(ADR_MTX_BCN_CFG0)) = (((_VAL_) << 16) | ((REG32(ADR_MTX_BCN_CFG0)) & 0xfc00ffff))
#define SET_MTX_BCN_PKT_ID1(_VAL_) (REG32(ADR_MTX_BCN_CFG1)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_BCN_CFG1)) & 0xffffff80))
#define SET_MTX_DTIM_OFST1(_VAL_) (REG32(ADR_MTX_BCN_CFG1)) = (((_VAL_) << 16) | ((REG32(ADR_MTX_BCN_CFG1)) & 0xfc00ffff))
#define SET_MTX_CCA(_VAL_) (REG32(ADR_MTX_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_STATUS)) & 0xfffffffe))
#define SET_MRX_CCA(_VAL_) (REG32(ADR_MTX_STATUS)) = (((_VAL_) << 1) | ((REG32(ADR_MTX_STATUS)) & 0xfffffffd))
#define SET_MTX_DMA_FSM(_VAL_) (REG32(ADR_MTX_STATUS)) = (((_VAL_) << 2) | ((REG32(ADR_MTX_STATUS)) & 0xffffffe3))
#define SET_CH_ST_FSM(_VAL_) (REG32(ADR_MTX_STATUS)) = (((_VAL_) << 5) | ((REG32(ADR_MTX_STATUS)) & 0xffffff1f))
#define SET_MTX_GNT_LOCK(_VAL_) (REG32(ADR_MTX_STATUS)) = (((_VAL_) << 8) | ((REG32(ADR_MTX_STATUS)) & 0xfffffeff))
#define SET_MTX_DMA_REQ(_VAL_) (REG32(ADR_MTX_STATUS)) = (((_VAL_) << 9) | ((REG32(ADR_MTX_STATUS)) & 0xfffffdff))
#define SET_MTX_Q_REQ(_VAL_) (REG32(ADR_MTX_STATUS)) = (((_VAL_) << 10) | ((REG32(ADR_MTX_STATUS)) & 0xfffffbff))
#define SET_MTX_TX_EN(_VAL_) (REG32(ADR_MTX_STATUS)) = (((_VAL_) << 11) | ((REG32(ADR_MTX_STATUS)) & 0xfffff7ff))
#define SET_MRX_RX_EN(_VAL_) (REG32(ADR_MTX_STATUS)) = (((_VAL_) << 12) | ((REG32(ADR_MTX_STATUS)) & 0xffffefff))
#define SET_DBG_PRTC_PRD(_VAL_) (REG32(ADR_MTX_STATUS)) = (((_VAL_) << 13) | ((REG32(ADR_MTX_STATUS)) & 0xffffdfff))
#define SET_DBG_DMA_RDY(_VAL_) (REG32(ADR_MTX_STATUS)) = (((_VAL_) << 14) | ((REG32(ADR_MTX_STATUS)) & 0xffffbfff))
#define SET_DBG_WAIT_RSP(_VAL_) (REG32(ADR_MTX_STATUS)) = (((_VAL_) << 15) | ((REG32(ADR_MTX_STATUS)) & 0xffff7fff))
#define SET_DBG_CFRM_BUSY(_VAL_) (REG32(ADR_MTX_STATUS)) = (((_VAL_) << 16) | ((REG32(ADR_MTX_STATUS)) & 0xfffeffff))
#define SET_DBG_RST(_VAL_) (REG32(ADR_MTX_DBG_CTRL)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_DBG_CTRL)) & 0xfffffffe))
#define SET_DBG_MODE(_VAL_) (REG32(ADR_MTX_DBG_CTRL)) = (((_VAL_) << 1) | ((REG32(ADR_MTX_DBG_CTRL)) & 0xfffffffd))
#define SET_MB_REQ_DUR(_VAL_) (REG32(ADR_MTX_DBG_DAT0)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_DBG_DAT0)) & 0xffff0000))
#define SET_RX_EN_DUR(_VAL_) (REG32(ADR_MTX_DBG_DAT0)) = (((_VAL_) << 16) | ((REG32(ADR_MTX_DBG_DAT0)) & 0x0000ffff))
#define SET_RX_CS_DUR(_VAL_) (REG32(ADR_MTX_DBG_DAT1)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_DBG_DAT1)) & 0xffff0000))
#define SET_TX_CCA_DUR(_VAL_) (REG32(ADR_MTX_DBG_DAT1)) = (((_VAL_) << 16) | ((REG32(ADR_MTX_DBG_DAT1)) & 0x0000ffff))
#define SET_Q_REQ_DUR(_VAL_) (REG32(ADR_MTX_DBG_DAT2)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_DBG_DAT2)) & 0xffff0000))
#define SET_CH_STA0_DUR(_VAL_) (REG32(ADR_MTX_DBG_DAT2)) = (((_VAL_) << 16) | ((REG32(ADR_MTX_DBG_DAT2)) & 0x0000ffff))
#define SET_MTX_DUR_RSP_TOUT_B(_VAL_) (REG32(ADR_MTX_DUR_TOUT)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_DUR_TOUT)) & 0xffffff00))
#define SET_MTX_DUR_RSP_TOUT_G(_VAL_) (REG32(ADR_MTX_DUR_TOUT)) = (((_VAL_) << 8) | ((REG32(ADR_MTX_DUR_TOUT)) & 0xffff00ff))
#define SET_MTX_DUR_RSP_SIFS(_VAL_) (REG32(ADR_MTX_DUR_IFS)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_DUR_IFS)) & 0xffffff00))
#define SET_MTX_DUR_BURST_SIFS(_VAL_) (REG32(ADR_MTX_DUR_IFS)) = (((_VAL_) << 8) | ((REG32(ADR_MTX_DUR_IFS)) & 0xffff00ff))
#define SET_MTX_DUR_SLOT(_VAL_) (REG32(ADR_MTX_DUR_IFS)) = (((_VAL_) << 16) | ((REG32(ADR_MTX_DUR_IFS)) & 0xffc0ffff))
#define SET_MTX_DUR_RSP_EIFS(_VAL_) (REG32(ADR_MTX_DUR_IFS)) = (((_VAL_) << 22) | ((REG32(ADR_MTX_DUR_IFS)) & 0x003fffff))
#define SET_MTX_DUR_RSP_SIFS_G(_VAL_) (REG32(ADR_MTX_DUR_SIFS_G)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_DUR_SIFS_G)) & 0xffffff00))
#define SET_MTX_DUR_BURST_SIFS_G(_VAL_) (REG32(ADR_MTX_DUR_SIFS_G)) = (((_VAL_) << 8) | ((REG32(ADR_MTX_DUR_SIFS_G)) & 0xffff00ff))
#define SET_MTX_DUR_SLOT_G(_VAL_) (REG32(ADR_MTX_DUR_SIFS_G)) = (((_VAL_) << 16) | ((REG32(ADR_MTX_DUR_SIFS_G)) & 0xffc0ffff))
#define SET_MTX_DUR_RSP_EIFS_G(_VAL_) (REG32(ADR_MTX_DUR_SIFS_G)) = (((_VAL_) << 22) | ((REG32(ADR_MTX_DUR_SIFS_G)) & 0x003fffff))
#define SET_CH_STA1_DUR(_VAL_) (REG32(ADR_MTX_DBG_DAT3)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_DBG_DAT3)) & 0xffff0000))
#define SET_CH_STA2_DUR(_VAL_) (REG32(ADR_MTX_DBG_DAT3)) = (((_VAL_) << 16) | ((REG32(ADR_MTX_DBG_DAT3)) & 0x0000ffff))
#define SET_MTX_NAV(_VAL_) (REG32(ADR_MTX_NAV)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_NAV)) & 0xffff0000))
#define SET_MTX_MIB_CNT0(_VAL_) (REG32(ADR_MTX_MIB_WSID0)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_MIB_WSID0)) & 0xc0000000))
#define SET_MTX_MIB_EN0(_VAL_) (REG32(ADR_MTX_MIB_WSID0)) = (((_VAL_) << 30) | ((REG32(ADR_MTX_MIB_WSID0)) & 0xbfffffff))
#define SET_MTX_MIB_CNT1(_VAL_) (REG32(ADR_MTX_MIB_WSID1)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_MIB_WSID1)) & 0xc0000000))
#define SET_MTX_MIB_EN1(_VAL_) (REG32(ADR_MTX_MIB_WSID1)) = (((_VAL_) << 30) | ((REG32(ADR_MTX_MIB_WSID1)) & 0xbfffffff))
#define SET_CH_STA3_DUR(_VAL_) (REG32(ADR_MTX_DBG_DAT4)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_DBG_DAT4)) & 0xffff0000))
#define SET_CH_STA4_DUR(_VAL_) (REG32(ADR_MTX_DBG_DAT4)) = (((_VAL_) << 16) | ((REG32(ADR_MTX_DBG_DAT4)) & 0x0000ffff))
#define SET_TXQ0_MTX_Q_PRE_LD(_VAL_) (REG32(ADR_TXQ0_MTX_Q_MISC_EN)) = (((_VAL_) << 1) | ((REG32(ADR_TXQ0_MTX_Q_MISC_EN)) & 0xfffffffd))
#define SET_TXQ0_MTX_Q_BKF_CNT_FIXED(_VAL_) (REG32(ADR_TXQ0_MTX_Q_MISC_EN)) = (((_VAL_) << 2) | ((REG32(ADR_TXQ0_MTX_Q_MISC_EN)) & 0xfffffffb))
#define SET_TXQ0_MTX_Q_TXOP_SUB_FRM_TIME(_VAL_) (REG32(ADR_TXQ0_MTX_Q_MISC_EN)) = (((_VAL_) << 3) | ((REG32(ADR_TXQ0_MTX_Q_MISC_EN)) & 0xfffffff7))
#define SET_TXQ0_MTX_Q_MB_NO_RLS(_VAL_) (REG32(ADR_TXQ0_MTX_Q_MISC_EN)) = (((_VAL_) << 4) | ((REG32(ADR_TXQ0_MTX_Q_MISC_EN)) & 0xffffffef))
#define SET_TXQ0_MTX_Q_TXOP_FRC_BUR(_VAL_) (REG32(ADR_TXQ0_MTX_Q_MISC_EN)) = (((_VAL_) << 5) | ((REG32(ADR_TXQ0_MTX_Q_MISC_EN)) & 0xffffffdf))
#define SET_TXQ0_MTX_Q_RND_MODE(_VAL_) (REG32(ADR_TXQ0_MTX_Q_MISC_EN)) = (((_VAL_) << 6) | ((REG32(ADR_TXQ0_MTX_Q_MISC_EN)) & 0xffffff3f))
#define SET_TXQ0_MTX_Q_AIFSN(_VAL_) (REG32(ADR_TXQ0_MTX_Q_AIFSN)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ0_MTX_Q_AIFSN)) & 0xfffffff0))
#define SET_TXQ0_MTX_Q_ECWMIN(_VAL_) (REG32(ADR_TXQ0_MTX_Q_AIFSN)) = (((_VAL_) << 8) | ((REG32(ADR_TXQ0_MTX_Q_AIFSN)) & 0xfffff0ff))
#define SET_TXQ0_MTX_Q_ECWMAX(_VAL_) (REG32(ADR_TXQ0_MTX_Q_AIFSN)) = (((_VAL_) << 12) | ((REG32(ADR_TXQ0_MTX_Q_AIFSN)) & 0xffff0fff))
#define SET_TXQ0_MTX_Q_TXOP_LIMIT(_VAL_) (REG32(ADR_TXQ0_MTX_Q_AIFSN)) = (((_VAL_) << 16) | ((REG32(ADR_TXQ0_MTX_Q_AIFSN)) & 0x0000ffff))
#define SET_TXQ0_MTX_Q_BKF_CNT(_VAL_) (REG32(ADR_TXQ0_MTX_Q_BKF_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ0_MTX_Q_BKF_CNT)) & 0xffff0000))
#define SET_TXQ0_MTX_Q_SRC_LIMIT(_VAL_) (REG32(ADR_TXQ0_MTX_Q_RC_LIMIT)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ0_MTX_Q_RC_LIMIT)) & 0xffffff00))
#define SET_TXQ0_MTX_Q_LRC_LIMIT(_VAL_) (REG32(ADR_TXQ0_MTX_Q_RC_LIMIT)) = (((_VAL_) << 8) | ((REG32(ADR_TXQ0_MTX_Q_RC_LIMIT)) & 0xffff00ff))
#define SET_TXQ0_MTX_Q_ID_MAP_L(_VAL_) (REG32(ADR_TXQ0_MTX_Q_ID_MAP_L)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ0_MTX_Q_ID_MAP_L)) & 0x00000000))
#define SET_TXQ0_MTX_Q_TXOP_CH_THD(_VAL_) (REG32(ADR_TXQ0_MTX_Q_TXOP_CH_THD)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ0_MTX_Q_TXOP_CH_THD)) & 0xffff0000))
#define SET_TXQ0_MTX_Q_TXOP_OV_THD(_VAL_) (REG32(ADR_TXQ0_MTX_Q_TXOP_OV_THD)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ0_MTX_Q_TXOP_OV_THD)) & 0xffff0000))
#define SET_TXQ1_MTX_Q_PRE_LD(_VAL_) (REG32(ADR_TXQ1_MTX_Q_MISC_EN)) = (((_VAL_) << 1) | ((REG32(ADR_TXQ1_MTX_Q_MISC_EN)) & 0xfffffffd))
#define SET_TXQ1_MTX_Q_BKF_CNT_FIXED(_VAL_) (REG32(ADR_TXQ1_MTX_Q_MISC_EN)) = (((_VAL_) << 2) | ((REG32(ADR_TXQ1_MTX_Q_MISC_EN)) & 0xfffffffb))
#define SET_TXQ1_MTX_Q_TXOP_SUB_FRM_TIME(_VAL_) (REG32(ADR_TXQ1_MTX_Q_MISC_EN)) = (((_VAL_) << 3) | ((REG32(ADR_TXQ1_MTX_Q_MISC_EN)) & 0xfffffff7))
#define SET_TXQ1_MTX_Q_MB_NO_RLS(_VAL_) (REG32(ADR_TXQ1_MTX_Q_MISC_EN)) = (((_VAL_) << 4) | ((REG32(ADR_TXQ1_MTX_Q_MISC_EN)) & 0xffffffef))
#define SET_TXQ1_MTX_Q_TXOP_FRC_BUR(_VAL_) (REG32(ADR_TXQ1_MTX_Q_MISC_EN)) = (((_VAL_) << 5) | ((REG32(ADR_TXQ1_MTX_Q_MISC_EN)) & 0xffffffdf))
#define SET_TXQ1_MTX_Q_RND_MODE(_VAL_) (REG32(ADR_TXQ1_MTX_Q_MISC_EN)) = (((_VAL_) << 6) | ((REG32(ADR_TXQ1_MTX_Q_MISC_EN)) & 0xffffff3f))
#define SET_TXQ1_MTX_Q_AIFSN(_VAL_) (REG32(ADR_TXQ1_MTX_Q_AIFSN)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ1_MTX_Q_AIFSN)) & 0xfffffff0))
#define SET_TXQ1_MTX_Q_ECWMIN(_VAL_) (REG32(ADR_TXQ1_MTX_Q_AIFSN)) = (((_VAL_) << 8) | ((REG32(ADR_TXQ1_MTX_Q_AIFSN)) & 0xfffff0ff))
#define SET_TXQ1_MTX_Q_ECWMAX(_VAL_) (REG32(ADR_TXQ1_MTX_Q_AIFSN)) = (((_VAL_) << 12) | ((REG32(ADR_TXQ1_MTX_Q_AIFSN)) & 0xffff0fff))
#define SET_TXQ1_MTX_Q_TXOP_LIMIT(_VAL_) (REG32(ADR_TXQ1_MTX_Q_AIFSN)) = (((_VAL_) << 16) | ((REG32(ADR_TXQ1_MTX_Q_AIFSN)) & 0x0000ffff))
#define SET_TXQ1_MTX_Q_BKF_CNT(_VAL_) (REG32(ADR_TXQ1_MTX_Q_BKF_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ1_MTX_Q_BKF_CNT)) & 0xffff0000))
#define SET_TXQ1_MTX_Q_SRC_LIMIT(_VAL_) (REG32(ADR_TXQ1_MTX_Q_RC_LIMIT)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ1_MTX_Q_RC_LIMIT)) & 0xffffff00))
#define SET_TXQ1_MTX_Q_LRC_LIMIT(_VAL_) (REG32(ADR_TXQ1_MTX_Q_RC_LIMIT)) = (((_VAL_) << 8) | ((REG32(ADR_TXQ1_MTX_Q_RC_LIMIT)) & 0xffff00ff))
#define SET_TXQ1_MTX_Q_ID_MAP_L(_VAL_) (REG32(ADR_TXQ1_MTX_Q_ID_MAP_L)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ1_MTX_Q_ID_MAP_L)) & 0x00000000))
#define SET_TXQ1_MTX_Q_TXOP_CH_THD(_VAL_) (REG32(ADR_TXQ1_MTX_Q_TXOP_CH_THD)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ1_MTX_Q_TXOP_CH_THD)) & 0xffff0000))
#define SET_TXQ1_MTX_Q_TXOP_OV_THD(_VAL_) (REG32(ADR_TXQ1_MTX_Q_TXOP_OV_THD)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ1_MTX_Q_TXOP_OV_THD)) & 0xffff0000))
#define SET_TXQ2_MTX_Q_PRE_LD(_VAL_) (REG32(ADR_TXQ2_MTX_Q_MISC_EN)) = (((_VAL_) << 1) | ((REG32(ADR_TXQ2_MTX_Q_MISC_EN)) & 0xfffffffd))
#define SET_TXQ2_MTX_Q_BKF_CNT_FIXED(_VAL_) (REG32(ADR_TXQ2_MTX_Q_MISC_EN)) = (((_VAL_) << 2) | ((REG32(ADR_TXQ2_MTX_Q_MISC_EN)) & 0xfffffffb))
#define SET_TXQ2_MTX_Q_TXOP_SUB_FRM_TIME(_VAL_) (REG32(ADR_TXQ2_MTX_Q_MISC_EN)) = (((_VAL_) << 3) | ((REG32(ADR_TXQ2_MTX_Q_MISC_EN)) & 0xfffffff7))
#define SET_TXQ2_MTX_Q_MB_NO_RLS(_VAL_) (REG32(ADR_TXQ2_MTX_Q_MISC_EN)) = (((_VAL_) << 4) | ((REG32(ADR_TXQ2_MTX_Q_MISC_EN)) & 0xffffffef))
#define SET_TXQ2_MTX_Q_TXOP_FRC_BUR(_VAL_) (REG32(ADR_TXQ2_MTX_Q_MISC_EN)) = (((_VAL_) << 5) | ((REG32(ADR_TXQ2_MTX_Q_MISC_EN)) & 0xffffffdf))
#define SET_TXQ2_MTX_Q_RND_MODE(_VAL_) (REG32(ADR_TXQ2_MTX_Q_MISC_EN)) = (((_VAL_) << 6) | ((REG32(ADR_TXQ2_MTX_Q_MISC_EN)) & 0xffffff3f))
#define SET_TXQ2_MTX_Q_AIFSN(_VAL_) (REG32(ADR_TXQ2_MTX_Q_AIFSN)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ2_MTX_Q_AIFSN)) & 0xfffffff0))
#define SET_TXQ2_MTX_Q_ECWMIN(_VAL_) (REG32(ADR_TXQ2_MTX_Q_AIFSN)) = (((_VAL_) << 8) | ((REG32(ADR_TXQ2_MTX_Q_AIFSN)) & 0xfffff0ff))
#define SET_TXQ2_MTX_Q_ECWMAX(_VAL_) (REG32(ADR_TXQ2_MTX_Q_AIFSN)) = (((_VAL_) << 12) | ((REG32(ADR_TXQ2_MTX_Q_AIFSN)) & 0xffff0fff))
#define SET_TXQ2_MTX_Q_TXOP_LIMIT(_VAL_) (REG32(ADR_TXQ2_MTX_Q_AIFSN)) = (((_VAL_) << 16) | ((REG32(ADR_TXQ2_MTX_Q_AIFSN)) & 0x0000ffff))
#define SET_TXQ2_MTX_Q_BKF_CNT(_VAL_) (REG32(ADR_TXQ2_MTX_Q_BKF_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ2_MTX_Q_BKF_CNT)) & 0xffff0000))
#define SET_TXQ2_MTX_Q_SRC_LIMIT(_VAL_) (REG32(ADR_TXQ2_MTX_Q_RC_LIMIT)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ2_MTX_Q_RC_LIMIT)) & 0xffffff00))
#define SET_TXQ2_MTX_Q_LRC_LIMIT(_VAL_) (REG32(ADR_TXQ2_MTX_Q_RC_LIMIT)) = (((_VAL_) << 8) | ((REG32(ADR_TXQ2_MTX_Q_RC_LIMIT)) & 0xffff00ff))
#define SET_TXQ2_MTX_Q_ID_MAP_L(_VAL_) (REG32(ADR_TXQ2_MTX_Q_ID_MAP_L)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ2_MTX_Q_ID_MAP_L)) & 0x00000000))
#define SET_TXQ2_MTX_Q_TXOP_CH_THD(_VAL_) (REG32(ADR_TXQ2_MTX_Q_TXOP_CH_THD)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ2_MTX_Q_TXOP_CH_THD)) & 0xffff0000))
#define SET_TXQ2_MTX_Q_TXOP_OV_THD(_VAL_) (REG32(ADR_TXQ2_MTX_Q_TXOP_OV_THD)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ2_MTX_Q_TXOP_OV_THD)) & 0xffff0000))
#define SET_TXQ3_MTX_Q_PRE_LD(_VAL_) (REG32(ADR_TXQ3_MTX_Q_MISC_EN)) = (((_VAL_) << 1) | ((REG32(ADR_TXQ3_MTX_Q_MISC_EN)) & 0xfffffffd))
#define SET_TXQ3_MTX_Q_BKF_CNT_FIXED(_VAL_) (REG32(ADR_TXQ3_MTX_Q_MISC_EN)) = (((_VAL_) << 2) | ((REG32(ADR_TXQ3_MTX_Q_MISC_EN)) & 0xfffffffb))
#define SET_TXQ3_MTX_Q_TXOP_SUB_FRM_TIME(_VAL_) (REG32(ADR_TXQ3_MTX_Q_MISC_EN)) = (((_VAL_) << 3) | ((REG32(ADR_TXQ3_MTX_Q_MISC_EN)) & 0xfffffff7))
#define SET_TXQ3_MTX_Q_MB_NO_RLS(_VAL_) (REG32(ADR_TXQ3_MTX_Q_MISC_EN)) = (((_VAL_) << 4) | ((REG32(ADR_TXQ3_MTX_Q_MISC_EN)) & 0xffffffef))
#define SET_TXQ3_MTX_Q_TXOP_FRC_BUR(_VAL_) (REG32(ADR_TXQ3_MTX_Q_MISC_EN)) = (((_VAL_) << 5) | ((REG32(ADR_TXQ3_MTX_Q_MISC_EN)) & 0xffffffdf))
#define SET_TXQ3_MTX_Q_RND_MODE(_VAL_) (REG32(ADR_TXQ3_MTX_Q_MISC_EN)) = (((_VAL_) << 6) | ((REG32(ADR_TXQ3_MTX_Q_MISC_EN)) & 0xffffff3f))
#define SET_TXQ3_MTX_Q_AIFSN(_VAL_) (REG32(ADR_TXQ3_MTX_Q_AIFSN)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ3_MTX_Q_AIFSN)) & 0xfffffff0))
#define SET_TXQ3_MTX_Q_ECWMIN(_VAL_) (REG32(ADR_TXQ3_MTX_Q_AIFSN)) = (((_VAL_) << 8) | ((REG32(ADR_TXQ3_MTX_Q_AIFSN)) & 0xfffff0ff))
#define SET_TXQ3_MTX_Q_ECWMAX(_VAL_) (REG32(ADR_TXQ3_MTX_Q_AIFSN)) = (((_VAL_) << 12) | ((REG32(ADR_TXQ3_MTX_Q_AIFSN)) & 0xffff0fff))
#define SET_TXQ3_MTX_Q_TXOP_LIMIT(_VAL_) (REG32(ADR_TXQ3_MTX_Q_AIFSN)) = (((_VAL_) << 16) | ((REG32(ADR_TXQ3_MTX_Q_AIFSN)) & 0x0000ffff))
#define SET_TXQ3_MTX_Q_BKF_CNT(_VAL_) (REG32(ADR_TXQ3_MTX_Q_BKF_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ3_MTX_Q_BKF_CNT)) & 0xffff0000))
#define SET_TXQ3_MTX_Q_SRC_LIMIT(_VAL_) (REG32(ADR_TXQ3_MTX_Q_RC_LIMIT)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ3_MTX_Q_RC_LIMIT)) & 0xffffff00))
#define SET_TXQ3_MTX_Q_LRC_LIMIT(_VAL_) (REG32(ADR_TXQ3_MTX_Q_RC_LIMIT)) = (((_VAL_) << 8) | ((REG32(ADR_TXQ3_MTX_Q_RC_LIMIT)) & 0xffff00ff))
#define SET_TXQ3_MTX_Q_ID_MAP_L(_VAL_) (REG32(ADR_TXQ3_MTX_Q_ID_MAP_L)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ3_MTX_Q_ID_MAP_L)) & 0x00000000))
#define SET_TXQ3_MTX_Q_TXOP_CH_THD(_VAL_) (REG32(ADR_TXQ3_MTX_Q_TXOP_CH_THD)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ3_MTX_Q_TXOP_CH_THD)) & 0xffff0000))
#define SET_TXQ3_MTX_Q_TXOP_OV_THD(_VAL_) (REG32(ADR_TXQ3_MTX_Q_TXOP_OV_THD)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ3_MTX_Q_TXOP_OV_THD)) & 0xffff0000))
#define SET_TXQ4_MTX_Q_PRE_LD(_VAL_) (REG32(ADR_TXQ4_MTX_Q_MISC_EN)) = (((_VAL_) << 1) | ((REG32(ADR_TXQ4_MTX_Q_MISC_EN)) & 0xfffffffd))
#define SET_TXQ4_MTX_Q_BKF_CNT_FIXED(_VAL_) (REG32(ADR_TXQ4_MTX_Q_MISC_EN)) = (((_VAL_) << 2) | ((REG32(ADR_TXQ4_MTX_Q_MISC_EN)) & 0xfffffffb))
#define SET_TXQ4_MTX_Q_TXOP_SUB_FRM_TIME(_VAL_) (REG32(ADR_TXQ4_MTX_Q_MISC_EN)) = (((_VAL_) << 3) | ((REG32(ADR_TXQ4_MTX_Q_MISC_EN)) & 0xfffffff7))
#define SET_TXQ4_MTX_Q_MB_NO_RLS(_VAL_) (REG32(ADR_TXQ4_MTX_Q_MISC_EN)) = (((_VAL_) << 4) | ((REG32(ADR_TXQ4_MTX_Q_MISC_EN)) & 0xffffffef))
#define SET_TXQ4_MTX_Q_TXOP_FRC_BUR(_VAL_) (REG32(ADR_TXQ4_MTX_Q_MISC_EN)) = (((_VAL_) << 5) | ((REG32(ADR_TXQ4_MTX_Q_MISC_EN)) & 0xffffffdf))
#define SET_TXQ4_MTX_Q_RND_MODE(_VAL_) (REG32(ADR_TXQ4_MTX_Q_MISC_EN)) = (((_VAL_) << 6) | ((REG32(ADR_TXQ4_MTX_Q_MISC_EN)) & 0xffffff3f))
#define SET_TXQ4_MTX_Q_AIFSN(_VAL_) (REG32(ADR_TXQ4_MTX_Q_AIFSN)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ4_MTX_Q_AIFSN)) & 0xfffffff0))
#define SET_TXQ4_MTX_Q_ECWMIN(_VAL_) (REG32(ADR_TXQ4_MTX_Q_AIFSN)) = (((_VAL_) << 8) | ((REG32(ADR_TXQ4_MTX_Q_AIFSN)) & 0xfffff0ff))
#define SET_TXQ4_MTX_Q_ECWMAX(_VAL_) (REG32(ADR_TXQ4_MTX_Q_AIFSN)) = (((_VAL_) << 12) | ((REG32(ADR_TXQ4_MTX_Q_AIFSN)) & 0xffff0fff))
#define SET_TXQ4_MTX_Q_TXOP_LIMIT(_VAL_) (REG32(ADR_TXQ4_MTX_Q_AIFSN)) = (((_VAL_) << 16) | ((REG32(ADR_TXQ4_MTX_Q_AIFSN)) & 0x0000ffff))
#define SET_TXQ4_MTX_Q_BKF_CNT(_VAL_) (REG32(ADR_TXQ4_MTX_Q_BKF_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ4_MTX_Q_BKF_CNT)) & 0xffff0000))
#define SET_TXQ4_MTX_Q_SRC_LIMIT(_VAL_) (REG32(ADR_TXQ4_MTX_Q_RC_LIMIT)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ4_MTX_Q_RC_LIMIT)) & 0xffffff00))
#define SET_TXQ4_MTX_Q_LRC_LIMIT(_VAL_) (REG32(ADR_TXQ4_MTX_Q_RC_LIMIT)) = (((_VAL_) << 8) | ((REG32(ADR_TXQ4_MTX_Q_RC_LIMIT)) & 0xffff00ff))
#define SET_TXQ4_MTX_Q_ID_MAP_L(_VAL_) (REG32(ADR_TXQ4_MTX_Q_ID_MAP_L)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ4_MTX_Q_ID_MAP_L)) & 0x00000000))
#define SET_TXQ4_MTX_Q_TXOP_CH_THD(_VAL_) (REG32(ADR_TXQ4_MTX_Q_TXOP_CH_THD)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ4_MTX_Q_TXOP_CH_THD)) & 0xffff0000))
#define SET_TXQ4_MTX_Q_TXOP_OV_THD(_VAL_) (REG32(ADR_TXQ4_MTX_Q_TXOP_OV_THD)) = (((_VAL_) << 0) | ((REG32(ADR_TXQ4_MTX_Q_TXOP_OV_THD)) & 0xffff0000))
#define SET_VALID0(_VAL_) (REG32(ADR_WSID0)) = (((_VAL_) << 0) | ((REG32(ADR_WSID0)) & 0xfffffffe))
#define SET_PEER_QOS_EN0(_VAL_) (REG32(ADR_WSID0)) = (((_VAL_) << 1) | ((REG32(ADR_WSID0)) & 0xfffffffd))
#define SET_PEER_OP_MODE0(_VAL_) (REG32(ADR_WSID0)) = (((_VAL_) << 2) | ((REG32(ADR_WSID0)) & 0xfffffff3))
#define SET_PEER_HT_MODE0(_VAL_) (REG32(ADR_WSID0)) = (((_VAL_) << 4) | ((REG32(ADR_WSID0)) & 0xffffffcf))
#define SET_PEER_MAC0_31_0(_VAL_) (REG32(ADR_PEER_MAC0_0)) = (((_VAL_) << 0) | ((REG32(ADR_PEER_MAC0_0)) & 0x00000000))
#define SET_PEER_MAC0_47_32(_VAL_) (REG32(ADR_PEER_MAC0_1)) = (((_VAL_) << 0) | ((REG32(ADR_PEER_MAC0_1)) & 0xffff0000))
#define SET_TX_ACK_POLICY_0_0(_VAL_) (REG32(ADR_TX_ACK_POLICY_0_0)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ACK_POLICY_0_0)) & 0xfffffffc))
#define SET_TX_SEQ_CTRL_0_0(_VAL_) (REG32(ADR_TX_SEQ_CTRL_0_0)) = (((_VAL_) << 0) | ((REG32(ADR_TX_SEQ_CTRL_0_0)) & 0xfffff000))
#define SET_TX_ACK_POLICY_0_1(_VAL_) (REG32(ADR_TX_ACK_POLICY_0_1)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ACK_POLICY_0_1)) & 0xfffffffc))
#define SET_TX_SEQ_CTRL_0_1(_VAL_) (REG32(ADR_TX_SEQ_CTRL_0_1)) = (((_VAL_) << 0) | ((REG32(ADR_TX_SEQ_CTRL_0_1)) & 0xfffff000))
#define SET_TX_ACK_POLICY_0_2(_VAL_) (REG32(ADR_TX_ACK_POLICY_0_2)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ACK_POLICY_0_2)) & 0xfffffffc))
#define SET_TX_SEQ_CTRL_0_2(_VAL_) (REG32(ADR_TX_SEQ_CTRL_0_2)) = (((_VAL_) << 0) | ((REG32(ADR_TX_SEQ_CTRL_0_2)) & 0xfffff000))
#define SET_TX_ACK_POLICY_0_3(_VAL_) (REG32(ADR_TX_ACK_POLICY_0_3)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ACK_POLICY_0_3)) & 0xfffffffc))
#define SET_TX_SEQ_CTRL_0_3(_VAL_) (REG32(ADR_TX_SEQ_CTRL_0_3)) = (((_VAL_) << 0) | ((REG32(ADR_TX_SEQ_CTRL_0_3)) & 0xfffff000))
#define SET_TX_ACK_POLICY_0_4(_VAL_) (REG32(ADR_TX_ACK_POLICY_0_4)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ACK_POLICY_0_4)) & 0xfffffffc))
#define SET_TX_SEQ_CTRL_0_4(_VAL_) (REG32(ADR_TX_SEQ_CTRL_0_4)) = (((_VAL_) << 0) | ((REG32(ADR_TX_SEQ_CTRL_0_4)) & 0xfffff000))
#define SET_TX_ACK_POLICY_0_5(_VAL_) (REG32(ADR_TX_ACK_POLICY_0_5)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ACK_POLICY_0_5)) & 0xfffffffc))
#define SET_TX_SEQ_CTRL_0_5(_VAL_) (REG32(ADR_TX_SEQ_CTRL_0_5)) = (((_VAL_) << 0) | ((REG32(ADR_TX_SEQ_CTRL_0_5)) & 0xfffff000))
#define SET_TX_ACK_POLICY_0_6(_VAL_) (REG32(ADR_TX_ACK_POLICY_0_6)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ACK_POLICY_0_6)) & 0xfffffffc))
#define SET_TX_SEQ_CTRL_0_6(_VAL_) (REG32(ADR_TX_SEQ_CTRL_0_6)) = (((_VAL_) << 0) | ((REG32(ADR_TX_SEQ_CTRL_0_6)) & 0xfffff000))
#define SET_TX_ACK_POLICY_0_7(_VAL_) (REG32(ADR_TX_ACK_POLICY_0_7)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ACK_POLICY_0_7)) & 0xfffffffc))
#define SET_TX_SEQ_CTRL_0_7(_VAL_) (REG32(ADR_TX_SEQ_CTRL_0_7)) = (((_VAL_) << 0) | ((REG32(ADR_TX_SEQ_CTRL_0_7)) & 0xfffff000))
#define SET_VALID1(_VAL_) (REG32(ADR_WSID1)) = (((_VAL_) << 0) | ((REG32(ADR_WSID1)) & 0xfffffffe))
#define SET_PEER_QOS_EN1(_VAL_) (REG32(ADR_WSID1)) = (((_VAL_) << 1) | ((REG32(ADR_WSID1)) & 0xfffffffd))
#define SET_PEER_OP_MODE1(_VAL_) (REG32(ADR_WSID1)) = (((_VAL_) << 2) | ((REG32(ADR_WSID1)) & 0xfffffff3))
#define SET_PEER_HT_MODE1(_VAL_) (REG32(ADR_WSID1)) = (((_VAL_) << 4) | ((REG32(ADR_WSID1)) & 0xffffffcf))
#define SET_PEER_MAC1_31_0(_VAL_) (REG32(ADR_PEER_MAC1_0)) = (((_VAL_) << 0) | ((REG32(ADR_PEER_MAC1_0)) & 0x00000000))
#define SET_PEER_MAC1_47_32(_VAL_) (REG32(ADR_PEER_MAC1_1)) = (((_VAL_) << 0) | ((REG32(ADR_PEER_MAC1_1)) & 0xffff0000))
#define SET_TX_ACK_POLICY_1_0(_VAL_) (REG32(ADR_TX_ACK_POLICY_1_0)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ACK_POLICY_1_0)) & 0xfffffffc))
#define SET_TX_SEQ_CTRL_1_0(_VAL_) (REG32(ADR_TX_SEQ_CTRL_1_0)) = (((_VAL_) << 0) | ((REG32(ADR_TX_SEQ_CTRL_1_0)) & 0xfffff000))
#define SET_TX_ACK_POLICY_1_1(_VAL_) (REG32(ADR_TX_ACK_POLICY_1_1)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ACK_POLICY_1_1)) & 0xfffffffc))
#define SET_TX_SEQ_CTRL_1_1(_VAL_) (REG32(ADR_TX_SEQ_CTRL_1_1)) = (((_VAL_) << 0) | ((REG32(ADR_TX_SEQ_CTRL_1_1)) & 0xfffff000))
#define SET_TX_ACK_POLICY_1_2(_VAL_) (REG32(ADR_TX_ACK_POLICY_1_2)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ACK_POLICY_1_2)) & 0xfffffffc))
#define SET_TX_SEQ_CTRL_1_2(_VAL_) (REG32(ADR_TX_SEQ_CTRL_1_2)) = (((_VAL_) << 0) | ((REG32(ADR_TX_SEQ_CTRL_1_2)) & 0xfffff000))
#define SET_TX_ACK_POLICY_1_3(_VAL_) (REG32(ADR_TX_ACK_POLICY_1_3)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ACK_POLICY_1_3)) & 0xfffffffc))
#define SET_TX_SEQ_CTRL_1_3(_VAL_) (REG32(ADR_TX_SEQ_CTRL_1_3)) = (((_VAL_) << 0) | ((REG32(ADR_TX_SEQ_CTRL_1_3)) & 0xfffff000))
#define SET_TX_ACK_POLICY_1_4(_VAL_) (REG32(ADR_TX_ACK_POLICY_1_4)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ACK_POLICY_1_4)) & 0xfffffffc))
#define SET_TX_SEQ_CTRL_1_4(_VAL_) (REG32(ADR_TX_SEQ_CTRL_1_4)) = (((_VAL_) << 0) | ((REG32(ADR_TX_SEQ_CTRL_1_4)) & 0xfffff000))
#define SET_TX_ACK_POLICY_1_5(_VAL_) (REG32(ADR_TX_ACK_POLICY_1_5)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ACK_POLICY_1_5)) & 0xfffffffc))
#define SET_TX_SEQ_CTRL_1_5(_VAL_) (REG32(ADR_TX_SEQ_CTRL_1_5)) = (((_VAL_) << 0) | ((REG32(ADR_TX_SEQ_CTRL_1_5)) & 0xfffff000))
#define SET_TX_ACK_POLICY_1_6(_VAL_) (REG32(ADR_TX_ACK_POLICY_1_6)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ACK_POLICY_1_6)) & 0xfffffffc))
#define SET_TX_SEQ_CTRL_1_6(_VAL_) (REG32(ADR_TX_SEQ_CTRL_1_6)) = (((_VAL_) << 0) | ((REG32(ADR_TX_SEQ_CTRL_1_6)) & 0xfffff000))
#define SET_TX_ACK_POLICY_1_7(_VAL_) (REG32(ADR_TX_ACK_POLICY_1_7)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ACK_POLICY_1_7)) & 0xfffffffc))
#define SET_TX_SEQ_CTRL_1_7(_VAL_) (REG32(ADR_TX_SEQ_CTRL_1_7)) = (((_VAL_) << 0) | ((REG32(ADR_TX_SEQ_CTRL_1_7)) & 0xfffff000))
#define SET_INFO0(_VAL_) (REG32(ADR_INFO0)) = (((_VAL_) << 0) | ((REG32(ADR_INFO0)) & 0x00000000))
#define SET_INFO1(_VAL_) (REG32(ADR_INFO1)) = (((_VAL_) << 0) | ((REG32(ADR_INFO1)) & 0x00000000))
#define SET_INFO2(_VAL_) (REG32(ADR_INFO2)) = (((_VAL_) << 0) | ((REG32(ADR_INFO2)) & 0x00000000))
#define SET_INFO3(_VAL_) (REG32(ADR_INFO3)) = (((_VAL_) << 0) | ((REG32(ADR_INFO3)) & 0x00000000))
#define SET_INFO4(_VAL_) (REG32(ADR_INFO4)) = (((_VAL_) << 0) | ((REG32(ADR_INFO4)) & 0x00000000))
#define SET_INFO5(_VAL_) (REG32(ADR_INFO5)) = (((_VAL_) << 0) | ((REG32(ADR_INFO5)) & 0x00000000))
#define SET_INFO6(_VAL_) (REG32(ADR_INFO6)) = (((_VAL_) << 0) | ((REG32(ADR_INFO6)) & 0x00000000))
#define SET_INFO7(_VAL_) (REG32(ADR_INFO7)) = (((_VAL_) << 0) | ((REG32(ADR_INFO7)) & 0x00000000))
#define SET_INFO8(_VAL_) (REG32(ADR_INFO8)) = (((_VAL_) << 0) | ((REG32(ADR_INFO8)) & 0x00000000))
#define SET_INFO9(_VAL_) (REG32(ADR_INFO9)) = (((_VAL_) << 0) | ((REG32(ADR_INFO9)) & 0x00000000))
#define SET_INFO10(_VAL_) (REG32(ADR_INFO10)) = (((_VAL_) << 0) | ((REG32(ADR_INFO10)) & 0x00000000))
#define SET_INFO11(_VAL_) (REG32(ADR_INFO11)) = (((_VAL_) << 0) | ((REG32(ADR_INFO11)) & 0x00000000))
#define SET_INFO12(_VAL_) (REG32(ADR_INFO12)) = (((_VAL_) << 0) | ((REG32(ADR_INFO12)) & 0x00000000))
#define SET_INFO13(_VAL_) (REG32(ADR_INFO13)) = (((_VAL_) << 0) | ((REG32(ADR_INFO13)) & 0x00000000))
#define SET_INFO14(_VAL_) (REG32(ADR_INFO14)) = (((_VAL_) << 0) | ((REG32(ADR_INFO14)) & 0x00000000))
#define SET_INFO15(_VAL_) (REG32(ADR_INFO15)) = (((_VAL_) << 0) | ((REG32(ADR_INFO15)) & 0x00000000))
#define SET_INFO16(_VAL_) (REG32(ADR_INFO16)) = (((_VAL_) << 0) | ((REG32(ADR_INFO16)) & 0x00000000))
#define SET_INFO17(_VAL_) (REG32(ADR_INFO17)) = (((_VAL_) << 0) | ((REG32(ADR_INFO17)) & 0x00000000))
#define SET_INFO18(_VAL_) (REG32(ADR_INFO18)) = (((_VAL_) << 0) | ((REG32(ADR_INFO18)) & 0x00000000))
#define SET_INFO19(_VAL_) (REG32(ADR_INFO19)) = (((_VAL_) << 0) | ((REG32(ADR_INFO19)) & 0x00000000))
#define SET_INFO20(_VAL_) (REG32(ADR_INFO20)) = (((_VAL_) << 0) | ((REG32(ADR_INFO20)) & 0x00000000))
#define SET_INFO21(_VAL_) (REG32(ADR_INFO21)) = (((_VAL_) << 0) | ((REG32(ADR_INFO21)) & 0x00000000))
#define SET_INFO22(_VAL_) (REG32(ADR_INFO22)) = (((_VAL_) << 0) | ((REG32(ADR_INFO22)) & 0x00000000))
#define SET_INFO23(_VAL_) (REG32(ADR_INFO23)) = (((_VAL_) << 0) | ((REG32(ADR_INFO23)) & 0x00000000))
#define SET_INFO24(_VAL_) (REG32(ADR_INFO24)) = (((_VAL_) << 0) | ((REG32(ADR_INFO24)) & 0x00000000))
#define SET_INFO25(_VAL_) (REG32(ADR_INFO25)) = (((_VAL_) << 0) | ((REG32(ADR_INFO25)) & 0x00000000))
#define SET_INFO26(_VAL_) (REG32(ADR_INFO26)) = (((_VAL_) << 0) | ((REG32(ADR_INFO26)) & 0x00000000))
#define SET_INFO27(_VAL_) (REG32(ADR_INFO27)) = (((_VAL_) << 0) | ((REG32(ADR_INFO27)) & 0x00000000))
#define SET_INFO28(_VAL_) (REG32(ADR_INFO28)) = (((_VAL_) << 0) | ((REG32(ADR_INFO28)) & 0x00000000))
#define SET_INFO29(_VAL_) (REG32(ADR_INFO29)) = (((_VAL_) << 0) | ((REG32(ADR_INFO29)) & 0x00000000))
#define SET_INFO30(_VAL_) (REG32(ADR_INFO30)) = (((_VAL_) << 0) | ((REG32(ADR_INFO30)) & 0x00000000))
#define SET_INFO31(_VAL_) (REG32(ADR_INFO31)) = (((_VAL_) << 0) | ((REG32(ADR_INFO31)) & 0x00000000))
#define SET_INFO32(_VAL_) (REG32(ADR_INFO32)) = (((_VAL_) << 0) | ((REG32(ADR_INFO32)) & 0x00000000))
#define SET_INFO33(_VAL_) (REG32(ADR_INFO33)) = (((_VAL_) << 0) | ((REG32(ADR_INFO33)) & 0x00000000))
#define SET_INFO34(_VAL_) (REG32(ADR_INFO34)) = (((_VAL_) << 0) | ((REG32(ADR_INFO34)) & 0x00000000))
#define SET_INFO35(_VAL_) (REG32(ADR_INFO35)) = (((_VAL_) << 0) | ((REG32(ADR_INFO35)) & 0x00000000))
#define SET_INFO36(_VAL_) (REG32(ADR_INFO36)) = (((_VAL_) << 0) | ((REG32(ADR_INFO36)) & 0x00000000))
#define SET_INFO37(_VAL_) (REG32(ADR_INFO37)) = (((_VAL_) << 0) | ((REG32(ADR_INFO37)) & 0x00000000))
#define SET_INFO38(_VAL_) (REG32(ADR_INFO38)) = (((_VAL_) << 0) | ((REG32(ADR_INFO38)) & 0x00000000))
#define SET_INFO_MASK(_VAL_) (REG32(ADR_INFO_MASK)) = (((_VAL_) << 0) | ((REG32(ADR_INFO_MASK)) & 0x00000000))
#define SET_INFO_DEF_RATE(_VAL_) (REG32(ADR_INFO_RATE_OFFSET)) = (((_VAL_) << 0) | ((REG32(ADR_INFO_RATE_OFFSET)) & 0xffffffc0))
#define SET_INFO_MRX_OFFSET(_VAL_) (REG32(ADR_INFO_RATE_OFFSET)) = (((_VAL_) << 16) | ((REG32(ADR_INFO_RATE_OFFSET)) & 0xfff0ffff))
#define SET_BCAST_RATEUNKNOW(_VAL_) (REG32(ADR_INFO_RATE_OFFSET)) = (((_VAL_) << 24) | ((REG32(ADR_INFO_RATE_OFFSET)) & 0xc0ffffff))
#define SET_INFO_IDX_TBL_ADDR(_VAL_) (REG32(ADR_INFO_IDX_ADDR)) = (((_VAL_) << 0) | ((REG32(ADR_INFO_IDX_ADDR)) & 0x00000000))
#define SET_INFO_LEN_TBL_ADDR(_VAL_) (REG32(ADR_INFO_LEN_ADDR)) = (((_VAL_) << 0) | ((REG32(ADR_INFO_LEN_ADDR)) & 0x00000000))
#define SET_IC_TAG_31_0(_VAL_) (REG32(ADR_IC_TIME_TAG_0)) = (((_VAL_) << 0) | ((REG32(ADR_IC_TIME_TAG_0)) & 0x00000000))
#define SET_IC_TAG_63_32(_VAL_) (REG32(ADR_IC_TIME_TAG_1)) = (((_VAL_) << 0) | ((REG32(ADR_IC_TIME_TAG_1)) & 0x00000000))
#define SET_CH1_PRI(_VAL_) (REG32(ADR_PACKET_ID_ALLOCATION_PRIORITY)) = (((_VAL_) << 0) | ((REG32(ADR_PACKET_ID_ALLOCATION_PRIORITY)) & 0xfffffffc))
#define SET_CH2_PRI(_VAL_) (REG32(ADR_PACKET_ID_ALLOCATION_PRIORITY)) = (((_VAL_) << 8) | ((REG32(ADR_PACKET_ID_ALLOCATION_PRIORITY)) & 0xfffffcff))
#define SET_CH3_PRI(_VAL_) (REG32(ADR_PACKET_ID_ALLOCATION_PRIORITY)) = (((_VAL_) << 16) | ((REG32(ADR_PACKET_ID_ALLOCATION_PRIORITY)) & 0xfffcffff))
#define SET_RG_MAC_LPBK(_VAL_) (REG32(ADR_MAC_MODE)) = (((_VAL_) << 0) | ((REG32(ADR_MAC_MODE)) & 0xfffffffe))
#define SET_RG_MAC_M2M(_VAL_) (REG32(ADR_MAC_MODE)) = (((_VAL_) << 1) | ((REG32(ADR_MAC_MODE)) & 0xfffffffd))
#define SET_RG_PHY_LPBK(_VAL_) (REG32(ADR_MAC_MODE)) = (((_VAL_) << 2) | ((REG32(ADR_MAC_MODE)) & 0xfffffffb))
#define SET_RG_LPBK_RX_EN(_VAL_) (REG32(ADR_MAC_MODE)) = (((_VAL_) << 3) | ((REG32(ADR_MAC_MODE)) & 0xfffffff7))
#define SET_EXT_MAC_MODE(_VAL_) (REG32(ADR_MAC_MODE)) = (((_VAL_) << 4) | ((REG32(ADR_MAC_MODE)) & 0xffffffef))
#define SET_EXT_PHY_MODE(_VAL_) (REG32(ADR_MAC_MODE)) = (((_VAL_) << 5) | ((REG32(ADR_MAC_MODE)) & 0xffffffdf))
#define SET_ASIC_TAG(_VAL_) (REG32(ADR_MAC_MODE)) = (((_VAL_) << 24) | ((REG32(ADR_MAC_MODE)) & 0x00ffffff))
#define SET_HCI_SW_RST(_VAL_) (REG32(ADR_ALL_SOFTWARE_RESET)) = (((_VAL_) << 0) | ((REG32(ADR_ALL_SOFTWARE_RESET)) & 0xfffffffe))
#define SET_CO_PROC_SW_RST(_VAL_) (REG32(ADR_ALL_SOFTWARE_RESET)) = (((_VAL_) << 1) | ((REG32(ADR_ALL_SOFTWARE_RESET)) & 0xfffffffd))
#define SET_MTX_MISC_SW_RST(_VAL_) (REG32(ADR_ALL_SOFTWARE_RESET)) = (((_VAL_) << 3) | ((REG32(ADR_ALL_SOFTWARE_RESET)) & 0xfffffff7))
#define SET_MTX_QUE_SW_RST(_VAL_) (REG32(ADR_ALL_SOFTWARE_RESET)) = (((_VAL_) << 4) | ((REG32(ADR_ALL_SOFTWARE_RESET)) & 0xffffffef))
#define SET_MTX_CHST_SW_RST(_VAL_) (REG32(ADR_ALL_SOFTWARE_RESET)) = (((_VAL_) << 5) | ((REG32(ADR_ALL_SOFTWARE_RESET)) & 0xffffffdf))
#define SET_MTX_BCN_SW_RST(_VAL_) (REG32(ADR_ALL_SOFTWARE_RESET)) = (((_VAL_) << 6) | ((REG32(ADR_ALL_SOFTWARE_RESET)) & 0xffffffbf))
#define SET_MRX_SW_RST(_VAL_) (REG32(ADR_ALL_SOFTWARE_RESET)) = (((_VAL_) << 7) | ((REG32(ADR_ALL_SOFTWARE_RESET)) & 0xffffff7f))
#define SET_AMPDU_SW_RST(_VAL_) (REG32(ADR_ALL_SOFTWARE_RESET)) = (((_VAL_) << 8) | ((REG32(ADR_ALL_SOFTWARE_RESET)) & 0xfffffeff))
#define SET_MMU_SW_RST(_VAL_) (REG32(ADR_ALL_SOFTWARE_RESET)) = (((_VAL_) << 9) | ((REG32(ADR_ALL_SOFTWARE_RESET)) & 0xfffffdff))
#define SET_ID_MNG_SW_RST(_VAL_) (REG32(ADR_ALL_SOFTWARE_RESET)) = (((_VAL_) << 11) | ((REG32(ADR_ALL_SOFTWARE_RESET)) & 0xfffff7ff))
#define SET_MBOX_SW_RST(_VAL_) (REG32(ADR_ALL_SOFTWARE_RESET)) = (((_VAL_) << 12) | ((REG32(ADR_ALL_SOFTWARE_RESET)) & 0xffffefff))
#define SET_SCRT_SW_RST(_VAL_) (REG32(ADR_ALL_SOFTWARE_RESET)) = (((_VAL_) << 13) | ((REG32(ADR_ALL_SOFTWARE_RESET)) & 0xffffdfff))
#define SET_MIC_SW_RST(_VAL_) (REG32(ADR_ALL_SOFTWARE_RESET)) = (((_VAL_) << 14) | ((REG32(ADR_ALL_SOFTWARE_RESET)) & 0xffffbfff))
#define SET_CO_PROC_ENG_RST(_VAL_) (REG32(ADR_ENG_SOFTWARE_RESET)) = (((_VAL_) << 1) | ((REG32(ADR_ENG_SOFTWARE_RESET)) & 0xfffffffd))
#define SET_MTX_MISC_ENG_RST(_VAL_) (REG32(ADR_ENG_SOFTWARE_RESET)) = (((_VAL_) << 3) | ((REG32(ADR_ENG_SOFTWARE_RESET)) & 0xfffffff7))
#define SET_MTX_QUE_ENG_RST(_VAL_) (REG32(ADR_ENG_SOFTWARE_RESET)) = (((_VAL_) << 4) | ((REG32(ADR_ENG_SOFTWARE_RESET)) & 0xffffffef))
#define SET_MTX_CHST_ENG_RST(_VAL_) (REG32(ADR_ENG_SOFTWARE_RESET)) = (((_VAL_) << 5) | ((REG32(ADR_ENG_SOFTWARE_RESET)) & 0xffffffdf))
#define SET_MTX_BCN_ENG_RST(_VAL_) (REG32(ADR_ENG_SOFTWARE_RESET)) = (((_VAL_) << 6) | ((REG32(ADR_ENG_SOFTWARE_RESET)) & 0xffffffbf))
#define SET_MRX_ENG_RST(_VAL_) (REG32(ADR_ENG_SOFTWARE_RESET)) = (((_VAL_) << 7) | ((REG32(ADR_ENG_SOFTWARE_RESET)) & 0xffffff7f))
#define SET_AMPDU_ENG_RST(_VAL_) (REG32(ADR_ENG_SOFTWARE_RESET)) = (((_VAL_) << 8) | ((REG32(ADR_ENG_SOFTWARE_RESET)) & 0xfffffeff))
#define SET_ID_MNG_ENG_RST(_VAL_) (REG32(ADR_ENG_SOFTWARE_RESET)) = (((_VAL_) << 14) | ((REG32(ADR_ENG_SOFTWARE_RESET)) & 0xffffbfff))
#define SET_MBOX_ENG_RST(_VAL_) (REG32(ADR_ENG_SOFTWARE_RESET)) = (((_VAL_) << 15) | ((REG32(ADR_ENG_SOFTWARE_RESET)) & 0xffff7fff))
#define SET_SCRT_ENG_RST(_VAL_) (REG32(ADR_ENG_SOFTWARE_RESET)) = (((_VAL_) << 16) | ((REG32(ADR_ENG_SOFTWARE_RESET)) & 0xfffeffff))
#define SET_MIC_ENG_RST(_VAL_) (REG32(ADR_ENG_SOFTWARE_RESET)) = (((_VAL_) << 17) | ((REG32(ADR_ENG_SOFTWARE_RESET)) & 0xfffdffff))
#define SET_CO_PROC_CSR_RST(_VAL_) (REG32(ADR_CSR_SOFTWARE_RESET)) = (((_VAL_) << 1) | ((REG32(ADR_CSR_SOFTWARE_RESET)) & 0xfffffffd))
#define SET_MTX_MISC_CSR_RST(_VAL_) (REG32(ADR_CSR_SOFTWARE_RESET)) = (((_VAL_) << 3) | ((REG32(ADR_CSR_SOFTWARE_RESET)) & 0xfffffff7))
#define SET_MTX_QUE0_CSR_RST(_VAL_) (REG32(ADR_CSR_SOFTWARE_RESET)) = (((_VAL_) << 4) | ((REG32(ADR_CSR_SOFTWARE_RESET)) & 0xffffffef))
#define SET_MTX_QUE1_CSR_RST(_VAL_) (REG32(ADR_CSR_SOFTWARE_RESET)) = (((_VAL_) << 5) | ((REG32(ADR_CSR_SOFTWARE_RESET)) & 0xffffffdf))
#define SET_MTX_QUE2_CSR_RST(_VAL_) (REG32(ADR_CSR_SOFTWARE_RESET)) = (((_VAL_) << 6) | ((REG32(ADR_CSR_SOFTWARE_RESET)) & 0xffffffbf))
#define SET_MTX_QUE3_CSR_RST(_VAL_) (REG32(ADR_CSR_SOFTWARE_RESET)) = (((_VAL_) << 7) | ((REG32(ADR_CSR_SOFTWARE_RESET)) & 0xffffff7f))
#define SET_MTX_QUE4_CSR_RST(_VAL_) (REG32(ADR_CSR_SOFTWARE_RESET)) = (((_VAL_) << 8) | ((REG32(ADR_CSR_SOFTWARE_RESET)) & 0xfffffeff))
#define SET_MTX_QUE5_CSR_RST(_VAL_) (REG32(ADR_CSR_SOFTWARE_RESET)) = (((_VAL_) << 9) | ((REG32(ADR_CSR_SOFTWARE_RESET)) & 0xfffffdff))
#define SET_MRX_CSR_RST(_VAL_) (REG32(ADR_CSR_SOFTWARE_RESET)) = (((_VAL_) << 10) | ((REG32(ADR_CSR_SOFTWARE_RESET)) & 0xfffffbff))
#define SET_AMPDU_CSR_RST(_VAL_) (REG32(ADR_CSR_SOFTWARE_RESET)) = (((_VAL_) << 11) | ((REG32(ADR_CSR_SOFTWARE_RESET)) & 0xfffff7ff))
#define SET_SCRT_CSR_RST(_VAL_) (REG32(ADR_CSR_SOFTWARE_RESET)) = (((_VAL_) << 13) | ((REG32(ADR_CSR_SOFTWARE_RESET)) & 0xffffdfff))
#define SET_ID_MNG_CSR_RST(_VAL_) (REG32(ADR_CSR_SOFTWARE_RESET)) = (((_VAL_) << 14) | ((REG32(ADR_CSR_SOFTWARE_RESET)) & 0xffffbfff))
#define SET_MBOX_CSR_RST(_VAL_) (REG32(ADR_CSR_SOFTWARE_RESET)) = (((_VAL_) << 15) | ((REG32(ADR_CSR_SOFTWARE_RESET)) & 0xffff7fff))
#define SET_HCI_CLK_EN(_VAL_) (REG32(ADR_MAC_CLOCK_ENABLE)) = (((_VAL_) << 0) | ((REG32(ADR_MAC_CLOCK_ENABLE)) & 0xfffffffe))
#define SET_CO_PROC_CLK_EN(_VAL_) (REG32(ADR_MAC_CLOCK_ENABLE)) = (((_VAL_) << 1) | ((REG32(ADR_MAC_CLOCK_ENABLE)) & 0xfffffffd))
#define SET_MTX_MISC_CLK_EN(_VAL_) (REG32(ADR_MAC_CLOCK_ENABLE)) = (((_VAL_) << 3) | ((REG32(ADR_MAC_CLOCK_ENABLE)) & 0xfffffff7))
#define SET_MTX_QUE_CLK_EN(_VAL_) (REG32(ADR_MAC_CLOCK_ENABLE)) = (((_VAL_) << 4) | ((REG32(ADR_MAC_CLOCK_ENABLE)) & 0xffffffef))
#define SET_MRX_CLK_EN(_VAL_) (REG32(ADR_MAC_CLOCK_ENABLE)) = (((_VAL_) << 5) | ((REG32(ADR_MAC_CLOCK_ENABLE)) & 0xffffffdf))
#define SET_AMPDU_CLK_EN(_VAL_) (REG32(ADR_MAC_CLOCK_ENABLE)) = (((_VAL_) << 6) | ((REG32(ADR_MAC_CLOCK_ENABLE)) & 0xffffffbf))
#define SET_MMU_CLK_EN(_VAL_) (REG32(ADR_MAC_CLOCK_ENABLE)) = (((_VAL_) << 7) | ((REG32(ADR_MAC_CLOCK_ENABLE)) & 0xffffff7f))
#define SET_ID_MNG_CLK_EN(_VAL_) (REG32(ADR_MAC_CLOCK_ENABLE)) = (((_VAL_) << 9) | ((REG32(ADR_MAC_CLOCK_ENABLE)) & 0xfffffdff))
#define SET_MBOX_CLK_EN(_VAL_) (REG32(ADR_MAC_CLOCK_ENABLE)) = (((_VAL_) << 10) | ((REG32(ADR_MAC_CLOCK_ENABLE)) & 0xfffffbff))
#define SET_SCRT_CLK_EN(_VAL_) (REG32(ADR_MAC_CLOCK_ENABLE)) = (((_VAL_) << 11) | ((REG32(ADR_MAC_CLOCK_ENABLE)) & 0xfffff7ff))
#define SET_MIC_CLK_EN(_VAL_) (REG32(ADR_MAC_CLOCK_ENABLE)) = (((_VAL_) << 12) | ((REG32(ADR_MAC_CLOCK_ENABLE)) & 0xffffefff))
#define SET_MIB_CLK_EN(_VAL_) (REG32(ADR_MAC_CLOCK_ENABLE)) = (((_VAL_) << 13) | ((REG32(ADR_MAC_CLOCK_ENABLE)) & 0xffffdfff))
#define SET_HCI_ENG_CLK_EN(_VAL_) (REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) = (((_VAL_) << 0) | ((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0xfffffffe))
#define SET_CO_PROC_ENG_CLK_EN(_VAL_) (REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) = (((_VAL_) << 1) | ((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0xfffffffd))
#define SET_MTX_MISC_ENG_CLK_EN(_VAL_) (REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) = (((_VAL_) << 3) | ((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0xfffffff7))
#define SET_MTX_QUE_ENG_CLK_EN(_VAL_) (REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) = (((_VAL_) << 4) | ((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0xffffffef))
#define SET_MRX_ENG_CLK_EN(_VAL_) (REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) = (((_VAL_) << 5) | ((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0xffffffdf))
#define SET_AMPDU_ENG_CLK_EN(_VAL_) (REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) = (((_VAL_) << 6) | ((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0xffffffbf))
#define SET_ID_MNG_ENG_CLK_EN(_VAL_) (REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) = (((_VAL_) << 12) | ((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0xffffefff))
#define SET_MBOX_ENG_CLK_EN(_VAL_) (REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) = (((_VAL_) << 13) | ((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0xffffdfff))
#define SET_SCRT_ENG_CLK_EN(_VAL_) (REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) = (((_VAL_) << 14) | ((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0xffffbfff))
#define SET_MIC_ENG_CLK_EN(_VAL_) (REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) = (((_VAL_) << 15) | ((REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) & 0xffff7fff))
#define SET_CO_PROC_CSR_CLK_EN(_VAL_) (REG32(ADR_MAC_CSR_CLOCK_ENABLE)) = (((_VAL_) << 1) | ((REG32(ADR_MAC_CSR_CLOCK_ENABLE)) & 0xfffffffd))
#define SET_MRX_CSR_CLK_EN(_VAL_) (REG32(ADR_MAC_CSR_CLOCK_ENABLE)) = (((_VAL_) << 10) | ((REG32(ADR_MAC_CSR_CLOCK_ENABLE)) & 0xfffffbff))
#define SET_AMPDU_CSR_CLK_EN(_VAL_) (REG32(ADR_MAC_CSR_CLOCK_ENABLE)) = (((_VAL_) << 11) | ((REG32(ADR_MAC_CSR_CLOCK_ENABLE)) & 0xfffff7ff))
#define SET_SCRT_CSR_CLK_EN(_VAL_) (REG32(ADR_MAC_CSR_CLOCK_ENABLE)) = (((_VAL_) << 13) | ((REG32(ADR_MAC_CSR_CLOCK_ENABLE)) & 0xffffdfff))
#define SET_ID_MNG_CSR_CLK_EN(_VAL_) (REG32(ADR_MAC_CSR_CLOCK_ENABLE)) = (((_VAL_) << 14) | ((REG32(ADR_MAC_CSR_CLOCK_ENABLE)) & 0xffffbfff))
#define SET_MBOX_CSR_CLK_EN(_VAL_) (REG32(ADR_MAC_CSR_CLOCK_ENABLE)) = (((_VAL_) << 15) | ((REG32(ADR_MAC_CSR_CLOCK_ENABLE)) & 0xffff7fff))
#define SET_OP_MODE(_VAL_) (REG32(ADR_GLBLE_SET)) = (((_VAL_) << 0) | ((REG32(ADR_GLBLE_SET)) & 0xfffffffc))
#define SET_HT_MODE(_VAL_) (REG32(ADR_GLBLE_SET)) = (((_VAL_) << 2) | ((REG32(ADR_GLBLE_SET)) & 0xfffffff3))
#define SET_QOS_EN(_VAL_) (REG32(ADR_GLBLE_SET)) = (((_VAL_) << 4) | ((REG32(ADR_GLBLE_SET)) & 0xffffffef))
#define SET_PB_OFFSET(_VAL_) (REG32(ADR_GLBLE_SET)) = (((_VAL_) << 8) | ((REG32(ADR_GLBLE_SET)) & 0xffff00ff))
#define SET_SNIFFER_MODE(_VAL_) (REG32(ADR_GLBLE_SET)) = (((_VAL_) << 16) | ((REG32(ADR_GLBLE_SET)) & 0xfffeffff))
#define SET_DUP_FLT(_VAL_) (REG32(ADR_GLBLE_SET)) = (((_VAL_) << 17) | ((REG32(ADR_GLBLE_SET)) & 0xfffdffff))
#define SET_TX_PKT_RSVD(_VAL_) (REG32(ADR_GLBLE_SET)) = (((_VAL_) << 18) | ((REG32(ADR_GLBLE_SET)) & 0xffe3ffff))
#define SET_AMPDU_SNIFFER(_VAL_) (REG32(ADR_GLBLE_SET)) = (((_VAL_) << 21) | ((REG32(ADR_GLBLE_SET)) & 0xffdfffff))
#define SET_REASON_TRAP0(_VAL_) (REG32(ADR_REASON_TRAP0)) = (((_VAL_) << 0) | ((REG32(ADR_REASON_TRAP0)) & 0x00000000))
#define SET_REASON_TRAP1(_VAL_) (REG32(ADR_REASON_TRAP1)) = (((_VAL_) << 0) | ((REG32(ADR_REASON_TRAP1)) & 0x00000000))
#define SET_BSSID_31_0(_VAL_) (REG32(ADR_BSSID_0)) = (((_VAL_) << 0) | ((REG32(ADR_BSSID_0)) & 0x00000000))
#define SET_BSSID_47_32(_VAL_) (REG32(ADR_BSSID_1)) = (((_VAL_) << 0) | ((REG32(ADR_BSSID_1)) & 0xffff0000))
#define SET_SCRT_STATE(_VAL_) (REG32(ADR_SCRT_STATE)) = (((_VAL_) << 0) | ((REG32(ADR_SCRT_STATE)) & 0xfffffff0))
#define SET_STA_MAC_31_0(_VAL_) (REG32(ADR_STA_MAC_0)) = (((_VAL_) << 0) | ((REG32(ADR_STA_MAC_0)) & 0x00000000))
#define SET_STA_MAC_47_32(_VAL_) (REG32(ADR_STA_MAC_1)) = (((_VAL_) << 0) | ((REG32(ADR_STA_MAC_1)) & 0xffff0000))
#define SET_PAIR_SCRT(_VAL_) (REG32(ADR_SCRT_SET)) = (((_VAL_) << 0) | ((REG32(ADR_SCRT_SET)) & 0xfffffff8))
#define SET_GRP_SCRT(_VAL_) (REG32(ADR_SCRT_SET)) = (((_VAL_) << 3) | ((REG32(ADR_SCRT_SET)) & 0xffffffc7))
#define SET_SCRT_PKT_ID(_VAL_) (REG32(ADR_SCRT_SET)) = (((_VAL_) << 6) | ((REG32(ADR_SCRT_SET)) & 0xffffe03f))
#define SET_SCRT_RPLY_IGNORE(_VAL_) (REG32(ADR_SCRT_SET)) = (((_VAL_) << 16) | ((REG32(ADR_SCRT_SET)) & 0xfffeffff))
#define SET_COEXIST_EN(_VAL_) (REG32(ADR_BTCX0)) = (((_VAL_) << 0) | ((REG32(ADR_BTCX0)) & 0xfffffffe))
#define SET_WIRE_MODE(_VAL_) (REG32(ADR_BTCX0)) = (((_VAL_) << 1) | ((REG32(ADR_BTCX0)) & 0xfffffff1))
#define SET_WL_RX_PRI(_VAL_) (REG32(ADR_BTCX0)) = (((_VAL_) << 4) | ((REG32(ADR_BTCX0)) & 0xffffffef))
#define SET_WL_TX_PRI(_VAL_) (REG32(ADR_BTCX0)) = (((_VAL_) << 5) | ((REG32(ADR_BTCX0)) & 0xffffffdf))
#define SET_GURAN_USE_EN(_VAL_) (REG32(ADR_BTCX0)) = (((_VAL_) << 8) | ((REG32(ADR_BTCX0)) & 0xfffffeff))
#define SET_GURAN_USE_CTRL(_VAL_) (REG32(ADR_BTCX0)) = (((_VAL_) << 9) | ((REG32(ADR_BTCX0)) & 0xfffffdff))
#define SET_BEACON_TIMEOUT_EN(_VAL_) (REG32(ADR_BTCX0)) = (((_VAL_) << 10) | ((REG32(ADR_BTCX0)) & 0xfffffbff))
#define SET_WLAN_ACT_POL(_VAL_) (REG32(ADR_BTCX0)) = (((_VAL_) << 11) | ((REG32(ADR_BTCX0)) & 0xfffff7ff))
#define SET_DUAL_ANT_EN(_VAL_) (REG32(ADR_BTCX0)) = (((_VAL_) << 12) | ((REG32(ADR_BTCX0)) & 0xffffefff))
#define SET_TRSW_PHY_POL(_VAL_) (REG32(ADR_BTCX0)) = (((_VAL_) << 16) | ((REG32(ADR_BTCX0)) & 0xfffeffff))
#define SET_WIFI_TX_SW_POL(_VAL_) (REG32(ADR_BTCX0)) = (((_VAL_) << 17) | ((REG32(ADR_BTCX0)) & 0xfffdffff))
#define SET_WIFI_RX_SW_POL(_VAL_) (REG32(ADR_BTCX0)) = (((_VAL_) << 18) | ((REG32(ADR_BTCX0)) & 0xfffbffff))
#define SET_BT_SW_POL(_VAL_) (REG32(ADR_BTCX0)) = (((_VAL_) << 19) | ((REG32(ADR_BTCX0)) & 0xfff7ffff))
#define SET_BT_PRI_SMP_TIME(_VAL_) (REG32(ADR_BTCX1)) = (((_VAL_) << 0) | ((REG32(ADR_BTCX1)) & 0xffffff00))
#define SET_BT_STA_SMP_TIME(_VAL_) (REG32(ADR_BTCX1)) = (((_VAL_) << 8) | ((REG32(ADR_BTCX1)) & 0xffff00ff))
#define SET_BEACON_TIMEOUT(_VAL_) (REG32(ADR_BTCX1)) = (((_VAL_) << 16) | ((REG32(ADR_BTCX1)) & 0xff00ffff))
#define SET_WLAN_REMAIN_TIME(_VAL_) (REG32(ADR_BTCX1)) = (((_VAL_) << 24) | ((REG32(ADR_BTCX1)) & 0x00ffffff))
#define SET_SW_MANUAL_EN(_VAL_) (REG32(ADR_SWITCH_CTL)) = (((_VAL_) << 0) | ((REG32(ADR_SWITCH_CTL)) & 0xfffffffe))
#define SET_SW_WL_TX(_VAL_) (REG32(ADR_SWITCH_CTL)) = (((_VAL_) << 1) | ((REG32(ADR_SWITCH_CTL)) & 0xfffffffd))
#define SET_SW_WL_RX(_VAL_) (REG32(ADR_SWITCH_CTL)) = (((_VAL_) << 2) | ((REG32(ADR_SWITCH_CTL)) & 0xfffffffb))
#define SET_SW_BT_TRX(_VAL_) (REG32(ADR_SWITCH_CTL)) = (((_VAL_) << 3) | ((REG32(ADR_SWITCH_CTL)) & 0xfffffff7))
#define SET_BT_TXBAR_MANUAL_EN(_VAL_) (REG32(ADR_SWITCH_CTL)) = (((_VAL_) << 4) | ((REG32(ADR_SWITCH_CTL)) & 0xffffffef))
#define SET_BT_TXBAR_SET(_VAL_) (REG32(ADR_SWITCH_CTL)) = (((_VAL_) << 5) | ((REG32(ADR_SWITCH_CTL)) & 0xffffffdf))
#define SET_BT_BUSY_MANUAL_EN(_VAL_) (REG32(ADR_SWITCH_CTL)) = (((_VAL_) << 8) | ((REG32(ADR_SWITCH_CTL)) & 0xfffffeff))
#define SET_BT_BUSY_SET(_VAL_) (REG32(ADR_SWITCH_CTL)) = (((_VAL_) << 9) | ((REG32(ADR_SWITCH_CTL)) & 0xfffffdff))
#define SET_G0_PKT_CLS_MIB_EN(_VAL_) (REG32(ADR_MIB_EN)) = (((_VAL_) << 2) | ((REG32(ADR_MIB_EN)) & 0xfffffffb))
#define SET_G0_PKT_CLS_ONGOING(_VAL_) (REG32(ADR_MIB_EN)) = (((_VAL_) << 3) | ((REG32(ADR_MIB_EN)) & 0xfffffff7))
#define SET_G1_PKT_CLS_MIB_EN(_VAL_) (REG32(ADR_MIB_EN)) = (((_VAL_) << 4) | ((REG32(ADR_MIB_EN)) & 0xffffffef))
#define SET_G1_PKT_CLS_ONGOING(_VAL_) (REG32(ADR_MIB_EN)) = (((_VAL_) << 5) | ((REG32(ADR_MIB_EN)) & 0xffffffdf))
#define SET_Q0_PKT_CLS_MIB_EN(_VAL_) (REG32(ADR_MIB_EN)) = (((_VAL_) << 6) | ((REG32(ADR_MIB_EN)) & 0xffffffbf))
#define SET_Q0_PKT_CLS_ONGOING(_VAL_) (REG32(ADR_MIB_EN)) = (((_VAL_) << 7) | ((REG32(ADR_MIB_EN)) & 0xffffff7f))
#define SET_Q1_PKT_CLS_MIB_EN(_VAL_) (REG32(ADR_MIB_EN)) = (((_VAL_) << 8) | ((REG32(ADR_MIB_EN)) & 0xfffffeff))
#define SET_Q1_PKT_CLS_ONGOING(_VAL_) (REG32(ADR_MIB_EN)) = (((_VAL_) << 9) | ((REG32(ADR_MIB_EN)) & 0xfffffdff))
#define SET_Q2_PKT_CLS_MIB_EN(_VAL_) (REG32(ADR_MIB_EN)) = (((_VAL_) << 10) | ((REG32(ADR_MIB_EN)) & 0xfffffbff))
#define SET_Q2_PKT_CLS_ONGOING(_VAL_) (REG32(ADR_MIB_EN)) = (((_VAL_) << 11) | ((REG32(ADR_MIB_EN)) & 0xfffff7ff))
#define SET_Q3_PKT_CLS_MIB_EN(_VAL_) (REG32(ADR_MIB_EN)) = (((_VAL_) << 12) | ((REG32(ADR_MIB_EN)) & 0xffffefff))
#define SET_Q3_PKT_CLS_ONGOING(_VAL_) (REG32(ADR_MIB_EN)) = (((_VAL_) << 13) | ((REG32(ADR_MIB_EN)) & 0xffffdfff))
#define SET_SCRT_PKT_CLS_MIB_EN(_VAL_) (REG32(ADR_MIB_EN)) = (((_VAL_) << 14) | ((REG32(ADR_MIB_EN)) & 0xffffbfff))
#define SET_SCRT_PKT_CLS_ONGOING(_VAL_) (REG32(ADR_MIB_EN)) = (((_VAL_) << 15) | ((REG32(ADR_MIB_EN)) & 0xffff7fff))
#define SET_MISC_PKT_CLS_MIB_EN(_VAL_) (REG32(ADR_MIB_EN)) = (((_VAL_) << 16) | ((REG32(ADR_MIB_EN)) & 0xfffeffff))
#define SET_MISC_PKT_CLS_ONGOING(_VAL_) (REG32(ADR_MIB_EN)) = (((_VAL_) << 17) | ((REG32(ADR_MIB_EN)) & 0xfffdffff))
#define SET_MTX_WSID0_SUCC(_VAL_) (REG32(ADR_MTX_WSID0_SUCC)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_WSID0_SUCC)) & 0xffff0000))
#define SET_MTX_WSID0_FRM(_VAL_) (REG32(ADR_MTX_WSID0_FRM)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_WSID0_FRM)) & 0xffff0000))
#define SET_MTX_WSID0_RETRY(_VAL_) (REG32(ADR_MTX_WSID0_RETRY)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_WSID0_RETRY)) & 0xffff0000))
#define SET_MTX_WSID0_TOTAL(_VAL_) (REG32(ADR_MTX_WSID0_TOTAL)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_WSID0_TOTAL)) & 0xffff0000))
#define SET_MTX_GRP(_VAL_) (REG32(ADR_MTX_GROUP)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_GROUP)) & 0xfff00000))
#define SET_MTX_FAIL(_VAL_) (REG32(ADR_MTX_FAIL)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_FAIL)) & 0xffff0000))
#define SET_MTX_RETRY(_VAL_) (REG32(ADR_MTX_RETRY)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_RETRY)) & 0xfff00000))
#define SET_MTX_MULTI_RETRY(_VAL_) (REG32(ADR_MTX_MULTI_RETRY)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_MULTI_RETRY)) & 0xfff00000))
#define SET_MTX_RTS_SUCC(_VAL_) (REG32(ADR_MTX_RTS_SUCCESS)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_RTS_SUCCESS)) & 0xffff0000))
#define SET_MTX_RTS_FAIL(_VAL_) (REG32(ADR_MTX_RTS_FAIL)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_RTS_FAIL)) & 0xffff0000))
#define SET_MTX_ACK_FAIL(_VAL_) (REG32(ADR_MTX_ACK_FAIL)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_ACK_FAIL)) & 0xffff0000))
#define SET_MTX_FRM(_VAL_) (REG32(ADR_MTX_FRM)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_FRM)) & 0xfff00000))
#define SET_MTX_ACK_TX(_VAL_) (REG32(ADR_MTX_ACK_TX)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_ACK_TX)) & 0xffff0000))
#define SET_MTX_CTS_TX(_VAL_) (REG32(ADR_MTX_CTS_TX)) = (((_VAL_) << 0) | ((REG32(ADR_MTX_CTS_TX)) & 0xffff0000))
#define SET_MRX_DUP(_VAL_) (REG32(ADR_MRX_DUP_FRM)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_DUP_FRM)) & 0xffff0000))
#define SET_MRX_FRG(_VAL_) (REG32(ADR_MRX_FRG_FRM)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FRG_FRM)) & 0xfff00000))
#define SET_MRX_GRP(_VAL_) (REG32(ADR_MRX_GROUP_FRM)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_GROUP_FRM)) & 0xfff00000))
#define SET_MRX_FCS_ERR(_VAL_) (REG32(ADR_MRX_FCS_ERR)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FCS_ERR)) & 0xffff0000))
#define SET_MRX_FCS_SUC(_VAL_) (REG32(ADR_MRX_FCS_SUCC)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_FCS_SUCC)) & 0xffff0000))
#define SET_MRX_MISS(_VAL_) (REG32(ADR_MRX_MISS)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MISS)) & 0xffff0000))
#define SET_MRX_ALC_FAIL(_VAL_) (REG32(ADR_MRX_ALC_FAIL)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_ALC_FAIL)) & 0xffff0000))
#define SET_MRX_DAT_NTF(_VAL_) (REG32(ADR_MRX_DAT_NTF)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_DAT_NTF)) & 0xffff0000))
#define SET_MRX_RTS_NTF(_VAL_) (REG32(ADR_MRX_RTS_NTF)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_RTS_NTF)) & 0xffff0000))
#define SET_MRX_CTS_NTF(_VAL_) (REG32(ADR_MRX_CTS_NTF)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_CTS_NTF)) & 0xffff0000))
#define SET_MRX_ACK_NTF(_VAL_) (REG32(ADR_MRX_ACK_NTF)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_ACK_NTF)) & 0xffff0000))
#define SET_MRX_BA_NTF(_VAL_) (REG32(ADR_MRX_BA_NTF)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_BA_NTF)) & 0xffff0000))
#define SET_MRX_DATA_NTF(_VAL_) (REG32(ADR_MRX_DATA_NTF)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_DATA_NTF)) & 0xffff0000))
#define SET_MRX_MNG_NTF(_VAL_) (REG32(ADR_MRX_MNG_NTF)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MNG_NTF)) & 0xffff0000))
#define SET_MRX_DAT_CRC_NTF(_VAL_) (REG32(ADR_MRX_DAT_CRC_NTF)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_DAT_CRC_NTF)) & 0xffff0000))
#define SET_MRX_BAR_NTF(_VAL_) (REG32(ADR_MRX_BAR_NTF)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_BAR_NTF)) & 0xffff0000))
#define SET_MRX_MB_MISS(_VAL_) (REG32(ADR_MRX_MB_MISS)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_MB_MISS)) & 0xffff0000))
#define SET_MRX_NIDLE_MISS(_VAL_) (REG32(ADR_MRX_NIDLE_MISS)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_NIDLE_MISS)) & 0xffff0000))
#define SET_MRX_CSR_NTF(_VAL_) (REG32(ADR_MRX_CSR_NTF)) = (((_VAL_) << 0) | ((REG32(ADR_MRX_CSR_NTF)) & 0xffff0000))
#define SET_DBG_Q0_SUCC(_VAL_) (REG32(ADR_DBG_Q0_FRM_SUCCESS)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_Q0_FRM_SUCCESS)) & 0xffff0000))
#define SET_DBG_Q0_FAIL(_VAL_) (REG32(ADR_DBG_Q0_FRM_FAIL)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_Q0_FRM_FAIL)) & 0xffff0000))
#define SET_DBG_Q0_ACK_SUCC(_VAL_) (REG32(ADR_DBG_Q0_ACK_SUCCESS)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_Q0_ACK_SUCCESS)) & 0xffff0000))
#define SET_DBG_Q0_ACK_FAIL(_VAL_) (REG32(ADR_DBG_Q0_ACK_FAIL)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_Q0_ACK_FAIL)) & 0xffff0000))
#define SET_DBG_Q1_SUCC(_VAL_) (REG32(ADR_DBG_Q1_FRM_SUCCESS)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_Q1_FRM_SUCCESS)) & 0xffff0000))
#define SET_DBG_Q1_FAIL(_VAL_) (REG32(ADR_DBG_Q1_FRM_FAIL)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_Q1_FRM_FAIL)) & 0xffff0000))
#define SET_DBG_Q1_ACK_SUCC(_VAL_) (REG32(ADR_DBG_Q1_ACK_SUCCESS)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_Q1_ACK_SUCCESS)) & 0xffff0000))
#define SET_DBG_Q1_ACK_FAIL(_VAL_) (REG32(ADR_DBG_Q1_ACK_FAIL)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_Q1_ACK_FAIL)) & 0xffff0000))
#define SET_DBG_Q2_SUCC(_VAL_) (REG32(ADR_DBG_Q2_FRM_SUCCESS)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_Q2_FRM_SUCCESS)) & 0xffff0000))
#define SET_DBG_Q2_FAIL(_VAL_) (REG32(ADR_DBG_Q2_FRM_FAIL)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_Q2_FRM_FAIL)) & 0xffff0000))
#define SET_DBG_Q2_ACK_SUCC(_VAL_) (REG32(ADR_DBG_Q2_ACK_SUCCESS)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_Q2_ACK_SUCCESS)) & 0xffff0000))
#define SET_DBG_Q2_ACK_FAIL(_VAL_) (REG32(ADR_DBG_Q2_ACK_FAIL)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_Q2_ACK_FAIL)) & 0xffff0000))
#define SET_DBG_Q3_SUCC(_VAL_) (REG32(ADR_DBG_Q3_FRM_SUCCESS)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_Q3_FRM_SUCCESS)) & 0xffff0000))
#define SET_DBG_Q3_FAIL(_VAL_) (REG32(ADR_DBG_Q3_FRM_FAIL)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_Q3_FRM_FAIL)) & 0xffff0000))
#define SET_DBG_Q3_ACK_SUCC(_VAL_) (REG32(ADR_DBG_Q3_ACK_SUCCESS)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_Q3_ACK_SUCCESS)) & 0xffff0000))
#define SET_DBG_Q3_ACK_FAIL(_VAL_) (REG32(ADR_DBG_Q3_ACK_FAIL)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_Q3_ACK_FAIL)) & 0xffff0000))
#define SET_SCRT_TKIP_CERR(_VAL_) (REG32(ADR_MIB_SCRT_TKIP0)) = (((_VAL_) << 0) | ((REG32(ADR_MIB_SCRT_TKIP0)) & 0xfff00000))
#define SET_SCRT_TKIP_MIC_ERR(_VAL_) (REG32(ADR_MIB_SCRT_TKIP1)) = (((_VAL_) << 0) | ((REG32(ADR_MIB_SCRT_TKIP1)) & 0xfff00000))
#define SET_SCRT_TKIP_RPLY(_VAL_) (REG32(ADR_MIB_SCRT_TKIP2)) = (((_VAL_) << 0) | ((REG32(ADR_MIB_SCRT_TKIP2)) & 0xfff00000))
#define SET_SCRT_CCMP_RPLY(_VAL_) (REG32(ADR_MIB_SCRT_CCMP0)) = (((_VAL_) << 0) | ((REG32(ADR_MIB_SCRT_CCMP0)) & 0xfff00000))
#define SET_SCRT_CCMP_CERR(_VAL_) (REG32(ADR_MIB_SCRT_CCMP1)) = (((_VAL_) << 0) | ((REG32(ADR_MIB_SCRT_CCMP1)) & 0xfff00000))
#define SET_DBG_LEN_CRC_FAIL(_VAL_) (REG32(ADR_DBG_LEN_CRC_FAIL)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_LEN_CRC_FAIL)) & 0xffff0000))
#define SET_DBG_LEN_ALC_FAIL(_VAL_) (REG32(ADR_DBG_LEN_ALC_FAIL)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_LEN_ALC_FAIL)) & 0xffff0000))
#define SET_DBG_AMPDU_PASS(_VAL_) (REG32(ADR_DBG_AMPDU_PASS)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_AMPDU_PASS)) & 0xffff0000))
#define SET_DBG_AMPDU_FAIL(_VAL_) (REG32(ADR_DBG_AMPDU_FAIL)) = (((_VAL_) << 0) | ((REG32(ADR_DBG_AMPDU_FAIL)) & 0xffff0000))
#define SET_RXID_ALC_CNT_FAIL(_VAL_) (REG32(ADR_ID_ALC_FAIL1)) = (((_VAL_) << 0) | ((REG32(ADR_ID_ALC_FAIL1)) & 0xffff0000))
#define SET_RXID_ALC_LEN_FAIL(_VAL_) (REG32(ADR_ID_ALC_FAIL2)) = (((_VAL_) << 0) | ((REG32(ADR_ID_ALC_FAIL2)) & 0xffff0000))
#define SET_CBR_RG_EN_MANUAL(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xfffffffe))
#define SET_CBR_RG_TX_EN(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 1) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xfffffffd))
#define SET_CBR_RG_TX_PA_EN(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xfffffffb))
#define SET_CBR_RG_TX_DAC_EN(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 3) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xfffffff7))
#define SET_CBR_RG_RX_AGC(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 4) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xffffffef))
#define SET_CBR_RG_RX_GAIN_MANUAL(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 5) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xffffffdf))
#define SET_CBR_RG_RFG(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xffffff3f))
#define SET_CBR_RG_PGAG(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 8) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xfffff0ff))
#define SET_CBR_RG_MODE(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xffffcfff))
#define SET_CBR_RG_EN_TX_TRSW(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 14) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xffffbfff))
#define SET_CBR_RG_EN_SX(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 15) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xffff7fff))
#define SET_CBR_RG_EN_RX_LNA(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 16) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xfffeffff))
#define SET_CBR_RG_EN_RX_MIXER(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 17) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xfffdffff))
#define SET_CBR_RG_EN_RX_DIV2(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 18) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xfffbffff))
#define SET_CBR_RG_EN_RX_LOBUF(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 19) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xfff7ffff))
#define SET_CBR_RG_EN_RX_TZ(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 20) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xffefffff))
#define SET_CBR_RG_EN_RX_FILTER(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 21) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xffdfffff))
#define SET_CBR_RG_EN_RX_HPF(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 22) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xffbfffff))
#define SET_CBR_RG_EN_RX_RSSI(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 23) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xff7fffff))
#define SET_CBR_RG_EN_ADC(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 24) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xfeffffff))
#define SET_CBR_RG_EN_TX_MOD(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 25) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xfdffffff))
#define SET_CBR_RG_EN_TX_DIV2(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 26) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xfbffffff))
#define SET_CBR_RG_EN_TX_DIV2_BUF(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 27) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xf7ffffff))
#define SET_CBR_RG_EN_TX_LOBF(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 28) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xefffffff))
#define SET_CBR_RG_EN_RX_LOBF(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 29) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xdfffffff))
#define SET_CBR_RG_SEL_DPLL_CLK(_VAL_) (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 30) | ((REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) & 0xbfffffff))
#define SET_CBR_RG_EN_TX_DPD(_VAL_) (REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0xfffffffe))
#define SET_CBR_RG_EN_TX_TSSI(_VAL_) (REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 1) | ((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0xfffffffd))
#define SET_CBR_RG_EN_RX_IQCAL(_VAL_) (REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0xfffffffb))
#define SET_CBR_RG_EN_TX_DAC_CAL(_VAL_) (REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 3) | ((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0xfffffff7))
#define SET_CBR_RG_EN_TX_SELF_MIXER(_VAL_) (REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 4) | ((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0xffffffef))
#define SET_CBR_RG_EN_TX_DAC_OUT(_VAL_) (REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 5) | ((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0xffffffdf))
#define SET_CBR_RG_EN_LDO_RX_FE(_VAL_) (REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0xffffffbf))
#define SET_CBR_RG_EN_LDO_ABB(_VAL_) (REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 7) | ((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0xffffff7f))
#define SET_CBR_RG_EN_LDO_AFE(_VAL_) (REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 8) | ((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0xfffffeff))
#define SET_CBR_RG_EN_SX_CHPLDO(_VAL_) (REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 9) | ((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0xfffffdff))
#define SET_CBR_RG_EN_SX_LOBFLDO(_VAL_) (REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 10) | ((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0xfffffbff))
#define SET_CBR_RG_EN_IREF_RX(_VAL_) (REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 11) | ((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0xfffff7ff))
#define SET_CBR_RG_DCDC_MODE(_VAL_) (REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) & 0xffffefff))
#define SET_CBR_RG_LDO_LEVEL_RX_FE(_VAL_) (REG32(ADR_CBR_LDO_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_LDO_REGISTER)) & 0xfffffff8))
#define SET_CBR_RG_LDO_LEVEL_ABB(_VAL_) (REG32(ADR_CBR_LDO_REGISTER)) = (((_VAL_) << 3) | ((REG32(ADR_CBR_LDO_REGISTER)) & 0xffffffc7))
#define SET_CBR_RG_LDO_LEVEL_AFE(_VAL_) (REG32(ADR_CBR_LDO_REGISTER)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_LDO_REGISTER)) & 0xfffffe3f))
#define SET_CBR_RG_SX_LDO_CHP_LEVEL(_VAL_) (REG32(ADR_CBR_LDO_REGISTER)) = (((_VAL_) << 9) | ((REG32(ADR_CBR_LDO_REGISTER)) & 0xfffff1ff))
#define SET_CBR_RG_SX_LDO_LOBF_LEVEL(_VAL_) (REG32(ADR_CBR_LDO_REGISTER)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_LDO_REGISTER)) & 0xffff8fff))
#define SET_CBR_RG_SX_LDO_XOSC_LEVEL(_VAL_) (REG32(ADR_CBR_LDO_REGISTER)) = (((_VAL_) << 15) | ((REG32(ADR_CBR_LDO_REGISTER)) & 0xfffc7fff))
#define SET_CBR_RG_DP_LDO_LEVEL(_VAL_) (REG32(ADR_CBR_LDO_REGISTER)) = (((_VAL_) << 18) | ((REG32(ADR_CBR_LDO_REGISTER)) & 0xffe3ffff))
#define SET_CBR_RG_SX_LDO_VCO_LEVEL(_VAL_) (REG32(ADR_CBR_LDO_REGISTER)) = (((_VAL_) << 21) | ((REG32(ADR_CBR_LDO_REGISTER)) & 0xff1fffff))
#define SET_CBR_RG_TX_LDO_TX_LEVEL(_VAL_) (REG32(ADR_CBR_LDO_REGISTER)) = (((_VAL_) << 24) | ((REG32(ADR_CBR_LDO_REGISTER)) & 0xf8ffffff))
#define SET_CBR_RG_BUCK_LEVEL(_VAL_) (REG32(ADR_CBR_LDO_REGISTER)) = (((_VAL_) << 27) | ((REG32(ADR_CBR_LDO_REGISTER)) & 0xc7ffffff))
#define SET_CBR_RG_EN_RX_PADSW(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_1)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_ABB_REGISTER_1)) & 0xfffffffe))
#define SET_CBR_RG_EN_RX_TESTNODE(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_1)) = (((_VAL_) << 1) | ((REG32(ADR_CBR_ABB_REGISTER_1)) & 0xfffffffd))
#define SET_CBR_RG_RX_ABBCFIX(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_1)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_ABB_REGISTER_1)) & 0xfffffffb))
#define SET_CBR_RG_RX_ABBCTUNE(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_1)) = (((_VAL_) << 3) | ((REG32(ADR_CBR_ABB_REGISTER_1)) & 0xfffffe07))
#define SET_CBR_RG_RX_ABBOUT_TRI_STATE(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_1)) = (((_VAL_) << 9) | ((REG32(ADR_CBR_ABB_REGISTER_1)) & 0xfffffdff))
#define SET_CBR_RG_RX_ABB_N_MODE(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_1)) = (((_VAL_) << 10) | ((REG32(ADR_CBR_ABB_REGISTER_1)) & 0xfffffbff))
#define SET_CBR_RG_RX_EN_LOOPA(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_1)) = (((_VAL_) << 11) | ((REG32(ADR_CBR_ABB_REGISTER_1)) & 0xfffff7ff))
#define SET_CBR_RG_RX_FILTERI1ST(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_1)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_ABB_REGISTER_1)) & 0xffffcfff))
#define SET_CBR_RG_RX_FILTERI2ND(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_1)) = (((_VAL_) << 14) | ((REG32(ADR_CBR_ABB_REGISTER_1)) & 0xffff3fff))
#define SET_CBR_RG_RX_FILTERI3RD(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_1)) = (((_VAL_) << 16) | ((REG32(ADR_CBR_ABB_REGISTER_1)) & 0xfffcffff))
#define SET_CBR_RG_RX_FILTERI_COURSE(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_1)) = (((_VAL_) << 18) | ((REG32(ADR_CBR_ABB_REGISTER_1)) & 0xfff3ffff))
#define SET_CBR_RG_RX_FILTERVCM(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_1)) = (((_VAL_) << 20) | ((REG32(ADR_CBR_ABB_REGISTER_1)) & 0xffcfffff))
#define SET_CBR_RG_RX_HPF3M(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_1)) = (((_VAL_) << 22) | ((REG32(ADR_CBR_ABB_REGISTER_1)) & 0xffbfffff))
#define SET_CBR_RG_RX_HPF300K(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_1)) = (((_VAL_) << 23) | ((REG32(ADR_CBR_ABB_REGISTER_1)) & 0xff7fffff))
#define SET_CBR_RG_RX_HPFI(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_1)) = (((_VAL_) << 24) | ((REG32(ADR_CBR_ABB_REGISTER_1)) & 0xfcffffff))
#define SET_CBR_RG_RX_HPF_FINALCORNER(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_1)) = (((_VAL_) << 26) | ((REG32(ADR_CBR_ABB_REGISTER_1)) & 0xf3ffffff))
#define SET_CBR_RG_RX_HPF_SETTLE1_C(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_1)) = (((_VAL_) << 28) | ((REG32(ADR_CBR_ABB_REGISTER_1)) & 0xcfffffff))
#define SET_CBR_RG_RX_HPF_SETTLE1_R(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_2)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_ABB_REGISTER_2)) & 0xfffffffc))
#define SET_CBR_RG_RX_HPF_SETTLE2_C(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_2)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_ABB_REGISTER_2)) & 0xfffffff3))
#define SET_CBR_RG_RX_HPF_SETTLE2_R(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_2)) = (((_VAL_) << 4) | ((REG32(ADR_CBR_ABB_REGISTER_2)) & 0xffffffcf))
#define SET_CBR_RG_RX_HPF_VCMCON2(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_2)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_ABB_REGISTER_2)) & 0xffffff3f))
#define SET_CBR_RG_RX_HPF_VCMCON(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_2)) = (((_VAL_) << 8) | ((REG32(ADR_CBR_ABB_REGISTER_2)) & 0xfffffcff))
#define SET_CBR_RG_RX_OUTVCM(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_2)) = (((_VAL_) << 10) | ((REG32(ADR_CBR_ABB_REGISTER_2)) & 0xfffff3ff))
#define SET_CBR_RG_RX_TZI(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_2)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_ABB_REGISTER_2)) & 0xffffcfff))
#define SET_CBR_RG_RX_TZ_OUT_TRISTATE(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_2)) = (((_VAL_) << 14) | ((REG32(ADR_CBR_ABB_REGISTER_2)) & 0xffffbfff))
#define SET_CBR_RG_RX_TZ_VCM(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_2)) = (((_VAL_) << 15) | ((REG32(ADR_CBR_ABB_REGISTER_2)) & 0xfffe7fff))
#define SET_CBR_RG_EN_RX_RSSI_TESTNODE(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_2)) = (((_VAL_) << 17) | ((REG32(ADR_CBR_ABB_REGISTER_2)) & 0xfff1ffff))
#define SET_CBR_RG_RX_ADCRSSI_CLKSEL(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_2)) = (((_VAL_) << 20) | ((REG32(ADR_CBR_ABB_REGISTER_2)) & 0xffefffff))
#define SET_CBR_RG_RX_ADCRSSI_VCM(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_2)) = (((_VAL_) << 21) | ((REG32(ADR_CBR_ABB_REGISTER_2)) & 0xff9fffff))
#define SET_CBR_RG_RX_REC_LPFCORNER(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_2)) = (((_VAL_) << 23) | ((REG32(ADR_CBR_ABB_REGISTER_2)) & 0xfe7fffff))
#define SET_CBR_RG_RSSI_CLOCK_GATING(_VAL_) (REG32(ADR_CBR_ABB_REGISTER_2)) = (((_VAL_) << 25) | ((REG32(ADR_CBR_ABB_REGISTER_2)) & 0xfdffffff))
#define SET_CBR_RG_TXPGA_CAPSW(_VAL_) (REG32(ADR_CBR_TX_FE_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_TX_FE_REGISTER)) & 0xfffffffc))
#define SET_CBR_RG_TXPGA_MAIN(_VAL_) (REG32(ADR_CBR_TX_FE_REGISTER)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_TX_FE_REGISTER)) & 0xffffff03))
#define SET_CBR_RG_TXPGA_STEER(_VAL_) (REG32(ADR_CBR_TX_FE_REGISTER)) = (((_VAL_) << 8) | ((REG32(ADR_CBR_TX_FE_REGISTER)) & 0xffffc0ff))
#define SET_CBR_RG_TXMOD_GMCELL(_VAL_) (REG32(ADR_CBR_TX_FE_REGISTER)) = (((_VAL_) << 14) | ((REG32(ADR_CBR_TX_FE_REGISTER)) & 0xffff3fff))
#define SET_CBR_RG_TXLPF_GMCELL(_VAL_) (REG32(ADR_CBR_TX_FE_REGISTER)) = (((_VAL_) << 16) | ((REG32(ADR_CBR_TX_FE_REGISTER)) & 0xfffcffff))
#define SET_CBR_RG_PACELL_EN(_VAL_) (REG32(ADR_CBR_TX_FE_REGISTER)) = (((_VAL_) << 18) | ((REG32(ADR_CBR_TX_FE_REGISTER)) & 0xffe3ffff))
#define SET_CBR_RG_PABIAS_CTRL(_VAL_) (REG32(ADR_CBR_TX_FE_REGISTER)) = (((_VAL_) << 21) | ((REG32(ADR_CBR_TX_FE_REGISTER)) & 0xfe1fffff))
#define SET_CBR_RG_PABIAS_AB(_VAL_) (REG32(ADR_CBR_TX_FE_REGISTER)) = (((_VAL_) << 25) | ((REG32(ADR_CBR_TX_FE_REGISTER)) & 0xfdffffff))
#define SET_CBR_RG_TX_DIV_VSET(_VAL_) (REG32(ADR_CBR_TX_FE_REGISTER)) = (((_VAL_) << 26) | ((REG32(ADR_CBR_TX_FE_REGISTER)) & 0xf3ffffff))
#define SET_CBR_RG_TX_LOBUF_VSET(_VAL_) (REG32(ADR_CBR_TX_FE_REGISTER)) = (((_VAL_) << 28) | ((REG32(ADR_CBR_TX_FE_REGISTER)) & 0xcfffffff))
#define SET_CBR_RG_RX_SQDC(_VAL_) (REG32(ADR_CBR_RX_FE_REGISTER_1)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0xfffffff8))
#define SET_CBR_RG_RX_DIV2_CORE(_VAL_) (REG32(ADR_CBR_RX_FE_REGISTER_1)) = (((_VAL_) << 3) | ((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0xffffffe7))
#define SET_CBR_RG_RX_LOBUF(_VAL_) (REG32(ADR_CBR_RX_FE_REGISTER_1)) = (((_VAL_) << 5) | ((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0xffffff9f))
#define SET_CBR_RG_TX_DPDGM_BIAS(_VAL_) (REG32(ADR_CBR_RX_FE_REGISTER_1)) = (((_VAL_) << 7) | ((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0xfffff87f))
#define SET_CBR_RG_TX_DPD_DIV(_VAL_) (REG32(ADR_CBR_RX_FE_REGISTER_1)) = (((_VAL_) << 11) | ((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0xffff87ff))
#define SET_CBR_RG_TX_TSSI_BIAS(_VAL_) (REG32(ADR_CBR_RX_FE_REGISTER_1)) = (((_VAL_) << 15) | ((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0xfffc7fff))
#define SET_CBR_RG_TX_TSSI_DIV(_VAL_) (REG32(ADR_CBR_RX_FE_REGISTER_1)) = (((_VAL_) << 18) | ((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0xffe3ffff))
#define SET_CBR_RG_TX_TSSI_TESTMODE(_VAL_) (REG32(ADR_CBR_RX_FE_REGISTER_1)) = (((_VAL_) << 21) | ((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0xffdfffff))
#define SET_CBR_RG_TX_TSSI_TEST(_VAL_) (REG32(ADR_CBR_RX_FE_REGISTER_1)) = (((_VAL_) << 22) | ((REG32(ADR_CBR_RX_FE_REGISTER_1)) & 0xff3fffff))
#define SET_CBR_RG_RX_HG_LNA_GC(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0xfffffffc))
#define SET_CBR_RG_RX_HG_LNAHGN_BIAS(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0xffffffc3))
#define SET_CBR_RG_RX_HG_LNAHGP_BIAS(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0xfffffc3f))
#define SET_CBR_RG_RX_HG_LNALG_BIAS(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) = (((_VAL_) << 10) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0xffffc3ff))
#define SET_CBR_RG_RX_HG_TZ_GC(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) = (((_VAL_) << 14) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0xffff3fff))
#define SET_CBR_RG_RX_HG_TZ_CAP(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) = (((_VAL_) << 16) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0xfff8ffff))
#define SET_CBR_RG_RX_MG_LNA_GC(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0xfffffffc))
#define SET_CBR_RG_RX_MG_LNAHGN_BIAS(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0xffffffc3))
#define SET_CBR_RG_RX_MG_LNAHGP_BIAS(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0xfffffc3f))
#define SET_CBR_RG_RX_MG_LNALG_BIAS(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) = (((_VAL_) << 10) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0xffffc3ff))
#define SET_CBR_RG_RX_MG_TZ_GC(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) = (((_VAL_) << 14) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0xffff3fff))
#define SET_CBR_RG_RX_MG_TZ_CAP(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) = (((_VAL_) << 16) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0xfff8ffff))
#define SET_CBR_RG_RX_LG_LNA_GC(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0xfffffffc))
#define SET_CBR_RG_RX_LG_LNAHGN_BIAS(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0xffffffc3))
#define SET_CBR_RG_RX_LG_LNAHGP_BIAS(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0xfffffc3f))
#define SET_CBR_RG_RX_LG_LNALG_BIAS(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) = (((_VAL_) << 10) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0xffffc3ff))
#define SET_CBR_RG_RX_LG_TZ_GC(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) = (((_VAL_) << 14) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0xffff3fff))
#define SET_CBR_RG_RX_LG_TZ_CAP(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) = (((_VAL_) << 16) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0xfff8ffff))
#define SET_CBR_RG_RX_ULG_LNA_GC(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0xfffffffc))
#define SET_CBR_RG_RX_ULG_LNAHGN_BIAS(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0xffffffc3))
#define SET_CBR_RG_RX_ULG_LNAHGP_BIAS(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0xfffffc3f))
#define SET_CBR_RG_RX_ULG_LNALG_BIAS(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) = (((_VAL_) << 10) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0xffffc3ff))
#define SET_CBR_RG_RX_ULG_TZ_GC(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) = (((_VAL_) << 14) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0xffff3fff))
#define SET_CBR_RG_RX_ULG_TZ_CAP(_VAL_) (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) = (((_VAL_) << 16) | ((REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0xfff8ffff))
#define SET_CBR_RG_HPF1_FAST_SET_X(_VAL_) (REG32(ADR_CBR_RX_FSM_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_RX_FSM_REGISTER)) & 0xfffffffe))
#define SET_CBR_RG_HPF1_FAST_SET_Y(_VAL_) (REG32(ADR_CBR_RX_FSM_REGISTER)) = (((_VAL_) << 1) | ((REG32(ADR_CBR_RX_FSM_REGISTER)) & 0xfffffffd))
#define SET_CBR_RG_HPF1_FAST_SET_Z(_VAL_) (REG32(ADR_CBR_RX_FSM_REGISTER)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_RX_FSM_REGISTER)) & 0xfffffffb))
#define SET_CBR_RG_HPF_T1A(_VAL_) (REG32(ADR_CBR_RX_FSM_REGISTER)) = (((_VAL_) << 3) | ((REG32(ADR_CBR_RX_FSM_REGISTER)) & 0xffffffe7))
#define SET_CBR_RG_HPF_T1B(_VAL_) (REG32(ADR_CBR_RX_FSM_REGISTER)) = (((_VAL_) << 5) | ((REG32(ADR_CBR_RX_FSM_REGISTER)) & 0xffffff9f))
#define SET_CBR_RG_HPF_T1C(_VAL_) (REG32(ADR_CBR_RX_FSM_REGISTER)) = (((_VAL_) << 7) | ((REG32(ADR_CBR_RX_FSM_REGISTER)) & 0xfffffe7f))
#define SET_CBR_RG_RX_LNA_TRI_SEL(_VAL_) (REG32(ADR_CBR_RX_FSM_REGISTER)) = (((_VAL_) << 9) | ((REG32(ADR_CBR_RX_FSM_REGISTER)) & 0xfffff9ff))
#define SET_CBR_RG_RX_LNA_SETTLE(_VAL_) (REG32(ADR_CBR_RX_FSM_REGISTER)) = (((_VAL_) << 11) | ((REG32(ADR_CBR_RX_FSM_REGISTER)) & 0xffffe7ff))
#define SET_CBR_RG_ADC_CLKSEL(_VAL_) (REG32(ADR_CBR_RX_ADC_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0xfffffffe))
#define SET_CBR_RG_ADC_DIBIAS(_VAL_) (REG32(ADR_CBR_RX_ADC_REGISTER)) = (((_VAL_) << 1) | ((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0xfffffff9))
#define SET_CBR_RG_ADC_DIVR(_VAL_) (REG32(ADR_CBR_RX_ADC_REGISTER)) = (((_VAL_) << 3) | ((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0xfffffff7))
#define SET_CBR_RG_ADC_DVCMI(_VAL_) (REG32(ADR_CBR_RX_ADC_REGISTER)) = (((_VAL_) << 4) | ((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0xffffffcf))
#define SET_CBR_RG_ADC_SAMSEL(_VAL_) (REG32(ADR_CBR_RX_ADC_REGISTER)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0xfffffc3f))
#define SET_CBR_RG_ADC_STNBY(_VAL_) (REG32(ADR_CBR_RX_ADC_REGISTER)) = (((_VAL_) << 10) | ((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0xfffffbff))
#define SET_CBR_RG_ADC_TESTMODE(_VAL_) (REG32(ADR_CBR_RX_ADC_REGISTER)) = (((_VAL_) << 11) | ((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0xfffff7ff))
#define SET_CBR_RG_ADC_TSEL(_VAL_) (REG32(ADR_CBR_RX_ADC_REGISTER)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0xffff0fff))
#define SET_CBR_RG_ADC_VRSEL(_VAL_) (REG32(ADR_CBR_RX_ADC_REGISTER)) = (((_VAL_) << 16) | ((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0xfffcffff))
#define SET_CBR_RG_DICMP(_VAL_) (REG32(ADR_CBR_RX_ADC_REGISTER)) = (((_VAL_) << 18) | ((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0xfff3ffff))
#define SET_CBR_RG_DIOP(_VAL_) (REG32(ADR_CBR_RX_ADC_REGISTER)) = (((_VAL_) << 20) | ((REG32(ADR_CBR_RX_ADC_REGISTER)) & 0xffcfffff))
#define SET_CBR_RG_DACI1ST(_VAL_) (REG32(ADR_CBR_TX_DAC_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0xfffffffc))
#define SET_CBR_RG_TX_DACLPF_ICOURSE(_VAL_) (REG32(ADR_CBR_TX_DAC_REGISTER)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0xfffffff3))
#define SET_CBR_RG_TX_DACLPF_IFINE(_VAL_) (REG32(ADR_CBR_TX_DAC_REGISTER)) = (((_VAL_) << 4) | ((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0xffffffcf))
#define SET_CBR_RG_TX_DACLPF_VCM(_VAL_) (REG32(ADR_CBR_TX_DAC_REGISTER)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0xffffff3f))
#define SET_CBR_RG_TX_DAC_CKEDGE_SEL(_VAL_) (REG32(ADR_CBR_TX_DAC_REGISTER)) = (((_VAL_) << 8) | ((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0xfffffeff))
#define SET_CBR_RG_TX_DAC_IBIAS(_VAL_) (REG32(ADR_CBR_TX_DAC_REGISTER)) = (((_VAL_) << 9) | ((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0xfffff9ff))
#define SET_CBR_RG_TX_DAC_OS(_VAL_) (REG32(ADR_CBR_TX_DAC_REGISTER)) = (((_VAL_) << 11) | ((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0xffffc7ff))
#define SET_CBR_RG_TX_DAC_RCAL(_VAL_) (REG32(ADR_CBR_TX_DAC_REGISTER)) = (((_VAL_) << 14) | ((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0xffff3fff))
#define SET_CBR_RG_TX_DAC_TSEL(_VAL_) (REG32(ADR_CBR_TX_DAC_REGISTER)) = (((_VAL_) << 16) | ((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0xfff0ffff))
#define SET_CBR_RG_TX_EN_VOLTAGE_IN(_VAL_) (REG32(ADR_CBR_TX_DAC_REGISTER)) = (((_VAL_) << 20) | ((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0xffefffff))
#define SET_CBR_RG_TXLPF_BYPASS(_VAL_) (REG32(ADR_CBR_TX_DAC_REGISTER)) = (((_VAL_) << 21) | ((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0xffdfffff))
#define SET_CBR_RG_TXLPF_BOOSTI(_VAL_) (REG32(ADR_CBR_TX_DAC_REGISTER)) = (((_VAL_) << 22) | ((REG32(ADR_CBR_TX_DAC_REGISTER)) & 0xffbfffff))
#define SET_CBR_RG_EN_SX_R3(_VAL_) (REG32(ADR_CBR_SX_ENABLE_RGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0xfffffffe))
#define SET_CBR_RG_EN_SX_CH(_VAL_) (REG32(ADR_CBR_SX_ENABLE_RGISTER)) = (((_VAL_) << 1) | ((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0xfffffffd))
#define SET_CBR_RG_EN_SX_CHP(_VAL_) (REG32(ADR_CBR_SX_ENABLE_RGISTER)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0xfffffffb))
#define SET_CBR_RG_EN_SX_DIVCK(_VAL_) (REG32(ADR_CBR_SX_ENABLE_RGISTER)) = (((_VAL_) << 3) | ((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0xfffffff7))
#define SET_CBR_RG_EN_SX_VCOBF(_VAL_) (REG32(ADR_CBR_SX_ENABLE_RGISTER)) = (((_VAL_) << 4) | ((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0xffffffef))
#define SET_CBR_RG_EN_SX_VCO(_VAL_) (REG32(ADR_CBR_SX_ENABLE_RGISTER)) = (((_VAL_) << 5) | ((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0xffffffdf))
#define SET_CBR_RG_EN_SX_MOD(_VAL_) (REG32(ADR_CBR_SX_ENABLE_RGISTER)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0xffffffbf))
#define SET_CBR_RG_EN_SX_LCK(_VAL_) (REG32(ADR_CBR_SX_ENABLE_RGISTER)) = (((_VAL_) << 7) | ((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0xffffff7f))
#define SET_CBR_RG_EN_SX_DITHER(_VAL_) (REG32(ADR_CBR_SX_ENABLE_RGISTER)) = (((_VAL_) << 8) | ((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0xfffffeff))
#define SET_CBR_RG_EN_SX_DELCAL(_VAL_) (REG32(ADR_CBR_SX_ENABLE_RGISTER)) = (((_VAL_) << 9) | ((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0xfffffdff))
#define SET_CBR_RG_EN_SX_PC_BYPASS(_VAL_) (REG32(ADR_CBR_SX_ENABLE_RGISTER)) = (((_VAL_) << 10) | ((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0xfffffbff))
#define SET_CBR_RG_EN_SX_VT_MON(_VAL_) (REG32(ADR_CBR_SX_ENABLE_RGISTER)) = (((_VAL_) << 11) | ((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0xfffff7ff))
#define SET_CBR_RG_EN_SX_VT_MON_DG(_VAL_) (REG32(ADR_CBR_SX_ENABLE_RGISTER)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0xffffefff))
#define SET_CBR_RG_EN_SX_DIV(_VAL_) (REG32(ADR_CBR_SX_ENABLE_RGISTER)) = (((_VAL_) << 13) | ((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0xffffdfff))
#define SET_CBR_RG_EN_SX_LPF(_VAL_) (REG32(ADR_CBR_SX_ENABLE_RGISTER)) = (((_VAL_) << 14) | ((REG32(ADR_CBR_SX_ENABLE_RGISTER)) & 0xffffbfff))
#define SET_CBR_RG_SX_RFCTRL_F(_VAL_) (REG32(ADR_CBR_SYN_RGISTER_1)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_SYN_RGISTER_1)) & 0xff000000))
#define SET_CBR_RG_SX_SEL_CP(_VAL_) (REG32(ADR_CBR_SYN_RGISTER_1)) = (((_VAL_) << 24) | ((REG32(ADR_CBR_SYN_RGISTER_1)) & 0xf0ffffff))
#define SET_CBR_RG_SX_SEL_CS(_VAL_) (REG32(ADR_CBR_SYN_RGISTER_1)) = (((_VAL_) << 28) | ((REG32(ADR_CBR_SYN_RGISTER_1)) & 0x0fffffff))
#define SET_CBR_RG_SX_RFCTRL_CH(_VAL_) (REG32(ADR_CBR_SYN_RGISTER_2)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_SYN_RGISTER_2)) & 0xfffff800))
#define SET_CBR_RG_SX_SEL_C3(_VAL_) (REG32(ADR_CBR_SYN_RGISTER_2)) = (((_VAL_) << 11) | ((REG32(ADR_CBR_SYN_RGISTER_2)) & 0xffff87ff))
#define SET_CBR_RG_SX_SEL_RS(_VAL_) (REG32(ADR_CBR_SYN_RGISTER_2)) = (((_VAL_) << 15) | ((REG32(ADR_CBR_SYN_RGISTER_2)) & 0xfff07fff))
#define SET_CBR_RG_SX_SEL_R3(_VAL_) (REG32(ADR_CBR_SYN_RGISTER_2)) = (((_VAL_) << 20) | ((REG32(ADR_CBR_SYN_RGISTER_2)) & 0xfe0fffff))
#define SET_CBR_RG_SX_SEL_ICHP(_VAL_) (REG32(ADR_CBR_SYN_PFD_CHP)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_SYN_PFD_CHP)) & 0xffffffe0))
#define SET_CBR_RG_SX_SEL_PCHP(_VAL_) (REG32(ADR_CBR_SYN_PFD_CHP)) = (((_VAL_) << 5) | ((REG32(ADR_CBR_SYN_PFD_CHP)) & 0xfffffc1f))
#define SET_CBR_RG_SX_SEL_CHP_REGOP(_VAL_) (REG32(ADR_CBR_SYN_PFD_CHP)) = (((_VAL_) << 10) | ((REG32(ADR_CBR_SYN_PFD_CHP)) & 0xffffc3ff))
#define SET_CBR_RG_SX_SEL_CHP_UNIOP(_VAL_) (REG32(ADR_CBR_SYN_PFD_CHP)) = (((_VAL_) << 14) | ((REG32(ADR_CBR_SYN_PFD_CHP)) & 0xfffc3fff))
#define SET_CBR_RG_SX_CHP_IOST_POL(_VAL_) (REG32(ADR_CBR_SYN_PFD_CHP)) = (((_VAL_) << 18) | ((REG32(ADR_CBR_SYN_PFD_CHP)) & 0xfffbffff))
#define SET_CBR_RG_SX_CHP_IOST(_VAL_) (REG32(ADR_CBR_SYN_PFD_CHP)) = (((_VAL_) << 19) | ((REG32(ADR_CBR_SYN_PFD_CHP)) & 0xffc7ffff))
#define SET_CBR_RG_SX_PFDSEL(_VAL_) (REG32(ADR_CBR_SYN_PFD_CHP)) = (((_VAL_) << 22) | ((REG32(ADR_CBR_SYN_PFD_CHP)) & 0xffbfffff))
#define SET_CBR_RG_SX_PFD_SET(_VAL_) (REG32(ADR_CBR_SYN_PFD_CHP)) = (((_VAL_) << 23) | ((REG32(ADR_CBR_SYN_PFD_CHP)) & 0xff7fffff))
#define SET_CBR_RG_SX_PFD_SET1(_VAL_) (REG32(ADR_CBR_SYN_PFD_CHP)) = (((_VAL_) << 24) | ((REG32(ADR_CBR_SYN_PFD_CHP)) & 0xfeffffff))
#define SET_CBR_RG_SX_PFD_SET2(_VAL_) (REG32(ADR_CBR_SYN_PFD_CHP)) = (((_VAL_) << 25) | ((REG32(ADR_CBR_SYN_PFD_CHP)) & 0xfdffffff))
#define SET_CBR_RG_SX_VBNCAS_SEL(_VAL_) (REG32(ADR_CBR_SYN_PFD_CHP)) = (((_VAL_) << 26) | ((REG32(ADR_CBR_SYN_PFD_CHP)) & 0xfbffffff))
#define SET_CBR_RG_SX_PFD_RST_H(_VAL_) (REG32(ADR_CBR_SYN_PFD_CHP)) = (((_VAL_) << 27) | ((REG32(ADR_CBR_SYN_PFD_CHP)) & 0xf7ffffff))
#define SET_CBR_RG_SX_PFD_TRUP(_VAL_) (REG32(ADR_CBR_SYN_PFD_CHP)) = (((_VAL_) << 28) | ((REG32(ADR_CBR_SYN_PFD_CHP)) & 0xefffffff))
#define SET_CBR_RG_SX_PFD_TRDN(_VAL_) (REG32(ADR_CBR_SYN_PFD_CHP)) = (((_VAL_) << 29) | ((REG32(ADR_CBR_SYN_PFD_CHP)) & 0xdfffffff))
#define SET_CBR_RG_SX_PFD_TRSEL(_VAL_) (REG32(ADR_CBR_SYN_PFD_CHP)) = (((_VAL_) << 30) | ((REG32(ADR_CBR_SYN_PFD_CHP)) & 0xbfffffff))
#define SET_CBR_RG_SX_VCOBA_R(_VAL_) (REG32(ADR_CBR_SYN_VCO_LOBF)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_SYN_VCO_LOBF)) & 0xfffffff8))
#define SET_CBR_RG_SX_VCORSEL(_VAL_) (REG32(ADR_CBR_SYN_VCO_LOBF)) = (((_VAL_) << 3) | ((REG32(ADR_CBR_SYN_VCO_LOBF)) & 0xffffff07))
#define SET_CBR_RG_SX_VCOCUSEL(_VAL_) (REG32(ADR_CBR_SYN_VCO_LOBF)) = (((_VAL_) << 8) | ((REG32(ADR_CBR_SYN_VCO_LOBF)) & 0xfffff0ff))
#define SET_CBR_RG_SX_RXBFSEL(_VAL_) (REG32(ADR_CBR_SYN_VCO_LOBF)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_SYN_VCO_LOBF)) & 0xffff0fff))
#define SET_CBR_RG_SX_TXBFSEL(_VAL_) (REG32(ADR_CBR_SYN_VCO_LOBF)) = (((_VAL_) << 16) | ((REG32(ADR_CBR_SYN_VCO_LOBF)) & 0xfff0ffff))
#define SET_CBR_RG_SX_VCOBFSEL(_VAL_) (REG32(ADR_CBR_SYN_VCO_LOBF)) = (((_VAL_) << 20) | ((REG32(ADR_CBR_SYN_VCO_LOBF)) & 0xff0fffff))
#define SET_CBR_RG_SX_DIVBFSEL(_VAL_) (REG32(ADR_CBR_SYN_VCO_LOBF)) = (((_VAL_) << 24) | ((REG32(ADR_CBR_SYN_VCO_LOBF)) & 0xf0ffffff))
#define SET_CBR_RG_SX_GNDR_SEL(_VAL_) (REG32(ADR_CBR_SYN_VCO_LOBF)) = (((_VAL_) << 28) | ((REG32(ADR_CBR_SYN_VCO_LOBF)) & 0x0fffffff))
#define SET_CBR_RG_SX_DITHER_WEIGHT(_VAL_) (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0xfffffffc))
#define SET_CBR_RG_SX_MOD_ERRCMP(_VAL_) (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0xfffffff3))
#define SET_CBR_RG_SX_MOD_ORDER(_VAL_) (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 4) | ((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0xffffffcf))
#define SET_CBR_RG_SX_SDM_D1(_VAL_) (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0xffffffbf))
#define SET_CBR_RG_SX_SDM_D2(_VAL_) (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 7) | ((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0xffffff7f))
#define SET_CBR_RG_SDM_PASS(_VAL_) (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 8) | ((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0xfffffeff))
#define SET_CBR_RG_SX_RST_H_DIV(_VAL_) (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 9) | ((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0xfffffdff))
#define SET_CBR_RG_SX_SDM_EDGE(_VAL_) (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 10) | ((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0xfffffbff))
#define SET_CBR_RG_SX_XO_GM(_VAL_) (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 11) | ((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0xffffe7ff))
#define SET_CBR_RG_SX_REFBYTWO(_VAL_) (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 13) | ((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0xffffdfff))
#define SET_CBR_RG_SX_XO_SWCAP(_VAL_) (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 14) | ((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0xfffc3fff))
#define SET_CBR_RG_SX_SDMLUT_INV(_VAL_) (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 18) | ((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0xfffbffff))
#define SET_CBR_RG_SX_LCKEN(_VAL_) (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 19) | ((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0xfff7ffff))
#define SET_CBR_RG_SX_PREVDD(_VAL_) (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 20) | ((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0xff0fffff))
#define SET_CBR_RG_SX_PSCONTERVDD(_VAL_) (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 24) | ((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0xf0ffffff))
#define SET_CBR_RG_SX_MOD_ERR_DELAY(_VAL_) (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 28) | ((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0xcfffffff))
#define SET_CBR_RG_SX_MODDB(_VAL_) (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 30) | ((REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) & 0xbfffffff))
#define SET_CBR_RG_SX_CV_CURVE_SEL(_VAL_) (REG32(ADR_CBR_SYN_LCK1)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_SYN_LCK1)) & 0xfffffffc))
#define SET_CBR_RG_SX_SEL_DELAY(_VAL_) (REG32(ADR_CBR_SYN_LCK1)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_SYN_LCK1)) & 0xffffff83))
#define SET_CBR_RG_SX_REF_CYCLE(_VAL_) (REG32(ADR_CBR_SYN_LCK1)) = (((_VAL_) << 7) | ((REG32(ADR_CBR_SYN_LCK1)) & 0xfffff87f))
#define SET_CBR_RG_SX_VCOBY16(_VAL_) (REG32(ADR_CBR_SYN_LCK1)) = (((_VAL_) << 11) | ((REG32(ADR_CBR_SYN_LCK1)) & 0xfffff7ff))
#define SET_CBR_RG_SX_VCOBY32(_VAL_) (REG32(ADR_CBR_SYN_LCK1)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_SYN_LCK1)) & 0xffffefff))
#define SET_CBR_RG_SX_PH(_VAL_) (REG32(ADR_CBR_SYN_LCK1)) = (((_VAL_) << 13) | ((REG32(ADR_CBR_SYN_LCK1)) & 0xffffdfff))
#define SET_CBR_RG_SX_PL(_VAL_) (REG32(ADR_CBR_SYN_LCK1)) = (((_VAL_) << 14) | ((REG32(ADR_CBR_SYN_LCK1)) & 0xffffbfff))
#define SET_CBR_RG_SX_VT_MON_MODE(_VAL_) (REG32(ADR_CBR_SYN_LCK2)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_SYN_LCK2)) & 0xfffffffe))
#define SET_CBR_RG_SX_VT_TH_HI(_VAL_) (REG32(ADR_CBR_SYN_LCK2)) = (((_VAL_) << 1) | ((REG32(ADR_CBR_SYN_LCK2)) & 0xfffffff9))
#define SET_CBR_RG_SX_VT_TH_LO(_VAL_) (REG32(ADR_CBR_SYN_LCK2)) = (((_VAL_) << 3) | ((REG32(ADR_CBR_SYN_LCK2)) & 0xffffffe7))
#define SET_CBR_RG_SX_VT_SET(_VAL_) (REG32(ADR_CBR_SYN_LCK2)) = (((_VAL_) << 5) | ((REG32(ADR_CBR_SYN_LCK2)) & 0xffffffdf))
#define SET_CBR_RG_SX_VT_MON_TMR(_VAL_) (REG32(ADR_CBR_SYN_LCK2)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_SYN_LCK2)) & 0xffff803f))
#define SET_CBR_RG_IDEAL_CYCLE(_VAL_) (REG32(ADR_CBR_SYN_LCK2)) = (((_VAL_) << 15) | ((REG32(ADR_CBR_SYN_LCK2)) & 0xf0007fff))
#define SET_CBR_RG_EN_DP_VT_MON(_VAL_) (REG32(ADR_CBR_DPLL_VCO_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_DPLL_VCO_REGISTER)) & 0xfffffffe))
#define SET_CBR_RG_DP_VT_TH_HI(_VAL_) (REG32(ADR_CBR_DPLL_VCO_REGISTER)) = (((_VAL_) << 1) | ((REG32(ADR_CBR_DPLL_VCO_REGISTER)) & 0xfffffff9))
#define SET_CBR_RG_DP_VT_TH_LO(_VAL_) (REG32(ADR_CBR_DPLL_VCO_REGISTER)) = (((_VAL_) << 3) | ((REG32(ADR_CBR_DPLL_VCO_REGISTER)) & 0xffffffe7))
#define SET_CBR_RG_DP_VT_MON_TMR(_VAL_) (REG32(ADR_CBR_DPLL_VCO_REGISTER)) = (((_VAL_) << 5) | ((REG32(ADR_CBR_DPLL_VCO_REGISTER)) & 0xffffc01f))
#define SET_CBR_RG_DP_CK320BY2(_VAL_) (REG32(ADR_CBR_DPLL_VCO_REGISTER)) = (((_VAL_) << 14) | ((REG32(ADR_CBR_DPLL_VCO_REGISTER)) & 0xffffbfff))
#define SET_CBR_RG_SX_DELCTRL(_VAL_) (REG32(ADR_CBR_DPLL_VCO_REGISTER)) = (((_VAL_) << 15) | ((REG32(ADR_CBR_DPLL_VCO_REGISTER)) & 0xffe07fff))
#define SET_CBR_RG_DP_OD_TEST(_VAL_) (REG32(ADR_CBR_DPLL_VCO_REGISTER)) = (((_VAL_) << 21) | ((REG32(ADR_CBR_DPLL_VCO_REGISTER)) & 0xffdfffff))
#define SET_CBR_RG_DP_BBPLL_BP(_VAL_) (REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0xfffffffe))
#define SET_CBR_RG_DP_BBPLL_ICP(_VAL_) (REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 1) | ((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0xfffffff9))
#define SET_CBR_RG_DP_BBPLL_IDUAL(_VAL_) (REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 3) | ((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0xffffffe7))
#define SET_CBR_RG_DP_BBPLL_OD_TEST(_VAL_) (REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 5) | ((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0xfffffe1f))
#define SET_CBR_RG_DP_BBPLL_PD(_VAL_) (REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 9) | ((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0xfffffdff))
#define SET_CBR_RG_DP_BBPLL_TESTSEL(_VAL_) (REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 10) | ((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0xffffe3ff))
#define SET_CBR_RG_DP_BBPLL_PFD_DLY(_VAL_) (REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 13) | ((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0xffff9fff))
#define SET_CBR_RG_DP_RP(_VAL_) (REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 15) | ((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0xfffc7fff))
#define SET_CBR_RG_DP_RHP(_VAL_) (REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 18) | ((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0xfff3ffff))
#define SET_CBR_RG_DP_DR3(_VAL_) (REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 20) | ((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0xff8fffff))
#define SET_CBR_RG_DP_DCP(_VAL_) (REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 23) | ((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0xf87fffff))
#define SET_CBR_RG_DP_DCS(_VAL_) (REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 27) | ((REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) & 0x87ffffff))
#define SET_CBR_RG_DP_FBDIV(_VAL_) (REG32(ADR_CBR_DPLL_DIVIDER_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_DPLL_DIVIDER_REGISTER)) & 0xfffff000))
#define SET_CBR_RG_DP_FODIV(_VAL_) (REG32(ADR_CBR_DPLL_DIVIDER_REGISTER)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_DPLL_DIVIDER_REGISTER)) & 0xffc00fff))
#define SET_CBR_RG_DP_REFDIV(_VAL_) (REG32(ADR_CBR_DPLL_DIVIDER_REGISTER)) = (((_VAL_) << 22) | ((REG32(ADR_CBR_DPLL_DIVIDER_REGISTER)) & 0x003fffff))
#define SET_CBR_RG_IDACAI_PGAG15(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER1)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER1)) & 0xffffffc0))
#define SET_CBR_RG_IDACAQ_PGAG15(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER1)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER1)) & 0xfffff03f))
#define SET_CBR_RG_IDACAI_PGAG14(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER1)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER1)) & 0xfffc0fff))
#define SET_CBR_RG_IDACAQ_PGAG14(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER1)) = (((_VAL_) << 18) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER1)) & 0xff03ffff))
#define SET_CBR_RG_IDACAI_PGAG13(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER2)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER2)) & 0xffffffc0))
#define SET_CBR_RG_IDACAQ_PGAG13(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER2)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER2)) & 0xfffff03f))
#define SET_CBR_RG_IDACAI_PGAG12(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER2)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER2)) & 0xfffc0fff))
#define SET_CBR_RG_IDACAQ_PGAG12(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER2)) = (((_VAL_) << 18) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER2)) & 0xff03ffff))
#define SET_CBR_RG_IDACAI_PGAG11(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER3)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER3)) & 0xffffffc0))
#define SET_CBR_RG_IDACAQ_PGAG11(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER3)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER3)) & 0xfffff03f))
#define SET_CBR_RG_IDACAI_PGAG10(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER3)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER3)) & 0xfffc0fff))
#define SET_CBR_RG_IDACAQ_PGAG10(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER3)) = (((_VAL_) << 18) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER3)) & 0xff03ffff))
#define SET_CBR_RG_IDACAI_PGAG9(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER4)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER4)) & 0xffffffc0))
#define SET_CBR_RG_IDACAQ_PGAG9(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER4)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER4)) & 0xfffff03f))
#define SET_CBR_RG_IDACAI_PGAG8(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER4)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER4)) & 0xfffc0fff))
#define SET_CBR_RG_IDACAQ_PGAG8(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER4)) = (((_VAL_) << 18) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER4)) & 0xff03ffff))
#define SET_CBR_RG_IDACAI_PGAG7(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER5)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER5)) & 0xffffffc0))
#define SET_CBR_RG_IDACAQ_PGAG7(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER5)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER5)) & 0xfffff03f))
#define SET_CBR_RG_IDACAI_PGAG6(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER5)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER5)) & 0xfffc0fff))
#define SET_CBR_RG_IDACAQ_PGAG6(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER5)) = (((_VAL_) << 18) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER5)) & 0xff03ffff))
#define SET_CBR_RG_IDACAI_PGAG5(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER6)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER6)) & 0xffffffc0))
#define SET_CBR_RG_IDACAQ_PGAG5(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER6)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER6)) & 0xfffff03f))
#define SET_CBR_RG_IDACAI_PGAG4(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER6)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER6)) & 0xfffc0fff))
#define SET_CBR_RG_IDACAQ_PGAG4(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER6)) = (((_VAL_) << 18) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER6)) & 0xff03ffff))
#define SET_CBR_RG_IDACAI_PGAG3(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER7)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER7)) & 0xffffffc0))
#define SET_CBR_RG_IDACAQ_PGAG3(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER7)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER7)) & 0xfffff03f))
#define SET_CBR_RG_IDACAI_PGAG2(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER7)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER7)) & 0xfffc0fff))
#define SET_CBR_RG_IDACAQ_PGAG2(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER7)) = (((_VAL_) << 18) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER7)) & 0xff03ffff))
#define SET_CBR_RG_IDACAI_PGAG1(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER8)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER8)) & 0xffffffc0))
#define SET_CBR_RG_IDACAQ_PGAG1(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER8)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER8)) & 0xfffff03f))
#define SET_CBR_RG_IDACAI_PGAG0(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER8)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER8)) & 0xfffc0fff))
#define SET_CBR_RG_IDACAQ_PGAG0(_VAL_) (REG32(ADR_CBR_DCOC_IDAC_REGISTER8)) = (((_VAL_) << 18) | ((REG32(ADR_CBR_DCOC_IDAC_REGISTER8)) & 0xff03ffff))
#define SET_CBR_RG_EN_RCAL(_VAL_) (REG32(ADR_CBR_RCAL_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_RCAL_REGISTER)) & 0xfffffffe))
#define SET_CBR_RG_RCAL_SPD(_VAL_) (REG32(ADR_CBR_RCAL_REGISTER)) = (((_VAL_) << 1) | ((REG32(ADR_CBR_RCAL_REGISTER)) & 0xfffffffd))
#define SET_CBR_RG_RCAL_TMR(_VAL_) (REG32(ADR_CBR_RCAL_REGISTER)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_RCAL_REGISTER)) & 0xfffffe03))
#define SET_CBR_RG_RCAL_CODE_CWR(_VAL_) (REG32(ADR_CBR_RCAL_REGISTER)) = (((_VAL_) << 9) | ((REG32(ADR_CBR_RCAL_REGISTER)) & 0xfffffdff))
#define SET_CBR_RG_RCAL_CODE_CWD(_VAL_) (REG32(ADR_CBR_RCAL_REGISTER)) = (((_VAL_) << 10) | ((REG32(ADR_CBR_RCAL_REGISTER)) & 0xffff83ff))
#define SET_CBR_RG_SX_SUB_SEL_CWR(_VAL_) (REG32(ADR_CBR_MANUAL_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_MANUAL_REGISTER)) & 0xfffffffe))
#define SET_CBR_RG_SX_SUB_SEL_CWD(_VAL_) (REG32(ADR_CBR_MANUAL_REGISTER)) = (((_VAL_) << 1) | ((REG32(ADR_CBR_MANUAL_REGISTER)) & 0xffffff01))
#define SET_CBR_RG_DP_BBPLL_BS_CWR(_VAL_) (REG32(ADR_CBR_MANUAL_REGISTER)) = (((_VAL_) << 8) | ((REG32(ADR_CBR_MANUAL_REGISTER)) & 0xfffffeff))
#define SET_CBR_RG_DP_BBPLL_BS_CWD(_VAL_) (REG32(ADR_CBR_MANUAL_REGISTER)) = (((_VAL_) << 9) | ((REG32(ADR_CBR_MANUAL_REGISTER)) & 0xffff81ff))
#define SET_CBR_RCAL_RDY(_VAL_) (REG32(ADR_CBR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_READ_ONLY_FLAGS_1)) & 0xfffffffe))
#define SET_CBR_DA_LCK_RDY(_VAL_) (REG32(ADR_CBR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 1) | ((REG32(ADR_CBR_READ_ONLY_FLAGS_1)) & 0xfffffffd))
#define SET_CBR_VT_MON_RDY(_VAL_) (REG32(ADR_CBR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_READ_ONLY_FLAGS_1)) & 0xfffffffb))
#define SET_CBR_DP_VT_MON_RDY(_VAL_) (REG32(ADR_CBR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 3) | ((REG32(ADR_CBR_READ_ONLY_FLAGS_1)) & 0xfffffff7))
#define SET_CBR_CH_RDY(_VAL_) (REG32(ADR_CBR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 4) | ((REG32(ADR_CBR_READ_ONLY_FLAGS_1)) & 0xffffffef))
#define SET_CBR_DA_R_CODE_LUT(_VAL_) (REG32(ADR_CBR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_READ_ONLY_FLAGS_1)) & 0xfffff83f))
#define SET_CBR_AD_SX_VT_MON_Q(_VAL_) (REG32(ADR_CBR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 11) | ((REG32(ADR_CBR_READ_ONLY_FLAGS_1)) & 0xffffe7ff))
#define SET_CBR_AD_DP_VT_MON_Q(_VAL_) (REG32(ADR_CBR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 13) | ((REG32(ADR_CBR_READ_ONLY_FLAGS_1)) & 0xffff9fff))
#define SET_CBR_DA_R_CAL_CODE(_VAL_) (REG32(ADR_CBR_READ_ONLY_FLAGS_2)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_READ_ONLY_FLAGS_2)) & 0xffffffe0))
#define SET_CBR_DA_SX_SUB_SEL(_VAL_) (REG32(ADR_CBR_READ_ONLY_FLAGS_2)) = (((_VAL_) << 5) | ((REG32(ADR_CBR_READ_ONLY_FLAGS_2)) & 0xfffff01f))
#define SET_CBR_DA_DP_BBPLL_BS(_VAL_) (REG32(ADR_CBR_READ_ONLY_FLAGS_2)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_READ_ONLY_FLAGS_2)) & 0xfffc0fff))
#define SET_CBR_TX_EN(_VAL_) (REG32(ADR_CBR_RG_PKT_GEN_0)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_RG_PKT_GEN_0)) & 0xfffffffe))
#define SET_CBR_TX_CNT_RST(_VAL_) (REG32(ADR_CBR_RG_PKT_GEN_0)) = (((_VAL_) << 1) | ((REG32(ADR_CBR_RG_PKT_GEN_0)) & 0xfffffffd))
#define SET_CBR_IFS_TIME(_VAL_) (REG32(ADR_CBR_RG_PKT_GEN_0)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_RG_PKT_GEN_0)) & 0xffffff03))
#define SET_CBR_LENGTH_TARGET(_VAL_) (REG32(ADR_CBR_RG_PKT_GEN_0)) = (((_VAL_) << 8) | ((REG32(ADR_CBR_RG_PKT_GEN_0)) & 0xfff000ff))
#define SET_CBR_TX_CNT_TARGET(_VAL_) (REG32(ADR_CBR_RG_PKT_GEN_0)) = (((_VAL_) << 24) | ((REG32(ADR_CBR_RG_PKT_GEN_0)) & 0x00ffffff))
#define SET_CBR_TC_CNT_TARGET(_VAL_) (REG32(ADR_CBR_RG_PKT_GEN_1)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_RG_PKT_GEN_1)) & 0xff000000))
#define SET_CBR_PLCP_PSDU_DATA_MEM(_VAL_) (REG32(ADR_CBR_RG_PKT_GEN_2)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_RG_PKT_GEN_2)) & 0xffffff00))
#define SET_CBR_PLCP_PSDU_PREAMBLE_SHORT(_VAL_) (REG32(ADR_CBR_RG_PKT_GEN_2)) = (((_VAL_) << 8) | ((REG32(ADR_CBR_RG_PKT_GEN_2)) & 0xfffffeff))
#define SET_CBR_PLCP_BYTE_LENGTH(_VAL_) (REG32(ADR_CBR_RG_PKT_GEN_2)) = (((_VAL_) << 9) | ((REG32(ADR_CBR_RG_PKT_GEN_2)) & 0xffe001ff))
#define SET_CBR_PLCP_PSDU_RATE(_VAL_) (REG32(ADR_CBR_RG_PKT_GEN_2)) = (((_VAL_) << 21) | ((REG32(ADR_CBR_RG_PKT_GEN_2)) & 0xff9fffff))
#define SET_CBR_TAIL_TIME(_VAL_) (REG32(ADR_CBR_RG_PKT_GEN_2)) = (((_VAL_) << 23) | ((REG32(ADR_CBR_RG_PKT_GEN_2)) & 0xe07fffff))
#define SET_CBR_RG_O_PAD_PD(_VAL_) (REG32(ADR_CBR_RG_INTEGRATION)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_RG_INTEGRATION)) & 0xfffffffe))
#define SET_CBR_RG_I_PAD_PD(_VAL_) (REG32(ADR_CBR_RG_INTEGRATION)) = (((_VAL_) << 1) | ((REG32(ADR_CBR_RG_INTEGRATION)) & 0xfffffffd))
#define SET_CBR_SEL_ADCKP_INV(_VAL_) (REG32(ADR_CBR_RG_INTEGRATION)) = (((_VAL_) << 2) | ((REG32(ADR_CBR_RG_INTEGRATION)) & 0xfffffffb))
#define SET_CBR_RG_PAD_DS(_VAL_) (REG32(ADR_CBR_RG_INTEGRATION)) = (((_VAL_) << 3) | ((REG32(ADR_CBR_RG_INTEGRATION)) & 0xfffffff7))
#define SET_CBR_SEL_ADCKP_MUX(_VAL_) (REG32(ADR_CBR_RG_INTEGRATION)) = (((_VAL_) << 4) | ((REG32(ADR_CBR_RG_INTEGRATION)) & 0xffffffef))
#define SET_CBR_RG_PAD_DS_CLK(_VAL_) (REG32(ADR_CBR_RG_INTEGRATION)) = (((_VAL_) << 5) | ((REG32(ADR_CBR_RG_INTEGRATION)) & 0xffffffdf))
#define SET_CBR_INTP_SEL(_VAL_) (REG32(ADR_CBR_RG_INTEGRATION)) = (((_VAL_) << 9) | ((REG32(ADR_CBR_RG_INTEGRATION)) & 0xfffffdff))
#define SET_CBR_IQ_SWP(_VAL_) (REG32(ADR_CBR_RG_INTEGRATION)) = (((_VAL_) << 10) | ((REG32(ADR_CBR_RG_INTEGRATION)) & 0xfffffbff))
#define SET_CBR_RG_EN_EXT_DA(_VAL_) (REG32(ADR_CBR_RG_INTEGRATION)) = (((_VAL_) << 11) | ((REG32(ADR_CBR_RG_INTEGRATION)) & 0xfffff7ff))
#define SET_CBR_RG_DIS_DA_OFFSET(_VAL_) (REG32(ADR_CBR_RG_INTEGRATION)) = (((_VAL_) << 12) | ((REG32(ADR_CBR_RG_INTEGRATION)) & 0xffffefff))
#define SET_CBR_DBG_SEL(_VAL_) (REG32(ADR_CBR_RG_INTEGRATION)) = (((_VAL_) << 16) | ((REG32(ADR_CBR_RG_INTEGRATION)) & 0xfff0ffff))
#define SET_CBR_DBG_EN(_VAL_) (REG32(ADR_CBR_RG_INTEGRATION)) = (((_VAL_) << 20) | ((REG32(ADR_CBR_RG_INTEGRATION)) & 0xffefffff))
#define SET_CBR_RG_PKT_GEN_TX_CNT(_VAL_) (REG32(ADR_CBR_RG_PKT_GEN_TXCNT)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_RG_PKT_GEN_TXCNT)) & 0x00000000))
#define SET_CBR_TP_SEL(_VAL_) (REG32(ADR_CBR_PATTERN_GEN)) = (((_VAL_) << 0) | ((REG32(ADR_CBR_PATTERN_GEN)) & 0xffffffe0))
#define SET_CBR_IDEAL_IQ_EN(_VAL_) (REG32(ADR_CBR_PATTERN_GEN)) = (((_VAL_) << 5) | ((REG32(ADR_CBR_PATTERN_GEN)) & 0xffffffdf))
#define SET_CBR_DATA_OUT_SEL(_VAL_) (REG32(ADR_CBR_PATTERN_GEN)) = (((_VAL_) << 6) | ((REG32(ADR_CBR_PATTERN_GEN)) & 0xfffffe3f))
#define SET_CBR_TWO_TONE_EN(_VAL_) (REG32(ADR_CBR_PATTERN_GEN)) = (((_VAL_) << 9) | ((REG32(ADR_CBR_PATTERN_GEN)) & 0xfffffdff))
#define SET_CBR_FREQ_SEL(_VAL_) (REG32(ADR_CBR_PATTERN_GEN)) = (((_VAL_) << 16) | ((REG32(ADR_CBR_PATTERN_GEN)) & 0xff00ffff))
#define SET_CBR_IQ_SCALE(_VAL_) (REG32(ADR_CBR_PATTERN_GEN)) = (((_VAL_) << 24) | ((REG32(ADR_CBR_PATTERN_GEN)) & 0x00ffffff))
#define SET_CPU_QUE_POP(_VAL_) (REG32(ADR_MB_CPU_INT)) = (((_VAL_) << 0) | ((REG32(ADR_MB_CPU_INT)) & 0xfffffffe))
#define SET_CPU_INT(_VAL_) (REG32(ADR_MB_CPU_INT)) = (((_VAL_) << 2) | ((REG32(ADR_MB_CPU_INT)) & 0xfffffffb))
#define SET_CPU_ID_TB0(_VAL_) (REG32(ADR_CPU_ID_TB0)) = (((_VAL_) << 0) | ((REG32(ADR_CPU_ID_TB0)) & 0x00000000))
#define SET_CPU_ID_TB1(_VAL_) (REG32(ADR_CPU_ID_TB1)) = (((_VAL_) << 0) | ((REG32(ADR_CPU_ID_TB1)) & 0x00000000))
#define SET_HW_PKTID(_VAL_) (REG32(ADR_CH0_TRIG_1)) = (((_VAL_) << 0) | ((REG32(ADR_CH0_TRIG_1)) & 0xfffff800))
#define SET_CH0_INT_ADDR(_VAL_) (REG32(ADR_CH0_TRIG_0)) = (((_VAL_) << 0) | ((REG32(ADR_CH0_TRIG_0)) & 0x00000000))
#define SET_PRI_HW_PKTID(_VAL_) (REG32(ADR_CH0_PRI_TRIG)) = (((_VAL_) << 0) | ((REG32(ADR_CH0_PRI_TRIG)) & 0xfffff800))
#define SET_CH0_FULL(_VAL_) (REG32(ADR_MCU_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_MCU_STATUS)) & 0xfffffffe))
#define SET_FF0_EMPTY(_VAL_) (REG32(ADR_MCU_STATUS)) = (((_VAL_) << 1) | ((REG32(ADR_MCU_STATUS)) & 0xfffffffd))
#define SET_RLS_BUSY(_VAL_) (REG32(ADR_MCU_STATUS)) = (((_VAL_) << 9) | ((REG32(ADR_MCU_STATUS)) & 0xfffffdff))
#define SET_RLS_COUNT_CLR(_VAL_) (REG32(ADR_MCU_STATUS)) = (((_VAL_) << 10) | ((REG32(ADR_MCU_STATUS)) & 0xfffffbff))
#define SET_RTN_COUNT_CLR(_VAL_) (REG32(ADR_MCU_STATUS)) = (((_VAL_) << 11) | ((REG32(ADR_MCU_STATUS)) & 0xfffff7ff))
#define SET_RLS_COUNT(_VAL_) (REG32(ADR_MCU_STATUS)) = (((_VAL_) << 16) | ((REG32(ADR_MCU_STATUS)) & 0xff00ffff))
#define SET_RTN_COUNT(_VAL_) (REG32(ADR_MCU_STATUS)) = (((_VAL_) << 24) | ((REG32(ADR_MCU_STATUS)) & 0x00ffffff))
#define SET_FF0_CNT(_VAL_) (REG32(ADR_RD_IN_FFCNT1)) = (((_VAL_) << 0) | ((REG32(ADR_RD_IN_FFCNT1)) & 0xffffffe0))
#define SET_FF1_CNT(_VAL_) (REG32(ADR_RD_IN_FFCNT1)) = (((_VAL_) << 5) | ((REG32(ADR_RD_IN_FFCNT1)) & 0xfffffe1f))
#define SET_FF3_CNT(_VAL_) (REG32(ADR_RD_IN_FFCNT1)) = (((_VAL_) << 11) | ((REG32(ADR_RD_IN_FFCNT1)) & 0xffffc7ff))
#define SET_FF5_CNT(_VAL_) (REG32(ADR_RD_IN_FFCNT1)) = (((_VAL_) << 17) | ((REG32(ADR_RD_IN_FFCNT1)) & 0xfff1ffff))
#define SET_FF6_CNT(_VAL_) (REG32(ADR_RD_IN_FFCNT1)) = (((_VAL_) << 20) | ((REG32(ADR_RD_IN_FFCNT1)) & 0xff8fffff))
#define SET_FF7_CNT(_VAL_) (REG32(ADR_RD_IN_FFCNT1)) = (((_VAL_) << 23) | ((REG32(ADR_RD_IN_FFCNT1)) & 0xfc7fffff))
#define SET_FF8_CNT(_VAL_) (REG32(ADR_RD_IN_FFCNT1)) = (((_VAL_) << 26) | ((REG32(ADR_RD_IN_FFCNT1)) & 0xe3ffffff))
#define SET_FF9_CNT(_VAL_) (REG32(ADR_RD_IN_FFCNT1)) = (((_VAL_) << 29) | ((REG32(ADR_RD_IN_FFCNT1)) & 0x1fffffff))
#define SET_FF10_CNT(_VAL_) (REG32(ADR_RD_IN_FFCNT2)) = (((_VAL_) << 0) | ((REG32(ADR_RD_IN_FFCNT2)) & 0xfffffff8))
#define SET_FF11_CNT(_VAL_) (REG32(ADR_RD_IN_FFCNT2)) = (((_VAL_) << 3) | ((REG32(ADR_RD_IN_FFCNT2)) & 0xffffffc7))
#define SET_FF12_CNT(_VAL_) (REG32(ADR_RD_IN_FFCNT2)) = (((_VAL_) << 6) | ((REG32(ADR_RD_IN_FFCNT2)) & 0xfffffe3f))
#define SET_FF13_CNT(_VAL_) (REG32(ADR_RD_IN_FFCNT2)) = (((_VAL_) << 9) | ((REG32(ADR_RD_IN_FFCNT2)) & 0xfffff9ff))
#define SET_FF14_CNT(_VAL_) (REG32(ADR_RD_IN_FFCNT2)) = (((_VAL_) << 11) | ((REG32(ADR_RD_IN_FFCNT2)) & 0xffffe7ff))
#define SET_FF15_CNT(_VAL_) (REG32(ADR_RD_IN_FFCNT2)) = (((_VAL_) << 13) | ((REG32(ADR_RD_IN_FFCNT2)) & 0xffff9fff))
#define SET_FF4_CNT(_VAL_) (REG32(ADR_RD_IN_FFCNT2)) = (((_VAL_) << 15) | ((REG32(ADR_RD_IN_FFCNT2)) & 0xfff07fff))
#define SET_FF2_CNT(_VAL_) (REG32(ADR_RD_IN_FFCNT2)) = (((_VAL_) << 20) | ((REG32(ADR_RD_IN_FFCNT2)) & 0xff8fffff))
#define SET_CH1_FULL(_VAL_) (REG32(ADR_RD_FFIN_FULL)) = (((_VAL_) << 1) | ((REG32(ADR_RD_FFIN_FULL)) & 0xfffffffd))
#define SET_CH2_FULL(_VAL_) (REG32(ADR_RD_FFIN_FULL)) = (((_VAL_) << 2) | ((REG32(ADR_RD_FFIN_FULL)) & 0xfffffffb))
#define SET_CH3_FULL(_VAL_) (REG32(ADR_RD_FFIN_FULL)) = (((_VAL_) << 3) | ((REG32(ADR_RD_FFIN_FULL)) & 0xfffffff7))
#define SET_CH4_FULL(_VAL_) (REG32(ADR_RD_FFIN_FULL)) = (((_VAL_) << 4) | ((REG32(ADR_RD_FFIN_FULL)) & 0xffffffef))
#define SET_CH5_FULL(_VAL_) (REG32(ADR_RD_FFIN_FULL)) = (((_VAL_) << 5) | ((REG32(ADR_RD_FFIN_FULL)) & 0xffffffdf))
#define SET_CH6_FULL(_VAL_) (REG32(ADR_RD_FFIN_FULL)) = (((_VAL_) << 6) | ((REG32(ADR_RD_FFIN_FULL)) & 0xffffffbf))
#define SET_CH7_FULL(_VAL_) (REG32(ADR_RD_FFIN_FULL)) = (((_VAL_) << 7) | ((REG32(ADR_RD_FFIN_FULL)) & 0xffffff7f))
#define SET_CH8_FULL(_VAL_) (REG32(ADR_RD_FFIN_FULL)) = (((_VAL_) << 8) | ((REG32(ADR_RD_FFIN_FULL)) & 0xfffffeff))
#define SET_CH9_FULL(_VAL_) (REG32(ADR_RD_FFIN_FULL)) = (((_VAL_) << 9) | ((REG32(ADR_RD_FFIN_FULL)) & 0xfffffdff))
#define SET_CH10_FULL(_VAL_) (REG32(ADR_RD_FFIN_FULL)) = (((_VAL_) << 10) | ((REG32(ADR_RD_FFIN_FULL)) & 0xfffffbff))
#define SET_CH11_FULL(_VAL_) (REG32(ADR_RD_FFIN_FULL)) = (((_VAL_) << 11) | ((REG32(ADR_RD_FFIN_FULL)) & 0xfffff7ff))
#define SET_CH12_FULL(_VAL_) (REG32(ADR_RD_FFIN_FULL)) = (((_VAL_) << 12) | ((REG32(ADR_RD_FFIN_FULL)) & 0xffffefff))
#define SET_CH13_FULL(_VAL_) (REG32(ADR_RD_FFIN_FULL)) = (((_VAL_) << 13) | ((REG32(ADR_RD_FFIN_FULL)) & 0xffffdfff))
#define SET_CH14_FULL(_VAL_) (REG32(ADR_RD_FFIN_FULL)) = (((_VAL_) << 14) | ((REG32(ADR_RD_FFIN_FULL)) & 0xffffbfff))
#define SET_CH15_FULL(_VAL_) (REG32(ADR_RD_FFIN_FULL)) = (((_VAL_) << 15) | ((REG32(ADR_RD_FFIN_FULL)) & 0xffff7fff))
#define SET_HALT_CH0(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 0) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xfffffffe))
#define SET_HALT_CH1(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 1) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xfffffffd))
#define SET_HALT_CH2(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 2) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xfffffffb))
#define SET_HALT_CH3(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 3) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xfffffff7))
#define SET_HALT_CH4(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 4) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xffffffef))
#define SET_HALT_CH5(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 5) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xffffffdf))
#define SET_HALT_CH6(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 6) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xffffffbf))
#define SET_HALT_CH7(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 7) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xffffff7f))
#define SET_HALT_CH8(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 8) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xfffffeff))
#define SET_HALT_CH9(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 9) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xfffffdff))
#define SET_HALT_CH10(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 10) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xfffffbff))
#define SET_HALT_CH11(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 11) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xfffff7ff))
#define SET_HALT_CH12(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 12) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xffffefff))
#define SET_HALT_CH13(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 13) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xffffdfff))
#define SET_HALT_CH14(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 14) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xffffbfff))
#define SET_HALT_CH15(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 15) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xffff7fff))
#define SET_STOP_MBOX(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 16) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xfffeffff))
#define SET_MB_ERR_AUTO_HALT_EN(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 20) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xffefffff))
#define SET_MB_EXCEPT_CLR(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 21) | ((REG32(ADR_MBOX_HALT_CFG)) & 0xffdfffff))
#define SET_MB_EXCEPT_CASE(_VAL_) (REG32(ADR_MBOX_HALT_CFG)) = (((_VAL_) << 24) | ((REG32(ADR_MBOX_HALT_CFG)) & 0x00ffffff))
#define SET_MB_DBG_TIME_STEP(_VAL_) (REG32(ADR_MB_DBG_CFG1)) = (((_VAL_) << 0) | ((REG32(ADR_MB_DBG_CFG1)) & 0xffff0000))
#define SET_DBG_TYPE(_VAL_) (REG32(ADR_MB_DBG_CFG1)) = (((_VAL_) << 16) | ((REG32(ADR_MB_DBG_CFG1)) & 0xfffcffff))
#define SET_MB_DBG_CLR(_VAL_) (REG32(ADR_MB_DBG_CFG1)) = (((_VAL_) << 18) | ((REG32(ADR_MB_DBG_CFG1)) & 0xfffbffff))
#define SET_DBG_ALC_LOG_EN(_VAL_) (REG32(ADR_MB_DBG_CFG1)) = (((_VAL_) << 19) | ((REG32(ADR_MB_DBG_CFG1)) & 0xfff7ffff))
#define SET_MB_DBG_COUNTER_EN(_VAL_) (REG32(ADR_MB_DBG_CFG1)) = (((_VAL_) << 24) | ((REG32(ADR_MB_DBG_CFG1)) & 0xfeffffff))
#define SET_MB_DBG_EN(_VAL_) (REG32(ADR_MB_DBG_CFG1)) = (((_VAL_) << 31) | ((REG32(ADR_MB_DBG_CFG1)) & 0x7fffffff))
#define SET_MB_DBG_RECORD_CNT(_VAL_) (REG32(ADR_MB_DBG_CFG2)) = (((_VAL_) << 0) | ((REG32(ADR_MB_DBG_CFG2)) & 0xffff0000))
#define SET_MB_DBG_LENGTH(_VAL_) (REG32(ADR_MB_DBG_CFG2)) = (((_VAL_) << 16) | ((REG32(ADR_MB_DBG_CFG2)) & 0x0000ffff))
#define SET_MB_DBG_CFG_ADDR(_VAL_) (REG32(ADR_MB_DBG_CFG3)) = (((_VAL_) << 0) | ((REG32(ADR_MB_DBG_CFG3)) & 0x00000000))
#define SET_DBG_HWID0_WR_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 0) | ((REG32(ADR_MB_DBG_CFG4)) & 0xfffffffe))
#define SET_DBG_HWID1_WR_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 1) | ((REG32(ADR_MB_DBG_CFG4)) & 0xfffffffd))
#define SET_DBG_HWID2_WR_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 2) | ((REG32(ADR_MB_DBG_CFG4)) & 0xfffffffb))
#define SET_DBG_HWID3_WR_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 3) | ((REG32(ADR_MB_DBG_CFG4)) & 0xfffffff7))
#define SET_DBG_HWID4_WR_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 4) | ((REG32(ADR_MB_DBG_CFG4)) & 0xffffffef))
#define SET_DBG_HWID5_WR_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 5) | ((REG32(ADR_MB_DBG_CFG4)) & 0xffffffdf))
#define SET_DBG_HWID6_WR_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 6) | ((REG32(ADR_MB_DBG_CFG4)) & 0xffffffbf))
#define SET_DBG_HWID7_WR_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 7) | ((REG32(ADR_MB_DBG_CFG4)) & 0xffffff7f))
#define SET_DBG_HWID8_WR_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 8) | ((REG32(ADR_MB_DBG_CFG4)) & 0xfffffeff))
#define SET_DBG_HWID9_WR_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 9) | ((REG32(ADR_MB_DBG_CFG4)) & 0xfffffdff))
#define SET_DBG_HWID10_WR_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 10) | ((REG32(ADR_MB_DBG_CFG4)) & 0xfffffbff))
#define SET_DBG_HWID11_WR_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 11) | ((REG32(ADR_MB_DBG_CFG4)) & 0xfffff7ff))
#define SET_DBG_HWID12_WR_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 12) | ((REG32(ADR_MB_DBG_CFG4)) & 0xffffefff))
#define SET_DBG_HWID13_WR_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 13) | ((REG32(ADR_MB_DBG_CFG4)) & 0xffffdfff))
#define SET_DBG_HWID14_WR_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 14) | ((REG32(ADR_MB_DBG_CFG4)) & 0xffffbfff))
#define SET_DBG_HWID15_WR_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 15) | ((REG32(ADR_MB_DBG_CFG4)) & 0xffff7fff))
#define SET_DBG_HWID0_RD_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 16) | ((REG32(ADR_MB_DBG_CFG4)) & 0xfffeffff))
#define SET_DBG_HWID1_RD_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 17) | ((REG32(ADR_MB_DBG_CFG4)) & 0xfffdffff))
#define SET_DBG_HWID2_RD_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 18) | ((REG32(ADR_MB_DBG_CFG4)) & 0xfffbffff))
#define SET_DBG_HWID3_RD_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 19) | ((REG32(ADR_MB_DBG_CFG4)) & 0xfff7ffff))
#define SET_DBG_HWID4_RD_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 20) | ((REG32(ADR_MB_DBG_CFG4)) & 0xffefffff))
#define SET_DBG_HWID5_RD_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 21) | ((REG32(ADR_MB_DBG_CFG4)) & 0xffdfffff))
#define SET_DBG_HWID6_RD_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 22) | ((REG32(ADR_MB_DBG_CFG4)) & 0xffbfffff))
#define SET_DBG_HWID7_RD_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 23) | ((REG32(ADR_MB_DBG_CFG4)) & 0xff7fffff))
#define SET_DBG_HWID8_RD_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 24) | ((REG32(ADR_MB_DBG_CFG4)) & 0xfeffffff))
#define SET_DBG_HWID9_RD_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 25) | ((REG32(ADR_MB_DBG_CFG4)) & 0xfdffffff))
#define SET_DBG_HWID10_RD_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 26) | ((REG32(ADR_MB_DBG_CFG4)) & 0xfbffffff))
#define SET_DBG_HWID11_RD_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 27) | ((REG32(ADR_MB_DBG_CFG4)) & 0xf7ffffff))
#define SET_DBG_HWID12_RD_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 28) | ((REG32(ADR_MB_DBG_CFG4)) & 0xefffffff))
#define SET_DBG_HWID13_RD_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 29) | ((REG32(ADR_MB_DBG_CFG4)) & 0xdfffffff))
#define SET_DBG_HWID14_RD_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 30) | ((REG32(ADR_MB_DBG_CFG4)) & 0xbfffffff))
#define SET_DBG_HWID15_RD_EN(_VAL_) (REG32(ADR_MB_DBG_CFG4)) = (((_VAL_) << 31) | ((REG32(ADR_MB_DBG_CFG4)) & 0x7fffffff))
#define SET_MB_OUT_QUEUE_EN(_VAL_) (REG32(ADR_MB_OUT_QUEUE_CFG)) = (((_VAL_) << 1) | ((REG32(ADR_MB_OUT_QUEUE_CFG)) & 0xfffffffd))
#define SET_CH0_QUEUE_FLUSH(_VAL_) (REG32(ADR_MB_OUT_QUEUE_FLUSH)) = (((_VAL_) << 0) | ((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0xfffffffe))
#define SET_CH1_QUEUE_FLUSH(_VAL_) (REG32(ADR_MB_OUT_QUEUE_FLUSH)) = (((_VAL_) << 1) | ((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0xfffffffd))
#define SET_CH2_QUEUE_FLUSH(_VAL_) (REG32(ADR_MB_OUT_QUEUE_FLUSH)) = (((_VAL_) << 2) | ((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0xfffffffb))
#define SET_CH3_QUEUE_FLUSH(_VAL_) (REG32(ADR_MB_OUT_QUEUE_FLUSH)) = (((_VAL_) << 3) | ((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0xfffffff7))
#define SET_CH4_QUEUE_FLUSH(_VAL_) (REG32(ADR_MB_OUT_QUEUE_FLUSH)) = (((_VAL_) << 4) | ((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0xffffffef))
#define SET_CH5_QUEUE_FLUSH(_VAL_) (REG32(ADR_MB_OUT_QUEUE_FLUSH)) = (((_VAL_) << 5) | ((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0xffffffdf))
#define SET_CH6_QUEUE_FLUSH(_VAL_) (REG32(ADR_MB_OUT_QUEUE_FLUSH)) = (((_VAL_) << 6) | ((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0xffffffbf))
#define SET_CH7_QUEUE_FLUSH(_VAL_) (REG32(ADR_MB_OUT_QUEUE_FLUSH)) = (((_VAL_) << 7) | ((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0xffffff7f))
#define SET_CH8_QUEUE_FLUSH(_VAL_) (REG32(ADR_MB_OUT_QUEUE_FLUSH)) = (((_VAL_) << 8) | ((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0xfffffeff))
#define SET_CH9_QUEUE_FLUSH(_VAL_) (REG32(ADR_MB_OUT_QUEUE_FLUSH)) = (((_VAL_) << 9) | ((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0xfffffdff))
#define SET_CH10_QUEUE_FLUSH(_VAL_) (REG32(ADR_MB_OUT_QUEUE_FLUSH)) = (((_VAL_) << 10) | ((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0xfffffbff))
#define SET_CH11_QUEUE_FLUSH(_VAL_) (REG32(ADR_MB_OUT_QUEUE_FLUSH)) = (((_VAL_) << 11) | ((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0xfffff7ff))
#define SET_CH12_QUEUE_FLUSH(_VAL_) (REG32(ADR_MB_OUT_QUEUE_FLUSH)) = (((_VAL_) << 12) | ((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0xffffefff))
#define SET_CH13_QUEUE_FLUSH(_VAL_) (REG32(ADR_MB_OUT_QUEUE_FLUSH)) = (((_VAL_) << 13) | ((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0xffffdfff))
#define SET_CH14_QUEUE_FLUSH(_VAL_) (REG32(ADR_MB_OUT_QUEUE_FLUSH)) = (((_VAL_) << 14) | ((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0xffffbfff))
#define SET_CH15_QUEUE_FLUSH(_VAL_) (REG32(ADR_MB_OUT_QUEUE_FLUSH)) = (((_VAL_) << 15) | ((REG32(ADR_MB_OUT_QUEUE_FLUSH)) & 0xffff7fff))
#define SET_FFO0_CNT(_VAL_) (REG32(ADR_RD_FFOUT_CNT1)) = (((_VAL_) << 0) | ((REG32(ADR_RD_FFOUT_CNT1)) & 0xffffffe0))
#define SET_FFO1_CNT(_VAL_) (REG32(ADR_RD_FFOUT_CNT1)) = (((_VAL_) << 5) | ((REG32(ADR_RD_FFOUT_CNT1)) & 0xfffffc1f))
#define SET_FFO2_CNT(_VAL_) (REG32(ADR_RD_FFOUT_CNT1)) = (((_VAL_) << 10) | ((REG32(ADR_RD_FFOUT_CNT1)) & 0xfffff3ff))
#define SET_FFO3_CNT(_VAL_) (REG32(ADR_RD_FFOUT_CNT1)) = (((_VAL_) << 15) | ((REG32(ADR_RD_FFOUT_CNT1)) & 0xfff07fff))
#define SET_FFO4_CNT(_VAL_) (REG32(ADR_RD_FFOUT_CNT1)) = (((_VAL_) << 20) | ((REG32(ADR_RD_FFOUT_CNT1)) & 0xffcfffff))
#define SET_FFO5_CNT(_VAL_) (REG32(ADR_RD_FFOUT_CNT1)) = (((_VAL_) << 25) | ((REG32(ADR_RD_FFOUT_CNT1)) & 0xf1ffffff))
#define SET_FFO6_CNT(_VAL_) (REG32(ADR_RD_FFOUT_CNT2)) = (((_VAL_) << 0) | ((REG32(ADR_RD_FFOUT_CNT2)) & 0xfffffff0))
#define SET_FFO7_CNT(_VAL_) (REG32(ADR_RD_FFOUT_CNT2)) = (((_VAL_) << 5) | ((REG32(ADR_RD_FFOUT_CNT2)) & 0xfffffc1f))
#define SET_FFO8_CNT(_VAL_) (REG32(ADR_RD_FFOUT_CNT2)) = (((_VAL_) << 10) | ((REG32(ADR_RD_FFOUT_CNT2)) & 0xffff83ff))
#define SET_FFO9_CNT(_VAL_) (REG32(ADR_RD_FFOUT_CNT2)) = (((_VAL_) << 15) | ((REG32(ADR_RD_FFOUT_CNT2)) & 0xfff07fff))
#define SET_FFO10_CNT(_VAL_) (REG32(ADR_RD_FFOUT_CNT2)) = (((_VAL_) << 20) | ((REG32(ADR_RD_FFOUT_CNT2)) & 0xff0fffff))
#define SET_FFO11_CNT(_VAL_) (REG32(ADR_RD_FFOUT_CNT2)) = (((_VAL_) << 25) | ((REG32(ADR_RD_FFOUT_CNT2)) & 0xc1ffffff))
#define SET_FFO12_CNT(_VAL_) (REG32(ADR_RD_FFOUT_CNT3)) = (((_VAL_) << 0) | ((REG32(ADR_RD_FFOUT_CNT3)) & 0xfffffff8))
#define SET_FFO13_CNT(_VAL_) (REG32(ADR_RD_FFOUT_CNT3)) = (((_VAL_) << 5) | ((REG32(ADR_RD_FFOUT_CNT3)) & 0xffffff9f))
#define SET_FFO14_CNT(_VAL_) (REG32(ADR_RD_FFOUT_CNT3)) = (((_VAL_) << 10) | ((REG32(ADR_RD_FFOUT_CNT3)) & 0xfffff3ff))
#define SET_FFO15_CNT(_VAL_) (REG32(ADR_RD_FFOUT_CNT3)) = (((_VAL_) << 15) | ((REG32(ADR_RD_FFOUT_CNT3)) & 0xffe07fff))
#define SET_CH0_FFO_FULL(_VAL_) (REG32(ADR_RD_FFOUT_FULL)) = (((_VAL_) << 0) | ((REG32(ADR_RD_FFOUT_FULL)) & 0xfffffffe))
#define SET_CH1_FFO_FULL(_VAL_) (REG32(ADR_RD_FFOUT_FULL)) = (((_VAL_) << 1) | ((REG32(ADR_RD_FFOUT_FULL)) & 0xfffffffd))
#define SET_CH2_FFO_FULL(_VAL_) (REG32(ADR_RD_FFOUT_FULL)) = (((_VAL_) << 2) | ((REG32(ADR_RD_FFOUT_FULL)) & 0xfffffffb))
#define SET_CH3_FFO_FULL(_VAL_) (REG32(ADR_RD_FFOUT_FULL)) = (((_VAL_) << 3) | ((REG32(ADR_RD_FFOUT_FULL)) & 0xfffffff7))
#define SET_CH4_FFO_FULL(_VAL_) (REG32(ADR_RD_FFOUT_FULL)) = (((_VAL_) << 4) | ((REG32(ADR_RD_FFOUT_FULL)) & 0xffffffef))
#define SET_CH5_FFO_FULL(_VAL_) (REG32(ADR_RD_FFOUT_FULL)) = (((_VAL_) << 5) | ((REG32(ADR_RD_FFOUT_FULL)) & 0xffffffdf))
#define SET_CH6_FFO_FULL(_VAL_) (REG32(ADR_RD_FFOUT_FULL)) = (((_VAL_) << 6) | ((REG32(ADR_RD_FFOUT_FULL)) & 0xffffffbf))
#define SET_CH7_FFO_FULL(_VAL_) (REG32(ADR_RD_FFOUT_FULL)) = (((_VAL_) << 7) | ((REG32(ADR_RD_FFOUT_FULL)) & 0xffffff7f))
#define SET_CH8_FFO_FULL(_VAL_) (REG32(ADR_RD_FFOUT_FULL)) = (((_VAL_) << 8) | ((REG32(ADR_RD_FFOUT_FULL)) & 0xfffffeff))
#define SET_CH9_FFO_FULL(_VAL_) (REG32(ADR_RD_FFOUT_FULL)) = (((_VAL_) << 9) | ((REG32(ADR_RD_FFOUT_FULL)) & 0xfffffdff))
#define SET_CH10_FFO_FULL(_VAL_) (REG32(ADR_RD_FFOUT_FULL)) = (((_VAL_) << 10) | ((REG32(ADR_RD_FFOUT_FULL)) & 0xfffffbff))
#define SET_CH11_FFO_FULL(_VAL_) (REG32(ADR_RD_FFOUT_FULL)) = (((_VAL_) << 11) | ((REG32(ADR_RD_FFOUT_FULL)) & 0xfffff7ff))
#define SET_CH12_FFO_FULL(_VAL_) (REG32(ADR_RD_FFOUT_FULL)) = (((_VAL_) << 12) | ((REG32(ADR_RD_FFOUT_FULL)) & 0xffffefff))
#define SET_CH13_FFO_FULL(_VAL_) (REG32(ADR_RD_FFOUT_FULL)) = (((_VAL_) << 13) | ((REG32(ADR_RD_FFOUT_FULL)) & 0xffffdfff))
#define SET_CH14_FFO_FULL(_VAL_) (REG32(ADR_RD_FFOUT_FULL)) = (((_VAL_) << 14) | ((REG32(ADR_RD_FFOUT_FULL)) & 0xffffbfff))
#define SET_CH15_FFO_FULL(_VAL_) (REG32(ADR_RD_FFOUT_FULL)) = (((_VAL_) << 15) | ((REG32(ADR_RD_FFOUT_FULL)) & 0xffff7fff))
#define SET_CH0_LOWTHOLD_INT(_VAL_) (REG32(ADR_MB_THRESHOLD6)) = (((_VAL_) << 0) | ((REG32(ADR_MB_THRESHOLD6)) & 0xfffffffe))
#define SET_CH1_LOWTHOLD_INT(_VAL_) (REG32(ADR_MB_THRESHOLD6)) = (((_VAL_) << 1) | ((REG32(ADR_MB_THRESHOLD6)) & 0xfffffffd))
#define SET_CH2_LOWTHOLD_INT(_VAL_) (REG32(ADR_MB_THRESHOLD6)) = (((_VAL_) << 2) | ((REG32(ADR_MB_THRESHOLD6)) & 0xfffffffb))
#define SET_CH3_LOWTHOLD_INT(_VAL_) (REG32(ADR_MB_THRESHOLD6)) = (((_VAL_) << 3) | ((REG32(ADR_MB_THRESHOLD6)) & 0xfffffff7))
#define SET_CH4_LOWTHOLD_INT(_VAL_) (REG32(ADR_MB_THRESHOLD6)) = (((_VAL_) << 4) | ((REG32(ADR_MB_THRESHOLD6)) & 0xffffffef))
#define SET_CH5_LOWTHOLD_INT(_VAL_) (REG32(ADR_MB_THRESHOLD6)) = (((_VAL_) << 5) | ((REG32(ADR_MB_THRESHOLD6)) & 0xffffffdf))
#define SET_CH6_LOWTHOLD_INT(_VAL_) (REG32(ADR_MB_THRESHOLD6)) = (((_VAL_) << 6) | ((REG32(ADR_MB_THRESHOLD6)) & 0xffffffbf))
#define SET_CH7_LOWTHOLD_INT(_VAL_) (REG32(ADR_MB_THRESHOLD6)) = (((_VAL_) << 7) | ((REG32(ADR_MB_THRESHOLD6)) & 0xffffff7f))
#define SET_CH8_LOWTHOLD_INT(_VAL_) (REG32(ADR_MB_THRESHOLD6)) = (((_VAL_) << 8) | ((REG32(ADR_MB_THRESHOLD6)) & 0xfffffeff))
#define SET_CH9_LOWTHOLD_INT(_VAL_) (REG32(ADR_MB_THRESHOLD6)) = (((_VAL_) << 9) | ((REG32(ADR_MB_THRESHOLD6)) & 0xfffffdff))
#define SET_CH10_LOWTHOLD_INT(_VAL_) (REG32(ADR_MB_THRESHOLD6)) = (((_VAL_) << 10) | ((REG32(ADR_MB_THRESHOLD6)) & 0xfffffbff))
#define SET_CH11_LOWTHOLD_INT(_VAL_) (REG32(ADR_MB_THRESHOLD6)) = (((_VAL_) << 11) | ((REG32(ADR_MB_THRESHOLD6)) & 0xfffff7ff))
#define SET_CH12_LOWTHOLD_INT(_VAL_) (REG32(ADR_MB_THRESHOLD6)) = (((_VAL_) << 12) | ((REG32(ADR_MB_THRESHOLD6)) & 0xffffefff))
#define SET_CH13_LOWTHOLD_INT(_VAL_) (REG32(ADR_MB_THRESHOLD6)) = (((_VAL_) << 13) | ((REG32(ADR_MB_THRESHOLD6)) & 0xffffdfff))
#define SET_CH14_LOWTHOLD_INT(_VAL_) (REG32(ADR_MB_THRESHOLD6)) = (((_VAL_) << 14) | ((REG32(ADR_MB_THRESHOLD6)) & 0xffffbfff))
#define SET_CH15_LOWTHOLD_INT(_VAL_) (REG32(ADR_MB_THRESHOLD6)) = (((_VAL_) << 15) | ((REG32(ADR_MB_THRESHOLD6)) & 0xffff7fff))
#define SET_MB_LOW_THOLD_EN(_VAL_) (REG32(ADR_MB_THRESHOLD6)) = (((_VAL_) << 31) | ((REG32(ADR_MB_THRESHOLD6)) & 0x7fffffff))
#define SET_CH0_LOWTHOLD(_VAL_) (REG32(ADR_MB_THRESHOLD7)) = (((_VAL_) << 0) | ((REG32(ADR_MB_THRESHOLD7)) & 0xffffffe0))
#define SET_CH1_LOWTHOLD(_VAL_) (REG32(ADR_MB_THRESHOLD7)) = (((_VAL_) << 8) | ((REG32(ADR_MB_THRESHOLD7)) & 0xffffe0ff))
#define SET_CH2_LOWTHOLD(_VAL_) (REG32(ADR_MB_THRESHOLD7)) = (((_VAL_) << 16) | ((REG32(ADR_MB_THRESHOLD7)) & 0xffe0ffff))
#define SET_CH3_LOWTHOLD(_VAL_) (REG32(ADR_MB_THRESHOLD7)) = (((_VAL_) << 24) | ((REG32(ADR_MB_THRESHOLD7)) & 0xe0ffffff))
#define SET_CH4_LOWTHOLD(_VAL_) (REG32(ADR_MB_THRESHOLD8)) = (((_VAL_) << 0) | ((REG32(ADR_MB_THRESHOLD8)) & 0xffffffe0))
#define SET_CH5_LOWTHOLD(_VAL_) (REG32(ADR_MB_THRESHOLD8)) = (((_VAL_) << 8) | ((REG32(ADR_MB_THRESHOLD8)) & 0xffffe0ff))
#define SET_CH6_LOWTHOLD(_VAL_) (REG32(ADR_MB_THRESHOLD8)) = (((_VAL_) << 16) | ((REG32(ADR_MB_THRESHOLD8)) & 0xffe0ffff))
#define SET_CH7_LOWTHOLD(_VAL_) (REG32(ADR_MB_THRESHOLD8)) = (((_VAL_) << 24) | ((REG32(ADR_MB_THRESHOLD8)) & 0xe0ffffff))
#define SET_CH8_LOWTHOLD(_VAL_) (REG32(ADR_MB_THRESHOLD9)) = (((_VAL_) << 0) | ((REG32(ADR_MB_THRESHOLD9)) & 0xffffffe0))
#define SET_CH9_LOWTHOLD(_VAL_) (REG32(ADR_MB_THRESHOLD9)) = (((_VAL_) << 8) | ((REG32(ADR_MB_THRESHOLD9)) & 0xffffe0ff))
#define SET_CH10_LOWTHOLD(_VAL_) (REG32(ADR_MB_THRESHOLD9)) = (((_VAL_) << 16) | ((REG32(ADR_MB_THRESHOLD9)) & 0xffe0ffff))
#define SET_CH11_LOWTHOLD(_VAL_) (REG32(ADR_MB_THRESHOLD9)) = (((_VAL_) << 24) | ((REG32(ADR_MB_THRESHOLD9)) & 0xe0ffffff))
#define SET_CH12_LOWTHOLD(_VAL_) (REG32(ADR_MB_THRESHOLD10)) = (((_VAL_) << 0) | ((REG32(ADR_MB_THRESHOLD10)) & 0xffffffe0))
#define SET_CH13_LOWTHOLD(_VAL_) (REG32(ADR_MB_THRESHOLD10)) = (((_VAL_) << 8) | ((REG32(ADR_MB_THRESHOLD10)) & 0xffffe0ff))
#define SET_CH14_LOWTHOLD(_VAL_) (REG32(ADR_MB_THRESHOLD10)) = (((_VAL_) << 16) | ((REG32(ADR_MB_THRESHOLD10)) & 0xffe0ffff))
#define SET_CH15_LOWTHOLD(_VAL_) (REG32(ADR_MB_THRESHOLD10)) = (((_VAL_) << 24) | ((REG32(ADR_MB_THRESHOLD10)) & 0xe0ffffff))
#define SET_TRASH_TIMEOUT_EN(_VAL_) (REG32(ADR_MB_TRASH_CFG)) = (((_VAL_) << 0) | ((REG32(ADR_MB_TRASH_CFG)) & 0xfffffffe))
#define SET_TRASH_CAN_INT(_VAL_) (REG32(ADR_MB_TRASH_CFG)) = (((_VAL_) << 1) | ((REG32(ADR_MB_TRASH_CFG)) & 0xfffffffd))
#define SET_TRASH_INT_ID(_VAL_) (REG32(ADR_MB_TRASH_CFG)) = (((_VAL_) << 4) | ((REG32(ADR_MB_TRASH_CFG)) & 0xfffff80f))
#define SET_TRASH_TIMEOUT(_VAL_) (REG32(ADR_MB_TRASH_CFG)) = (((_VAL_) << 16) | ((REG32(ADR_MB_TRASH_CFG)) & 0xfc00ffff))
#define SET_CH0_WRFF_FLUSH(_VAL_) (REG32(ADR_MB_IN_FF_FLUSH)) = (((_VAL_) << 0) | ((REG32(ADR_MB_IN_FF_FLUSH)) & 0xfffffffe))
#define SET_CH1_WRFF_FLUSH(_VAL_) (REG32(ADR_MB_IN_FF_FLUSH)) = (((_VAL_) << 1) | ((REG32(ADR_MB_IN_FF_FLUSH)) & 0xfffffffd))
#define SET_CH2_WRFF_FLUSH(_VAL_) (REG32(ADR_MB_IN_FF_FLUSH)) = (((_VAL_) << 2) | ((REG32(ADR_MB_IN_FF_FLUSH)) & 0xfffffffb))
#define SET_CH3_WRFF_FLUSH(_VAL_) (REG32(ADR_MB_IN_FF_FLUSH)) = (((_VAL_) << 3) | ((REG32(ADR_MB_IN_FF_FLUSH)) & 0xfffffff7))
#define SET_CH4_WRFF_FLUSH(_VAL_) (REG32(ADR_MB_IN_FF_FLUSH)) = (((_VAL_) << 4) | ((REG32(ADR_MB_IN_FF_FLUSH)) & 0xffffffef))
#define SET_CH5_WRFF_FLUSH(_VAL_) (REG32(ADR_MB_IN_FF_FLUSH)) = (((_VAL_) << 5) | ((REG32(ADR_MB_IN_FF_FLUSH)) & 0xffffffdf))
#define SET_CH6_WRFF_FLUSH(_VAL_) (REG32(ADR_MB_IN_FF_FLUSH)) = (((_VAL_) << 6) | ((REG32(ADR_MB_IN_FF_FLUSH)) & 0xffffffbf))
#define SET_CH7_WRFF_FLUSH(_VAL_) (REG32(ADR_MB_IN_FF_FLUSH)) = (((_VAL_) << 7) | ((REG32(ADR_MB_IN_FF_FLUSH)) & 0xffffff7f))
#define SET_CH8_WRFF_FLUSH(_VAL_) (REG32(ADR_MB_IN_FF_FLUSH)) = (((_VAL_) << 8) | ((REG32(ADR_MB_IN_FF_FLUSH)) & 0xfffffeff))
#define SET_CH9_WRFF_FLUSH(_VAL_) (REG32(ADR_MB_IN_FF_FLUSH)) = (((_VAL_) << 9) | ((REG32(ADR_MB_IN_FF_FLUSH)) & 0xfffffdff))
#define SET_CH10_WRFF_FLUSH(_VAL_) (REG32(ADR_MB_IN_FF_FLUSH)) = (((_VAL_) << 10) | ((REG32(ADR_MB_IN_FF_FLUSH)) & 0xfffffbff))
#define SET_CH11_WRFF_FLUSH(_VAL_) (REG32(ADR_MB_IN_FF_FLUSH)) = (((_VAL_) << 11) | ((REG32(ADR_MB_IN_FF_FLUSH)) & 0xfffff7ff))
#define SET_CH12_WRFF_FLUSH(_VAL_) (REG32(ADR_MB_IN_FF_FLUSH)) = (((_VAL_) << 12) | ((REG32(ADR_MB_IN_FF_FLUSH)) & 0xffffefff))
#define SET_CH13_WRFF_FLUSH(_VAL_) (REG32(ADR_MB_IN_FF_FLUSH)) = (((_VAL_) << 13) | ((REG32(ADR_MB_IN_FF_FLUSH)) & 0xffffdfff))
#define SET_CH14_WRFF_FLUSH(_VAL_) (REG32(ADR_MB_IN_FF_FLUSH)) = (((_VAL_) << 14) | ((REG32(ADR_MB_IN_FF_FLUSH)) & 0xffffbfff))
#define SET_CPU_ID_TB2(_VAL_) (REG32(ADR_CPU_ID_TB2)) = (((_VAL_) << 0) | ((REG32(ADR_CPU_ID_TB2)) & 0x00000000))
#define SET_CPU_ID_TB3(_VAL_) (REG32(ADR_CPU_ID_TB3)) = (((_VAL_) << 0) | ((REG32(ADR_CPU_ID_TB3)) & 0x00000000))
#define SET_IQ_LOG_EN(_VAL_) (REG32(ADR_PHY_IQ_LOG_CFG0)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_IQ_LOG_CFG0)) & 0xfffffffe))
#define SET_IQ_LOG_STOP_MODE(_VAL_) (REG32(ADR_PHY_IQ_LOG_CFG1)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_IQ_LOG_CFG1)) & 0xfffffffe))
#define SET_GPIO_STOP_EN(_VAL_) (REG32(ADR_PHY_IQ_LOG_CFG1)) = (((_VAL_) << 4) | ((REG32(ADR_PHY_IQ_LOG_CFG1)) & 0xffffffef))
#define SET_GPIO_STOP_POL(_VAL_) (REG32(ADR_PHY_IQ_LOG_CFG1)) = (((_VAL_) << 5) | ((REG32(ADR_PHY_IQ_LOG_CFG1)) & 0xffffffdf))
#define SET_IQ_LOG_TIMER(_VAL_) (REG32(ADR_PHY_IQ_LOG_CFG1)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_IQ_LOG_CFG1)) & 0x0000ffff))
#define SET_IQ_LOG_LEN(_VAL_) (REG32(ADR_PHY_IQ_LOG_LEN)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_IQ_LOG_LEN)) & 0xffff0000))
#define SET_IQ_LOG_TAIL_ADR(_VAL_) (REG32(ADR_PHY_IQ_LOG_PTR)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_IQ_LOG_PTR)) & 0xffff0000))
#define SET_ALC_LENG(_VAL_) (REG32(ADR_WR_ALC)) = (((_VAL_) << 0) | ((REG32(ADR_WR_ALC)) & 0xfffc0000))
#define SET_CH0_DYN_PRI(_VAL_) (REG32(ADR_WR_ALC)) = (((_VAL_) << 20) | ((REG32(ADR_WR_ALC)) & 0xffcfffff))
#define SET_MCU_PKTID(_VAL_) (REG32(ADR_GETID)) = (((_VAL_) << 0) | ((REG32(ADR_GETID)) & 0x00000000))
#define SET_CH0_STA_PRI(_VAL_) (REG32(ADR_CH_STA_PRI)) = (((_VAL_) << 0) | ((REG32(ADR_CH_STA_PRI)) & 0xfffffffc))
#define SET_CH1_STA_PRI(_VAL_) (REG32(ADR_CH_STA_PRI)) = (((_VAL_) << 4) | ((REG32(ADR_CH_STA_PRI)) & 0xffffffcf))
#define SET_CH2_STA_PRI(_VAL_) (REG32(ADR_CH_STA_PRI)) = (((_VAL_) << 8) | ((REG32(ADR_CH_STA_PRI)) & 0xfffffcff))
#define SET_CH3_STA_PRI(_VAL_) (REG32(ADR_CH_STA_PRI)) = (((_VAL_) << 12) | ((REG32(ADR_CH_STA_PRI)) & 0xffffcfff))
#define SET_ID_TB0(_VAL_) (REG32(ADR_RD_ID0)) = (((_VAL_) << 0) | ((REG32(ADR_RD_ID0)) & 0x00000000))
#define SET_ID_TB1(_VAL_) (REG32(ADR_RD_ID1)) = (((_VAL_) << 0) | ((REG32(ADR_RD_ID1)) & 0x00000000))
#define SET_ID_MNG_HALT(_VAL_) (REG32(ADR_IMD_CFG)) = (((_VAL_) << 4) | ((REG32(ADR_IMD_CFG)) & 0xffffffef))
#define SET_ID_MNG_ERR_HALT_EN(_VAL_) (REG32(ADR_IMD_CFG)) = (((_VAL_) << 5) | ((REG32(ADR_IMD_CFG)) & 0xffffffdf))
#define SET_ID_EXCEPT_FLG_CLR(_VAL_) (REG32(ADR_IMD_CFG)) = (((_VAL_) << 6) | ((REG32(ADR_IMD_CFG)) & 0xffffffbf))
#define SET_ID_EXCEPT_FLG(_VAL_) (REG32(ADR_IMD_CFG)) = (((_VAL_) << 7) | ((REG32(ADR_IMD_CFG)) & 0xffffff7f))
#define SET_ID_FULL(_VAL_) (REG32(ADR_IMD_STA)) = (((_VAL_) << 0) | ((REG32(ADR_IMD_STA)) & 0xfffffffe))
#define SET_ID_MNG_BUSY(_VAL_) (REG32(ADR_IMD_STA)) = (((_VAL_) << 1) | ((REG32(ADR_IMD_STA)) & 0xfffffffd))
#define SET_REQ_LOCK(_VAL_) (REG32(ADR_IMD_STA)) = (((_VAL_) << 2) | ((REG32(ADR_IMD_STA)) & 0xfffffffb))
#define SET_CH0_REQ_LOCK(_VAL_) (REG32(ADR_IMD_STA)) = (((_VAL_) << 4) | ((REG32(ADR_IMD_STA)) & 0xffffffef))
#define SET_CH1_REQ_LOCK(_VAL_) (REG32(ADR_IMD_STA)) = (((_VAL_) << 5) | ((REG32(ADR_IMD_STA)) & 0xffffffdf))
#define SET_CH2_REQ_LOCK(_VAL_) (REG32(ADR_IMD_STA)) = (((_VAL_) << 6) | ((REG32(ADR_IMD_STA)) & 0xffffffbf))
#define SET_CH3_REQ_LOCK(_VAL_) (REG32(ADR_IMD_STA)) = (((_VAL_) << 7) | ((REG32(ADR_IMD_STA)) & 0xffffff7f))
#define SET_REQ_LOCK_INT_EN(_VAL_) (REG32(ADR_IMD_STA)) = (((_VAL_) << 8) | ((REG32(ADR_IMD_STA)) & 0xfffffeff))
#define SET_REQ_LOCK_INT(_VAL_) (REG32(ADR_IMD_STA)) = (((_VAL_) << 9) | ((REG32(ADR_IMD_STA)) & 0xfffffdff))
#define SET_MCU_ALC_READY(_VAL_) (REG32(ADR_ALC_STA)) = (((_VAL_) << 0) | ((REG32(ADR_ALC_STA)) & 0xfffffffe))
#define SET_ALC_FAIL(_VAL_) (REG32(ADR_ALC_STA)) = (((_VAL_) << 1) | ((REG32(ADR_ALC_STA)) & 0xfffffffd))
#define SET_ALC_BUSY(_VAL_) (REG32(ADR_ALC_STA)) = (((_VAL_) << 2) | ((REG32(ADR_ALC_STA)) & 0xfffffffb))
#define SET_CH0_NVLD(_VAL_) (REG32(ADR_ALC_STA)) = (((_VAL_) << 4) | ((REG32(ADR_ALC_STA)) & 0xffffffef))
#define SET_CH1_NVLD(_VAL_) (REG32(ADR_ALC_STA)) = (((_VAL_) << 5) | ((REG32(ADR_ALC_STA)) & 0xffffffdf))
#define SET_CH2_NVLD(_VAL_) (REG32(ADR_ALC_STA)) = (((_VAL_) << 6) | ((REG32(ADR_ALC_STA)) & 0xffffffbf))
#define SET_CH3_NVLD(_VAL_) (REG32(ADR_ALC_STA)) = (((_VAL_) << 7) | ((REG32(ADR_ALC_STA)) & 0xffffff7f))
#define SET_ALC_INT_ID(_VAL_) (REG32(ADR_ALC_STA)) = (((_VAL_) << 8) | ((REG32(ADR_ALC_STA)) & 0xffff80ff))
#define SET_ALC_TIMEOUT(_VAL_) (REG32(ADR_ALC_STA)) = (((_VAL_) << 16) | ((REG32(ADR_ALC_STA)) & 0xfc00ffff))
#define SET_ALC_TIMEOUT_INT_EN(_VAL_) (REG32(ADR_ALC_STA)) = (((_VAL_) << 30) | ((REG32(ADR_ALC_STA)) & 0xbfffffff))
#define SET_ALC_TIMEOUT_INT(_VAL_) (REG32(ADR_ALC_STA)) = (((_VAL_) << 31) | ((REG32(ADR_ALC_STA)) & 0x7fffffff))
#define SET_TX_ID_COUNT(_VAL_) (REG32(ADR_TRX_ID_COUNT)) = (((_VAL_) << 0) | ((REG32(ADR_TRX_ID_COUNT)) & 0xffffff00))
#define SET_RX_ID_COUNT(_VAL_) (REG32(ADR_TRX_ID_COUNT)) = (((_VAL_) << 8) | ((REG32(ADR_TRX_ID_COUNT)) & 0xffff00ff))
#define SET_TX_ID_THOLD(_VAL_) (REG32(ADR_TRX_ID_THRESHOLD)) = (((_VAL_) << 0) | ((REG32(ADR_TRX_ID_THRESHOLD)) & 0xffffff00))
#define SET_RX_ID_THOLD(_VAL_) (REG32(ADR_TRX_ID_THRESHOLD)) = (((_VAL_) << 8) | ((REG32(ADR_TRX_ID_THRESHOLD)) & 0xffff00ff))
#define SET_ID_THOLD_RX_INT(_VAL_) (REG32(ADR_TRX_ID_THRESHOLD)) = (((_VAL_) << 16) | ((REG32(ADR_TRX_ID_THRESHOLD)) & 0xfffeffff))
#define SET_RX_INT_CH(_VAL_) (REG32(ADR_TRX_ID_THRESHOLD)) = (((_VAL_) << 17) | ((REG32(ADR_TRX_ID_THRESHOLD)) & 0xfff1ffff))
#define SET_ID_THOLD_TX_INT(_VAL_) (REG32(ADR_TRX_ID_THRESHOLD)) = (((_VAL_) << 20) | ((REG32(ADR_TRX_ID_THRESHOLD)) & 0xffefffff))
#define SET_TX_INT_CH(_VAL_) (REG32(ADR_TRX_ID_THRESHOLD)) = (((_VAL_) << 21) | ((REG32(ADR_TRX_ID_THRESHOLD)) & 0xff1fffff))
#define SET_ID_THOLD_INT_EN(_VAL_) (REG32(ADR_TRX_ID_THRESHOLD)) = (((_VAL_) << 24) | ((REG32(ADR_TRX_ID_THRESHOLD)) & 0xfeffffff))
#define SET_TX_ID_TB0(_VAL_) (REG32(ADR_TX_ID0)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ID0)) & 0x00000000))
#define SET_TX_ID_TB1(_VAL_) (REG32(ADR_TX_ID1)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ID1)) & 0x00000000))
#define SET_RX_ID_TB0(_VAL_) (REG32(ADR_RX_ID0)) = (((_VAL_) << 0) | ((REG32(ADR_RX_ID0)) & 0x00000000))
#define SET_RX_ID_TB1(_VAL_) (REG32(ADR_RX_ID1)) = (((_VAL_) << 0) | ((REG32(ADR_RX_ID1)) & 0x00000000))
#define SET_DOUBLE_RLS_INT_EN(_VAL_) (REG32(ADR_RTN_STA)) = (((_VAL_) << 0) | ((REG32(ADR_RTN_STA)) & 0xfffffffe))
#define SET_ID_DOUBLE_RLS_INT(_VAL_) (REG32(ADR_RTN_STA)) = (((_VAL_) << 1) | ((REG32(ADR_RTN_STA)) & 0xfffffffd))
#define SET_DOUBLE_RLS_ID(_VAL_) (REG32(ADR_RTN_STA)) = (((_VAL_) << 8) | ((REG32(ADR_RTN_STA)) & 0xffff80ff))
#define SET_ID_LEN_THOLD_INT_EN(_VAL_) (REG32(ADR_ID_LEN_THREADSHOLD1)) = (((_VAL_) << 0) | ((REG32(ADR_ID_LEN_THREADSHOLD1)) & 0xfffffffe))
#define SET_ALL_ID_LEN_THOLD_INT(_VAL_) (REG32(ADR_ID_LEN_THREADSHOLD1)) = (((_VAL_) << 1) | ((REG32(ADR_ID_LEN_THREADSHOLD1)) & 0xfffffffd))
#define SET_TX_ID_LEN_THOLD_INT(_VAL_) (REG32(ADR_ID_LEN_THREADSHOLD1)) = (((_VAL_) << 2) | ((REG32(ADR_ID_LEN_THREADSHOLD1)) & 0xfffffffb))
#define SET_RX_ID_LEN_THOLD_INT(_VAL_) (REG32(ADR_ID_LEN_THREADSHOLD1)) = (((_VAL_) << 3) | ((REG32(ADR_ID_LEN_THREADSHOLD1)) & 0xfffffff7))
#define SET_ID_TX_LEN_THOLD(_VAL_) (REG32(ADR_ID_LEN_THREADSHOLD1)) = (((_VAL_) << 4) | ((REG32(ADR_ID_LEN_THREADSHOLD1)) & 0xffffe00f))
#define SET_ID_RX_LEN_THOLD(_VAL_) (REG32(ADR_ID_LEN_THREADSHOLD1)) = (((_VAL_) << 13) | ((REG32(ADR_ID_LEN_THREADSHOLD1)) & 0xffc01fff))
#define SET_ID_LEN_THOLD(_VAL_) (REG32(ADR_ID_LEN_THREADSHOLD1)) = (((_VAL_) << 22) | ((REG32(ADR_ID_LEN_THREADSHOLD1)) & 0x803fffff))
#define SET_ALL_ID_ALC_LEN(_VAL_) (REG32(ADR_ID_LEN_THREADSHOLD2)) = (((_VAL_) << 0) | ((REG32(ADR_ID_LEN_THREADSHOLD2)) & 0xfffffe00))
#define SET_TX_ID_ALC_LEN(_VAL_) (REG32(ADR_ID_LEN_THREADSHOLD2)) = (((_VAL_) << 9) | ((REG32(ADR_ID_LEN_THREADSHOLD2)) & 0xfffc01ff))
#define SET_RX_ID_ALC_LEN(_VAL_) (REG32(ADR_ID_LEN_THREADSHOLD2)) = (((_VAL_) << 18) | ((REG32(ADR_ID_LEN_THREADSHOLD2)) & 0xf803ffff))
#define SET_CH_ARB_EN(_VAL_) (REG32(ADR_CH_ARB_PRI)) = (((_VAL_) << 0) | ((REG32(ADR_CH_ARB_PRI)) & 0xfffffffe))
#define SET_CH_PRI1(_VAL_) (REG32(ADR_CH_ARB_PRI)) = (((_VAL_) << 4) | ((REG32(ADR_CH_ARB_PRI)) & 0xffffffcf))
#define SET_CH_PRI2(_VAL_) (REG32(ADR_CH_ARB_PRI)) = (((_VAL_) << 8) | ((REG32(ADR_CH_ARB_PRI)) & 0xfffffcff))
#define SET_CH_PRI3(_VAL_) (REG32(ADR_CH_ARB_PRI)) = (((_VAL_) << 12) | ((REG32(ADR_CH_ARB_PRI)) & 0xffffcfff))
#define SET_CH_PRI4(_VAL_) (REG32(ADR_CH_ARB_PRI)) = (((_VAL_) << 16) | ((REG32(ADR_CH_ARB_PRI)) & 0xfffcffff))
#define SET_TX_ID_REMAIN(_VAL_) (REG32(ADR_TX_ID_REMAIN_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ID_REMAIN_STATUS)) & 0xffffff80))
#define SET_TX_PAGE_REMAIN(_VAL_) (REG32(ADR_TX_ID_REMAIN_STATUS)) = (((_VAL_) << 8) | ((REG32(ADR_TX_ID_REMAIN_STATUS)) & 0xfffe00ff))
#define SET_ID_PAGE_MAX_SIZE(_VAL_) (REG32(ADR_ID_INFO_STA)) = (((_VAL_) << 0) | ((REG32(ADR_ID_INFO_STA)) & 0xfffffe00))
#define SET_TX_PAGE_LIMIT(_VAL_) (REG32(ADR_TX_LIMIT_INTR)) = (((_VAL_) << 0) | ((REG32(ADR_TX_LIMIT_INTR)) & 0xfffffe00))
#define SET_TX_COUNT_LIMIT(_VAL_) (REG32(ADR_TX_LIMIT_INTR)) = (((_VAL_) << 16) | ((REG32(ADR_TX_LIMIT_INTR)) & 0xff00ffff))
#define SET_TX_LIMIT_INT(_VAL_) (REG32(ADR_TX_LIMIT_INTR)) = (((_VAL_) << 30) | ((REG32(ADR_TX_LIMIT_INTR)) & 0xbfffffff))
#define SET_TX_LIMIT_INT_EN(_VAL_) (REG32(ADR_TX_LIMIT_INTR)) = (((_VAL_) << 31) | ((REG32(ADR_TX_LIMIT_INTR)) & 0x7fffffff))
#define SET_TX_PAGE_USE_7_0(_VAL_) (REG32(ADR_TX_ID_ALL_INFO)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ID_ALL_INFO)) & 0xffffff00))
#define SET_TX_ID_USE_5_0(_VAL_) (REG32(ADR_TX_ID_ALL_INFO)) = (((_VAL_) << 8) | ((REG32(ADR_TX_ID_ALL_INFO)) & 0xffffc0ff))
#define SET_EDCA0_FFO_CNT(_VAL_) (REG32(ADR_TX_ID_ALL_INFO)) = (((_VAL_) << 14) | ((REG32(ADR_TX_ID_ALL_INFO)) & 0xfffc3fff))
#define SET_EDCA1_FFO_CNT_3_0(_VAL_) (REG32(ADR_TX_ID_ALL_INFO)) = (((_VAL_) << 18) | ((REG32(ADR_TX_ID_ALL_INFO)) & 0xffc3ffff))
#define SET_EDCA2_FFO_CNT(_VAL_) (REG32(ADR_TX_ID_ALL_INFO)) = (((_VAL_) << 22) | ((REG32(ADR_TX_ID_ALL_INFO)) & 0xf83fffff))
#define SET_EDCA3_FFO_CNT(_VAL_) (REG32(ADR_TX_ID_ALL_INFO)) = (((_VAL_) << 27) | ((REG32(ADR_TX_ID_ALL_INFO)) & 0x07ffffff))
#define SET_ID_TB2(_VAL_) (REG32(ADR_RD_ID2)) = (((_VAL_) << 0) | ((REG32(ADR_RD_ID2)) & 0x00000000))
#define SET_ID_TB3(_VAL_) (REG32(ADR_RD_ID3)) = (((_VAL_) << 0) | ((REG32(ADR_RD_ID3)) & 0x00000000))
#define SET_TX_ID_TB2(_VAL_) (REG32(ADR_TX_ID2)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ID2)) & 0x00000000))
#define SET_TX_ID_TB3(_VAL_) (REG32(ADR_TX_ID3)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ID3)) & 0x00000000))
#define SET_RX_ID_TB2(_VAL_) (REG32(ADR_RX_ID2)) = (((_VAL_) << 0) | ((REG32(ADR_RX_ID2)) & 0x00000000))
#define SET_RX_ID_TB3(_VAL_) (REG32(ADR_RX_ID3)) = (((_VAL_) << 0) | ((REG32(ADR_RX_ID3)) & 0x00000000))
#define SET_TX_PAGE_USE2(_VAL_) (REG32(ADR_TX_ID_ALL_INFO2)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ID_ALL_INFO2)) & 0xfffffe00))
#define SET_TX_ID_USE2(_VAL_) (REG32(ADR_TX_ID_ALL_INFO2)) = (((_VAL_) << 9) | ((REG32(ADR_TX_ID_ALL_INFO2)) & 0xfffe01ff))
#define SET_EDCA4_FFO_CNT(_VAL_) (REG32(ADR_TX_ID_ALL_INFO2)) = (((_VAL_) << 17) | ((REG32(ADR_TX_ID_ALL_INFO2)) & 0xffe1ffff))
#define SET_TX_PAGE_USE3(_VAL_) (REG32(ADR_TX_ID_ALL_INFO_A)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ID_ALL_INFO_A)) & 0xfffffe00))
#define SET_TX_ID_USE3(_VAL_) (REG32(ADR_TX_ID_ALL_INFO_A)) = (((_VAL_) << 9) | ((REG32(ADR_TX_ID_ALL_INFO_A)) & 0xfffe01ff))
#define SET_EDCA1_FFO_CNT2(_VAL_) (REG32(ADR_TX_ID_ALL_INFO_A)) = (((_VAL_) << 21) | ((REG32(ADR_TX_ID_ALL_INFO_A)) & 0xfc1fffff))
#define SET_EDCA4_FFO_CNT2(_VAL_) (REG32(ADR_TX_ID_ALL_INFO_A)) = (((_VAL_) << 26) | ((REG32(ADR_TX_ID_ALL_INFO_A)) & 0xc3ffffff))
#define SET_TX_PAGE_USE4(_VAL_) (REG32(ADR_TX_ID_ALL_INFO_B)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ID_ALL_INFO_B)) & 0xfffffe00))
#define SET_TX_ID_USE4(_VAL_) (REG32(ADR_TX_ID_ALL_INFO_B)) = (((_VAL_) << 9) | ((REG32(ADR_TX_ID_ALL_INFO_B)) & 0xfffe01ff))
#define SET_EDCA2_FFO_CNT2(_VAL_) (REG32(ADR_TX_ID_ALL_INFO_B)) = (((_VAL_) << 17) | ((REG32(ADR_TX_ID_ALL_INFO_B)) & 0xffc1ffff))
#define SET_EDCA3_FFO_CNT2(_VAL_) (REG32(ADR_TX_ID_ALL_INFO_B)) = (((_VAL_) << 22) | ((REG32(ADR_TX_ID_ALL_INFO_B)) & 0xf83fffff))
#define SET_TX_ID_IFO_LEN(_VAL_) (REG32(ADR_TX_ID_REMAIN_STATUS2)) = (((_VAL_) << 0) | ((REG32(ADR_TX_ID_REMAIN_STATUS2)) & 0xfffffe00))
#define SET_RX_ID_IFO_LEN(_VAL_) (REG32(ADR_TX_ID_REMAIN_STATUS2)) = (((_VAL_) << 16) | ((REG32(ADR_TX_ID_REMAIN_STATUS2)) & 0xfe00ffff))
#define SET_MAX_ALL_ALC_ID_CNT(_VAL_) (REG32(ADR_ALC_ID_INFO)) = (((_VAL_) << 0) | ((REG32(ADR_ALC_ID_INFO)) & 0xffffff00))
#define SET_MAX_TX_ALC_ID_CNT(_VAL_) (REG32(ADR_ALC_ID_INFO)) = (((_VAL_) << 8) | ((REG32(ADR_ALC_ID_INFO)) & 0xffff00ff))
#define SET_MAX_RX_ALC_ID_CNT(_VAL_) (REG32(ADR_ALC_ID_INFO)) = (((_VAL_) << 16) | ((REG32(ADR_ALC_ID_INFO)) & 0xff00ffff))
#define SET_MAX_ALL_ID_ALC_LEN(_VAL_) (REG32(ADR_ALC_ID_INF1)) = (((_VAL_) << 0) | ((REG32(ADR_ALC_ID_INF1)) & 0xfffffe00))
#define SET_MAX_TX_ID_ALC_LEN(_VAL_) (REG32(ADR_ALC_ID_INF1)) = (((_VAL_) << 9) | ((REG32(ADR_ALC_ID_INF1)) & 0xfffc01ff))
#define SET_MAX_RX_ID_ALC_LEN(_VAL_) (REG32(ADR_ALC_ID_INF1)) = (((_VAL_) << 18) | ((REG32(ADR_ALC_ID_INF1)) & 0xf803ffff))
#define SET_RG_PMDLBK(_VAL_) (REG32(ADR_PHY_EN_0)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_EN_0)) & 0xfffffffe))
#define SET_RG_RDYACK_SEL(_VAL_) (REG32(ADR_PHY_EN_0)) = (((_VAL_) << 1) | ((REG32(ADR_PHY_EN_0)) & 0xfffffff9))
#define SET_RG_ADEDGE_SEL(_VAL_) (REG32(ADR_PHY_EN_0)) = (((_VAL_) << 3) | ((REG32(ADR_PHY_EN_0)) & 0xfffffff7))
#define SET_RG_SIGN_SWAP(_VAL_) (REG32(ADR_PHY_EN_0)) = (((_VAL_) << 4) | ((REG32(ADR_PHY_EN_0)) & 0xffffffef))
#define SET_RG_IQ_SWAP(_VAL_) (REG32(ADR_PHY_EN_0)) = (((_VAL_) << 5) | ((REG32(ADR_PHY_EN_0)) & 0xffffffdf))
#define SET_RG_Q_INV(_VAL_) (REG32(ADR_PHY_EN_0)) = (((_VAL_) << 6) | ((REG32(ADR_PHY_EN_0)) & 0xffffffbf))
#define SET_RG_I_INV(_VAL_) (REG32(ADR_PHY_EN_0)) = (((_VAL_) << 7) | ((REG32(ADR_PHY_EN_0)) & 0xffffff7f))
#define SET_RG_BYPASS_ACI(_VAL_) (REG32(ADR_PHY_EN_0)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_EN_0)) & 0xfffffeff))
#define SET_RG_LBK_ANA_PATH(_VAL_) (REG32(ADR_PHY_EN_0)) = (((_VAL_) << 9) | ((REG32(ADR_PHY_EN_0)) & 0xfffffdff))
#define SET_RG_SPECTRUM_LEAKY_FACTOR(_VAL_) (REG32(ADR_PHY_EN_0)) = (((_VAL_) << 10) | ((REG32(ADR_PHY_EN_0)) & 0xfffff3ff))
#define SET_RG_SPECTRUM_BW(_VAL_) (REG32(ADR_PHY_EN_0)) = (((_VAL_) << 12) | ((REG32(ADR_PHY_EN_0)) & 0xffffcfff))
#define SET_RG_SPECTRUM_FREQ_MANUAL(_VAL_) (REG32(ADR_PHY_EN_0)) = (((_VAL_) << 14) | ((REG32(ADR_PHY_EN_0)) & 0xffffbfff))
#define SET_RG_SPECTRUM_EN(_VAL_) (REG32(ADR_PHY_EN_0)) = (((_VAL_) << 15) | ((REG32(ADR_PHY_EN_0)) & 0xffff7fff))
#define SET_RG_TXPWRLVL_SET(_VAL_) (REG32(ADR_PHY_EN_0)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_EN_0)) & 0xff00ffff))
#define SET_RG_TXPWRLVL_SEL(_VAL_) (REG32(ADR_PHY_EN_0)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_EN_0)) & 0xfeffffff))
#define SET_RG_RF_BB_CLK_SEL(_VAL_) (REG32(ADR_PHY_EN_0)) = (((_VAL_) << 31) | ((REG32(ADR_PHY_EN_0)) & 0x7fffffff))
#define SET_RG_PHY_MD_EN(_VAL_) (REG32(ADR_PHY_EN_1)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_EN_1)) & 0xfffffffe))
#define SET_RG_PHYRX_MD_EN(_VAL_) (REG32(ADR_PHY_EN_1)) = (((_VAL_) << 1) | ((REG32(ADR_PHY_EN_1)) & 0xfffffffd))
#define SET_RG_PHYTX_MD_EN(_VAL_) (REG32(ADR_PHY_EN_1)) = (((_VAL_) << 2) | ((REG32(ADR_PHY_EN_1)) & 0xfffffffb))
#define SET_RG_PHY11GN_MD_EN(_VAL_) (REG32(ADR_PHY_EN_1)) = (((_VAL_) << 3) | ((REG32(ADR_PHY_EN_1)) & 0xfffffff7))
#define SET_RG_PHY11B_MD_EN(_VAL_) (REG32(ADR_PHY_EN_1)) = (((_VAL_) << 4) | ((REG32(ADR_PHY_EN_1)) & 0xffffffef))
#define SET_RG_PHYRXFIFO_MD_EN(_VAL_) (REG32(ADR_PHY_EN_1)) = (((_VAL_) << 5) | ((REG32(ADR_PHY_EN_1)) & 0xffffffdf))
#define SET_RG_PHYTXFIFO_MD_EN(_VAL_) (REG32(ADR_PHY_EN_1)) = (((_VAL_) << 6) | ((REG32(ADR_PHY_EN_1)) & 0xffffffbf))
#define SET_RG_PHY11BGN_MD_EN(_VAL_) (REG32(ADR_PHY_EN_1)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_EN_1)) & 0xfffffeff))
#define SET_RG_FORCE_11GN_EN(_VAL_) (REG32(ADR_PHY_EN_1)) = (((_VAL_) << 12) | ((REG32(ADR_PHY_EN_1)) & 0xffffefff))
#define SET_RG_FORCE_11B_EN(_VAL_) (REG32(ADR_PHY_EN_1)) = (((_VAL_) << 13) | ((REG32(ADR_PHY_EN_1)) & 0xffffdfff))
#define SET_RG_FFT_MEM_CLK_EN_RX(_VAL_) (REG32(ADR_PHY_EN_1)) = (((_VAL_) << 14) | ((REG32(ADR_PHY_EN_1)) & 0xffffbfff))
#define SET_RG_FFT_MEM_CLK_EN_TX(_VAL_) (REG32(ADR_PHY_EN_1)) = (((_VAL_) << 15) | ((REG32(ADR_PHY_EN_1)) & 0xffff7fff))
#define SET_RG_PHY_IQ_TRIG_SEL(_VAL_) (REG32(ADR_PHY_EN_1)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_EN_1)) & 0xfff0ffff))
#define SET_RG_SPECTRUM_FREQ(_VAL_) (REG32(ADR_PHY_EN_1)) = (((_VAL_) << 20) | ((REG32(ADR_PHY_EN_1)) & 0xc00fffff))
#define SET_SVN_VERSION(_VAL_) (REG32(ADR_SVN_VERSION_REG)) = (((_VAL_) << 0) | ((REG32(ADR_SVN_VERSION_REG)) & 0x00000000))
#define SET_RG_LENGTH(_VAL_) (REG32(ADR_PHY_PKT_GEN_0)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_PKT_GEN_0)) & 0xffff0000))
#define SET_RG_PKT_MODE(_VAL_) (REG32(ADR_PHY_PKT_GEN_0)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_PKT_GEN_0)) & 0xfff8ffff))
#define SET_RG_CH_BW(_VAL_) (REG32(ADR_PHY_PKT_GEN_0)) = (((_VAL_) << 19) | ((REG32(ADR_PHY_PKT_GEN_0)) & 0xffc7ffff))
#define SET_RG_PRM(_VAL_) (REG32(ADR_PHY_PKT_GEN_0)) = (((_VAL_) << 22) | ((REG32(ADR_PHY_PKT_GEN_0)) & 0xffbfffff))
#define SET_RG_SHORTGI(_VAL_) (REG32(ADR_PHY_PKT_GEN_0)) = (((_VAL_) << 23) | ((REG32(ADR_PHY_PKT_GEN_0)) & 0xff7fffff))
#define SET_RG_RATE(_VAL_) (REG32(ADR_PHY_PKT_GEN_0)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_PKT_GEN_0)) & 0x80ffffff))
#define SET_RG_L_LENGTH(_VAL_) (REG32(ADR_PHY_PKT_GEN_1)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_PKT_GEN_1)) & 0xfffff000))
#define SET_RG_L_RATE(_VAL_) (REG32(ADR_PHY_PKT_GEN_1)) = (((_VAL_) << 12) | ((REG32(ADR_PHY_PKT_GEN_1)) & 0xffff8fff))
#define SET_RG_SERVICE(_VAL_) (REG32(ADR_PHY_PKT_GEN_1)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_PKT_GEN_1)) & 0x0000ffff))
#define SET_RG_SMOOTHING(_VAL_) (REG32(ADR_PHY_PKT_GEN_2)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_PKT_GEN_2)) & 0xfffffffe))
#define SET_RG_NO_SOUND(_VAL_) (REG32(ADR_PHY_PKT_GEN_2)) = (((_VAL_) << 1) | ((REG32(ADR_PHY_PKT_GEN_2)) & 0xfffffffd))
#define SET_RG_AGGREGATE(_VAL_) (REG32(ADR_PHY_PKT_GEN_2)) = (((_VAL_) << 2) | ((REG32(ADR_PHY_PKT_GEN_2)) & 0xfffffffb))
#define SET_RG_STBC(_VAL_) (REG32(ADR_PHY_PKT_GEN_2)) = (((_VAL_) << 3) | ((REG32(ADR_PHY_PKT_GEN_2)) & 0xffffffe7))
#define SET_RG_FEC(_VAL_) (REG32(ADR_PHY_PKT_GEN_2)) = (((_VAL_) << 5) | ((REG32(ADR_PHY_PKT_GEN_2)) & 0xffffffdf))
#define SET_RG_N_ESS(_VAL_) (REG32(ADR_PHY_PKT_GEN_2)) = (((_VAL_) << 6) | ((REG32(ADR_PHY_PKT_GEN_2)) & 0xffffff3f))
#define SET_RG_TXPWRLVL(_VAL_) (REG32(ADR_PHY_PKT_GEN_2)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_PKT_GEN_2)) & 0xffff00ff))
#define SET_RG_TX_START(_VAL_) (REG32(ADR_PHY_PKT_GEN_3)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_PKT_GEN_3)) & 0xfffffffe))
#define SET_RG_IFS_TIME(_VAL_) (REG32(ADR_PHY_PKT_GEN_3)) = (((_VAL_) << 2) | ((REG32(ADR_PHY_PKT_GEN_3)) & 0xffffff03))
#define SET_RG_CONTINUOUS_DATA(_VAL_) (REG32(ADR_PHY_PKT_GEN_3)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_PKT_GEN_3)) & 0xfffffeff))
#define SET_RG_DATA_SEL(_VAL_) (REG32(ADR_PHY_PKT_GEN_3)) = (((_VAL_) << 9) | ((REG32(ADR_PHY_PKT_GEN_3)) & 0xfffff9ff))
#define SET_RG_TX_D(_VAL_) (REG32(ADR_PHY_PKT_GEN_3)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_PKT_GEN_3)) & 0xff00ffff))
#define SET_RG_TX_CNT_TARGET(_VAL_) (REG32(ADR_PHY_PKT_GEN_4)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_PKT_GEN_4)) & 0x00000000))
#define SET_RG_FFT_IFFT_MODE(_VAL_) (REG32(ADR_PHY_REG_00)) = (((_VAL_) << 6) | ((REG32(ADR_PHY_REG_00)) & 0xffffff3f))
#define SET_RG_DAC_DBG_MODE(_VAL_) (REG32(ADR_PHY_REG_00)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_REG_00)) & 0xfffffeff))
#define SET_RG_DAC_SGN_SWAP(_VAL_) (REG32(ADR_PHY_REG_00)) = (((_VAL_) << 9) | ((REG32(ADR_PHY_REG_00)) & 0xfffffdff))
#define SET_RG_TXD_SEL(_VAL_) (REG32(ADR_PHY_REG_00)) = (((_VAL_) << 10) | ((REG32(ADR_PHY_REG_00)) & 0xfffff3ff))
#define SET_RG_UP8X(_VAL_) (REG32(ADR_PHY_REG_00)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_00)) & 0xff00ffff))
#define SET_RG_IQ_DC_BYP(_VAL_) (REG32(ADR_PHY_REG_00)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_00)) & 0xfeffffff))
#define SET_RG_IQ_DC_LEAKY_FACTOR(_VAL_) (REG32(ADR_PHY_REG_00)) = (((_VAL_) << 28) | ((REG32(ADR_PHY_REG_00)) & 0xcfffffff))
#define SET_RG_DAC_DCEN(_VAL_) (REG32(ADR_PHY_REG_01)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_01)) & 0xfffffffe))
#define SET_RG_DAC_DCQ(_VAL_) (REG32(ADR_PHY_REG_01)) = (((_VAL_) << 4) | ((REG32(ADR_PHY_REG_01)) & 0xffffc00f))
#define SET_RG_DAC_DCI(_VAL_) (REG32(ADR_PHY_REG_01)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_01)) & 0xfc00ffff))
#define SET_RG_PGA_REFDB_SAT(_VAL_) (REG32(ADR_PHY_REG_02_AGC)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_02_AGC)) & 0xffffff80))
#define SET_RG_PGA_REFDB_TOP(_VAL_) (REG32(ADR_PHY_REG_02_AGC)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_REG_02_AGC)) & 0xffff80ff))
#define SET_RG_PGA_REF_UND(_VAL_) (REG32(ADR_PHY_REG_02_AGC)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_02_AGC)) & 0xfc00ffff))
#define SET_RG_RF_REF_SAT(_VAL_) (REG32(ADR_PHY_REG_02_AGC)) = (((_VAL_) << 28) | ((REG32(ADR_PHY_REG_02_AGC)) & 0x0fffffff))
#define SET_RG_PGAGC_SET(_VAL_) (REG32(ADR_PHY_REG_03_AGC)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_03_AGC)) & 0xfffffff0))
#define SET_RG_PGAGC_OW(_VAL_) (REG32(ADR_PHY_REG_03_AGC)) = (((_VAL_) << 4) | ((REG32(ADR_PHY_REG_03_AGC)) & 0xffffffef))
#define SET_RG_RFGC_SET(_VAL_) (REG32(ADR_PHY_REG_03_AGC)) = (((_VAL_) << 5) | ((REG32(ADR_PHY_REG_03_AGC)) & 0xffffff9f))
#define SET_RG_RFGC_OW(_VAL_) (REG32(ADR_PHY_REG_03_AGC)) = (((_VAL_) << 7) | ((REG32(ADR_PHY_REG_03_AGC)) & 0xffffff7f))
#define SET_RG_WAIT_T_RXAGC(_VAL_) (REG32(ADR_PHY_REG_03_AGC)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_REG_03_AGC)) & 0xffffc0ff))
#define SET_RG_RXAGC_SET(_VAL_) (REG32(ADR_PHY_REG_03_AGC)) = (((_VAL_) << 14) | ((REG32(ADR_PHY_REG_03_AGC)) & 0xffffbfff))
#define SET_RG_RXAGC_OW(_VAL_) (REG32(ADR_PHY_REG_03_AGC)) = (((_VAL_) << 15) | ((REG32(ADR_PHY_REG_03_AGC)) & 0xffff7fff))
#define SET_RG_WAIT_T_FINAL(_VAL_) (REG32(ADR_PHY_REG_03_AGC)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_03_AGC)) & 0xffc0ffff))
#define SET_RG_WAIT_T(_VAL_) (REG32(ADR_PHY_REG_03_AGC)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_03_AGC)) & 0xc0ffffff))
#define SET_RG_ULG_PGA_SAT_PGA_GAIN(_VAL_) (REG32(ADR_PHY_REG_04_AGC)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_04_AGC)) & 0xfffffff0))
#define SET_RG_LG_PGA_UND_PGA_GAIN(_VAL_) (REG32(ADR_PHY_REG_04_AGC)) = (((_VAL_) << 4) | ((REG32(ADR_PHY_REG_04_AGC)) & 0xffffff0f))
#define SET_RG_LG_PGA_SAT_PGA_GAIN(_VAL_) (REG32(ADR_PHY_REG_04_AGC)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_REG_04_AGC)) & 0xfffff0ff))
#define SET_RG_LG_RF_SAT_PGA_GAIN(_VAL_) (REG32(ADR_PHY_REG_04_AGC)) = (((_VAL_) << 12) | ((REG32(ADR_PHY_REG_04_AGC)) & 0xffff0fff))
#define SET_RG_MG_RF_SAT_PGANOREF_PGA_GAIN(_VAL_) (REG32(ADR_PHY_REG_04_AGC)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_04_AGC)) & 0xfff0ffff))
#define SET_RG_HG_PGA_SAT2_PGA_GAIN(_VAL_) (REG32(ADR_PHY_REG_04_AGC)) = (((_VAL_) << 20) | ((REG32(ADR_PHY_REG_04_AGC)) & 0xff0fffff))
#define SET_RG_HG_PGA_SAT1_PGA_GAIN(_VAL_) (REG32(ADR_PHY_REG_04_AGC)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_04_AGC)) & 0xf0ffffff))
#define SET_RG_HG_RF_SAT_PGA_GAIN(_VAL_) (REG32(ADR_PHY_REG_04_AGC)) = (((_VAL_) << 28) | ((REG32(ADR_PHY_REG_04_AGC)) & 0x0fffffff))
#define SET_RG_MG_PGA_JB_TH(_VAL_) (REG32(ADR_PHY_REG_05_AGC)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_05_AGC)) & 0xfffffff0))
#define SET_RG_MA_PGA_LOW_TH_CNT_LMT(_VAL_) (REG32(ADR_PHY_REG_05_AGC)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_05_AGC)) & 0xffe0ffff))
#define SET_RG_WR_RFGC_INIT_SET(_VAL_) (REG32(ADR_PHY_REG_05_AGC)) = (((_VAL_) << 21) | ((REG32(ADR_PHY_REG_05_AGC)) & 0xff9fffff))
#define SET_RG_WR_RFGC_INIT_EN(_VAL_) (REG32(ADR_PHY_REG_05_AGC)) = (((_VAL_) << 23) | ((REG32(ADR_PHY_REG_05_AGC)) & 0xff7fffff))
#define SET_RG_MA_PGA_HIGH_TH_CNT_LMT(_VAL_) (REG32(ADR_PHY_REG_05_AGC)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_05_AGC)) & 0xe0ffffff))
#define SET_RG_AGC_THRESHOLD(_VAL_) (REG32(ADR_PHY_REG_06_11B_DAGC)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_06_11B_DAGC)) & 0xffffc000))
#define SET_RG_ACI_POINT_CNT_LMT_11B(_VAL_) (REG32(ADR_PHY_REG_06_11B_DAGC)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_06_11B_DAGC)) & 0xff80ffff))
#define SET_RG_ACI_DAGC_LEAKY_FACTOR_11B(_VAL_) (REG32(ADR_PHY_REG_06_11B_DAGC)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_06_11B_DAGC)) & 0xfcffffff))
#define SET_RG_WR_ACI_GAIN_INI_SEL_11B(_VAL_) (REG32(ADR_PHY_REG_07_11B_DAGC)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_07_11B_DAGC)) & 0xffffff00))
#define SET_RG_WR_ACI_GAIN_SEL_11B(_VAL_) (REG32(ADR_PHY_REG_07_11B_DAGC)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_REG_07_11B_DAGC)) & 0xffff00ff))
#define SET_RG_ACI_DAGC_SET_VALUE_11B(_VAL_) (REG32(ADR_PHY_REG_07_11B_DAGC)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_07_11B_DAGC)) & 0xff80ffff))
#define SET_RG_WR_ACI_GAIN_OW_11B(_VAL_) (REG32(ADR_PHY_REG_07_11B_DAGC)) = (((_VAL_) << 31) | ((REG32(ADR_PHY_REG_07_11B_DAGC)) & 0x7fffffff))
#define SET_RG_ACI_POINT_CNT_LMT_11GN(_VAL_) (REG32(ADR_PHY_REG_08_11GN_DAGC)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_08_11GN_DAGC)) & 0xffffff00))
#define SET_RG_ACI_DAGC_LEAKY_FACTOR_11GN(_VAL_) (REG32(ADR_PHY_REG_08_11GN_DAGC)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_REG_08_11GN_DAGC)) & 0xfffffcff))
#define SET_RG_ACI_DAGC_DONE_CNT_LMT_11GN(_VAL_) (REG32(ADR_PHY_REG_08_11GN_DAGC)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_08_11GN_DAGC)) & 0x00ffffff))
#define SET_RG_ACI_DAGC_SET_VALUE_11GN(_VAL_) (REG32(ADR_PHY_REG_09_11GN_DAGC)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_09_11GN_DAGC)) & 0xffffff80))
#define SET_RG_ACI_GAIN_INI_VAL_11GN(_VAL_) (REG32(ADR_PHY_REG_09_11GN_DAGC)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_REG_09_11GN_DAGC)) & 0xffff00ff))
#define SET_RG_ACI_GAIN_OW_VAL_11GN(_VAL_) (REG32(ADR_PHY_REG_09_11GN_DAGC)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_09_11GN_DAGC)) & 0xff00ffff))
#define SET_RG_ACI_GAIN_OW_11GN(_VAL_) (REG32(ADR_PHY_REG_09_11GN_DAGC)) = (((_VAL_) << 31) | ((REG32(ADR_PHY_REG_09_11GN_DAGC)) & 0x7fffffff))
#define SET_RO_CCA_PWR_MA_11GN(_VAL_) (REG32(ADR_PHY_READ_REG_00_DIG_PWR)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_READ_REG_00_DIG_PWR)) & 0xffffff80))
#define SET_RO_ED_STATE(_VAL_) (REG32(ADR_PHY_READ_REG_00_DIG_PWR)) = (((_VAL_) << 15) | ((REG32(ADR_PHY_READ_REG_00_DIG_PWR)) & 0xffff7fff))
#define SET_RO_CCA_PWR_MA_11B(_VAL_) (REG32(ADR_PHY_READ_REG_00_DIG_PWR)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_READ_REG_00_DIG_PWR)) & 0xff80ffff))
#define SET_RO_PGA_PWR_FF1(_VAL_) (REG32(ADR_PHY_READ_REG_01_RF_GAIN_PWR)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_READ_REG_01_RF_GAIN_PWR)) & 0xffffc000))
#define SET_RO_RF_PWR_FF1(_VAL_) (REG32(ADR_PHY_READ_REG_01_RF_GAIN_PWR)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_READ_REG_01_RF_GAIN_PWR)) & 0xfff0ffff))
#define SET_RO_PGAGC_FF1(_VAL_) (REG32(ADR_PHY_READ_REG_01_RF_GAIN_PWR)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_READ_REG_01_RF_GAIN_PWR)) & 0xf0ffffff))
#define SET_RO_RFGC_FF1(_VAL_) (REG32(ADR_PHY_READ_REG_01_RF_GAIN_PWR)) = (((_VAL_) << 28) | ((REG32(ADR_PHY_READ_REG_01_RF_GAIN_PWR)) & 0xcfffffff))
#define SET_RO_PGA_PWR_FF2(_VAL_) (REG32(ADR_PHY_READ_REG_02_RF_GAIN_PWR)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_READ_REG_02_RF_GAIN_PWR)) & 0xffffc000))
#define SET_RO_RF_PWR_FF2(_VAL_) (REG32(ADR_PHY_READ_REG_02_RF_GAIN_PWR)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_READ_REG_02_RF_GAIN_PWR)) & 0xfff0ffff))
#define SET_RO_PGAGC_FF2(_VAL_) (REG32(ADR_PHY_READ_REG_02_RF_GAIN_PWR)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_READ_REG_02_RF_GAIN_PWR)) & 0xf0ffffff))
#define SET_RO_RFGC_FF2(_VAL_) (REG32(ADR_PHY_READ_REG_02_RF_GAIN_PWR)) = (((_VAL_) << 28) | ((REG32(ADR_PHY_READ_REG_02_RF_GAIN_PWR)) & 0xcfffffff))
#define SET_RO_PGA_PWR_FF3(_VAL_) (REG32(ADR_PHY_READ_REG_03_RF_GAIN_PWR)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_READ_REG_03_RF_GAIN_PWR)) & 0xffffc000))
#define SET_RO_RF_PWR_FF3(_VAL_) (REG32(ADR_PHY_READ_REG_03_RF_GAIN_PWR)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_READ_REG_03_RF_GAIN_PWR)) & 0xfff0ffff))
#define SET_RO_PGAGC_FF3(_VAL_) (REG32(ADR_PHY_READ_REG_03_RF_GAIN_PWR)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_READ_REG_03_RF_GAIN_PWR)) & 0xf0ffffff))
#define SET_RO_RFGC_FF3(_VAL_) (REG32(ADR_PHY_READ_REG_03_RF_GAIN_PWR)) = (((_VAL_) << 28) | ((REG32(ADR_PHY_READ_REG_03_RF_GAIN_PWR)) & 0xcfffffff))
#define SET_RG_TX_DES_RATE(_VAL_) (REG32(ADR_PHY_REG_10_TX_DES)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_10_TX_DES)) & 0xffffffe0))
#define SET_RG_TX_DES_MODE(_VAL_) (REG32(ADR_PHY_REG_10_TX_DES)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_REG_10_TX_DES)) & 0xffffe0ff))
#define SET_RG_TX_DES_LEN_LO(_VAL_) (REG32(ADR_PHY_REG_10_TX_DES)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_10_TX_DES)) & 0xffe0ffff))
#define SET_RG_TX_DES_LEN_UP(_VAL_) (REG32(ADR_PHY_REG_10_TX_DES)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_10_TX_DES)) & 0xe0ffffff))
#define SET_RG_TX_DES_SRVC_UP(_VAL_) (REG32(ADR_PHY_REG_11_TX_DES)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_11_TX_DES)) & 0xffffffe0))
#define SET_RG_TX_DES_L_LEN_LO(_VAL_) (REG32(ADR_PHY_REG_11_TX_DES)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_REG_11_TX_DES)) & 0xffffe0ff))
#define SET_RG_TX_DES_L_LEN_UP(_VAL_) (REG32(ADR_PHY_REG_11_TX_DES)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_11_TX_DES)) & 0xffe0ffff))
#define SET_RG_TX_DES_TYPE(_VAL_) (REG32(ADR_PHY_REG_11_TX_DES)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_11_TX_DES)) & 0xe0ffffff))
#define SET_RG_TX_DES_L_LEN_UP_COMB(_VAL_) (REG32(ADR_PHY_REG_12_TX_DES)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_12_TX_DES)) & 0xfffffffe))
#define SET_RG_TX_DES_TYPE_COMB(_VAL_) (REG32(ADR_PHY_REG_12_TX_DES)) = (((_VAL_) << 4) | ((REG32(ADR_PHY_REG_12_TX_DES)) & 0xffffffef))
#define SET_RG_TX_DES_RATE_COMB(_VAL_) (REG32(ADR_PHY_REG_12_TX_DES)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_REG_12_TX_DES)) & 0xfffffeff))
#define SET_RG_TX_DES_MODE_COMB(_VAL_) (REG32(ADR_PHY_REG_12_TX_DES)) = (((_VAL_) << 12) | ((REG32(ADR_PHY_REG_12_TX_DES)) & 0xffffefff))
#define SET_RG_TX_DES_PWRLVL(_VAL_) (REG32(ADR_PHY_REG_12_TX_DES)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_12_TX_DES)) & 0xffe0ffff))
#define SET_RG_TX_DES_SRVC_LO(_VAL_) (REG32(ADR_PHY_REG_12_TX_DES)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_12_TX_DES)) & 0xe0ffffff))
#define SET_RG_RX_DES_RATE(_VAL_) (REG32(ADR_PHY_REG_13_RX_DES)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_13_RX_DES)) & 0xffffffc0))
#define SET_RG_RX_DES_MODE(_VAL_) (REG32(ADR_PHY_REG_13_RX_DES)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_REG_13_RX_DES)) & 0xffffc0ff))
#define SET_RG_RX_DES_LEN_LO(_VAL_) (REG32(ADR_PHY_REG_13_RX_DES)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_13_RX_DES)) & 0xffc0ffff))
#define SET_RG_RX_DES_LEN_UP(_VAL_) (REG32(ADR_PHY_REG_13_RX_DES)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_13_RX_DES)) & 0xc0ffffff))
#define SET_RG_RX_DES_SRVC_UP(_VAL_) (REG32(ADR_PHY_REG_14_RX_DES)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_14_RX_DES)) & 0xffffffc0))
#define SET_RG_RX_DES_L_LEN_LO(_VAL_) (REG32(ADR_PHY_REG_14_RX_DES)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_REG_14_RX_DES)) & 0xffffc0ff))
#define SET_RG_RX_DES_L_LEN_UP(_VAL_) (REG32(ADR_PHY_REG_14_RX_DES)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_14_RX_DES)) & 0xffc0ffff))
#define SET_RG_RX_DES_TYPE(_VAL_) (REG32(ADR_PHY_REG_14_RX_DES)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_14_RX_DES)) & 0xc0ffffff))
#define SET_RG_RX_DES_L_LEN_UP_COMB(_VAL_) (REG32(ADR_PHY_REG_15_RX_DES)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_15_RX_DES)) & 0xfffffffe))
#define SET_RG_RX_DES_TYPE_COMB(_VAL_) (REG32(ADR_PHY_REG_15_RX_DES)) = (((_VAL_) << 4) | ((REG32(ADR_PHY_REG_15_RX_DES)) & 0xffffffef))
#define SET_RG_RX_DES_RATE_COMB(_VAL_) (REG32(ADR_PHY_REG_15_RX_DES)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_REG_15_RX_DES)) & 0xfffffeff))
#define SET_RG_RX_DES_MODE_COMB(_VAL_) (REG32(ADR_PHY_REG_15_RX_DES)) = (((_VAL_) << 12) | ((REG32(ADR_PHY_REG_15_RX_DES)) & 0xffffefff))
#define SET_RG_RX_DES_SNR(_VAL_) (REG32(ADR_PHY_REG_15_RX_DES)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_15_RX_DES)) & 0xfff0ffff))
#define SET_RG_RX_DES_RCPI(_VAL_) (REG32(ADR_PHY_REG_15_RX_DES)) = (((_VAL_) << 20) | ((REG32(ADR_PHY_REG_15_RX_DES)) & 0xff0fffff))
#define SET_RG_RX_DES_SRVC_LO(_VAL_) (REG32(ADR_PHY_REG_15_RX_DES)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_15_RX_DES)) & 0xc0ffffff))
#define SET_RO_TX_DES_EXCP_RATE_CNT(_VAL_) (REG32(ADR_PHY_REG_16_TX_DES_EXCP)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_16_TX_DES_EXCP)) & 0xffffff00))
#define SET_RO_TX_DES_EXCP_CH_BW_CNT(_VAL_) (REG32(ADR_PHY_REG_16_TX_DES_EXCP)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_REG_16_TX_DES_EXCP)) & 0xffff00ff))
#define SET_RO_TX_DES_EXCP_MODE_CNT(_VAL_) (REG32(ADR_PHY_REG_16_TX_DES_EXCP)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_16_TX_DES_EXCP)) & 0xff00ffff))
#define SET_RG_TX_DES_EXCP_RATE_DEFAULT(_VAL_) (REG32(ADR_PHY_REG_16_TX_DES_EXCP)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_16_TX_DES_EXCP)) & 0xf8ffffff))
#define SET_RG_TX_DES_EXCP_MODE_DEFAULT(_VAL_) (REG32(ADR_PHY_REG_16_TX_DES_EXCP)) = (((_VAL_) << 28) | ((REG32(ADR_PHY_REG_16_TX_DES_EXCP)) & 0x8fffffff))
#define SET_RG_TX_DES_EXCP_CLR(_VAL_) (REG32(ADR_PHY_REG_16_TX_DES_EXCP)) = (((_VAL_) << 31) | ((REG32(ADR_PHY_REG_16_TX_DES_EXCP)) & 0x7fffffff))
#define SET_RG_TX_DES_ACK_WIDTH(_VAL_) (REG32(ADR_PHY_REG_17_TX_DES_EXCP)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_17_TX_DES_EXCP)) & 0xfffffffe))
#define SET_RG_TX_DES_ACK_PRD(_VAL_) (REG32(ADR_PHY_REG_17_TX_DES_EXCP)) = (((_VAL_) << 1) | ((REG32(ADR_PHY_REG_17_TX_DES_EXCP)) & 0xfffffff1))
#define SET_RG_RX_DES_SNR_GN(_VAL_) (REG32(ADR_PHY_REG_17_TX_DES_EXCP)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_17_TX_DES_EXCP)) & 0xffc0ffff))
#define SET_RG_RX_DES_RCPI_GN(_VAL_) (REG32(ADR_PHY_REG_17_TX_DES_EXCP)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_17_TX_DES_EXCP)) & 0xc0ffffff))
#define SET_RG_TST_TBUS_SEL(_VAL_) (REG32(ADR_PHY_REG_18_RSSI_SNR)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_18_RSSI_SNR)) & 0xfffffff0))
#define SET_RG_RSSI_OFFSET(_VAL_) (REG32(ADR_PHY_REG_18_RSSI_SNR)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_18_RSSI_SNR)) & 0xff00ffff))
#define SET_RG_RSSI_INV(_VAL_) (REG32(ADR_PHY_REG_18_RSSI_SNR)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_18_RSSI_SNR)) & 0xfeffffff))
#define SET_RG_TST_ADC_ON(_VAL_) (REG32(ADR_PHY_REG_18_RSSI_SNR)) = (((_VAL_) << 30) | ((REG32(ADR_PHY_REG_18_RSSI_SNR)) & 0xbfffffff))
#define SET_RG_TST_EXT_GAIN(_VAL_) (REG32(ADR_PHY_REG_18_RSSI_SNR)) = (((_VAL_) << 31) | ((REG32(ADR_PHY_REG_18_RSSI_SNR)) & 0x7fffffff))
#define SET_RG_DAC_Q_SET(_VAL_) (REG32(ADR_PHY_REG_19_DAC_MANUAL)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_19_DAC_MANUAL)) & 0xfffffc00))
#define SET_RG_DAC_I_SET(_VAL_) (REG32(ADR_PHY_REG_19_DAC_MANUAL)) = (((_VAL_) << 12) | ((REG32(ADR_PHY_REG_19_DAC_MANUAL)) & 0xffc00fff))
#define SET_RG_DAC_EN_MAN(_VAL_) (REG32(ADR_PHY_REG_19_DAC_MANUAL)) = (((_VAL_) << 28) | ((REG32(ADR_PHY_REG_19_DAC_MANUAL)) & 0xefffffff))
#define SET_RG_IQC_FFT_EN(_VAL_) (REG32(ADR_PHY_REG_19_DAC_MANUAL)) = (((_VAL_) << 29) | ((REG32(ADR_PHY_REG_19_DAC_MANUAL)) & 0xdfffffff))
#define SET_RG_DAC_MAN_Q_EN(_VAL_) (REG32(ADR_PHY_REG_19_DAC_MANUAL)) = (((_VAL_) << 30) | ((REG32(ADR_PHY_REG_19_DAC_MANUAL)) & 0xbfffffff))
#define SET_RG_DAC_MAN_I_EN(_VAL_) (REG32(ADR_PHY_REG_19_DAC_MANUAL)) = (((_VAL_) << 31) | ((REG32(ADR_PHY_REG_19_DAC_MANUAL)) & 0x7fffffff))
#define SET_RO_MRX_EN_CNT(_VAL_) (REG32(ADR_PHY_REG_20_MRX_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_20_MRX_CNT)) & 0xffff0000))
#define SET_RG_MRX_EN_CNT_RST_N(_VAL_) (REG32(ADR_PHY_REG_20_MRX_CNT)) = (((_VAL_) << 31) | ((REG32(ADR_PHY_REG_20_MRX_CNT)) & 0x7fffffff))
#define SET_RG_PA_RISE_TIME(_VAL_) (REG32(ADR_PHY_REG_21_TRX_RAMP)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_21_TRX_RAMP)) & 0xffffff00))
#define SET_RG_RFTX_RISE_TIME(_VAL_) (REG32(ADR_PHY_REG_21_TRX_RAMP)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_REG_21_TRX_RAMP)) & 0xffff00ff))
#define SET_RG_DAC_RISE_TIME(_VAL_) (REG32(ADR_PHY_REG_21_TRX_RAMP)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_21_TRX_RAMP)) & 0xff00ffff))
#define SET_RG_SW_RISE_TIME(_VAL_) (REG32(ADR_PHY_REG_21_TRX_RAMP)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_21_TRX_RAMP)) & 0x00ffffff))
#define SET_RG_PA_FALL_TIME(_VAL_) (REG32(ADR_PHY_REG_22_TRX_RAMP)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_22_TRX_RAMP)) & 0xffffff00))
#define SET_RG_RFTX_FALL_TIME(_VAL_) (REG32(ADR_PHY_REG_22_TRX_RAMP)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_REG_22_TRX_RAMP)) & 0xffff00ff))
#define SET_RG_DAC_FALL_TIME(_VAL_) (REG32(ADR_PHY_REG_22_TRX_RAMP)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_22_TRX_RAMP)) & 0xff00ffff))
#define SET_RG_SW_FALL_TIME(_VAL_) (REG32(ADR_PHY_REG_22_TRX_RAMP)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_22_TRX_RAMP)) & 0x00ffffff))
#define SET_RG_ANT_SW_0(_VAL_) (REG32(ADR_PHY_REG_23_ANT)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_23_ANT)) & 0xfffffff8))
#define SET_RG_ANT_SW_1(_VAL_) (REG32(ADR_PHY_REG_23_ANT)) = (((_VAL_) << 3) | ((REG32(ADR_PHY_REG_23_ANT)) & 0xffffffc7))
#define SET_RG_MTX_LEN_LOWER_TH_0(_VAL_) (REG32(ADR_PHY_REG_24_MTX_LEN_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_24_MTX_LEN_CNT)) & 0xffffe000))
#define SET_RG_MTX_LEN_UPPER_TH_0(_VAL_) (REG32(ADR_PHY_REG_24_MTX_LEN_CNT)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_24_MTX_LEN_CNT)) & 0xe000ffff))
#define SET_RG_MTX_LEN_CNT_EN_0(_VAL_) (REG32(ADR_PHY_REG_24_MTX_LEN_CNT)) = (((_VAL_) << 31) | ((REG32(ADR_PHY_REG_24_MTX_LEN_CNT)) & 0x7fffffff))
#define SET_RG_MTX_LEN_LOWER_TH_1(_VAL_) (REG32(ADR_PHY_REG_25_MTX_LEN_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_25_MTX_LEN_CNT)) & 0xffffe000))
#define SET_RG_MTX_LEN_UPPER_TH_1(_VAL_) (REG32(ADR_PHY_REG_25_MTX_LEN_CNT)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_25_MTX_LEN_CNT)) & 0xe000ffff))
#define SET_RG_MTX_LEN_CNT_EN_1(_VAL_) (REG32(ADR_PHY_REG_25_MTX_LEN_CNT)) = (((_VAL_) << 31) | ((REG32(ADR_PHY_REG_25_MTX_LEN_CNT)) & 0x7fffffff))
#define SET_RG_MRX_LEN_LOWER_TH_0(_VAL_) (REG32(ADR_PHY_REG_26_MRX_LEN_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_26_MRX_LEN_CNT)) & 0xffffe000))
#define SET_RG_MRX_LEN_UPPER_TH_0(_VAL_) (REG32(ADR_PHY_REG_26_MRX_LEN_CNT)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_26_MRX_LEN_CNT)) & 0xe000ffff))
#define SET_RG_MRX_LEN_CNT_EN_0(_VAL_) (REG32(ADR_PHY_REG_26_MRX_LEN_CNT)) = (((_VAL_) << 31) | ((REG32(ADR_PHY_REG_26_MRX_LEN_CNT)) & 0x7fffffff))
#define SET_RG_MRX_LEN_LOWER_TH_1(_VAL_) (REG32(ADR_PHY_REG_27_MRX_LEN_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_27_MRX_LEN_CNT)) & 0xffffe000))
#define SET_RG_MRX_LEN_UPPER_TH_1(_VAL_) (REG32(ADR_PHY_REG_27_MRX_LEN_CNT)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_27_MRX_LEN_CNT)) & 0xe000ffff))
#define SET_RG_MRX_LEN_CNT_EN_1(_VAL_) (REG32(ADR_PHY_REG_27_MRX_LEN_CNT)) = (((_VAL_) << 31) | ((REG32(ADR_PHY_REG_27_MRX_LEN_CNT)) & 0x7fffffff))
#define SET_RO_MTX_LEN_CNT_1(_VAL_) (REG32(ADR_PHY_READ_REG_04)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_READ_REG_04)) & 0xffff0000))
#define SET_RO_MTX_LEN_CNT_0(_VAL_) (REG32(ADR_PHY_READ_REG_04)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_READ_REG_04)) & 0x0000ffff))
#define SET_RO_MRX_LEN_CNT_1(_VAL_) (REG32(ADR_PHY_READ_REG_05)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_READ_REG_05)) & 0xffff0000))
#define SET_RO_MRX_LEN_CNT_0(_VAL_) (REG32(ADR_PHY_READ_REG_05)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_READ_REG_05)) & 0x0000ffff))
#define SET_RG_MODE_REG_IN_16(_VAL_) (REG32(ADR_PHY_REG_28_BIST)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_28_BIST)) & 0xffff0000))
#define SET_RG_PARALLEL_DR_16(_VAL_) (REG32(ADR_PHY_REG_28_BIST)) = (((_VAL_) << 20) | ((REG32(ADR_PHY_REG_28_BIST)) & 0xffefffff))
#define SET_RG_MBRUN_16(_VAL_) (REG32(ADR_PHY_REG_28_BIST)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_28_BIST)) & 0xfeffffff))
#define SET_RG_SHIFT_DR_16(_VAL_) (REG32(ADR_PHY_REG_28_BIST)) = (((_VAL_) << 28) | ((REG32(ADR_PHY_REG_28_BIST)) & 0xefffffff))
#define SET_RG_MODE_REG_SI_16(_VAL_) (REG32(ADR_PHY_REG_28_BIST)) = (((_VAL_) << 29) | ((REG32(ADR_PHY_REG_28_BIST)) & 0xdfffffff))
#define SET_RG_SIMULATION_MODE_16(_VAL_) (REG32(ADR_PHY_REG_28_BIST)) = (((_VAL_) << 30) | ((REG32(ADR_PHY_REG_28_BIST)) & 0xbfffffff))
#define SET_RG_DBIST_MODE_16(_VAL_) (REG32(ADR_PHY_REG_28_BIST)) = (((_VAL_) << 31) | ((REG32(ADR_PHY_REG_28_BIST)) & 0x7fffffff))
#define SET_RO_MODE_REG_OUT_16(_VAL_) (REG32(ADR_PHY_READ_REG_06_BIST)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_READ_REG_06_BIST)) & 0xffff0000))
#define SET_RO_MODE_REG_SO_16(_VAL_) (REG32(ADR_PHY_READ_REG_06_BIST)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_READ_REG_06_BIST)) & 0xfeffffff))
#define SET_RO_MONITOR_BUS_16(_VAL_) (REG32(ADR_PHY_READ_REG_07_BIST)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_READ_REG_07_BIST)) & 0xfff80000))
#define SET_RG_MRX_TYPE_1(_VAL_) (REG32(ADR_PHY_REG_29_MTRX_MAC)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_29_MTRX_MAC)) & 0xffffff00))
#define SET_RG_MRX_TYPE_0(_VAL_) (REG32(ADR_PHY_REG_29_MTRX_MAC)) = (((_VAL_) << 8) | ((REG32(ADR_PHY_REG_29_MTRX_MAC)) & 0xffff00ff))
#define SET_RG_MTX_TYPE_1(_VAL_) (REG32(ADR_PHY_REG_29_MTRX_MAC)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_29_MTRX_MAC)) & 0xff00ffff))
#define SET_RG_MTX_TYPE_0(_VAL_) (REG32(ADR_PHY_REG_29_MTRX_MAC)) = (((_VAL_) << 24) | ((REG32(ADR_PHY_REG_29_MTRX_MAC)) & 0x00ffffff))
#define SET_RO_MTX_TYPE_CNT_1(_VAL_) (REG32(ADR_PHY_READ_REG_08_MTRX_MAC)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_READ_REG_08_MTRX_MAC)) & 0xffff0000))
#define SET_RO_MTX_TYPE_CNT_0(_VAL_) (REG32(ADR_PHY_READ_REG_08_MTRX_MAC)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_READ_REG_08_MTRX_MAC)) & 0x0000ffff))
#define SET_RO_MRX_TYPE_CNT_1(_VAL_) (REG32(ADR_PHY_READ_REG_09_MTRX_MAC)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_READ_REG_09_MTRX_MAC)) & 0xffff0000))
#define SET_RO_MRX_TYPE_CNT_0(_VAL_) (REG32(ADR_PHY_READ_REG_09_MTRX_MAC)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_READ_REG_09_MTRX_MAC)) & 0x0000ffff))
#define SET_RG_HB_COEF0(_VAL_) (REG32(ADR_PHY_REG_30_TX_UP_FIL)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_30_TX_UP_FIL)) & 0xfffff000))
#define SET_RG_HB_COEF1(_VAL_) (REG32(ADR_PHY_REG_30_TX_UP_FIL)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_30_TX_UP_FIL)) & 0xf000ffff))
#define SET_RG_HB_COEF2(_VAL_) (REG32(ADR_PHY_REG_31_TX_UP_FIL)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_31_TX_UP_FIL)) & 0xfffff000))
#define SET_RG_HB_COEF3(_VAL_) (REG32(ADR_PHY_REG_31_TX_UP_FIL)) = (((_VAL_) << 16) | ((REG32(ADR_PHY_REG_31_TX_UP_FIL)) & 0xf000ffff))
#define SET_RG_HB_COEF4(_VAL_) (REG32(ADR_PHY_REG_32_TX_UP_FIL)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_REG_32_TX_UP_FIL)) & 0xfffff000))
#define SET_RO_TBUS_O(_VAL_) (REG32(ADR_PHY_READ_TBUS)) = (((_VAL_) << 0) | ((REG32(ADR_PHY_READ_TBUS)) & 0xfff00000))
#define SET_RG_LPF4_00(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_00)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_00)) & 0xffffe000))
#define SET_RG_LPF4_01(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_01)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_01)) & 0xffffe000))
#define SET_RG_LPF4_02(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_02)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_02)) & 0xffffe000))
#define SET_RG_LPF4_03(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_03)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_03)) & 0xffffe000))
#define SET_RG_LPF4_04(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_04)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_04)) & 0xffffe000))
#define SET_RG_LPF4_05(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_05)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_05)) & 0xffffe000))
#define SET_RG_LPF4_06(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_06)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_06)) & 0xffffe000))
#define SET_RG_LPF4_07(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_07)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_07)) & 0xffffe000))
#define SET_RG_LPF4_08(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_08)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_08)) & 0xffffe000))
#define SET_RG_LPF4_09(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_09)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_09)) & 0xffffe000))
#define SET_RG_LPF4_10(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_10)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_10)) & 0xffffe000))
#define SET_RG_LPF4_11(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_11)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_11)) & 0xffffe000))
#define SET_RG_LPF4_12(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_12)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_12)) & 0xffffe000))
#define SET_RG_LPF4_13(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_13)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_13)) & 0xffffe000))
#define SET_RG_LPF4_14(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_14)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_14)) & 0xffffe000))
#define SET_RG_LPF4_15(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_15)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_15)) & 0xffffe000))
#define SET_RG_LPF4_16(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_16)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_16)) & 0xffffe000))
#define SET_RG_LPF4_17(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_17)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_17)) & 0xffffe000))
#define SET_RG_LPF4_18(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_18)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_18)) & 0xffffe000))
#define SET_RG_LPF4_19(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_19)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_19)) & 0xffffe000))
#define SET_RG_LPF4_20(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_20)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_20)) & 0xffffe000))
#define SET_RG_LPF4_21(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_21)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_21)) & 0xffffe000))
#define SET_RG_LPF4_22(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_22)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_22)) & 0xffffe000))
#define SET_RG_LPF4_23(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_23)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_23)) & 0xffffe000))
#define SET_RG_LPF4_24(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_24)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_24)) & 0xffffe000))
#define SET_RG_LPF4_25(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_25)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_25)) & 0xffffe000))
#define SET_RG_LPF4_26(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_26)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_26)) & 0xffffe000))
#define SET_RG_LPF4_27(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_27)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_27)) & 0xffffe000))
#define SET_RG_LPF4_28(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_28)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_28)) & 0xffffe000))
#define SET_RG_LPF4_29(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_29)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_29)) & 0xffffe000))
#define SET_RG_LPF4_30(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_30)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_30)) & 0xffffe000))
#define SET_RG_LPF4_31(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_31)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_31)) & 0xffffe000))
#define SET_RG_LPF4_32(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_32)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_32)) & 0xffffe000))
#define SET_RG_LPF4_33(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_33)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_33)) & 0xffffe000))
#define SET_RG_LPF4_34(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_34)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_34)) & 0xffffe000))
#define SET_RG_LPF4_35(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_35)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_35)) & 0xffffe000))
#define SET_RG_LPF4_36(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_36)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_36)) & 0xffffe000))
#define SET_RG_LPF4_37(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_37)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_37)) & 0xffffe000))
#define SET_RG_LPF4_38(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_38)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_38)) & 0xffffe000))
#define SET_RG_LPF4_39(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_39)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_39)) & 0xffffe000))
#define SET_RG_LPF4_40(_VAL_) (REG32(ADR_TX_11B_FIL_COEF_40)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_FIL_COEF_40)) & 0xffffe000))
#define SET_RG_BP_SMB(_VAL_) (REG32(ADR_TX_11B_PLCP)) = (((_VAL_) << 13) | ((REG32(ADR_TX_11B_PLCP)) & 0xffffdfff))
#define SET_RG_EN_SRVC(_VAL_) (REG32(ADR_TX_11B_PLCP)) = (((_VAL_) << 14) | ((REG32(ADR_TX_11B_PLCP)) & 0xffffbfff))
#define SET_RG_DES_SPD(_VAL_) (REG32(ADR_TX_11B_PLCP)) = (((_VAL_) << 16) | ((REG32(ADR_TX_11B_PLCP)) & 0xfffcffff))
#define SET_RG_BB_11B_RISE_TIME(_VAL_) (REG32(ADR_TX_11B_RAMP)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_RAMP)) & 0xffffff00))
#define SET_RG_BB_11B_FALL_TIME(_VAL_) (REG32(ADR_TX_11B_RAMP)) = (((_VAL_) << 8) | ((REG32(ADR_TX_11B_RAMP)) & 0xffff00ff))
#define SET_RG_WR_TX_EN_CNT_RST_N(_VAL_) (REG32(ADR_TX_11B_EN_CNT_RST_N)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_EN_CNT_RST_N)) & 0xfffffffe))
#define SET_RO_TX_EN_CNT(_VAL_) (REG32(ADR_TX_11B_EN_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_EN_CNT)) & 0xffff0000))
#define SET_RO_TX_CNT(_VAL_) (REG32(ADR_TX_11B_PKT_GEN_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11B_PKT_GEN_CNT)) & 0x00000000))
#define SET_RG_POS_DES_11B_L_EXT(_VAL_) (REG32(ADR_RX_11B_DES_DLY)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_DES_DLY)) & 0xfffffff0))
#define SET_RG_PRE_DES_11B_DLY(_VAL_) (REG32(ADR_RX_11B_DES_DLY)) = (((_VAL_) << 4) | ((REG32(ADR_RX_11B_DES_DLY)) & 0xffffff0f))
#define SET_RG_CNT_CCA_LMT(_VAL_) (REG32(ADR_RX_11B_CCA_0)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_CCA_0)) & 0xfff0ffff))
#define SET_RG_BYPASS_DESCRAMBLER(_VAL_) (REG32(ADR_RX_11B_CCA_0)) = (((_VAL_) << 29) | ((REG32(ADR_RX_11B_CCA_0)) & 0xdfffffff))
#define SET_RG_BYPASS_AGC(_VAL_) (REG32(ADR_RX_11B_CCA_0)) = (((_VAL_) << 31) | ((REG32(ADR_RX_11B_CCA_0)) & 0x7fffffff))
#define SET_RG_CCA_BIT_CNT_LMT_RX(_VAL_) (REG32(ADR_RX_11B_CCA_1)) = (((_VAL_) << 4) | ((REG32(ADR_RX_11B_CCA_1)) & 0xffffff0f))
#define SET_RG_CCA_SCALE_BF(_VAL_) (REG32(ADR_RX_11B_CCA_1)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_CCA_1)) & 0xff80ffff))
#define SET_RG_PEAK_IDX_CNT_SEL(_VAL_) (REG32(ADR_RX_11B_CCA_1)) = (((_VAL_) << 28) | ((REG32(ADR_RX_11B_CCA_1)) & 0xcfffffff))
#define SET_RG_TR_KI_T2(_VAL_) (REG32(ADR_RX_11B_TR_KP_KI_0)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_TR_KP_KI_0)) & 0xfffffff8))
#define SET_RG_TR_KP_T2(_VAL_) (REG32(ADR_RX_11B_TR_KP_KI_0)) = (((_VAL_) << 4) | ((REG32(ADR_RX_11B_TR_KP_KI_0)) & 0xffffff8f))
#define SET_RG_TR_KI_T1(_VAL_) (REG32(ADR_RX_11B_TR_KP_KI_0)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11B_TR_KP_KI_0)) & 0xfffff8ff))
#define SET_RG_TR_KP_T1(_VAL_) (REG32(ADR_RX_11B_TR_KP_KI_0)) = (((_VAL_) << 12) | ((REG32(ADR_RX_11B_TR_KP_KI_0)) & 0xffff8fff))
#define SET_RG_CR_KI_T1(_VAL_) (REG32(ADR_RX_11B_TR_KP_KI_1)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_TR_KP_KI_1)) & 0xfff8ffff))
#define SET_RG_CR_KP_T1(_VAL_) (REG32(ADR_RX_11B_TR_KP_KI_1)) = (((_VAL_) << 20) | ((REG32(ADR_RX_11B_TR_KP_KI_1)) & 0xff8fffff))
#define SET_RG_CHIP_CNT_SLICER(_VAL_) (REG32(ADR_RX_11B_CE_CNT_THRESHOLD)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_CE_CNT_THRESHOLD)) & 0xffffffe0))
#define SET_RG_CE_T4_CNT_LMT(_VAL_) (REG32(ADR_RX_11B_CE_CNT_THRESHOLD)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11B_CE_CNT_THRESHOLD)) & 0xffff00ff))
#define SET_RG_CE_T3_CNT_LMT(_VAL_) (REG32(ADR_RX_11B_CE_CNT_THRESHOLD)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_CE_CNT_THRESHOLD)) & 0xff00ffff))
#define SET_RG_CE_T2_CNT_LMT(_VAL_) (REG32(ADR_RX_11B_CE_CNT_THRESHOLD)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11B_CE_CNT_THRESHOLD)) & 0x00ffffff))
#define SET_RG_CE_MU_T1(_VAL_) (REG32(ADR_RX_11B_CE_MU_0)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_CE_MU_0)) & 0xfffffff8))
#define SET_RG_CE_DLY_SEL(_VAL_) (REG32(ADR_RX_11B_CE_MU_0)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_CE_MU_0)) & 0xffc0ffff))
#define SET_RG_CE_MU_T8(_VAL_) (REG32(ADR_RX_11B_CE_MU_1)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_CE_MU_1)) & 0xfffffff8))
#define SET_RG_CE_MU_T7(_VAL_) (REG32(ADR_RX_11B_CE_MU_1)) = (((_VAL_) << 4) | ((REG32(ADR_RX_11B_CE_MU_1)) & 0xffffff8f))
#define SET_RG_CE_MU_T6(_VAL_) (REG32(ADR_RX_11B_CE_MU_1)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11B_CE_MU_1)) & 0xfffff8ff))
#define SET_RG_CE_MU_T5(_VAL_) (REG32(ADR_RX_11B_CE_MU_1)) = (((_VAL_) << 12) | ((REG32(ADR_RX_11B_CE_MU_1)) & 0xffff8fff))
#define SET_RG_CE_MU_T4(_VAL_) (REG32(ADR_RX_11B_CE_MU_1)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_CE_MU_1)) & 0xfff8ffff))
#define SET_RG_CE_MU_T3(_VAL_) (REG32(ADR_RX_11B_CE_MU_1)) = (((_VAL_) << 20) | ((REG32(ADR_RX_11B_CE_MU_1)) & 0xff8fffff))
#define SET_RG_CE_MU_T2(_VAL_) (REG32(ADR_RX_11B_CE_MU_1)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11B_CE_MU_1)) & 0xf8ffffff))
#define SET_RG_EQ_MU_FB_T2(_VAL_) (REG32(ADR_RX_11B_EQ_MU_0)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_EQ_MU_0)) & 0xfffffff0))
#define SET_RG_EQ_MU_FF_T2(_VAL_) (REG32(ADR_RX_11B_EQ_MU_0)) = (((_VAL_) << 4) | ((REG32(ADR_RX_11B_EQ_MU_0)) & 0xffffff0f))
#define SET_RG_EQ_MU_FB_T1(_VAL_) (REG32(ADR_RX_11B_EQ_MU_0)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_EQ_MU_0)) & 0xfff0ffff))
#define SET_RG_EQ_MU_FF_T1(_VAL_) (REG32(ADR_RX_11B_EQ_MU_0)) = (((_VAL_) << 20) | ((REG32(ADR_RX_11B_EQ_MU_0)) & 0xff0fffff))
#define SET_RG_EQ_MU_FB_T4(_VAL_) (REG32(ADR_RX_11B_EQ_MU_1)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_EQ_MU_1)) & 0xfffffff0))
#define SET_RG_EQ_MU_FF_T4(_VAL_) (REG32(ADR_RX_11B_EQ_MU_1)) = (((_VAL_) << 4) | ((REG32(ADR_RX_11B_EQ_MU_1)) & 0xffffff0f))
#define SET_RG_EQ_MU_FB_T3(_VAL_) (REG32(ADR_RX_11B_EQ_MU_1)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_EQ_MU_1)) & 0xfff0ffff))
#define SET_RG_EQ_MU_FF_T3(_VAL_) (REG32(ADR_RX_11B_EQ_MU_1)) = (((_VAL_) << 20) | ((REG32(ADR_RX_11B_EQ_MU_1)) & 0xff0fffff))
#define SET_RG_EQ_KI_T2(_VAL_) (REG32(ADR_RX_11B_EQ_CR_KP_KI)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11B_EQ_CR_KP_KI)) & 0xfffff8ff))
#define SET_RG_EQ_KP_T2(_VAL_) (REG32(ADR_RX_11B_EQ_CR_KP_KI)) = (((_VAL_) << 12) | ((REG32(ADR_RX_11B_EQ_CR_KP_KI)) & 0xffff8fff))
#define SET_RG_EQ_KI_T1(_VAL_) (REG32(ADR_RX_11B_EQ_CR_KP_KI)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_EQ_CR_KP_KI)) & 0xfff8ffff))
#define SET_RG_EQ_KP_T1(_VAL_) (REG32(ADR_RX_11B_EQ_CR_KP_KI)) = (((_VAL_) << 20) | ((REG32(ADR_RX_11B_EQ_CR_KP_KI)) & 0xff8fffff))
#define SET_RG_TR_LPF_RATE(_VAL_) (REG32(ADR_RX_11B_LPF_RATE)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_LPF_RATE)) & 0xffc00000))
#define SET_RG_CE_BIT_CNT_LMT(_VAL_) (REG32(ADR_RX_11B_CIT_CNT_THRESHOLD)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_CIT_CNT_THRESHOLD)) & 0xffffff80))
#define SET_RG_CE_CH_MAIN_SET(_VAL_) (REG32(ADR_RX_11B_CIT_CNT_THRESHOLD)) = (((_VAL_) << 7) | ((REG32(ADR_RX_11B_CIT_CNT_THRESHOLD)) & 0xffffff7f))
#define SET_RG_TC_BIT_CNT_LMT(_VAL_) (REG32(ADR_RX_11B_CIT_CNT_THRESHOLD)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11B_CIT_CNT_THRESHOLD)) & 0xffff80ff))
#define SET_RG_CR_BIT_CNT_LMT(_VAL_) (REG32(ADR_RX_11B_CIT_CNT_THRESHOLD)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_CIT_CNT_THRESHOLD)) & 0xff80ffff))
#define SET_RG_TR_BIT_CNT_LMT(_VAL_) (REG32(ADR_RX_11B_CIT_CNT_THRESHOLD)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11B_CIT_CNT_THRESHOLD)) & 0x80ffffff))
#define SET_RG_EQ_MAIN_TAP_MAN(_VAL_) (REG32(ADR_RX_11B_EQ_CH_MAIN_TAP)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_EQ_CH_MAIN_TAP)) & 0xfffffffe))
#define SET_RG_EQ_MAIN_TAP_COEF(_VAL_) (REG32(ADR_RX_11B_EQ_CH_MAIN_TAP)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_EQ_CH_MAIN_TAP)) & 0xf800ffff))
#define SET_RG_PWRON_DLY_TH_11B(_VAL_) (REG32(ADR_RX_11B_SEARCH_CNT_TH)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_SEARCH_CNT_TH)) & 0xffffff00))
#define SET_RG_SFD_BIT_CNT_LMT(_VAL_) (REG32(ADR_RX_11B_SEARCH_CNT_TH)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_SEARCH_CNT_TH)) & 0xff00ffff))
#define SET_RG_CCA_PWR_TH_RX(_VAL_) (REG32(ADR_RX_11B_CCA_CONTROL)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_CCA_CONTROL)) & 0xffff8000))
#define SET_RG_CCA_PWR_CNT_TH(_VAL_) (REG32(ADR_RX_11B_CCA_CONTROL)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_CCA_CONTROL)) & 0xffe0ffff))
#define SET_B_FREQ_OS(_VAL_) (REG32(ADR_RX_11B_FREQUENCY_OFFSET)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_FREQUENCY_OFFSET)) & 0xfffff800))
#define SET_B_SNR(_VAL_) (REG32(ADR_RX_11B_SNR_RSSI)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_SNR_RSSI)) & 0xffffff80))
#define SET_B_RCPI(_VAL_) (REG32(ADR_RX_11B_SNR_RSSI)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_SNR_RSSI)) & 0xff80ffff))
#define SET_CRC_CNT(_VAL_) (REG32(ADR_RX_11B_SFD_CRC_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_SFD_CRC_CNT)) & 0xffff0000))
#define SET_SFD_CNT(_VAL_) (REG32(ADR_RX_11B_SFD_CRC_CNT)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_SFD_CRC_CNT)) & 0x0000ffff))
#define SET_B_PACKET_ERR_CNT(_VAL_) (REG32(ADR_RX_11B_PKT_ERR_AND_PKT_ERR_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_PKT_ERR_AND_PKT_ERR_CNT)) & 0xffff0000))
#define SET_PACKET_ERR(_VAL_) (REG32(ADR_RX_11B_PKT_ERR_AND_PKT_ERR_CNT)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_PKT_ERR_AND_PKT_ERR_CNT)) & 0xfffeffff))
#define SET_B_PACKET_CNT(_VAL_) (REG32(ADR_RX_11B_PKT_CCA_AND_PKT_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_PKT_CCA_AND_PKT_CNT)) & 0xffff0000))
#define SET_B_CCA_CNT(_VAL_) (REG32(ADR_RX_11B_PKT_CCA_AND_PKT_CNT)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_PKT_CCA_AND_PKT_CNT)) & 0x0000ffff))
#define SET_B_LENGTH_FIELD(_VAL_) (REG32(ADR_RX_11B_SFD_FILED_0)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_SFD_FILED_0)) & 0xffff0000))
#define SET_SFD_FIELD(_VAL_) (REG32(ADR_RX_11B_SFD_FILED_0)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_SFD_FILED_0)) & 0x0000ffff))
#define SET_SIGNAL_FIELD(_VAL_) (REG32(ADR_RX_11B_SFD_FIELD_1)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_SFD_FIELD_1)) & 0xffffff00))
#define SET_B_SERVICE_FIELD(_VAL_) (REG32(ADR_RX_11B_SFD_FIELD_1)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11B_SFD_FIELD_1)) & 0xffff00ff))
#define SET_CRC_CORRECT(_VAL_) (REG32(ADR_RX_11B_SFD_FIELD_1)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11B_SFD_FIELD_1)) & 0xfffeffff))
#define SET_DEBUG_SEL(_VAL_) (REG32(ADR_RX_11B_PKT_STAT_EN)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_PKT_STAT_EN)) & 0xfffffff0))
#define SET_RG_PACKET_STAT_EN_11B(_VAL_) (REG32(ADR_RX_11B_PKT_STAT_EN)) = (((_VAL_) << 20) | ((REG32(ADR_RX_11B_PKT_STAT_EN)) & 0xffefffff))
#define SET_RG_BIT_REVERSE(_VAL_) (REG32(ADR_RX_11B_PKT_STAT_EN)) = (((_VAL_) << 21) | ((REG32(ADR_RX_11B_PKT_STAT_EN)) & 0xffdfffff))
#define SET_RX_PHY_11B_SOFT_RST_N(_VAL_) (REG32(ADR_RX_11B_SOFT_RST)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11B_SOFT_RST)) & 0xfffffffe))
#define SET_RG_CE_BYPASS_TAP(_VAL_) (REG32(ADR_RX_11B_SOFT_RST)) = (((_VAL_) << 4) | ((REG32(ADR_RX_11B_SOFT_RST)) & 0xffffff0f))
#define SET_RG_EQ_BYPASS_FBW_TAP(_VAL_) (REG32(ADR_RX_11B_SOFT_RST)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11B_SOFT_RST)) & 0xfffff0ff))
#define SET_RG_BB_11GN_RISE_TIME(_VAL_) (REG32(ADR_TX_11GN_RAMP)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11GN_RAMP)) & 0xffffff00))
#define SET_RG_BB_11GN_FALL_TIME(_VAL_) (REG32(ADR_TX_11GN_RAMP)) = (((_VAL_) << 8) | ((REG32(ADR_TX_11GN_RAMP)) & 0xffff00ff))
#define SET_RG_HTCARR52_FFT_SCALE(_VAL_) (REG32(ADR_TX_11GN_PLCP)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11GN_PLCP)) & 0xfffffc00))
#define SET_RG_HTCARR56_FFT_SCALE(_VAL_) (REG32(ADR_TX_11GN_PLCP)) = (((_VAL_) << 12) | ((REG32(ADR_TX_11GN_PLCP)) & 0xffc00fff))
#define SET_RG_PACKET_STAT_EN(_VAL_) (REG32(ADR_TX_11GN_PLCP)) = (((_VAL_) << 23) | ((REG32(ADR_TX_11GN_PLCP)) & 0xff7fffff))
#define SET_RG_SMB_DEF(_VAL_) (REG32(ADR_TX_11GN_PLCP)) = (((_VAL_) << 24) | ((REG32(ADR_TX_11GN_PLCP)) & 0x80ffffff))
#define SET_RG_CONTINUOUS_DATA_11GN(_VAL_) (REG32(ADR_TX_11GN_PLCP)) = (((_VAL_) << 31) | ((REG32(ADR_TX_11GN_PLCP)) & 0x7fffffff))
#define SET_RO_TX_CNT_R(_VAL_) (REG32(ADR_TX_11GN_PKT_GEN_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11GN_PKT_GEN_CNT)) & 0x00000000))
#define SET_RO_PACKET_ERR_CNT(_VAL_) (REG32(ADR_TX_11GN_PLCP_CRC_ERR_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_TX_11GN_PLCP_CRC_ERR_CNT)) & 0xffff0000))
#define SET_RG_POS_DES_11GN_L_EXT(_VAL_) (REG32(ADR_RX_11GN_DES_DLY)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_DES_DLY)) & 0xfffffff0))
#define SET_RG_PRE_DES_11GN_DLY(_VAL_) (REG32(ADR_RX_11GN_DES_DLY)) = (((_VAL_) << 4) | ((REG32(ADR_RX_11GN_DES_DLY)) & 0xffffff0f))
#define SET_RG_TR_LPF_KI_G_T1(_VAL_) (REG32(ADR_RX_11GN_TR_0)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_TR_0)) & 0xfffffff0))
#define SET_RG_TR_LPF_KP_G_T1(_VAL_) (REG32(ADR_RX_11GN_TR_0)) = (((_VAL_) << 4) | ((REG32(ADR_RX_11GN_TR_0)) & 0xffffff0f))
#define SET_RG_TR_CNT_T1(_VAL_) (REG32(ADR_RX_11GN_TR_0)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_TR_0)) & 0xffff00ff))
#define SET_RG_TR_LPF_KI_G_T0(_VAL_) (REG32(ADR_RX_11GN_TR_0)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_TR_0)) & 0xfff0ffff))
#define SET_RG_TR_LPF_KP_G_T0(_VAL_) (REG32(ADR_RX_11GN_TR_0)) = (((_VAL_) << 20) | ((REG32(ADR_RX_11GN_TR_0)) & 0xff0fffff))
#define SET_RG_TR_CNT_T0(_VAL_) (REG32(ADR_RX_11GN_TR_0)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_TR_0)) & 0x00ffffff))
#define SET_RG_TR_LPF_KI_G_T2(_VAL_) (REG32(ADR_RX_11GN_TR_1)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_TR_1)) & 0xfffffff0))
#define SET_RG_TR_LPF_KP_G_T2(_VAL_) (REG32(ADR_RX_11GN_TR_1)) = (((_VAL_) << 4) | ((REG32(ADR_RX_11GN_TR_1)) & 0xffffff0f))
#define SET_RG_TR_CNT_T2(_VAL_) (REG32(ADR_RX_11GN_TR_1)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_TR_1)) & 0xffff00ff))
#define SET_RG_TR_LPF_KI_G(_VAL_) (REG32(ADR_RX_11GN_TR_2)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_TR_2)) & 0xfffffff0))
#define SET_RG_TR_LPF_KP_G(_VAL_) (REG32(ADR_RX_11GN_TR_2)) = (((_VAL_) << 4) | ((REG32(ADR_RX_11GN_TR_2)) & 0xffffff0f))
#define SET_RG_TR_LPF_RATE_G(_VAL_) (REG32(ADR_RX_11GN_TR_2)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_TR_2)) & 0xc00000ff))
#define SET_RG_CR_LPF_KI_G(_VAL_) (REG32(ADR_RX_11GN_CCA_0)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_CCA_0)) & 0xfffffff8))
#define SET_RG_SYM_BOUND_CNT(_VAL_) (REG32(ADR_RX_11GN_CCA_0)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_CCA_0)) & 0xffff80ff))
#define SET_RG_XSCOR32_RATIO(_VAL_) (REG32(ADR_RX_11GN_CCA_0)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_CCA_0)) & 0xff80ffff))
#define SET_RG_ATCOR64_CNT_LMT(_VAL_) (REG32(ADR_RX_11GN_CCA_0)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_CCA_0)) & 0x80ffffff))
#define SET_RG_ATCOR16_CNT_LMT2(_VAL_) (REG32(ADR_RX_11GN_CCA_1)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_CCA_1)) & 0xffff80ff))
#define SET_RG_ATCOR16_CNT_LMT1(_VAL_) (REG32(ADR_RX_11GN_CCA_1)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_CCA_1)) & 0xff80ffff))
#define SET_RG_ATCOR16_RATIO_SB(_VAL_) (REG32(ADR_RX_11GN_CCA_1)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_CCA_1)) & 0x80ffffff))
#define SET_RG_XSCOR64_CNT_LMT2(_VAL_) (REG32(ADR_RX_11GN_CCA_2)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_CCA_2)) & 0xff80ffff))
#define SET_RG_XSCOR64_CNT_LMT1(_VAL_) (REG32(ADR_RX_11GN_CCA_2)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_CCA_2)) & 0x80ffffff))
#define SET_RG_RX_FFT_SCALE(_VAL_) (REG32(ADR_RX_11GN_CCA_FFT_SCALE)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_CCA_FFT_SCALE)) & 0xfffffc00))
#define SET_RG_VITERBI_AB_SWAP(_VAL_) (REG32(ADR_RX_11GN_CCA_FFT_SCALE)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_CCA_FFT_SCALE)) & 0xfffeffff))
#define SET_RG_ATCOR16_CNT_TH(_VAL_) (REG32(ADR_RX_11GN_CCA_FFT_SCALE)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_CCA_FFT_SCALE)) & 0xf0ffffff))
#define SET_RG_NORMSQUARE_LOW_SNR_7(_VAL_) (REG32(ADR_RX_11GN_SOFT_DEMAP_0)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_SOFT_DEMAP_0)) & 0xffffff00))
#define SET_RG_NORMSQUARE_LOW_SNR_6(_VAL_) (REG32(ADR_RX_11GN_SOFT_DEMAP_0)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_SOFT_DEMAP_0)) & 0xffff00ff))
#define SET_RG_NORMSQUARE_LOW_SNR_5(_VAL_) (REG32(ADR_RX_11GN_SOFT_DEMAP_0)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_SOFT_DEMAP_0)) & 0xff00ffff))
#define SET_RG_NORMSQUARE_LOW_SNR_4(_VAL_) (REG32(ADR_RX_11GN_SOFT_DEMAP_0)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_SOFT_DEMAP_0)) & 0x00ffffff))
#define SET_RG_NORMSQUARE_LOW_SNR_8(_VAL_) (REG32(ADR_RX_11GN_SOFT_DEMAP_1)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_SOFT_DEMAP_1)) & 0x00ffffff))
#define SET_RG_NORMSQUARE_SNR_3(_VAL_) (REG32(ADR_RX_11GN_SOFT_DEMAP_2)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_SOFT_DEMAP_2)) & 0xffffff00))
#define SET_RG_NORMSQUARE_SNR_2(_VAL_) (REG32(ADR_RX_11GN_SOFT_DEMAP_2)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_SOFT_DEMAP_2)) & 0xffff00ff))
#define SET_RG_NORMSQUARE_SNR_1(_VAL_) (REG32(ADR_RX_11GN_SOFT_DEMAP_2)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_SOFT_DEMAP_2)) & 0xff00ffff))
#define SET_RG_NORMSQUARE_SNR_0(_VAL_) (REG32(ADR_RX_11GN_SOFT_DEMAP_2)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_SOFT_DEMAP_2)) & 0x00ffffff))
#define SET_RG_NORMSQUARE_SNR_7(_VAL_) (REG32(ADR_RX_11GN_SOFT_DEMAP_3)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_SOFT_DEMAP_3)) & 0xffffff00))
#define SET_RG_NORMSQUARE_SNR_6(_VAL_) (REG32(ADR_RX_11GN_SOFT_DEMAP_3)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_SOFT_DEMAP_3)) & 0xffff00ff))
#define SET_RG_NORMSQUARE_SNR_5(_VAL_) (REG32(ADR_RX_11GN_SOFT_DEMAP_3)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_SOFT_DEMAP_3)) & 0xff00ffff))
#define SET_RG_NORMSQUARE_SNR_4(_VAL_) (REG32(ADR_RX_11GN_SOFT_DEMAP_3)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_SOFT_DEMAP_3)) & 0x00ffffff))
#define SET_RG_NORMSQUARE_SNR_8(_VAL_) (REG32(ADR_RX_11GN_SOFT_DEMAP_4)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_SOFT_DEMAP_4)) & 0x00ffffff))
#define SET_RG_SNR_TH_64QAM(_VAL_) (REG32(ADR_RX_11GN_SOFT_DEMAP_5)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_SOFT_DEMAP_5)) & 0xffffff80))
#define SET_RG_SNR_TH_16QAM(_VAL_) (REG32(ADR_RX_11GN_SOFT_DEMAP_5)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_SOFT_DEMAP_5)) & 0xffff80ff))
#define SET_RG_ATCOR16_CNT_PLUS_LMT2(_VAL_) (REG32(ADR_RX_11GN_SYM_BOUND_0)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_SYM_BOUND_0)) & 0xffffff80))
#define SET_RG_ATCOR16_CNT_PLUS_LMT1(_VAL_) (REG32(ADR_RX_11GN_SYM_BOUND_0)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_SYM_BOUND_0)) & 0xffff80ff))
#define SET_RG_SYM_BOUND_METHOD(_VAL_) (REG32(ADR_RX_11GN_SYM_BOUND_0)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_SYM_BOUND_0)) & 0xfffcffff))
#define SET_RG_PWRON_DLY_TH_11GN(_VAL_) (REG32(ADR_RX_11GN_SYM_BOUND_1)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_SYM_BOUND_1)) & 0xffffff00))
#define SET_RG_SB_START_CNT(_VAL_) (REG32(ADR_RX_11GN_SYM_BOUND_1)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_SYM_BOUND_1)) & 0xffff80ff))
#define SET_RG_POW16_CNT_TH(_VAL_) (REG32(ADR_RX_11GN_CCA_PWR)) = (((_VAL_) << 4) | ((REG32(ADR_RX_11GN_CCA_PWR)) & 0xffffff0f))
#define SET_RG_POW16_SHORT_CNT_LMT(_VAL_) (REG32(ADR_RX_11GN_CCA_PWR)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_CCA_PWR)) & 0xfffff8ff))
#define SET_RG_POW16_TH_L(_VAL_) (REG32(ADR_RX_11GN_CCA_PWR)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_CCA_PWR)) & 0x80ffffff))
#define SET_RG_XSCOR16_SHORT_CNT_LMT(_VAL_) (REG32(ADR_RX_11GN_CCA_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_CCA_CNT)) & 0xfffffff8))
#define SET_RG_XSCOR16_RATIO(_VAL_) (REG32(ADR_RX_11GN_CCA_CNT)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_CCA_CNT)) & 0xffff80ff))
#define SET_RG_ATCOR16_SHORT_CNT_LMT(_VAL_) (REG32(ADR_RX_11GN_CCA_CNT)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_CCA_CNT)) & 0xfff8ffff))
#define SET_RG_ATCOR16_RATIO_CCD(_VAL_) (REG32(ADR_RX_11GN_CCA_CNT)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_CCA_CNT)) & 0x80ffffff))
#define SET_RG_ATCOR64_ACC_LMT(_VAL_) (REG32(ADR_RX_11GN_CCA_ATCOR_RE_CHECK)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_CCA_ATCOR_RE_CHECK)) & 0xffffff80))
#define SET_RG_ATCOR16_SHORT_CNT_LMT2(_VAL_) (REG32(ADR_RX_11GN_CCA_ATCOR_RE_CHECK)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_CCA_ATCOR_RE_CHECK)) & 0xfff8ffff))
#define SET_RG_VITERBI_TB_BITS(_VAL_) (REG32(ADR_RX_11GN_VTB_TB)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_VTB_TB)) & 0x00ffffff))
#define SET_RG_CR_CNT_UPDATE(_VAL_) (REG32(ADR_RX_11GN_ERR_UPDATE)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_ERR_UPDATE)) & 0xffffff00))
#define SET_RG_TR_CNT_UPDATE(_VAL_) (REG32(ADR_RX_11GN_ERR_UPDATE)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_ERR_UPDATE)) & 0xff00ffff))
#define SET_RG_BYPASS_CPE_MA(_VAL_) (REG32(ADR_RX_11GN_SHORT_GI)) = (((_VAL_) << 4) | ((REG32(ADR_RX_11GN_SHORT_GI)) & 0xffffffef))
#define SET_RG_PILOT_BNDRY_SHIFT(_VAL_) (REG32(ADR_RX_11GN_SHORT_GI)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_SHORT_GI)) & 0xfffff8ff))
#define SET_RG_EQ_SHORT_GI_SHIFT(_VAL_) (REG32(ADR_RX_11GN_SHORT_GI)) = (((_VAL_) << 12) | ((REG32(ADR_RX_11GN_SHORT_GI)) & 0xffff8fff))
#define SET_RG_FFT_WDW_SHORT_SHIFT(_VAL_) (REG32(ADR_RX_11GN_SHORT_GI)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_SHORT_GI)) & 0xfff8ffff))
#define SET_RG_CHSMTH_COEF(_VAL_) (REG32(ADR_RX_11GN_CHANNEL_UPDATE)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_CHANNEL_UPDATE)) & 0xfffcffff))
#define SET_RG_CHSMTH_EN(_VAL_) (REG32(ADR_RX_11GN_CHANNEL_UPDATE)) = (((_VAL_) << 18) | ((REG32(ADR_RX_11GN_CHANNEL_UPDATE)) & 0xfffbffff))
#define SET_RG_CHEST_DD_FACTOR(_VAL_) (REG32(ADR_RX_11GN_CHANNEL_UPDATE)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_CHANNEL_UPDATE)) & 0xf8ffffff))
#define SET_RG_CH_UPDATE(_VAL_) (REG32(ADR_RX_11GN_CHANNEL_UPDATE)) = (((_VAL_) << 31) | ((REG32(ADR_RX_11GN_CHANNEL_UPDATE)) & 0x7fffffff))
#define SET_RG_FMT_DET_MM_TH(_VAL_) (REG32(ADR_RX_11GN_PKT_FORMAT_0)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_PKT_FORMAT_0)) & 0xffffff00))
#define SET_RG_FMT_DET_GF_TH(_VAL_) (REG32(ADR_RX_11GN_PKT_FORMAT_0)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_PKT_FORMAT_0)) & 0xffff00ff))
#define SET_RG_DO_NOT_CHECK_L_RATE(_VAL_) (REG32(ADR_RX_11GN_PKT_FORMAT_0)) = (((_VAL_) << 25) | ((REG32(ADR_RX_11GN_PKT_FORMAT_0)) & 0xfdffffff))
#define SET_RG_FMT_DET_LENGTH_TH(_VAL_) (REG32(ADR_RX_11GN_PKT_FORMAT_1)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_PKT_FORMAT_1)) & 0xffff0000))
#define SET_RG_L_LENGTH_MAX(_VAL_) (REG32(ADR_RX_11GN_PKT_FORMAT_1)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_PKT_FORMAT_1)) & 0x0000ffff))
#define SET_RG_TX_TIME_EXT(_VAL_) (REG32(ADR_RX_11GN_TX_TIME)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_TX_TIME)) & 0xffffff00))
#define SET_RG_MAC_DES_SPACE(_VAL_) (REG32(ADR_RX_11GN_TX_TIME)) = (((_VAL_) << 20) | ((REG32(ADR_RX_11GN_TX_TIME)) & 0xff0fffff))
#define SET_RG_TR_LPF_STBC_GF_KI_G(_VAL_) (REG32(ADR_RX_11GN_STBC_TR_KP_KI)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_STBC_TR_KP_KI)) & 0xfffffff0))
#define SET_RG_TR_LPF_STBC_GF_KP_G(_VAL_) (REG32(ADR_RX_11GN_STBC_TR_KP_KI)) = (((_VAL_) << 4) | ((REG32(ADR_RX_11GN_STBC_TR_KP_KI)) & 0xffffff0f))
#define SET_RG_TR_LPF_STBC_MF_KI_G(_VAL_) (REG32(ADR_RX_11GN_STBC_TR_KP_KI)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_STBC_TR_KP_KI)) & 0xfffff0ff))
#define SET_RG_TR_LPF_STBC_MF_KP_G(_VAL_) (REG32(ADR_RX_11GN_STBC_TR_KP_KI)) = (((_VAL_) << 12) | ((REG32(ADR_RX_11GN_STBC_TR_KP_KI)) & 0xffff0fff))
#define SET_RG_MODE_REG_IN_80(_VAL_) (REG32(ADR_RX_11GN_BIST_0)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_BIST_0)) & 0xfffe0000))
#define SET_RG_PARALLEL_DR_80(_VAL_) (REG32(ADR_RX_11GN_BIST_0)) = (((_VAL_) << 20) | ((REG32(ADR_RX_11GN_BIST_0)) & 0xffefffff))
#define SET_RG_MBRUN_80(_VAL_) (REG32(ADR_RX_11GN_BIST_0)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_BIST_0)) & 0xfeffffff))
#define SET_RG_SHIFT_DR_80(_VAL_) (REG32(ADR_RX_11GN_BIST_0)) = (((_VAL_) << 28) | ((REG32(ADR_RX_11GN_BIST_0)) & 0xefffffff))
#define SET_RG_MODE_REG_SI_80(_VAL_) (REG32(ADR_RX_11GN_BIST_0)) = (((_VAL_) << 29) | ((REG32(ADR_RX_11GN_BIST_0)) & 0xdfffffff))
#define SET_RG_SIMULATION_MODE_80(_VAL_) (REG32(ADR_RX_11GN_BIST_0)) = (((_VAL_) << 30) | ((REG32(ADR_RX_11GN_BIST_0)) & 0xbfffffff))
#define SET_RG_DBIST_MODE_80(_VAL_) (REG32(ADR_RX_11GN_BIST_0)) = (((_VAL_) << 31) | ((REG32(ADR_RX_11GN_BIST_0)) & 0x7fffffff))
#define SET_RG_MODE_REG_IN_64(_VAL_) (REG32(ADR_RX_11GN_BIST_1)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_BIST_1)) & 0xffff0000))
#define SET_RG_PARALLEL_DR_64(_VAL_) (REG32(ADR_RX_11GN_BIST_1)) = (((_VAL_) << 20) | ((REG32(ADR_RX_11GN_BIST_1)) & 0xffefffff))
#define SET_RG_MBRUN_64(_VAL_) (REG32(ADR_RX_11GN_BIST_1)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_BIST_1)) & 0xfeffffff))
#define SET_RG_SHIFT_DR_64(_VAL_) (REG32(ADR_RX_11GN_BIST_1)) = (((_VAL_) << 28) | ((REG32(ADR_RX_11GN_BIST_1)) & 0xefffffff))
#define SET_RG_MODE_REG_SI_64(_VAL_) (REG32(ADR_RX_11GN_BIST_1)) = (((_VAL_) << 29) | ((REG32(ADR_RX_11GN_BIST_1)) & 0xdfffffff))
#define SET_RG_SIMULATION_MODE_64(_VAL_) (REG32(ADR_RX_11GN_BIST_1)) = (((_VAL_) << 30) | ((REG32(ADR_RX_11GN_BIST_1)) & 0xbfffffff))
#define SET_RG_DBIST_MODE_64(_VAL_) (REG32(ADR_RX_11GN_BIST_1)) = (((_VAL_) << 31) | ((REG32(ADR_RX_11GN_BIST_1)) & 0x7fffffff))
#define SET_RO_MODE_REG_OUT_80(_VAL_) (REG32(ADR_RX_11GN_BIST_2)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_BIST_2)) & 0xfffe0000))
#define SET_RO_MODE_REG_SO_80(_VAL_) (REG32(ADR_RX_11GN_BIST_2)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_BIST_2)) & 0xfeffffff))
#define SET_RO_MONITOR_BUS_80(_VAL_) (REG32(ADR_RX_11GN_BIST_3)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_BIST_3)) & 0xffc00000))
#define SET_RO_MODE_REG_OUT_64(_VAL_) (REG32(ADR_RX_11GN_BIST_4)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_BIST_4)) & 0xffff0000))
#define SET_RO_MODE_REG_SO_64(_VAL_) (REG32(ADR_RX_11GN_BIST_4)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_BIST_4)) & 0xfeffffff))
#define SET_RO_MONITOR_BUS_64(_VAL_) (REG32(ADR_RX_11GN_BIST_5)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_BIST_5)) & 0xfff80000))
#define SET_RO_SPECTRUM_DATA(_VAL_) (REG32(ADR_RX_11GN_SPECTRUM_ANALYZER)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_SPECTRUM_ANALYZER)) & 0x00000000))
#define SET_GN_SNR(_VAL_) (REG32(ADR_RX_11GN_READ_0)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_READ_0)) & 0xffffff80))
#define SET_GN_NOISE_PWR(_VAL_) (REG32(ADR_RX_11GN_READ_0)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_READ_0)) & 0xffff80ff))
#define SET_GN_RCPI(_VAL_) (REG32(ADR_RX_11GN_READ_0)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_READ_0)) & 0xff80ffff))
#define SET_GN_SIGNAL_PWR(_VAL_) (REG32(ADR_RX_11GN_READ_0)) = (((_VAL_) << 24) | ((REG32(ADR_RX_11GN_READ_0)) & 0x80ffffff))
#define SET_RO_FREQ_OS_LTS(_VAL_) (REG32(ADR_RX_11GN_FREQ_OFFSET)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_FREQ_OFFSET)) & 0xffff8000))
#define SET_CSTATE(_VAL_) (REG32(ADR_RX_11GN_FREQ_OFFSET)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_FREQ_OFFSET)) & 0xfff0ffff))
#define SET_SIGNAL_FIELD0(_VAL_) (REG32(ADR_RX_11GN_SIGNAL_FIELD_0)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_SIGNAL_FIELD_0)) & 0xff000000))
#define SET_SIGNAL_FIELD1(_VAL_) (REG32(ADR_RX_11GN_SIGNAL_FIELD_1)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_SIGNAL_FIELD_1)) & 0xff000000))
#define SET_GN_PACKET_ERR_CNT(_VAL_) (REG32(ADR_RX_11GN_PKT_ERR_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_PKT_ERR_CNT)) & 0xffff0000))
#define SET_GN_PACKET_CNT(_VAL_) (REG32(ADR_RX_11GN_PKT_CCA_AND_PKT_CNT)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_PKT_CCA_AND_PKT_CNT)) & 0xffff0000))
#define SET_GN_CCA_CNT(_VAL_) (REG32(ADR_RX_11GN_PKT_CCA_AND_PKT_CNT)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_PKT_CCA_AND_PKT_CNT)) & 0x0000ffff))
#define SET_GN_LENGTH_FIELD(_VAL_) (REG32(ADR_RX_11GN_SERVICE_LENGTH_FIELD)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_SERVICE_LENGTH_FIELD)) & 0xffff0000))
#define SET_GN_SERVICE_FIELD(_VAL_) (REG32(ADR_RX_11GN_SERVICE_LENGTH_FIELD)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_SERVICE_LENGTH_FIELD)) & 0x0000ffff))
#define SET_RO_HT_MCS_40M(_VAL_) (REG32(ADR_RX_11GN_RATE)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_RATE)) & 0xffffff80))
#define SET_RO_L_RATE_40M(_VAL_) (REG32(ADR_RX_11GN_RATE)) = (((_VAL_) << 8) | ((REG32(ADR_RX_11GN_RATE)) & 0xffffc0ff))
#define SET_RG_DAGC_CNT_TH(_VAL_) (REG32(ADR_RX_11GN_STAT_EN)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_STAT_EN)) & 0xfffffffc))
#define SET_RG_PACKET_STAT_EN_11GN(_VAL_) (REG32(ADR_RX_11GN_STAT_EN)) = (((_VAL_) << 20) | ((REG32(ADR_RX_11GN_STAT_EN)) & 0xffefffff))
#define SET_RX_PHY_11GN_SOFT_RST_N(_VAL_) (REG32(ADR_RX_11GN_SOFT_RST)) = (((_VAL_) << 0) | ((REG32(ADR_RX_11GN_SOFT_RST)) & 0xfffffffe))
#define SET_RG_RIFS_EN(_VAL_) (REG32(ADR_RX_11GN_SOFT_RST)) = (((_VAL_) << 1) | ((REG32(ADR_RX_11GN_SOFT_RST)) & 0xfffffffd))
#define SET_RG_STBC_EN(_VAL_) (REG32(ADR_RX_11GN_SOFT_RST)) = (((_VAL_) << 2) | ((REG32(ADR_RX_11GN_SOFT_RST)) & 0xfffffffb))
#define SET_RG_COR_SEL(_VAL_) (REG32(ADR_RX_11GN_SOFT_RST)) = (((_VAL_) << 3) | ((REG32(ADR_RX_11GN_SOFT_RST)) & 0xfffffff7))
#define SET_RG_INI_PHASE(_VAL_) (REG32(ADR_RX_11GN_SOFT_RST)) = (((_VAL_) << 4) | ((REG32(ADR_RX_11GN_SOFT_RST)) & 0xffffffcf))
#define SET_RG_HT_LTF_SEL_EQ(_VAL_) (REG32(ADR_RX_11GN_SOFT_RST)) = (((_VAL_) << 6) | ((REG32(ADR_RX_11GN_SOFT_RST)) & 0xffffffbf))
#define SET_RG_HT_LTF_SEL_PILOT(_VAL_) (REG32(ADR_RX_11GN_SOFT_RST)) = (((_VAL_) << 7) | ((REG32(ADR_RX_11GN_SOFT_RST)) & 0xffffff7f))
#define SET_RG_CCA_PWR_SEL(_VAL_) (REG32(ADR_RX_11GN_SOFT_RST)) = (((_VAL_) << 9) | ((REG32(ADR_RX_11GN_SOFT_RST)) & 0xfffffdff))
#define SET_RG_CCA_XSCOR_PWR_SEL(_VAL_) (REG32(ADR_RX_11GN_SOFT_RST)) = (((_VAL_) << 10) | ((REG32(ADR_RX_11GN_SOFT_RST)) & 0xfffffbff))
#define SET_RG_CCA_XSCOR_AVGPWR_SEL(_VAL_) (REG32(ADR_RX_11GN_SOFT_RST)) = (((_VAL_) << 11) | ((REG32(ADR_RX_11GN_SOFT_RST)) & 0xfffff7ff))
#define SET_RG_DEBUG_SEL(_VAL_) (REG32(ADR_RX_11GN_SOFT_RST)) = (((_VAL_) << 12) | ((REG32(ADR_RX_11GN_SOFT_RST)) & 0xffff0fff))
#define SET_RG_POST_CLK_EN(_VAL_) (REG32(ADR_RX_11GN_SOFT_RST)) = (((_VAL_) << 16) | ((REG32(ADR_RX_11GN_SOFT_RST)) & 0xfffeffff))
#define SET_IQCAL_RF_TX_EN(_VAL_) (REG32(ADR_RF_CONTROL_0)) = (((_VAL_) << 0) | ((REG32(ADR_RF_CONTROL_0)) & 0xfffffffe))
#define SET_IQCAL_RF_TX_PA_EN(_VAL_) (REG32(ADR_RF_CONTROL_0)) = (((_VAL_) << 1) | ((REG32(ADR_RF_CONTROL_0)) & 0xfffffffd))
#define SET_IQCAL_RF_TX_DAC_EN(_VAL_) (REG32(ADR_RF_CONTROL_0)) = (((_VAL_) << 2) | ((REG32(ADR_RF_CONTROL_0)) & 0xfffffffb))
#define SET_IQCAL_RF_RX_AGC(_VAL_) (REG32(ADR_RF_CONTROL_0)) = (((_VAL_) << 3) | ((REG32(ADR_RF_CONTROL_0)) & 0xfffffff7))
#define SET_IQCAL_RF_PGAG(_VAL_) (REG32(ADR_RF_CONTROL_0)) = (((_VAL_) << 8) | ((REG32(ADR_RF_CONTROL_0)) & 0xfffff0ff))
#define SET_IQCAL_RF_RFG(_VAL_) (REG32(ADR_RF_CONTROL_0)) = (((_VAL_) << 12) | ((REG32(ADR_RF_CONTROL_0)) & 0xffffcfff))
#define SET_RG_TONEGEN_FREQ(_VAL_) (REG32(ADR_RF_CONTROL_0)) = (((_VAL_) << 16) | ((REG32(ADR_RF_CONTROL_0)) & 0xff80ffff))
#define SET_RG_TONEGEN_EN(_VAL_) (REG32(ADR_RF_CONTROL_0)) = (((_VAL_) << 23) | ((REG32(ADR_RF_CONTROL_0)) & 0xff7fffff))
#define SET_RG_TONEGEN_INIT_PH(_VAL_) (REG32(ADR_RF_CONTROL_0)) = (((_VAL_) << 24) | ((REG32(ADR_RF_CONTROL_0)) & 0x80ffffff))
#define SET_RG_TONEGEN2_FREQ(_VAL_) (REG32(ADR_RF_CONTROL_1)) = (((_VAL_) << 0) | ((REG32(ADR_RF_CONTROL_1)) & 0xffffff80))
#define SET_RG_TONEGEN2_EN(_VAL_) (REG32(ADR_RF_CONTROL_1)) = (((_VAL_) << 7) | ((REG32(ADR_RF_CONTROL_1)) & 0xffffff7f))
#define SET_RG_TONEGEN2_SCALE(_VAL_) (REG32(ADR_RF_CONTROL_1)) = (((_VAL_) << 8) | ((REG32(ADR_RF_CONTROL_1)) & 0xffff00ff))
#define SET_RG_TXIQ_CLP_THD_I(_VAL_) (REG32(ADR_TX_IQ_CONTROL_0)) = (((_VAL_) << 0) | ((REG32(ADR_TX_IQ_CONTROL_0)) & 0xfffffc00))
#define SET_RG_TXIQ_CLP_THD_Q(_VAL_) (REG32(ADR_TX_IQ_CONTROL_0)) = (((_VAL_) << 16) | ((REG32(ADR_TX_IQ_CONTROL_0)) & 0xfc00ffff))
#define SET_RG_TX_I_SCALE(_VAL_) (REG32(ADR_TX_IQ_CONTROL_1)) = (((_VAL_) << 0) | ((REG32(ADR_TX_IQ_CONTROL_1)) & 0xffffff00))
#define SET_RG_TX_Q_SCALE(_VAL_) (REG32(ADR_TX_IQ_CONTROL_1)) = (((_VAL_) << 8) | ((REG32(ADR_TX_IQ_CONTROL_1)) & 0xffff00ff))
#define SET_RG_TX_IQ_SWP(_VAL_) (REG32(ADR_TX_IQ_CONTROL_1)) = (((_VAL_) << 16) | ((REG32(ADR_TX_IQ_CONTROL_1)) & 0xfffeffff))
#define SET_RG_TX_SGN_OUT(_VAL_) (REG32(ADR_TX_IQ_CONTROL_1)) = (((_VAL_) << 17) | ((REG32(ADR_TX_IQ_CONTROL_1)) & 0xfffdffff))
#define SET_RG_TXIQ_EMU_IDX(_VAL_) (REG32(ADR_TX_IQ_CONTROL_1)) = (((_VAL_) << 18) | ((REG32(ADR_TX_IQ_CONTROL_1)) & 0xffc3ffff))
#define SET_RG_TX_IQ_SRC(_VAL_) (REG32(ADR_TX_IQ_CONTROL_1)) = (((_VAL_) << 24) | ((REG32(ADR_TX_IQ_CONTROL_1)) & 0xfcffffff))
#define SET_RG_TX_I_DC(_VAL_) (REG32(ADR_TX_IQ_CONTROL_2)) = (((_VAL_) << 0) | ((REG32(ADR_TX_IQ_CONTROL_2)) & 0xfffffc00))
#define SET_RG_TX_Q_DC(_VAL_) (REG32(ADR_TX_IQ_CONTROL_2)) = (((_VAL_) << 16) | ((REG32(ADR_TX_IQ_CONTROL_2)) & 0xfc00ffff))
#define SET_RG_TX_IQ_THETA(_VAL_) (REG32(ADR_TX_COMPENSATION_CONTROL)) = (((_VAL_) << 0) | ((REG32(ADR_TX_COMPENSATION_CONTROL)) & 0xffffffe0))
#define SET_RG_TX_IQ_ALPHA(_VAL_) (REG32(ADR_TX_COMPENSATION_CONTROL)) = (((_VAL_) << 8) | ((REG32(ADR_TX_COMPENSATION_CONTROL)) & 0xffffe0ff))
#define SET_RG_TXIQ_NOSHRINK(_VAL_) (REG32(ADR_TX_COMPENSATION_CONTROL)) = (((_VAL_) << 13) | ((REG32(ADR_TX_COMPENSATION_CONTROL)) & 0xffffdfff))
#define SET_RG_TX_I_OFFSET(_VAL_) (REG32(ADR_TX_COMPENSATION_CONTROL)) = (((_VAL_) << 16) | ((REG32(ADR_TX_COMPENSATION_CONTROL)) & 0xff00ffff))
#define SET_RG_TX_Q_OFFSET(_VAL_) (REG32(ADR_TX_COMPENSATION_CONTROL)) = (((_VAL_) << 24) | ((REG32(ADR_TX_COMPENSATION_CONTROL)) & 0x00ffffff))
#define SET_RG_RX_IQ_THETA(_VAL_) (REG32(ADR_RX_COMPENSATION_CONTROL)) = (((_VAL_) << 0) | ((REG32(ADR_RX_COMPENSATION_CONTROL)) & 0xffffffe0))
#define SET_RG_RX_IQ_ALPHA(_VAL_) (REG32(ADR_RX_COMPENSATION_CONTROL)) = (((_VAL_) << 8) | ((REG32(ADR_RX_COMPENSATION_CONTROL)) & 0xffffe0ff))
#define SET_RG_RXIQ_NOSHRINK(_VAL_) (REG32(ADR_RX_COMPENSATION_CONTROL)) = (((_VAL_) << 13) | ((REG32(ADR_RX_COMPENSATION_CONTROL)) & 0xffffdfff))
#define SET_RG_MA_DPTH(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) = (((_VAL_) << 0) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0xfffffff0))
#define SET_RG_INTG_PH(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) = (((_VAL_) << 4) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0xfffffc0f))
#define SET_RG_INTG_PRD(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) = (((_VAL_) << 10) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0xffffe3ff))
#define SET_RG_INTG_MU(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) = (((_VAL_) << 13) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0xffff9fff))
#define SET_RG_IQCAL_SPRM_SELQ(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) = (((_VAL_) << 16) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0xfffeffff))
#define SET_RG_IQCAL_SPRM_EN(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) = (((_VAL_) << 17) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0xfffdffff))
#define SET_RG_IQCAL_SPRM_FREQ(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) = (((_VAL_) << 18) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0xff03ffff))
#define SET_RG_IQCAL_IQCOL_EN(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) = (((_VAL_) << 24) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0xfeffffff))
#define SET_RG_IQCAL_ALPHA_ESTM_EN(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) = (((_VAL_) << 25) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0xfdffffff))
#define SET_RG_IQCAL_DC_EN(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) = (((_VAL_) << 26) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0xfbffffff))
#define SET_RG_PHEST_STBY(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) = (((_VAL_) << 27) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0xf7ffffff))
#define SET_RG_PHEST_EN(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) = (((_VAL_) << 28) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0xefffffff))
#define SET_RG_GP_DIV_EN(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) = (((_VAL_) << 29) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0xdfffffff))
#define SET_RG_DPD_GAIN_EST_EN(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) = (((_VAL_) << 30) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) & 0xbfffffff))
#define SET_RG_IQCAL_MULT_OP0(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_1)) = (((_VAL_) << 0) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_1)) & 0xfffffc00))
#define SET_RG_IQCAL_MULT_OP1(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_1)) = (((_VAL_) << 16) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_1)) & 0xfc00ffff))
#define SET_RO_IQCAL_O(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) = (((_VAL_) << 0) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0xfff00000))
#define SET_RO_IQCAL_SPRM_RDY(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) = (((_VAL_) << 20) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0xffefffff))
#define SET_RO_IQCAL_IQCOL_RDY(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) = (((_VAL_) << 21) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0xffdfffff))
#define SET_RO_IQCAL_ALPHA_ESTM_RDY(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) = (((_VAL_) << 22) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0xffbfffff))
#define SET_RO_IQCAL_DC_RDY(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) = (((_VAL_) << 23) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0xff7fffff))
#define SET_RO_IQCAL_MULT_RDY(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) = (((_VAL_) << 24) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0xfeffffff))
#define SET_RO_FFT_ENRG_RDY(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) = (((_VAL_) << 25) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0xfdffffff))
#define SET_RO_PHEST_RDY(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) = (((_VAL_) << 26) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0xfbffffff))
#define SET_RO_GP_DIV_RDY(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) = (((_VAL_) << 27) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0xf7ffffff))
#define SET_RO_GAIN_EST_RDY(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) = (((_VAL_) << 28) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) & 0xefffffff))
#define SET_RO_AMP_O(_VAL_) (REG32(ADR_RX_OBSERVATION_CIRCUIT_3)) = (((_VAL_) << 0) | ((REG32(ADR_RX_OBSERVATION_CIRCUIT_3)) & 0xfffffe00))
#define SET_RG_RX_I_SCALE(_VAL_) (REG32(ADR_RF_IQ_CONTROL_0)) = (((_VAL_) << 0) | ((REG32(ADR_RF_IQ_CONTROL_0)) & 0xffffff00))
#define SET_RG_RX_Q_SCALE(_VAL_) (REG32(ADR_RF_IQ_CONTROL_0)) = (((_VAL_) << 8) | ((REG32(ADR_RF_IQ_CONTROL_0)) & 0xffff00ff))
#define SET_RG_RX_I_OFFSET(_VAL_) (REG32(ADR_RF_IQ_CONTROL_0)) = (((_VAL_) << 16) | ((REG32(ADR_RF_IQ_CONTROL_0)) & 0xff00ffff))
#define SET_RG_RX_Q_OFFSET(_VAL_) (REG32(ADR_RF_IQ_CONTROL_0)) = (((_VAL_) << 24) | ((REG32(ADR_RF_IQ_CONTROL_0)) & 0x00ffffff))
#define SET_RG_RX_IQ_SWP(_VAL_) (REG32(ADR_RF_IQ_CONTROL_1)) = (((_VAL_) << 0) | ((REG32(ADR_RF_IQ_CONTROL_1)) & 0xfffffffe))
#define SET_RG_RX_SGN_IN(_VAL_) (REG32(ADR_RF_IQ_CONTROL_1)) = (((_VAL_) << 1) | ((REG32(ADR_RF_IQ_CONTROL_1)) & 0xfffffffd))
#define SET_RG_RX_IQ_SRC(_VAL_) (REG32(ADR_RF_IQ_CONTROL_1)) = (((_VAL_) << 2) | ((REG32(ADR_RF_IQ_CONTROL_1)) & 0xfffffff3))
#define SET_RG_ACI_GAIN(_VAL_) (REG32(ADR_RF_IQ_CONTROL_1)) = (((_VAL_) << 4) | ((REG32(ADR_RF_IQ_CONTROL_1)) & 0xfffff00f))
#define SET_RG_FFT_EN(_VAL_) (REG32(ADR_RF_IQ_CONTROL_1)) = (((_VAL_) << 12) | ((REG32(ADR_RF_IQ_CONTROL_1)) & 0xffffefff))
#define SET_RG_FFT_MOD(_VAL_) (REG32(ADR_RF_IQ_CONTROL_1)) = (((_VAL_) << 13) | ((REG32(ADR_RF_IQ_CONTROL_1)) & 0xffffdfff))
#define SET_RG_FFT_SCALE(_VAL_) (REG32(ADR_RF_IQ_CONTROL_1)) = (((_VAL_) << 14) | ((REG32(ADR_RF_IQ_CONTROL_1)) & 0xff003fff))
#define SET_RG_FFT_ENRG_FREQ(_VAL_) (REG32(ADR_RF_IQ_CONTROL_1)) = (((_VAL_) << 24) | ((REG32(ADR_RF_IQ_CONTROL_1)) & 0xc0ffffff))
#define SET_RG_FPGA_80M_PH_UP(_VAL_) (REG32(ADR_RF_IQ_CONTROL_1)) = (((_VAL_) << 30) | ((REG32(ADR_RF_IQ_CONTROL_1)) & 0xbfffffff))
#define SET_RG_FPGA_80M_PH_STP(_VAL_) (REG32(ADR_RF_IQ_CONTROL_1)) = (((_VAL_) << 31) | ((REG32(ADR_RF_IQ_CONTROL_1)) & 0x7fffffff))
#define SET_RG_ADC2LA_SEL(_VAL_) (REG32(ADR_RF_IQ_CONTROL_2)) = (((_VAL_) << 0) | ((REG32(ADR_RF_IQ_CONTROL_2)) & 0xfffffffe))
#define SET_RG_ADC2LA_CLKPH(_VAL_) (REG32(ADR_RF_IQ_CONTROL_2)) = (((_VAL_) << 1) | ((REG32(ADR_RF_IQ_CONTROL_2)) & 0xfffffffd))
#define SET_RG_RXIQ_EMU_IDX(_VAL_) (REG32(ADR_RF_IQ_CONTROL_3)) = (((_VAL_) << 0) | ((REG32(ADR_RF_IQ_CONTROL_3)) & 0xfffffff0))
#define SET_RG_IQCAL_BP_ACI(_VAL_) (REG32(ADR_RF_IQ_CONTROL_3)) = (((_VAL_) << 4) | ((REG32(ADR_RF_IQ_CONTROL_3)) & 0xffffffef))
#define SET_RG_DPD_AM_EN(_VAL_) (REG32(ADR_DPD_CONTROL)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_CONTROL)) & 0xfffffffe))
#define SET_RG_DPD_PM_EN(_VAL_) (REG32(ADR_DPD_CONTROL)) = (((_VAL_) << 1) | ((REG32(ADR_DPD_CONTROL)) & 0xfffffffd))
#define SET_RG_DPD_PM_AMSEL(_VAL_) (REG32(ADR_DPD_CONTROL)) = (((_VAL_) << 2) | ((REG32(ADR_DPD_CONTROL)) & 0xfffffffb))
#define SET_RG_DPD_020_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_0)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_GAIN_TABLE_0)) & 0xfffffc00))
#define SET_RG_DPD_040_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_0)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_GAIN_TABLE_0)) & 0xfc00ffff))
#define SET_RG_DPD_060_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_1)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_GAIN_TABLE_1)) & 0xfffffc00))
#define SET_RG_DPD_080_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_1)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_GAIN_TABLE_1)) & 0xfc00ffff))
#define SET_RG_DPD_0A0_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_2)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_GAIN_TABLE_2)) & 0xfffffc00))
#define SET_RG_DPD_0C0_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_2)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_GAIN_TABLE_2)) & 0xfc00ffff))
#define SET_RG_DPD_0D0_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_3)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_GAIN_TABLE_3)) & 0xfffffc00))
#define SET_RG_DPD_0E0_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_3)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_GAIN_TABLE_3)) & 0xfc00ffff))
#define SET_RG_DPD_0F0_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_4)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_GAIN_TABLE_4)) & 0xfffffc00))
#define SET_RG_DPD_100_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_4)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_GAIN_TABLE_4)) & 0xfc00ffff))
#define SET_RG_DPD_110_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_5)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_GAIN_TABLE_5)) & 0xfffffc00))
#define SET_RG_DPD_120_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_5)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_GAIN_TABLE_5)) & 0xfc00ffff))
#define SET_RG_DPD_130_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_6)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_GAIN_TABLE_6)) & 0xfffffc00))
#define SET_RG_DPD_140_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_6)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_GAIN_TABLE_6)) & 0xfc00ffff))
#define SET_RG_DPD_150_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_7)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_GAIN_TABLE_7)) & 0xfffffc00))
#define SET_RG_DPD_160_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_7)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_GAIN_TABLE_7)) & 0xfc00ffff))
#define SET_RG_DPD_170_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_8)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_GAIN_TABLE_8)) & 0xfffffc00))
#define SET_RG_DPD_180_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_8)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_GAIN_TABLE_8)) & 0xfc00ffff))
#define SET_RG_DPD_190_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_9)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_GAIN_TABLE_9)) & 0xfffffc00))
#define SET_RG_DPD_1A0_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_9)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_GAIN_TABLE_9)) & 0xfc00ffff))
#define SET_RG_DPD_1B0_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_A)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_GAIN_TABLE_A)) & 0xfffffc00))
#define SET_RG_DPD_1C0_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_A)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_GAIN_TABLE_A)) & 0xfc00ffff))
#define SET_RG_DPD_1D0_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_B)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_GAIN_TABLE_B)) & 0xfffffc00))
#define SET_RG_DPD_1E0_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_B)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_GAIN_TABLE_B)) & 0xfc00ffff))
#define SET_RG_DPD_1F0_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_C)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_GAIN_TABLE_C)) & 0xfffffc00))
#define SET_RG_DPD_200_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_TABLE_C)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_GAIN_TABLE_C)) & 0xfc00ffff))
#define SET_RG_DPD_020_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_0)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_PH_TABLE_0)) & 0xffffe000))
#define SET_RG_DPD_040_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_0)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_PH_TABLE_0)) & 0xe000ffff))
#define SET_RG_DPD_060_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_1)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_PH_TABLE_1)) & 0xffffe000))
#define SET_RG_DPD_080_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_1)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_PH_TABLE_1)) & 0xe000ffff))
#define SET_RG_DPD_0A0_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_2)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_PH_TABLE_2)) & 0xffffe000))
#define SET_RG_DPD_0C0_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_2)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_PH_TABLE_2)) & 0xe000ffff))
#define SET_RG_DPD_0D0_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_3)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_PH_TABLE_3)) & 0xffffe000))
#define SET_RG_DPD_0E0_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_3)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_PH_TABLE_3)) & 0xe000ffff))
#define SET_RG_DPD_0F0_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_4)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_PH_TABLE_4)) & 0xffffe000))
#define SET_RG_DPD_100_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_4)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_PH_TABLE_4)) & 0xe000ffff))
#define SET_RG_DPD_110_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_5)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_PH_TABLE_5)) & 0xffffe000))
#define SET_RG_DPD_120_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_5)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_PH_TABLE_5)) & 0xe000ffff))
#define SET_RG_DPD_130_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_6)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_PH_TABLE_6)) & 0xffffe000))
#define SET_RG_DPD_140_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_6)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_PH_TABLE_6)) & 0xe000ffff))
#define SET_RG_DPD_150_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_7)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_PH_TABLE_7)) & 0xffffe000))
#define SET_RG_DPD_160_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_7)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_PH_TABLE_7)) & 0xe000ffff))
#define SET_RG_DPD_170_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_8)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_PH_TABLE_8)) & 0xffffe000))
#define SET_RG_DPD_180_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_8)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_PH_TABLE_8)) & 0xe000ffff))
#define SET_RG_DPD_190_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_9)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_PH_TABLE_9)) & 0xffffe000))
#define SET_RG_DPD_1A0_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_9)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_PH_TABLE_9)) & 0xe000ffff))
#define SET_RG_DPD_1B0_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_A)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_PH_TABLE_A)) & 0xffffe000))
#define SET_RG_DPD_1C0_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_A)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_PH_TABLE_A)) & 0xe000ffff))
#define SET_RG_DPD_1D0_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_B)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_PH_TABLE_B)) & 0xffffe000))
#define SET_RG_DPD_1E0_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_B)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_PH_TABLE_B)) & 0xe000ffff))
#define SET_RG_DPD_1F0_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_C)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_PH_TABLE_C)) & 0xffffe000))
#define SET_RG_DPD_200_PH(_VAL_) (REG32(ADR_DPD_PH_TABLE_C)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_PH_TABLE_C)) & 0xe000ffff))
#define SET_RG_DPD_GAIN_EST_Y0(_VAL_) (REG32(ADR_DPD_GAIN_ESTIMATION_0)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_GAIN_ESTIMATION_0)) & 0xfffffe00))
#define SET_RG_DPD_GAIN_EST_Y1(_VAL_) (REG32(ADR_DPD_GAIN_ESTIMATION_0)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_GAIN_ESTIMATION_0)) & 0xfe00ffff))
#define SET_RG_DPD_LOOP_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_ESTIMATION_1)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_GAIN_ESTIMATION_1)) & 0xfffffc00))
#define SET_RG_DPD_GAIN_EST_X0(_VAL_) (REG32(ADR_DPD_GAIN_ESTIMATION_2)) = (((_VAL_) << 0) | ((REG32(ADR_DPD_GAIN_ESTIMATION_2)) & 0xfffffe00))
#define SET_RO_DPD_GAIN(_VAL_) (REG32(ADR_DPD_GAIN_ESTIMATION_2)) = (((_VAL_) << 16) | ((REG32(ADR_DPD_GAIN_ESTIMATION_2)) & 0xfc00ffff))
#define SET_TX_SCALE_11B(_VAL_) (REG32(ADR_TX_GAIN_FACTOR)) = (((_VAL_) << 0) | ((REG32(ADR_TX_GAIN_FACTOR)) & 0xffffff00))
#define SET_TX_SCALE_11B_P0D5(_VAL_) (REG32(ADR_TX_GAIN_FACTOR)) = (((_VAL_) << 8) | ((REG32(ADR_TX_GAIN_FACTOR)) & 0xffff00ff))
#define SET_TX_SCALE_11G(_VAL_) (REG32(ADR_TX_GAIN_FACTOR)) = (((_VAL_) << 16) | ((REG32(ADR_TX_GAIN_FACTOR)) & 0xff00ffff))
#define SET_TX_SCALE_11G_P0D5(_VAL_) (REG32(ADR_TX_GAIN_FACTOR)) = (((_VAL_) << 24) | ((REG32(ADR_TX_GAIN_FACTOR)) & 0x00ffffff))
#define SET_RG_EN_MANUAL(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xfffffffe))
#define SET_RG_TX_EN(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 1) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xfffffffd))
#define SET_RG_TX_PA_EN(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 2) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xfffffffb))
#define SET_RG_TX_DAC_EN(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 3) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xfffffff7))
#define SET_RG_RX_AGC(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 4) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xffffffef))
#define SET_RG_RX_GAIN_MANUAL(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 5) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xffffffdf))
#define SET_RG_RFG(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 6) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xffffff3f))
#define SET_RG_PGAG(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 8) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xfffff0ff))
#define SET_RG_MODE(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 12) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xffffcfff))
#define SET_RG_EN_TX_TRSW(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 14) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xffffbfff))
#define SET_RG_EN_SX(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 15) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xffff7fff))
#define SET_RG_EN_RX_LNA(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 16) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xfffeffff))
#define SET_RG_EN_RX_MIXER(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 17) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xfffdffff))
#define SET_RG_EN_RX_DIV2(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 18) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xfffbffff))
#define SET_RG_EN_RX_LOBUF(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 19) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xfff7ffff))
#define SET_RG_EN_RX_TZ(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 20) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xffefffff))
#define SET_RG_EN_RX_FILTER(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 21) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xffdfffff))
#define SET_RG_EN_RX_HPF(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 22) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xffbfffff))
#define SET_RG_EN_RX_RSSI(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 23) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xff7fffff))
#define SET_RG_EN_ADC(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 24) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xfeffffff))
#define SET_RG_EN_TX_MOD(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 25) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xfdffffff))
#define SET_RG_EN_TX_DIV2(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 26) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xfbffffff))
#define SET_RG_EN_TX_DIV2_BUF(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 27) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xf7ffffff))
#define SET_RG_EN_TX_LOBF(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 28) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xefffffff))
#define SET_RG_EN_RX_LOBF(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 29) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xdfffffff))
#define SET_RG_SEL_DPLL_CLK(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 30) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0xbfffffff))
#define SET_RG_EN_CLK_960MBY13_UART(_VAL_) (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (((_VAL_) << 31) | ((REG32(ADR_HARD_WIRE_PIN_REGISTER)) & 0x7fffffff))
#define SET_RG_EN_TX_DPD(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xfffffffe))
#define SET_RG_EN_TX_TSSI(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 1) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xfffffffd))
#define SET_RG_EN_RX_IQCAL(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 2) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xfffffffb))
#define SET_RG_EN_TX_DAC_CAL(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 3) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xfffffff7))
#define SET_RG_EN_TX_SELF_MIXER(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 4) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xffffffef))
#define SET_RG_EN_TX_DAC_OUT(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 5) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xffffffdf))
#define SET_RG_EN_LDO_RX_FE(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 6) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xffffffbf))
#define SET_RG_EN_LDO_ABB(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 7) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xffffff7f))
#define SET_RG_EN_LDO_AFE(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 8) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xfffffeff))
#define SET_RG_EN_SX_CHPLDO(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 9) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xfffffdff))
#define SET_RG_EN_SX_LOBFLDO(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 10) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xfffffbff))
#define SET_RG_EN_IREF_RX(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 11) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xfffff7ff))
#define SET_RG_EN_TX_DAC_VOUT(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 13) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xffffdfff))
#define SET_RG_EN_SX_LCK_BIN(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 14) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xffffbfff))
#define SET_RG_RTC_CAL_MODE(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 16) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xfffeffff))
#define SET_RG_EN_IQPAD_IOSW(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 17) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xfffdffff))
#define SET_RG_EN_TESTPAD_IOSW(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 18) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xfffbffff))
#define SET_RG_EN_TRXBF_BYPASS(_VAL_) (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (((_VAL_) << 19) | ((REG32(ADR_MANUAL_ENABLE_REGISTER)) & 0xfff7ffff))
#define SET_RG_LDO_LEVEL_RX_FE(_VAL_) (REG32(ADR_LDO_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_LDO_REGISTER)) & 0xfffffff8))
#define SET_RG_LDO_LEVEL_ABB(_VAL_) (REG32(ADR_LDO_REGISTER)) = (((_VAL_) << 3) | ((REG32(ADR_LDO_REGISTER)) & 0xffffffc7))
#define SET_RG_LDO_LEVEL_AFE(_VAL_) (REG32(ADR_LDO_REGISTER)) = (((_VAL_) << 6) | ((REG32(ADR_LDO_REGISTER)) & 0xfffffe3f))
#define SET_RG_SX_LDO_CHP_LEVEL(_VAL_) (REG32(ADR_LDO_REGISTER)) = (((_VAL_) << 9) | ((REG32(ADR_LDO_REGISTER)) & 0xfffff1ff))
#define SET_RG_SX_LDO_LOBF_LEVEL(_VAL_) (REG32(ADR_LDO_REGISTER)) = (((_VAL_) << 12) | ((REG32(ADR_LDO_REGISTER)) & 0xffff8fff))
#define SET_RG_SX_LDO_XOSC_LEVEL(_VAL_) (REG32(ADR_LDO_REGISTER)) = (((_VAL_) << 15) | ((REG32(ADR_LDO_REGISTER)) & 0xfffc7fff))
#define SET_RG_DP_LDO_LEVEL(_VAL_) (REG32(ADR_LDO_REGISTER)) = (((_VAL_) << 18) | ((REG32(ADR_LDO_REGISTER)) & 0xffe3ffff))
#define SET_RG_SX_LDO_VCO_LEVEL(_VAL_) (REG32(ADR_LDO_REGISTER)) = (((_VAL_) << 21) | ((REG32(ADR_LDO_REGISTER)) & 0xff1fffff))
#define SET_RG_TX_LDO_TX_LEVEL(_VAL_) (REG32(ADR_LDO_REGISTER)) = (((_VAL_) << 24) | ((REG32(ADR_LDO_REGISTER)) & 0xf8ffffff))
#define SET_RG_EN_RX_PADSW(_VAL_) (REG32(ADR_ABB_REGISTER_1)) = (((_VAL_) << 0) | ((REG32(ADR_ABB_REGISTER_1)) & 0xfffffffe))
#define SET_RG_EN_RX_TESTNODE(_VAL_) (REG32(ADR_ABB_REGISTER_1)) = (((_VAL_) << 1) | ((REG32(ADR_ABB_REGISTER_1)) & 0xfffffffd))
#define SET_RG_RX_ABBCFIX(_VAL_) (REG32(ADR_ABB_REGISTER_1)) = (((_VAL_) << 2) | ((REG32(ADR_ABB_REGISTER_1)) & 0xfffffffb))
#define SET_RG_RX_ABBCTUNE(_VAL_) (REG32(ADR_ABB_REGISTER_1)) = (((_VAL_) << 3) | ((REG32(ADR_ABB_REGISTER_1)) & 0xfffffe07))
#define SET_RG_RX_ABBOUT_TRI_STATE(_VAL_) (REG32(ADR_ABB_REGISTER_1)) = (((_VAL_) << 9) | ((REG32(ADR_ABB_REGISTER_1)) & 0xfffffdff))
#define SET_RG_RX_ABB_N_MODE(_VAL_) (REG32(ADR_ABB_REGISTER_1)) = (((_VAL_) << 10) | ((REG32(ADR_ABB_REGISTER_1)) & 0xfffffbff))
#define SET_RG_RX_EN_LOOPA(_VAL_) (REG32(ADR_ABB_REGISTER_1)) = (((_VAL_) << 11) | ((REG32(ADR_ABB_REGISTER_1)) & 0xfffff7ff))
#define SET_RG_RX_FILTERI1ST(_VAL_) (REG32(ADR_ABB_REGISTER_1)) = (((_VAL_) << 12) | ((REG32(ADR_ABB_REGISTER_1)) & 0xffffcfff))
#define SET_RG_RX_FILTERI2ND(_VAL_) (REG32(ADR_ABB_REGISTER_1)) = (((_VAL_) << 14) | ((REG32(ADR_ABB_REGISTER_1)) & 0xffff3fff))
#define SET_RG_RX_FILTERI3RD(_VAL_) (REG32(ADR_ABB_REGISTER_1)) = (((_VAL_) << 16) | ((REG32(ADR_ABB_REGISTER_1)) & 0xfffcffff))
#define SET_RG_RX_FILTERI_COURSE(_VAL_) (REG32(ADR_ABB_REGISTER_1)) = (((_VAL_) << 18) | ((REG32(ADR_ABB_REGISTER_1)) & 0xfff3ffff))
#define SET_RG_RX_FILTERVCM(_VAL_) (REG32(ADR_ABB_REGISTER_1)) = (((_VAL_) << 20) | ((REG32(ADR_ABB_REGISTER_1)) & 0xffcfffff))
#define SET_RG_RX_HPF3M(_VAL_) (REG32(ADR_ABB_REGISTER_1)) = (((_VAL_) << 22) | ((REG32(ADR_ABB_REGISTER_1)) & 0xffbfffff))
#define SET_RG_RX_HPF300K(_VAL_) (REG32(ADR_ABB_REGISTER_1)) = (((_VAL_) << 23) | ((REG32(ADR_ABB_REGISTER_1)) & 0xff7fffff))
#define SET_RG_RX_HPFI(_VAL_) (REG32(ADR_ABB_REGISTER_1)) = (((_VAL_) << 24) | ((REG32(ADR_ABB_REGISTER_1)) & 0xfcffffff))
#define SET_RG_RX_HPF_FINALCORNER(_VAL_) (REG32(ADR_ABB_REGISTER_1)) = (((_VAL_) << 26) | ((REG32(ADR_ABB_REGISTER_1)) & 0xf3ffffff))
#define SET_RG_RX_HPF_SETTLE1_C(_VAL_) (REG32(ADR_ABB_REGISTER_1)) = (((_VAL_) << 28) | ((REG32(ADR_ABB_REGISTER_1)) & 0xcfffffff))
#define SET_RG_RX_HPF_SETTLE1_R(_VAL_) (REG32(ADR_ABB_REGISTER_2)) = (((_VAL_) << 0) | ((REG32(ADR_ABB_REGISTER_2)) & 0xfffffffc))
#define SET_RG_RX_HPF_SETTLE2_C(_VAL_) (REG32(ADR_ABB_REGISTER_2)) = (((_VAL_) << 2) | ((REG32(ADR_ABB_REGISTER_2)) & 0xfffffff3))
#define SET_RG_RX_HPF_SETTLE2_R(_VAL_) (REG32(ADR_ABB_REGISTER_2)) = (((_VAL_) << 4) | ((REG32(ADR_ABB_REGISTER_2)) & 0xffffffcf))
#define SET_RG_RX_HPF_VCMCON2(_VAL_) (REG32(ADR_ABB_REGISTER_2)) = (((_VAL_) << 6) | ((REG32(ADR_ABB_REGISTER_2)) & 0xffffff3f))
#define SET_RG_RX_HPF_VCMCON(_VAL_) (REG32(ADR_ABB_REGISTER_2)) = (((_VAL_) << 8) | ((REG32(ADR_ABB_REGISTER_2)) & 0xfffffcff))
#define SET_RG_RX_OUTVCM(_VAL_) (REG32(ADR_ABB_REGISTER_2)) = (((_VAL_) << 10) | ((REG32(ADR_ABB_REGISTER_2)) & 0xfffff3ff))
#define SET_RG_RX_TZI(_VAL_) (REG32(ADR_ABB_REGISTER_2)) = (((_VAL_) << 12) | ((REG32(ADR_ABB_REGISTER_2)) & 0xffffcfff))
#define SET_RG_RX_TZ_OUT_TRISTATE(_VAL_) (REG32(ADR_ABB_REGISTER_2)) = (((_VAL_) << 14) | ((REG32(ADR_ABB_REGISTER_2)) & 0xffffbfff))
#define SET_RG_RX_TZ_VCM(_VAL_) (REG32(ADR_ABB_REGISTER_2)) = (((_VAL_) << 15) | ((REG32(ADR_ABB_REGISTER_2)) & 0xfffe7fff))
#define SET_RG_EN_RX_RSSI_TESTNODE(_VAL_) (REG32(ADR_ABB_REGISTER_2)) = (((_VAL_) << 17) | ((REG32(ADR_ABB_REGISTER_2)) & 0xfff1ffff))
#define SET_RG_RX_ADCRSSI_CLKSEL(_VAL_) (REG32(ADR_ABB_REGISTER_2)) = (((_VAL_) << 20) | ((REG32(ADR_ABB_REGISTER_2)) & 0xffefffff))
#define SET_RG_RX_ADCRSSI_VCM(_VAL_) (REG32(ADR_ABB_REGISTER_2)) = (((_VAL_) << 21) | ((REG32(ADR_ABB_REGISTER_2)) & 0xff9fffff))
#define SET_RG_RX_REC_LPFCORNER(_VAL_) (REG32(ADR_ABB_REGISTER_2)) = (((_VAL_) << 23) | ((REG32(ADR_ABB_REGISTER_2)) & 0xfe7fffff))
#define SET_RG_RSSI_CLOCK_GATING(_VAL_) (REG32(ADR_ABB_REGISTER_2)) = (((_VAL_) << 25) | ((REG32(ADR_ABB_REGISTER_2)) & 0xfdffffff))
#define SET_RG_TXPGA_CAPSW(_VAL_) (REG32(ADR_TX_FE_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_TX_FE_REGISTER)) & 0xfffffffc))
#define SET_RG_TXPGA_MAIN(_VAL_) (REG32(ADR_TX_FE_REGISTER)) = (((_VAL_) << 2) | ((REG32(ADR_TX_FE_REGISTER)) & 0xffffff03))
#define SET_RG_TXPGA_STEER(_VAL_) (REG32(ADR_TX_FE_REGISTER)) = (((_VAL_) << 8) | ((REG32(ADR_TX_FE_REGISTER)) & 0xffffc0ff))
#define SET_RG_TXMOD_GMCELL(_VAL_) (REG32(ADR_TX_FE_REGISTER)) = (((_VAL_) << 14) | ((REG32(ADR_TX_FE_REGISTER)) & 0xffff3fff))
#define SET_RG_TXLPF_GMCELL(_VAL_) (REG32(ADR_TX_FE_REGISTER)) = (((_VAL_) << 16) | ((REG32(ADR_TX_FE_REGISTER)) & 0xfffcffff))
#define SET_RG_PACELL_EN(_VAL_) (REG32(ADR_TX_FE_REGISTER)) = (((_VAL_) << 18) | ((REG32(ADR_TX_FE_REGISTER)) & 0xffe3ffff))
#define SET_RG_PABIAS_CTRL(_VAL_) (REG32(ADR_TX_FE_REGISTER)) = (((_VAL_) << 21) | ((REG32(ADR_TX_FE_REGISTER)) & 0xfe1fffff))
#define SET_RG_TX_DIV_VSET(_VAL_) (REG32(ADR_TX_FE_REGISTER)) = (((_VAL_) << 26) | ((REG32(ADR_TX_FE_REGISTER)) & 0xf3ffffff))
#define SET_RG_TX_LOBUF_VSET(_VAL_) (REG32(ADR_TX_FE_REGISTER)) = (((_VAL_) << 28) | ((REG32(ADR_TX_FE_REGISTER)) & 0xcfffffff))
#define SET_RG_RX_SQDC(_VAL_) (REG32(ADR_RX_FE_REGISTER_1)) = (((_VAL_) << 0) | ((REG32(ADR_RX_FE_REGISTER_1)) & 0xfffffff8))
#define SET_RG_RX_DIV2_CORE(_VAL_) (REG32(ADR_RX_FE_REGISTER_1)) = (((_VAL_) << 3) | ((REG32(ADR_RX_FE_REGISTER_1)) & 0xffffffe7))
#define SET_RG_RX_LOBUF(_VAL_) (REG32(ADR_RX_FE_REGISTER_1)) = (((_VAL_) << 5) | ((REG32(ADR_RX_FE_REGISTER_1)) & 0xffffff9f))
#define SET_RG_TX_DPDGM_BIAS(_VAL_) (REG32(ADR_RX_FE_REGISTER_1)) = (((_VAL_) << 7) | ((REG32(ADR_RX_FE_REGISTER_1)) & 0xfffff87f))
#define SET_RG_TX_DPD_DIV(_VAL_) (REG32(ADR_RX_FE_REGISTER_1)) = (((_VAL_) << 11) | ((REG32(ADR_RX_FE_REGISTER_1)) & 0xffff87ff))
#define SET_RG_TX_TSSI_BIAS(_VAL_) (REG32(ADR_RX_FE_REGISTER_1)) = (((_VAL_) << 15) | ((REG32(ADR_RX_FE_REGISTER_1)) & 0xfffc7fff))
#define SET_RG_TX_TSSI_DIV(_VAL_) (REG32(ADR_RX_FE_REGISTER_1)) = (((_VAL_) << 18) | ((REG32(ADR_RX_FE_REGISTER_1)) & 0xffe3ffff))
#define SET_RG_TX_TSSI_TESTMODE(_VAL_) (REG32(ADR_RX_FE_REGISTER_1)) = (((_VAL_) << 21) | ((REG32(ADR_RX_FE_REGISTER_1)) & 0xffdfffff))
#define SET_RG_TX_TSSI_TEST(_VAL_) (REG32(ADR_RX_FE_REGISTER_1)) = (((_VAL_) << 22) | ((REG32(ADR_RX_FE_REGISTER_1)) & 0xff3fffff))
#define SET_RG_PACASCODE_CTRL(_VAL_) (REG32(ADR_RX_FE_REGISTER_1)) = (((_VAL_) << 24) | ((REG32(ADR_RX_FE_REGISTER_1)) & 0xf8ffffff))
#define SET_RG_RX_HG_LNA_GC(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) = (((_VAL_) << 0) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0xfffffffc))
#define SET_RG_RX_HG_LNAHGN_BIAS(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) = (((_VAL_) << 2) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0xffffffc3))
#define SET_RG_RX_HG_LNAHGP_BIAS(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) = (((_VAL_) << 6) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0xfffffc3f))
#define SET_RG_RX_HG_LNALG_BIAS(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) = (((_VAL_) << 10) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0xffffc3ff))
#define SET_RG_RX_HG_TZ_GC(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) = (((_VAL_) << 14) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0xffff3fff))
#define SET_RG_RX_HG_TZ_CAP(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) = (((_VAL_) << 16) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) & 0xfff8ffff))
#define SET_RG_RX_MG_LNA_GC(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) = (((_VAL_) << 0) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0xfffffffc))
#define SET_RG_RX_MG_LNAHGN_BIAS(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) = (((_VAL_) << 2) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0xffffffc3))
#define SET_RG_RX_MG_LNAHGP_BIAS(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) = (((_VAL_) << 6) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0xfffffc3f))
#define SET_RG_RX_MG_LNALG_BIAS(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) = (((_VAL_) << 10) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0xffffc3ff))
#define SET_RG_RX_MG_TZ_GC(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) = (((_VAL_) << 14) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0xffff3fff))
#define SET_RG_RX_MG_TZ_CAP(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) = (((_VAL_) << 16) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) & 0xfff8ffff))
#define SET_RG_RX_LG_LNA_GC(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) = (((_VAL_) << 0) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0xfffffffc))
#define SET_RG_RX_LG_LNAHGN_BIAS(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) = (((_VAL_) << 2) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0xffffffc3))
#define SET_RG_RX_LG_LNAHGP_BIAS(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) = (((_VAL_) << 6) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0xfffffc3f))
#define SET_RG_RX_LG_LNALG_BIAS(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) = (((_VAL_) << 10) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0xffffc3ff))
#define SET_RG_RX_LG_TZ_GC(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) = (((_VAL_) << 14) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0xffff3fff))
#define SET_RG_RX_LG_TZ_CAP(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) = (((_VAL_) << 16) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) & 0xfff8ffff))
#define SET_RG_RX_ULG_LNA_GC(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) = (((_VAL_) << 0) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0xfffffffc))
#define SET_RG_RX_ULG_LNAHGN_BIAS(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) = (((_VAL_) << 2) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0xffffffc3))
#define SET_RG_RX_ULG_LNAHGP_BIAS(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) = (((_VAL_) << 6) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0xfffffc3f))
#define SET_RG_RX_ULG_LNALG_BIAS(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) = (((_VAL_) << 10) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0xffffc3ff))
#define SET_RG_RX_ULG_TZ_GC(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) = (((_VAL_) << 14) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0xffff3fff))
#define SET_RG_RX_ULG_TZ_CAP(_VAL_) (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) = (((_VAL_) << 16) | ((REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) & 0xfff8ffff))
#define SET_RG_HPF1_FAST_SET_X(_VAL_) (REG32(ADR_RX_TX_FSM_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_RX_TX_FSM_REGISTER)) & 0xfffffffe))
#define SET_RG_HPF1_FAST_SET_Y(_VAL_) (REG32(ADR_RX_TX_FSM_REGISTER)) = (((_VAL_) << 1) | ((REG32(ADR_RX_TX_FSM_REGISTER)) & 0xfffffffd))
#define SET_RG_HPF1_FAST_SET_Z(_VAL_) (REG32(ADR_RX_TX_FSM_REGISTER)) = (((_VAL_) << 2) | ((REG32(ADR_RX_TX_FSM_REGISTER)) & 0xfffffffb))
#define SET_RG_HPF_T1A(_VAL_) (REG32(ADR_RX_TX_FSM_REGISTER)) = (((_VAL_) << 3) | ((REG32(ADR_RX_TX_FSM_REGISTER)) & 0xffffffe7))
#define SET_RG_HPF_T1B(_VAL_) (REG32(ADR_RX_TX_FSM_REGISTER)) = (((_VAL_) << 5) | ((REG32(ADR_RX_TX_FSM_REGISTER)) & 0xffffff9f))
#define SET_RG_HPF_T1C(_VAL_) (REG32(ADR_RX_TX_FSM_REGISTER)) = (((_VAL_) << 7) | ((REG32(ADR_RX_TX_FSM_REGISTER)) & 0xfffffe7f))
#define SET_RG_RX_LNA_TRI_SEL(_VAL_) (REG32(ADR_RX_TX_FSM_REGISTER)) = (((_VAL_) << 9) | ((REG32(ADR_RX_TX_FSM_REGISTER)) & 0xfffff9ff))
#define SET_RG_RX_LNA_SETTLE(_VAL_) (REG32(ADR_RX_TX_FSM_REGISTER)) = (((_VAL_) << 11) | ((REG32(ADR_RX_TX_FSM_REGISTER)) & 0xffffe7ff))
#define SET_RG_TXGAIN_PHYCTRL(_VAL_) (REG32(ADR_RX_TX_FSM_REGISTER)) = (((_VAL_) << 13) | ((REG32(ADR_RX_TX_FSM_REGISTER)) & 0xffffdfff))
#define SET_RG_TX_GAIN(_VAL_) (REG32(ADR_RX_TX_FSM_REGISTER)) = (((_VAL_) << 14) | ((REG32(ADR_RX_TX_FSM_REGISTER)) & 0xffc03fff))
#define SET_RG_TXGAIN_MANUAL(_VAL_) (REG32(ADR_RX_TX_FSM_REGISTER)) = (((_VAL_) << 22) | ((REG32(ADR_RX_TX_FSM_REGISTER)) & 0xffbfffff))
#define SET_RG_TX_GAIN_OFFSET(_VAL_) (REG32(ADR_RX_TX_FSM_REGISTER)) = (((_VAL_) << 23) | ((REG32(ADR_RX_TX_FSM_REGISTER)) & 0xf87fffff))
#define SET_RG_ADC_CLKSEL(_VAL_) (REG32(ADR_RX_ADC_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_RX_ADC_REGISTER)) & 0xfffffffe))
#define SET_RG_ADC_DIBIAS(_VAL_) (REG32(ADR_RX_ADC_REGISTER)) = (((_VAL_) << 1) | ((REG32(ADR_RX_ADC_REGISTER)) & 0xfffffff9))
#define SET_RG_ADC_DIVR(_VAL_) (REG32(ADR_RX_ADC_REGISTER)) = (((_VAL_) << 3) | ((REG32(ADR_RX_ADC_REGISTER)) & 0xfffffff7))
#define SET_RG_ADC_DVCMI(_VAL_) (REG32(ADR_RX_ADC_REGISTER)) = (((_VAL_) << 4) | ((REG32(ADR_RX_ADC_REGISTER)) & 0xffffffcf))
#define SET_RG_ADC_SAMSEL(_VAL_) (REG32(ADR_RX_ADC_REGISTER)) = (((_VAL_) << 6) | ((REG32(ADR_RX_ADC_REGISTER)) & 0xfffffc3f))
#define SET_RG_ADC_STNBY(_VAL_) (REG32(ADR_RX_ADC_REGISTER)) = (((_VAL_) << 10) | ((REG32(ADR_RX_ADC_REGISTER)) & 0xfffffbff))
#define SET_RG_ADC_TESTMODE(_VAL_) (REG32(ADR_RX_ADC_REGISTER)) = (((_VAL_) << 11) | ((REG32(ADR_RX_ADC_REGISTER)) & 0xfffff7ff))
#define SET_RG_ADC_TSEL(_VAL_) (REG32(ADR_RX_ADC_REGISTER)) = (((_VAL_) << 12) | ((REG32(ADR_RX_ADC_REGISTER)) & 0xffff0fff))
#define SET_RG_ADC_VRSEL(_VAL_) (REG32(ADR_RX_ADC_REGISTER)) = (((_VAL_) << 16) | ((REG32(ADR_RX_ADC_REGISTER)) & 0xfffcffff))
#define SET_RG_DICMP(_VAL_) (REG32(ADR_RX_ADC_REGISTER)) = (((_VAL_) << 18) | ((REG32(ADR_RX_ADC_REGISTER)) & 0xfff3ffff))
#define SET_RG_DIOP(_VAL_) (REG32(ADR_RX_ADC_REGISTER)) = (((_VAL_) << 20) | ((REG32(ADR_RX_ADC_REGISTER)) & 0xffcfffff))
#define SET_RG_SARADC_VRSEL(_VAL_) (REG32(ADR_RX_ADC_REGISTER)) = (((_VAL_) << 22) | ((REG32(ADR_RX_ADC_REGISTER)) & 0xff3fffff))
#define SET_RG_EN_SAR_TEST(_VAL_) (REG32(ADR_RX_ADC_REGISTER)) = (((_VAL_) << 24) | ((REG32(ADR_RX_ADC_REGISTER)) & 0xfcffffff))
#define SET_RG_SARADC_THERMAL(_VAL_) (REG32(ADR_RX_ADC_REGISTER)) = (((_VAL_) << 26) | ((REG32(ADR_RX_ADC_REGISTER)) & 0xfbffffff))
#define SET_RG_SARADC_TSSI(_VAL_) (REG32(ADR_RX_ADC_REGISTER)) = (((_VAL_) << 27) | ((REG32(ADR_RX_ADC_REGISTER)) & 0xf7ffffff))
#define SET_RG_CLK_SAR_SEL(_VAL_) (REG32(ADR_RX_ADC_REGISTER)) = (((_VAL_) << 28) | ((REG32(ADR_RX_ADC_REGISTER)) & 0xcfffffff))
#define SET_RG_EN_SARADC(_VAL_) (REG32(ADR_RX_ADC_REGISTER)) = (((_VAL_) << 30) | ((REG32(ADR_RX_ADC_REGISTER)) & 0xbfffffff))
#define SET_RG_DACI1ST(_VAL_) (REG32(ADR_TX_DAC_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_TX_DAC_REGISTER)) & 0xfffffffc))
#define SET_RG_TX_DACLPF_ICOURSE(_VAL_) (REG32(ADR_TX_DAC_REGISTER)) = (((_VAL_) << 2) | ((REG32(ADR_TX_DAC_REGISTER)) & 0xfffffff3))
#define SET_RG_TX_DACLPF_IFINE(_VAL_) (REG32(ADR_TX_DAC_REGISTER)) = (((_VAL_) << 4) | ((REG32(ADR_TX_DAC_REGISTER)) & 0xffffffcf))
#define SET_RG_TX_DACLPF_VCM(_VAL_) (REG32(ADR_TX_DAC_REGISTER)) = (((_VAL_) << 6) | ((REG32(ADR_TX_DAC_REGISTER)) & 0xffffff3f))
#define SET_RG_TX_DAC_CKEDGE_SEL(_VAL_) (REG32(ADR_TX_DAC_REGISTER)) = (((_VAL_) << 8) | ((REG32(ADR_TX_DAC_REGISTER)) & 0xfffffeff))
#define SET_RG_TX_DAC_IBIAS(_VAL_) (REG32(ADR_TX_DAC_REGISTER)) = (((_VAL_) << 9) | ((REG32(ADR_TX_DAC_REGISTER)) & 0xfffff9ff))
#define SET_RG_TX_DAC_OS(_VAL_) (REG32(ADR_TX_DAC_REGISTER)) = (((_VAL_) << 11) | ((REG32(ADR_TX_DAC_REGISTER)) & 0xffffc7ff))
#define SET_RG_TX_DAC_RCAL(_VAL_) (REG32(ADR_TX_DAC_REGISTER)) = (((_VAL_) << 14) | ((REG32(ADR_TX_DAC_REGISTER)) & 0xffff3fff))
#define SET_RG_TX_DAC_TSEL(_VAL_) (REG32(ADR_TX_DAC_REGISTER)) = (((_VAL_) << 16) | ((REG32(ADR_TX_DAC_REGISTER)) & 0xfff0ffff))
#define SET_RG_TX_EN_VOLTAGE_IN(_VAL_) (REG32(ADR_TX_DAC_REGISTER)) = (((_VAL_) << 20) | ((REG32(ADR_TX_DAC_REGISTER)) & 0xffefffff))
#define SET_RG_TXLPF_BYPASS(_VAL_) (REG32(ADR_TX_DAC_REGISTER)) = (((_VAL_) << 21) | ((REG32(ADR_TX_DAC_REGISTER)) & 0xffdfffff))
#define SET_RG_TXLPF_BOOSTI(_VAL_) (REG32(ADR_TX_DAC_REGISTER)) = (((_VAL_) << 22) | ((REG32(ADR_TX_DAC_REGISTER)) & 0xffbfffff))
#define SET_RG_TX_DAC_IOFFSET(_VAL_) (REG32(ADR_TX_DAC_REGISTER)) = (((_VAL_) << 23) | ((REG32(ADR_TX_DAC_REGISTER)) & 0xf87fffff))
#define SET_RG_TX_DAC_QOFFSET(_VAL_) (REG32(ADR_TX_DAC_REGISTER)) = (((_VAL_) << 27) | ((REG32(ADR_TX_DAC_REGISTER)) & 0x87ffffff))
#define SET_RG_EN_SX_R3(_VAL_) (REG32(ADR_SX_ENABLE_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_SX_ENABLE_REGISTER)) & 0xfffffffe))
#define SET_RG_EN_SX_CH(_VAL_) (REG32(ADR_SX_ENABLE_REGISTER)) = (((_VAL_) << 1) | ((REG32(ADR_SX_ENABLE_REGISTER)) & 0xfffffffd))
#define SET_RG_EN_SX_CHP(_VAL_) (REG32(ADR_SX_ENABLE_REGISTER)) = (((_VAL_) << 2) | ((REG32(ADR_SX_ENABLE_REGISTER)) & 0xfffffffb))
#define SET_RG_EN_SX_DIVCK(_VAL_) (REG32(ADR_SX_ENABLE_REGISTER)) = (((_VAL_) << 3) | ((REG32(ADR_SX_ENABLE_REGISTER)) & 0xfffffff7))
#define SET_RG_EN_SX_VCOBF(_VAL_) (REG32(ADR_SX_ENABLE_REGISTER)) = (((_VAL_) << 4) | ((REG32(ADR_SX_ENABLE_REGISTER)) & 0xffffffef))
#define SET_RG_EN_SX_VCO(_VAL_) (REG32(ADR_SX_ENABLE_REGISTER)) = (((_VAL_) << 5) | ((REG32(ADR_SX_ENABLE_REGISTER)) & 0xffffffdf))
#define SET_RG_EN_SX_MOD(_VAL_) (REG32(ADR_SX_ENABLE_REGISTER)) = (((_VAL_) << 6) | ((REG32(ADR_SX_ENABLE_REGISTER)) & 0xffffffbf))
#define SET_RG_EN_SX_DITHER(_VAL_) (REG32(ADR_SX_ENABLE_REGISTER)) = (((_VAL_) << 8) | ((REG32(ADR_SX_ENABLE_REGISTER)) & 0xfffffeff))
#define SET_RG_EN_SX_VT_MON(_VAL_) (REG32(ADR_SX_ENABLE_REGISTER)) = (((_VAL_) << 11) | ((REG32(ADR_SX_ENABLE_REGISTER)) & 0xfffff7ff))
#define SET_RG_EN_SX_VT_MON_DG(_VAL_) (REG32(ADR_SX_ENABLE_REGISTER)) = (((_VAL_) << 12) | ((REG32(ADR_SX_ENABLE_REGISTER)) & 0xffffefff))
#define SET_RG_EN_SX_DIV(_VAL_) (REG32(ADR_SX_ENABLE_REGISTER)) = (((_VAL_) << 13) | ((REG32(ADR_SX_ENABLE_REGISTER)) & 0xffffdfff))
#define SET_RG_EN_SX_LPF(_VAL_) (REG32(ADR_SX_ENABLE_REGISTER)) = (((_VAL_) << 14) | ((REG32(ADR_SX_ENABLE_REGISTER)) & 0xffffbfff))
#define SET_RG_EN_DPL_MOD(_VAL_) (REG32(ADR_SX_ENABLE_REGISTER)) = (((_VAL_) << 15) | ((REG32(ADR_SX_ENABLE_REGISTER)) & 0xffff7fff))
#define SET_RG_DPL_MOD_ORDER(_VAL_) (REG32(ADR_SX_ENABLE_REGISTER)) = (((_VAL_) << 16) | ((REG32(ADR_SX_ENABLE_REGISTER)) & 0xfffcffff))
#define SET_RG_SX_RFCTRL_F(_VAL_) (REG32(ADR_SYN_REGISTER_1)) = (((_VAL_) << 0) | ((REG32(ADR_SYN_REGISTER_1)) & 0xff000000))
#define SET_RG_SX_SEL_CP(_VAL_) (REG32(ADR_SYN_REGISTER_1)) = (((_VAL_) << 24) | ((REG32(ADR_SYN_REGISTER_1)) & 0xf0ffffff))
#define SET_RG_SX_SEL_CS(_VAL_) (REG32(ADR_SYN_REGISTER_1)) = (((_VAL_) << 28) | ((REG32(ADR_SYN_REGISTER_1)) & 0x0fffffff))
#define SET_RG_SX_RFCTRL_CH(_VAL_) (REG32(ADR_SYN_REGISTER_2)) = (((_VAL_) << 0) | ((REG32(ADR_SYN_REGISTER_2)) & 0xfffff800))
#define SET_RG_SX_SEL_C3(_VAL_) (REG32(ADR_SYN_REGISTER_2)) = (((_VAL_) << 11) | ((REG32(ADR_SYN_REGISTER_2)) & 0xffff87ff))
#define SET_RG_SX_SEL_RS(_VAL_) (REG32(ADR_SYN_REGISTER_2)) = (((_VAL_) << 15) | ((REG32(ADR_SYN_REGISTER_2)) & 0xfff07fff))
#define SET_RG_SX_SEL_R3(_VAL_) (REG32(ADR_SYN_REGISTER_2)) = (((_VAL_) << 20) | ((REG32(ADR_SYN_REGISTER_2)) & 0xfe0fffff))
#define SET_RG_SX_SEL_ICHP(_VAL_) (REG32(ADR_SYN_PFD_CHP)) = (((_VAL_) << 0) | ((REG32(ADR_SYN_PFD_CHP)) & 0xffffffe0))
#define SET_RG_SX_SEL_PCHP(_VAL_) (REG32(ADR_SYN_PFD_CHP)) = (((_VAL_) << 5) | ((REG32(ADR_SYN_PFD_CHP)) & 0xfffffc1f))
#define SET_RG_SX_SEL_CHP_REGOP(_VAL_) (REG32(ADR_SYN_PFD_CHP)) = (((_VAL_) << 10) | ((REG32(ADR_SYN_PFD_CHP)) & 0xffffc3ff))
#define SET_RG_SX_SEL_CHP_UNIOP(_VAL_) (REG32(ADR_SYN_PFD_CHP)) = (((_VAL_) << 14) | ((REG32(ADR_SYN_PFD_CHP)) & 0xfffc3fff))
#define SET_RG_SX_CHP_IOST_POL(_VAL_) (REG32(ADR_SYN_PFD_CHP)) = (((_VAL_) << 18) | ((REG32(ADR_SYN_PFD_CHP)) & 0xfffbffff))
#define SET_RG_SX_CHP_IOST(_VAL_) (REG32(ADR_SYN_PFD_CHP)) = (((_VAL_) << 19) | ((REG32(ADR_SYN_PFD_CHP)) & 0xffc7ffff))
#define SET_RG_SX_PFDSEL(_VAL_) (REG32(ADR_SYN_PFD_CHP)) = (((_VAL_) << 22) | ((REG32(ADR_SYN_PFD_CHP)) & 0xffbfffff))
#define SET_RG_SX_PFD_SET(_VAL_) (REG32(ADR_SYN_PFD_CHP)) = (((_VAL_) << 23) | ((REG32(ADR_SYN_PFD_CHP)) & 0xff7fffff))
#define SET_RG_SX_PFD_SET1(_VAL_) (REG32(ADR_SYN_PFD_CHP)) = (((_VAL_) << 24) | ((REG32(ADR_SYN_PFD_CHP)) & 0xfeffffff))
#define SET_RG_SX_PFD_SET2(_VAL_) (REG32(ADR_SYN_PFD_CHP)) = (((_VAL_) << 25) | ((REG32(ADR_SYN_PFD_CHP)) & 0xfdffffff))
#define SET_RG_SX_VBNCAS_SEL(_VAL_) (REG32(ADR_SYN_PFD_CHP)) = (((_VAL_) << 26) | ((REG32(ADR_SYN_PFD_CHP)) & 0xfbffffff))
#define SET_RG_SX_PFD_RST_H(_VAL_) (REG32(ADR_SYN_PFD_CHP)) = (((_VAL_) << 27) | ((REG32(ADR_SYN_PFD_CHP)) & 0xf7ffffff))
#define SET_RG_SX_PFD_TRUP(_VAL_) (REG32(ADR_SYN_PFD_CHP)) = (((_VAL_) << 28) | ((REG32(ADR_SYN_PFD_CHP)) & 0xefffffff))
#define SET_RG_SX_PFD_TRDN(_VAL_) (REG32(ADR_SYN_PFD_CHP)) = (((_VAL_) << 29) | ((REG32(ADR_SYN_PFD_CHP)) & 0xdfffffff))
#define SET_RG_SX_PFD_TRSEL(_VAL_) (REG32(ADR_SYN_PFD_CHP)) = (((_VAL_) << 30) | ((REG32(ADR_SYN_PFD_CHP)) & 0xbfffffff))
#define SET_RG_SX_VCOBA_R(_VAL_) (REG32(ADR_SYN_VCO_LOBF)) = (((_VAL_) << 0) | ((REG32(ADR_SYN_VCO_LOBF)) & 0xfffffff8))
#define SET_RG_SX_VCORSEL(_VAL_) (REG32(ADR_SYN_VCO_LOBF)) = (((_VAL_) << 3) | ((REG32(ADR_SYN_VCO_LOBF)) & 0xffffff07))
#define SET_RG_SX_VCOCUSEL(_VAL_) (REG32(ADR_SYN_VCO_LOBF)) = (((_VAL_) << 8) | ((REG32(ADR_SYN_VCO_LOBF)) & 0xfffff0ff))
#define SET_RG_SX_RXBFSEL(_VAL_) (REG32(ADR_SYN_VCO_LOBF)) = (((_VAL_) << 12) | ((REG32(ADR_SYN_VCO_LOBF)) & 0xffff0fff))
#define SET_RG_SX_TXBFSEL(_VAL_) (REG32(ADR_SYN_VCO_LOBF)) = (((_VAL_) << 16) | ((REG32(ADR_SYN_VCO_LOBF)) & 0xfff0ffff))
#define SET_RG_SX_VCOBFSEL(_VAL_) (REG32(ADR_SYN_VCO_LOBF)) = (((_VAL_) << 20) | ((REG32(ADR_SYN_VCO_LOBF)) & 0xff0fffff))
#define SET_RG_SX_DIVBFSEL(_VAL_) (REG32(ADR_SYN_VCO_LOBF)) = (((_VAL_) << 24) | ((REG32(ADR_SYN_VCO_LOBF)) & 0xf0ffffff))
#define SET_RG_SX_GNDR_SEL(_VAL_) (REG32(ADR_SYN_VCO_LOBF)) = (((_VAL_) << 28) | ((REG32(ADR_SYN_VCO_LOBF)) & 0x0fffffff))
#define SET_RG_SX_DITHER_WEIGHT(_VAL_) (REG32(ADR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 0) | ((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0xfffffffc))
#define SET_RG_SX_MOD_ORDER(_VAL_) (REG32(ADR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 4) | ((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0xffffffcf))
#define SET_RG_SX_RST_H_DIV(_VAL_) (REG32(ADR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 9) | ((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0xfffffdff))
#define SET_RG_SX_SDM_EDGE(_VAL_) (REG32(ADR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 10) | ((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0xfffffbff))
#define SET_RG_SX_XO_GM(_VAL_) (REG32(ADR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 11) | ((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0xffffe7ff))
#define SET_RG_SX_REFBYTWO(_VAL_) (REG32(ADR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 13) | ((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0xffffdfff))
#define SET_RG_SX_LCKEN(_VAL_) (REG32(ADR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 19) | ((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0xfff7ffff))
#define SET_RG_SX_PREVDD(_VAL_) (REG32(ADR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 20) | ((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0xff0fffff))
#define SET_RG_SX_PSCONTERVDD(_VAL_) (REG32(ADR_SYN_DIV_SDM_XOSC)) = (((_VAL_) << 24) | ((REG32(ADR_SYN_DIV_SDM_XOSC)) & 0xf0ffffff))
#define SET_RG_SX_PH(_VAL_) (REG32(ADR_SYN_KVCO_XO_FINE_TUNE_CBANK)) = (((_VAL_) << 13) | ((REG32(ADR_SYN_KVCO_XO_FINE_TUNE_CBANK)) & 0xffffdfff))
#define SET_RG_SX_PL(_VAL_) (REG32(ADR_SYN_KVCO_XO_FINE_TUNE_CBANK)) = (((_VAL_) << 14) | ((REG32(ADR_SYN_KVCO_XO_FINE_TUNE_CBANK)) & 0xffffbfff))
#define SET_RG_XOSC_CBANK_XO(_VAL_) (REG32(ADR_SYN_KVCO_XO_FINE_TUNE_CBANK)) = (((_VAL_) << 15) | ((REG32(ADR_SYN_KVCO_XO_FINE_TUNE_CBANK)) & 0xfff87fff))
#define SET_RG_XOSC_CBANK_XI(_VAL_) (REG32(ADR_SYN_KVCO_XO_FINE_TUNE_CBANK)) = (((_VAL_) << 19) | ((REG32(ADR_SYN_KVCO_XO_FINE_TUNE_CBANK)) & 0xff87ffff))
#define SET_RG_SX_VT_MON_MODE(_VAL_) (REG32(ADR_SYN_LCK_VT)) = (((_VAL_) << 0) | ((REG32(ADR_SYN_LCK_VT)) & 0xfffffffe))
#define SET_RG_SX_VT_TH_HI(_VAL_) (REG32(ADR_SYN_LCK_VT)) = (((_VAL_) << 1) | ((REG32(ADR_SYN_LCK_VT)) & 0xfffffff9))
#define SET_RG_SX_VT_TH_LO(_VAL_) (REG32(ADR_SYN_LCK_VT)) = (((_VAL_) << 3) | ((REG32(ADR_SYN_LCK_VT)) & 0xffffffe7))
#define SET_RG_SX_VT_SET(_VAL_) (REG32(ADR_SYN_LCK_VT)) = (((_VAL_) << 5) | ((REG32(ADR_SYN_LCK_VT)) & 0xffffffdf))
#define SET_RG_SX_VT_MON_TMR(_VAL_) (REG32(ADR_SYN_LCK_VT)) = (((_VAL_) << 6) | ((REG32(ADR_SYN_LCK_VT)) & 0xffff803f))
#define SET_RG_EN_DP_VT_MON(_VAL_) (REG32(ADR_DPLL_VCO_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_DPLL_VCO_REGISTER)) & 0xfffffffe))
#define SET_RG_DP_VT_TH_HI(_VAL_) (REG32(ADR_DPLL_VCO_REGISTER)) = (((_VAL_) << 1) | ((REG32(ADR_DPLL_VCO_REGISTER)) & 0xfffffff9))
#define SET_RG_DP_VT_TH_LO(_VAL_) (REG32(ADR_DPLL_VCO_REGISTER)) = (((_VAL_) << 3) | ((REG32(ADR_DPLL_VCO_REGISTER)) & 0xffffffe7))
#define SET_RG_DP_CK320BY2(_VAL_) (REG32(ADR_DPLL_VCO_REGISTER)) = (((_VAL_) << 14) | ((REG32(ADR_DPLL_VCO_REGISTER)) & 0xffffbfff))
#define SET_RG_DP_OD_TEST(_VAL_) (REG32(ADR_DPLL_VCO_REGISTER)) = (((_VAL_) << 21) | ((REG32(ADR_DPLL_VCO_REGISTER)) & 0xffdfffff))
#define SET_RG_DP_BBPLL_BP(_VAL_) (REG32(ADR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0xfffffffe))
#define SET_RG_DP_BBPLL_ICP(_VAL_) (REG32(ADR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 1) | ((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0xfffffff9))
#define SET_RG_DP_BBPLL_IDUAL(_VAL_) (REG32(ADR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 3) | ((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0xffffffe7))
#define SET_RG_DP_BBPLL_OD_TEST(_VAL_) (REG32(ADR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 5) | ((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0xfffffe1f))
#define SET_RG_DP_BBPLL_PD(_VAL_) (REG32(ADR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 9) | ((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0xfffffdff))
#define SET_RG_DP_BBPLL_TESTSEL(_VAL_) (REG32(ADR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 10) | ((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0xffffe3ff))
#define SET_RG_DP_BBPLL_PFD_DLY(_VAL_) (REG32(ADR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 13) | ((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0xffff9fff))
#define SET_RG_DP_RP(_VAL_) (REG32(ADR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 15) | ((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0xfffc7fff))
#define SET_RG_DP_RHP(_VAL_) (REG32(ADR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 18) | ((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0xfff3ffff))
#define SET_RG_DP_BBPLL_SDM_EDGE(_VAL_) (REG32(ADR_DPLL_CP_PFD_REGISTER)) = (((_VAL_) << 31) | ((REG32(ADR_DPLL_CP_PFD_REGISTER)) & 0x7fffffff))
#define SET_RG_DP_FODIV(_VAL_) (REG32(ADR_DPLL_DIVIDER_REGISTER)) = (((_VAL_) << 12) | ((REG32(ADR_DPLL_DIVIDER_REGISTER)) & 0xfff80fff))
#define SET_RG_DP_REFDIV(_VAL_) (REG32(ADR_DPLL_DIVIDER_REGISTER)) = (((_VAL_) << 22) | ((REG32(ADR_DPLL_DIVIDER_REGISTER)) & 0xe03fffff))
#define SET_RG_IDACAI_PGAG15(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER1)) = (((_VAL_) << 0) | ((REG32(ADR_DCOC_IDAC_REGISTER1)) & 0xffffffc0))
#define SET_RG_IDACAQ_PGAG15(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER1)) = (((_VAL_) << 6) | ((REG32(ADR_DCOC_IDAC_REGISTER1)) & 0xfffff03f))
#define SET_RG_IDACAI_PGAG14(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER1)) = (((_VAL_) << 12) | ((REG32(ADR_DCOC_IDAC_REGISTER1)) & 0xfffc0fff))
#define SET_RG_IDACAQ_PGAG14(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER1)) = (((_VAL_) << 18) | ((REG32(ADR_DCOC_IDAC_REGISTER1)) & 0xff03ffff))
#define SET_RG_DP_BBPLL_BS(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER1)) = (((_VAL_) << 24) | ((REG32(ADR_DCOC_IDAC_REGISTER1)) & 0xc0ffffff))
#define SET_RG_IDACAI_PGAG13(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER2)) = (((_VAL_) << 0) | ((REG32(ADR_DCOC_IDAC_REGISTER2)) & 0xffffffc0))
#define SET_RG_IDACAQ_PGAG13(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER2)) = (((_VAL_) << 6) | ((REG32(ADR_DCOC_IDAC_REGISTER2)) & 0xfffff03f))
#define SET_RG_IDACAI_PGAG12(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER2)) = (((_VAL_) << 12) | ((REG32(ADR_DCOC_IDAC_REGISTER2)) & 0xfffc0fff))
#define SET_RG_IDACAQ_PGAG12(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER2)) = (((_VAL_) << 18) | ((REG32(ADR_DCOC_IDAC_REGISTER2)) & 0xff03ffff))
#define SET_RG_IDACAI_PGAG11(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER3)) = (((_VAL_) << 0) | ((REG32(ADR_DCOC_IDAC_REGISTER3)) & 0xffffffc0))
#define SET_RG_IDACAQ_PGAG11(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER3)) = (((_VAL_) << 6) | ((REG32(ADR_DCOC_IDAC_REGISTER3)) & 0xfffff03f))
#define SET_RG_IDACAI_PGAG10(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER3)) = (((_VAL_) << 12) | ((REG32(ADR_DCOC_IDAC_REGISTER3)) & 0xfffc0fff))
#define SET_RG_IDACAQ_PGAG10(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER3)) = (((_VAL_) << 18) | ((REG32(ADR_DCOC_IDAC_REGISTER3)) & 0xff03ffff))
#define SET_RG_IDACAI_PGAG9(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER4)) = (((_VAL_) << 0) | ((REG32(ADR_DCOC_IDAC_REGISTER4)) & 0xffffffc0))
#define SET_RG_IDACAQ_PGAG9(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER4)) = (((_VAL_) << 6) | ((REG32(ADR_DCOC_IDAC_REGISTER4)) & 0xfffff03f))
#define SET_RG_IDACAI_PGAG8(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER4)) = (((_VAL_) << 12) | ((REG32(ADR_DCOC_IDAC_REGISTER4)) & 0xfffc0fff))
#define SET_RG_IDACAQ_PGAG8(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER4)) = (((_VAL_) << 18) | ((REG32(ADR_DCOC_IDAC_REGISTER4)) & 0xff03ffff))
#define SET_RG_IDACAI_PGAG7(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER5)) = (((_VAL_) << 0) | ((REG32(ADR_DCOC_IDAC_REGISTER5)) & 0xffffffc0))
#define SET_RG_IDACAQ_PGAG7(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER5)) = (((_VAL_) << 6) | ((REG32(ADR_DCOC_IDAC_REGISTER5)) & 0xfffff03f))
#define SET_RG_IDACAI_PGAG6(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER5)) = (((_VAL_) << 12) | ((REG32(ADR_DCOC_IDAC_REGISTER5)) & 0xfffc0fff))
#define SET_RG_IDACAQ_PGAG6(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER5)) = (((_VAL_) << 18) | ((REG32(ADR_DCOC_IDAC_REGISTER5)) & 0xff03ffff))
#define SET_RG_IDACAI_PGAG5(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER6)) = (((_VAL_) << 0) | ((REG32(ADR_DCOC_IDAC_REGISTER6)) & 0xffffffc0))
#define SET_RG_IDACAQ_PGAG5(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER6)) = (((_VAL_) << 6) | ((REG32(ADR_DCOC_IDAC_REGISTER6)) & 0xfffff03f))
#define SET_RG_IDACAI_PGAG4(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER6)) = (((_VAL_) << 12) | ((REG32(ADR_DCOC_IDAC_REGISTER6)) & 0xfffc0fff))
#define SET_RG_IDACAQ_PGAG4(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER6)) = (((_VAL_) << 18) | ((REG32(ADR_DCOC_IDAC_REGISTER6)) & 0xff03ffff))
#define SET_RG_IDACAI_PGAG3(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER7)) = (((_VAL_) << 0) | ((REG32(ADR_DCOC_IDAC_REGISTER7)) & 0xffffffc0))
#define SET_RG_IDACAQ_PGAG3(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER7)) = (((_VAL_) << 6) | ((REG32(ADR_DCOC_IDAC_REGISTER7)) & 0xfffff03f))
#define SET_RG_IDACAI_PGAG2(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER7)) = (((_VAL_) << 12) | ((REG32(ADR_DCOC_IDAC_REGISTER7)) & 0xfffc0fff))
#define SET_RG_IDACAQ_PGAG2(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER7)) = (((_VAL_) << 18) | ((REG32(ADR_DCOC_IDAC_REGISTER7)) & 0xff03ffff))
#define SET_RG_IDACAI_PGAG1(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER8)) = (((_VAL_) << 0) | ((REG32(ADR_DCOC_IDAC_REGISTER8)) & 0xffffffc0))
#define SET_RG_IDACAQ_PGAG1(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER8)) = (((_VAL_) << 6) | ((REG32(ADR_DCOC_IDAC_REGISTER8)) & 0xfffff03f))
#define SET_RG_IDACAI_PGAG0(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER8)) = (((_VAL_) << 12) | ((REG32(ADR_DCOC_IDAC_REGISTER8)) & 0xfffc0fff))
#define SET_RG_IDACAQ_PGAG0(_VAL_) (REG32(ADR_DCOC_IDAC_REGISTER8)) = (((_VAL_) << 18) | ((REG32(ADR_DCOC_IDAC_REGISTER8)) & 0xff03ffff))
#define SET_RG_EN_RCAL(_VAL_) (REG32(ADR_RCAL_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_RCAL_REGISTER)) & 0xfffffffe))
#define SET_RG_RCAL_SPD(_VAL_) (REG32(ADR_RCAL_REGISTER)) = (((_VAL_) << 1) | ((REG32(ADR_RCAL_REGISTER)) & 0xfffffffd))
#define SET_RG_RCAL_TMR(_VAL_) (REG32(ADR_RCAL_REGISTER)) = (((_VAL_) << 2) | ((REG32(ADR_RCAL_REGISTER)) & 0xfffffe03))
#define SET_RG_RCAL_CODE_CWR(_VAL_) (REG32(ADR_RCAL_REGISTER)) = (((_VAL_) << 9) | ((REG32(ADR_RCAL_REGISTER)) & 0xfffffdff))
#define SET_RG_RCAL_CODE_CWD(_VAL_) (REG32(ADR_RCAL_REGISTER)) = (((_VAL_) << 10) | ((REG32(ADR_RCAL_REGISTER)) & 0xffff83ff))
#define SET_RG_SX_SUB_SEL_CWR(_VAL_) (REG32(ADR_SX_LCK_BIN_REGISTERS_I)) = (((_VAL_) << 0) | ((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0xfffffffe))
#define SET_RG_SX_SUB_SEL_CWD(_VAL_) (REG32(ADR_SX_LCK_BIN_REGISTERS_I)) = (((_VAL_) << 1) | ((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0xffffff01))
#define SET_RG_SX_LCK_BIN_OFFSET(_VAL_) (REG32(ADR_SX_LCK_BIN_REGISTERS_I)) = (((_VAL_) << 15) | ((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0xfff87fff))
#define SET_RG_SX_LCK_BIN_PRECISION(_VAL_) (REG32(ADR_SX_LCK_BIN_REGISTERS_I)) = (((_VAL_) << 19) | ((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0xfff7ffff))
#define SET_RG_SX_LOCK_EN_N(_VAL_) (REG32(ADR_SX_LCK_BIN_REGISTERS_I)) = (((_VAL_) << 20) | ((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0xffefffff))
#define SET_RG_SX_LOCK_MANUAL(_VAL_) (REG32(ADR_SX_LCK_BIN_REGISTERS_I)) = (((_VAL_) << 21) | ((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0xffdfffff))
#define SET_RG_SX_SUB_MANUAL(_VAL_) (REG32(ADR_SX_LCK_BIN_REGISTERS_I)) = (((_VAL_) << 22) | ((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0xffbfffff))
#define SET_RG_SX_SUB_SEL(_VAL_) (REG32(ADR_SX_LCK_BIN_REGISTERS_I)) = (((_VAL_) << 23) | ((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0xc07fffff))
#define SET_RG_SX_MUX_SEL_VTH_BINL(_VAL_) (REG32(ADR_SX_LCK_BIN_REGISTERS_I)) = (((_VAL_) << 30) | ((REG32(ADR_SX_LCK_BIN_REGISTERS_I)) & 0xbfffffff))
#define SET_RG_TRX_DUMMMY(_VAL_) (REG32(ADR_TRX_DUMMY_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_TRX_DUMMY_REGISTER)) & 0x00000000))
#define SET_RG_SX_DUMMMY(_VAL_) (REG32(ADR_SX_DUMMY_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_SX_DUMMY_REGISTER)) & 0x00000000))
#define SET_RCAL_RDY(_VAL_) (REG32(ADR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 0) | ((REG32(ADR_READ_ONLY_FLAGS_1)) & 0xfffffffe))
#define SET_LCK_BIN_RDY(_VAL_) (REG32(ADR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 1) | ((REG32(ADR_READ_ONLY_FLAGS_1)) & 0xfffffffd))
#define SET_VT_MON_RDY(_VAL_) (REG32(ADR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 2) | ((REG32(ADR_READ_ONLY_FLAGS_1)) & 0xfffffffb))
#define SET_DA_R_CODE_LUT(_VAL_) (REG32(ADR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 6) | ((REG32(ADR_READ_ONLY_FLAGS_1)) & 0xfffff83f))
#define SET_AD_SX_VT_MON_Q(_VAL_) (REG32(ADR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 11) | ((REG32(ADR_READ_ONLY_FLAGS_1)) & 0xffffe7ff))
#define SET_AD_DP_VT_MON_Q(_VAL_) (REG32(ADR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 13) | ((REG32(ADR_READ_ONLY_FLAGS_1)) & 0xffff9fff))
#define SET_RTC_CAL_RDY(_VAL_) (REG32(ADR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 15) | ((REG32(ADR_READ_ONLY_FLAGS_1)) & 0xffff7fff))
#define SET_RG_SARADC_BIT(_VAL_) (REG32(ADR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 16) | ((REG32(ADR_READ_ONLY_FLAGS_1)) & 0xffc0ffff))
#define SET_SAR_ADC_FSM_RDY(_VAL_) (REG32(ADR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 22) | ((REG32(ADR_READ_ONLY_FLAGS_1)) & 0xffbfffff))
#define SET_AD_CIRCUIT_VERSION(_VAL_) (REG32(ADR_READ_ONLY_FLAGS_1)) = (((_VAL_) << 23) | ((REG32(ADR_READ_ONLY_FLAGS_1)) & 0xf87fffff))
#define SET_DA_R_CAL_CODE(_VAL_) (REG32(ADR_READ_ONLY_FLAGS_2)) = (((_VAL_) << 0) | ((REG32(ADR_READ_ONLY_FLAGS_2)) & 0xffffffe0))
#define SET_DA_SX_SUB_SEL(_VAL_) (REG32(ADR_READ_ONLY_FLAGS_2)) = (((_VAL_) << 5) | ((REG32(ADR_READ_ONLY_FLAGS_2)) & 0xfffff01f))
#define SET_RG_DPL_RFCTRL_CH(_VAL_) (REG32(ADR_DPLL_FB_DIVIDER_REGISTERS_I)) = (((_VAL_) << 0) | ((REG32(ADR_DPLL_FB_DIVIDER_REGISTERS_I)) & 0xfffff800))
#define SET_RG_RSSIADC_RO_BIT(_VAL_) (REG32(ADR_DPLL_FB_DIVIDER_REGISTERS_I)) = (((_VAL_) << 11) | ((REG32(ADR_DPLL_FB_DIVIDER_REGISTERS_I)) & 0xffff87ff))
#define SET_RG_RX_ADC_I_RO_BIT(_VAL_) (REG32(ADR_DPLL_FB_DIVIDER_REGISTERS_I)) = (((_VAL_) << 15) | ((REG32(ADR_DPLL_FB_DIVIDER_REGISTERS_I)) & 0xff807fff))
#define SET_RG_RX_ADC_Q_RO_BIT(_VAL_) (REG32(ADR_DPLL_FB_DIVIDER_REGISTERS_I)) = (((_VAL_) << 23) | ((REG32(ADR_DPLL_FB_DIVIDER_REGISTERS_I)) & 0x807fffff))
#define SET_RG_DPL_RFCTRL_F(_VAL_) (REG32(ADR_DPLL_FB_DIVIDER_REGISTERS_II)) = (((_VAL_) << 0) | ((REG32(ADR_DPLL_FB_DIVIDER_REGISTERS_II)) & 0xff000000))
#define SET_RG_SX_TARGET_CNT(_VAL_) (REG32(ADR_SX_LCK_BIN_REGISTERS_II)) = (((_VAL_) << 0) | ((REG32(ADR_SX_LCK_BIN_REGISTERS_II)) & 0xffffe000))
#define SET_RG_RTC_OFFSET(_VAL_) (REG32(ADR_RC_OSC_32K_CAL_REGISTERS)) = (((_VAL_) << 0) | ((REG32(ADR_RC_OSC_32K_CAL_REGISTERS)) & 0xffffff00))
#define SET_RG_RTC_CAL_TARGET_COUNT(_VAL_) (REG32(ADR_RC_OSC_32K_CAL_REGISTERS)) = (((_VAL_) << 8) | ((REG32(ADR_RC_OSC_32K_CAL_REGISTERS)) & 0xfff000ff))
#define SET_RG_RF_D_REG(_VAL_) (REG32(ADR_RF_D_DIGITAL_DEBUG_PORT_REGISTER)) = (((_VAL_) << 0) | ((REG32(ADR_RF_D_DIGITAL_DEBUG_PORT_REGISTER)) & 0xffff0000))
#define SET_DIRECT_MODE(_VAL_) (REG32(ADR_MMU_CTRL)) = (((_VAL_) << 0) | ((REG32(ADR_MMU_CTRL)) & 0xfffffffe))
#define SET_TAG_INTERLEAVE_MD(_VAL_) (REG32(ADR_MMU_CTRL)) = (((_VAL_) << 1) | ((REG32(ADR_MMU_CTRL)) & 0xfffffffd))
#define SET_DIS_DEMAND(_VAL_) (REG32(ADR_MMU_CTRL)) = (((_VAL_) << 2) | ((REG32(ADR_MMU_CTRL)) & 0xfffffffb))
#define SET_SAME_ID_ALLOC_MD(_VAL_) (REG32(ADR_MMU_CTRL)) = (((_VAL_) << 3) | ((REG32(ADR_MMU_CTRL)) & 0xfffffff7))
#define SET_HS_ACCESS_MD(_VAL_) (REG32(ADR_MMU_CTRL)) = (((_VAL_) << 4) | ((REG32(ADR_MMU_CTRL)) & 0xffffffef))
#define SET_SRAM_ACCESS_MD(_VAL_) (REG32(ADR_MMU_CTRL)) = (((_VAL_) << 5) | ((REG32(ADR_MMU_CTRL)) & 0xffffffdf))
#define SET_NOHIT_RPASS_MD(_VAL_) (REG32(ADR_MMU_CTRL)) = (((_VAL_) << 6) | ((REG32(ADR_MMU_CTRL)) & 0xffffffbf))
#define SET_DMN_FLAG_CLR(_VAL_) (REG32(ADR_MMU_CTRL)) = (((_VAL_) << 7) | ((REG32(ADR_MMU_CTRL)) & 0xffffff7f))
#define SET_ERR_SW_RST_N(_VAL_) (REG32(ADR_MMU_CTRL)) = (((_VAL_) << 8) | ((REG32(ADR_MMU_CTRL)) & 0xfffffeff))
#define SET_ALR_SW_RST_N(_VAL_) (REG32(ADR_MMU_CTRL)) = (((_VAL_) << 9) | ((REG32(ADR_MMU_CTRL)) & 0xfffffdff))
#define SET_MCH_SW_RST_N(_VAL_) (REG32(ADR_MMU_CTRL)) = (((_VAL_) << 10) | ((REG32(ADR_MMU_CTRL)) & 0xfffffbff))
#define SET_TAG_SW_RST_N(_VAL_) (REG32(ADR_MMU_CTRL)) = (((_VAL_) << 11) | ((REG32(ADR_MMU_CTRL)) & 0xfffff7ff))
#define SET_ABT_SW_RST_N(_VAL_) (REG32(ADR_MMU_CTRL)) = (((_VAL_) << 12) | ((REG32(ADR_MMU_CTRL)) & 0xffffefff))
#define SET_MMU_VER(_VAL_) (REG32(ADR_MMU_CTRL)) = (((_VAL_) << 13) | ((REG32(ADR_MMU_CTRL)) & 0xffff1fff))
#define SET_MMU_SHARE_MCU(_VAL_) (REG32(ADR_MMU_CTRL)) = (((_VAL_) << 16) | ((REG32(ADR_MMU_CTRL)) & 0xff00ffff))
#define SET_HS_WR(_VAL_) (REG32(ADR_HS_CTRL)) = (((_VAL_) << 0) | ((REG32(ADR_HS_CTRL)) & 0xfffffffe))
#define SET_HS_FLAG(_VAL_) (REG32(ADR_HS_CTRL)) = (((_VAL_) << 4) | ((REG32(ADR_HS_CTRL)) & 0xffffffef))
#define SET_HS_ID(_VAL_) (REG32(ADR_HS_CTRL)) = (((_VAL_) << 8) | ((REG32(ADR_HS_CTRL)) & 0xffff80ff))
#define SET_HS_CHANNEL(_VAL_) (REG32(ADR_HS_CTRL)) = (((_VAL_) << 16) | ((REG32(ADR_HS_CTRL)) & 0xfff0ffff))
#define SET_HS_PAGE(_VAL_) (REG32(ADR_HS_CTRL)) = (((_VAL_) << 20) | ((REG32(ADR_HS_CTRL)) & 0xff0fffff))
#define SET_HS_DATA(_VAL_) (REG32(ADR_HS_CTRL)) = (((_VAL_) << 24) | ((REG32(ADR_HS_CTRL)) & 0x00ffffff))
#define SET_CPU_POR0(_VAL_) (REG32(ADR_CPU_POR0_7)) = (((_VAL_) << 0) | ((REG32(ADR_CPU_POR0_7)) & 0xfffffff0))
#define SET_CPU_POR1(_VAL_) (REG32(ADR_CPU_POR0_7)) = (((_VAL_) << 4) | ((REG32(ADR_CPU_POR0_7)) & 0xffffff0f))
#define SET_CPU_POR2(_VAL_) (REG32(ADR_CPU_POR0_7)) = (((_VAL_) << 8) | ((REG32(ADR_CPU_POR0_7)) & 0xfffff0ff))
#define SET_CPU_POR3(_VAL_) (REG32(ADR_CPU_POR0_7)) = (((_VAL_) << 12) | ((REG32(ADR_CPU_POR0_7)) & 0xffff0fff))
#define SET_CPU_POR4(_VAL_) (REG32(ADR_CPU_POR0_7)) = (((_VAL_) << 16) | ((REG32(ADR_CPU_POR0_7)) & 0xfff0ffff))
#define SET_CPU_POR5(_VAL_) (REG32(ADR_CPU_POR0_7)) = (((_VAL_) << 20) | ((REG32(ADR_CPU_POR0_7)) & 0xff0fffff))
#define SET_CPU_POR6(_VAL_) (REG32(ADR_CPU_POR0_7)) = (((_VAL_) << 24) | ((REG32(ADR_CPU_POR0_7)) & 0xf0ffffff))
#define SET_CPU_POR7(_VAL_) (REG32(ADR_CPU_POR0_7)) = (((_VAL_) << 28) | ((REG32(ADR_CPU_POR0_7)) & 0x0fffffff))
#define SET_CPU_POR8(_VAL_) (REG32(ADR_CPU_POR8_F)) = (((_VAL_) << 0) | ((REG32(ADR_CPU_POR8_F)) & 0xfffffff0))
#define SET_CPU_POR9(_VAL_) (REG32(ADR_CPU_POR8_F)) = (((_VAL_) << 4) | ((REG32(ADR_CPU_POR8_F)) & 0xffffff0f))
#define SET_CPU_PORA(_VAL_) (REG32(ADR_CPU_POR8_F)) = (((_VAL_) << 8) | ((REG32(ADR_CPU_POR8_F)) & 0xfffff0ff))
#define SET_CPU_PORB(_VAL_) (REG32(ADR_CPU_POR8_F)) = (((_VAL_) << 12) | ((REG32(ADR_CPU_POR8_F)) & 0xffff0fff))
#define SET_CPU_PORC(_VAL_) (REG32(ADR_CPU_POR8_F)) = (((_VAL_) << 16) | ((REG32(ADR_CPU_POR8_F)) & 0xfff0ffff))
#define SET_CPU_PORD(_VAL_) (REG32(ADR_CPU_POR8_F)) = (((_VAL_) << 20) | ((REG32(ADR_CPU_POR8_F)) & 0xff0fffff))
#define SET_CPU_PORE(_VAL_) (REG32(ADR_CPU_POR8_F)) = (((_VAL_) << 24) | ((REG32(ADR_CPU_POR8_F)) & 0xf0ffffff))
#define SET_CPU_PORF(_VAL_) (REG32(ADR_CPU_POR8_F)) = (((_VAL_) << 28) | ((REG32(ADR_CPU_POR8_F)) & 0x0fffffff))
#define SET_ACC_WR_LEN(_VAL_) (REG32(ADR_REG_LEN_CTRL)) = (((_VAL_) << 0) | ((REG32(ADR_REG_LEN_CTRL)) & 0xffffffc0))
#define SET_ACC_RD_LEN(_VAL_) (REG32(ADR_REG_LEN_CTRL)) = (((_VAL_) << 8) | ((REG32(ADR_REG_LEN_CTRL)) & 0xffffc0ff))
#define SET_REQ_NACK_CLR(_VAL_) (REG32(ADR_REG_LEN_CTRL)) = (((_VAL_) << 15) | ((REG32(ADR_REG_LEN_CTRL)) & 0xffff7fff))
#define SET_NACK_FLAG_BUS(_VAL_) (REG32(ADR_REG_LEN_CTRL)) = (((_VAL_) << 16) | ((REG32(ADR_REG_LEN_CTRL)) & 0x0000ffff))
#define SET_DMN_R_PASS(_VAL_) (REG32(ADR_DMN_READ_BYPASS)) = (((_VAL_) << 0) | ((REG32(ADR_DMN_READ_BYPASS)) & 0xffff0000))
#define SET_PARA_ALC_RLS(_VAL_) (REG32(ADR_DMN_READ_BYPASS)) = (((_VAL_) << 16) | ((REG32(ADR_DMN_READ_BYPASS)) & 0xfffeffff))
#define SET_REQ_PORNS_CHGEN(_VAL_) (REG32(ADR_DMN_READ_BYPASS)) = (((_VAL_) << 24) | ((REG32(ADR_DMN_READ_BYPASS)) & 0xfeffffff))
#define SET_ALC_ABT_ID(_VAL_) (REG32(ADR_ALC_RLS_ABORT)) = (((_VAL_) << 0) | ((REG32(ADR_ALC_RLS_ABORT)) & 0xffffff80))
#define SET_ALC_ABT_INT(_VAL_) (REG32(ADR_ALC_RLS_ABORT)) = (((_VAL_) << 15) | ((REG32(ADR_ALC_RLS_ABORT)) & 0xffff7fff))
#define SET_RLS_ABT_ID(_VAL_) (REG32(ADR_ALC_RLS_ABORT)) = (((_VAL_) << 16) | ((REG32(ADR_ALC_RLS_ABORT)) & 0xff80ffff))
#define SET_RLS_ABT_INT(_VAL_) (REG32(ADR_ALC_RLS_ABORT)) = (((_VAL_) << 31) | ((REG32(ADR_ALC_RLS_ABORT)) & 0x7fffffff))
#define SET_DEBUG_CTL(_VAL_) (REG32(ADR_DEBUG_CTL)) = (((_VAL_) << 0) | ((REG32(ADR_DEBUG_CTL)) & 0xffffff00))
#define SET_DEBUG_H16(_VAL_) (REG32(ADR_DEBUG_CTL)) = (((_VAL_) << 8) | ((REG32(ADR_DEBUG_CTL)) & 0xfffffeff))
#define SET_DEBUG_OUT(_VAL_) (REG32(ADR_DEBUG_OUT)) = (((_VAL_) << 0) | ((REG32(ADR_DEBUG_OUT)) & 0x00000000))
#define SET_ALC_ERR(_VAL_) (REG32(ADR_MMU_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_MMU_STATUS)) & 0xfffffffe))
#define SET_RLS_ERR(_VAL_) (REG32(ADR_MMU_STATUS)) = (((_VAL_) << 1) | ((REG32(ADR_MMU_STATUS)) & 0xfffffffd))
#define SET_AL_STATE(_VAL_) (REG32(ADR_MMU_STATUS)) = (((_VAL_) << 8) | ((REG32(ADR_MMU_STATUS)) & 0xfffff8ff))
#define SET_RL_STATE(_VAL_) (REG32(ADR_MMU_STATUS)) = (((_VAL_) << 12) | ((REG32(ADR_MMU_STATUS)) & 0xffff8fff))
#define SET_ALC_ERR_ID(_VAL_) (REG32(ADR_MMU_STATUS)) = (((_VAL_) << 16) | ((REG32(ADR_MMU_STATUS)) & 0xff80ffff))
#define SET_RLS_ERR_ID(_VAL_) (REG32(ADR_MMU_STATUS)) = (((_VAL_) << 24) | ((REG32(ADR_MMU_STATUS)) & 0x80ffffff))
#define SET_DMN_NOHIT_FLAG(_VAL_) (REG32(ADR_DMN_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_DMN_STATUS)) & 0xfffffffe))
#define SET_DMN_FLAG(_VAL_) (REG32(ADR_DMN_STATUS)) = (((_VAL_) << 1) | ((REG32(ADR_DMN_STATUS)) & 0xfffffffd))
#define SET_DMN_WR(_VAL_) (REG32(ADR_DMN_STATUS)) = (((_VAL_) << 3) | ((REG32(ADR_DMN_STATUS)) & 0xfffffff7))
#define SET_DMN_PORT(_VAL_) (REG32(ADR_DMN_STATUS)) = (((_VAL_) << 4) | ((REG32(ADR_DMN_STATUS)) & 0xffffff0f))
#define SET_DMN_NHIT_ID(_VAL_) (REG32(ADR_DMN_STATUS)) = (((_VAL_) << 8) | ((REG32(ADR_DMN_STATUS)) & 0xffff80ff))
#define SET_DMN_NHIT_ADDR(_VAL_) (REG32(ADR_DMN_STATUS)) = (((_VAL_) << 16) | ((REG32(ADR_DMN_STATUS)) & 0x0000ffff))
#define SET_TX_MOUNT(_VAL_) (REG32(ADR_TAG_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_TAG_STATUS)) & 0xffffff00))
#define SET_RX_MOUNT(_VAL_) (REG32(ADR_TAG_STATUS)) = (((_VAL_) << 8) | ((REG32(ADR_TAG_STATUS)) & 0xffff00ff))
#define SET_AVA_TAG(_VAL_) (REG32(ADR_TAG_STATUS)) = (((_VAL_) << 16) | ((REG32(ADR_TAG_STATUS)) & 0xfe00ffff))
#define SET_PKTBUF_FULL(_VAL_) (REG32(ADR_TAG_STATUS)) = (((_VAL_) << 31) | ((REG32(ADR_TAG_STATUS)) & 0x7fffffff))
#define SET_DMN_NOHIT_MCU(_VAL_) (REG32(ADR_DMN_MCU_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_DMN_MCU_STATUS)) & 0xfffffffe))
#define SET_DMN_MCU_FLAG(_VAL_) (REG32(ADR_DMN_MCU_STATUS)) = (((_VAL_) << 1) | ((REG32(ADR_DMN_MCU_STATUS)) & 0xfffffffd))
#define SET_DMN_MCU_WR(_VAL_) (REG32(ADR_DMN_MCU_STATUS)) = (((_VAL_) << 3) | ((REG32(ADR_DMN_MCU_STATUS)) & 0xfffffff7))
#define SET_DMN_MCU_PORT(_VAL_) (REG32(ADR_DMN_MCU_STATUS)) = (((_VAL_) << 4) | ((REG32(ADR_DMN_MCU_STATUS)) & 0xffffff0f))
#define SET_DMN_MCU_ID(_VAL_) (REG32(ADR_DMN_MCU_STATUS)) = (((_VAL_) << 8) | ((REG32(ADR_DMN_MCU_STATUS)) & 0xffff80ff))
#define SET_DMN_MCU_ADDR(_VAL_) (REG32(ADR_DMN_MCU_STATUS)) = (((_VAL_) << 16) | ((REG32(ADR_DMN_MCU_STATUS)) & 0x0000ffff))
#define SET_MB_IDTBL_31_0(_VAL_) (REG32(ADR_MB_IDTBL_0_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_MB_IDTBL_0_STATUS)) & 0x00000000))
#define SET_MB_IDTBL_63_32(_VAL_) (REG32(ADR_MB_IDTBL_1_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_MB_IDTBL_1_STATUS)) & 0x00000000))
#define SET_MB_IDTBL_95_64(_VAL_) (REG32(ADR_MB_IDTBL_2_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_MB_IDTBL_2_STATUS)) & 0x00000000))
#define SET_MB_IDTBL_127_96(_VAL_) (REG32(ADR_MB_IDTBL_3_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_MB_IDTBL_3_STATUS)) & 0x00000000))
#define SET_PKT_IDTBL_31_0(_VAL_) (REG32(ADR_PKT_IDTBL_0_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_PKT_IDTBL_0_STATUS)) & 0x00000000))
#define SET_PKT_IDTBL_63_32(_VAL_) (REG32(ADR_PKT_IDTBL_1_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_PKT_IDTBL_1_STATUS)) & 0x00000000))
#define SET_PKT_IDTBL_95_64(_VAL_) (REG32(ADR_PKT_IDTBL_2_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_PKT_IDTBL_2_STATUS)) & 0x00000000))
#define SET_PKT_IDTBL_127_96(_VAL_) (REG32(ADR_PKT_IDTBL_3_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_PKT_IDTBL_3_STATUS)) & 0x00000000))
#define SET_DMN_IDTBL_31_0(_VAL_) (REG32(ADR_DMN_IDTBL_0_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_DMN_IDTBL_0_STATUS)) & 0x00000000))
#define SET_DMN_IDTBL_63_32(_VAL_) (REG32(ADR_DMN_IDTBL_1_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_DMN_IDTBL_1_STATUS)) & 0x00000000))
#define SET_DMN_IDTBL_95_64(_VAL_) (REG32(ADR_DMN_IDTBL_2_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_DMN_IDTBL_2_STATUS)) & 0x00000000))
#define SET_DMN_IDTBL_127_96(_VAL_) (REG32(ADR_DMN_IDTBL_3_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_DMN_IDTBL_3_STATUS)) & 0x00000000))
#define SET_NEQ_MB_ID_31_0(_VAL_) (REG32(ADR_MB_NEQID_0_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_MB_NEQID_0_STATUS)) & 0x00000000))
#define SET_NEQ_MB_ID_63_32(_VAL_) (REG32(ADR_MB_NEQID_1_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_MB_NEQID_1_STATUS)) & 0x00000000))
#define SET_NEQ_MB_ID_95_64(_VAL_) (REG32(ADR_MB_NEQID_2_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_MB_NEQID_2_STATUS)) & 0x00000000))
#define SET_NEQ_MB_ID_127_96(_VAL_) (REG32(ADR_MB_NEQID_3_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_MB_NEQID_3_STATUS)) & 0x00000000))
#define SET_NEQ_PKT_ID_31_0(_VAL_) (REG32(ADR_PKT_NEQID_0_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_PKT_NEQID_0_STATUS)) & 0x00000000))
#define SET_NEQ_PKT_ID_63_32(_VAL_) (REG32(ADR_PKT_NEQID_1_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_PKT_NEQID_1_STATUS)) & 0x00000000))
#define SET_NEQ_PKT_ID_95_64(_VAL_) (REG32(ADR_PKT_NEQID_2_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_PKT_NEQID_2_STATUS)) & 0x00000000))
#define SET_NEQ_PKT_ID_127_96(_VAL_) (REG32(ADR_PKT_NEQID_3_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_PKT_NEQID_3_STATUS)) & 0x00000000))
#define SET_ALC_NOCHG_ID(_VAL_) (REG32(ADR_ALC_NOCHG_ID_STATUS)) = (((_VAL_) << 0) | ((REG32(ADR_ALC_NOCHG_ID_STATUS)) & 0xffffff80))
#define SET_ALC_NOCHG_INT(_VAL_) (REG32(ADR_ALC_NOCHG_ID_STATUS)) = (((_VAL_) << 15) | ((REG32(ADR_ALC_NOCHG_ID_STATUS)) & 0xffff7fff))
#define SET_NEQ_PKT_FLAG(_VAL_) (REG32(ADR_ALC_NOCHG_ID_STATUS)) = (((_VAL_) << 16) | ((REG32(ADR_ALC_NOCHG_ID_STATUS)) & 0xfffeffff))
#define SET_NEQ_MB_FLAG(_VAL_) (REG32(ADR_ALC_NOCHG_ID_STATUS)) = (((_VAL_) << 24) | ((REG32(ADR_ALC_NOCHG_ID_STATUS)) & 0xfeffffff))
#define SET_SRAM_TAG_0(_VAL_) (REG32(ADR_TAG_SRAM0_F_STATUS_0)) = (((_VAL_) << 0) | ((REG32(ADR_TAG_SRAM0_F_STATUS_0)) & 0xffff0000))
#define SET_SRAM_TAG_1(_VAL_) (REG32(ADR_TAG_SRAM0_F_STATUS_0)) = (((_VAL_) << 16) | ((REG32(ADR_TAG_SRAM0_F_STATUS_0)) & 0x0000ffff))
#define SET_SRAM_TAG_2(_VAL_) (REG32(ADR_TAG_SRAM0_F_STATUS_1)) = (((_VAL_) << 0) | ((REG32(ADR_TAG_SRAM0_F_STATUS_1)) & 0xffff0000))
#define SET_SRAM_TAG_3(_VAL_) (REG32(ADR_TAG_SRAM0_F_STATUS_1)) = (((_VAL_) << 16) | ((REG32(ADR_TAG_SRAM0_F_STATUS_1)) & 0x0000ffff))
#define SET_SRAM_TAG_4(_VAL_) (REG32(ADR_TAG_SRAM0_F_STATUS_2)) = (((_VAL_) << 0) | ((REG32(ADR_TAG_SRAM0_F_STATUS_2)) & 0xffff0000))
#define SET_SRAM_TAG_5(_VAL_) (REG32(ADR_TAG_SRAM0_F_STATUS_2)) = (((_VAL_) << 16) | ((REG32(ADR_TAG_SRAM0_F_STATUS_2)) & 0x0000ffff))
#define SET_SRAM_TAG_6(_VAL_) (REG32(ADR_TAG_SRAM0_F_STATUS_3)) = (((_VAL_) << 0) | ((REG32(ADR_TAG_SRAM0_F_STATUS_3)) & 0xffff0000))
#define SET_SRAM_TAG_7(_VAL_) (REG32(ADR_TAG_SRAM0_F_STATUS_3)) = (((_VAL_) << 16) | ((REG32(ADR_TAG_SRAM0_F_STATUS_3)) & 0x0000ffff))
#define SET_SRAM_TAG_8(_VAL_) (REG32(ADR_TAG_SRAM0_F_STATUS_4)) = (((_VAL_) << 0) | ((REG32(ADR_TAG_SRAM0_F_STATUS_4)) & 0xffff0000))
#define SET_SRAM_TAG_9(_VAL_) (REG32(ADR_TAG_SRAM0_F_STATUS_4)) = (((_VAL_) << 16) | ((REG32(ADR_TAG_SRAM0_F_STATUS_4)) & 0x0000ffff))
#define SET_SRAM_TAG_10(_VAL_) (REG32(ADR_TAG_SRAM0_F_STATUS_5)) = (((_VAL_) << 0) | ((REG32(ADR_TAG_SRAM0_F_STATUS_5)) & 0xffff0000))
#define SET_SRAM_TAG_11(_VAL_) (REG32(ADR_TAG_SRAM0_F_STATUS_5)) = (((_VAL_) << 16) | ((REG32(ADR_TAG_SRAM0_F_STATUS_5)) & 0x0000ffff))
#define SET_SRAM_TAG_12(_VAL_) (REG32(ADR_TAG_SRAM0_F_STATUS_6)) = (((_VAL_) << 0) | ((REG32(ADR_TAG_SRAM0_F_STATUS_6)) & 0xffff0000))
#define SET_SRAM_TAG_13(_VAL_) (REG32(ADR_TAG_SRAM0_F_STATUS_6)) = (((_VAL_) << 16) | ((REG32(ADR_TAG_SRAM0_F_STATUS_6)) & 0x0000ffff))
#define SET_SRAM_TAG_14(_VAL_) (REG32(ADR_TAG_SRAM0_F_STATUS_7)) = (((_VAL_) << 0) | ((REG32(ADR_TAG_SRAM0_F_STATUS_7)) & 0xffff0000))
#define SET_SRAM_TAG_15(_VAL_) (REG32(ADR_TAG_SRAM0_F_STATUS_7)) = (((_VAL_) << 16) | ((REG32(ADR_TAG_SRAM0_F_STATUS_7)) & 0x0000ffff))
#define DEF_BRG_SW_RST() (REG32(ADR_BRG_SW_RST)) = (0x00000000)
#define DEF_BOOT() (REG32(ADR_BOOT)) = (0x00040000)
#define DEF_CHIP_ID_0() (REG32(ADR_CHIP_ID_0)) = (0x31333131)
#define DEF_CHIP_ID_1() (REG32(ADR_CHIP_ID_1)) = (0x322d3230)
#define DEF_CHIP_ID_2() (REG32(ADR_CHIP_ID_2)) = (0x32303041)
#define DEF_CHIP_ID_3() (REG32(ADR_CHIP_ID_3)) = (0x53535636)
#define DEF_CLOCK_SELECTION() (REG32(ADR_CLOCK_SELECTION)) = (0x00000000)
#define DEF_PLATFORM_CLOCK_ENABLE() (REG32(ADR_PLATFORM_CLOCK_ENABLE)) = (0x008fffff)
#define DEF_SYS_CSR_CLOCK_ENABLE() (REG32(ADR_SYS_CSR_CLOCK_ENABLE)) = (0x00000400)
#define DEF_MCU_DBG_SEL() (REG32(ADR_MCU_DBG_SEL)) = (0x00000000)
#define DEF_MCU_DBG_DATA() (REG32(ADR_MCU_DBG_DATA)) = (0x00000000)
#define DEF_AHB_BRG_STATUS() (REG32(ADR_AHB_BRG_STATUS)) = (0x00000000)
#define DEF_BIST_BIST_CTRL() (REG32(ADR_BIST_BIST_CTRL)) = (0x00000000)
#define DEF_BIST_MODE_REG_IN() (REG32(ADR_BIST_MODE_REG_IN)) = (0x001ffe3e)
#define DEF_BIST_MODE_REG_OUT() (REG32(ADR_BIST_MODE_REG_OUT)) = (0x00000000)
#define DEF_BIST_MONITOR_BUS_LSB() (REG32(ADR_BIST_MONITOR_BUS_LSB)) = (0x00000000)
#define DEF_BIST_MONITOR_BUS_MSB() (REG32(ADR_BIST_MONITOR_BUS_MSB)) = (0x00000000)
#define DEF_TB_ADR_SEL() (REG32(ADR_TB_ADR_SEL)) = (0x00000000)
#define DEF_TB_RDATA() (REG32(ADR_TB_RDATA)) = (0x00000000)
#define DEF_UART_W2B() (REG32(ADR_UART_W2B)) = (0x00000000)
#define DEF_AHB_ILL_ADDR() (REG32(ADR_AHB_ILL_ADDR)) = (0x00000000)
#define DEF_AHB_FEN_ADDR() (REG32(ADR_AHB_FEN_ADDR)) = (0x00000000)
#define DEF_AHB_ILLFEN_STATUS() (REG32(ADR_AHB_ILLFEN_STATUS)) = (0x00000000)
#define DEF_PWM_A() (REG32(ADR_PWM_A)) = (0x400a1010)
#define DEF_PWM_B() (REG32(ADR_PWM_B)) = (0x400a1010)
#define DEF_HBUSREQ_LOCK() (REG32(ADR_HBUSREQ_LOCK)) = (0x00001ffd)
#define DEF_HBURST_LOCK() (REG32(ADR_HBURST_LOCK)) = (0x00000000)
#define DEF_PRESCALER_USTIMER() (REG32(ADR_PRESCALER_USTIMER)) = (0x00000028)
#define DEF_BIST_MODE_REG_IN_MMU() (REG32(ADR_BIST_MODE_REG_IN_MMU)) = (0x0000fe3e)
#define DEF_BIST_MODE_REG_OUT_MMU() (REG32(ADR_BIST_MODE_REG_OUT_MMU)) = (0x00000000)
#define DEF_BIST_MONITOR_BUS_MMU() (REG32(ADR_BIST_MONITOR_BUS_MMU)) = (0x00000000)
#define DEF_TEST_MODE() (REG32(ADR_TEST_MODE)) = (0x00000000)
#define DEF_BOOT_INFO() (REG32(ADR_BOOT_INFO)) = (0x00000000)
#define DEF_SD_INIT_CFG() (REG32(ADR_SD_INIT_CFG)) = (0x00000000)
#define DEF_SPARE_UART_INFO() (REG32(ADR_SPARE_UART_INFO)) = (0x00000000)
#define DEF_TU0_MICROSECOND_TIMER() (REG32(ADR_TU0_MICROSECOND_TIMER)) = (0x00000000)
#define DEF_TU0_CURRENT_MICROSECOND_TIME_VALUE() (REG32(ADR_TU0_CURRENT_MICROSECOND_TIME_VALUE)) = (0x00000000)
#define DEF_TU0_DUMMY_BIT_0() (REG32(ADR_TU0_DUMMY_BIT_0)) = (0x00000000)
#define DEF_TU0_DUMMY_BIT_1() (REG32(ADR_TU0_DUMMY_BIT_1)) = (0x00000000)
#define DEF_TU1_MICROSECOND_TIMER() (REG32(ADR_TU1_MICROSECOND_TIMER)) = (0x00000000)
#define DEF_TU1_CURRENT_MICROSECOND_TIME_VALUE() (REG32(ADR_TU1_CURRENT_MICROSECOND_TIME_VALUE)) = (0x00000000)
#define DEF_TU1_DUMMY_BIT_0() (REG32(ADR_TU1_DUMMY_BIT_0)) = (0x00000000)
#define DEF_TU1_DUMMY_BIT_1() (REG32(ADR_TU1_DUMMY_BIT_1)) = (0x00000000)
#define DEF_TU2_MICROSECOND_TIMER() (REG32(ADR_TU2_MICROSECOND_TIMER)) = (0x00000000)
#define DEF_TU2_CURRENT_MICROSECOND_TIME_VALUE() (REG32(ADR_TU2_CURRENT_MICROSECOND_TIME_VALUE)) = (0x00000000)
#define DEF_TU2_DUMMY_BIT_0() (REG32(ADR_TU2_DUMMY_BIT_0)) = (0x00000000)
#define DEF_TU2_DUMMY_BIT_1() (REG32(ADR_TU2_DUMMY_BIT_1)) = (0x00000000)
#define DEF_TU3_MICROSECOND_TIMER() (REG32(ADR_TU3_MICROSECOND_TIMER)) = (0x00000000)
#define DEF_TU3_CURRENT_MICROSECOND_TIME_VALUE() (REG32(ADR_TU3_CURRENT_MICROSECOND_TIME_VALUE)) = (0x00000000)
#define DEF_TU3_DUMMY_BIT_0() (REG32(ADR_TU3_DUMMY_BIT_0)) = (0x00000000)
#define DEF_TU3_DUMMY_BIT_1() (REG32(ADR_TU3_DUMMY_BIT_1)) = (0x00000000)
#define DEF_TM0_MILISECOND_TIMER() (REG32(ADR_TM0_MILISECOND_TIMER)) = (0x00000000)
#define DEF_TM0_CURRENT_MILISECOND_TIME_VALUE() (REG32(ADR_TM0_CURRENT_MILISECOND_TIME_VALUE)) = (0x00000000)
#define DEF_TM0_DUMMY_BIT_0() (REG32(ADR_TM0_DUMMY_BIT_0)) = (0x00000000)
#define DEF_TM0_DUMMY_BIT_1() (REG32(ADR_TM0_DUMMY_BIT_1)) = (0x00000000)
#define DEF_TM1_MILISECOND_TIMER() (REG32(ADR_TM1_MILISECOND_TIMER)) = (0x00000000)
#define DEF_TM1_CURRENT_MILISECOND_TIME_VALUE() (REG32(ADR_TM1_CURRENT_MILISECOND_TIME_VALUE)) = (0x00000000)
#define DEF_TM1_DUMMY_BIT_0() (REG32(ADR_TM1_DUMMY_BIT_0)) = (0x00000000)
#define DEF_TM1_DUMMY_BIT_1() (REG32(ADR_TM1_DUMMY_BIT_1)) = (0x00000000)
#define DEF_TM2_MILISECOND_TIMER() (REG32(ADR_TM2_MILISECOND_TIMER)) = (0x00000000)
#define DEF_TM2_CURRENT_MILISECOND_TIME_VALUE() (REG32(ADR_TM2_CURRENT_MILISECOND_TIME_VALUE)) = (0x00000000)
#define DEF_TM2_DUMMY_BIT_0() (REG32(ADR_TM2_DUMMY_BIT_0)) = (0x00000000)
#define DEF_TM2_DUMMY_BIT_1() (REG32(ADR_TM2_DUMMY_BIT_1)) = (0x00000000)
#define DEF_TM3_MILISECOND_TIMER() (REG32(ADR_TM3_MILISECOND_TIMER)) = (0x00000000)
#define DEF_TM3_CURRENT_MILISECOND_TIME_VALUE() (REG32(ADR_TM3_CURRENT_MILISECOND_TIME_VALUE)) = (0x00000000)
#define DEF_TM3_DUMMY_BIT_0() (REG32(ADR_TM3_DUMMY_BIT_0)) = (0x00000000)
#define DEF_TM3_DUMMY_BIT_1() (REG32(ADR_TM3_DUMMY_BIT_1)) = (0x00000000)
#define DEF_MCU_WDOG_REG() (REG32(ADR_MCU_WDOG_REG)) = (0x00000000)
#define DEF_SYS_WDOG_REG() (REG32(ADR_SYS_WDOG_REG)) = (0x00000000)
#define DEF_PAD6() (REG32(ADR_PAD6)) = (0x00000008)
#define DEF_PAD7() (REG32(ADR_PAD7)) = (0x00000008)
#define DEF_PAD8() (REG32(ADR_PAD8)) = (0x00000008)
#define DEF_PAD9() (REG32(ADR_PAD9)) = (0x00000008)
#define DEF_PAD11() (REG32(ADR_PAD11)) = (0x00000008)
#define DEF_PAD15() (REG32(ADR_PAD15)) = (0x0000000a)
#define DEF_PAD16() (REG32(ADR_PAD16)) = (0x0000000a)
#define DEF_PAD17() (REG32(ADR_PAD17)) = (0x0000000a)
#define DEF_PAD18() (REG32(ADR_PAD18)) = (0x0000000a)
#define DEF_PAD19() (REG32(ADR_PAD19)) = (0x00007000)
#define DEF_PAD20() (REG32(ADR_PAD20)) = (0x0000000a)
#define DEF_PAD21() (REG32(ADR_PAD21)) = (0x0000000a)
#define DEF_PAD22() (REG32(ADR_PAD22)) = (0x00000009)
#define DEF_PAD24() (REG32(ADR_PAD24)) = (0x00000008)
#define DEF_PAD25() (REG32(ADR_PAD25)) = (0x0000000b)
#define DEF_PAD27() (REG32(ADR_PAD27)) = (0x00000008)
#define DEF_PAD28() (REG32(ADR_PAD28)) = (0x00000008)
#define DEF_PAD29() (REG32(ADR_PAD29)) = (0x00000009)
#define DEF_PAD30() (REG32(ADR_PAD30)) = (0x0000000a)
#define DEF_PAD31() (REG32(ADR_PAD31)) = (0x0000000a)
#define DEF_PAD32() (REG32(ADR_PAD32)) = (0x0000000a)
#define DEF_PAD33() (REG32(ADR_PAD33)) = (0x0000000a)
#define DEF_PAD34() (REG32(ADR_PAD34)) = (0x0000000a)
#define DEF_PAD42() (REG32(ADR_PAD42)) = (0x0000000a)
#define DEF_PAD43() (REG32(ADR_PAD43)) = (0x0000000a)
#define DEF_PAD44() (REG32(ADR_PAD44)) = (0x0000000a)
#define DEF_PAD45() (REG32(ADR_PAD45)) = (0x0000000a)
#define DEF_PAD46() (REG32(ADR_PAD46)) = (0x0000000a)
#define DEF_PAD47() (REG32(ADR_PAD47)) = (0x00100000)
#define DEF_PAD48() (REG32(ADR_PAD48)) = (0x00100808)
#define DEF_PAD49() (REG32(ADR_PAD49)) = (0x00100008)
#define DEF_PAD50() (REG32(ADR_PAD50)) = (0x00100008)
#define DEF_PAD51() (REG32(ADR_PAD51)) = (0x00100008)
#define DEF_PAD52() (REG32(ADR_PAD52)) = (0x00100000)
#define DEF_PAD53() (REG32(ADR_PAD53)) = (0x0000000a)
#define DEF_PAD54() (REG32(ADR_PAD54)) = (0x00000000)
#define DEF_PAD56() (REG32(ADR_PAD56)) = (0x00000000)
#define DEF_PAD57() (REG32(ADR_PAD57)) = (0x00000008)
#define DEF_PAD58() (REG32(ADR_PAD58)) = (0x0000000a)
#define DEF_PAD59() (REG32(ADR_PAD59)) = (0x0000000a)
#define DEF_PAD60() (REG32(ADR_PAD60)) = (0x0000000a)
#define DEF_PAD61() (REG32(ADR_PAD61)) = (0x0000000a)
#define DEF_PAD62() (REG32(ADR_PAD62)) = (0x0000000a)
#define DEF_PAD64() (REG32(ADR_PAD64)) = (0x00000009)
#define DEF_PAD65() (REG32(ADR_PAD65)) = (0x00000009)
#define DEF_PAD66() (REG32(ADR_PAD66)) = (0x00000008)
#define DEF_PAD68() (REG32(ADR_PAD68)) = (0x00000008)
#define DEF_PAD67() (REG32(ADR_PAD67)) = (0x00000159)
#define DEF_PAD69() (REG32(ADR_PAD69)) = (0x0000000b)
#define DEF_PAD70() (REG32(ADR_PAD70)) = (0x00000008)
#define DEF_PAD231() (REG32(ADR_PAD231)) = (0x00000008)
#define DEF_PIN_SEL_0() (REG32(ADR_PIN_SEL_0)) = (0x00000000)
#define DEF_PIN_SEL_1() (REG32(ADR_PIN_SEL_1)) = (0x00000000)
#define DEF_IO_PORT_REG() (REG32(ADR_IO_PORT_REG)) = (0x00010000)
#define DEF_INT_MASK_REG() (REG32(ADR_INT_MASK_REG)) = (0x000000ff)
#define DEF_INT_STATUS_REG() (REG32(ADR_INT_STATUS_REG)) = (0x00000000)
#define DEF_FN1_STATUS_REG() (REG32(ADR_FN1_STATUS_REG)) = (0x00000000)
#define DEF_CARD_PKT_STATUS_TEST() (REG32(ADR_CARD_PKT_STATUS_TEST)) = (0x00000000)
#define DEF_SYSTEM_INFORMATION_REG() (REG32(ADR_SYSTEM_INFORMATION_REG)) = (0x00000000)
#define DEF_CARD_RCA_REG() (REG32(ADR_CARD_RCA_REG)) = (0x00000000)
#define DEF_SDIO_FIFO_WR_THLD_REG() (REG32(ADR_SDIO_FIFO_WR_THLD_REG)) = (0x00000000)
#define DEF_SDIO_FIFO_WR_LIMIT_REG() (REG32(ADR_SDIO_FIFO_WR_LIMIT_REG)) = (0x00000000)
#define DEF_SDIO_TX_DATA_BATCH_SIZE_REG() (REG32(ADR_SDIO_TX_DATA_BATCH_SIZE_REG)) = (0x00000000)
#define DEF_SDIO_THLD_FOR_CMD53RD_REG() (REG32(ADR_SDIO_THLD_FOR_CMD53RD_REG)) = (0x00000000)
#define DEF_SDIO_RX_DATA_BATCH_SIZE_REG() (REG32(ADR_SDIO_RX_DATA_BATCH_SIZE_REG)) = (0x00000000)
#define DEF_SDIO_LOG_START_END_DATA_REG() (REG32(ADR_SDIO_LOG_START_END_DATA_REG)) = (0x00000000)
#define DEF_SDIO_BYTE_MODE_BATCH_SIZE_REG() (REG32(ADR_SDIO_BYTE_MODE_BATCH_SIZE_REG)) = (0x00000000)
#define DEF_SDIO_LAST_CMD_INDEX_CRC_REG() (REG32(ADR_SDIO_LAST_CMD_INDEX_CRC_REG)) = (0x00000000)
#define DEF_SDIO_LAST_CMD_ARG_REG() (REG32(ADR_SDIO_LAST_CMD_ARG_REG)) = (0x00000000)
#define DEF_SDIO_BUS_STATE_DEBUG_MONITOR() (REG32(ADR_SDIO_BUS_STATE_DEBUG_MONITOR)) = (0x00000000)
#define DEF_SDIO_CARD_STATUS_REG() (REG32(ADR_SDIO_CARD_STATUS_REG)) = (0x00000000)
#define DEF_R5_RESP_FLAG_OUT_TIMING() (REG32(ADR_R5_RESP_FLAG_OUT_TIMING)) = (0x00000000)
#define DEF_CMD52_DATA_FOR_LAST_TIME() (REG32(ADR_CMD52_DATA_FOR_LAST_TIME)) = (0x00000000)
#define DEF_FN1_DMA_START_ADDR_REG() (REG32(ADR_FN1_DMA_START_ADDR_REG)) = (0x00000000)
#define DEF_FN1_INT_CTRL_RESET() (REG32(ADR_FN1_INT_CTRL_RESET)) = (0x00000000)
#define DEF_IO_REG_PORT_REG() (REG32(ADR_IO_REG_PORT_REG)) = (0x00010020)
#define DEF_SDIO_FIFO_ERROR_CNT() (REG32(ADR_SDIO_FIFO_ERROR_CNT)) = (0x00000000)
#define DEF_SDIO_CRC7_CRC16_ERROR_REG() (REG32(ADR_SDIO_CRC7_CRC16_ERROR_REG)) = (0x00000000)
#define DEF_SDIO_BLOCK_CNT_INFO() (REG32(ADR_SDIO_BLOCK_CNT_INFO)) = (0x00000000)
#define DEF_RX_DATA_CMD52_ABORT_COUNT() (REG32(ADR_RX_DATA_CMD52_ABORT_COUNT)) = (0x00000000)
#define DEF_FIFO_PTR_READ_BLOCK_CNT() (REG32(ADR_FIFO_PTR_READ_BLOCK_CNT)) = (0x00000000)
#define DEF_TX_TIME_OUT_READ_CTRL() (REG32(ADR_TX_TIME_OUT_READ_CTRL)) = (0x00000000)
#define DEF_SDIO_TX_ALLOC_REG() (REG32(ADR_SDIO_TX_ALLOC_REG)) = (0x00000000)
#define DEF_SDIO_TX_INFORM() (REG32(ADR_SDIO_TX_INFORM)) = (0x00000000)
#define DEF_F1_BLOCK_SIZE_0_REG() (REG32(ADR_F1_BLOCK_SIZE_0_REG)) = (0x00000000)
#define DEF_SDIO_COMMAND_LOG_DATA_31_0() (REG32(ADR_SDIO_COMMAND_LOG_DATA_31_0)) = (0x000000ec)
#define DEF_SDIO_COMMAND_LOG_DATA_63_32() (REG32(ADR_SDIO_COMMAND_LOG_DATA_63_32)) = (0xce000000)
#define DEF_SYSTEM_INFORMATION_REGISTER() (REG32(ADR_SYSTEM_INFORMATION_REGISTER)) = (0x00000000)
#define DEF_CCCR_00H_REG() (REG32(ADR_CCCR_00H_REG)) = (0x00000000)
#define DEF_CCCR_04H_REG() (REG32(ADR_CCCR_04H_REG)) = (0x00000000)
#define DEF_CCCR_08H_REG() (REG32(ADR_CCCR_08H_REG)) = (0x00000000)
#define DEF_CCCR_13H_REG() (REG32(ADR_CCCR_13H_REG)) = (0x00000000)
#define DEF_FBR_100H_REG() (REG32(ADR_FBR_100H_REG)) = (0x00000000)
#define DEF_FBR_109H_REG() (REG32(ADR_FBR_109H_REG)) = (0x00000000)
#define DEF_F0_CIS_CONTENT_REG_0() (REG32(ADR_F0_CIS_CONTENT_REG_0)) = (0x00000000)
#define DEF_F0_CIS_CONTENT_REG_1() (REG32(ADR_F0_CIS_CONTENT_REG_1)) = (0x00000000)
#define DEF_F0_CIS_CONTENT_REG_2() (REG32(ADR_F0_CIS_CONTENT_REG_2)) = (0x00000000)
#define DEF_F0_CIS_CONTENT_REG_3() (REG32(ADR_F0_CIS_CONTENT_REG_3)) = (0x00000000)
#define DEF_F0_CIS_CONTENT_REG_4() (REG32(ADR_F0_CIS_CONTENT_REG_4)) = (0x00000000)
#define DEF_F0_CIS_CONTENT_REG_5() (REG32(ADR_F0_CIS_CONTENT_REG_5)) = (0x00000000)
#define DEF_F0_CIS_CONTENT_REG_6() (REG32(ADR_F0_CIS_CONTENT_REG_6)) = (0x00000000)
#define DEF_F0_CIS_CONTENT_REG_7() (REG32(ADR_F0_CIS_CONTENT_REG_7)) = (0x00000000)
#define DEF_F0_CIS_CONTENT_REG_8() (REG32(ADR_F0_CIS_CONTENT_REG_8)) = (0x00000000)
#define DEF_F0_CIS_CONTENT_REG_9() (REG32(ADR_F0_CIS_CONTENT_REG_9)) = (0x00000000)
#define DEF_F0_CIS_CONTENT_REG_10() (REG32(ADR_F0_CIS_CONTENT_REG_10)) = (0x00000000)
#define DEF_F0_CIS_CONTENT_REG_11() (REG32(ADR_F0_CIS_CONTENT_REG_11)) = (0x00000000)
#define DEF_F0_CIS_CONTENT_REG_12() (REG32(ADR_F0_CIS_CONTENT_REG_12)) = (0x00000000)
#define DEF_F0_CIS_CONTENT_REG_13() (REG32(ADR_F0_CIS_CONTENT_REG_13)) = (0x00000000)
#define DEF_F0_CIS_CONTENT_REG_14() (REG32(ADR_F0_CIS_CONTENT_REG_14)) = (0x00000000)
#define DEF_F0_CIS_CONTENT_REG_15() (REG32(ADR_F0_CIS_CONTENT_REG_15)) = (0x00000000)
#define DEF_F1_CIS_CONTENT_REG_0() (REG32(ADR_F1_CIS_CONTENT_REG_0)) = (0x00000000)
#define DEF_F1_CIS_CONTENT_REG_1() (REG32(ADR_F1_CIS_CONTENT_REG_1)) = (0x00000000)
#define DEF_F1_CIS_CONTENT_REG_2() (REG32(ADR_F1_CIS_CONTENT_REG_2)) = (0x00000000)
#define DEF_F1_CIS_CONTENT_REG_3() (REG32(ADR_F1_CIS_CONTENT_REG_3)) = (0x00000000)
#define DEF_F1_CIS_CONTENT_REG_4() (REG32(ADR_F1_CIS_CONTENT_REG_4)) = (0x00000000)
#define DEF_F1_CIS_CONTENT_REG_5() (REG32(ADR_F1_CIS_CONTENT_REG_5)) = (0x00000000)
#define DEF_F1_CIS_CONTENT_REG_6() (REG32(ADR_F1_CIS_CONTENT_REG_6)) = (0x00000000)
#define DEF_F1_CIS_CONTENT_REG_7() (REG32(ADR_F1_CIS_CONTENT_REG_7)) = (0x00000000)
#define DEF_F1_CIS_CONTENT_REG_8() (REG32(ADR_F1_CIS_CONTENT_REG_8)) = (0x00000000)
#define DEF_F1_CIS_CONTENT_REG_9() (REG32(ADR_F1_CIS_CONTENT_REG_9)) = (0x00000000)
#define DEF_F1_CIS_CONTENT_REG_10() (REG32(ADR_F1_CIS_CONTENT_REG_10)) = (0x00000000)
#define DEF_F1_CIS_CONTENT_REG_11() (REG32(ADR_F1_CIS_CONTENT_REG_11)) = (0x00000000)
#define DEF_F1_CIS_CONTENT_REG_12() (REG32(ADR_F1_CIS_CONTENT_REG_12)) = (0x00000000)
#define DEF_F1_CIS_CONTENT_REG_13() (REG32(ADR_F1_CIS_CONTENT_REG_13)) = (0x00000000)
#define DEF_F1_CIS_CONTENT_REG_14() (REG32(ADR_F1_CIS_CONTENT_REG_14)) = (0x00000000)
#define DEF_F1_CIS_CONTENT_REG_15() (REG32(ADR_F1_CIS_CONTENT_REG_15)) = (0x00000000)
#define DEF_SPI_MODE() (REG32(ADR_SPI_MODE)) = (0x00000000)
#define DEF_RX_QUOTA() (REG32(ADR_RX_QUOTA)) = (0x00000000)
#define DEF_CONDITION_NUMBER() (REG32(ADR_CONDITION_NUMBER)) = (0x00000004)
#define DEF_HOST_PATH() (REG32(ADR_HOST_PATH)) = (0x00000001)
#define DEF_TX_SEG() (REG32(ADR_TX_SEG)) = (0x00000000)
#define DEF_DEBUG_BURST_MODE() (REG32(ADR_DEBUG_BURST_MODE)) = (0x00000000)
#define DEF_SPI_TO_PHY_PARAM1() (REG32(ADR_SPI_TO_PHY_PARAM1)) = (0x000e0006)
#define DEF_SPI_TO_PHY_PARAM2() (REG32(ADR_SPI_TO_PHY_PARAM2)) = (0x000e000e)
#define DEF_SPI_STS() (REG32(ADR_SPI_STS)) = (0x00000000)
#define DEF_TX_ALLOC_SET() (REG32(ADR_TX_ALLOC_SET)) = (0x00000000)
#define DEF_TX_ALLOC() (REG32(ADR_TX_ALLOC)) = (0x00000000)
#define DEF_DBG_CNT() (REG32(ADR_DBG_CNT)) = (0x00000000)
#define DEF_DBG_CNT2() (REG32(ADR_DBG_CNT2)) = (0x00000000)
#define DEF_DBG_CNT3() (REG32(ADR_DBG_CNT3)) = (0x00000000)
#define DEF_DBG_CNT4() (REG32(ADR_DBG_CNT4)) = (0x00000000)
#define DEF_INT_TAG() (REG32(ADR_INT_TAG)) = (0x00000000)
#define DEF_I2CM_EN() (REG32(ADR_I2CM_EN)) = (0x00000074)
#define DEF_I2CM_DEV_A() (REG32(ADR_I2CM_DEV_A)) = (0x00008000)
#define DEF_I2CM_LEN() (REG32(ADR_I2CM_LEN)) = (0x00000000)
#define DEF_I2CM_WDAT() (REG32(ADR_I2CM_WDAT)) = (0x00000000)
#define DEF_I2CM_RDAT() (REG32(ADR_I2CM_RDAT)) = (0x00000000)
#define DEF_I2CM_EN_2() (REG32(ADR_I2CM_EN_2)) = (0x00010000)
#define DEF_UART_DATA() (REG32(ADR_UART_DATA)) = (0x00000000)
#define DEF_UART_IER() (REG32(ADR_UART_IER)) = (0x00000000)
#define DEF_UART_FCR() (REG32(ADR_UART_FCR)) = (0x00000001)
#define DEF_UART_LCR() (REG32(ADR_UART_LCR)) = (0x00000003)
#define DEF_UART_MCR() (REG32(ADR_UART_MCR)) = (0x00000000)
#define DEF_UART_LSR() (REG32(ADR_UART_LSR)) = (0x00000000)
#define DEF_UART_MSR() (REG32(ADR_UART_MSR)) = (0x00000000)
#define DEF_UART_SPR() (REG32(ADR_UART_SPR)) = (0x00000000)
#define DEF_UART_RTHR() (REG32(ADR_UART_RTHR)) = (0x000000c8)
#define DEF_UART_ISR() (REG32(ADR_UART_ISR)) = (0x000000c1)
#define DEF_DAT_UART_DATA() (REG32(ADR_DAT_UART_DATA)) = (0x00000000)
#define DEF_DAT_UART_IER() (REG32(ADR_DAT_UART_IER)) = (0x00000000)
#define DEF_DAT_UART_FCR() (REG32(ADR_DAT_UART_FCR)) = (0x00000001)
#define DEF_DAT_UART_LCR() (REG32(ADR_DAT_UART_LCR)) = (0x00000003)
#define DEF_DAT_UART_MCR() (REG32(ADR_DAT_UART_MCR)) = (0x00000000)
#define DEF_DAT_UART_LSR() (REG32(ADR_DAT_UART_LSR)) = (0x00000000)
#define DEF_DAT_UART_MSR() (REG32(ADR_DAT_UART_MSR)) = (0x00000000)
#define DEF_DAT_UART_SPR() (REG32(ADR_DAT_UART_SPR)) = (0x00000000)
#define DEF_DAT_UART_RTHR() (REG32(ADR_DAT_UART_RTHR)) = (0x000000c8)
#define DEF_DAT_UART_ISR() (REG32(ADR_DAT_UART_ISR)) = (0x000000c1)
#define DEF_INT_MASK() (REG32(ADR_INT_MASK)) = (0xffffffff)
#define DEF_INT_MODE() (REG32(ADR_INT_MODE)) = (0x00000000)
#define DEF_INT_IRQ_STS() (REG32(ADR_INT_IRQ_STS)) = (0x00000000)
#define DEF_INT_FIQ_STS() (REG32(ADR_INT_FIQ_STS)) = (0x00000000)
#define DEF_INT_IRQ_RAW() (REG32(ADR_INT_IRQ_RAW)) = (0x00000000)
#define DEF_INT_FIQ_RAW() (REG32(ADR_INT_FIQ_RAW)) = (0x00000000)
#define DEF_INT_PERI_MASK() (REG32(ADR_INT_PERI_MASK)) = (0xffffffff)
#define DEF_INT_PERI_STS() (REG32(ADR_INT_PERI_STS)) = (0x00000000)
#define DEF_INT_PERI_RAW() (REG32(ADR_INT_PERI_RAW)) = (0x00000000)
#define DEF_INT_GPI_CFG() (REG32(ADR_INT_GPI_CFG)) = (0x00000000)
#define DEF_SYS_INT_FOR_HOST() (REG32(ADR_SYS_INT_FOR_HOST)) = (0x00000001)
#define DEF_SPI_IPC() (REG32(ADR_SPI_IPC)) = (0x00000000)
#define DEF_SDIO_IPC() (REG32(ADR_SDIO_IPC)) = (0x00000000)
#define DEF_SDIO_MASK() (REG32(ADR_SDIO_MASK)) = (0xffffffff)
#define DEF_SDIO_IRQ_STS() (REG32(ADR_SDIO_IRQ_STS)) = (0x00000000)
#define DEF_SD_PERI_MASK() (REG32(ADR_SD_PERI_MASK)) = (0xffffffff)
#define DEF_SD_PERI_STS() (REG32(ADR_SD_PERI_STS)) = (0x00000000)
#define DEF_DBG_SPI_MODE() (REG32(ADR_DBG_SPI_MODE)) = (0x00000000)
#define DEF_DBG_RX_QUOTA() (REG32(ADR_DBG_RX_QUOTA)) = (0x00000000)
#define DEF_DBG_CONDITION_NUMBER() (REG32(ADR_DBG_CONDITION_NUMBER)) = (0x00000004)
#define DEF_DBG_HOST_PATH() (REG32(ADR_DBG_HOST_PATH)) = (0x00000001)
#define DEF_DBG_TX_SEG() (REG32(ADR_DBG_TX_SEG)) = (0x00000000)
#define DEF_DBG_DEBUG_BURST_MODE() (REG32(ADR_DBG_DEBUG_BURST_MODE)) = (0x00000000)
#define DEF_DBG_SPI_TO_PHY_PARAM1() (REG32(ADR_DBG_SPI_TO_PHY_PARAM1)) = (0x000e0006)
#define DEF_DBG_SPI_TO_PHY_PARAM2() (REG32(ADR_DBG_SPI_TO_PHY_PARAM2)) = (0x000e000e)
#define DEF_DBG_SPI_STS() (REG32(ADR_DBG_SPI_STS)) = (0x00000000)
#define DEF_DBG_TX_ALLOC_SET() (REG32(ADR_DBG_TX_ALLOC_SET)) = (0x00000000)
#define DEF_DBG_TX_ALLOC() (REG32(ADR_DBG_TX_ALLOC)) = (0x00000000)
#define DEF_DBG_DBG_CNT() (REG32(ADR_DBG_DBG_CNT)) = (0x00000000)
#define DEF_DBG_DBG_CNT2() (REG32(ADR_DBG_DBG_CNT2)) = (0x00000000)
#define DEF_DBG_DBG_CNT3() (REG32(ADR_DBG_DBG_CNT3)) = (0x00000000)
#define DEF_DBG_DBG_CNT4() (REG32(ADR_DBG_DBG_CNT4)) = (0x00000000)
#define DEF_DBG_INT_TAG() (REG32(ADR_DBG_INT_TAG)) = (0x00000000)
#define DEF_BOOT_ADDR() (REG32(ADR_BOOT_ADDR)) = (0x00000000)
#define DEF_VERIFY_DATA() (REG32(ADR_VERIFY_DATA)) = (0x5e11aa11)
#define DEF_FLASH_ADDR() (REG32(ADR_FLASH_ADDR)) = (0x00000000)
#define DEF_SRAM_ADDR() (REG32(ADR_SRAM_ADDR)) = (0x00000000)
#define DEF_LEN() (REG32(ADR_LEN)) = (0x00000000)
#define DEF_SPI_PARAM() (REG32(ADR_SPI_PARAM)) = (0x000f000f)
#define DEF_SPI_PARAM2() (REG32(ADR_SPI_PARAM2)) = (0x00040001)
#define DEF_CHECK_SUM_RESULT() (REG32(ADR_CHECK_SUM_RESULT)) = (0x00000000)
#define DEF_CHECK_SUM_IN_FILE() (REG32(ADR_CHECK_SUM_IN_FILE)) = (0x00000000)
#define DEF_COMMAND_LEN() (REG32(ADR_COMMAND_LEN)) = (0x00000000)
#define DEF_COMMAND_ADDR() (REG32(ADR_COMMAND_ADDR)) = (0x00000000)
#define DEF_DMA_ADR_SRC() (REG32(ADR_DMA_ADR_SRC)) = (0x00000000)
#define DEF_DMA_ADR_DST() (REG32(ADR_DMA_ADR_DST)) = (0x00000000)
#define DEF_DMA_CTRL() (REG32(ADR_DMA_CTRL)) = (0x000000aa)
#define DEF_DMA_INT() (REG32(ADR_DMA_INT)) = (0x00000001)
#define DEF_DMA_FILL_CONST() (REG32(ADR_DMA_FILL_CONST)) = (0x00000000)
#define DEF_PMU_0() (REG32(ADR_PMU_0)) = (0x0f000040)
#define DEF_PMU_1() (REG32(ADR_PMU_1)) = (0x015d015d)
#define DEF_PMU_2() (REG32(ADR_PMU_2)) = (0x00000000)
#define DEF_PMU_3() (REG32(ADR_PMU_3)) = (0x55550000)
#define DEF_RTC_1() (REG32(ADR_RTC_1)) = (0x7fff0000)
#define DEF_RTC_2() (REG32(ADR_RTC_2)) = (0x00000003)
#define DEF_RTC_3W() (REG32(ADR_RTC_3W)) = (0x00000000)
#define DEF_RTC_3R() (REG32(ADR_RTC_3R)) = (0x00000000)
#define DEF_RTC_4() (REG32(ADR_RTC_4)) = (0x00000000)
#define DEF_D2_DMA_ADR_SRC() (REG32(ADR_D2_DMA_ADR_SRC)) = (0x00000000)
#define DEF_D2_DMA_ADR_DST() (REG32(ADR_D2_DMA_ADR_DST)) = (0x00000000)
#define DEF_D2_DMA_CTRL() (REG32(ADR_D2_DMA_CTRL)) = (0x000000aa)
#define DEF_D2_DMA_INT() (REG32(ADR_D2_DMA_INT)) = (0x00000001)
#define DEF_D2_DMA_FILL_CONST() (REG32(ADR_D2_DMA_FILL_CONST)) = (0x00000000)
#define DEF_CONTROL() (REG32(ADR_CONTROL)) = (0x02700008)
#define DEF_SDIO_WAKE_MODE() (REG32(ADR_SDIO_WAKE_MODE)) = (0x00000000)
#define DEF_TX_FLOW_0() (REG32(ADR_TX_FLOW_0)) = (0x00000000)
#define DEF_TX_FLOW_1() (REG32(ADR_TX_FLOW_1)) = (0x00000000)
#define DEF_THREASHOLD() (REG32(ADR_THREASHOLD)) = (0x09000000)
#define DEF_TXFID_INCREASE() (REG32(ADR_TXFID_INCREASE)) = (0x00000000)
#define DEF_GLOBAL_SEQUENCE() (REG32(ADR_GLOBAL_SEQUENCE)) = (0x00000000)
#define DEF_HCI_TX_RX_INFO_SIZE() (REG32(ADR_HCI_TX_RX_INFO_SIZE)) = (0x00040450)
#define DEF_HCI_TX_INFO_CLEAR() (REG32(ADR_HCI_TX_INFO_CLEAR)) = (0x00000008)
#define DEF_TX_ETHER_TYPE_0() (REG32(ADR_TX_ETHER_TYPE_0)) = (0x00000000)
#define DEF_TX_ETHER_TYPE_1() (REG32(ADR_TX_ETHER_TYPE_1)) = (0x00000000)
#define DEF_RX_ETHER_TYPE_0() (REG32(ADR_RX_ETHER_TYPE_0)) = (0x00000000)
#define DEF_RX_ETHER_TYPE_1() (REG32(ADR_RX_ETHER_TYPE_1)) = (0x00000000)
#define DEF_PACKET_COUNTER_INFO_0() (REG32(ADR_PACKET_COUNTER_INFO_0)) = (0x00000000)
#define DEF_PACKET_COUNTER_INFO_1() (REG32(ADR_PACKET_COUNTER_INFO_1)) = (0x00000000)
#define DEF_PACKET_COUNTER_INFO_2() (REG32(ADR_PACKET_COUNTER_INFO_2)) = (0x00000000)
#define DEF_PACKET_COUNTER_INFO_3() (REG32(ADR_PACKET_COUNTER_INFO_3)) = (0x00000000)
#define DEF_PACKET_COUNTER_INFO_4() (REG32(ADR_PACKET_COUNTER_INFO_4)) = (0x00000000)
#define DEF_PACKET_COUNTER_INFO_5() (REG32(ADR_PACKET_COUNTER_INFO_5)) = (0x00000000)
#define DEF_PACKET_COUNTER_INFO_6() (REG32(ADR_PACKET_COUNTER_INFO_6)) = (0x00000000)
#define DEF_PACKET_COUNTER_INFO_7() (REG32(ADR_PACKET_COUNTER_INFO_7)) = (0x00000000)
#define DEF_SDIO_TX_RX_FAIL_COUNTER_0() (REG32(ADR_SDIO_TX_RX_FAIL_COUNTER_0)) = (0x00000000)
#define DEF_SDIO_TX_RX_FAIL_COUNTER_1() (REG32(ADR_SDIO_TX_RX_FAIL_COUNTER_1)) = (0x00000000)
#define DEF_HCI_STATE_DEBUG_MODE_0() (REG32(ADR_HCI_STATE_DEBUG_MODE_0)) = (0x00000000)
#define DEF_HCI_STATE_DEBUG_MODE_1() (REG32(ADR_HCI_STATE_DEBUG_MODE_1)) = (0x00000000)
#define DEF_HCI_STATE_DEBUG_MODE_2() (REG32(ADR_HCI_STATE_DEBUG_MODE_2)) = (0x00000000)
#define DEF_HCI_STATE_DEBUG_MODE_3() (REG32(ADR_HCI_STATE_DEBUG_MODE_3)) = (0x00000000)
#define DEF_HCI_STATE_DEBUG_MODE_4() (REG32(ADR_HCI_STATE_DEBUG_MODE_4)) = (0x00000000)
#define DEF_HCI_STATE_DEBUG_MODE_5() (REG32(ADR_HCI_STATE_DEBUG_MODE_5)) = (0x00000000)
#define DEF_HCI_STATE_DEBUG_MODE_6() (REG32(ADR_HCI_STATE_DEBUG_MODE_6)) = (0x00000000)
#define DEF_HCI_STATE_DEBUG_MODE_7() (REG32(ADR_HCI_STATE_DEBUG_MODE_7)) = (0x00000000)
#define DEF_HCI_STATE_DEBUG_MODE_8() (REG32(ADR_HCI_STATE_DEBUG_MODE_8)) = (0x00000000)
#define DEF_HCI_STATE_DEBUG_MODE_9() (REG32(ADR_HCI_STATE_DEBUG_MODE_9)) = (0x00000000)
#define DEF_HCI_STATE_DEBUG_MODE_10() (REG32(ADR_HCI_STATE_DEBUG_MODE_10)) = (0x00000000)
#define DEF_CS_START_ADDR() (REG32(ADR_CS_START_ADDR)) = (0x00000000)
#define DEF_CS_ADD_LEN() (REG32(ADR_CS_ADD_LEN)) = (0x00000000)
#define DEF_CS_CMD() (REG32(ADR_CS_CMD)) = (0x00000000)
#define DEF_CS_INI_BUF() (REG32(ADR_CS_INI_BUF)) = (0x00000000)
#define DEF_CS_PSEUDO_BUF() (REG32(ADR_CS_PSEUDO_BUF)) = (0x00000000)
#define DEF_CS_CHECK_SUM() (REG32(ADR_CS_CHECK_SUM)) = (0x00000000)
#define DEF_RAND_EN() (REG32(ADR_RAND_EN)) = (0x00000000)
#define DEF_RAND_NUM() (REG32(ADR_RAND_NUM)) = (0x00000000)
#define DEF_MUL_OP1() (REG32(ADR_MUL_OP1)) = (0x00000000)
#define DEF_MUL_OP2() (REG32(ADR_MUL_OP2)) = (0x00000000)
#define DEF_MUL_ANS0() (REG32(ADR_MUL_ANS0)) = (0x00000000)
#define DEF_MUL_ANS1() (REG32(ADR_MUL_ANS1)) = (0x00000000)
#define DEF_DMA_RDATA() (REG32(ADR_DMA_RDATA)) = (0x00000000)
#define DEF_DMA_WDATA() (REG32(ADR_DMA_WDATA)) = (0x00000000)
#define DEF_DMA_LEN() (REG32(ADR_DMA_LEN)) = (0x00000000)
#define DEF_DMA_CLR() (REG32(ADR_DMA_CLR)) = (0x00000000)
#define DEF_NAV_DATA() (REG32(ADR_NAV_DATA)) = (0x00000000)
#define DEF_CO_NAV() (REG32(ADR_CO_NAV)) = (0x00000000)
#define DEF_SHA_DST_ADDR() (REG32(ADR_SHA_DST_ADDR)) = (0x00000000)
#define DEF_SHA_SRC_ADDR() (REG32(ADR_SHA_SRC_ADDR)) = (0x00000000)
#define DEF_SHA_SETTING() (REG32(ADR_SHA_SETTING)) = (0x00000002)
#define DEF_EFUSE_CLK_FREQ() (REG32(ADR_EFUSE_CLK_FREQ)) = (0x610100d0)
#define DEF_EFUSE_LDO_TIME() (REG32(ADR_EFUSE_LDO_TIME)) = (0x00020002)
#define DEF_EFUSE_AHB_RDATA_0() (REG32(ADR_EFUSE_AHB_RDATA_0)) = (0x00000000)
#define DEF_EFUSE_WDATA_0() (REG32(ADR_EFUSE_WDATA_0)) = (0x00000000)
#define DEF_EFUSE_AHB_RDATA_1() (REG32(ADR_EFUSE_AHB_RDATA_1)) = (0x00000000)
#define DEF_EFUSE_WDATA_1() (REG32(ADR_EFUSE_WDATA_1)) = (0x00000000)
#define DEF_EFUSE_AHB_RDATA_2() (REG32(ADR_EFUSE_AHB_RDATA_2)) = (0x00000000)
#define DEF_EFUSE_WDATA_2() (REG32(ADR_EFUSE_WDATA_2)) = (0x00000000)
#define DEF_EFUSE_AHB_RDATA_3() (REG32(ADR_EFUSE_AHB_RDATA_3)) = (0x00000000)
#define DEF_EFUSE_WDATA_3() (REG32(ADR_EFUSE_WDATA_3)) = (0x00000000)
#define DEF_EFUSE_AHB_RDATA_4() (REG32(ADR_EFUSE_AHB_RDATA_4)) = (0x00000000)
#define DEF_EFUSE_WDATA_4() (REG32(ADR_EFUSE_WDATA_4)) = (0x00000000)
#define DEF_EFUSE_AHB_RDATA_5() (REG32(ADR_EFUSE_AHB_RDATA_5)) = (0x00000000)
#define DEF_EFUSE_WDATA_5() (REG32(ADR_EFUSE_WDATA_5)) = (0x00000000)
#define DEF_EFUSE_AHB_RDATA_6() (REG32(ADR_EFUSE_AHB_RDATA_6)) = (0x00000000)
#define DEF_EFUSE_WDATA_6() (REG32(ADR_EFUSE_WDATA_6)) = (0x00000000)
#define DEF_EFUSE_AHB_RDATA_7() (REG32(ADR_EFUSE_AHB_RDATA_7)) = (0x00000000)
#define DEF_EFUSE_WDATA_7() (REG32(ADR_EFUSE_WDATA_7)) = (0x00000000)
#define DEF_EFUSE_SPI_RD0_EN() (REG32(ADR_EFUSE_SPI_RD0_EN)) = (0x00000000)
#define DEF_EFUSE_SPI_RD1_EN() (REG32(ADR_EFUSE_SPI_RD1_EN)) = (0x00000000)
#define DEF_EFUSE_SPI_RD2_EN() (REG32(ADR_EFUSE_SPI_RD2_EN)) = (0x00000000)
#define DEF_EFUSE_SPI_RD3_EN() (REG32(ADR_EFUSE_SPI_RD3_EN)) = (0x00000000)
#define DEF_EFUSE_SPI_RD4_EN() (REG32(ADR_EFUSE_SPI_RD4_EN)) = (0x00000000)
#define DEF_EFUSE_SPI_RD5_EN() (REG32(ADR_EFUSE_SPI_RD5_EN)) = (0x00000000)
#define DEF_EFUSE_SPI_RD6_EN() (REG32(ADR_EFUSE_SPI_RD6_EN)) = (0x00000000)
#define DEF_EFUSE_SPI_RD7_EN() (REG32(ADR_EFUSE_SPI_RD7_EN)) = (0x00000000)
#define DEF_EFUSE_SPI_BUSY() (REG32(ADR_EFUSE_SPI_BUSY)) = (0x00000000)
#define DEF_EFUSE_SPI_RDATA_0() (REG32(ADR_EFUSE_SPI_RDATA_0)) = (0x00000000)
#define DEF_EFUSE_SPI_RDATA_1() (REG32(ADR_EFUSE_SPI_RDATA_1)) = (0x00000000)
#define DEF_EFUSE_SPI_RDATA_2() (REG32(ADR_EFUSE_SPI_RDATA_2)) = (0x00000000)
#define DEF_EFUSE_SPI_RDATA_3() (REG32(ADR_EFUSE_SPI_RDATA_3)) = (0x00000000)
#define DEF_EFUSE_SPI_RDATA_4() (REG32(ADR_EFUSE_SPI_RDATA_4)) = (0x00000000)
#define DEF_EFUSE_SPI_RDATA_5() (REG32(ADR_EFUSE_SPI_RDATA_5)) = (0x00000000)
#define DEF_EFUSE_SPI_RDATA_6() (REG32(ADR_EFUSE_SPI_RDATA_6)) = (0x00000000)
#define DEF_EFUSE_SPI_RDATA_7() (REG32(ADR_EFUSE_SPI_RDATA_7)) = (0x00000000)
#define DEF_SMS4_CFG1() (REG32(ADR_SMS4_CFG1)) = (0x00000002)
#define DEF_SMS4_CFG2() (REG32(ADR_SMS4_CFG2)) = (0x00000000)
#define DEF_SMS4_MODE1() (REG32(ADR_SMS4_MODE1)) = (0x00000000)
#define DEF_SMS4_TRIG() (REG32(ADR_SMS4_TRIG)) = (0x00000000)
#define DEF_SMS4_STATUS1() (REG32(ADR_SMS4_STATUS1)) = (0x00000000)
#define DEF_SMS4_STATUS2() (REG32(ADR_SMS4_STATUS2)) = (0x00000000)
#define DEF_SMS4_DATA_IN0() (REG32(ADR_SMS4_DATA_IN0)) = (0x00000000)
#define DEF_SMS4_DATA_IN1() (REG32(ADR_SMS4_DATA_IN1)) = (0x00000000)
#define DEF_SMS4_DATA_IN2() (REG32(ADR_SMS4_DATA_IN2)) = (0x00000000)
#define DEF_SMS4_DATA_IN3() (REG32(ADR_SMS4_DATA_IN3)) = (0x00000000)
#define DEF_SMS4_DATA_OUT0() (REG32(ADR_SMS4_DATA_OUT0)) = (0x00000000)
#define DEF_SMS4_DATA_OUT1() (REG32(ADR_SMS4_DATA_OUT1)) = (0x00000000)
#define DEF_SMS4_DATA_OUT2() (REG32(ADR_SMS4_DATA_OUT2)) = (0x00000000)
#define DEF_SMS4_DATA_OUT3() (REG32(ADR_SMS4_DATA_OUT3)) = (0x00000000)
#define DEF_SMS4_KEY_0() (REG32(ADR_SMS4_KEY_0)) = (0x00000000)
#define DEF_SMS4_KEY_1() (REG32(ADR_SMS4_KEY_1)) = (0x00000000)
#define DEF_SMS4_KEY_2() (REG32(ADR_SMS4_KEY_2)) = (0x00000000)
#define DEF_SMS4_KEY_3() (REG32(ADR_SMS4_KEY_3)) = (0x00000000)
#define DEF_SMS4_MODE_IV0() (REG32(ADR_SMS4_MODE_IV0)) = (0x00000000)
#define DEF_SMS4_MODE_IV1() (REG32(ADR_SMS4_MODE_IV1)) = (0x00000000)
#define DEF_SMS4_MODE_IV2() (REG32(ADR_SMS4_MODE_IV2)) = (0x00000000)
#define DEF_SMS4_MODE_IV3() (REG32(ADR_SMS4_MODE_IV3)) = (0x00000000)
#define DEF_SMS4_OFB_ENC0() (REG32(ADR_SMS4_OFB_ENC0)) = (0x00000000)
#define DEF_SMS4_OFB_ENC1() (REG32(ADR_SMS4_OFB_ENC1)) = (0x00000000)
#define DEF_SMS4_OFB_ENC2() (REG32(ADR_SMS4_OFB_ENC2)) = (0x00000000)
#define DEF_SMS4_OFB_ENC3() (REG32(ADR_SMS4_OFB_ENC3)) = (0x00000000)
#define DEF_MRX_MCAST_TB0_0() (REG32(ADR_MRX_MCAST_TB0_0)) = (0x00000000)
#define DEF_MRX_MCAST_TB0_1() (REG32(ADR_MRX_MCAST_TB0_1)) = (0x00000000)
#define DEF_MRX_MCAST_MK0_0() (REG32(ADR_MRX_MCAST_MK0_0)) = (0x00000000)
#define DEF_MRX_MCAST_MK0_1() (REG32(ADR_MRX_MCAST_MK0_1)) = (0x00000000)
#define DEF_MRX_MCAST_CTRL0() (REG32(ADR_MRX_MCAST_CTRL0)) = (0x00000000)
#define DEF_MRX_MCAST_TB1_0() (REG32(ADR_MRX_MCAST_TB1_0)) = (0x00000000)
#define DEF_MRX_MCAST_TB1_1() (REG32(ADR_MRX_MCAST_TB1_1)) = (0x00000000)
#define DEF_MRX_MCAST_MK1_0() (REG32(ADR_MRX_MCAST_MK1_0)) = (0x00000000)
#define DEF_MRX_MCAST_MK1_1() (REG32(ADR_MRX_MCAST_MK1_1)) = (0x00000000)
#define DEF_MRX_MCAST_CTRL1() (REG32(ADR_MRX_MCAST_CTRL1)) = (0x00000000)
#define DEF_MRX_MCAST_TB2_0() (REG32(ADR_MRX_MCAST_TB2_0)) = (0x00000000)
#define DEF_MRX_MCAST_TB2_1() (REG32(ADR_MRX_MCAST_TB2_1)) = (0x00000000)
#define DEF_MRX_MCAST_MK2_0() (REG32(ADR_MRX_MCAST_MK2_0)) = (0x00000000)
#define DEF_MRX_MCAST_MK2_1() (REG32(ADR_MRX_MCAST_MK2_1)) = (0x00000000)
#define DEF_MRX_MCAST_CTRL2() (REG32(ADR_MRX_MCAST_CTRL2)) = (0x00000000)
#define DEF_MRX_MCAST_TB3_0() (REG32(ADR_MRX_MCAST_TB3_0)) = (0x00000000)
#define DEF_MRX_MCAST_TB3_1() (REG32(ADR_MRX_MCAST_TB3_1)) = (0x00000000)
#define DEF_MRX_MCAST_MK3_0() (REG32(ADR_MRX_MCAST_MK3_0)) = (0x00000000)
#define DEF_MRX_MCAST_MK3_1() (REG32(ADR_MRX_MCAST_MK3_1)) = (0x00000000)
#define DEF_MRX_MCAST_CTRL3() (REG32(ADR_MRX_MCAST_CTRL3)) = (0x00000000)
#define DEF_MRX_PHY_INFO() (REG32(ADR_MRX_PHY_INFO)) = (0x00000000)
#define DEF_MRX_BA_DBG() (REG32(ADR_MRX_BA_DBG)) = (0x00000000)
#define DEF_MRX_FLT_TB0() (REG32(ADR_MRX_FLT_TB0)) = (0x00003df5)
#define DEF_MRX_FLT_TB1() (REG32(ADR_MRX_FLT_TB1)) = (0x000031f6)
#define DEF_MRX_FLT_TB2() (REG32(ADR_MRX_FLT_TB2)) = (0x000035f9)
#define DEF_MRX_FLT_TB3() (REG32(ADR_MRX_FLT_TB3)) = (0x000021c1)
#define DEF_MRX_FLT_TB4() (REG32(ADR_MRX_FLT_TB4)) = (0x00004bf9)
#define DEF_MRX_FLT_TB5() (REG32(ADR_MRX_FLT_TB5)) = (0x00004db1)
#define DEF_MRX_FLT_TB6() (REG32(ADR_MRX_FLT_TB6)) = (0x000011fe)
#define DEF_MRX_FLT_TB7() (REG32(ADR_MRX_FLT_TB7)) = (0x00000bfe)
#define DEF_MRX_FLT_TB8() (REG32(ADR_MRX_FLT_TB8)) = (0x00000000)
#define DEF_MRX_FLT_TB9() (REG32(ADR_MRX_FLT_TB9)) = (0x00000000)
#define DEF_MRX_FLT_TB10() (REG32(ADR_MRX_FLT_TB10)) = (0x00000000)
#define DEF_MRX_FLT_TB11() (REG32(ADR_MRX_FLT_TB11)) = (0x00000006)
#define DEF_MRX_FLT_TB12() (REG32(ADR_MRX_FLT_TB12)) = (0x00000001)
#define DEF_MRX_FLT_TB13() (REG32(ADR_MRX_FLT_TB13)) = (0x00000003)
#define DEF_MRX_FLT_TB14() (REG32(ADR_MRX_FLT_TB14)) = (0x00000005)
#define DEF_MRX_FLT_TB15() (REG32(ADR_MRX_FLT_TB15)) = (0x00000007)
#define DEF_MRX_FLT_EN0() (REG32(ADR_MRX_FLT_EN0)) = (0x00002008)
#define DEF_MRX_FLT_EN1() (REG32(ADR_MRX_FLT_EN1)) = (0x00001001)
#define DEF_MRX_FLT_EN2() (REG32(ADR_MRX_FLT_EN2)) = (0x00000808)
#define DEF_MRX_FLT_EN3() (REG32(ADR_MRX_FLT_EN3)) = (0x00001000)
#define DEF_MRX_FLT_EN4() (REG32(ADR_MRX_FLT_EN4)) = (0x00002008)
#define DEF_MRX_FLT_EN5() (REG32(ADR_MRX_FLT_EN5)) = (0x0000800e)
#define DEF_MRX_FLT_EN6() (REG32(ADR_MRX_FLT_EN6)) = (0x00000838)
#define DEF_MRX_FLT_EN7() (REG32(ADR_MRX_FLT_EN7)) = (0x00002008)
#define DEF_MRX_FLT_EN8() (REG32(ADR_MRX_FLT_EN8)) = (0x00002008)
#define DEF_MRX_LEN_FLT() (REG32(ADR_MRX_LEN_FLT)) = (0x00000000)
#define DEF_RX_FLOW_DATA() (REG32(ADR_RX_FLOW_DATA)) = (0x00105034)
#define DEF_RX_FLOW_MNG() (REG32(ADR_RX_FLOW_MNG)) = (0x00000004)
#define DEF_RX_FLOW_CTRL() (REG32(ADR_RX_FLOW_CTRL)) = (0x00000004)
#define DEF_RX_TIME_STAMP_CFG() (REG32(ADR_RX_TIME_STAMP_CFG)) = (0x00001c00)
#define DEF_DBG_FF_FULL() (REG32(ADR_DBG_FF_FULL)) = (0x00000000)
#define DEF_DBG_WFF_FULL() (REG32(ADR_DBG_WFF_FULL)) = (0x00000000)
#define DEF_DBG_MB_FULL() (REG32(ADR_DBG_MB_FULL)) = (0x00000000)
#define DEF_BA_CTRL() (REG32(ADR_BA_CTRL)) = (0x00000008)
#define DEF_BA_TA_0() (REG32(ADR_BA_TA_0)) = (0x00000000)
#define DEF_BA_TA_1() (REG32(ADR_BA_TA_1)) = (0x00000000)
#define DEF_BA_TID() (REG32(ADR_BA_TID)) = (0x00000000)
#define DEF_BA_ST_SEQ() (REG32(ADR_BA_ST_SEQ)) = (0x00000000)
#define DEF_BA_SB0() (REG32(ADR_BA_SB0)) = (0x00000000)
#define DEF_BA_SB1() (REG32(ADR_BA_SB1)) = (0x00000000)
#define DEF_MRX_WATCH_DOG() (REG32(ADR_MRX_WATCH_DOG)) = (0x0000ffff)
#define DEF_ACK_GEN_EN() (REG32(ADR_ACK_GEN_EN)) = (0x00000000)
#define DEF_ACK_GEN_PARA() (REG32(ADR_ACK_GEN_PARA)) = (0x00000000)
#define DEF_ACK_GEN_RA_0() (REG32(ADR_ACK_GEN_RA_0)) = (0x00000000)
#define DEF_ACK_GEN_RA_1() (REG32(ADR_ACK_GEN_RA_1)) = (0x00000000)
#define DEF_MIB_LEN_FAIL() (REG32(ADR_MIB_LEN_FAIL)) = (0x00000000)
#define DEF_TRAP_HW_ID() (REG32(ADR_TRAP_HW_ID)) = (0x00000000)
#define DEF_ID_IN_USE() (REG32(ADR_ID_IN_USE)) = (0x00000000)
#define DEF_MRX_ERR() (REG32(ADR_MRX_ERR)) = (0x00000000)
#define DEF_WSID0_TID0_RX_SEQ() (REG32(ADR_WSID0_TID0_RX_SEQ)) = (0x00000000)
#define DEF_WSID0_TID1_RX_SEQ() (REG32(ADR_WSID0_TID1_RX_SEQ)) = (0x00000000)
#define DEF_WSID0_TID2_RX_SEQ() (REG32(ADR_WSID0_TID2_RX_SEQ)) = (0x00000000)
#define DEF_WSID0_TID3_RX_SEQ() (REG32(ADR_WSID0_TID3_RX_SEQ)) = (0x00000000)
#define DEF_WSID0_TID4_RX_SEQ() (REG32(ADR_WSID0_TID4_RX_SEQ)) = (0x00000000)
#define DEF_WSID0_TID5_RX_SEQ() (REG32(ADR_WSID0_TID5_RX_SEQ)) = (0x00000000)
#define DEF_WSID0_TID6_RX_SEQ() (REG32(ADR_WSID0_TID6_RX_SEQ)) = (0x00000000)
#define DEF_WSID0_TID7_RX_SEQ() (REG32(ADR_WSID0_TID7_RX_SEQ)) = (0x00000000)
#define DEF_WSID1_TID0_RX_SEQ() (REG32(ADR_WSID1_TID0_RX_SEQ)) = (0x00000000)
#define DEF_WSID1_TID1_RX_SEQ() (REG32(ADR_WSID1_TID1_RX_SEQ)) = (0x00000000)
#define DEF_WSID1_TID2_RX_SEQ() (REG32(ADR_WSID1_TID2_RX_SEQ)) = (0x00000000)
#define DEF_WSID1_TID3_RX_SEQ() (REG32(ADR_WSID1_TID3_RX_SEQ)) = (0x00000000)
#define DEF_WSID1_TID4_RX_SEQ() (REG32(ADR_WSID1_TID4_RX_SEQ)) = (0x00000000)
#define DEF_WSID1_TID5_RX_SEQ() (REG32(ADR_WSID1_TID5_RX_SEQ)) = (0x00000000)
#define DEF_WSID1_TID6_RX_SEQ() (REG32(ADR_WSID1_TID6_RX_SEQ)) = (0x00000000)
#define DEF_WSID1_TID7_RX_SEQ() (REG32(ADR_WSID1_TID7_RX_SEQ)) = (0x00000000)
#define DEF_HDR_ADDR_SEL() (REG32(ADR_HDR_ADDR_SEL)) = (0x00003e79)
#define DEF_FRAME_TYPE_CNTR_SET() (REG32(ADR_FRAME_TYPE_CNTR_SET)) = (0x00000000)
#define DEF_PHY_INFO() (REG32(ADR_PHY_INFO)) = (0x00000000)
#define DEF_AMPDU_SIG() (REG32(ADR_AMPDU_SIG)) = (0x0000004e)
#define DEF_MIB_AMPDU() (REG32(ADR_MIB_AMPDU)) = (0x00000000)
#define DEF_LEN_FLT() (REG32(ADR_LEN_FLT)) = (0x00000000)
#define DEF_MIB_DELIMITER() (REG32(ADR_MIB_DELIMITER)) = (0x00000000)
#define DEF_MTX_INT_STS() (REG32(ADR_MTX_INT_STS)) = (0x00000000)
#define DEF_MTX_INT_EN() (REG32(ADR_MTX_INT_EN)) = (0x00000000)
#define DEF_MTX_MISC_EN() (REG32(ADR_MTX_MISC_EN)) = (0x00c00c00)
#define DEF_MTX_EDCCA_TOUT() (REG32(ADR_MTX_EDCCA_TOUT)) = (0x00000200)
#define DEF_MTX_BCN_INT_STS() (REG32(ADR_MTX_BCN_INT_STS)) = (0x00000000)
#define DEF_MTX_BCN_EN_INT() (REG32(ADR_MTX_BCN_EN_INT)) = (0x00000000)
#define DEF_MTX_BCN_EN_MISC() (REG32(ADR_MTX_BCN_EN_MISC)) = (0x00000042)
#define DEF_MTX_BCN_MISC() (REG32(ADR_MTX_BCN_MISC)) = (0x00000000)
#define DEF_MTX_BCN_PRD() (REG32(ADR_MTX_BCN_PRD)) = (0x00000064)
#define DEF_MTX_BCN_TSF_L() (REG32(ADR_MTX_BCN_TSF_L)) = (0x00000000)
#define DEF_MTX_BCN_TSF_U() (REG32(ADR_MTX_BCN_TSF_U)) = (0x00000000)
#define DEF_MTX_BCN_CFG0() (REG32(ADR_MTX_BCN_CFG0)) = (0x00000000)
#define DEF_MTX_BCN_CFG1() (REG32(ADR_MTX_BCN_CFG1)) = (0x00000000)
#define DEF_MTX_STATUS() (REG32(ADR_MTX_STATUS)) = (0x00000000)
#define DEF_MTX_DBG_CTRL() (REG32(ADR_MTX_DBG_CTRL)) = (0x00000000)
#define DEF_MTX_DBG_DAT0() (REG32(ADR_MTX_DBG_DAT0)) = (0x00000000)
#define DEF_MTX_DBG_DAT1() (REG32(ADR_MTX_DBG_DAT1)) = (0x00000000)
#define DEF_MTX_DBG_DAT2() (REG32(ADR_MTX_DBG_DAT2)) = (0x00000000)
#define DEF_MTX_DUR_TOUT() (REG32(ADR_MTX_DUR_TOUT)) = (0x00002c2c)
#define DEF_MTX_DUR_IFS() (REG32(ADR_MTX_DUR_IFS)) = (0x12d40a05)
#define DEF_MTX_DUR_SIFS_G() (REG32(ADR_MTX_DUR_SIFS_G)) = (0x12c90100)
#define DEF_MTX_DBG_DAT3() (REG32(ADR_MTX_DBG_DAT3)) = (0x00000000)
#define DEF_MTX_NAV() (REG32(ADR_MTX_NAV)) = (0x00000000)
#define DEF_MTX_MIB_WSID0() (REG32(ADR_MTX_MIB_WSID0)) = (0x00000000)
#define DEF_MTX_MIB_WSID1() (REG32(ADR_MTX_MIB_WSID1)) = (0x00000000)
#define DEF_MTX_DBG_DAT4() (REG32(ADR_MTX_DBG_DAT4)) = (0x00000000)
#define DEF_TXQ0_MTX_Q_MISC_EN() (REG32(ADR_TXQ0_MTX_Q_MISC_EN)) = (0x00000000)
#define DEF_TXQ0_MTX_Q_AIFSN() (REG32(ADR_TXQ0_MTX_Q_AIFSN)) = (0x0000a502)
#define DEF_TXQ0_MTX_Q_BKF_CNT() (REG32(ADR_TXQ0_MTX_Q_BKF_CNT)) = (0x00000000)
#define DEF_TXQ0_MTX_Q_RC_LIMIT() (REG32(ADR_TXQ0_MTX_Q_RC_LIMIT)) = (0x00000407)
#define DEF_TXQ0_MTX_Q_ID_MAP_L() (REG32(ADR_TXQ0_MTX_Q_ID_MAP_L)) = (0x00000000)
#define DEF_TXQ0_MTX_Q_TXOP_CH_THD() (REG32(ADR_TXQ0_MTX_Q_TXOP_CH_THD)) = (0x00000000)
#define DEF_TXQ0_MTX_Q_TXOP_OV_THD() (REG32(ADR_TXQ0_MTX_Q_TXOP_OV_THD)) = (0x00000000)
#define DEF_TXQ1_MTX_Q_MISC_EN() (REG32(ADR_TXQ1_MTX_Q_MISC_EN)) = (0x00000000)
#define DEF_TXQ1_MTX_Q_AIFSN() (REG32(ADR_TXQ1_MTX_Q_AIFSN)) = (0x0000a502)
#define DEF_TXQ1_MTX_Q_BKF_CNT() (REG32(ADR_TXQ1_MTX_Q_BKF_CNT)) = (0x00000000)
#define DEF_TXQ1_MTX_Q_RC_LIMIT() (REG32(ADR_TXQ1_MTX_Q_RC_LIMIT)) = (0x00000407)
#define DEF_TXQ1_MTX_Q_ID_MAP_L() (REG32(ADR_TXQ1_MTX_Q_ID_MAP_L)) = (0x00000000)
#define DEF_TXQ1_MTX_Q_TXOP_CH_THD() (REG32(ADR_TXQ1_MTX_Q_TXOP_CH_THD)) = (0x00000000)
#define DEF_TXQ1_MTX_Q_TXOP_OV_THD() (REG32(ADR_TXQ1_MTX_Q_TXOP_OV_THD)) = (0x00000000)
#define DEF_TXQ2_MTX_Q_MISC_EN() (REG32(ADR_TXQ2_MTX_Q_MISC_EN)) = (0x00000000)
#define DEF_TXQ2_MTX_Q_AIFSN() (REG32(ADR_TXQ2_MTX_Q_AIFSN)) = (0x0000a502)
#define DEF_TXQ2_MTX_Q_BKF_CNT() (REG32(ADR_TXQ2_MTX_Q_BKF_CNT)) = (0x00000000)
#define DEF_TXQ2_MTX_Q_RC_LIMIT() (REG32(ADR_TXQ2_MTX_Q_RC_LIMIT)) = (0x00000407)
#define DEF_TXQ2_MTX_Q_ID_MAP_L() (REG32(ADR_TXQ2_MTX_Q_ID_MAP_L)) = (0x00000000)
#define DEF_TXQ2_MTX_Q_TXOP_CH_THD() (REG32(ADR_TXQ2_MTX_Q_TXOP_CH_THD)) = (0x00000000)
#define DEF_TXQ2_MTX_Q_TXOP_OV_THD() (REG32(ADR_TXQ2_MTX_Q_TXOP_OV_THD)) = (0x00000000)
#define DEF_TXQ3_MTX_Q_MISC_EN() (REG32(ADR_TXQ3_MTX_Q_MISC_EN)) = (0x00000000)
#define DEF_TXQ3_MTX_Q_AIFSN() (REG32(ADR_TXQ3_MTX_Q_AIFSN)) = (0x0000a502)
#define DEF_TXQ3_MTX_Q_BKF_CNT() (REG32(ADR_TXQ3_MTX_Q_BKF_CNT)) = (0x00000000)
#define DEF_TXQ3_MTX_Q_RC_LIMIT() (REG32(ADR_TXQ3_MTX_Q_RC_LIMIT)) = (0x00000407)
#define DEF_TXQ3_MTX_Q_ID_MAP_L() (REG32(ADR_TXQ3_MTX_Q_ID_MAP_L)) = (0x00000000)
#define DEF_TXQ3_MTX_Q_TXOP_CH_THD() (REG32(ADR_TXQ3_MTX_Q_TXOP_CH_THD)) = (0x00000000)
#define DEF_TXQ3_MTX_Q_TXOP_OV_THD() (REG32(ADR_TXQ3_MTX_Q_TXOP_OV_THD)) = (0x00000000)
#define DEF_TXQ4_MTX_Q_MISC_EN() (REG32(ADR_TXQ4_MTX_Q_MISC_EN)) = (0x00000000)
#define DEF_TXQ4_MTX_Q_AIFSN() (REG32(ADR_TXQ4_MTX_Q_AIFSN)) = (0x0000a502)
#define DEF_TXQ4_MTX_Q_BKF_CNT() (REG32(ADR_TXQ4_MTX_Q_BKF_CNT)) = (0x00000000)
#define DEF_TXQ4_MTX_Q_RC_LIMIT() (REG32(ADR_TXQ4_MTX_Q_RC_LIMIT)) = (0x00000407)
#define DEF_TXQ4_MTX_Q_ID_MAP_L() (REG32(ADR_TXQ4_MTX_Q_ID_MAP_L)) = (0x00000000)
#define DEF_TXQ4_MTX_Q_TXOP_CH_THD() (REG32(ADR_TXQ4_MTX_Q_TXOP_CH_THD)) = (0x00000000)
#define DEF_TXQ4_MTX_Q_TXOP_OV_THD() (REG32(ADR_TXQ4_MTX_Q_TXOP_OV_THD)) = (0x00000000)
#define DEF_WSID0() (REG32(ADR_WSID0)) = (0x00000000)
#define DEF_PEER_MAC0_0() (REG32(ADR_PEER_MAC0_0)) = (0x00000000)
#define DEF_PEER_MAC0_1() (REG32(ADR_PEER_MAC0_1)) = (0x00000000)
#define DEF_TX_ACK_POLICY_0_0() (REG32(ADR_TX_ACK_POLICY_0_0)) = (0x00000000)
#define DEF_TX_SEQ_CTRL_0_0() (REG32(ADR_TX_SEQ_CTRL_0_0)) = (0x00000000)
#define DEF_TX_ACK_POLICY_0_1() (REG32(ADR_TX_ACK_POLICY_0_1)) = (0x00000000)
#define DEF_TX_SEQ_CTRL_0_1() (REG32(ADR_TX_SEQ_CTRL_0_1)) = (0x00000000)
#define DEF_TX_ACK_POLICY_0_2() (REG32(ADR_TX_ACK_POLICY_0_2)) = (0x00000000)
#define DEF_TX_SEQ_CTRL_0_2() (REG32(ADR_TX_SEQ_CTRL_0_2)) = (0x00000000)
#define DEF_TX_ACK_POLICY_0_3() (REG32(ADR_TX_ACK_POLICY_0_3)) = (0x00000000)
#define DEF_TX_SEQ_CTRL_0_3() (REG32(ADR_TX_SEQ_CTRL_0_3)) = (0x00000000)
#define DEF_TX_ACK_POLICY_0_4() (REG32(ADR_TX_ACK_POLICY_0_4)) = (0x00000000)
#define DEF_TX_SEQ_CTRL_0_4() (REG32(ADR_TX_SEQ_CTRL_0_4)) = (0x00000000)
#define DEF_TX_ACK_POLICY_0_5() (REG32(ADR_TX_ACK_POLICY_0_5)) = (0x00000000)
#define DEF_TX_SEQ_CTRL_0_5() (REG32(ADR_TX_SEQ_CTRL_0_5)) = (0x00000000)
#define DEF_TX_ACK_POLICY_0_6() (REG32(ADR_TX_ACK_POLICY_0_6)) = (0x00000000)
#define DEF_TX_SEQ_CTRL_0_6() (REG32(ADR_TX_SEQ_CTRL_0_6)) = (0x00000000)
#define DEF_TX_ACK_POLICY_0_7() (REG32(ADR_TX_ACK_POLICY_0_7)) = (0x00000000)
#define DEF_TX_SEQ_CTRL_0_7() (REG32(ADR_TX_SEQ_CTRL_0_7)) = (0x00000000)
#define DEF_WSID1() (REG32(ADR_WSID1)) = (0x00000000)
#define DEF_PEER_MAC1_0() (REG32(ADR_PEER_MAC1_0)) = (0x00000000)
#define DEF_PEER_MAC1_1() (REG32(ADR_PEER_MAC1_1)) = (0x00000000)
#define DEF_TX_ACK_POLICY_1_0() (REG32(ADR_TX_ACK_POLICY_1_0)) = (0x00000000)
#define DEF_TX_SEQ_CTRL_1_0() (REG32(ADR_TX_SEQ_CTRL_1_0)) = (0x00000000)
#define DEF_TX_ACK_POLICY_1_1() (REG32(ADR_TX_ACK_POLICY_1_1)) = (0x00000000)
#define DEF_TX_SEQ_CTRL_1_1() (REG32(ADR_TX_SEQ_CTRL_1_1)) = (0x00000000)
#define DEF_TX_ACK_POLICY_1_2() (REG32(ADR_TX_ACK_POLICY_1_2)) = (0x00000000)
#define DEF_TX_SEQ_CTRL_1_2() (REG32(ADR_TX_SEQ_CTRL_1_2)) = (0x00000000)
#define DEF_TX_ACK_POLICY_1_3() (REG32(ADR_TX_ACK_POLICY_1_3)) = (0x00000000)
#define DEF_TX_SEQ_CTRL_1_3() (REG32(ADR_TX_SEQ_CTRL_1_3)) = (0x00000000)
#define DEF_TX_ACK_POLICY_1_4() (REG32(ADR_TX_ACK_POLICY_1_4)) = (0x00000000)
#define DEF_TX_SEQ_CTRL_1_4() (REG32(ADR_TX_SEQ_CTRL_1_4)) = (0x00000000)
#define DEF_TX_ACK_POLICY_1_5() (REG32(ADR_TX_ACK_POLICY_1_5)) = (0x00000000)
#define DEF_TX_SEQ_CTRL_1_5() (REG32(ADR_TX_SEQ_CTRL_1_5)) = (0x00000000)
#define DEF_TX_ACK_POLICY_1_6() (REG32(ADR_TX_ACK_POLICY_1_6)) = (0x00000000)
#define DEF_TX_SEQ_CTRL_1_6() (REG32(ADR_TX_SEQ_CTRL_1_6)) = (0x00000000)
#define DEF_TX_ACK_POLICY_1_7() (REG32(ADR_TX_ACK_POLICY_1_7)) = (0x00000000)
#define DEF_TX_SEQ_CTRL_1_7() (REG32(ADR_TX_SEQ_CTRL_1_7)) = (0x00000000)
#define DEF_INFO0() (REG32(ADR_INFO0)) = (0x00000000)
#define DEF_INFO1() (REG32(ADR_INFO1)) = (0x00000100)
#define DEF_INFO2() (REG32(ADR_INFO2)) = (0x00000200)
#define DEF_INFO3() (REG32(ADR_INFO3)) = (0x00000300)
#define DEF_INFO4() (REG32(ADR_INFO4)) = (0x00000140)
#define DEF_INFO5() (REG32(ADR_INFO5)) = (0x00000240)
#define DEF_INFO6() (REG32(ADR_INFO6)) = (0x00000340)
#define DEF_INFO7() (REG32(ADR_INFO7)) = (0x00000001)
#define DEF_INFO8() (REG32(ADR_INFO8)) = (0x00000101)
#define DEF_INFO9() (REG32(ADR_INFO9)) = (0x00000201)
#define DEF_INFO10() (REG32(ADR_INFO10)) = (0x00000301)
#define DEF_INFO11() (REG32(ADR_INFO11)) = (0x00000401)
#define DEF_INFO12() (REG32(ADR_INFO12)) = (0x00000501)
#define DEF_INFO13() (REG32(ADR_INFO13)) = (0x00000601)
#define DEF_INFO14() (REG32(ADR_INFO14)) = (0x00000701)
#define DEF_INFO15() (REG32(ADR_INFO15)) = (0x00030002)
#define DEF_INFO16() (REG32(ADR_INFO16)) = (0x00030102)
#define DEF_INFO17() (REG32(ADR_INFO17)) = (0x00030202)
#define DEF_INFO18() (REG32(ADR_INFO18)) = (0x00030302)
#define DEF_INFO19() (REG32(ADR_INFO19)) = (0x00030402)
#define DEF_INFO20() (REG32(ADR_INFO20)) = (0x00030502)
#define DEF_INFO21() (REG32(ADR_INFO21)) = (0x00030602)
#define DEF_INFO22() (REG32(ADR_INFO22)) = (0x00030702)
#define DEF_INFO23() (REG32(ADR_INFO23)) = (0x00030082)
#define DEF_INFO24() (REG32(ADR_INFO24)) = (0x00030182)
#define DEF_INFO25() (REG32(ADR_INFO25)) = (0x00030282)
#define DEF_INFO26() (REG32(ADR_INFO26)) = (0x00030382)
#define DEF_INFO27() (REG32(ADR_INFO27)) = (0x00030482)
#define DEF_INFO28() (REG32(ADR_INFO28)) = (0x00030582)
#define DEF_INFO29() (REG32(ADR_INFO29)) = (0x00030682)
#define DEF_INFO30() (REG32(ADR_INFO30)) = (0x00030782)
#define DEF_INFO31() (REG32(ADR_INFO31)) = (0x00030042)
#define DEF_INFO32() (REG32(ADR_INFO32)) = (0x00030142)
#define DEF_INFO33() (REG32(ADR_INFO33)) = (0x00030242)
#define DEF_INFO34() (REG32(ADR_INFO34)) = (0x00030342)
#define DEF_INFO35() (REG32(ADR_INFO35)) = (0x00030442)
#define DEF_INFO36() (REG32(ADR_INFO36)) = (0x00030542)
#define DEF_INFO37() (REG32(ADR_INFO37)) = (0x00030642)
#define DEF_INFO38() (REG32(ADR_INFO38)) = (0x00030742)
#define DEF_INFO_MASK() (REG32(ADR_INFO_MASK)) = (0x00007fc7)
#define DEF_INFO_RATE_OFFSET() (REG32(ADR_INFO_RATE_OFFSET)) = (0x00040000)
#define DEF_INFO_IDX_ADDR() (REG32(ADR_INFO_IDX_ADDR)) = (0x00000000)
#define DEF_INFO_LEN_ADDR() (REG32(ADR_INFO_LEN_ADDR)) = (0x00000000)
#define DEF_IC_TIME_TAG_0() (REG32(ADR_IC_TIME_TAG_0)) = (0x00000000)
#define DEF_IC_TIME_TAG_1() (REG32(ADR_IC_TIME_TAG_1)) = (0x00000000)
#define DEF_PACKET_ID_ALLOCATION_PRIORITY() (REG32(ADR_PACKET_ID_ALLOCATION_PRIORITY)) = (0x00000000)
#define DEF_MAC_MODE() (REG32(ADR_MAC_MODE)) = (0x00000000)
#define DEF_ALL_SOFTWARE_RESET() (REG32(ADR_ALL_SOFTWARE_RESET)) = (0x00000000)
#define DEF_ENG_SOFTWARE_RESET() (REG32(ADR_ENG_SOFTWARE_RESET)) = (0x00000000)
#define DEF_CSR_SOFTWARE_RESET() (REG32(ADR_CSR_SOFTWARE_RESET)) = (0x00000000)
#define DEF_MAC_CLOCK_ENABLE() (REG32(ADR_MAC_CLOCK_ENABLE)) = (0x00003efb)
#define DEF_MAC_ENGINE_CLOCK_ENABLE() (REG32(ADR_MAC_ENGINE_CLOCK_ENABLE)) = (0x0000f07b)
#define DEF_MAC_CSR_CLOCK_ENABLE() (REG32(ADR_MAC_CSR_CLOCK_ENABLE)) = (0x0000ec02)
#define DEF_GLBLE_SET() (REG32(ADR_GLBLE_SET)) = (0x000e5000)
#define DEF_REASON_TRAP0() (REG32(ADR_REASON_TRAP0)) = (0x00000000)
#define DEF_REASON_TRAP1() (REG32(ADR_REASON_TRAP1)) = (0x00000000)
#define DEF_BSSID_0() (REG32(ADR_BSSID_0)) = (0x00000000)
#define DEF_BSSID_1() (REG32(ADR_BSSID_1)) = (0x00000000)
#define DEF_SCRT_STATE() (REG32(ADR_SCRT_STATE)) = (0x00000000)
#define DEF_STA_MAC_0() (REG32(ADR_STA_MAC_0)) = (0x00000000)
#define DEF_STA_MAC_1() (REG32(ADR_STA_MAC_1)) = (0x00000000)
#define DEF_SCRT_SET() (REG32(ADR_SCRT_SET)) = (0x00000000)
#define DEF_BTCX0() (REG32(ADR_BTCX0)) = (0x00000006)
#define DEF_BTCX1() (REG32(ADR_BTCX1)) = (0x00000000)
#define DEF_SWITCH_CTL() (REG32(ADR_SWITCH_CTL)) = (0x00000000)
#define DEF_MIB_EN() (REG32(ADR_MIB_EN)) = (0x00000000)
#define DEF_MTX_WSID0_SUCC() (REG32(ADR_MTX_WSID0_SUCC)) = (0x00000000)
#define DEF_MTX_WSID0_FRM() (REG32(ADR_MTX_WSID0_FRM)) = (0x00000000)
#define DEF_MTX_WSID0_RETRY() (REG32(ADR_MTX_WSID0_RETRY)) = (0x00000000)
#define DEF_MTX_WSID0_TOTAL() (REG32(ADR_MTX_WSID0_TOTAL)) = (0x00000000)
#define DEF_MTX_GROUP() (REG32(ADR_MTX_GROUP)) = (0x00000000)
#define DEF_MTX_FAIL() (REG32(ADR_MTX_FAIL)) = (0x00000000)
#define DEF_MTX_RETRY() (REG32(ADR_MTX_RETRY)) = (0x00000000)
#define DEF_MTX_MULTI_RETRY() (REG32(ADR_MTX_MULTI_RETRY)) = (0x00000000)
#define DEF_MTX_RTS_SUCCESS() (REG32(ADR_MTX_RTS_SUCCESS)) = (0x00000000)
#define DEF_MTX_RTS_FAIL() (REG32(ADR_MTX_RTS_FAIL)) = (0x00000000)
#define DEF_MTX_ACK_FAIL() (REG32(ADR_MTX_ACK_FAIL)) = (0x00000000)
#define DEF_MTX_FRM() (REG32(ADR_MTX_FRM)) = (0x00000000)
#define DEF_MTX_ACK_TX() (REG32(ADR_MTX_ACK_TX)) = (0x00000000)
#define DEF_MTX_CTS_TX() (REG32(ADR_MTX_CTS_TX)) = (0x00000000)
#define DEF_MRX_DUP_FRM() (REG32(ADR_MRX_DUP_FRM)) = (0x00000000)
#define DEF_MRX_FRG_FRM() (REG32(ADR_MRX_FRG_FRM)) = (0x00000000)
#define DEF_MRX_GROUP_FRM() (REG32(ADR_MRX_GROUP_FRM)) = (0x00000000)
#define DEF_MRX_FCS_ERR() (REG32(ADR_MRX_FCS_ERR)) = (0x00000000)
#define DEF_MRX_FCS_SUCC() (REG32(ADR_MRX_FCS_SUCC)) = (0x00000000)
#define DEF_MRX_MISS() (REG32(ADR_MRX_MISS)) = (0x00000000)
#define DEF_MRX_ALC_FAIL() (REG32(ADR_MRX_ALC_FAIL)) = (0x00000000)
#define DEF_MRX_DAT_NTF() (REG32(ADR_MRX_DAT_NTF)) = (0x00000000)
#define DEF_MRX_RTS_NTF() (REG32(ADR_MRX_RTS_NTF)) = (0x00000000)
#define DEF_MRX_CTS_NTF() (REG32(ADR_MRX_CTS_NTF)) = (0x00000000)
#define DEF_MRX_ACK_NTF() (REG32(ADR_MRX_ACK_NTF)) = (0x00000000)
#define DEF_MRX_BA_NTF() (REG32(ADR_MRX_BA_NTF)) = (0x00000000)
#define DEF_MRX_DATA_NTF() (REG32(ADR_MRX_DATA_NTF)) = (0x00000000)
#define DEF_MRX_MNG_NTF() (REG32(ADR_MRX_MNG_NTF)) = (0x00000000)
#define DEF_MRX_DAT_CRC_NTF() (REG32(ADR_MRX_DAT_CRC_NTF)) = (0x00000000)
#define DEF_MRX_BAR_NTF() (REG32(ADR_MRX_BAR_NTF)) = (0x00000000)
#define DEF_MRX_MB_MISS() (REG32(ADR_MRX_MB_MISS)) = (0x00000000)
#define DEF_MRX_NIDLE_MISS() (REG32(ADR_MRX_NIDLE_MISS)) = (0x00000000)
#define DEF_MRX_CSR_NTF() (REG32(ADR_MRX_CSR_NTF)) = (0x00000000)
#define DEF_DBG_Q0_FRM_SUCCESS() (REG32(ADR_DBG_Q0_FRM_SUCCESS)) = (0x00000000)
#define DEF_DBG_Q0_FRM_FAIL() (REG32(ADR_DBG_Q0_FRM_FAIL)) = (0x00000000)
#define DEF_DBG_Q0_ACK_SUCCESS() (REG32(ADR_DBG_Q0_ACK_SUCCESS)) = (0x00000000)
#define DEF_DBG_Q0_ACK_FAIL() (REG32(ADR_DBG_Q0_ACK_FAIL)) = (0x00000000)
#define DEF_DBG_Q1_FRM_SUCCESS() (REG32(ADR_DBG_Q1_FRM_SUCCESS)) = (0x00000000)
#define DEF_DBG_Q1_FRM_FAIL() (REG32(ADR_DBG_Q1_FRM_FAIL)) = (0x00000000)
#define DEF_DBG_Q1_ACK_SUCCESS() (REG32(ADR_DBG_Q1_ACK_SUCCESS)) = (0x00000000)
#define DEF_DBG_Q1_ACK_FAIL() (REG32(ADR_DBG_Q1_ACK_FAIL)) = (0x00000000)
#define DEF_DBG_Q2_FRM_SUCCESS() (REG32(ADR_DBG_Q2_FRM_SUCCESS)) = (0x00000000)
#define DEF_DBG_Q2_FRM_FAIL() (REG32(ADR_DBG_Q2_FRM_FAIL)) = (0x00000000)
#define DEF_DBG_Q2_ACK_SUCCESS() (REG32(ADR_DBG_Q2_ACK_SUCCESS)) = (0x00000000)
#define DEF_DBG_Q2_ACK_FAIL() (REG32(ADR_DBG_Q2_ACK_FAIL)) = (0x00000000)
#define DEF_DBG_Q3_FRM_SUCCESS() (REG32(ADR_DBG_Q3_FRM_SUCCESS)) = (0x00000000)
#define DEF_DBG_Q3_FRM_FAIL() (REG32(ADR_DBG_Q3_FRM_FAIL)) = (0x00000000)
#define DEF_DBG_Q3_ACK_SUCCESS() (REG32(ADR_DBG_Q3_ACK_SUCCESS)) = (0x00000000)
#define DEF_DBG_Q3_ACK_FAIL() (REG32(ADR_DBG_Q3_ACK_FAIL)) = (0x00000000)
#define DEF_MIB_SCRT_TKIP0() (REG32(ADR_MIB_SCRT_TKIP0)) = (0x00000000)
#define DEF_MIB_SCRT_TKIP1() (REG32(ADR_MIB_SCRT_TKIP1)) = (0x00000000)
#define DEF_MIB_SCRT_TKIP2() (REG32(ADR_MIB_SCRT_TKIP2)) = (0x00000000)
#define DEF_MIB_SCRT_CCMP0() (REG32(ADR_MIB_SCRT_CCMP0)) = (0x00000000)
#define DEF_MIB_SCRT_CCMP1() (REG32(ADR_MIB_SCRT_CCMP1)) = (0x00000000)
#define DEF_DBG_LEN_CRC_FAIL() (REG32(ADR_DBG_LEN_CRC_FAIL)) = (0x00000000)
#define DEF_DBG_LEN_ALC_FAIL() (REG32(ADR_DBG_LEN_ALC_FAIL)) = (0x00000000)
#define DEF_DBG_AMPDU_PASS() (REG32(ADR_DBG_AMPDU_PASS)) = (0x00000000)
#define DEF_DBG_AMPDU_FAIL() (REG32(ADR_DBG_AMPDU_FAIL)) = (0x00000000)
#define DEF_ID_ALC_FAIL1() (REG32(ADR_ID_ALC_FAIL1)) = (0x00000000)
#define DEF_ID_ALC_FAIL2() (REG32(ADR_ID_ALC_FAIL2)) = (0x00000000)
#define DEF_CBR_HARD_WIRE_PIN_REGISTER() (REG32(ADR_CBR_HARD_WIRE_PIN_REGISTER)) = (0x00004000)
#define DEF_CBR_MANUAL_ENABLE_REGISTER() (REG32(ADR_CBR_MANUAL_ENABLE_REGISTER)) = (0x00001fc0)
#define DEF_CBR_LDO_REGISTER() (REG32(ADR_CBR_LDO_REGISTER)) = (0x2496db1b)
#define DEF_CBR_ABB_REGISTER_1() (REG32(ADR_CBR_ABB_REGISTER_1)) = (0x151558dd)
#define DEF_CBR_ABB_REGISTER_2() (REG32(ADR_CBR_ABB_REGISTER_2)) = (0x01011a88)
#define DEF_CBR_TX_FE_REGISTER() (REG32(ADR_CBR_TX_FE_REGISTER)) = (0x3cbe84fe)
#define DEF_CBR_RX_FE_REGISTER_1() (REG32(ADR_CBR_RX_FE_REGISTER_1)) = (0x00657579)
#define DEF_CBR_RX_FE_GAIN_DECODER_REGISTER_1() (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_1)) = (0x000103a7)
#define DEF_CBR_RX_FE_GAIN_DECODER_REGISTER_2() (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_2)) = (0x000103a6)
#define DEF_CBR_RX_FE_GAIN_DECODER_REGISTER_3() (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_3)) = (0x00012001)
#define DEF_CBR_RX_FE_GAIN_DECODER_REGISTER_4() (REG32(ADR_CBR_RX_FE_GAIN_DECODER_REGISTER_4)) = (0x00036000)
#define DEF_CBR_RX_FSM_REGISTER() (REG32(ADR_CBR_RX_FSM_REGISTER)) = (0x00000ca8)
#define DEF_CBR_RX_ADC_REGISTER() (REG32(ADR_CBR_RX_ADC_REGISTER)) = (0x002a0224)
#define DEF_CBR_TX_DAC_REGISTER() (REG32(ADR_CBR_TX_DAC_REGISTER)) = (0x00002655)
#define DEF_CBR_SX_ENABLE_RGISTER() (REG32(ADR_CBR_SX_ENABLE_RGISTER)) = (0x0000647c)
#define DEF_CBR_SYN_RGISTER_1() (REG32(ADR_CBR_SYN_RGISTER_1)) = (0xaa800000)
#define DEF_CBR_SYN_RGISTER_2() (REG32(ADR_CBR_SYN_RGISTER_2)) = (0x00550800)
#define DEF_CBR_SYN_PFD_CHP() (REG32(ADR_CBR_SYN_PFD_CHP)) = (0x07c0894a)
#define DEF_CBR_SYN_VCO_LOBF() (REG32(ADR_CBR_SYN_VCO_LOBF)) = (0xfcccca27)
#define DEF_CBR_SYN_DIV_SDM_XOSC() (REG32(ADR_CBR_SYN_DIV_SDM_XOSC)) = (0x2773c93c)
#define DEF_CBR_SYN_LCK1() (REG32(ADR_CBR_SYN_LCK1)) = (0x00000a7c)
#define DEF_CBR_SYN_LCK2() (REG32(ADR_CBR_SYN_LCK2)) = (0x01c67ff4)
#define DEF_CBR_DPLL_VCO_REGISTER() (REG32(ADR_CBR_DPLL_VCO_REGISTER)) = (0x00103014)
#define DEF_CBR_DPLL_CP_PFD_REGISTER() (REG32(ADR_CBR_DPLL_CP_PFD_REGISTER)) = (0x0001848c)
#define DEF_CBR_DPLL_DIVIDER_REGISTER() (REG32(ADR_CBR_DPLL_DIVIDER_REGISTER)) = (0x034061e0)
#define DEF_CBR_DCOC_IDAC_REGISTER1() (REG32(ADR_CBR_DCOC_IDAC_REGISTER1)) = (0x00820820)
#define DEF_CBR_DCOC_IDAC_REGISTER2() (REG32(ADR_CBR_DCOC_IDAC_REGISTER2)) = (0x00820820)
#define DEF_CBR_DCOC_IDAC_REGISTER3() (REG32(ADR_CBR_DCOC_IDAC_REGISTER3)) = (0x00820820)
#define DEF_CBR_DCOC_IDAC_REGISTER4() (REG32(ADR_CBR_DCOC_IDAC_REGISTER4)) = (0x00820820)
#define DEF_CBR_DCOC_IDAC_REGISTER5() (REG32(ADR_CBR_DCOC_IDAC_REGISTER5)) = (0x00820820)
#define DEF_CBR_DCOC_IDAC_REGISTER6() (REG32(ADR_CBR_DCOC_IDAC_REGISTER6)) = (0x00820820)
#define DEF_CBR_DCOC_IDAC_REGISTER7() (REG32(ADR_CBR_DCOC_IDAC_REGISTER7)) = (0x00820820)
#define DEF_CBR_DCOC_IDAC_REGISTER8() (REG32(ADR_CBR_DCOC_IDAC_REGISTER8)) = (0x00820820)
#define DEF_CBR_RCAL_REGISTER() (REG32(ADR_CBR_RCAL_REGISTER)) = (0x00004080)
#define DEF_CBR_MANUAL_REGISTER() (REG32(ADR_CBR_MANUAL_REGISTER)) = (0x00003e7e)
#define DEF_CBR_TRX_DUMMY_REGISTER() (REG32(ADR_CBR_TRX_DUMMY_REGISTER)) = (0xaaaaaaaa)
#define DEF_CBR_SX_DUMMY_REGISTER() (REG32(ADR_CBR_SX_DUMMY_REGISTER)) = (0xaaaaaaaa)
#define DEF_CBR_RG_PKT_GEN_0() (REG32(ADR_CBR_RG_PKT_GEN_0)) = (0x00000000)
#define DEF_CBR_RG_PKT_GEN_1() (REG32(ADR_CBR_RG_PKT_GEN_1)) = (0x00000000)
#define DEF_CBR_RG_PKT_GEN_2() (REG32(ADR_CBR_RG_PKT_GEN_2)) = (0x00000000)
#define DEF_CBR_RG_INTEGRATION() (REG32(ADR_CBR_RG_INTEGRATION)) = (0x00000000)
#define DEF_CBR_RG_PKT_GEN_TXCNT() (REG32(ADR_CBR_RG_PKT_GEN_TXCNT)) = (0x00000000)
#define DEF_CBR_PATTERN_GEN() (REG32(ADR_CBR_PATTERN_GEN)) = (0xff000000)
#define DEF_MB_CPU_INT() (REG32(ADR_MB_CPU_INT)) = (0x00000000)
#define DEF_CPU_ID_TB0() (REG32(ADR_CPU_ID_TB0)) = (0x00000000)
#define DEF_CPU_ID_TB1() (REG32(ADR_CPU_ID_TB1)) = (0x00000000)
#define DEF_CH0_TRIG_1() (REG32(ADR_CH0_TRIG_1)) = (0x00000000)
#define DEF_CH0_TRIG_0() (REG32(ADR_CH0_TRIG_0)) = (0x00000000)
#define DEF_CH0_PRI_TRIG() (REG32(ADR_CH0_PRI_TRIG)) = (0x00000000)
#define DEF_MCU_STATUS() (REG32(ADR_MCU_STATUS)) = (0x00000000)
#define DEF_RD_IN_FFCNT1() (REG32(ADR_RD_IN_FFCNT1)) = (0x00000000)
#define DEF_RD_IN_FFCNT2() (REG32(ADR_RD_IN_FFCNT2)) = (0x00000000)
#define DEF_RD_FFIN_FULL() (REG32(ADR_RD_FFIN_FULL)) = (0x00000000)
#define DEF_MBOX_HALT_CFG() (REG32(ADR_MBOX_HALT_CFG)) = (0x00000000)
#define DEF_MB_DBG_CFG1() (REG32(ADR_MB_DBG_CFG1)) = (0x00080000)
#define DEF_MB_DBG_CFG2() (REG32(ADR_MB_DBG_CFG2)) = (0x00000000)
#define DEF_MB_DBG_CFG3() (REG32(ADR_MB_DBG_CFG3)) = (0x00000000)
#define DEF_MB_DBG_CFG4() (REG32(ADR_MB_DBG_CFG4)) = (0xffffffff)
#define DEF_MB_OUT_QUEUE_CFG() (REG32(ADR_MB_OUT_QUEUE_CFG)) = (0x00000002)
#define DEF_MB_OUT_QUEUE_FLUSH() (REG32(ADR_MB_OUT_QUEUE_FLUSH)) = (0x00000000)
#define DEF_RD_FFOUT_CNT1() (REG32(ADR_RD_FFOUT_CNT1)) = (0x00000000)
#define DEF_RD_FFOUT_CNT2() (REG32(ADR_RD_FFOUT_CNT2)) = (0x00000000)
#define DEF_RD_FFOUT_CNT3() (REG32(ADR_RD_FFOUT_CNT3)) = (0x00000000)
#define DEF_RD_FFOUT_FULL() (REG32(ADR_RD_FFOUT_FULL)) = (0x00000000)
#define DEF_MB_THRESHOLD6() (REG32(ADR_MB_THRESHOLD6)) = (0x00000000)
#define DEF_MB_THRESHOLD7() (REG32(ADR_MB_THRESHOLD7)) = (0x00000000)
#define DEF_MB_THRESHOLD8() (REG32(ADR_MB_THRESHOLD8)) = (0x00000000)
#define DEF_MB_THRESHOLD9() (REG32(ADR_MB_THRESHOLD9)) = (0x00000000)
#define DEF_MB_THRESHOLD10() (REG32(ADR_MB_THRESHOLD10)) = (0x00000000)
#define DEF_MB_TRASH_CFG() (REG32(ADR_MB_TRASH_CFG)) = (0x01000001)
#define DEF_MB_IN_FF_FLUSH() (REG32(ADR_MB_IN_FF_FLUSH)) = (0x00000000)
#define DEF_CPU_ID_TB2() (REG32(ADR_CPU_ID_TB2)) = (0x00000000)
#define DEF_CPU_ID_TB3() (REG32(ADR_CPU_ID_TB3)) = (0x00000000)
#define DEF_PHY_IQ_LOG_CFG0() (REG32(ADR_PHY_IQ_LOG_CFG0)) = (0x00000000)
#define DEF_PHY_IQ_LOG_CFG1() (REG32(ADR_PHY_IQ_LOG_CFG1)) = (0x00000000)
#define DEF_PHY_IQ_LOG_LEN() (REG32(ADR_PHY_IQ_LOG_LEN)) = (0x00001000)
#define DEF_PHY_IQ_LOG_PTR() (REG32(ADR_PHY_IQ_LOG_PTR)) = (0x00000000)
#define DEF_WR_ALC() (REG32(ADR_WR_ALC)) = (0x00000000)
#define DEF_GETID() (REG32(ADR_GETID)) = (0x00000000)
#define DEF_CH_STA_PRI() (REG32(ADR_CH_STA_PRI)) = (0x00000213)
#define DEF_RD_ID0() (REG32(ADR_RD_ID0)) = (0x00000000)
#define DEF_RD_ID1() (REG32(ADR_RD_ID1)) = (0x00000000)
#define DEF_IMD_CFG() (REG32(ADR_IMD_CFG)) = (0x00000000)
#define DEF_IMD_STA() (REG32(ADR_IMD_STA)) = (0x00000000)
#define DEF_ALC_STA() (REG32(ADR_ALC_STA)) = (0x01000000)
#define DEF_TRX_ID_COUNT() (REG32(ADR_TRX_ID_COUNT)) = (0x00000000)
#define DEF_TRX_ID_THRESHOLD() (REG32(ADR_TRX_ID_THRESHOLD)) = (0x01ee3c3c)
#define DEF_TX_ID0() (REG32(ADR_TX_ID0)) = (0x00000000)
#define DEF_TX_ID1() (REG32(ADR_TX_ID1)) = (0x00000000)
#define DEF_RX_ID0() (REG32(ADR_RX_ID0)) = (0x00000000)
#define DEF_RX_ID1() (REG32(ADR_RX_ID1)) = (0x00000000)
#define DEF_RTN_STA() (REG32(ADR_RTN_STA)) = (0x00000001)
#define DEF_ID_LEN_THREADSHOLD1() (REG32(ADR_ID_LEN_THREADSHOLD1)) = (0x000f0641)
#define DEF_ID_LEN_THREADSHOLD2() (REG32(ADR_ID_LEN_THREADSHOLD2)) = (0x00000000)
#define DEF_CH_ARB_PRI() (REG32(ADR_CH_ARB_PRI)) = (0x00031201)
#define DEF_TX_ID_REMAIN_STATUS() (REG32(ADR_TX_ID_REMAIN_STATUS)) = (0x00000000)
#define DEF_ID_INFO_STA() (REG32(ADR_ID_INFO_STA)) = (0x00000100)
#define DEF_TX_LIMIT_INTR() (REG32(ADR_TX_LIMIT_INTR)) = (0x00000000)
#define DEF_TX_ID_ALL_INFO() (REG32(ADR_TX_ID_ALL_INFO)) = (0x00000000)
#define DEF_RD_ID2() (REG32(ADR_RD_ID2)) = (0x00000000)
#define DEF_RD_ID3() (REG32(ADR_RD_ID3)) = (0x00000000)
#define DEF_TX_ID2() (REG32(ADR_TX_ID2)) = (0x00000000)
#define DEF_TX_ID3() (REG32(ADR_TX_ID3)) = (0x00000000)
#define DEF_RX_ID2() (REG32(ADR_RX_ID2)) = (0x00000000)
#define DEF_RX_ID3() (REG32(ADR_RX_ID3)) = (0x00000000)
#define DEF_TX_ID_ALL_INFO2() (REG32(ADR_TX_ID_ALL_INFO2)) = (0x00000000)
#define DEF_TX_ID_ALL_INFO_A() (REG32(ADR_TX_ID_ALL_INFO_A)) = (0x00000000)
#define DEF_TX_ID_ALL_INFO_B() (REG32(ADR_TX_ID_ALL_INFO_B)) = (0x00000000)
#define DEF_TX_ID_REMAIN_STATUS2() (REG32(ADR_TX_ID_REMAIN_STATUS2)) = (0x01000100)
#define DEF_ALC_ID_INFO() (REG32(ADR_ALC_ID_INFO)) = (0x00000000)
#define DEF_ALC_ID_INF1() (REG32(ADR_ALC_ID_INF1)) = (0x00000000)
#define DEF_PHY_EN_0() (REG32(ADR_PHY_EN_0)) = (0x00000014)
#define DEF_PHY_EN_1() (REG32(ADR_PHY_EN_1)) = (0x00000000)
#define DEF_SVN_VERSION_REG() (REG32(ADR_SVN_VERSION_REG)) = (0x00000000)
#define DEF_PHY_PKT_GEN_0() (REG32(ADR_PHY_PKT_GEN_0)) = (0x00000064)
#define DEF_PHY_PKT_GEN_1() (REG32(ADR_PHY_PKT_GEN_1)) = (0x00000fff)
#define DEF_PHY_PKT_GEN_2() (REG32(ADR_PHY_PKT_GEN_2)) = (0x00000003)
#define DEF_PHY_PKT_GEN_3() (REG32(ADR_PHY_PKT_GEN_3)) = (0x005a0220)
#define DEF_PHY_PKT_GEN_4() (REG32(ADR_PHY_PKT_GEN_4)) = (0x00000001)
#define DEF_PHY_REG_00() (REG32(ADR_PHY_REG_00)) = (0x10000000)
#define DEF_PHY_REG_01() (REG32(ADR_PHY_REG_01)) = (0x00000000)
#define DEF_PHY_REG_02_AGC() (REG32(ADR_PHY_REG_02_AGC)) = (0x80046771)
#define DEF_PHY_REG_03_AGC() (REG32(ADR_PHY_REG_03_AGC)) = (0x1f300f6f)
#define DEF_PHY_REG_04_AGC() (REG32(ADR_PHY_REG_04_AGC)) = (0x663f36d0)
#define DEF_PHY_REG_05_AGC() (REG32(ADR_PHY_REG_05_AGC)) = (0x106c0000)
#define DEF_PHY_REG_06_11B_DAGC() (REG32(ADR_PHY_REG_06_11B_DAGC)) = (0x01603fff)
#define DEF_PHY_REG_07_11B_DAGC() (REG32(ADR_PHY_REG_07_11B_DAGC)) = (0x00600808)
#define DEF_PHY_REG_08_11GN_DAGC() (REG32(ADR_PHY_REG_08_11GN_DAGC)) = (0xff000160)
#define DEF_PHY_REG_09_11GN_DAGC() (REG32(ADR_PHY_REG_09_11GN_DAGC)) = (0x00080840)
#define DEF_PHY_READ_REG_00_DIG_PWR() (REG32(ADR_PHY_READ_REG_00_DIG_PWR)) = (0x00000000)
#define DEF_PHY_READ_REG_01_RF_GAIN_PWR() (REG32(ADR_PHY_READ_REG_01_RF_GAIN_PWR)) = (0x00000000)
#define DEF_PHY_READ_REG_02_RF_GAIN_PWR() (REG32(ADR_PHY_READ_REG_02_RF_GAIN_PWR)) = (0x00000000)
#define DEF_PHY_READ_REG_03_RF_GAIN_PWR() (REG32(ADR_PHY_READ_REG_03_RF_GAIN_PWR)) = (0x00000000)
#define DEF_PHY_REG_10_TX_DES() (REG32(ADR_PHY_REG_10_TX_DES)) = (0x00010405)
#define DEF_PHY_REG_11_TX_DES() (REG32(ADR_PHY_REG_11_TX_DES)) = (0x06090813)
#define DEF_PHY_REG_12_TX_DES() (REG32(ADR_PHY_REG_12_TX_DES)) = (0x12070000)
#define DEF_PHY_REG_13_RX_DES() (REG32(ADR_PHY_REG_13_RX_DES)) = (0x01000405)
#define DEF_PHY_REG_14_RX_DES() (REG32(ADR_PHY_REG_14_RX_DES)) = (0x06090813)
#define DEF_PHY_REG_15_RX_DES() (REG32(ADR_PHY_REG_15_RX_DES)) = (0x12010000)
#define DEF_PHY_REG_16_TX_DES_EXCP() (REG32(ADR_PHY_REG_16_TX_DES_EXCP)) = (0x00000000)
#define DEF_PHY_REG_17_TX_DES_EXCP() (REG32(ADR_PHY_REG_17_TX_DES_EXCP)) = (0x10110000)
#define DEF_PHY_REG_18_RSSI_SNR() (REG32(ADR_PHY_REG_18_RSSI_SNR)) = (0x00fc000f)
#define DEF_PHY_REG_19_DAC_MANUAL() (REG32(ADR_PHY_REG_19_DAC_MANUAL)) = (0x00000000)
#define DEF_PHY_REG_20_MRX_CNT() (REG32(ADR_PHY_REG_20_MRX_CNT)) = (0x00000000)
#define DEF_PHY_REG_21_TRX_RAMP() (REG32(ADR_PHY_REG_21_TRX_RAMP)) = (0x3c012801)
#define DEF_PHY_REG_22_TRX_RAMP() (REG32(ADR_PHY_REG_22_TRX_RAMP)) = (0x24243724)
#define DEF_PHY_REG_23_ANT() (REG32(ADR_PHY_REG_23_ANT)) = (0x00000011)
#define DEF_PHY_REG_24_MTX_LEN_CNT() (REG32(ADR_PHY_REG_24_MTX_LEN_CNT)) = (0x1fff0000)
#define DEF_PHY_REG_25_MTX_LEN_CNT() (REG32(ADR_PHY_REG_25_MTX_LEN_CNT)) = (0x1fff0000)
#define DEF_PHY_REG_26_MRX_LEN_CNT() (REG32(ADR_PHY_REG_26_MRX_LEN_CNT)) = (0x1fff0000)
#define DEF_PHY_REG_27_MRX_LEN_CNT() (REG32(ADR_PHY_REG_27_MRX_LEN_CNT)) = (0x1fff0000)
#define DEF_PHY_READ_REG_04() (REG32(ADR_PHY_READ_REG_04)) = (0x00000000)
#define DEF_PHY_READ_REG_05() (REG32(ADR_PHY_READ_REG_05)) = (0x00000000)
#define DEF_PHY_REG_28_BIST() (REG32(ADR_PHY_REG_28_BIST)) = (0x0000fe3e)
#define DEF_PHY_READ_REG_06_BIST() (REG32(ADR_PHY_READ_REG_06_BIST)) = (0x00000000)
#define DEF_PHY_READ_REG_07_BIST() (REG32(ADR_PHY_READ_REG_07_BIST)) = (0x00000000)
#define DEF_PHY_REG_29_MTRX_MAC() (REG32(ADR_PHY_REG_29_MTRX_MAC)) = (0xffffffff)
#define DEF_PHY_READ_REG_08_MTRX_MAC() (REG32(ADR_PHY_READ_REG_08_MTRX_MAC)) = (0x00000000)
#define DEF_PHY_READ_REG_09_MTRX_MAC() (REG32(ADR_PHY_READ_REG_09_MTRX_MAC)) = (0x00000000)
#define DEF_PHY_REG_30_TX_UP_FIL() (REG32(ADR_PHY_REG_30_TX_UP_FIL)) = (0x0ead04f5)
#define DEF_PHY_REG_31_TX_UP_FIL() (REG32(ADR_PHY_REG_31_TX_UP_FIL)) = (0x0fd60080)
#define DEF_PHY_REG_32_TX_UP_FIL() (REG32(ADR_PHY_REG_32_TX_UP_FIL)) = (0x00000009)
#define DEF_PHY_READ_TBUS() (REG32(ADR_PHY_READ_TBUS)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_00() (REG32(ADR_TX_11B_FIL_COEF_00)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_01() (REG32(ADR_TX_11B_FIL_COEF_01)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_02() (REG32(ADR_TX_11B_FIL_COEF_02)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_03() (REG32(ADR_TX_11B_FIL_COEF_03)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_04() (REG32(ADR_TX_11B_FIL_COEF_04)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_05() (REG32(ADR_TX_11B_FIL_COEF_05)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_06() (REG32(ADR_TX_11B_FIL_COEF_06)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_07() (REG32(ADR_TX_11B_FIL_COEF_07)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_08() (REG32(ADR_TX_11B_FIL_COEF_08)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_09() (REG32(ADR_TX_11B_FIL_COEF_09)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_10() (REG32(ADR_TX_11B_FIL_COEF_10)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_11() (REG32(ADR_TX_11B_FIL_COEF_11)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_12() (REG32(ADR_TX_11B_FIL_COEF_12)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_13() (REG32(ADR_TX_11B_FIL_COEF_13)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_14() (REG32(ADR_TX_11B_FIL_COEF_14)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_15() (REG32(ADR_TX_11B_FIL_COEF_15)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_16() (REG32(ADR_TX_11B_FIL_COEF_16)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_17() (REG32(ADR_TX_11B_FIL_COEF_17)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_18() (REG32(ADR_TX_11B_FIL_COEF_18)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_19() (REG32(ADR_TX_11B_FIL_COEF_19)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_20() (REG32(ADR_TX_11B_FIL_COEF_20)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_21() (REG32(ADR_TX_11B_FIL_COEF_21)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_22() (REG32(ADR_TX_11B_FIL_COEF_22)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_23() (REG32(ADR_TX_11B_FIL_COEF_23)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_24() (REG32(ADR_TX_11B_FIL_COEF_24)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_25() (REG32(ADR_TX_11B_FIL_COEF_25)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_26() (REG32(ADR_TX_11B_FIL_COEF_26)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_27() (REG32(ADR_TX_11B_FIL_COEF_27)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_28() (REG32(ADR_TX_11B_FIL_COEF_28)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_29() (REG32(ADR_TX_11B_FIL_COEF_29)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_30() (REG32(ADR_TX_11B_FIL_COEF_30)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_31() (REG32(ADR_TX_11B_FIL_COEF_31)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_32() (REG32(ADR_TX_11B_FIL_COEF_32)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_33() (REG32(ADR_TX_11B_FIL_COEF_33)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_34() (REG32(ADR_TX_11B_FIL_COEF_34)) = (0x00000000)
#define DEF_TX_11B_FIL_COEF_35() (REG32(ADR_TX_11B_FIL_COEF_35)) = (0x00000005)
#define DEF_TX_11B_FIL_COEF_36() (REG32(ADR_TX_11B_FIL_COEF_36)) = (0x0000003d)
#define DEF_TX_11B_FIL_COEF_37() (REG32(ADR_TX_11B_FIL_COEF_37)) = (0x00000162)
#define DEF_TX_11B_FIL_COEF_38() (REG32(ADR_TX_11B_FIL_COEF_38)) = (0x00000400)
#define DEF_TX_11B_FIL_COEF_39() (REG32(ADR_TX_11B_FIL_COEF_39)) = (0x00000699)
#define DEF_TX_11B_FIL_COEF_40() (REG32(ADR_TX_11B_FIL_COEF_40)) = (0x00000787)
#define DEF_TX_11B_PLCP() (REG32(ADR_TX_11B_PLCP)) = (0x00000000)
#define DEF_TX_11B_RAMP() (REG32(ADR_TX_11B_RAMP)) = (0x0000403c)
#define DEF_TX_11B_EN_CNT_RST_N() (REG32(ADR_TX_11B_EN_CNT_RST_N)) = (0x00000001)
#define DEF_TX_11B_EN_CNT() (REG32(ADR_TX_11B_EN_CNT)) = (0x00000000)
#define DEF_TX_11B_PKT_GEN_CNT() (REG32(ADR_TX_11B_PKT_GEN_CNT)) = (0x00000000)
#define DEF_RX_11B_DES_DLY() (REG32(ADR_RX_11B_DES_DLY)) = (0x00000044)
#define DEF_RX_11B_CCA_0() (REG32(ADR_RX_11B_CCA_0)) = (0x00040000)
#define DEF_RX_11B_CCA_1() (REG32(ADR_RX_11B_CCA_1)) = (0x00400040)
#define DEF_RX_11B_TR_KP_KI_0() (REG32(ADR_RX_11B_TR_KP_KI_0)) = (0x00003467)
#define DEF_RX_11B_TR_KP_KI_1() (REG32(ADR_RX_11B_TR_KP_KI_1)) = (0x00540000)
#define DEF_RX_11B_CE_CNT_THRESHOLD() (REG32(ADR_RX_11B_CE_CNT_THRESHOLD)) = (0x12243615)
#define DEF_RX_11B_CE_MU_0() (REG32(ADR_RX_11B_CE_MU_0)) = (0x00390002)
#define DEF_RX_11B_CE_MU_1() (REG32(ADR_RX_11B_CE_MU_1)) = (0x03456777)
#define DEF_RX_11B_EQ_MU_0() (REG32(ADR_RX_11B_EQ_MU_0)) = (0x00350046)
#define DEF_RX_11B_EQ_MU_1() (REG32(ADR_RX_11B_EQ_MU_1)) = (0x00570057)
#define DEF_RX_11B_EQ_CR_KP_KI() (REG32(ADR_RX_11B_EQ_CR_KP_KI)) = (0x00236700)
#define DEF_RX_11B_LPF_RATE() (REG32(ADR_RX_11B_LPF_RATE)) = (0x000d1746)
#define DEF_RX_11B_CIT_CNT_THRESHOLD() (REG32(ADR_RX_11B_CIT_CNT_THRESHOLD)) = (0x04061787)
#define DEF_RX_11B_EQ_CH_MAIN_TAP() (REG32(ADR_RX_11B_EQ_CH_MAIN_TAP)) = (0x07800000)
#define DEF_RX_11B_SEARCH_CNT_TH() (REG32(ADR_RX_11B_SEARCH_CNT_TH)) = (0x00c0000a)
#define DEF_RX_11B_CCA_CONTROL() (REG32(ADR_RX_11B_CCA_CONTROL)) = (0x00000000)
#define DEF_RX_11B_FREQUENCY_OFFSET() (REG32(ADR_RX_11B_FREQUENCY_OFFSET)) = (0x00000000)
#define DEF_RX_11B_SNR_RSSI() (REG32(ADR_RX_11B_SNR_RSSI)) = (0x00000000)
#define DEF_RX_11B_SFD_CRC_CNT() (REG32(ADR_RX_11B_SFD_CRC_CNT)) = (0x00000000)
#define DEF_RX_11B_PKT_ERR_AND_PKT_ERR_CNT() (REG32(ADR_RX_11B_PKT_ERR_AND_PKT_ERR_CNT)) = (0x00000000)
#define DEF_RX_11B_PKT_CCA_AND_PKT_CNT() (REG32(ADR_RX_11B_PKT_CCA_AND_PKT_CNT)) = (0x00000000)
#define DEF_RX_11B_SFD_FILED_0() (REG32(ADR_RX_11B_SFD_FILED_0)) = (0x00000000)
#define DEF_RX_11B_SFD_FIELD_1() (REG32(ADR_RX_11B_SFD_FIELD_1)) = (0x00000000)
#define DEF_RX_11B_PKT_STAT_EN() (REG32(ADR_RX_11B_PKT_STAT_EN)) = (0x00100000)
#define DEF_RX_11B_SOFT_RST() (REG32(ADR_RX_11B_SOFT_RST)) = (0x00000001)
#define DEF_TX_11GN_RAMP() (REG32(ADR_TX_11GN_RAMP)) = (0x0000233c)
#define DEF_TX_11GN_PLCP() (REG32(ADR_TX_11GN_PLCP)) = (0x5d08908e)
#define DEF_TX_11GN_PKT_GEN_CNT() (REG32(ADR_TX_11GN_PKT_GEN_CNT)) = (0x00000000)
#define DEF_TX_11GN_PLCP_CRC_ERR_CNT() (REG32(ADR_TX_11GN_PLCP_CRC_ERR_CNT)) = (0x00000000)
#define DEF_RX_11GN_DES_DLY() (REG32(ADR_RX_11GN_DES_DLY)) = (0x00000044)
#define DEF_RX_11GN_TR_0() (REG32(ADR_RX_11GN_TR_0)) = (0x00750075)
#define DEF_RX_11GN_TR_1() (REG32(ADR_RX_11GN_TR_1)) = (0x00000075)
#define DEF_RX_11GN_TR_2() (REG32(ADR_RX_11GN_TR_2)) = (0x10000075)
#define DEF_RX_11GN_CCA_0() (REG32(ADR_RX_11GN_CCA_0)) = (0x38324705)
#define DEF_RX_11GN_CCA_1() (REG32(ADR_RX_11GN_CCA_1)) = (0x30182000)
#define DEF_RX_11GN_CCA_2() (REG32(ADR_RX_11GN_CCA_2)) = (0x20600000)
#define DEF_RX_11GN_CCA_FFT_SCALE() (REG32(ADR_RX_11GN_CCA_FFT_SCALE)) = (0x0a010100)
#define DEF_RX_11GN_SOFT_DEMAP_0() (REG32(ADR_RX_11GN_SOFT_DEMAP_0)) = (0x50505050)
#define DEF_RX_11GN_SOFT_DEMAP_1() (REG32(ADR_RX_11GN_SOFT_DEMAP_1)) = (0x50000000)
#define DEF_RX_11GN_SOFT_DEMAP_2() (REG32(ADR_RX_11GN_SOFT_DEMAP_2)) = (0x50505050)
#define DEF_RX_11GN_SOFT_DEMAP_3() (REG32(ADR_RX_11GN_SOFT_DEMAP_3)) = (0x50505050)
#define DEF_RX_11GN_SOFT_DEMAP_4() (REG32(ADR_RX_11GN_SOFT_DEMAP_4)) = (0x50000000)
#define DEF_RX_11GN_SOFT_DEMAP_5() (REG32(ADR_RX_11GN_SOFT_DEMAP_5)) = (0x00000000)
#define DEF_RX_11GN_SYM_BOUND_0() (REG32(ADR_RX_11GN_SYM_BOUND_0)) = (0x00001420)
#define DEF_RX_11GN_SYM_BOUND_1() (REG32(ADR_RX_11GN_SYM_BOUND_1)) = (0x0000200a)
#define DEF_RX_11GN_CCA_PWR() (REG32(ADR_RX_11GN_CCA_PWR)) = (0x30000280)
#define DEF_RX_11GN_CCA_CNT() (REG32(ADR_RX_11GN_CCA_CNT)) = (0x30023002)
#define DEF_RX_11GN_CCA_ATCOR_RE_CHECK() (REG32(ADR_RX_11GN_CCA_ATCOR_RE_CHECK)) = (0x0000003a)
#define DEF_RX_11GN_VTB_TB() (REG32(ADR_RX_11GN_VTB_TB)) = (0x40000000)
#define DEF_RX_11GN_ERR_UPDATE() (REG32(ADR_RX_11GN_ERR_UPDATE)) = (0x009e007e)
#define DEF_RX_11GN_SHORT_GI() (REG32(ADR_RX_11GN_SHORT_GI)) = (0x00044400)
#define DEF_RX_11GN_CHANNEL_UPDATE() (REG32(ADR_RX_11GN_CHANNEL_UPDATE)) = (0x82000000)
#define DEF_RX_11GN_PKT_FORMAT_0() (REG32(ADR_RX_11GN_PKT_FORMAT_0)) = (0x02003030)
#define DEF_RX_11GN_PKT_FORMAT_1() (REG32(ADR_RX_11GN_PKT_FORMAT_1)) = (0x092a092a)
#define DEF_RX_11GN_TX_TIME() (REG32(ADR_RX_11GN_TX_TIME)) = (0x00700010)
#define DEF_RX_11GN_STBC_TR_KP_KI() (REG32(ADR_RX_11GN_STBC_TR_KP_KI)) = (0x00007575)
#define DEF_RX_11GN_BIST_0() (REG32(ADR_RX_11GN_BIST_0)) = (0x0001fe3e)
#define DEF_RX_11GN_BIST_1() (REG32(ADR_RX_11GN_BIST_1)) = (0x0000fe3e)
#define DEF_RX_11GN_BIST_2() (REG32(ADR_RX_11GN_BIST_2)) = (0x00000000)
#define DEF_RX_11GN_BIST_3() (REG32(ADR_RX_11GN_BIST_3)) = (0x00000000)
#define DEF_RX_11GN_BIST_4() (REG32(ADR_RX_11GN_BIST_4)) = (0x00000000)
#define DEF_RX_11GN_BIST_5() (REG32(ADR_RX_11GN_BIST_5)) = (0x00000000)
#define DEF_RX_11GN_SPECTRUM_ANALYZER() (REG32(ADR_RX_11GN_SPECTRUM_ANALYZER)) = (0x00000000)
#define DEF_RX_11GN_READ_0() (REG32(ADR_RX_11GN_READ_0)) = (0x00000000)
#define DEF_RX_11GN_FREQ_OFFSET() (REG32(ADR_RX_11GN_FREQ_OFFSET)) = (0x00000000)
#define DEF_RX_11GN_SIGNAL_FIELD_0() (REG32(ADR_RX_11GN_SIGNAL_FIELD_0)) = (0x00000000)
#define DEF_RX_11GN_SIGNAL_FIELD_1() (REG32(ADR_RX_11GN_SIGNAL_FIELD_1)) = (0x00000000)
#define DEF_RX_11GN_PKT_ERR_CNT() (REG32(ADR_RX_11GN_PKT_ERR_CNT)) = (0x00000000)
#define DEF_RX_11GN_PKT_CCA_AND_PKT_CNT() (REG32(ADR_RX_11GN_PKT_CCA_AND_PKT_CNT)) = (0x00000000)
#define DEF_RX_11GN_SERVICE_LENGTH_FIELD() (REG32(ADR_RX_11GN_SERVICE_LENGTH_FIELD)) = (0x00000000)
#define DEF_RX_11GN_RATE() (REG32(ADR_RX_11GN_RATE)) = (0x00000000)
#define DEF_RX_11GN_STAT_EN() (REG32(ADR_RX_11GN_STAT_EN)) = (0x00100001)
#define DEF_RX_11GN_SOFT_RST() (REG32(ADR_RX_11GN_SOFT_RST)) = (0x00000001)
#define DEF_RF_CONTROL_0() (REG32(ADR_RF_CONTROL_0)) = (0x00000000)
#define DEF_RF_CONTROL_1() (REG32(ADR_RF_CONTROL_1)) = (0x00008000)
#define DEF_TX_IQ_CONTROL_0() (REG32(ADR_TX_IQ_CONTROL_0)) = (0x00200020)
#define DEF_TX_IQ_CONTROL_1() (REG32(ADR_TX_IQ_CONTROL_1)) = (0x00028080)
#define DEF_TX_IQ_CONTROL_2() (REG32(ADR_TX_IQ_CONTROL_2)) = (0x00000000)
#define DEF_TX_COMPENSATION_CONTROL() (REG32(ADR_TX_COMPENSATION_CONTROL)) = (0x00000000)
#define DEF_RX_COMPENSATION_CONTROL() (REG32(ADR_RX_COMPENSATION_CONTROL)) = (0x00000000)
#define DEF_RX_OBSERVATION_CIRCUIT_0() (REG32(ADR_RX_OBSERVATION_CIRCUIT_0)) = (0x000028ff)
#define DEF_RX_OBSERVATION_CIRCUIT_1() (REG32(ADR_RX_OBSERVATION_CIRCUIT_1)) = (0x00000000)
#define DEF_RX_OBSERVATION_CIRCUIT_2() (REG32(ADR_RX_OBSERVATION_CIRCUIT_2)) = (0x00000000)
#define DEF_RX_OBSERVATION_CIRCUIT_3() (REG32(ADR_RX_OBSERVATION_CIRCUIT_3)) = (0x00000000)
#define DEF_RF_IQ_CONTROL_0() (REG32(ADR_RF_IQ_CONTROL_0)) = (0x00000202)
#define DEF_RF_IQ_CONTROL_1() (REG32(ADR_RF_IQ_CONTROL_1)) = (0x00ffc200)
#define DEF_RF_IQ_CONTROL_2() (REG32(ADR_RF_IQ_CONTROL_2)) = (0x00000000)
#define DEF_RF_IQ_CONTROL_3() (REG32(ADR_RF_IQ_CONTROL_3)) = (0x00000000)
#define DEF_DPD_CONTROL() (REG32(ADR_DPD_CONTROL)) = (0x00000000)
#define DEF_DPD_GAIN_TABLE_0() (REG32(ADR_DPD_GAIN_TABLE_0)) = (0x02000200)
#define DEF_DPD_GAIN_TABLE_1() (REG32(ADR_DPD_GAIN_TABLE_1)) = (0x02000200)
#define DEF_DPD_GAIN_TABLE_2() (REG32(ADR_DPD_GAIN_TABLE_2)) = (0x02000200)
#define DEF_DPD_GAIN_TABLE_3() (REG32(ADR_DPD_GAIN_TABLE_3)) = (0x02000200)
#define DEF_DPD_GAIN_TABLE_4() (REG32(ADR_DPD_GAIN_TABLE_4)) = (0x02000200)
#define DEF_DPD_GAIN_TABLE_5() (REG32(ADR_DPD_GAIN_TABLE_5)) = (0x02000200)
#define DEF_DPD_GAIN_TABLE_6() (REG32(ADR_DPD_GAIN_TABLE_6)) = (0x02000200)
#define DEF_DPD_GAIN_TABLE_7() (REG32(ADR_DPD_GAIN_TABLE_7)) = (0x02000200)
#define DEF_DPD_GAIN_TABLE_8() (REG32(ADR_DPD_GAIN_TABLE_8)) = (0x02000200)
#define DEF_DPD_GAIN_TABLE_9() (REG32(ADR_DPD_GAIN_TABLE_9)) = (0x02000200)
#define DEF_DPD_GAIN_TABLE_A() (REG32(ADR_DPD_GAIN_TABLE_A)) = (0x02000200)
#define DEF_DPD_GAIN_TABLE_B() (REG32(ADR_DPD_GAIN_TABLE_B)) = (0x02000200)
#define DEF_DPD_GAIN_TABLE_C() (REG32(ADR_DPD_GAIN_TABLE_C)) = (0x02000200)
#define DEF_DPD_PH_TABLE_0() (REG32(ADR_DPD_PH_TABLE_0)) = (0x00000000)
#define DEF_DPD_PH_TABLE_1() (REG32(ADR_DPD_PH_TABLE_1)) = (0x00000000)
#define DEF_DPD_PH_TABLE_2() (REG32(ADR_DPD_PH_TABLE_2)) = (0x00000000)
#define DEF_DPD_PH_TABLE_3() (REG32(ADR_DPD_PH_TABLE_3)) = (0x00000000)
#define DEF_DPD_PH_TABLE_4() (REG32(ADR_DPD_PH_TABLE_4)) = (0x00000000)
#define DEF_DPD_PH_TABLE_5() (REG32(ADR_DPD_PH_TABLE_5)) = (0x00000000)
#define DEF_DPD_PH_TABLE_6() (REG32(ADR_DPD_PH_TABLE_6)) = (0x00000000)
#define DEF_DPD_PH_TABLE_7() (REG32(ADR_DPD_PH_TABLE_7)) = (0x00000000)
#define DEF_DPD_PH_TABLE_8() (REG32(ADR_DPD_PH_TABLE_8)) = (0x00000000)
#define DEF_DPD_PH_TABLE_9() (REG32(ADR_DPD_PH_TABLE_9)) = (0x00000000)
#define DEF_DPD_PH_TABLE_A() (REG32(ADR_DPD_PH_TABLE_A)) = (0x00000000)
#define DEF_DPD_PH_TABLE_B() (REG32(ADR_DPD_PH_TABLE_B)) = (0x00000000)
#define DEF_DPD_PH_TABLE_C() (REG32(ADR_DPD_PH_TABLE_C)) = (0x00000000)
#define DEF_DPD_GAIN_ESTIMATION_0() (REG32(ADR_DPD_GAIN_ESTIMATION_0)) = (0x00000000)
#define DEF_DPD_GAIN_ESTIMATION_1() (REG32(ADR_DPD_GAIN_ESTIMATION_1)) = (0x00000100)
#define DEF_DPD_GAIN_ESTIMATION_2() (REG32(ADR_DPD_GAIN_ESTIMATION_2)) = (0x00000000)
#define DEF_TX_GAIN_FACTOR() (REG32(ADR_TX_GAIN_FACTOR)) = (0x80808080)
#define DEF_HARD_WIRE_PIN_REGISTER() (REG32(ADR_HARD_WIRE_PIN_REGISTER)) = (0x00004000)
#define DEF_MANUAL_ENABLE_REGISTER() (REG32(ADR_MANUAL_ENABLE_REGISTER)) = (0x00000fc0)
#define DEF_LDO_REGISTER() (REG32(ADR_LDO_REGISTER)) = (0x000db71b)
#define DEF_ABB_REGISTER_1() (REG32(ADR_ABB_REGISTER_1)) = (0x151558dd)
#define DEF_ABB_REGISTER_2() (REG32(ADR_ABB_REGISTER_2)) = (0x01011a88)
#define DEF_TX_FE_REGISTER() (REG32(ADR_TX_FE_REGISTER)) = (0x3d3e84fe)
#define DEF_RX_FE_REGISTER_1() (REG32(ADR_RX_FE_REGISTER_1)) = (0x03457579)
#define DEF_RX_FE_GAIN_DECODER_REGISTER_1() (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_1)) = (0x000103a7)
#define DEF_RX_FE_GAIN_DECODER_REGISTER_2() (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_2)) = (0x000103a6)
#define DEF_RX_FE_GAIN_DECODER_REGISTER_3() (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_3)) = (0x00012001)
#define DEF_RX_FE_GAIN_DECODER_REGISTER_4() (REG32(ADR_RX_FE_GAIN_DECODER_REGISTER_4)) = (0x00036000)
#define DEF_RX_TX_FSM_REGISTER() (REG32(ADR_RX_TX_FSM_REGISTER)) = (0x00030ca8)
#define DEF_RX_ADC_REGISTER() (REG32(ADR_RX_ADC_REGISTER)) = (0x20ea0224)
#define DEF_TX_DAC_REGISTER() (REG32(ADR_TX_DAC_REGISTER)) = (0x44000655)
#define DEF_SX_ENABLE_REGISTER() (REG32(ADR_SX_ENABLE_REGISTER)) = (0x0003e07c)
#define DEF_SYN_REGISTER_1() (REG32(ADR_SYN_REGISTER_1)) = (0xaa800000)
#define DEF_SYN_REGISTER_2() (REG32(ADR_SYN_REGISTER_2)) = (0x00550800)
#define DEF_SYN_PFD_CHP() (REG32(ADR_SYN_PFD_CHP)) = (0x07c0894a)
#define DEF_SYN_VCO_LOBF() (REG32(ADR_SYN_VCO_LOBF)) = (0xfcccca27)
#define DEF_SYN_DIV_SDM_XOSC() (REG32(ADR_SYN_DIV_SDM_XOSC)) = (0x07700830)
#define DEF_SYN_KVCO_XO_FINE_TUNE_CBANK() (REG32(ADR_SYN_KVCO_XO_FINE_TUNE_CBANK)) = (0x00440000)
#define DEF_SYN_LCK_VT() (REG32(ADR_SYN_LCK_VT)) = (0x00007ff4)
#define DEF_DPLL_VCO_REGISTER() (REG32(ADR_DPLL_VCO_REGISTER)) = (0x0000000e)
#define DEF_DPLL_CP_PFD_REGISTER() (REG32(ADR_DPLL_CP_PFD_REGISTER)) = (0x00088008)
#define DEF_DPLL_DIVIDER_REGISTER() (REG32(ADR_DPLL_DIVIDER_REGISTER)) = (0x00406000)
#define DEF_DCOC_IDAC_REGISTER1() (REG32(ADR_DCOC_IDAC_REGISTER1)) = (0x08820820)
#define DEF_DCOC_IDAC_REGISTER2() (REG32(ADR_DCOC_IDAC_REGISTER2)) = (0x00820820)
#define DEF_DCOC_IDAC_REGISTER3() (REG32(ADR_DCOC_IDAC_REGISTER3)) = (0x00820820)
#define DEF_DCOC_IDAC_REGISTER4() (REG32(ADR_DCOC_IDAC_REGISTER4)) = (0x00820820)
#define DEF_DCOC_IDAC_REGISTER5() (REG32(ADR_DCOC_IDAC_REGISTER5)) = (0x00820820)
#define DEF_DCOC_IDAC_REGISTER6() (REG32(ADR_DCOC_IDAC_REGISTER6)) = (0x00820820)
#define DEF_DCOC_IDAC_REGISTER7() (REG32(ADR_DCOC_IDAC_REGISTER7)) = (0x00820820)
#define DEF_DCOC_IDAC_REGISTER8() (REG32(ADR_DCOC_IDAC_REGISTER8)) = (0x00820820)
#define DEF_RCAL_REGISTER() (REG32(ADR_RCAL_REGISTER)) = (0x00004080)
#define DEF_SX_LCK_BIN_REGISTERS_I() (REG32(ADR_SX_LCK_BIN_REGISTERS_I)) = (0x20080080)
#define DEF_TRX_DUMMY_REGISTER() (REG32(ADR_TRX_DUMMY_REGISTER)) = (0xaaaaaaaa)
#define DEF_SX_DUMMY_REGISTER() (REG32(ADR_SX_DUMMY_REGISTER)) = (0xaaaaaaaa)
#define DEF_DPLL_FB_DIVIDER_REGISTERS_II() (REG32(ADR_DPLL_FB_DIVIDER_REGISTERS_II)) = (0x00ec2ec5)
#define DEF_SX_LCK_BIN_REGISTERS_II() (REG32(ADR_SX_LCK_BIN_REGISTERS_II)) = (0x00000f13)
#define DEF_RC_OSC_32K_CAL_REGISTERS() (REG32(ADR_RC_OSC_32K_CAL_REGISTERS)) = (0x00098900)
#define DEF_RF_D_DIGITAL_DEBUG_PORT_REGISTER() (REG32(ADR_RF_D_DIGITAL_DEBUG_PORT_REGISTER)) = (0x00000000)
#define DEF_MMU_CTRL() (REG32(ADR_MMU_CTRL)) = (0x00002042)
#define DEF_HS_CTRL() (REG32(ADR_HS_CTRL)) = (0x00000000)
#define DEF_CPU_POR0_7() (REG32(ADR_CPU_POR0_7)) = (0x00000000)
#define DEF_CPU_POR8_F() (REG32(ADR_CPU_POR8_F)) = (0x00000000)
#define DEF_REG_LEN_CTRL() (REG32(ADR_REG_LEN_CTRL)) = (0x00000f0f)
#define DEF_DMN_READ_BYPASS() (REG32(ADR_DMN_READ_BYPASS)) = (0x0000ffff)
#define DEF_ALC_RLS_ABORT() (REG32(ADR_ALC_RLS_ABORT)) = (0x00000000)
#define DEF_DEBUG_CTL() (REG32(ADR_DEBUG_CTL)) = (0x00000000)
#define DEF_DEBUG_OUT() (REG32(ADR_DEBUG_OUT)) = (0x00000000)
#define DEF_MMU_STATUS() (REG32(ADR_MMU_STATUS)) = (0x00000000)
#define DEF_DMN_STATUS() (REG32(ADR_DMN_STATUS)) = (0x00000000)
#define DEF_TAG_STATUS() (REG32(ADR_TAG_STATUS)) = (0x00000000)
#define DEF_DMN_MCU_STATUS() (REG32(ADR_DMN_MCU_STATUS)) = (0x00000000)
#define DEF_MB_IDTBL_0_STATUS() (REG32(ADR_MB_IDTBL_0_STATUS)) = (0x00000000)
#define DEF_MB_IDTBL_1_STATUS() (REG32(ADR_MB_IDTBL_1_STATUS)) = (0x00000000)
#define DEF_MB_IDTBL_2_STATUS() (REG32(ADR_MB_IDTBL_2_STATUS)) = (0x00000000)
#define DEF_MB_IDTBL_3_STATUS() (REG32(ADR_MB_IDTBL_3_STATUS)) = (0x00000000)
#define DEF_PKT_IDTBL_0_STATUS() (REG32(ADR_PKT_IDTBL_0_STATUS)) = (0x00000000)
#define DEF_PKT_IDTBL_1_STATUS() (REG32(ADR_PKT_IDTBL_1_STATUS)) = (0x00000000)
#define DEF_PKT_IDTBL_2_STATUS() (REG32(ADR_PKT_IDTBL_2_STATUS)) = (0x00000000)
#define DEF_PKT_IDTBL_3_STATUS() (REG32(ADR_PKT_IDTBL_3_STATUS)) = (0x00000000)
#define DEF_DMN_IDTBL_0_STATUS() (REG32(ADR_DMN_IDTBL_0_STATUS)) = (0x00000000)
#define DEF_DMN_IDTBL_1_STATUS() (REG32(ADR_DMN_IDTBL_1_STATUS)) = (0x00000000)
#define DEF_DMN_IDTBL_2_STATUS() (REG32(ADR_DMN_IDTBL_2_STATUS)) = (0x00000000)
#define DEF_DMN_IDTBL_3_STATUS() (REG32(ADR_DMN_IDTBL_3_STATUS)) = (0x00000000)
#define DEF_MB_NEQID_0_STATUS() (REG32(ADR_MB_NEQID_0_STATUS)) = (0x00000000)
#define DEF_MB_NEQID_1_STATUS() (REG32(ADR_MB_NEQID_1_STATUS)) = (0x00000000)
#define DEF_MB_NEQID_2_STATUS() (REG32(ADR_MB_NEQID_2_STATUS)) = (0x00000000)
#define DEF_MB_NEQID_3_STATUS() (REG32(ADR_MB_NEQID_3_STATUS)) = (0x00000000)
#define DEF_PKT_NEQID_0_STATUS() (REG32(ADR_PKT_NEQID_0_STATUS)) = (0x00000000)
#define DEF_PKT_NEQID_1_STATUS() (REG32(ADR_PKT_NEQID_1_STATUS)) = (0x00000000)
#define DEF_PKT_NEQID_2_STATUS() (REG32(ADR_PKT_NEQID_2_STATUS)) = (0x00000000)
#define DEF_PKT_NEQID_3_STATUS() (REG32(ADR_PKT_NEQID_3_STATUS)) = (0x00000000)
#define DEF_ALC_NOCHG_ID_STATUS() (REG32(ADR_ALC_NOCHG_ID_STATUS)) = (0x00000000)
#define DEF_TAG_SRAM0_F_STATUS_0() (REG32(ADR_TAG_SRAM0_F_STATUS_0)) = (0x00000000)
#define DEF_TAG_SRAM0_F_STATUS_1() (REG32(ADR_TAG_SRAM0_F_STATUS_1)) = (0x00000000)
#define DEF_TAG_SRAM0_F_STATUS_2() (REG32(ADR_TAG_SRAM0_F_STATUS_2)) = (0x00000000)
#define DEF_TAG_SRAM0_F_STATUS_3() (REG32(ADR_TAG_SRAM0_F_STATUS_3)) = (0x00000000)
#define DEF_TAG_SRAM0_F_STATUS_4() (REG32(ADR_TAG_SRAM0_F_STATUS_4)) = (0x00000000)
#define DEF_TAG_SRAM0_F_STATUS_5() (REG32(ADR_TAG_SRAM0_F_STATUS_5)) = (0x00000000)
#define DEF_TAG_SRAM0_F_STATUS_6() (REG32(ADR_TAG_SRAM0_F_STATUS_6)) = (0x00000000)
#define DEF_TAG_SRAM0_F_STATUS_7() (REG32(ADR_TAG_SRAM0_F_STATUS_7)) = (0x00000000)
