// Code generated by Wire. DO NOT EDIT.

//go:generate go run github.com/google/wire/cmd/wire
//go:build !wireinject
// +build !wireinject

package main

import (
	"github.com/GoYoko/web"
	"github.com/chaitin/MonkeyCode/backend/config"
	"github.com/chaitin/MonkeyCode/backend/internal/scanner/handler/http/v1"
	"github.com/chaitin/MonkeyCode/backend/pkg"
	"github.com/chaitin/MonkeyCode/backend/pkg/logger"
	"github.com/chaitin/MonkeyCode/backend/pkg/version"
	"log/slog"
)

// Injectors from wire.go:

func newServer() (*Server, error) {
	configConfig, err := config.Init()
	if err != nil {
		return nil, err
	}
	web := pkg.NewWeb(configConfig)
	loggerConfig := configConfig.Logger
	slogLogger := logger.NewLogger(loggerConfig)
	versionInfo := version.NewVersionInfo()
	scannerHandler := v1.NewScannerHandler(web, slogLogger)
	server := &Server{
		config:  configConfig,
		web:     web,
		logger:  slogLogger,
		version: versionInfo,
		scanner: scannerHandler,
	}
	return server, nil
}

// wire.go:

type Server struct {
	config  *config.Config
	web     *web.Web
	logger  *slog.Logger
	version *version.VersionInfo
	scanner *v1.ScannerHandler
}
