// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/google/uuid"
)

// Admin is the model entity for the Admin schema.
type Admin struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// Username holds the value of the "username" field.
	Username string `json:"username,omitempty"`
	// Password holds the value of the "password" field.
	Password string `json:"password,omitempty"`
	// Status holds the value of the "status" field.
	Status consts.AdminStatus `json:"status,omitempty"`
	// LastActiveAt holds the value of the "last_active_at" field.
	LastActiveAt time.Time `json:"last_active_at,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt time.Time `json:"updated_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the AdminQuery when eager-loading is set.
	Edges        AdminEdges `json:"edges"`
	selectValues sql.SelectValues
}

// AdminEdges holds the relations/edges for other nodes in the graph.
type AdminEdges struct {
	// LoginHistories holds the value of the login_histories edge.
	LoginHistories []*AdminLoginHistory `json:"login_histories,omitempty"`
	// Myusergroups holds the value of the myusergroups edge.
	Myusergroups []*UserGroup `json:"myusergroups,omitempty"`
	// Aiemployees holds the value of the aiemployees edge.
	Aiemployees []*AIEmployee `json:"aiemployees,omitempty"`
	// Usergroups holds the value of the usergroups edge.
	Usergroups []*UserGroup `json:"usergroups,omitempty"`
	// Roles holds the value of the roles edge.
	Roles []*Role `json:"roles,omitempty"`
	// UserGroupAdmins holds the value of the user_group_admins edge.
	UserGroupAdmins []*UserGroupAdmin `json:"user_group_admins,omitempty"`
	// AdminRoles holds the value of the admin_roles edge.
	AdminRoles []*AdminRole `json:"admin_roles,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [7]bool
}

// LoginHistoriesOrErr returns the LoginHistories value or an error if the edge
// was not loaded in eager-loading.
func (e AdminEdges) LoginHistoriesOrErr() ([]*AdminLoginHistory, error) {
	if e.loadedTypes[0] {
		return e.LoginHistories, nil
	}
	return nil, &NotLoadedError{edge: "login_histories"}
}

// MyusergroupsOrErr returns the Myusergroups value or an error if the edge
// was not loaded in eager-loading.
func (e AdminEdges) MyusergroupsOrErr() ([]*UserGroup, error) {
	if e.loadedTypes[1] {
		return e.Myusergroups, nil
	}
	return nil, &NotLoadedError{edge: "myusergroups"}
}

// AiemployeesOrErr returns the Aiemployees value or an error if the edge
// was not loaded in eager-loading.
func (e AdminEdges) AiemployeesOrErr() ([]*AIEmployee, error) {
	if e.loadedTypes[2] {
		return e.Aiemployees, nil
	}
	return nil, &NotLoadedError{edge: "aiemployees"}
}

// UsergroupsOrErr returns the Usergroups value or an error if the edge
// was not loaded in eager-loading.
func (e AdminEdges) UsergroupsOrErr() ([]*UserGroup, error) {
	if e.loadedTypes[3] {
		return e.Usergroups, nil
	}
	return nil, &NotLoadedError{edge: "usergroups"}
}

// RolesOrErr returns the Roles value or an error if the edge
// was not loaded in eager-loading.
func (e AdminEdges) RolesOrErr() ([]*Role, error) {
	if e.loadedTypes[4] {
		return e.Roles, nil
	}
	return nil, &NotLoadedError{edge: "roles"}
}

// UserGroupAdminsOrErr returns the UserGroupAdmins value or an error if the edge
// was not loaded in eager-loading.
func (e AdminEdges) UserGroupAdminsOrErr() ([]*UserGroupAdmin, error) {
	if e.loadedTypes[5] {
		return e.UserGroupAdmins, nil
	}
	return nil, &NotLoadedError{edge: "user_group_admins"}
}

// AdminRolesOrErr returns the AdminRoles value or an error if the edge
// was not loaded in eager-loading.
func (e AdminEdges) AdminRolesOrErr() ([]*AdminRole, error) {
	if e.loadedTypes[6] {
		return e.AdminRoles, nil
	}
	return nil, &NotLoadedError{edge: "admin_roles"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Admin) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case admin.FieldUsername, admin.FieldPassword, admin.FieldStatus:
			values[i] = new(sql.NullString)
		case admin.FieldLastActiveAt, admin.FieldCreatedAt, admin.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		case admin.FieldID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Admin fields.
func (a *Admin) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case admin.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				a.ID = *value
			}
		case admin.FieldUsername:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field username", values[i])
			} else if value.Valid {
				a.Username = value.String
			}
		case admin.FieldPassword:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field password", values[i])
			} else if value.Valid {
				a.Password = value.String
			}
		case admin.FieldStatus:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field status", values[i])
			} else if value.Valid {
				a.Status = consts.AdminStatus(value.String)
			}
		case admin.FieldLastActiveAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field last_active_at", values[i])
			} else if value.Valid {
				a.LastActiveAt = value.Time
			}
		case admin.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				a.CreatedAt = value.Time
			}
		case admin.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				a.UpdatedAt = value.Time
			}
		default:
			a.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the Admin.
// This includes values selected through modifiers, order, etc.
func (a *Admin) Value(name string) (ent.Value, error) {
	return a.selectValues.Get(name)
}

// QueryLoginHistories queries the "login_histories" edge of the Admin entity.
func (a *Admin) QueryLoginHistories() *AdminLoginHistoryQuery {
	return NewAdminClient(a.config).QueryLoginHistories(a)
}

// QueryMyusergroups queries the "myusergroups" edge of the Admin entity.
func (a *Admin) QueryMyusergroups() *UserGroupQuery {
	return NewAdminClient(a.config).QueryMyusergroups(a)
}

// QueryAiemployees queries the "aiemployees" edge of the Admin entity.
func (a *Admin) QueryAiemployees() *AIEmployeeQuery {
	return NewAdminClient(a.config).QueryAiemployees(a)
}

// QueryUsergroups queries the "usergroups" edge of the Admin entity.
func (a *Admin) QueryUsergroups() *UserGroupQuery {
	return NewAdminClient(a.config).QueryUsergroups(a)
}

// QueryRoles queries the "roles" edge of the Admin entity.
func (a *Admin) QueryRoles() *RoleQuery {
	return NewAdminClient(a.config).QueryRoles(a)
}

// QueryUserGroupAdmins queries the "user_group_admins" edge of the Admin entity.
func (a *Admin) QueryUserGroupAdmins() *UserGroupAdminQuery {
	return NewAdminClient(a.config).QueryUserGroupAdmins(a)
}

// QueryAdminRoles queries the "admin_roles" edge of the Admin entity.
func (a *Admin) QueryAdminRoles() *AdminRoleQuery {
	return NewAdminClient(a.config).QueryAdminRoles(a)
}

// Update returns a builder for updating this Admin.
// Note that you need to call Admin.Unwrap() before calling this method if this Admin
// was returned from a transaction, and the transaction was committed or rolled back.
func (a *Admin) Update() *AdminUpdateOne {
	return NewAdminClient(a.config).UpdateOne(a)
}

// Unwrap unwraps the Admin entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (a *Admin) Unwrap() *Admin {
	_tx, ok := a.config.driver.(*txDriver)
	if !ok {
		panic("db: Admin is not a transactional entity")
	}
	a.config.driver = _tx.drv
	return a
}

// String implements the fmt.Stringer.
func (a *Admin) String() string {
	var builder strings.Builder
	builder.WriteString("Admin(")
	builder.WriteString(fmt.Sprintf("id=%v, ", a.ID))
	builder.WriteString("username=")
	builder.WriteString(a.Username)
	builder.WriteString(", ")
	builder.WriteString("password=")
	builder.WriteString(a.Password)
	builder.WriteString(", ")
	builder.WriteString("status=")
	builder.WriteString(fmt.Sprintf("%v", a.Status))
	builder.WriteString(", ")
	builder.WriteString("last_active_at=")
	builder.WriteString(a.LastActiveAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(a.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(a.UpdatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// Admins is a parsable slice of Admin.
type Admins []*Admin
