// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/adminloginhistory"
	"github.com/chaitin/MonkeyCode/backend/db/adminrole"
	"github.com/chaitin/MonkeyCode/backend/db/aiemployee"
	"github.com/chaitin/MonkeyCode/backend/db/role"
	"github.com/chaitin/MonkeyCode/backend/db/usergroup"
	"github.com/chaitin/MonkeyCode/backend/db/usergroupadmin"
	"github.com/google/uuid"
)

// AdminCreate is the builder for creating a Admin entity.
type AdminCreate struct {
	config
	mutation *AdminMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetUsername sets the "username" field.
func (ac *AdminCreate) SetUsername(s string) *AdminCreate {
	ac.mutation.SetUsername(s)
	return ac
}

// SetPassword sets the "password" field.
func (ac *AdminCreate) SetPassword(s string) *AdminCreate {
	ac.mutation.SetPassword(s)
	return ac
}

// SetStatus sets the "status" field.
func (ac *AdminCreate) SetStatus(cs consts.AdminStatus) *AdminCreate {
	ac.mutation.SetStatus(cs)
	return ac
}

// SetLastActiveAt sets the "last_active_at" field.
func (ac *AdminCreate) SetLastActiveAt(t time.Time) *AdminCreate {
	ac.mutation.SetLastActiveAt(t)
	return ac
}

// SetNillableLastActiveAt sets the "last_active_at" field if the given value is not nil.
func (ac *AdminCreate) SetNillableLastActiveAt(t *time.Time) *AdminCreate {
	if t != nil {
		ac.SetLastActiveAt(*t)
	}
	return ac
}

// SetCreatedAt sets the "created_at" field.
func (ac *AdminCreate) SetCreatedAt(t time.Time) *AdminCreate {
	ac.mutation.SetCreatedAt(t)
	return ac
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (ac *AdminCreate) SetNillableCreatedAt(t *time.Time) *AdminCreate {
	if t != nil {
		ac.SetCreatedAt(*t)
	}
	return ac
}

// SetUpdatedAt sets the "updated_at" field.
func (ac *AdminCreate) SetUpdatedAt(t time.Time) *AdminCreate {
	ac.mutation.SetUpdatedAt(t)
	return ac
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (ac *AdminCreate) SetNillableUpdatedAt(t *time.Time) *AdminCreate {
	if t != nil {
		ac.SetUpdatedAt(*t)
	}
	return ac
}

// SetID sets the "id" field.
func (ac *AdminCreate) SetID(u uuid.UUID) *AdminCreate {
	ac.mutation.SetID(u)
	return ac
}

// AddLoginHistoryIDs adds the "login_histories" edge to the AdminLoginHistory entity by IDs.
func (ac *AdminCreate) AddLoginHistoryIDs(ids ...uuid.UUID) *AdminCreate {
	ac.mutation.AddLoginHistoryIDs(ids...)
	return ac
}

// AddLoginHistories adds the "login_histories" edges to the AdminLoginHistory entity.
func (ac *AdminCreate) AddLoginHistories(a ...*AdminLoginHistory) *AdminCreate {
	ids := make([]uuid.UUID, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return ac.AddLoginHistoryIDs(ids...)
}

// AddMyusergroupIDs adds the "myusergroups" edge to the UserGroup entity by IDs.
func (ac *AdminCreate) AddMyusergroupIDs(ids ...uuid.UUID) *AdminCreate {
	ac.mutation.AddMyusergroupIDs(ids...)
	return ac
}

// AddMyusergroups adds the "myusergroups" edges to the UserGroup entity.
func (ac *AdminCreate) AddMyusergroups(u ...*UserGroup) *AdminCreate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return ac.AddMyusergroupIDs(ids...)
}

// AddAiemployeeIDs adds the "aiemployees" edge to the AIEmployee entity by IDs.
func (ac *AdminCreate) AddAiemployeeIDs(ids ...uuid.UUID) *AdminCreate {
	ac.mutation.AddAiemployeeIDs(ids...)
	return ac
}

// AddAiemployees adds the "aiemployees" edges to the AIEmployee entity.
func (ac *AdminCreate) AddAiemployees(a ...*AIEmployee) *AdminCreate {
	ids := make([]uuid.UUID, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return ac.AddAiemployeeIDs(ids...)
}

// AddUsergroupIDs adds the "usergroups" edge to the UserGroup entity by IDs.
func (ac *AdminCreate) AddUsergroupIDs(ids ...uuid.UUID) *AdminCreate {
	ac.mutation.AddUsergroupIDs(ids...)
	return ac
}

// AddUsergroups adds the "usergroups" edges to the UserGroup entity.
func (ac *AdminCreate) AddUsergroups(u ...*UserGroup) *AdminCreate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return ac.AddUsergroupIDs(ids...)
}

// AddRoleIDs adds the "roles" edge to the Role entity by IDs.
func (ac *AdminCreate) AddRoleIDs(ids ...int64) *AdminCreate {
	ac.mutation.AddRoleIDs(ids...)
	return ac
}

// AddRoles adds the "roles" edges to the Role entity.
func (ac *AdminCreate) AddRoles(r ...*Role) *AdminCreate {
	ids := make([]int64, len(r))
	for i := range r {
		ids[i] = r[i].ID
	}
	return ac.AddRoleIDs(ids...)
}

// AddUserGroupAdminIDs adds the "user_group_admins" edge to the UserGroupAdmin entity by IDs.
func (ac *AdminCreate) AddUserGroupAdminIDs(ids ...uuid.UUID) *AdminCreate {
	ac.mutation.AddUserGroupAdminIDs(ids...)
	return ac
}

// AddUserGroupAdmins adds the "user_group_admins" edges to the UserGroupAdmin entity.
func (ac *AdminCreate) AddUserGroupAdmins(u ...*UserGroupAdmin) *AdminCreate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return ac.AddUserGroupAdminIDs(ids...)
}

// AddAdminRoleIDs adds the "admin_roles" edge to the AdminRole entity by IDs.
func (ac *AdminCreate) AddAdminRoleIDs(ids ...uuid.UUID) *AdminCreate {
	ac.mutation.AddAdminRoleIDs(ids...)
	return ac
}

// AddAdminRoles adds the "admin_roles" edges to the AdminRole entity.
func (ac *AdminCreate) AddAdminRoles(a ...*AdminRole) *AdminCreate {
	ids := make([]uuid.UUID, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return ac.AddAdminRoleIDs(ids...)
}

// Mutation returns the AdminMutation object of the builder.
func (ac *AdminCreate) Mutation() *AdminMutation {
	return ac.mutation
}

// Save creates the Admin in the database.
func (ac *AdminCreate) Save(ctx context.Context) (*Admin, error) {
	ac.defaults()
	return withHooks(ctx, ac.sqlSave, ac.mutation, ac.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (ac *AdminCreate) SaveX(ctx context.Context) *Admin {
	v, err := ac.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (ac *AdminCreate) Exec(ctx context.Context) error {
	_, err := ac.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ac *AdminCreate) ExecX(ctx context.Context) {
	if err := ac.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (ac *AdminCreate) defaults() {
	if _, ok := ac.mutation.LastActiveAt(); !ok {
		v := admin.DefaultLastActiveAt()
		ac.mutation.SetLastActiveAt(v)
	}
	if _, ok := ac.mutation.CreatedAt(); !ok {
		v := admin.DefaultCreatedAt()
		ac.mutation.SetCreatedAt(v)
	}
	if _, ok := ac.mutation.UpdatedAt(); !ok {
		v := admin.DefaultUpdatedAt()
		ac.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ac *AdminCreate) check() error {
	if _, ok := ac.mutation.Username(); !ok {
		return &ValidationError{Name: "username", err: errors.New(`db: missing required field "Admin.username"`)}
	}
	if _, ok := ac.mutation.Password(); !ok {
		return &ValidationError{Name: "password", err: errors.New(`db: missing required field "Admin.password"`)}
	}
	if _, ok := ac.mutation.Status(); !ok {
		return &ValidationError{Name: "status", err: errors.New(`db: missing required field "Admin.status"`)}
	}
	if _, ok := ac.mutation.LastActiveAt(); !ok {
		return &ValidationError{Name: "last_active_at", err: errors.New(`db: missing required field "Admin.last_active_at"`)}
	}
	if _, ok := ac.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "Admin.created_at"`)}
	}
	if _, ok := ac.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`db: missing required field "Admin.updated_at"`)}
	}
	return nil
}

func (ac *AdminCreate) sqlSave(ctx context.Context) (*Admin, error) {
	if err := ac.check(); err != nil {
		return nil, err
	}
	_node, _spec := ac.createSpec()
	if err := sqlgraph.CreateNode(ctx, ac.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	ac.mutation.id = &_node.ID
	ac.mutation.done = true
	return _node, nil
}

func (ac *AdminCreate) createSpec() (*Admin, *sqlgraph.CreateSpec) {
	var (
		_node = &Admin{config: ac.config}
		_spec = sqlgraph.NewCreateSpec(admin.Table, sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = ac.conflict
	if id, ok := ac.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := ac.mutation.Username(); ok {
		_spec.SetField(admin.FieldUsername, field.TypeString, value)
		_node.Username = value
	}
	if value, ok := ac.mutation.Password(); ok {
		_spec.SetField(admin.FieldPassword, field.TypeString, value)
		_node.Password = value
	}
	if value, ok := ac.mutation.Status(); ok {
		_spec.SetField(admin.FieldStatus, field.TypeString, value)
		_node.Status = value
	}
	if value, ok := ac.mutation.LastActiveAt(); ok {
		_spec.SetField(admin.FieldLastActiveAt, field.TypeTime, value)
		_node.LastActiveAt = value
	}
	if value, ok := ac.mutation.CreatedAt(); ok {
		_spec.SetField(admin.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := ac.mutation.UpdatedAt(); ok {
		_spec.SetField(admin.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	if nodes := ac.mutation.LoginHistoriesIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   admin.LoginHistoriesTable,
			Columns: []string{admin.LoginHistoriesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(adminloginhistory.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := ac.mutation.MyusergroupsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   admin.MyusergroupsTable,
			Columns: []string{admin.MyusergroupsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroup.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := ac.mutation.AiemployeesIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   admin.AiemployeesTable,
			Columns: []string{admin.AiemployeesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(aiemployee.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := ac.mutation.UsergroupsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   admin.UsergroupsTable,
			Columns: admin.UsergroupsPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroup.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := ac.mutation.RolesIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   admin.RolesTable,
			Columns: admin.RolesPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(role.FieldID, field.TypeInt64),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := ac.mutation.UserGroupAdminsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   admin.UserGroupAdminsTable,
			Columns: []string{admin.UserGroupAdminsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(usergroupadmin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := ac.mutation.AdminRolesIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   admin.AdminRolesTable,
			Columns: []string{admin.AdminRolesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(adminrole.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Admin.Create().
//		SetUsername(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.AdminUpsert) {
//			SetUsername(v+v).
//		}).
//		Exec(ctx)
func (ac *AdminCreate) OnConflict(opts ...sql.ConflictOption) *AdminUpsertOne {
	ac.conflict = opts
	return &AdminUpsertOne{
		create: ac,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Admin.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (ac *AdminCreate) OnConflictColumns(columns ...string) *AdminUpsertOne {
	ac.conflict = append(ac.conflict, sql.ConflictColumns(columns...))
	return &AdminUpsertOne{
		create: ac,
	}
}

type (
	// AdminUpsertOne is the builder for "upsert"-ing
	//  one Admin node.
	AdminUpsertOne struct {
		create *AdminCreate
	}

	// AdminUpsert is the "OnConflict" setter.
	AdminUpsert struct {
		*sql.UpdateSet
	}
)

// SetUsername sets the "username" field.
func (u *AdminUpsert) SetUsername(v string) *AdminUpsert {
	u.Set(admin.FieldUsername, v)
	return u
}

// UpdateUsername sets the "username" field to the value that was provided on create.
func (u *AdminUpsert) UpdateUsername() *AdminUpsert {
	u.SetExcluded(admin.FieldUsername)
	return u
}

// SetPassword sets the "password" field.
func (u *AdminUpsert) SetPassword(v string) *AdminUpsert {
	u.Set(admin.FieldPassword, v)
	return u
}

// UpdatePassword sets the "password" field to the value that was provided on create.
func (u *AdminUpsert) UpdatePassword() *AdminUpsert {
	u.SetExcluded(admin.FieldPassword)
	return u
}

// SetStatus sets the "status" field.
func (u *AdminUpsert) SetStatus(v consts.AdminStatus) *AdminUpsert {
	u.Set(admin.FieldStatus, v)
	return u
}

// UpdateStatus sets the "status" field to the value that was provided on create.
func (u *AdminUpsert) UpdateStatus() *AdminUpsert {
	u.SetExcluded(admin.FieldStatus)
	return u
}

// SetLastActiveAt sets the "last_active_at" field.
func (u *AdminUpsert) SetLastActiveAt(v time.Time) *AdminUpsert {
	u.Set(admin.FieldLastActiveAt, v)
	return u
}

// UpdateLastActiveAt sets the "last_active_at" field to the value that was provided on create.
func (u *AdminUpsert) UpdateLastActiveAt() *AdminUpsert {
	u.SetExcluded(admin.FieldLastActiveAt)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *AdminUpsert) SetCreatedAt(v time.Time) *AdminUpsert {
	u.Set(admin.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *AdminUpsert) UpdateCreatedAt() *AdminUpsert {
	u.SetExcluded(admin.FieldCreatedAt)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *AdminUpsert) SetUpdatedAt(v time.Time) *AdminUpsert {
	u.Set(admin.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *AdminUpsert) UpdateUpdatedAt() *AdminUpsert {
	u.SetExcluded(admin.FieldUpdatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.Admin.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(admin.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *AdminUpsertOne) UpdateNewValues() *AdminUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(admin.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Admin.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *AdminUpsertOne) Ignore() *AdminUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *AdminUpsertOne) DoNothing() *AdminUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the AdminCreate.OnConflict
// documentation for more info.
func (u *AdminUpsertOne) Update(set func(*AdminUpsert)) *AdminUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&AdminUpsert{UpdateSet: update})
	}))
	return u
}

// SetUsername sets the "username" field.
func (u *AdminUpsertOne) SetUsername(v string) *AdminUpsertOne {
	return u.Update(func(s *AdminUpsert) {
		s.SetUsername(v)
	})
}

// UpdateUsername sets the "username" field to the value that was provided on create.
func (u *AdminUpsertOne) UpdateUsername() *AdminUpsertOne {
	return u.Update(func(s *AdminUpsert) {
		s.UpdateUsername()
	})
}

// SetPassword sets the "password" field.
func (u *AdminUpsertOne) SetPassword(v string) *AdminUpsertOne {
	return u.Update(func(s *AdminUpsert) {
		s.SetPassword(v)
	})
}

// UpdatePassword sets the "password" field to the value that was provided on create.
func (u *AdminUpsertOne) UpdatePassword() *AdminUpsertOne {
	return u.Update(func(s *AdminUpsert) {
		s.UpdatePassword()
	})
}

// SetStatus sets the "status" field.
func (u *AdminUpsertOne) SetStatus(v consts.AdminStatus) *AdminUpsertOne {
	return u.Update(func(s *AdminUpsert) {
		s.SetStatus(v)
	})
}

// UpdateStatus sets the "status" field to the value that was provided on create.
func (u *AdminUpsertOne) UpdateStatus() *AdminUpsertOne {
	return u.Update(func(s *AdminUpsert) {
		s.UpdateStatus()
	})
}

// SetLastActiveAt sets the "last_active_at" field.
func (u *AdminUpsertOne) SetLastActiveAt(v time.Time) *AdminUpsertOne {
	return u.Update(func(s *AdminUpsert) {
		s.SetLastActiveAt(v)
	})
}

// UpdateLastActiveAt sets the "last_active_at" field to the value that was provided on create.
func (u *AdminUpsertOne) UpdateLastActiveAt() *AdminUpsertOne {
	return u.Update(func(s *AdminUpsert) {
		s.UpdateLastActiveAt()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *AdminUpsertOne) SetCreatedAt(v time.Time) *AdminUpsertOne {
	return u.Update(func(s *AdminUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *AdminUpsertOne) UpdateCreatedAt() *AdminUpsertOne {
	return u.Update(func(s *AdminUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *AdminUpsertOne) SetUpdatedAt(v time.Time) *AdminUpsertOne {
	return u.Update(func(s *AdminUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *AdminUpsertOne) UpdateUpdatedAt() *AdminUpsertOne {
	return u.Update(func(s *AdminUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *AdminUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for AdminCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *AdminUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *AdminUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: AdminUpsertOne.ID is not supported by MySQL driver. Use AdminUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *AdminUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// AdminCreateBulk is the builder for creating many Admin entities in bulk.
type AdminCreateBulk struct {
	config
	err      error
	builders []*AdminCreate
	conflict []sql.ConflictOption
}

// Save creates the Admin entities in the database.
func (acb *AdminCreateBulk) Save(ctx context.Context) ([]*Admin, error) {
	if acb.err != nil {
		return nil, acb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(acb.builders))
	nodes := make([]*Admin, len(acb.builders))
	mutators := make([]Mutator, len(acb.builders))
	for i := range acb.builders {
		func(i int, root context.Context) {
			builder := acb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*AdminMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, acb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = acb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, acb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, acb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (acb *AdminCreateBulk) SaveX(ctx context.Context) []*Admin {
	v, err := acb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (acb *AdminCreateBulk) Exec(ctx context.Context) error {
	_, err := acb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (acb *AdminCreateBulk) ExecX(ctx context.Context) {
	if err := acb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Admin.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.AdminUpsert) {
//			SetUsername(v+v).
//		}).
//		Exec(ctx)
func (acb *AdminCreateBulk) OnConflict(opts ...sql.ConflictOption) *AdminUpsertBulk {
	acb.conflict = opts
	return &AdminUpsertBulk{
		create: acb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Admin.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (acb *AdminCreateBulk) OnConflictColumns(columns ...string) *AdminUpsertBulk {
	acb.conflict = append(acb.conflict, sql.ConflictColumns(columns...))
	return &AdminUpsertBulk{
		create: acb,
	}
}

// AdminUpsertBulk is the builder for "upsert"-ing
// a bulk of Admin nodes.
type AdminUpsertBulk struct {
	create *AdminCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.Admin.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(admin.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *AdminUpsertBulk) UpdateNewValues() *AdminUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(admin.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Admin.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *AdminUpsertBulk) Ignore() *AdminUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *AdminUpsertBulk) DoNothing() *AdminUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the AdminCreateBulk.OnConflict
// documentation for more info.
func (u *AdminUpsertBulk) Update(set func(*AdminUpsert)) *AdminUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&AdminUpsert{UpdateSet: update})
	}))
	return u
}

// SetUsername sets the "username" field.
func (u *AdminUpsertBulk) SetUsername(v string) *AdminUpsertBulk {
	return u.Update(func(s *AdminUpsert) {
		s.SetUsername(v)
	})
}

// UpdateUsername sets the "username" field to the value that was provided on create.
func (u *AdminUpsertBulk) UpdateUsername() *AdminUpsertBulk {
	return u.Update(func(s *AdminUpsert) {
		s.UpdateUsername()
	})
}

// SetPassword sets the "password" field.
func (u *AdminUpsertBulk) SetPassword(v string) *AdminUpsertBulk {
	return u.Update(func(s *AdminUpsert) {
		s.SetPassword(v)
	})
}

// UpdatePassword sets the "password" field to the value that was provided on create.
func (u *AdminUpsertBulk) UpdatePassword() *AdminUpsertBulk {
	return u.Update(func(s *AdminUpsert) {
		s.UpdatePassword()
	})
}

// SetStatus sets the "status" field.
func (u *AdminUpsertBulk) SetStatus(v consts.AdminStatus) *AdminUpsertBulk {
	return u.Update(func(s *AdminUpsert) {
		s.SetStatus(v)
	})
}

// UpdateStatus sets the "status" field to the value that was provided on create.
func (u *AdminUpsertBulk) UpdateStatus() *AdminUpsertBulk {
	return u.Update(func(s *AdminUpsert) {
		s.UpdateStatus()
	})
}

// SetLastActiveAt sets the "last_active_at" field.
func (u *AdminUpsertBulk) SetLastActiveAt(v time.Time) *AdminUpsertBulk {
	return u.Update(func(s *AdminUpsert) {
		s.SetLastActiveAt(v)
	})
}

// UpdateLastActiveAt sets the "last_active_at" field to the value that was provided on create.
func (u *AdminUpsertBulk) UpdateLastActiveAt() *AdminUpsertBulk {
	return u.Update(func(s *AdminUpsert) {
		s.UpdateLastActiveAt()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *AdminUpsertBulk) SetCreatedAt(v time.Time) *AdminUpsertBulk {
	return u.Update(func(s *AdminUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *AdminUpsertBulk) UpdateCreatedAt() *AdminUpsertBulk {
	return u.Update(func(s *AdminUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *AdminUpsertBulk) SetUpdatedAt(v time.Time) *AdminUpsertBulk {
	return u.Update(func(s *AdminUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *AdminUpsertBulk) UpdateUpdatedAt() *AdminUpsertBulk {
	return u.Update(func(s *AdminUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *AdminUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the AdminCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for AdminCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *AdminUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
