// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/adminloginhistory"
	"github.com/google/uuid"
)

// AdminLoginHistory is the model entity for the AdminLoginHistory schema.
type AdminLoginHistory struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// AdminID holds the value of the "admin_id" field.
	AdminID uuid.UUID `json:"admin_id,omitempty"`
	// IP holds the value of the "ip" field.
	IP string `json:"ip,omitempty"`
	// Country holds the value of the "country" field.
	Country string `json:"country,omitempty"`
	// Province holds the value of the "province" field.
	Province string `json:"province,omitempty"`
	// City holds the value of the "city" field.
	City string `json:"city,omitempty"`
	// Isp holds the value of the "isp" field.
	Isp string `json:"isp,omitempty"`
	// Asn holds the value of the "asn" field.
	Asn string `json:"asn,omitempty"`
	// ClientVersion holds the value of the "client_version" field.
	ClientVersion string `json:"client_version,omitempty"`
	// Device holds the value of the "device" field.
	Device string `json:"device,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the AdminLoginHistoryQuery when eager-loading is set.
	Edges        AdminLoginHistoryEdges `json:"edges"`
	selectValues sql.SelectValues
}

// AdminLoginHistoryEdges holds the relations/edges for other nodes in the graph.
type AdminLoginHistoryEdges struct {
	// Owner holds the value of the owner edge.
	Owner *Admin `json:"owner,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [1]bool
}

// OwnerOrErr returns the Owner value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e AdminLoginHistoryEdges) OwnerOrErr() (*Admin, error) {
	if e.Owner != nil {
		return e.Owner, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: admin.Label}
	}
	return nil, &NotLoadedError{edge: "owner"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*AdminLoginHistory) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case adminloginhistory.FieldIP, adminloginhistory.FieldCountry, adminloginhistory.FieldProvince, adminloginhistory.FieldCity, adminloginhistory.FieldIsp, adminloginhistory.FieldAsn, adminloginhistory.FieldClientVersion, adminloginhistory.FieldDevice:
			values[i] = new(sql.NullString)
		case adminloginhistory.FieldCreatedAt:
			values[i] = new(sql.NullTime)
		case adminloginhistory.FieldID, adminloginhistory.FieldAdminID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the AdminLoginHistory fields.
func (alh *AdminLoginHistory) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case adminloginhistory.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				alh.ID = *value
			}
		case adminloginhistory.FieldAdminID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field admin_id", values[i])
			} else if value != nil {
				alh.AdminID = *value
			}
		case adminloginhistory.FieldIP:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field ip", values[i])
			} else if value.Valid {
				alh.IP = value.String
			}
		case adminloginhistory.FieldCountry:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field country", values[i])
			} else if value.Valid {
				alh.Country = value.String
			}
		case adminloginhistory.FieldProvince:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field province", values[i])
			} else if value.Valid {
				alh.Province = value.String
			}
		case adminloginhistory.FieldCity:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field city", values[i])
			} else if value.Valid {
				alh.City = value.String
			}
		case adminloginhistory.FieldIsp:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field isp", values[i])
			} else if value.Valid {
				alh.Isp = value.String
			}
		case adminloginhistory.FieldAsn:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field asn", values[i])
			} else if value.Valid {
				alh.Asn = value.String
			}
		case adminloginhistory.FieldClientVersion:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field client_version", values[i])
			} else if value.Valid {
				alh.ClientVersion = value.String
			}
		case adminloginhistory.FieldDevice:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field device", values[i])
			} else if value.Valid {
				alh.Device = value.String
			}
		case adminloginhistory.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				alh.CreatedAt = value.Time
			}
		default:
			alh.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the AdminLoginHistory.
// This includes values selected through modifiers, order, etc.
func (alh *AdminLoginHistory) Value(name string) (ent.Value, error) {
	return alh.selectValues.Get(name)
}

// QueryOwner queries the "owner" edge of the AdminLoginHistory entity.
func (alh *AdminLoginHistory) QueryOwner() *AdminQuery {
	return NewAdminLoginHistoryClient(alh.config).QueryOwner(alh)
}

// Update returns a builder for updating this AdminLoginHistory.
// Note that you need to call AdminLoginHistory.Unwrap() before calling this method if this AdminLoginHistory
// was returned from a transaction, and the transaction was committed or rolled back.
func (alh *AdminLoginHistory) Update() *AdminLoginHistoryUpdateOne {
	return NewAdminLoginHistoryClient(alh.config).UpdateOne(alh)
}

// Unwrap unwraps the AdminLoginHistory entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (alh *AdminLoginHistory) Unwrap() *AdminLoginHistory {
	_tx, ok := alh.config.driver.(*txDriver)
	if !ok {
		panic("db: AdminLoginHistory is not a transactional entity")
	}
	alh.config.driver = _tx.drv
	return alh
}

// String implements the fmt.Stringer.
func (alh *AdminLoginHistory) String() string {
	var builder strings.Builder
	builder.WriteString("AdminLoginHistory(")
	builder.WriteString(fmt.Sprintf("id=%v, ", alh.ID))
	builder.WriteString("admin_id=")
	builder.WriteString(fmt.Sprintf("%v", alh.AdminID))
	builder.WriteString(", ")
	builder.WriteString("ip=")
	builder.WriteString(alh.IP)
	builder.WriteString(", ")
	builder.WriteString("country=")
	builder.WriteString(alh.Country)
	builder.WriteString(", ")
	builder.WriteString("province=")
	builder.WriteString(alh.Province)
	builder.WriteString(", ")
	builder.WriteString("city=")
	builder.WriteString(alh.City)
	builder.WriteString(", ")
	builder.WriteString("isp=")
	builder.WriteString(alh.Isp)
	builder.WriteString(", ")
	builder.WriteString("asn=")
	builder.WriteString(alh.Asn)
	builder.WriteString(", ")
	builder.WriteString("client_version=")
	builder.WriteString(alh.ClientVersion)
	builder.WriteString(", ")
	builder.WriteString("device=")
	builder.WriteString(alh.Device)
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(alh.CreatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// AdminLoginHistories is a parsable slice of AdminLoginHistory.
type AdminLoginHistories []*AdminLoginHistory
