// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/adminloginhistory"
	"github.com/google/uuid"
)

// AdminLoginHistoryCreate is the builder for creating a AdminLoginHistory entity.
type AdminLoginHistoryCreate struct {
	config
	mutation *AdminLoginHistoryMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetAdminID sets the "admin_id" field.
func (alhc *AdminLoginHistoryCreate) SetAdminID(u uuid.UUID) *AdminLoginHistoryCreate {
	alhc.mutation.SetAdminID(u)
	return alhc
}

// SetNillableAdminID sets the "admin_id" field if the given value is not nil.
func (alhc *AdminLoginHistoryCreate) SetNillableAdminID(u *uuid.UUID) *AdminLoginHistoryCreate {
	if u != nil {
		alhc.SetAdminID(*u)
	}
	return alhc
}

// SetIP sets the "ip" field.
func (alhc *AdminLoginHistoryCreate) SetIP(s string) *AdminLoginHistoryCreate {
	alhc.mutation.SetIP(s)
	return alhc
}

// SetCountry sets the "country" field.
func (alhc *AdminLoginHistoryCreate) SetCountry(s string) *AdminLoginHistoryCreate {
	alhc.mutation.SetCountry(s)
	return alhc
}

// SetProvince sets the "province" field.
func (alhc *AdminLoginHistoryCreate) SetProvince(s string) *AdminLoginHistoryCreate {
	alhc.mutation.SetProvince(s)
	return alhc
}

// SetCity sets the "city" field.
func (alhc *AdminLoginHistoryCreate) SetCity(s string) *AdminLoginHistoryCreate {
	alhc.mutation.SetCity(s)
	return alhc
}

// SetIsp sets the "isp" field.
func (alhc *AdminLoginHistoryCreate) SetIsp(s string) *AdminLoginHistoryCreate {
	alhc.mutation.SetIsp(s)
	return alhc
}

// SetNillableIsp sets the "isp" field if the given value is not nil.
func (alhc *AdminLoginHistoryCreate) SetNillableIsp(s *string) *AdminLoginHistoryCreate {
	if s != nil {
		alhc.SetIsp(*s)
	}
	return alhc
}

// SetAsn sets the "asn" field.
func (alhc *AdminLoginHistoryCreate) SetAsn(s string) *AdminLoginHistoryCreate {
	alhc.mutation.SetAsn(s)
	return alhc
}

// SetNillableAsn sets the "asn" field if the given value is not nil.
func (alhc *AdminLoginHistoryCreate) SetNillableAsn(s *string) *AdminLoginHistoryCreate {
	if s != nil {
		alhc.SetAsn(*s)
	}
	return alhc
}

// SetClientVersion sets the "client_version" field.
func (alhc *AdminLoginHistoryCreate) SetClientVersion(s string) *AdminLoginHistoryCreate {
	alhc.mutation.SetClientVersion(s)
	return alhc
}

// SetNillableClientVersion sets the "client_version" field if the given value is not nil.
func (alhc *AdminLoginHistoryCreate) SetNillableClientVersion(s *string) *AdminLoginHistoryCreate {
	if s != nil {
		alhc.SetClientVersion(*s)
	}
	return alhc
}

// SetDevice sets the "device" field.
func (alhc *AdminLoginHistoryCreate) SetDevice(s string) *AdminLoginHistoryCreate {
	alhc.mutation.SetDevice(s)
	return alhc
}

// SetNillableDevice sets the "device" field if the given value is not nil.
func (alhc *AdminLoginHistoryCreate) SetNillableDevice(s *string) *AdminLoginHistoryCreate {
	if s != nil {
		alhc.SetDevice(*s)
	}
	return alhc
}

// SetCreatedAt sets the "created_at" field.
func (alhc *AdminLoginHistoryCreate) SetCreatedAt(t time.Time) *AdminLoginHistoryCreate {
	alhc.mutation.SetCreatedAt(t)
	return alhc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (alhc *AdminLoginHistoryCreate) SetNillableCreatedAt(t *time.Time) *AdminLoginHistoryCreate {
	if t != nil {
		alhc.SetCreatedAt(*t)
	}
	return alhc
}

// SetID sets the "id" field.
func (alhc *AdminLoginHistoryCreate) SetID(u uuid.UUID) *AdminLoginHistoryCreate {
	alhc.mutation.SetID(u)
	return alhc
}

// SetOwnerID sets the "owner" edge to the Admin entity by ID.
func (alhc *AdminLoginHistoryCreate) SetOwnerID(id uuid.UUID) *AdminLoginHistoryCreate {
	alhc.mutation.SetOwnerID(id)
	return alhc
}

// SetNillableOwnerID sets the "owner" edge to the Admin entity by ID if the given value is not nil.
func (alhc *AdminLoginHistoryCreate) SetNillableOwnerID(id *uuid.UUID) *AdminLoginHistoryCreate {
	if id != nil {
		alhc = alhc.SetOwnerID(*id)
	}
	return alhc
}

// SetOwner sets the "owner" edge to the Admin entity.
func (alhc *AdminLoginHistoryCreate) SetOwner(a *Admin) *AdminLoginHistoryCreate {
	return alhc.SetOwnerID(a.ID)
}

// Mutation returns the AdminLoginHistoryMutation object of the builder.
func (alhc *AdminLoginHistoryCreate) Mutation() *AdminLoginHistoryMutation {
	return alhc.mutation
}

// Save creates the AdminLoginHistory in the database.
func (alhc *AdminLoginHistoryCreate) Save(ctx context.Context) (*AdminLoginHistory, error) {
	alhc.defaults()
	return withHooks(ctx, alhc.sqlSave, alhc.mutation, alhc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (alhc *AdminLoginHistoryCreate) SaveX(ctx context.Context) *AdminLoginHistory {
	v, err := alhc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (alhc *AdminLoginHistoryCreate) Exec(ctx context.Context) error {
	_, err := alhc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (alhc *AdminLoginHistoryCreate) ExecX(ctx context.Context) {
	if err := alhc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (alhc *AdminLoginHistoryCreate) defaults() {
	if _, ok := alhc.mutation.CreatedAt(); !ok {
		v := adminloginhistory.DefaultCreatedAt()
		alhc.mutation.SetCreatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (alhc *AdminLoginHistoryCreate) check() error {
	if _, ok := alhc.mutation.IP(); !ok {
		return &ValidationError{Name: "ip", err: errors.New(`db: missing required field "AdminLoginHistory.ip"`)}
	}
	if _, ok := alhc.mutation.Country(); !ok {
		return &ValidationError{Name: "country", err: errors.New(`db: missing required field "AdminLoginHistory.country"`)}
	}
	if _, ok := alhc.mutation.Province(); !ok {
		return &ValidationError{Name: "province", err: errors.New(`db: missing required field "AdminLoginHistory.province"`)}
	}
	if _, ok := alhc.mutation.City(); !ok {
		return &ValidationError{Name: "city", err: errors.New(`db: missing required field "AdminLoginHistory.city"`)}
	}
	if _, ok := alhc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "AdminLoginHistory.created_at"`)}
	}
	return nil
}

func (alhc *AdminLoginHistoryCreate) sqlSave(ctx context.Context) (*AdminLoginHistory, error) {
	if err := alhc.check(); err != nil {
		return nil, err
	}
	_node, _spec := alhc.createSpec()
	if err := sqlgraph.CreateNode(ctx, alhc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	alhc.mutation.id = &_node.ID
	alhc.mutation.done = true
	return _node, nil
}

func (alhc *AdminLoginHistoryCreate) createSpec() (*AdminLoginHistory, *sqlgraph.CreateSpec) {
	var (
		_node = &AdminLoginHistory{config: alhc.config}
		_spec = sqlgraph.NewCreateSpec(adminloginhistory.Table, sqlgraph.NewFieldSpec(adminloginhistory.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = alhc.conflict
	if id, ok := alhc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := alhc.mutation.IP(); ok {
		_spec.SetField(adminloginhistory.FieldIP, field.TypeString, value)
		_node.IP = value
	}
	if value, ok := alhc.mutation.Country(); ok {
		_spec.SetField(adminloginhistory.FieldCountry, field.TypeString, value)
		_node.Country = value
	}
	if value, ok := alhc.mutation.Province(); ok {
		_spec.SetField(adminloginhistory.FieldProvince, field.TypeString, value)
		_node.Province = value
	}
	if value, ok := alhc.mutation.City(); ok {
		_spec.SetField(adminloginhistory.FieldCity, field.TypeString, value)
		_node.City = value
	}
	if value, ok := alhc.mutation.Isp(); ok {
		_spec.SetField(adminloginhistory.FieldIsp, field.TypeString, value)
		_node.Isp = value
	}
	if value, ok := alhc.mutation.Asn(); ok {
		_spec.SetField(adminloginhistory.FieldAsn, field.TypeString, value)
		_node.Asn = value
	}
	if value, ok := alhc.mutation.ClientVersion(); ok {
		_spec.SetField(adminloginhistory.FieldClientVersion, field.TypeString, value)
		_node.ClientVersion = value
	}
	if value, ok := alhc.mutation.Device(); ok {
		_spec.SetField(adminloginhistory.FieldDevice, field.TypeString, value)
		_node.Device = value
	}
	if value, ok := alhc.mutation.CreatedAt(); ok {
		_spec.SetField(adminloginhistory.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if nodes := alhc.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   adminloginhistory.OwnerTable,
			Columns: []string{adminloginhistory.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.AdminID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.AdminLoginHistory.Create().
//		SetAdminID(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.AdminLoginHistoryUpsert) {
//			SetAdminID(v+v).
//		}).
//		Exec(ctx)
func (alhc *AdminLoginHistoryCreate) OnConflict(opts ...sql.ConflictOption) *AdminLoginHistoryUpsertOne {
	alhc.conflict = opts
	return &AdminLoginHistoryUpsertOne{
		create: alhc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.AdminLoginHistory.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (alhc *AdminLoginHistoryCreate) OnConflictColumns(columns ...string) *AdminLoginHistoryUpsertOne {
	alhc.conflict = append(alhc.conflict, sql.ConflictColumns(columns...))
	return &AdminLoginHistoryUpsertOne{
		create: alhc,
	}
}

type (
	// AdminLoginHistoryUpsertOne is the builder for "upsert"-ing
	//  one AdminLoginHistory node.
	AdminLoginHistoryUpsertOne struct {
		create *AdminLoginHistoryCreate
	}

	// AdminLoginHistoryUpsert is the "OnConflict" setter.
	AdminLoginHistoryUpsert struct {
		*sql.UpdateSet
	}
)

// SetAdminID sets the "admin_id" field.
func (u *AdminLoginHistoryUpsert) SetAdminID(v uuid.UUID) *AdminLoginHistoryUpsert {
	u.Set(adminloginhistory.FieldAdminID, v)
	return u
}

// UpdateAdminID sets the "admin_id" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsert) UpdateAdminID() *AdminLoginHistoryUpsert {
	u.SetExcluded(adminloginhistory.FieldAdminID)
	return u
}

// ClearAdminID clears the value of the "admin_id" field.
func (u *AdminLoginHistoryUpsert) ClearAdminID() *AdminLoginHistoryUpsert {
	u.SetNull(adminloginhistory.FieldAdminID)
	return u
}

// SetIP sets the "ip" field.
func (u *AdminLoginHistoryUpsert) SetIP(v string) *AdminLoginHistoryUpsert {
	u.Set(adminloginhistory.FieldIP, v)
	return u
}

// UpdateIP sets the "ip" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsert) UpdateIP() *AdminLoginHistoryUpsert {
	u.SetExcluded(adminloginhistory.FieldIP)
	return u
}

// SetCountry sets the "country" field.
func (u *AdminLoginHistoryUpsert) SetCountry(v string) *AdminLoginHistoryUpsert {
	u.Set(adminloginhistory.FieldCountry, v)
	return u
}

// UpdateCountry sets the "country" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsert) UpdateCountry() *AdminLoginHistoryUpsert {
	u.SetExcluded(adminloginhistory.FieldCountry)
	return u
}

// SetProvince sets the "province" field.
func (u *AdminLoginHistoryUpsert) SetProvince(v string) *AdminLoginHistoryUpsert {
	u.Set(adminloginhistory.FieldProvince, v)
	return u
}

// UpdateProvince sets the "province" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsert) UpdateProvince() *AdminLoginHistoryUpsert {
	u.SetExcluded(adminloginhistory.FieldProvince)
	return u
}

// SetCity sets the "city" field.
func (u *AdminLoginHistoryUpsert) SetCity(v string) *AdminLoginHistoryUpsert {
	u.Set(adminloginhistory.FieldCity, v)
	return u
}

// UpdateCity sets the "city" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsert) UpdateCity() *AdminLoginHistoryUpsert {
	u.SetExcluded(adminloginhistory.FieldCity)
	return u
}

// SetIsp sets the "isp" field.
func (u *AdminLoginHistoryUpsert) SetIsp(v string) *AdminLoginHistoryUpsert {
	u.Set(adminloginhistory.FieldIsp, v)
	return u
}

// UpdateIsp sets the "isp" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsert) UpdateIsp() *AdminLoginHistoryUpsert {
	u.SetExcluded(adminloginhistory.FieldIsp)
	return u
}

// ClearIsp clears the value of the "isp" field.
func (u *AdminLoginHistoryUpsert) ClearIsp() *AdminLoginHistoryUpsert {
	u.SetNull(adminloginhistory.FieldIsp)
	return u
}

// SetAsn sets the "asn" field.
func (u *AdminLoginHistoryUpsert) SetAsn(v string) *AdminLoginHistoryUpsert {
	u.Set(adminloginhistory.FieldAsn, v)
	return u
}

// UpdateAsn sets the "asn" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsert) UpdateAsn() *AdminLoginHistoryUpsert {
	u.SetExcluded(adminloginhistory.FieldAsn)
	return u
}

// ClearAsn clears the value of the "asn" field.
func (u *AdminLoginHistoryUpsert) ClearAsn() *AdminLoginHistoryUpsert {
	u.SetNull(adminloginhistory.FieldAsn)
	return u
}

// SetClientVersion sets the "client_version" field.
func (u *AdminLoginHistoryUpsert) SetClientVersion(v string) *AdminLoginHistoryUpsert {
	u.Set(adminloginhistory.FieldClientVersion, v)
	return u
}

// UpdateClientVersion sets the "client_version" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsert) UpdateClientVersion() *AdminLoginHistoryUpsert {
	u.SetExcluded(adminloginhistory.FieldClientVersion)
	return u
}

// ClearClientVersion clears the value of the "client_version" field.
func (u *AdminLoginHistoryUpsert) ClearClientVersion() *AdminLoginHistoryUpsert {
	u.SetNull(adminloginhistory.FieldClientVersion)
	return u
}

// SetDevice sets the "device" field.
func (u *AdminLoginHistoryUpsert) SetDevice(v string) *AdminLoginHistoryUpsert {
	u.Set(adminloginhistory.FieldDevice, v)
	return u
}

// UpdateDevice sets the "device" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsert) UpdateDevice() *AdminLoginHistoryUpsert {
	u.SetExcluded(adminloginhistory.FieldDevice)
	return u
}

// ClearDevice clears the value of the "device" field.
func (u *AdminLoginHistoryUpsert) ClearDevice() *AdminLoginHistoryUpsert {
	u.SetNull(adminloginhistory.FieldDevice)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *AdminLoginHistoryUpsert) SetCreatedAt(v time.Time) *AdminLoginHistoryUpsert {
	u.Set(adminloginhistory.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsert) UpdateCreatedAt() *AdminLoginHistoryUpsert {
	u.SetExcluded(adminloginhistory.FieldCreatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.AdminLoginHistory.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(adminloginhistory.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *AdminLoginHistoryUpsertOne) UpdateNewValues() *AdminLoginHistoryUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(adminloginhistory.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.AdminLoginHistory.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *AdminLoginHistoryUpsertOne) Ignore() *AdminLoginHistoryUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *AdminLoginHistoryUpsertOne) DoNothing() *AdminLoginHistoryUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the AdminLoginHistoryCreate.OnConflict
// documentation for more info.
func (u *AdminLoginHistoryUpsertOne) Update(set func(*AdminLoginHistoryUpsert)) *AdminLoginHistoryUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&AdminLoginHistoryUpsert{UpdateSet: update})
	}))
	return u
}

// SetAdminID sets the "admin_id" field.
func (u *AdminLoginHistoryUpsertOne) SetAdminID(v uuid.UUID) *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetAdminID(v)
	})
}

// UpdateAdminID sets the "admin_id" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertOne) UpdateAdminID() *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateAdminID()
	})
}

// ClearAdminID clears the value of the "admin_id" field.
func (u *AdminLoginHistoryUpsertOne) ClearAdminID() *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.ClearAdminID()
	})
}

// SetIP sets the "ip" field.
func (u *AdminLoginHistoryUpsertOne) SetIP(v string) *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetIP(v)
	})
}

// UpdateIP sets the "ip" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertOne) UpdateIP() *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateIP()
	})
}

// SetCountry sets the "country" field.
func (u *AdminLoginHistoryUpsertOne) SetCountry(v string) *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetCountry(v)
	})
}

// UpdateCountry sets the "country" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertOne) UpdateCountry() *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateCountry()
	})
}

// SetProvince sets the "province" field.
func (u *AdminLoginHistoryUpsertOne) SetProvince(v string) *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetProvince(v)
	})
}

// UpdateProvince sets the "province" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertOne) UpdateProvince() *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateProvince()
	})
}

// SetCity sets the "city" field.
func (u *AdminLoginHistoryUpsertOne) SetCity(v string) *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetCity(v)
	})
}

// UpdateCity sets the "city" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertOne) UpdateCity() *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateCity()
	})
}

// SetIsp sets the "isp" field.
func (u *AdminLoginHistoryUpsertOne) SetIsp(v string) *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetIsp(v)
	})
}

// UpdateIsp sets the "isp" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertOne) UpdateIsp() *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateIsp()
	})
}

// ClearIsp clears the value of the "isp" field.
func (u *AdminLoginHistoryUpsertOne) ClearIsp() *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.ClearIsp()
	})
}

// SetAsn sets the "asn" field.
func (u *AdminLoginHistoryUpsertOne) SetAsn(v string) *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetAsn(v)
	})
}

// UpdateAsn sets the "asn" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertOne) UpdateAsn() *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateAsn()
	})
}

// ClearAsn clears the value of the "asn" field.
func (u *AdminLoginHistoryUpsertOne) ClearAsn() *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.ClearAsn()
	})
}

// SetClientVersion sets the "client_version" field.
func (u *AdminLoginHistoryUpsertOne) SetClientVersion(v string) *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetClientVersion(v)
	})
}

// UpdateClientVersion sets the "client_version" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertOne) UpdateClientVersion() *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateClientVersion()
	})
}

// ClearClientVersion clears the value of the "client_version" field.
func (u *AdminLoginHistoryUpsertOne) ClearClientVersion() *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.ClearClientVersion()
	})
}

// SetDevice sets the "device" field.
func (u *AdminLoginHistoryUpsertOne) SetDevice(v string) *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetDevice(v)
	})
}

// UpdateDevice sets the "device" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertOne) UpdateDevice() *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateDevice()
	})
}

// ClearDevice clears the value of the "device" field.
func (u *AdminLoginHistoryUpsertOne) ClearDevice() *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.ClearDevice()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *AdminLoginHistoryUpsertOne) SetCreatedAt(v time.Time) *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertOne) UpdateCreatedAt() *AdminLoginHistoryUpsertOne {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateCreatedAt()
	})
}

// Exec executes the query.
func (u *AdminLoginHistoryUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for AdminLoginHistoryCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *AdminLoginHistoryUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *AdminLoginHistoryUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: AdminLoginHistoryUpsertOne.ID is not supported by MySQL driver. Use AdminLoginHistoryUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *AdminLoginHistoryUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// AdminLoginHistoryCreateBulk is the builder for creating many AdminLoginHistory entities in bulk.
type AdminLoginHistoryCreateBulk struct {
	config
	err      error
	builders []*AdminLoginHistoryCreate
	conflict []sql.ConflictOption
}

// Save creates the AdminLoginHistory entities in the database.
func (alhcb *AdminLoginHistoryCreateBulk) Save(ctx context.Context) ([]*AdminLoginHistory, error) {
	if alhcb.err != nil {
		return nil, alhcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(alhcb.builders))
	nodes := make([]*AdminLoginHistory, len(alhcb.builders))
	mutators := make([]Mutator, len(alhcb.builders))
	for i := range alhcb.builders {
		func(i int, root context.Context) {
			builder := alhcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*AdminLoginHistoryMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, alhcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = alhcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, alhcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, alhcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (alhcb *AdminLoginHistoryCreateBulk) SaveX(ctx context.Context) []*AdminLoginHistory {
	v, err := alhcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (alhcb *AdminLoginHistoryCreateBulk) Exec(ctx context.Context) error {
	_, err := alhcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (alhcb *AdminLoginHistoryCreateBulk) ExecX(ctx context.Context) {
	if err := alhcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.AdminLoginHistory.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.AdminLoginHistoryUpsert) {
//			SetAdminID(v+v).
//		}).
//		Exec(ctx)
func (alhcb *AdminLoginHistoryCreateBulk) OnConflict(opts ...sql.ConflictOption) *AdminLoginHistoryUpsertBulk {
	alhcb.conflict = opts
	return &AdminLoginHistoryUpsertBulk{
		create: alhcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.AdminLoginHistory.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (alhcb *AdminLoginHistoryCreateBulk) OnConflictColumns(columns ...string) *AdminLoginHistoryUpsertBulk {
	alhcb.conflict = append(alhcb.conflict, sql.ConflictColumns(columns...))
	return &AdminLoginHistoryUpsertBulk{
		create: alhcb,
	}
}

// AdminLoginHistoryUpsertBulk is the builder for "upsert"-ing
// a bulk of AdminLoginHistory nodes.
type AdminLoginHistoryUpsertBulk struct {
	create *AdminLoginHistoryCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.AdminLoginHistory.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(adminloginhistory.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *AdminLoginHistoryUpsertBulk) UpdateNewValues() *AdminLoginHistoryUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(adminloginhistory.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.AdminLoginHistory.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *AdminLoginHistoryUpsertBulk) Ignore() *AdminLoginHistoryUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *AdminLoginHistoryUpsertBulk) DoNothing() *AdminLoginHistoryUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the AdminLoginHistoryCreateBulk.OnConflict
// documentation for more info.
func (u *AdminLoginHistoryUpsertBulk) Update(set func(*AdminLoginHistoryUpsert)) *AdminLoginHistoryUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&AdminLoginHistoryUpsert{UpdateSet: update})
	}))
	return u
}

// SetAdminID sets the "admin_id" field.
func (u *AdminLoginHistoryUpsertBulk) SetAdminID(v uuid.UUID) *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetAdminID(v)
	})
}

// UpdateAdminID sets the "admin_id" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertBulk) UpdateAdminID() *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateAdminID()
	})
}

// ClearAdminID clears the value of the "admin_id" field.
func (u *AdminLoginHistoryUpsertBulk) ClearAdminID() *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.ClearAdminID()
	})
}

// SetIP sets the "ip" field.
func (u *AdminLoginHistoryUpsertBulk) SetIP(v string) *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetIP(v)
	})
}

// UpdateIP sets the "ip" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertBulk) UpdateIP() *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateIP()
	})
}

// SetCountry sets the "country" field.
func (u *AdminLoginHistoryUpsertBulk) SetCountry(v string) *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetCountry(v)
	})
}

// UpdateCountry sets the "country" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertBulk) UpdateCountry() *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateCountry()
	})
}

// SetProvince sets the "province" field.
func (u *AdminLoginHistoryUpsertBulk) SetProvince(v string) *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetProvince(v)
	})
}

// UpdateProvince sets the "province" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertBulk) UpdateProvince() *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateProvince()
	})
}

// SetCity sets the "city" field.
func (u *AdminLoginHistoryUpsertBulk) SetCity(v string) *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetCity(v)
	})
}

// UpdateCity sets the "city" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertBulk) UpdateCity() *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateCity()
	})
}

// SetIsp sets the "isp" field.
func (u *AdminLoginHistoryUpsertBulk) SetIsp(v string) *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetIsp(v)
	})
}

// UpdateIsp sets the "isp" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertBulk) UpdateIsp() *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateIsp()
	})
}

// ClearIsp clears the value of the "isp" field.
func (u *AdminLoginHistoryUpsertBulk) ClearIsp() *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.ClearIsp()
	})
}

// SetAsn sets the "asn" field.
func (u *AdminLoginHistoryUpsertBulk) SetAsn(v string) *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetAsn(v)
	})
}

// UpdateAsn sets the "asn" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertBulk) UpdateAsn() *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateAsn()
	})
}

// ClearAsn clears the value of the "asn" field.
func (u *AdminLoginHistoryUpsertBulk) ClearAsn() *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.ClearAsn()
	})
}

// SetClientVersion sets the "client_version" field.
func (u *AdminLoginHistoryUpsertBulk) SetClientVersion(v string) *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetClientVersion(v)
	})
}

// UpdateClientVersion sets the "client_version" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertBulk) UpdateClientVersion() *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateClientVersion()
	})
}

// ClearClientVersion clears the value of the "client_version" field.
func (u *AdminLoginHistoryUpsertBulk) ClearClientVersion() *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.ClearClientVersion()
	})
}

// SetDevice sets the "device" field.
func (u *AdminLoginHistoryUpsertBulk) SetDevice(v string) *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetDevice(v)
	})
}

// UpdateDevice sets the "device" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertBulk) UpdateDevice() *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateDevice()
	})
}

// ClearDevice clears the value of the "device" field.
func (u *AdminLoginHistoryUpsertBulk) ClearDevice() *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.ClearDevice()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *AdminLoginHistoryUpsertBulk) SetCreatedAt(v time.Time) *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *AdminLoginHistoryUpsertBulk) UpdateCreatedAt() *AdminLoginHistoryUpsertBulk {
	return u.Update(func(s *AdminLoginHistoryUpsert) {
		s.UpdateCreatedAt()
	})
}

// Exec executes the query.
func (u *AdminLoginHistoryUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the AdminLoginHistoryCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for AdminLoginHistoryCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *AdminLoginHistoryUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
