// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/adminloginhistory"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
)

// AdminLoginHistoryDelete is the builder for deleting a AdminLoginHistory entity.
type AdminLoginHistoryDelete struct {
	config
	hooks    []Hook
	mutation *AdminLoginHistoryMutation
}

// Where appends a list predicates to the AdminLoginHistoryDelete builder.
func (alhd *AdminLoginHistoryDelete) Where(ps ...predicate.AdminLoginHistory) *AdminLoginHistoryDelete {
	alhd.mutation.Where(ps...)
	return alhd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (alhd *AdminLoginHistoryDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, alhd.sqlExec, alhd.mutation, alhd.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (alhd *AdminLoginHistoryDelete) ExecX(ctx context.Context) int {
	n, err := alhd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (alhd *AdminLoginHistoryDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(adminloginhistory.Table, sqlgraph.NewFieldSpec(adminloginhistory.FieldID, field.TypeUUID))
	if ps := alhd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, alhd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	alhd.mutation.done = true
	return affected, err
}

// AdminLoginHistoryDeleteOne is the builder for deleting a single AdminLoginHistory entity.
type AdminLoginHistoryDeleteOne struct {
	alhd *AdminLoginHistoryDelete
}

// Where appends a list predicates to the AdminLoginHistoryDelete builder.
func (alhdo *AdminLoginHistoryDeleteOne) Where(ps ...predicate.AdminLoginHistory) *AdminLoginHistoryDeleteOne {
	alhdo.alhd.mutation.Where(ps...)
	return alhdo
}

// Exec executes the deletion query.
func (alhdo *AdminLoginHistoryDeleteOne) Exec(ctx context.Context) error {
	n, err := alhdo.alhd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{adminloginhistory.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (alhdo *AdminLoginHistoryDeleteOne) ExecX(ctx context.Context) {
	if err := alhdo.Exec(ctx); err != nil {
		panic(err)
	}
}
