// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/adminrole"
	"github.com/chaitin/MonkeyCode/backend/db/role"
	"github.com/google/uuid"
)

// AdminRole is the model entity for the AdminRole schema.
type AdminRole struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// AdminID holds the value of the "admin_id" field.
	AdminID uuid.UUID `json:"admin_id,omitempty"`
	// RoleID holds the value of the "role_id" field.
	RoleID int64 `json:"role_id,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the AdminRoleQuery when eager-loading is set.
	Edges        AdminRoleEdges `json:"edges"`
	selectValues sql.SelectValues
}

// AdminRoleEdges holds the relations/edges for other nodes in the graph.
type AdminRoleEdges struct {
	// Admin holds the value of the admin edge.
	Admin *Admin `json:"admin,omitempty"`
	// Role holds the value of the role edge.
	Role *Role `json:"role,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [2]bool
}

// AdminOrErr returns the Admin value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e AdminRoleEdges) AdminOrErr() (*Admin, error) {
	if e.Admin != nil {
		return e.Admin, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: admin.Label}
	}
	return nil, &NotLoadedError{edge: "admin"}
}

// RoleOrErr returns the Role value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e AdminRoleEdges) RoleOrErr() (*Role, error) {
	if e.Role != nil {
		return e.Role, nil
	} else if e.loadedTypes[1] {
		return nil, &NotFoundError{label: role.Label}
	}
	return nil, &NotLoadedError{edge: "role"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*AdminRole) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case adminrole.FieldRoleID:
			values[i] = new(sql.NullInt64)
		case adminrole.FieldID, adminrole.FieldAdminID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the AdminRole fields.
func (ar *AdminRole) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case adminrole.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				ar.ID = *value
			}
		case adminrole.FieldAdminID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field admin_id", values[i])
			} else if value != nil {
				ar.AdminID = *value
			}
		case adminrole.FieldRoleID:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field role_id", values[i])
			} else if value.Valid {
				ar.RoleID = value.Int64
			}
		default:
			ar.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the AdminRole.
// This includes values selected through modifiers, order, etc.
func (ar *AdminRole) Value(name string) (ent.Value, error) {
	return ar.selectValues.Get(name)
}

// QueryAdmin queries the "admin" edge of the AdminRole entity.
func (ar *AdminRole) QueryAdmin() *AdminQuery {
	return NewAdminRoleClient(ar.config).QueryAdmin(ar)
}

// QueryRole queries the "role" edge of the AdminRole entity.
func (ar *AdminRole) QueryRole() *RoleQuery {
	return NewAdminRoleClient(ar.config).QueryRole(ar)
}

// Update returns a builder for updating this AdminRole.
// Note that you need to call AdminRole.Unwrap() before calling this method if this AdminRole
// was returned from a transaction, and the transaction was committed or rolled back.
func (ar *AdminRole) Update() *AdminRoleUpdateOne {
	return NewAdminRoleClient(ar.config).UpdateOne(ar)
}

// Unwrap unwraps the AdminRole entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (ar *AdminRole) Unwrap() *AdminRole {
	_tx, ok := ar.config.driver.(*txDriver)
	if !ok {
		panic("db: AdminRole is not a transactional entity")
	}
	ar.config.driver = _tx.drv
	return ar
}

// String implements the fmt.Stringer.
func (ar *AdminRole) String() string {
	var builder strings.Builder
	builder.WriteString("AdminRole(")
	builder.WriteString(fmt.Sprintf("id=%v, ", ar.ID))
	builder.WriteString("admin_id=")
	builder.WriteString(fmt.Sprintf("%v", ar.AdminID))
	builder.WriteString(", ")
	builder.WriteString("role_id=")
	builder.WriteString(fmt.Sprintf("%v", ar.RoleID))
	builder.WriteByte(')')
	return builder.String()
}

// AdminRoles is a parsable slice of AdminRole.
type AdminRoles []*AdminRole
