// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"fmt"
	"math"

	"entgo.io/ent"
	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/adminrole"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/role"
	"github.com/google/uuid"
)

// AdminRoleQuery is the builder for querying AdminRole entities.
type AdminRoleQuery struct {
	config
	ctx        *QueryContext
	order      []adminrole.OrderOption
	inters     []Interceptor
	predicates []predicate.AdminRole
	withAdmin  *AdminQuery
	withRole   *RoleQuery
	modifiers  []func(*sql.Selector)
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the AdminRoleQuery builder.
func (arq *AdminRoleQuery) Where(ps ...predicate.AdminRole) *AdminRoleQuery {
	arq.predicates = append(arq.predicates, ps...)
	return arq
}

// Limit the number of records to be returned by this query.
func (arq *AdminRoleQuery) Limit(limit int) *AdminRoleQuery {
	arq.ctx.Limit = &limit
	return arq
}

// Offset to start from.
func (arq *AdminRoleQuery) Offset(offset int) *AdminRoleQuery {
	arq.ctx.Offset = &offset
	return arq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (arq *AdminRoleQuery) Unique(unique bool) *AdminRoleQuery {
	arq.ctx.Unique = &unique
	return arq
}

// Order specifies how the records should be ordered.
func (arq *AdminRoleQuery) Order(o ...adminrole.OrderOption) *AdminRoleQuery {
	arq.order = append(arq.order, o...)
	return arq
}

// QueryAdmin chains the current query on the "admin" edge.
func (arq *AdminRoleQuery) QueryAdmin() *AdminQuery {
	query := (&AdminClient{config: arq.config}).Query()
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := arq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := arq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(adminrole.Table, adminrole.FieldID, selector),
			sqlgraph.To(admin.Table, admin.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, adminrole.AdminTable, adminrole.AdminColumn),
		)
		fromU = sqlgraph.SetNeighbors(arq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// QueryRole chains the current query on the "role" edge.
func (arq *AdminRoleQuery) QueryRole() *RoleQuery {
	query := (&RoleClient{config: arq.config}).Query()
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := arq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := arq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(adminrole.Table, adminrole.FieldID, selector),
			sqlgraph.To(role.Table, role.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, adminrole.RoleTable, adminrole.RoleColumn),
		)
		fromU = sqlgraph.SetNeighbors(arq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// First returns the first AdminRole entity from the query.
// Returns a *NotFoundError when no AdminRole was found.
func (arq *AdminRoleQuery) First(ctx context.Context) (*AdminRole, error) {
	nodes, err := arq.Limit(1).All(setContextOp(ctx, arq.ctx, ent.OpQueryFirst))
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{adminrole.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (arq *AdminRoleQuery) FirstX(ctx context.Context) *AdminRole {
	node, err := arq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// FirstID returns the first AdminRole ID from the query.
// Returns a *NotFoundError when no AdminRole ID was found.
func (arq *AdminRoleQuery) FirstID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = arq.Limit(1).IDs(setContextOp(ctx, arq.ctx, ent.OpQueryFirstID)); err != nil {
		return
	}
	if len(ids) == 0 {
		err = &NotFoundError{adminrole.Label}
		return
	}
	return ids[0], nil
}

// FirstIDX is like FirstID, but panics if an error occurs.
func (arq *AdminRoleQuery) FirstIDX(ctx context.Context) uuid.UUID {
	id, err := arq.FirstID(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return id
}

// Only returns a single AdminRole entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one AdminRole entity is found.
// Returns a *NotFoundError when no AdminRole entities are found.
func (arq *AdminRoleQuery) Only(ctx context.Context) (*AdminRole, error) {
	nodes, err := arq.Limit(2).All(setContextOp(ctx, arq.ctx, ent.OpQueryOnly))
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{adminrole.Label}
	default:
		return nil, &NotSingularError{adminrole.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (arq *AdminRoleQuery) OnlyX(ctx context.Context) *AdminRole {
	node, err := arq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// OnlyID is like Only, but returns the only AdminRole ID in the query.
// Returns a *NotSingularError when more than one AdminRole ID is found.
// Returns a *NotFoundError when no entities are found.
func (arq *AdminRoleQuery) OnlyID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = arq.Limit(2).IDs(setContextOp(ctx, arq.ctx, ent.OpQueryOnlyID)); err != nil {
		return
	}
	switch len(ids) {
	case 1:
		id = ids[0]
	case 0:
		err = &NotFoundError{adminrole.Label}
	default:
		err = &NotSingularError{adminrole.Label}
	}
	return
}

// OnlyIDX is like OnlyID, but panics if an error occurs.
func (arq *AdminRoleQuery) OnlyIDX(ctx context.Context) uuid.UUID {
	id, err := arq.OnlyID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// All executes the query and returns a list of AdminRoles.
func (arq *AdminRoleQuery) All(ctx context.Context) ([]*AdminRole, error) {
	ctx = setContextOp(ctx, arq.ctx, ent.OpQueryAll)
	if err := arq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	qr := querierAll[[]*AdminRole, *AdminRoleQuery]()
	return withInterceptors[[]*AdminRole](ctx, arq, qr, arq.inters)
}

// AllX is like All, but panics if an error occurs.
func (arq *AdminRoleQuery) AllX(ctx context.Context) []*AdminRole {
	nodes, err := arq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// IDs executes the query and returns a list of AdminRole IDs.
func (arq *AdminRoleQuery) IDs(ctx context.Context) (ids []uuid.UUID, err error) {
	if arq.ctx.Unique == nil && arq.path != nil {
		arq.Unique(true)
	}
	ctx = setContextOp(ctx, arq.ctx, ent.OpQueryIDs)
	if err = arq.Select(adminrole.FieldID).Scan(ctx, &ids); err != nil {
		return nil, err
	}
	return ids, nil
}

// IDsX is like IDs, but panics if an error occurs.
func (arq *AdminRoleQuery) IDsX(ctx context.Context) []uuid.UUID {
	ids, err := arq.IDs(ctx)
	if err != nil {
		panic(err)
	}
	return ids
}

// Count returns the count of the given query.
func (arq *AdminRoleQuery) Count(ctx context.Context) (int, error) {
	ctx = setContextOp(ctx, arq.ctx, ent.OpQueryCount)
	if err := arq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return withInterceptors[int](ctx, arq, querierCount[*AdminRoleQuery](), arq.inters)
}

// CountX is like Count, but panics if an error occurs.
func (arq *AdminRoleQuery) CountX(ctx context.Context) int {
	count, err := arq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (arq *AdminRoleQuery) Exist(ctx context.Context) (bool, error) {
	ctx = setContextOp(ctx, arq.ctx, ent.OpQueryExist)
	switch _, err := arq.FirstID(ctx); {
	case IsNotFound(err):
		return false, nil
	case err != nil:
		return false, fmt.Errorf("db: check existence: %w", err)
	default:
		return true, nil
	}
}

// ExistX is like Exist, but panics if an error occurs.
func (arq *AdminRoleQuery) ExistX(ctx context.Context) bool {
	exist, err := arq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the AdminRoleQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (arq *AdminRoleQuery) Clone() *AdminRoleQuery {
	if arq == nil {
		return nil
	}
	return &AdminRoleQuery{
		config:     arq.config,
		ctx:        arq.ctx.Clone(),
		order:      append([]adminrole.OrderOption{}, arq.order...),
		inters:     append([]Interceptor{}, arq.inters...),
		predicates: append([]predicate.AdminRole{}, arq.predicates...),
		withAdmin:  arq.withAdmin.Clone(),
		withRole:   arq.withRole.Clone(),
		// clone intermediate query.
		sql:       arq.sql.Clone(),
		path:      arq.path,
		modifiers: append([]func(*sql.Selector){}, arq.modifiers...),
	}
}

// WithAdmin tells the query-builder to eager-load the nodes that are connected to
// the "admin" edge. The optional arguments are used to configure the query builder of the edge.
func (arq *AdminRoleQuery) WithAdmin(opts ...func(*AdminQuery)) *AdminRoleQuery {
	query := (&AdminClient{config: arq.config}).Query()
	for _, opt := range opts {
		opt(query)
	}
	arq.withAdmin = query
	return arq
}

// WithRole tells the query-builder to eager-load the nodes that are connected to
// the "role" edge. The optional arguments are used to configure the query builder of the edge.
func (arq *AdminRoleQuery) WithRole(opts ...func(*RoleQuery)) *AdminRoleQuery {
	query := (&RoleClient{config: arq.config}).Query()
	for _, opt := range opts {
		opt(query)
	}
	arq.withRole = query
	return arq
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		AdminID uuid.UUID `json:"admin_id,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.AdminRole.Query().
//		GroupBy(adminrole.FieldAdminID).
//		Aggregate(db.Count()).
//		Scan(ctx, &v)
func (arq *AdminRoleQuery) GroupBy(field string, fields ...string) *AdminRoleGroupBy {
	arq.ctx.Fields = append([]string{field}, fields...)
	grbuild := &AdminRoleGroupBy{build: arq}
	grbuild.flds = &arq.ctx.Fields
	grbuild.label = adminrole.Label
	grbuild.scan = grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		AdminID uuid.UUID `json:"admin_id,omitempty"`
//	}
//
//	client.AdminRole.Query().
//		Select(adminrole.FieldAdminID).
//		Scan(ctx, &v)
func (arq *AdminRoleQuery) Select(fields ...string) *AdminRoleSelect {
	arq.ctx.Fields = append(arq.ctx.Fields, fields...)
	sbuild := &AdminRoleSelect{AdminRoleQuery: arq}
	sbuild.label = adminrole.Label
	sbuild.flds, sbuild.scan = &arq.ctx.Fields, sbuild.Scan
	return sbuild
}

// Aggregate returns a AdminRoleSelect configured with the given aggregations.
func (arq *AdminRoleQuery) Aggregate(fns ...AggregateFunc) *AdminRoleSelect {
	return arq.Select().Aggregate(fns...)
}

func (arq *AdminRoleQuery) prepareQuery(ctx context.Context) error {
	for _, inter := range arq.inters {
		if inter == nil {
			return fmt.Errorf("db: uninitialized interceptor (forgotten import db/runtime?)")
		}
		if trv, ok := inter.(Traverser); ok {
			if err := trv.Traverse(ctx, arq); err != nil {
				return err
			}
		}
	}
	for _, f := range arq.ctx.Fields {
		if !adminrole.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
		}
	}
	if arq.path != nil {
		prev, err := arq.path(ctx)
		if err != nil {
			return err
		}
		arq.sql = prev
	}
	return nil
}

func (arq *AdminRoleQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*AdminRole, error) {
	var (
		nodes       = []*AdminRole{}
		_spec       = arq.querySpec()
		loadedTypes = [2]bool{
			arq.withAdmin != nil,
			arq.withRole != nil,
		}
	)
	_spec.ScanValues = func(columns []string) ([]any, error) {
		return (*AdminRole).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []any) error {
		node := &AdminRole{config: arq.config}
		nodes = append(nodes, node)
		node.Edges.loadedTypes = loadedTypes
		return node.assignValues(columns, values)
	}
	if len(arq.modifiers) > 0 {
		_spec.Modifiers = arq.modifiers
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, arq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	if query := arq.withAdmin; query != nil {
		if err := arq.loadAdmin(ctx, query, nodes, nil,
			func(n *AdminRole, e *Admin) { n.Edges.Admin = e }); err != nil {
			return nil, err
		}
	}
	if query := arq.withRole; query != nil {
		if err := arq.loadRole(ctx, query, nodes, nil,
			func(n *AdminRole, e *Role) { n.Edges.Role = e }); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

func (arq *AdminRoleQuery) loadAdmin(ctx context.Context, query *AdminQuery, nodes []*AdminRole, init func(*AdminRole), assign func(*AdminRole, *Admin)) error {
	ids := make([]uuid.UUID, 0, len(nodes))
	nodeids := make(map[uuid.UUID][]*AdminRole)
	for i := range nodes {
		fk := nodes[i].AdminID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	if len(ids) == 0 {
		return nil
	}
	query.Where(admin.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "admin_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}
func (arq *AdminRoleQuery) loadRole(ctx context.Context, query *RoleQuery, nodes []*AdminRole, init func(*AdminRole), assign func(*AdminRole, *Role)) error {
	ids := make([]int64, 0, len(nodes))
	nodeids := make(map[int64][]*AdminRole)
	for i := range nodes {
		fk := nodes[i].RoleID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	if len(ids) == 0 {
		return nil
	}
	query.Where(role.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "role_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}

func (arq *AdminRoleQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := arq.querySpec()
	if len(arq.modifiers) > 0 {
		_spec.Modifiers = arq.modifiers
	}
	_spec.Node.Columns = arq.ctx.Fields
	if len(arq.ctx.Fields) > 0 {
		_spec.Unique = arq.ctx.Unique != nil && *arq.ctx.Unique
	}
	return sqlgraph.CountNodes(ctx, arq.driver, _spec)
}

func (arq *AdminRoleQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := sqlgraph.NewQuerySpec(adminrole.Table, adminrole.Columns, sqlgraph.NewFieldSpec(adminrole.FieldID, field.TypeUUID))
	_spec.From = arq.sql
	if unique := arq.ctx.Unique; unique != nil {
		_spec.Unique = *unique
	} else if arq.path != nil {
		_spec.Unique = true
	}
	if fields := arq.ctx.Fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, adminrole.FieldID)
		for i := range fields {
			if fields[i] != adminrole.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
			}
		}
		if arq.withAdmin != nil {
			_spec.Node.AddColumnOnce(adminrole.FieldAdminID)
		}
		if arq.withRole != nil {
			_spec.Node.AddColumnOnce(adminrole.FieldRoleID)
		}
	}
	if ps := arq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := arq.ctx.Limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := arq.ctx.Offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := arq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (arq *AdminRoleQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(arq.driver.Dialect())
	t1 := builder.Table(adminrole.Table)
	columns := arq.ctx.Fields
	if len(columns) == 0 {
		columns = adminrole.Columns
	}
	selector := builder.Select(t1.Columns(columns...)...).From(t1)
	if arq.sql != nil {
		selector = arq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if arq.ctx.Unique != nil && *arq.ctx.Unique {
		selector.Distinct()
	}
	for _, m := range arq.modifiers {
		m(selector)
	}
	for _, p := range arq.predicates {
		p(selector)
	}
	for _, p := range arq.order {
		p(selector)
	}
	if offset := arq.ctx.Offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := arq.ctx.Limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// ForUpdate locks the selected rows against concurrent updates, and prevent them from being
// updated, deleted or "selected ... for update" by other sessions, until the transaction is
// either committed or rolled-back.
func (arq *AdminRoleQuery) ForUpdate(opts ...sql.LockOption) *AdminRoleQuery {
	if arq.driver.Dialect() == dialect.Postgres {
		arq.Unique(false)
	}
	arq.modifiers = append(arq.modifiers, func(s *sql.Selector) {
		s.ForUpdate(opts...)
	})
	return arq
}

// ForShare behaves similarly to ForUpdate, except that it acquires a shared mode lock
// on any rows that are read. Other sessions can read the rows, but cannot modify them
// until your transaction commits.
func (arq *AdminRoleQuery) ForShare(opts ...sql.LockOption) *AdminRoleQuery {
	if arq.driver.Dialect() == dialect.Postgres {
		arq.Unique(false)
	}
	arq.modifiers = append(arq.modifiers, func(s *sql.Selector) {
		s.ForShare(opts...)
	})
	return arq
}

// Modify adds a query modifier for attaching custom logic to queries.
func (arq *AdminRoleQuery) Modify(modifiers ...func(s *sql.Selector)) *AdminRoleSelect {
	arq.modifiers = append(arq.modifiers, modifiers...)
	return arq.Select()
}

// AdminRoleGroupBy is the group-by builder for AdminRole entities.
type AdminRoleGroupBy struct {
	selector
	build *AdminRoleQuery
}

// Aggregate adds the given aggregation functions to the group-by query.
func (argb *AdminRoleGroupBy) Aggregate(fns ...AggregateFunc) *AdminRoleGroupBy {
	argb.fns = append(argb.fns, fns...)
	return argb
}

// Scan applies the selector query and scans the result into the given value.
func (argb *AdminRoleGroupBy) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, argb.build.ctx, ent.OpQueryGroupBy)
	if err := argb.build.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*AdminRoleQuery, *AdminRoleGroupBy](ctx, argb.build, argb, argb.build.inters, v)
}

func (argb *AdminRoleGroupBy) sqlScan(ctx context.Context, root *AdminRoleQuery, v any) error {
	selector := root.sqlQuery(ctx).Select()
	aggregation := make([]string, 0, len(argb.fns))
	for _, fn := range argb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(*argb.flds)+len(argb.fns))
		for _, f := range *argb.flds {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	selector.GroupBy(selector.Columns(*argb.flds...)...)
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := argb.build.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// AdminRoleSelect is the builder for selecting fields of AdminRole entities.
type AdminRoleSelect struct {
	*AdminRoleQuery
	selector
}

// Aggregate adds the given aggregation functions to the selector query.
func (ars *AdminRoleSelect) Aggregate(fns ...AggregateFunc) *AdminRoleSelect {
	ars.fns = append(ars.fns, fns...)
	return ars
}

// Scan applies the selector query and scans the result into the given value.
func (ars *AdminRoleSelect) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, ars.ctx, ent.OpQuerySelect)
	if err := ars.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*AdminRoleQuery, *AdminRoleSelect](ctx, ars.AdminRoleQuery, ars, ars.inters, v)
}

func (ars *AdminRoleSelect) sqlScan(ctx context.Context, root *AdminRoleQuery, v any) error {
	selector := root.sqlQuery(ctx)
	aggregation := make([]string, 0, len(ars.fns))
	for _, fn := range ars.fns {
		aggregation = append(aggregation, fn(selector))
	}
	switch n := len(*ars.selector.flds); {
	case n == 0 && len(aggregation) > 0:
		selector.Select(aggregation...)
	case n != 0 && len(aggregation) > 0:
		selector.AppendSelect(aggregation...)
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := ars.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// Modify adds a query modifier for attaching custom logic to queries.
func (ars *AdminRoleSelect) Modify(modifiers ...func(s *sql.Selector)) *AdminRoleSelect {
	ars.modifiers = append(ars.modifiers, modifiers...)
	return ars
}
