// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/adminrole"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/role"
	"github.com/google/uuid"
)

// AdminRoleUpdate is the builder for updating AdminRole entities.
type AdminRoleUpdate struct {
	config
	hooks     []Hook
	mutation  *AdminRoleMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the AdminRoleUpdate builder.
func (aru *AdminRoleUpdate) Where(ps ...predicate.AdminRole) *AdminRoleUpdate {
	aru.mutation.Where(ps...)
	return aru
}

// SetAdminID sets the "admin_id" field.
func (aru *AdminRoleUpdate) SetAdminID(u uuid.UUID) *AdminRoleUpdate {
	aru.mutation.SetAdminID(u)
	return aru
}

// SetNillableAdminID sets the "admin_id" field if the given value is not nil.
func (aru *AdminRoleUpdate) SetNillableAdminID(u *uuid.UUID) *AdminRoleUpdate {
	if u != nil {
		aru.SetAdminID(*u)
	}
	return aru
}

// SetRoleID sets the "role_id" field.
func (aru *AdminRoleUpdate) SetRoleID(i int64) *AdminRoleUpdate {
	aru.mutation.SetRoleID(i)
	return aru
}

// SetNillableRoleID sets the "role_id" field if the given value is not nil.
func (aru *AdminRoleUpdate) SetNillableRoleID(i *int64) *AdminRoleUpdate {
	if i != nil {
		aru.SetRoleID(*i)
	}
	return aru
}

// SetAdmin sets the "admin" edge to the Admin entity.
func (aru *AdminRoleUpdate) SetAdmin(a *Admin) *AdminRoleUpdate {
	return aru.SetAdminID(a.ID)
}

// SetRole sets the "role" edge to the Role entity.
func (aru *AdminRoleUpdate) SetRole(r *Role) *AdminRoleUpdate {
	return aru.SetRoleID(r.ID)
}

// Mutation returns the AdminRoleMutation object of the builder.
func (aru *AdminRoleUpdate) Mutation() *AdminRoleMutation {
	return aru.mutation
}

// ClearAdmin clears the "admin" edge to the Admin entity.
func (aru *AdminRoleUpdate) ClearAdmin() *AdminRoleUpdate {
	aru.mutation.ClearAdmin()
	return aru
}

// ClearRole clears the "role" edge to the Role entity.
func (aru *AdminRoleUpdate) ClearRole() *AdminRoleUpdate {
	aru.mutation.ClearRole()
	return aru
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (aru *AdminRoleUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, aru.sqlSave, aru.mutation, aru.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (aru *AdminRoleUpdate) SaveX(ctx context.Context) int {
	affected, err := aru.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (aru *AdminRoleUpdate) Exec(ctx context.Context) error {
	_, err := aru.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (aru *AdminRoleUpdate) ExecX(ctx context.Context) {
	if err := aru.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (aru *AdminRoleUpdate) check() error {
	if aru.mutation.AdminCleared() && len(aru.mutation.AdminIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "AdminRole.admin"`)
	}
	if aru.mutation.RoleCleared() && len(aru.mutation.RoleIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "AdminRole.role"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (aru *AdminRoleUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *AdminRoleUpdate {
	aru.modifiers = append(aru.modifiers, modifiers...)
	return aru
}

func (aru *AdminRoleUpdate) sqlSave(ctx context.Context) (n int, err error) {
	if err := aru.check(); err != nil {
		return n, err
	}
	_spec := sqlgraph.NewUpdateSpec(adminrole.Table, adminrole.Columns, sqlgraph.NewFieldSpec(adminrole.FieldID, field.TypeUUID))
	if ps := aru.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if aru.mutation.AdminCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   adminrole.AdminTable,
			Columns: []string{adminrole.AdminColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := aru.mutation.AdminIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   adminrole.AdminTable,
			Columns: []string{adminrole.AdminColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if aru.mutation.RoleCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   adminrole.RoleTable,
			Columns: []string{adminrole.RoleColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(role.FieldID, field.TypeInt64),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := aru.mutation.RoleIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   adminrole.RoleTable,
			Columns: []string{adminrole.RoleColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(role.FieldID, field.TypeInt64),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(aru.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, aru.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{adminrole.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	aru.mutation.done = true
	return n, nil
}

// AdminRoleUpdateOne is the builder for updating a single AdminRole entity.
type AdminRoleUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *AdminRoleMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetAdminID sets the "admin_id" field.
func (aruo *AdminRoleUpdateOne) SetAdminID(u uuid.UUID) *AdminRoleUpdateOne {
	aruo.mutation.SetAdminID(u)
	return aruo
}

// SetNillableAdminID sets the "admin_id" field if the given value is not nil.
func (aruo *AdminRoleUpdateOne) SetNillableAdminID(u *uuid.UUID) *AdminRoleUpdateOne {
	if u != nil {
		aruo.SetAdminID(*u)
	}
	return aruo
}

// SetRoleID sets the "role_id" field.
func (aruo *AdminRoleUpdateOne) SetRoleID(i int64) *AdminRoleUpdateOne {
	aruo.mutation.SetRoleID(i)
	return aruo
}

// SetNillableRoleID sets the "role_id" field if the given value is not nil.
func (aruo *AdminRoleUpdateOne) SetNillableRoleID(i *int64) *AdminRoleUpdateOne {
	if i != nil {
		aruo.SetRoleID(*i)
	}
	return aruo
}

// SetAdmin sets the "admin" edge to the Admin entity.
func (aruo *AdminRoleUpdateOne) SetAdmin(a *Admin) *AdminRoleUpdateOne {
	return aruo.SetAdminID(a.ID)
}

// SetRole sets the "role" edge to the Role entity.
func (aruo *AdminRoleUpdateOne) SetRole(r *Role) *AdminRoleUpdateOne {
	return aruo.SetRoleID(r.ID)
}

// Mutation returns the AdminRoleMutation object of the builder.
func (aruo *AdminRoleUpdateOne) Mutation() *AdminRoleMutation {
	return aruo.mutation
}

// ClearAdmin clears the "admin" edge to the Admin entity.
func (aruo *AdminRoleUpdateOne) ClearAdmin() *AdminRoleUpdateOne {
	aruo.mutation.ClearAdmin()
	return aruo
}

// ClearRole clears the "role" edge to the Role entity.
func (aruo *AdminRoleUpdateOne) ClearRole() *AdminRoleUpdateOne {
	aruo.mutation.ClearRole()
	return aruo
}

// Where appends a list predicates to the AdminRoleUpdate builder.
func (aruo *AdminRoleUpdateOne) Where(ps ...predicate.AdminRole) *AdminRoleUpdateOne {
	aruo.mutation.Where(ps...)
	return aruo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (aruo *AdminRoleUpdateOne) Select(field string, fields ...string) *AdminRoleUpdateOne {
	aruo.fields = append([]string{field}, fields...)
	return aruo
}

// Save executes the query and returns the updated AdminRole entity.
func (aruo *AdminRoleUpdateOne) Save(ctx context.Context) (*AdminRole, error) {
	return withHooks(ctx, aruo.sqlSave, aruo.mutation, aruo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (aruo *AdminRoleUpdateOne) SaveX(ctx context.Context) *AdminRole {
	node, err := aruo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (aruo *AdminRoleUpdateOne) Exec(ctx context.Context) error {
	_, err := aruo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (aruo *AdminRoleUpdateOne) ExecX(ctx context.Context) {
	if err := aruo.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (aruo *AdminRoleUpdateOne) check() error {
	if aruo.mutation.AdminCleared() && len(aruo.mutation.AdminIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "AdminRole.admin"`)
	}
	if aruo.mutation.RoleCleared() && len(aruo.mutation.RoleIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "AdminRole.role"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (aruo *AdminRoleUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *AdminRoleUpdateOne {
	aruo.modifiers = append(aruo.modifiers, modifiers...)
	return aruo
}

func (aruo *AdminRoleUpdateOne) sqlSave(ctx context.Context) (_node *AdminRole, err error) {
	if err := aruo.check(); err != nil {
		return _node, err
	}
	_spec := sqlgraph.NewUpdateSpec(adminrole.Table, adminrole.Columns, sqlgraph.NewFieldSpec(adminrole.FieldID, field.TypeUUID))
	id, ok := aruo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "AdminRole.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := aruo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, adminrole.FieldID)
		for _, f := range fields {
			if !adminrole.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != adminrole.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := aruo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if aruo.mutation.AdminCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   adminrole.AdminTable,
			Columns: []string{adminrole.AdminColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := aruo.mutation.AdminIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   adminrole.AdminTable,
			Columns: []string{adminrole.AdminColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if aruo.mutation.RoleCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   adminrole.RoleTable,
			Columns: []string{adminrole.RoleColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(role.FieldID, field.TypeInt64),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := aruo.mutation.RoleIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   adminrole.RoleTable,
			Columns: []string{adminrole.RoleColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(role.FieldID, field.TypeInt64),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(aruo.modifiers...)
	_node = &AdminRole{config: aruo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, aruo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{adminrole.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	aruo.mutation.done = true
	return _node, nil
}
