// Code generated by ent, DO NOT EDIT.

package aiemployee

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the aiemployee type in the database.
	Label = "ai_employee"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldAdminID holds the string denoting the admin_id field in the database.
	FieldAdminID = "admin_id"
	// FieldUserID holds the string denoting the user_id field in the database.
	FieldUserID = "user_id"
	// FieldName holds the string denoting the name field in the database.
	FieldName = "name"
	// FieldPosition holds the string denoting the position field in the database.
	FieldPosition = "position"
	// FieldRepositoryURL holds the string denoting the repository_url field in the database.
	FieldRepositoryURL = "repository_url"
	// FieldRepositoryUser holds the string denoting the repository_user field in the database.
	FieldRepositoryUser = "repository_user"
	// FieldPlatform holds the string denoting the platform field in the database.
	FieldPlatform = "platform"
	// FieldToken holds the string denoting the token field in the database.
	FieldToken = "token"
	// FieldWebhookSecret holds the string denoting the webhook_secret field in the database.
	FieldWebhookSecret = "webhook_secret"
	// FieldWebhookURL holds the string denoting the webhook_url field in the database.
	FieldWebhookURL = "webhook_url"
	// FieldCreatedBy holds the string denoting the created_by field in the database.
	FieldCreatedBy = "created_by"
	// FieldParameters holds the string denoting the parameters field in the database.
	FieldParameters = "parameters"
	// FieldCreatedAt holds the string denoting the created_at field in the database.
	FieldCreatedAt = "created_at"
	// FieldUpdatedAt holds the string denoting the updated_at field in the database.
	FieldUpdatedAt = "updated_at"
	// EdgeAdmin holds the string denoting the admin edge name in mutations.
	EdgeAdmin = "admin"
	// EdgeUser holds the string denoting the user edge name in mutations.
	EdgeUser = "user"
	// Table holds the table name of the aiemployee in the database.
	Table = "ai_employees"
	// AdminTable is the table that holds the admin relation/edge.
	AdminTable = "ai_employees"
	// AdminInverseTable is the table name for the Admin entity.
	// It exists in this package in order to avoid circular dependency with the "admin" package.
	AdminInverseTable = "admins"
	// AdminColumn is the table column denoting the admin relation/edge.
	AdminColumn = "admin_id"
	// UserTable is the table that holds the user relation/edge.
	UserTable = "ai_employees"
	// UserInverseTable is the table name for the User entity.
	// It exists in this package in order to avoid circular dependency with the "user" package.
	UserInverseTable = "users"
	// UserColumn is the table column denoting the user relation/edge.
	UserColumn = "user_id"
)

// Columns holds all SQL columns for aiemployee fields.
var Columns = []string{
	FieldID,
	FieldAdminID,
	FieldUserID,
	FieldName,
	FieldPosition,
	FieldRepositoryURL,
	FieldRepositoryUser,
	FieldPlatform,
	FieldToken,
	FieldWebhookSecret,
	FieldWebhookURL,
	FieldCreatedBy,
	FieldParameters,
	FieldCreatedAt,
	FieldUpdatedAt,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultCreatedAt holds the default value on creation for the "created_at" field.
	DefaultCreatedAt func() time.Time
	// DefaultUpdatedAt holds the default value on creation for the "updated_at" field.
	DefaultUpdatedAt func() time.Time
	// UpdateDefaultUpdatedAt holds the default value on update for the "updated_at" field.
	UpdateDefaultUpdatedAt func() time.Time
)

// OrderOption defines the ordering options for the AIEmployee queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByAdminID orders the results by the admin_id field.
func ByAdminID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldAdminID, opts...).ToFunc()
}

// ByUserID orders the results by the user_id field.
func ByUserID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUserID, opts...).ToFunc()
}

// ByName orders the results by the name field.
func ByName(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldName, opts...).ToFunc()
}

// ByPosition orders the results by the position field.
func ByPosition(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldPosition, opts...).ToFunc()
}

// ByRepositoryURL orders the results by the repository_url field.
func ByRepositoryURL(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldRepositoryURL, opts...).ToFunc()
}

// ByRepositoryUser orders the results by the repository_user field.
func ByRepositoryUser(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldRepositoryUser, opts...).ToFunc()
}

// ByPlatform orders the results by the platform field.
func ByPlatform(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldPlatform, opts...).ToFunc()
}

// ByToken orders the results by the token field.
func ByToken(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldToken, opts...).ToFunc()
}

// ByWebhookSecret orders the results by the webhook_secret field.
func ByWebhookSecret(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldWebhookSecret, opts...).ToFunc()
}

// ByWebhookURL orders the results by the webhook_url field.
func ByWebhookURL(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldWebhookURL, opts...).ToFunc()
}

// ByCreatedBy orders the results by the created_by field.
func ByCreatedBy(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedBy, opts...).ToFunc()
}

// ByCreatedAt orders the results by the created_at field.
func ByCreatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedAt, opts...).ToFunc()
}

// ByUpdatedAt orders the results by the updated_at field.
func ByUpdatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUpdatedAt, opts...).ToFunc()
}

// ByAdminField orders the results by admin field.
func ByAdminField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newAdminStep(), sql.OrderByField(field, opts...))
	}
}

// ByUserField orders the results by user field.
func ByUserField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newUserStep(), sql.OrderByField(field, opts...))
	}
}
func newAdminStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(AdminInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2O, true, AdminTable, AdminColumn),
	)
}
func newUserStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(UserInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2O, true, UserTable, UserColumn),
	)
}
