// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/aiemployee"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/ent/types"
	"github.com/google/uuid"
)

// AIEmployeeUpdate is the builder for updating AIEmployee entities.
type AIEmployeeUpdate struct {
	config
	hooks     []Hook
	mutation  *AIEmployeeMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the AIEmployeeUpdate builder.
func (aeu *AIEmployeeUpdate) Where(ps ...predicate.AIEmployee) *AIEmployeeUpdate {
	aeu.mutation.Where(ps...)
	return aeu
}

// SetAdminID sets the "admin_id" field.
func (aeu *AIEmployeeUpdate) SetAdminID(u uuid.UUID) *AIEmployeeUpdate {
	aeu.mutation.SetAdminID(u)
	return aeu
}

// SetNillableAdminID sets the "admin_id" field if the given value is not nil.
func (aeu *AIEmployeeUpdate) SetNillableAdminID(u *uuid.UUID) *AIEmployeeUpdate {
	if u != nil {
		aeu.SetAdminID(*u)
	}
	return aeu
}

// ClearAdminID clears the value of the "admin_id" field.
func (aeu *AIEmployeeUpdate) ClearAdminID() *AIEmployeeUpdate {
	aeu.mutation.ClearAdminID()
	return aeu
}

// SetUserID sets the "user_id" field.
func (aeu *AIEmployeeUpdate) SetUserID(u uuid.UUID) *AIEmployeeUpdate {
	aeu.mutation.SetUserID(u)
	return aeu
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (aeu *AIEmployeeUpdate) SetNillableUserID(u *uuid.UUID) *AIEmployeeUpdate {
	if u != nil {
		aeu.SetUserID(*u)
	}
	return aeu
}

// ClearUserID clears the value of the "user_id" field.
func (aeu *AIEmployeeUpdate) ClearUserID() *AIEmployeeUpdate {
	aeu.mutation.ClearUserID()
	return aeu
}

// SetName sets the "name" field.
func (aeu *AIEmployeeUpdate) SetName(s string) *AIEmployeeUpdate {
	aeu.mutation.SetName(s)
	return aeu
}

// SetNillableName sets the "name" field if the given value is not nil.
func (aeu *AIEmployeeUpdate) SetNillableName(s *string) *AIEmployeeUpdate {
	if s != nil {
		aeu.SetName(*s)
	}
	return aeu
}

// SetPosition sets the "position" field.
func (aeu *AIEmployeeUpdate) SetPosition(cep consts.AIEmployeePosition) *AIEmployeeUpdate {
	aeu.mutation.SetPosition(cep)
	return aeu
}

// SetNillablePosition sets the "position" field if the given value is not nil.
func (aeu *AIEmployeeUpdate) SetNillablePosition(cep *consts.AIEmployeePosition) *AIEmployeeUpdate {
	if cep != nil {
		aeu.SetPosition(*cep)
	}
	return aeu
}

// SetRepositoryURL sets the "repository_url" field.
func (aeu *AIEmployeeUpdate) SetRepositoryURL(s string) *AIEmployeeUpdate {
	aeu.mutation.SetRepositoryURL(s)
	return aeu
}

// SetNillableRepositoryURL sets the "repository_url" field if the given value is not nil.
func (aeu *AIEmployeeUpdate) SetNillableRepositoryURL(s *string) *AIEmployeeUpdate {
	if s != nil {
		aeu.SetRepositoryURL(*s)
	}
	return aeu
}

// SetRepositoryUser sets the "repository_user" field.
func (aeu *AIEmployeeUpdate) SetRepositoryUser(s string) *AIEmployeeUpdate {
	aeu.mutation.SetRepositoryUser(s)
	return aeu
}

// SetNillableRepositoryUser sets the "repository_user" field if the given value is not nil.
func (aeu *AIEmployeeUpdate) SetNillableRepositoryUser(s *string) *AIEmployeeUpdate {
	if s != nil {
		aeu.SetRepositoryUser(*s)
	}
	return aeu
}

// SetPlatform sets the "platform" field.
func (aeu *AIEmployeeUpdate) SetPlatform(cp consts.RepoPlatform) *AIEmployeeUpdate {
	aeu.mutation.SetPlatform(cp)
	return aeu
}

// SetNillablePlatform sets the "platform" field if the given value is not nil.
func (aeu *AIEmployeeUpdate) SetNillablePlatform(cp *consts.RepoPlatform) *AIEmployeeUpdate {
	if cp != nil {
		aeu.SetPlatform(*cp)
	}
	return aeu
}

// SetToken sets the "token" field.
func (aeu *AIEmployeeUpdate) SetToken(s string) *AIEmployeeUpdate {
	aeu.mutation.SetToken(s)
	return aeu
}

// SetNillableToken sets the "token" field if the given value is not nil.
func (aeu *AIEmployeeUpdate) SetNillableToken(s *string) *AIEmployeeUpdate {
	if s != nil {
		aeu.SetToken(*s)
	}
	return aeu
}

// SetWebhookSecret sets the "webhook_secret" field.
func (aeu *AIEmployeeUpdate) SetWebhookSecret(s string) *AIEmployeeUpdate {
	aeu.mutation.SetWebhookSecret(s)
	return aeu
}

// SetNillableWebhookSecret sets the "webhook_secret" field if the given value is not nil.
func (aeu *AIEmployeeUpdate) SetNillableWebhookSecret(s *string) *AIEmployeeUpdate {
	if s != nil {
		aeu.SetWebhookSecret(*s)
	}
	return aeu
}

// SetWebhookURL sets the "webhook_url" field.
func (aeu *AIEmployeeUpdate) SetWebhookURL(s string) *AIEmployeeUpdate {
	aeu.mutation.SetWebhookURL(s)
	return aeu
}

// SetNillableWebhookURL sets the "webhook_url" field if the given value is not nil.
func (aeu *AIEmployeeUpdate) SetNillableWebhookURL(s *string) *AIEmployeeUpdate {
	if s != nil {
		aeu.SetWebhookURL(*s)
	}
	return aeu
}

// SetCreatedBy sets the "created_by" field.
func (aeu *AIEmployeeUpdate) SetCreatedBy(cb consts.CreatedBy) *AIEmployeeUpdate {
	aeu.mutation.SetCreatedBy(cb)
	return aeu
}

// SetNillableCreatedBy sets the "created_by" field if the given value is not nil.
func (aeu *AIEmployeeUpdate) SetNillableCreatedBy(cb *consts.CreatedBy) *AIEmployeeUpdate {
	if cb != nil {
		aeu.SetCreatedBy(*cb)
	}
	return aeu
}

// SetParameters sets the "parameters" field.
func (aeu *AIEmployeeUpdate) SetParameters(tep *types.AIEmployeeParam) *AIEmployeeUpdate {
	aeu.mutation.SetParameters(tep)
	return aeu
}

// SetCreatedAt sets the "created_at" field.
func (aeu *AIEmployeeUpdate) SetCreatedAt(t time.Time) *AIEmployeeUpdate {
	aeu.mutation.SetCreatedAt(t)
	return aeu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (aeu *AIEmployeeUpdate) SetNillableCreatedAt(t *time.Time) *AIEmployeeUpdate {
	if t != nil {
		aeu.SetCreatedAt(*t)
	}
	return aeu
}

// SetUpdatedAt sets the "updated_at" field.
func (aeu *AIEmployeeUpdate) SetUpdatedAt(t time.Time) *AIEmployeeUpdate {
	aeu.mutation.SetUpdatedAt(t)
	return aeu
}

// SetAdmin sets the "admin" edge to the Admin entity.
func (aeu *AIEmployeeUpdate) SetAdmin(a *Admin) *AIEmployeeUpdate {
	return aeu.SetAdminID(a.ID)
}

// SetUser sets the "user" edge to the User entity.
func (aeu *AIEmployeeUpdate) SetUser(u *User) *AIEmployeeUpdate {
	return aeu.SetUserID(u.ID)
}

// Mutation returns the AIEmployeeMutation object of the builder.
func (aeu *AIEmployeeUpdate) Mutation() *AIEmployeeMutation {
	return aeu.mutation
}

// ClearAdmin clears the "admin" edge to the Admin entity.
func (aeu *AIEmployeeUpdate) ClearAdmin() *AIEmployeeUpdate {
	aeu.mutation.ClearAdmin()
	return aeu
}

// ClearUser clears the "user" edge to the User entity.
func (aeu *AIEmployeeUpdate) ClearUser() *AIEmployeeUpdate {
	aeu.mutation.ClearUser()
	return aeu
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (aeu *AIEmployeeUpdate) Save(ctx context.Context) (int, error) {
	aeu.defaults()
	return withHooks(ctx, aeu.sqlSave, aeu.mutation, aeu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (aeu *AIEmployeeUpdate) SaveX(ctx context.Context) int {
	affected, err := aeu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (aeu *AIEmployeeUpdate) Exec(ctx context.Context) error {
	_, err := aeu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (aeu *AIEmployeeUpdate) ExecX(ctx context.Context) {
	if err := aeu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (aeu *AIEmployeeUpdate) defaults() {
	if _, ok := aeu.mutation.UpdatedAt(); !ok {
		v := aiemployee.UpdateDefaultUpdatedAt()
		aeu.mutation.SetUpdatedAt(v)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (aeu *AIEmployeeUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *AIEmployeeUpdate {
	aeu.modifiers = append(aeu.modifiers, modifiers...)
	return aeu
}

func (aeu *AIEmployeeUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(aiemployee.Table, aiemployee.Columns, sqlgraph.NewFieldSpec(aiemployee.FieldID, field.TypeUUID))
	if ps := aeu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := aeu.mutation.Name(); ok {
		_spec.SetField(aiemployee.FieldName, field.TypeString, value)
	}
	if value, ok := aeu.mutation.Position(); ok {
		_spec.SetField(aiemployee.FieldPosition, field.TypeString, value)
	}
	if value, ok := aeu.mutation.RepositoryURL(); ok {
		_spec.SetField(aiemployee.FieldRepositoryURL, field.TypeString, value)
	}
	if value, ok := aeu.mutation.RepositoryUser(); ok {
		_spec.SetField(aiemployee.FieldRepositoryUser, field.TypeString, value)
	}
	if value, ok := aeu.mutation.Platform(); ok {
		_spec.SetField(aiemployee.FieldPlatform, field.TypeString, value)
	}
	if value, ok := aeu.mutation.Token(); ok {
		_spec.SetField(aiemployee.FieldToken, field.TypeString, value)
	}
	if value, ok := aeu.mutation.WebhookSecret(); ok {
		_spec.SetField(aiemployee.FieldWebhookSecret, field.TypeString, value)
	}
	if value, ok := aeu.mutation.WebhookURL(); ok {
		_spec.SetField(aiemployee.FieldWebhookURL, field.TypeString, value)
	}
	if value, ok := aeu.mutation.CreatedBy(); ok {
		_spec.SetField(aiemployee.FieldCreatedBy, field.TypeString, value)
	}
	if value, ok := aeu.mutation.Parameters(); ok {
		_spec.SetField(aiemployee.FieldParameters, field.TypeJSON, value)
	}
	if value, ok := aeu.mutation.CreatedAt(); ok {
		_spec.SetField(aiemployee.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := aeu.mutation.UpdatedAt(); ok {
		_spec.SetField(aiemployee.FieldUpdatedAt, field.TypeTime, value)
	}
	if aeu.mutation.AdminCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   aiemployee.AdminTable,
			Columns: []string{aiemployee.AdminColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := aeu.mutation.AdminIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   aiemployee.AdminTable,
			Columns: []string{aiemployee.AdminColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if aeu.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   aiemployee.UserTable,
			Columns: []string{aiemployee.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := aeu.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   aiemployee.UserTable,
			Columns: []string{aiemployee.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(aeu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, aeu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{aiemployee.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	aeu.mutation.done = true
	return n, nil
}

// AIEmployeeUpdateOne is the builder for updating a single AIEmployee entity.
type AIEmployeeUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *AIEmployeeMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetAdminID sets the "admin_id" field.
func (aeuo *AIEmployeeUpdateOne) SetAdminID(u uuid.UUID) *AIEmployeeUpdateOne {
	aeuo.mutation.SetAdminID(u)
	return aeuo
}

// SetNillableAdminID sets the "admin_id" field if the given value is not nil.
func (aeuo *AIEmployeeUpdateOne) SetNillableAdminID(u *uuid.UUID) *AIEmployeeUpdateOne {
	if u != nil {
		aeuo.SetAdminID(*u)
	}
	return aeuo
}

// ClearAdminID clears the value of the "admin_id" field.
func (aeuo *AIEmployeeUpdateOne) ClearAdminID() *AIEmployeeUpdateOne {
	aeuo.mutation.ClearAdminID()
	return aeuo
}

// SetUserID sets the "user_id" field.
func (aeuo *AIEmployeeUpdateOne) SetUserID(u uuid.UUID) *AIEmployeeUpdateOne {
	aeuo.mutation.SetUserID(u)
	return aeuo
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (aeuo *AIEmployeeUpdateOne) SetNillableUserID(u *uuid.UUID) *AIEmployeeUpdateOne {
	if u != nil {
		aeuo.SetUserID(*u)
	}
	return aeuo
}

// ClearUserID clears the value of the "user_id" field.
func (aeuo *AIEmployeeUpdateOne) ClearUserID() *AIEmployeeUpdateOne {
	aeuo.mutation.ClearUserID()
	return aeuo
}

// SetName sets the "name" field.
func (aeuo *AIEmployeeUpdateOne) SetName(s string) *AIEmployeeUpdateOne {
	aeuo.mutation.SetName(s)
	return aeuo
}

// SetNillableName sets the "name" field if the given value is not nil.
func (aeuo *AIEmployeeUpdateOne) SetNillableName(s *string) *AIEmployeeUpdateOne {
	if s != nil {
		aeuo.SetName(*s)
	}
	return aeuo
}

// SetPosition sets the "position" field.
func (aeuo *AIEmployeeUpdateOne) SetPosition(cep consts.AIEmployeePosition) *AIEmployeeUpdateOne {
	aeuo.mutation.SetPosition(cep)
	return aeuo
}

// SetNillablePosition sets the "position" field if the given value is not nil.
func (aeuo *AIEmployeeUpdateOne) SetNillablePosition(cep *consts.AIEmployeePosition) *AIEmployeeUpdateOne {
	if cep != nil {
		aeuo.SetPosition(*cep)
	}
	return aeuo
}

// SetRepositoryURL sets the "repository_url" field.
func (aeuo *AIEmployeeUpdateOne) SetRepositoryURL(s string) *AIEmployeeUpdateOne {
	aeuo.mutation.SetRepositoryURL(s)
	return aeuo
}

// SetNillableRepositoryURL sets the "repository_url" field if the given value is not nil.
func (aeuo *AIEmployeeUpdateOne) SetNillableRepositoryURL(s *string) *AIEmployeeUpdateOne {
	if s != nil {
		aeuo.SetRepositoryURL(*s)
	}
	return aeuo
}

// SetRepositoryUser sets the "repository_user" field.
func (aeuo *AIEmployeeUpdateOne) SetRepositoryUser(s string) *AIEmployeeUpdateOne {
	aeuo.mutation.SetRepositoryUser(s)
	return aeuo
}

// SetNillableRepositoryUser sets the "repository_user" field if the given value is not nil.
func (aeuo *AIEmployeeUpdateOne) SetNillableRepositoryUser(s *string) *AIEmployeeUpdateOne {
	if s != nil {
		aeuo.SetRepositoryUser(*s)
	}
	return aeuo
}

// SetPlatform sets the "platform" field.
func (aeuo *AIEmployeeUpdateOne) SetPlatform(cp consts.RepoPlatform) *AIEmployeeUpdateOne {
	aeuo.mutation.SetPlatform(cp)
	return aeuo
}

// SetNillablePlatform sets the "platform" field if the given value is not nil.
func (aeuo *AIEmployeeUpdateOne) SetNillablePlatform(cp *consts.RepoPlatform) *AIEmployeeUpdateOne {
	if cp != nil {
		aeuo.SetPlatform(*cp)
	}
	return aeuo
}

// SetToken sets the "token" field.
func (aeuo *AIEmployeeUpdateOne) SetToken(s string) *AIEmployeeUpdateOne {
	aeuo.mutation.SetToken(s)
	return aeuo
}

// SetNillableToken sets the "token" field if the given value is not nil.
func (aeuo *AIEmployeeUpdateOne) SetNillableToken(s *string) *AIEmployeeUpdateOne {
	if s != nil {
		aeuo.SetToken(*s)
	}
	return aeuo
}

// SetWebhookSecret sets the "webhook_secret" field.
func (aeuo *AIEmployeeUpdateOne) SetWebhookSecret(s string) *AIEmployeeUpdateOne {
	aeuo.mutation.SetWebhookSecret(s)
	return aeuo
}

// SetNillableWebhookSecret sets the "webhook_secret" field if the given value is not nil.
func (aeuo *AIEmployeeUpdateOne) SetNillableWebhookSecret(s *string) *AIEmployeeUpdateOne {
	if s != nil {
		aeuo.SetWebhookSecret(*s)
	}
	return aeuo
}

// SetWebhookURL sets the "webhook_url" field.
func (aeuo *AIEmployeeUpdateOne) SetWebhookURL(s string) *AIEmployeeUpdateOne {
	aeuo.mutation.SetWebhookURL(s)
	return aeuo
}

// SetNillableWebhookURL sets the "webhook_url" field if the given value is not nil.
func (aeuo *AIEmployeeUpdateOne) SetNillableWebhookURL(s *string) *AIEmployeeUpdateOne {
	if s != nil {
		aeuo.SetWebhookURL(*s)
	}
	return aeuo
}

// SetCreatedBy sets the "created_by" field.
func (aeuo *AIEmployeeUpdateOne) SetCreatedBy(cb consts.CreatedBy) *AIEmployeeUpdateOne {
	aeuo.mutation.SetCreatedBy(cb)
	return aeuo
}

// SetNillableCreatedBy sets the "created_by" field if the given value is not nil.
func (aeuo *AIEmployeeUpdateOne) SetNillableCreatedBy(cb *consts.CreatedBy) *AIEmployeeUpdateOne {
	if cb != nil {
		aeuo.SetCreatedBy(*cb)
	}
	return aeuo
}

// SetParameters sets the "parameters" field.
func (aeuo *AIEmployeeUpdateOne) SetParameters(tep *types.AIEmployeeParam) *AIEmployeeUpdateOne {
	aeuo.mutation.SetParameters(tep)
	return aeuo
}

// SetCreatedAt sets the "created_at" field.
func (aeuo *AIEmployeeUpdateOne) SetCreatedAt(t time.Time) *AIEmployeeUpdateOne {
	aeuo.mutation.SetCreatedAt(t)
	return aeuo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (aeuo *AIEmployeeUpdateOne) SetNillableCreatedAt(t *time.Time) *AIEmployeeUpdateOne {
	if t != nil {
		aeuo.SetCreatedAt(*t)
	}
	return aeuo
}

// SetUpdatedAt sets the "updated_at" field.
func (aeuo *AIEmployeeUpdateOne) SetUpdatedAt(t time.Time) *AIEmployeeUpdateOne {
	aeuo.mutation.SetUpdatedAt(t)
	return aeuo
}

// SetAdmin sets the "admin" edge to the Admin entity.
func (aeuo *AIEmployeeUpdateOne) SetAdmin(a *Admin) *AIEmployeeUpdateOne {
	return aeuo.SetAdminID(a.ID)
}

// SetUser sets the "user" edge to the User entity.
func (aeuo *AIEmployeeUpdateOne) SetUser(u *User) *AIEmployeeUpdateOne {
	return aeuo.SetUserID(u.ID)
}

// Mutation returns the AIEmployeeMutation object of the builder.
func (aeuo *AIEmployeeUpdateOne) Mutation() *AIEmployeeMutation {
	return aeuo.mutation
}

// ClearAdmin clears the "admin" edge to the Admin entity.
func (aeuo *AIEmployeeUpdateOne) ClearAdmin() *AIEmployeeUpdateOne {
	aeuo.mutation.ClearAdmin()
	return aeuo
}

// ClearUser clears the "user" edge to the User entity.
func (aeuo *AIEmployeeUpdateOne) ClearUser() *AIEmployeeUpdateOne {
	aeuo.mutation.ClearUser()
	return aeuo
}

// Where appends a list predicates to the AIEmployeeUpdate builder.
func (aeuo *AIEmployeeUpdateOne) Where(ps ...predicate.AIEmployee) *AIEmployeeUpdateOne {
	aeuo.mutation.Where(ps...)
	return aeuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (aeuo *AIEmployeeUpdateOne) Select(field string, fields ...string) *AIEmployeeUpdateOne {
	aeuo.fields = append([]string{field}, fields...)
	return aeuo
}

// Save executes the query and returns the updated AIEmployee entity.
func (aeuo *AIEmployeeUpdateOne) Save(ctx context.Context) (*AIEmployee, error) {
	aeuo.defaults()
	return withHooks(ctx, aeuo.sqlSave, aeuo.mutation, aeuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (aeuo *AIEmployeeUpdateOne) SaveX(ctx context.Context) *AIEmployee {
	node, err := aeuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (aeuo *AIEmployeeUpdateOne) Exec(ctx context.Context) error {
	_, err := aeuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (aeuo *AIEmployeeUpdateOne) ExecX(ctx context.Context) {
	if err := aeuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (aeuo *AIEmployeeUpdateOne) defaults() {
	if _, ok := aeuo.mutation.UpdatedAt(); !ok {
		v := aiemployee.UpdateDefaultUpdatedAt()
		aeuo.mutation.SetUpdatedAt(v)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (aeuo *AIEmployeeUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *AIEmployeeUpdateOne {
	aeuo.modifiers = append(aeuo.modifiers, modifiers...)
	return aeuo
}

func (aeuo *AIEmployeeUpdateOne) sqlSave(ctx context.Context) (_node *AIEmployee, err error) {
	_spec := sqlgraph.NewUpdateSpec(aiemployee.Table, aiemployee.Columns, sqlgraph.NewFieldSpec(aiemployee.FieldID, field.TypeUUID))
	id, ok := aeuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "AIEmployee.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := aeuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, aiemployee.FieldID)
		for _, f := range fields {
			if !aiemployee.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != aiemployee.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := aeuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := aeuo.mutation.Name(); ok {
		_spec.SetField(aiemployee.FieldName, field.TypeString, value)
	}
	if value, ok := aeuo.mutation.Position(); ok {
		_spec.SetField(aiemployee.FieldPosition, field.TypeString, value)
	}
	if value, ok := aeuo.mutation.RepositoryURL(); ok {
		_spec.SetField(aiemployee.FieldRepositoryURL, field.TypeString, value)
	}
	if value, ok := aeuo.mutation.RepositoryUser(); ok {
		_spec.SetField(aiemployee.FieldRepositoryUser, field.TypeString, value)
	}
	if value, ok := aeuo.mutation.Platform(); ok {
		_spec.SetField(aiemployee.FieldPlatform, field.TypeString, value)
	}
	if value, ok := aeuo.mutation.Token(); ok {
		_spec.SetField(aiemployee.FieldToken, field.TypeString, value)
	}
	if value, ok := aeuo.mutation.WebhookSecret(); ok {
		_spec.SetField(aiemployee.FieldWebhookSecret, field.TypeString, value)
	}
	if value, ok := aeuo.mutation.WebhookURL(); ok {
		_spec.SetField(aiemployee.FieldWebhookURL, field.TypeString, value)
	}
	if value, ok := aeuo.mutation.CreatedBy(); ok {
		_spec.SetField(aiemployee.FieldCreatedBy, field.TypeString, value)
	}
	if value, ok := aeuo.mutation.Parameters(); ok {
		_spec.SetField(aiemployee.FieldParameters, field.TypeJSON, value)
	}
	if value, ok := aeuo.mutation.CreatedAt(); ok {
		_spec.SetField(aiemployee.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := aeuo.mutation.UpdatedAt(); ok {
		_spec.SetField(aiemployee.FieldUpdatedAt, field.TypeTime, value)
	}
	if aeuo.mutation.AdminCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   aiemployee.AdminTable,
			Columns: []string{aiemployee.AdminColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := aeuo.mutation.AdminIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   aiemployee.AdminTable,
			Columns: []string{aiemployee.AdminColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(admin.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if aeuo.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   aiemployee.UserTable,
			Columns: []string{aiemployee.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := aeuo.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   aiemployee.UserTable,
			Columns: []string{aiemployee.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(aeuo.modifiers...)
	_node = &AIEmployee{config: aeuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, aeuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{aiemployee.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	aeuo.mutation.done = true
	return _node, nil
}
