// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/db/aitask"
	"github.com/google/uuid"
)

// AITask is the model entity for the AITask schema.
type AITask struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// EmployeeID holds the value of the "employee_id" field.
	EmployeeID uuid.UUID `json:"employee_id,omitempty"`
	// Status holds the value of the "status" field.
	Status string `json:"status,omitempty"`
	// Output holds the value of the "output" field.
	Output *string `json:"output,omitempty"`
	// Logs holds the value of the "logs" field.
	Logs *string `json:"logs,omitempty"`
	// ErrorMessage holds the value of the "error_message" field.
	ErrorMessage *string `json:"error_message,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt    time.Time `json:"updated_at,omitempty"`
	selectValues sql.SelectValues
}

// scanValues returns the types for scanning values from sql.Rows.
func (*AITask) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case aitask.FieldStatus, aitask.FieldOutput, aitask.FieldLogs, aitask.FieldErrorMessage:
			values[i] = new(sql.NullString)
		case aitask.FieldCreatedAt, aitask.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		case aitask.FieldID, aitask.FieldEmployeeID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the AITask fields.
func (at *AITask) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case aitask.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				at.ID = *value
			}
		case aitask.FieldEmployeeID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field employee_id", values[i])
			} else if value != nil {
				at.EmployeeID = *value
			}
		case aitask.FieldStatus:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field status", values[i])
			} else if value.Valid {
				at.Status = value.String
			}
		case aitask.FieldOutput:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field output", values[i])
			} else if value.Valid {
				at.Output = new(string)
				*at.Output = value.String
			}
		case aitask.FieldLogs:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field logs", values[i])
			} else if value.Valid {
				at.Logs = new(string)
				*at.Logs = value.String
			}
		case aitask.FieldErrorMessage:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field error_message", values[i])
			} else if value.Valid {
				at.ErrorMessage = new(string)
				*at.ErrorMessage = value.String
			}
		case aitask.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				at.CreatedAt = value.Time
			}
		case aitask.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				at.UpdatedAt = value.Time
			}
		default:
			at.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the AITask.
// This includes values selected through modifiers, order, etc.
func (at *AITask) Value(name string) (ent.Value, error) {
	return at.selectValues.Get(name)
}

// Update returns a builder for updating this AITask.
// Note that you need to call AITask.Unwrap() before calling this method if this AITask
// was returned from a transaction, and the transaction was committed or rolled back.
func (at *AITask) Update() *AITaskUpdateOne {
	return NewAITaskClient(at.config).UpdateOne(at)
}

// Unwrap unwraps the AITask entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (at *AITask) Unwrap() *AITask {
	_tx, ok := at.config.driver.(*txDriver)
	if !ok {
		panic("db: AITask is not a transactional entity")
	}
	at.config.driver = _tx.drv
	return at
}

// String implements the fmt.Stringer.
func (at *AITask) String() string {
	var builder strings.Builder
	builder.WriteString("AITask(")
	builder.WriteString(fmt.Sprintf("id=%v, ", at.ID))
	builder.WriteString("employee_id=")
	builder.WriteString(fmt.Sprintf("%v", at.EmployeeID))
	builder.WriteString(", ")
	builder.WriteString("status=")
	builder.WriteString(at.Status)
	builder.WriteString(", ")
	if v := at.Output; v != nil {
		builder.WriteString("output=")
		builder.WriteString(*v)
	}
	builder.WriteString(", ")
	if v := at.Logs; v != nil {
		builder.WriteString("logs=")
		builder.WriteString(*v)
	}
	builder.WriteString(", ")
	if v := at.ErrorMessage; v != nil {
		builder.WriteString("error_message=")
		builder.WriteString(*v)
	}
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(at.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(at.UpdatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// AITasks is a parsable slice of AITask.
type AITasks []*AITask
