// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/aitask"
	"github.com/google/uuid"
)

// AITaskCreate is the builder for creating a AITask entity.
type AITaskCreate struct {
	config
	mutation *AITaskMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetEmployeeID sets the "employee_id" field.
func (atc *AITaskCreate) SetEmployeeID(u uuid.UUID) *AITaskCreate {
	atc.mutation.SetEmployeeID(u)
	return atc
}

// SetStatus sets the "status" field.
func (atc *AITaskCreate) SetStatus(s string) *AITaskCreate {
	atc.mutation.SetStatus(s)
	return atc
}

// SetNillableStatus sets the "status" field if the given value is not nil.
func (atc *AITaskCreate) SetNillableStatus(s *string) *AITaskCreate {
	if s != nil {
		atc.SetStatus(*s)
	}
	return atc
}

// SetOutput sets the "output" field.
func (atc *AITaskCreate) SetOutput(s string) *AITaskCreate {
	atc.mutation.SetOutput(s)
	return atc
}

// SetNillableOutput sets the "output" field if the given value is not nil.
func (atc *AITaskCreate) SetNillableOutput(s *string) *AITaskCreate {
	if s != nil {
		atc.SetOutput(*s)
	}
	return atc
}

// SetLogs sets the "logs" field.
func (atc *AITaskCreate) SetLogs(s string) *AITaskCreate {
	atc.mutation.SetLogs(s)
	return atc
}

// SetNillableLogs sets the "logs" field if the given value is not nil.
func (atc *AITaskCreate) SetNillableLogs(s *string) *AITaskCreate {
	if s != nil {
		atc.SetLogs(*s)
	}
	return atc
}

// SetErrorMessage sets the "error_message" field.
func (atc *AITaskCreate) SetErrorMessage(s string) *AITaskCreate {
	atc.mutation.SetErrorMessage(s)
	return atc
}

// SetNillableErrorMessage sets the "error_message" field if the given value is not nil.
func (atc *AITaskCreate) SetNillableErrorMessage(s *string) *AITaskCreate {
	if s != nil {
		atc.SetErrorMessage(*s)
	}
	return atc
}

// SetCreatedAt sets the "created_at" field.
func (atc *AITaskCreate) SetCreatedAt(t time.Time) *AITaskCreate {
	atc.mutation.SetCreatedAt(t)
	return atc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (atc *AITaskCreate) SetNillableCreatedAt(t *time.Time) *AITaskCreate {
	if t != nil {
		atc.SetCreatedAt(*t)
	}
	return atc
}

// SetUpdatedAt sets the "updated_at" field.
func (atc *AITaskCreate) SetUpdatedAt(t time.Time) *AITaskCreate {
	atc.mutation.SetUpdatedAt(t)
	return atc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (atc *AITaskCreate) SetNillableUpdatedAt(t *time.Time) *AITaskCreate {
	if t != nil {
		atc.SetUpdatedAt(*t)
	}
	return atc
}

// SetID sets the "id" field.
func (atc *AITaskCreate) SetID(u uuid.UUID) *AITaskCreate {
	atc.mutation.SetID(u)
	return atc
}

// Mutation returns the AITaskMutation object of the builder.
func (atc *AITaskCreate) Mutation() *AITaskMutation {
	return atc.mutation
}

// Save creates the AITask in the database.
func (atc *AITaskCreate) Save(ctx context.Context) (*AITask, error) {
	atc.defaults()
	return withHooks(ctx, atc.sqlSave, atc.mutation, atc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (atc *AITaskCreate) SaveX(ctx context.Context) *AITask {
	v, err := atc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (atc *AITaskCreate) Exec(ctx context.Context) error {
	_, err := atc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (atc *AITaskCreate) ExecX(ctx context.Context) {
	if err := atc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (atc *AITaskCreate) defaults() {
	if _, ok := atc.mutation.Status(); !ok {
		v := aitask.DefaultStatus
		atc.mutation.SetStatus(v)
	}
	if _, ok := atc.mutation.CreatedAt(); !ok {
		v := aitask.DefaultCreatedAt()
		atc.mutation.SetCreatedAt(v)
	}
	if _, ok := atc.mutation.UpdatedAt(); !ok {
		v := aitask.DefaultUpdatedAt()
		atc.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (atc *AITaskCreate) check() error {
	if _, ok := atc.mutation.EmployeeID(); !ok {
		return &ValidationError{Name: "employee_id", err: errors.New(`db: missing required field "AITask.employee_id"`)}
	}
	if _, ok := atc.mutation.Status(); !ok {
		return &ValidationError{Name: "status", err: errors.New(`db: missing required field "AITask.status"`)}
	}
	if _, ok := atc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "AITask.created_at"`)}
	}
	if _, ok := atc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`db: missing required field "AITask.updated_at"`)}
	}
	return nil
}

func (atc *AITaskCreate) sqlSave(ctx context.Context) (*AITask, error) {
	if err := atc.check(); err != nil {
		return nil, err
	}
	_node, _spec := atc.createSpec()
	if err := sqlgraph.CreateNode(ctx, atc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	atc.mutation.id = &_node.ID
	atc.mutation.done = true
	return _node, nil
}

func (atc *AITaskCreate) createSpec() (*AITask, *sqlgraph.CreateSpec) {
	var (
		_node = &AITask{config: atc.config}
		_spec = sqlgraph.NewCreateSpec(aitask.Table, sqlgraph.NewFieldSpec(aitask.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = atc.conflict
	if id, ok := atc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := atc.mutation.EmployeeID(); ok {
		_spec.SetField(aitask.FieldEmployeeID, field.TypeUUID, value)
		_node.EmployeeID = value
	}
	if value, ok := atc.mutation.Status(); ok {
		_spec.SetField(aitask.FieldStatus, field.TypeString, value)
		_node.Status = value
	}
	if value, ok := atc.mutation.Output(); ok {
		_spec.SetField(aitask.FieldOutput, field.TypeString, value)
		_node.Output = &value
	}
	if value, ok := atc.mutation.Logs(); ok {
		_spec.SetField(aitask.FieldLogs, field.TypeString, value)
		_node.Logs = &value
	}
	if value, ok := atc.mutation.ErrorMessage(); ok {
		_spec.SetField(aitask.FieldErrorMessage, field.TypeString, value)
		_node.ErrorMessage = &value
	}
	if value, ok := atc.mutation.CreatedAt(); ok {
		_spec.SetField(aitask.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := atc.mutation.UpdatedAt(); ok {
		_spec.SetField(aitask.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.AITask.Create().
//		SetEmployeeID(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.AITaskUpsert) {
//			SetEmployeeID(v+v).
//		}).
//		Exec(ctx)
func (atc *AITaskCreate) OnConflict(opts ...sql.ConflictOption) *AITaskUpsertOne {
	atc.conflict = opts
	return &AITaskUpsertOne{
		create: atc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.AITask.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (atc *AITaskCreate) OnConflictColumns(columns ...string) *AITaskUpsertOne {
	atc.conflict = append(atc.conflict, sql.ConflictColumns(columns...))
	return &AITaskUpsertOne{
		create: atc,
	}
}

type (
	// AITaskUpsertOne is the builder for "upsert"-ing
	//  one AITask node.
	AITaskUpsertOne struct {
		create *AITaskCreate
	}

	// AITaskUpsert is the "OnConflict" setter.
	AITaskUpsert struct {
		*sql.UpdateSet
	}
)

// SetEmployeeID sets the "employee_id" field.
func (u *AITaskUpsert) SetEmployeeID(v uuid.UUID) *AITaskUpsert {
	u.Set(aitask.FieldEmployeeID, v)
	return u
}

// UpdateEmployeeID sets the "employee_id" field to the value that was provided on create.
func (u *AITaskUpsert) UpdateEmployeeID() *AITaskUpsert {
	u.SetExcluded(aitask.FieldEmployeeID)
	return u
}

// SetStatus sets the "status" field.
func (u *AITaskUpsert) SetStatus(v string) *AITaskUpsert {
	u.Set(aitask.FieldStatus, v)
	return u
}

// UpdateStatus sets the "status" field to the value that was provided on create.
func (u *AITaskUpsert) UpdateStatus() *AITaskUpsert {
	u.SetExcluded(aitask.FieldStatus)
	return u
}

// SetOutput sets the "output" field.
func (u *AITaskUpsert) SetOutput(v string) *AITaskUpsert {
	u.Set(aitask.FieldOutput, v)
	return u
}

// UpdateOutput sets the "output" field to the value that was provided on create.
func (u *AITaskUpsert) UpdateOutput() *AITaskUpsert {
	u.SetExcluded(aitask.FieldOutput)
	return u
}

// ClearOutput clears the value of the "output" field.
func (u *AITaskUpsert) ClearOutput() *AITaskUpsert {
	u.SetNull(aitask.FieldOutput)
	return u
}

// SetLogs sets the "logs" field.
func (u *AITaskUpsert) SetLogs(v string) *AITaskUpsert {
	u.Set(aitask.FieldLogs, v)
	return u
}

// UpdateLogs sets the "logs" field to the value that was provided on create.
func (u *AITaskUpsert) UpdateLogs() *AITaskUpsert {
	u.SetExcluded(aitask.FieldLogs)
	return u
}

// ClearLogs clears the value of the "logs" field.
func (u *AITaskUpsert) ClearLogs() *AITaskUpsert {
	u.SetNull(aitask.FieldLogs)
	return u
}

// SetErrorMessage sets the "error_message" field.
func (u *AITaskUpsert) SetErrorMessage(v string) *AITaskUpsert {
	u.Set(aitask.FieldErrorMessage, v)
	return u
}

// UpdateErrorMessage sets the "error_message" field to the value that was provided on create.
func (u *AITaskUpsert) UpdateErrorMessage() *AITaskUpsert {
	u.SetExcluded(aitask.FieldErrorMessage)
	return u
}

// ClearErrorMessage clears the value of the "error_message" field.
func (u *AITaskUpsert) ClearErrorMessage() *AITaskUpsert {
	u.SetNull(aitask.FieldErrorMessage)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *AITaskUpsert) SetCreatedAt(v time.Time) *AITaskUpsert {
	u.Set(aitask.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *AITaskUpsert) UpdateCreatedAt() *AITaskUpsert {
	u.SetExcluded(aitask.FieldCreatedAt)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *AITaskUpsert) SetUpdatedAt(v time.Time) *AITaskUpsert {
	u.Set(aitask.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *AITaskUpsert) UpdateUpdatedAt() *AITaskUpsert {
	u.SetExcluded(aitask.FieldUpdatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.AITask.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(aitask.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *AITaskUpsertOne) UpdateNewValues() *AITaskUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(aitask.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.AITask.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *AITaskUpsertOne) Ignore() *AITaskUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *AITaskUpsertOne) DoNothing() *AITaskUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the AITaskCreate.OnConflict
// documentation for more info.
func (u *AITaskUpsertOne) Update(set func(*AITaskUpsert)) *AITaskUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&AITaskUpsert{UpdateSet: update})
	}))
	return u
}

// SetEmployeeID sets the "employee_id" field.
func (u *AITaskUpsertOne) SetEmployeeID(v uuid.UUID) *AITaskUpsertOne {
	return u.Update(func(s *AITaskUpsert) {
		s.SetEmployeeID(v)
	})
}

// UpdateEmployeeID sets the "employee_id" field to the value that was provided on create.
func (u *AITaskUpsertOne) UpdateEmployeeID() *AITaskUpsertOne {
	return u.Update(func(s *AITaskUpsert) {
		s.UpdateEmployeeID()
	})
}

// SetStatus sets the "status" field.
func (u *AITaskUpsertOne) SetStatus(v string) *AITaskUpsertOne {
	return u.Update(func(s *AITaskUpsert) {
		s.SetStatus(v)
	})
}

// UpdateStatus sets the "status" field to the value that was provided on create.
func (u *AITaskUpsertOne) UpdateStatus() *AITaskUpsertOne {
	return u.Update(func(s *AITaskUpsert) {
		s.UpdateStatus()
	})
}

// SetOutput sets the "output" field.
func (u *AITaskUpsertOne) SetOutput(v string) *AITaskUpsertOne {
	return u.Update(func(s *AITaskUpsert) {
		s.SetOutput(v)
	})
}

// UpdateOutput sets the "output" field to the value that was provided on create.
func (u *AITaskUpsertOne) UpdateOutput() *AITaskUpsertOne {
	return u.Update(func(s *AITaskUpsert) {
		s.UpdateOutput()
	})
}

// ClearOutput clears the value of the "output" field.
func (u *AITaskUpsertOne) ClearOutput() *AITaskUpsertOne {
	return u.Update(func(s *AITaskUpsert) {
		s.ClearOutput()
	})
}

// SetLogs sets the "logs" field.
func (u *AITaskUpsertOne) SetLogs(v string) *AITaskUpsertOne {
	return u.Update(func(s *AITaskUpsert) {
		s.SetLogs(v)
	})
}

// UpdateLogs sets the "logs" field to the value that was provided on create.
func (u *AITaskUpsertOne) UpdateLogs() *AITaskUpsertOne {
	return u.Update(func(s *AITaskUpsert) {
		s.UpdateLogs()
	})
}

// ClearLogs clears the value of the "logs" field.
func (u *AITaskUpsertOne) ClearLogs() *AITaskUpsertOne {
	return u.Update(func(s *AITaskUpsert) {
		s.ClearLogs()
	})
}

// SetErrorMessage sets the "error_message" field.
func (u *AITaskUpsertOne) SetErrorMessage(v string) *AITaskUpsertOne {
	return u.Update(func(s *AITaskUpsert) {
		s.SetErrorMessage(v)
	})
}

// UpdateErrorMessage sets the "error_message" field to the value that was provided on create.
func (u *AITaskUpsertOne) UpdateErrorMessage() *AITaskUpsertOne {
	return u.Update(func(s *AITaskUpsert) {
		s.UpdateErrorMessage()
	})
}

// ClearErrorMessage clears the value of the "error_message" field.
func (u *AITaskUpsertOne) ClearErrorMessage() *AITaskUpsertOne {
	return u.Update(func(s *AITaskUpsert) {
		s.ClearErrorMessage()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *AITaskUpsertOne) SetCreatedAt(v time.Time) *AITaskUpsertOne {
	return u.Update(func(s *AITaskUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *AITaskUpsertOne) UpdateCreatedAt() *AITaskUpsertOne {
	return u.Update(func(s *AITaskUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *AITaskUpsertOne) SetUpdatedAt(v time.Time) *AITaskUpsertOne {
	return u.Update(func(s *AITaskUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *AITaskUpsertOne) UpdateUpdatedAt() *AITaskUpsertOne {
	return u.Update(func(s *AITaskUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *AITaskUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for AITaskCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *AITaskUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *AITaskUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: AITaskUpsertOne.ID is not supported by MySQL driver. Use AITaskUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *AITaskUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// AITaskCreateBulk is the builder for creating many AITask entities in bulk.
type AITaskCreateBulk struct {
	config
	err      error
	builders []*AITaskCreate
	conflict []sql.ConflictOption
}

// Save creates the AITask entities in the database.
func (atcb *AITaskCreateBulk) Save(ctx context.Context) ([]*AITask, error) {
	if atcb.err != nil {
		return nil, atcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(atcb.builders))
	nodes := make([]*AITask, len(atcb.builders))
	mutators := make([]Mutator, len(atcb.builders))
	for i := range atcb.builders {
		func(i int, root context.Context) {
			builder := atcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*AITaskMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, atcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = atcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, atcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, atcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (atcb *AITaskCreateBulk) SaveX(ctx context.Context) []*AITask {
	v, err := atcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (atcb *AITaskCreateBulk) Exec(ctx context.Context) error {
	_, err := atcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (atcb *AITaskCreateBulk) ExecX(ctx context.Context) {
	if err := atcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.AITask.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.AITaskUpsert) {
//			SetEmployeeID(v+v).
//		}).
//		Exec(ctx)
func (atcb *AITaskCreateBulk) OnConflict(opts ...sql.ConflictOption) *AITaskUpsertBulk {
	atcb.conflict = opts
	return &AITaskUpsertBulk{
		create: atcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.AITask.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (atcb *AITaskCreateBulk) OnConflictColumns(columns ...string) *AITaskUpsertBulk {
	atcb.conflict = append(atcb.conflict, sql.ConflictColumns(columns...))
	return &AITaskUpsertBulk{
		create: atcb,
	}
}

// AITaskUpsertBulk is the builder for "upsert"-ing
// a bulk of AITask nodes.
type AITaskUpsertBulk struct {
	create *AITaskCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.AITask.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(aitask.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *AITaskUpsertBulk) UpdateNewValues() *AITaskUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(aitask.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.AITask.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *AITaskUpsertBulk) Ignore() *AITaskUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *AITaskUpsertBulk) DoNothing() *AITaskUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the AITaskCreateBulk.OnConflict
// documentation for more info.
func (u *AITaskUpsertBulk) Update(set func(*AITaskUpsert)) *AITaskUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&AITaskUpsert{UpdateSet: update})
	}))
	return u
}

// SetEmployeeID sets the "employee_id" field.
func (u *AITaskUpsertBulk) SetEmployeeID(v uuid.UUID) *AITaskUpsertBulk {
	return u.Update(func(s *AITaskUpsert) {
		s.SetEmployeeID(v)
	})
}

// UpdateEmployeeID sets the "employee_id" field to the value that was provided on create.
func (u *AITaskUpsertBulk) UpdateEmployeeID() *AITaskUpsertBulk {
	return u.Update(func(s *AITaskUpsert) {
		s.UpdateEmployeeID()
	})
}

// SetStatus sets the "status" field.
func (u *AITaskUpsertBulk) SetStatus(v string) *AITaskUpsertBulk {
	return u.Update(func(s *AITaskUpsert) {
		s.SetStatus(v)
	})
}

// UpdateStatus sets the "status" field to the value that was provided on create.
func (u *AITaskUpsertBulk) UpdateStatus() *AITaskUpsertBulk {
	return u.Update(func(s *AITaskUpsert) {
		s.UpdateStatus()
	})
}

// SetOutput sets the "output" field.
func (u *AITaskUpsertBulk) SetOutput(v string) *AITaskUpsertBulk {
	return u.Update(func(s *AITaskUpsert) {
		s.SetOutput(v)
	})
}

// UpdateOutput sets the "output" field to the value that was provided on create.
func (u *AITaskUpsertBulk) UpdateOutput() *AITaskUpsertBulk {
	return u.Update(func(s *AITaskUpsert) {
		s.UpdateOutput()
	})
}

// ClearOutput clears the value of the "output" field.
func (u *AITaskUpsertBulk) ClearOutput() *AITaskUpsertBulk {
	return u.Update(func(s *AITaskUpsert) {
		s.ClearOutput()
	})
}

// SetLogs sets the "logs" field.
func (u *AITaskUpsertBulk) SetLogs(v string) *AITaskUpsertBulk {
	return u.Update(func(s *AITaskUpsert) {
		s.SetLogs(v)
	})
}

// UpdateLogs sets the "logs" field to the value that was provided on create.
func (u *AITaskUpsertBulk) UpdateLogs() *AITaskUpsertBulk {
	return u.Update(func(s *AITaskUpsert) {
		s.UpdateLogs()
	})
}

// ClearLogs clears the value of the "logs" field.
func (u *AITaskUpsertBulk) ClearLogs() *AITaskUpsertBulk {
	return u.Update(func(s *AITaskUpsert) {
		s.ClearLogs()
	})
}

// SetErrorMessage sets the "error_message" field.
func (u *AITaskUpsertBulk) SetErrorMessage(v string) *AITaskUpsertBulk {
	return u.Update(func(s *AITaskUpsert) {
		s.SetErrorMessage(v)
	})
}

// UpdateErrorMessage sets the "error_message" field to the value that was provided on create.
func (u *AITaskUpsertBulk) UpdateErrorMessage() *AITaskUpsertBulk {
	return u.Update(func(s *AITaskUpsert) {
		s.UpdateErrorMessage()
	})
}

// ClearErrorMessage clears the value of the "error_message" field.
func (u *AITaskUpsertBulk) ClearErrorMessage() *AITaskUpsertBulk {
	return u.Update(func(s *AITaskUpsert) {
		s.ClearErrorMessage()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *AITaskUpsertBulk) SetCreatedAt(v time.Time) *AITaskUpsertBulk {
	return u.Update(func(s *AITaskUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *AITaskUpsertBulk) UpdateCreatedAt() *AITaskUpsertBulk {
	return u.Update(func(s *AITaskUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *AITaskUpsertBulk) SetUpdatedAt(v time.Time) *AITaskUpsertBulk {
	return u.Update(func(s *AITaskUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *AITaskUpsertBulk) UpdateUpdatedAt() *AITaskUpsertBulk {
	return u.Update(func(s *AITaskUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *AITaskUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the AITaskCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for AITaskCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *AITaskUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
