// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/aitask"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/google/uuid"
)

// AITaskUpdate is the builder for updating AITask entities.
type AITaskUpdate struct {
	config
	hooks     []Hook
	mutation  *AITaskMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the AITaskUpdate builder.
func (atu *AITaskUpdate) Where(ps ...predicate.AITask) *AITaskUpdate {
	atu.mutation.Where(ps...)
	return atu
}

// SetEmployeeID sets the "employee_id" field.
func (atu *AITaskUpdate) SetEmployeeID(u uuid.UUID) *AITaskUpdate {
	atu.mutation.SetEmployeeID(u)
	return atu
}

// SetNillableEmployeeID sets the "employee_id" field if the given value is not nil.
func (atu *AITaskUpdate) SetNillableEmployeeID(u *uuid.UUID) *AITaskUpdate {
	if u != nil {
		atu.SetEmployeeID(*u)
	}
	return atu
}

// SetStatus sets the "status" field.
func (atu *AITaskUpdate) SetStatus(s string) *AITaskUpdate {
	atu.mutation.SetStatus(s)
	return atu
}

// SetNillableStatus sets the "status" field if the given value is not nil.
func (atu *AITaskUpdate) SetNillableStatus(s *string) *AITaskUpdate {
	if s != nil {
		atu.SetStatus(*s)
	}
	return atu
}

// SetOutput sets the "output" field.
func (atu *AITaskUpdate) SetOutput(s string) *AITaskUpdate {
	atu.mutation.SetOutput(s)
	return atu
}

// SetNillableOutput sets the "output" field if the given value is not nil.
func (atu *AITaskUpdate) SetNillableOutput(s *string) *AITaskUpdate {
	if s != nil {
		atu.SetOutput(*s)
	}
	return atu
}

// ClearOutput clears the value of the "output" field.
func (atu *AITaskUpdate) ClearOutput() *AITaskUpdate {
	atu.mutation.ClearOutput()
	return atu
}

// SetLogs sets the "logs" field.
func (atu *AITaskUpdate) SetLogs(s string) *AITaskUpdate {
	atu.mutation.SetLogs(s)
	return atu
}

// SetNillableLogs sets the "logs" field if the given value is not nil.
func (atu *AITaskUpdate) SetNillableLogs(s *string) *AITaskUpdate {
	if s != nil {
		atu.SetLogs(*s)
	}
	return atu
}

// ClearLogs clears the value of the "logs" field.
func (atu *AITaskUpdate) ClearLogs() *AITaskUpdate {
	atu.mutation.ClearLogs()
	return atu
}

// SetErrorMessage sets the "error_message" field.
func (atu *AITaskUpdate) SetErrorMessage(s string) *AITaskUpdate {
	atu.mutation.SetErrorMessage(s)
	return atu
}

// SetNillableErrorMessage sets the "error_message" field if the given value is not nil.
func (atu *AITaskUpdate) SetNillableErrorMessage(s *string) *AITaskUpdate {
	if s != nil {
		atu.SetErrorMessage(*s)
	}
	return atu
}

// ClearErrorMessage clears the value of the "error_message" field.
func (atu *AITaskUpdate) ClearErrorMessage() *AITaskUpdate {
	atu.mutation.ClearErrorMessage()
	return atu
}

// SetCreatedAt sets the "created_at" field.
func (atu *AITaskUpdate) SetCreatedAt(t time.Time) *AITaskUpdate {
	atu.mutation.SetCreatedAt(t)
	return atu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (atu *AITaskUpdate) SetNillableCreatedAt(t *time.Time) *AITaskUpdate {
	if t != nil {
		atu.SetCreatedAt(*t)
	}
	return atu
}

// SetUpdatedAt sets the "updated_at" field.
func (atu *AITaskUpdate) SetUpdatedAt(t time.Time) *AITaskUpdate {
	atu.mutation.SetUpdatedAt(t)
	return atu
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (atu *AITaskUpdate) SetNillableUpdatedAt(t *time.Time) *AITaskUpdate {
	if t != nil {
		atu.SetUpdatedAt(*t)
	}
	return atu
}

// Mutation returns the AITaskMutation object of the builder.
func (atu *AITaskUpdate) Mutation() *AITaskMutation {
	return atu.mutation
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (atu *AITaskUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, atu.sqlSave, atu.mutation, atu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (atu *AITaskUpdate) SaveX(ctx context.Context) int {
	affected, err := atu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (atu *AITaskUpdate) Exec(ctx context.Context) error {
	_, err := atu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (atu *AITaskUpdate) ExecX(ctx context.Context) {
	if err := atu.Exec(ctx); err != nil {
		panic(err)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (atu *AITaskUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *AITaskUpdate {
	atu.modifiers = append(atu.modifiers, modifiers...)
	return atu
}

func (atu *AITaskUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(aitask.Table, aitask.Columns, sqlgraph.NewFieldSpec(aitask.FieldID, field.TypeUUID))
	if ps := atu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := atu.mutation.EmployeeID(); ok {
		_spec.SetField(aitask.FieldEmployeeID, field.TypeUUID, value)
	}
	if value, ok := atu.mutation.Status(); ok {
		_spec.SetField(aitask.FieldStatus, field.TypeString, value)
	}
	if value, ok := atu.mutation.Output(); ok {
		_spec.SetField(aitask.FieldOutput, field.TypeString, value)
	}
	if atu.mutation.OutputCleared() {
		_spec.ClearField(aitask.FieldOutput, field.TypeString)
	}
	if value, ok := atu.mutation.Logs(); ok {
		_spec.SetField(aitask.FieldLogs, field.TypeString, value)
	}
	if atu.mutation.LogsCleared() {
		_spec.ClearField(aitask.FieldLogs, field.TypeString)
	}
	if value, ok := atu.mutation.ErrorMessage(); ok {
		_spec.SetField(aitask.FieldErrorMessage, field.TypeString, value)
	}
	if atu.mutation.ErrorMessageCleared() {
		_spec.ClearField(aitask.FieldErrorMessage, field.TypeString)
	}
	if value, ok := atu.mutation.CreatedAt(); ok {
		_spec.SetField(aitask.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := atu.mutation.UpdatedAt(); ok {
		_spec.SetField(aitask.FieldUpdatedAt, field.TypeTime, value)
	}
	_spec.AddModifiers(atu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, atu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{aitask.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	atu.mutation.done = true
	return n, nil
}

// AITaskUpdateOne is the builder for updating a single AITask entity.
type AITaskUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *AITaskMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetEmployeeID sets the "employee_id" field.
func (atuo *AITaskUpdateOne) SetEmployeeID(u uuid.UUID) *AITaskUpdateOne {
	atuo.mutation.SetEmployeeID(u)
	return atuo
}

// SetNillableEmployeeID sets the "employee_id" field if the given value is not nil.
func (atuo *AITaskUpdateOne) SetNillableEmployeeID(u *uuid.UUID) *AITaskUpdateOne {
	if u != nil {
		atuo.SetEmployeeID(*u)
	}
	return atuo
}

// SetStatus sets the "status" field.
func (atuo *AITaskUpdateOne) SetStatus(s string) *AITaskUpdateOne {
	atuo.mutation.SetStatus(s)
	return atuo
}

// SetNillableStatus sets the "status" field if the given value is not nil.
func (atuo *AITaskUpdateOne) SetNillableStatus(s *string) *AITaskUpdateOne {
	if s != nil {
		atuo.SetStatus(*s)
	}
	return atuo
}

// SetOutput sets the "output" field.
func (atuo *AITaskUpdateOne) SetOutput(s string) *AITaskUpdateOne {
	atuo.mutation.SetOutput(s)
	return atuo
}

// SetNillableOutput sets the "output" field if the given value is not nil.
func (atuo *AITaskUpdateOne) SetNillableOutput(s *string) *AITaskUpdateOne {
	if s != nil {
		atuo.SetOutput(*s)
	}
	return atuo
}

// ClearOutput clears the value of the "output" field.
func (atuo *AITaskUpdateOne) ClearOutput() *AITaskUpdateOne {
	atuo.mutation.ClearOutput()
	return atuo
}

// SetLogs sets the "logs" field.
func (atuo *AITaskUpdateOne) SetLogs(s string) *AITaskUpdateOne {
	atuo.mutation.SetLogs(s)
	return atuo
}

// SetNillableLogs sets the "logs" field if the given value is not nil.
func (atuo *AITaskUpdateOne) SetNillableLogs(s *string) *AITaskUpdateOne {
	if s != nil {
		atuo.SetLogs(*s)
	}
	return atuo
}

// ClearLogs clears the value of the "logs" field.
func (atuo *AITaskUpdateOne) ClearLogs() *AITaskUpdateOne {
	atuo.mutation.ClearLogs()
	return atuo
}

// SetErrorMessage sets the "error_message" field.
func (atuo *AITaskUpdateOne) SetErrorMessage(s string) *AITaskUpdateOne {
	atuo.mutation.SetErrorMessage(s)
	return atuo
}

// SetNillableErrorMessage sets the "error_message" field if the given value is not nil.
func (atuo *AITaskUpdateOne) SetNillableErrorMessage(s *string) *AITaskUpdateOne {
	if s != nil {
		atuo.SetErrorMessage(*s)
	}
	return atuo
}

// ClearErrorMessage clears the value of the "error_message" field.
func (atuo *AITaskUpdateOne) ClearErrorMessage() *AITaskUpdateOne {
	atuo.mutation.ClearErrorMessage()
	return atuo
}

// SetCreatedAt sets the "created_at" field.
func (atuo *AITaskUpdateOne) SetCreatedAt(t time.Time) *AITaskUpdateOne {
	atuo.mutation.SetCreatedAt(t)
	return atuo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (atuo *AITaskUpdateOne) SetNillableCreatedAt(t *time.Time) *AITaskUpdateOne {
	if t != nil {
		atuo.SetCreatedAt(*t)
	}
	return atuo
}

// SetUpdatedAt sets the "updated_at" field.
func (atuo *AITaskUpdateOne) SetUpdatedAt(t time.Time) *AITaskUpdateOne {
	atuo.mutation.SetUpdatedAt(t)
	return atuo
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (atuo *AITaskUpdateOne) SetNillableUpdatedAt(t *time.Time) *AITaskUpdateOne {
	if t != nil {
		atuo.SetUpdatedAt(*t)
	}
	return atuo
}

// Mutation returns the AITaskMutation object of the builder.
func (atuo *AITaskUpdateOne) Mutation() *AITaskMutation {
	return atuo.mutation
}

// Where appends a list predicates to the AITaskUpdate builder.
func (atuo *AITaskUpdateOne) Where(ps ...predicate.AITask) *AITaskUpdateOne {
	atuo.mutation.Where(ps...)
	return atuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (atuo *AITaskUpdateOne) Select(field string, fields ...string) *AITaskUpdateOne {
	atuo.fields = append([]string{field}, fields...)
	return atuo
}

// Save executes the query and returns the updated AITask entity.
func (atuo *AITaskUpdateOne) Save(ctx context.Context) (*AITask, error) {
	return withHooks(ctx, atuo.sqlSave, atuo.mutation, atuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (atuo *AITaskUpdateOne) SaveX(ctx context.Context) *AITask {
	node, err := atuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (atuo *AITaskUpdateOne) Exec(ctx context.Context) error {
	_, err := atuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (atuo *AITaskUpdateOne) ExecX(ctx context.Context) {
	if err := atuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (atuo *AITaskUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *AITaskUpdateOne {
	atuo.modifiers = append(atuo.modifiers, modifiers...)
	return atuo
}

func (atuo *AITaskUpdateOne) sqlSave(ctx context.Context) (_node *AITask, err error) {
	_spec := sqlgraph.NewUpdateSpec(aitask.Table, aitask.Columns, sqlgraph.NewFieldSpec(aitask.FieldID, field.TypeUUID))
	id, ok := atuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "AITask.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := atuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, aitask.FieldID)
		for _, f := range fields {
			if !aitask.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != aitask.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := atuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := atuo.mutation.EmployeeID(); ok {
		_spec.SetField(aitask.FieldEmployeeID, field.TypeUUID, value)
	}
	if value, ok := atuo.mutation.Status(); ok {
		_spec.SetField(aitask.FieldStatus, field.TypeString, value)
	}
	if value, ok := atuo.mutation.Output(); ok {
		_spec.SetField(aitask.FieldOutput, field.TypeString, value)
	}
	if atuo.mutation.OutputCleared() {
		_spec.ClearField(aitask.FieldOutput, field.TypeString)
	}
	if value, ok := atuo.mutation.Logs(); ok {
		_spec.SetField(aitask.FieldLogs, field.TypeString, value)
	}
	if atuo.mutation.LogsCleared() {
		_spec.ClearField(aitask.FieldLogs, field.TypeString)
	}
	if value, ok := atuo.mutation.ErrorMessage(); ok {
		_spec.SetField(aitask.FieldErrorMessage, field.TypeString, value)
	}
	if atuo.mutation.ErrorMessageCleared() {
		_spec.ClearField(aitask.FieldErrorMessage, field.TypeString)
	}
	if value, ok := atuo.mutation.CreatedAt(); ok {
		_spec.SetField(aitask.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := atuo.mutation.UpdatedAt(); ok {
		_spec.SetField(aitask.FieldUpdatedAt, field.TypeTime, value)
	}
	_spec.AddModifiers(atuo.modifiers...)
	_node = &AITask{config: atuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, atuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{aitask.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	atuo.mutation.done = true
	return _node, nil
}
