// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/apikey"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/google/uuid"
)

// ApiKey is the model entity for the ApiKey schema.
type ApiKey struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// UserID holds the value of the "user_id" field.
	UserID uuid.UUID `json:"user_id,omitempty"`
	// Key holds the value of the "key" field.
	Key string `json:"key,omitempty"`
	// Name holds the value of the "name" field.
	Name string `json:"name,omitempty"`
	// Status holds the value of the "status" field.
	Status consts.ApiKeyStatus `json:"status,omitempty"`
	// LastUsed holds the value of the "last_used" field.
	LastUsed time.Time `json:"last_used,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt time.Time `json:"updated_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the ApiKeyQuery when eager-loading is set.
	Edges        ApiKeyEdges `json:"edges"`
	selectValues sql.SelectValues
}

// ApiKeyEdges holds the relations/edges for other nodes in the graph.
type ApiKeyEdges struct {
	// User holds the value of the user edge.
	User *User `json:"user,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [1]bool
}

// UserOrErr returns the User value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e ApiKeyEdges) UserOrErr() (*User, error) {
	if e.User != nil {
		return e.User, nil
	} else if e.loadedTypes[0] {
		return nil, &NotFoundError{label: user.Label}
	}
	return nil, &NotLoadedError{edge: "user"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*ApiKey) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case apikey.FieldKey, apikey.FieldName, apikey.FieldStatus:
			values[i] = new(sql.NullString)
		case apikey.FieldLastUsed, apikey.FieldCreatedAt, apikey.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		case apikey.FieldID, apikey.FieldUserID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the ApiKey fields.
func (ak *ApiKey) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case apikey.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				ak.ID = *value
			}
		case apikey.FieldUserID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field user_id", values[i])
			} else if value != nil {
				ak.UserID = *value
			}
		case apikey.FieldKey:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field key", values[i])
			} else if value.Valid {
				ak.Key = value.String
			}
		case apikey.FieldName:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field name", values[i])
			} else if value.Valid {
				ak.Name = value.String
			}
		case apikey.FieldStatus:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field status", values[i])
			} else if value.Valid {
				ak.Status = consts.ApiKeyStatus(value.String)
			}
		case apikey.FieldLastUsed:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field last_used", values[i])
			} else if value.Valid {
				ak.LastUsed = value.Time
			}
		case apikey.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				ak.CreatedAt = value.Time
			}
		case apikey.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				ak.UpdatedAt = value.Time
			}
		default:
			ak.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the ApiKey.
// This includes values selected through modifiers, order, etc.
func (ak *ApiKey) Value(name string) (ent.Value, error) {
	return ak.selectValues.Get(name)
}

// QueryUser queries the "user" edge of the ApiKey entity.
func (ak *ApiKey) QueryUser() *UserQuery {
	return NewApiKeyClient(ak.config).QueryUser(ak)
}

// Update returns a builder for updating this ApiKey.
// Note that you need to call ApiKey.Unwrap() before calling this method if this ApiKey
// was returned from a transaction, and the transaction was committed or rolled back.
func (ak *ApiKey) Update() *ApiKeyUpdateOne {
	return NewApiKeyClient(ak.config).UpdateOne(ak)
}

// Unwrap unwraps the ApiKey entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (ak *ApiKey) Unwrap() *ApiKey {
	_tx, ok := ak.config.driver.(*txDriver)
	if !ok {
		panic("db: ApiKey is not a transactional entity")
	}
	ak.config.driver = _tx.drv
	return ak
}

// String implements the fmt.Stringer.
func (ak *ApiKey) String() string {
	var builder strings.Builder
	builder.WriteString("ApiKey(")
	builder.WriteString(fmt.Sprintf("id=%v, ", ak.ID))
	builder.WriteString("user_id=")
	builder.WriteString(fmt.Sprintf("%v", ak.UserID))
	builder.WriteString(", ")
	builder.WriteString("key=")
	builder.WriteString(ak.Key)
	builder.WriteString(", ")
	builder.WriteString("name=")
	builder.WriteString(ak.Name)
	builder.WriteString(", ")
	builder.WriteString("status=")
	builder.WriteString(fmt.Sprintf("%v", ak.Status))
	builder.WriteString(", ")
	builder.WriteString("last_used=")
	builder.WriteString(ak.LastUsed.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(ak.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(ak.UpdatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// ApiKeys is a parsable slice of ApiKey.
type ApiKeys []*ApiKey
