// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/apikey"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/google/uuid"
)

// ApiKeyCreate is the builder for creating a ApiKey entity.
type ApiKeyCreate struct {
	config
	mutation *ApiKeyMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetUserID sets the "user_id" field.
func (akc *ApiKeyCreate) SetUserID(u uuid.UUID) *ApiKeyCreate {
	akc.mutation.SetUserID(u)
	return akc
}

// SetKey sets the "key" field.
func (akc *ApiKeyCreate) SetKey(s string) *ApiKeyCreate {
	akc.mutation.SetKey(s)
	return akc
}

// SetName sets the "name" field.
func (akc *ApiKeyCreate) SetName(s string) *ApiKeyCreate {
	akc.mutation.SetName(s)
	return akc
}

// SetStatus sets the "status" field.
func (akc *ApiKeyCreate) SetStatus(cks consts.ApiKeyStatus) *ApiKeyCreate {
	akc.mutation.SetStatus(cks)
	return akc
}

// SetNillableStatus sets the "status" field if the given value is not nil.
func (akc *ApiKeyCreate) SetNillableStatus(cks *consts.ApiKeyStatus) *ApiKeyCreate {
	if cks != nil {
		akc.SetStatus(*cks)
	}
	return akc
}

// SetLastUsed sets the "last_used" field.
func (akc *ApiKeyCreate) SetLastUsed(t time.Time) *ApiKeyCreate {
	akc.mutation.SetLastUsed(t)
	return akc
}

// SetNillableLastUsed sets the "last_used" field if the given value is not nil.
func (akc *ApiKeyCreate) SetNillableLastUsed(t *time.Time) *ApiKeyCreate {
	if t != nil {
		akc.SetLastUsed(*t)
	}
	return akc
}

// SetCreatedAt sets the "created_at" field.
func (akc *ApiKeyCreate) SetCreatedAt(t time.Time) *ApiKeyCreate {
	akc.mutation.SetCreatedAt(t)
	return akc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (akc *ApiKeyCreate) SetNillableCreatedAt(t *time.Time) *ApiKeyCreate {
	if t != nil {
		akc.SetCreatedAt(*t)
	}
	return akc
}

// SetUpdatedAt sets the "updated_at" field.
func (akc *ApiKeyCreate) SetUpdatedAt(t time.Time) *ApiKeyCreate {
	akc.mutation.SetUpdatedAt(t)
	return akc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (akc *ApiKeyCreate) SetNillableUpdatedAt(t *time.Time) *ApiKeyCreate {
	if t != nil {
		akc.SetUpdatedAt(*t)
	}
	return akc
}

// SetID sets the "id" field.
func (akc *ApiKeyCreate) SetID(u uuid.UUID) *ApiKeyCreate {
	akc.mutation.SetID(u)
	return akc
}

// SetUser sets the "user" edge to the User entity.
func (akc *ApiKeyCreate) SetUser(u *User) *ApiKeyCreate {
	return akc.SetUserID(u.ID)
}

// Mutation returns the ApiKeyMutation object of the builder.
func (akc *ApiKeyCreate) Mutation() *ApiKeyMutation {
	return akc.mutation
}

// Save creates the ApiKey in the database.
func (akc *ApiKeyCreate) Save(ctx context.Context) (*ApiKey, error) {
	akc.defaults()
	return withHooks(ctx, akc.sqlSave, akc.mutation, akc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (akc *ApiKeyCreate) SaveX(ctx context.Context) *ApiKey {
	v, err := akc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (akc *ApiKeyCreate) Exec(ctx context.Context) error {
	_, err := akc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (akc *ApiKeyCreate) ExecX(ctx context.Context) {
	if err := akc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (akc *ApiKeyCreate) defaults() {
	if _, ok := akc.mutation.Status(); !ok {
		v := apikey.DefaultStatus
		akc.mutation.SetStatus(v)
	}
	if _, ok := akc.mutation.CreatedAt(); !ok {
		v := apikey.DefaultCreatedAt()
		akc.mutation.SetCreatedAt(v)
	}
	if _, ok := akc.mutation.UpdatedAt(); !ok {
		v := apikey.DefaultUpdatedAt()
		akc.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (akc *ApiKeyCreate) check() error {
	if _, ok := akc.mutation.UserID(); !ok {
		return &ValidationError{Name: "user_id", err: errors.New(`db: missing required field "ApiKey.user_id"`)}
	}
	if _, ok := akc.mutation.Key(); !ok {
		return &ValidationError{Name: "key", err: errors.New(`db: missing required field "ApiKey.key"`)}
	}
	if _, ok := akc.mutation.Name(); !ok {
		return &ValidationError{Name: "name", err: errors.New(`db: missing required field "ApiKey.name"`)}
	}
	if _, ok := akc.mutation.Status(); !ok {
		return &ValidationError{Name: "status", err: errors.New(`db: missing required field "ApiKey.status"`)}
	}
	if _, ok := akc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "ApiKey.created_at"`)}
	}
	if _, ok := akc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`db: missing required field "ApiKey.updated_at"`)}
	}
	if len(akc.mutation.UserIDs()) == 0 {
		return &ValidationError{Name: "user", err: errors.New(`db: missing required edge "ApiKey.user"`)}
	}
	return nil
}

func (akc *ApiKeyCreate) sqlSave(ctx context.Context) (*ApiKey, error) {
	if err := akc.check(); err != nil {
		return nil, err
	}
	_node, _spec := akc.createSpec()
	if err := sqlgraph.CreateNode(ctx, akc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	akc.mutation.id = &_node.ID
	akc.mutation.done = true
	return _node, nil
}

func (akc *ApiKeyCreate) createSpec() (*ApiKey, *sqlgraph.CreateSpec) {
	var (
		_node = &ApiKey{config: akc.config}
		_spec = sqlgraph.NewCreateSpec(apikey.Table, sqlgraph.NewFieldSpec(apikey.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = akc.conflict
	if id, ok := akc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := akc.mutation.Key(); ok {
		_spec.SetField(apikey.FieldKey, field.TypeString, value)
		_node.Key = value
	}
	if value, ok := akc.mutation.Name(); ok {
		_spec.SetField(apikey.FieldName, field.TypeString, value)
		_node.Name = value
	}
	if value, ok := akc.mutation.Status(); ok {
		_spec.SetField(apikey.FieldStatus, field.TypeString, value)
		_node.Status = value
	}
	if value, ok := akc.mutation.LastUsed(); ok {
		_spec.SetField(apikey.FieldLastUsed, field.TypeTime, value)
		_node.LastUsed = value
	}
	if value, ok := akc.mutation.CreatedAt(); ok {
		_spec.SetField(apikey.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := akc.mutation.UpdatedAt(); ok {
		_spec.SetField(apikey.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	if nodes := akc.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   apikey.UserTable,
			Columns: []string{apikey.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.UserID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.ApiKey.Create().
//		SetUserID(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.ApiKeyUpsert) {
//			SetUserID(v+v).
//		}).
//		Exec(ctx)
func (akc *ApiKeyCreate) OnConflict(opts ...sql.ConflictOption) *ApiKeyUpsertOne {
	akc.conflict = opts
	return &ApiKeyUpsertOne{
		create: akc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.ApiKey.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (akc *ApiKeyCreate) OnConflictColumns(columns ...string) *ApiKeyUpsertOne {
	akc.conflict = append(akc.conflict, sql.ConflictColumns(columns...))
	return &ApiKeyUpsertOne{
		create: akc,
	}
}

type (
	// ApiKeyUpsertOne is the builder for "upsert"-ing
	//  one ApiKey node.
	ApiKeyUpsertOne struct {
		create *ApiKeyCreate
	}

	// ApiKeyUpsert is the "OnConflict" setter.
	ApiKeyUpsert struct {
		*sql.UpdateSet
	}
)

// SetUserID sets the "user_id" field.
func (u *ApiKeyUpsert) SetUserID(v uuid.UUID) *ApiKeyUpsert {
	u.Set(apikey.FieldUserID, v)
	return u
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *ApiKeyUpsert) UpdateUserID() *ApiKeyUpsert {
	u.SetExcluded(apikey.FieldUserID)
	return u
}

// SetKey sets the "key" field.
func (u *ApiKeyUpsert) SetKey(v string) *ApiKeyUpsert {
	u.Set(apikey.FieldKey, v)
	return u
}

// UpdateKey sets the "key" field to the value that was provided on create.
func (u *ApiKeyUpsert) UpdateKey() *ApiKeyUpsert {
	u.SetExcluded(apikey.FieldKey)
	return u
}

// SetName sets the "name" field.
func (u *ApiKeyUpsert) SetName(v string) *ApiKeyUpsert {
	u.Set(apikey.FieldName, v)
	return u
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *ApiKeyUpsert) UpdateName() *ApiKeyUpsert {
	u.SetExcluded(apikey.FieldName)
	return u
}

// SetStatus sets the "status" field.
func (u *ApiKeyUpsert) SetStatus(v consts.ApiKeyStatus) *ApiKeyUpsert {
	u.Set(apikey.FieldStatus, v)
	return u
}

// UpdateStatus sets the "status" field to the value that was provided on create.
func (u *ApiKeyUpsert) UpdateStatus() *ApiKeyUpsert {
	u.SetExcluded(apikey.FieldStatus)
	return u
}

// SetLastUsed sets the "last_used" field.
func (u *ApiKeyUpsert) SetLastUsed(v time.Time) *ApiKeyUpsert {
	u.Set(apikey.FieldLastUsed, v)
	return u
}

// UpdateLastUsed sets the "last_used" field to the value that was provided on create.
func (u *ApiKeyUpsert) UpdateLastUsed() *ApiKeyUpsert {
	u.SetExcluded(apikey.FieldLastUsed)
	return u
}

// ClearLastUsed clears the value of the "last_used" field.
func (u *ApiKeyUpsert) ClearLastUsed() *ApiKeyUpsert {
	u.SetNull(apikey.FieldLastUsed)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *ApiKeyUpsert) SetCreatedAt(v time.Time) *ApiKeyUpsert {
	u.Set(apikey.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *ApiKeyUpsert) UpdateCreatedAt() *ApiKeyUpsert {
	u.SetExcluded(apikey.FieldCreatedAt)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *ApiKeyUpsert) SetUpdatedAt(v time.Time) *ApiKeyUpsert {
	u.Set(apikey.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *ApiKeyUpsert) UpdateUpdatedAt() *ApiKeyUpsert {
	u.SetExcluded(apikey.FieldUpdatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.ApiKey.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(apikey.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *ApiKeyUpsertOne) UpdateNewValues() *ApiKeyUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(apikey.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.ApiKey.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *ApiKeyUpsertOne) Ignore() *ApiKeyUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *ApiKeyUpsertOne) DoNothing() *ApiKeyUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the ApiKeyCreate.OnConflict
// documentation for more info.
func (u *ApiKeyUpsertOne) Update(set func(*ApiKeyUpsert)) *ApiKeyUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&ApiKeyUpsert{UpdateSet: update})
	}))
	return u
}

// SetUserID sets the "user_id" field.
func (u *ApiKeyUpsertOne) SetUserID(v uuid.UUID) *ApiKeyUpsertOne {
	return u.Update(func(s *ApiKeyUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *ApiKeyUpsertOne) UpdateUserID() *ApiKeyUpsertOne {
	return u.Update(func(s *ApiKeyUpsert) {
		s.UpdateUserID()
	})
}

// SetKey sets the "key" field.
func (u *ApiKeyUpsertOne) SetKey(v string) *ApiKeyUpsertOne {
	return u.Update(func(s *ApiKeyUpsert) {
		s.SetKey(v)
	})
}

// UpdateKey sets the "key" field to the value that was provided on create.
func (u *ApiKeyUpsertOne) UpdateKey() *ApiKeyUpsertOne {
	return u.Update(func(s *ApiKeyUpsert) {
		s.UpdateKey()
	})
}

// SetName sets the "name" field.
func (u *ApiKeyUpsertOne) SetName(v string) *ApiKeyUpsertOne {
	return u.Update(func(s *ApiKeyUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *ApiKeyUpsertOne) UpdateName() *ApiKeyUpsertOne {
	return u.Update(func(s *ApiKeyUpsert) {
		s.UpdateName()
	})
}

// SetStatus sets the "status" field.
func (u *ApiKeyUpsertOne) SetStatus(v consts.ApiKeyStatus) *ApiKeyUpsertOne {
	return u.Update(func(s *ApiKeyUpsert) {
		s.SetStatus(v)
	})
}

// UpdateStatus sets the "status" field to the value that was provided on create.
func (u *ApiKeyUpsertOne) UpdateStatus() *ApiKeyUpsertOne {
	return u.Update(func(s *ApiKeyUpsert) {
		s.UpdateStatus()
	})
}

// SetLastUsed sets the "last_used" field.
func (u *ApiKeyUpsertOne) SetLastUsed(v time.Time) *ApiKeyUpsertOne {
	return u.Update(func(s *ApiKeyUpsert) {
		s.SetLastUsed(v)
	})
}

// UpdateLastUsed sets the "last_used" field to the value that was provided on create.
func (u *ApiKeyUpsertOne) UpdateLastUsed() *ApiKeyUpsertOne {
	return u.Update(func(s *ApiKeyUpsert) {
		s.UpdateLastUsed()
	})
}

// ClearLastUsed clears the value of the "last_used" field.
func (u *ApiKeyUpsertOne) ClearLastUsed() *ApiKeyUpsertOne {
	return u.Update(func(s *ApiKeyUpsert) {
		s.ClearLastUsed()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *ApiKeyUpsertOne) SetCreatedAt(v time.Time) *ApiKeyUpsertOne {
	return u.Update(func(s *ApiKeyUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *ApiKeyUpsertOne) UpdateCreatedAt() *ApiKeyUpsertOne {
	return u.Update(func(s *ApiKeyUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *ApiKeyUpsertOne) SetUpdatedAt(v time.Time) *ApiKeyUpsertOne {
	return u.Update(func(s *ApiKeyUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *ApiKeyUpsertOne) UpdateUpdatedAt() *ApiKeyUpsertOne {
	return u.Update(func(s *ApiKeyUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *ApiKeyUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for ApiKeyCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *ApiKeyUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *ApiKeyUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: ApiKeyUpsertOne.ID is not supported by MySQL driver. Use ApiKeyUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *ApiKeyUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// ApiKeyCreateBulk is the builder for creating many ApiKey entities in bulk.
type ApiKeyCreateBulk struct {
	config
	err      error
	builders []*ApiKeyCreate
	conflict []sql.ConflictOption
}

// Save creates the ApiKey entities in the database.
func (akcb *ApiKeyCreateBulk) Save(ctx context.Context) ([]*ApiKey, error) {
	if akcb.err != nil {
		return nil, akcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(akcb.builders))
	nodes := make([]*ApiKey, len(akcb.builders))
	mutators := make([]Mutator, len(akcb.builders))
	for i := range akcb.builders {
		func(i int, root context.Context) {
			builder := akcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*ApiKeyMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, akcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = akcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, akcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, akcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (akcb *ApiKeyCreateBulk) SaveX(ctx context.Context) []*ApiKey {
	v, err := akcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (akcb *ApiKeyCreateBulk) Exec(ctx context.Context) error {
	_, err := akcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (akcb *ApiKeyCreateBulk) ExecX(ctx context.Context) {
	if err := akcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.ApiKey.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.ApiKeyUpsert) {
//			SetUserID(v+v).
//		}).
//		Exec(ctx)
func (akcb *ApiKeyCreateBulk) OnConflict(opts ...sql.ConflictOption) *ApiKeyUpsertBulk {
	akcb.conflict = opts
	return &ApiKeyUpsertBulk{
		create: akcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.ApiKey.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (akcb *ApiKeyCreateBulk) OnConflictColumns(columns ...string) *ApiKeyUpsertBulk {
	akcb.conflict = append(akcb.conflict, sql.ConflictColumns(columns...))
	return &ApiKeyUpsertBulk{
		create: akcb,
	}
}

// ApiKeyUpsertBulk is the builder for "upsert"-ing
// a bulk of ApiKey nodes.
type ApiKeyUpsertBulk struct {
	create *ApiKeyCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.ApiKey.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(apikey.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *ApiKeyUpsertBulk) UpdateNewValues() *ApiKeyUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(apikey.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.ApiKey.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *ApiKeyUpsertBulk) Ignore() *ApiKeyUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *ApiKeyUpsertBulk) DoNothing() *ApiKeyUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the ApiKeyCreateBulk.OnConflict
// documentation for more info.
func (u *ApiKeyUpsertBulk) Update(set func(*ApiKeyUpsert)) *ApiKeyUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&ApiKeyUpsert{UpdateSet: update})
	}))
	return u
}

// SetUserID sets the "user_id" field.
func (u *ApiKeyUpsertBulk) SetUserID(v uuid.UUID) *ApiKeyUpsertBulk {
	return u.Update(func(s *ApiKeyUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *ApiKeyUpsertBulk) UpdateUserID() *ApiKeyUpsertBulk {
	return u.Update(func(s *ApiKeyUpsert) {
		s.UpdateUserID()
	})
}

// SetKey sets the "key" field.
func (u *ApiKeyUpsertBulk) SetKey(v string) *ApiKeyUpsertBulk {
	return u.Update(func(s *ApiKeyUpsert) {
		s.SetKey(v)
	})
}

// UpdateKey sets the "key" field to the value that was provided on create.
func (u *ApiKeyUpsertBulk) UpdateKey() *ApiKeyUpsertBulk {
	return u.Update(func(s *ApiKeyUpsert) {
		s.UpdateKey()
	})
}

// SetName sets the "name" field.
func (u *ApiKeyUpsertBulk) SetName(v string) *ApiKeyUpsertBulk {
	return u.Update(func(s *ApiKeyUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *ApiKeyUpsertBulk) UpdateName() *ApiKeyUpsertBulk {
	return u.Update(func(s *ApiKeyUpsert) {
		s.UpdateName()
	})
}

// SetStatus sets the "status" field.
func (u *ApiKeyUpsertBulk) SetStatus(v consts.ApiKeyStatus) *ApiKeyUpsertBulk {
	return u.Update(func(s *ApiKeyUpsert) {
		s.SetStatus(v)
	})
}

// UpdateStatus sets the "status" field to the value that was provided on create.
func (u *ApiKeyUpsertBulk) UpdateStatus() *ApiKeyUpsertBulk {
	return u.Update(func(s *ApiKeyUpsert) {
		s.UpdateStatus()
	})
}

// SetLastUsed sets the "last_used" field.
func (u *ApiKeyUpsertBulk) SetLastUsed(v time.Time) *ApiKeyUpsertBulk {
	return u.Update(func(s *ApiKeyUpsert) {
		s.SetLastUsed(v)
	})
}

// UpdateLastUsed sets the "last_used" field to the value that was provided on create.
func (u *ApiKeyUpsertBulk) UpdateLastUsed() *ApiKeyUpsertBulk {
	return u.Update(func(s *ApiKeyUpsert) {
		s.UpdateLastUsed()
	})
}

// ClearLastUsed clears the value of the "last_used" field.
func (u *ApiKeyUpsertBulk) ClearLastUsed() *ApiKeyUpsertBulk {
	return u.Update(func(s *ApiKeyUpsert) {
		s.ClearLastUsed()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *ApiKeyUpsertBulk) SetCreatedAt(v time.Time) *ApiKeyUpsertBulk {
	return u.Update(func(s *ApiKeyUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *ApiKeyUpsertBulk) UpdateCreatedAt() *ApiKeyUpsertBulk {
	return u.Update(func(s *ApiKeyUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *ApiKeyUpsertBulk) SetUpdatedAt(v time.Time) *ApiKeyUpsertBulk {
	return u.Update(func(s *ApiKeyUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *ApiKeyUpsertBulk) UpdateUpdatedAt() *ApiKeyUpsertBulk {
	return u.Update(func(s *ApiKeyUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *ApiKeyUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the ApiKeyCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for ApiKeyCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *ApiKeyUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
