// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/apikey"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/google/uuid"
)

// ApiKeyUpdate is the builder for updating ApiKey entities.
type ApiKeyUpdate struct {
	config
	hooks     []Hook
	mutation  *ApiKeyMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the ApiKeyUpdate builder.
func (aku *ApiKeyUpdate) Where(ps ...predicate.ApiKey) *ApiKeyUpdate {
	aku.mutation.Where(ps...)
	return aku
}

// SetUserID sets the "user_id" field.
func (aku *ApiKeyUpdate) SetUserID(u uuid.UUID) *ApiKeyUpdate {
	aku.mutation.SetUserID(u)
	return aku
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (aku *ApiKeyUpdate) SetNillableUserID(u *uuid.UUID) *ApiKeyUpdate {
	if u != nil {
		aku.SetUserID(*u)
	}
	return aku
}

// SetKey sets the "key" field.
func (aku *ApiKeyUpdate) SetKey(s string) *ApiKeyUpdate {
	aku.mutation.SetKey(s)
	return aku
}

// SetNillableKey sets the "key" field if the given value is not nil.
func (aku *ApiKeyUpdate) SetNillableKey(s *string) *ApiKeyUpdate {
	if s != nil {
		aku.SetKey(*s)
	}
	return aku
}

// SetName sets the "name" field.
func (aku *ApiKeyUpdate) SetName(s string) *ApiKeyUpdate {
	aku.mutation.SetName(s)
	return aku
}

// SetNillableName sets the "name" field if the given value is not nil.
func (aku *ApiKeyUpdate) SetNillableName(s *string) *ApiKeyUpdate {
	if s != nil {
		aku.SetName(*s)
	}
	return aku
}

// SetStatus sets the "status" field.
func (aku *ApiKeyUpdate) SetStatus(cks consts.ApiKeyStatus) *ApiKeyUpdate {
	aku.mutation.SetStatus(cks)
	return aku
}

// SetNillableStatus sets the "status" field if the given value is not nil.
func (aku *ApiKeyUpdate) SetNillableStatus(cks *consts.ApiKeyStatus) *ApiKeyUpdate {
	if cks != nil {
		aku.SetStatus(*cks)
	}
	return aku
}

// SetLastUsed sets the "last_used" field.
func (aku *ApiKeyUpdate) SetLastUsed(t time.Time) *ApiKeyUpdate {
	aku.mutation.SetLastUsed(t)
	return aku
}

// SetNillableLastUsed sets the "last_used" field if the given value is not nil.
func (aku *ApiKeyUpdate) SetNillableLastUsed(t *time.Time) *ApiKeyUpdate {
	if t != nil {
		aku.SetLastUsed(*t)
	}
	return aku
}

// ClearLastUsed clears the value of the "last_used" field.
func (aku *ApiKeyUpdate) ClearLastUsed() *ApiKeyUpdate {
	aku.mutation.ClearLastUsed()
	return aku
}

// SetCreatedAt sets the "created_at" field.
func (aku *ApiKeyUpdate) SetCreatedAt(t time.Time) *ApiKeyUpdate {
	aku.mutation.SetCreatedAt(t)
	return aku
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (aku *ApiKeyUpdate) SetNillableCreatedAt(t *time.Time) *ApiKeyUpdate {
	if t != nil {
		aku.SetCreatedAt(*t)
	}
	return aku
}

// SetUpdatedAt sets the "updated_at" field.
func (aku *ApiKeyUpdate) SetUpdatedAt(t time.Time) *ApiKeyUpdate {
	aku.mutation.SetUpdatedAt(t)
	return aku
}

// SetUser sets the "user" edge to the User entity.
func (aku *ApiKeyUpdate) SetUser(u *User) *ApiKeyUpdate {
	return aku.SetUserID(u.ID)
}

// Mutation returns the ApiKeyMutation object of the builder.
func (aku *ApiKeyUpdate) Mutation() *ApiKeyMutation {
	return aku.mutation
}

// ClearUser clears the "user" edge to the User entity.
func (aku *ApiKeyUpdate) ClearUser() *ApiKeyUpdate {
	aku.mutation.ClearUser()
	return aku
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (aku *ApiKeyUpdate) Save(ctx context.Context) (int, error) {
	aku.defaults()
	return withHooks(ctx, aku.sqlSave, aku.mutation, aku.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (aku *ApiKeyUpdate) SaveX(ctx context.Context) int {
	affected, err := aku.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (aku *ApiKeyUpdate) Exec(ctx context.Context) error {
	_, err := aku.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (aku *ApiKeyUpdate) ExecX(ctx context.Context) {
	if err := aku.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (aku *ApiKeyUpdate) defaults() {
	if _, ok := aku.mutation.UpdatedAt(); !ok {
		v := apikey.UpdateDefaultUpdatedAt()
		aku.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (aku *ApiKeyUpdate) check() error {
	if aku.mutation.UserCleared() && len(aku.mutation.UserIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "ApiKey.user"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (aku *ApiKeyUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *ApiKeyUpdate {
	aku.modifiers = append(aku.modifiers, modifiers...)
	return aku
}

func (aku *ApiKeyUpdate) sqlSave(ctx context.Context) (n int, err error) {
	if err := aku.check(); err != nil {
		return n, err
	}
	_spec := sqlgraph.NewUpdateSpec(apikey.Table, apikey.Columns, sqlgraph.NewFieldSpec(apikey.FieldID, field.TypeUUID))
	if ps := aku.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := aku.mutation.Key(); ok {
		_spec.SetField(apikey.FieldKey, field.TypeString, value)
	}
	if value, ok := aku.mutation.Name(); ok {
		_spec.SetField(apikey.FieldName, field.TypeString, value)
	}
	if value, ok := aku.mutation.Status(); ok {
		_spec.SetField(apikey.FieldStatus, field.TypeString, value)
	}
	if value, ok := aku.mutation.LastUsed(); ok {
		_spec.SetField(apikey.FieldLastUsed, field.TypeTime, value)
	}
	if aku.mutation.LastUsedCleared() {
		_spec.ClearField(apikey.FieldLastUsed, field.TypeTime)
	}
	if value, ok := aku.mutation.CreatedAt(); ok {
		_spec.SetField(apikey.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := aku.mutation.UpdatedAt(); ok {
		_spec.SetField(apikey.FieldUpdatedAt, field.TypeTime, value)
	}
	if aku.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   apikey.UserTable,
			Columns: []string{apikey.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := aku.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   apikey.UserTable,
			Columns: []string{apikey.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(aku.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, aku.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{apikey.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	aku.mutation.done = true
	return n, nil
}

// ApiKeyUpdateOne is the builder for updating a single ApiKey entity.
type ApiKeyUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *ApiKeyMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetUserID sets the "user_id" field.
func (akuo *ApiKeyUpdateOne) SetUserID(u uuid.UUID) *ApiKeyUpdateOne {
	akuo.mutation.SetUserID(u)
	return akuo
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (akuo *ApiKeyUpdateOne) SetNillableUserID(u *uuid.UUID) *ApiKeyUpdateOne {
	if u != nil {
		akuo.SetUserID(*u)
	}
	return akuo
}

// SetKey sets the "key" field.
func (akuo *ApiKeyUpdateOne) SetKey(s string) *ApiKeyUpdateOne {
	akuo.mutation.SetKey(s)
	return akuo
}

// SetNillableKey sets the "key" field if the given value is not nil.
func (akuo *ApiKeyUpdateOne) SetNillableKey(s *string) *ApiKeyUpdateOne {
	if s != nil {
		akuo.SetKey(*s)
	}
	return akuo
}

// SetName sets the "name" field.
func (akuo *ApiKeyUpdateOne) SetName(s string) *ApiKeyUpdateOne {
	akuo.mutation.SetName(s)
	return akuo
}

// SetNillableName sets the "name" field if the given value is not nil.
func (akuo *ApiKeyUpdateOne) SetNillableName(s *string) *ApiKeyUpdateOne {
	if s != nil {
		akuo.SetName(*s)
	}
	return akuo
}

// SetStatus sets the "status" field.
func (akuo *ApiKeyUpdateOne) SetStatus(cks consts.ApiKeyStatus) *ApiKeyUpdateOne {
	akuo.mutation.SetStatus(cks)
	return akuo
}

// SetNillableStatus sets the "status" field if the given value is not nil.
func (akuo *ApiKeyUpdateOne) SetNillableStatus(cks *consts.ApiKeyStatus) *ApiKeyUpdateOne {
	if cks != nil {
		akuo.SetStatus(*cks)
	}
	return akuo
}

// SetLastUsed sets the "last_used" field.
func (akuo *ApiKeyUpdateOne) SetLastUsed(t time.Time) *ApiKeyUpdateOne {
	akuo.mutation.SetLastUsed(t)
	return akuo
}

// SetNillableLastUsed sets the "last_used" field if the given value is not nil.
func (akuo *ApiKeyUpdateOne) SetNillableLastUsed(t *time.Time) *ApiKeyUpdateOne {
	if t != nil {
		akuo.SetLastUsed(*t)
	}
	return akuo
}

// ClearLastUsed clears the value of the "last_used" field.
func (akuo *ApiKeyUpdateOne) ClearLastUsed() *ApiKeyUpdateOne {
	akuo.mutation.ClearLastUsed()
	return akuo
}

// SetCreatedAt sets the "created_at" field.
func (akuo *ApiKeyUpdateOne) SetCreatedAt(t time.Time) *ApiKeyUpdateOne {
	akuo.mutation.SetCreatedAt(t)
	return akuo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (akuo *ApiKeyUpdateOne) SetNillableCreatedAt(t *time.Time) *ApiKeyUpdateOne {
	if t != nil {
		akuo.SetCreatedAt(*t)
	}
	return akuo
}

// SetUpdatedAt sets the "updated_at" field.
func (akuo *ApiKeyUpdateOne) SetUpdatedAt(t time.Time) *ApiKeyUpdateOne {
	akuo.mutation.SetUpdatedAt(t)
	return akuo
}

// SetUser sets the "user" edge to the User entity.
func (akuo *ApiKeyUpdateOne) SetUser(u *User) *ApiKeyUpdateOne {
	return akuo.SetUserID(u.ID)
}

// Mutation returns the ApiKeyMutation object of the builder.
func (akuo *ApiKeyUpdateOne) Mutation() *ApiKeyMutation {
	return akuo.mutation
}

// ClearUser clears the "user" edge to the User entity.
func (akuo *ApiKeyUpdateOne) ClearUser() *ApiKeyUpdateOne {
	akuo.mutation.ClearUser()
	return akuo
}

// Where appends a list predicates to the ApiKeyUpdate builder.
func (akuo *ApiKeyUpdateOne) Where(ps ...predicate.ApiKey) *ApiKeyUpdateOne {
	akuo.mutation.Where(ps...)
	return akuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (akuo *ApiKeyUpdateOne) Select(field string, fields ...string) *ApiKeyUpdateOne {
	akuo.fields = append([]string{field}, fields...)
	return akuo
}

// Save executes the query and returns the updated ApiKey entity.
func (akuo *ApiKeyUpdateOne) Save(ctx context.Context) (*ApiKey, error) {
	akuo.defaults()
	return withHooks(ctx, akuo.sqlSave, akuo.mutation, akuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (akuo *ApiKeyUpdateOne) SaveX(ctx context.Context) *ApiKey {
	node, err := akuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (akuo *ApiKeyUpdateOne) Exec(ctx context.Context) error {
	_, err := akuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (akuo *ApiKeyUpdateOne) ExecX(ctx context.Context) {
	if err := akuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (akuo *ApiKeyUpdateOne) defaults() {
	if _, ok := akuo.mutation.UpdatedAt(); !ok {
		v := apikey.UpdateDefaultUpdatedAt()
		akuo.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (akuo *ApiKeyUpdateOne) check() error {
	if akuo.mutation.UserCleared() && len(akuo.mutation.UserIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "ApiKey.user"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (akuo *ApiKeyUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *ApiKeyUpdateOne {
	akuo.modifiers = append(akuo.modifiers, modifiers...)
	return akuo
}

func (akuo *ApiKeyUpdateOne) sqlSave(ctx context.Context) (_node *ApiKey, err error) {
	if err := akuo.check(); err != nil {
		return _node, err
	}
	_spec := sqlgraph.NewUpdateSpec(apikey.Table, apikey.Columns, sqlgraph.NewFieldSpec(apikey.FieldID, field.TypeUUID))
	id, ok := akuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "ApiKey.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := akuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, apikey.FieldID)
		for _, f := range fields {
			if !apikey.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != apikey.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := akuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := akuo.mutation.Key(); ok {
		_spec.SetField(apikey.FieldKey, field.TypeString, value)
	}
	if value, ok := akuo.mutation.Name(); ok {
		_spec.SetField(apikey.FieldName, field.TypeString, value)
	}
	if value, ok := akuo.mutation.Status(); ok {
		_spec.SetField(apikey.FieldStatus, field.TypeString, value)
	}
	if value, ok := akuo.mutation.LastUsed(); ok {
		_spec.SetField(apikey.FieldLastUsed, field.TypeTime, value)
	}
	if akuo.mutation.LastUsedCleared() {
		_spec.ClearField(apikey.FieldLastUsed, field.TypeTime)
	}
	if value, ok := akuo.mutation.CreatedAt(); ok {
		_spec.SetField(apikey.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := akuo.mutation.UpdatedAt(); ok {
		_spec.SetField(apikey.FieldUpdatedAt, field.TypeTime, value)
	}
	if akuo.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   apikey.UserTable,
			Columns: []string{apikey.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := akuo.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   apikey.UserTable,
			Columns: []string{apikey.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(akuo.modifiers...)
	_node = &ApiKey{config: akuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, akuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{apikey.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	akuo.mutation.done = true
	return _node, nil
}
