// Code generated by ent, DO NOT EDIT.

package db

import (
	"encoding/json"
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/db/billingplan"
)

// BillingPlan is the model entity for the BillingPlan schema.
type BillingPlan struct {
	config `json:"-"`
	// ID of the ent.
	ID string `json:"id,omitempty"`
	// Name holds the value of the "name" field.
	Name string `json:"name,omitempty"`
	// Description holds the value of the "description" field.
	Description string `json:"description,omitempty"`
	// Rules holds the value of the "rules" field.
	Rules map[string]interface{} `json:"rules,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt    time.Time `json:"updated_at,omitempty"`
	selectValues sql.SelectValues
}

// scanValues returns the types for scanning values from sql.Rows.
func (*BillingPlan) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case billingplan.FieldRules:
			values[i] = new([]byte)
		case billingplan.FieldID, billingplan.FieldName, billingplan.FieldDescription:
			values[i] = new(sql.NullString)
		case billingplan.FieldCreatedAt, billingplan.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the BillingPlan fields.
func (bp *BillingPlan) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case billingplan.FieldID:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value.Valid {
				bp.ID = value.String
			}
		case billingplan.FieldName:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field name", values[i])
			} else if value.Valid {
				bp.Name = value.String
			}
		case billingplan.FieldDescription:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field description", values[i])
			} else if value.Valid {
				bp.Description = value.String
			}
		case billingplan.FieldRules:
			if value, ok := values[i].(*[]byte); !ok {
				return fmt.Errorf("unexpected type %T for field rules", values[i])
			} else if value != nil && len(*value) > 0 {
				if err := json.Unmarshal(*value, &bp.Rules); err != nil {
					return fmt.Errorf("unmarshal field rules: %w", err)
				}
			}
		case billingplan.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				bp.CreatedAt = value.Time
			}
		case billingplan.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				bp.UpdatedAt = value.Time
			}
		default:
			bp.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the BillingPlan.
// This includes values selected through modifiers, order, etc.
func (bp *BillingPlan) Value(name string) (ent.Value, error) {
	return bp.selectValues.Get(name)
}

// Update returns a builder for updating this BillingPlan.
// Note that you need to call BillingPlan.Unwrap() before calling this method if this BillingPlan
// was returned from a transaction, and the transaction was committed or rolled back.
func (bp *BillingPlan) Update() *BillingPlanUpdateOne {
	return NewBillingPlanClient(bp.config).UpdateOne(bp)
}

// Unwrap unwraps the BillingPlan entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (bp *BillingPlan) Unwrap() *BillingPlan {
	_tx, ok := bp.config.driver.(*txDriver)
	if !ok {
		panic("db: BillingPlan is not a transactional entity")
	}
	bp.config.driver = _tx.drv
	return bp
}

// String implements the fmt.Stringer.
func (bp *BillingPlan) String() string {
	var builder strings.Builder
	builder.WriteString("BillingPlan(")
	builder.WriteString(fmt.Sprintf("id=%v, ", bp.ID))
	builder.WriteString("name=")
	builder.WriteString(bp.Name)
	builder.WriteString(", ")
	builder.WriteString("description=")
	builder.WriteString(bp.Description)
	builder.WriteString(", ")
	builder.WriteString("rules=")
	builder.WriteString(fmt.Sprintf("%v", bp.Rules))
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(bp.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(bp.UpdatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// BillingPlans is a parsable slice of BillingPlan.
type BillingPlans []*BillingPlan
