// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/billingplan"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
)

// BillingPlanUpdate is the builder for updating BillingPlan entities.
type BillingPlanUpdate struct {
	config
	hooks     []Hook
	mutation  *BillingPlanMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the BillingPlanUpdate builder.
func (bpu *BillingPlanUpdate) Where(ps ...predicate.BillingPlan) *BillingPlanUpdate {
	bpu.mutation.Where(ps...)
	return bpu
}

// SetName sets the "name" field.
func (bpu *BillingPlanUpdate) SetName(s string) *BillingPlanUpdate {
	bpu.mutation.SetName(s)
	return bpu
}

// SetNillableName sets the "name" field if the given value is not nil.
func (bpu *BillingPlanUpdate) SetNillableName(s *string) *BillingPlanUpdate {
	if s != nil {
		bpu.SetName(*s)
	}
	return bpu
}

// SetDescription sets the "description" field.
func (bpu *BillingPlanUpdate) SetDescription(s string) *BillingPlanUpdate {
	bpu.mutation.SetDescription(s)
	return bpu
}

// SetNillableDescription sets the "description" field if the given value is not nil.
func (bpu *BillingPlanUpdate) SetNillableDescription(s *string) *BillingPlanUpdate {
	if s != nil {
		bpu.SetDescription(*s)
	}
	return bpu
}

// SetRules sets the "rules" field.
func (bpu *BillingPlanUpdate) SetRules(m map[string]interface{}) *BillingPlanUpdate {
	bpu.mutation.SetRules(m)
	return bpu
}

// SetCreatedAt sets the "created_at" field.
func (bpu *BillingPlanUpdate) SetCreatedAt(t time.Time) *BillingPlanUpdate {
	bpu.mutation.SetCreatedAt(t)
	return bpu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (bpu *BillingPlanUpdate) SetNillableCreatedAt(t *time.Time) *BillingPlanUpdate {
	if t != nil {
		bpu.SetCreatedAt(*t)
	}
	return bpu
}

// SetUpdatedAt sets the "updated_at" field.
func (bpu *BillingPlanUpdate) SetUpdatedAt(t time.Time) *BillingPlanUpdate {
	bpu.mutation.SetUpdatedAt(t)
	return bpu
}

// Mutation returns the BillingPlanMutation object of the builder.
func (bpu *BillingPlanUpdate) Mutation() *BillingPlanMutation {
	return bpu.mutation
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (bpu *BillingPlanUpdate) Save(ctx context.Context) (int, error) {
	bpu.defaults()
	return withHooks(ctx, bpu.sqlSave, bpu.mutation, bpu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (bpu *BillingPlanUpdate) SaveX(ctx context.Context) int {
	affected, err := bpu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (bpu *BillingPlanUpdate) Exec(ctx context.Context) error {
	_, err := bpu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (bpu *BillingPlanUpdate) ExecX(ctx context.Context) {
	if err := bpu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (bpu *BillingPlanUpdate) defaults() {
	if _, ok := bpu.mutation.UpdatedAt(); !ok {
		v := billingplan.UpdateDefaultUpdatedAt()
		bpu.mutation.SetUpdatedAt(v)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (bpu *BillingPlanUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *BillingPlanUpdate {
	bpu.modifiers = append(bpu.modifiers, modifiers...)
	return bpu
}

func (bpu *BillingPlanUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(billingplan.Table, billingplan.Columns, sqlgraph.NewFieldSpec(billingplan.FieldID, field.TypeString))
	if ps := bpu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := bpu.mutation.Name(); ok {
		_spec.SetField(billingplan.FieldName, field.TypeString, value)
	}
	if value, ok := bpu.mutation.Description(); ok {
		_spec.SetField(billingplan.FieldDescription, field.TypeString, value)
	}
	if value, ok := bpu.mutation.Rules(); ok {
		_spec.SetField(billingplan.FieldRules, field.TypeJSON, value)
	}
	if value, ok := bpu.mutation.CreatedAt(); ok {
		_spec.SetField(billingplan.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := bpu.mutation.UpdatedAt(); ok {
		_spec.SetField(billingplan.FieldUpdatedAt, field.TypeTime, value)
	}
	_spec.AddModifiers(bpu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, bpu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{billingplan.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	bpu.mutation.done = true
	return n, nil
}

// BillingPlanUpdateOne is the builder for updating a single BillingPlan entity.
type BillingPlanUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *BillingPlanMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetName sets the "name" field.
func (bpuo *BillingPlanUpdateOne) SetName(s string) *BillingPlanUpdateOne {
	bpuo.mutation.SetName(s)
	return bpuo
}

// SetNillableName sets the "name" field if the given value is not nil.
func (bpuo *BillingPlanUpdateOne) SetNillableName(s *string) *BillingPlanUpdateOne {
	if s != nil {
		bpuo.SetName(*s)
	}
	return bpuo
}

// SetDescription sets the "description" field.
func (bpuo *BillingPlanUpdateOne) SetDescription(s string) *BillingPlanUpdateOne {
	bpuo.mutation.SetDescription(s)
	return bpuo
}

// SetNillableDescription sets the "description" field if the given value is not nil.
func (bpuo *BillingPlanUpdateOne) SetNillableDescription(s *string) *BillingPlanUpdateOne {
	if s != nil {
		bpuo.SetDescription(*s)
	}
	return bpuo
}

// SetRules sets the "rules" field.
func (bpuo *BillingPlanUpdateOne) SetRules(m map[string]interface{}) *BillingPlanUpdateOne {
	bpuo.mutation.SetRules(m)
	return bpuo
}

// SetCreatedAt sets the "created_at" field.
func (bpuo *BillingPlanUpdateOne) SetCreatedAt(t time.Time) *BillingPlanUpdateOne {
	bpuo.mutation.SetCreatedAt(t)
	return bpuo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (bpuo *BillingPlanUpdateOne) SetNillableCreatedAt(t *time.Time) *BillingPlanUpdateOne {
	if t != nil {
		bpuo.SetCreatedAt(*t)
	}
	return bpuo
}

// SetUpdatedAt sets the "updated_at" field.
func (bpuo *BillingPlanUpdateOne) SetUpdatedAt(t time.Time) *BillingPlanUpdateOne {
	bpuo.mutation.SetUpdatedAt(t)
	return bpuo
}

// Mutation returns the BillingPlanMutation object of the builder.
func (bpuo *BillingPlanUpdateOne) Mutation() *BillingPlanMutation {
	return bpuo.mutation
}

// Where appends a list predicates to the BillingPlanUpdate builder.
func (bpuo *BillingPlanUpdateOne) Where(ps ...predicate.BillingPlan) *BillingPlanUpdateOne {
	bpuo.mutation.Where(ps...)
	return bpuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (bpuo *BillingPlanUpdateOne) Select(field string, fields ...string) *BillingPlanUpdateOne {
	bpuo.fields = append([]string{field}, fields...)
	return bpuo
}

// Save executes the query and returns the updated BillingPlan entity.
func (bpuo *BillingPlanUpdateOne) Save(ctx context.Context) (*BillingPlan, error) {
	bpuo.defaults()
	return withHooks(ctx, bpuo.sqlSave, bpuo.mutation, bpuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (bpuo *BillingPlanUpdateOne) SaveX(ctx context.Context) *BillingPlan {
	node, err := bpuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (bpuo *BillingPlanUpdateOne) Exec(ctx context.Context) error {
	_, err := bpuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (bpuo *BillingPlanUpdateOne) ExecX(ctx context.Context) {
	if err := bpuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (bpuo *BillingPlanUpdateOne) defaults() {
	if _, ok := bpuo.mutation.UpdatedAt(); !ok {
		v := billingplan.UpdateDefaultUpdatedAt()
		bpuo.mutation.SetUpdatedAt(v)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (bpuo *BillingPlanUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *BillingPlanUpdateOne {
	bpuo.modifiers = append(bpuo.modifiers, modifiers...)
	return bpuo
}

func (bpuo *BillingPlanUpdateOne) sqlSave(ctx context.Context) (_node *BillingPlan, err error) {
	_spec := sqlgraph.NewUpdateSpec(billingplan.Table, billingplan.Columns, sqlgraph.NewFieldSpec(billingplan.FieldID, field.TypeString))
	id, ok := bpuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "BillingPlan.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := bpuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, billingplan.FieldID)
		for _, f := range fields {
			if !billingplan.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != billingplan.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := bpuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := bpuo.mutation.Name(); ok {
		_spec.SetField(billingplan.FieldName, field.TypeString, value)
	}
	if value, ok := bpuo.mutation.Description(); ok {
		_spec.SetField(billingplan.FieldDescription, field.TypeString, value)
	}
	if value, ok := bpuo.mutation.Rules(); ok {
		_spec.SetField(billingplan.FieldRules, field.TypeJSON, value)
	}
	if value, ok := bpuo.mutation.CreatedAt(); ok {
		_spec.SetField(billingplan.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := bpuo.mutation.UpdatedAt(); ok {
		_spec.SetField(billingplan.FieldUpdatedAt, field.TypeTime, value)
	}
	_spec.AddModifiers(bpuo.modifiers...)
	_node = &BillingPlan{config: bpuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, bpuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{billingplan.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	bpuo.mutation.done = true
	return _node, nil
}
