// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/billingquota"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
)

// BillingQuotaDelete is the builder for deleting a BillingQuota entity.
type BillingQuotaDelete struct {
	config
	hooks    []Hook
	mutation *BillingQuotaMutation
}

// Where appends a list predicates to the BillingQuotaDelete builder.
func (bqd *BillingQuotaDelete) Where(ps ...predicate.BillingQuota) *BillingQuotaDelete {
	bqd.mutation.Where(ps...)
	return bqd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (bqd *BillingQuotaDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, bqd.sqlExec, bqd.mutation, bqd.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (bqd *BillingQuotaDelete) ExecX(ctx context.Context) int {
	n, err := bqd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (bqd *BillingQuotaDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(billingquota.Table, sqlgraph.NewFieldSpec(billingquota.FieldID, field.TypeString))
	if ps := bqd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, bqd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	bqd.mutation.done = true
	return affected, err
}

// BillingQuotaDeleteOne is the builder for deleting a single BillingQuota entity.
type BillingQuotaDeleteOne struct {
	bqd *BillingQuotaDelete
}

// Where appends a list predicates to the BillingQuotaDelete builder.
func (bqdo *BillingQuotaDeleteOne) Where(ps ...predicate.BillingQuota) *BillingQuotaDeleteOne {
	bqdo.bqd.mutation.Where(ps...)
	return bqdo
}

// Exec executes the deletion query.
func (bqdo *BillingQuotaDeleteOne) Exec(ctx context.Context) error {
	n, err := bqdo.bqd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{billingquota.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (bqdo *BillingQuotaDeleteOne) ExecX(ctx context.Context) {
	if err := bqdo.Exec(ctx); err != nil {
		panic(err)
	}
}
