// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/billingquota"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
)

// BillingQuotaUpdate is the builder for updating BillingQuota entities.
type BillingQuotaUpdate struct {
	config
	hooks     []Hook
	mutation  *BillingQuotaMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the BillingQuotaUpdate builder.
func (bqu *BillingQuotaUpdate) Where(ps ...predicate.BillingQuota) *BillingQuotaUpdate {
	bqu.mutation.Where(ps...)
	return bqu
}

// SetDeletedAt sets the "deleted_at" field.
func (bqu *BillingQuotaUpdate) SetDeletedAt(t time.Time) *BillingQuotaUpdate {
	bqu.mutation.SetDeletedAt(t)
	return bqu
}

// SetNillableDeletedAt sets the "deleted_at" field if the given value is not nil.
func (bqu *BillingQuotaUpdate) SetNillableDeletedAt(t *time.Time) *BillingQuotaUpdate {
	if t != nil {
		bqu.SetDeletedAt(*t)
	}
	return bqu
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (bqu *BillingQuotaUpdate) ClearDeletedAt() *BillingQuotaUpdate {
	bqu.mutation.ClearDeletedAt()
	return bqu
}

// SetUserID sets the "user_id" field.
func (bqu *BillingQuotaUpdate) SetUserID(s string) *BillingQuotaUpdate {
	bqu.mutation.SetUserID(s)
	return bqu
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (bqu *BillingQuotaUpdate) SetNillableUserID(s *string) *BillingQuotaUpdate {
	if s != nil {
		bqu.SetUserID(*s)
	}
	return bqu
}

// SetTotal sets the "total" field.
func (bqu *BillingQuotaUpdate) SetTotal(i int64) *BillingQuotaUpdate {
	bqu.mutation.ResetTotal()
	bqu.mutation.SetTotal(i)
	return bqu
}

// SetNillableTotal sets the "total" field if the given value is not nil.
func (bqu *BillingQuotaUpdate) SetNillableTotal(i *int64) *BillingQuotaUpdate {
	if i != nil {
		bqu.SetTotal(*i)
	}
	return bqu
}

// AddTotal adds i to the "total" field.
func (bqu *BillingQuotaUpdate) AddTotal(i int64) *BillingQuotaUpdate {
	bqu.mutation.AddTotal(i)
	return bqu
}

// SetUsed sets the "used" field.
func (bqu *BillingQuotaUpdate) SetUsed(i int64) *BillingQuotaUpdate {
	bqu.mutation.ResetUsed()
	bqu.mutation.SetUsed(i)
	return bqu
}

// SetNillableUsed sets the "used" field if the given value is not nil.
func (bqu *BillingQuotaUpdate) SetNillableUsed(i *int64) *BillingQuotaUpdate {
	if i != nil {
		bqu.SetUsed(*i)
	}
	return bqu
}

// AddUsed adds i to the "used" field.
func (bqu *BillingQuotaUpdate) AddUsed(i int64) *BillingQuotaUpdate {
	bqu.mutation.AddUsed(i)
	return bqu
}

// SetRemain sets the "remain" field.
func (bqu *BillingQuotaUpdate) SetRemain(i int64) *BillingQuotaUpdate {
	bqu.mutation.ResetRemain()
	bqu.mutation.SetRemain(i)
	return bqu
}

// SetNillableRemain sets the "remain" field if the given value is not nil.
func (bqu *BillingQuotaUpdate) SetNillableRemain(i *int64) *BillingQuotaUpdate {
	if i != nil {
		bqu.SetRemain(*i)
	}
	return bqu
}

// AddRemain adds i to the "remain" field.
func (bqu *BillingQuotaUpdate) AddRemain(i int64) *BillingQuotaUpdate {
	bqu.mutation.AddRemain(i)
	return bqu
}

// SetCreatedAt sets the "created_at" field.
func (bqu *BillingQuotaUpdate) SetCreatedAt(t time.Time) *BillingQuotaUpdate {
	bqu.mutation.SetCreatedAt(t)
	return bqu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (bqu *BillingQuotaUpdate) SetNillableCreatedAt(t *time.Time) *BillingQuotaUpdate {
	if t != nil {
		bqu.SetCreatedAt(*t)
	}
	return bqu
}

// SetUpdatedAt sets the "updated_at" field.
func (bqu *BillingQuotaUpdate) SetUpdatedAt(t time.Time) *BillingQuotaUpdate {
	bqu.mutation.SetUpdatedAt(t)
	return bqu
}

// Mutation returns the BillingQuotaMutation object of the builder.
func (bqu *BillingQuotaUpdate) Mutation() *BillingQuotaMutation {
	return bqu.mutation
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (bqu *BillingQuotaUpdate) Save(ctx context.Context) (int, error) {
	if err := bqu.defaults(); err != nil {
		return 0, err
	}
	return withHooks(ctx, bqu.sqlSave, bqu.mutation, bqu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (bqu *BillingQuotaUpdate) SaveX(ctx context.Context) int {
	affected, err := bqu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (bqu *BillingQuotaUpdate) Exec(ctx context.Context) error {
	_, err := bqu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (bqu *BillingQuotaUpdate) ExecX(ctx context.Context) {
	if err := bqu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (bqu *BillingQuotaUpdate) defaults() error {
	if _, ok := bqu.mutation.UpdatedAt(); !ok {
		if billingquota.UpdateDefaultUpdatedAt == nil {
			return fmt.Errorf("db: uninitialized billingquota.UpdateDefaultUpdatedAt (forgotten import db/runtime?)")
		}
		v := billingquota.UpdateDefaultUpdatedAt()
		bqu.mutation.SetUpdatedAt(v)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (bqu *BillingQuotaUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *BillingQuotaUpdate {
	bqu.modifiers = append(bqu.modifiers, modifiers...)
	return bqu
}

func (bqu *BillingQuotaUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(billingquota.Table, billingquota.Columns, sqlgraph.NewFieldSpec(billingquota.FieldID, field.TypeString))
	if ps := bqu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := bqu.mutation.DeletedAt(); ok {
		_spec.SetField(billingquota.FieldDeletedAt, field.TypeTime, value)
	}
	if bqu.mutation.DeletedAtCleared() {
		_spec.ClearField(billingquota.FieldDeletedAt, field.TypeTime)
	}
	if value, ok := bqu.mutation.UserID(); ok {
		_spec.SetField(billingquota.FieldUserID, field.TypeString, value)
	}
	if value, ok := bqu.mutation.Total(); ok {
		_spec.SetField(billingquota.FieldTotal, field.TypeInt64, value)
	}
	if value, ok := bqu.mutation.AddedTotal(); ok {
		_spec.AddField(billingquota.FieldTotal, field.TypeInt64, value)
	}
	if value, ok := bqu.mutation.Used(); ok {
		_spec.SetField(billingquota.FieldUsed, field.TypeInt64, value)
	}
	if value, ok := bqu.mutation.AddedUsed(); ok {
		_spec.AddField(billingquota.FieldUsed, field.TypeInt64, value)
	}
	if value, ok := bqu.mutation.Remain(); ok {
		_spec.SetField(billingquota.FieldRemain, field.TypeInt64, value)
	}
	if value, ok := bqu.mutation.AddedRemain(); ok {
		_spec.AddField(billingquota.FieldRemain, field.TypeInt64, value)
	}
	if value, ok := bqu.mutation.CreatedAt(); ok {
		_spec.SetField(billingquota.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := bqu.mutation.UpdatedAt(); ok {
		_spec.SetField(billingquota.FieldUpdatedAt, field.TypeTime, value)
	}
	_spec.AddModifiers(bqu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, bqu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{billingquota.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	bqu.mutation.done = true
	return n, nil
}

// BillingQuotaUpdateOne is the builder for updating a single BillingQuota entity.
type BillingQuotaUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *BillingQuotaMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetDeletedAt sets the "deleted_at" field.
func (bquo *BillingQuotaUpdateOne) SetDeletedAt(t time.Time) *BillingQuotaUpdateOne {
	bquo.mutation.SetDeletedAt(t)
	return bquo
}

// SetNillableDeletedAt sets the "deleted_at" field if the given value is not nil.
func (bquo *BillingQuotaUpdateOne) SetNillableDeletedAt(t *time.Time) *BillingQuotaUpdateOne {
	if t != nil {
		bquo.SetDeletedAt(*t)
	}
	return bquo
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (bquo *BillingQuotaUpdateOne) ClearDeletedAt() *BillingQuotaUpdateOne {
	bquo.mutation.ClearDeletedAt()
	return bquo
}

// SetUserID sets the "user_id" field.
func (bquo *BillingQuotaUpdateOne) SetUserID(s string) *BillingQuotaUpdateOne {
	bquo.mutation.SetUserID(s)
	return bquo
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (bquo *BillingQuotaUpdateOne) SetNillableUserID(s *string) *BillingQuotaUpdateOne {
	if s != nil {
		bquo.SetUserID(*s)
	}
	return bquo
}

// SetTotal sets the "total" field.
func (bquo *BillingQuotaUpdateOne) SetTotal(i int64) *BillingQuotaUpdateOne {
	bquo.mutation.ResetTotal()
	bquo.mutation.SetTotal(i)
	return bquo
}

// SetNillableTotal sets the "total" field if the given value is not nil.
func (bquo *BillingQuotaUpdateOne) SetNillableTotal(i *int64) *BillingQuotaUpdateOne {
	if i != nil {
		bquo.SetTotal(*i)
	}
	return bquo
}

// AddTotal adds i to the "total" field.
func (bquo *BillingQuotaUpdateOne) AddTotal(i int64) *BillingQuotaUpdateOne {
	bquo.mutation.AddTotal(i)
	return bquo
}

// SetUsed sets the "used" field.
func (bquo *BillingQuotaUpdateOne) SetUsed(i int64) *BillingQuotaUpdateOne {
	bquo.mutation.ResetUsed()
	bquo.mutation.SetUsed(i)
	return bquo
}

// SetNillableUsed sets the "used" field if the given value is not nil.
func (bquo *BillingQuotaUpdateOne) SetNillableUsed(i *int64) *BillingQuotaUpdateOne {
	if i != nil {
		bquo.SetUsed(*i)
	}
	return bquo
}

// AddUsed adds i to the "used" field.
func (bquo *BillingQuotaUpdateOne) AddUsed(i int64) *BillingQuotaUpdateOne {
	bquo.mutation.AddUsed(i)
	return bquo
}

// SetRemain sets the "remain" field.
func (bquo *BillingQuotaUpdateOne) SetRemain(i int64) *BillingQuotaUpdateOne {
	bquo.mutation.ResetRemain()
	bquo.mutation.SetRemain(i)
	return bquo
}

// SetNillableRemain sets the "remain" field if the given value is not nil.
func (bquo *BillingQuotaUpdateOne) SetNillableRemain(i *int64) *BillingQuotaUpdateOne {
	if i != nil {
		bquo.SetRemain(*i)
	}
	return bquo
}

// AddRemain adds i to the "remain" field.
func (bquo *BillingQuotaUpdateOne) AddRemain(i int64) *BillingQuotaUpdateOne {
	bquo.mutation.AddRemain(i)
	return bquo
}

// SetCreatedAt sets the "created_at" field.
func (bquo *BillingQuotaUpdateOne) SetCreatedAt(t time.Time) *BillingQuotaUpdateOne {
	bquo.mutation.SetCreatedAt(t)
	return bquo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (bquo *BillingQuotaUpdateOne) SetNillableCreatedAt(t *time.Time) *BillingQuotaUpdateOne {
	if t != nil {
		bquo.SetCreatedAt(*t)
	}
	return bquo
}

// SetUpdatedAt sets the "updated_at" field.
func (bquo *BillingQuotaUpdateOne) SetUpdatedAt(t time.Time) *BillingQuotaUpdateOne {
	bquo.mutation.SetUpdatedAt(t)
	return bquo
}

// Mutation returns the BillingQuotaMutation object of the builder.
func (bquo *BillingQuotaUpdateOne) Mutation() *BillingQuotaMutation {
	return bquo.mutation
}

// Where appends a list predicates to the BillingQuotaUpdate builder.
func (bquo *BillingQuotaUpdateOne) Where(ps ...predicate.BillingQuota) *BillingQuotaUpdateOne {
	bquo.mutation.Where(ps...)
	return bquo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (bquo *BillingQuotaUpdateOne) Select(field string, fields ...string) *BillingQuotaUpdateOne {
	bquo.fields = append([]string{field}, fields...)
	return bquo
}

// Save executes the query and returns the updated BillingQuota entity.
func (bquo *BillingQuotaUpdateOne) Save(ctx context.Context) (*BillingQuota, error) {
	if err := bquo.defaults(); err != nil {
		return nil, err
	}
	return withHooks(ctx, bquo.sqlSave, bquo.mutation, bquo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (bquo *BillingQuotaUpdateOne) SaveX(ctx context.Context) *BillingQuota {
	node, err := bquo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (bquo *BillingQuotaUpdateOne) Exec(ctx context.Context) error {
	_, err := bquo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (bquo *BillingQuotaUpdateOne) ExecX(ctx context.Context) {
	if err := bquo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (bquo *BillingQuotaUpdateOne) defaults() error {
	if _, ok := bquo.mutation.UpdatedAt(); !ok {
		if billingquota.UpdateDefaultUpdatedAt == nil {
			return fmt.Errorf("db: uninitialized billingquota.UpdateDefaultUpdatedAt (forgotten import db/runtime?)")
		}
		v := billingquota.UpdateDefaultUpdatedAt()
		bquo.mutation.SetUpdatedAt(v)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (bquo *BillingQuotaUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *BillingQuotaUpdateOne {
	bquo.modifiers = append(bquo.modifiers, modifiers...)
	return bquo
}

func (bquo *BillingQuotaUpdateOne) sqlSave(ctx context.Context) (_node *BillingQuota, err error) {
	_spec := sqlgraph.NewUpdateSpec(billingquota.Table, billingquota.Columns, sqlgraph.NewFieldSpec(billingquota.FieldID, field.TypeString))
	id, ok := bquo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "BillingQuota.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := bquo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, billingquota.FieldID)
		for _, f := range fields {
			if !billingquota.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != billingquota.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := bquo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := bquo.mutation.DeletedAt(); ok {
		_spec.SetField(billingquota.FieldDeletedAt, field.TypeTime, value)
	}
	if bquo.mutation.DeletedAtCleared() {
		_spec.ClearField(billingquota.FieldDeletedAt, field.TypeTime)
	}
	if value, ok := bquo.mutation.UserID(); ok {
		_spec.SetField(billingquota.FieldUserID, field.TypeString, value)
	}
	if value, ok := bquo.mutation.Total(); ok {
		_spec.SetField(billingquota.FieldTotal, field.TypeInt64, value)
	}
	if value, ok := bquo.mutation.AddedTotal(); ok {
		_spec.AddField(billingquota.FieldTotal, field.TypeInt64, value)
	}
	if value, ok := bquo.mutation.Used(); ok {
		_spec.SetField(billingquota.FieldUsed, field.TypeInt64, value)
	}
	if value, ok := bquo.mutation.AddedUsed(); ok {
		_spec.AddField(billingquota.FieldUsed, field.TypeInt64, value)
	}
	if value, ok := bquo.mutation.Remain(); ok {
		_spec.SetField(billingquota.FieldRemain, field.TypeInt64, value)
	}
	if value, ok := bquo.mutation.AddedRemain(); ok {
		_spec.AddField(billingquota.FieldRemain, field.TypeInt64, value)
	}
	if value, ok := bquo.mutation.CreatedAt(); ok {
		_spec.SetField(billingquota.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := bquo.mutation.UpdatedAt(); ok {
		_spec.SetField(billingquota.FieldUpdatedAt, field.TypeTime, value)
	}
	_spec.AddModifiers(bquo.modifiers...)
	_node = &BillingQuota{config: bquo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, bquo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{billingquota.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	bquo.mutation.done = true
	return _node, nil
}
