// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/billingrecord"
)

// BillingRecordCreate is the builder for creating a BillingRecord entity.
type BillingRecordCreate struct {
	config
	mutation *BillingRecordMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetTenantID sets the "tenant_id" field.
func (brc *BillingRecordCreate) SetTenantID(s string) *BillingRecordCreate {
	brc.mutation.SetTenantID(s)
	return brc
}

// SetUserID sets the "user_id" field.
func (brc *BillingRecordCreate) SetUserID(s string) *BillingRecordCreate {
	brc.mutation.SetUserID(s)
	return brc
}

// SetModel sets the "model" field.
func (brc *BillingRecordCreate) SetModel(s string) *BillingRecordCreate {
	brc.mutation.SetModel(s)
	return brc
}

// SetOperation sets the "operation" field.
func (brc *BillingRecordCreate) SetOperation(s string) *BillingRecordCreate {
	brc.mutation.SetOperation(s)
	return brc
}

// SetInputTokens sets the "input_tokens" field.
func (brc *BillingRecordCreate) SetInputTokens(i int64) *BillingRecordCreate {
	brc.mutation.SetInputTokens(i)
	return brc
}

// SetOutputTokens sets the "output_tokens" field.
func (brc *BillingRecordCreate) SetOutputTokens(i int64) *BillingRecordCreate {
	brc.mutation.SetOutputTokens(i)
	return brc
}

// SetCost sets the "cost" field.
func (brc *BillingRecordCreate) SetCost(i int64) *BillingRecordCreate {
	brc.mutation.SetCost(i)
	return brc
}

// SetRequestTime sets the "request_time" field.
func (brc *BillingRecordCreate) SetRequestTime(t time.Time) *BillingRecordCreate {
	brc.mutation.SetRequestTime(t)
	return brc
}

// SetNillableRequestTime sets the "request_time" field if the given value is not nil.
func (brc *BillingRecordCreate) SetNillableRequestTime(t *time.Time) *BillingRecordCreate {
	if t != nil {
		brc.SetRequestTime(*t)
	}
	return brc
}

// SetMetadata sets the "metadata" field.
func (brc *BillingRecordCreate) SetMetadata(m map[string]interface{}) *BillingRecordCreate {
	brc.mutation.SetMetadata(m)
	return brc
}

// SetCreatedAt sets the "created_at" field.
func (brc *BillingRecordCreate) SetCreatedAt(t time.Time) *BillingRecordCreate {
	brc.mutation.SetCreatedAt(t)
	return brc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (brc *BillingRecordCreate) SetNillableCreatedAt(t *time.Time) *BillingRecordCreate {
	if t != nil {
		brc.SetCreatedAt(*t)
	}
	return brc
}

// SetUpdatedAt sets the "updated_at" field.
func (brc *BillingRecordCreate) SetUpdatedAt(t time.Time) *BillingRecordCreate {
	brc.mutation.SetUpdatedAt(t)
	return brc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (brc *BillingRecordCreate) SetNillableUpdatedAt(t *time.Time) *BillingRecordCreate {
	if t != nil {
		brc.SetUpdatedAt(*t)
	}
	return brc
}

// SetID sets the "id" field.
func (brc *BillingRecordCreate) SetID(s string) *BillingRecordCreate {
	brc.mutation.SetID(s)
	return brc
}

// Mutation returns the BillingRecordMutation object of the builder.
func (brc *BillingRecordCreate) Mutation() *BillingRecordMutation {
	return brc.mutation
}

// Save creates the BillingRecord in the database.
func (brc *BillingRecordCreate) Save(ctx context.Context) (*BillingRecord, error) {
	brc.defaults()
	return withHooks(ctx, brc.sqlSave, brc.mutation, brc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (brc *BillingRecordCreate) SaveX(ctx context.Context) *BillingRecord {
	v, err := brc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (brc *BillingRecordCreate) Exec(ctx context.Context) error {
	_, err := brc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (brc *BillingRecordCreate) ExecX(ctx context.Context) {
	if err := brc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (brc *BillingRecordCreate) defaults() {
	if _, ok := brc.mutation.RequestTime(); !ok {
		v := billingrecord.DefaultRequestTime()
		brc.mutation.SetRequestTime(v)
	}
	if _, ok := brc.mutation.CreatedAt(); !ok {
		v := billingrecord.DefaultCreatedAt()
		brc.mutation.SetCreatedAt(v)
	}
	if _, ok := brc.mutation.UpdatedAt(); !ok {
		v := billingrecord.DefaultUpdatedAt()
		brc.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (brc *BillingRecordCreate) check() error {
	if _, ok := brc.mutation.TenantID(); !ok {
		return &ValidationError{Name: "tenant_id", err: errors.New(`db: missing required field "BillingRecord.tenant_id"`)}
	}
	if _, ok := brc.mutation.UserID(); !ok {
		return &ValidationError{Name: "user_id", err: errors.New(`db: missing required field "BillingRecord.user_id"`)}
	}
	if _, ok := brc.mutation.Model(); !ok {
		return &ValidationError{Name: "model", err: errors.New(`db: missing required field "BillingRecord.model"`)}
	}
	if _, ok := brc.mutation.Operation(); !ok {
		return &ValidationError{Name: "operation", err: errors.New(`db: missing required field "BillingRecord.operation"`)}
	}
	if _, ok := brc.mutation.InputTokens(); !ok {
		return &ValidationError{Name: "input_tokens", err: errors.New(`db: missing required field "BillingRecord.input_tokens"`)}
	}
	if _, ok := brc.mutation.OutputTokens(); !ok {
		return &ValidationError{Name: "output_tokens", err: errors.New(`db: missing required field "BillingRecord.output_tokens"`)}
	}
	if _, ok := brc.mutation.Cost(); !ok {
		return &ValidationError{Name: "cost", err: errors.New(`db: missing required field "BillingRecord.cost"`)}
	}
	if _, ok := brc.mutation.RequestTime(); !ok {
		return &ValidationError{Name: "request_time", err: errors.New(`db: missing required field "BillingRecord.request_time"`)}
	}
	if _, ok := brc.mutation.Metadata(); !ok {
		return &ValidationError{Name: "metadata", err: errors.New(`db: missing required field "BillingRecord.metadata"`)}
	}
	if _, ok := brc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "BillingRecord.created_at"`)}
	}
	if _, ok := brc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`db: missing required field "BillingRecord.updated_at"`)}
	}
	return nil
}

func (brc *BillingRecordCreate) sqlSave(ctx context.Context) (*BillingRecord, error) {
	if err := brc.check(); err != nil {
		return nil, err
	}
	_node, _spec := brc.createSpec()
	if err := sqlgraph.CreateNode(ctx, brc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(string); ok {
			_node.ID = id
		} else {
			return nil, fmt.Errorf("unexpected BillingRecord.ID type: %T", _spec.ID.Value)
		}
	}
	brc.mutation.id = &_node.ID
	brc.mutation.done = true
	return _node, nil
}

func (brc *BillingRecordCreate) createSpec() (*BillingRecord, *sqlgraph.CreateSpec) {
	var (
		_node = &BillingRecord{config: brc.config}
		_spec = sqlgraph.NewCreateSpec(billingrecord.Table, sqlgraph.NewFieldSpec(billingrecord.FieldID, field.TypeString))
	)
	_spec.OnConflict = brc.conflict
	if id, ok := brc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = id
	}
	if value, ok := brc.mutation.TenantID(); ok {
		_spec.SetField(billingrecord.FieldTenantID, field.TypeString, value)
		_node.TenantID = value
	}
	if value, ok := brc.mutation.UserID(); ok {
		_spec.SetField(billingrecord.FieldUserID, field.TypeString, value)
		_node.UserID = value
	}
	if value, ok := brc.mutation.Model(); ok {
		_spec.SetField(billingrecord.FieldModel, field.TypeString, value)
		_node.Model = value
	}
	if value, ok := brc.mutation.Operation(); ok {
		_spec.SetField(billingrecord.FieldOperation, field.TypeString, value)
		_node.Operation = value
	}
	if value, ok := brc.mutation.InputTokens(); ok {
		_spec.SetField(billingrecord.FieldInputTokens, field.TypeInt64, value)
		_node.InputTokens = value
	}
	if value, ok := brc.mutation.OutputTokens(); ok {
		_spec.SetField(billingrecord.FieldOutputTokens, field.TypeInt64, value)
		_node.OutputTokens = value
	}
	if value, ok := brc.mutation.Cost(); ok {
		_spec.SetField(billingrecord.FieldCost, field.TypeInt64, value)
		_node.Cost = value
	}
	if value, ok := brc.mutation.RequestTime(); ok {
		_spec.SetField(billingrecord.FieldRequestTime, field.TypeTime, value)
		_node.RequestTime = value
	}
	if value, ok := brc.mutation.Metadata(); ok {
		_spec.SetField(billingrecord.FieldMetadata, field.TypeJSON, value)
		_node.Metadata = value
	}
	if value, ok := brc.mutation.CreatedAt(); ok {
		_spec.SetField(billingrecord.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := brc.mutation.UpdatedAt(); ok {
		_spec.SetField(billingrecord.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.BillingRecord.Create().
//		SetTenantID(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.BillingRecordUpsert) {
//			SetTenantID(v+v).
//		}).
//		Exec(ctx)
func (brc *BillingRecordCreate) OnConflict(opts ...sql.ConflictOption) *BillingRecordUpsertOne {
	brc.conflict = opts
	return &BillingRecordUpsertOne{
		create: brc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.BillingRecord.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (brc *BillingRecordCreate) OnConflictColumns(columns ...string) *BillingRecordUpsertOne {
	brc.conflict = append(brc.conflict, sql.ConflictColumns(columns...))
	return &BillingRecordUpsertOne{
		create: brc,
	}
}

type (
	// BillingRecordUpsertOne is the builder for "upsert"-ing
	//  one BillingRecord node.
	BillingRecordUpsertOne struct {
		create *BillingRecordCreate
	}

	// BillingRecordUpsert is the "OnConflict" setter.
	BillingRecordUpsert struct {
		*sql.UpdateSet
	}
)

// SetTenantID sets the "tenant_id" field.
func (u *BillingRecordUpsert) SetTenantID(v string) *BillingRecordUpsert {
	u.Set(billingrecord.FieldTenantID, v)
	return u
}

// UpdateTenantID sets the "tenant_id" field to the value that was provided on create.
func (u *BillingRecordUpsert) UpdateTenantID() *BillingRecordUpsert {
	u.SetExcluded(billingrecord.FieldTenantID)
	return u
}

// SetUserID sets the "user_id" field.
func (u *BillingRecordUpsert) SetUserID(v string) *BillingRecordUpsert {
	u.Set(billingrecord.FieldUserID, v)
	return u
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *BillingRecordUpsert) UpdateUserID() *BillingRecordUpsert {
	u.SetExcluded(billingrecord.FieldUserID)
	return u
}

// SetModel sets the "model" field.
func (u *BillingRecordUpsert) SetModel(v string) *BillingRecordUpsert {
	u.Set(billingrecord.FieldModel, v)
	return u
}

// UpdateModel sets the "model" field to the value that was provided on create.
func (u *BillingRecordUpsert) UpdateModel() *BillingRecordUpsert {
	u.SetExcluded(billingrecord.FieldModel)
	return u
}

// SetOperation sets the "operation" field.
func (u *BillingRecordUpsert) SetOperation(v string) *BillingRecordUpsert {
	u.Set(billingrecord.FieldOperation, v)
	return u
}

// UpdateOperation sets the "operation" field to the value that was provided on create.
func (u *BillingRecordUpsert) UpdateOperation() *BillingRecordUpsert {
	u.SetExcluded(billingrecord.FieldOperation)
	return u
}

// SetInputTokens sets the "input_tokens" field.
func (u *BillingRecordUpsert) SetInputTokens(v int64) *BillingRecordUpsert {
	u.Set(billingrecord.FieldInputTokens, v)
	return u
}

// UpdateInputTokens sets the "input_tokens" field to the value that was provided on create.
func (u *BillingRecordUpsert) UpdateInputTokens() *BillingRecordUpsert {
	u.SetExcluded(billingrecord.FieldInputTokens)
	return u
}

// AddInputTokens adds v to the "input_tokens" field.
func (u *BillingRecordUpsert) AddInputTokens(v int64) *BillingRecordUpsert {
	u.Add(billingrecord.FieldInputTokens, v)
	return u
}

// SetOutputTokens sets the "output_tokens" field.
func (u *BillingRecordUpsert) SetOutputTokens(v int64) *BillingRecordUpsert {
	u.Set(billingrecord.FieldOutputTokens, v)
	return u
}

// UpdateOutputTokens sets the "output_tokens" field to the value that was provided on create.
func (u *BillingRecordUpsert) UpdateOutputTokens() *BillingRecordUpsert {
	u.SetExcluded(billingrecord.FieldOutputTokens)
	return u
}

// AddOutputTokens adds v to the "output_tokens" field.
func (u *BillingRecordUpsert) AddOutputTokens(v int64) *BillingRecordUpsert {
	u.Add(billingrecord.FieldOutputTokens, v)
	return u
}

// SetCost sets the "cost" field.
func (u *BillingRecordUpsert) SetCost(v int64) *BillingRecordUpsert {
	u.Set(billingrecord.FieldCost, v)
	return u
}

// UpdateCost sets the "cost" field to the value that was provided on create.
func (u *BillingRecordUpsert) UpdateCost() *BillingRecordUpsert {
	u.SetExcluded(billingrecord.FieldCost)
	return u
}

// AddCost adds v to the "cost" field.
func (u *BillingRecordUpsert) AddCost(v int64) *BillingRecordUpsert {
	u.Add(billingrecord.FieldCost, v)
	return u
}

// SetRequestTime sets the "request_time" field.
func (u *BillingRecordUpsert) SetRequestTime(v time.Time) *BillingRecordUpsert {
	u.Set(billingrecord.FieldRequestTime, v)
	return u
}

// UpdateRequestTime sets the "request_time" field to the value that was provided on create.
func (u *BillingRecordUpsert) UpdateRequestTime() *BillingRecordUpsert {
	u.SetExcluded(billingrecord.FieldRequestTime)
	return u
}

// SetMetadata sets the "metadata" field.
func (u *BillingRecordUpsert) SetMetadata(v map[string]interface{}) *BillingRecordUpsert {
	u.Set(billingrecord.FieldMetadata, v)
	return u
}

// UpdateMetadata sets the "metadata" field to the value that was provided on create.
func (u *BillingRecordUpsert) UpdateMetadata() *BillingRecordUpsert {
	u.SetExcluded(billingrecord.FieldMetadata)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *BillingRecordUpsert) SetCreatedAt(v time.Time) *BillingRecordUpsert {
	u.Set(billingrecord.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *BillingRecordUpsert) UpdateCreatedAt() *BillingRecordUpsert {
	u.SetExcluded(billingrecord.FieldCreatedAt)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *BillingRecordUpsert) SetUpdatedAt(v time.Time) *BillingRecordUpsert {
	u.Set(billingrecord.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *BillingRecordUpsert) UpdateUpdatedAt() *BillingRecordUpsert {
	u.SetExcluded(billingrecord.FieldUpdatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.BillingRecord.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(billingrecord.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *BillingRecordUpsertOne) UpdateNewValues() *BillingRecordUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(billingrecord.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.BillingRecord.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *BillingRecordUpsertOne) Ignore() *BillingRecordUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *BillingRecordUpsertOne) DoNothing() *BillingRecordUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the BillingRecordCreate.OnConflict
// documentation for more info.
func (u *BillingRecordUpsertOne) Update(set func(*BillingRecordUpsert)) *BillingRecordUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&BillingRecordUpsert{UpdateSet: update})
	}))
	return u
}

// SetTenantID sets the "tenant_id" field.
func (u *BillingRecordUpsertOne) SetTenantID(v string) *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetTenantID(v)
	})
}

// UpdateTenantID sets the "tenant_id" field to the value that was provided on create.
func (u *BillingRecordUpsertOne) UpdateTenantID() *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateTenantID()
	})
}

// SetUserID sets the "user_id" field.
func (u *BillingRecordUpsertOne) SetUserID(v string) *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *BillingRecordUpsertOne) UpdateUserID() *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateUserID()
	})
}

// SetModel sets the "model" field.
func (u *BillingRecordUpsertOne) SetModel(v string) *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetModel(v)
	})
}

// UpdateModel sets the "model" field to the value that was provided on create.
func (u *BillingRecordUpsertOne) UpdateModel() *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateModel()
	})
}

// SetOperation sets the "operation" field.
func (u *BillingRecordUpsertOne) SetOperation(v string) *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetOperation(v)
	})
}

// UpdateOperation sets the "operation" field to the value that was provided on create.
func (u *BillingRecordUpsertOne) UpdateOperation() *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateOperation()
	})
}

// SetInputTokens sets the "input_tokens" field.
func (u *BillingRecordUpsertOne) SetInputTokens(v int64) *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetInputTokens(v)
	})
}

// AddInputTokens adds v to the "input_tokens" field.
func (u *BillingRecordUpsertOne) AddInputTokens(v int64) *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.AddInputTokens(v)
	})
}

// UpdateInputTokens sets the "input_tokens" field to the value that was provided on create.
func (u *BillingRecordUpsertOne) UpdateInputTokens() *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateInputTokens()
	})
}

// SetOutputTokens sets the "output_tokens" field.
func (u *BillingRecordUpsertOne) SetOutputTokens(v int64) *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetOutputTokens(v)
	})
}

// AddOutputTokens adds v to the "output_tokens" field.
func (u *BillingRecordUpsertOne) AddOutputTokens(v int64) *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.AddOutputTokens(v)
	})
}

// UpdateOutputTokens sets the "output_tokens" field to the value that was provided on create.
func (u *BillingRecordUpsertOne) UpdateOutputTokens() *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateOutputTokens()
	})
}

// SetCost sets the "cost" field.
func (u *BillingRecordUpsertOne) SetCost(v int64) *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetCost(v)
	})
}

// AddCost adds v to the "cost" field.
func (u *BillingRecordUpsertOne) AddCost(v int64) *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.AddCost(v)
	})
}

// UpdateCost sets the "cost" field to the value that was provided on create.
func (u *BillingRecordUpsertOne) UpdateCost() *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateCost()
	})
}

// SetRequestTime sets the "request_time" field.
func (u *BillingRecordUpsertOne) SetRequestTime(v time.Time) *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetRequestTime(v)
	})
}

// UpdateRequestTime sets the "request_time" field to the value that was provided on create.
func (u *BillingRecordUpsertOne) UpdateRequestTime() *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateRequestTime()
	})
}

// SetMetadata sets the "metadata" field.
func (u *BillingRecordUpsertOne) SetMetadata(v map[string]interface{}) *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetMetadata(v)
	})
}

// UpdateMetadata sets the "metadata" field to the value that was provided on create.
func (u *BillingRecordUpsertOne) UpdateMetadata() *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateMetadata()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *BillingRecordUpsertOne) SetCreatedAt(v time.Time) *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *BillingRecordUpsertOne) UpdateCreatedAt() *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *BillingRecordUpsertOne) SetUpdatedAt(v time.Time) *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *BillingRecordUpsertOne) UpdateUpdatedAt() *BillingRecordUpsertOne {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *BillingRecordUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for BillingRecordCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *BillingRecordUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *BillingRecordUpsertOne) ID(ctx context.Context) (id string, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: BillingRecordUpsertOne.ID is not supported by MySQL driver. Use BillingRecordUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *BillingRecordUpsertOne) IDX(ctx context.Context) string {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// BillingRecordCreateBulk is the builder for creating many BillingRecord entities in bulk.
type BillingRecordCreateBulk struct {
	config
	err      error
	builders []*BillingRecordCreate
	conflict []sql.ConflictOption
}

// Save creates the BillingRecord entities in the database.
func (brcb *BillingRecordCreateBulk) Save(ctx context.Context) ([]*BillingRecord, error) {
	if brcb.err != nil {
		return nil, brcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(brcb.builders))
	nodes := make([]*BillingRecord, len(brcb.builders))
	mutators := make([]Mutator, len(brcb.builders))
	for i := range brcb.builders {
		func(i int, root context.Context) {
			builder := brcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*BillingRecordMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, brcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = brcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, brcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, brcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (brcb *BillingRecordCreateBulk) SaveX(ctx context.Context) []*BillingRecord {
	v, err := brcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (brcb *BillingRecordCreateBulk) Exec(ctx context.Context) error {
	_, err := brcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (brcb *BillingRecordCreateBulk) ExecX(ctx context.Context) {
	if err := brcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.BillingRecord.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.BillingRecordUpsert) {
//			SetTenantID(v+v).
//		}).
//		Exec(ctx)
func (brcb *BillingRecordCreateBulk) OnConflict(opts ...sql.ConflictOption) *BillingRecordUpsertBulk {
	brcb.conflict = opts
	return &BillingRecordUpsertBulk{
		create: brcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.BillingRecord.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (brcb *BillingRecordCreateBulk) OnConflictColumns(columns ...string) *BillingRecordUpsertBulk {
	brcb.conflict = append(brcb.conflict, sql.ConflictColumns(columns...))
	return &BillingRecordUpsertBulk{
		create: brcb,
	}
}

// BillingRecordUpsertBulk is the builder for "upsert"-ing
// a bulk of BillingRecord nodes.
type BillingRecordUpsertBulk struct {
	create *BillingRecordCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.BillingRecord.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(billingrecord.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *BillingRecordUpsertBulk) UpdateNewValues() *BillingRecordUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(billingrecord.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.BillingRecord.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *BillingRecordUpsertBulk) Ignore() *BillingRecordUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *BillingRecordUpsertBulk) DoNothing() *BillingRecordUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the BillingRecordCreateBulk.OnConflict
// documentation for more info.
func (u *BillingRecordUpsertBulk) Update(set func(*BillingRecordUpsert)) *BillingRecordUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&BillingRecordUpsert{UpdateSet: update})
	}))
	return u
}

// SetTenantID sets the "tenant_id" field.
func (u *BillingRecordUpsertBulk) SetTenantID(v string) *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetTenantID(v)
	})
}

// UpdateTenantID sets the "tenant_id" field to the value that was provided on create.
func (u *BillingRecordUpsertBulk) UpdateTenantID() *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateTenantID()
	})
}

// SetUserID sets the "user_id" field.
func (u *BillingRecordUpsertBulk) SetUserID(v string) *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *BillingRecordUpsertBulk) UpdateUserID() *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateUserID()
	})
}

// SetModel sets the "model" field.
func (u *BillingRecordUpsertBulk) SetModel(v string) *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetModel(v)
	})
}

// UpdateModel sets the "model" field to the value that was provided on create.
func (u *BillingRecordUpsertBulk) UpdateModel() *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateModel()
	})
}

// SetOperation sets the "operation" field.
func (u *BillingRecordUpsertBulk) SetOperation(v string) *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetOperation(v)
	})
}

// UpdateOperation sets the "operation" field to the value that was provided on create.
func (u *BillingRecordUpsertBulk) UpdateOperation() *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateOperation()
	})
}

// SetInputTokens sets the "input_tokens" field.
func (u *BillingRecordUpsertBulk) SetInputTokens(v int64) *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetInputTokens(v)
	})
}

// AddInputTokens adds v to the "input_tokens" field.
func (u *BillingRecordUpsertBulk) AddInputTokens(v int64) *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.AddInputTokens(v)
	})
}

// UpdateInputTokens sets the "input_tokens" field to the value that was provided on create.
func (u *BillingRecordUpsertBulk) UpdateInputTokens() *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateInputTokens()
	})
}

// SetOutputTokens sets the "output_tokens" field.
func (u *BillingRecordUpsertBulk) SetOutputTokens(v int64) *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetOutputTokens(v)
	})
}

// AddOutputTokens adds v to the "output_tokens" field.
func (u *BillingRecordUpsertBulk) AddOutputTokens(v int64) *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.AddOutputTokens(v)
	})
}

// UpdateOutputTokens sets the "output_tokens" field to the value that was provided on create.
func (u *BillingRecordUpsertBulk) UpdateOutputTokens() *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateOutputTokens()
	})
}

// SetCost sets the "cost" field.
func (u *BillingRecordUpsertBulk) SetCost(v int64) *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetCost(v)
	})
}

// AddCost adds v to the "cost" field.
func (u *BillingRecordUpsertBulk) AddCost(v int64) *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.AddCost(v)
	})
}

// UpdateCost sets the "cost" field to the value that was provided on create.
func (u *BillingRecordUpsertBulk) UpdateCost() *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateCost()
	})
}

// SetRequestTime sets the "request_time" field.
func (u *BillingRecordUpsertBulk) SetRequestTime(v time.Time) *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetRequestTime(v)
	})
}

// UpdateRequestTime sets the "request_time" field to the value that was provided on create.
func (u *BillingRecordUpsertBulk) UpdateRequestTime() *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateRequestTime()
	})
}

// SetMetadata sets the "metadata" field.
func (u *BillingRecordUpsertBulk) SetMetadata(v map[string]interface{}) *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetMetadata(v)
	})
}

// UpdateMetadata sets the "metadata" field to the value that was provided on create.
func (u *BillingRecordUpsertBulk) UpdateMetadata() *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateMetadata()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *BillingRecordUpsertBulk) SetCreatedAt(v time.Time) *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *BillingRecordUpsertBulk) UpdateCreatedAt() *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *BillingRecordUpsertBulk) SetUpdatedAt(v time.Time) *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *BillingRecordUpsertBulk) UpdateUpdatedAt() *BillingRecordUpsertBulk {
	return u.Update(func(s *BillingRecordUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *BillingRecordUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the BillingRecordCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for BillingRecordCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *BillingRecordUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
