// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/billingrecord"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
)

// BillingRecordUpdate is the builder for updating BillingRecord entities.
type BillingRecordUpdate struct {
	config
	hooks     []Hook
	mutation  *BillingRecordMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the BillingRecordUpdate builder.
func (bru *BillingRecordUpdate) Where(ps ...predicate.BillingRecord) *BillingRecordUpdate {
	bru.mutation.Where(ps...)
	return bru
}

// SetTenantID sets the "tenant_id" field.
func (bru *BillingRecordUpdate) SetTenantID(s string) *BillingRecordUpdate {
	bru.mutation.SetTenantID(s)
	return bru
}

// SetNillableTenantID sets the "tenant_id" field if the given value is not nil.
func (bru *BillingRecordUpdate) SetNillableTenantID(s *string) *BillingRecordUpdate {
	if s != nil {
		bru.SetTenantID(*s)
	}
	return bru
}

// SetUserID sets the "user_id" field.
func (bru *BillingRecordUpdate) SetUserID(s string) *BillingRecordUpdate {
	bru.mutation.SetUserID(s)
	return bru
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (bru *BillingRecordUpdate) SetNillableUserID(s *string) *BillingRecordUpdate {
	if s != nil {
		bru.SetUserID(*s)
	}
	return bru
}

// SetModel sets the "model" field.
func (bru *BillingRecordUpdate) SetModel(s string) *BillingRecordUpdate {
	bru.mutation.SetModel(s)
	return bru
}

// SetNillableModel sets the "model" field if the given value is not nil.
func (bru *BillingRecordUpdate) SetNillableModel(s *string) *BillingRecordUpdate {
	if s != nil {
		bru.SetModel(*s)
	}
	return bru
}

// SetOperation sets the "operation" field.
func (bru *BillingRecordUpdate) SetOperation(s string) *BillingRecordUpdate {
	bru.mutation.SetOperation(s)
	return bru
}

// SetNillableOperation sets the "operation" field if the given value is not nil.
func (bru *BillingRecordUpdate) SetNillableOperation(s *string) *BillingRecordUpdate {
	if s != nil {
		bru.SetOperation(*s)
	}
	return bru
}

// SetInputTokens sets the "input_tokens" field.
func (bru *BillingRecordUpdate) SetInputTokens(i int64) *BillingRecordUpdate {
	bru.mutation.ResetInputTokens()
	bru.mutation.SetInputTokens(i)
	return bru
}

// SetNillableInputTokens sets the "input_tokens" field if the given value is not nil.
func (bru *BillingRecordUpdate) SetNillableInputTokens(i *int64) *BillingRecordUpdate {
	if i != nil {
		bru.SetInputTokens(*i)
	}
	return bru
}

// AddInputTokens adds i to the "input_tokens" field.
func (bru *BillingRecordUpdate) AddInputTokens(i int64) *BillingRecordUpdate {
	bru.mutation.AddInputTokens(i)
	return bru
}

// SetOutputTokens sets the "output_tokens" field.
func (bru *BillingRecordUpdate) SetOutputTokens(i int64) *BillingRecordUpdate {
	bru.mutation.ResetOutputTokens()
	bru.mutation.SetOutputTokens(i)
	return bru
}

// SetNillableOutputTokens sets the "output_tokens" field if the given value is not nil.
func (bru *BillingRecordUpdate) SetNillableOutputTokens(i *int64) *BillingRecordUpdate {
	if i != nil {
		bru.SetOutputTokens(*i)
	}
	return bru
}

// AddOutputTokens adds i to the "output_tokens" field.
func (bru *BillingRecordUpdate) AddOutputTokens(i int64) *BillingRecordUpdate {
	bru.mutation.AddOutputTokens(i)
	return bru
}

// SetCost sets the "cost" field.
func (bru *BillingRecordUpdate) SetCost(i int64) *BillingRecordUpdate {
	bru.mutation.ResetCost()
	bru.mutation.SetCost(i)
	return bru
}

// SetNillableCost sets the "cost" field if the given value is not nil.
func (bru *BillingRecordUpdate) SetNillableCost(i *int64) *BillingRecordUpdate {
	if i != nil {
		bru.SetCost(*i)
	}
	return bru
}

// AddCost adds i to the "cost" field.
func (bru *BillingRecordUpdate) AddCost(i int64) *BillingRecordUpdate {
	bru.mutation.AddCost(i)
	return bru
}

// SetRequestTime sets the "request_time" field.
func (bru *BillingRecordUpdate) SetRequestTime(t time.Time) *BillingRecordUpdate {
	bru.mutation.SetRequestTime(t)
	return bru
}

// SetNillableRequestTime sets the "request_time" field if the given value is not nil.
func (bru *BillingRecordUpdate) SetNillableRequestTime(t *time.Time) *BillingRecordUpdate {
	if t != nil {
		bru.SetRequestTime(*t)
	}
	return bru
}

// SetMetadata sets the "metadata" field.
func (bru *BillingRecordUpdate) SetMetadata(m map[string]interface{}) *BillingRecordUpdate {
	bru.mutation.SetMetadata(m)
	return bru
}

// SetCreatedAt sets the "created_at" field.
func (bru *BillingRecordUpdate) SetCreatedAt(t time.Time) *BillingRecordUpdate {
	bru.mutation.SetCreatedAt(t)
	return bru
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (bru *BillingRecordUpdate) SetNillableCreatedAt(t *time.Time) *BillingRecordUpdate {
	if t != nil {
		bru.SetCreatedAt(*t)
	}
	return bru
}

// SetUpdatedAt sets the "updated_at" field.
func (bru *BillingRecordUpdate) SetUpdatedAt(t time.Time) *BillingRecordUpdate {
	bru.mutation.SetUpdatedAt(t)
	return bru
}

// Mutation returns the BillingRecordMutation object of the builder.
func (bru *BillingRecordUpdate) Mutation() *BillingRecordMutation {
	return bru.mutation
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (bru *BillingRecordUpdate) Save(ctx context.Context) (int, error) {
	bru.defaults()
	return withHooks(ctx, bru.sqlSave, bru.mutation, bru.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (bru *BillingRecordUpdate) SaveX(ctx context.Context) int {
	affected, err := bru.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (bru *BillingRecordUpdate) Exec(ctx context.Context) error {
	_, err := bru.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (bru *BillingRecordUpdate) ExecX(ctx context.Context) {
	if err := bru.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (bru *BillingRecordUpdate) defaults() {
	if _, ok := bru.mutation.UpdatedAt(); !ok {
		v := billingrecord.UpdateDefaultUpdatedAt()
		bru.mutation.SetUpdatedAt(v)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (bru *BillingRecordUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *BillingRecordUpdate {
	bru.modifiers = append(bru.modifiers, modifiers...)
	return bru
}

func (bru *BillingRecordUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(billingrecord.Table, billingrecord.Columns, sqlgraph.NewFieldSpec(billingrecord.FieldID, field.TypeString))
	if ps := bru.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := bru.mutation.TenantID(); ok {
		_spec.SetField(billingrecord.FieldTenantID, field.TypeString, value)
	}
	if value, ok := bru.mutation.UserID(); ok {
		_spec.SetField(billingrecord.FieldUserID, field.TypeString, value)
	}
	if value, ok := bru.mutation.Model(); ok {
		_spec.SetField(billingrecord.FieldModel, field.TypeString, value)
	}
	if value, ok := bru.mutation.Operation(); ok {
		_spec.SetField(billingrecord.FieldOperation, field.TypeString, value)
	}
	if value, ok := bru.mutation.InputTokens(); ok {
		_spec.SetField(billingrecord.FieldInputTokens, field.TypeInt64, value)
	}
	if value, ok := bru.mutation.AddedInputTokens(); ok {
		_spec.AddField(billingrecord.FieldInputTokens, field.TypeInt64, value)
	}
	if value, ok := bru.mutation.OutputTokens(); ok {
		_spec.SetField(billingrecord.FieldOutputTokens, field.TypeInt64, value)
	}
	if value, ok := bru.mutation.AddedOutputTokens(); ok {
		_spec.AddField(billingrecord.FieldOutputTokens, field.TypeInt64, value)
	}
	if value, ok := bru.mutation.Cost(); ok {
		_spec.SetField(billingrecord.FieldCost, field.TypeInt64, value)
	}
	if value, ok := bru.mutation.AddedCost(); ok {
		_spec.AddField(billingrecord.FieldCost, field.TypeInt64, value)
	}
	if value, ok := bru.mutation.RequestTime(); ok {
		_spec.SetField(billingrecord.FieldRequestTime, field.TypeTime, value)
	}
	if value, ok := bru.mutation.Metadata(); ok {
		_spec.SetField(billingrecord.FieldMetadata, field.TypeJSON, value)
	}
	if value, ok := bru.mutation.CreatedAt(); ok {
		_spec.SetField(billingrecord.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := bru.mutation.UpdatedAt(); ok {
		_spec.SetField(billingrecord.FieldUpdatedAt, field.TypeTime, value)
	}
	_spec.AddModifiers(bru.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, bru.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{billingrecord.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	bru.mutation.done = true
	return n, nil
}

// BillingRecordUpdateOne is the builder for updating a single BillingRecord entity.
type BillingRecordUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *BillingRecordMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetTenantID sets the "tenant_id" field.
func (bruo *BillingRecordUpdateOne) SetTenantID(s string) *BillingRecordUpdateOne {
	bruo.mutation.SetTenantID(s)
	return bruo
}

// SetNillableTenantID sets the "tenant_id" field if the given value is not nil.
func (bruo *BillingRecordUpdateOne) SetNillableTenantID(s *string) *BillingRecordUpdateOne {
	if s != nil {
		bruo.SetTenantID(*s)
	}
	return bruo
}

// SetUserID sets the "user_id" field.
func (bruo *BillingRecordUpdateOne) SetUserID(s string) *BillingRecordUpdateOne {
	bruo.mutation.SetUserID(s)
	return bruo
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (bruo *BillingRecordUpdateOne) SetNillableUserID(s *string) *BillingRecordUpdateOne {
	if s != nil {
		bruo.SetUserID(*s)
	}
	return bruo
}

// SetModel sets the "model" field.
func (bruo *BillingRecordUpdateOne) SetModel(s string) *BillingRecordUpdateOne {
	bruo.mutation.SetModel(s)
	return bruo
}

// SetNillableModel sets the "model" field if the given value is not nil.
func (bruo *BillingRecordUpdateOne) SetNillableModel(s *string) *BillingRecordUpdateOne {
	if s != nil {
		bruo.SetModel(*s)
	}
	return bruo
}

// SetOperation sets the "operation" field.
func (bruo *BillingRecordUpdateOne) SetOperation(s string) *BillingRecordUpdateOne {
	bruo.mutation.SetOperation(s)
	return bruo
}

// SetNillableOperation sets the "operation" field if the given value is not nil.
func (bruo *BillingRecordUpdateOne) SetNillableOperation(s *string) *BillingRecordUpdateOne {
	if s != nil {
		bruo.SetOperation(*s)
	}
	return bruo
}

// SetInputTokens sets the "input_tokens" field.
func (bruo *BillingRecordUpdateOne) SetInputTokens(i int64) *BillingRecordUpdateOne {
	bruo.mutation.ResetInputTokens()
	bruo.mutation.SetInputTokens(i)
	return bruo
}

// SetNillableInputTokens sets the "input_tokens" field if the given value is not nil.
func (bruo *BillingRecordUpdateOne) SetNillableInputTokens(i *int64) *BillingRecordUpdateOne {
	if i != nil {
		bruo.SetInputTokens(*i)
	}
	return bruo
}

// AddInputTokens adds i to the "input_tokens" field.
func (bruo *BillingRecordUpdateOne) AddInputTokens(i int64) *BillingRecordUpdateOne {
	bruo.mutation.AddInputTokens(i)
	return bruo
}

// SetOutputTokens sets the "output_tokens" field.
func (bruo *BillingRecordUpdateOne) SetOutputTokens(i int64) *BillingRecordUpdateOne {
	bruo.mutation.ResetOutputTokens()
	bruo.mutation.SetOutputTokens(i)
	return bruo
}

// SetNillableOutputTokens sets the "output_tokens" field if the given value is not nil.
func (bruo *BillingRecordUpdateOne) SetNillableOutputTokens(i *int64) *BillingRecordUpdateOne {
	if i != nil {
		bruo.SetOutputTokens(*i)
	}
	return bruo
}

// AddOutputTokens adds i to the "output_tokens" field.
func (bruo *BillingRecordUpdateOne) AddOutputTokens(i int64) *BillingRecordUpdateOne {
	bruo.mutation.AddOutputTokens(i)
	return bruo
}

// SetCost sets the "cost" field.
func (bruo *BillingRecordUpdateOne) SetCost(i int64) *BillingRecordUpdateOne {
	bruo.mutation.ResetCost()
	bruo.mutation.SetCost(i)
	return bruo
}

// SetNillableCost sets the "cost" field if the given value is not nil.
func (bruo *BillingRecordUpdateOne) SetNillableCost(i *int64) *BillingRecordUpdateOne {
	if i != nil {
		bruo.SetCost(*i)
	}
	return bruo
}

// AddCost adds i to the "cost" field.
func (bruo *BillingRecordUpdateOne) AddCost(i int64) *BillingRecordUpdateOne {
	bruo.mutation.AddCost(i)
	return bruo
}

// SetRequestTime sets the "request_time" field.
func (bruo *BillingRecordUpdateOne) SetRequestTime(t time.Time) *BillingRecordUpdateOne {
	bruo.mutation.SetRequestTime(t)
	return bruo
}

// SetNillableRequestTime sets the "request_time" field if the given value is not nil.
func (bruo *BillingRecordUpdateOne) SetNillableRequestTime(t *time.Time) *BillingRecordUpdateOne {
	if t != nil {
		bruo.SetRequestTime(*t)
	}
	return bruo
}

// SetMetadata sets the "metadata" field.
func (bruo *BillingRecordUpdateOne) SetMetadata(m map[string]interface{}) *BillingRecordUpdateOne {
	bruo.mutation.SetMetadata(m)
	return bruo
}

// SetCreatedAt sets the "created_at" field.
func (bruo *BillingRecordUpdateOne) SetCreatedAt(t time.Time) *BillingRecordUpdateOne {
	bruo.mutation.SetCreatedAt(t)
	return bruo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (bruo *BillingRecordUpdateOne) SetNillableCreatedAt(t *time.Time) *BillingRecordUpdateOne {
	if t != nil {
		bruo.SetCreatedAt(*t)
	}
	return bruo
}

// SetUpdatedAt sets the "updated_at" field.
func (bruo *BillingRecordUpdateOne) SetUpdatedAt(t time.Time) *BillingRecordUpdateOne {
	bruo.mutation.SetUpdatedAt(t)
	return bruo
}

// Mutation returns the BillingRecordMutation object of the builder.
func (bruo *BillingRecordUpdateOne) Mutation() *BillingRecordMutation {
	return bruo.mutation
}

// Where appends a list predicates to the BillingRecordUpdate builder.
func (bruo *BillingRecordUpdateOne) Where(ps ...predicate.BillingRecord) *BillingRecordUpdateOne {
	bruo.mutation.Where(ps...)
	return bruo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (bruo *BillingRecordUpdateOne) Select(field string, fields ...string) *BillingRecordUpdateOne {
	bruo.fields = append([]string{field}, fields...)
	return bruo
}

// Save executes the query and returns the updated BillingRecord entity.
func (bruo *BillingRecordUpdateOne) Save(ctx context.Context) (*BillingRecord, error) {
	bruo.defaults()
	return withHooks(ctx, bruo.sqlSave, bruo.mutation, bruo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (bruo *BillingRecordUpdateOne) SaveX(ctx context.Context) *BillingRecord {
	node, err := bruo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (bruo *BillingRecordUpdateOne) Exec(ctx context.Context) error {
	_, err := bruo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (bruo *BillingRecordUpdateOne) ExecX(ctx context.Context) {
	if err := bruo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (bruo *BillingRecordUpdateOne) defaults() {
	if _, ok := bruo.mutation.UpdatedAt(); !ok {
		v := billingrecord.UpdateDefaultUpdatedAt()
		bruo.mutation.SetUpdatedAt(v)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (bruo *BillingRecordUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *BillingRecordUpdateOne {
	bruo.modifiers = append(bruo.modifiers, modifiers...)
	return bruo
}

func (bruo *BillingRecordUpdateOne) sqlSave(ctx context.Context) (_node *BillingRecord, err error) {
	_spec := sqlgraph.NewUpdateSpec(billingrecord.Table, billingrecord.Columns, sqlgraph.NewFieldSpec(billingrecord.FieldID, field.TypeString))
	id, ok := bruo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "BillingRecord.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := bruo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, billingrecord.FieldID)
		for _, f := range fields {
			if !billingrecord.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != billingrecord.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := bruo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := bruo.mutation.TenantID(); ok {
		_spec.SetField(billingrecord.FieldTenantID, field.TypeString, value)
	}
	if value, ok := bruo.mutation.UserID(); ok {
		_spec.SetField(billingrecord.FieldUserID, field.TypeString, value)
	}
	if value, ok := bruo.mutation.Model(); ok {
		_spec.SetField(billingrecord.FieldModel, field.TypeString, value)
	}
	if value, ok := bruo.mutation.Operation(); ok {
		_spec.SetField(billingrecord.FieldOperation, field.TypeString, value)
	}
	if value, ok := bruo.mutation.InputTokens(); ok {
		_spec.SetField(billingrecord.FieldInputTokens, field.TypeInt64, value)
	}
	if value, ok := bruo.mutation.AddedInputTokens(); ok {
		_spec.AddField(billingrecord.FieldInputTokens, field.TypeInt64, value)
	}
	if value, ok := bruo.mutation.OutputTokens(); ok {
		_spec.SetField(billingrecord.FieldOutputTokens, field.TypeInt64, value)
	}
	if value, ok := bruo.mutation.AddedOutputTokens(); ok {
		_spec.AddField(billingrecord.FieldOutputTokens, field.TypeInt64, value)
	}
	if value, ok := bruo.mutation.Cost(); ok {
		_spec.SetField(billingrecord.FieldCost, field.TypeInt64, value)
	}
	if value, ok := bruo.mutation.AddedCost(); ok {
		_spec.AddField(billingrecord.FieldCost, field.TypeInt64, value)
	}
	if value, ok := bruo.mutation.RequestTime(); ok {
		_spec.SetField(billingrecord.FieldRequestTime, field.TypeTime, value)
	}
	if value, ok := bruo.mutation.Metadata(); ok {
		_spec.SetField(billingrecord.FieldMetadata, field.TypeJSON, value)
	}
	if value, ok := bruo.mutation.CreatedAt(); ok {
		_spec.SetField(billingrecord.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := bruo.mutation.UpdatedAt(); ok {
		_spec.SetField(billingrecord.FieldUpdatedAt, field.TypeTime, value)
	}
	_spec.AddModifiers(bruo.modifiers...)
	_node = &BillingRecord{config: bruo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, bruo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{billingrecord.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	bruo.mutation.done = true
	return _node, nil
}
