// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/billingusage"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
)

// BillingUsageDelete is the builder for deleting a BillingUsage entity.
type BillingUsageDelete struct {
	config
	hooks    []Hook
	mutation *BillingUsageMutation
}

// Where appends a list predicates to the BillingUsageDelete builder.
func (bud *BillingUsageDelete) Where(ps ...predicate.BillingUsage) *BillingUsageDelete {
	bud.mutation.Where(ps...)
	return bud
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (bud *BillingUsageDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, bud.sqlExec, bud.mutation, bud.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (bud *BillingUsageDelete) ExecX(ctx context.Context) int {
	n, err := bud.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (bud *BillingUsageDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(billingusage.Table, sqlgraph.NewFieldSpec(billingusage.FieldID, field.TypeString))
	if ps := bud.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, bud.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	bud.mutation.done = true
	return affected, err
}

// BillingUsageDeleteOne is the builder for deleting a single BillingUsage entity.
type BillingUsageDeleteOne struct {
	bud *BillingUsageDelete
}

// Where appends a list predicates to the BillingUsageDelete builder.
func (budo *BillingUsageDeleteOne) Where(ps ...predicate.BillingUsage) *BillingUsageDeleteOne {
	budo.bud.mutation.Where(ps...)
	return budo
}

// Exec executes the deletion query.
func (budo *BillingUsageDeleteOne) Exec(ctx context.Context) error {
	n, err := budo.bud.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{billingusage.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (budo *BillingUsageDeleteOne) ExecX(ctx context.Context) {
	if err := budo.Exec(ctx); err != nil {
		panic(err)
	}
}
