// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/billingusage"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
)

// BillingUsageUpdate is the builder for updating BillingUsage entities.
type BillingUsageUpdate struct {
	config
	hooks     []Hook
	mutation  *BillingUsageMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the BillingUsageUpdate builder.
func (buu *BillingUsageUpdate) Where(ps ...predicate.BillingUsage) *BillingUsageUpdate {
	buu.mutation.Where(ps...)
	return buu
}

// SetDeletedAt sets the "deleted_at" field.
func (buu *BillingUsageUpdate) SetDeletedAt(t time.Time) *BillingUsageUpdate {
	buu.mutation.SetDeletedAt(t)
	return buu
}

// SetNillableDeletedAt sets the "deleted_at" field if the given value is not nil.
func (buu *BillingUsageUpdate) SetNillableDeletedAt(t *time.Time) *BillingUsageUpdate {
	if t != nil {
		buu.SetDeletedAt(*t)
	}
	return buu
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (buu *BillingUsageUpdate) ClearDeletedAt() *BillingUsageUpdate {
	buu.mutation.ClearDeletedAt()
	return buu
}

// SetUserID sets the "user_id" field.
func (buu *BillingUsageUpdate) SetUserID(s string) *BillingUsageUpdate {
	buu.mutation.SetUserID(s)
	return buu
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (buu *BillingUsageUpdate) SetNillableUserID(s *string) *BillingUsageUpdate {
	if s != nil {
		buu.SetUserID(*s)
	}
	return buu
}

// SetModelName sets the "model_name" field.
func (buu *BillingUsageUpdate) SetModelName(s string) *BillingUsageUpdate {
	buu.mutation.SetModelName(s)
	return buu
}

// SetNillableModelName sets the "model_name" field if the given value is not nil.
func (buu *BillingUsageUpdate) SetNillableModelName(s *string) *BillingUsageUpdate {
	if s != nil {
		buu.SetModelName(*s)
	}
	return buu
}

// SetTokens sets the "tokens" field.
func (buu *BillingUsageUpdate) SetTokens(i int64) *BillingUsageUpdate {
	buu.mutation.ResetTokens()
	buu.mutation.SetTokens(i)
	return buu
}

// SetNillableTokens sets the "tokens" field if the given value is not nil.
func (buu *BillingUsageUpdate) SetNillableTokens(i *int64) *BillingUsageUpdate {
	if i != nil {
		buu.SetTokens(*i)
	}
	return buu
}

// AddTokens adds i to the "tokens" field.
func (buu *BillingUsageUpdate) AddTokens(i int64) *BillingUsageUpdate {
	buu.mutation.AddTokens(i)
	return buu
}

// SetOperation sets the "operation" field.
func (buu *BillingUsageUpdate) SetOperation(s string) *BillingUsageUpdate {
	buu.mutation.SetOperation(s)
	return buu
}

// SetNillableOperation sets the "operation" field if the given value is not nil.
func (buu *BillingUsageUpdate) SetNillableOperation(s *string) *BillingUsageUpdate {
	if s != nil {
		buu.SetOperation(*s)
	}
	return buu
}

// SetCreatedAt sets the "created_at" field.
func (buu *BillingUsageUpdate) SetCreatedAt(t time.Time) *BillingUsageUpdate {
	buu.mutation.SetCreatedAt(t)
	return buu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (buu *BillingUsageUpdate) SetNillableCreatedAt(t *time.Time) *BillingUsageUpdate {
	if t != nil {
		buu.SetCreatedAt(*t)
	}
	return buu
}

// SetUpdatedAt sets the "updated_at" field.
func (buu *BillingUsageUpdate) SetUpdatedAt(t time.Time) *BillingUsageUpdate {
	buu.mutation.SetUpdatedAt(t)
	return buu
}

// Mutation returns the BillingUsageMutation object of the builder.
func (buu *BillingUsageUpdate) Mutation() *BillingUsageMutation {
	return buu.mutation
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (buu *BillingUsageUpdate) Save(ctx context.Context) (int, error) {
	if err := buu.defaults(); err != nil {
		return 0, err
	}
	return withHooks(ctx, buu.sqlSave, buu.mutation, buu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (buu *BillingUsageUpdate) SaveX(ctx context.Context) int {
	affected, err := buu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (buu *BillingUsageUpdate) Exec(ctx context.Context) error {
	_, err := buu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (buu *BillingUsageUpdate) ExecX(ctx context.Context) {
	if err := buu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (buu *BillingUsageUpdate) defaults() error {
	if _, ok := buu.mutation.UpdatedAt(); !ok {
		if billingusage.UpdateDefaultUpdatedAt == nil {
			return fmt.Errorf("db: uninitialized billingusage.UpdateDefaultUpdatedAt (forgotten import db/runtime?)")
		}
		v := billingusage.UpdateDefaultUpdatedAt()
		buu.mutation.SetUpdatedAt(v)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (buu *BillingUsageUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *BillingUsageUpdate {
	buu.modifiers = append(buu.modifiers, modifiers...)
	return buu
}

func (buu *BillingUsageUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(billingusage.Table, billingusage.Columns, sqlgraph.NewFieldSpec(billingusage.FieldID, field.TypeString))
	if ps := buu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := buu.mutation.DeletedAt(); ok {
		_spec.SetField(billingusage.FieldDeletedAt, field.TypeTime, value)
	}
	if buu.mutation.DeletedAtCleared() {
		_spec.ClearField(billingusage.FieldDeletedAt, field.TypeTime)
	}
	if value, ok := buu.mutation.UserID(); ok {
		_spec.SetField(billingusage.FieldUserID, field.TypeString, value)
	}
	if value, ok := buu.mutation.ModelName(); ok {
		_spec.SetField(billingusage.FieldModelName, field.TypeString, value)
	}
	if value, ok := buu.mutation.Tokens(); ok {
		_spec.SetField(billingusage.FieldTokens, field.TypeInt64, value)
	}
	if value, ok := buu.mutation.AddedTokens(); ok {
		_spec.AddField(billingusage.FieldTokens, field.TypeInt64, value)
	}
	if value, ok := buu.mutation.Operation(); ok {
		_spec.SetField(billingusage.FieldOperation, field.TypeString, value)
	}
	if value, ok := buu.mutation.CreatedAt(); ok {
		_spec.SetField(billingusage.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := buu.mutation.UpdatedAt(); ok {
		_spec.SetField(billingusage.FieldUpdatedAt, field.TypeTime, value)
	}
	_spec.AddModifiers(buu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, buu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{billingusage.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	buu.mutation.done = true
	return n, nil
}

// BillingUsageUpdateOne is the builder for updating a single BillingUsage entity.
type BillingUsageUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *BillingUsageMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetDeletedAt sets the "deleted_at" field.
func (buuo *BillingUsageUpdateOne) SetDeletedAt(t time.Time) *BillingUsageUpdateOne {
	buuo.mutation.SetDeletedAt(t)
	return buuo
}

// SetNillableDeletedAt sets the "deleted_at" field if the given value is not nil.
func (buuo *BillingUsageUpdateOne) SetNillableDeletedAt(t *time.Time) *BillingUsageUpdateOne {
	if t != nil {
		buuo.SetDeletedAt(*t)
	}
	return buuo
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (buuo *BillingUsageUpdateOne) ClearDeletedAt() *BillingUsageUpdateOne {
	buuo.mutation.ClearDeletedAt()
	return buuo
}

// SetUserID sets the "user_id" field.
func (buuo *BillingUsageUpdateOne) SetUserID(s string) *BillingUsageUpdateOne {
	buuo.mutation.SetUserID(s)
	return buuo
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (buuo *BillingUsageUpdateOne) SetNillableUserID(s *string) *BillingUsageUpdateOne {
	if s != nil {
		buuo.SetUserID(*s)
	}
	return buuo
}

// SetModelName sets the "model_name" field.
func (buuo *BillingUsageUpdateOne) SetModelName(s string) *BillingUsageUpdateOne {
	buuo.mutation.SetModelName(s)
	return buuo
}

// SetNillableModelName sets the "model_name" field if the given value is not nil.
func (buuo *BillingUsageUpdateOne) SetNillableModelName(s *string) *BillingUsageUpdateOne {
	if s != nil {
		buuo.SetModelName(*s)
	}
	return buuo
}

// SetTokens sets the "tokens" field.
func (buuo *BillingUsageUpdateOne) SetTokens(i int64) *BillingUsageUpdateOne {
	buuo.mutation.ResetTokens()
	buuo.mutation.SetTokens(i)
	return buuo
}

// SetNillableTokens sets the "tokens" field if the given value is not nil.
func (buuo *BillingUsageUpdateOne) SetNillableTokens(i *int64) *BillingUsageUpdateOne {
	if i != nil {
		buuo.SetTokens(*i)
	}
	return buuo
}

// AddTokens adds i to the "tokens" field.
func (buuo *BillingUsageUpdateOne) AddTokens(i int64) *BillingUsageUpdateOne {
	buuo.mutation.AddTokens(i)
	return buuo
}

// SetOperation sets the "operation" field.
func (buuo *BillingUsageUpdateOne) SetOperation(s string) *BillingUsageUpdateOne {
	buuo.mutation.SetOperation(s)
	return buuo
}

// SetNillableOperation sets the "operation" field if the given value is not nil.
func (buuo *BillingUsageUpdateOne) SetNillableOperation(s *string) *BillingUsageUpdateOne {
	if s != nil {
		buuo.SetOperation(*s)
	}
	return buuo
}

// SetCreatedAt sets the "created_at" field.
func (buuo *BillingUsageUpdateOne) SetCreatedAt(t time.Time) *BillingUsageUpdateOne {
	buuo.mutation.SetCreatedAt(t)
	return buuo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (buuo *BillingUsageUpdateOne) SetNillableCreatedAt(t *time.Time) *BillingUsageUpdateOne {
	if t != nil {
		buuo.SetCreatedAt(*t)
	}
	return buuo
}

// SetUpdatedAt sets the "updated_at" field.
func (buuo *BillingUsageUpdateOne) SetUpdatedAt(t time.Time) *BillingUsageUpdateOne {
	buuo.mutation.SetUpdatedAt(t)
	return buuo
}

// Mutation returns the BillingUsageMutation object of the builder.
func (buuo *BillingUsageUpdateOne) Mutation() *BillingUsageMutation {
	return buuo.mutation
}

// Where appends a list predicates to the BillingUsageUpdate builder.
func (buuo *BillingUsageUpdateOne) Where(ps ...predicate.BillingUsage) *BillingUsageUpdateOne {
	buuo.mutation.Where(ps...)
	return buuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (buuo *BillingUsageUpdateOne) Select(field string, fields ...string) *BillingUsageUpdateOne {
	buuo.fields = append([]string{field}, fields...)
	return buuo
}

// Save executes the query and returns the updated BillingUsage entity.
func (buuo *BillingUsageUpdateOne) Save(ctx context.Context) (*BillingUsage, error) {
	if err := buuo.defaults(); err != nil {
		return nil, err
	}
	return withHooks(ctx, buuo.sqlSave, buuo.mutation, buuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (buuo *BillingUsageUpdateOne) SaveX(ctx context.Context) *BillingUsage {
	node, err := buuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (buuo *BillingUsageUpdateOne) Exec(ctx context.Context) error {
	_, err := buuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (buuo *BillingUsageUpdateOne) ExecX(ctx context.Context) {
	if err := buuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (buuo *BillingUsageUpdateOne) defaults() error {
	if _, ok := buuo.mutation.UpdatedAt(); !ok {
		if billingusage.UpdateDefaultUpdatedAt == nil {
			return fmt.Errorf("db: uninitialized billingusage.UpdateDefaultUpdatedAt (forgotten import db/runtime?)")
		}
		v := billingusage.UpdateDefaultUpdatedAt()
		buuo.mutation.SetUpdatedAt(v)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (buuo *BillingUsageUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *BillingUsageUpdateOne {
	buuo.modifiers = append(buuo.modifiers, modifiers...)
	return buuo
}

func (buuo *BillingUsageUpdateOne) sqlSave(ctx context.Context) (_node *BillingUsage, err error) {
	_spec := sqlgraph.NewUpdateSpec(billingusage.Table, billingusage.Columns, sqlgraph.NewFieldSpec(billingusage.FieldID, field.TypeString))
	id, ok := buuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "BillingUsage.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := buuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, billingusage.FieldID)
		for _, f := range fields {
			if !billingusage.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != billingusage.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := buuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := buuo.mutation.DeletedAt(); ok {
		_spec.SetField(billingusage.FieldDeletedAt, field.TypeTime, value)
	}
	if buuo.mutation.DeletedAtCleared() {
		_spec.ClearField(billingusage.FieldDeletedAt, field.TypeTime)
	}
	if value, ok := buuo.mutation.UserID(); ok {
		_spec.SetField(billingusage.FieldUserID, field.TypeString, value)
	}
	if value, ok := buuo.mutation.ModelName(); ok {
		_spec.SetField(billingusage.FieldModelName, field.TypeString, value)
	}
	if value, ok := buuo.mutation.Tokens(); ok {
		_spec.SetField(billingusage.FieldTokens, field.TypeInt64, value)
	}
	if value, ok := buuo.mutation.AddedTokens(); ok {
		_spec.AddField(billingusage.FieldTokens, field.TypeInt64, value)
	}
	if value, ok := buuo.mutation.Operation(); ok {
		_spec.SetField(billingusage.FieldOperation, field.TypeString, value)
	}
	if value, ok := buuo.mutation.CreatedAt(); ok {
		_spec.SetField(billingusage.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := buuo.mutation.UpdatedAt(); ok {
		_spec.SetField(billingusage.FieldUpdatedAt, field.TypeTime, value)
	}
	_spec.AddModifiers(buuo.modifiers...)
	_node = &BillingUsage{config: buuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, buuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{billingusage.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	buuo.mutation.done = true
	return _node, nil
}
