// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"log"
	"reflect"

	"github.com/chaitin/MonkeyCode/backend/db/migrate"
	"github.com/google/uuid"

	"entgo.io/ent"
	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"github.com/chaitin/MonkeyCode/backend/db/admin"
	"github.com/chaitin/MonkeyCode/backend/db/adminloginhistory"
	"github.com/chaitin/MonkeyCode/backend/db/adminrole"
	"github.com/chaitin/MonkeyCode/backend/db/aiemployee"
	"github.com/chaitin/MonkeyCode/backend/db/aitask"
	"github.com/chaitin/MonkeyCode/backend/db/apikey"
	"github.com/chaitin/MonkeyCode/backend/db/billingplan"
	"github.com/chaitin/MonkeyCode/backend/db/billingquota"
	"github.com/chaitin/MonkeyCode/backend/db/billingrecord"
	"github.com/chaitin/MonkeyCode/backend/db/billingusage"
	"github.com/chaitin/MonkeyCode/backend/db/codesnippet"
	"github.com/chaitin/MonkeyCode/backend/db/extension"
	"github.com/chaitin/MonkeyCode/backend/db/invitecode"
	"github.com/chaitin/MonkeyCode/backend/db/license"
	"github.com/chaitin/MonkeyCode/backend/db/model"
	"github.com/chaitin/MonkeyCode/backend/db/modelprovider"
	"github.com/chaitin/MonkeyCode/backend/db/modelprovidermodel"
	"github.com/chaitin/MonkeyCode/backend/db/role"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanning"
	"github.com/chaitin/MonkeyCode/backend/db/securityscanningresult"
	"github.com/chaitin/MonkeyCode/backend/db/setting"
	"github.com/chaitin/MonkeyCode/backend/db/task"
	"github.com/chaitin/MonkeyCode/backend/db/taskrecord"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/db/usergroup"
	"github.com/chaitin/MonkeyCode/backend/db/usergroupadmin"
	"github.com/chaitin/MonkeyCode/backend/db/usergroupuser"
	"github.com/chaitin/MonkeyCode/backend/db/useridentity"
	"github.com/chaitin/MonkeyCode/backend/db/userloginhistory"
	"github.com/chaitin/MonkeyCode/backend/db/workspace"
	"github.com/chaitin/MonkeyCode/backend/db/workspacefile"

	stdsql "database/sql"
)

// Client is the client that holds all ent builders.
type Client struct {
	config
	// Schema is the client for creating, migrating and dropping schema.
	Schema *migrate.Schema
	// AIEmployee is the client for interacting with the AIEmployee builders.
	AIEmployee *AIEmployeeClient
	// AITask is the client for interacting with the AITask builders.
	AITask *AITaskClient
	// Admin is the client for interacting with the Admin builders.
	Admin *AdminClient
	// AdminLoginHistory is the client for interacting with the AdminLoginHistory builders.
	AdminLoginHistory *AdminLoginHistoryClient
	// AdminRole is the client for interacting with the AdminRole builders.
	AdminRole *AdminRoleClient
	// ApiKey is the client for interacting with the ApiKey builders.
	ApiKey *ApiKeyClient
	// BillingPlan is the client for interacting with the BillingPlan builders.
	BillingPlan *BillingPlanClient
	// BillingQuota is the client for interacting with the BillingQuota builders.
	BillingQuota *BillingQuotaClient
	// BillingRecord is the client for interacting with the BillingRecord builders.
	BillingRecord *BillingRecordClient
	// BillingUsage is the client for interacting with the BillingUsage builders.
	BillingUsage *BillingUsageClient
	// CodeSnippet is the client for interacting with the CodeSnippet builders.
	CodeSnippet *CodeSnippetClient
	// Extension is the client for interacting with the Extension builders.
	Extension *ExtensionClient
	// InviteCode is the client for interacting with the InviteCode builders.
	InviteCode *InviteCodeClient
	// License is the client for interacting with the License builders.
	License *LicenseClient
	// Model is the client for interacting with the Model builders.
	Model *ModelClient
	// ModelProvider is the client for interacting with the ModelProvider builders.
	ModelProvider *ModelProviderClient
	// ModelProviderModel is the client for interacting with the ModelProviderModel builders.
	ModelProviderModel *ModelProviderModelClient
	// Role is the client for interacting with the Role builders.
	Role *RoleClient
	// SecurityScanning is the client for interacting with the SecurityScanning builders.
	SecurityScanning *SecurityScanningClient
	// SecurityScanningResult is the client for interacting with the SecurityScanningResult builders.
	SecurityScanningResult *SecurityScanningResultClient
	// Setting is the client for interacting with the Setting builders.
	Setting *SettingClient
	// Task is the client for interacting with the Task builders.
	Task *TaskClient
	// TaskRecord is the client for interacting with the TaskRecord builders.
	TaskRecord *TaskRecordClient
	// User is the client for interacting with the User builders.
	User *UserClient
	// UserGroup is the client for interacting with the UserGroup builders.
	UserGroup *UserGroupClient
	// UserGroupAdmin is the client for interacting with the UserGroupAdmin builders.
	UserGroupAdmin *UserGroupAdminClient
	// UserGroupUser is the client for interacting with the UserGroupUser builders.
	UserGroupUser *UserGroupUserClient
	// UserIdentity is the client for interacting with the UserIdentity builders.
	UserIdentity *UserIdentityClient
	// UserLoginHistory is the client for interacting with the UserLoginHistory builders.
	UserLoginHistory *UserLoginHistoryClient
	// Workspace is the client for interacting with the Workspace builders.
	Workspace *WorkspaceClient
	// WorkspaceFile is the client for interacting with the WorkspaceFile builders.
	WorkspaceFile *WorkspaceFileClient
}

// NewClient creates a new client configured with the given options.
func NewClient(opts ...Option) *Client {
	client := &Client{config: newConfig(opts...)}
	client.init()
	return client
}

func (c *Client) init() {
	c.Schema = migrate.NewSchema(c.driver)
	c.AIEmployee = NewAIEmployeeClient(c.config)
	c.AITask = NewAITaskClient(c.config)
	c.Admin = NewAdminClient(c.config)
	c.AdminLoginHistory = NewAdminLoginHistoryClient(c.config)
	c.AdminRole = NewAdminRoleClient(c.config)
	c.ApiKey = NewApiKeyClient(c.config)
	c.BillingPlan = NewBillingPlanClient(c.config)
	c.BillingQuota = NewBillingQuotaClient(c.config)
	c.BillingRecord = NewBillingRecordClient(c.config)
	c.BillingUsage = NewBillingUsageClient(c.config)
	c.CodeSnippet = NewCodeSnippetClient(c.config)
	c.Extension = NewExtensionClient(c.config)
	c.InviteCode = NewInviteCodeClient(c.config)
	c.License = NewLicenseClient(c.config)
	c.Model = NewModelClient(c.config)
	c.ModelProvider = NewModelProviderClient(c.config)
	c.ModelProviderModel = NewModelProviderModelClient(c.config)
	c.Role = NewRoleClient(c.config)
	c.SecurityScanning = NewSecurityScanningClient(c.config)
	c.SecurityScanningResult = NewSecurityScanningResultClient(c.config)
	c.Setting = NewSettingClient(c.config)
	c.Task = NewTaskClient(c.config)
	c.TaskRecord = NewTaskRecordClient(c.config)
	c.User = NewUserClient(c.config)
	c.UserGroup = NewUserGroupClient(c.config)
	c.UserGroupAdmin = NewUserGroupAdminClient(c.config)
	c.UserGroupUser = NewUserGroupUserClient(c.config)
	c.UserIdentity = NewUserIdentityClient(c.config)
	c.UserLoginHistory = NewUserLoginHistoryClient(c.config)
	c.Workspace = NewWorkspaceClient(c.config)
	c.WorkspaceFile = NewWorkspaceFileClient(c.config)
}

type (
	// config is the configuration for the client and its builder.
	config struct {
		// driver used for executing database requests.
		driver dialect.Driver
		// debug enable a debug logging.
		debug bool
		// log used for logging on debug mode.
		log func(...any)
		// hooks to execute on mutations.
		hooks *hooks
		// interceptors to execute on queries.
		inters *inters
	}
	// Option function to configure the client.
	Option func(*config)
)

// newConfig creates a new config for the client.
func newConfig(opts ...Option) config {
	cfg := config{log: log.Println, hooks: &hooks{}, inters: &inters{}}
	cfg.options(opts...)
	return cfg
}

// options applies the options on the config object.
func (c *config) options(opts ...Option) {
	for _, opt := range opts {
		opt(c)
	}
	if c.debug {
		c.driver = dialect.Debug(c.driver, c.log)
	}
}

// Debug enables debug logging on the ent.Driver.
func Debug() Option {
	return func(c *config) {
		c.debug = true
	}
}

// Log sets the logging function for debug mode.
func Log(fn func(...any)) Option {
	return func(c *config) {
		c.log = fn
	}
}

// Driver configures the client driver.
func Driver(driver dialect.Driver) Option {
	return func(c *config) {
		c.driver = driver
	}
}

// Open opens a database/sql.DB specified by the driver name and
// the data source name, and returns a new client attached to it.
// Optional parameters can be added for configuring the client.
func Open(driverName, dataSourceName string, options ...Option) (*Client, error) {
	switch driverName {
	case dialect.MySQL, dialect.Postgres, dialect.SQLite:
		drv, err := sql.Open(driverName, dataSourceName)
		if err != nil {
			return nil, err
		}
		return NewClient(append(options, Driver(drv))...), nil
	default:
		return nil, fmt.Errorf("unsupported driver: %q", driverName)
	}
}

// ErrTxStarted is returned when trying to start a new transaction from a transactional client.
var ErrTxStarted = errors.New("db: cannot start a transaction within a transaction")

// Tx returns a new transactional client. The provided context
// is used until the transaction is committed or rolled back.
func (c *Client) Tx(ctx context.Context) (*Tx, error) {
	if _, ok := c.driver.(*txDriver); ok {
		return nil, ErrTxStarted
	}
	tx, err := newTx(ctx, c.driver)
	if err != nil {
		return nil, fmt.Errorf("db: starting a transaction: %w", err)
	}
	cfg := c.config
	cfg.driver = tx
	return &Tx{
		ctx:                    ctx,
		config:                 cfg,
		AIEmployee:             NewAIEmployeeClient(cfg),
		AITask:                 NewAITaskClient(cfg),
		Admin:                  NewAdminClient(cfg),
		AdminLoginHistory:      NewAdminLoginHistoryClient(cfg),
		AdminRole:              NewAdminRoleClient(cfg),
		ApiKey:                 NewApiKeyClient(cfg),
		BillingPlan:            NewBillingPlanClient(cfg),
		BillingQuota:           NewBillingQuotaClient(cfg),
		BillingRecord:          NewBillingRecordClient(cfg),
		BillingUsage:           NewBillingUsageClient(cfg),
		CodeSnippet:            NewCodeSnippetClient(cfg),
		Extension:              NewExtensionClient(cfg),
		InviteCode:             NewInviteCodeClient(cfg),
		License:                NewLicenseClient(cfg),
		Model:                  NewModelClient(cfg),
		ModelProvider:          NewModelProviderClient(cfg),
		ModelProviderModel:     NewModelProviderModelClient(cfg),
		Role:                   NewRoleClient(cfg),
		SecurityScanning:       NewSecurityScanningClient(cfg),
		SecurityScanningResult: NewSecurityScanningResultClient(cfg),
		Setting:                NewSettingClient(cfg),
		Task:                   NewTaskClient(cfg),
		TaskRecord:             NewTaskRecordClient(cfg),
		User:                   NewUserClient(cfg),
		UserGroup:              NewUserGroupClient(cfg),
		UserGroupAdmin:         NewUserGroupAdminClient(cfg),
		UserGroupUser:          NewUserGroupUserClient(cfg),
		UserIdentity:           NewUserIdentityClient(cfg),
		UserLoginHistory:       NewUserLoginHistoryClient(cfg),
		Workspace:              NewWorkspaceClient(cfg),
		WorkspaceFile:          NewWorkspaceFileClient(cfg),
	}, nil
}

// BeginTx returns a transactional client with specified options.
func (c *Client) BeginTx(ctx context.Context, opts *sql.TxOptions) (*Tx, error) {
	if _, ok := c.driver.(*txDriver); ok {
		return nil, errors.New("ent: cannot start a transaction within a transaction")
	}
	tx, err := c.driver.(interface {
		BeginTx(context.Context, *sql.TxOptions) (dialect.Tx, error)
	}).BeginTx(ctx, opts)
	if err != nil {
		return nil, fmt.Errorf("ent: starting a transaction: %w", err)
	}
	cfg := c.config
	cfg.driver = &txDriver{tx: tx, drv: c.driver}
	return &Tx{
		ctx:                    ctx,
		config:                 cfg,
		AIEmployee:             NewAIEmployeeClient(cfg),
		AITask:                 NewAITaskClient(cfg),
		Admin:                  NewAdminClient(cfg),
		AdminLoginHistory:      NewAdminLoginHistoryClient(cfg),
		AdminRole:              NewAdminRoleClient(cfg),
		ApiKey:                 NewApiKeyClient(cfg),
		BillingPlan:            NewBillingPlanClient(cfg),
		BillingQuota:           NewBillingQuotaClient(cfg),
		BillingRecord:          NewBillingRecordClient(cfg),
		BillingUsage:           NewBillingUsageClient(cfg),
		CodeSnippet:            NewCodeSnippetClient(cfg),
		Extension:              NewExtensionClient(cfg),
		InviteCode:             NewInviteCodeClient(cfg),
		License:                NewLicenseClient(cfg),
		Model:                  NewModelClient(cfg),
		ModelProvider:          NewModelProviderClient(cfg),
		ModelProviderModel:     NewModelProviderModelClient(cfg),
		Role:                   NewRoleClient(cfg),
		SecurityScanning:       NewSecurityScanningClient(cfg),
		SecurityScanningResult: NewSecurityScanningResultClient(cfg),
		Setting:                NewSettingClient(cfg),
		Task:                   NewTaskClient(cfg),
		TaskRecord:             NewTaskRecordClient(cfg),
		User:                   NewUserClient(cfg),
		UserGroup:              NewUserGroupClient(cfg),
		UserGroupAdmin:         NewUserGroupAdminClient(cfg),
		UserGroupUser:          NewUserGroupUserClient(cfg),
		UserIdentity:           NewUserIdentityClient(cfg),
		UserLoginHistory:       NewUserLoginHistoryClient(cfg),
		Workspace:              NewWorkspaceClient(cfg),
		WorkspaceFile:          NewWorkspaceFileClient(cfg),
	}, nil
}

// Debug returns a new debug-client. It's used to get verbose logging on specific operations.
//
//	client.Debug().
//		AIEmployee.
//		Query().
//		Count(ctx)
func (c *Client) Debug() *Client {
	if c.debug {
		return c
	}
	cfg := c.config
	cfg.driver = dialect.Debug(c.driver, c.log)
	client := &Client{config: cfg}
	client.init()
	return client
}

// Close closes the database connection and prevents new queries from starting.
func (c *Client) Close() error {
	return c.driver.Close()
}

// Use adds the mutation hooks to all the entity clients.
// In order to add hooks to a specific client, call: `client.Node.Use(...)`.
func (c *Client) Use(hooks ...Hook) {
	for _, n := range []interface{ Use(...Hook) }{
		c.AIEmployee, c.AITask, c.Admin, c.AdminLoginHistory, c.AdminRole, c.ApiKey,
		c.BillingPlan, c.BillingQuota, c.BillingRecord, c.BillingUsage, c.CodeSnippet,
		c.Extension, c.InviteCode, c.License, c.Model, c.ModelProvider,
		c.ModelProviderModel, c.Role, c.SecurityScanning, c.SecurityScanningResult,
		c.Setting, c.Task, c.TaskRecord, c.User, c.UserGroup, c.UserGroupAdmin,
		c.UserGroupUser, c.UserIdentity, c.UserLoginHistory, c.Workspace,
		c.WorkspaceFile,
	} {
		n.Use(hooks...)
	}
}

// Intercept adds the query interceptors to all the entity clients.
// In order to add interceptors to a specific client, call: `client.Node.Intercept(...)`.
func (c *Client) Intercept(interceptors ...Interceptor) {
	for _, n := range []interface{ Intercept(...Interceptor) }{
		c.AIEmployee, c.AITask, c.Admin, c.AdminLoginHistory, c.AdminRole, c.ApiKey,
		c.BillingPlan, c.BillingQuota, c.BillingRecord, c.BillingUsage, c.CodeSnippet,
		c.Extension, c.InviteCode, c.License, c.Model, c.ModelProvider,
		c.ModelProviderModel, c.Role, c.SecurityScanning, c.SecurityScanningResult,
		c.Setting, c.Task, c.TaskRecord, c.User, c.UserGroup, c.UserGroupAdmin,
		c.UserGroupUser, c.UserIdentity, c.UserLoginHistory, c.Workspace,
		c.WorkspaceFile,
	} {
		n.Intercept(interceptors...)
	}
}

// Mutate implements the ent.Mutator interface.
func (c *Client) Mutate(ctx context.Context, m Mutation) (Value, error) {
	switch m := m.(type) {
	case *AIEmployeeMutation:
		return c.AIEmployee.mutate(ctx, m)
	case *AITaskMutation:
		return c.AITask.mutate(ctx, m)
	case *AdminMutation:
		return c.Admin.mutate(ctx, m)
	case *AdminLoginHistoryMutation:
		return c.AdminLoginHistory.mutate(ctx, m)
	case *AdminRoleMutation:
		return c.AdminRole.mutate(ctx, m)
	case *ApiKeyMutation:
		return c.ApiKey.mutate(ctx, m)
	case *BillingPlanMutation:
		return c.BillingPlan.mutate(ctx, m)
	case *BillingQuotaMutation:
		return c.BillingQuota.mutate(ctx, m)
	case *BillingRecordMutation:
		return c.BillingRecord.mutate(ctx, m)
	case *BillingUsageMutation:
		return c.BillingUsage.mutate(ctx, m)
	case *CodeSnippetMutation:
		return c.CodeSnippet.mutate(ctx, m)
	case *ExtensionMutation:
		return c.Extension.mutate(ctx, m)
	case *InviteCodeMutation:
		return c.InviteCode.mutate(ctx, m)
	case *LicenseMutation:
		return c.License.mutate(ctx, m)
	case *ModelMutation:
		return c.Model.mutate(ctx, m)
	case *ModelProviderMutation:
		return c.ModelProvider.mutate(ctx, m)
	case *ModelProviderModelMutation:
		return c.ModelProviderModel.mutate(ctx, m)
	case *RoleMutation:
		return c.Role.mutate(ctx, m)
	case *SecurityScanningMutation:
		return c.SecurityScanning.mutate(ctx, m)
	case *SecurityScanningResultMutation:
		return c.SecurityScanningResult.mutate(ctx, m)
	case *SettingMutation:
		return c.Setting.mutate(ctx, m)
	case *TaskMutation:
		return c.Task.mutate(ctx, m)
	case *TaskRecordMutation:
		return c.TaskRecord.mutate(ctx, m)
	case *UserMutation:
		return c.User.mutate(ctx, m)
	case *UserGroupMutation:
		return c.UserGroup.mutate(ctx, m)
	case *UserGroupAdminMutation:
		return c.UserGroupAdmin.mutate(ctx, m)
	case *UserGroupUserMutation:
		return c.UserGroupUser.mutate(ctx, m)
	case *UserIdentityMutation:
		return c.UserIdentity.mutate(ctx, m)
	case *UserLoginHistoryMutation:
		return c.UserLoginHistory.mutate(ctx, m)
	case *WorkspaceMutation:
		return c.Workspace.mutate(ctx, m)
	case *WorkspaceFileMutation:
		return c.WorkspaceFile.mutate(ctx, m)
	default:
		return nil, fmt.Errorf("db: unknown mutation type %T", m)
	}
}

// AIEmployeeClient is a client for the AIEmployee schema.
type AIEmployeeClient struct {
	config
}

// NewAIEmployeeClient returns a client for the AIEmployee from the given config.
func NewAIEmployeeClient(c config) *AIEmployeeClient {
	return &AIEmployeeClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `aiemployee.Hooks(f(g(h())))`.
func (c *AIEmployeeClient) Use(hooks ...Hook) {
	c.hooks.AIEmployee = append(c.hooks.AIEmployee, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `aiemployee.Intercept(f(g(h())))`.
func (c *AIEmployeeClient) Intercept(interceptors ...Interceptor) {
	c.inters.AIEmployee = append(c.inters.AIEmployee, interceptors...)
}

// Create returns a builder for creating a AIEmployee entity.
func (c *AIEmployeeClient) Create() *AIEmployeeCreate {
	mutation := newAIEmployeeMutation(c.config, OpCreate)
	return &AIEmployeeCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of AIEmployee entities.
func (c *AIEmployeeClient) CreateBulk(builders ...*AIEmployeeCreate) *AIEmployeeCreateBulk {
	return &AIEmployeeCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *AIEmployeeClient) MapCreateBulk(slice any, setFunc func(*AIEmployeeCreate, int)) *AIEmployeeCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &AIEmployeeCreateBulk{err: fmt.Errorf("calling to AIEmployeeClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*AIEmployeeCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &AIEmployeeCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for AIEmployee.
func (c *AIEmployeeClient) Update() *AIEmployeeUpdate {
	mutation := newAIEmployeeMutation(c.config, OpUpdate)
	return &AIEmployeeUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *AIEmployeeClient) UpdateOne(ae *AIEmployee) *AIEmployeeUpdateOne {
	mutation := newAIEmployeeMutation(c.config, OpUpdateOne, withAIEmployee(ae))
	return &AIEmployeeUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *AIEmployeeClient) UpdateOneID(id uuid.UUID) *AIEmployeeUpdateOne {
	mutation := newAIEmployeeMutation(c.config, OpUpdateOne, withAIEmployeeID(id))
	return &AIEmployeeUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for AIEmployee.
func (c *AIEmployeeClient) Delete() *AIEmployeeDelete {
	mutation := newAIEmployeeMutation(c.config, OpDelete)
	return &AIEmployeeDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *AIEmployeeClient) DeleteOne(ae *AIEmployee) *AIEmployeeDeleteOne {
	return c.DeleteOneID(ae.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *AIEmployeeClient) DeleteOneID(id uuid.UUID) *AIEmployeeDeleteOne {
	builder := c.Delete().Where(aiemployee.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &AIEmployeeDeleteOne{builder}
}

// Query returns a query builder for AIEmployee.
func (c *AIEmployeeClient) Query() *AIEmployeeQuery {
	return &AIEmployeeQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeAIEmployee},
		inters: c.Interceptors(),
	}
}

// Get returns a AIEmployee entity by its id.
func (c *AIEmployeeClient) Get(ctx context.Context, id uuid.UUID) (*AIEmployee, error) {
	return c.Query().Where(aiemployee.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *AIEmployeeClient) GetX(ctx context.Context, id uuid.UUID) *AIEmployee {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryAdmin queries the admin edge of a AIEmployee.
func (c *AIEmployeeClient) QueryAdmin(ae *AIEmployee) *AdminQuery {
	query := (&AdminClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ae.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(aiemployee.Table, aiemployee.FieldID, id),
			sqlgraph.To(admin.Table, admin.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, aiemployee.AdminTable, aiemployee.AdminColumn),
		)
		fromV = sqlgraph.Neighbors(ae.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryUser queries the user edge of a AIEmployee.
func (c *AIEmployeeClient) QueryUser(ae *AIEmployee) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ae.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(aiemployee.Table, aiemployee.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, aiemployee.UserTable, aiemployee.UserColumn),
		)
		fromV = sqlgraph.Neighbors(ae.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *AIEmployeeClient) Hooks() []Hook {
	return c.hooks.AIEmployee
}

// Interceptors returns the client interceptors.
func (c *AIEmployeeClient) Interceptors() []Interceptor {
	return c.inters.AIEmployee
}

func (c *AIEmployeeClient) mutate(ctx context.Context, m *AIEmployeeMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&AIEmployeeCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&AIEmployeeUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&AIEmployeeUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&AIEmployeeDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown AIEmployee mutation op: %q", m.Op())
	}
}

// AITaskClient is a client for the AITask schema.
type AITaskClient struct {
	config
}

// NewAITaskClient returns a client for the AITask from the given config.
func NewAITaskClient(c config) *AITaskClient {
	return &AITaskClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `aitask.Hooks(f(g(h())))`.
func (c *AITaskClient) Use(hooks ...Hook) {
	c.hooks.AITask = append(c.hooks.AITask, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `aitask.Intercept(f(g(h())))`.
func (c *AITaskClient) Intercept(interceptors ...Interceptor) {
	c.inters.AITask = append(c.inters.AITask, interceptors...)
}

// Create returns a builder for creating a AITask entity.
func (c *AITaskClient) Create() *AITaskCreate {
	mutation := newAITaskMutation(c.config, OpCreate)
	return &AITaskCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of AITask entities.
func (c *AITaskClient) CreateBulk(builders ...*AITaskCreate) *AITaskCreateBulk {
	return &AITaskCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *AITaskClient) MapCreateBulk(slice any, setFunc func(*AITaskCreate, int)) *AITaskCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &AITaskCreateBulk{err: fmt.Errorf("calling to AITaskClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*AITaskCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &AITaskCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for AITask.
func (c *AITaskClient) Update() *AITaskUpdate {
	mutation := newAITaskMutation(c.config, OpUpdate)
	return &AITaskUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *AITaskClient) UpdateOne(at *AITask) *AITaskUpdateOne {
	mutation := newAITaskMutation(c.config, OpUpdateOne, withAITask(at))
	return &AITaskUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *AITaskClient) UpdateOneID(id uuid.UUID) *AITaskUpdateOne {
	mutation := newAITaskMutation(c.config, OpUpdateOne, withAITaskID(id))
	return &AITaskUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for AITask.
func (c *AITaskClient) Delete() *AITaskDelete {
	mutation := newAITaskMutation(c.config, OpDelete)
	return &AITaskDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *AITaskClient) DeleteOne(at *AITask) *AITaskDeleteOne {
	return c.DeleteOneID(at.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *AITaskClient) DeleteOneID(id uuid.UUID) *AITaskDeleteOne {
	builder := c.Delete().Where(aitask.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &AITaskDeleteOne{builder}
}

// Query returns a query builder for AITask.
func (c *AITaskClient) Query() *AITaskQuery {
	return &AITaskQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeAITask},
		inters: c.Interceptors(),
	}
}

// Get returns a AITask entity by its id.
func (c *AITaskClient) Get(ctx context.Context, id uuid.UUID) (*AITask, error) {
	return c.Query().Where(aitask.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *AITaskClient) GetX(ctx context.Context, id uuid.UUID) *AITask {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *AITaskClient) Hooks() []Hook {
	return c.hooks.AITask
}

// Interceptors returns the client interceptors.
func (c *AITaskClient) Interceptors() []Interceptor {
	return c.inters.AITask
}

func (c *AITaskClient) mutate(ctx context.Context, m *AITaskMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&AITaskCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&AITaskUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&AITaskUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&AITaskDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown AITask mutation op: %q", m.Op())
	}
}

// AdminClient is a client for the Admin schema.
type AdminClient struct {
	config
}

// NewAdminClient returns a client for the Admin from the given config.
func NewAdminClient(c config) *AdminClient {
	return &AdminClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `admin.Hooks(f(g(h())))`.
func (c *AdminClient) Use(hooks ...Hook) {
	c.hooks.Admin = append(c.hooks.Admin, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `admin.Intercept(f(g(h())))`.
func (c *AdminClient) Intercept(interceptors ...Interceptor) {
	c.inters.Admin = append(c.inters.Admin, interceptors...)
}

// Create returns a builder for creating a Admin entity.
func (c *AdminClient) Create() *AdminCreate {
	mutation := newAdminMutation(c.config, OpCreate)
	return &AdminCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Admin entities.
func (c *AdminClient) CreateBulk(builders ...*AdminCreate) *AdminCreateBulk {
	return &AdminCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *AdminClient) MapCreateBulk(slice any, setFunc func(*AdminCreate, int)) *AdminCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &AdminCreateBulk{err: fmt.Errorf("calling to AdminClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*AdminCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &AdminCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Admin.
func (c *AdminClient) Update() *AdminUpdate {
	mutation := newAdminMutation(c.config, OpUpdate)
	return &AdminUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *AdminClient) UpdateOne(a *Admin) *AdminUpdateOne {
	mutation := newAdminMutation(c.config, OpUpdateOne, withAdmin(a))
	return &AdminUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *AdminClient) UpdateOneID(id uuid.UUID) *AdminUpdateOne {
	mutation := newAdminMutation(c.config, OpUpdateOne, withAdminID(id))
	return &AdminUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Admin.
func (c *AdminClient) Delete() *AdminDelete {
	mutation := newAdminMutation(c.config, OpDelete)
	return &AdminDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *AdminClient) DeleteOne(a *Admin) *AdminDeleteOne {
	return c.DeleteOneID(a.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *AdminClient) DeleteOneID(id uuid.UUID) *AdminDeleteOne {
	builder := c.Delete().Where(admin.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &AdminDeleteOne{builder}
}

// Query returns a query builder for Admin.
func (c *AdminClient) Query() *AdminQuery {
	return &AdminQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeAdmin},
		inters: c.Interceptors(),
	}
}

// Get returns a Admin entity by its id.
func (c *AdminClient) Get(ctx context.Context, id uuid.UUID) (*Admin, error) {
	return c.Query().Where(admin.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *AdminClient) GetX(ctx context.Context, id uuid.UUID) *Admin {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryLoginHistories queries the login_histories edge of a Admin.
func (c *AdminClient) QueryLoginHistories(a *Admin) *AdminLoginHistoryQuery {
	query := (&AdminLoginHistoryClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := a.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(admin.Table, admin.FieldID, id),
			sqlgraph.To(adminloginhistory.Table, adminloginhistory.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, admin.LoginHistoriesTable, admin.LoginHistoriesColumn),
		)
		fromV = sqlgraph.Neighbors(a.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryMyusergroups queries the myusergroups edge of a Admin.
func (c *AdminClient) QueryMyusergroups(a *Admin) *UserGroupQuery {
	query := (&UserGroupClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := a.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(admin.Table, admin.FieldID, id),
			sqlgraph.To(usergroup.Table, usergroup.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, admin.MyusergroupsTable, admin.MyusergroupsColumn),
		)
		fromV = sqlgraph.Neighbors(a.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryAiemployees queries the aiemployees edge of a Admin.
func (c *AdminClient) QueryAiemployees(a *Admin) *AIEmployeeQuery {
	query := (&AIEmployeeClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := a.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(admin.Table, admin.FieldID, id),
			sqlgraph.To(aiemployee.Table, aiemployee.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, admin.AiemployeesTable, admin.AiemployeesColumn),
		)
		fromV = sqlgraph.Neighbors(a.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryUsergroups queries the usergroups edge of a Admin.
func (c *AdminClient) QueryUsergroups(a *Admin) *UserGroupQuery {
	query := (&UserGroupClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := a.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(admin.Table, admin.FieldID, id),
			sqlgraph.To(usergroup.Table, usergroup.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, true, admin.UsergroupsTable, admin.UsergroupsPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(a.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryRoles queries the roles edge of a Admin.
func (c *AdminClient) QueryRoles(a *Admin) *RoleQuery {
	query := (&RoleClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := a.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(admin.Table, admin.FieldID, id),
			sqlgraph.To(role.Table, role.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, true, admin.RolesTable, admin.RolesPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(a.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryUserGroupAdmins queries the user_group_admins edge of a Admin.
func (c *AdminClient) QueryUserGroupAdmins(a *Admin) *UserGroupAdminQuery {
	query := (&UserGroupAdminClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := a.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(admin.Table, admin.FieldID, id),
			sqlgraph.To(usergroupadmin.Table, usergroupadmin.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, admin.UserGroupAdminsTable, admin.UserGroupAdminsColumn),
		)
		fromV = sqlgraph.Neighbors(a.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryAdminRoles queries the admin_roles edge of a Admin.
func (c *AdminClient) QueryAdminRoles(a *Admin) *AdminRoleQuery {
	query := (&AdminRoleClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := a.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(admin.Table, admin.FieldID, id),
			sqlgraph.To(adminrole.Table, adminrole.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, admin.AdminRolesTable, admin.AdminRolesColumn),
		)
		fromV = sqlgraph.Neighbors(a.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *AdminClient) Hooks() []Hook {
	return c.hooks.Admin
}

// Interceptors returns the client interceptors.
func (c *AdminClient) Interceptors() []Interceptor {
	return c.inters.Admin
}

func (c *AdminClient) mutate(ctx context.Context, m *AdminMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&AdminCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&AdminUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&AdminUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&AdminDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown Admin mutation op: %q", m.Op())
	}
}

// AdminLoginHistoryClient is a client for the AdminLoginHistory schema.
type AdminLoginHistoryClient struct {
	config
}

// NewAdminLoginHistoryClient returns a client for the AdminLoginHistory from the given config.
func NewAdminLoginHistoryClient(c config) *AdminLoginHistoryClient {
	return &AdminLoginHistoryClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `adminloginhistory.Hooks(f(g(h())))`.
func (c *AdminLoginHistoryClient) Use(hooks ...Hook) {
	c.hooks.AdminLoginHistory = append(c.hooks.AdminLoginHistory, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `adminloginhistory.Intercept(f(g(h())))`.
func (c *AdminLoginHistoryClient) Intercept(interceptors ...Interceptor) {
	c.inters.AdminLoginHistory = append(c.inters.AdminLoginHistory, interceptors...)
}

// Create returns a builder for creating a AdminLoginHistory entity.
func (c *AdminLoginHistoryClient) Create() *AdminLoginHistoryCreate {
	mutation := newAdminLoginHistoryMutation(c.config, OpCreate)
	return &AdminLoginHistoryCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of AdminLoginHistory entities.
func (c *AdminLoginHistoryClient) CreateBulk(builders ...*AdminLoginHistoryCreate) *AdminLoginHistoryCreateBulk {
	return &AdminLoginHistoryCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *AdminLoginHistoryClient) MapCreateBulk(slice any, setFunc func(*AdminLoginHistoryCreate, int)) *AdminLoginHistoryCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &AdminLoginHistoryCreateBulk{err: fmt.Errorf("calling to AdminLoginHistoryClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*AdminLoginHistoryCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &AdminLoginHistoryCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for AdminLoginHistory.
func (c *AdminLoginHistoryClient) Update() *AdminLoginHistoryUpdate {
	mutation := newAdminLoginHistoryMutation(c.config, OpUpdate)
	return &AdminLoginHistoryUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *AdminLoginHistoryClient) UpdateOne(alh *AdminLoginHistory) *AdminLoginHistoryUpdateOne {
	mutation := newAdminLoginHistoryMutation(c.config, OpUpdateOne, withAdminLoginHistory(alh))
	return &AdminLoginHistoryUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *AdminLoginHistoryClient) UpdateOneID(id uuid.UUID) *AdminLoginHistoryUpdateOne {
	mutation := newAdminLoginHistoryMutation(c.config, OpUpdateOne, withAdminLoginHistoryID(id))
	return &AdminLoginHistoryUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for AdminLoginHistory.
func (c *AdminLoginHistoryClient) Delete() *AdminLoginHistoryDelete {
	mutation := newAdminLoginHistoryMutation(c.config, OpDelete)
	return &AdminLoginHistoryDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *AdminLoginHistoryClient) DeleteOne(alh *AdminLoginHistory) *AdminLoginHistoryDeleteOne {
	return c.DeleteOneID(alh.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *AdminLoginHistoryClient) DeleteOneID(id uuid.UUID) *AdminLoginHistoryDeleteOne {
	builder := c.Delete().Where(adminloginhistory.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &AdminLoginHistoryDeleteOne{builder}
}

// Query returns a query builder for AdminLoginHistory.
func (c *AdminLoginHistoryClient) Query() *AdminLoginHistoryQuery {
	return &AdminLoginHistoryQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeAdminLoginHistory},
		inters: c.Interceptors(),
	}
}

// Get returns a AdminLoginHistory entity by its id.
func (c *AdminLoginHistoryClient) Get(ctx context.Context, id uuid.UUID) (*AdminLoginHistory, error) {
	return c.Query().Where(adminloginhistory.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *AdminLoginHistoryClient) GetX(ctx context.Context, id uuid.UUID) *AdminLoginHistory {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryOwner queries the owner edge of a AdminLoginHistory.
func (c *AdminLoginHistoryClient) QueryOwner(alh *AdminLoginHistory) *AdminQuery {
	query := (&AdminClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := alh.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(adminloginhistory.Table, adminloginhistory.FieldID, id),
			sqlgraph.To(admin.Table, admin.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, adminloginhistory.OwnerTable, adminloginhistory.OwnerColumn),
		)
		fromV = sqlgraph.Neighbors(alh.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *AdminLoginHistoryClient) Hooks() []Hook {
	return c.hooks.AdminLoginHistory
}

// Interceptors returns the client interceptors.
func (c *AdminLoginHistoryClient) Interceptors() []Interceptor {
	return c.inters.AdminLoginHistory
}

func (c *AdminLoginHistoryClient) mutate(ctx context.Context, m *AdminLoginHistoryMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&AdminLoginHistoryCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&AdminLoginHistoryUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&AdminLoginHistoryUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&AdminLoginHistoryDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown AdminLoginHistory mutation op: %q", m.Op())
	}
}

// AdminRoleClient is a client for the AdminRole schema.
type AdminRoleClient struct {
	config
}

// NewAdminRoleClient returns a client for the AdminRole from the given config.
func NewAdminRoleClient(c config) *AdminRoleClient {
	return &AdminRoleClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `adminrole.Hooks(f(g(h())))`.
func (c *AdminRoleClient) Use(hooks ...Hook) {
	c.hooks.AdminRole = append(c.hooks.AdminRole, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `adminrole.Intercept(f(g(h())))`.
func (c *AdminRoleClient) Intercept(interceptors ...Interceptor) {
	c.inters.AdminRole = append(c.inters.AdminRole, interceptors...)
}

// Create returns a builder for creating a AdminRole entity.
func (c *AdminRoleClient) Create() *AdminRoleCreate {
	mutation := newAdminRoleMutation(c.config, OpCreate)
	return &AdminRoleCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of AdminRole entities.
func (c *AdminRoleClient) CreateBulk(builders ...*AdminRoleCreate) *AdminRoleCreateBulk {
	return &AdminRoleCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *AdminRoleClient) MapCreateBulk(slice any, setFunc func(*AdminRoleCreate, int)) *AdminRoleCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &AdminRoleCreateBulk{err: fmt.Errorf("calling to AdminRoleClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*AdminRoleCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &AdminRoleCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for AdminRole.
func (c *AdminRoleClient) Update() *AdminRoleUpdate {
	mutation := newAdminRoleMutation(c.config, OpUpdate)
	return &AdminRoleUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *AdminRoleClient) UpdateOne(ar *AdminRole) *AdminRoleUpdateOne {
	mutation := newAdminRoleMutation(c.config, OpUpdateOne, withAdminRole(ar))
	return &AdminRoleUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *AdminRoleClient) UpdateOneID(id uuid.UUID) *AdminRoleUpdateOne {
	mutation := newAdminRoleMutation(c.config, OpUpdateOne, withAdminRoleID(id))
	return &AdminRoleUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for AdminRole.
func (c *AdminRoleClient) Delete() *AdminRoleDelete {
	mutation := newAdminRoleMutation(c.config, OpDelete)
	return &AdminRoleDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *AdminRoleClient) DeleteOne(ar *AdminRole) *AdminRoleDeleteOne {
	return c.DeleteOneID(ar.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *AdminRoleClient) DeleteOneID(id uuid.UUID) *AdminRoleDeleteOne {
	builder := c.Delete().Where(adminrole.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &AdminRoleDeleteOne{builder}
}

// Query returns a query builder for AdminRole.
func (c *AdminRoleClient) Query() *AdminRoleQuery {
	return &AdminRoleQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeAdminRole},
		inters: c.Interceptors(),
	}
}

// Get returns a AdminRole entity by its id.
func (c *AdminRoleClient) Get(ctx context.Context, id uuid.UUID) (*AdminRole, error) {
	return c.Query().Where(adminrole.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *AdminRoleClient) GetX(ctx context.Context, id uuid.UUID) *AdminRole {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryAdmin queries the admin edge of a AdminRole.
func (c *AdminRoleClient) QueryAdmin(ar *AdminRole) *AdminQuery {
	query := (&AdminClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ar.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(adminrole.Table, adminrole.FieldID, id),
			sqlgraph.To(admin.Table, admin.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, adminrole.AdminTable, adminrole.AdminColumn),
		)
		fromV = sqlgraph.Neighbors(ar.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryRole queries the role edge of a AdminRole.
func (c *AdminRoleClient) QueryRole(ar *AdminRole) *RoleQuery {
	query := (&RoleClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ar.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(adminrole.Table, adminrole.FieldID, id),
			sqlgraph.To(role.Table, role.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, adminrole.RoleTable, adminrole.RoleColumn),
		)
		fromV = sqlgraph.Neighbors(ar.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *AdminRoleClient) Hooks() []Hook {
	return c.hooks.AdminRole
}

// Interceptors returns the client interceptors.
func (c *AdminRoleClient) Interceptors() []Interceptor {
	return c.inters.AdminRole
}

func (c *AdminRoleClient) mutate(ctx context.Context, m *AdminRoleMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&AdminRoleCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&AdminRoleUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&AdminRoleUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&AdminRoleDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown AdminRole mutation op: %q", m.Op())
	}
}

// ApiKeyClient is a client for the ApiKey schema.
type ApiKeyClient struct {
	config
}

// NewApiKeyClient returns a client for the ApiKey from the given config.
func NewApiKeyClient(c config) *ApiKeyClient {
	return &ApiKeyClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `apikey.Hooks(f(g(h())))`.
func (c *ApiKeyClient) Use(hooks ...Hook) {
	c.hooks.ApiKey = append(c.hooks.ApiKey, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `apikey.Intercept(f(g(h())))`.
func (c *ApiKeyClient) Intercept(interceptors ...Interceptor) {
	c.inters.ApiKey = append(c.inters.ApiKey, interceptors...)
}

// Create returns a builder for creating a ApiKey entity.
func (c *ApiKeyClient) Create() *ApiKeyCreate {
	mutation := newApiKeyMutation(c.config, OpCreate)
	return &ApiKeyCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of ApiKey entities.
func (c *ApiKeyClient) CreateBulk(builders ...*ApiKeyCreate) *ApiKeyCreateBulk {
	return &ApiKeyCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *ApiKeyClient) MapCreateBulk(slice any, setFunc func(*ApiKeyCreate, int)) *ApiKeyCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &ApiKeyCreateBulk{err: fmt.Errorf("calling to ApiKeyClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*ApiKeyCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &ApiKeyCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for ApiKey.
func (c *ApiKeyClient) Update() *ApiKeyUpdate {
	mutation := newApiKeyMutation(c.config, OpUpdate)
	return &ApiKeyUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *ApiKeyClient) UpdateOne(ak *ApiKey) *ApiKeyUpdateOne {
	mutation := newApiKeyMutation(c.config, OpUpdateOne, withApiKey(ak))
	return &ApiKeyUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *ApiKeyClient) UpdateOneID(id uuid.UUID) *ApiKeyUpdateOne {
	mutation := newApiKeyMutation(c.config, OpUpdateOne, withApiKeyID(id))
	return &ApiKeyUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for ApiKey.
func (c *ApiKeyClient) Delete() *ApiKeyDelete {
	mutation := newApiKeyMutation(c.config, OpDelete)
	return &ApiKeyDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *ApiKeyClient) DeleteOne(ak *ApiKey) *ApiKeyDeleteOne {
	return c.DeleteOneID(ak.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *ApiKeyClient) DeleteOneID(id uuid.UUID) *ApiKeyDeleteOne {
	builder := c.Delete().Where(apikey.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &ApiKeyDeleteOne{builder}
}

// Query returns a query builder for ApiKey.
func (c *ApiKeyClient) Query() *ApiKeyQuery {
	return &ApiKeyQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeApiKey},
		inters: c.Interceptors(),
	}
}

// Get returns a ApiKey entity by its id.
func (c *ApiKeyClient) Get(ctx context.Context, id uuid.UUID) (*ApiKey, error) {
	return c.Query().Where(apikey.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *ApiKeyClient) GetX(ctx context.Context, id uuid.UUID) *ApiKey {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryUser queries the user edge of a ApiKey.
func (c *ApiKeyClient) QueryUser(ak *ApiKey) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ak.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(apikey.Table, apikey.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, apikey.UserTable, apikey.UserColumn),
		)
		fromV = sqlgraph.Neighbors(ak.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *ApiKeyClient) Hooks() []Hook {
	return c.hooks.ApiKey
}

// Interceptors returns the client interceptors.
func (c *ApiKeyClient) Interceptors() []Interceptor {
	return c.inters.ApiKey
}

func (c *ApiKeyClient) mutate(ctx context.Context, m *ApiKeyMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&ApiKeyCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&ApiKeyUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&ApiKeyUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&ApiKeyDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown ApiKey mutation op: %q", m.Op())
	}
}

// BillingPlanClient is a client for the BillingPlan schema.
type BillingPlanClient struct {
	config
}

// NewBillingPlanClient returns a client for the BillingPlan from the given config.
func NewBillingPlanClient(c config) *BillingPlanClient {
	return &BillingPlanClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `billingplan.Hooks(f(g(h())))`.
func (c *BillingPlanClient) Use(hooks ...Hook) {
	c.hooks.BillingPlan = append(c.hooks.BillingPlan, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `billingplan.Intercept(f(g(h())))`.
func (c *BillingPlanClient) Intercept(interceptors ...Interceptor) {
	c.inters.BillingPlan = append(c.inters.BillingPlan, interceptors...)
}

// Create returns a builder for creating a BillingPlan entity.
func (c *BillingPlanClient) Create() *BillingPlanCreate {
	mutation := newBillingPlanMutation(c.config, OpCreate)
	return &BillingPlanCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of BillingPlan entities.
func (c *BillingPlanClient) CreateBulk(builders ...*BillingPlanCreate) *BillingPlanCreateBulk {
	return &BillingPlanCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *BillingPlanClient) MapCreateBulk(slice any, setFunc func(*BillingPlanCreate, int)) *BillingPlanCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &BillingPlanCreateBulk{err: fmt.Errorf("calling to BillingPlanClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*BillingPlanCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &BillingPlanCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for BillingPlan.
func (c *BillingPlanClient) Update() *BillingPlanUpdate {
	mutation := newBillingPlanMutation(c.config, OpUpdate)
	return &BillingPlanUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *BillingPlanClient) UpdateOne(bp *BillingPlan) *BillingPlanUpdateOne {
	mutation := newBillingPlanMutation(c.config, OpUpdateOne, withBillingPlan(bp))
	return &BillingPlanUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *BillingPlanClient) UpdateOneID(id string) *BillingPlanUpdateOne {
	mutation := newBillingPlanMutation(c.config, OpUpdateOne, withBillingPlanID(id))
	return &BillingPlanUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for BillingPlan.
func (c *BillingPlanClient) Delete() *BillingPlanDelete {
	mutation := newBillingPlanMutation(c.config, OpDelete)
	return &BillingPlanDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *BillingPlanClient) DeleteOne(bp *BillingPlan) *BillingPlanDeleteOne {
	return c.DeleteOneID(bp.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *BillingPlanClient) DeleteOneID(id string) *BillingPlanDeleteOne {
	builder := c.Delete().Where(billingplan.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &BillingPlanDeleteOne{builder}
}

// Query returns a query builder for BillingPlan.
func (c *BillingPlanClient) Query() *BillingPlanQuery {
	return &BillingPlanQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeBillingPlan},
		inters: c.Interceptors(),
	}
}

// Get returns a BillingPlan entity by its id.
func (c *BillingPlanClient) Get(ctx context.Context, id string) (*BillingPlan, error) {
	return c.Query().Where(billingplan.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *BillingPlanClient) GetX(ctx context.Context, id string) *BillingPlan {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *BillingPlanClient) Hooks() []Hook {
	return c.hooks.BillingPlan
}

// Interceptors returns the client interceptors.
func (c *BillingPlanClient) Interceptors() []Interceptor {
	return c.inters.BillingPlan
}

func (c *BillingPlanClient) mutate(ctx context.Context, m *BillingPlanMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&BillingPlanCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&BillingPlanUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&BillingPlanUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&BillingPlanDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown BillingPlan mutation op: %q", m.Op())
	}
}

// BillingQuotaClient is a client for the BillingQuota schema.
type BillingQuotaClient struct {
	config
}

// NewBillingQuotaClient returns a client for the BillingQuota from the given config.
func NewBillingQuotaClient(c config) *BillingQuotaClient {
	return &BillingQuotaClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `billingquota.Hooks(f(g(h())))`.
func (c *BillingQuotaClient) Use(hooks ...Hook) {
	c.hooks.BillingQuota = append(c.hooks.BillingQuota, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `billingquota.Intercept(f(g(h())))`.
func (c *BillingQuotaClient) Intercept(interceptors ...Interceptor) {
	c.inters.BillingQuota = append(c.inters.BillingQuota, interceptors...)
}

// Create returns a builder for creating a BillingQuota entity.
func (c *BillingQuotaClient) Create() *BillingQuotaCreate {
	mutation := newBillingQuotaMutation(c.config, OpCreate)
	return &BillingQuotaCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of BillingQuota entities.
func (c *BillingQuotaClient) CreateBulk(builders ...*BillingQuotaCreate) *BillingQuotaCreateBulk {
	return &BillingQuotaCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *BillingQuotaClient) MapCreateBulk(slice any, setFunc func(*BillingQuotaCreate, int)) *BillingQuotaCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &BillingQuotaCreateBulk{err: fmt.Errorf("calling to BillingQuotaClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*BillingQuotaCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &BillingQuotaCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for BillingQuota.
func (c *BillingQuotaClient) Update() *BillingQuotaUpdate {
	mutation := newBillingQuotaMutation(c.config, OpUpdate)
	return &BillingQuotaUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *BillingQuotaClient) UpdateOne(bq *BillingQuota) *BillingQuotaUpdateOne {
	mutation := newBillingQuotaMutation(c.config, OpUpdateOne, withBillingQuota(bq))
	return &BillingQuotaUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *BillingQuotaClient) UpdateOneID(id string) *BillingQuotaUpdateOne {
	mutation := newBillingQuotaMutation(c.config, OpUpdateOne, withBillingQuotaID(id))
	return &BillingQuotaUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for BillingQuota.
func (c *BillingQuotaClient) Delete() *BillingQuotaDelete {
	mutation := newBillingQuotaMutation(c.config, OpDelete)
	return &BillingQuotaDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *BillingQuotaClient) DeleteOne(bq *BillingQuota) *BillingQuotaDeleteOne {
	return c.DeleteOneID(bq.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *BillingQuotaClient) DeleteOneID(id string) *BillingQuotaDeleteOne {
	builder := c.Delete().Where(billingquota.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &BillingQuotaDeleteOne{builder}
}

// Query returns a query builder for BillingQuota.
func (c *BillingQuotaClient) Query() *BillingQuotaQuery {
	return &BillingQuotaQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeBillingQuota},
		inters: c.Interceptors(),
	}
}

// Get returns a BillingQuota entity by its id.
func (c *BillingQuotaClient) Get(ctx context.Context, id string) (*BillingQuota, error) {
	return c.Query().Where(billingquota.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *BillingQuotaClient) GetX(ctx context.Context, id string) *BillingQuota {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *BillingQuotaClient) Hooks() []Hook {
	hooks := c.hooks.BillingQuota
	return append(hooks[:len(hooks):len(hooks)], billingquota.Hooks[:]...)
}

// Interceptors returns the client interceptors.
func (c *BillingQuotaClient) Interceptors() []Interceptor {
	inters := c.inters.BillingQuota
	return append(inters[:len(inters):len(inters)], billingquota.Interceptors[:]...)
}

func (c *BillingQuotaClient) mutate(ctx context.Context, m *BillingQuotaMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&BillingQuotaCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&BillingQuotaUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&BillingQuotaUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&BillingQuotaDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown BillingQuota mutation op: %q", m.Op())
	}
}

// BillingRecordClient is a client for the BillingRecord schema.
type BillingRecordClient struct {
	config
}

// NewBillingRecordClient returns a client for the BillingRecord from the given config.
func NewBillingRecordClient(c config) *BillingRecordClient {
	return &BillingRecordClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `billingrecord.Hooks(f(g(h())))`.
func (c *BillingRecordClient) Use(hooks ...Hook) {
	c.hooks.BillingRecord = append(c.hooks.BillingRecord, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `billingrecord.Intercept(f(g(h())))`.
func (c *BillingRecordClient) Intercept(interceptors ...Interceptor) {
	c.inters.BillingRecord = append(c.inters.BillingRecord, interceptors...)
}

// Create returns a builder for creating a BillingRecord entity.
func (c *BillingRecordClient) Create() *BillingRecordCreate {
	mutation := newBillingRecordMutation(c.config, OpCreate)
	return &BillingRecordCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of BillingRecord entities.
func (c *BillingRecordClient) CreateBulk(builders ...*BillingRecordCreate) *BillingRecordCreateBulk {
	return &BillingRecordCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *BillingRecordClient) MapCreateBulk(slice any, setFunc func(*BillingRecordCreate, int)) *BillingRecordCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &BillingRecordCreateBulk{err: fmt.Errorf("calling to BillingRecordClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*BillingRecordCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &BillingRecordCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for BillingRecord.
func (c *BillingRecordClient) Update() *BillingRecordUpdate {
	mutation := newBillingRecordMutation(c.config, OpUpdate)
	return &BillingRecordUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *BillingRecordClient) UpdateOne(br *BillingRecord) *BillingRecordUpdateOne {
	mutation := newBillingRecordMutation(c.config, OpUpdateOne, withBillingRecord(br))
	return &BillingRecordUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *BillingRecordClient) UpdateOneID(id string) *BillingRecordUpdateOne {
	mutation := newBillingRecordMutation(c.config, OpUpdateOne, withBillingRecordID(id))
	return &BillingRecordUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for BillingRecord.
func (c *BillingRecordClient) Delete() *BillingRecordDelete {
	mutation := newBillingRecordMutation(c.config, OpDelete)
	return &BillingRecordDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *BillingRecordClient) DeleteOne(br *BillingRecord) *BillingRecordDeleteOne {
	return c.DeleteOneID(br.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *BillingRecordClient) DeleteOneID(id string) *BillingRecordDeleteOne {
	builder := c.Delete().Where(billingrecord.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &BillingRecordDeleteOne{builder}
}

// Query returns a query builder for BillingRecord.
func (c *BillingRecordClient) Query() *BillingRecordQuery {
	return &BillingRecordQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeBillingRecord},
		inters: c.Interceptors(),
	}
}

// Get returns a BillingRecord entity by its id.
func (c *BillingRecordClient) Get(ctx context.Context, id string) (*BillingRecord, error) {
	return c.Query().Where(billingrecord.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *BillingRecordClient) GetX(ctx context.Context, id string) *BillingRecord {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *BillingRecordClient) Hooks() []Hook {
	return c.hooks.BillingRecord
}

// Interceptors returns the client interceptors.
func (c *BillingRecordClient) Interceptors() []Interceptor {
	return c.inters.BillingRecord
}

func (c *BillingRecordClient) mutate(ctx context.Context, m *BillingRecordMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&BillingRecordCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&BillingRecordUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&BillingRecordUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&BillingRecordDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown BillingRecord mutation op: %q", m.Op())
	}
}

// BillingUsageClient is a client for the BillingUsage schema.
type BillingUsageClient struct {
	config
}

// NewBillingUsageClient returns a client for the BillingUsage from the given config.
func NewBillingUsageClient(c config) *BillingUsageClient {
	return &BillingUsageClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `billingusage.Hooks(f(g(h())))`.
func (c *BillingUsageClient) Use(hooks ...Hook) {
	c.hooks.BillingUsage = append(c.hooks.BillingUsage, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `billingusage.Intercept(f(g(h())))`.
func (c *BillingUsageClient) Intercept(interceptors ...Interceptor) {
	c.inters.BillingUsage = append(c.inters.BillingUsage, interceptors...)
}

// Create returns a builder for creating a BillingUsage entity.
func (c *BillingUsageClient) Create() *BillingUsageCreate {
	mutation := newBillingUsageMutation(c.config, OpCreate)
	return &BillingUsageCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of BillingUsage entities.
func (c *BillingUsageClient) CreateBulk(builders ...*BillingUsageCreate) *BillingUsageCreateBulk {
	return &BillingUsageCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *BillingUsageClient) MapCreateBulk(slice any, setFunc func(*BillingUsageCreate, int)) *BillingUsageCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &BillingUsageCreateBulk{err: fmt.Errorf("calling to BillingUsageClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*BillingUsageCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &BillingUsageCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for BillingUsage.
func (c *BillingUsageClient) Update() *BillingUsageUpdate {
	mutation := newBillingUsageMutation(c.config, OpUpdate)
	return &BillingUsageUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *BillingUsageClient) UpdateOne(bu *BillingUsage) *BillingUsageUpdateOne {
	mutation := newBillingUsageMutation(c.config, OpUpdateOne, withBillingUsage(bu))
	return &BillingUsageUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *BillingUsageClient) UpdateOneID(id string) *BillingUsageUpdateOne {
	mutation := newBillingUsageMutation(c.config, OpUpdateOne, withBillingUsageID(id))
	return &BillingUsageUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for BillingUsage.
func (c *BillingUsageClient) Delete() *BillingUsageDelete {
	mutation := newBillingUsageMutation(c.config, OpDelete)
	return &BillingUsageDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *BillingUsageClient) DeleteOne(bu *BillingUsage) *BillingUsageDeleteOne {
	return c.DeleteOneID(bu.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *BillingUsageClient) DeleteOneID(id string) *BillingUsageDeleteOne {
	builder := c.Delete().Where(billingusage.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &BillingUsageDeleteOne{builder}
}

// Query returns a query builder for BillingUsage.
func (c *BillingUsageClient) Query() *BillingUsageQuery {
	return &BillingUsageQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeBillingUsage},
		inters: c.Interceptors(),
	}
}

// Get returns a BillingUsage entity by its id.
func (c *BillingUsageClient) Get(ctx context.Context, id string) (*BillingUsage, error) {
	return c.Query().Where(billingusage.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *BillingUsageClient) GetX(ctx context.Context, id string) *BillingUsage {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *BillingUsageClient) Hooks() []Hook {
	hooks := c.hooks.BillingUsage
	return append(hooks[:len(hooks):len(hooks)], billingusage.Hooks[:]...)
}

// Interceptors returns the client interceptors.
func (c *BillingUsageClient) Interceptors() []Interceptor {
	inters := c.inters.BillingUsage
	return append(inters[:len(inters):len(inters)], billingusage.Interceptors[:]...)
}

func (c *BillingUsageClient) mutate(ctx context.Context, m *BillingUsageMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&BillingUsageCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&BillingUsageUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&BillingUsageUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&BillingUsageDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown BillingUsage mutation op: %q", m.Op())
	}
}

// CodeSnippetClient is a client for the CodeSnippet schema.
type CodeSnippetClient struct {
	config
}

// NewCodeSnippetClient returns a client for the CodeSnippet from the given config.
func NewCodeSnippetClient(c config) *CodeSnippetClient {
	return &CodeSnippetClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `codesnippet.Hooks(f(g(h())))`.
func (c *CodeSnippetClient) Use(hooks ...Hook) {
	c.hooks.CodeSnippet = append(c.hooks.CodeSnippet, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `codesnippet.Intercept(f(g(h())))`.
func (c *CodeSnippetClient) Intercept(interceptors ...Interceptor) {
	c.inters.CodeSnippet = append(c.inters.CodeSnippet, interceptors...)
}

// Create returns a builder for creating a CodeSnippet entity.
func (c *CodeSnippetClient) Create() *CodeSnippetCreate {
	mutation := newCodeSnippetMutation(c.config, OpCreate)
	return &CodeSnippetCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of CodeSnippet entities.
func (c *CodeSnippetClient) CreateBulk(builders ...*CodeSnippetCreate) *CodeSnippetCreateBulk {
	return &CodeSnippetCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *CodeSnippetClient) MapCreateBulk(slice any, setFunc func(*CodeSnippetCreate, int)) *CodeSnippetCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &CodeSnippetCreateBulk{err: fmt.Errorf("calling to CodeSnippetClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*CodeSnippetCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &CodeSnippetCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for CodeSnippet.
func (c *CodeSnippetClient) Update() *CodeSnippetUpdate {
	mutation := newCodeSnippetMutation(c.config, OpUpdate)
	return &CodeSnippetUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *CodeSnippetClient) UpdateOne(cs *CodeSnippet) *CodeSnippetUpdateOne {
	mutation := newCodeSnippetMutation(c.config, OpUpdateOne, withCodeSnippet(cs))
	return &CodeSnippetUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *CodeSnippetClient) UpdateOneID(id uuid.UUID) *CodeSnippetUpdateOne {
	mutation := newCodeSnippetMutation(c.config, OpUpdateOne, withCodeSnippetID(id))
	return &CodeSnippetUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for CodeSnippet.
func (c *CodeSnippetClient) Delete() *CodeSnippetDelete {
	mutation := newCodeSnippetMutation(c.config, OpDelete)
	return &CodeSnippetDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *CodeSnippetClient) DeleteOne(cs *CodeSnippet) *CodeSnippetDeleteOne {
	return c.DeleteOneID(cs.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *CodeSnippetClient) DeleteOneID(id uuid.UUID) *CodeSnippetDeleteOne {
	builder := c.Delete().Where(codesnippet.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &CodeSnippetDeleteOne{builder}
}

// Query returns a query builder for CodeSnippet.
func (c *CodeSnippetClient) Query() *CodeSnippetQuery {
	return &CodeSnippetQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeCodeSnippet},
		inters: c.Interceptors(),
	}
}

// Get returns a CodeSnippet entity by its id.
func (c *CodeSnippetClient) Get(ctx context.Context, id uuid.UUID) (*CodeSnippet, error) {
	return c.Query().Where(codesnippet.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *CodeSnippetClient) GetX(ctx context.Context, id uuid.UUID) *CodeSnippet {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QuerySourceFile queries the source_file edge of a CodeSnippet.
func (c *CodeSnippetClient) QuerySourceFile(cs *CodeSnippet) *WorkspaceFileQuery {
	query := (&WorkspaceFileClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := cs.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(codesnippet.Table, codesnippet.FieldID, id),
			sqlgraph.To(workspacefile.Table, workspacefile.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, codesnippet.SourceFileTable, codesnippet.SourceFileColumn),
		)
		fromV = sqlgraph.Neighbors(cs.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *CodeSnippetClient) Hooks() []Hook {
	return c.hooks.CodeSnippet
}

// Interceptors returns the client interceptors.
func (c *CodeSnippetClient) Interceptors() []Interceptor {
	return c.inters.CodeSnippet
}

func (c *CodeSnippetClient) mutate(ctx context.Context, m *CodeSnippetMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&CodeSnippetCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&CodeSnippetUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&CodeSnippetUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&CodeSnippetDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown CodeSnippet mutation op: %q", m.Op())
	}
}

// ExtensionClient is a client for the Extension schema.
type ExtensionClient struct {
	config
}

// NewExtensionClient returns a client for the Extension from the given config.
func NewExtensionClient(c config) *ExtensionClient {
	return &ExtensionClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `extension.Hooks(f(g(h())))`.
func (c *ExtensionClient) Use(hooks ...Hook) {
	c.hooks.Extension = append(c.hooks.Extension, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `extension.Intercept(f(g(h())))`.
func (c *ExtensionClient) Intercept(interceptors ...Interceptor) {
	c.inters.Extension = append(c.inters.Extension, interceptors...)
}

// Create returns a builder for creating a Extension entity.
func (c *ExtensionClient) Create() *ExtensionCreate {
	mutation := newExtensionMutation(c.config, OpCreate)
	return &ExtensionCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Extension entities.
func (c *ExtensionClient) CreateBulk(builders ...*ExtensionCreate) *ExtensionCreateBulk {
	return &ExtensionCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *ExtensionClient) MapCreateBulk(slice any, setFunc func(*ExtensionCreate, int)) *ExtensionCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &ExtensionCreateBulk{err: fmt.Errorf("calling to ExtensionClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*ExtensionCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &ExtensionCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Extension.
func (c *ExtensionClient) Update() *ExtensionUpdate {
	mutation := newExtensionMutation(c.config, OpUpdate)
	return &ExtensionUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *ExtensionClient) UpdateOne(e *Extension) *ExtensionUpdateOne {
	mutation := newExtensionMutation(c.config, OpUpdateOne, withExtension(e))
	return &ExtensionUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *ExtensionClient) UpdateOneID(id uuid.UUID) *ExtensionUpdateOne {
	mutation := newExtensionMutation(c.config, OpUpdateOne, withExtensionID(id))
	return &ExtensionUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Extension.
func (c *ExtensionClient) Delete() *ExtensionDelete {
	mutation := newExtensionMutation(c.config, OpDelete)
	return &ExtensionDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *ExtensionClient) DeleteOne(e *Extension) *ExtensionDeleteOne {
	return c.DeleteOneID(e.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *ExtensionClient) DeleteOneID(id uuid.UUID) *ExtensionDeleteOne {
	builder := c.Delete().Where(extension.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &ExtensionDeleteOne{builder}
}

// Query returns a query builder for Extension.
func (c *ExtensionClient) Query() *ExtensionQuery {
	return &ExtensionQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeExtension},
		inters: c.Interceptors(),
	}
}

// Get returns a Extension entity by its id.
func (c *ExtensionClient) Get(ctx context.Context, id uuid.UUID) (*Extension, error) {
	return c.Query().Where(extension.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *ExtensionClient) GetX(ctx context.Context, id uuid.UUID) *Extension {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *ExtensionClient) Hooks() []Hook {
	return c.hooks.Extension
}

// Interceptors returns the client interceptors.
func (c *ExtensionClient) Interceptors() []Interceptor {
	return c.inters.Extension
}

func (c *ExtensionClient) mutate(ctx context.Context, m *ExtensionMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&ExtensionCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&ExtensionUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&ExtensionUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&ExtensionDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown Extension mutation op: %q", m.Op())
	}
}

// InviteCodeClient is a client for the InviteCode schema.
type InviteCodeClient struct {
	config
}

// NewInviteCodeClient returns a client for the InviteCode from the given config.
func NewInviteCodeClient(c config) *InviteCodeClient {
	return &InviteCodeClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `invitecode.Hooks(f(g(h())))`.
func (c *InviteCodeClient) Use(hooks ...Hook) {
	c.hooks.InviteCode = append(c.hooks.InviteCode, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `invitecode.Intercept(f(g(h())))`.
func (c *InviteCodeClient) Intercept(interceptors ...Interceptor) {
	c.inters.InviteCode = append(c.inters.InviteCode, interceptors...)
}

// Create returns a builder for creating a InviteCode entity.
func (c *InviteCodeClient) Create() *InviteCodeCreate {
	mutation := newInviteCodeMutation(c.config, OpCreate)
	return &InviteCodeCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of InviteCode entities.
func (c *InviteCodeClient) CreateBulk(builders ...*InviteCodeCreate) *InviteCodeCreateBulk {
	return &InviteCodeCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *InviteCodeClient) MapCreateBulk(slice any, setFunc func(*InviteCodeCreate, int)) *InviteCodeCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &InviteCodeCreateBulk{err: fmt.Errorf("calling to InviteCodeClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*InviteCodeCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &InviteCodeCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for InviteCode.
func (c *InviteCodeClient) Update() *InviteCodeUpdate {
	mutation := newInviteCodeMutation(c.config, OpUpdate)
	return &InviteCodeUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *InviteCodeClient) UpdateOne(ic *InviteCode) *InviteCodeUpdateOne {
	mutation := newInviteCodeMutation(c.config, OpUpdateOne, withInviteCode(ic))
	return &InviteCodeUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *InviteCodeClient) UpdateOneID(id uuid.UUID) *InviteCodeUpdateOne {
	mutation := newInviteCodeMutation(c.config, OpUpdateOne, withInviteCodeID(id))
	return &InviteCodeUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for InviteCode.
func (c *InviteCodeClient) Delete() *InviteCodeDelete {
	mutation := newInviteCodeMutation(c.config, OpDelete)
	return &InviteCodeDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *InviteCodeClient) DeleteOne(ic *InviteCode) *InviteCodeDeleteOne {
	return c.DeleteOneID(ic.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *InviteCodeClient) DeleteOneID(id uuid.UUID) *InviteCodeDeleteOne {
	builder := c.Delete().Where(invitecode.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &InviteCodeDeleteOne{builder}
}

// Query returns a query builder for InviteCode.
func (c *InviteCodeClient) Query() *InviteCodeQuery {
	return &InviteCodeQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeInviteCode},
		inters: c.Interceptors(),
	}
}

// Get returns a InviteCode entity by its id.
func (c *InviteCodeClient) Get(ctx context.Context, id uuid.UUID) (*InviteCode, error) {
	return c.Query().Where(invitecode.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *InviteCodeClient) GetX(ctx context.Context, id uuid.UUID) *InviteCode {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *InviteCodeClient) Hooks() []Hook {
	return c.hooks.InviteCode
}

// Interceptors returns the client interceptors.
func (c *InviteCodeClient) Interceptors() []Interceptor {
	return c.inters.InviteCode
}

func (c *InviteCodeClient) mutate(ctx context.Context, m *InviteCodeMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&InviteCodeCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&InviteCodeUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&InviteCodeUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&InviteCodeDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown InviteCode mutation op: %q", m.Op())
	}
}

// LicenseClient is a client for the License schema.
type LicenseClient struct {
	config
}

// NewLicenseClient returns a client for the License from the given config.
func NewLicenseClient(c config) *LicenseClient {
	return &LicenseClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `license.Hooks(f(g(h())))`.
func (c *LicenseClient) Use(hooks ...Hook) {
	c.hooks.License = append(c.hooks.License, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `license.Intercept(f(g(h())))`.
func (c *LicenseClient) Intercept(interceptors ...Interceptor) {
	c.inters.License = append(c.inters.License, interceptors...)
}

// Create returns a builder for creating a License entity.
func (c *LicenseClient) Create() *LicenseCreate {
	mutation := newLicenseMutation(c.config, OpCreate)
	return &LicenseCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of License entities.
func (c *LicenseClient) CreateBulk(builders ...*LicenseCreate) *LicenseCreateBulk {
	return &LicenseCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *LicenseClient) MapCreateBulk(slice any, setFunc func(*LicenseCreate, int)) *LicenseCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &LicenseCreateBulk{err: fmt.Errorf("calling to LicenseClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*LicenseCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &LicenseCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for License.
func (c *LicenseClient) Update() *LicenseUpdate {
	mutation := newLicenseMutation(c.config, OpUpdate)
	return &LicenseUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *LicenseClient) UpdateOne(l *License) *LicenseUpdateOne {
	mutation := newLicenseMutation(c.config, OpUpdateOne, withLicense(l))
	return &LicenseUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *LicenseClient) UpdateOneID(id int) *LicenseUpdateOne {
	mutation := newLicenseMutation(c.config, OpUpdateOne, withLicenseID(id))
	return &LicenseUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for License.
func (c *LicenseClient) Delete() *LicenseDelete {
	mutation := newLicenseMutation(c.config, OpDelete)
	return &LicenseDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *LicenseClient) DeleteOne(l *License) *LicenseDeleteOne {
	return c.DeleteOneID(l.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *LicenseClient) DeleteOneID(id int) *LicenseDeleteOne {
	builder := c.Delete().Where(license.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &LicenseDeleteOne{builder}
}

// Query returns a query builder for License.
func (c *LicenseClient) Query() *LicenseQuery {
	return &LicenseQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeLicense},
		inters: c.Interceptors(),
	}
}

// Get returns a License entity by its id.
func (c *LicenseClient) Get(ctx context.Context, id int) (*License, error) {
	return c.Query().Where(license.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *LicenseClient) GetX(ctx context.Context, id int) *License {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *LicenseClient) Hooks() []Hook {
	return c.hooks.License
}

// Interceptors returns the client interceptors.
func (c *LicenseClient) Interceptors() []Interceptor {
	return c.inters.License
}

func (c *LicenseClient) mutate(ctx context.Context, m *LicenseMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&LicenseCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&LicenseUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&LicenseUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&LicenseDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown License mutation op: %q", m.Op())
	}
}

// ModelClient is a client for the Model schema.
type ModelClient struct {
	config
}

// NewModelClient returns a client for the Model from the given config.
func NewModelClient(c config) *ModelClient {
	return &ModelClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `model.Hooks(f(g(h())))`.
func (c *ModelClient) Use(hooks ...Hook) {
	c.hooks.Model = append(c.hooks.Model, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `model.Intercept(f(g(h())))`.
func (c *ModelClient) Intercept(interceptors ...Interceptor) {
	c.inters.Model = append(c.inters.Model, interceptors...)
}

// Create returns a builder for creating a Model entity.
func (c *ModelClient) Create() *ModelCreate {
	mutation := newModelMutation(c.config, OpCreate)
	return &ModelCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Model entities.
func (c *ModelClient) CreateBulk(builders ...*ModelCreate) *ModelCreateBulk {
	return &ModelCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *ModelClient) MapCreateBulk(slice any, setFunc func(*ModelCreate, int)) *ModelCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &ModelCreateBulk{err: fmt.Errorf("calling to ModelClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*ModelCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &ModelCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Model.
func (c *ModelClient) Update() *ModelUpdate {
	mutation := newModelMutation(c.config, OpUpdate)
	return &ModelUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *ModelClient) UpdateOne(m *Model) *ModelUpdateOne {
	mutation := newModelMutation(c.config, OpUpdateOne, withModel(m))
	return &ModelUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *ModelClient) UpdateOneID(id uuid.UUID) *ModelUpdateOne {
	mutation := newModelMutation(c.config, OpUpdateOne, withModelID(id))
	return &ModelUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Model.
func (c *ModelClient) Delete() *ModelDelete {
	mutation := newModelMutation(c.config, OpDelete)
	return &ModelDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *ModelClient) DeleteOne(m *Model) *ModelDeleteOne {
	return c.DeleteOneID(m.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *ModelClient) DeleteOneID(id uuid.UUID) *ModelDeleteOne {
	builder := c.Delete().Where(model.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &ModelDeleteOne{builder}
}

// Query returns a query builder for Model.
func (c *ModelClient) Query() *ModelQuery {
	return &ModelQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeModel},
		inters: c.Interceptors(),
	}
}

// Get returns a Model entity by its id.
func (c *ModelClient) Get(ctx context.Context, id uuid.UUID) (*Model, error) {
	return c.Query().Where(model.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *ModelClient) GetX(ctx context.Context, id uuid.UUID) *Model {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryTasks queries the tasks edge of a Model.
func (c *ModelClient) QueryTasks(m *Model) *TaskQuery {
	query := (&TaskClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := m.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(model.Table, model.FieldID, id),
			sqlgraph.To(task.Table, task.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, model.TasksTable, model.TasksColumn),
		)
		fromV = sqlgraph.Neighbors(m.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryUser queries the user edge of a Model.
func (c *ModelClient) QueryUser(m *Model) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := m.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(model.Table, model.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, model.UserTable, model.UserColumn),
		)
		fromV = sqlgraph.Neighbors(m.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *ModelClient) Hooks() []Hook {
	return c.hooks.Model
}

// Interceptors returns the client interceptors.
func (c *ModelClient) Interceptors() []Interceptor {
	return c.inters.Model
}

func (c *ModelClient) mutate(ctx context.Context, m *ModelMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&ModelCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&ModelUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&ModelUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&ModelDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown Model mutation op: %q", m.Op())
	}
}

// ModelProviderClient is a client for the ModelProvider schema.
type ModelProviderClient struct {
	config
}

// NewModelProviderClient returns a client for the ModelProvider from the given config.
func NewModelProviderClient(c config) *ModelProviderClient {
	return &ModelProviderClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `modelprovider.Hooks(f(g(h())))`.
func (c *ModelProviderClient) Use(hooks ...Hook) {
	c.hooks.ModelProvider = append(c.hooks.ModelProvider, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `modelprovider.Intercept(f(g(h())))`.
func (c *ModelProviderClient) Intercept(interceptors ...Interceptor) {
	c.inters.ModelProvider = append(c.inters.ModelProvider, interceptors...)
}

// Create returns a builder for creating a ModelProvider entity.
func (c *ModelProviderClient) Create() *ModelProviderCreate {
	mutation := newModelProviderMutation(c.config, OpCreate)
	return &ModelProviderCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of ModelProvider entities.
func (c *ModelProviderClient) CreateBulk(builders ...*ModelProviderCreate) *ModelProviderCreateBulk {
	return &ModelProviderCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *ModelProviderClient) MapCreateBulk(slice any, setFunc func(*ModelProviderCreate, int)) *ModelProviderCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &ModelProviderCreateBulk{err: fmt.Errorf("calling to ModelProviderClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*ModelProviderCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &ModelProviderCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for ModelProvider.
func (c *ModelProviderClient) Update() *ModelProviderUpdate {
	mutation := newModelProviderMutation(c.config, OpUpdate)
	return &ModelProviderUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *ModelProviderClient) UpdateOne(mp *ModelProvider) *ModelProviderUpdateOne {
	mutation := newModelProviderMutation(c.config, OpUpdateOne, withModelProvider(mp))
	return &ModelProviderUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *ModelProviderClient) UpdateOneID(id string) *ModelProviderUpdateOne {
	mutation := newModelProviderMutation(c.config, OpUpdateOne, withModelProviderID(id))
	return &ModelProviderUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for ModelProvider.
func (c *ModelProviderClient) Delete() *ModelProviderDelete {
	mutation := newModelProviderMutation(c.config, OpDelete)
	return &ModelProviderDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *ModelProviderClient) DeleteOne(mp *ModelProvider) *ModelProviderDeleteOne {
	return c.DeleteOneID(mp.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *ModelProviderClient) DeleteOneID(id string) *ModelProviderDeleteOne {
	builder := c.Delete().Where(modelprovider.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &ModelProviderDeleteOne{builder}
}

// Query returns a query builder for ModelProvider.
func (c *ModelProviderClient) Query() *ModelProviderQuery {
	return &ModelProviderQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeModelProvider},
		inters: c.Interceptors(),
	}
}

// Get returns a ModelProvider entity by its id.
func (c *ModelProviderClient) Get(ctx context.Context, id string) (*ModelProvider, error) {
	return c.Query().Where(modelprovider.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *ModelProviderClient) GetX(ctx context.Context, id string) *ModelProvider {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryModels queries the models edge of a ModelProvider.
func (c *ModelProviderClient) QueryModels(mp *ModelProvider) *ModelProviderModelQuery {
	query := (&ModelProviderModelClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := mp.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(modelprovider.Table, modelprovider.FieldID, id),
			sqlgraph.To(modelprovidermodel.Table, modelprovidermodel.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, modelprovider.ModelsTable, modelprovider.ModelsColumn),
		)
		fromV = sqlgraph.Neighbors(mp.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *ModelProviderClient) Hooks() []Hook {
	return c.hooks.ModelProvider
}

// Interceptors returns the client interceptors.
func (c *ModelProviderClient) Interceptors() []Interceptor {
	return c.inters.ModelProvider
}

func (c *ModelProviderClient) mutate(ctx context.Context, m *ModelProviderMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&ModelProviderCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&ModelProviderUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&ModelProviderUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&ModelProviderDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown ModelProvider mutation op: %q", m.Op())
	}
}

// ModelProviderModelClient is a client for the ModelProviderModel schema.
type ModelProviderModelClient struct {
	config
}

// NewModelProviderModelClient returns a client for the ModelProviderModel from the given config.
func NewModelProviderModelClient(c config) *ModelProviderModelClient {
	return &ModelProviderModelClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `modelprovidermodel.Hooks(f(g(h())))`.
func (c *ModelProviderModelClient) Use(hooks ...Hook) {
	c.hooks.ModelProviderModel = append(c.hooks.ModelProviderModel, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `modelprovidermodel.Intercept(f(g(h())))`.
func (c *ModelProviderModelClient) Intercept(interceptors ...Interceptor) {
	c.inters.ModelProviderModel = append(c.inters.ModelProviderModel, interceptors...)
}

// Create returns a builder for creating a ModelProviderModel entity.
func (c *ModelProviderModelClient) Create() *ModelProviderModelCreate {
	mutation := newModelProviderModelMutation(c.config, OpCreate)
	return &ModelProviderModelCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of ModelProviderModel entities.
func (c *ModelProviderModelClient) CreateBulk(builders ...*ModelProviderModelCreate) *ModelProviderModelCreateBulk {
	return &ModelProviderModelCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *ModelProviderModelClient) MapCreateBulk(slice any, setFunc func(*ModelProviderModelCreate, int)) *ModelProviderModelCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &ModelProviderModelCreateBulk{err: fmt.Errorf("calling to ModelProviderModelClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*ModelProviderModelCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &ModelProviderModelCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for ModelProviderModel.
func (c *ModelProviderModelClient) Update() *ModelProviderModelUpdate {
	mutation := newModelProviderModelMutation(c.config, OpUpdate)
	return &ModelProviderModelUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *ModelProviderModelClient) UpdateOne(mpm *ModelProviderModel) *ModelProviderModelUpdateOne {
	mutation := newModelProviderModelMutation(c.config, OpUpdateOne, withModelProviderModel(mpm))
	return &ModelProviderModelUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *ModelProviderModelClient) UpdateOneID(id uuid.UUID) *ModelProviderModelUpdateOne {
	mutation := newModelProviderModelMutation(c.config, OpUpdateOne, withModelProviderModelID(id))
	return &ModelProviderModelUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for ModelProviderModel.
func (c *ModelProviderModelClient) Delete() *ModelProviderModelDelete {
	mutation := newModelProviderModelMutation(c.config, OpDelete)
	return &ModelProviderModelDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *ModelProviderModelClient) DeleteOne(mpm *ModelProviderModel) *ModelProviderModelDeleteOne {
	return c.DeleteOneID(mpm.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *ModelProviderModelClient) DeleteOneID(id uuid.UUID) *ModelProviderModelDeleteOne {
	builder := c.Delete().Where(modelprovidermodel.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &ModelProviderModelDeleteOne{builder}
}

// Query returns a query builder for ModelProviderModel.
func (c *ModelProviderModelClient) Query() *ModelProviderModelQuery {
	return &ModelProviderModelQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeModelProviderModel},
		inters: c.Interceptors(),
	}
}

// Get returns a ModelProviderModel entity by its id.
func (c *ModelProviderModelClient) Get(ctx context.Context, id uuid.UUID) (*ModelProviderModel, error) {
	return c.Query().Where(modelprovidermodel.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *ModelProviderModelClient) GetX(ctx context.Context, id uuid.UUID) *ModelProviderModel {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryProvider queries the provider edge of a ModelProviderModel.
func (c *ModelProviderModelClient) QueryProvider(mpm *ModelProviderModel) *ModelProviderQuery {
	query := (&ModelProviderClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := mpm.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(modelprovidermodel.Table, modelprovidermodel.FieldID, id),
			sqlgraph.To(modelprovider.Table, modelprovider.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, modelprovidermodel.ProviderTable, modelprovidermodel.ProviderColumn),
		)
		fromV = sqlgraph.Neighbors(mpm.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *ModelProviderModelClient) Hooks() []Hook {
	return c.hooks.ModelProviderModel
}

// Interceptors returns the client interceptors.
func (c *ModelProviderModelClient) Interceptors() []Interceptor {
	return c.inters.ModelProviderModel
}

func (c *ModelProviderModelClient) mutate(ctx context.Context, m *ModelProviderModelMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&ModelProviderModelCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&ModelProviderModelUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&ModelProviderModelUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&ModelProviderModelDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown ModelProviderModel mutation op: %q", m.Op())
	}
}

// RoleClient is a client for the Role schema.
type RoleClient struct {
	config
}

// NewRoleClient returns a client for the Role from the given config.
func NewRoleClient(c config) *RoleClient {
	return &RoleClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `role.Hooks(f(g(h())))`.
func (c *RoleClient) Use(hooks ...Hook) {
	c.hooks.Role = append(c.hooks.Role, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `role.Intercept(f(g(h())))`.
func (c *RoleClient) Intercept(interceptors ...Interceptor) {
	c.inters.Role = append(c.inters.Role, interceptors...)
}

// Create returns a builder for creating a Role entity.
func (c *RoleClient) Create() *RoleCreate {
	mutation := newRoleMutation(c.config, OpCreate)
	return &RoleCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Role entities.
func (c *RoleClient) CreateBulk(builders ...*RoleCreate) *RoleCreateBulk {
	return &RoleCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *RoleClient) MapCreateBulk(slice any, setFunc func(*RoleCreate, int)) *RoleCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &RoleCreateBulk{err: fmt.Errorf("calling to RoleClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*RoleCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &RoleCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Role.
func (c *RoleClient) Update() *RoleUpdate {
	mutation := newRoleMutation(c.config, OpUpdate)
	return &RoleUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *RoleClient) UpdateOne(r *Role) *RoleUpdateOne {
	mutation := newRoleMutation(c.config, OpUpdateOne, withRole(r))
	return &RoleUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *RoleClient) UpdateOneID(id int64) *RoleUpdateOne {
	mutation := newRoleMutation(c.config, OpUpdateOne, withRoleID(id))
	return &RoleUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Role.
func (c *RoleClient) Delete() *RoleDelete {
	mutation := newRoleMutation(c.config, OpDelete)
	return &RoleDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *RoleClient) DeleteOne(r *Role) *RoleDeleteOne {
	return c.DeleteOneID(r.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *RoleClient) DeleteOneID(id int64) *RoleDeleteOne {
	builder := c.Delete().Where(role.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &RoleDeleteOne{builder}
}

// Query returns a query builder for Role.
func (c *RoleClient) Query() *RoleQuery {
	return &RoleQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeRole},
		inters: c.Interceptors(),
	}
}

// Get returns a Role entity by its id.
func (c *RoleClient) Get(ctx context.Context, id int64) (*Role, error) {
	return c.Query().Where(role.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *RoleClient) GetX(ctx context.Context, id int64) *Role {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryAdmins queries the admins edge of a Role.
func (c *RoleClient) QueryAdmins(r *Role) *AdminQuery {
	query := (&AdminClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := r.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(role.Table, role.FieldID, id),
			sqlgraph.To(admin.Table, admin.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, role.AdminsTable, role.AdminsPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(r.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryAdminRoles queries the admin_roles edge of a Role.
func (c *RoleClient) QueryAdminRoles(r *Role) *AdminRoleQuery {
	query := (&AdminRoleClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := r.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(role.Table, role.FieldID, id),
			sqlgraph.To(adminrole.Table, adminrole.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, role.AdminRolesTable, role.AdminRolesColumn),
		)
		fromV = sqlgraph.Neighbors(r.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *RoleClient) Hooks() []Hook {
	return c.hooks.Role
}

// Interceptors returns the client interceptors.
func (c *RoleClient) Interceptors() []Interceptor {
	return c.inters.Role
}

func (c *RoleClient) mutate(ctx context.Context, m *RoleMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&RoleCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&RoleUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&RoleUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&RoleDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown Role mutation op: %q", m.Op())
	}
}

// SecurityScanningClient is a client for the SecurityScanning schema.
type SecurityScanningClient struct {
	config
}

// NewSecurityScanningClient returns a client for the SecurityScanning from the given config.
func NewSecurityScanningClient(c config) *SecurityScanningClient {
	return &SecurityScanningClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `securityscanning.Hooks(f(g(h())))`.
func (c *SecurityScanningClient) Use(hooks ...Hook) {
	c.hooks.SecurityScanning = append(c.hooks.SecurityScanning, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `securityscanning.Intercept(f(g(h())))`.
func (c *SecurityScanningClient) Intercept(interceptors ...Interceptor) {
	c.inters.SecurityScanning = append(c.inters.SecurityScanning, interceptors...)
}

// Create returns a builder for creating a SecurityScanning entity.
func (c *SecurityScanningClient) Create() *SecurityScanningCreate {
	mutation := newSecurityScanningMutation(c.config, OpCreate)
	return &SecurityScanningCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of SecurityScanning entities.
func (c *SecurityScanningClient) CreateBulk(builders ...*SecurityScanningCreate) *SecurityScanningCreateBulk {
	return &SecurityScanningCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *SecurityScanningClient) MapCreateBulk(slice any, setFunc func(*SecurityScanningCreate, int)) *SecurityScanningCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &SecurityScanningCreateBulk{err: fmt.Errorf("calling to SecurityScanningClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*SecurityScanningCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &SecurityScanningCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for SecurityScanning.
func (c *SecurityScanningClient) Update() *SecurityScanningUpdate {
	mutation := newSecurityScanningMutation(c.config, OpUpdate)
	return &SecurityScanningUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *SecurityScanningClient) UpdateOne(ss *SecurityScanning) *SecurityScanningUpdateOne {
	mutation := newSecurityScanningMutation(c.config, OpUpdateOne, withSecurityScanning(ss))
	return &SecurityScanningUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *SecurityScanningClient) UpdateOneID(id uuid.UUID) *SecurityScanningUpdateOne {
	mutation := newSecurityScanningMutation(c.config, OpUpdateOne, withSecurityScanningID(id))
	return &SecurityScanningUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for SecurityScanning.
func (c *SecurityScanningClient) Delete() *SecurityScanningDelete {
	mutation := newSecurityScanningMutation(c.config, OpDelete)
	return &SecurityScanningDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *SecurityScanningClient) DeleteOne(ss *SecurityScanning) *SecurityScanningDeleteOne {
	return c.DeleteOneID(ss.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *SecurityScanningClient) DeleteOneID(id uuid.UUID) *SecurityScanningDeleteOne {
	builder := c.Delete().Where(securityscanning.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &SecurityScanningDeleteOne{builder}
}

// Query returns a query builder for SecurityScanning.
func (c *SecurityScanningClient) Query() *SecurityScanningQuery {
	return &SecurityScanningQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeSecurityScanning},
		inters: c.Interceptors(),
	}
}

// Get returns a SecurityScanning entity by its id.
func (c *SecurityScanningClient) Get(ctx context.Context, id uuid.UUID) (*SecurityScanning, error) {
	return c.Query().Where(securityscanning.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *SecurityScanningClient) GetX(ctx context.Context, id uuid.UUID) *SecurityScanning {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryUser queries the user edge of a SecurityScanning.
func (c *SecurityScanningClient) QueryUser(ss *SecurityScanning) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ss.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(securityscanning.Table, securityscanning.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, securityscanning.UserTable, securityscanning.UserColumn),
		)
		fromV = sqlgraph.Neighbors(ss.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryResults queries the results edge of a SecurityScanning.
func (c *SecurityScanningClient) QueryResults(ss *SecurityScanning) *SecurityScanningResultQuery {
	query := (&SecurityScanningResultClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ss.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(securityscanning.Table, securityscanning.FieldID, id),
			sqlgraph.To(securityscanningresult.Table, securityscanningresult.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, securityscanning.ResultsTable, securityscanning.ResultsColumn),
		)
		fromV = sqlgraph.Neighbors(ss.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryWorkspaceEdge queries the workspace_edge edge of a SecurityScanning.
func (c *SecurityScanningClient) QueryWorkspaceEdge(ss *SecurityScanning) *WorkspaceQuery {
	query := (&WorkspaceClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ss.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(securityscanning.Table, securityscanning.FieldID, id),
			sqlgraph.To(workspace.Table, workspace.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, securityscanning.WorkspaceEdgeTable, securityscanning.WorkspaceEdgeColumn),
		)
		fromV = sqlgraph.Neighbors(ss.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *SecurityScanningClient) Hooks() []Hook {
	return c.hooks.SecurityScanning
}

// Interceptors returns the client interceptors.
func (c *SecurityScanningClient) Interceptors() []Interceptor {
	return c.inters.SecurityScanning
}

func (c *SecurityScanningClient) mutate(ctx context.Context, m *SecurityScanningMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&SecurityScanningCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&SecurityScanningUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&SecurityScanningUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&SecurityScanningDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown SecurityScanning mutation op: %q", m.Op())
	}
}

// SecurityScanningResultClient is a client for the SecurityScanningResult schema.
type SecurityScanningResultClient struct {
	config
}

// NewSecurityScanningResultClient returns a client for the SecurityScanningResult from the given config.
func NewSecurityScanningResultClient(c config) *SecurityScanningResultClient {
	return &SecurityScanningResultClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `securityscanningresult.Hooks(f(g(h())))`.
func (c *SecurityScanningResultClient) Use(hooks ...Hook) {
	c.hooks.SecurityScanningResult = append(c.hooks.SecurityScanningResult, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `securityscanningresult.Intercept(f(g(h())))`.
func (c *SecurityScanningResultClient) Intercept(interceptors ...Interceptor) {
	c.inters.SecurityScanningResult = append(c.inters.SecurityScanningResult, interceptors...)
}

// Create returns a builder for creating a SecurityScanningResult entity.
func (c *SecurityScanningResultClient) Create() *SecurityScanningResultCreate {
	mutation := newSecurityScanningResultMutation(c.config, OpCreate)
	return &SecurityScanningResultCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of SecurityScanningResult entities.
func (c *SecurityScanningResultClient) CreateBulk(builders ...*SecurityScanningResultCreate) *SecurityScanningResultCreateBulk {
	return &SecurityScanningResultCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *SecurityScanningResultClient) MapCreateBulk(slice any, setFunc func(*SecurityScanningResultCreate, int)) *SecurityScanningResultCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &SecurityScanningResultCreateBulk{err: fmt.Errorf("calling to SecurityScanningResultClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*SecurityScanningResultCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &SecurityScanningResultCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for SecurityScanningResult.
func (c *SecurityScanningResultClient) Update() *SecurityScanningResultUpdate {
	mutation := newSecurityScanningResultMutation(c.config, OpUpdate)
	return &SecurityScanningResultUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *SecurityScanningResultClient) UpdateOne(ssr *SecurityScanningResult) *SecurityScanningResultUpdateOne {
	mutation := newSecurityScanningResultMutation(c.config, OpUpdateOne, withSecurityScanningResult(ssr))
	return &SecurityScanningResultUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *SecurityScanningResultClient) UpdateOneID(id uuid.UUID) *SecurityScanningResultUpdateOne {
	mutation := newSecurityScanningResultMutation(c.config, OpUpdateOne, withSecurityScanningResultID(id))
	return &SecurityScanningResultUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for SecurityScanningResult.
func (c *SecurityScanningResultClient) Delete() *SecurityScanningResultDelete {
	mutation := newSecurityScanningResultMutation(c.config, OpDelete)
	return &SecurityScanningResultDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *SecurityScanningResultClient) DeleteOne(ssr *SecurityScanningResult) *SecurityScanningResultDeleteOne {
	return c.DeleteOneID(ssr.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *SecurityScanningResultClient) DeleteOneID(id uuid.UUID) *SecurityScanningResultDeleteOne {
	builder := c.Delete().Where(securityscanningresult.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &SecurityScanningResultDeleteOne{builder}
}

// Query returns a query builder for SecurityScanningResult.
func (c *SecurityScanningResultClient) Query() *SecurityScanningResultQuery {
	return &SecurityScanningResultQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeSecurityScanningResult},
		inters: c.Interceptors(),
	}
}

// Get returns a SecurityScanningResult entity by its id.
func (c *SecurityScanningResultClient) Get(ctx context.Context, id uuid.UUID) (*SecurityScanningResult, error) {
	return c.Query().Where(securityscanningresult.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *SecurityScanningResultClient) GetX(ctx context.Context, id uuid.UUID) *SecurityScanningResult {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QuerySecurityScanning queries the security_scanning edge of a SecurityScanningResult.
func (c *SecurityScanningResultClient) QuerySecurityScanning(ssr *SecurityScanningResult) *SecurityScanningQuery {
	query := (&SecurityScanningClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ssr.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(securityscanningresult.Table, securityscanningresult.FieldID, id),
			sqlgraph.To(securityscanning.Table, securityscanning.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, securityscanningresult.SecurityScanningTable, securityscanningresult.SecurityScanningColumn),
		)
		fromV = sqlgraph.Neighbors(ssr.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *SecurityScanningResultClient) Hooks() []Hook {
	return c.hooks.SecurityScanningResult
}

// Interceptors returns the client interceptors.
func (c *SecurityScanningResultClient) Interceptors() []Interceptor {
	return c.inters.SecurityScanningResult
}

func (c *SecurityScanningResultClient) mutate(ctx context.Context, m *SecurityScanningResultMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&SecurityScanningResultCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&SecurityScanningResultUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&SecurityScanningResultUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&SecurityScanningResultDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown SecurityScanningResult mutation op: %q", m.Op())
	}
}

// SettingClient is a client for the Setting schema.
type SettingClient struct {
	config
}

// NewSettingClient returns a client for the Setting from the given config.
func NewSettingClient(c config) *SettingClient {
	return &SettingClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `setting.Hooks(f(g(h())))`.
func (c *SettingClient) Use(hooks ...Hook) {
	c.hooks.Setting = append(c.hooks.Setting, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `setting.Intercept(f(g(h())))`.
func (c *SettingClient) Intercept(interceptors ...Interceptor) {
	c.inters.Setting = append(c.inters.Setting, interceptors...)
}

// Create returns a builder for creating a Setting entity.
func (c *SettingClient) Create() *SettingCreate {
	mutation := newSettingMutation(c.config, OpCreate)
	return &SettingCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Setting entities.
func (c *SettingClient) CreateBulk(builders ...*SettingCreate) *SettingCreateBulk {
	return &SettingCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *SettingClient) MapCreateBulk(slice any, setFunc func(*SettingCreate, int)) *SettingCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &SettingCreateBulk{err: fmt.Errorf("calling to SettingClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*SettingCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &SettingCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Setting.
func (c *SettingClient) Update() *SettingUpdate {
	mutation := newSettingMutation(c.config, OpUpdate)
	return &SettingUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *SettingClient) UpdateOne(s *Setting) *SettingUpdateOne {
	mutation := newSettingMutation(c.config, OpUpdateOne, withSetting(s))
	return &SettingUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *SettingClient) UpdateOneID(id uuid.UUID) *SettingUpdateOne {
	mutation := newSettingMutation(c.config, OpUpdateOne, withSettingID(id))
	return &SettingUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Setting.
func (c *SettingClient) Delete() *SettingDelete {
	mutation := newSettingMutation(c.config, OpDelete)
	return &SettingDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *SettingClient) DeleteOne(s *Setting) *SettingDeleteOne {
	return c.DeleteOneID(s.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *SettingClient) DeleteOneID(id uuid.UUID) *SettingDeleteOne {
	builder := c.Delete().Where(setting.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &SettingDeleteOne{builder}
}

// Query returns a query builder for Setting.
func (c *SettingClient) Query() *SettingQuery {
	return &SettingQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeSetting},
		inters: c.Interceptors(),
	}
}

// Get returns a Setting entity by its id.
func (c *SettingClient) Get(ctx context.Context, id uuid.UUID) (*Setting, error) {
	return c.Query().Where(setting.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *SettingClient) GetX(ctx context.Context, id uuid.UUID) *Setting {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *SettingClient) Hooks() []Hook {
	return c.hooks.Setting
}

// Interceptors returns the client interceptors.
func (c *SettingClient) Interceptors() []Interceptor {
	return c.inters.Setting
}

func (c *SettingClient) mutate(ctx context.Context, m *SettingMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&SettingCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&SettingUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&SettingUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&SettingDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown Setting mutation op: %q", m.Op())
	}
}

// TaskClient is a client for the Task schema.
type TaskClient struct {
	config
}

// NewTaskClient returns a client for the Task from the given config.
func NewTaskClient(c config) *TaskClient {
	return &TaskClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `task.Hooks(f(g(h())))`.
func (c *TaskClient) Use(hooks ...Hook) {
	c.hooks.Task = append(c.hooks.Task, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `task.Intercept(f(g(h())))`.
func (c *TaskClient) Intercept(interceptors ...Interceptor) {
	c.inters.Task = append(c.inters.Task, interceptors...)
}

// Create returns a builder for creating a Task entity.
func (c *TaskClient) Create() *TaskCreate {
	mutation := newTaskMutation(c.config, OpCreate)
	return &TaskCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Task entities.
func (c *TaskClient) CreateBulk(builders ...*TaskCreate) *TaskCreateBulk {
	return &TaskCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *TaskClient) MapCreateBulk(slice any, setFunc func(*TaskCreate, int)) *TaskCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &TaskCreateBulk{err: fmt.Errorf("calling to TaskClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*TaskCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &TaskCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Task.
func (c *TaskClient) Update() *TaskUpdate {
	mutation := newTaskMutation(c.config, OpUpdate)
	return &TaskUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *TaskClient) UpdateOne(t *Task) *TaskUpdateOne {
	mutation := newTaskMutation(c.config, OpUpdateOne, withTask(t))
	return &TaskUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *TaskClient) UpdateOneID(id uuid.UUID) *TaskUpdateOne {
	mutation := newTaskMutation(c.config, OpUpdateOne, withTaskID(id))
	return &TaskUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Task.
func (c *TaskClient) Delete() *TaskDelete {
	mutation := newTaskMutation(c.config, OpDelete)
	return &TaskDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *TaskClient) DeleteOne(t *Task) *TaskDeleteOne {
	return c.DeleteOneID(t.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *TaskClient) DeleteOneID(id uuid.UUID) *TaskDeleteOne {
	builder := c.Delete().Where(task.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &TaskDeleteOne{builder}
}

// Query returns a query builder for Task.
func (c *TaskClient) Query() *TaskQuery {
	return &TaskQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeTask},
		inters: c.Interceptors(),
	}
}

// Get returns a Task entity by its id.
func (c *TaskClient) Get(ctx context.Context, id uuid.UUID) (*Task, error) {
	return c.Query().Where(task.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *TaskClient) GetX(ctx context.Context, id uuid.UUID) *Task {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryTaskRecords queries the task_records edge of a Task.
func (c *TaskClient) QueryTaskRecords(t *Task) *TaskRecordQuery {
	query := (&TaskRecordClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := t.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(task.Table, task.FieldID, id),
			sqlgraph.To(taskrecord.Table, taskrecord.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, task.TaskRecordsTable, task.TaskRecordsColumn),
		)
		fromV = sqlgraph.Neighbors(t.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryUser queries the user edge of a Task.
func (c *TaskClient) QueryUser(t *Task) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := t.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(task.Table, task.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, task.UserTable, task.UserColumn),
		)
		fromV = sqlgraph.Neighbors(t.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryModel queries the model edge of a Task.
func (c *TaskClient) QueryModel(t *Task) *ModelQuery {
	query := (&ModelClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := t.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(task.Table, task.FieldID, id),
			sqlgraph.To(model.Table, model.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, task.ModelTable, task.ModelColumn),
		)
		fromV = sqlgraph.Neighbors(t.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *TaskClient) Hooks() []Hook {
	return c.hooks.Task
}

// Interceptors returns the client interceptors.
func (c *TaskClient) Interceptors() []Interceptor {
	return c.inters.Task
}

func (c *TaskClient) mutate(ctx context.Context, m *TaskMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&TaskCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&TaskUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&TaskUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&TaskDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown Task mutation op: %q", m.Op())
	}
}

// TaskRecordClient is a client for the TaskRecord schema.
type TaskRecordClient struct {
	config
}

// NewTaskRecordClient returns a client for the TaskRecord from the given config.
func NewTaskRecordClient(c config) *TaskRecordClient {
	return &TaskRecordClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `taskrecord.Hooks(f(g(h())))`.
func (c *TaskRecordClient) Use(hooks ...Hook) {
	c.hooks.TaskRecord = append(c.hooks.TaskRecord, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `taskrecord.Intercept(f(g(h())))`.
func (c *TaskRecordClient) Intercept(interceptors ...Interceptor) {
	c.inters.TaskRecord = append(c.inters.TaskRecord, interceptors...)
}

// Create returns a builder for creating a TaskRecord entity.
func (c *TaskRecordClient) Create() *TaskRecordCreate {
	mutation := newTaskRecordMutation(c.config, OpCreate)
	return &TaskRecordCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of TaskRecord entities.
func (c *TaskRecordClient) CreateBulk(builders ...*TaskRecordCreate) *TaskRecordCreateBulk {
	return &TaskRecordCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *TaskRecordClient) MapCreateBulk(slice any, setFunc func(*TaskRecordCreate, int)) *TaskRecordCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &TaskRecordCreateBulk{err: fmt.Errorf("calling to TaskRecordClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*TaskRecordCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &TaskRecordCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for TaskRecord.
func (c *TaskRecordClient) Update() *TaskRecordUpdate {
	mutation := newTaskRecordMutation(c.config, OpUpdate)
	return &TaskRecordUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *TaskRecordClient) UpdateOne(tr *TaskRecord) *TaskRecordUpdateOne {
	mutation := newTaskRecordMutation(c.config, OpUpdateOne, withTaskRecord(tr))
	return &TaskRecordUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *TaskRecordClient) UpdateOneID(id uuid.UUID) *TaskRecordUpdateOne {
	mutation := newTaskRecordMutation(c.config, OpUpdateOne, withTaskRecordID(id))
	return &TaskRecordUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for TaskRecord.
func (c *TaskRecordClient) Delete() *TaskRecordDelete {
	mutation := newTaskRecordMutation(c.config, OpDelete)
	return &TaskRecordDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *TaskRecordClient) DeleteOne(tr *TaskRecord) *TaskRecordDeleteOne {
	return c.DeleteOneID(tr.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *TaskRecordClient) DeleteOneID(id uuid.UUID) *TaskRecordDeleteOne {
	builder := c.Delete().Where(taskrecord.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &TaskRecordDeleteOne{builder}
}

// Query returns a query builder for TaskRecord.
func (c *TaskRecordClient) Query() *TaskRecordQuery {
	return &TaskRecordQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeTaskRecord},
		inters: c.Interceptors(),
	}
}

// Get returns a TaskRecord entity by its id.
func (c *TaskRecordClient) Get(ctx context.Context, id uuid.UUID) (*TaskRecord, error) {
	return c.Query().Where(taskrecord.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *TaskRecordClient) GetX(ctx context.Context, id uuid.UUID) *TaskRecord {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryTask queries the task edge of a TaskRecord.
func (c *TaskRecordClient) QueryTask(tr *TaskRecord) *TaskQuery {
	query := (&TaskClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := tr.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(taskrecord.Table, taskrecord.FieldID, id),
			sqlgraph.To(task.Table, task.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, taskrecord.TaskTable, taskrecord.TaskColumn),
		)
		fromV = sqlgraph.Neighbors(tr.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *TaskRecordClient) Hooks() []Hook {
	return c.hooks.TaskRecord
}

// Interceptors returns the client interceptors.
func (c *TaskRecordClient) Interceptors() []Interceptor {
	return c.inters.TaskRecord
}

func (c *TaskRecordClient) mutate(ctx context.Context, m *TaskRecordMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&TaskRecordCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&TaskRecordUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&TaskRecordUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&TaskRecordDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown TaskRecord mutation op: %q", m.Op())
	}
}

// UserClient is a client for the User schema.
type UserClient struct {
	config
}

// NewUserClient returns a client for the User from the given config.
func NewUserClient(c config) *UserClient {
	return &UserClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `user.Hooks(f(g(h())))`.
func (c *UserClient) Use(hooks ...Hook) {
	c.hooks.User = append(c.hooks.User, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `user.Intercept(f(g(h())))`.
func (c *UserClient) Intercept(interceptors ...Interceptor) {
	c.inters.User = append(c.inters.User, interceptors...)
}

// Create returns a builder for creating a User entity.
func (c *UserClient) Create() *UserCreate {
	mutation := newUserMutation(c.config, OpCreate)
	return &UserCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of User entities.
func (c *UserClient) CreateBulk(builders ...*UserCreate) *UserCreateBulk {
	return &UserCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *UserClient) MapCreateBulk(slice any, setFunc func(*UserCreate, int)) *UserCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &UserCreateBulk{err: fmt.Errorf("calling to UserClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*UserCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &UserCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for User.
func (c *UserClient) Update() *UserUpdate {
	mutation := newUserMutation(c.config, OpUpdate)
	return &UserUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *UserClient) UpdateOne(u *User) *UserUpdateOne {
	mutation := newUserMutation(c.config, OpUpdateOne, withUser(u))
	return &UserUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *UserClient) UpdateOneID(id uuid.UUID) *UserUpdateOne {
	mutation := newUserMutation(c.config, OpUpdateOne, withUserID(id))
	return &UserUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for User.
func (c *UserClient) Delete() *UserDelete {
	mutation := newUserMutation(c.config, OpDelete)
	return &UserDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *UserClient) DeleteOne(u *User) *UserDeleteOne {
	return c.DeleteOneID(u.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *UserClient) DeleteOneID(id uuid.UUID) *UserDeleteOne {
	builder := c.Delete().Where(user.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &UserDeleteOne{builder}
}

// Query returns a query builder for User.
func (c *UserClient) Query() *UserQuery {
	return &UserQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeUser},
		inters: c.Interceptors(),
	}
}

// Get returns a User entity by its id.
func (c *UserClient) Get(ctx context.Context, id uuid.UUID) (*User, error) {
	return c.Query().Where(user.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *UserClient) GetX(ctx context.Context, id uuid.UUID) *User {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryLoginHistories queries the login_histories edge of a User.
func (c *UserClient) QueryLoginHistories(u *User) *UserLoginHistoryQuery {
	query := (&UserLoginHistoryClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(userloginhistory.Table, userloginhistory.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, user.LoginHistoriesTable, user.LoginHistoriesColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryModels queries the models edge of a User.
func (c *UserClient) QueryModels(u *User) *ModelQuery {
	query := (&ModelClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(model.Table, model.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, user.ModelsTable, user.ModelsColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryTasks queries the tasks edge of a User.
func (c *UserClient) QueryTasks(u *User) *TaskQuery {
	query := (&TaskClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(task.Table, task.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, user.TasksTable, user.TasksColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryIdentities queries the identities edge of a User.
func (c *UserClient) QueryIdentities(u *User) *UserIdentityQuery {
	query := (&UserIdentityClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(useridentity.Table, useridentity.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, user.IdentitiesTable, user.IdentitiesColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryWorkspaces queries the workspaces edge of a User.
func (c *UserClient) QueryWorkspaces(u *User) *WorkspaceQuery {
	query := (&WorkspaceClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(workspace.Table, workspace.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, user.WorkspacesTable, user.WorkspacesColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryWorkspaceFiles queries the workspace_files edge of a User.
func (c *UserClient) QueryWorkspaceFiles(u *User) *WorkspaceFileQuery {
	query := (&WorkspaceFileClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(workspacefile.Table, workspacefile.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, user.WorkspaceFilesTable, user.WorkspaceFilesColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryAPIKeys queries the api_keys edge of a User.
func (c *UserClient) QueryAPIKeys(u *User) *ApiKeyQuery {
	query := (&ApiKeyClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(apikey.Table, apikey.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, user.APIKeysTable, user.APIKeysColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QuerySecurityScannings queries the security_scannings edge of a User.
func (c *UserClient) QuerySecurityScannings(u *User) *SecurityScanningQuery {
	query := (&SecurityScanningClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(securityscanning.Table, securityscanning.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, user.SecurityScanningsTable, user.SecurityScanningsColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryAiemployees queries the aiemployees edge of a User.
func (c *UserClient) QueryAiemployees(u *User) *AIEmployeeQuery {
	query := (&AIEmployeeClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(aiemployee.Table, aiemployee.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, user.AiemployeesTable, user.AiemployeesColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryGroups queries the groups edge of a User.
func (c *UserClient) QueryGroups(u *User) *UserGroupQuery {
	query := (&UserGroupClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(usergroup.Table, usergroup.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, true, user.GroupsTable, user.GroupsPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryUserGroups queries the user_groups edge of a User.
func (c *UserClient) QueryUserGroups(u *User) *UserGroupUserQuery {
	query := (&UserGroupUserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(usergroupuser.Table, usergroupuser.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, user.UserGroupsTable, user.UserGroupsColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *UserClient) Hooks() []Hook {
	hooks := c.hooks.User
	return append(hooks[:len(hooks):len(hooks)], user.Hooks[:]...)
}

// Interceptors returns the client interceptors.
func (c *UserClient) Interceptors() []Interceptor {
	inters := c.inters.User
	return append(inters[:len(inters):len(inters)], user.Interceptors[:]...)
}

func (c *UserClient) mutate(ctx context.Context, m *UserMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&UserCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&UserUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&UserUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&UserDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown User mutation op: %q", m.Op())
	}
}

// UserGroupClient is a client for the UserGroup schema.
type UserGroupClient struct {
	config
}

// NewUserGroupClient returns a client for the UserGroup from the given config.
func NewUserGroupClient(c config) *UserGroupClient {
	return &UserGroupClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `usergroup.Hooks(f(g(h())))`.
func (c *UserGroupClient) Use(hooks ...Hook) {
	c.hooks.UserGroup = append(c.hooks.UserGroup, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `usergroup.Intercept(f(g(h())))`.
func (c *UserGroupClient) Intercept(interceptors ...Interceptor) {
	c.inters.UserGroup = append(c.inters.UserGroup, interceptors...)
}

// Create returns a builder for creating a UserGroup entity.
func (c *UserGroupClient) Create() *UserGroupCreate {
	mutation := newUserGroupMutation(c.config, OpCreate)
	return &UserGroupCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of UserGroup entities.
func (c *UserGroupClient) CreateBulk(builders ...*UserGroupCreate) *UserGroupCreateBulk {
	return &UserGroupCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *UserGroupClient) MapCreateBulk(slice any, setFunc func(*UserGroupCreate, int)) *UserGroupCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &UserGroupCreateBulk{err: fmt.Errorf("calling to UserGroupClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*UserGroupCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &UserGroupCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for UserGroup.
func (c *UserGroupClient) Update() *UserGroupUpdate {
	mutation := newUserGroupMutation(c.config, OpUpdate)
	return &UserGroupUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *UserGroupClient) UpdateOne(ug *UserGroup) *UserGroupUpdateOne {
	mutation := newUserGroupMutation(c.config, OpUpdateOne, withUserGroup(ug))
	return &UserGroupUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *UserGroupClient) UpdateOneID(id uuid.UUID) *UserGroupUpdateOne {
	mutation := newUserGroupMutation(c.config, OpUpdateOne, withUserGroupID(id))
	return &UserGroupUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for UserGroup.
func (c *UserGroupClient) Delete() *UserGroupDelete {
	mutation := newUserGroupMutation(c.config, OpDelete)
	return &UserGroupDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *UserGroupClient) DeleteOne(ug *UserGroup) *UserGroupDeleteOne {
	return c.DeleteOneID(ug.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *UserGroupClient) DeleteOneID(id uuid.UUID) *UserGroupDeleteOne {
	builder := c.Delete().Where(usergroup.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &UserGroupDeleteOne{builder}
}

// Query returns a query builder for UserGroup.
func (c *UserGroupClient) Query() *UserGroupQuery {
	return &UserGroupQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeUserGroup},
		inters: c.Interceptors(),
	}
}

// Get returns a UserGroup entity by its id.
func (c *UserGroupClient) Get(ctx context.Context, id uuid.UUID) (*UserGroup, error) {
	return c.Query().Where(usergroup.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *UserGroupClient) GetX(ctx context.Context, id uuid.UUID) *UserGroup {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryOwner queries the owner edge of a UserGroup.
func (c *UserGroupClient) QueryOwner(ug *UserGroup) *AdminQuery {
	query := (&AdminClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ug.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(usergroup.Table, usergroup.FieldID, id),
			sqlgraph.To(admin.Table, admin.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, usergroup.OwnerTable, usergroup.OwnerColumn),
		)
		fromV = sqlgraph.Neighbors(ug.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryUsers queries the users edge of a UserGroup.
func (c *UserGroupClient) QueryUsers(ug *UserGroup) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ug.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(usergroup.Table, usergroup.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, usergroup.UsersTable, usergroup.UsersPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(ug.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryAdmins queries the admins edge of a UserGroup.
func (c *UserGroupClient) QueryAdmins(ug *UserGroup) *AdminQuery {
	query := (&AdminClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ug.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(usergroup.Table, usergroup.FieldID, id),
			sqlgraph.To(admin.Table, admin.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, usergroup.AdminsTable, usergroup.AdminsPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(ug.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryUserGroups queries the user_groups edge of a UserGroup.
func (c *UserGroupClient) QueryUserGroups(ug *UserGroup) *UserGroupUserQuery {
	query := (&UserGroupUserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ug.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(usergroup.Table, usergroup.FieldID, id),
			sqlgraph.To(usergroupuser.Table, usergroupuser.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, usergroup.UserGroupsTable, usergroup.UserGroupsColumn),
		)
		fromV = sqlgraph.Neighbors(ug.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryUserGroupAdmins queries the user_group_admins edge of a UserGroup.
func (c *UserGroupClient) QueryUserGroupAdmins(ug *UserGroup) *UserGroupAdminQuery {
	query := (&UserGroupAdminClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ug.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(usergroup.Table, usergroup.FieldID, id),
			sqlgraph.To(usergroupadmin.Table, usergroupadmin.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, usergroup.UserGroupAdminsTable, usergroup.UserGroupAdminsColumn),
		)
		fromV = sqlgraph.Neighbors(ug.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *UserGroupClient) Hooks() []Hook {
	return c.hooks.UserGroup
}

// Interceptors returns the client interceptors.
func (c *UserGroupClient) Interceptors() []Interceptor {
	return c.inters.UserGroup
}

func (c *UserGroupClient) mutate(ctx context.Context, m *UserGroupMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&UserGroupCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&UserGroupUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&UserGroupUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&UserGroupDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown UserGroup mutation op: %q", m.Op())
	}
}

// UserGroupAdminClient is a client for the UserGroupAdmin schema.
type UserGroupAdminClient struct {
	config
}

// NewUserGroupAdminClient returns a client for the UserGroupAdmin from the given config.
func NewUserGroupAdminClient(c config) *UserGroupAdminClient {
	return &UserGroupAdminClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `usergroupadmin.Hooks(f(g(h())))`.
func (c *UserGroupAdminClient) Use(hooks ...Hook) {
	c.hooks.UserGroupAdmin = append(c.hooks.UserGroupAdmin, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `usergroupadmin.Intercept(f(g(h())))`.
func (c *UserGroupAdminClient) Intercept(interceptors ...Interceptor) {
	c.inters.UserGroupAdmin = append(c.inters.UserGroupAdmin, interceptors...)
}

// Create returns a builder for creating a UserGroupAdmin entity.
func (c *UserGroupAdminClient) Create() *UserGroupAdminCreate {
	mutation := newUserGroupAdminMutation(c.config, OpCreate)
	return &UserGroupAdminCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of UserGroupAdmin entities.
func (c *UserGroupAdminClient) CreateBulk(builders ...*UserGroupAdminCreate) *UserGroupAdminCreateBulk {
	return &UserGroupAdminCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *UserGroupAdminClient) MapCreateBulk(slice any, setFunc func(*UserGroupAdminCreate, int)) *UserGroupAdminCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &UserGroupAdminCreateBulk{err: fmt.Errorf("calling to UserGroupAdminClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*UserGroupAdminCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &UserGroupAdminCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for UserGroupAdmin.
func (c *UserGroupAdminClient) Update() *UserGroupAdminUpdate {
	mutation := newUserGroupAdminMutation(c.config, OpUpdate)
	return &UserGroupAdminUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *UserGroupAdminClient) UpdateOne(uga *UserGroupAdmin) *UserGroupAdminUpdateOne {
	mutation := newUserGroupAdminMutation(c.config, OpUpdateOne, withUserGroupAdmin(uga))
	return &UserGroupAdminUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *UserGroupAdminClient) UpdateOneID(id uuid.UUID) *UserGroupAdminUpdateOne {
	mutation := newUserGroupAdminMutation(c.config, OpUpdateOne, withUserGroupAdminID(id))
	return &UserGroupAdminUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for UserGroupAdmin.
func (c *UserGroupAdminClient) Delete() *UserGroupAdminDelete {
	mutation := newUserGroupAdminMutation(c.config, OpDelete)
	return &UserGroupAdminDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *UserGroupAdminClient) DeleteOne(uga *UserGroupAdmin) *UserGroupAdminDeleteOne {
	return c.DeleteOneID(uga.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *UserGroupAdminClient) DeleteOneID(id uuid.UUID) *UserGroupAdminDeleteOne {
	builder := c.Delete().Where(usergroupadmin.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &UserGroupAdminDeleteOne{builder}
}

// Query returns a query builder for UserGroupAdmin.
func (c *UserGroupAdminClient) Query() *UserGroupAdminQuery {
	return &UserGroupAdminQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeUserGroupAdmin},
		inters: c.Interceptors(),
	}
}

// Get returns a UserGroupAdmin entity by its id.
func (c *UserGroupAdminClient) Get(ctx context.Context, id uuid.UUID) (*UserGroupAdmin, error) {
	return c.Query().Where(usergroupadmin.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *UserGroupAdminClient) GetX(ctx context.Context, id uuid.UUID) *UserGroupAdmin {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryUserGroup queries the user_group edge of a UserGroupAdmin.
func (c *UserGroupAdminClient) QueryUserGroup(uga *UserGroupAdmin) *UserGroupQuery {
	query := (&UserGroupClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := uga.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(usergroupadmin.Table, usergroupadmin.FieldID, id),
			sqlgraph.To(usergroup.Table, usergroup.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, usergroupadmin.UserGroupTable, usergroupadmin.UserGroupColumn),
		)
		fromV = sqlgraph.Neighbors(uga.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryAdmin queries the admin edge of a UserGroupAdmin.
func (c *UserGroupAdminClient) QueryAdmin(uga *UserGroupAdmin) *AdminQuery {
	query := (&AdminClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := uga.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(usergroupadmin.Table, usergroupadmin.FieldID, id),
			sqlgraph.To(admin.Table, admin.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, usergroupadmin.AdminTable, usergroupadmin.AdminColumn),
		)
		fromV = sqlgraph.Neighbors(uga.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *UserGroupAdminClient) Hooks() []Hook {
	return c.hooks.UserGroupAdmin
}

// Interceptors returns the client interceptors.
func (c *UserGroupAdminClient) Interceptors() []Interceptor {
	return c.inters.UserGroupAdmin
}

func (c *UserGroupAdminClient) mutate(ctx context.Context, m *UserGroupAdminMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&UserGroupAdminCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&UserGroupAdminUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&UserGroupAdminUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&UserGroupAdminDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown UserGroupAdmin mutation op: %q", m.Op())
	}
}

// UserGroupUserClient is a client for the UserGroupUser schema.
type UserGroupUserClient struct {
	config
}

// NewUserGroupUserClient returns a client for the UserGroupUser from the given config.
func NewUserGroupUserClient(c config) *UserGroupUserClient {
	return &UserGroupUserClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `usergroupuser.Hooks(f(g(h())))`.
func (c *UserGroupUserClient) Use(hooks ...Hook) {
	c.hooks.UserGroupUser = append(c.hooks.UserGroupUser, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `usergroupuser.Intercept(f(g(h())))`.
func (c *UserGroupUserClient) Intercept(interceptors ...Interceptor) {
	c.inters.UserGroupUser = append(c.inters.UserGroupUser, interceptors...)
}

// Create returns a builder for creating a UserGroupUser entity.
func (c *UserGroupUserClient) Create() *UserGroupUserCreate {
	mutation := newUserGroupUserMutation(c.config, OpCreate)
	return &UserGroupUserCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of UserGroupUser entities.
func (c *UserGroupUserClient) CreateBulk(builders ...*UserGroupUserCreate) *UserGroupUserCreateBulk {
	return &UserGroupUserCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *UserGroupUserClient) MapCreateBulk(slice any, setFunc func(*UserGroupUserCreate, int)) *UserGroupUserCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &UserGroupUserCreateBulk{err: fmt.Errorf("calling to UserGroupUserClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*UserGroupUserCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &UserGroupUserCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for UserGroupUser.
func (c *UserGroupUserClient) Update() *UserGroupUserUpdate {
	mutation := newUserGroupUserMutation(c.config, OpUpdate)
	return &UserGroupUserUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *UserGroupUserClient) UpdateOne(ugu *UserGroupUser) *UserGroupUserUpdateOne {
	mutation := newUserGroupUserMutation(c.config, OpUpdateOne, withUserGroupUser(ugu))
	return &UserGroupUserUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *UserGroupUserClient) UpdateOneID(id uuid.UUID) *UserGroupUserUpdateOne {
	mutation := newUserGroupUserMutation(c.config, OpUpdateOne, withUserGroupUserID(id))
	return &UserGroupUserUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for UserGroupUser.
func (c *UserGroupUserClient) Delete() *UserGroupUserDelete {
	mutation := newUserGroupUserMutation(c.config, OpDelete)
	return &UserGroupUserDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *UserGroupUserClient) DeleteOne(ugu *UserGroupUser) *UserGroupUserDeleteOne {
	return c.DeleteOneID(ugu.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *UserGroupUserClient) DeleteOneID(id uuid.UUID) *UserGroupUserDeleteOne {
	builder := c.Delete().Where(usergroupuser.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &UserGroupUserDeleteOne{builder}
}

// Query returns a query builder for UserGroupUser.
func (c *UserGroupUserClient) Query() *UserGroupUserQuery {
	return &UserGroupUserQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeUserGroupUser},
		inters: c.Interceptors(),
	}
}

// Get returns a UserGroupUser entity by its id.
func (c *UserGroupUserClient) Get(ctx context.Context, id uuid.UUID) (*UserGroupUser, error) {
	return c.Query().Where(usergroupuser.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *UserGroupUserClient) GetX(ctx context.Context, id uuid.UUID) *UserGroupUser {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryUserGroup queries the user_group edge of a UserGroupUser.
func (c *UserGroupUserClient) QueryUserGroup(ugu *UserGroupUser) *UserGroupQuery {
	query := (&UserGroupClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ugu.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(usergroupuser.Table, usergroupuser.FieldID, id),
			sqlgraph.To(usergroup.Table, usergroup.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, usergroupuser.UserGroupTable, usergroupuser.UserGroupColumn),
		)
		fromV = sqlgraph.Neighbors(ugu.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryUser queries the user edge of a UserGroupUser.
func (c *UserGroupUserClient) QueryUser(ugu *UserGroupUser) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ugu.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(usergroupuser.Table, usergroupuser.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, usergroupuser.UserTable, usergroupuser.UserColumn),
		)
		fromV = sqlgraph.Neighbors(ugu.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *UserGroupUserClient) Hooks() []Hook {
	return c.hooks.UserGroupUser
}

// Interceptors returns the client interceptors.
func (c *UserGroupUserClient) Interceptors() []Interceptor {
	return c.inters.UserGroupUser
}

func (c *UserGroupUserClient) mutate(ctx context.Context, m *UserGroupUserMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&UserGroupUserCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&UserGroupUserUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&UserGroupUserUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&UserGroupUserDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown UserGroupUser mutation op: %q", m.Op())
	}
}

// UserIdentityClient is a client for the UserIdentity schema.
type UserIdentityClient struct {
	config
}

// NewUserIdentityClient returns a client for the UserIdentity from the given config.
func NewUserIdentityClient(c config) *UserIdentityClient {
	return &UserIdentityClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `useridentity.Hooks(f(g(h())))`.
func (c *UserIdentityClient) Use(hooks ...Hook) {
	c.hooks.UserIdentity = append(c.hooks.UserIdentity, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `useridentity.Intercept(f(g(h())))`.
func (c *UserIdentityClient) Intercept(interceptors ...Interceptor) {
	c.inters.UserIdentity = append(c.inters.UserIdentity, interceptors...)
}

// Create returns a builder for creating a UserIdentity entity.
func (c *UserIdentityClient) Create() *UserIdentityCreate {
	mutation := newUserIdentityMutation(c.config, OpCreate)
	return &UserIdentityCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of UserIdentity entities.
func (c *UserIdentityClient) CreateBulk(builders ...*UserIdentityCreate) *UserIdentityCreateBulk {
	return &UserIdentityCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *UserIdentityClient) MapCreateBulk(slice any, setFunc func(*UserIdentityCreate, int)) *UserIdentityCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &UserIdentityCreateBulk{err: fmt.Errorf("calling to UserIdentityClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*UserIdentityCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &UserIdentityCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for UserIdentity.
func (c *UserIdentityClient) Update() *UserIdentityUpdate {
	mutation := newUserIdentityMutation(c.config, OpUpdate)
	return &UserIdentityUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *UserIdentityClient) UpdateOne(ui *UserIdentity) *UserIdentityUpdateOne {
	mutation := newUserIdentityMutation(c.config, OpUpdateOne, withUserIdentity(ui))
	return &UserIdentityUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *UserIdentityClient) UpdateOneID(id uuid.UUID) *UserIdentityUpdateOne {
	mutation := newUserIdentityMutation(c.config, OpUpdateOne, withUserIdentityID(id))
	return &UserIdentityUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for UserIdentity.
func (c *UserIdentityClient) Delete() *UserIdentityDelete {
	mutation := newUserIdentityMutation(c.config, OpDelete)
	return &UserIdentityDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *UserIdentityClient) DeleteOne(ui *UserIdentity) *UserIdentityDeleteOne {
	return c.DeleteOneID(ui.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *UserIdentityClient) DeleteOneID(id uuid.UUID) *UserIdentityDeleteOne {
	builder := c.Delete().Where(useridentity.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &UserIdentityDeleteOne{builder}
}

// Query returns a query builder for UserIdentity.
func (c *UserIdentityClient) Query() *UserIdentityQuery {
	return &UserIdentityQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeUserIdentity},
		inters: c.Interceptors(),
	}
}

// Get returns a UserIdentity entity by its id.
func (c *UserIdentityClient) Get(ctx context.Context, id uuid.UUID) (*UserIdentity, error) {
	return c.Query().Where(useridentity.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *UserIdentityClient) GetX(ctx context.Context, id uuid.UUID) *UserIdentity {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryUser queries the user edge of a UserIdentity.
func (c *UserIdentityClient) QueryUser(ui *UserIdentity) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ui.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(useridentity.Table, useridentity.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, useridentity.UserTable, useridentity.UserColumn),
		)
		fromV = sqlgraph.Neighbors(ui.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *UserIdentityClient) Hooks() []Hook {
	hooks := c.hooks.UserIdentity
	return append(hooks[:len(hooks):len(hooks)], useridentity.Hooks[:]...)
}

// Interceptors returns the client interceptors.
func (c *UserIdentityClient) Interceptors() []Interceptor {
	inters := c.inters.UserIdentity
	return append(inters[:len(inters):len(inters)], useridentity.Interceptors[:]...)
}

func (c *UserIdentityClient) mutate(ctx context.Context, m *UserIdentityMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&UserIdentityCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&UserIdentityUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&UserIdentityUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&UserIdentityDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown UserIdentity mutation op: %q", m.Op())
	}
}

// UserLoginHistoryClient is a client for the UserLoginHistory schema.
type UserLoginHistoryClient struct {
	config
}

// NewUserLoginHistoryClient returns a client for the UserLoginHistory from the given config.
func NewUserLoginHistoryClient(c config) *UserLoginHistoryClient {
	return &UserLoginHistoryClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `userloginhistory.Hooks(f(g(h())))`.
func (c *UserLoginHistoryClient) Use(hooks ...Hook) {
	c.hooks.UserLoginHistory = append(c.hooks.UserLoginHistory, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `userloginhistory.Intercept(f(g(h())))`.
func (c *UserLoginHistoryClient) Intercept(interceptors ...Interceptor) {
	c.inters.UserLoginHistory = append(c.inters.UserLoginHistory, interceptors...)
}

// Create returns a builder for creating a UserLoginHistory entity.
func (c *UserLoginHistoryClient) Create() *UserLoginHistoryCreate {
	mutation := newUserLoginHistoryMutation(c.config, OpCreate)
	return &UserLoginHistoryCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of UserLoginHistory entities.
func (c *UserLoginHistoryClient) CreateBulk(builders ...*UserLoginHistoryCreate) *UserLoginHistoryCreateBulk {
	return &UserLoginHistoryCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *UserLoginHistoryClient) MapCreateBulk(slice any, setFunc func(*UserLoginHistoryCreate, int)) *UserLoginHistoryCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &UserLoginHistoryCreateBulk{err: fmt.Errorf("calling to UserLoginHistoryClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*UserLoginHistoryCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &UserLoginHistoryCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for UserLoginHistory.
func (c *UserLoginHistoryClient) Update() *UserLoginHistoryUpdate {
	mutation := newUserLoginHistoryMutation(c.config, OpUpdate)
	return &UserLoginHistoryUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *UserLoginHistoryClient) UpdateOne(ulh *UserLoginHistory) *UserLoginHistoryUpdateOne {
	mutation := newUserLoginHistoryMutation(c.config, OpUpdateOne, withUserLoginHistory(ulh))
	return &UserLoginHistoryUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *UserLoginHistoryClient) UpdateOneID(id uuid.UUID) *UserLoginHistoryUpdateOne {
	mutation := newUserLoginHistoryMutation(c.config, OpUpdateOne, withUserLoginHistoryID(id))
	return &UserLoginHistoryUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for UserLoginHistory.
func (c *UserLoginHistoryClient) Delete() *UserLoginHistoryDelete {
	mutation := newUserLoginHistoryMutation(c.config, OpDelete)
	return &UserLoginHistoryDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *UserLoginHistoryClient) DeleteOne(ulh *UserLoginHistory) *UserLoginHistoryDeleteOne {
	return c.DeleteOneID(ulh.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *UserLoginHistoryClient) DeleteOneID(id uuid.UUID) *UserLoginHistoryDeleteOne {
	builder := c.Delete().Where(userloginhistory.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &UserLoginHistoryDeleteOne{builder}
}

// Query returns a query builder for UserLoginHistory.
func (c *UserLoginHistoryClient) Query() *UserLoginHistoryQuery {
	return &UserLoginHistoryQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeUserLoginHistory},
		inters: c.Interceptors(),
	}
}

// Get returns a UserLoginHistory entity by its id.
func (c *UserLoginHistoryClient) Get(ctx context.Context, id uuid.UUID) (*UserLoginHistory, error) {
	return c.Query().Where(userloginhistory.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *UserLoginHistoryClient) GetX(ctx context.Context, id uuid.UUID) *UserLoginHistory {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryOwner queries the owner edge of a UserLoginHistory.
func (c *UserLoginHistoryClient) QueryOwner(ulh *UserLoginHistory) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ulh.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(userloginhistory.Table, userloginhistory.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, userloginhistory.OwnerTable, userloginhistory.OwnerColumn),
		)
		fromV = sqlgraph.Neighbors(ulh.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *UserLoginHistoryClient) Hooks() []Hook {
	return c.hooks.UserLoginHistory
}

// Interceptors returns the client interceptors.
func (c *UserLoginHistoryClient) Interceptors() []Interceptor {
	return c.inters.UserLoginHistory
}

func (c *UserLoginHistoryClient) mutate(ctx context.Context, m *UserLoginHistoryMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&UserLoginHistoryCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&UserLoginHistoryUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&UserLoginHistoryUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&UserLoginHistoryDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown UserLoginHistory mutation op: %q", m.Op())
	}
}

// WorkspaceClient is a client for the Workspace schema.
type WorkspaceClient struct {
	config
}

// NewWorkspaceClient returns a client for the Workspace from the given config.
func NewWorkspaceClient(c config) *WorkspaceClient {
	return &WorkspaceClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `workspace.Hooks(f(g(h())))`.
func (c *WorkspaceClient) Use(hooks ...Hook) {
	c.hooks.Workspace = append(c.hooks.Workspace, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `workspace.Intercept(f(g(h())))`.
func (c *WorkspaceClient) Intercept(interceptors ...Interceptor) {
	c.inters.Workspace = append(c.inters.Workspace, interceptors...)
}

// Create returns a builder for creating a Workspace entity.
func (c *WorkspaceClient) Create() *WorkspaceCreate {
	mutation := newWorkspaceMutation(c.config, OpCreate)
	return &WorkspaceCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Workspace entities.
func (c *WorkspaceClient) CreateBulk(builders ...*WorkspaceCreate) *WorkspaceCreateBulk {
	return &WorkspaceCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *WorkspaceClient) MapCreateBulk(slice any, setFunc func(*WorkspaceCreate, int)) *WorkspaceCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &WorkspaceCreateBulk{err: fmt.Errorf("calling to WorkspaceClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*WorkspaceCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &WorkspaceCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Workspace.
func (c *WorkspaceClient) Update() *WorkspaceUpdate {
	mutation := newWorkspaceMutation(c.config, OpUpdate)
	return &WorkspaceUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *WorkspaceClient) UpdateOne(w *Workspace) *WorkspaceUpdateOne {
	mutation := newWorkspaceMutation(c.config, OpUpdateOne, withWorkspace(w))
	return &WorkspaceUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *WorkspaceClient) UpdateOneID(id uuid.UUID) *WorkspaceUpdateOne {
	mutation := newWorkspaceMutation(c.config, OpUpdateOne, withWorkspaceID(id))
	return &WorkspaceUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Workspace.
func (c *WorkspaceClient) Delete() *WorkspaceDelete {
	mutation := newWorkspaceMutation(c.config, OpDelete)
	return &WorkspaceDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *WorkspaceClient) DeleteOne(w *Workspace) *WorkspaceDeleteOne {
	return c.DeleteOneID(w.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *WorkspaceClient) DeleteOneID(id uuid.UUID) *WorkspaceDeleteOne {
	builder := c.Delete().Where(workspace.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &WorkspaceDeleteOne{builder}
}

// Query returns a query builder for Workspace.
func (c *WorkspaceClient) Query() *WorkspaceQuery {
	return &WorkspaceQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeWorkspace},
		inters: c.Interceptors(),
	}
}

// Get returns a Workspace entity by its id.
func (c *WorkspaceClient) Get(ctx context.Context, id uuid.UUID) (*Workspace, error) {
	return c.Query().Where(workspace.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *WorkspaceClient) GetX(ctx context.Context, id uuid.UUID) *Workspace {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryOwner queries the owner edge of a Workspace.
func (c *WorkspaceClient) QueryOwner(w *Workspace) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := w.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(workspace.Table, workspace.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, workspace.OwnerTable, workspace.OwnerColumn),
		)
		fromV = sqlgraph.Neighbors(w.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryFiles queries the files edge of a Workspace.
func (c *WorkspaceClient) QueryFiles(w *Workspace) *WorkspaceFileQuery {
	query := (&WorkspaceFileClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := w.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(workspace.Table, workspace.FieldID, id),
			sqlgraph.To(workspacefile.Table, workspacefile.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, workspace.FilesTable, workspace.FilesColumn),
		)
		fromV = sqlgraph.Neighbors(w.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QuerySecurityScannings queries the security_scannings edge of a Workspace.
func (c *WorkspaceClient) QuerySecurityScannings(w *Workspace) *SecurityScanningQuery {
	query := (&SecurityScanningClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := w.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(workspace.Table, workspace.FieldID, id),
			sqlgraph.To(securityscanning.Table, securityscanning.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, workspace.SecurityScanningsTable, workspace.SecurityScanningsColumn),
		)
		fromV = sqlgraph.Neighbors(w.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *WorkspaceClient) Hooks() []Hook {
	return c.hooks.Workspace
}

// Interceptors returns the client interceptors.
func (c *WorkspaceClient) Interceptors() []Interceptor {
	return c.inters.Workspace
}

func (c *WorkspaceClient) mutate(ctx context.Context, m *WorkspaceMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&WorkspaceCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&WorkspaceUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&WorkspaceUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&WorkspaceDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown Workspace mutation op: %q", m.Op())
	}
}

// WorkspaceFileClient is a client for the WorkspaceFile schema.
type WorkspaceFileClient struct {
	config
}

// NewWorkspaceFileClient returns a client for the WorkspaceFile from the given config.
func NewWorkspaceFileClient(c config) *WorkspaceFileClient {
	return &WorkspaceFileClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `workspacefile.Hooks(f(g(h())))`.
func (c *WorkspaceFileClient) Use(hooks ...Hook) {
	c.hooks.WorkspaceFile = append(c.hooks.WorkspaceFile, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `workspacefile.Intercept(f(g(h())))`.
func (c *WorkspaceFileClient) Intercept(interceptors ...Interceptor) {
	c.inters.WorkspaceFile = append(c.inters.WorkspaceFile, interceptors...)
}

// Create returns a builder for creating a WorkspaceFile entity.
func (c *WorkspaceFileClient) Create() *WorkspaceFileCreate {
	mutation := newWorkspaceFileMutation(c.config, OpCreate)
	return &WorkspaceFileCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of WorkspaceFile entities.
func (c *WorkspaceFileClient) CreateBulk(builders ...*WorkspaceFileCreate) *WorkspaceFileCreateBulk {
	return &WorkspaceFileCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *WorkspaceFileClient) MapCreateBulk(slice any, setFunc func(*WorkspaceFileCreate, int)) *WorkspaceFileCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &WorkspaceFileCreateBulk{err: fmt.Errorf("calling to WorkspaceFileClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*WorkspaceFileCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &WorkspaceFileCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for WorkspaceFile.
func (c *WorkspaceFileClient) Update() *WorkspaceFileUpdate {
	mutation := newWorkspaceFileMutation(c.config, OpUpdate)
	return &WorkspaceFileUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *WorkspaceFileClient) UpdateOne(wf *WorkspaceFile) *WorkspaceFileUpdateOne {
	mutation := newWorkspaceFileMutation(c.config, OpUpdateOne, withWorkspaceFile(wf))
	return &WorkspaceFileUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *WorkspaceFileClient) UpdateOneID(id uuid.UUID) *WorkspaceFileUpdateOne {
	mutation := newWorkspaceFileMutation(c.config, OpUpdateOne, withWorkspaceFileID(id))
	return &WorkspaceFileUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for WorkspaceFile.
func (c *WorkspaceFileClient) Delete() *WorkspaceFileDelete {
	mutation := newWorkspaceFileMutation(c.config, OpDelete)
	return &WorkspaceFileDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *WorkspaceFileClient) DeleteOne(wf *WorkspaceFile) *WorkspaceFileDeleteOne {
	return c.DeleteOneID(wf.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *WorkspaceFileClient) DeleteOneID(id uuid.UUID) *WorkspaceFileDeleteOne {
	builder := c.Delete().Where(workspacefile.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &WorkspaceFileDeleteOne{builder}
}

// Query returns a query builder for WorkspaceFile.
func (c *WorkspaceFileClient) Query() *WorkspaceFileQuery {
	return &WorkspaceFileQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeWorkspaceFile},
		inters: c.Interceptors(),
	}
}

// Get returns a WorkspaceFile entity by its id.
func (c *WorkspaceFileClient) Get(ctx context.Context, id uuid.UUID) (*WorkspaceFile, error) {
	return c.Query().Where(workspacefile.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *WorkspaceFileClient) GetX(ctx context.Context, id uuid.UUID) *WorkspaceFile {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryOwner queries the owner edge of a WorkspaceFile.
func (c *WorkspaceFileClient) QueryOwner(wf *WorkspaceFile) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := wf.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(workspacefile.Table, workspacefile.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, workspacefile.OwnerTable, workspacefile.OwnerColumn),
		)
		fromV = sqlgraph.Neighbors(wf.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryWorkspace queries the workspace edge of a WorkspaceFile.
func (c *WorkspaceFileClient) QueryWorkspace(wf *WorkspaceFile) *WorkspaceQuery {
	query := (&WorkspaceClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := wf.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(workspacefile.Table, workspacefile.FieldID, id),
			sqlgraph.To(workspace.Table, workspace.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, workspacefile.WorkspaceTable, workspacefile.WorkspaceColumn),
		)
		fromV = sqlgraph.Neighbors(wf.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QuerySnippets queries the snippets edge of a WorkspaceFile.
func (c *WorkspaceFileClient) QuerySnippets(wf *WorkspaceFile) *CodeSnippetQuery {
	query := (&CodeSnippetClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := wf.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(workspacefile.Table, workspacefile.FieldID, id),
			sqlgraph.To(codesnippet.Table, codesnippet.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, workspacefile.SnippetsTable, workspacefile.SnippetsColumn),
		)
		fromV = sqlgraph.Neighbors(wf.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *WorkspaceFileClient) Hooks() []Hook {
	return c.hooks.WorkspaceFile
}

// Interceptors returns the client interceptors.
func (c *WorkspaceFileClient) Interceptors() []Interceptor {
	return c.inters.WorkspaceFile
}

func (c *WorkspaceFileClient) mutate(ctx context.Context, m *WorkspaceFileMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&WorkspaceFileCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&WorkspaceFileUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&WorkspaceFileUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&WorkspaceFileDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("db: unknown WorkspaceFile mutation op: %q", m.Op())
	}
}

// hooks and interceptors per client, for fast access.
type (
	hooks struct {
		AIEmployee, AITask, Admin, AdminLoginHistory, AdminRole, ApiKey, BillingPlan,
		BillingQuota, BillingRecord, BillingUsage, CodeSnippet, Extension, InviteCode,
		License, Model, ModelProvider, ModelProviderModel, Role, SecurityScanning,
		SecurityScanningResult, Setting, Task, TaskRecord, User, UserGroup,
		UserGroupAdmin, UserGroupUser, UserIdentity, UserLoginHistory, Workspace,
		WorkspaceFile []ent.Hook
	}
	inters struct {
		AIEmployee, AITask, Admin, AdminLoginHistory, AdminRole, ApiKey, BillingPlan,
		BillingQuota, BillingRecord, BillingUsage, CodeSnippet, Extension, InviteCode,
		License, Model, ModelProvider, ModelProviderModel, Role, SecurityScanning,
		SecurityScanningResult, Setting, Task, TaskRecord, User, UserGroup,
		UserGroupAdmin, UserGroupUser, UserIdentity, UserLoginHistory, Workspace,
		WorkspaceFile []ent.Interceptor
	}
)

// ExecContext allows calling the underlying ExecContext method of the driver if it is supported by it.
// See, database/sql#DB.ExecContext for more information.
func (c *config) ExecContext(ctx context.Context, query string, args ...any) (stdsql.Result, error) {
	ex, ok := c.driver.(interface {
		ExecContext(context.Context, string, ...any) (stdsql.Result, error)
	})
	if !ok {
		return nil, fmt.Errorf("Driver.ExecContext is not supported")
	}
	return ex.ExecContext(ctx, query, args...)
}

// QueryContext allows calling the underlying QueryContext method of the driver if it is supported by it.
// See, database/sql#DB.QueryContext for more information.
func (c *config) QueryContext(ctx context.Context, query string, args ...any) (*stdsql.Rows, error) {
	q, ok := c.driver.(interface {
		QueryContext(context.Context, string, ...any) (*stdsql.Rows, error)
	})
	if !ok {
		return nil, fmt.Errorf("Driver.QueryContext is not supported")
	}
	return q.QueryContext(ctx, query, args...)
}
