// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/dialect/sql/sqljson"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/codesnippet"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/workspacefile"
	"github.com/google/uuid"
	pgvector "github.com/pgvector/pgvector-go"
)

// CodeSnippetUpdate is the builder for updating CodeSnippet entities.
type CodeSnippetUpdate struct {
	config
	hooks     []Hook
	mutation  *CodeSnippetMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the CodeSnippetUpdate builder.
func (csu *CodeSnippetUpdate) Where(ps ...predicate.CodeSnippet) *CodeSnippetUpdate {
	csu.mutation.Where(ps...)
	return csu
}

// SetWorkspaceFileID sets the "workspace_file_id" field.
func (csu *CodeSnippetUpdate) SetWorkspaceFileID(u uuid.UUID) *CodeSnippetUpdate {
	csu.mutation.SetWorkspaceFileID(u)
	return csu
}

// SetNillableWorkspaceFileID sets the "workspace_file_id" field if the given value is not nil.
func (csu *CodeSnippetUpdate) SetNillableWorkspaceFileID(u *uuid.UUID) *CodeSnippetUpdate {
	if u != nil {
		csu.SetWorkspaceFileID(*u)
	}
	return csu
}

// SetName sets the "name" field.
func (csu *CodeSnippetUpdate) SetName(s string) *CodeSnippetUpdate {
	csu.mutation.SetName(s)
	return csu
}

// SetNillableName sets the "name" field if the given value is not nil.
func (csu *CodeSnippetUpdate) SetNillableName(s *string) *CodeSnippetUpdate {
	if s != nil {
		csu.SetName(*s)
	}
	return csu
}

// SetSnippetType sets the "snippet_type" field.
func (csu *CodeSnippetUpdate) SetSnippetType(s string) *CodeSnippetUpdate {
	csu.mutation.SetSnippetType(s)
	return csu
}

// SetNillableSnippetType sets the "snippet_type" field if the given value is not nil.
func (csu *CodeSnippetUpdate) SetNillableSnippetType(s *string) *CodeSnippetUpdate {
	if s != nil {
		csu.SetSnippetType(*s)
	}
	return csu
}

// SetLanguage sets the "language" field.
func (csu *CodeSnippetUpdate) SetLanguage(s string) *CodeSnippetUpdate {
	csu.mutation.SetLanguage(s)
	return csu
}

// SetNillableLanguage sets the "language" field if the given value is not nil.
func (csu *CodeSnippetUpdate) SetNillableLanguage(s *string) *CodeSnippetUpdate {
	if s != nil {
		csu.SetLanguage(*s)
	}
	return csu
}

// SetContent sets the "content" field.
func (csu *CodeSnippetUpdate) SetContent(s string) *CodeSnippetUpdate {
	csu.mutation.SetContent(s)
	return csu
}

// SetNillableContent sets the "content" field if the given value is not nil.
func (csu *CodeSnippetUpdate) SetNillableContent(s *string) *CodeSnippetUpdate {
	if s != nil {
		csu.SetContent(*s)
	}
	return csu
}

// SetHash sets the "hash" field.
func (csu *CodeSnippetUpdate) SetHash(s string) *CodeSnippetUpdate {
	csu.mutation.SetHash(s)
	return csu
}

// SetNillableHash sets the "hash" field if the given value is not nil.
func (csu *CodeSnippetUpdate) SetNillableHash(s *string) *CodeSnippetUpdate {
	if s != nil {
		csu.SetHash(*s)
	}
	return csu
}

// SetStartLine sets the "start_line" field.
func (csu *CodeSnippetUpdate) SetStartLine(i int) *CodeSnippetUpdate {
	csu.mutation.ResetStartLine()
	csu.mutation.SetStartLine(i)
	return csu
}

// SetNillableStartLine sets the "start_line" field if the given value is not nil.
func (csu *CodeSnippetUpdate) SetNillableStartLine(i *int) *CodeSnippetUpdate {
	if i != nil {
		csu.SetStartLine(*i)
	}
	return csu
}

// AddStartLine adds i to the "start_line" field.
func (csu *CodeSnippetUpdate) AddStartLine(i int) *CodeSnippetUpdate {
	csu.mutation.AddStartLine(i)
	return csu
}

// SetEndLine sets the "end_line" field.
func (csu *CodeSnippetUpdate) SetEndLine(i int) *CodeSnippetUpdate {
	csu.mutation.ResetEndLine()
	csu.mutation.SetEndLine(i)
	return csu
}

// SetNillableEndLine sets the "end_line" field if the given value is not nil.
func (csu *CodeSnippetUpdate) SetNillableEndLine(i *int) *CodeSnippetUpdate {
	if i != nil {
		csu.SetEndLine(*i)
	}
	return csu
}

// AddEndLine adds i to the "end_line" field.
func (csu *CodeSnippetUpdate) AddEndLine(i int) *CodeSnippetUpdate {
	csu.mutation.AddEndLine(i)
	return csu
}

// SetStartColumn sets the "start_column" field.
func (csu *CodeSnippetUpdate) SetStartColumn(i int) *CodeSnippetUpdate {
	csu.mutation.ResetStartColumn()
	csu.mutation.SetStartColumn(i)
	return csu
}

// SetNillableStartColumn sets the "start_column" field if the given value is not nil.
func (csu *CodeSnippetUpdate) SetNillableStartColumn(i *int) *CodeSnippetUpdate {
	if i != nil {
		csu.SetStartColumn(*i)
	}
	return csu
}

// AddStartColumn adds i to the "start_column" field.
func (csu *CodeSnippetUpdate) AddStartColumn(i int) *CodeSnippetUpdate {
	csu.mutation.AddStartColumn(i)
	return csu
}

// SetEndColumn sets the "end_column" field.
func (csu *CodeSnippetUpdate) SetEndColumn(i int) *CodeSnippetUpdate {
	csu.mutation.ResetEndColumn()
	csu.mutation.SetEndColumn(i)
	return csu
}

// SetNillableEndColumn sets the "end_column" field if the given value is not nil.
func (csu *CodeSnippetUpdate) SetNillableEndColumn(i *int) *CodeSnippetUpdate {
	if i != nil {
		csu.SetEndColumn(*i)
	}
	return csu
}

// AddEndColumn adds i to the "end_column" field.
func (csu *CodeSnippetUpdate) AddEndColumn(i int) *CodeSnippetUpdate {
	csu.mutation.AddEndColumn(i)
	return csu
}

// SetNamespace sets the "namespace" field.
func (csu *CodeSnippetUpdate) SetNamespace(s string) *CodeSnippetUpdate {
	csu.mutation.SetNamespace(s)
	return csu
}

// SetNillableNamespace sets the "namespace" field if the given value is not nil.
func (csu *CodeSnippetUpdate) SetNillableNamespace(s *string) *CodeSnippetUpdate {
	if s != nil {
		csu.SetNamespace(*s)
	}
	return csu
}

// ClearNamespace clears the value of the "namespace" field.
func (csu *CodeSnippetUpdate) ClearNamespace() *CodeSnippetUpdate {
	csu.mutation.ClearNamespace()
	return csu
}

// SetContainerName sets the "container_name" field.
func (csu *CodeSnippetUpdate) SetContainerName(s string) *CodeSnippetUpdate {
	csu.mutation.SetContainerName(s)
	return csu
}

// SetNillableContainerName sets the "container_name" field if the given value is not nil.
func (csu *CodeSnippetUpdate) SetNillableContainerName(s *string) *CodeSnippetUpdate {
	if s != nil {
		csu.SetContainerName(*s)
	}
	return csu
}

// ClearContainerName clears the value of the "container_name" field.
func (csu *CodeSnippetUpdate) ClearContainerName() *CodeSnippetUpdate {
	csu.mutation.ClearContainerName()
	return csu
}

// SetScope sets the "scope" field.
func (csu *CodeSnippetUpdate) SetScope(s []string) *CodeSnippetUpdate {
	csu.mutation.SetScope(s)
	return csu
}

// AppendScope appends s to the "scope" field.
func (csu *CodeSnippetUpdate) AppendScope(s []string) *CodeSnippetUpdate {
	csu.mutation.AppendScope(s)
	return csu
}

// ClearScope clears the value of the "scope" field.
func (csu *CodeSnippetUpdate) ClearScope() *CodeSnippetUpdate {
	csu.mutation.ClearScope()
	return csu
}

// SetDependencies sets the "dependencies" field.
func (csu *CodeSnippetUpdate) SetDependencies(s []string) *CodeSnippetUpdate {
	csu.mutation.SetDependencies(s)
	return csu
}

// AppendDependencies appends s to the "dependencies" field.
func (csu *CodeSnippetUpdate) AppendDependencies(s []string) *CodeSnippetUpdate {
	csu.mutation.AppendDependencies(s)
	return csu
}

// ClearDependencies clears the value of the "dependencies" field.
func (csu *CodeSnippetUpdate) ClearDependencies() *CodeSnippetUpdate {
	csu.mutation.ClearDependencies()
	return csu
}

// SetParameters sets the "parameters" field.
func (csu *CodeSnippetUpdate) SetParameters(m []map[string]interface{}) *CodeSnippetUpdate {
	csu.mutation.SetParameters(m)
	return csu
}

// AppendParameters appends m to the "parameters" field.
func (csu *CodeSnippetUpdate) AppendParameters(m []map[string]interface{}) *CodeSnippetUpdate {
	csu.mutation.AppendParameters(m)
	return csu
}

// ClearParameters clears the value of the "parameters" field.
func (csu *CodeSnippetUpdate) ClearParameters() *CodeSnippetUpdate {
	csu.mutation.ClearParameters()
	return csu
}

// SetSignature sets the "signature" field.
func (csu *CodeSnippetUpdate) SetSignature(s string) *CodeSnippetUpdate {
	csu.mutation.SetSignature(s)
	return csu
}

// SetNillableSignature sets the "signature" field if the given value is not nil.
func (csu *CodeSnippetUpdate) SetNillableSignature(s *string) *CodeSnippetUpdate {
	if s != nil {
		csu.SetSignature(*s)
	}
	return csu
}

// ClearSignature clears the value of the "signature" field.
func (csu *CodeSnippetUpdate) ClearSignature() *CodeSnippetUpdate {
	csu.mutation.ClearSignature()
	return csu
}

// SetDefinitionText sets the "definition_text" field.
func (csu *CodeSnippetUpdate) SetDefinitionText(s string) *CodeSnippetUpdate {
	csu.mutation.SetDefinitionText(s)
	return csu
}

// SetNillableDefinitionText sets the "definition_text" field if the given value is not nil.
func (csu *CodeSnippetUpdate) SetNillableDefinitionText(s *string) *CodeSnippetUpdate {
	if s != nil {
		csu.SetDefinitionText(*s)
	}
	return csu
}

// ClearDefinitionText clears the value of the "definition_text" field.
func (csu *CodeSnippetUpdate) ClearDefinitionText() *CodeSnippetUpdate {
	csu.mutation.ClearDefinitionText()
	return csu
}

// SetStructuredInfo sets the "structured_info" field.
func (csu *CodeSnippetUpdate) SetStructuredInfo(m map[string]interface{}) *CodeSnippetUpdate {
	csu.mutation.SetStructuredInfo(m)
	return csu
}

// ClearStructuredInfo clears the value of the "structured_info" field.
func (csu *CodeSnippetUpdate) ClearStructuredInfo() *CodeSnippetUpdate {
	csu.mutation.ClearStructuredInfo()
	return csu
}

// SetEmbedding sets the "embedding" field.
func (csu *CodeSnippetUpdate) SetEmbedding(pg pgvector.Vector) *CodeSnippetUpdate {
	csu.mutation.SetEmbedding(pg)
	return csu
}

// SetNillableEmbedding sets the "embedding" field if the given value is not nil.
func (csu *CodeSnippetUpdate) SetNillableEmbedding(pg *pgvector.Vector) *CodeSnippetUpdate {
	if pg != nil {
		csu.SetEmbedding(*pg)
	}
	return csu
}

// ClearEmbedding clears the value of the "embedding" field.
func (csu *CodeSnippetUpdate) ClearEmbedding() *CodeSnippetUpdate {
	csu.mutation.ClearEmbedding()
	return csu
}

// SetWorkspacePath sets the "workspacePath" field.
func (csu *CodeSnippetUpdate) SetWorkspacePath(s string) *CodeSnippetUpdate {
	csu.mutation.SetWorkspacePath(s)
	return csu
}

// SetNillableWorkspacePath sets the "workspacePath" field if the given value is not nil.
func (csu *CodeSnippetUpdate) SetNillableWorkspacePath(s *string) *CodeSnippetUpdate {
	if s != nil {
		csu.SetWorkspacePath(*s)
	}
	return csu
}

// ClearWorkspacePath clears the value of the "workspacePath" field.
func (csu *CodeSnippetUpdate) ClearWorkspacePath() *CodeSnippetUpdate {
	csu.mutation.ClearWorkspacePath()
	return csu
}

// SetSourceFileID sets the "source_file" edge to the WorkspaceFile entity by ID.
func (csu *CodeSnippetUpdate) SetSourceFileID(id uuid.UUID) *CodeSnippetUpdate {
	csu.mutation.SetSourceFileID(id)
	return csu
}

// SetSourceFile sets the "source_file" edge to the WorkspaceFile entity.
func (csu *CodeSnippetUpdate) SetSourceFile(w *WorkspaceFile) *CodeSnippetUpdate {
	return csu.SetSourceFileID(w.ID)
}

// Mutation returns the CodeSnippetMutation object of the builder.
func (csu *CodeSnippetUpdate) Mutation() *CodeSnippetMutation {
	return csu.mutation
}

// ClearSourceFile clears the "source_file" edge to the WorkspaceFile entity.
func (csu *CodeSnippetUpdate) ClearSourceFile() *CodeSnippetUpdate {
	csu.mutation.ClearSourceFile()
	return csu
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (csu *CodeSnippetUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, csu.sqlSave, csu.mutation, csu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (csu *CodeSnippetUpdate) SaveX(ctx context.Context) int {
	affected, err := csu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (csu *CodeSnippetUpdate) Exec(ctx context.Context) error {
	_, err := csu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (csu *CodeSnippetUpdate) ExecX(ctx context.Context) {
	if err := csu.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (csu *CodeSnippetUpdate) check() error {
	if csu.mutation.SourceFileCleared() && len(csu.mutation.SourceFileIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "CodeSnippet.source_file"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (csu *CodeSnippetUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *CodeSnippetUpdate {
	csu.modifiers = append(csu.modifiers, modifiers...)
	return csu
}

func (csu *CodeSnippetUpdate) sqlSave(ctx context.Context) (n int, err error) {
	if err := csu.check(); err != nil {
		return n, err
	}
	_spec := sqlgraph.NewUpdateSpec(codesnippet.Table, codesnippet.Columns, sqlgraph.NewFieldSpec(codesnippet.FieldID, field.TypeUUID))
	if ps := csu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := csu.mutation.Name(); ok {
		_spec.SetField(codesnippet.FieldName, field.TypeString, value)
	}
	if value, ok := csu.mutation.SnippetType(); ok {
		_spec.SetField(codesnippet.FieldSnippetType, field.TypeString, value)
	}
	if value, ok := csu.mutation.Language(); ok {
		_spec.SetField(codesnippet.FieldLanguage, field.TypeString, value)
	}
	if value, ok := csu.mutation.Content(); ok {
		_spec.SetField(codesnippet.FieldContent, field.TypeString, value)
	}
	if value, ok := csu.mutation.Hash(); ok {
		_spec.SetField(codesnippet.FieldHash, field.TypeString, value)
	}
	if value, ok := csu.mutation.StartLine(); ok {
		_spec.SetField(codesnippet.FieldStartLine, field.TypeInt, value)
	}
	if value, ok := csu.mutation.AddedStartLine(); ok {
		_spec.AddField(codesnippet.FieldStartLine, field.TypeInt, value)
	}
	if value, ok := csu.mutation.EndLine(); ok {
		_spec.SetField(codesnippet.FieldEndLine, field.TypeInt, value)
	}
	if value, ok := csu.mutation.AddedEndLine(); ok {
		_spec.AddField(codesnippet.FieldEndLine, field.TypeInt, value)
	}
	if value, ok := csu.mutation.StartColumn(); ok {
		_spec.SetField(codesnippet.FieldStartColumn, field.TypeInt, value)
	}
	if value, ok := csu.mutation.AddedStartColumn(); ok {
		_spec.AddField(codesnippet.FieldStartColumn, field.TypeInt, value)
	}
	if value, ok := csu.mutation.EndColumn(); ok {
		_spec.SetField(codesnippet.FieldEndColumn, field.TypeInt, value)
	}
	if value, ok := csu.mutation.AddedEndColumn(); ok {
		_spec.AddField(codesnippet.FieldEndColumn, field.TypeInt, value)
	}
	if value, ok := csu.mutation.Namespace(); ok {
		_spec.SetField(codesnippet.FieldNamespace, field.TypeString, value)
	}
	if csu.mutation.NamespaceCleared() {
		_spec.ClearField(codesnippet.FieldNamespace, field.TypeString)
	}
	if value, ok := csu.mutation.ContainerName(); ok {
		_spec.SetField(codesnippet.FieldContainerName, field.TypeString, value)
	}
	if csu.mutation.ContainerNameCleared() {
		_spec.ClearField(codesnippet.FieldContainerName, field.TypeString)
	}
	if value, ok := csu.mutation.Scope(); ok {
		_spec.SetField(codesnippet.FieldScope, field.TypeJSON, value)
	}
	if value, ok := csu.mutation.AppendedScope(); ok {
		_spec.AddModifier(func(u *sql.UpdateBuilder) {
			sqljson.Append(u, codesnippet.FieldScope, value)
		})
	}
	if csu.mutation.ScopeCleared() {
		_spec.ClearField(codesnippet.FieldScope, field.TypeJSON)
	}
	if value, ok := csu.mutation.Dependencies(); ok {
		_spec.SetField(codesnippet.FieldDependencies, field.TypeJSON, value)
	}
	if value, ok := csu.mutation.AppendedDependencies(); ok {
		_spec.AddModifier(func(u *sql.UpdateBuilder) {
			sqljson.Append(u, codesnippet.FieldDependencies, value)
		})
	}
	if csu.mutation.DependenciesCleared() {
		_spec.ClearField(codesnippet.FieldDependencies, field.TypeJSON)
	}
	if value, ok := csu.mutation.Parameters(); ok {
		_spec.SetField(codesnippet.FieldParameters, field.TypeJSON, value)
	}
	if value, ok := csu.mutation.AppendedParameters(); ok {
		_spec.AddModifier(func(u *sql.UpdateBuilder) {
			sqljson.Append(u, codesnippet.FieldParameters, value)
		})
	}
	if csu.mutation.ParametersCleared() {
		_spec.ClearField(codesnippet.FieldParameters, field.TypeJSON)
	}
	if value, ok := csu.mutation.Signature(); ok {
		_spec.SetField(codesnippet.FieldSignature, field.TypeString, value)
	}
	if csu.mutation.SignatureCleared() {
		_spec.ClearField(codesnippet.FieldSignature, field.TypeString)
	}
	if value, ok := csu.mutation.DefinitionText(); ok {
		_spec.SetField(codesnippet.FieldDefinitionText, field.TypeString, value)
	}
	if csu.mutation.DefinitionTextCleared() {
		_spec.ClearField(codesnippet.FieldDefinitionText, field.TypeString)
	}
	if value, ok := csu.mutation.StructuredInfo(); ok {
		_spec.SetField(codesnippet.FieldStructuredInfo, field.TypeJSON, value)
	}
	if csu.mutation.StructuredInfoCleared() {
		_spec.ClearField(codesnippet.FieldStructuredInfo, field.TypeJSON)
	}
	if value, ok := csu.mutation.Embedding(); ok {
		_spec.SetField(codesnippet.FieldEmbedding, field.TypeOther, value)
	}
	if csu.mutation.EmbeddingCleared() {
		_spec.ClearField(codesnippet.FieldEmbedding, field.TypeOther)
	}
	if value, ok := csu.mutation.WorkspacePath(); ok {
		_spec.SetField(codesnippet.FieldWorkspacePath, field.TypeString, value)
	}
	if csu.mutation.WorkspacePathCleared() {
		_spec.ClearField(codesnippet.FieldWorkspacePath, field.TypeString)
	}
	if csu.mutation.SourceFileCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   codesnippet.SourceFileTable,
			Columns: []string{codesnippet.SourceFileColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspacefile.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := csu.mutation.SourceFileIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   codesnippet.SourceFileTable,
			Columns: []string{codesnippet.SourceFileColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspacefile.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(csu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, csu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{codesnippet.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	csu.mutation.done = true
	return n, nil
}

// CodeSnippetUpdateOne is the builder for updating a single CodeSnippet entity.
type CodeSnippetUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *CodeSnippetMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetWorkspaceFileID sets the "workspace_file_id" field.
func (csuo *CodeSnippetUpdateOne) SetWorkspaceFileID(u uuid.UUID) *CodeSnippetUpdateOne {
	csuo.mutation.SetWorkspaceFileID(u)
	return csuo
}

// SetNillableWorkspaceFileID sets the "workspace_file_id" field if the given value is not nil.
func (csuo *CodeSnippetUpdateOne) SetNillableWorkspaceFileID(u *uuid.UUID) *CodeSnippetUpdateOne {
	if u != nil {
		csuo.SetWorkspaceFileID(*u)
	}
	return csuo
}

// SetName sets the "name" field.
func (csuo *CodeSnippetUpdateOne) SetName(s string) *CodeSnippetUpdateOne {
	csuo.mutation.SetName(s)
	return csuo
}

// SetNillableName sets the "name" field if the given value is not nil.
func (csuo *CodeSnippetUpdateOne) SetNillableName(s *string) *CodeSnippetUpdateOne {
	if s != nil {
		csuo.SetName(*s)
	}
	return csuo
}

// SetSnippetType sets the "snippet_type" field.
func (csuo *CodeSnippetUpdateOne) SetSnippetType(s string) *CodeSnippetUpdateOne {
	csuo.mutation.SetSnippetType(s)
	return csuo
}

// SetNillableSnippetType sets the "snippet_type" field if the given value is not nil.
func (csuo *CodeSnippetUpdateOne) SetNillableSnippetType(s *string) *CodeSnippetUpdateOne {
	if s != nil {
		csuo.SetSnippetType(*s)
	}
	return csuo
}

// SetLanguage sets the "language" field.
func (csuo *CodeSnippetUpdateOne) SetLanguage(s string) *CodeSnippetUpdateOne {
	csuo.mutation.SetLanguage(s)
	return csuo
}

// SetNillableLanguage sets the "language" field if the given value is not nil.
func (csuo *CodeSnippetUpdateOne) SetNillableLanguage(s *string) *CodeSnippetUpdateOne {
	if s != nil {
		csuo.SetLanguage(*s)
	}
	return csuo
}

// SetContent sets the "content" field.
func (csuo *CodeSnippetUpdateOne) SetContent(s string) *CodeSnippetUpdateOne {
	csuo.mutation.SetContent(s)
	return csuo
}

// SetNillableContent sets the "content" field if the given value is not nil.
func (csuo *CodeSnippetUpdateOne) SetNillableContent(s *string) *CodeSnippetUpdateOne {
	if s != nil {
		csuo.SetContent(*s)
	}
	return csuo
}

// SetHash sets the "hash" field.
func (csuo *CodeSnippetUpdateOne) SetHash(s string) *CodeSnippetUpdateOne {
	csuo.mutation.SetHash(s)
	return csuo
}

// SetNillableHash sets the "hash" field if the given value is not nil.
func (csuo *CodeSnippetUpdateOne) SetNillableHash(s *string) *CodeSnippetUpdateOne {
	if s != nil {
		csuo.SetHash(*s)
	}
	return csuo
}

// SetStartLine sets the "start_line" field.
func (csuo *CodeSnippetUpdateOne) SetStartLine(i int) *CodeSnippetUpdateOne {
	csuo.mutation.ResetStartLine()
	csuo.mutation.SetStartLine(i)
	return csuo
}

// SetNillableStartLine sets the "start_line" field if the given value is not nil.
func (csuo *CodeSnippetUpdateOne) SetNillableStartLine(i *int) *CodeSnippetUpdateOne {
	if i != nil {
		csuo.SetStartLine(*i)
	}
	return csuo
}

// AddStartLine adds i to the "start_line" field.
func (csuo *CodeSnippetUpdateOne) AddStartLine(i int) *CodeSnippetUpdateOne {
	csuo.mutation.AddStartLine(i)
	return csuo
}

// SetEndLine sets the "end_line" field.
func (csuo *CodeSnippetUpdateOne) SetEndLine(i int) *CodeSnippetUpdateOne {
	csuo.mutation.ResetEndLine()
	csuo.mutation.SetEndLine(i)
	return csuo
}

// SetNillableEndLine sets the "end_line" field if the given value is not nil.
func (csuo *CodeSnippetUpdateOne) SetNillableEndLine(i *int) *CodeSnippetUpdateOne {
	if i != nil {
		csuo.SetEndLine(*i)
	}
	return csuo
}

// AddEndLine adds i to the "end_line" field.
func (csuo *CodeSnippetUpdateOne) AddEndLine(i int) *CodeSnippetUpdateOne {
	csuo.mutation.AddEndLine(i)
	return csuo
}

// SetStartColumn sets the "start_column" field.
func (csuo *CodeSnippetUpdateOne) SetStartColumn(i int) *CodeSnippetUpdateOne {
	csuo.mutation.ResetStartColumn()
	csuo.mutation.SetStartColumn(i)
	return csuo
}

// SetNillableStartColumn sets the "start_column" field if the given value is not nil.
func (csuo *CodeSnippetUpdateOne) SetNillableStartColumn(i *int) *CodeSnippetUpdateOne {
	if i != nil {
		csuo.SetStartColumn(*i)
	}
	return csuo
}

// AddStartColumn adds i to the "start_column" field.
func (csuo *CodeSnippetUpdateOne) AddStartColumn(i int) *CodeSnippetUpdateOne {
	csuo.mutation.AddStartColumn(i)
	return csuo
}

// SetEndColumn sets the "end_column" field.
func (csuo *CodeSnippetUpdateOne) SetEndColumn(i int) *CodeSnippetUpdateOne {
	csuo.mutation.ResetEndColumn()
	csuo.mutation.SetEndColumn(i)
	return csuo
}

// SetNillableEndColumn sets the "end_column" field if the given value is not nil.
func (csuo *CodeSnippetUpdateOne) SetNillableEndColumn(i *int) *CodeSnippetUpdateOne {
	if i != nil {
		csuo.SetEndColumn(*i)
	}
	return csuo
}

// AddEndColumn adds i to the "end_column" field.
func (csuo *CodeSnippetUpdateOne) AddEndColumn(i int) *CodeSnippetUpdateOne {
	csuo.mutation.AddEndColumn(i)
	return csuo
}

// SetNamespace sets the "namespace" field.
func (csuo *CodeSnippetUpdateOne) SetNamespace(s string) *CodeSnippetUpdateOne {
	csuo.mutation.SetNamespace(s)
	return csuo
}

// SetNillableNamespace sets the "namespace" field if the given value is not nil.
func (csuo *CodeSnippetUpdateOne) SetNillableNamespace(s *string) *CodeSnippetUpdateOne {
	if s != nil {
		csuo.SetNamespace(*s)
	}
	return csuo
}

// ClearNamespace clears the value of the "namespace" field.
func (csuo *CodeSnippetUpdateOne) ClearNamespace() *CodeSnippetUpdateOne {
	csuo.mutation.ClearNamespace()
	return csuo
}

// SetContainerName sets the "container_name" field.
func (csuo *CodeSnippetUpdateOne) SetContainerName(s string) *CodeSnippetUpdateOne {
	csuo.mutation.SetContainerName(s)
	return csuo
}

// SetNillableContainerName sets the "container_name" field if the given value is not nil.
func (csuo *CodeSnippetUpdateOne) SetNillableContainerName(s *string) *CodeSnippetUpdateOne {
	if s != nil {
		csuo.SetContainerName(*s)
	}
	return csuo
}

// ClearContainerName clears the value of the "container_name" field.
func (csuo *CodeSnippetUpdateOne) ClearContainerName() *CodeSnippetUpdateOne {
	csuo.mutation.ClearContainerName()
	return csuo
}

// SetScope sets the "scope" field.
func (csuo *CodeSnippetUpdateOne) SetScope(s []string) *CodeSnippetUpdateOne {
	csuo.mutation.SetScope(s)
	return csuo
}

// AppendScope appends s to the "scope" field.
func (csuo *CodeSnippetUpdateOne) AppendScope(s []string) *CodeSnippetUpdateOne {
	csuo.mutation.AppendScope(s)
	return csuo
}

// ClearScope clears the value of the "scope" field.
func (csuo *CodeSnippetUpdateOne) ClearScope() *CodeSnippetUpdateOne {
	csuo.mutation.ClearScope()
	return csuo
}

// SetDependencies sets the "dependencies" field.
func (csuo *CodeSnippetUpdateOne) SetDependencies(s []string) *CodeSnippetUpdateOne {
	csuo.mutation.SetDependencies(s)
	return csuo
}

// AppendDependencies appends s to the "dependencies" field.
func (csuo *CodeSnippetUpdateOne) AppendDependencies(s []string) *CodeSnippetUpdateOne {
	csuo.mutation.AppendDependencies(s)
	return csuo
}

// ClearDependencies clears the value of the "dependencies" field.
func (csuo *CodeSnippetUpdateOne) ClearDependencies() *CodeSnippetUpdateOne {
	csuo.mutation.ClearDependencies()
	return csuo
}

// SetParameters sets the "parameters" field.
func (csuo *CodeSnippetUpdateOne) SetParameters(m []map[string]interface{}) *CodeSnippetUpdateOne {
	csuo.mutation.SetParameters(m)
	return csuo
}

// AppendParameters appends m to the "parameters" field.
func (csuo *CodeSnippetUpdateOne) AppendParameters(m []map[string]interface{}) *CodeSnippetUpdateOne {
	csuo.mutation.AppendParameters(m)
	return csuo
}

// ClearParameters clears the value of the "parameters" field.
func (csuo *CodeSnippetUpdateOne) ClearParameters() *CodeSnippetUpdateOne {
	csuo.mutation.ClearParameters()
	return csuo
}

// SetSignature sets the "signature" field.
func (csuo *CodeSnippetUpdateOne) SetSignature(s string) *CodeSnippetUpdateOne {
	csuo.mutation.SetSignature(s)
	return csuo
}

// SetNillableSignature sets the "signature" field if the given value is not nil.
func (csuo *CodeSnippetUpdateOne) SetNillableSignature(s *string) *CodeSnippetUpdateOne {
	if s != nil {
		csuo.SetSignature(*s)
	}
	return csuo
}

// ClearSignature clears the value of the "signature" field.
func (csuo *CodeSnippetUpdateOne) ClearSignature() *CodeSnippetUpdateOne {
	csuo.mutation.ClearSignature()
	return csuo
}

// SetDefinitionText sets the "definition_text" field.
func (csuo *CodeSnippetUpdateOne) SetDefinitionText(s string) *CodeSnippetUpdateOne {
	csuo.mutation.SetDefinitionText(s)
	return csuo
}

// SetNillableDefinitionText sets the "definition_text" field if the given value is not nil.
func (csuo *CodeSnippetUpdateOne) SetNillableDefinitionText(s *string) *CodeSnippetUpdateOne {
	if s != nil {
		csuo.SetDefinitionText(*s)
	}
	return csuo
}

// ClearDefinitionText clears the value of the "definition_text" field.
func (csuo *CodeSnippetUpdateOne) ClearDefinitionText() *CodeSnippetUpdateOne {
	csuo.mutation.ClearDefinitionText()
	return csuo
}

// SetStructuredInfo sets the "structured_info" field.
func (csuo *CodeSnippetUpdateOne) SetStructuredInfo(m map[string]interface{}) *CodeSnippetUpdateOne {
	csuo.mutation.SetStructuredInfo(m)
	return csuo
}

// ClearStructuredInfo clears the value of the "structured_info" field.
func (csuo *CodeSnippetUpdateOne) ClearStructuredInfo() *CodeSnippetUpdateOne {
	csuo.mutation.ClearStructuredInfo()
	return csuo
}

// SetEmbedding sets the "embedding" field.
func (csuo *CodeSnippetUpdateOne) SetEmbedding(pg pgvector.Vector) *CodeSnippetUpdateOne {
	csuo.mutation.SetEmbedding(pg)
	return csuo
}

// SetNillableEmbedding sets the "embedding" field if the given value is not nil.
func (csuo *CodeSnippetUpdateOne) SetNillableEmbedding(pg *pgvector.Vector) *CodeSnippetUpdateOne {
	if pg != nil {
		csuo.SetEmbedding(*pg)
	}
	return csuo
}

// ClearEmbedding clears the value of the "embedding" field.
func (csuo *CodeSnippetUpdateOne) ClearEmbedding() *CodeSnippetUpdateOne {
	csuo.mutation.ClearEmbedding()
	return csuo
}

// SetWorkspacePath sets the "workspacePath" field.
func (csuo *CodeSnippetUpdateOne) SetWorkspacePath(s string) *CodeSnippetUpdateOne {
	csuo.mutation.SetWorkspacePath(s)
	return csuo
}

// SetNillableWorkspacePath sets the "workspacePath" field if the given value is not nil.
func (csuo *CodeSnippetUpdateOne) SetNillableWorkspacePath(s *string) *CodeSnippetUpdateOne {
	if s != nil {
		csuo.SetWorkspacePath(*s)
	}
	return csuo
}

// ClearWorkspacePath clears the value of the "workspacePath" field.
func (csuo *CodeSnippetUpdateOne) ClearWorkspacePath() *CodeSnippetUpdateOne {
	csuo.mutation.ClearWorkspacePath()
	return csuo
}

// SetSourceFileID sets the "source_file" edge to the WorkspaceFile entity by ID.
func (csuo *CodeSnippetUpdateOne) SetSourceFileID(id uuid.UUID) *CodeSnippetUpdateOne {
	csuo.mutation.SetSourceFileID(id)
	return csuo
}

// SetSourceFile sets the "source_file" edge to the WorkspaceFile entity.
func (csuo *CodeSnippetUpdateOne) SetSourceFile(w *WorkspaceFile) *CodeSnippetUpdateOne {
	return csuo.SetSourceFileID(w.ID)
}

// Mutation returns the CodeSnippetMutation object of the builder.
func (csuo *CodeSnippetUpdateOne) Mutation() *CodeSnippetMutation {
	return csuo.mutation
}

// ClearSourceFile clears the "source_file" edge to the WorkspaceFile entity.
func (csuo *CodeSnippetUpdateOne) ClearSourceFile() *CodeSnippetUpdateOne {
	csuo.mutation.ClearSourceFile()
	return csuo
}

// Where appends a list predicates to the CodeSnippetUpdate builder.
func (csuo *CodeSnippetUpdateOne) Where(ps ...predicate.CodeSnippet) *CodeSnippetUpdateOne {
	csuo.mutation.Where(ps...)
	return csuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (csuo *CodeSnippetUpdateOne) Select(field string, fields ...string) *CodeSnippetUpdateOne {
	csuo.fields = append([]string{field}, fields...)
	return csuo
}

// Save executes the query and returns the updated CodeSnippet entity.
func (csuo *CodeSnippetUpdateOne) Save(ctx context.Context) (*CodeSnippet, error) {
	return withHooks(ctx, csuo.sqlSave, csuo.mutation, csuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (csuo *CodeSnippetUpdateOne) SaveX(ctx context.Context) *CodeSnippet {
	node, err := csuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (csuo *CodeSnippetUpdateOne) Exec(ctx context.Context) error {
	_, err := csuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (csuo *CodeSnippetUpdateOne) ExecX(ctx context.Context) {
	if err := csuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (csuo *CodeSnippetUpdateOne) check() error {
	if csuo.mutation.SourceFileCleared() && len(csuo.mutation.SourceFileIDs()) > 0 {
		return errors.New(`db: clearing a required unique edge "CodeSnippet.source_file"`)
	}
	return nil
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (csuo *CodeSnippetUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *CodeSnippetUpdateOne {
	csuo.modifiers = append(csuo.modifiers, modifiers...)
	return csuo
}

func (csuo *CodeSnippetUpdateOne) sqlSave(ctx context.Context) (_node *CodeSnippet, err error) {
	if err := csuo.check(); err != nil {
		return _node, err
	}
	_spec := sqlgraph.NewUpdateSpec(codesnippet.Table, codesnippet.Columns, sqlgraph.NewFieldSpec(codesnippet.FieldID, field.TypeUUID))
	id, ok := csuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "CodeSnippet.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := csuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, codesnippet.FieldID)
		for _, f := range fields {
			if !codesnippet.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != codesnippet.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := csuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := csuo.mutation.Name(); ok {
		_spec.SetField(codesnippet.FieldName, field.TypeString, value)
	}
	if value, ok := csuo.mutation.SnippetType(); ok {
		_spec.SetField(codesnippet.FieldSnippetType, field.TypeString, value)
	}
	if value, ok := csuo.mutation.Language(); ok {
		_spec.SetField(codesnippet.FieldLanguage, field.TypeString, value)
	}
	if value, ok := csuo.mutation.Content(); ok {
		_spec.SetField(codesnippet.FieldContent, field.TypeString, value)
	}
	if value, ok := csuo.mutation.Hash(); ok {
		_spec.SetField(codesnippet.FieldHash, field.TypeString, value)
	}
	if value, ok := csuo.mutation.StartLine(); ok {
		_spec.SetField(codesnippet.FieldStartLine, field.TypeInt, value)
	}
	if value, ok := csuo.mutation.AddedStartLine(); ok {
		_spec.AddField(codesnippet.FieldStartLine, field.TypeInt, value)
	}
	if value, ok := csuo.mutation.EndLine(); ok {
		_spec.SetField(codesnippet.FieldEndLine, field.TypeInt, value)
	}
	if value, ok := csuo.mutation.AddedEndLine(); ok {
		_spec.AddField(codesnippet.FieldEndLine, field.TypeInt, value)
	}
	if value, ok := csuo.mutation.StartColumn(); ok {
		_spec.SetField(codesnippet.FieldStartColumn, field.TypeInt, value)
	}
	if value, ok := csuo.mutation.AddedStartColumn(); ok {
		_spec.AddField(codesnippet.FieldStartColumn, field.TypeInt, value)
	}
	if value, ok := csuo.mutation.EndColumn(); ok {
		_spec.SetField(codesnippet.FieldEndColumn, field.TypeInt, value)
	}
	if value, ok := csuo.mutation.AddedEndColumn(); ok {
		_spec.AddField(codesnippet.FieldEndColumn, field.TypeInt, value)
	}
	if value, ok := csuo.mutation.Namespace(); ok {
		_spec.SetField(codesnippet.FieldNamespace, field.TypeString, value)
	}
	if csuo.mutation.NamespaceCleared() {
		_spec.ClearField(codesnippet.FieldNamespace, field.TypeString)
	}
	if value, ok := csuo.mutation.ContainerName(); ok {
		_spec.SetField(codesnippet.FieldContainerName, field.TypeString, value)
	}
	if csuo.mutation.ContainerNameCleared() {
		_spec.ClearField(codesnippet.FieldContainerName, field.TypeString)
	}
	if value, ok := csuo.mutation.Scope(); ok {
		_spec.SetField(codesnippet.FieldScope, field.TypeJSON, value)
	}
	if value, ok := csuo.mutation.AppendedScope(); ok {
		_spec.AddModifier(func(u *sql.UpdateBuilder) {
			sqljson.Append(u, codesnippet.FieldScope, value)
		})
	}
	if csuo.mutation.ScopeCleared() {
		_spec.ClearField(codesnippet.FieldScope, field.TypeJSON)
	}
	if value, ok := csuo.mutation.Dependencies(); ok {
		_spec.SetField(codesnippet.FieldDependencies, field.TypeJSON, value)
	}
	if value, ok := csuo.mutation.AppendedDependencies(); ok {
		_spec.AddModifier(func(u *sql.UpdateBuilder) {
			sqljson.Append(u, codesnippet.FieldDependencies, value)
		})
	}
	if csuo.mutation.DependenciesCleared() {
		_spec.ClearField(codesnippet.FieldDependencies, field.TypeJSON)
	}
	if value, ok := csuo.mutation.Parameters(); ok {
		_spec.SetField(codesnippet.FieldParameters, field.TypeJSON, value)
	}
	if value, ok := csuo.mutation.AppendedParameters(); ok {
		_spec.AddModifier(func(u *sql.UpdateBuilder) {
			sqljson.Append(u, codesnippet.FieldParameters, value)
		})
	}
	if csuo.mutation.ParametersCleared() {
		_spec.ClearField(codesnippet.FieldParameters, field.TypeJSON)
	}
	if value, ok := csuo.mutation.Signature(); ok {
		_spec.SetField(codesnippet.FieldSignature, field.TypeString, value)
	}
	if csuo.mutation.SignatureCleared() {
		_spec.ClearField(codesnippet.FieldSignature, field.TypeString)
	}
	if value, ok := csuo.mutation.DefinitionText(); ok {
		_spec.SetField(codesnippet.FieldDefinitionText, field.TypeString, value)
	}
	if csuo.mutation.DefinitionTextCleared() {
		_spec.ClearField(codesnippet.FieldDefinitionText, field.TypeString)
	}
	if value, ok := csuo.mutation.StructuredInfo(); ok {
		_spec.SetField(codesnippet.FieldStructuredInfo, field.TypeJSON, value)
	}
	if csuo.mutation.StructuredInfoCleared() {
		_spec.ClearField(codesnippet.FieldStructuredInfo, field.TypeJSON)
	}
	if value, ok := csuo.mutation.Embedding(); ok {
		_spec.SetField(codesnippet.FieldEmbedding, field.TypeOther, value)
	}
	if csuo.mutation.EmbeddingCleared() {
		_spec.ClearField(codesnippet.FieldEmbedding, field.TypeOther)
	}
	if value, ok := csuo.mutation.WorkspacePath(); ok {
		_spec.SetField(codesnippet.FieldWorkspacePath, field.TypeString, value)
	}
	if csuo.mutation.WorkspacePathCleared() {
		_spec.ClearField(codesnippet.FieldWorkspacePath, field.TypeString)
	}
	if csuo.mutation.SourceFileCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   codesnippet.SourceFileTable,
			Columns: []string{codesnippet.SourceFileColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspacefile.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := csuo.mutation.SourceFileIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   codesnippet.SourceFileTable,
			Columns: []string{codesnippet.SourceFileColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(workspacefile.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(csuo.modifiers...)
	_node = &CodeSnippet{config: csuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, csuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{codesnippet.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	csuo.mutation.done = true
	return _node, nil
}
