// Code generated by ent, DO NOT EDIT.

package db

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/db/extension"
	"github.com/google/uuid"
)

// Extension is the model entity for the Extension schema.
type Extension struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// Version holds the value of the "version" field.
	Version string `json:"version,omitempty"`
	// Path holds the value of the "path" field.
	Path string `json:"path,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt    time.Time `json:"created_at,omitempty"`
	selectValues sql.SelectValues
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Extension) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case extension.FieldVersion, extension.FieldPath:
			values[i] = new(sql.NullString)
		case extension.FieldCreatedAt:
			values[i] = new(sql.NullTime)
		case extension.FieldID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Extension fields.
func (e *Extension) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case extension.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				e.ID = *value
			}
		case extension.FieldVersion:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field version", values[i])
			} else if value.Valid {
				e.Version = value.String
			}
		case extension.FieldPath:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field path", values[i])
			} else if value.Valid {
				e.Path = value.String
			}
		case extension.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				e.CreatedAt = value.Time
			}
		default:
			e.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the Extension.
// This includes values selected through modifiers, order, etc.
func (e *Extension) Value(name string) (ent.Value, error) {
	return e.selectValues.Get(name)
}

// Update returns a builder for updating this Extension.
// Note that you need to call Extension.Unwrap() before calling this method if this Extension
// was returned from a transaction, and the transaction was committed or rolled back.
func (e *Extension) Update() *ExtensionUpdateOne {
	return NewExtensionClient(e.config).UpdateOne(e)
}

// Unwrap unwraps the Extension entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (e *Extension) Unwrap() *Extension {
	_tx, ok := e.config.driver.(*txDriver)
	if !ok {
		panic("db: Extension is not a transactional entity")
	}
	e.config.driver = _tx.drv
	return e
}

// String implements the fmt.Stringer.
func (e *Extension) String() string {
	var builder strings.Builder
	builder.WriteString("Extension(")
	builder.WriteString(fmt.Sprintf("id=%v, ", e.ID))
	builder.WriteString("version=")
	builder.WriteString(e.Version)
	builder.WriteString(", ")
	builder.WriteString("path=")
	builder.WriteString(e.Path)
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(e.CreatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// Extensions is a parsable slice of Extension.
type Extensions []*Extension
