// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"fmt"
	"math"

	"entgo.io/ent"
	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/extension"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/google/uuid"
)

// ExtensionQuery is the builder for querying Extension entities.
type ExtensionQuery struct {
	config
	ctx        *QueryContext
	order      []extension.OrderOption
	inters     []Interceptor
	predicates []predicate.Extension
	modifiers  []func(*sql.Selector)
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the ExtensionQuery builder.
func (eq *ExtensionQuery) Where(ps ...predicate.Extension) *ExtensionQuery {
	eq.predicates = append(eq.predicates, ps...)
	return eq
}

// Limit the number of records to be returned by this query.
func (eq *ExtensionQuery) Limit(limit int) *ExtensionQuery {
	eq.ctx.Limit = &limit
	return eq
}

// Offset to start from.
func (eq *ExtensionQuery) Offset(offset int) *ExtensionQuery {
	eq.ctx.Offset = &offset
	return eq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (eq *ExtensionQuery) Unique(unique bool) *ExtensionQuery {
	eq.ctx.Unique = &unique
	return eq
}

// Order specifies how the records should be ordered.
func (eq *ExtensionQuery) Order(o ...extension.OrderOption) *ExtensionQuery {
	eq.order = append(eq.order, o...)
	return eq
}

// First returns the first Extension entity from the query.
// Returns a *NotFoundError when no Extension was found.
func (eq *ExtensionQuery) First(ctx context.Context) (*Extension, error) {
	nodes, err := eq.Limit(1).All(setContextOp(ctx, eq.ctx, ent.OpQueryFirst))
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{extension.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (eq *ExtensionQuery) FirstX(ctx context.Context) *Extension {
	node, err := eq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// FirstID returns the first Extension ID from the query.
// Returns a *NotFoundError when no Extension ID was found.
func (eq *ExtensionQuery) FirstID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = eq.Limit(1).IDs(setContextOp(ctx, eq.ctx, ent.OpQueryFirstID)); err != nil {
		return
	}
	if len(ids) == 0 {
		err = &NotFoundError{extension.Label}
		return
	}
	return ids[0], nil
}

// FirstIDX is like FirstID, but panics if an error occurs.
func (eq *ExtensionQuery) FirstIDX(ctx context.Context) uuid.UUID {
	id, err := eq.FirstID(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return id
}

// Only returns a single Extension entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one Extension entity is found.
// Returns a *NotFoundError when no Extension entities are found.
func (eq *ExtensionQuery) Only(ctx context.Context) (*Extension, error) {
	nodes, err := eq.Limit(2).All(setContextOp(ctx, eq.ctx, ent.OpQueryOnly))
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{extension.Label}
	default:
		return nil, &NotSingularError{extension.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (eq *ExtensionQuery) OnlyX(ctx context.Context) *Extension {
	node, err := eq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// OnlyID is like Only, but returns the only Extension ID in the query.
// Returns a *NotSingularError when more than one Extension ID is found.
// Returns a *NotFoundError when no entities are found.
func (eq *ExtensionQuery) OnlyID(ctx context.Context) (id uuid.UUID, err error) {
	var ids []uuid.UUID
	if ids, err = eq.Limit(2).IDs(setContextOp(ctx, eq.ctx, ent.OpQueryOnlyID)); err != nil {
		return
	}
	switch len(ids) {
	case 1:
		id = ids[0]
	case 0:
		err = &NotFoundError{extension.Label}
	default:
		err = &NotSingularError{extension.Label}
	}
	return
}

// OnlyIDX is like OnlyID, but panics if an error occurs.
func (eq *ExtensionQuery) OnlyIDX(ctx context.Context) uuid.UUID {
	id, err := eq.OnlyID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// All executes the query and returns a list of Extensions.
func (eq *ExtensionQuery) All(ctx context.Context) ([]*Extension, error) {
	ctx = setContextOp(ctx, eq.ctx, ent.OpQueryAll)
	if err := eq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	qr := querierAll[[]*Extension, *ExtensionQuery]()
	return withInterceptors[[]*Extension](ctx, eq, qr, eq.inters)
}

// AllX is like All, but panics if an error occurs.
func (eq *ExtensionQuery) AllX(ctx context.Context) []*Extension {
	nodes, err := eq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// IDs executes the query and returns a list of Extension IDs.
func (eq *ExtensionQuery) IDs(ctx context.Context) (ids []uuid.UUID, err error) {
	if eq.ctx.Unique == nil && eq.path != nil {
		eq.Unique(true)
	}
	ctx = setContextOp(ctx, eq.ctx, ent.OpQueryIDs)
	if err = eq.Select(extension.FieldID).Scan(ctx, &ids); err != nil {
		return nil, err
	}
	return ids, nil
}

// IDsX is like IDs, but panics if an error occurs.
func (eq *ExtensionQuery) IDsX(ctx context.Context) []uuid.UUID {
	ids, err := eq.IDs(ctx)
	if err != nil {
		panic(err)
	}
	return ids
}

// Count returns the count of the given query.
func (eq *ExtensionQuery) Count(ctx context.Context) (int, error) {
	ctx = setContextOp(ctx, eq.ctx, ent.OpQueryCount)
	if err := eq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return withInterceptors[int](ctx, eq, querierCount[*ExtensionQuery](), eq.inters)
}

// CountX is like Count, but panics if an error occurs.
func (eq *ExtensionQuery) CountX(ctx context.Context) int {
	count, err := eq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (eq *ExtensionQuery) Exist(ctx context.Context) (bool, error) {
	ctx = setContextOp(ctx, eq.ctx, ent.OpQueryExist)
	switch _, err := eq.FirstID(ctx); {
	case IsNotFound(err):
		return false, nil
	case err != nil:
		return false, fmt.Errorf("db: check existence: %w", err)
	default:
		return true, nil
	}
}

// ExistX is like Exist, but panics if an error occurs.
func (eq *ExtensionQuery) ExistX(ctx context.Context) bool {
	exist, err := eq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the ExtensionQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (eq *ExtensionQuery) Clone() *ExtensionQuery {
	if eq == nil {
		return nil
	}
	return &ExtensionQuery{
		config:     eq.config,
		ctx:        eq.ctx.Clone(),
		order:      append([]extension.OrderOption{}, eq.order...),
		inters:     append([]Interceptor{}, eq.inters...),
		predicates: append([]predicate.Extension{}, eq.predicates...),
		// clone intermediate query.
		sql:       eq.sql.Clone(),
		path:      eq.path,
		modifiers: append([]func(*sql.Selector){}, eq.modifiers...),
	}
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		Version string `json:"version,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.Extension.Query().
//		GroupBy(extension.FieldVersion).
//		Aggregate(db.Count()).
//		Scan(ctx, &v)
func (eq *ExtensionQuery) GroupBy(field string, fields ...string) *ExtensionGroupBy {
	eq.ctx.Fields = append([]string{field}, fields...)
	grbuild := &ExtensionGroupBy{build: eq}
	grbuild.flds = &eq.ctx.Fields
	grbuild.label = extension.Label
	grbuild.scan = grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		Version string `json:"version,omitempty"`
//	}
//
//	client.Extension.Query().
//		Select(extension.FieldVersion).
//		Scan(ctx, &v)
func (eq *ExtensionQuery) Select(fields ...string) *ExtensionSelect {
	eq.ctx.Fields = append(eq.ctx.Fields, fields...)
	sbuild := &ExtensionSelect{ExtensionQuery: eq}
	sbuild.label = extension.Label
	sbuild.flds, sbuild.scan = &eq.ctx.Fields, sbuild.Scan
	return sbuild
}

// Aggregate returns a ExtensionSelect configured with the given aggregations.
func (eq *ExtensionQuery) Aggregate(fns ...AggregateFunc) *ExtensionSelect {
	return eq.Select().Aggregate(fns...)
}

func (eq *ExtensionQuery) prepareQuery(ctx context.Context) error {
	for _, inter := range eq.inters {
		if inter == nil {
			return fmt.Errorf("db: uninitialized interceptor (forgotten import db/runtime?)")
		}
		if trv, ok := inter.(Traverser); ok {
			if err := trv.Traverse(ctx, eq); err != nil {
				return err
			}
		}
	}
	for _, f := range eq.ctx.Fields {
		if !extension.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
		}
	}
	if eq.path != nil {
		prev, err := eq.path(ctx)
		if err != nil {
			return err
		}
		eq.sql = prev
	}
	return nil
}

func (eq *ExtensionQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*Extension, error) {
	var (
		nodes = []*Extension{}
		_spec = eq.querySpec()
	)
	_spec.ScanValues = func(columns []string) ([]any, error) {
		return (*Extension).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []any) error {
		node := &Extension{config: eq.config}
		nodes = append(nodes, node)
		return node.assignValues(columns, values)
	}
	if len(eq.modifiers) > 0 {
		_spec.Modifiers = eq.modifiers
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, eq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	return nodes, nil
}

func (eq *ExtensionQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := eq.querySpec()
	if len(eq.modifiers) > 0 {
		_spec.Modifiers = eq.modifiers
	}
	_spec.Node.Columns = eq.ctx.Fields
	if len(eq.ctx.Fields) > 0 {
		_spec.Unique = eq.ctx.Unique != nil && *eq.ctx.Unique
	}
	return sqlgraph.CountNodes(ctx, eq.driver, _spec)
}

func (eq *ExtensionQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := sqlgraph.NewQuerySpec(extension.Table, extension.Columns, sqlgraph.NewFieldSpec(extension.FieldID, field.TypeUUID))
	_spec.From = eq.sql
	if unique := eq.ctx.Unique; unique != nil {
		_spec.Unique = *unique
	} else if eq.path != nil {
		_spec.Unique = true
	}
	if fields := eq.ctx.Fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, extension.FieldID)
		for i := range fields {
			if fields[i] != extension.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
			}
		}
	}
	if ps := eq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := eq.ctx.Limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := eq.ctx.Offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := eq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (eq *ExtensionQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(eq.driver.Dialect())
	t1 := builder.Table(extension.Table)
	columns := eq.ctx.Fields
	if len(columns) == 0 {
		columns = extension.Columns
	}
	selector := builder.Select(t1.Columns(columns...)...).From(t1)
	if eq.sql != nil {
		selector = eq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if eq.ctx.Unique != nil && *eq.ctx.Unique {
		selector.Distinct()
	}
	for _, m := range eq.modifiers {
		m(selector)
	}
	for _, p := range eq.predicates {
		p(selector)
	}
	for _, p := range eq.order {
		p(selector)
	}
	if offset := eq.ctx.Offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := eq.ctx.Limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// ForUpdate locks the selected rows against concurrent updates, and prevent them from being
// updated, deleted or "selected ... for update" by other sessions, until the transaction is
// either committed or rolled-back.
func (eq *ExtensionQuery) ForUpdate(opts ...sql.LockOption) *ExtensionQuery {
	if eq.driver.Dialect() == dialect.Postgres {
		eq.Unique(false)
	}
	eq.modifiers = append(eq.modifiers, func(s *sql.Selector) {
		s.ForUpdate(opts...)
	})
	return eq
}

// ForShare behaves similarly to ForUpdate, except that it acquires a shared mode lock
// on any rows that are read. Other sessions can read the rows, but cannot modify them
// until your transaction commits.
func (eq *ExtensionQuery) ForShare(opts ...sql.LockOption) *ExtensionQuery {
	if eq.driver.Dialect() == dialect.Postgres {
		eq.Unique(false)
	}
	eq.modifiers = append(eq.modifiers, func(s *sql.Selector) {
		s.ForShare(opts...)
	})
	return eq
}

// Modify adds a query modifier for attaching custom logic to queries.
func (eq *ExtensionQuery) Modify(modifiers ...func(s *sql.Selector)) *ExtensionSelect {
	eq.modifiers = append(eq.modifiers, modifiers...)
	return eq.Select()
}

// ExtensionGroupBy is the group-by builder for Extension entities.
type ExtensionGroupBy struct {
	selector
	build *ExtensionQuery
}

// Aggregate adds the given aggregation functions to the group-by query.
func (egb *ExtensionGroupBy) Aggregate(fns ...AggregateFunc) *ExtensionGroupBy {
	egb.fns = append(egb.fns, fns...)
	return egb
}

// Scan applies the selector query and scans the result into the given value.
func (egb *ExtensionGroupBy) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, egb.build.ctx, ent.OpQueryGroupBy)
	if err := egb.build.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*ExtensionQuery, *ExtensionGroupBy](ctx, egb.build, egb, egb.build.inters, v)
}

func (egb *ExtensionGroupBy) sqlScan(ctx context.Context, root *ExtensionQuery, v any) error {
	selector := root.sqlQuery(ctx).Select()
	aggregation := make([]string, 0, len(egb.fns))
	for _, fn := range egb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(*egb.flds)+len(egb.fns))
		for _, f := range *egb.flds {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	selector.GroupBy(selector.Columns(*egb.flds...)...)
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := egb.build.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// ExtensionSelect is the builder for selecting fields of Extension entities.
type ExtensionSelect struct {
	*ExtensionQuery
	selector
}

// Aggregate adds the given aggregation functions to the selector query.
func (es *ExtensionSelect) Aggregate(fns ...AggregateFunc) *ExtensionSelect {
	es.fns = append(es.fns, fns...)
	return es
}

// Scan applies the selector query and scans the result into the given value.
func (es *ExtensionSelect) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, es.ctx, ent.OpQuerySelect)
	if err := es.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*ExtensionQuery, *ExtensionSelect](ctx, es.ExtensionQuery, es, es.inters, v)
}

func (es *ExtensionSelect) sqlScan(ctx context.Context, root *ExtensionQuery, v any) error {
	selector := root.sqlQuery(ctx)
	aggregation := make([]string, 0, len(es.fns))
	for _, fn := range es.fns {
		aggregation = append(aggregation, fn(selector))
	}
	switch n := len(*es.selector.flds); {
	case n == 0 && len(aggregation) > 0:
		selector.Select(aggregation...)
	case n != 0 && len(aggregation) > 0:
		selector.AppendSelect(aggregation...)
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := es.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// Modify adds a query modifier for attaching custom logic to queries.
func (es *ExtensionSelect) Modify(modifiers ...func(s *sql.Selector)) *ExtensionSelect {
	es.modifiers = append(es.modifiers, modifiers...)
	return es
}
