// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/invitecode"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
)

// InviteCodeDelete is the builder for deleting a InviteCode entity.
type InviteCodeDelete struct {
	config
	hooks    []Hook
	mutation *InviteCodeMutation
}

// Where appends a list predicates to the InviteCodeDelete builder.
func (icd *InviteCodeDelete) Where(ps ...predicate.InviteCode) *InviteCodeDelete {
	icd.mutation.Where(ps...)
	return icd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (icd *InviteCodeDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, icd.sqlExec, icd.mutation, icd.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (icd *InviteCodeDelete) ExecX(ctx context.Context) int {
	n, err := icd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (icd *InviteCodeDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(invitecode.Table, sqlgraph.NewFieldSpec(invitecode.FieldID, field.TypeUUID))
	if ps := icd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, icd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	icd.mutation.done = true
	return affected, err
}

// InviteCodeDeleteOne is the builder for deleting a single InviteCode entity.
type InviteCodeDeleteOne struct {
	icd *InviteCodeDelete
}

// Where appends a list predicates to the InviteCodeDelete builder.
func (icdo *InviteCodeDeleteOne) Where(ps ...predicate.InviteCode) *InviteCodeDeleteOne {
	icdo.icd.mutation.Where(ps...)
	return icdo
}

// Exec executes the deletion query.
func (icdo *InviteCodeDeleteOne) Exec(ctx context.Context) error {
	n, err := icdo.icd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{invitecode.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (icdo *InviteCodeDeleteOne) ExecX(ctx context.Context) {
	if err := icdo.Exec(ctx); err != nil {
		panic(err)
	}
}
