// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/invitecode"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/google/uuid"
)

// InviteCodeUpdate is the builder for updating InviteCode entities.
type InviteCodeUpdate struct {
	config
	hooks     []Hook
	mutation  *InviteCodeMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the InviteCodeUpdate builder.
func (icu *InviteCodeUpdate) Where(ps ...predicate.InviteCode) *InviteCodeUpdate {
	icu.mutation.Where(ps...)
	return icu
}

// SetAdminID sets the "admin_id" field.
func (icu *InviteCodeUpdate) SetAdminID(u uuid.UUID) *InviteCodeUpdate {
	icu.mutation.SetAdminID(u)
	return icu
}

// SetNillableAdminID sets the "admin_id" field if the given value is not nil.
func (icu *InviteCodeUpdate) SetNillableAdminID(u *uuid.UUID) *InviteCodeUpdate {
	if u != nil {
		icu.SetAdminID(*u)
	}
	return icu
}

// SetCode sets the "code" field.
func (icu *InviteCodeUpdate) SetCode(s string) *InviteCodeUpdate {
	icu.mutation.SetCode(s)
	return icu
}

// SetNillableCode sets the "code" field if the given value is not nil.
func (icu *InviteCodeUpdate) SetNillableCode(s *string) *InviteCodeUpdate {
	if s != nil {
		icu.SetCode(*s)
	}
	return icu
}

// SetStatus sets the "status" field.
func (icu *InviteCodeUpdate) SetStatus(ccs consts.InviteCodeStatus) *InviteCodeUpdate {
	icu.mutation.SetStatus(ccs)
	return icu
}

// SetNillableStatus sets the "status" field if the given value is not nil.
func (icu *InviteCodeUpdate) SetNillableStatus(ccs *consts.InviteCodeStatus) *InviteCodeUpdate {
	if ccs != nil {
		icu.SetStatus(*ccs)
	}
	return icu
}

// SetCreatedAt sets the "created_at" field.
func (icu *InviteCodeUpdate) SetCreatedAt(t time.Time) *InviteCodeUpdate {
	icu.mutation.SetCreatedAt(t)
	return icu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (icu *InviteCodeUpdate) SetNillableCreatedAt(t *time.Time) *InviteCodeUpdate {
	if t != nil {
		icu.SetCreatedAt(*t)
	}
	return icu
}

// SetUpdatedAt sets the "updated_at" field.
func (icu *InviteCodeUpdate) SetUpdatedAt(t time.Time) *InviteCodeUpdate {
	icu.mutation.SetUpdatedAt(t)
	return icu
}

// SetExpiredAt sets the "expired_at" field.
func (icu *InviteCodeUpdate) SetExpiredAt(t time.Time) *InviteCodeUpdate {
	icu.mutation.SetExpiredAt(t)
	return icu
}

// SetNillableExpiredAt sets the "expired_at" field if the given value is not nil.
func (icu *InviteCodeUpdate) SetNillableExpiredAt(t *time.Time) *InviteCodeUpdate {
	if t != nil {
		icu.SetExpiredAt(*t)
	}
	return icu
}

// Mutation returns the InviteCodeMutation object of the builder.
func (icu *InviteCodeUpdate) Mutation() *InviteCodeMutation {
	return icu.mutation
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (icu *InviteCodeUpdate) Save(ctx context.Context) (int, error) {
	icu.defaults()
	return withHooks(ctx, icu.sqlSave, icu.mutation, icu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (icu *InviteCodeUpdate) SaveX(ctx context.Context) int {
	affected, err := icu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (icu *InviteCodeUpdate) Exec(ctx context.Context) error {
	_, err := icu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (icu *InviteCodeUpdate) ExecX(ctx context.Context) {
	if err := icu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (icu *InviteCodeUpdate) defaults() {
	if _, ok := icu.mutation.UpdatedAt(); !ok {
		v := invitecode.UpdateDefaultUpdatedAt()
		icu.mutation.SetUpdatedAt(v)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (icu *InviteCodeUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *InviteCodeUpdate {
	icu.modifiers = append(icu.modifiers, modifiers...)
	return icu
}

func (icu *InviteCodeUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(invitecode.Table, invitecode.Columns, sqlgraph.NewFieldSpec(invitecode.FieldID, field.TypeUUID))
	if ps := icu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := icu.mutation.AdminID(); ok {
		_spec.SetField(invitecode.FieldAdminID, field.TypeUUID, value)
	}
	if value, ok := icu.mutation.Code(); ok {
		_spec.SetField(invitecode.FieldCode, field.TypeString, value)
	}
	if value, ok := icu.mutation.Status(); ok {
		_spec.SetField(invitecode.FieldStatus, field.TypeString, value)
	}
	if value, ok := icu.mutation.CreatedAt(); ok {
		_spec.SetField(invitecode.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := icu.mutation.UpdatedAt(); ok {
		_spec.SetField(invitecode.FieldUpdatedAt, field.TypeTime, value)
	}
	if value, ok := icu.mutation.ExpiredAt(); ok {
		_spec.SetField(invitecode.FieldExpiredAt, field.TypeTime, value)
	}
	_spec.AddModifiers(icu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, icu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{invitecode.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	icu.mutation.done = true
	return n, nil
}

// InviteCodeUpdateOne is the builder for updating a single InviteCode entity.
type InviteCodeUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *InviteCodeMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetAdminID sets the "admin_id" field.
func (icuo *InviteCodeUpdateOne) SetAdminID(u uuid.UUID) *InviteCodeUpdateOne {
	icuo.mutation.SetAdminID(u)
	return icuo
}

// SetNillableAdminID sets the "admin_id" field if the given value is not nil.
func (icuo *InviteCodeUpdateOne) SetNillableAdminID(u *uuid.UUID) *InviteCodeUpdateOne {
	if u != nil {
		icuo.SetAdminID(*u)
	}
	return icuo
}

// SetCode sets the "code" field.
func (icuo *InviteCodeUpdateOne) SetCode(s string) *InviteCodeUpdateOne {
	icuo.mutation.SetCode(s)
	return icuo
}

// SetNillableCode sets the "code" field if the given value is not nil.
func (icuo *InviteCodeUpdateOne) SetNillableCode(s *string) *InviteCodeUpdateOne {
	if s != nil {
		icuo.SetCode(*s)
	}
	return icuo
}

// SetStatus sets the "status" field.
func (icuo *InviteCodeUpdateOne) SetStatus(ccs consts.InviteCodeStatus) *InviteCodeUpdateOne {
	icuo.mutation.SetStatus(ccs)
	return icuo
}

// SetNillableStatus sets the "status" field if the given value is not nil.
func (icuo *InviteCodeUpdateOne) SetNillableStatus(ccs *consts.InviteCodeStatus) *InviteCodeUpdateOne {
	if ccs != nil {
		icuo.SetStatus(*ccs)
	}
	return icuo
}

// SetCreatedAt sets the "created_at" field.
func (icuo *InviteCodeUpdateOne) SetCreatedAt(t time.Time) *InviteCodeUpdateOne {
	icuo.mutation.SetCreatedAt(t)
	return icuo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (icuo *InviteCodeUpdateOne) SetNillableCreatedAt(t *time.Time) *InviteCodeUpdateOne {
	if t != nil {
		icuo.SetCreatedAt(*t)
	}
	return icuo
}

// SetUpdatedAt sets the "updated_at" field.
func (icuo *InviteCodeUpdateOne) SetUpdatedAt(t time.Time) *InviteCodeUpdateOne {
	icuo.mutation.SetUpdatedAt(t)
	return icuo
}

// SetExpiredAt sets the "expired_at" field.
func (icuo *InviteCodeUpdateOne) SetExpiredAt(t time.Time) *InviteCodeUpdateOne {
	icuo.mutation.SetExpiredAt(t)
	return icuo
}

// SetNillableExpiredAt sets the "expired_at" field if the given value is not nil.
func (icuo *InviteCodeUpdateOne) SetNillableExpiredAt(t *time.Time) *InviteCodeUpdateOne {
	if t != nil {
		icuo.SetExpiredAt(*t)
	}
	return icuo
}

// Mutation returns the InviteCodeMutation object of the builder.
func (icuo *InviteCodeUpdateOne) Mutation() *InviteCodeMutation {
	return icuo.mutation
}

// Where appends a list predicates to the InviteCodeUpdate builder.
func (icuo *InviteCodeUpdateOne) Where(ps ...predicate.InviteCode) *InviteCodeUpdateOne {
	icuo.mutation.Where(ps...)
	return icuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (icuo *InviteCodeUpdateOne) Select(field string, fields ...string) *InviteCodeUpdateOne {
	icuo.fields = append([]string{field}, fields...)
	return icuo
}

// Save executes the query and returns the updated InviteCode entity.
func (icuo *InviteCodeUpdateOne) Save(ctx context.Context) (*InviteCode, error) {
	icuo.defaults()
	return withHooks(ctx, icuo.sqlSave, icuo.mutation, icuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (icuo *InviteCodeUpdateOne) SaveX(ctx context.Context) *InviteCode {
	node, err := icuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (icuo *InviteCodeUpdateOne) Exec(ctx context.Context) error {
	_, err := icuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (icuo *InviteCodeUpdateOne) ExecX(ctx context.Context) {
	if err := icuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (icuo *InviteCodeUpdateOne) defaults() {
	if _, ok := icuo.mutation.UpdatedAt(); !ok {
		v := invitecode.UpdateDefaultUpdatedAt()
		icuo.mutation.SetUpdatedAt(v)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (icuo *InviteCodeUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *InviteCodeUpdateOne {
	icuo.modifiers = append(icuo.modifiers, modifiers...)
	return icuo
}

func (icuo *InviteCodeUpdateOne) sqlSave(ctx context.Context) (_node *InviteCode, err error) {
	_spec := sqlgraph.NewUpdateSpec(invitecode.Table, invitecode.Columns, sqlgraph.NewFieldSpec(invitecode.FieldID, field.TypeUUID))
	id, ok := icuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "InviteCode.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := icuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, invitecode.FieldID)
		for _, f := range fields {
			if !invitecode.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != invitecode.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := icuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := icuo.mutation.AdminID(); ok {
		_spec.SetField(invitecode.FieldAdminID, field.TypeUUID, value)
	}
	if value, ok := icuo.mutation.Code(); ok {
		_spec.SetField(invitecode.FieldCode, field.TypeString, value)
	}
	if value, ok := icuo.mutation.Status(); ok {
		_spec.SetField(invitecode.FieldStatus, field.TypeString, value)
	}
	if value, ok := icuo.mutation.CreatedAt(); ok {
		_spec.SetField(invitecode.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := icuo.mutation.UpdatedAt(); ok {
		_spec.SetField(invitecode.FieldUpdatedAt, field.TypeTime, value)
	}
	if value, ok := icuo.mutation.ExpiredAt(); ok {
		_spec.SetField(invitecode.FieldExpiredAt, field.TypeTime, value)
	}
	_spec.AddModifiers(icuo.modifiers...)
	_node = &InviteCode{config: icuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, icuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{invitecode.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	icuo.mutation.done = true
	return _node, nil
}
