// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/license"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
)

// LicenseUpdate is the builder for updating License entities.
type LicenseUpdate struct {
	config
	hooks     []Hook
	mutation  *LicenseMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the LicenseUpdate builder.
func (lu *LicenseUpdate) Where(ps ...predicate.License) *LicenseUpdate {
	lu.mutation.Where(ps...)
	return lu
}

// SetType sets the "type" field.
func (lu *LicenseUpdate) SetType(ct consts.LicenseType) *LicenseUpdate {
	lu.mutation.SetType(ct)
	return lu
}

// SetNillableType sets the "type" field if the given value is not nil.
func (lu *LicenseUpdate) SetNillableType(ct *consts.LicenseType) *LicenseUpdate {
	if ct != nil {
		lu.SetType(*ct)
	}
	return lu
}

// SetData sets the "data" field.
func (lu *LicenseUpdate) SetData(b []byte) *LicenseUpdate {
	lu.mutation.SetData(b)
	return lu
}

// ClearData clears the value of the "data" field.
func (lu *LicenseUpdate) ClearData() *LicenseUpdate {
	lu.mutation.ClearData()
	return lu
}

// SetCode sets the "code" field.
func (lu *LicenseUpdate) SetCode(s string) *LicenseUpdate {
	lu.mutation.SetCode(s)
	return lu
}

// SetNillableCode sets the "code" field if the given value is not nil.
func (lu *LicenseUpdate) SetNillableCode(s *string) *LicenseUpdate {
	if s != nil {
		lu.SetCode(*s)
	}
	return lu
}

// ClearCode clears the value of the "code" field.
func (lu *LicenseUpdate) ClearCode() *LicenseUpdate {
	lu.mutation.ClearCode()
	return lu
}

// SetCreatedAt sets the "created_at" field.
func (lu *LicenseUpdate) SetCreatedAt(t time.Time) *LicenseUpdate {
	lu.mutation.SetCreatedAt(t)
	return lu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (lu *LicenseUpdate) SetNillableCreatedAt(t *time.Time) *LicenseUpdate {
	if t != nil {
		lu.SetCreatedAt(*t)
	}
	return lu
}

// Mutation returns the LicenseMutation object of the builder.
func (lu *LicenseUpdate) Mutation() *LicenseMutation {
	return lu.mutation
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (lu *LicenseUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, lu.sqlSave, lu.mutation, lu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (lu *LicenseUpdate) SaveX(ctx context.Context) int {
	affected, err := lu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (lu *LicenseUpdate) Exec(ctx context.Context) error {
	_, err := lu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (lu *LicenseUpdate) ExecX(ctx context.Context) {
	if err := lu.Exec(ctx); err != nil {
		panic(err)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (lu *LicenseUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *LicenseUpdate {
	lu.modifiers = append(lu.modifiers, modifiers...)
	return lu
}

func (lu *LicenseUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(license.Table, license.Columns, sqlgraph.NewFieldSpec(license.FieldID, field.TypeInt))
	if ps := lu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := lu.mutation.GetType(); ok {
		_spec.SetField(license.FieldType, field.TypeString, value)
	}
	if value, ok := lu.mutation.Data(); ok {
		_spec.SetField(license.FieldData, field.TypeBytes, value)
	}
	if lu.mutation.DataCleared() {
		_spec.ClearField(license.FieldData, field.TypeBytes)
	}
	if value, ok := lu.mutation.Code(); ok {
		_spec.SetField(license.FieldCode, field.TypeString, value)
	}
	if lu.mutation.CodeCleared() {
		_spec.ClearField(license.FieldCode, field.TypeString)
	}
	if value, ok := lu.mutation.CreatedAt(); ok {
		_spec.SetField(license.FieldCreatedAt, field.TypeTime, value)
	}
	_spec.AddModifiers(lu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, lu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{license.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	lu.mutation.done = true
	return n, nil
}

// LicenseUpdateOne is the builder for updating a single License entity.
type LicenseUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *LicenseMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetType sets the "type" field.
func (luo *LicenseUpdateOne) SetType(ct consts.LicenseType) *LicenseUpdateOne {
	luo.mutation.SetType(ct)
	return luo
}

// SetNillableType sets the "type" field if the given value is not nil.
func (luo *LicenseUpdateOne) SetNillableType(ct *consts.LicenseType) *LicenseUpdateOne {
	if ct != nil {
		luo.SetType(*ct)
	}
	return luo
}

// SetData sets the "data" field.
func (luo *LicenseUpdateOne) SetData(b []byte) *LicenseUpdateOne {
	luo.mutation.SetData(b)
	return luo
}

// ClearData clears the value of the "data" field.
func (luo *LicenseUpdateOne) ClearData() *LicenseUpdateOne {
	luo.mutation.ClearData()
	return luo
}

// SetCode sets the "code" field.
func (luo *LicenseUpdateOne) SetCode(s string) *LicenseUpdateOne {
	luo.mutation.SetCode(s)
	return luo
}

// SetNillableCode sets the "code" field if the given value is not nil.
func (luo *LicenseUpdateOne) SetNillableCode(s *string) *LicenseUpdateOne {
	if s != nil {
		luo.SetCode(*s)
	}
	return luo
}

// ClearCode clears the value of the "code" field.
func (luo *LicenseUpdateOne) ClearCode() *LicenseUpdateOne {
	luo.mutation.ClearCode()
	return luo
}

// SetCreatedAt sets the "created_at" field.
func (luo *LicenseUpdateOne) SetCreatedAt(t time.Time) *LicenseUpdateOne {
	luo.mutation.SetCreatedAt(t)
	return luo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (luo *LicenseUpdateOne) SetNillableCreatedAt(t *time.Time) *LicenseUpdateOne {
	if t != nil {
		luo.SetCreatedAt(*t)
	}
	return luo
}

// Mutation returns the LicenseMutation object of the builder.
func (luo *LicenseUpdateOne) Mutation() *LicenseMutation {
	return luo.mutation
}

// Where appends a list predicates to the LicenseUpdate builder.
func (luo *LicenseUpdateOne) Where(ps ...predicate.License) *LicenseUpdateOne {
	luo.mutation.Where(ps...)
	return luo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (luo *LicenseUpdateOne) Select(field string, fields ...string) *LicenseUpdateOne {
	luo.fields = append([]string{field}, fields...)
	return luo
}

// Save executes the query and returns the updated License entity.
func (luo *LicenseUpdateOne) Save(ctx context.Context) (*License, error) {
	return withHooks(ctx, luo.sqlSave, luo.mutation, luo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (luo *LicenseUpdateOne) SaveX(ctx context.Context) *License {
	node, err := luo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (luo *LicenseUpdateOne) Exec(ctx context.Context) error {
	_, err := luo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (luo *LicenseUpdateOne) ExecX(ctx context.Context) {
	if err := luo.Exec(ctx); err != nil {
		panic(err)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (luo *LicenseUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *LicenseUpdateOne {
	luo.modifiers = append(luo.modifiers, modifiers...)
	return luo
}

func (luo *LicenseUpdateOne) sqlSave(ctx context.Context) (_node *License, err error) {
	_spec := sqlgraph.NewUpdateSpec(license.Table, license.Columns, sqlgraph.NewFieldSpec(license.FieldID, field.TypeInt))
	id, ok := luo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "License.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := luo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, license.FieldID)
		for _, f := range fields {
			if !license.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != license.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := luo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := luo.mutation.GetType(); ok {
		_spec.SetField(license.FieldType, field.TypeString, value)
	}
	if value, ok := luo.mutation.Data(); ok {
		_spec.SetField(license.FieldData, field.TypeBytes, value)
	}
	if luo.mutation.DataCleared() {
		_spec.ClearField(license.FieldData, field.TypeBytes)
	}
	if value, ok := luo.mutation.Code(); ok {
		_spec.SetField(license.FieldCode, field.TypeString, value)
	}
	if luo.mutation.CodeCleared() {
		_spec.ClearField(license.FieldCode, field.TypeString)
	}
	if value, ok := luo.mutation.CreatedAt(); ok {
		_spec.SetField(license.FieldCreatedAt, field.TypeTime, value)
	}
	_spec.AddModifiers(luo.modifiers...)
	_node = &License{config: luo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, luo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{license.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	luo.mutation.done = true
	return _node, nil
}
