// Code generated by ent, DO NOT EDIT.

package migrate

import (
	"entgo.io/ent/dialect/entsql"
	"entgo.io/ent/dialect/sql/schema"
	"entgo.io/ent/schema/field"
)

var (
	// AiEmployeesColumns holds the columns for the "ai_employees" table.
	AiEmployeesColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "name", Type: field.TypeString},
		{Name: "position", Type: field.TypeString},
		{Name: "repository_url", Type: field.TypeString},
		{Name: "repository_user", Type: field.TypeString},
		{Name: "platform", Type: field.TypeString},
		{Name: "token", Type: field.TypeString},
		{Name: "webhook_secret", Type: field.TypeString},
		{Name: "webhook_url", Type: field.TypeString},
		{Name: "created_by", Type: field.TypeString},
		{Name: "parameters", Type: field.TypeJSON},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
		{Name: "admin_id", Type: field.TypeUUID, Nullable: true},
		{Name: "user_id", Type: field.TypeUUID, Nullable: true},
	}
	// AiEmployeesTable holds the schema information for the "ai_employees" table.
	AiEmployeesTable = &schema.Table{
		Name:       "ai_employees",
		Columns:    AiEmployeesColumns,
		PrimaryKey: []*schema.Column{AiEmployeesColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "ai_employees_admins_aiemployees",
				Columns:    []*schema.Column{AiEmployeesColumns[13]},
				RefColumns: []*schema.Column{AdminsColumns[0]},
				OnDelete:   schema.SetNull,
			},
			{
				Symbol:     "ai_employees_users_aiemployees",
				Columns:    []*schema.Column{AiEmployeesColumns[14]},
				RefColumns: []*schema.Column{UsersColumns[0]},
				OnDelete:   schema.SetNull,
			},
		},
	}
	// AiTasksColumns holds the columns for the "ai_tasks" table.
	AiTasksColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "employee_id", Type: field.TypeUUID},
		{Name: "status", Type: field.TypeString, Default: "pending"},
		{Name: "output", Type: field.TypeString, Nullable: true, Size: 2147483647},
		{Name: "logs", Type: field.TypeString, Nullable: true, Size: 2147483647},
		{Name: "error_message", Type: field.TypeString, Nullable: true, Size: 2147483647},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
	}
	// AiTasksTable holds the schema information for the "ai_tasks" table.
	AiTasksTable = &schema.Table{
		Name:       "ai_tasks",
		Columns:    AiTasksColumns,
		PrimaryKey: []*schema.Column{AiTasksColumns[0]},
	}
	// AdminsColumns holds the columns for the "admins" table.
	AdminsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "username", Type: field.TypeString, Unique: true},
		{Name: "password", Type: field.TypeString},
		{Name: "status", Type: field.TypeString},
		{Name: "last_active_at", Type: field.TypeTime},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
	}
	// AdminsTable holds the schema information for the "admins" table.
	AdminsTable = &schema.Table{
		Name:       "admins",
		Columns:    AdminsColumns,
		PrimaryKey: []*schema.Column{AdminsColumns[0]},
	}
	// AdminLoginHistoriesColumns holds the columns for the "admin_login_histories" table.
	AdminLoginHistoriesColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "ip", Type: field.TypeString},
		{Name: "country", Type: field.TypeString},
		{Name: "province", Type: field.TypeString},
		{Name: "city", Type: field.TypeString},
		{Name: "isp", Type: field.TypeString, Nullable: true},
		{Name: "asn", Type: field.TypeString, Nullable: true},
		{Name: "client_version", Type: field.TypeString, Nullable: true},
		{Name: "device", Type: field.TypeString, Nullable: true},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "admin_id", Type: field.TypeUUID, Nullable: true},
	}
	// AdminLoginHistoriesTable holds the schema information for the "admin_login_histories" table.
	AdminLoginHistoriesTable = &schema.Table{
		Name:       "admin_login_histories",
		Columns:    AdminLoginHistoriesColumns,
		PrimaryKey: []*schema.Column{AdminLoginHistoriesColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "admin_login_histories_admins_login_histories",
				Columns:    []*schema.Column{AdminLoginHistoriesColumns[10]},
				RefColumns: []*schema.Column{AdminsColumns[0]},
				OnDelete:   schema.SetNull,
			},
		},
	}
	// AdminRolesColumns holds the columns for the "admin_roles" table.
	AdminRolesColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "admin_id", Type: field.TypeUUID},
		{Name: "role_id", Type: field.TypeInt64},
	}
	// AdminRolesTable holds the schema information for the "admin_roles" table.
	AdminRolesTable = &schema.Table{
		Name:       "admin_roles",
		Columns:    AdminRolesColumns,
		PrimaryKey: []*schema.Column{AdminRolesColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "admin_roles_admins_admin",
				Columns:    []*schema.Column{AdminRolesColumns[1]},
				RefColumns: []*schema.Column{AdminsColumns[0]},
				OnDelete:   schema.NoAction,
			},
			{
				Symbol:     "admin_roles_roles_role",
				Columns:    []*schema.Column{AdminRolesColumns[2]},
				RefColumns: []*schema.Column{RolesColumns[0]},
				OnDelete:   schema.NoAction,
			},
		},
		Indexes: []*schema.Index{
			{
				Name:    "adminrole_role_id_admin_id",
				Unique:  true,
				Columns: []*schema.Column{AdminRolesColumns[2], AdminRolesColumns[1]},
			},
		},
	}
	// APIKeysColumns holds the columns for the "api_keys" table.
	APIKeysColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "key", Type: field.TypeString},
		{Name: "name", Type: field.TypeString},
		{Name: "status", Type: field.TypeString, Default: "active"},
		{Name: "last_used", Type: field.TypeTime, Nullable: true},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
		{Name: "user_id", Type: field.TypeUUID},
	}
	// APIKeysTable holds the schema information for the "api_keys" table.
	APIKeysTable = &schema.Table{
		Name:       "api_keys",
		Columns:    APIKeysColumns,
		PrimaryKey: []*schema.Column{APIKeysColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "api_keys_users_api_keys",
				Columns:    []*schema.Column{APIKeysColumns[7]},
				RefColumns: []*schema.Column{UsersColumns[0]},
				OnDelete:   schema.NoAction,
			},
		},
	}
	// BillingPlansColumns holds the columns for the "billing_plans" table.
	BillingPlansColumns = []*schema.Column{
		{Name: "id", Type: field.TypeString, Unique: true},
		{Name: "name", Type: field.TypeString, Unique: true},
		{Name: "description", Type: field.TypeString},
		{Name: "rules", Type: field.TypeJSON},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
	}
	// BillingPlansTable holds the schema information for the "billing_plans" table.
	BillingPlansTable = &schema.Table{
		Name:       "billing_plans",
		Columns:    BillingPlansColumns,
		PrimaryKey: []*schema.Column{BillingPlansColumns[0]},
	}
	// BillingQuotasColumns holds the columns for the "billing_quotas" table.
	BillingQuotasColumns = []*schema.Column{
		{Name: "id", Type: field.TypeString, Unique: true},
		{Name: "deleted_at", Type: field.TypeTime, Nullable: true},
		{Name: "user_id", Type: field.TypeString, Unique: true},
		{Name: "total", Type: field.TypeInt64},
		{Name: "used", Type: field.TypeInt64},
		{Name: "remain", Type: field.TypeInt64},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
	}
	// BillingQuotasTable holds the schema information for the "billing_quotas" table.
	BillingQuotasTable = &schema.Table{
		Name:       "billing_quotas",
		Columns:    BillingQuotasColumns,
		PrimaryKey: []*schema.Column{BillingQuotasColumns[0]},
	}
	// BillingRecordsColumns holds the columns for the "billing_records" table.
	BillingRecordsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeString, Unique: true},
		{Name: "tenant_id", Type: field.TypeString, Unique: true},
		{Name: "user_id", Type: field.TypeString, Unique: true},
		{Name: "model", Type: field.TypeString},
		{Name: "operation", Type: field.TypeString},
		{Name: "input_tokens", Type: field.TypeInt64},
		{Name: "output_tokens", Type: field.TypeInt64},
		{Name: "cost", Type: field.TypeInt64},
		{Name: "request_time", Type: field.TypeTime},
		{Name: "metadata", Type: field.TypeJSON},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
	}
	// BillingRecordsTable holds the schema information for the "billing_records" table.
	BillingRecordsTable = &schema.Table{
		Name:       "billing_records",
		Columns:    BillingRecordsColumns,
		PrimaryKey: []*schema.Column{BillingRecordsColumns[0]},
	}
	// BillingUsagesColumns holds the columns for the "billing_usages" table.
	BillingUsagesColumns = []*schema.Column{
		{Name: "id", Type: field.TypeString, Unique: true},
		{Name: "deleted_at", Type: field.TypeTime, Nullable: true},
		{Name: "user_id", Type: field.TypeString, Unique: true},
		{Name: "model_name", Type: field.TypeString},
		{Name: "tokens", Type: field.TypeInt64},
		{Name: "operation", Type: field.TypeString},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
	}
	// BillingUsagesTable holds the schema information for the "billing_usages" table.
	BillingUsagesTable = &schema.Table{
		Name:       "billing_usages",
		Columns:    BillingUsagesColumns,
		PrimaryKey: []*schema.Column{BillingUsagesColumns[0]},
	}
	// CodeSnippetsColumns holds the columns for the "code_snippets" table.
	CodeSnippetsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "name", Type: field.TypeString},
		{Name: "snippet_type", Type: field.TypeString},
		{Name: "language", Type: field.TypeString},
		{Name: "content", Type: field.TypeString, Size: 2147483647},
		{Name: "hash", Type: field.TypeString},
		{Name: "start_line", Type: field.TypeInt},
		{Name: "end_line", Type: field.TypeInt},
		{Name: "start_column", Type: field.TypeInt},
		{Name: "end_column", Type: field.TypeInt},
		{Name: "namespace", Type: field.TypeString, Nullable: true},
		{Name: "container_name", Type: field.TypeString, Nullable: true},
		{Name: "scope", Type: field.TypeJSON, Nullable: true},
		{Name: "dependencies", Type: field.TypeJSON, Nullable: true},
		{Name: "parameters", Type: field.TypeJSON, Nullable: true},
		{Name: "signature", Type: field.TypeString, Nullable: true, Size: 2147483647},
		{Name: "definition_text", Type: field.TypeString, Nullable: true, Size: 2147483647},
		{Name: "structured_info", Type: field.TypeJSON, Nullable: true},
		{Name: "embedding", Type: field.TypeOther, Nullable: true, SchemaType: map[string]string{"postgres": "vector(1024)"}},
		{Name: "workspace_path", Type: field.TypeString, Nullable: true},
		{Name: "workspace_file_id", Type: field.TypeUUID},
	}
	// CodeSnippetsTable holds the schema information for the "code_snippets" table.
	CodeSnippetsTable = &schema.Table{
		Name:       "code_snippets",
		Columns:    CodeSnippetsColumns,
		PrimaryKey: []*schema.Column{CodeSnippetsColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "code_snippets_workspace_files_snippets",
				Columns:    []*schema.Column{CodeSnippetsColumns[20]},
				RefColumns: []*schema.Column{WorkspaceFilesColumns[0]},
				OnDelete:   schema.NoAction,
			},
		},
		Indexes: []*schema.Index{
			{
				Name:    "codesnippet_hash",
				Unique:  false,
				Columns: []*schema.Column{CodeSnippetsColumns[5]},
			},
			{
				Name:    "codesnippet_workspace_file_id",
				Unique:  false,
				Columns: []*schema.Column{CodeSnippetsColumns[20]},
			},
			{
				Name:    "codesnippet_language_snippet_type",
				Unique:  false,
				Columns: []*schema.Column{CodeSnippetsColumns[3], CodeSnippetsColumns[2]},
			},
			{
				Name:    "codesnippet_language_name",
				Unique:  false,
				Columns: []*schema.Column{CodeSnippetsColumns[3], CodeSnippetsColumns[1]},
			},
			{
				Name:    "codesnippet_embedding",
				Unique:  false,
				Columns: []*schema.Column{CodeSnippetsColumns[18]},
				Annotation: &entsql.IndexAnnotation{
					OpClass: "vector_cosine_ops",
					Type:    "hnsw",
				},
			},
			{
				Name:    "codesnippet_workspace_path",
				Unique:  false,
				Columns: []*schema.Column{CodeSnippetsColumns[19]},
			},
		},
	}
	// ExtensionsColumns holds the columns for the "extensions" table.
	ExtensionsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "version", Type: field.TypeString},
		{Name: "path", Type: field.TypeString},
		{Name: "created_at", Type: field.TypeTime},
	}
	// ExtensionsTable holds the schema information for the "extensions" table.
	ExtensionsTable = &schema.Table{
		Name:       "extensions",
		Columns:    ExtensionsColumns,
		PrimaryKey: []*schema.Column{ExtensionsColumns[0]},
	}
	// InviteCodesColumns holds the columns for the "invite_codes" table.
	InviteCodesColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "admin_id", Type: field.TypeUUID},
		{Name: "code", Type: field.TypeString, Unique: true},
		{Name: "status", Type: field.TypeString, Default: "pending"},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
		{Name: "expired_at", Type: field.TypeTime},
	}
	// InviteCodesTable holds the schema information for the "invite_codes" table.
	InviteCodesTable = &schema.Table{
		Name:       "invite_codes",
		Columns:    InviteCodesColumns,
		PrimaryKey: []*schema.Column{InviteCodesColumns[0]},
	}
	// LicenseColumns holds the columns for the "license" table.
	LicenseColumns = []*schema.Column{
		{Name: "id", Type: field.TypeInt, Increment: true},
		{Name: "type", Type: field.TypeString},
		{Name: "data", Type: field.TypeBytes, Nullable: true},
		{Name: "code", Type: field.TypeString, Nullable: true},
		{Name: "created_at", Type: field.TypeTime},
	}
	// LicenseTable holds the schema information for the "license" table.
	LicenseTable = &schema.Table{
		Name:       "license",
		Columns:    LicenseColumns,
		PrimaryKey: []*schema.Column{LicenseColumns[0]},
	}
	// ModelsColumns holds the columns for the "models" table.
	ModelsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "model_name", Type: field.TypeString},
		{Name: "model_type", Type: field.TypeString},
		{Name: "show_name", Type: field.TypeString, Nullable: true},
		{Name: "api_base", Type: field.TypeString},
		{Name: "api_key", Type: field.TypeString, Nullable: true},
		{Name: "api_version", Type: field.TypeString, Nullable: true},
		{Name: "api_header", Type: field.TypeString, Nullable: true},
		{Name: "description", Type: field.TypeString, Nullable: true},
		{Name: "is_internal", Type: field.TypeBool, Default: false},
		{Name: "provider", Type: field.TypeString},
		{Name: "status", Type: field.TypeString, Default: "active"},
		{Name: "parameters", Type: field.TypeJSON, Nullable: true},
		{Name: "context_length", Type: field.TypeInt, Nullable: true},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
		{Name: "user_id", Type: field.TypeUUID, Nullable: true},
	}
	// ModelsTable holds the schema information for the "models" table.
	ModelsTable = &schema.Table{
		Name:       "models",
		Columns:    ModelsColumns,
		PrimaryKey: []*schema.Column{ModelsColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "models_users_models",
				Columns:    []*schema.Column{ModelsColumns[16]},
				RefColumns: []*schema.Column{UsersColumns[0]},
				OnDelete:   schema.SetNull,
			},
		},
	}
	// ModelProvidersColumns holds the columns for the "model_providers" table.
	ModelProvidersColumns = []*schema.Column{
		{Name: "id", Type: field.TypeString, Unique: true},
		{Name: "name", Type: field.TypeString},
		{Name: "api_base", Type: field.TypeString},
		{Name: "priority", Type: field.TypeInt, Default: 0},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
	}
	// ModelProvidersTable holds the schema information for the "model_providers" table.
	ModelProvidersTable = &schema.Table{
		Name:       "model_providers",
		Columns:    ModelProvidersColumns,
		PrimaryKey: []*schema.Column{ModelProvidersColumns[0]},
	}
	// ModelProviderModelsColumns holds the columns for the "model_provider_models" table.
	ModelProviderModelsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "name", Type: field.TypeString},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
		{Name: "provider_id", Type: field.TypeString, Nullable: true},
	}
	// ModelProviderModelsTable holds the schema information for the "model_provider_models" table.
	ModelProviderModelsTable = &schema.Table{
		Name:       "model_provider_models",
		Columns:    ModelProviderModelsColumns,
		PrimaryKey: []*schema.Column{ModelProviderModelsColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "model_provider_models_model_providers_models",
				Columns:    []*schema.Column{ModelProviderModelsColumns[4]},
				RefColumns: []*schema.Column{ModelProvidersColumns[0]},
				OnDelete:   schema.SetNull,
			},
		},
	}
	// RolesColumns holds the columns for the "roles" table.
	RolesColumns = []*schema.Column{
		{Name: "id", Type: field.TypeInt64, Increment: true},
		{Name: "name", Type: field.TypeString},
		{Name: "description", Type: field.TypeString, Size: 2147483647},
		{Name: "created_at", Type: field.TypeTime},
	}
	// RolesTable holds the schema information for the "roles" table.
	RolesTable = &schema.Table{
		Name:       "roles",
		Columns:    RolesColumns,
		PrimaryKey: []*schema.Column{RolesColumns[0]},
	}
	// SecurityScanningsColumns holds the columns for the "security_scannings" table.
	SecurityScanningsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "status", Type: field.TypeString},
		{Name: "workspace", Type: field.TypeString},
		{Name: "language", Type: field.TypeString},
		{Name: "rule", Type: field.TypeString, Nullable: true},
		{Name: "error_message", Type: field.TypeString, Nullable: true},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
		{Name: "user_id", Type: field.TypeUUID},
		{Name: "workspace_id", Type: field.TypeUUID},
	}
	// SecurityScanningsTable holds the schema information for the "security_scannings" table.
	SecurityScanningsTable = &schema.Table{
		Name:       "security_scannings",
		Columns:    SecurityScanningsColumns,
		PrimaryKey: []*schema.Column{SecurityScanningsColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "security_scannings_users_security_scannings",
				Columns:    []*schema.Column{SecurityScanningsColumns[8]},
				RefColumns: []*schema.Column{UsersColumns[0]},
				OnDelete:   schema.NoAction,
			},
			{
				Symbol:     "security_scannings_workspaces_security_scannings",
				Columns:    []*schema.Column{SecurityScanningsColumns[9]},
				RefColumns: []*schema.Column{WorkspacesColumns[0]},
				OnDelete:   schema.NoAction,
			},
		},
	}
	// SecurityScanningResultsColumns holds the columns for the "security_scanning_results" table.
	SecurityScanningResultsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "check_id", Type: field.TypeString},
		{Name: "engine_kind", Type: field.TypeString},
		{Name: "lines", Type: field.TypeString, Size: 2147483647},
		{Name: "path", Type: field.TypeString, Size: 2147483647},
		{Name: "message", Type: field.TypeString, Size: 2147483647},
		{Name: "message_zh", Type: field.TypeString, Size: 2147483647},
		{Name: "severity", Type: field.TypeString},
		{Name: "abstract_en", Type: field.TypeString, Size: 2147483647},
		{Name: "abstract_zh", Type: field.TypeString, Size: 2147483647},
		{Name: "category_en", Type: field.TypeString, Size: 2147483647},
		{Name: "category_zh", Type: field.TypeString, Size: 2147483647},
		{Name: "confidence", Type: field.TypeString},
		{Name: "cwe", Type: field.TypeJSON},
		{Name: "impact", Type: field.TypeString},
		{Name: "owasp", Type: field.TypeJSON},
		{Name: "file_content", Type: field.TypeString, Size: 2147483647},
		{Name: "start_position", Type: field.TypeJSON},
		{Name: "end_position", Type: field.TypeJSON},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "security_scanning_id", Type: field.TypeUUID},
	}
	// SecurityScanningResultsTable holds the schema information for the "security_scanning_results" table.
	SecurityScanningResultsTable = &schema.Table{
		Name:       "security_scanning_results",
		Columns:    SecurityScanningResultsColumns,
		PrimaryKey: []*schema.Column{SecurityScanningResultsColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "security_scanning_results_security_scannings_results",
				Columns:    []*schema.Column{SecurityScanningResultsColumns[20]},
				RefColumns: []*schema.Column{SecurityScanningsColumns[0]},
				OnDelete:   schema.NoAction,
			},
		},
	}
	// SettingsColumns holds the columns for the "settings" table.
	SettingsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "enable_sso", Type: field.TypeBool, Default: false},
		{Name: "force_two_factor_auth", Type: field.TypeBool, Default: false},
		{Name: "disable_password_login", Type: field.TypeBool, Default: false},
		{Name: "enable_auto_login", Type: field.TypeBool, Default: false},
		{Name: "dingtalk_oauth", Type: field.TypeJSON, Nullable: true},
		{Name: "custom_oauth", Type: field.TypeJSON, Nullable: true},
		{Name: "base_url", Type: field.TypeString, Nullable: true},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
	}
	// SettingsTable holds the schema information for the "settings" table.
	SettingsTable = &schema.Table{
		Name:       "settings",
		Columns:    SettingsColumns,
		PrimaryKey: []*schema.Column{SettingsColumns[0]},
	}
	// TasksColumns holds the columns for the "tasks" table.
	TasksColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "task_id", Type: field.TypeString, Unique: true},
		{Name: "request_id", Type: field.TypeString, Nullable: true},
		{Name: "model_type", Type: field.TypeString},
		{Name: "is_accept", Type: field.TypeBool, Default: false},
		{Name: "program_language", Type: field.TypeString, Nullable: true},
		{Name: "work_mode", Type: field.TypeString, Nullable: true},
		{Name: "prompt", Type: field.TypeString, Nullable: true},
		{Name: "completion", Type: field.TypeString, Nullable: true},
		{Name: "code_lines", Type: field.TypeInt64, Nullable: true},
		{Name: "input_tokens", Type: field.TypeInt64, Nullable: true},
		{Name: "output_tokens", Type: field.TypeInt64, Nullable: true},
		{Name: "is_suggested", Type: field.TypeBool, Default: false},
		{Name: "source_code", Type: field.TypeString, Nullable: true},
		{Name: "cursor_position", Type: field.TypeJSON, Nullable: true},
		{Name: "user_input", Type: field.TypeString, Nullable: true},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
		{Name: "model_id", Type: field.TypeUUID, Nullable: true},
		{Name: "user_id", Type: field.TypeUUID, Nullable: true},
	}
	// TasksTable holds the schema information for the "tasks" table.
	TasksTable = &schema.Table{
		Name:       "tasks",
		Columns:    TasksColumns,
		PrimaryKey: []*schema.Column{TasksColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "tasks_models_tasks",
				Columns:    []*schema.Column{TasksColumns[18]},
				RefColumns: []*schema.Column{ModelsColumns[0]},
				OnDelete:   schema.SetNull,
			},
			{
				Symbol:     "tasks_users_tasks",
				Columns:    []*schema.Column{TasksColumns[19]},
				RefColumns: []*schema.Column{UsersColumns[0]},
				OnDelete:   schema.SetNull,
			},
		},
	}
	// TaskRecordsColumns holds the columns for the "task_records" table.
	TaskRecordsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID, Unique: true},
		{Name: "prompt", Type: field.TypeString, Nullable: true},
		{Name: "role", Type: field.TypeString},
		{Name: "completion", Type: field.TypeString, Nullable: true},
		{Name: "output_tokens", Type: field.TypeInt64, Default: 0},
		{Name: "code_lines", Type: field.TypeInt64, Default: 0},
		{Name: "code", Type: field.TypeString, Nullable: true},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
		{Name: "task_id", Type: field.TypeUUID, Nullable: true},
	}
	// TaskRecordsTable holds the schema information for the "task_records" table.
	TaskRecordsTable = &schema.Table{
		Name:       "task_records",
		Columns:    TaskRecordsColumns,
		PrimaryKey: []*schema.Column{TaskRecordsColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "task_records_tasks_task_records",
				Columns:    []*schema.Column{TaskRecordsColumns[9]},
				RefColumns: []*schema.Column{TasksColumns[0]},
				OnDelete:   schema.SetNull,
			},
		},
	}
	// UsersColumns holds the columns for the "users" table.
	UsersColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "deleted_at", Type: field.TypeTime, Nullable: true},
		{Name: "username", Type: field.TypeString, Nullable: true},
		{Name: "password", Type: field.TypeString, Nullable: true},
		{Name: "email", Type: field.TypeString, Nullable: true},
		{Name: "avatar_url", Type: field.TypeString, Nullable: true},
		{Name: "platform", Type: field.TypeString, Default: "email"},
		{Name: "status", Type: field.TypeString, Default: "active"},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
	}
	// UsersTable holds the schema information for the "users" table.
	UsersTable = &schema.Table{
		Name:       "users",
		Columns:    UsersColumns,
		PrimaryKey: []*schema.Column{UsersColumns[0]},
	}
	// UserGroupsColumns holds the columns for the "user_groups" table.
	UserGroupsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "name", Type: field.TypeString},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "admin_id", Type: field.TypeUUID},
	}
	// UserGroupsTable holds the schema information for the "user_groups" table.
	UserGroupsTable = &schema.Table{
		Name:       "user_groups",
		Columns:    UserGroupsColumns,
		PrimaryKey: []*schema.Column{UserGroupsColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "user_groups_admins_myusergroups",
				Columns:    []*schema.Column{UserGroupsColumns[3]},
				RefColumns: []*schema.Column{AdminsColumns[0]},
				OnDelete:   schema.NoAction,
			},
		},
	}
	// UserGroupAdminsColumns holds the columns for the "user_group_admins" table.
	UserGroupAdminsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "user_group_id", Type: field.TypeUUID},
		{Name: "admin_id", Type: field.TypeUUID},
	}
	// UserGroupAdminsTable holds the schema information for the "user_group_admins" table.
	UserGroupAdminsTable = &schema.Table{
		Name:       "user_group_admins",
		Columns:    UserGroupAdminsColumns,
		PrimaryKey: []*schema.Column{UserGroupAdminsColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "user_group_admins_user_groups_user_group",
				Columns:    []*schema.Column{UserGroupAdminsColumns[1]},
				RefColumns: []*schema.Column{UserGroupsColumns[0]},
				OnDelete:   schema.NoAction,
			},
			{
				Symbol:     "user_group_admins_admins_admin",
				Columns:    []*schema.Column{UserGroupAdminsColumns[2]},
				RefColumns: []*schema.Column{AdminsColumns[0]},
				OnDelete:   schema.NoAction,
			},
		},
		Indexes: []*schema.Index{
			{
				Name:    "usergroupadmin_user_group_id_admin_id",
				Unique:  true,
				Columns: []*schema.Column{UserGroupAdminsColumns[1], UserGroupAdminsColumns[2]},
			},
		},
	}
	// UserGroupUsersColumns holds the columns for the "user_group_users" table.
	UserGroupUsersColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "user_group_id", Type: field.TypeUUID},
		{Name: "user_id", Type: field.TypeUUID},
	}
	// UserGroupUsersTable holds the schema information for the "user_group_users" table.
	UserGroupUsersTable = &schema.Table{
		Name:       "user_group_users",
		Columns:    UserGroupUsersColumns,
		PrimaryKey: []*schema.Column{UserGroupUsersColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "user_group_users_user_groups_user_group",
				Columns:    []*schema.Column{UserGroupUsersColumns[1]},
				RefColumns: []*schema.Column{UserGroupsColumns[0]},
				OnDelete:   schema.NoAction,
			},
			{
				Symbol:     "user_group_users_users_user",
				Columns:    []*schema.Column{UserGroupUsersColumns[2]},
				RefColumns: []*schema.Column{UsersColumns[0]},
				OnDelete:   schema.NoAction,
			},
		},
		Indexes: []*schema.Index{
			{
				Name:    "usergroupuser_user_group_id_user_id",
				Unique:  true,
				Columns: []*schema.Column{UserGroupUsersColumns[1], UserGroupUsersColumns[2]},
			},
		},
	}
	// UserIdentitiesColumns holds the columns for the "user_identities" table.
	UserIdentitiesColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "deleted_at", Type: field.TypeTime, Nullable: true},
		{Name: "platform", Type: field.TypeString, Default: "email"},
		{Name: "identity_id", Type: field.TypeString},
		{Name: "union_id", Type: field.TypeString, Nullable: true},
		{Name: "nickname", Type: field.TypeString, Nullable: true},
		{Name: "email", Type: field.TypeString, Nullable: true},
		{Name: "avatar_url", Type: field.TypeString, Nullable: true},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "user_id", Type: field.TypeUUID, Nullable: true},
	}
	// UserIdentitiesTable holds the schema information for the "user_identities" table.
	UserIdentitiesTable = &schema.Table{
		Name:       "user_identities",
		Columns:    UserIdentitiesColumns,
		PrimaryKey: []*schema.Column{UserIdentitiesColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "user_identities_users_identities",
				Columns:    []*schema.Column{UserIdentitiesColumns[9]},
				RefColumns: []*schema.Column{UsersColumns[0]},
				OnDelete:   schema.SetNull,
			},
		},
	}
	// UserLoginHistoriesColumns holds the columns for the "user_login_histories" table.
	UserLoginHistoriesColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "ip", Type: field.TypeString},
		{Name: "country", Type: field.TypeString},
		{Name: "province", Type: field.TypeString},
		{Name: "city", Type: field.TypeString},
		{Name: "isp", Type: field.TypeString, Nullable: true},
		{Name: "asn", Type: field.TypeString, Nullable: true},
		{Name: "client_version", Type: field.TypeString, Nullable: true},
		{Name: "os_type", Type: field.TypeString, Nullable: true},
		{Name: "os_release", Type: field.TypeString, Nullable: true},
		{Name: "hostname", Type: field.TypeString, Nullable: true},
		{Name: "client_id", Type: field.TypeString, Nullable: true},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "user_id", Type: field.TypeUUID, Nullable: true},
	}
	// UserLoginHistoriesTable holds the schema information for the "user_login_histories" table.
	UserLoginHistoriesTable = &schema.Table{
		Name:       "user_login_histories",
		Columns:    UserLoginHistoriesColumns,
		PrimaryKey: []*schema.Column{UserLoginHistoriesColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "user_login_histories_users_login_histories",
				Columns:    []*schema.Column{UserLoginHistoriesColumns[13]},
				RefColumns: []*schema.Column{UsersColumns[0]},
				OnDelete:   schema.SetNull,
			},
		},
	}
	// WorkspacesColumns holds the columns for the "workspaces" table.
	WorkspacesColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "name", Type: field.TypeString, Nullable: true},
		{Name: "description", Type: field.TypeString, Nullable: true},
		{Name: "root_path", Type: field.TypeString},
		{Name: "settings", Type: field.TypeJSON, Nullable: true},
		{Name: "last_accessed_at", Type: field.TypeTime},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
		{Name: "user_id", Type: field.TypeUUID},
	}
	// WorkspacesTable holds the schema information for the "workspaces" table.
	WorkspacesTable = &schema.Table{
		Name:       "workspaces",
		Columns:    WorkspacesColumns,
		PrimaryKey: []*schema.Column{WorkspacesColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "workspaces_users_workspaces",
				Columns:    []*schema.Column{WorkspacesColumns[8]},
				RefColumns: []*schema.Column{UsersColumns[0]},
				OnDelete:   schema.NoAction,
			},
		},
		Indexes: []*schema.Index{
			{
				Name:    "workspace_user_id_root_path",
				Unique:  true,
				Columns: []*schema.Column{WorkspacesColumns[8], WorkspacesColumns[3]},
			},
			{
				Name:    "workspace_user_id",
				Unique:  false,
				Columns: []*schema.Column{WorkspacesColumns[8]},
			},
			{
				Name:    "workspace_last_accessed_at",
				Unique:  false,
				Columns: []*schema.Column{WorkspacesColumns[5]},
			},
			{
				Name:    "workspace_name",
				Unique:  false,
				Columns: []*schema.Column{WorkspacesColumns[1]},
			},
			{
				Name:    "workspace_root_path",
				Unique:  false,
				Columns: []*schema.Column{WorkspacesColumns[3]},
			},
		},
	}
	// WorkspaceFilesColumns holds the columns for the "workspace_files" table.
	WorkspaceFilesColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "path", Type: field.TypeString, Size: 2147483647},
		{Name: "content", Type: field.TypeString, Nullable: true, Size: 2147483647},
		{Name: "hash", Type: field.TypeString},
		{Name: "language", Type: field.TypeString, Nullable: true},
		{Name: "size", Type: field.TypeInt64, Default: 0},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime},
		{Name: "user_id", Type: field.TypeUUID},
		{Name: "workspace_id", Type: field.TypeUUID},
	}
	// WorkspaceFilesTable holds the schema information for the "workspace_files" table.
	WorkspaceFilesTable = &schema.Table{
		Name:       "workspace_files",
		Columns:    WorkspaceFilesColumns,
		PrimaryKey: []*schema.Column{WorkspaceFilesColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "workspace_files_users_workspace_files",
				Columns:    []*schema.Column{WorkspaceFilesColumns[8]},
				RefColumns: []*schema.Column{UsersColumns[0]},
				OnDelete:   schema.NoAction,
			},
			{
				Symbol:     "workspace_files_workspaces_files",
				Columns:    []*schema.Column{WorkspaceFilesColumns[9]},
				RefColumns: []*schema.Column{WorkspacesColumns[0]},
				OnDelete:   schema.NoAction,
			},
		},
		Indexes: []*schema.Index{
			{
				Name:    "workspacefile_user_id_workspace_id_path",
				Unique:  true,
				Columns: []*schema.Column{WorkspaceFilesColumns[8], WorkspaceFilesColumns[9], WorkspaceFilesColumns[1]},
			},
			{
				Name:    "workspacefile_hash",
				Unique:  false,
				Columns: []*schema.Column{WorkspaceFilesColumns[3]},
			},
			{
				Name:    "workspacefile_workspace_id_hash",
				Unique:  false,
				Columns: []*schema.Column{WorkspaceFilesColumns[9], WorkspaceFilesColumns[3]},
			},
			{
				Name:    "workspacefile_language",
				Unique:  false,
				Columns: []*schema.Column{WorkspaceFilesColumns[4]},
			},
			{
				Name:    "workspacefile_updated_at",
				Unique:  false,
				Columns: []*schema.Column{WorkspaceFilesColumns[7]},
			},
			{
				Name:    "workspacefile_size",
				Unique:  false,
				Columns: []*schema.Column{WorkspaceFilesColumns[5]},
			},
			{
				Name:    "workspacefile_workspace_id",
				Unique:  false,
				Columns: []*schema.Column{WorkspaceFilesColumns[9]},
			},
		},
	}
	// Tables holds all the tables in the schema.
	Tables = []*schema.Table{
		AiEmployeesTable,
		AiTasksTable,
		AdminsTable,
		AdminLoginHistoriesTable,
		AdminRolesTable,
		APIKeysTable,
		BillingPlansTable,
		BillingQuotasTable,
		BillingRecordsTable,
		BillingUsagesTable,
		CodeSnippetsTable,
		ExtensionsTable,
		InviteCodesTable,
		LicenseTable,
		ModelsTable,
		ModelProvidersTable,
		ModelProviderModelsTable,
		RolesTable,
		SecurityScanningsTable,
		SecurityScanningResultsTable,
		SettingsTable,
		TasksTable,
		TaskRecordsTable,
		UsersTable,
		UserGroupsTable,
		UserGroupAdminsTable,
		UserGroupUsersTable,
		UserIdentitiesTable,
		UserLoginHistoriesTable,
		WorkspacesTable,
		WorkspaceFilesTable,
	}
)

func init() {
	AiEmployeesTable.ForeignKeys[0].RefTable = AdminsTable
	AiEmployeesTable.ForeignKeys[1].RefTable = UsersTable
	AiEmployeesTable.Annotation = &entsql.Annotation{
		Table: "ai_employees",
	}
	AiTasksTable.Annotation = &entsql.Annotation{
		Table: "ai_tasks",
	}
	AdminsTable.Annotation = &entsql.Annotation{
		Table: "admins",
	}
	AdminLoginHistoriesTable.ForeignKeys[0].RefTable = AdminsTable
	AdminLoginHistoriesTable.Annotation = &entsql.Annotation{
		Table: "admin_login_histories",
	}
	AdminRolesTable.ForeignKeys[0].RefTable = AdminsTable
	AdminRolesTable.ForeignKeys[1].RefTable = RolesTable
	AdminRolesTable.Annotation = &entsql.Annotation{
		Table: "admin_roles",
	}
	APIKeysTable.ForeignKeys[0].RefTable = UsersTable
	APIKeysTable.Annotation = &entsql.Annotation{
		Table: "api_keys",
	}
	BillingPlansTable.Annotation = &entsql.Annotation{
		Table: "billing_plans",
	}
	BillingQuotasTable.Annotation = &entsql.Annotation{
		Table: "billing_quotas",
	}
	BillingRecordsTable.Annotation = &entsql.Annotation{
		Table: "billing_records",
	}
	BillingUsagesTable.Annotation = &entsql.Annotation{
		Table: "billing_usages",
	}
	CodeSnippetsTable.ForeignKeys[0].RefTable = WorkspaceFilesTable
	CodeSnippetsTable.Annotation = &entsql.Annotation{
		Table: "code_snippets",
	}
	ExtensionsTable.Annotation = &entsql.Annotation{
		Table: "extensions",
	}
	InviteCodesTable.Annotation = &entsql.Annotation{
		Table: "invite_codes",
	}
	LicenseTable.Annotation = &entsql.Annotation{
		Table: "license",
	}
	ModelsTable.ForeignKeys[0].RefTable = UsersTable
	ModelsTable.Annotation = &entsql.Annotation{
		Table: "models",
	}
	ModelProvidersTable.Annotation = &entsql.Annotation{
		Table: "model_providers",
	}
	ModelProviderModelsTable.ForeignKeys[0].RefTable = ModelProvidersTable
	ModelProviderModelsTable.Annotation = &entsql.Annotation{
		Table: "model_provider_models",
	}
	RolesTable.Annotation = &entsql.Annotation{
		Table: "roles",
	}
	SecurityScanningsTable.ForeignKeys[0].RefTable = UsersTable
	SecurityScanningsTable.ForeignKeys[1].RefTable = WorkspacesTable
	SecurityScanningsTable.Annotation = &entsql.Annotation{
		Table: "security_scannings",
	}
	SecurityScanningResultsTable.ForeignKeys[0].RefTable = SecurityScanningsTable
	SecurityScanningResultsTable.Annotation = &entsql.Annotation{
		Table: "security_scanning_results",
	}
	SettingsTable.Annotation = &entsql.Annotation{
		Table: "settings",
	}
	TasksTable.ForeignKeys[0].RefTable = ModelsTable
	TasksTable.ForeignKeys[1].RefTable = UsersTable
	TasksTable.Annotation = &entsql.Annotation{
		Table: "tasks",
	}
	TaskRecordsTable.ForeignKeys[0].RefTable = TasksTable
	TaskRecordsTable.Annotation = &entsql.Annotation{
		Table: "task_records",
	}
	UsersTable.Annotation = &entsql.Annotation{
		Table: "users",
	}
	UserGroupsTable.ForeignKeys[0].RefTable = AdminsTable
	UserGroupsTable.Annotation = &entsql.Annotation{
		Table: "user_groups",
	}
	UserGroupAdminsTable.ForeignKeys[0].RefTable = UserGroupsTable
	UserGroupAdminsTable.ForeignKeys[1].RefTable = AdminsTable
	UserGroupAdminsTable.Annotation = &entsql.Annotation{
		Table: "user_group_admins",
	}
	UserGroupUsersTable.ForeignKeys[0].RefTable = UserGroupsTable
	UserGroupUsersTable.ForeignKeys[1].RefTable = UsersTable
	UserGroupUsersTable.Annotation = &entsql.Annotation{
		Table: "user_group_users",
	}
	UserIdentitiesTable.ForeignKeys[0].RefTable = UsersTable
	UserIdentitiesTable.Annotation = &entsql.Annotation{
		Table: "user_identities",
	}
	UserLoginHistoriesTable.ForeignKeys[0].RefTable = UsersTable
	UserLoginHistoriesTable.Annotation = &entsql.Annotation{
		Table: "user_login_histories",
	}
	WorkspacesTable.ForeignKeys[0].RefTable = UsersTable
	WorkspacesTable.Annotation = &entsql.Annotation{
		Table: "workspaces",
	}
	WorkspaceFilesTable.ForeignKeys[0].RefTable = UsersTable
	WorkspaceFilesTable.ForeignKeys[1].RefTable = WorkspacesTable
	WorkspaceFilesTable.Annotation = &entsql.Annotation{
		Table: "workspace_files",
	}
}
