// Code generated by ent, DO NOT EDIT.

package db

import (
	"encoding/json"
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/model"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/ent/types"
	"github.com/google/uuid"
)

// Model is the model entity for the Model schema.
type Model struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// UserID holds the value of the "user_id" field.
	UserID uuid.UUID `json:"user_id,omitempty"`
	// ModelName holds the value of the "model_name" field.
	ModelName string `json:"model_name,omitempty"`
	// ModelType holds the value of the "model_type" field.
	ModelType consts.ModelType `json:"model_type,omitempty"`
	// ShowName holds the value of the "show_name" field.
	ShowName string `json:"show_name,omitempty"`
	// APIBase holds the value of the "api_base" field.
	APIBase string `json:"api_base,omitempty"`
	// APIKey holds the value of the "api_key" field.
	APIKey string `json:"api_key,omitempty"`
	// APIVersion holds the value of the "api_version" field.
	APIVersion string `json:"api_version,omitempty"`
	// APIHeader holds the value of the "api_header" field.
	APIHeader string `json:"api_header,omitempty"`
	// Description holds the value of the "description" field.
	Description string `json:"description,omitempty"`
	// IsInternal holds the value of the "is_internal" field.
	IsInternal bool `json:"is_internal,omitempty"`
	// Provider holds the value of the "provider" field.
	Provider consts.ModelProvider `json:"provider,omitempty"`
	// Status holds the value of the "status" field.
	Status consts.ModelStatus `json:"status,omitempty"`
	// Parameters holds the value of the "parameters" field.
	Parameters *types.ModelParam `json:"parameters,omitempty"`
	// ContextLength holds the value of the "context_length" field.
	ContextLength int `json:"context_length,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt time.Time `json:"updated_at,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the ModelQuery when eager-loading is set.
	Edges        ModelEdges `json:"edges"`
	selectValues sql.SelectValues
}

// ModelEdges holds the relations/edges for other nodes in the graph.
type ModelEdges struct {
	// Tasks holds the value of the tasks edge.
	Tasks []*Task `json:"tasks,omitempty"`
	// User holds the value of the user edge.
	User *User `json:"user,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [2]bool
}

// TasksOrErr returns the Tasks value or an error if the edge
// was not loaded in eager-loading.
func (e ModelEdges) TasksOrErr() ([]*Task, error) {
	if e.loadedTypes[0] {
		return e.Tasks, nil
	}
	return nil, &NotLoadedError{edge: "tasks"}
}

// UserOrErr returns the User value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e ModelEdges) UserOrErr() (*User, error) {
	if e.User != nil {
		return e.User, nil
	} else if e.loadedTypes[1] {
		return nil, &NotFoundError{label: user.Label}
	}
	return nil, &NotLoadedError{edge: "user"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Model) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case model.FieldParameters:
			values[i] = new([]byte)
		case model.FieldIsInternal:
			values[i] = new(sql.NullBool)
		case model.FieldContextLength:
			values[i] = new(sql.NullInt64)
		case model.FieldModelName, model.FieldModelType, model.FieldShowName, model.FieldAPIBase, model.FieldAPIKey, model.FieldAPIVersion, model.FieldAPIHeader, model.FieldDescription, model.FieldProvider, model.FieldStatus:
			values[i] = new(sql.NullString)
		case model.FieldCreatedAt, model.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		case model.FieldID, model.FieldUserID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Model fields.
func (m *Model) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case model.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				m.ID = *value
			}
		case model.FieldUserID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field user_id", values[i])
			} else if value != nil {
				m.UserID = *value
			}
		case model.FieldModelName:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field model_name", values[i])
			} else if value.Valid {
				m.ModelName = value.String
			}
		case model.FieldModelType:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field model_type", values[i])
			} else if value.Valid {
				m.ModelType = consts.ModelType(value.String)
			}
		case model.FieldShowName:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field show_name", values[i])
			} else if value.Valid {
				m.ShowName = value.String
			}
		case model.FieldAPIBase:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field api_base", values[i])
			} else if value.Valid {
				m.APIBase = value.String
			}
		case model.FieldAPIKey:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field api_key", values[i])
			} else if value.Valid {
				m.APIKey = value.String
			}
		case model.FieldAPIVersion:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field api_version", values[i])
			} else if value.Valid {
				m.APIVersion = value.String
			}
		case model.FieldAPIHeader:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field api_header", values[i])
			} else if value.Valid {
				m.APIHeader = value.String
			}
		case model.FieldDescription:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field description", values[i])
			} else if value.Valid {
				m.Description = value.String
			}
		case model.FieldIsInternal:
			if value, ok := values[i].(*sql.NullBool); !ok {
				return fmt.Errorf("unexpected type %T for field is_internal", values[i])
			} else if value.Valid {
				m.IsInternal = value.Bool
			}
		case model.FieldProvider:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field provider", values[i])
			} else if value.Valid {
				m.Provider = consts.ModelProvider(value.String)
			}
		case model.FieldStatus:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field status", values[i])
			} else if value.Valid {
				m.Status = consts.ModelStatus(value.String)
			}
		case model.FieldParameters:
			if value, ok := values[i].(*[]byte); !ok {
				return fmt.Errorf("unexpected type %T for field parameters", values[i])
			} else if value != nil && len(*value) > 0 {
				if err := json.Unmarshal(*value, &m.Parameters); err != nil {
					return fmt.Errorf("unmarshal field parameters: %w", err)
				}
			}
		case model.FieldContextLength:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field context_length", values[i])
			} else if value.Valid {
				m.ContextLength = int(value.Int64)
			}
		case model.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				m.CreatedAt = value.Time
			}
		case model.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				m.UpdatedAt = value.Time
			}
		default:
			m.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the Model.
// This includes values selected through modifiers, order, etc.
func (m *Model) Value(name string) (ent.Value, error) {
	return m.selectValues.Get(name)
}

// QueryTasks queries the "tasks" edge of the Model entity.
func (m *Model) QueryTasks() *TaskQuery {
	return NewModelClient(m.config).QueryTasks(m)
}

// QueryUser queries the "user" edge of the Model entity.
func (m *Model) QueryUser() *UserQuery {
	return NewModelClient(m.config).QueryUser(m)
}

// Update returns a builder for updating this Model.
// Note that you need to call Model.Unwrap() before calling this method if this Model
// was returned from a transaction, and the transaction was committed or rolled back.
func (m *Model) Update() *ModelUpdateOne {
	return NewModelClient(m.config).UpdateOne(m)
}

// Unwrap unwraps the Model entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (m *Model) Unwrap() *Model {
	_tx, ok := m.config.driver.(*txDriver)
	if !ok {
		panic("db: Model is not a transactional entity")
	}
	m.config.driver = _tx.drv
	return m
}

// String implements the fmt.Stringer.
func (m *Model) String() string {
	var builder strings.Builder
	builder.WriteString("Model(")
	builder.WriteString(fmt.Sprintf("id=%v, ", m.ID))
	builder.WriteString("user_id=")
	builder.WriteString(fmt.Sprintf("%v", m.UserID))
	builder.WriteString(", ")
	builder.WriteString("model_name=")
	builder.WriteString(m.ModelName)
	builder.WriteString(", ")
	builder.WriteString("model_type=")
	builder.WriteString(fmt.Sprintf("%v", m.ModelType))
	builder.WriteString(", ")
	builder.WriteString("show_name=")
	builder.WriteString(m.ShowName)
	builder.WriteString(", ")
	builder.WriteString("api_base=")
	builder.WriteString(m.APIBase)
	builder.WriteString(", ")
	builder.WriteString("api_key=")
	builder.WriteString(m.APIKey)
	builder.WriteString(", ")
	builder.WriteString("api_version=")
	builder.WriteString(m.APIVersion)
	builder.WriteString(", ")
	builder.WriteString("api_header=")
	builder.WriteString(m.APIHeader)
	builder.WriteString(", ")
	builder.WriteString("description=")
	builder.WriteString(m.Description)
	builder.WriteString(", ")
	builder.WriteString("is_internal=")
	builder.WriteString(fmt.Sprintf("%v", m.IsInternal))
	builder.WriteString(", ")
	builder.WriteString("provider=")
	builder.WriteString(fmt.Sprintf("%v", m.Provider))
	builder.WriteString(", ")
	builder.WriteString("status=")
	builder.WriteString(fmt.Sprintf("%v", m.Status))
	builder.WriteString(", ")
	builder.WriteString("parameters=")
	builder.WriteString(fmt.Sprintf("%v", m.Parameters))
	builder.WriteString(", ")
	builder.WriteString("context_length=")
	builder.WriteString(fmt.Sprintf("%v", m.ContextLength))
	builder.WriteString(", ")
	builder.WriteString("created_at=")
	builder.WriteString(m.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(m.UpdatedAt.Format(time.ANSIC))
	builder.WriteByte(')')
	return builder.String()
}

// Models is a parsable slice of Model.
type Models []*Model
