// Code generated by ent, DO NOT EDIT.

package model

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/google/uuid"
)

// ID filters vertices based on their ID field.
func ID(id uuid.UUID) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldID, id))
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id uuid.UUID) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldID, id))
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id uuid.UUID) predicate.Model {
	return predicate.Model(sql.FieldNEQ(FieldID, id))
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...uuid.UUID) predicate.Model {
	return predicate.Model(sql.FieldIn(FieldID, ids...))
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...uuid.UUID) predicate.Model {
	return predicate.Model(sql.FieldNotIn(FieldID, ids...))
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id uuid.UUID) predicate.Model {
	return predicate.Model(sql.FieldGT(FieldID, id))
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id uuid.UUID) predicate.Model {
	return predicate.Model(sql.FieldGTE(FieldID, id))
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id uuid.UUID) predicate.Model {
	return predicate.Model(sql.FieldLT(FieldID, id))
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id uuid.UUID) predicate.Model {
	return predicate.Model(sql.FieldLTE(FieldID, id))
}

// UserID applies equality check predicate on the "user_id" field. It's identical to UserIDEQ.
func UserID(v uuid.UUID) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldUserID, v))
}

// ModelName applies equality check predicate on the "model_name" field. It's identical to ModelNameEQ.
func ModelName(v string) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldModelName, v))
}

// ModelType applies equality check predicate on the "model_type" field. It's identical to ModelTypeEQ.
func ModelType(v consts.ModelType) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldEQ(FieldModelType, vc))
}

// ShowName applies equality check predicate on the "show_name" field. It's identical to ShowNameEQ.
func ShowName(v string) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldShowName, v))
}

// APIBase applies equality check predicate on the "api_base" field. It's identical to APIBaseEQ.
func APIBase(v string) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldAPIBase, v))
}

// APIKey applies equality check predicate on the "api_key" field. It's identical to APIKeyEQ.
func APIKey(v string) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldAPIKey, v))
}

// APIVersion applies equality check predicate on the "api_version" field. It's identical to APIVersionEQ.
func APIVersion(v string) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldAPIVersion, v))
}

// APIHeader applies equality check predicate on the "api_header" field. It's identical to APIHeaderEQ.
func APIHeader(v string) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldAPIHeader, v))
}

// Description applies equality check predicate on the "description" field. It's identical to DescriptionEQ.
func Description(v string) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldDescription, v))
}

// IsInternal applies equality check predicate on the "is_internal" field. It's identical to IsInternalEQ.
func IsInternal(v bool) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldIsInternal, v))
}

// Provider applies equality check predicate on the "provider" field. It's identical to ProviderEQ.
func Provider(v consts.ModelProvider) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldEQ(FieldProvider, vc))
}

// Status applies equality check predicate on the "status" field. It's identical to StatusEQ.
func Status(v consts.ModelStatus) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldEQ(FieldStatus, vc))
}

// ContextLength applies equality check predicate on the "context_length" field. It's identical to ContextLengthEQ.
func ContextLength(v int) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldContextLength, v))
}

// CreatedAt applies equality check predicate on the "created_at" field. It's identical to CreatedAtEQ.
func CreatedAt(v time.Time) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldCreatedAt, v))
}

// UpdatedAt applies equality check predicate on the "updated_at" field. It's identical to UpdatedAtEQ.
func UpdatedAt(v time.Time) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldUpdatedAt, v))
}

// UserIDEQ applies the EQ predicate on the "user_id" field.
func UserIDEQ(v uuid.UUID) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldUserID, v))
}

// UserIDNEQ applies the NEQ predicate on the "user_id" field.
func UserIDNEQ(v uuid.UUID) predicate.Model {
	return predicate.Model(sql.FieldNEQ(FieldUserID, v))
}

// UserIDIn applies the In predicate on the "user_id" field.
func UserIDIn(vs ...uuid.UUID) predicate.Model {
	return predicate.Model(sql.FieldIn(FieldUserID, vs...))
}

// UserIDNotIn applies the NotIn predicate on the "user_id" field.
func UserIDNotIn(vs ...uuid.UUID) predicate.Model {
	return predicate.Model(sql.FieldNotIn(FieldUserID, vs...))
}

// UserIDIsNil applies the IsNil predicate on the "user_id" field.
func UserIDIsNil() predicate.Model {
	return predicate.Model(sql.FieldIsNull(FieldUserID))
}

// UserIDNotNil applies the NotNil predicate on the "user_id" field.
func UserIDNotNil() predicate.Model {
	return predicate.Model(sql.FieldNotNull(FieldUserID))
}

// ModelNameEQ applies the EQ predicate on the "model_name" field.
func ModelNameEQ(v string) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldModelName, v))
}

// ModelNameNEQ applies the NEQ predicate on the "model_name" field.
func ModelNameNEQ(v string) predicate.Model {
	return predicate.Model(sql.FieldNEQ(FieldModelName, v))
}

// ModelNameIn applies the In predicate on the "model_name" field.
func ModelNameIn(vs ...string) predicate.Model {
	return predicate.Model(sql.FieldIn(FieldModelName, vs...))
}

// ModelNameNotIn applies the NotIn predicate on the "model_name" field.
func ModelNameNotIn(vs ...string) predicate.Model {
	return predicate.Model(sql.FieldNotIn(FieldModelName, vs...))
}

// ModelNameGT applies the GT predicate on the "model_name" field.
func ModelNameGT(v string) predicate.Model {
	return predicate.Model(sql.FieldGT(FieldModelName, v))
}

// ModelNameGTE applies the GTE predicate on the "model_name" field.
func ModelNameGTE(v string) predicate.Model {
	return predicate.Model(sql.FieldGTE(FieldModelName, v))
}

// ModelNameLT applies the LT predicate on the "model_name" field.
func ModelNameLT(v string) predicate.Model {
	return predicate.Model(sql.FieldLT(FieldModelName, v))
}

// ModelNameLTE applies the LTE predicate on the "model_name" field.
func ModelNameLTE(v string) predicate.Model {
	return predicate.Model(sql.FieldLTE(FieldModelName, v))
}

// ModelNameContains applies the Contains predicate on the "model_name" field.
func ModelNameContains(v string) predicate.Model {
	return predicate.Model(sql.FieldContains(FieldModelName, v))
}

// ModelNameHasPrefix applies the HasPrefix predicate on the "model_name" field.
func ModelNameHasPrefix(v string) predicate.Model {
	return predicate.Model(sql.FieldHasPrefix(FieldModelName, v))
}

// ModelNameHasSuffix applies the HasSuffix predicate on the "model_name" field.
func ModelNameHasSuffix(v string) predicate.Model {
	return predicate.Model(sql.FieldHasSuffix(FieldModelName, v))
}

// ModelNameEqualFold applies the EqualFold predicate on the "model_name" field.
func ModelNameEqualFold(v string) predicate.Model {
	return predicate.Model(sql.FieldEqualFold(FieldModelName, v))
}

// ModelNameContainsFold applies the ContainsFold predicate on the "model_name" field.
func ModelNameContainsFold(v string) predicate.Model {
	return predicate.Model(sql.FieldContainsFold(FieldModelName, v))
}

// ModelTypeEQ applies the EQ predicate on the "model_type" field.
func ModelTypeEQ(v consts.ModelType) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldEQ(FieldModelType, vc))
}

// ModelTypeNEQ applies the NEQ predicate on the "model_type" field.
func ModelTypeNEQ(v consts.ModelType) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldNEQ(FieldModelType, vc))
}

// ModelTypeIn applies the In predicate on the "model_type" field.
func ModelTypeIn(vs ...consts.ModelType) predicate.Model {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.Model(sql.FieldIn(FieldModelType, v...))
}

// ModelTypeNotIn applies the NotIn predicate on the "model_type" field.
func ModelTypeNotIn(vs ...consts.ModelType) predicate.Model {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.Model(sql.FieldNotIn(FieldModelType, v...))
}

// ModelTypeGT applies the GT predicate on the "model_type" field.
func ModelTypeGT(v consts.ModelType) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldGT(FieldModelType, vc))
}

// ModelTypeGTE applies the GTE predicate on the "model_type" field.
func ModelTypeGTE(v consts.ModelType) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldGTE(FieldModelType, vc))
}

// ModelTypeLT applies the LT predicate on the "model_type" field.
func ModelTypeLT(v consts.ModelType) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldLT(FieldModelType, vc))
}

// ModelTypeLTE applies the LTE predicate on the "model_type" field.
func ModelTypeLTE(v consts.ModelType) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldLTE(FieldModelType, vc))
}

// ModelTypeContains applies the Contains predicate on the "model_type" field.
func ModelTypeContains(v consts.ModelType) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldContains(FieldModelType, vc))
}

// ModelTypeHasPrefix applies the HasPrefix predicate on the "model_type" field.
func ModelTypeHasPrefix(v consts.ModelType) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldHasPrefix(FieldModelType, vc))
}

// ModelTypeHasSuffix applies the HasSuffix predicate on the "model_type" field.
func ModelTypeHasSuffix(v consts.ModelType) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldHasSuffix(FieldModelType, vc))
}

// ModelTypeEqualFold applies the EqualFold predicate on the "model_type" field.
func ModelTypeEqualFold(v consts.ModelType) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldEqualFold(FieldModelType, vc))
}

// ModelTypeContainsFold applies the ContainsFold predicate on the "model_type" field.
func ModelTypeContainsFold(v consts.ModelType) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldContainsFold(FieldModelType, vc))
}

// ShowNameEQ applies the EQ predicate on the "show_name" field.
func ShowNameEQ(v string) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldShowName, v))
}

// ShowNameNEQ applies the NEQ predicate on the "show_name" field.
func ShowNameNEQ(v string) predicate.Model {
	return predicate.Model(sql.FieldNEQ(FieldShowName, v))
}

// ShowNameIn applies the In predicate on the "show_name" field.
func ShowNameIn(vs ...string) predicate.Model {
	return predicate.Model(sql.FieldIn(FieldShowName, vs...))
}

// ShowNameNotIn applies the NotIn predicate on the "show_name" field.
func ShowNameNotIn(vs ...string) predicate.Model {
	return predicate.Model(sql.FieldNotIn(FieldShowName, vs...))
}

// ShowNameGT applies the GT predicate on the "show_name" field.
func ShowNameGT(v string) predicate.Model {
	return predicate.Model(sql.FieldGT(FieldShowName, v))
}

// ShowNameGTE applies the GTE predicate on the "show_name" field.
func ShowNameGTE(v string) predicate.Model {
	return predicate.Model(sql.FieldGTE(FieldShowName, v))
}

// ShowNameLT applies the LT predicate on the "show_name" field.
func ShowNameLT(v string) predicate.Model {
	return predicate.Model(sql.FieldLT(FieldShowName, v))
}

// ShowNameLTE applies the LTE predicate on the "show_name" field.
func ShowNameLTE(v string) predicate.Model {
	return predicate.Model(sql.FieldLTE(FieldShowName, v))
}

// ShowNameContains applies the Contains predicate on the "show_name" field.
func ShowNameContains(v string) predicate.Model {
	return predicate.Model(sql.FieldContains(FieldShowName, v))
}

// ShowNameHasPrefix applies the HasPrefix predicate on the "show_name" field.
func ShowNameHasPrefix(v string) predicate.Model {
	return predicate.Model(sql.FieldHasPrefix(FieldShowName, v))
}

// ShowNameHasSuffix applies the HasSuffix predicate on the "show_name" field.
func ShowNameHasSuffix(v string) predicate.Model {
	return predicate.Model(sql.FieldHasSuffix(FieldShowName, v))
}

// ShowNameIsNil applies the IsNil predicate on the "show_name" field.
func ShowNameIsNil() predicate.Model {
	return predicate.Model(sql.FieldIsNull(FieldShowName))
}

// ShowNameNotNil applies the NotNil predicate on the "show_name" field.
func ShowNameNotNil() predicate.Model {
	return predicate.Model(sql.FieldNotNull(FieldShowName))
}

// ShowNameEqualFold applies the EqualFold predicate on the "show_name" field.
func ShowNameEqualFold(v string) predicate.Model {
	return predicate.Model(sql.FieldEqualFold(FieldShowName, v))
}

// ShowNameContainsFold applies the ContainsFold predicate on the "show_name" field.
func ShowNameContainsFold(v string) predicate.Model {
	return predicate.Model(sql.FieldContainsFold(FieldShowName, v))
}

// APIBaseEQ applies the EQ predicate on the "api_base" field.
func APIBaseEQ(v string) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldAPIBase, v))
}

// APIBaseNEQ applies the NEQ predicate on the "api_base" field.
func APIBaseNEQ(v string) predicate.Model {
	return predicate.Model(sql.FieldNEQ(FieldAPIBase, v))
}

// APIBaseIn applies the In predicate on the "api_base" field.
func APIBaseIn(vs ...string) predicate.Model {
	return predicate.Model(sql.FieldIn(FieldAPIBase, vs...))
}

// APIBaseNotIn applies the NotIn predicate on the "api_base" field.
func APIBaseNotIn(vs ...string) predicate.Model {
	return predicate.Model(sql.FieldNotIn(FieldAPIBase, vs...))
}

// APIBaseGT applies the GT predicate on the "api_base" field.
func APIBaseGT(v string) predicate.Model {
	return predicate.Model(sql.FieldGT(FieldAPIBase, v))
}

// APIBaseGTE applies the GTE predicate on the "api_base" field.
func APIBaseGTE(v string) predicate.Model {
	return predicate.Model(sql.FieldGTE(FieldAPIBase, v))
}

// APIBaseLT applies the LT predicate on the "api_base" field.
func APIBaseLT(v string) predicate.Model {
	return predicate.Model(sql.FieldLT(FieldAPIBase, v))
}

// APIBaseLTE applies the LTE predicate on the "api_base" field.
func APIBaseLTE(v string) predicate.Model {
	return predicate.Model(sql.FieldLTE(FieldAPIBase, v))
}

// APIBaseContains applies the Contains predicate on the "api_base" field.
func APIBaseContains(v string) predicate.Model {
	return predicate.Model(sql.FieldContains(FieldAPIBase, v))
}

// APIBaseHasPrefix applies the HasPrefix predicate on the "api_base" field.
func APIBaseHasPrefix(v string) predicate.Model {
	return predicate.Model(sql.FieldHasPrefix(FieldAPIBase, v))
}

// APIBaseHasSuffix applies the HasSuffix predicate on the "api_base" field.
func APIBaseHasSuffix(v string) predicate.Model {
	return predicate.Model(sql.FieldHasSuffix(FieldAPIBase, v))
}

// APIBaseEqualFold applies the EqualFold predicate on the "api_base" field.
func APIBaseEqualFold(v string) predicate.Model {
	return predicate.Model(sql.FieldEqualFold(FieldAPIBase, v))
}

// APIBaseContainsFold applies the ContainsFold predicate on the "api_base" field.
func APIBaseContainsFold(v string) predicate.Model {
	return predicate.Model(sql.FieldContainsFold(FieldAPIBase, v))
}

// APIKeyEQ applies the EQ predicate on the "api_key" field.
func APIKeyEQ(v string) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldAPIKey, v))
}

// APIKeyNEQ applies the NEQ predicate on the "api_key" field.
func APIKeyNEQ(v string) predicate.Model {
	return predicate.Model(sql.FieldNEQ(FieldAPIKey, v))
}

// APIKeyIn applies the In predicate on the "api_key" field.
func APIKeyIn(vs ...string) predicate.Model {
	return predicate.Model(sql.FieldIn(FieldAPIKey, vs...))
}

// APIKeyNotIn applies the NotIn predicate on the "api_key" field.
func APIKeyNotIn(vs ...string) predicate.Model {
	return predicate.Model(sql.FieldNotIn(FieldAPIKey, vs...))
}

// APIKeyGT applies the GT predicate on the "api_key" field.
func APIKeyGT(v string) predicate.Model {
	return predicate.Model(sql.FieldGT(FieldAPIKey, v))
}

// APIKeyGTE applies the GTE predicate on the "api_key" field.
func APIKeyGTE(v string) predicate.Model {
	return predicate.Model(sql.FieldGTE(FieldAPIKey, v))
}

// APIKeyLT applies the LT predicate on the "api_key" field.
func APIKeyLT(v string) predicate.Model {
	return predicate.Model(sql.FieldLT(FieldAPIKey, v))
}

// APIKeyLTE applies the LTE predicate on the "api_key" field.
func APIKeyLTE(v string) predicate.Model {
	return predicate.Model(sql.FieldLTE(FieldAPIKey, v))
}

// APIKeyContains applies the Contains predicate on the "api_key" field.
func APIKeyContains(v string) predicate.Model {
	return predicate.Model(sql.FieldContains(FieldAPIKey, v))
}

// APIKeyHasPrefix applies the HasPrefix predicate on the "api_key" field.
func APIKeyHasPrefix(v string) predicate.Model {
	return predicate.Model(sql.FieldHasPrefix(FieldAPIKey, v))
}

// APIKeyHasSuffix applies the HasSuffix predicate on the "api_key" field.
func APIKeyHasSuffix(v string) predicate.Model {
	return predicate.Model(sql.FieldHasSuffix(FieldAPIKey, v))
}

// APIKeyIsNil applies the IsNil predicate on the "api_key" field.
func APIKeyIsNil() predicate.Model {
	return predicate.Model(sql.FieldIsNull(FieldAPIKey))
}

// APIKeyNotNil applies the NotNil predicate on the "api_key" field.
func APIKeyNotNil() predicate.Model {
	return predicate.Model(sql.FieldNotNull(FieldAPIKey))
}

// APIKeyEqualFold applies the EqualFold predicate on the "api_key" field.
func APIKeyEqualFold(v string) predicate.Model {
	return predicate.Model(sql.FieldEqualFold(FieldAPIKey, v))
}

// APIKeyContainsFold applies the ContainsFold predicate on the "api_key" field.
func APIKeyContainsFold(v string) predicate.Model {
	return predicate.Model(sql.FieldContainsFold(FieldAPIKey, v))
}

// APIVersionEQ applies the EQ predicate on the "api_version" field.
func APIVersionEQ(v string) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldAPIVersion, v))
}

// APIVersionNEQ applies the NEQ predicate on the "api_version" field.
func APIVersionNEQ(v string) predicate.Model {
	return predicate.Model(sql.FieldNEQ(FieldAPIVersion, v))
}

// APIVersionIn applies the In predicate on the "api_version" field.
func APIVersionIn(vs ...string) predicate.Model {
	return predicate.Model(sql.FieldIn(FieldAPIVersion, vs...))
}

// APIVersionNotIn applies the NotIn predicate on the "api_version" field.
func APIVersionNotIn(vs ...string) predicate.Model {
	return predicate.Model(sql.FieldNotIn(FieldAPIVersion, vs...))
}

// APIVersionGT applies the GT predicate on the "api_version" field.
func APIVersionGT(v string) predicate.Model {
	return predicate.Model(sql.FieldGT(FieldAPIVersion, v))
}

// APIVersionGTE applies the GTE predicate on the "api_version" field.
func APIVersionGTE(v string) predicate.Model {
	return predicate.Model(sql.FieldGTE(FieldAPIVersion, v))
}

// APIVersionLT applies the LT predicate on the "api_version" field.
func APIVersionLT(v string) predicate.Model {
	return predicate.Model(sql.FieldLT(FieldAPIVersion, v))
}

// APIVersionLTE applies the LTE predicate on the "api_version" field.
func APIVersionLTE(v string) predicate.Model {
	return predicate.Model(sql.FieldLTE(FieldAPIVersion, v))
}

// APIVersionContains applies the Contains predicate on the "api_version" field.
func APIVersionContains(v string) predicate.Model {
	return predicate.Model(sql.FieldContains(FieldAPIVersion, v))
}

// APIVersionHasPrefix applies the HasPrefix predicate on the "api_version" field.
func APIVersionHasPrefix(v string) predicate.Model {
	return predicate.Model(sql.FieldHasPrefix(FieldAPIVersion, v))
}

// APIVersionHasSuffix applies the HasSuffix predicate on the "api_version" field.
func APIVersionHasSuffix(v string) predicate.Model {
	return predicate.Model(sql.FieldHasSuffix(FieldAPIVersion, v))
}

// APIVersionIsNil applies the IsNil predicate on the "api_version" field.
func APIVersionIsNil() predicate.Model {
	return predicate.Model(sql.FieldIsNull(FieldAPIVersion))
}

// APIVersionNotNil applies the NotNil predicate on the "api_version" field.
func APIVersionNotNil() predicate.Model {
	return predicate.Model(sql.FieldNotNull(FieldAPIVersion))
}

// APIVersionEqualFold applies the EqualFold predicate on the "api_version" field.
func APIVersionEqualFold(v string) predicate.Model {
	return predicate.Model(sql.FieldEqualFold(FieldAPIVersion, v))
}

// APIVersionContainsFold applies the ContainsFold predicate on the "api_version" field.
func APIVersionContainsFold(v string) predicate.Model {
	return predicate.Model(sql.FieldContainsFold(FieldAPIVersion, v))
}

// APIHeaderEQ applies the EQ predicate on the "api_header" field.
func APIHeaderEQ(v string) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldAPIHeader, v))
}

// APIHeaderNEQ applies the NEQ predicate on the "api_header" field.
func APIHeaderNEQ(v string) predicate.Model {
	return predicate.Model(sql.FieldNEQ(FieldAPIHeader, v))
}

// APIHeaderIn applies the In predicate on the "api_header" field.
func APIHeaderIn(vs ...string) predicate.Model {
	return predicate.Model(sql.FieldIn(FieldAPIHeader, vs...))
}

// APIHeaderNotIn applies the NotIn predicate on the "api_header" field.
func APIHeaderNotIn(vs ...string) predicate.Model {
	return predicate.Model(sql.FieldNotIn(FieldAPIHeader, vs...))
}

// APIHeaderGT applies the GT predicate on the "api_header" field.
func APIHeaderGT(v string) predicate.Model {
	return predicate.Model(sql.FieldGT(FieldAPIHeader, v))
}

// APIHeaderGTE applies the GTE predicate on the "api_header" field.
func APIHeaderGTE(v string) predicate.Model {
	return predicate.Model(sql.FieldGTE(FieldAPIHeader, v))
}

// APIHeaderLT applies the LT predicate on the "api_header" field.
func APIHeaderLT(v string) predicate.Model {
	return predicate.Model(sql.FieldLT(FieldAPIHeader, v))
}

// APIHeaderLTE applies the LTE predicate on the "api_header" field.
func APIHeaderLTE(v string) predicate.Model {
	return predicate.Model(sql.FieldLTE(FieldAPIHeader, v))
}

// APIHeaderContains applies the Contains predicate on the "api_header" field.
func APIHeaderContains(v string) predicate.Model {
	return predicate.Model(sql.FieldContains(FieldAPIHeader, v))
}

// APIHeaderHasPrefix applies the HasPrefix predicate on the "api_header" field.
func APIHeaderHasPrefix(v string) predicate.Model {
	return predicate.Model(sql.FieldHasPrefix(FieldAPIHeader, v))
}

// APIHeaderHasSuffix applies the HasSuffix predicate on the "api_header" field.
func APIHeaderHasSuffix(v string) predicate.Model {
	return predicate.Model(sql.FieldHasSuffix(FieldAPIHeader, v))
}

// APIHeaderIsNil applies the IsNil predicate on the "api_header" field.
func APIHeaderIsNil() predicate.Model {
	return predicate.Model(sql.FieldIsNull(FieldAPIHeader))
}

// APIHeaderNotNil applies the NotNil predicate on the "api_header" field.
func APIHeaderNotNil() predicate.Model {
	return predicate.Model(sql.FieldNotNull(FieldAPIHeader))
}

// APIHeaderEqualFold applies the EqualFold predicate on the "api_header" field.
func APIHeaderEqualFold(v string) predicate.Model {
	return predicate.Model(sql.FieldEqualFold(FieldAPIHeader, v))
}

// APIHeaderContainsFold applies the ContainsFold predicate on the "api_header" field.
func APIHeaderContainsFold(v string) predicate.Model {
	return predicate.Model(sql.FieldContainsFold(FieldAPIHeader, v))
}

// DescriptionEQ applies the EQ predicate on the "description" field.
func DescriptionEQ(v string) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldDescription, v))
}

// DescriptionNEQ applies the NEQ predicate on the "description" field.
func DescriptionNEQ(v string) predicate.Model {
	return predicate.Model(sql.FieldNEQ(FieldDescription, v))
}

// DescriptionIn applies the In predicate on the "description" field.
func DescriptionIn(vs ...string) predicate.Model {
	return predicate.Model(sql.FieldIn(FieldDescription, vs...))
}

// DescriptionNotIn applies the NotIn predicate on the "description" field.
func DescriptionNotIn(vs ...string) predicate.Model {
	return predicate.Model(sql.FieldNotIn(FieldDescription, vs...))
}

// DescriptionGT applies the GT predicate on the "description" field.
func DescriptionGT(v string) predicate.Model {
	return predicate.Model(sql.FieldGT(FieldDescription, v))
}

// DescriptionGTE applies the GTE predicate on the "description" field.
func DescriptionGTE(v string) predicate.Model {
	return predicate.Model(sql.FieldGTE(FieldDescription, v))
}

// DescriptionLT applies the LT predicate on the "description" field.
func DescriptionLT(v string) predicate.Model {
	return predicate.Model(sql.FieldLT(FieldDescription, v))
}

// DescriptionLTE applies the LTE predicate on the "description" field.
func DescriptionLTE(v string) predicate.Model {
	return predicate.Model(sql.FieldLTE(FieldDescription, v))
}

// DescriptionContains applies the Contains predicate on the "description" field.
func DescriptionContains(v string) predicate.Model {
	return predicate.Model(sql.FieldContains(FieldDescription, v))
}

// DescriptionHasPrefix applies the HasPrefix predicate on the "description" field.
func DescriptionHasPrefix(v string) predicate.Model {
	return predicate.Model(sql.FieldHasPrefix(FieldDescription, v))
}

// DescriptionHasSuffix applies the HasSuffix predicate on the "description" field.
func DescriptionHasSuffix(v string) predicate.Model {
	return predicate.Model(sql.FieldHasSuffix(FieldDescription, v))
}

// DescriptionIsNil applies the IsNil predicate on the "description" field.
func DescriptionIsNil() predicate.Model {
	return predicate.Model(sql.FieldIsNull(FieldDescription))
}

// DescriptionNotNil applies the NotNil predicate on the "description" field.
func DescriptionNotNil() predicate.Model {
	return predicate.Model(sql.FieldNotNull(FieldDescription))
}

// DescriptionEqualFold applies the EqualFold predicate on the "description" field.
func DescriptionEqualFold(v string) predicate.Model {
	return predicate.Model(sql.FieldEqualFold(FieldDescription, v))
}

// DescriptionContainsFold applies the ContainsFold predicate on the "description" field.
func DescriptionContainsFold(v string) predicate.Model {
	return predicate.Model(sql.FieldContainsFold(FieldDescription, v))
}

// IsInternalEQ applies the EQ predicate on the "is_internal" field.
func IsInternalEQ(v bool) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldIsInternal, v))
}

// IsInternalNEQ applies the NEQ predicate on the "is_internal" field.
func IsInternalNEQ(v bool) predicate.Model {
	return predicate.Model(sql.FieldNEQ(FieldIsInternal, v))
}

// ProviderEQ applies the EQ predicate on the "provider" field.
func ProviderEQ(v consts.ModelProvider) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldEQ(FieldProvider, vc))
}

// ProviderNEQ applies the NEQ predicate on the "provider" field.
func ProviderNEQ(v consts.ModelProvider) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldNEQ(FieldProvider, vc))
}

// ProviderIn applies the In predicate on the "provider" field.
func ProviderIn(vs ...consts.ModelProvider) predicate.Model {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.Model(sql.FieldIn(FieldProvider, v...))
}

// ProviderNotIn applies the NotIn predicate on the "provider" field.
func ProviderNotIn(vs ...consts.ModelProvider) predicate.Model {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.Model(sql.FieldNotIn(FieldProvider, v...))
}

// ProviderGT applies the GT predicate on the "provider" field.
func ProviderGT(v consts.ModelProvider) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldGT(FieldProvider, vc))
}

// ProviderGTE applies the GTE predicate on the "provider" field.
func ProviderGTE(v consts.ModelProvider) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldGTE(FieldProvider, vc))
}

// ProviderLT applies the LT predicate on the "provider" field.
func ProviderLT(v consts.ModelProvider) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldLT(FieldProvider, vc))
}

// ProviderLTE applies the LTE predicate on the "provider" field.
func ProviderLTE(v consts.ModelProvider) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldLTE(FieldProvider, vc))
}

// ProviderContains applies the Contains predicate on the "provider" field.
func ProviderContains(v consts.ModelProvider) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldContains(FieldProvider, vc))
}

// ProviderHasPrefix applies the HasPrefix predicate on the "provider" field.
func ProviderHasPrefix(v consts.ModelProvider) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldHasPrefix(FieldProvider, vc))
}

// ProviderHasSuffix applies the HasSuffix predicate on the "provider" field.
func ProviderHasSuffix(v consts.ModelProvider) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldHasSuffix(FieldProvider, vc))
}

// ProviderEqualFold applies the EqualFold predicate on the "provider" field.
func ProviderEqualFold(v consts.ModelProvider) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldEqualFold(FieldProvider, vc))
}

// ProviderContainsFold applies the ContainsFold predicate on the "provider" field.
func ProviderContainsFold(v consts.ModelProvider) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldContainsFold(FieldProvider, vc))
}

// StatusEQ applies the EQ predicate on the "status" field.
func StatusEQ(v consts.ModelStatus) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldEQ(FieldStatus, vc))
}

// StatusNEQ applies the NEQ predicate on the "status" field.
func StatusNEQ(v consts.ModelStatus) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldNEQ(FieldStatus, vc))
}

// StatusIn applies the In predicate on the "status" field.
func StatusIn(vs ...consts.ModelStatus) predicate.Model {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.Model(sql.FieldIn(FieldStatus, v...))
}

// StatusNotIn applies the NotIn predicate on the "status" field.
func StatusNotIn(vs ...consts.ModelStatus) predicate.Model {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.Model(sql.FieldNotIn(FieldStatus, v...))
}

// StatusGT applies the GT predicate on the "status" field.
func StatusGT(v consts.ModelStatus) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldGT(FieldStatus, vc))
}

// StatusGTE applies the GTE predicate on the "status" field.
func StatusGTE(v consts.ModelStatus) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldGTE(FieldStatus, vc))
}

// StatusLT applies the LT predicate on the "status" field.
func StatusLT(v consts.ModelStatus) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldLT(FieldStatus, vc))
}

// StatusLTE applies the LTE predicate on the "status" field.
func StatusLTE(v consts.ModelStatus) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldLTE(FieldStatus, vc))
}

// StatusContains applies the Contains predicate on the "status" field.
func StatusContains(v consts.ModelStatus) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldContains(FieldStatus, vc))
}

// StatusHasPrefix applies the HasPrefix predicate on the "status" field.
func StatusHasPrefix(v consts.ModelStatus) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldHasPrefix(FieldStatus, vc))
}

// StatusHasSuffix applies the HasSuffix predicate on the "status" field.
func StatusHasSuffix(v consts.ModelStatus) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldHasSuffix(FieldStatus, vc))
}

// StatusEqualFold applies the EqualFold predicate on the "status" field.
func StatusEqualFold(v consts.ModelStatus) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldEqualFold(FieldStatus, vc))
}

// StatusContainsFold applies the ContainsFold predicate on the "status" field.
func StatusContainsFold(v consts.ModelStatus) predicate.Model {
	vc := string(v)
	return predicate.Model(sql.FieldContainsFold(FieldStatus, vc))
}

// ParametersIsNil applies the IsNil predicate on the "parameters" field.
func ParametersIsNil() predicate.Model {
	return predicate.Model(sql.FieldIsNull(FieldParameters))
}

// ParametersNotNil applies the NotNil predicate on the "parameters" field.
func ParametersNotNil() predicate.Model {
	return predicate.Model(sql.FieldNotNull(FieldParameters))
}

// ContextLengthEQ applies the EQ predicate on the "context_length" field.
func ContextLengthEQ(v int) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldContextLength, v))
}

// ContextLengthNEQ applies the NEQ predicate on the "context_length" field.
func ContextLengthNEQ(v int) predicate.Model {
	return predicate.Model(sql.FieldNEQ(FieldContextLength, v))
}

// ContextLengthIn applies the In predicate on the "context_length" field.
func ContextLengthIn(vs ...int) predicate.Model {
	return predicate.Model(sql.FieldIn(FieldContextLength, vs...))
}

// ContextLengthNotIn applies the NotIn predicate on the "context_length" field.
func ContextLengthNotIn(vs ...int) predicate.Model {
	return predicate.Model(sql.FieldNotIn(FieldContextLength, vs...))
}

// ContextLengthGT applies the GT predicate on the "context_length" field.
func ContextLengthGT(v int) predicate.Model {
	return predicate.Model(sql.FieldGT(FieldContextLength, v))
}

// ContextLengthGTE applies the GTE predicate on the "context_length" field.
func ContextLengthGTE(v int) predicate.Model {
	return predicate.Model(sql.FieldGTE(FieldContextLength, v))
}

// ContextLengthLT applies the LT predicate on the "context_length" field.
func ContextLengthLT(v int) predicate.Model {
	return predicate.Model(sql.FieldLT(FieldContextLength, v))
}

// ContextLengthLTE applies the LTE predicate on the "context_length" field.
func ContextLengthLTE(v int) predicate.Model {
	return predicate.Model(sql.FieldLTE(FieldContextLength, v))
}

// ContextLengthIsNil applies the IsNil predicate on the "context_length" field.
func ContextLengthIsNil() predicate.Model {
	return predicate.Model(sql.FieldIsNull(FieldContextLength))
}

// ContextLengthNotNil applies the NotNil predicate on the "context_length" field.
func ContextLengthNotNil() predicate.Model {
	return predicate.Model(sql.FieldNotNull(FieldContextLength))
}

// CreatedAtEQ applies the EQ predicate on the "created_at" field.
func CreatedAtEQ(v time.Time) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldCreatedAt, v))
}

// CreatedAtNEQ applies the NEQ predicate on the "created_at" field.
func CreatedAtNEQ(v time.Time) predicate.Model {
	return predicate.Model(sql.FieldNEQ(FieldCreatedAt, v))
}

// CreatedAtIn applies the In predicate on the "created_at" field.
func CreatedAtIn(vs ...time.Time) predicate.Model {
	return predicate.Model(sql.FieldIn(FieldCreatedAt, vs...))
}

// CreatedAtNotIn applies the NotIn predicate on the "created_at" field.
func CreatedAtNotIn(vs ...time.Time) predicate.Model {
	return predicate.Model(sql.FieldNotIn(FieldCreatedAt, vs...))
}

// CreatedAtGT applies the GT predicate on the "created_at" field.
func CreatedAtGT(v time.Time) predicate.Model {
	return predicate.Model(sql.FieldGT(FieldCreatedAt, v))
}

// CreatedAtGTE applies the GTE predicate on the "created_at" field.
func CreatedAtGTE(v time.Time) predicate.Model {
	return predicate.Model(sql.FieldGTE(FieldCreatedAt, v))
}

// CreatedAtLT applies the LT predicate on the "created_at" field.
func CreatedAtLT(v time.Time) predicate.Model {
	return predicate.Model(sql.FieldLT(FieldCreatedAt, v))
}

// CreatedAtLTE applies the LTE predicate on the "created_at" field.
func CreatedAtLTE(v time.Time) predicate.Model {
	return predicate.Model(sql.FieldLTE(FieldCreatedAt, v))
}

// UpdatedAtEQ applies the EQ predicate on the "updated_at" field.
func UpdatedAtEQ(v time.Time) predicate.Model {
	return predicate.Model(sql.FieldEQ(FieldUpdatedAt, v))
}

// UpdatedAtNEQ applies the NEQ predicate on the "updated_at" field.
func UpdatedAtNEQ(v time.Time) predicate.Model {
	return predicate.Model(sql.FieldNEQ(FieldUpdatedAt, v))
}

// UpdatedAtIn applies the In predicate on the "updated_at" field.
func UpdatedAtIn(vs ...time.Time) predicate.Model {
	return predicate.Model(sql.FieldIn(FieldUpdatedAt, vs...))
}

// UpdatedAtNotIn applies the NotIn predicate on the "updated_at" field.
func UpdatedAtNotIn(vs ...time.Time) predicate.Model {
	return predicate.Model(sql.FieldNotIn(FieldUpdatedAt, vs...))
}

// UpdatedAtGT applies the GT predicate on the "updated_at" field.
func UpdatedAtGT(v time.Time) predicate.Model {
	return predicate.Model(sql.FieldGT(FieldUpdatedAt, v))
}

// UpdatedAtGTE applies the GTE predicate on the "updated_at" field.
func UpdatedAtGTE(v time.Time) predicate.Model {
	return predicate.Model(sql.FieldGTE(FieldUpdatedAt, v))
}

// UpdatedAtLT applies the LT predicate on the "updated_at" field.
func UpdatedAtLT(v time.Time) predicate.Model {
	return predicate.Model(sql.FieldLT(FieldUpdatedAt, v))
}

// UpdatedAtLTE applies the LTE predicate on the "updated_at" field.
func UpdatedAtLTE(v time.Time) predicate.Model {
	return predicate.Model(sql.FieldLTE(FieldUpdatedAt, v))
}

// HasTasks applies the HasEdge predicate on the "tasks" edge.
func HasTasks() predicate.Model {
	return predicate.Model(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, TasksTable, TasksColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasTasksWith applies the HasEdge predicate on the "tasks" edge with a given conditions (other predicates).
func HasTasksWith(preds ...predicate.Task) predicate.Model {
	return predicate.Model(func(s *sql.Selector) {
		step := newTasksStep()
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// HasUser applies the HasEdge predicate on the "user" edge.
func HasUser() predicate.Model {
	return predicate.Model(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, UserTable, UserColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasUserWith applies the HasEdge predicate on the "user" edge with a given conditions (other predicates).
func HasUserWith(preds ...predicate.User) predicate.Model {
	return predicate.Model(func(s *sql.Selector) {
		step := newUserStep()
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.Model) predicate.Model {
	return predicate.Model(sql.AndPredicates(predicates...))
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.Model) predicate.Model {
	return predicate.Model(sql.OrPredicates(predicates...))
}

// Not applies the not operator on the given predicate.
func Not(p predicate.Model) predicate.Model {
	return predicate.Model(sql.NotPredicates(p))
}
