// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/model"
	"github.com/chaitin/MonkeyCode/backend/db/task"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/ent/types"
	"github.com/google/uuid"
)

// ModelCreate is the builder for creating a Model entity.
type ModelCreate struct {
	config
	mutation *ModelMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetUserID sets the "user_id" field.
func (mc *ModelCreate) SetUserID(u uuid.UUID) *ModelCreate {
	mc.mutation.SetUserID(u)
	return mc
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (mc *ModelCreate) SetNillableUserID(u *uuid.UUID) *ModelCreate {
	if u != nil {
		mc.SetUserID(*u)
	}
	return mc
}

// SetModelName sets the "model_name" field.
func (mc *ModelCreate) SetModelName(s string) *ModelCreate {
	mc.mutation.SetModelName(s)
	return mc
}

// SetModelType sets the "model_type" field.
func (mc *ModelCreate) SetModelType(ct consts.ModelType) *ModelCreate {
	mc.mutation.SetModelType(ct)
	return mc
}

// SetShowName sets the "show_name" field.
func (mc *ModelCreate) SetShowName(s string) *ModelCreate {
	mc.mutation.SetShowName(s)
	return mc
}

// SetNillableShowName sets the "show_name" field if the given value is not nil.
func (mc *ModelCreate) SetNillableShowName(s *string) *ModelCreate {
	if s != nil {
		mc.SetShowName(*s)
	}
	return mc
}

// SetAPIBase sets the "api_base" field.
func (mc *ModelCreate) SetAPIBase(s string) *ModelCreate {
	mc.mutation.SetAPIBase(s)
	return mc
}

// SetAPIKey sets the "api_key" field.
func (mc *ModelCreate) SetAPIKey(s string) *ModelCreate {
	mc.mutation.SetAPIKey(s)
	return mc
}

// SetNillableAPIKey sets the "api_key" field if the given value is not nil.
func (mc *ModelCreate) SetNillableAPIKey(s *string) *ModelCreate {
	if s != nil {
		mc.SetAPIKey(*s)
	}
	return mc
}

// SetAPIVersion sets the "api_version" field.
func (mc *ModelCreate) SetAPIVersion(s string) *ModelCreate {
	mc.mutation.SetAPIVersion(s)
	return mc
}

// SetNillableAPIVersion sets the "api_version" field if the given value is not nil.
func (mc *ModelCreate) SetNillableAPIVersion(s *string) *ModelCreate {
	if s != nil {
		mc.SetAPIVersion(*s)
	}
	return mc
}

// SetAPIHeader sets the "api_header" field.
func (mc *ModelCreate) SetAPIHeader(s string) *ModelCreate {
	mc.mutation.SetAPIHeader(s)
	return mc
}

// SetNillableAPIHeader sets the "api_header" field if the given value is not nil.
func (mc *ModelCreate) SetNillableAPIHeader(s *string) *ModelCreate {
	if s != nil {
		mc.SetAPIHeader(*s)
	}
	return mc
}

// SetDescription sets the "description" field.
func (mc *ModelCreate) SetDescription(s string) *ModelCreate {
	mc.mutation.SetDescription(s)
	return mc
}

// SetNillableDescription sets the "description" field if the given value is not nil.
func (mc *ModelCreate) SetNillableDescription(s *string) *ModelCreate {
	if s != nil {
		mc.SetDescription(*s)
	}
	return mc
}

// SetIsInternal sets the "is_internal" field.
func (mc *ModelCreate) SetIsInternal(b bool) *ModelCreate {
	mc.mutation.SetIsInternal(b)
	return mc
}

// SetNillableIsInternal sets the "is_internal" field if the given value is not nil.
func (mc *ModelCreate) SetNillableIsInternal(b *bool) *ModelCreate {
	if b != nil {
		mc.SetIsInternal(*b)
	}
	return mc
}

// SetProvider sets the "provider" field.
func (mc *ModelCreate) SetProvider(cp consts.ModelProvider) *ModelCreate {
	mc.mutation.SetProvider(cp)
	return mc
}

// SetStatus sets the "status" field.
func (mc *ModelCreate) SetStatus(cs consts.ModelStatus) *ModelCreate {
	mc.mutation.SetStatus(cs)
	return mc
}

// SetNillableStatus sets the "status" field if the given value is not nil.
func (mc *ModelCreate) SetNillableStatus(cs *consts.ModelStatus) *ModelCreate {
	if cs != nil {
		mc.SetStatus(*cs)
	}
	return mc
}

// SetParameters sets the "parameters" field.
func (mc *ModelCreate) SetParameters(tp *types.ModelParam) *ModelCreate {
	mc.mutation.SetParameters(tp)
	return mc
}

// SetContextLength sets the "context_length" field.
func (mc *ModelCreate) SetContextLength(i int) *ModelCreate {
	mc.mutation.SetContextLength(i)
	return mc
}

// SetNillableContextLength sets the "context_length" field if the given value is not nil.
func (mc *ModelCreate) SetNillableContextLength(i *int) *ModelCreate {
	if i != nil {
		mc.SetContextLength(*i)
	}
	return mc
}

// SetCreatedAt sets the "created_at" field.
func (mc *ModelCreate) SetCreatedAt(t time.Time) *ModelCreate {
	mc.mutation.SetCreatedAt(t)
	return mc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (mc *ModelCreate) SetNillableCreatedAt(t *time.Time) *ModelCreate {
	if t != nil {
		mc.SetCreatedAt(*t)
	}
	return mc
}

// SetUpdatedAt sets the "updated_at" field.
func (mc *ModelCreate) SetUpdatedAt(t time.Time) *ModelCreate {
	mc.mutation.SetUpdatedAt(t)
	return mc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (mc *ModelCreate) SetNillableUpdatedAt(t *time.Time) *ModelCreate {
	if t != nil {
		mc.SetUpdatedAt(*t)
	}
	return mc
}

// SetID sets the "id" field.
func (mc *ModelCreate) SetID(u uuid.UUID) *ModelCreate {
	mc.mutation.SetID(u)
	return mc
}

// AddTaskIDs adds the "tasks" edge to the Task entity by IDs.
func (mc *ModelCreate) AddTaskIDs(ids ...uuid.UUID) *ModelCreate {
	mc.mutation.AddTaskIDs(ids...)
	return mc
}

// AddTasks adds the "tasks" edges to the Task entity.
func (mc *ModelCreate) AddTasks(t ...*Task) *ModelCreate {
	ids := make([]uuid.UUID, len(t))
	for i := range t {
		ids[i] = t[i].ID
	}
	return mc.AddTaskIDs(ids...)
}

// SetUser sets the "user" edge to the User entity.
func (mc *ModelCreate) SetUser(u *User) *ModelCreate {
	return mc.SetUserID(u.ID)
}

// Mutation returns the ModelMutation object of the builder.
func (mc *ModelCreate) Mutation() *ModelMutation {
	return mc.mutation
}

// Save creates the Model in the database.
func (mc *ModelCreate) Save(ctx context.Context) (*Model, error) {
	mc.defaults()
	return withHooks(ctx, mc.sqlSave, mc.mutation, mc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (mc *ModelCreate) SaveX(ctx context.Context) *Model {
	v, err := mc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (mc *ModelCreate) Exec(ctx context.Context) error {
	_, err := mc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mc *ModelCreate) ExecX(ctx context.Context) {
	if err := mc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (mc *ModelCreate) defaults() {
	if _, ok := mc.mutation.IsInternal(); !ok {
		v := model.DefaultIsInternal
		mc.mutation.SetIsInternal(v)
	}
	if _, ok := mc.mutation.Status(); !ok {
		v := model.DefaultStatus
		mc.mutation.SetStatus(v)
	}
	if _, ok := mc.mutation.CreatedAt(); !ok {
		v := model.DefaultCreatedAt()
		mc.mutation.SetCreatedAt(v)
	}
	if _, ok := mc.mutation.UpdatedAt(); !ok {
		v := model.DefaultUpdatedAt()
		mc.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (mc *ModelCreate) check() error {
	if _, ok := mc.mutation.ModelName(); !ok {
		return &ValidationError{Name: "model_name", err: errors.New(`db: missing required field "Model.model_name"`)}
	}
	if _, ok := mc.mutation.ModelType(); !ok {
		return &ValidationError{Name: "model_type", err: errors.New(`db: missing required field "Model.model_type"`)}
	}
	if _, ok := mc.mutation.APIBase(); !ok {
		return &ValidationError{Name: "api_base", err: errors.New(`db: missing required field "Model.api_base"`)}
	}
	if _, ok := mc.mutation.IsInternal(); !ok {
		return &ValidationError{Name: "is_internal", err: errors.New(`db: missing required field "Model.is_internal"`)}
	}
	if _, ok := mc.mutation.Provider(); !ok {
		return &ValidationError{Name: "provider", err: errors.New(`db: missing required field "Model.provider"`)}
	}
	if _, ok := mc.mutation.Status(); !ok {
		return &ValidationError{Name: "status", err: errors.New(`db: missing required field "Model.status"`)}
	}
	if _, ok := mc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "Model.created_at"`)}
	}
	if _, ok := mc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`db: missing required field "Model.updated_at"`)}
	}
	return nil
}

func (mc *ModelCreate) sqlSave(ctx context.Context) (*Model, error) {
	if err := mc.check(); err != nil {
		return nil, err
	}
	_node, _spec := mc.createSpec()
	if err := sqlgraph.CreateNode(ctx, mc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	mc.mutation.id = &_node.ID
	mc.mutation.done = true
	return _node, nil
}

func (mc *ModelCreate) createSpec() (*Model, *sqlgraph.CreateSpec) {
	var (
		_node = &Model{config: mc.config}
		_spec = sqlgraph.NewCreateSpec(model.Table, sqlgraph.NewFieldSpec(model.FieldID, field.TypeUUID))
	)
	_spec.OnConflict = mc.conflict
	if id, ok := mc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := mc.mutation.ModelName(); ok {
		_spec.SetField(model.FieldModelName, field.TypeString, value)
		_node.ModelName = value
	}
	if value, ok := mc.mutation.ModelType(); ok {
		_spec.SetField(model.FieldModelType, field.TypeString, value)
		_node.ModelType = value
	}
	if value, ok := mc.mutation.ShowName(); ok {
		_spec.SetField(model.FieldShowName, field.TypeString, value)
		_node.ShowName = value
	}
	if value, ok := mc.mutation.APIBase(); ok {
		_spec.SetField(model.FieldAPIBase, field.TypeString, value)
		_node.APIBase = value
	}
	if value, ok := mc.mutation.APIKey(); ok {
		_spec.SetField(model.FieldAPIKey, field.TypeString, value)
		_node.APIKey = value
	}
	if value, ok := mc.mutation.APIVersion(); ok {
		_spec.SetField(model.FieldAPIVersion, field.TypeString, value)
		_node.APIVersion = value
	}
	if value, ok := mc.mutation.APIHeader(); ok {
		_spec.SetField(model.FieldAPIHeader, field.TypeString, value)
		_node.APIHeader = value
	}
	if value, ok := mc.mutation.Description(); ok {
		_spec.SetField(model.FieldDescription, field.TypeString, value)
		_node.Description = value
	}
	if value, ok := mc.mutation.IsInternal(); ok {
		_spec.SetField(model.FieldIsInternal, field.TypeBool, value)
		_node.IsInternal = value
	}
	if value, ok := mc.mutation.Provider(); ok {
		_spec.SetField(model.FieldProvider, field.TypeString, value)
		_node.Provider = value
	}
	if value, ok := mc.mutation.Status(); ok {
		_spec.SetField(model.FieldStatus, field.TypeString, value)
		_node.Status = value
	}
	if value, ok := mc.mutation.Parameters(); ok {
		_spec.SetField(model.FieldParameters, field.TypeJSON, value)
		_node.Parameters = value
	}
	if value, ok := mc.mutation.ContextLength(); ok {
		_spec.SetField(model.FieldContextLength, field.TypeInt, value)
		_node.ContextLength = value
	}
	if value, ok := mc.mutation.CreatedAt(); ok {
		_spec.SetField(model.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := mc.mutation.UpdatedAt(); ok {
		_spec.SetField(model.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	if nodes := mc.mutation.TasksIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   model.TasksTable,
			Columns: []string{model.TasksColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(task.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := mc.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   model.UserTable,
			Columns: []string{model.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.UserID = nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Model.Create().
//		SetUserID(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.ModelUpsert) {
//			SetUserID(v+v).
//		}).
//		Exec(ctx)
func (mc *ModelCreate) OnConflict(opts ...sql.ConflictOption) *ModelUpsertOne {
	mc.conflict = opts
	return &ModelUpsertOne{
		create: mc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Model.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (mc *ModelCreate) OnConflictColumns(columns ...string) *ModelUpsertOne {
	mc.conflict = append(mc.conflict, sql.ConflictColumns(columns...))
	return &ModelUpsertOne{
		create: mc,
	}
}

type (
	// ModelUpsertOne is the builder for "upsert"-ing
	//  one Model node.
	ModelUpsertOne struct {
		create *ModelCreate
	}

	// ModelUpsert is the "OnConflict" setter.
	ModelUpsert struct {
		*sql.UpdateSet
	}
)

// SetUserID sets the "user_id" field.
func (u *ModelUpsert) SetUserID(v uuid.UUID) *ModelUpsert {
	u.Set(model.FieldUserID, v)
	return u
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *ModelUpsert) UpdateUserID() *ModelUpsert {
	u.SetExcluded(model.FieldUserID)
	return u
}

// ClearUserID clears the value of the "user_id" field.
func (u *ModelUpsert) ClearUserID() *ModelUpsert {
	u.SetNull(model.FieldUserID)
	return u
}

// SetModelName sets the "model_name" field.
func (u *ModelUpsert) SetModelName(v string) *ModelUpsert {
	u.Set(model.FieldModelName, v)
	return u
}

// UpdateModelName sets the "model_name" field to the value that was provided on create.
func (u *ModelUpsert) UpdateModelName() *ModelUpsert {
	u.SetExcluded(model.FieldModelName)
	return u
}

// SetModelType sets the "model_type" field.
func (u *ModelUpsert) SetModelType(v consts.ModelType) *ModelUpsert {
	u.Set(model.FieldModelType, v)
	return u
}

// UpdateModelType sets the "model_type" field to the value that was provided on create.
func (u *ModelUpsert) UpdateModelType() *ModelUpsert {
	u.SetExcluded(model.FieldModelType)
	return u
}

// SetShowName sets the "show_name" field.
func (u *ModelUpsert) SetShowName(v string) *ModelUpsert {
	u.Set(model.FieldShowName, v)
	return u
}

// UpdateShowName sets the "show_name" field to the value that was provided on create.
func (u *ModelUpsert) UpdateShowName() *ModelUpsert {
	u.SetExcluded(model.FieldShowName)
	return u
}

// ClearShowName clears the value of the "show_name" field.
func (u *ModelUpsert) ClearShowName() *ModelUpsert {
	u.SetNull(model.FieldShowName)
	return u
}

// SetAPIBase sets the "api_base" field.
func (u *ModelUpsert) SetAPIBase(v string) *ModelUpsert {
	u.Set(model.FieldAPIBase, v)
	return u
}

// UpdateAPIBase sets the "api_base" field to the value that was provided on create.
func (u *ModelUpsert) UpdateAPIBase() *ModelUpsert {
	u.SetExcluded(model.FieldAPIBase)
	return u
}

// SetAPIKey sets the "api_key" field.
func (u *ModelUpsert) SetAPIKey(v string) *ModelUpsert {
	u.Set(model.FieldAPIKey, v)
	return u
}

// UpdateAPIKey sets the "api_key" field to the value that was provided on create.
func (u *ModelUpsert) UpdateAPIKey() *ModelUpsert {
	u.SetExcluded(model.FieldAPIKey)
	return u
}

// ClearAPIKey clears the value of the "api_key" field.
func (u *ModelUpsert) ClearAPIKey() *ModelUpsert {
	u.SetNull(model.FieldAPIKey)
	return u
}

// SetAPIVersion sets the "api_version" field.
func (u *ModelUpsert) SetAPIVersion(v string) *ModelUpsert {
	u.Set(model.FieldAPIVersion, v)
	return u
}

// UpdateAPIVersion sets the "api_version" field to the value that was provided on create.
func (u *ModelUpsert) UpdateAPIVersion() *ModelUpsert {
	u.SetExcluded(model.FieldAPIVersion)
	return u
}

// ClearAPIVersion clears the value of the "api_version" field.
func (u *ModelUpsert) ClearAPIVersion() *ModelUpsert {
	u.SetNull(model.FieldAPIVersion)
	return u
}

// SetAPIHeader sets the "api_header" field.
func (u *ModelUpsert) SetAPIHeader(v string) *ModelUpsert {
	u.Set(model.FieldAPIHeader, v)
	return u
}

// UpdateAPIHeader sets the "api_header" field to the value that was provided on create.
func (u *ModelUpsert) UpdateAPIHeader() *ModelUpsert {
	u.SetExcluded(model.FieldAPIHeader)
	return u
}

// ClearAPIHeader clears the value of the "api_header" field.
func (u *ModelUpsert) ClearAPIHeader() *ModelUpsert {
	u.SetNull(model.FieldAPIHeader)
	return u
}

// SetDescription sets the "description" field.
func (u *ModelUpsert) SetDescription(v string) *ModelUpsert {
	u.Set(model.FieldDescription, v)
	return u
}

// UpdateDescription sets the "description" field to the value that was provided on create.
func (u *ModelUpsert) UpdateDescription() *ModelUpsert {
	u.SetExcluded(model.FieldDescription)
	return u
}

// ClearDescription clears the value of the "description" field.
func (u *ModelUpsert) ClearDescription() *ModelUpsert {
	u.SetNull(model.FieldDescription)
	return u
}

// SetIsInternal sets the "is_internal" field.
func (u *ModelUpsert) SetIsInternal(v bool) *ModelUpsert {
	u.Set(model.FieldIsInternal, v)
	return u
}

// UpdateIsInternal sets the "is_internal" field to the value that was provided on create.
func (u *ModelUpsert) UpdateIsInternal() *ModelUpsert {
	u.SetExcluded(model.FieldIsInternal)
	return u
}

// SetProvider sets the "provider" field.
func (u *ModelUpsert) SetProvider(v consts.ModelProvider) *ModelUpsert {
	u.Set(model.FieldProvider, v)
	return u
}

// UpdateProvider sets the "provider" field to the value that was provided on create.
func (u *ModelUpsert) UpdateProvider() *ModelUpsert {
	u.SetExcluded(model.FieldProvider)
	return u
}

// SetStatus sets the "status" field.
func (u *ModelUpsert) SetStatus(v consts.ModelStatus) *ModelUpsert {
	u.Set(model.FieldStatus, v)
	return u
}

// UpdateStatus sets the "status" field to the value that was provided on create.
func (u *ModelUpsert) UpdateStatus() *ModelUpsert {
	u.SetExcluded(model.FieldStatus)
	return u
}

// SetParameters sets the "parameters" field.
func (u *ModelUpsert) SetParameters(v *types.ModelParam) *ModelUpsert {
	u.Set(model.FieldParameters, v)
	return u
}

// UpdateParameters sets the "parameters" field to the value that was provided on create.
func (u *ModelUpsert) UpdateParameters() *ModelUpsert {
	u.SetExcluded(model.FieldParameters)
	return u
}

// ClearParameters clears the value of the "parameters" field.
func (u *ModelUpsert) ClearParameters() *ModelUpsert {
	u.SetNull(model.FieldParameters)
	return u
}

// SetContextLength sets the "context_length" field.
func (u *ModelUpsert) SetContextLength(v int) *ModelUpsert {
	u.Set(model.FieldContextLength, v)
	return u
}

// UpdateContextLength sets the "context_length" field to the value that was provided on create.
func (u *ModelUpsert) UpdateContextLength() *ModelUpsert {
	u.SetExcluded(model.FieldContextLength)
	return u
}

// AddContextLength adds v to the "context_length" field.
func (u *ModelUpsert) AddContextLength(v int) *ModelUpsert {
	u.Add(model.FieldContextLength, v)
	return u
}

// ClearContextLength clears the value of the "context_length" field.
func (u *ModelUpsert) ClearContextLength() *ModelUpsert {
	u.SetNull(model.FieldContextLength)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *ModelUpsert) SetCreatedAt(v time.Time) *ModelUpsert {
	u.Set(model.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *ModelUpsert) UpdateCreatedAt() *ModelUpsert {
	u.SetExcluded(model.FieldCreatedAt)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *ModelUpsert) SetUpdatedAt(v time.Time) *ModelUpsert {
	u.Set(model.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *ModelUpsert) UpdateUpdatedAt() *ModelUpsert {
	u.SetExcluded(model.FieldUpdatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.Model.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(model.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *ModelUpsertOne) UpdateNewValues() *ModelUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(model.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Model.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *ModelUpsertOne) Ignore() *ModelUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *ModelUpsertOne) DoNothing() *ModelUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the ModelCreate.OnConflict
// documentation for more info.
func (u *ModelUpsertOne) Update(set func(*ModelUpsert)) *ModelUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&ModelUpsert{UpdateSet: update})
	}))
	return u
}

// SetUserID sets the "user_id" field.
func (u *ModelUpsertOne) SetUserID(v uuid.UUID) *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *ModelUpsertOne) UpdateUserID() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateUserID()
	})
}

// ClearUserID clears the value of the "user_id" field.
func (u *ModelUpsertOne) ClearUserID() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.ClearUserID()
	})
}

// SetModelName sets the "model_name" field.
func (u *ModelUpsertOne) SetModelName(v string) *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.SetModelName(v)
	})
}

// UpdateModelName sets the "model_name" field to the value that was provided on create.
func (u *ModelUpsertOne) UpdateModelName() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateModelName()
	})
}

// SetModelType sets the "model_type" field.
func (u *ModelUpsertOne) SetModelType(v consts.ModelType) *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.SetModelType(v)
	})
}

// UpdateModelType sets the "model_type" field to the value that was provided on create.
func (u *ModelUpsertOne) UpdateModelType() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateModelType()
	})
}

// SetShowName sets the "show_name" field.
func (u *ModelUpsertOne) SetShowName(v string) *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.SetShowName(v)
	})
}

// UpdateShowName sets the "show_name" field to the value that was provided on create.
func (u *ModelUpsertOne) UpdateShowName() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateShowName()
	})
}

// ClearShowName clears the value of the "show_name" field.
func (u *ModelUpsertOne) ClearShowName() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.ClearShowName()
	})
}

// SetAPIBase sets the "api_base" field.
func (u *ModelUpsertOne) SetAPIBase(v string) *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.SetAPIBase(v)
	})
}

// UpdateAPIBase sets the "api_base" field to the value that was provided on create.
func (u *ModelUpsertOne) UpdateAPIBase() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateAPIBase()
	})
}

// SetAPIKey sets the "api_key" field.
func (u *ModelUpsertOne) SetAPIKey(v string) *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.SetAPIKey(v)
	})
}

// UpdateAPIKey sets the "api_key" field to the value that was provided on create.
func (u *ModelUpsertOne) UpdateAPIKey() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateAPIKey()
	})
}

// ClearAPIKey clears the value of the "api_key" field.
func (u *ModelUpsertOne) ClearAPIKey() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.ClearAPIKey()
	})
}

// SetAPIVersion sets the "api_version" field.
func (u *ModelUpsertOne) SetAPIVersion(v string) *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.SetAPIVersion(v)
	})
}

// UpdateAPIVersion sets the "api_version" field to the value that was provided on create.
func (u *ModelUpsertOne) UpdateAPIVersion() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateAPIVersion()
	})
}

// ClearAPIVersion clears the value of the "api_version" field.
func (u *ModelUpsertOne) ClearAPIVersion() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.ClearAPIVersion()
	})
}

// SetAPIHeader sets the "api_header" field.
func (u *ModelUpsertOne) SetAPIHeader(v string) *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.SetAPIHeader(v)
	})
}

// UpdateAPIHeader sets the "api_header" field to the value that was provided on create.
func (u *ModelUpsertOne) UpdateAPIHeader() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateAPIHeader()
	})
}

// ClearAPIHeader clears the value of the "api_header" field.
func (u *ModelUpsertOne) ClearAPIHeader() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.ClearAPIHeader()
	})
}

// SetDescription sets the "description" field.
func (u *ModelUpsertOne) SetDescription(v string) *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.SetDescription(v)
	})
}

// UpdateDescription sets the "description" field to the value that was provided on create.
func (u *ModelUpsertOne) UpdateDescription() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateDescription()
	})
}

// ClearDescription clears the value of the "description" field.
func (u *ModelUpsertOne) ClearDescription() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.ClearDescription()
	})
}

// SetIsInternal sets the "is_internal" field.
func (u *ModelUpsertOne) SetIsInternal(v bool) *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.SetIsInternal(v)
	})
}

// UpdateIsInternal sets the "is_internal" field to the value that was provided on create.
func (u *ModelUpsertOne) UpdateIsInternal() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateIsInternal()
	})
}

// SetProvider sets the "provider" field.
func (u *ModelUpsertOne) SetProvider(v consts.ModelProvider) *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.SetProvider(v)
	})
}

// UpdateProvider sets the "provider" field to the value that was provided on create.
func (u *ModelUpsertOne) UpdateProvider() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateProvider()
	})
}

// SetStatus sets the "status" field.
func (u *ModelUpsertOne) SetStatus(v consts.ModelStatus) *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.SetStatus(v)
	})
}

// UpdateStatus sets the "status" field to the value that was provided on create.
func (u *ModelUpsertOne) UpdateStatus() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateStatus()
	})
}

// SetParameters sets the "parameters" field.
func (u *ModelUpsertOne) SetParameters(v *types.ModelParam) *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.SetParameters(v)
	})
}

// UpdateParameters sets the "parameters" field to the value that was provided on create.
func (u *ModelUpsertOne) UpdateParameters() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateParameters()
	})
}

// ClearParameters clears the value of the "parameters" field.
func (u *ModelUpsertOne) ClearParameters() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.ClearParameters()
	})
}

// SetContextLength sets the "context_length" field.
func (u *ModelUpsertOne) SetContextLength(v int) *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.SetContextLength(v)
	})
}

// AddContextLength adds v to the "context_length" field.
func (u *ModelUpsertOne) AddContextLength(v int) *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.AddContextLength(v)
	})
}

// UpdateContextLength sets the "context_length" field to the value that was provided on create.
func (u *ModelUpsertOne) UpdateContextLength() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateContextLength()
	})
}

// ClearContextLength clears the value of the "context_length" field.
func (u *ModelUpsertOne) ClearContextLength() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.ClearContextLength()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *ModelUpsertOne) SetCreatedAt(v time.Time) *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *ModelUpsertOne) UpdateCreatedAt() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *ModelUpsertOne) SetUpdatedAt(v time.Time) *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *ModelUpsertOne) UpdateUpdatedAt() *ModelUpsertOne {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *ModelUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for ModelCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *ModelUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *ModelUpsertOne) ID(ctx context.Context) (id uuid.UUID, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: ModelUpsertOne.ID is not supported by MySQL driver. Use ModelUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *ModelUpsertOne) IDX(ctx context.Context) uuid.UUID {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// ModelCreateBulk is the builder for creating many Model entities in bulk.
type ModelCreateBulk struct {
	config
	err      error
	builders []*ModelCreate
	conflict []sql.ConflictOption
}

// Save creates the Model entities in the database.
func (mcb *ModelCreateBulk) Save(ctx context.Context) ([]*Model, error) {
	if mcb.err != nil {
		return nil, mcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(mcb.builders))
	nodes := make([]*Model, len(mcb.builders))
	mutators := make([]Mutator, len(mcb.builders))
	for i := range mcb.builders {
		func(i int, root context.Context) {
			builder := mcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*ModelMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, mcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = mcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, mcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, mcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (mcb *ModelCreateBulk) SaveX(ctx context.Context) []*Model {
	v, err := mcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (mcb *ModelCreateBulk) Exec(ctx context.Context) error {
	_, err := mcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mcb *ModelCreateBulk) ExecX(ctx context.Context) {
	if err := mcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Model.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.ModelUpsert) {
//			SetUserID(v+v).
//		}).
//		Exec(ctx)
func (mcb *ModelCreateBulk) OnConflict(opts ...sql.ConflictOption) *ModelUpsertBulk {
	mcb.conflict = opts
	return &ModelUpsertBulk{
		create: mcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Model.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (mcb *ModelCreateBulk) OnConflictColumns(columns ...string) *ModelUpsertBulk {
	mcb.conflict = append(mcb.conflict, sql.ConflictColumns(columns...))
	return &ModelUpsertBulk{
		create: mcb,
	}
}

// ModelUpsertBulk is the builder for "upsert"-ing
// a bulk of Model nodes.
type ModelUpsertBulk struct {
	create *ModelCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.Model.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(model.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *ModelUpsertBulk) UpdateNewValues() *ModelUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(model.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Model.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *ModelUpsertBulk) Ignore() *ModelUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *ModelUpsertBulk) DoNothing() *ModelUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the ModelCreateBulk.OnConflict
// documentation for more info.
func (u *ModelUpsertBulk) Update(set func(*ModelUpsert)) *ModelUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&ModelUpsert{UpdateSet: update})
	}))
	return u
}

// SetUserID sets the "user_id" field.
func (u *ModelUpsertBulk) SetUserID(v uuid.UUID) *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.SetUserID(v)
	})
}

// UpdateUserID sets the "user_id" field to the value that was provided on create.
func (u *ModelUpsertBulk) UpdateUserID() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateUserID()
	})
}

// ClearUserID clears the value of the "user_id" field.
func (u *ModelUpsertBulk) ClearUserID() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.ClearUserID()
	})
}

// SetModelName sets the "model_name" field.
func (u *ModelUpsertBulk) SetModelName(v string) *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.SetModelName(v)
	})
}

// UpdateModelName sets the "model_name" field to the value that was provided on create.
func (u *ModelUpsertBulk) UpdateModelName() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateModelName()
	})
}

// SetModelType sets the "model_type" field.
func (u *ModelUpsertBulk) SetModelType(v consts.ModelType) *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.SetModelType(v)
	})
}

// UpdateModelType sets the "model_type" field to the value that was provided on create.
func (u *ModelUpsertBulk) UpdateModelType() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateModelType()
	})
}

// SetShowName sets the "show_name" field.
func (u *ModelUpsertBulk) SetShowName(v string) *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.SetShowName(v)
	})
}

// UpdateShowName sets the "show_name" field to the value that was provided on create.
func (u *ModelUpsertBulk) UpdateShowName() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateShowName()
	})
}

// ClearShowName clears the value of the "show_name" field.
func (u *ModelUpsertBulk) ClearShowName() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.ClearShowName()
	})
}

// SetAPIBase sets the "api_base" field.
func (u *ModelUpsertBulk) SetAPIBase(v string) *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.SetAPIBase(v)
	})
}

// UpdateAPIBase sets the "api_base" field to the value that was provided on create.
func (u *ModelUpsertBulk) UpdateAPIBase() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateAPIBase()
	})
}

// SetAPIKey sets the "api_key" field.
func (u *ModelUpsertBulk) SetAPIKey(v string) *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.SetAPIKey(v)
	})
}

// UpdateAPIKey sets the "api_key" field to the value that was provided on create.
func (u *ModelUpsertBulk) UpdateAPIKey() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateAPIKey()
	})
}

// ClearAPIKey clears the value of the "api_key" field.
func (u *ModelUpsertBulk) ClearAPIKey() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.ClearAPIKey()
	})
}

// SetAPIVersion sets the "api_version" field.
func (u *ModelUpsertBulk) SetAPIVersion(v string) *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.SetAPIVersion(v)
	})
}

// UpdateAPIVersion sets the "api_version" field to the value that was provided on create.
func (u *ModelUpsertBulk) UpdateAPIVersion() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateAPIVersion()
	})
}

// ClearAPIVersion clears the value of the "api_version" field.
func (u *ModelUpsertBulk) ClearAPIVersion() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.ClearAPIVersion()
	})
}

// SetAPIHeader sets the "api_header" field.
func (u *ModelUpsertBulk) SetAPIHeader(v string) *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.SetAPIHeader(v)
	})
}

// UpdateAPIHeader sets the "api_header" field to the value that was provided on create.
func (u *ModelUpsertBulk) UpdateAPIHeader() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateAPIHeader()
	})
}

// ClearAPIHeader clears the value of the "api_header" field.
func (u *ModelUpsertBulk) ClearAPIHeader() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.ClearAPIHeader()
	})
}

// SetDescription sets the "description" field.
func (u *ModelUpsertBulk) SetDescription(v string) *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.SetDescription(v)
	})
}

// UpdateDescription sets the "description" field to the value that was provided on create.
func (u *ModelUpsertBulk) UpdateDescription() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateDescription()
	})
}

// ClearDescription clears the value of the "description" field.
func (u *ModelUpsertBulk) ClearDescription() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.ClearDescription()
	})
}

// SetIsInternal sets the "is_internal" field.
func (u *ModelUpsertBulk) SetIsInternal(v bool) *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.SetIsInternal(v)
	})
}

// UpdateIsInternal sets the "is_internal" field to the value that was provided on create.
func (u *ModelUpsertBulk) UpdateIsInternal() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateIsInternal()
	})
}

// SetProvider sets the "provider" field.
func (u *ModelUpsertBulk) SetProvider(v consts.ModelProvider) *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.SetProvider(v)
	})
}

// UpdateProvider sets the "provider" field to the value that was provided on create.
func (u *ModelUpsertBulk) UpdateProvider() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateProvider()
	})
}

// SetStatus sets the "status" field.
func (u *ModelUpsertBulk) SetStatus(v consts.ModelStatus) *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.SetStatus(v)
	})
}

// UpdateStatus sets the "status" field to the value that was provided on create.
func (u *ModelUpsertBulk) UpdateStatus() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateStatus()
	})
}

// SetParameters sets the "parameters" field.
func (u *ModelUpsertBulk) SetParameters(v *types.ModelParam) *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.SetParameters(v)
	})
}

// UpdateParameters sets the "parameters" field to the value that was provided on create.
func (u *ModelUpsertBulk) UpdateParameters() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateParameters()
	})
}

// ClearParameters clears the value of the "parameters" field.
func (u *ModelUpsertBulk) ClearParameters() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.ClearParameters()
	})
}

// SetContextLength sets the "context_length" field.
func (u *ModelUpsertBulk) SetContextLength(v int) *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.SetContextLength(v)
	})
}

// AddContextLength adds v to the "context_length" field.
func (u *ModelUpsertBulk) AddContextLength(v int) *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.AddContextLength(v)
	})
}

// UpdateContextLength sets the "context_length" field to the value that was provided on create.
func (u *ModelUpsertBulk) UpdateContextLength() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateContextLength()
	})
}

// ClearContextLength clears the value of the "context_length" field.
func (u *ModelUpsertBulk) ClearContextLength() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.ClearContextLength()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *ModelUpsertBulk) SetCreatedAt(v time.Time) *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *ModelUpsertBulk) UpdateCreatedAt() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *ModelUpsertBulk) SetUpdatedAt(v time.Time) *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *ModelUpsertBulk) UpdateUpdatedAt() *ModelUpsertBulk {
	return u.Update(func(s *ModelUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *ModelUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the ModelCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for ModelCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *ModelUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
