// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/consts"
	"github.com/chaitin/MonkeyCode/backend/db/model"
	"github.com/chaitin/MonkeyCode/backend/db/predicate"
	"github.com/chaitin/MonkeyCode/backend/db/task"
	"github.com/chaitin/MonkeyCode/backend/db/user"
	"github.com/chaitin/MonkeyCode/backend/ent/types"
	"github.com/google/uuid"
)

// ModelUpdate is the builder for updating Model entities.
type ModelUpdate struct {
	config
	hooks     []Hook
	mutation  *ModelMutation
	modifiers []func(*sql.UpdateBuilder)
}

// Where appends a list predicates to the ModelUpdate builder.
func (mu *ModelUpdate) Where(ps ...predicate.Model) *ModelUpdate {
	mu.mutation.Where(ps...)
	return mu
}

// SetUserID sets the "user_id" field.
func (mu *ModelUpdate) SetUserID(u uuid.UUID) *ModelUpdate {
	mu.mutation.SetUserID(u)
	return mu
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (mu *ModelUpdate) SetNillableUserID(u *uuid.UUID) *ModelUpdate {
	if u != nil {
		mu.SetUserID(*u)
	}
	return mu
}

// ClearUserID clears the value of the "user_id" field.
func (mu *ModelUpdate) ClearUserID() *ModelUpdate {
	mu.mutation.ClearUserID()
	return mu
}

// SetModelName sets the "model_name" field.
func (mu *ModelUpdate) SetModelName(s string) *ModelUpdate {
	mu.mutation.SetModelName(s)
	return mu
}

// SetNillableModelName sets the "model_name" field if the given value is not nil.
func (mu *ModelUpdate) SetNillableModelName(s *string) *ModelUpdate {
	if s != nil {
		mu.SetModelName(*s)
	}
	return mu
}

// SetModelType sets the "model_type" field.
func (mu *ModelUpdate) SetModelType(ct consts.ModelType) *ModelUpdate {
	mu.mutation.SetModelType(ct)
	return mu
}

// SetNillableModelType sets the "model_type" field if the given value is not nil.
func (mu *ModelUpdate) SetNillableModelType(ct *consts.ModelType) *ModelUpdate {
	if ct != nil {
		mu.SetModelType(*ct)
	}
	return mu
}

// SetShowName sets the "show_name" field.
func (mu *ModelUpdate) SetShowName(s string) *ModelUpdate {
	mu.mutation.SetShowName(s)
	return mu
}

// SetNillableShowName sets the "show_name" field if the given value is not nil.
func (mu *ModelUpdate) SetNillableShowName(s *string) *ModelUpdate {
	if s != nil {
		mu.SetShowName(*s)
	}
	return mu
}

// ClearShowName clears the value of the "show_name" field.
func (mu *ModelUpdate) ClearShowName() *ModelUpdate {
	mu.mutation.ClearShowName()
	return mu
}

// SetAPIBase sets the "api_base" field.
func (mu *ModelUpdate) SetAPIBase(s string) *ModelUpdate {
	mu.mutation.SetAPIBase(s)
	return mu
}

// SetNillableAPIBase sets the "api_base" field if the given value is not nil.
func (mu *ModelUpdate) SetNillableAPIBase(s *string) *ModelUpdate {
	if s != nil {
		mu.SetAPIBase(*s)
	}
	return mu
}

// SetAPIKey sets the "api_key" field.
func (mu *ModelUpdate) SetAPIKey(s string) *ModelUpdate {
	mu.mutation.SetAPIKey(s)
	return mu
}

// SetNillableAPIKey sets the "api_key" field if the given value is not nil.
func (mu *ModelUpdate) SetNillableAPIKey(s *string) *ModelUpdate {
	if s != nil {
		mu.SetAPIKey(*s)
	}
	return mu
}

// ClearAPIKey clears the value of the "api_key" field.
func (mu *ModelUpdate) ClearAPIKey() *ModelUpdate {
	mu.mutation.ClearAPIKey()
	return mu
}

// SetAPIVersion sets the "api_version" field.
func (mu *ModelUpdate) SetAPIVersion(s string) *ModelUpdate {
	mu.mutation.SetAPIVersion(s)
	return mu
}

// SetNillableAPIVersion sets the "api_version" field if the given value is not nil.
func (mu *ModelUpdate) SetNillableAPIVersion(s *string) *ModelUpdate {
	if s != nil {
		mu.SetAPIVersion(*s)
	}
	return mu
}

// ClearAPIVersion clears the value of the "api_version" field.
func (mu *ModelUpdate) ClearAPIVersion() *ModelUpdate {
	mu.mutation.ClearAPIVersion()
	return mu
}

// SetAPIHeader sets the "api_header" field.
func (mu *ModelUpdate) SetAPIHeader(s string) *ModelUpdate {
	mu.mutation.SetAPIHeader(s)
	return mu
}

// SetNillableAPIHeader sets the "api_header" field if the given value is not nil.
func (mu *ModelUpdate) SetNillableAPIHeader(s *string) *ModelUpdate {
	if s != nil {
		mu.SetAPIHeader(*s)
	}
	return mu
}

// ClearAPIHeader clears the value of the "api_header" field.
func (mu *ModelUpdate) ClearAPIHeader() *ModelUpdate {
	mu.mutation.ClearAPIHeader()
	return mu
}

// SetDescription sets the "description" field.
func (mu *ModelUpdate) SetDescription(s string) *ModelUpdate {
	mu.mutation.SetDescription(s)
	return mu
}

// SetNillableDescription sets the "description" field if the given value is not nil.
func (mu *ModelUpdate) SetNillableDescription(s *string) *ModelUpdate {
	if s != nil {
		mu.SetDescription(*s)
	}
	return mu
}

// ClearDescription clears the value of the "description" field.
func (mu *ModelUpdate) ClearDescription() *ModelUpdate {
	mu.mutation.ClearDescription()
	return mu
}

// SetIsInternal sets the "is_internal" field.
func (mu *ModelUpdate) SetIsInternal(b bool) *ModelUpdate {
	mu.mutation.SetIsInternal(b)
	return mu
}

// SetNillableIsInternal sets the "is_internal" field if the given value is not nil.
func (mu *ModelUpdate) SetNillableIsInternal(b *bool) *ModelUpdate {
	if b != nil {
		mu.SetIsInternal(*b)
	}
	return mu
}

// SetProvider sets the "provider" field.
func (mu *ModelUpdate) SetProvider(cp consts.ModelProvider) *ModelUpdate {
	mu.mutation.SetProvider(cp)
	return mu
}

// SetNillableProvider sets the "provider" field if the given value is not nil.
func (mu *ModelUpdate) SetNillableProvider(cp *consts.ModelProvider) *ModelUpdate {
	if cp != nil {
		mu.SetProvider(*cp)
	}
	return mu
}

// SetStatus sets the "status" field.
func (mu *ModelUpdate) SetStatus(cs consts.ModelStatus) *ModelUpdate {
	mu.mutation.SetStatus(cs)
	return mu
}

// SetNillableStatus sets the "status" field if the given value is not nil.
func (mu *ModelUpdate) SetNillableStatus(cs *consts.ModelStatus) *ModelUpdate {
	if cs != nil {
		mu.SetStatus(*cs)
	}
	return mu
}

// SetParameters sets the "parameters" field.
func (mu *ModelUpdate) SetParameters(tp *types.ModelParam) *ModelUpdate {
	mu.mutation.SetParameters(tp)
	return mu
}

// ClearParameters clears the value of the "parameters" field.
func (mu *ModelUpdate) ClearParameters() *ModelUpdate {
	mu.mutation.ClearParameters()
	return mu
}

// SetContextLength sets the "context_length" field.
func (mu *ModelUpdate) SetContextLength(i int) *ModelUpdate {
	mu.mutation.ResetContextLength()
	mu.mutation.SetContextLength(i)
	return mu
}

// SetNillableContextLength sets the "context_length" field if the given value is not nil.
func (mu *ModelUpdate) SetNillableContextLength(i *int) *ModelUpdate {
	if i != nil {
		mu.SetContextLength(*i)
	}
	return mu
}

// AddContextLength adds i to the "context_length" field.
func (mu *ModelUpdate) AddContextLength(i int) *ModelUpdate {
	mu.mutation.AddContextLength(i)
	return mu
}

// ClearContextLength clears the value of the "context_length" field.
func (mu *ModelUpdate) ClearContextLength() *ModelUpdate {
	mu.mutation.ClearContextLength()
	return mu
}

// SetCreatedAt sets the "created_at" field.
func (mu *ModelUpdate) SetCreatedAt(t time.Time) *ModelUpdate {
	mu.mutation.SetCreatedAt(t)
	return mu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (mu *ModelUpdate) SetNillableCreatedAt(t *time.Time) *ModelUpdate {
	if t != nil {
		mu.SetCreatedAt(*t)
	}
	return mu
}

// SetUpdatedAt sets the "updated_at" field.
func (mu *ModelUpdate) SetUpdatedAt(t time.Time) *ModelUpdate {
	mu.mutation.SetUpdatedAt(t)
	return mu
}

// AddTaskIDs adds the "tasks" edge to the Task entity by IDs.
func (mu *ModelUpdate) AddTaskIDs(ids ...uuid.UUID) *ModelUpdate {
	mu.mutation.AddTaskIDs(ids...)
	return mu
}

// AddTasks adds the "tasks" edges to the Task entity.
func (mu *ModelUpdate) AddTasks(t ...*Task) *ModelUpdate {
	ids := make([]uuid.UUID, len(t))
	for i := range t {
		ids[i] = t[i].ID
	}
	return mu.AddTaskIDs(ids...)
}

// SetUser sets the "user" edge to the User entity.
func (mu *ModelUpdate) SetUser(u *User) *ModelUpdate {
	return mu.SetUserID(u.ID)
}

// Mutation returns the ModelMutation object of the builder.
func (mu *ModelUpdate) Mutation() *ModelMutation {
	return mu.mutation
}

// ClearTasks clears all "tasks" edges to the Task entity.
func (mu *ModelUpdate) ClearTasks() *ModelUpdate {
	mu.mutation.ClearTasks()
	return mu
}

// RemoveTaskIDs removes the "tasks" edge to Task entities by IDs.
func (mu *ModelUpdate) RemoveTaskIDs(ids ...uuid.UUID) *ModelUpdate {
	mu.mutation.RemoveTaskIDs(ids...)
	return mu
}

// RemoveTasks removes "tasks" edges to Task entities.
func (mu *ModelUpdate) RemoveTasks(t ...*Task) *ModelUpdate {
	ids := make([]uuid.UUID, len(t))
	for i := range t {
		ids[i] = t[i].ID
	}
	return mu.RemoveTaskIDs(ids...)
}

// ClearUser clears the "user" edge to the User entity.
func (mu *ModelUpdate) ClearUser() *ModelUpdate {
	mu.mutation.ClearUser()
	return mu
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (mu *ModelUpdate) Save(ctx context.Context) (int, error) {
	mu.defaults()
	return withHooks(ctx, mu.sqlSave, mu.mutation, mu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (mu *ModelUpdate) SaveX(ctx context.Context) int {
	affected, err := mu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (mu *ModelUpdate) Exec(ctx context.Context) error {
	_, err := mu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mu *ModelUpdate) ExecX(ctx context.Context) {
	if err := mu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (mu *ModelUpdate) defaults() {
	if _, ok := mu.mutation.UpdatedAt(); !ok {
		v := model.UpdateDefaultUpdatedAt()
		mu.mutation.SetUpdatedAt(v)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (mu *ModelUpdate) Modify(modifiers ...func(u *sql.UpdateBuilder)) *ModelUpdate {
	mu.modifiers = append(mu.modifiers, modifiers...)
	return mu
}

func (mu *ModelUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(model.Table, model.Columns, sqlgraph.NewFieldSpec(model.FieldID, field.TypeUUID))
	if ps := mu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := mu.mutation.ModelName(); ok {
		_spec.SetField(model.FieldModelName, field.TypeString, value)
	}
	if value, ok := mu.mutation.ModelType(); ok {
		_spec.SetField(model.FieldModelType, field.TypeString, value)
	}
	if value, ok := mu.mutation.ShowName(); ok {
		_spec.SetField(model.FieldShowName, field.TypeString, value)
	}
	if mu.mutation.ShowNameCleared() {
		_spec.ClearField(model.FieldShowName, field.TypeString)
	}
	if value, ok := mu.mutation.APIBase(); ok {
		_spec.SetField(model.FieldAPIBase, field.TypeString, value)
	}
	if value, ok := mu.mutation.APIKey(); ok {
		_spec.SetField(model.FieldAPIKey, field.TypeString, value)
	}
	if mu.mutation.APIKeyCleared() {
		_spec.ClearField(model.FieldAPIKey, field.TypeString)
	}
	if value, ok := mu.mutation.APIVersion(); ok {
		_spec.SetField(model.FieldAPIVersion, field.TypeString, value)
	}
	if mu.mutation.APIVersionCleared() {
		_spec.ClearField(model.FieldAPIVersion, field.TypeString)
	}
	if value, ok := mu.mutation.APIHeader(); ok {
		_spec.SetField(model.FieldAPIHeader, field.TypeString, value)
	}
	if mu.mutation.APIHeaderCleared() {
		_spec.ClearField(model.FieldAPIHeader, field.TypeString)
	}
	if value, ok := mu.mutation.Description(); ok {
		_spec.SetField(model.FieldDescription, field.TypeString, value)
	}
	if mu.mutation.DescriptionCleared() {
		_spec.ClearField(model.FieldDescription, field.TypeString)
	}
	if value, ok := mu.mutation.IsInternal(); ok {
		_spec.SetField(model.FieldIsInternal, field.TypeBool, value)
	}
	if value, ok := mu.mutation.Provider(); ok {
		_spec.SetField(model.FieldProvider, field.TypeString, value)
	}
	if value, ok := mu.mutation.Status(); ok {
		_spec.SetField(model.FieldStatus, field.TypeString, value)
	}
	if value, ok := mu.mutation.Parameters(); ok {
		_spec.SetField(model.FieldParameters, field.TypeJSON, value)
	}
	if mu.mutation.ParametersCleared() {
		_spec.ClearField(model.FieldParameters, field.TypeJSON)
	}
	if value, ok := mu.mutation.ContextLength(); ok {
		_spec.SetField(model.FieldContextLength, field.TypeInt, value)
	}
	if value, ok := mu.mutation.AddedContextLength(); ok {
		_spec.AddField(model.FieldContextLength, field.TypeInt, value)
	}
	if mu.mutation.ContextLengthCleared() {
		_spec.ClearField(model.FieldContextLength, field.TypeInt)
	}
	if value, ok := mu.mutation.CreatedAt(); ok {
		_spec.SetField(model.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := mu.mutation.UpdatedAt(); ok {
		_spec.SetField(model.FieldUpdatedAt, field.TypeTime, value)
	}
	if mu.mutation.TasksCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   model.TasksTable,
			Columns: []string{model.TasksColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(task.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := mu.mutation.RemovedTasksIDs(); len(nodes) > 0 && !mu.mutation.TasksCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   model.TasksTable,
			Columns: []string{model.TasksColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(task.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := mu.mutation.TasksIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   model.TasksTable,
			Columns: []string{model.TasksColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(task.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if mu.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   model.UserTable,
			Columns: []string{model.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := mu.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   model.UserTable,
			Columns: []string{model.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(mu.modifiers...)
	if n, err = sqlgraph.UpdateNodes(ctx, mu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{model.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	mu.mutation.done = true
	return n, nil
}

// ModelUpdateOne is the builder for updating a single Model entity.
type ModelUpdateOne struct {
	config
	fields    []string
	hooks     []Hook
	mutation  *ModelMutation
	modifiers []func(*sql.UpdateBuilder)
}

// SetUserID sets the "user_id" field.
func (muo *ModelUpdateOne) SetUserID(u uuid.UUID) *ModelUpdateOne {
	muo.mutation.SetUserID(u)
	return muo
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (muo *ModelUpdateOne) SetNillableUserID(u *uuid.UUID) *ModelUpdateOne {
	if u != nil {
		muo.SetUserID(*u)
	}
	return muo
}

// ClearUserID clears the value of the "user_id" field.
func (muo *ModelUpdateOne) ClearUserID() *ModelUpdateOne {
	muo.mutation.ClearUserID()
	return muo
}

// SetModelName sets the "model_name" field.
func (muo *ModelUpdateOne) SetModelName(s string) *ModelUpdateOne {
	muo.mutation.SetModelName(s)
	return muo
}

// SetNillableModelName sets the "model_name" field if the given value is not nil.
func (muo *ModelUpdateOne) SetNillableModelName(s *string) *ModelUpdateOne {
	if s != nil {
		muo.SetModelName(*s)
	}
	return muo
}

// SetModelType sets the "model_type" field.
func (muo *ModelUpdateOne) SetModelType(ct consts.ModelType) *ModelUpdateOne {
	muo.mutation.SetModelType(ct)
	return muo
}

// SetNillableModelType sets the "model_type" field if the given value is not nil.
func (muo *ModelUpdateOne) SetNillableModelType(ct *consts.ModelType) *ModelUpdateOne {
	if ct != nil {
		muo.SetModelType(*ct)
	}
	return muo
}

// SetShowName sets the "show_name" field.
func (muo *ModelUpdateOne) SetShowName(s string) *ModelUpdateOne {
	muo.mutation.SetShowName(s)
	return muo
}

// SetNillableShowName sets the "show_name" field if the given value is not nil.
func (muo *ModelUpdateOne) SetNillableShowName(s *string) *ModelUpdateOne {
	if s != nil {
		muo.SetShowName(*s)
	}
	return muo
}

// ClearShowName clears the value of the "show_name" field.
func (muo *ModelUpdateOne) ClearShowName() *ModelUpdateOne {
	muo.mutation.ClearShowName()
	return muo
}

// SetAPIBase sets the "api_base" field.
func (muo *ModelUpdateOne) SetAPIBase(s string) *ModelUpdateOne {
	muo.mutation.SetAPIBase(s)
	return muo
}

// SetNillableAPIBase sets the "api_base" field if the given value is not nil.
func (muo *ModelUpdateOne) SetNillableAPIBase(s *string) *ModelUpdateOne {
	if s != nil {
		muo.SetAPIBase(*s)
	}
	return muo
}

// SetAPIKey sets the "api_key" field.
func (muo *ModelUpdateOne) SetAPIKey(s string) *ModelUpdateOne {
	muo.mutation.SetAPIKey(s)
	return muo
}

// SetNillableAPIKey sets the "api_key" field if the given value is not nil.
func (muo *ModelUpdateOne) SetNillableAPIKey(s *string) *ModelUpdateOne {
	if s != nil {
		muo.SetAPIKey(*s)
	}
	return muo
}

// ClearAPIKey clears the value of the "api_key" field.
func (muo *ModelUpdateOne) ClearAPIKey() *ModelUpdateOne {
	muo.mutation.ClearAPIKey()
	return muo
}

// SetAPIVersion sets the "api_version" field.
func (muo *ModelUpdateOne) SetAPIVersion(s string) *ModelUpdateOne {
	muo.mutation.SetAPIVersion(s)
	return muo
}

// SetNillableAPIVersion sets the "api_version" field if the given value is not nil.
func (muo *ModelUpdateOne) SetNillableAPIVersion(s *string) *ModelUpdateOne {
	if s != nil {
		muo.SetAPIVersion(*s)
	}
	return muo
}

// ClearAPIVersion clears the value of the "api_version" field.
func (muo *ModelUpdateOne) ClearAPIVersion() *ModelUpdateOne {
	muo.mutation.ClearAPIVersion()
	return muo
}

// SetAPIHeader sets the "api_header" field.
func (muo *ModelUpdateOne) SetAPIHeader(s string) *ModelUpdateOne {
	muo.mutation.SetAPIHeader(s)
	return muo
}

// SetNillableAPIHeader sets the "api_header" field if the given value is not nil.
func (muo *ModelUpdateOne) SetNillableAPIHeader(s *string) *ModelUpdateOne {
	if s != nil {
		muo.SetAPIHeader(*s)
	}
	return muo
}

// ClearAPIHeader clears the value of the "api_header" field.
func (muo *ModelUpdateOne) ClearAPIHeader() *ModelUpdateOne {
	muo.mutation.ClearAPIHeader()
	return muo
}

// SetDescription sets the "description" field.
func (muo *ModelUpdateOne) SetDescription(s string) *ModelUpdateOne {
	muo.mutation.SetDescription(s)
	return muo
}

// SetNillableDescription sets the "description" field if the given value is not nil.
func (muo *ModelUpdateOne) SetNillableDescription(s *string) *ModelUpdateOne {
	if s != nil {
		muo.SetDescription(*s)
	}
	return muo
}

// ClearDescription clears the value of the "description" field.
func (muo *ModelUpdateOne) ClearDescription() *ModelUpdateOne {
	muo.mutation.ClearDescription()
	return muo
}

// SetIsInternal sets the "is_internal" field.
func (muo *ModelUpdateOne) SetIsInternal(b bool) *ModelUpdateOne {
	muo.mutation.SetIsInternal(b)
	return muo
}

// SetNillableIsInternal sets the "is_internal" field if the given value is not nil.
func (muo *ModelUpdateOne) SetNillableIsInternal(b *bool) *ModelUpdateOne {
	if b != nil {
		muo.SetIsInternal(*b)
	}
	return muo
}

// SetProvider sets the "provider" field.
func (muo *ModelUpdateOne) SetProvider(cp consts.ModelProvider) *ModelUpdateOne {
	muo.mutation.SetProvider(cp)
	return muo
}

// SetNillableProvider sets the "provider" field if the given value is not nil.
func (muo *ModelUpdateOne) SetNillableProvider(cp *consts.ModelProvider) *ModelUpdateOne {
	if cp != nil {
		muo.SetProvider(*cp)
	}
	return muo
}

// SetStatus sets the "status" field.
func (muo *ModelUpdateOne) SetStatus(cs consts.ModelStatus) *ModelUpdateOne {
	muo.mutation.SetStatus(cs)
	return muo
}

// SetNillableStatus sets the "status" field if the given value is not nil.
func (muo *ModelUpdateOne) SetNillableStatus(cs *consts.ModelStatus) *ModelUpdateOne {
	if cs != nil {
		muo.SetStatus(*cs)
	}
	return muo
}

// SetParameters sets the "parameters" field.
func (muo *ModelUpdateOne) SetParameters(tp *types.ModelParam) *ModelUpdateOne {
	muo.mutation.SetParameters(tp)
	return muo
}

// ClearParameters clears the value of the "parameters" field.
func (muo *ModelUpdateOne) ClearParameters() *ModelUpdateOne {
	muo.mutation.ClearParameters()
	return muo
}

// SetContextLength sets the "context_length" field.
func (muo *ModelUpdateOne) SetContextLength(i int) *ModelUpdateOne {
	muo.mutation.ResetContextLength()
	muo.mutation.SetContextLength(i)
	return muo
}

// SetNillableContextLength sets the "context_length" field if the given value is not nil.
func (muo *ModelUpdateOne) SetNillableContextLength(i *int) *ModelUpdateOne {
	if i != nil {
		muo.SetContextLength(*i)
	}
	return muo
}

// AddContextLength adds i to the "context_length" field.
func (muo *ModelUpdateOne) AddContextLength(i int) *ModelUpdateOne {
	muo.mutation.AddContextLength(i)
	return muo
}

// ClearContextLength clears the value of the "context_length" field.
func (muo *ModelUpdateOne) ClearContextLength() *ModelUpdateOne {
	muo.mutation.ClearContextLength()
	return muo
}

// SetCreatedAt sets the "created_at" field.
func (muo *ModelUpdateOne) SetCreatedAt(t time.Time) *ModelUpdateOne {
	muo.mutation.SetCreatedAt(t)
	return muo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (muo *ModelUpdateOne) SetNillableCreatedAt(t *time.Time) *ModelUpdateOne {
	if t != nil {
		muo.SetCreatedAt(*t)
	}
	return muo
}

// SetUpdatedAt sets the "updated_at" field.
func (muo *ModelUpdateOne) SetUpdatedAt(t time.Time) *ModelUpdateOne {
	muo.mutation.SetUpdatedAt(t)
	return muo
}

// AddTaskIDs adds the "tasks" edge to the Task entity by IDs.
func (muo *ModelUpdateOne) AddTaskIDs(ids ...uuid.UUID) *ModelUpdateOne {
	muo.mutation.AddTaskIDs(ids...)
	return muo
}

// AddTasks adds the "tasks" edges to the Task entity.
func (muo *ModelUpdateOne) AddTasks(t ...*Task) *ModelUpdateOne {
	ids := make([]uuid.UUID, len(t))
	for i := range t {
		ids[i] = t[i].ID
	}
	return muo.AddTaskIDs(ids...)
}

// SetUser sets the "user" edge to the User entity.
func (muo *ModelUpdateOne) SetUser(u *User) *ModelUpdateOne {
	return muo.SetUserID(u.ID)
}

// Mutation returns the ModelMutation object of the builder.
func (muo *ModelUpdateOne) Mutation() *ModelMutation {
	return muo.mutation
}

// ClearTasks clears all "tasks" edges to the Task entity.
func (muo *ModelUpdateOne) ClearTasks() *ModelUpdateOne {
	muo.mutation.ClearTasks()
	return muo
}

// RemoveTaskIDs removes the "tasks" edge to Task entities by IDs.
func (muo *ModelUpdateOne) RemoveTaskIDs(ids ...uuid.UUID) *ModelUpdateOne {
	muo.mutation.RemoveTaskIDs(ids...)
	return muo
}

// RemoveTasks removes "tasks" edges to Task entities.
func (muo *ModelUpdateOne) RemoveTasks(t ...*Task) *ModelUpdateOne {
	ids := make([]uuid.UUID, len(t))
	for i := range t {
		ids[i] = t[i].ID
	}
	return muo.RemoveTaskIDs(ids...)
}

// ClearUser clears the "user" edge to the User entity.
func (muo *ModelUpdateOne) ClearUser() *ModelUpdateOne {
	muo.mutation.ClearUser()
	return muo
}

// Where appends a list predicates to the ModelUpdate builder.
func (muo *ModelUpdateOne) Where(ps ...predicate.Model) *ModelUpdateOne {
	muo.mutation.Where(ps...)
	return muo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (muo *ModelUpdateOne) Select(field string, fields ...string) *ModelUpdateOne {
	muo.fields = append([]string{field}, fields...)
	return muo
}

// Save executes the query and returns the updated Model entity.
func (muo *ModelUpdateOne) Save(ctx context.Context) (*Model, error) {
	muo.defaults()
	return withHooks(ctx, muo.sqlSave, muo.mutation, muo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (muo *ModelUpdateOne) SaveX(ctx context.Context) *Model {
	node, err := muo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (muo *ModelUpdateOne) Exec(ctx context.Context) error {
	_, err := muo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (muo *ModelUpdateOne) ExecX(ctx context.Context) {
	if err := muo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (muo *ModelUpdateOne) defaults() {
	if _, ok := muo.mutation.UpdatedAt(); !ok {
		v := model.UpdateDefaultUpdatedAt()
		muo.mutation.SetUpdatedAt(v)
	}
}

// Modify adds a statement modifier for attaching custom logic to the UPDATE statement.
func (muo *ModelUpdateOne) Modify(modifiers ...func(u *sql.UpdateBuilder)) *ModelUpdateOne {
	muo.modifiers = append(muo.modifiers, modifiers...)
	return muo
}

func (muo *ModelUpdateOne) sqlSave(ctx context.Context) (_node *Model, err error) {
	_spec := sqlgraph.NewUpdateSpec(model.Table, model.Columns, sqlgraph.NewFieldSpec(model.FieldID, field.TypeUUID))
	id, ok := muo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`db: missing "Model.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := muo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, model.FieldID)
		for _, f := range fields {
			if !model.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("db: invalid field %q for query", f)}
			}
			if f != model.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := muo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := muo.mutation.ModelName(); ok {
		_spec.SetField(model.FieldModelName, field.TypeString, value)
	}
	if value, ok := muo.mutation.ModelType(); ok {
		_spec.SetField(model.FieldModelType, field.TypeString, value)
	}
	if value, ok := muo.mutation.ShowName(); ok {
		_spec.SetField(model.FieldShowName, field.TypeString, value)
	}
	if muo.mutation.ShowNameCleared() {
		_spec.ClearField(model.FieldShowName, field.TypeString)
	}
	if value, ok := muo.mutation.APIBase(); ok {
		_spec.SetField(model.FieldAPIBase, field.TypeString, value)
	}
	if value, ok := muo.mutation.APIKey(); ok {
		_spec.SetField(model.FieldAPIKey, field.TypeString, value)
	}
	if muo.mutation.APIKeyCleared() {
		_spec.ClearField(model.FieldAPIKey, field.TypeString)
	}
	if value, ok := muo.mutation.APIVersion(); ok {
		_spec.SetField(model.FieldAPIVersion, field.TypeString, value)
	}
	if muo.mutation.APIVersionCleared() {
		_spec.ClearField(model.FieldAPIVersion, field.TypeString)
	}
	if value, ok := muo.mutation.APIHeader(); ok {
		_spec.SetField(model.FieldAPIHeader, field.TypeString, value)
	}
	if muo.mutation.APIHeaderCleared() {
		_spec.ClearField(model.FieldAPIHeader, field.TypeString)
	}
	if value, ok := muo.mutation.Description(); ok {
		_spec.SetField(model.FieldDescription, field.TypeString, value)
	}
	if muo.mutation.DescriptionCleared() {
		_spec.ClearField(model.FieldDescription, field.TypeString)
	}
	if value, ok := muo.mutation.IsInternal(); ok {
		_spec.SetField(model.FieldIsInternal, field.TypeBool, value)
	}
	if value, ok := muo.mutation.Provider(); ok {
		_spec.SetField(model.FieldProvider, field.TypeString, value)
	}
	if value, ok := muo.mutation.Status(); ok {
		_spec.SetField(model.FieldStatus, field.TypeString, value)
	}
	if value, ok := muo.mutation.Parameters(); ok {
		_spec.SetField(model.FieldParameters, field.TypeJSON, value)
	}
	if muo.mutation.ParametersCleared() {
		_spec.ClearField(model.FieldParameters, field.TypeJSON)
	}
	if value, ok := muo.mutation.ContextLength(); ok {
		_spec.SetField(model.FieldContextLength, field.TypeInt, value)
	}
	if value, ok := muo.mutation.AddedContextLength(); ok {
		_spec.AddField(model.FieldContextLength, field.TypeInt, value)
	}
	if muo.mutation.ContextLengthCleared() {
		_spec.ClearField(model.FieldContextLength, field.TypeInt)
	}
	if value, ok := muo.mutation.CreatedAt(); ok {
		_spec.SetField(model.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := muo.mutation.UpdatedAt(); ok {
		_spec.SetField(model.FieldUpdatedAt, field.TypeTime, value)
	}
	if muo.mutation.TasksCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   model.TasksTable,
			Columns: []string{model.TasksColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(task.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := muo.mutation.RemovedTasksIDs(); len(nodes) > 0 && !muo.mutation.TasksCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   model.TasksTable,
			Columns: []string{model.TasksColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(task.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := muo.mutation.TasksIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   model.TasksTable,
			Columns: []string{model.TasksColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(task.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if muo.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   model.UserTable,
			Columns: []string{model.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := muo.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   model.UserTable,
			Columns: []string{model.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_spec.AddModifiers(muo.modifiers...)
	_node = &Model{config: muo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, muo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{model.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	muo.mutation.done = true
	return _node, nil
}
