// Code generated by ent, DO NOT EDIT.

package modelprovider

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the modelprovider type in the database.
	Label = "model_provider"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldName holds the string denoting the name field in the database.
	FieldName = "name"
	// FieldAPIBase holds the string denoting the api_base field in the database.
	FieldAPIBase = "api_base"
	// FieldPriority holds the string denoting the priority field in the database.
	FieldPriority = "priority"
	// FieldCreatedAt holds the string denoting the created_at field in the database.
	FieldCreatedAt = "created_at"
	// FieldUpdatedAt holds the string denoting the updated_at field in the database.
	FieldUpdatedAt = "updated_at"
	// EdgeModels holds the string denoting the models edge name in mutations.
	EdgeModels = "models"
	// Table holds the table name of the modelprovider in the database.
	Table = "model_providers"
	// ModelsTable is the table that holds the models relation/edge.
	ModelsTable = "model_provider_models"
	// ModelsInverseTable is the table name for the ModelProviderModel entity.
	// It exists in this package in order to avoid circular dependency with the "modelprovidermodel" package.
	ModelsInverseTable = "model_provider_models"
	// ModelsColumn is the table column denoting the models relation/edge.
	ModelsColumn = "provider_id"
)

// Columns holds all SQL columns for modelprovider fields.
var Columns = []string{
	FieldID,
	FieldName,
	FieldAPIBase,
	FieldPriority,
	FieldCreatedAt,
	FieldUpdatedAt,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// NameValidator is a validator for the "name" field. It is called by the builders before save.
	NameValidator func(string) error
	// APIBaseValidator is a validator for the "api_base" field. It is called by the builders before save.
	APIBaseValidator func(string) error
	// DefaultPriority holds the default value on creation for the "priority" field.
	DefaultPriority int
	// DefaultCreatedAt holds the default value on creation for the "created_at" field.
	DefaultCreatedAt func() time.Time
	// DefaultUpdatedAt holds the default value on creation for the "updated_at" field.
	DefaultUpdatedAt func() time.Time
	// UpdateDefaultUpdatedAt holds the default value on update for the "updated_at" field.
	UpdateDefaultUpdatedAt func() time.Time
	// IDValidator is a validator for the "id" field. It is called by the builders before save.
	IDValidator func(string) error
)

// OrderOption defines the ordering options for the ModelProvider queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByName orders the results by the name field.
func ByName(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldName, opts...).ToFunc()
}

// ByAPIBase orders the results by the api_base field.
func ByAPIBase(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldAPIBase, opts...).ToFunc()
}

// ByPriority orders the results by the priority field.
func ByPriority(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldPriority, opts...).ToFunc()
}

// ByCreatedAt orders the results by the created_at field.
func ByCreatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedAt, opts...).ToFunc()
}

// ByUpdatedAt orders the results by the updated_at field.
func ByUpdatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUpdatedAt, opts...).ToFunc()
}

// ByModelsCount orders the results by models count.
func ByModelsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newModelsStep(), opts...)
	}
}

// ByModels orders the results by models terms.
func ByModels(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newModelsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}
func newModelsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(ModelsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, ModelsTable, ModelsColumn),
	)
}
