// Code generated by ent, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/chaitin/MonkeyCode/backend/db/modelprovider"
	"github.com/chaitin/MonkeyCode/backend/db/modelprovidermodel"
	"github.com/google/uuid"
)

// ModelProviderCreate is the builder for creating a ModelProvider entity.
type ModelProviderCreate struct {
	config
	mutation *ModelProviderMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetName sets the "name" field.
func (mpc *ModelProviderCreate) SetName(s string) *ModelProviderCreate {
	mpc.mutation.SetName(s)
	return mpc
}

// SetAPIBase sets the "api_base" field.
func (mpc *ModelProviderCreate) SetAPIBase(s string) *ModelProviderCreate {
	mpc.mutation.SetAPIBase(s)
	return mpc
}

// SetPriority sets the "priority" field.
func (mpc *ModelProviderCreate) SetPriority(i int) *ModelProviderCreate {
	mpc.mutation.SetPriority(i)
	return mpc
}

// SetNillablePriority sets the "priority" field if the given value is not nil.
func (mpc *ModelProviderCreate) SetNillablePriority(i *int) *ModelProviderCreate {
	if i != nil {
		mpc.SetPriority(*i)
	}
	return mpc
}

// SetCreatedAt sets the "created_at" field.
func (mpc *ModelProviderCreate) SetCreatedAt(t time.Time) *ModelProviderCreate {
	mpc.mutation.SetCreatedAt(t)
	return mpc
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (mpc *ModelProviderCreate) SetNillableCreatedAt(t *time.Time) *ModelProviderCreate {
	if t != nil {
		mpc.SetCreatedAt(*t)
	}
	return mpc
}

// SetUpdatedAt sets the "updated_at" field.
func (mpc *ModelProviderCreate) SetUpdatedAt(t time.Time) *ModelProviderCreate {
	mpc.mutation.SetUpdatedAt(t)
	return mpc
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (mpc *ModelProviderCreate) SetNillableUpdatedAt(t *time.Time) *ModelProviderCreate {
	if t != nil {
		mpc.SetUpdatedAt(*t)
	}
	return mpc
}

// SetID sets the "id" field.
func (mpc *ModelProviderCreate) SetID(s string) *ModelProviderCreate {
	mpc.mutation.SetID(s)
	return mpc
}

// AddModelIDs adds the "models" edge to the ModelProviderModel entity by IDs.
func (mpc *ModelProviderCreate) AddModelIDs(ids ...uuid.UUID) *ModelProviderCreate {
	mpc.mutation.AddModelIDs(ids...)
	return mpc
}

// AddModels adds the "models" edges to the ModelProviderModel entity.
func (mpc *ModelProviderCreate) AddModels(m ...*ModelProviderModel) *ModelProviderCreate {
	ids := make([]uuid.UUID, len(m))
	for i := range m {
		ids[i] = m[i].ID
	}
	return mpc.AddModelIDs(ids...)
}

// Mutation returns the ModelProviderMutation object of the builder.
func (mpc *ModelProviderCreate) Mutation() *ModelProviderMutation {
	return mpc.mutation
}

// Save creates the ModelProvider in the database.
func (mpc *ModelProviderCreate) Save(ctx context.Context) (*ModelProvider, error) {
	mpc.defaults()
	return withHooks(ctx, mpc.sqlSave, mpc.mutation, mpc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (mpc *ModelProviderCreate) SaveX(ctx context.Context) *ModelProvider {
	v, err := mpc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (mpc *ModelProviderCreate) Exec(ctx context.Context) error {
	_, err := mpc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mpc *ModelProviderCreate) ExecX(ctx context.Context) {
	if err := mpc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (mpc *ModelProviderCreate) defaults() {
	if _, ok := mpc.mutation.Priority(); !ok {
		v := modelprovider.DefaultPriority
		mpc.mutation.SetPriority(v)
	}
	if _, ok := mpc.mutation.CreatedAt(); !ok {
		v := modelprovider.DefaultCreatedAt()
		mpc.mutation.SetCreatedAt(v)
	}
	if _, ok := mpc.mutation.UpdatedAt(); !ok {
		v := modelprovider.DefaultUpdatedAt()
		mpc.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (mpc *ModelProviderCreate) check() error {
	if _, ok := mpc.mutation.Name(); !ok {
		return &ValidationError{Name: "name", err: errors.New(`db: missing required field "ModelProvider.name"`)}
	}
	if v, ok := mpc.mutation.Name(); ok {
		if err := modelprovider.NameValidator(v); err != nil {
			return &ValidationError{Name: "name", err: fmt.Errorf(`db: validator failed for field "ModelProvider.name": %w`, err)}
		}
	}
	if _, ok := mpc.mutation.APIBase(); !ok {
		return &ValidationError{Name: "api_base", err: errors.New(`db: missing required field "ModelProvider.api_base"`)}
	}
	if v, ok := mpc.mutation.APIBase(); ok {
		if err := modelprovider.APIBaseValidator(v); err != nil {
			return &ValidationError{Name: "api_base", err: fmt.Errorf(`db: validator failed for field "ModelProvider.api_base": %w`, err)}
		}
	}
	if _, ok := mpc.mutation.Priority(); !ok {
		return &ValidationError{Name: "priority", err: errors.New(`db: missing required field "ModelProvider.priority"`)}
	}
	if _, ok := mpc.mutation.CreatedAt(); !ok {
		return &ValidationError{Name: "created_at", err: errors.New(`db: missing required field "ModelProvider.created_at"`)}
	}
	if _, ok := mpc.mutation.UpdatedAt(); !ok {
		return &ValidationError{Name: "updated_at", err: errors.New(`db: missing required field "ModelProvider.updated_at"`)}
	}
	if v, ok := mpc.mutation.ID(); ok {
		if err := modelprovider.IDValidator(v); err != nil {
			return &ValidationError{Name: "id", err: fmt.Errorf(`db: validator failed for field "ModelProvider.id": %w`, err)}
		}
	}
	return nil
}

func (mpc *ModelProviderCreate) sqlSave(ctx context.Context) (*ModelProvider, error) {
	if err := mpc.check(); err != nil {
		return nil, err
	}
	_node, _spec := mpc.createSpec()
	if err := sqlgraph.CreateNode(ctx, mpc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(string); ok {
			_node.ID = id
		} else {
			return nil, fmt.Errorf("unexpected ModelProvider.ID type: %T", _spec.ID.Value)
		}
	}
	mpc.mutation.id = &_node.ID
	mpc.mutation.done = true
	return _node, nil
}

func (mpc *ModelProviderCreate) createSpec() (*ModelProvider, *sqlgraph.CreateSpec) {
	var (
		_node = &ModelProvider{config: mpc.config}
		_spec = sqlgraph.NewCreateSpec(modelprovider.Table, sqlgraph.NewFieldSpec(modelprovider.FieldID, field.TypeString))
	)
	_spec.OnConflict = mpc.conflict
	if id, ok := mpc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = id
	}
	if value, ok := mpc.mutation.Name(); ok {
		_spec.SetField(modelprovider.FieldName, field.TypeString, value)
		_node.Name = value
	}
	if value, ok := mpc.mutation.APIBase(); ok {
		_spec.SetField(modelprovider.FieldAPIBase, field.TypeString, value)
		_node.APIBase = value
	}
	if value, ok := mpc.mutation.Priority(); ok {
		_spec.SetField(modelprovider.FieldPriority, field.TypeInt, value)
		_node.Priority = value
	}
	if value, ok := mpc.mutation.CreatedAt(); ok {
		_spec.SetField(modelprovider.FieldCreatedAt, field.TypeTime, value)
		_node.CreatedAt = value
	}
	if value, ok := mpc.mutation.UpdatedAt(); ok {
		_spec.SetField(modelprovider.FieldUpdatedAt, field.TypeTime, value)
		_node.UpdatedAt = value
	}
	if nodes := mpc.mutation.ModelsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   modelprovider.ModelsTable,
			Columns: []string{modelprovider.ModelsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(modelprovidermodel.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.ModelProvider.Create().
//		SetName(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.ModelProviderUpsert) {
//			SetName(v+v).
//		}).
//		Exec(ctx)
func (mpc *ModelProviderCreate) OnConflict(opts ...sql.ConflictOption) *ModelProviderUpsertOne {
	mpc.conflict = opts
	return &ModelProviderUpsertOne{
		create: mpc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.ModelProvider.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (mpc *ModelProviderCreate) OnConflictColumns(columns ...string) *ModelProviderUpsertOne {
	mpc.conflict = append(mpc.conflict, sql.ConflictColumns(columns...))
	return &ModelProviderUpsertOne{
		create: mpc,
	}
}

type (
	// ModelProviderUpsertOne is the builder for "upsert"-ing
	//  one ModelProvider node.
	ModelProviderUpsertOne struct {
		create *ModelProviderCreate
	}

	// ModelProviderUpsert is the "OnConflict" setter.
	ModelProviderUpsert struct {
		*sql.UpdateSet
	}
)

// SetName sets the "name" field.
func (u *ModelProviderUpsert) SetName(v string) *ModelProviderUpsert {
	u.Set(modelprovider.FieldName, v)
	return u
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *ModelProviderUpsert) UpdateName() *ModelProviderUpsert {
	u.SetExcluded(modelprovider.FieldName)
	return u
}

// SetAPIBase sets the "api_base" field.
func (u *ModelProviderUpsert) SetAPIBase(v string) *ModelProviderUpsert {
	u.Set(modelprovider.FieldAPIBase, v)
	return u
}

// UpdateAPIBase sets the "api_base" field to the value that was provided on create.
func (u *ModelProviderUpsert) UpdateAPIBase() *ModelProviderUpsert {
	u.SetExcluded(modelprovider.FieldAPIBase)
	return u
}

// SetPriority sets the "priority" field.
func (u *ModelProviderUpsert) SetPriority(v int) *ModelProviderUpsert {
	u.Set(modelprovider.FieldPriority, v)
	return u
}

// UpdatePriority sets the "priority" field to the value that was provided on create.
func (u *ModelProviderUpsert) UpdatePriority() *ModelProviderUpsert {
	u.SetExcluded(modelprovider.FieldPriority)
	return u
}

// AddPriority adds v to the "priority" field.
func (u *ModelProviderUpsert) AddPriority(v int) *ModelProviderUpsert {
	u.Add(modelprovider.FieldPriority, v)
	return u
}

// SetCreatedAt sets the "created_at" field.
func (u *ModelProviderUpsert) SetCreatedAt(v time.Time) *ModelProviderUpsert {
	u.Set(modelprovider.FieldCreatedAt, v)
	return u
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *ModelProviderUpsert) UpdateCreatedAt() *ModelProviderUpsert {
	u.SetExcluded(modelprovider.FieldCreatedAt)
	return u
}

// SetUpdatedAt sets the "updated_at" field.
func (u *ModelProviderUpsert) SetUpdatedAt(v time.Time) *ModelProviderUpsert {
	u.Set(modelprovider.FieldUpdatedAt, v)
	return u
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *ModelProviderUpsert) UpdateUpdatedAt() *ModelProviderUpsert {
	u.SetExcluded(modelprovider.FieldUpdatedAt)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create except the ID field.
// Using this option is equivalent to using:
//
//	client.ModelProvider.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(modelprovider.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *ModelProviderUpsertOne) UpdateNewValues() *ModelProviderUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		if _, exists := u.create.mutation.ID(); exists {
			s.SetIgnore(modelprovider.FieldID)
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.ModelProvider.Create().
//	    OnConflict(sql.ResolveWithIgnore()).
//	    Exec(ctx)
func (u *ModelProviderUpsertOne) Ignore() *ModelProviderUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *ModelProviderUpsertOne) DoNothing() *ModelProviderUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the ModelProviderCreate.OnConflict
// documentation for more info.
func (u *ModelProviderUpsertOne) Update(set func(*ModelProviderUpsert)) *ModelProviderUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&ModelProviderUpsert{UpdateSet: update})
	}))
	return u
}

// SetName sets the "name" field.
func (u *ModelProviderUpsertOne) SetName(v string) *ModelProviderUpsertOne {
	return u.Update(func(s *ModelProviderUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *ModelProviderUpsertOne) UpdateName() *ModelProviderUpsertOne {
	return u.Update(func(s *ModelProviderUpsert) {
		s.UpdateName()
	})
}

// SetAPIBase sets the "api_base" field.
func (u *ModelProviderUpsertOne) SetAPIBase(v string) *ModelProviderUpsertOne {
	return u.Update(func(s *ModelProviderUpsert) {
		s.SetAPIBase(v)
	})
}

// UpdateAPIBase sets the "api_base" field to the value that was provided on create.
func (u *ModelProviderUpsertOne) UpdateAPIBase() *ModelProviderUpsertOne {
	return u.Update(func(s *ModelProviderUpsert) {
		s.UpdateAPIBase()
	})
}

// SetPriority sets the "priority" field.
func (u *ModelProviderUpsertOne) SetPriority(v int) *ModelProviderUpsertOne {
	return u.Update(func(s *ModelProviderUpsert) {
		s.SetPriority(v)
	})
}

// AddPriority adds v to the "priority" field.
func (u *ModelProviderUpsertOne) AddPriority(v int) *ModelProviderUpsertOne {
	return u.Update(func(s *ModelProviderUpsert) {
		s.AddPriority(v)
	})
}

// UpdatePriority sets the "priority" field to the value that was provided on create.
func (u *ModelProviderUpsertOne) UpdatePriority() *ModelProviderUpsertOne {
	return u.Update(func(s *ModelProviderUpsert) {
		s.UpdatePriority()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *ModelProviderUpsertOne) SetCreatedAt(v time.Time) *ModelProviderUpsertOne {
	return u.Update(func(s *ModelProviderUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *ModelProviderUpsertOne) UpdateCreatedAt() *ModelProviderUpsertOne {
	return u.Update(func(s *ModelProviderUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *ModelProviderUpsertOne) SetUpdatedAt(v time.Time) *ModelProviderUpsertOne {
	return u.Update(func(s *ModelProviderUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *ModelProviderUpsertOne) UpdateUpdatedAt() *ModelProviderUpsertOne {
	return u.Update(func(s *ModelProviderUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *ModelProviderUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for ModelProviderCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *ModelProviderUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *ModelProviderUpsertOne) ID(ctx context.Context) (id string, err error) {
	if u.create.driver.Dialect() == dialect.MySQL {
		// In case of "ON CONFLICT", there is no way to get back non-numeric ID
		// fields from the database since MySQL does not support the RETURNING clause.
		return id, errors.New("db: ModelProviderUpsertOne.ID is not supported by MySQL driver. Use ModelProviderUpsertOne.Exec instead")
	}
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *ModelProviderUpsertOne) IDX(ctx context.Context) string {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// ModelProviderCreateBulk is the builder for creating many ModelProvider entities in bulk.
type ModelProviderCreateBulk struct {
	config
	err      error
	builders []*ModelProviderCreate
	conflict []sql.ConflictOption
}

// Save creates the ModelProvider entities in the database.
func (mpcb *ModelProviderCreateBulk) Save(ctx context.Context) ([]*ModelProvider, error) {
	if mpcb.err != nil {
		return nil, mpcb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(mpcb.builders))
	nodes := make([]*ModelProvider, len(mpcb.builders))
	mutators := make([]Mutator, len(mpcb.builders))
	for i := range mpcb.builders {
		func(i int, root context.Context) {
			builder := mpcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*ModelProviderMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, mpcb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = mpcb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, mpcb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, mpcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (mpcb *ModelProviderCreateBulk) SaveX(ctx context.Context) []*ModelProvider {
	v, err := mpcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (mpcb *ModelProviderCreateBulk) Exec(ctx context.Context) error {
	_, err := mpcb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mpcb *ModelProviderCreateBulk) ExecX(ctx context.Context) {
	if err := mpcb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.ModelProvider.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.ModelProviderUpsert) {
//			SetName(v+v).
//		}).
//		Exec(ctx)
func (mpcb *ModelProviderCreateBulk) OnConflict(opts ...sql.ConflictOption) *ModelProviderUpsertBulk {
	mpcb.conflict = opts
	return &ModelProviderUpsertBulk{
		create: mpcb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.ModelProvider.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
func (mpcb *ModelProviderCreateBulk) OnConflictColumns(columns ...string) *ModelProviderUpsertBulk {
	mpcb.conflict = append(mpcb.conflict, sql.ConflictColumns(columns...))
	return &ModelProviderUpsertBulk{
		create: mpcb,
	}
}

// ModelProviderUpsertBulk is the builder for "upsert"-ing
// a bulk of ModelProvider nodes.
type ModelProviderUpsertBulk struct {
	create *ModelProviderCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.ModelProvider.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//			sql.ResolveWith(func(u *sql.UpdateSet) {
//				u.SetIgnore(modelprovider.FieldID)
//			}),
//		).
//		Exec(ctx)
func (u *ModelProviderUpsertBulk) UpdateNewValues() *ModelProviderUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(s *sql.UpdateSet) {
		for _, b := range u.create.builders {
			if _, exists := b.mutation.ID(); exists {
				s.SetIgnore(modelprovider.FieldID)
			}
		}
	}))
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.ModelProvider.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
func (u *ModelProviderUpsertBulk) Ignore() *ModelProviderUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *ModelProviderUpsertBulk) DoNothing() *ModelProviderUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the ModelProviderCreateBulk.OnConflict
// documentation for more info.
func (u *ModelProviderUpsertBulk) Update(set func(*ModelProviderUpsert)) *ModelProviderUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&ModelProviderUpsert{UpdateSet: update})
	}))
	return u
}

// SetName sets the "name" field.
func (u *ModelProviderUpsertBulk) SetName(v string) *ModelProviderUpsertBulk {
	return u.Update(func(s *ModelProviderUpsert) {
		s.SetName(v)
	})
}

// UpdateName sets the "name" field to the value that was provided on create.
func (u *ModelProviderUpsertBulk) UpdateName() *ModelProviderUpsertBulk {
	return u.Update(func(s *ModelProviderUpsert) {
		s.UpdateName()
	})
}

// SetAPIBase sets the "api_base" field.
func (u *ModelProviderUpsertBulk) SetAPIBase(v string) *ModelProviderUpsertBulk {
	return u.Update(func(s *ModelProviderUpsert) {
		s.SetAPIBase(v)
	})
}

// UpdateAPIBase sets the "api_base" field to the value that was provided on create.
func (u *ModelProviderUpsertBulk) UpdateAPIBase() *ModelProviderUpsertBulk {
	return u.Update(func(s *ModelProviderUpsert) {
		s.UpdateAPIBase()
	})
}

// SetPriority sets the "priority" field.
func (u *ModelProviderUpsertBulk) SetPriority(v int) *ModelProviderUpsertBulk {
	return u.Update(func(s *ModelProviderUpsert) {
		s.SetPriority(v)
	})
}

// AddPriority adds v to the "priority" field.
func (u *ModelProviderUpsertBulk) AddPriority(v int) *ModelProviderUpsertBulk {
	return u.Update(func(s *ModelProviderUpsert) {
		s.AddPriority(v)
	})
}

// UpdatePriority sets the "priority" field to the value that was provided on create.
func (u *ModelProviderUpsertBulk) UpdatePriority() *ModelProviderUpsertBulk {
	return u.Update(func(s *ModelProviderUpsert) {
		s.UpdatePriority()
	})
}

// SetCreatedAt sets the "created_at" field.
func (u *ModelProviderUpsertBulk) SetCreatedAt(v time.Time) *ModelProviderUpsertBulk {
	return u.Update(func(s *ModelProviderUpsert) {
		s.SetCreatedAt(v)
	})
}

// UpdateCreatedAt sets the "created_at" field to the value that was provided on create.
func (u *ModelProviderUpsertBulk) UpdateCreatedAt() *ModelProviderUpsertBulk {
	return u.Update(func(s *ModelProviderUpsert) {
		s.UpdateCreatedAt()
	})
}

// SetUpdatedAt sets the "updated_at" field.
func (u *ModelProviderUpsertBulk) SetUpdatedAt(v time.Time) *ModelProviderUpsertBulk {
	return u.Update(func(s *ModelProviderUpsert) {
		s.SetUpdatedAt(v)
	})
}

// UpdateUpdatedAt sets the "updated_at" field to the value that was provided on create.
func (u *ModelProviderUpsertBulk) UpdateUpdatedAt() *ModelProviderUpsertBulk {
	return u.Update(func(s *ModelProviderUpsert) {
		s.UpdateUpdatedAt()
	})
}

// Exec executes the query.
func (u *ModelProviderUpsertBulk) Exec(ctx context.Context) error {
	if u.create.err != nil {
		return u.create.err
	}
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("db: OnConflict was set for builder %d. Set it on the ModelProviderCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("db: missing options for ModelProviderCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *ModelProviderUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
